/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import java.math.BigDecimal;

final class Converter {
    private Converter() {
    }

    static double toNumber(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static double toNumber(NodeIterator iter) throws XSLException {
        return Converter.toNumber(Converter.toString(iter));
    }

    static double toNumber(boolean b) {
        return b ? 1.0 : 0.0;
    }

    static boolean toBoolean(String str) {
        return str.length() != 0;
    }

    static boolean toBoolean(double num) {
        return num != 0.0 && num == num;
    }

    static boolean toBoolean(NodeIterator iter) throws XSLException {
        return iter.next() != null;
    }

    static String toString(NodeIterator iter) throws XSLException {
        return Converter.toString(iter.next());
    }

    static String toString(Node node) throws XSLException {
        if (node == null) {
            return "";
        }
        String value = node.getData();
        if (value != null) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        Converter.addContent(node, buf);
        return buf.toString();
    }

    private static void addContent(Node node, StringBuffer result) throws XSLException {
        switch (node.getType()) {
            case 1: {
                result.append(node.getData());
                break;
            }
            case 0: 
            case 3: {
                SafeNodeIterator iter = node.getChildren();
                while ((node = iter.next()) != null) {
                    Converter.addContent(node, result);
                }
                break;
            }
        }
    }

    static String toString(double num) {
        String sign;
        int len;
        if (!Double.isInfinite(num) && (num >= 9.007199254740992E15 || -num >= 9.007199254740992E15)) {
            return new BigDecimal(num).toString();
        }
        String s = Double.toString(num);
        if (s.charAt((len = s.length()) - 2) == '.' && s.charAt(len - 1) == '0') {
            if ((s = s.substring(0, len - 2)).equals("-0")) {
                return "0";
            }
            return s;
        }
        int e = s.indexOf(69);
        if (e < 0) {
            return s;
        }
        int exp = Integer.parseInt(s.substring(e + 1));
        if (s.charAt(0) == '-') {
            sign = "-";
            s = s.substring(1);
            --e;
        } else {
            sign = "";
        }
        int nDigits = e - 2;
        if (exp >= nDigits) {
            return sign + s.substring(0, 1) + s.substring(2, e) + Converter.zeros(exp - nDigits);
        }
        if (exp > 0) {
            return sign + s.substring(0, 1) + s.substring(2, 2 + exp) + "." + s.substring(2 + exp, e);
        }
        return sign + "0." + Converter.zeros(-1 - exp) + s.substring(0, 1) + s.substring(2, e);
    }

    private static String zeros(int n) {
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = 48;
        }
        return new String(buf);
    }

    static String toString(boolean b) {
        return b ? "true" : "false";
    }

    static boolean positionToBoolean(double d, ExprContext context) throws XSLException {
        return (double)context.getPosition() == d;
    }
}

