/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.dom.SiblingNodeIterator;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import java.net.URL;

abstract class NodeBase
implements Node {
    final org.w3c.dom.Node domNode;
    int level;
    private int childIndex;
    ContainerNode parent;
    RootNode root;

    NodeBase(org.w3c.dom.Node domNode) {
        this.domNode = domNode;
        this.childIndex = 0;
        this.level = 0;
    }

    NodeBase(org.w3c.dom.Node domNode, ContainerNode parent, int childIndex) {
        this.domNode = domNode;
        this.parent = parent;
        this.root = parent.root;
        this.childIndex = childIndex;
        this.level = parent.level + 1;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getGeneratedId() {
        return this.parent.getGeneratedId() + "." + Integer.toString(this.childIndex);
    }

    public int compareTo(Node node) {
        NodeBase other = (NodeBase)node;
        if (this.root == other.root) {
            return NodeBase.compare(this, other);
        }
        return this.root.compareRootTo(other.root);
    }

    private static final int compare(NodeBase node1, NodeBase node2) {
        int level1;
        int level2 = node2.level;
        int levelDiff = level1 - level2;
        for (level1 = node1.level; level1 > level2; --level1) {
            node1 = node1.parent;
        }
        while (level2 > level1) {
            node2 = node2.parent;
            --level2;
        }
        int ret = NodeBase.compareSameLevel(node1, node2);
        if (ret != 0) {
            return ret;
        }
        return levelDiff;
    }

    private static final int compareSameLevel(NodeBase node1, NodeBase node2) {
        if (node1.level == 0) {
            return 0;
        }
        if (node1.domNode.equals(node2.domNode)) {
            return 0;
        }
        int ret = NodeBase.compareSameLevel(node1.parent, node2.parent);
        if (ret != 0) {
            return ret;
        }
        return node1.childIndex - node2.childIndex;
    }

    public String getData() {
        return null;
    }

    public Name getName() {
        return null;
    }

    public String getAttributeValue(Name name) {
        return null;
    }

    public Node getAttribute(Name name) {
        return null;
    }

    public Node getElementWithId(String id) {
        return this.root.getElementWithId(id);
    }

    public boolean isId(String id) {
        return this.root.isId(this.domNode, id);
    }

    public NamespacePrefixMap getNamespacePrefixMap() {
        return this.parent.getNamespacePrefixMap();
    }

    public String getUnparsedEntityURI(String name) {
        return this.root.getUnparsedEntityURI(name);
    }

    public SafeNodeIterator getChildren() {
        return NullNodeIterator.getInstance();
    }

    public SafeNodeIterator getAttributes() {
        return NullNodeIterator.getInstance();
    }

    public SafeNodeIterator getNamespaces() {
        return NullNodeIterator.getInstance();
    }

    public URL getURL() {
        return this.root.getURL();
    }

    public String getSystemId() {
        return this.getURL().toString();
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public SafeNodeIterator getFollowingSiblings() {
        SiblingNodeIterator iter = new SiblingNodeIterator(this.parent, this.childIndex, this.domNode);
        iter.next();
        return iter;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeBase)) {
            return false;
        }
        return ((NodeBase)obj).domNode.equals(this.domNode);
    }

    public Node getRoot() {
        return this.root;
    }
}

