package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ElementTest extends PathPatternBase {
  private final Name name;

  ElementTest(Name name) {
    this.name = name;
  }

  public boolean matches(Node node, ExprContext context) {
    return (name.equals(node.getName())
	    && node.getType() == Node.ELEMENT);
  }

  Name getMatchName() { return name; }
  byte getMatchNodeType() { return Node.ELEMENT; }
  public int getDefaultPriority() { return 0; }
}
