/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.AddExpr;
import com.jclark.xsl.expr.AlternativesPattern;
import com.jclark.xsl.expr.AncestorAxisExpr;
import com.jclark.xsl.expr.AncestorOrSelfAxisExpr;
import com.jclark.xsl.expr.AndExpr;
import com.jclark.xsl.expr.AppendExpr;
import com.jclark.xsl.expr.AttributeAxisExpr;
import com.jclark.xsl.expr.AttributeTest;
import com.jclark.xsl.expr.AxisExpr;
import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.BooleanFunction;
import com.jclark.xsl.expr.BooleanRelationalExpr;
import com.jclark.xsl.expr.CeilingFunction;
import com.jclark.xsl.expr.ChildAxisExpr;
import com.jclark.xsl.expr.ConcatFunction;
import com.jclark.xsl.expr.ContainsFunction;
import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.CountFunction;
import com.jclark.xsl.expr.CurrentFunction;
import com.jclark.xsl.expr.DescendantAxisExpr;
import com.jclark.xsl.expr.DescendantOrSelfAxisExpr;
import com.jclark.xsl.expr.DifferenceFunction;
import com.jclark.xsl.expr.DivideExpr;
import com.jclark.xsl.expr.DocumentFunction;
import com.jclark.xsl.expr.ElementTest;
import com.jclark.xsl.expr.EmptyVariableSet;
import com.jclark.xsl.expr.EqualsRelation;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.ExprTokenizer;
import com.jclark.xsl.expr.ExtensionFunctionCallExpr;
import com.jclark.xsl.expr.FalseFunction;
import com.jclark.xsl.expr.FilterExpr;
import com.jclark.xsl.expr.FilterPattern;
import com.jclark.xsl.expr.FloorFunction;
import com.jclark.xsl.expr.FollowingAxisExpr;
import com.jclark.xsl.expr.FollowingSiblingAxisExpr;
import com.jclark.xsl.expr.FormatNumberFunction;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.FunctionAvailableFunction;
import com.jclark.xsl.expr.GenerateIdFunction;
import com.jclark.xsl.expr.GlobalVariableRefExpr;
import com.jclark.xsl.expr.GreaterThanEqualsRelation;
import com.jclark.xsl.expr.GreaterThanRelation;
import com.jclark.xsl.expr.IdFunction;
import com.jclark.xsl.expr.IdPattern;
import com.jclark.xsl.expr.InheritPattern;
import com.jclark.xsl.expr.IntersectionFunction;
import com.jclark.xsl.expr.LangFunction;
import com.jclark.xsl.expr.LastFunction;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.LocalNameFunction;
import com.jclark.xsl.expr.LocalVariableRefExpr;
import com.jclark.xsl.expr.ModuloExpr;
import com.jclark.xsl.expr.MultiplyExpr;
import com.jclark.xsl.expr.NameFunction;
import com.jclark.xsl.expr.NamespaceAttributeTest;
import com.jclark.xsl.expr.NamespaceElementTest;
import com.jclark.xsl.expr.NamespaceUriFunction;
import com.jclark.xsl.expr.NegateExpr;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NodeSetFunction;
import com.jclark.xsl.expr.NodeTestExpr;
import com.jclark.xsl.expr.NodeTypeTest;
import com.jclark.xsl.expr.NormalizeSpaceFunction;
import com.jclark.xsl.expr.NotEqualsRelation;
import com.jclark.xsl.expr.NotFunction;
import com.jclark.xsl.expr.NumberConstantExpr;
import com.jclark.xsl.expr.NumberExpr;
import com.jclark.xsl.expr.NumberFunction;
import com.jclark.xsl.expr.NumberRelationalExpr;
import com.jclark.xsl.expr.NumericRelation;
import com.jclark.xsl.expr.OrExpr;
import com.jclark.xsl.expr.ParentAxisExpr;
import com.jclark.xsl.expr.ParentPattern;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.expr.PathPatternBase;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.expr.PositionFunction;
import com.jclark.xsl.expr.PrecedingAxisExpr;
import com.jclark.xsl.expr.PrecedingSiblingAxisExpr;
import com.jclark.xsl.expr.ProcessingInstructionTest;
import com.jclark.xsl.expr.Relation;
import com.jclark.xsl.expr.RootExpr;
import com.jclark.xsl.expr.RoundFunction;
import com.jclark.xsl.expr.SelfAxisExpr;
import com.jclark.xsl.expr.StartsWithFunction;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.expr.StringFunction;
import com.jclark.xsl.expr.StringLengthFunction;
import com.jclark.xsl.expr.StringRelationalExpr;
import com.jclark.xsl.expr.SubstringAfterFunction;
import com.jclark.xsl.expr.SubstringBeforeFunction;
import com.jclark.xsl.expr.SubstringFunction;
import com.jclark.xsl.expr.SubtractExpr;
import com.jclark.xsl.expr.SumFunction;
import com.jclark.xsl.expr.SystemPropertyFunction;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.expr.TranslateFunction;
import com.jclark.xsl.expr.TrueFunction;
import com.jclark.xsl.expr.UnionExpr;
import com.jclark.xsl.expr.UnparsedEntityURIFunction;
import com.jclark.xsl.expr.VariableSet;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.expr.VariantRelationalExpr;
import com.jclark.xsl.expr.WithCurrentExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespaceConstants;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.Hashtable;

public class ExprParser
extends ExprTokenizer
implements NamespaceConstants {
    private NamespacePrefixMap prefixMap;
    private Node node;
    private VariableSet locals;
    private boolean usesCurrentFunction = false;
    private static final Hashtable axisTable = new Hashtable();
    private static final AxisExpr childAxis = new ChildAxisExpr();
    private static final AxisExpr parentAxis = new ParentAxisExpr();
    private static final AxisExpr selfAxis = new SelfAxisExpr();
    private static final AxisExpr attributeAxis = new AttributeAxisExpr();
    private static final AxisExpr descendantOrSelfAxis = new DescendantOrSelfAxisExpr();
    private static final Hashtable functionTable = new Hashtable();
    private static final Hashtable extensionFunctionTable = new Hashtable();
    private static final Relation equalsRelation = new EqualsRelation();
    private static final Relation notEqualsRelation = new NotEqualsRelation();
    private static final Relation greaterThanEqualsRelation = new GreaterThanEqualsRelation();
    private static final Relation greaterThanRelation = new GreaterThanRelation();
    private static final Function currentFunction = new CurrentFunction();

    public static VariantExpr parseVariantExpr(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, string, variableSet).makeVariantExpr();
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    private static ConvertibleExpr parseConvertibleExpr(Node node, String string, VariableSet variableSet) throws ParseException {
        return new ExprParser(string, node, variableSet).parseExpr();
    }

    ConvertibleExpr[] parseArgs() throws ParseException {
        if (this.currentToken == 13) {
            this.next();
            return new ConvertibleExpr[0];
        }
        ConvertibleExpr[] convertibleExprArray = new ConvertibleExpr[1];
        while (true) {
            convertibleExprArray[convertibleExprArray.length - 1] = this.parseOrExpr();
            if (this.currentToken != 25) break;
            this.next();
            ConvertibleExpr[] convertibleExprArray2 = convertibleExprArray;
            convertibleExprArray = new ConvertibleExpr[convertibleExprArray2.length + 1];
            System.arraycopy(convertibleExprArray2, 0, convertibleExprArray, 0, convertibleExprArray2.length);
        }
        this.expectRpar();
        return convertibleExprArray;
    }

    private ConvertibleExpr parseAndExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseEqualityExpr();
        while (this.currentToken == 34) {
            this.next();
            convertibleExpr = new AndExpr(convertibleExpr.makeBooleanExpr(), this.parseEqualityExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private static XSLException makeXSLException(ParseException parseException, Node node) {
        return new XSLException(parseException.getMessage(), node);
    }

    private PathPatternBase parsePathPattern() throws ParseException {
        PathPatternBase pathPatternBase;
        Pattern pattern = null;
        switch (this.currentToken) {
            case 23: {
                this.next();
                break;
            }
            case 22: {
                this.next();
                if (!this.tokenStartsStep()) {
                    return new NodeTypeTest(3);
                }
                pattern = new NodeTypeTest(3);
                break;
            }
            case 19: {
                if (this.currentTokenValue.equals("id")) {
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("expected literal");
                    }
                    pathPatternBase = new IdPattern(this.currentTokenValue);
                    this.next();
                    this.expectRpar();
                    if (this.currentToken == 22) {
                        pattern = pathPatternBase;
                    } else if (this.currentToken == 23) {
                        pattern = new InheritPattern(pathPatternBase);
                    } else {
                        return pathPatternBase;
                    }
                    this.next();
                    break;
                }
                throw new ParseException("function illegal in pattern");
            }
        }
        while (true) {
            pathPatternBase = this.parseStepPattern();
            if (pattern != null) {
                pathPatternBase = new ParentPattern(pathPatternBase, pattern);
            }
            if (this.currentToken == 22) {
                pattern = pathPatternBase;
            } else if (this.currentToken == 23) {
                pattern = new InheritPattern(pathPatternBase);
            } else {
                return pathPatternBase;
            }
            this.next();
        }
    }

    private static int findExprEnd(String string, int n) {
        int n2 = string.length();
        char c = '\u0000';
        while (n < n2) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '}': {
                    if (c != '\u0000') break;
                    return n;
                }
                case '\"': 
                case '\'': {
                    if (c == c2) {
                        c = '\u0000';
                        break;
                    }
                    if (c != '\u0000') break;
                    c = c2;
                }
            }
            ++n;
        }
        return -1;
    }

    private TopLevelPattern parseTopLevelPattern(Node node) throws XSLException {
        try {
            this.next();
            TopLevelPattern topLevelPattern = this.parsePathPattern();
            while (this.currentToken == 24) {
                this.next();
                topLevelPattern = new AlternativesPattern(topLevelPattern, this.parsePathPattern());
            }
            if (this.currentToken != 0) {
                throw new ParseException("unexpected token");
            }
            if (this.usesCurrentFunction) {
                throw new ParseException("current() in match pattern");
            }
            return topLevelPattern;
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    private Name expandName() throws ParseException {
        try {
            if (this.prefixMap != null) {
                return this.prefixMap.expandAttributeName(this.currentTokenValue, null);
            }
            return null;
        }
        catch (XSLException xSLException) {
            throw new ParseException("undefined prefix");
        }
    }

    private PathPatternBase parseNodeTest(boolean bl) throws ParseException {
        PathPatternBase pathPatternBase;
        switch (this.currentToken) {
            case 1: {
                if (bl) {
                    pathPatternBase = new AttributeTest(this.expandName());
                    break;
                }
                pathPatternBase = new ElementTest(this.expandName());
                break;
            }
            case 2: {
                pathPatternBase = bl ? null : new NodeTypeTest(0);
                break;
            }
            case 3: {
                if (bl) {
                    pathPatternBase = new NamespaceAttributeTest(this.expandPrefix());
                    break;
                }
                pathPatternBase = new NamespaceElementTest(this.expandPrefix());
                break;
            }
            case 8: {
                PathPatternBase pathPatternBase2;
                this.next();
                if (this.currentToken == 16) {
                    pathPatternBase2 = new ProcessingInstructionTest(this.expandName());
                    this.next();
                } else {
                    pathPatternBase2 = new NodeTypeTest(4);
                }
                this.expectRpar();
                return pathPatternBase2;
            }
            case 7: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(5);
            }
            case 9: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(1);
            }
            case 10: {
                this.next();
                this.expectRpar();
                return null;
            }
            default: {
                throw new ParseException("expected node test");
            }
        }
        this.next();
        return pathPatternBase;
    }

    private ConvertibleNodeSetExpr parseStep() throws ParseException {
        switch (this.currentToken) {
            case 18: {
                AxisExpr axisExpr = (AxisExpr)axisTable.get(this.currentTokenValue);
                if (axisExpr == null) {
                    throw new ParseException("no such axis");
                }
                boolean bl = this.currentTokenValue.equals("attribute");
                this.next();
                return this.parsePredicates(axisExpr, this.parseNodeTest(bl));
            }
            case 5: {
                this.next();
                return selfAxis;
            }
            case 6: {
                this.next();
                return parentAxis;
            }
            case 4: {
                this.next();
                return this.parsePredicates(attributeAxis, this.parseNodeTest(true));
            }
        }
        return this.parsePredicates(childAxis, this.parseNodeTest(false));
    }

    public static StringExpr parseAttributeValueTemplate(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            ConvertibleStringExpr convertibleStringExpr = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '{': {
                        if (n2 + 1 < n && string.charAt(n2 + 1) == '{') {
                            ++n2;
                            stringBuffer.append('{');
                            break;
                        }
                        int n3 = ExprParser.findExprEnd(string, n2 + 1);
                        if (n3 < 0) {
                            throw new XSLException("missing }", node);
                        }
                        ConvertibleStringExpr convertibleStringExpr2 = ExprParser.parseConvertibleExpr(node, string.substring(n2 + 1, n3), variableSet).makeStringExpr();
                        if (stringBuffer.length() > 0) {
                            convertibleStringExpr = convertibleStringExpr == null ? new LiteralExpr(stringBuffer.toString()) : new AppendExpr(convertibleStringExpr, new LiteralExpr(stringBuffer.toString()));
                            stringBuffer.setLength(0);
                        }
                        convertibleStringExpr = convertibleStringExpr == null ? convertibleStringExpr2 : new AppendExpr(convertibleStringExpr, convertibleStringExpr2);
                        n2 = n3;
                        break;
                    }
                    case '}': {
                        stringBuffer.append('}');
                        if (n2 + 1 >= n || string.charAt(n2 + 1) != '}') break;
                        ++n2;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            if (stringBuffer.length() > 0) {
                if (convertibleStringExpr == null) {
                    return new LiteralExpr(stringBuffer.toString());
                }
                return new AppendExpr(convertibleStringExpr, new LiteralExpr(stringBuffer.toString()));
            }
            if (convertibleStringExpr != null) {
                return convertibleStringExpr;
            }
            return new LiteralExpr("");
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    public static NumberExpr parseNumberExpr(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, string, variableSet).makeNumberExpr();
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    private ConvertibleExpr parseExpr() throws ParseException {
        this.next();
        ConvertibleExpr convertibleExpr = this.parseOrExpr();
        if (this.currentToken != 0) {
            throw new ParseException("unexpected token");
        }
        if (this.usesCurrentFunction) {
            return new WithCurrentExpr(convertibleExpr);
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseUnionExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parsePathExpr();
        while (this.currentToken == 24) {
            this.next();
            convertibleExpr = new UnionExpr(convertibleExpr.makeNodeSetExpr(), this.parsePathExpr().makeNodeSetExpr());
        }
        return convertibleExpr;
    }

    ConvertibleExpr makeRelationalExpr(Relation relation, ConvertibleExpr convertibleExpr, ConvertibleExpr convertibleExpr2) throws ParseException {
        if (convertibleExpr instanceof NodeSetExpr || convertibleExpr2 instanceof NodeSetExpr || convertibleExpr instanceof VariantExpr || convertibleExpr2 instanceof VariantExpr) {
            return new VariantRelationalExpr(relation, convertibleExpr.makeVariantExpr(), convertibleExpr2.makeVariantExpr());
        }
        if (relation instanceof NumericRelation) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        if (convertibleExpr instanceof BooleanExpr || convertibleExpr2 instanceof BooleanExpr) {
            return new BooleanRelationalExpr(relation, convertibleExpr.makeBooleanExpr(), convertibleExpr2.makeBooleanExpr());
        }
        if (convertibleExpr instanceof NumberExpr || convertibleExpr2 instanceof NumberExpr) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        return new StringRelationalExpr(relation, convertibleExpr.makeStringExpr(), convertibleExpr2.makeStringExpr());
    }

    static boolean functionAvailable(Name name, ExprContext exprContext) throws XSLException {
        String string = name.getNamespace();
        if (string == null) {
            return functionTable.get(name.getLocalPart()) != null;
        }
        if (string.equals("http://www.jclark.com/xt") && extensionFunctionTable.get(name.getLocalPart()) != null) {
            return true;
        }
        return exprContext.getExtensionContext(string).available(name.getLocalPart());
    }

    private final void expectRpar() throws ParseException {
        if (this.currentToken != 13) {
            throw new ParseException("expected )");
        }
        this.next();
    }

    private ExprParser(String string, Node node, VariableSet variableSet) {
        super(string);
        this.node = node;
        if (node != null) {
            this.prefixMap = node.getNamespacePrefixMap();
        }
        this.locals = variableSet;
    }

    public static NodeSetExpr parseNodeSetExpr(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, string, variableSet).makeNodeSetExpr();
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    private ConvertibleExpr parseAdditiveExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 26: {
                    this.next();
                    convertibleExpr = new AddExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
                case 27: {
                    this.next();
                    convertibleExpr = new SubtractExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parsePrimaryExpr() throws ParseException {
        ConvertibleExpr convertibleExpr;
        switch (this.currentToken) {
            case 21: {
                Name name = this.expandName();
                if (this.locals.contains(name)) {
                    convertibleExpr = new LocalVariableRefExpr(name);
                    break;
                }
                convertibleExpr = new GlobalVariableRefExpr(name, this.node);
                break;
            }
            case 12: {
                this.next();
                ConvertibleExpr convertibleExpr2 = this.parseOrExpr();
                this.expectRpar();
                return convertibleExpr2;
            }
            case 16: {
                convertibleExpr = new LiteralExpr(this.currentTokenValue);
                break;
            }
            case 17: {
                convertibleExpr = new NumberConstantExpr(Converter.toNumber(this.currentTokenValue));
                break;
            }
            case 19: {
                Function function = (Function)functionTable.get(this.currentTokenValue);
                if (function == null) {
                    if (!this.currentTokenValue.equals("current")) {
                        throw new ParseException("no such function: " + this.currentTokenValue);
                    }
                    this.usesCurrentFunction = true;
                    function = currentFunction;
                }
                this.next();
                return function.makeCallExpr(this.parseArgs(), this.node);
            }
            case 20: {
                Object object;
                Name name = this.expandName();
                this.next();
                if ("http://www.jclark.com/xt".equals(name.getNamespace()) && (object = (Function)extensionFunctionTable.get(name.getLocalPart())) != null) {
                    return object.makeCallExpr(this.parseArgs(), this.node);
                }
                object = this.parseArgs();
                VariantExpr[] variantExprArray = new VariantExpr[((ConvertibleExpr[])object).length];
                int n = 0;
                while (n < ((ConvertibleExpr[])object).length) {
                    variantExprArray[n] = ((ConvertibleExpr)object[n]).makeVariantExpr();
                    ++n;
                }
                return new ExtensionFunctionCallExpr(name, variantExprArray);
            }
            default: {
                throw new ParseException("syntax error");
            }
        }
        this.next();
        return convertibleExpr;
    }

    private String expandPrefix() throws ParseException {
        if (this.prefixMap == null) {
            return null;
        }
        String string = this.prefixMap.getNamespace(this.currentTokenValue);
        if (string == null) {
            throw new ParseException("undefined prefix");
        }
        return string;
    }

    public static NodeSetExpr getChildrenExpr() {
        return new ChildAxisExpr();
    }

    public static TopLevelPattern parsePattern(Node node, String string) throws XSLException {
        return new ExprParser(string, node, new EmptyVariableSet()).parseTopLevelPattern(node);
    }

    public static TopLevelPattern parsePattern(Node node, String string, VariableSet variableSet) throws XSLException {
        return new ExprParser(string, node, variableSet).parseTopLevelPattern(node);
    }

    /*
     * Unable to fully structure code
     */
    private PathPatternBase parseStepPattern() throws ParseException {
        block3: {
            if (this.currentToken != 4 && (this.currentToken != 18 || !this.currentTokenValue.equals("attribute"))) break block3;
            this.next();
            var1_1 = this.parseNodeTest(true);
            if (var1_1 == null) {
                var1_1 = new NodeTypeTest(2);
            }
            ** GOTO lbl15
        }
        if (this.currentToken == 18 && this.currentTokenValue.equals("child")) {
            this.next();
        }
        if ((var1_1 = this.parseNodeTest(false)) != null) ** GOTO lbl15
        throw new ParseException("node() in step pattern not implemented");
lbl-1000:
        // 1 sources

        {
            this.next();
            var1_1 = new FilterPattern(var1_1, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
lbl15:
            // 3 sources

            ** while (this.currentToken == 14)
        }
lbl16:
        // 1 sources

        return var1_1;
    }

    private ConvertibleNodeSetExpr parsePredicates(AxisExpr axisExpr, Pattern pattern) throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = axisExpr;
        if (pattern != null) {
            convertibleNodeSetExpr = new NodeTestExpr(convertibleNodeSetExpr, pattern);
        }
        while (this.currentToken == 14) {
            this.next();
            convertibleNodeSetExpr = new FilterExpr(convertibleNodeSetExpr, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return axisExpr.makeDocumentOrderExpr(convertibleNodeSetExpr);
    }

    private boolean tokenStartsNodeTest() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private final void expectRsqb() throws ParseException {
        if (this.currentToken != 15) {
            throw new ParseException("expected ]");
        }
        this.next();
    }

    private boolean tokenStartsStep() {
        switch (this.currentToken) {
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                return true;
            }
        }
        return this.tokenStartsNodeTest();
    }

    private ConvertibleNodeSetExpr parseRelativeLocationPath() throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = this.parseStep();
        if (this.currentToken == 22) {
            this.next();
            return convertibleNodeSetExpr.compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleNodeSetExpr.compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleNodeSetExpr;
    }

    static {
        axisTable.put("child", childAxis);
        axisTable.put("parent", parentAxis);
        axisTable.put("self", selfAxis);
        axisTable.put("attribute", attributeAxis);
        axisTable.put("descendant-or-self", descendantOrSelfAxis);
        axisTable.put("descendant", new DescendantAxisExpr());
        axisTable.put("ancestor-or-self", new AncestorOrSelfAxisExpr());
        axisTable.put("ancestor", new AncestorAxisExpr());
        axisTable.put("following-sibling", new FollowingSiblingAxisExpr());
        axisTable.put("preceding-sibling", new PrecedingSiblingAxisExpr());
        axisTable.put("following", new FollowingAxisExpr());
        axisTable.put("preceding", new PrecedingAxisExpr());
        functionTable.put("boolean", new BooleanFunction());
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("concat", new ConcatFunction());
        functionTable.put("contains", new ContainsFunction());
        functionTable.put("count", new CountFunction());
        functionTable.put("document", new DocumentFunction());
        functionTable.put("false", new FalseFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("format-number", new FormatNumberFunction());
        functionTable.put("function-available", new FunctionAvailableFunction());
        functionTable.put("generate-id", new GenerateIdFunction());
        functionTable.put("id", new IdFunction());
        functionTable.put("lang", new LangFunction());
        functionTable.put("last", new LastFunction());
        functionTable.put("local-name", new LocalNameFunction());
        functionTable.put("namespace-uri", new NamespaceUriFunction());
        functionTable.put("normalize-space", new NormalizeSpaceFunction());
        functionTable.put("not", new NotFunction());
        functionTable.put("number", new NumberFunction());
        functionTable.put("position", new PositionFunction());
        functionTable.put("name", new NameFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("starts-with", new StartsWithFunction());
        functionTable.put("string", new StringFunction());
        functionTable.put("string-length", new StringLengthFunction());
        functionTable.put("substring", new SubstringFunction());
        functionTable.put("substring-after", new SubstringAfterFunction());
        functionTable.put("substring-before", new SubstringBeforeFunction());
        functionTable.put("sum", new SumFunction());
        functionTable.put("system-property", new SystemPropertyFunction());
        functionTable.put("translate", new TranslateFunction());
        functionTable.put("true", new TrueFunction());
        functionTable.put("unparsed-entity-uri", new UnparsedEntityURIFunction());
        extensionFunctionTable.put("node-set", new NodeSetFunction());
        extensionFunctionTable.put("intersection", new IntersectionFunction());
        extensionFunctionTable.put("difference", new DifferenceFunction());
    }

    public static StringExpr parseStringExpr(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, string, variableSet).makeStringExpr();
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }

    private ConvertibleExpr parseOrExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAndExpr();
        while (this.currentToken == 35) {
            this.next();
            convertibleExpr = new OrExpr(convertibleExpr.makeBooleanExpr(), this.parseAndExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseEqualityExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseRelationalExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 28: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(equalsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
                case 29: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(notEqualsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseRelationalExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAdditiveExpr();
        block6: while (true) {
            switch (this.currentToken) {
                case 30: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 32: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 31: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
                case 33: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseMultiplicativeExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 37: {
                    this.next();
                    convertibleExpr = new DivideExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 36: {
                    this.next();
                    convertibleExpr = new ModuloExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 11: {
                    this.next();
                    convertibleExpr = new MultiplyExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseUnaryExpr() throws ParseException {
        if (this.currentToken == 27) {
            this.next();
            return new NegateExpr(this.parseUnaryExpr().makeNumberExpr());
        }
        return this.parseUnionExpr();
    }

    private ConvertibleExpr parsePathExpr() throws ParseException {
        if (this.tokenStartsStep()) {
            return this.parseRelativeLocationPath();
        }
        if (this.currentToken == 22) {
            this.next();
            if (this.tokenStartsStep()) {
                return new RootExpr(this.parseRelativeLocationPath());
            }
            return new RootExpr(selfAxis);
        }
        if (this.currentToken == 23) {
            this.next();
            return new RootExpr(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        ConvertibleExpr convertibleExpr = this.parsePrimaryExpr();
        while (this.currentToken == 14) {
            this.next();
            convertibleExpr = new FilterExpr(convertibleExpr.makeNodeSetExpr(), this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        if (this.currentToken == 22) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleExpr;
    }

    public static BooleanExpr parseBooleanExpr(Node node, String string, VariableSet variableSet) throws XSLException {
        try {
            return ExprParser.parseConvertibleExpr(node, string, variableSet).makeBooleanExpr();
        }
        catch (ParseException parseException) {
            throw ExprParser.makeXSLException(parseException, node);
        }
    }
}

