# Before `make install' is performed this script should be runnable
# with `make test'. After `make install' it should work as `perl
# URLInputSource.t'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..9\n"; }
END {print "not ok 1\n" unless $loaded;}
use Carp;
use XML::Xerces;
use Cwd;

use lib 't';
use TestUtils qw(result $PERSONAL_FILE_NAME);
use vars qw($i $loaded $file $error);
use strict;

$loaded = 1;
$i = 1;
result($loaded);

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):


#
# This test monitors a heinous setErrorHandler() bug, in which
#   no internal reference to the perl handler object was maintained
#   and so when it went out of scope it was destroyed, and caused
#   core dumps
#

package MyErrorHandler;
use strict;
use vars qw(@ISA);
@ISA = qw(XML::Xerces::PerlErrorHandler);
sub warning {
}

sub error {
  $::error = 'error';
}

sub fatal_error {
  $::error = 'fatal';
}
1;

package main;
# a bogus URL to cause a fatal error
my $URL = 'file://../foo';
my $DOM = XML::Xerces::DOMParser->new();
$DOM->setErrorHandler(MyErrorHandler->new());
$error = undef;
$DOM->parse(XML::Xerces::URLInputSource->new('file:',$URL,'foo'));
result($error eq 'fatal');

# test that our error handler generates a die() with a fatal error
$DOM = XML::Xerces::DOMParser->new();
$DOM->setErrorHandler(XML::Xerces::PerlErrorHandler->new());
eval {
  $DOM->parse(XML::Xerces::LocalFileInputSource->new('/I/AM/NOT/A/FILE'));
};
result($@);

# now test DOMParser::reset
$DOM->reset();
result(1);

# now test the overloaded methods in DOMParser
$DOM->parse($PERSONAL_FILE_NAME);
result(1);


# test the progressive parsing interface
my $token = XML::Xerces::XMLPScanToken->new();
$DOM->parseFirst($PERSONAL_FILE_NAME,$token);
while ($DOM->parseNext($token)) {
  # do nothing
}
result(1);


# test that we can reuse the parse again and again
my $document = <<\END;
<?xml version="1.0" encoding="iso-8859-1" standalone="no"?>

<!-- @version: -->
<personnel>

  <person id="Big.Boss">
    <name><family>Boss</family> <given>Big</given></name>
    <email>chief@foo.com</email>
    <link subordinates="one.worker two.worker three.worker four.worker five.worker"/>
  </person>

  <person id="one.worker">
    <name><family>Worker</family> <given>One</given></name>
    <email>one@foo.com</email>
    <link manager="Big.Boss"/>
  </person>

  <foo id="two.worker">
    <name><family>Worker</family> <given>Two</given></name>
    <email>two@foo.com</email>
    <link manager="Big.Boss"/>
  </person>

  <person id="three.worker">
    <name><family>Worker</family> <given>Three</given></name>
    <email>three@foo.com</email>
    <link manager="Big.Boss"/>
  </person>

  <person id="four.worker">
    <name><family>Worker</family> <given>Four</given></name>
    <email>four@foo.com</email>
    <link manager="Big.Boss"/>
  </person>

  <person id="five.worker">
    <name><family>Worker</family> <given>Five</given></name>
    <email>five@foo.com</email>
    <link manager="Big.Boss"/>
  </person>

</personnel>
END

$token = XML::Xerces::XMLPScanToken->new();
$DOM->setErrorHandler(MyErrorHandler->new());
$::error = '';
$DOM->parseFirst(XML::Xerces::MemBufInputSource->new($document),$token);
while ($DOM->parseNext($token)) {
  # do nothing
}
result($::error eq 'fatal');
$::error = '';
$DOM->parseReset($token);
$DOM->parse(XML::Xerces::MemBufInputSource->new($document));
result($::error eq 'fatal');

# test that we can exclude ignorable whitespace
$DOM = XML::Xerces::IDOMParser->new();
$DOM->setValidationScheme($XML::Xerces::DOMParser::Val_Always);
$DOM->setIncludeIgnorableWhitespace(0);
$DOM->parse($PERSONAL_FILE_NAME);

# now check that we do *not* get whitespace nodes
my @nodes = $DOM->getDocument->getDocumentElement->getChildNodes();
result(scalar @nodes == 6);
