/*
 * Copyright © 2001 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Red Hat not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Red Hat makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * RED HAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL RED HAT
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Owen Taylor, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *          Olivier Fourdan: adapted to the "multi-channel" concept
 */
#ifndef MCS_CLIENT_H
#define MCS_CLIENT_H

#include <X11/Xlib.h>

#include <glib.h>

#include <libxfce4mcs/mcs-common.h>

#ifdef __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

    typedef struct _McsClient McsClient;

    typedef enum
    {
        MCS_ACTION_NEW,
        MCS_ACTION_CHANGED,
        MCS_ACTION_DELETED
    }
    McsAction;

    typedef void (*McsNotifyFunc) (const gchar *name, const gchar *channel_name, McsAction action, McsSetting * setting, void *cb_data);
    typedef void (*McsWatchFunc) (Window window, Bool is_start, long mask, void *cb_data);

    McsClient *mcs_client_new(Display * display, int screen, McsNotifyFunc notify, McsWatchFunc watch, void *cb_data);
    void mcs_client_destroy(McsClient * client);
    Bool mcs_client_process_event(McsClient * client, XEvent * xev);

    McsChannel *mcs_client_add_channel(McsClient * client, const gchar *channel_name);
    void mcs_client_delete_channel(McsClient * client, const gchar *channel_name);

    McsResult mcs_client_get_setting(McsClient * client, const gchar *name, const gchar *channel_name, McsSetting ** setting);

    void mcs_client_show(Display * display, int screen, const gchar *message);

    gboolean mcs_client_check_manager(Display * display, int screen, const gchar *manager_command);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* MCS_CLIENT_H */
