/*
 * Unicode Conversion Library (UCS2 to CP932)
 * 1999 by yoshidam
 *
 */

#ifndef _U2S_H
#define _U2S_H

/*
 *  0x0000-0x007f : ASCII
 *  0x00a1-0x00df : JIS X 0201 KANA
 *  0x8140-0xfcfc : JIS X 0208 + alpha
 */
const static unsigned short u2s_tbl[65536] = {
  0x0000, /* U+0000 */
  0x0001, /* U+0001 */
  0x0002, /* U+0002 */
  0x0003, /* U+0003 */
  0x0004, /* U+0004 */
  0x0005, /* U+0005 */
  0x0006, /* U+0006 */
  0x0007, /* U+0007 */
  0x0008, /* U+0008 */
  0x0009, /* U+0009 */
  0x000a, /* U+000a */
  0x000b, /* U+000b */
  0x000c, /* U+000c */
  0x000d, /* U+000d */
  0x000e, /* U+000e */
  0x000f, /* U+000f */
  0x0010, /* U+0010 */
  0x0011, /* U+0011 */
  0x0012, /* U+0012 */
  0x0013, /* U+0013 */
  0x0014, /* U+0014 */
  0x0015, /* U+0015 */
  0x0016, /* U+0016 */
  0x0017, /* U+0017 */
  0x0018, /* U+0018 */
  0x0019, /* U+0019 */
  0x001a, /* U+001a */
  0x001b, /* U+001b */
  0x001c, /* U+001c */
  0x001d, /* U+001d */
  0x001e, /* U+001e */
  0x001f, /* U+001f */
  0x0020, /* U+0020 */
  0x0021, /* U+0021 */
  0x0022, /* U+0022 */
  0x0023, /* U+0023 */
  0x0024, /* U+0024 */
  0x0025, /* U+0025 */
  0x0026, /* U+0026 */
  0x0027, /* U+0027 */
  0x0028, /* U+0028 */
  0x0029, /* U+0029 */
  0x002a, /* U+002a */
  0x002b, /* U+002b */
  0x002c, /* U+002c */
  0x002d, /* U+002d */
  0x002e, /* U+002e */
  0x002f, /* U+002f */
  0x0030, /* U+0030 */
  0x0031, /* U+0031 */
  0x0032, /* U+0032 */
  0x0033, /* U+0033 */
  0x0034, /* U+0034 */
  0x0035, /* U+0035 */
  0x0036, /* U+0036 */
  0x0037, /* U+0037 */
  0x0038, /* U+0038 */
  0x0039, /* U+0039 */
  0x003a, /* U+003a */
  0x003b, /* U+003b */
  0x003c, /* U+003c */
  0x003d, /* U+003d */
  0x003e, /* U+003e */
  0x003f, /* U+003f */
  0x0040, /* U+0040 */
  0x0041, /* U+0041 */
  0x0042, /* U+0042 */
  0x0043, /* U+0043 */
  0x0044, /* U+0044 */
  0x0045, /* U+0045 */
  0x0046, /* U+0046 */
  0x0047, /* U+0047 */
  0x0048, /* U+0048 */
  0x0049, /* U+0049 */
  0x004a, /* U+004a */
  0x004b, /* U+004b */
  0x004c, /* U+004c */
  0x004d, /* U+004d */
  0x004e, /* U+004e */
  0x004f, /* U+004f */
  0x0050, /* U+0050 */
  0x0051, /* U+0051 */
  0x0052, /* U+0052 */
  0x0053, /* U+0053 */
  0x0054, /* U+0054 */
  0x0055, /* U+0055 */
  0x0056, /* U+0056 */
  0x0057, /* U+0057 */
  0x0058, /* U+0058 */
  0x0059, /* U+0059 */
  0x005a, /* U+005a */
  0x005b, /* U+005b */
  0x005c, /* U+005c */
  0x005d, /* U+005d */
  0x005e, /* U+005e */
  0x005f, /* U+005f */
  0x0060, /* U+0060 */
  0x0061, /* U+0061 */
  0x0062, /* U+0062 */
  0x0063, /* U+0063 */
  0x0064, /* U+0064 */
  0x0065, /* U+0065 */
  0x0066, /* U+0066 */
  0x0067, /* U+0067 */
  0x0068, /* U+0068 */
  0x0069, /* U+0069 */
  0x006a, /* U+006a */
  0x006b, /* U+006b */
  0x006c, /* U+006c */
  0x006d, /* U+006d */
  0x006e, /* U+006e */
  0x006f, /* U+006f */
  0x0070, /* U+0070 */
  0x0071, /* U+0071 */
  0x0072, /* U+0072 */
  0x0073, /* U+0073 */
  0x0074, /* U+0074 */
  0x0075, /* U+0075 */
  0x0076, /* U+0076 */
  0x0077, /* U+0077 */
  0x0078, /* U+0078 */
  0x0079, /* U+0079 */
  0x007a, /* U+007a */
  0x007b, /* U+007b */
  0x007c, /* U+007c */
  0x007d, /* U+007d */
  0x007e, /* U+007e */
  0x007f, /* U+007f */
  0x0000, /* U+0080 */
  0x0000, /* U+0081 */
  0x0000, /* U+0082 */
  0x0000, /* U+0083 */
  0x0000, /* U+0084 */
  0x0000, /* U+0085 */
  0x0000, /* U+0086 */
  0x0000, /* U+0087 */
  0x0000, /* U+0088 */
  0x0000, /* U+0089 */
  0x0000, /* U+008a */
  0x0000, /* U+008b */
  0x0000, /* U+008c */
  0x0000, /* U+008d */
  0x0000, /* U+008e */
  0x0000, /* U+008f */
  0x0000, /* U+0090 */
  0x0000, /* U+0091 */
  0x0000, /* U+0092 */
  0x0000, /* U+0093 */
  0x0000, /* U+0094 */
  0x0000, /* U+0095 */
  0x0000, /* U+0096 */
  0x0000, /* U+0097 */
  0x0000, /* U+0098 */
  0x0000, /* U+0099 */
  0x0000, /* U+009a */
  0x0000, /* U+009b */
  0x0000, /* U+009c */
  0x0000, /* U+009d */
  0x0000, /* U+009e */
  0x0000, /* U+009f */
  0x0000, /* U+00a0 */
  0x0000, /* U+00a1 */
  0x0000, /* U+00a2 */
  0x0000, /* U+00a3 */
  0x0000, /* U+00a4 */
  0x0000, /* U+00a5 */
  0x0000, /* U+00a6 */
  0x8198, /* U+00a7 */
  0x814e, /* U+00a8 */
  0x0000, /* U+00a9 */
  0x0000, /* U+00aa */
  0x0000, /* U+00ab */
  0x0000, /* U+00ac */
  0x0000, /* U+00ad */
  0x0000, /* U+00ae */
  0x0000, /* U+00af */
  0x818b, /* U+00b0 */
  0x817d, /* U+00b1 */
  0x0000, /* U+00b2 */
  0x0000, /* U+00b3 */
  0x814c, /* U+00b4 */
  0x0000, /* U+00b5 */
  0x81f7, /* U+00b6 */
  0x0000, /* U+00b7 */
  0x0000, /* U+00b8 */
  0x0000, /* U+00b9 */
  0x0000, /* U+00ba */
  0x0000, /* U+00bb */
  0x0000, /* U+00bc */
  0x0000, /* U+00bd */
  0x0000, /* U+00be */
  0x0000, /* U+00bf */
  0x0000, /* U+00c0 */
  0x0000, /* U+00c1 */
  0x0000, /* U+00c2 */
  0x0000, /* U+00c3 */
  0x0000, /* U+00c4 */
  0x0000, /* U+00c5 */
  0x0000, /* U+00c6 */
  0x0000, /* U+00c7 */
  0x0000, /* U+00c8 */
  0x0000, /* U+00c9 */
  0x0000, /* U+00ca */
  0x0000, /* U+00cb */
  0x0000, /* U+00cc */
  0x0000, /* U+00cd */
  0x0000, /* U+00ce */
  0x0000, /* U+00cf */
  0x0000, /* U+00d0 */
  0x0000, /* U+00d1 */
  0x0000, /* U+00d2 */
  0x0000, /* U+00d3 */
  0x0000, /* U+00d4 */
  0x0000, /* U+00d5 */
  0x0000, /* U+00d6 */
  0x817e, /* U+00d7 */
  0x0000, /* U+00d8 */
  0x0000, /* U+00d9 */
  0x0000, /* U+00da */
  0x0000, /* U+00db */
  0x0000, /* U+00dc */
  0x0000, /* U+00dd */
  0x0000, /* U+00de */
  0x0000, /* U+00df */
  0x0000, /* U+00e0 */
  0x0000, /* U+00e1 */
  0x0000, /* U+00e2 */
  0x0000, /* U+00e3 */
  0x0000, /* U+00e4 */
  0x0000, /* U+00e5 */
  0x0000, /* U+00e6 */
  0x0000, /* U+00e7 */
  0x0000, /* U+00e8 */
  0x0000, /* U+00e9 */
  0x0000, /* U+00ea */
  0x0000, /* U+00eb */
  0x0000, /* U+00ec */
  0x0000, /* U+00ed */
  0x0000, /* U+00ee */
  0x0000, /* U+00ef */
  0x0000, /* U+00f0 */
  0x0000, /* U+00f1 */
  0x0000, /* U+00f2 */
  0x0000, /* U+00f3 */
  0x0000, /* U+00f4 */
  0x0000, /* U+00f5 */
  0x0000, /* U+00f6 */
  0x8180, /* U+00f7 */
  0x0000, /* U+00f8 */
  0x0000, /* U+00f9 */
  0x0000, /* U+00fa */
  0x0000, /* U+00fb */
  0x0000, /* U+00fc */
  0x0000, /* U+00fd */
  0x0000, /* U+00fe */
  0x0000, /* U+00ff */
  0x0000, /* U+0100 */
  0x0000, /* U+0101 */
  0x0000, /* U+0102 */
  0x0000, /* U+0103 */
  0x0000, /* U+0104 */
  0x0000, /* U+0105 */
  0x0000, /* U+0106 */
  0x0000, /* U+0107 */
  0x0000, /* U+0108 */
  0x0000, /* U+0109 */
  0x0000, /* U+010a */
  0x0000, /* U+010b */
  0x0000, /* U+010c */
  0x0000, /* U+010d */
  0x0000, /* U+010e */
  0x0000, /* U+010f */
  0x0000, /* U+0110 */
  0x0000, /* U+0111 */
  0x0000, /* U+0112 */
  0x0000, /* U+0113 */
  0x0000, /* U+0114 */
  0x0000, /* U+0115 */
  0x0000, /* U+0116 */
  0x0000, /* U+0117 */
  0x0000, /* U+0118 */
  0x0000, /* U+0119 */
  0x0000, /* U+011a */
  0x0000, /* U+011b */
  0x0000, /* U+011c */
  0x0000, /* U+011d */
  0x0000, /* U+011e */
  0x0000, /* U+011f */
  0x0000, /* U+0120 */
  0x0000, /* U+0121 */
  0x0000, /* U+0122 */
  0x0000, /* U+0123 */
  0x0000, /* U+0124 */
  0x0000, /* U+0125 */
  0x0000, /* U+0126 */
  0x0000, /* U+0127 */
  0x0000, /* U+0128 */
  0x0000, /* U+0129 */
  0x0000, /* U+012a */
  0x0000, /* U+012b */
  0x0000, /* U+012c */
  0x0000, /* U+012d */
  0x0000, /* U+012e */
  0x0000, /* U+012f */
  0x0000, /* U+0130 */
  0x0000, /* U+0131 */
  0x0000, /* U+0132 */
  0x0000, /* U+0133 */
  0x0000, /* U+0134 */
  0x0000, /* U+0135 */
  0x0000, /* U+0136 */
  0x0000, /* U+0137 */
  0x0000, /* U+0138 */
  0x0000, /* U+0139 */
  0x0000, /* U+013a */
  0x0000, /* U+013b */
  0x0000, /* U+013c */
  0x0000, /* U+013d */
  0x0000, /* U+013e */
  0x0000, /* U+013f */
  0x0000, /* U+0140 */
  0x0000, /* U+0141 */
  0x0000, /* U+0142 */
  0x0000, /* U+0143 */
  0x0000, /* U+0144 */
  0x0000, /* U+0145 */
  0x0000, /* U+0146 */
  0x0000, /* U+0147 */
  0x0000, /* U+0148 */
  0x0000, /* U+0149 */
  0x0000, /* U+014a */
  0x0000, /* U+014b */
  0x0000, /* U+014c */
  0x0000, /* U+014d */
  0x0000, /* U+014e */
  0x0000, /* U+014f */
  0x0000, /* U+0150 */
  0x0000, /* U+0151 */
  0x0000, /* U+0152 */
  0x0000, /* U+0153 */
  0x0000, /* U+0154 */
  0x0000, /* U+0155 */
  0x0000, /* U+0156 */
  0x0000, /* U+0157 */
  0x0000, /* U+0158 */
  0x0000, /* U+0159 */
  0x0000, /* U+015a */
  0x0000, /* U+015b */
  0x0000, /* U+015c */
  0x0000, /* U+015d */
  0x0000, /* U+015e */
  0x0000, /* U+015f */
  0x0000, /* U+0160 */
  0x0000, /* U+0161 */
  0x0000, /* U+0162 */
  0x0000, /* U+0163 */
  0x0000, /* U+0164 */
  0x0000, /* U+0165 */
  0x0000, /* U+0166 */
  0x0000, /* U+0167 */
  0x0000, /* U+0168 */
  0x0000, /* U+0169 */
  0x0000, /* U+016a */
  0x0000, /* U+016b */
  0x0000, /* U+016c */
  0x0000, /* U+016d */
  0x0000, /* U+016e */
  0x0000, /* U+016f */
  0x0000, /* U+0170 */
  0x0000, /* U+0171 */
  0x0000, /* U+0172 */
  0x0000, /* U+0173 */
  0x0000, /* U+0174 */
  0x0000, /* U+0175 */
  0x0000, /* U+0176 */
  0x0000, /* U+0177 */
  0x0000, /* U+0178 */
  0x0000, /* U+0179 */
  0x0000, /* U+017a */
  0x0000, /* U+017b */
  0x0000, /* U+017c */
  0x0000, /* U+017d */
  0x0000, /* U+017e */
  0x0000, /* U+017f */
  0x0000, /* U+0180 */
  0x0000, /* U+0181 */
  0x0000, /* U+0182 */
  0x0000, /* U+0183 */
  0x0000, /* U+0184 */
  0x0000, /* U+0185 */
  0x0000, /* U+0186 */
  0x0000, /* U+0187 */
  0x0000, /* U+0188 */
  0x0000, /* U+0189 */
  0x0000, /* U+018a */
  0x0000, /* U+018b */
  0x0000, /* U+018c */
  0x0000, /* U+018d */
  0x0000, /* U+018e */
  0x0000, /* U+018f */
  0x0000, /* U+0190 */
  0x0000, /* U+0191 */
  0x0000, /* U+0192 */
  0x0000, /* U+0193 */
  0x0000, /* U+0194 */
  0x0000, /* U+0195 */
  0x0000, /* U+0196 */
  0x0000, /* U+0197 */
  0x0000, /* U+0198 */
  0x0000, /* U+0199 */
  0x0000, /* U+019a */
  0x0000, /* U+019b */
  0x0000, /* U+019c */
  0x0000, /* U+019d */
  0x0000, /* U+019e */
  0x0000, /* U+019f */
  0x0000, /* U+01a0 */
  0x0000, /* U+01a1 */
  0x0000, /* U+01a2 */
  0x0000, /* U+01a3 */
  0x0000, /* U+01a4 */
  0x0000, /* U+01a5 */
  0x0000, /* U+01a6 */
  0x0000, /* U+01a7 */
  0x0000, /* U+01a8 */
  0x0000, /* U+01a9 */
  0x0000, /* U+01aa */
  0x0000, /* U+01ab */
  0x0000, /* U+01ac */
  0x0000, /* U+01ad */
  0x0000, /* U+01ae */
  0x0000, /* U+01af */
  0x0000, /* U+01b0 */
  0x0000, /* U+01b1 */
  0x0000, /* U+01b2 */
  0x0000, /* U+01b3 */
  0x0000, /* U+01b4 */
  0x0000, /* U+01b5 */
  0x0000, /* U+01b6 */
  0x0000, /* U+01b7 */
  0x0000, /* U+01b8 */
  0x0000, /* U+01b9 */
  0x0000, /* U+01ba */
  0x0000, /* U+01bb */
  0x0000, /* U+01bc */
  0x0000, /* U+01bd */
  0x0000, /* U+01be */
  0x0000, /* U+01bf */
  0x0000, /* U+01c0 */
  0x0000, /* U+01c1 */
  0x0000, /* U+01c2 */
  0x0000, /* U+01c3 */
  0x0000, /* U+01c4 */
  0x0000, /* U+01c5 */
  0x0000, /* U+01c6 */
  0x0000, /* U+01c7 */
  0x0000, /* U+01c8 */
  0x0000, /* U+01c9 */
  0x0000, /* U+01ca */
  0x0000, /* U+01cb */
  0x0000, /* U+01cc */
  0x0000, /* U+01cd */
  0x0000, /* U+01ce */
  0x0000, /* U+01cf */
  0x0000, /* U+01d0 */
  0x0000, /* U+01d1 */
  0x0000, /* U+01d2 */
  0x0000, /* U+01d3 */
  0x0000, /* U+01d4 */
  0x0000, /* U+01d5 */
  0x0000, /* U+01d6 */
  0x0000, /* U+01d7 */
  0x0000, /* U+01d8 */
  0x0000, /* U+01d9 */
  0x0000, /* U+01da */
  0x0000, /* U+01db */
  0x0000, /* U+01dc */
  0x0000, /* U+01dd */
  0x0000, /* U+01de */
  0x0000, /* U+01df */
  0x0000, /* U+01e0 */
  0x0000, /* U+01e1 */
  0x0000, /* U+01e2 */
  0x0000, /* U+01e3 */
  0x0000, /* U+01e4 */
  0x0000, /* U+01e5 */
  0x0000, /* U+01e6 */
  0x0000, /* U+01e7 */
  0x0000, /* U+01e8 */
  0x0000, /* U+01e9 */
  0x0000, /* U+01ea */
  0x0000, /* U+01eb */
  0x0000, /* U+01ec */
  0x0000, /* U+01ed */
  0x0000, /* U+01ee */
  0x0000, /* U+01ef */
  0x0000, /* U+01f0 */
  0x0000, /* U+01f1 */
  0x0000, /* U+01f2 */
  0x0000, /* U+01f3 */
  0x0000, /* U+01f4 */
  0x0000, /* U+01f5 */
  0x0000, /* U+01f6 */
  0x0000, /* U+01f7 */
  0x0000, /* U+01f8 */
  0x0000, /* U+01f9 */
  0x0000, /* U+01fa */
  0x0000, /* U+01fb */
  0x0000, /* U+01fc */
  0x0000, /* U+01fd */
  0x0000, /* U+01fe */
  0x0000, /* U+01ff */
  0x0000, /* U+0200 */
  0x0000, /* U+0201 */
  0x0000, /* U+0202 */
  0x0000, /* U+0203 */
  0x0000, /* U+0204 */
  0x0000, /* U+0205 */
  0x0000, /* U+0206 */
  0x0000, /* U+0207 */
  0x0000, /* U+0208 */
  0x0000, /* U+0209 */
  0x0000, /* U+020a */
  0x0000, /* U+020b */
  0x0000, /* U+020c */
  0x0000, /* U+020d */
  0x0000, /* U+020e */
  0x0000, /* U+020f */
  0x0000, /* U+0210 */
  0x0000, /* U+0211 */
  0x0000, /* U+0212 */
  0x0000, /* U+0213 */
  0x0000, /* U+0214 */
  0x0000, /* U+0215 */
  0x0000, /* U+0216 */
  0x0000, /* U+0217 */
  0x0000, /* U+0218 */
  0x0000, /* U+0219 */
  0x0000, /* U+021a */
  0x0000, /* U+021b */
  0x0000, /* U+021c */
  0x0000, /* U+021d */
  0x0000, /* U+021e */
  0x0000, /* U+021f */
  0x0000, /* U+0220 */
  0x0000, /* U+0221 */
  0x0000, /* U+0222 */
  0x0000, /* U+0223 */
  0x0000, /* U+0224 */
  0x0000, /* U+0225 */
  0x0000, /* U+0226 */
  0x0000, /* U+0227 */
  0x0000, /* U+0228 */
  0x0000, /* U+0229 */
  0x0000, /* U+022a */
  0x0000, /* U+022b */
  0x0000, /* U+022c */
  0x0000, /* U+022d */
  0x0000, /* U+022e */
  0x0000, /* U+022f */
  0x0000, /* U+0230 */
  0x0000, /* U+0231 */
  0x0000, /* U+0232 */
  0x0000, /* U+0233 */
  0x0000, /* U+0234 */
  0x0000, /* U+0235 */
  0x0000, /* U+0236 */
  0x0000, /* U+0237 */
  0x0000, /* U+0238 */
  0x0000, /* U+0239 */
  0x0000, /* U+023a */
  0x0000, /* U+023b */
  0x0000, /* U+023c */
  0x0000, /* U+023d */
  0x0000, /* U+023e */
  0x0000, /* U+023f */
  0x0000, /* U+0240 */
  0x0000, /* U+0241 */
  0x0000, /* U+0242 */
  0x0000, /* U+0243 */
  0x0000, /* U+0244 */
  0x0000, /* U+0245 */
  0x0000, /* U+0246 */
  0x0000, /* U+0247 */
  0x0000, /* U+0248 */
  0x0000, /* U+0249 */
  0x0000, /* U+024a */
  0x0000, /* U+024b */
  0x0000, /* U+024c */
  0x0000, /* U+024d */
  0x0000, /* U+024e */
  0x0000, /* U+024f */
  0x0000, /* U+0250 */
  0x0000, /* U+0251 */
  0x0000, /* U+0252 */
  0x0000, /* U+0253 */
  0x0000, /* U+0254 */
  0x0000, /* U+0255 */
  0x0000, /* U+0256 */
  0x0000, /* U+0257 */
  0x0000, /* U+0258 */
  0x0000, /* U+0259 */
  0x0000, /* U+025a */
  0x0000, /* U+025b */
  0x0000, /* U+025c */
  0x0000, /* U+025d */
  0x0000, /* U+025e */
  0x0000, /* U+025f */
  0x0000, /* U+0260 */
  0x0000, /* U+0261 */
  0x0000, /* U+0262 */
  0x0000, /* U+0263 */
  0x0000, /* U+0264 */
  0x0000, /* U+0265 */
  0x0000, /* U+0266 */
  0x0000, /* U+0267 */
  0x0000, /* U+0268 */
  0x0000, /* U+0269 */
  0x0000, /* U+026a */
  0x0000, /* U+026b */
  0x0000, /* U+026c */
  0x0000, /* U+026d */
  0x0000, /* U+026e */
  0x0000, /* U+026f */
  0x0000, /* U+0270 */
  0x0000, /* U+0271 */
  0x0000, /* U+0272 */
  0x0000, /* U+0273 */
  0x0000, /* U+0274 */
  0x0000, /* U+0275 */
  0x0000, /* U+0276 */
  0x0000, /* U+0277 */
  0x0000, /* U+0278 */
  0x0000, /* U+0279 */
  0x0000, /* U+027a */
  0x0000, /* U+027b */
  0x0000, /* U+027c */
  0x0000, /* U+027d */
  0x0000, /* U+027e */
  0x0000, /* U+027f */
  0x0000, /* U+0280 */
  0x0000, /* U+0281 */
  0x0000, /* U+0282 */
  0x0000, /* U+0283 */
  0x0000, /* U+0284 */
  0x0000, /* U+0285 */
  0x0000, /* U+0286 */
  0x0000, /* U+0287 */
  0x0000, /* U+0288 */
  0x0000, /* U+0289 */
  0x0000, /* U+028a */
  0x0000, /* U+028b */
  0x0000, /* U+028c */
  0x0000, /* U+028d */
  0x0000, /* U+028e */
  0x0000, /* U+028f */
  0x0000, /* U+0290 */
  0x0000, /* U+0291 */
  0x0000, /* U+0292 */
  0x0000, /* U+0293 */
  0x0000, /* U+0294 */
  0x0000, /* U+0295 */
  0x0000, /* U+0296 */
  0x0000, /* U+0297 */
  0x0000, /* U+0298 */
  0x0000, /* U+0299 */
  0x0000, /* U+029a */
  0x0000, /* U+029b */
  0x0000, /* U+029c */
  0x0000, /* U+029d */
  0x0000, /* U+029e */
  0x0000, /* U+029f */
  0x0000, /* U+02a0 */
  0x0000, /* U+02a1 */
  0x0000, /* U+02a2 */
  0x0000, /* U+02a3 */
  0x0000, /* U+02a4 */
  0x0000, /* U+02a5 */
  0x0000, /* U+02a6 */
  0x0000, /* U+02a7 */
  0x0000, /* U+02a8 */
  0x0000, /* U+02a9 */
  0x0000, /* U+02aa */
  0x0000, /* U+02ab */
  0x0000, /* U+02ac */
  0x0000, /* U+02ad */
  0x0000, /* U+02ae */
  0x0000, /* U+02af */
  0x0000, /* U+02b0 */
  0x0000, /* U+02b1 */
  0x0000, /* U+02b2 */
  0x0000, /* U+02b3 */
  0x0000, /* U+02b4 */
  0x0000, /* U+02b5 */
  0x0000, /* U+02b6 */
  0x0000, /* U+02b7 */
  0x0000, /* U+02b8 */
  0x0000, /* U+02b9 */
  0x0000, /* U+02ba */
  0x0000, /* U+02bb */
  0x0000, /* U+02bc */
  0x0000, /* U+02bd */
  0x0000, /* U+02be */
  0x0000, /* U+02bf */
  0x0000, /* U+02c0 */
  0x0000, /* U+02c1 */
  0x0000, /* U+02c2 */
  0x0000, /* U+02c3 */
  0x0000, /* U+02c4 */
  0x0000, /* U+02c5 */
  0x0000, /* U+02c6 */
  0x0000, /* U+02c7 */
  0x0000, /* U+02c8 */
  0x0000, /* U+02c9 */
  0x0000, /* U+02ca */
  0x0000, /* U+02cb */
  0x0000, /* U+02cc */
  0x0000, /* U+02cd */
  0x0000, /* U+02ce */
  0x0000, /* U+02cf */
  0x0000, /* U+02d0 */
  0x0000, /* U+02d1 */
  0x0000, /* U+02d2 */
  0x0000, /* U+02d3 */
  0x0000, /* U+02d4 */
  0x0000, /* U+02d5 */
  0x0000, /* U+02d6 */
  0x0000, /* U+02d7 */
  0x0000, /* U+02d8 */
  0x0000, /* U+02d9 */
  0x0000, /* U+02da */
  0x0000, /* U+02db */
  0x0000, /* U+02dc */
  0x0000, /* U+02dd */
  0x0000, /* U+02de */
  0x0000, /* U+02df */
  0x0000, /* U+02e0 */
  0x0000, /* U+02e1 */
  0x0000, /* U+02e2 */
  0x0000, /* U+02e3 */
  0x0000, /* U+02e4 */
  0x0000, /* U+02e5 */
  0x0000, /* U+02e6 */
  0x0000, /* U+02e7 */
  0x0000, /* U+02e8 */
  0x0000, /* U+02e9 */
  0x0000, /* U+02ea */
  0x0000, /* U+02eb */
  0x0000, /* U+02ec */
  0x0000, /* U+02ed */
  0x0000, /* U+02ee */
  0x0000, /* U+02ef */
  0x0000, /* U+02f0 */
  0x0000, /* U+02f1 */
  0x0000, /* U+02f2 */
  0x0000, /* U+02f3 */
  0x0000, /* U+02f4 */
  0x0000, /* U+02f5 */
  0x0000, /* U+02f6 */
  0x0000, /* U+02f7 */
  0x0000, /* U+02f8 */
  0x0000, /* U+02f9 */
  0x0000, /* U+02fa */
  0x0000, /* U+02fb */
  0x0000, /* U+02fc */
  0x0000, /* U+02fd */
  0x0000, /* U+02fe */
  0x0000, /* U+02ff */
  0x0000, /* U+0300 */
  0x0000, /* U+0301 */
  0x0000, /* U+0302 */
  0x0000, /* U+0303 */
  0x0000, /* U+0304 */
  0x0000, /* U+0305 */
  0x0000, /* U+0306 */
  0x0000, /* U+0307 */
  0x0000, /* U+0308 */
  0x0000, /* U+0309 */
  0x0000, /* U+030a */
  0x0000, /* U+030b */
  0x0000, /* U+030c */
  0x0000, /* U+030d */
  0x0000, /* U+030e */
  0x0000, /* U+030f */
  0x0000, /* U+0310 */
  0x0000, /* U+0311 */
  0x0000, /* U+0312 */
  0x0000, /* U+0313 */
  0x0000, /* U+0314 */
  0x0000, /* U+0315 */
  0x0000, /* U+0316 */
  0x0000, /* U+0317 */
  0x0000, /* U+0318 */
  0x0000, /* U+0319 */
  0x0000, /* U+031a */
  0x0000, /* U+031b */
  0x0000, /* U+031c */
  0x0000, /* U+031d */
  0x0000, /* U+031e */
  0x0000, /* U+031f */
  0x0000, /* U+0320 */
  0x0000, /* U+0321 */
  0x0000, /* U+0322 */
  0x0000, /* U+0323 */
  0x0000, /* U+0324 */
  0x0000, /* U+0325 */
  0x0000, /* U+0326 */
  0x0000, /* U+0327 */
  0x0000, /* U+0328 */
  0x0000, /* U+0329 */
  0x0000, /* U+032a */
  0x0000, /* U+032b */
  0x0000, /* U+032c */
  0x0000, /* U+032d */
  0x0000, /* U+032e */
  0x0000, /* U+032f */
  0x0000, /* U+0330 */
  0x0000, /* U+0331 */
  0x0000, /* U+0332 */
  0x0000, /* U+0333 */
  0x0000, /* U+0334 */
  0x0000, /* U+0335 */
  0x0000, /* U+0336 */
  0x0000, /* U+0337 */
  0x0000, /* U+0338 */
  0x0000, /* U+0339 */
  0x0000, /* U+033a */
  0x0000, /* U+033b */
  0x0000, /* U+033c */
  0x0000, /* U+033d */
  0x0000, /* U+033e */
  0x0000, /* U+033f */
  0x0000, /* U+0340 */
  0x0000, /* U+0341 */
  0x0000, /* U+0342 */
  0x0000, /* U+0343 */
  0x0000, /* U+0344 */
  0x0000, /* U+0345 */
  0x0000, /* U+0346 */
  0x0000, /* U+0347 */
  0x0000, /* U+0348 */
  0x0000, /* U+0349 */
  0x0000, /* U+034a */
  0x0000, /* U+034b */
  0x0000, /* U+034c */
  0x0000, /* U+034d */
  0x0000, /* U+034e */
  0x0000, /* U+034f */
  0x0000, /* U+0350 */
  0x0000, /* U+0351 */
  0x0000, /* U+0352 */
  0x0000, /* U+0353 */
  0x0000, /* U+0354 */
  0x0000, /* U+0355 */
  0x0000, /* U+0356 */
  0x0000, /* U+0357 */
  0x0000, /* U+0358 */
  0x0000, /* U+0359 */
  0x0000, /* U+035a */
  0x0000, /* U+035b */
  0x0000, /* U+035c */
  0x0000, /* U+035d */
  0x0000, /* U+035e */
  0x0000, /* U+035f */
  0x0000, /* U+0360 */
  0x0000, /* U+0361 */
  0x0000, /* U+0362 */
  0x0000, /* U+0363 */
  0x0000, /* U+0364 */
  0x0000, /* U+0365 */
  0x0000, /* U+0366 */
  0x0000, /* U+0367 */
  0x0000, /* U+0368 */
  0x0000, /* U+0369 */
  0x0000, /* U+036a */
  0x0000, /* U+036b */
  0x0000, /* U+036c */
  0x0000, /* U+036d */
  0x0000, /* U+036e */
  0x0000, /* U+036f */
  0x0000, /* U+0370 */
  0x0000, /* U+0371 */
  0x0000, /* U+0372 */
  0x0000, /* U+0373 */
  0x0000, /* U+0374 */
  0x0000, /* U+0375 */
  0x0000, /* U+0376 */
  0x0000, /* U+0377 */
  0x0000, /* U+0378 */
  0x0000, /* U+0379 */
  0x0000, /* U+037a */
  0x0000, /* U+037b */
  0x0000, /* U+037c */
  0x0000, /* U+037d */
  0x0000, /* U+037e */
  0x0000, /* U+037f */
  0x0000, /* U+0380 */
  0x0000, /* U+0381 */
  0x0000, /* U+0382 */
  0x0000, /* U+0383 */
  0x0000, /* U+0384 */
  0x0000, /* U+0385 */
  0x0000, /* U+0386 */
  0x0000, /* U+0387 */
  0x0000, /* U+0388 */
  0x0000, /* U+0389 */
  0x0000, /* U+038a */
  0x0000, /* U+038b */
  0x0000, /* U+038c */
  0x0000, /* U+038d */
  0x0000, /* U+038e */
  0x0000, /* U+038f */
  0x0000, /* U+0390 */
  0x839f, /* U+0391 */
  0x83a0, /* U+0392 */
  0x83a1, /* U+0393 */
  0x83a2, /* U+0394 */
  0x83a3, /* U+0395 */
  0x83a4, /* U+0396 */
  0x83a5, /* U+0397 */
  0x83a6, /* U+0398 */
  0x83a7, /* U+0399 */
  0x83a8, /* U+039a */
  0x83a9, /* U+039b */
  0x83aa, /* U+039c */
  0x83ab, /* U+039d */
  0x83ac, /* U+039e */
  0x83ad, /* U+039f */
  0x83ae, /* U+03a0 */
  0x83af, /* U+03a1 */
  0x0000, /* U+03a2 */
  0x83b0, /* U+03a3 */
  0x83b1, /* U+03a4 */
  0x83b2, /* U+03a5 */
  0x83b3, /* U+03a6 */
  0x83b4, /* U+03a7 */
  0x83b5, /* U+03a8 */
  0x83b6, /* U+03a9 */
  0x0000, /* U+03aa */
  0x0000, /* U+03ab */
  0x0000, /* U+03ac */
  0x0000, /* U+03ad */
  0x0000, /* U+03ae */
  0x0000, /* U+03af */
  0x0000, /* U+03b0 */
  0x83bf, /* U+03b1 */
  0x83c0, /* U+03b2 */
  0x83c1, /* U+03b3 */
  0x83c2, /* U+03b4 */
  0x83c3, /* U+03b5 */
  0x83c4, /* U+03b6 */
  0x83c5, /* U+03b7 */
  0x83c6, /* U+03b8 */
  0x83c7, /* U+03b9 */
  0x83c8, /* U+03ba */
  0x83c9, /* U+03bb */
  0x83ca, /* U+03bc */
  0x83cb, /* U+03bd */
  0x83cc, /* U+03be */
  0x83cd, /* U+03bf */
  0x83ce, /* U+03c0 */
  0x83cf, /* U+03c1 */
  0x0000, /* U+03c2 */
  0x83d0, /* U+03c3 */
  0x83d1, /* U+03c4 */
  0x83d2, /* U+03c5 */
  0x83d3, /* U+03c6 */
  0x83d4, /* U+03c7 */
  0x83d5, /* U+03c8 */
  0x83d6, /* U+03c9 */
  0x0000, /* U+03ca */
  0x0000, /* U+03cb */
  0x0000, /* U+03cc */
  0x0000, /* U+03cd */
  0x0000, /* U+03ce */
  0x0000, /* U+03cf */
  0x0000, /* U+03d0 */
  0x0000, /* U+03d1 */
  0x0000, /* U+03d2 */
  0x0000, /* U+03d3 */
  0x0000, /* U+03d4 */
  0x0000, /* U+03d5 */
  0x0000, /* U+03d6 */
  0x0000, /* U+03d7 */
  0x0000, /* U+03d8 */
  0x0000, /* U+03d9 */
  0x0000, /* U+03da */
  0x0000, /* U+03db */
  0x0000, /* U+03dc */
  0x0000, /* U+03dd */
  0x0000, /* U+03de */
  0x0000, /* U+03df */
  0x0000, /* U+03e0 */
  0x0000, /* U+03e1 */
  0x0000, /* U+03e2 */
  0x0000, /* U+03e3 */
  0x0000, /* U+03e4 */
  0x0000, /* U+03e5 */
  0x0000, /* U+03e6 */
  0x0000, /* U+03e7 */
  0x0000, /* U+03e8 */
  0x0000, /* U+03e9 */
  0x0000, /* U+03ea */
  0x0000, /* U+03eb */
  0x0000, /* U+03ec */
  0x0000, /* U+03ed */
  0x0000, /* U+03ee */
  0x0000, /* U+03ef */
  0x0000, /* U+03f0 */
  0x0000, /* U+03f1 */
  0x0000, /* U+03f2 */
  0x0000, /* U+03f3 */
  0x0000, /* U+03f4 */
  0x0000, /* U+03f5 */
  0x0000, /* U+03f6 */
  0x0000, /* U+03f7 */
  0x0000, /* U+03f8 */
  0x0000, /* U+03f9 */
  0x0000, /* U+03fa */
  0x0000, /* U+03fb */
  0x0000, /* U+03fc */
  0x0000, /* U+03fd */
  0x0000, /* U+03fe */
  0x0000, /* U+03ff */
  0x0000, /* U+0400 */
  0x8446, /* U+0401 */
  0x0000, /* U+0402 */
  0x0000, /* U+0403 */
  0x0000, /* U+0404 */
  0x0000, /* U+0405 */
  0x0000, /* U+0406 */
  0x0000, /* U+0407 */
  0x0000, /* U+0408 */
  0x0000, /* U+0409 */
  0x0000, /* U+040a */
  0x0000, /* U+040b */
  0x0000, /* U+040c */
  0x0000, /* U+040d */
  0x0000, /* U+040e */
  0x0000, /* U+040f */
  0x8440, /* U+0410 */
  0x8441, /* U+0411 */
  0x8442, /* U+0412 */
  0x8443, /* U+0413 */
  0x8444, /* U+0414 */
  0x8445, /* U+0415 */
  0x8447, /* U+0416 */
  0x8448, /* U+0417 */
  0x8449, /* U+0418 */
  0x844a, /* U+0419 */
  0x844b, /* U+041a */
  0x844c, /* U+041b */
  0x844d, /* U+041c */
  0x844e, /* U+041d */
  0x844f, /* U+041e */
  0x8450, /* U+041f */
  0x8451, /* U+0420 */
  0x8452, /* U+0421 */
  0x8453, /* U+0422 */
  0x8454, /* U+0423 */
  0x8455, /* U+0424 */
  0x8456, /* U+0425 */
  0x8457, /* U+0426 */
  0x8458, /* U+0427 */
  0x8459, /* U+0428 */
  0x845a, /* U+0429 */
  0x845b, /* U+042a */
  0x845c, /* U+042b */
  0x845d, /* U+042c */
  0x845e, /* U+042d */
  0x845f, /* U+042e */
  0x8460, /* U+042f */
  0x8470, /* U+0430 */
  0x8471, /* U+0431 */
  0x8472, /* U+0432 */
  0x8473, /* U+0433 */
  0x8474, /* U+0434 */
  0x8475, /* U+0435 */
  0x8477, /* U+0436 */
  0x8478, /* U+0437 */
  0x8479, /* U+0438 */
  0x847a, /* U+0439 */
  0x847b, /* U+043a */
  0x847c, /* U+043b */
  0x847d, /* U+043c */
  0x847e, /* U+043d */
  0x8480, /* U+043e */
  0x8481, /* U+043f */
  0x8482, /* U+0440 */
  0x8483, /* U+0441 */
  0x8484, /* U+0442 */
  0x8485, /* U+0443 */
  0x8486, /* U+0444 */
  0x8487, /* U+0445 */
  0x8488, /* U+0446 */
  0x8489, /* U+0447 */
  0x848a, /* U+0448 */
  0x848b, /* U+0449 */
  0x848c, /* U+044a */
  0x848d, /* U+044b */
  0x848e, /* U+044c */
  0x848f, /* U+044d */
  0x8490, /* U+044e */
  0x8491, /* U+044f */
  0x0000, /* U+0450 */
  0x8476, /* U+0451 */
  0x0000, /* U+0452 */
  0x0000, /* U+0453 */
  0x0000, /* U+0454 */
  0x0000, /* U+0455 */
  0x0000, /* U+0456 */
  0x0000, /* U+0457 */
  0x0000, /* U+0458 */
  0x0000, /* U+0459 */
  0x0000, /* U+045a */
  0x0000, /* U+045b */
  0x0000, /* U+045c */
  0x0000, /* U+045d */
  0x0000, /* U+045e */
  0x0000, /* U+045f */
  0x0000, /* U+0460 */
  0x0000, /* U+0461 */
  0x0000, /* U+0462 */
  0x0000, /* U+0463 */
  0x0000, /* U+0464 */
  0x0000, /* U+0465 */
  0x0000, /* U+0466 */
  0x0000, /* U+0467 */
  0x0000, /* U+0468 */
  0x0000, /* U+0469 */
  0x0000, /* U+046a */
  0x0000, /* U+046b */
  0x0000, /* U+046c */
  0x0000, /* U+046d */
  0x0000, /* U+046e */
  0x0000, /* U+046f */
  0x0000, /* U+0470 */
  0x0000, /* U+0471 */
  0x0000, /* U+0472 */
  0x0000, /* U+0473 */
  0x0000, /* U+0474 */
  0x0000, /* U+0475 */
  0x0000, /* U+0476 */
  0x0000, /* U+0477 */
  0x0000, /* U+0478 */
  0x0000, /* U+0479 */
  0x0000, /* U+047a */
  0x0000, /* U+047b */
  0x0000, /* U+047c */
  0x0000, /* U+047d */
  0x0000, /* U+047e */
  0x0000, /* U+047f */
  0x0000, /* U+0480 */
  0x0000, /* U+0481 */
  0x0000, /* U+0482 */
  0x0000, /* U+0483 */
  0x0000, /* U+0484 */
  0x0000, /* U+0485 */
  0x0000, /* U+0486 */
  0x0000, /* U+0487 */
  0x0000, /* U+0488 */
  0x0000, /* U+0489 */
  0x0000, /* U+048a */
  0x0000, /* U+048b */
  0x0000, /* U+048c */
  0x0000, /* U+048d */
  0x0000, /* U+048e */
  0x0000, /* U+048f */
  0x0000, /* U+0490 */
  0x0000, /* U+0491 */
  0x0000, /* U+0492 */
  0x0000, /* U+0493 */
  0x0000, /* U+0494 */
  0x0000, /* U+0495 */
  0x0000, /* U+0496 */
  0x0000, /* U+0497 */
  0x0000, /* U+0498 */
  0x0000, /* U+0499 */
  0x0000, /* U+049a */
  0x0000, /* U+049b */
  0x0000, /* U+049c */
  0x0000, /* U+049d */
  0x0000, /* U+049e */
  0x0000, /* U+049f */
  0x0000, /* U+04a0 */
  0x0000, /* U+04a1 */
  0x0000, /* U+04a2 */
  0x0000, /* U+04a3 */
  0x0000, /* U+04a4 */
  0x0000, /* U+04a5 */
  0x0000, /* U+04a6 */
  0x0000, /* U+04a7 */
  0x0000, /* U+04a8 */
  0x0000, /* U+04a9 */
  0x0000, /* U+04aa */
  0x0000, /* U+04ab */
  0x0000, /* U+04ac */
  0x0000, /* U+04ad */
  0x0000, /* U+04ae */
  0x0000, /* U+04af */
  0x0000, /* U+04b0 */
  0x0000, /* U+04b1 */
  0x0000, /* U+04b2 */
  0x0000, /* U+04b3 */
  0x0000, /* U+04b4 */
  0x0000, /* U+04b5 */
  0x0000, /* U+04b6 */
  0x0000, /* U+04b7 */
  0x0000, /* U+04b8 */
  0x0000, /* U+04b9 */
  0x0000, /* U+04ba */
  0x0000, /* U+04bb */
  0x0000, /* U+04bc */
  0x0000, /* U+04bd */
  0x0000, /* U+04be */
  0x0000, /* U+04bf */
  0x0000, /* U+04c0 */
  0x0000, /* U+04c1 */
  0x0000, /* U+04c2 */
  0x0000, /* U+04c3 */
  0x0000, /* U+04c4 */
  0x0000, /* U+04c5 */
  0x0000, /* U+04c6 */
  0x0000, /* U+04c7 */
  0x0000, /* U+04c8 */
  0x0000, /* U+04c9 */
  0x0000, /* U+04ca */
  0x0000, /* U+04cb */
  0x0000, /* U+04cc */
  0x0000, /* U+04cd */
  0x0000, /* U+04ce */
  0x0000, /* U+04cf */
  0x0000, /* U+04d0 */
  0x0000, /* U+04d1 */
  0x0000, /* U+04d2 */
  0x0000, /* U+04d3 */
  0x0000, /* U+04d4 */
  0x0000, /* U+04d5 */
  0x0000, /* U+04d6 */
  0x0000, /* U+04d7 */
  0x0000, /* U+04d8 */
  0x0000, /* U+04d9 */
  0x0000, /* U+04da */
  0x0000, /* U+04db */
  0x0000, /* U+04dc */
  0x0000, /* U+04dd */
  0x0000, /* U+04de */
  0x0000, /* U+04df */
  0x0000, /* U+04e0 */
  0x0000, /* U+04e1 */
  0x0000, /* U+04e2 */
  0x0000, /* U+04e3 */
  0x0000, /* U+04e4 */
  0x0000, /* U+04e5 */
  0x0000, /* U+04e6 */
  0x0000, /* U+04e7 */
  0x0000, /* U+04e8 */
  0x0000, /* U+04e9 */
  0x0000, /* U+04ea */
  0x0000, /* U+04eb */
  0x0000, /* U+04ec */
  0x0000, /* U+04ed */
  0x0000, /* U+04ee */
  0x0000, /* U+04ef */
  0x0000, /* U+04f0 */
  0x0000, /* U+04f1 */
  0x0000, /* U+04f2 */
  0x0000, /* U+04f3 */
  0x0000, /* U+04f4 */
  0x0000, /* U+04f5 */
  0x0000, /* U+04f6 */
  0x0000, /* U+04f7 */
  0x0000, /* U+04f8 */
  0x0000, /* U+04f9 */
  0x0000, /* U+04fa */
  0x0000, /* U+04fb */
  0x0000, /* U+04fc */
  0x0000, /* U+04fd */
  0x0000, /* U+04fe */
  0x0000, /* U+04ff */
  0x0000, /* U+0500 */
  0x0000, /* U+0501 */
  0x0000, /* U+0502 */
  0x0000, /* U+0503 */
  0x0000, /* U+0504 */
  0x0000, /* U+0505 */
  0x0000, /* U+0506 */
  0x0000, /* U+0507 */
  0x0000, /* U+0508 */
  0x0000, /* U+0509 */
  0x0000, /* U+050a */
  0x0000, /* U+050b */
  0x0000, /* U+050c */
  0x0000, /* U+050d */
  0x0000, /* U+050e */
  0x0000, /* U+050f */
  0x0000, /* U+0510 */
  0x0000, /* U+0511 */
  0x0000, /* U+0512 */
  0x0000, /* U+0513 */
  0x0000, /* U+0514 */
  0x0000, /* U+0515 */
  0x0000, /* U+0516 */
  0x0000, /* U+0517 */
  0x0000, /* U+0518 */
  0x0000, /* U+0519 */
  0x0000, /* U+051a */
  0x0000, /* U+051b */
  0x0000, /* U+051c */
  0x0000, /* U+051d */
  0x0000, /* U+051e */
  0x0000, /* U+051f */
  0x0000, /* U+0520 */
  0x0000, /* U+0521 */
  0x0000, /* U+0522 */
  0x0000, /* U+0523 */
  0x0000, /* U+0524 */
  0x0000, /* U+0525 */
  0x0000, /* U+0526 */
  0x0000, /* U+0527 */
  0x0000, /* U+0528 */
  0x0000, /* U+0529 */
  0x0000, /* U+052a */
  0x0000, /* U+052b */
  0x0000, /* U+052c */
  0x0000, /* U+052d */
  0x0000, /* U+052e */
  0x0000, /* U+052f */
  0x0000, /* U+0530 */
  0x0000, /* U+0531 */
  0x0000, /* U+0532 */
  0x0000, /* U+0533 */
  0x0000, /* U+0534 */
  0x0000, /* U+0535 */
  0x0000, /* U+0536 */
  0x0000, /* U+0537 */
  0x0000, /* U+0538 */
  0x0000, /* U+0539 */
  0x0000, /* U+053a */
  0x0000, /* U+053b */
  0x0000, /* U+053c */
  0x0000, /* U+053d */
  0x0000, /* U+053e */
  0x0000, /* U+053f */
  0x0000, /* U+0540 */
  0x0000, /* U+0541 */
  0x0000, /* U+0542 */
  0x0000, /* U+0543 */
  0x0000, /* U+0544 */
  0x0000, /* U+0545 */
  0x0000, /* U+0546 */
  0x0000, /* U+0547 */
  0x0000, /* U+0548 */
  0x0000, /* U+0549 */
  0x0000, /* U+054a */
  0x0000, /* U+054b */
  0x0000, /* U+054c */
  0x0000, /* U+054d */
  0x0000, /* U+054e */
  0x0000, /* U+054f */
  0x0000, /* U+0550 */
  0x0000, /* U+0551 */
  0x0000, /* U+0552 */
  0x0000, /* U+0553 */
  0x0000, /* U+0554 */
  0x0000, /* U+0555 */
  0x0000, /* U+0556 */
  0x0000, /* U+0557 */
  0x0000, /* U+0558 */
  0x0000, /* U+0559 */
  0x0000, /* U+055a */
  0x0000, /* U+055b */
  0x0000, /* U+055c */
  0x0000, /* U+055d */
  0x0000, /* U+055e */
  0x0000, /* U+055f */
  0x0000, /* U+0560 */
  0x0000, /* U+0561 */
  0x0000, /* U+0562 */
  0x0000, /* U+0563 */
  0x0000, /* U+0564 */
  0x0000, /* U+0565 */
  0x0000, /* U+0566 */
  0x0000, /* U+0567 */
  0x0000, /* U+0568 */
  0x0000, /* U+0569 */
  0x0000, /* U+056a */
  0x0000, /* U+056b */
  0x0000, /* U+056c */
  0x0000, /* U+056d */
  0x0000, /* U+056e */
  0x0000, /* U+056f */
  0x0000, /* U+0570 */
  0x0000, /* U+0571 */
  0x0000, /* U+0572 */
  0x0000, /* U+0573 */
  0x0000, /* U+0574 */
  0x0000, /* U+0575 */
  0x0000, /* U+0576 */
  0x0000, /* U+0577 */
  0x0000, /* U+0578 */
  0x0000, /* U+0579 */
  0x0000, /* U+057a */
  0x0000, /* U+057b */
  0x0000, /* U+057c */
  0x0000, /* U+057d */
  0x0000, /* U+057e */
  0x0000, /* U+057f */
  0x0000, /* U+0580 */
  0x0000, /* U+0581 */
  0x0000, /* U+0582 */
  0x0000, /* U+0583 */
  0x0000, /* U+0584 */
  0x0000, /* U+0585 */
  0x0000, /* U+0586 */
  0x0000, /* U+0587 */
  0x0000, /* U+0588 */
  0x0000, /* U+0589 */
  0x0000, /* U+058a */
  0x0000, /* U+058b */
  0x0000, /* U+058c */
  0x0000, /* U+058d */
  0x0000, /* U+058e */
  0x0000, /* U+058f */
  0x0000, /* U+0590 */
  0x0000, /* U+0591 */
  0x0000, /* U+0592 */
  0x0000, /* U+0593 */
  0x0000, /* U+0594 */
  0x0000, /* U+0595 */
  0x0000, /* U+0596 */
  0x0000, /* U+0597 */
  0x0000, /* U+0598 */
  0x0000, /* U+0599 */
  0x0000, /* U+059a */
  0x0000, /* U+059b */
  0x0000, /* U+059c */
  0x0000, /* U+059d */
  0x0000, /* U+059e */
  0x0000, /* U+059f */
  0x0000, /* U+05a0 */
  0x0000, /* U+05a1 */
  0x0000, /* U+05a2 */
  0x0000, /* U+05a3 */
  0x0000, /* U+05a4 */
  0x0000, /* U+05a5 */
  0x0000, /* U+05a6 */
  0x0000, /* U+05a7 */
  0x0000, /* U+05a8 */
  0x0000, /* U+05a9 */
  0x0000, /* U+05aa */
  0x0000, /* U+05ab */
  0x0000, /* U+05ac */
  0x0000, /* U+05ad */
  0x0000, /* U+05ae */
  0x0000, /* U+05af */
  0x0000, /* U+05b0 */
  0x0000, /* U+05b1 */
  0x0000, /* U+05b2 */
  0x0000, /* U+05b3 */
  0x0000, /* U+05b4 */
  0x0000, /* U+05b5 */
  0x0000, /* U+05b6 */
  0x0000, /* U+05b7 */
  0x0000, /* U+05b8 */
  0x0000, /* U+05b9 */
  0x0000, /* U+05ba */
  0x0000, /* U+05bb */
  0x0000, /* U+05bc */
  0x0000, /* U+05bd */
  0x0000, /* U+05be */
  0x0000, /* U+05bf */
  0x0000, /* U+05c0 */
  0x0000, /* U+05c1 */
  0x0000, /* U+05c2 */
  0x0000, /* U+05c3 */
  0x0000, /* U+05c4 */
  0x0000, /* U+05c5 */
  0x0000, /* U+05c6 */
  0x0000, /* U+05c7 */
  0x0000, /* U+05c8 */
  0x0000, /* U+05c9 */
  0x0000, /* U+05ca */
  0x0000, /* U+05cb */
  0x0000, /* U+05cc */
  0x0000, /* U+05cd */
  0x0000, /* U+05ce */
  0x0000, /* U+05cf */
  0x0000, /* U+05d0 */
  0x0000, /* U+05d1 */
  0x0000, /* U+05d2 */
  0x0000, /* U+05d3 */
  0x0000, /* U+05d4 */
  0x0000, /* U+05d5 */
  0x0000, /* U+05d6 */
  0x0000, /* U+05d7 */
  0x0000, /* U+05d8 */
  0x0000, /* U+05d9 */
  0x0000, /* U+05da */
  0x0000, /* U+05db */
  0x0000, /* U+05dc */
  0x0000, /* U+05dd */
  0x0000, /* U+05de */
  0x0000, /* U+05df */
  0x0000, /* U+05e0 */
  0x0000, /* U+05e1 */
  0x0000, /* U+05e2 */
  0x0000, /* U+05e3 */
  0x0000, /* U+05e4 */
  0x0000, /* U+05e5 */
  0x0000, /* U+05e6 */
  0x0000, /* U+05e7 */
  0x0000, /* U+05e8 */
  0x0000, /* U+05e9 */
  0x0000, /* U+05ea */
  0x0000, /* U+05eb */
  0x0000, /* U+05ec */
  0x0000, /* U+05ed */
  0x0000, /* U+05ee */
  0x0000, /* U+05ef */
  0x0000, /* U+05f0 */
  0x0000, /* U+05f1 */
  0x0000, /* U+05f2 */
  0x0000, /* U+05f3 */
  0x0000, /* U+05f4 */
  0x0000, /* U+05f5 */
  0x0000, /* U+05f6 */
  0x0000, /* U+05f7 */
  0x0000, /* U+05f8 */
  0x0000, /* U+05f9 */
  0x0000, /* U+05fa */
  0x0000, /* U+05fb */
  0x0000, /* U+05fc */
  0x0000, /* U+05fd */
  0x0000, /* U+05fe */
  0x0000, /* U+05ff */
  0x0000, /* U+0600 */
  0x0000, /* U+0601 */
  0x0000, /* U+0602 */
  0x0000, /* U+0603 */
  0x0000, /* U+0604 */
  0x0000, /* U+0605 */
  0x0000, /* U+0606 */
  0x0000, /* U+0607 */
  0x0000, /* U+0608 */
  0x0000, /* U+0609 */
  0x0000, /* U+060a */
  0x0000, /* U+060b */
  0x0000, /* U+060c */
  0x0000, /* U+060d */
  0x0000, /* U+060e */
  0x0000, /* U+060f */
  0x0000, /* U+0610 */
  0x0000, /* U+0611 */
  0x0000, /* U+0612 */
  0x0000, /* U+0613 */
  0x0000, /* U+0614 */
  0x0000, /* U+0615 */
  0x0000, /* U+0616 */
  0x0000, /* U+0617 */
  0x0000, /* U+0618 */
  0x0000, /* U+0619 */
  0x0000, /* U+061a */
  0x0000, /* U+061b */
  0x0000, /* U+061c */
  0x0000, /* U+061d */
  0x0000, /* U+061e */
  0x0000, /* U+061f */
  0x0000, /* U+0620 */
  0x0000, /* U+0621 */
  0x0000, /* U+0622 */
  0x0000, /* U+0623 */
  0x0000, /* U+0624 */
  0x0000, /* U+0625 */
  0x0000, /* U+0626 */
  0x0000, /* U+0627 */
  0x0000, /* U+0628 */
  0x0000, /* U+0629 */
  0x0000, /* U+062a */
  0x0000, /* U+062b */
  0x0000, /* U+062c */
  0x0000, /* U+062d */
  0x0000, /* U+062e */
  0x0000, /* U+062f */
  0x0000, /* U+0630 */
  0x0000, /* U+0631 */
  0x0000, /* U+0632 */
  0x0000, /* U+0633 */
  0x0000, /* U+0634 */
  0x0000, /* U+0635 */
  0x0000, /* U+0636 */
  0x0000, /* U+0637 */
  0x0000, /* U+0638 */
  0x0000, /* U+0639 */
  0x0000, /* U+063a */
  0x0000, /* U+063b */
  0x0000, /* U+063c */
  0x0000, /* U+063d */
  0x0000, /* U+063e */
  0x0000, /* U+063f */
  0x0000, /* U+0640 */
  0x0000, /* U+0641 */
  0x0000, /* U+0642 */
  0x0000, /* U+0643 */
  0x0000, /* U+0644 */
  0x0000, /* U+0645 */
  0x0000, /* U+0646 */
  0x0000, /* U+0647 */
  0x0000, /* U+0648 */
  0x0000, /* U+0649 */
  0x0000, /* U+064a */
  0x0000, /* U+064b */
  0x0000, /* U+064c */
  0x0000, /* U+064d */
  0x0000, /* U+064e */
  0x0000, /* U+064f */
  0x0000, /* U+0650 */
  0x0000, /* U+0651 */
  0x0000, /* U+0652 */
  0x0000, /* U+0653 */
  0x0000, /* U+0654 */
  0x0000, /* U+0655 */
  0x0000, /* U+0656 */
  0x0000, /* U+0657 */
  0x0000, /* U+0658 */
  0x0000, /* U+0659 */
  0x0000, /* U+065a */
  0x0000, /* U+065b */
  0x0000, /* U+065c */
  0x0000, /* U+065d */
  0x0000, /* U+065e */
  0x0000, /* U+065f */
  0x0000, /* U+0660 */
  0x0000, /* U+0661 */
  0x0000, /* U+0662 */
  0x0000, /* U+0663 */
  0x0000, /* U+0664 */
  0x0000, /* U+0665 */
  0x0000, /* U+0666 */
  0x0000, /* U+0667 */
  0x0000, /* U+0668 */
  0x0000, /* U+0669 */
  0x0000, /* U+066a */
  0x0000, /* U+066b */
  0x0000, /* U+066c */
  0x0000, /* U+066d */
  0x0000, /* U+066e */
  0x0000, /* U+066f */
  0x0000, /* U+0670 */
  0x0000, /* U+0671 */
  0x0000, /* U+0672 */
  0x0000, /* U+0673 */
  0x0000, /* U+0674 */
  0x0000, /* U+0675 */
  0x0000, /* U+0676 */
  0x0000, /* U+0677 */
  0x0000, /* U+0678 */
  0x0000, /* U+0679 */
  0x0000, /* U+067a */
  0x0000, /* U+067b */
  0x0000, /* U+067c */
  0x0000, /* U+067d */
  0x0000, /* U+067e */
  0x0000, /* U+067f */
  0x0000, /* U+0680 */
  0x0000, /* U+0681 */
  0x0000, /* U+0682 */
  0x0000, /* U+0683 */
  0x0000, /* U+0684 */
  0x0000, /* U+0685 */
  0x0000, /* U+0686 */
  0x0000, /* U+0687 */
  0x0000, /* U+0688 */
  0x0000, /* U+0689 */
  0x0000, /* U+068a */
  0x0000, /* U+068b */
  0x0000, /* U+068c */
  0x0000, /* U+068d */
  0x0000, /* U+068e */
  0x0000, /* U+068f */
  0x0000, /* U+0690 */
  0x0000, /* U+0691 */
  0x0000, /* U+0692 */
  0x0000, /* U+0693 */
  0x0000, /* U+0694 */
  0x0000, /* U+0695 */
  0x0000, /* U+0696 */
  0x0000, /* U+0697 */
  0x0000, /* U+0698 */
  0x0000, /* U+0699 */
  0x0000, /* U+069a */
  0x0000, /* U+069b */
  0x0000, /* U+069c */
  0x0000, /* U+069d */
  0x0000, /* U+069e */
  0x0000, /* U+069f */
  0x0000, /* U+06a0 */
  0x0000, /* U+06a1 */
  0x0000, /* U+06a2 */
  0x0000, /* U+06a3 */
  0x0000, /* U+06a4 */
  0x0000, /* U+06a5 */
  0x0000, /* U+06a6 */
  0x0000, /* U+06a7 */
  0x0000, /* U+06a8 */
  0x0000, /* U+06a9 */
  0x0000, /* U+06aa */
  0x0000, /* U+06ab */
  0x0000, /* U+06ac */
  0x0000, /* U+06ad */
  0x0000, /* U+06ae */
  0x0000, /* U+06af */
  0x0000, /* U+06b0 */
  0x0000, /* U+06b1 */
  0x0000, /* U+06b2 */
  0x0000, /* U+06b3 */
  0x0000, /* U+06b4 */
  0x0000, /* U+06b5 */
  0x0000, /* U+06b6 */
  0x0000, /* U+06b7 */
  0x0000, /* U+06b8 */
  0x0000, /* U+06b9 */
  0x0000, /* U+06ba */
  0x0000, /* U+06bb */
  0x0000, /* U+06bc */
  0x0000, /* U+06bd */
  0x0000, /* U+06be */
  0x0000, /* U+06bf */
  0x0000, /* U+06c0 */
  0x0000, /* U+06c1 */
  0x0000, /* U+06c2 */
  0x0000, /* U+06c3 */
  0x0000, /* U+06c4 */
  0x0000, /* U+06c5 */
  0x0000, /* U+06c6 */
  0x0000, /* U+06c7 */
  0x0000, /* U+06c8 */
  0x0000, /* U+06c9 */
  0x0000, /* U+06ca */
  0x0000, /* U+06cb */
  0x0000, /* U+06cc */
  0x0000, /* U+06cd */
  0x0000, /* U+06ce */
  0x0000, /* U+06cf */
  0x0000, /* U+06d0 */
  0x0000, /* U+06d1 */
  0x0000, /* U+06d2 */
  0x0000, /* U+06d3 */
  0x0000, /* U+06d4 */
  0x0000, /* U+06d5 */
  0x0000, /* U+06d6 */
  0x0000, /* U+06d7 */
  0x0000, /* U+06d8 */
  0x0000, /* U+06d9 */
  0x0000, /* U+06da */
  0x0000, /* U+06db */
  0x0000, /* U+06dc */
  0x0000, /* U+06dd */
  0x0000, /* U+06de */
  0x0000, /* U+06df */
  0x0000, /* U+06e0 */
  0x0000, /* U+06e1 */
  0x0000, /* U+06e2 */
  0x0000, /* U+06e3 */
  0x0000, /* U+06e4 */
  0x0000, /* U+06e5 */
  0x0000, /* U+06e6 */
  0x0000, /* U+06e7 */
  0x0000, /* U+06e8 */
  0x0000, /* U+06e9 */
  0x0000, /* U+06ea */
  0x0000, /* U+06eb */
  0x0000, /* U+06ec */
  0x0000, /* U+06ed */
  0x0000, /* U+06ee */
  0x0000, /* U+06ef */
  0x0000, /* U+06f0 */
  0x0000, /* U+06f1 */
  0x0000, /* U+06f2 */
  0x0000, /* U+06f3 */
  0x0000, /* U+06f4 */
  0x0000, /* U+06f5 */
  0x0000, /* U+06f6 */
  0x0000, /* U+06f7 */
  0x0000, /* U+06f8 */
  0x0000, /* U+06f9 */
  0x0000, /* U+06fa */
  0x0000, /* U+06fb */
  0x0000, /* U+06fc */
  0x0000, /* U+06fd */
  0x0000, /* U+06fe */
  0x0000, /* U+06ff */
  0x0000, /* U+0700 */
  0x0000, /* U+0701 */
  0x0000, /* U+0702 */
  0x0000, /* U+0703 */
  0x0000, /* U+0704 */
  0x0000, /* U+0705 */
  0x0000, /* U+0706 */
  0x0000, /* U+0707 */
  0x0000, /* U+0708 */
  0x0000, /* U+0709 */
  0x0000, /* U+070a */
  0x0000, /* U+070b */
  0x0000, /* U+070c */
  0x0000, /* U+070d */
  0x0000, /* U+070e */
  0x0000, /* U+070f */
  0x0000, /* U+0710 */
  0x0000, /* U+0711 */
  0x0000, /* U+0712 */
  0x0000, /* U+0713 */
  0x0000, /* U+0714 */
  0x0000, /* U+0715 */
  0x0000, /* U+0716 */
  0x0000, /* U+0717 */
  0x0000, /* U+0718 */
  0x0000, /* U+0719 */
  0x0000, /* U+071a */
  0x0000, /* U+071b */
  0x0000, /* U+071c */
  0x0000, /* U+071d */
  0x0000, /* U+071e */
  0x0000, /* U+071f */
  0x0000, /* U+0720 */
  0x0000, /* U+0721 */
  0x0000, /* U+0722 */
  0x0000, /* U+0723 */
  0x0000, /* U+0724 */
  0x0000, /* U+0725 */
  0x0000, /* U+0726 */
  0x0000, /* U+0727 */
  0x0000, /* U+0728 */
  0x0000, /* U+0729 */
  0x0000, /* U+072a */
  0x0000, /* U+072b */
  0x0000, /* U+072c */
  0x0000, /* U+072d */
  0x0000, /* U+072e */
  0x0000, /* U+072f */
  0x0000, /* U+0730 */
  0x0000, /* U+0731 */
  0x0000, /* U+0732 */
  0x0000, /* U+0733 */
  0x0000, /* U+0734 */
  0x0000, /* U+0735 */
  0x0000, /* U+0736 */
  0x0000, /* U+0737 */
  0x0000, /* U+0738 */
  0x0000, /* U+0739 */
  0x0000, /* U+073a */
  0x0000, /* U+073b */
  0x0000, /* U+073c */
  0x0000, /* U+073d */
  0x0000, /* U+073e */
  0x0000, /* U+073f */
  0x0000, /* U+0740 */
  0x0000, /* U+0741 */
  0x0000, /* U+0742 */
  0x0000, /* U+0743 */
  0x0000, /* U+0744 */
  0x0000, /* U+0745 */
  0x0000, /* U+0746 */
  0x0000, /* U+0747 */
  0x0000, /* U+0748 */
  0x0000, /* U+0749 */
  0x0000, /* U+074a */
  0x0000, /* U+074b */
  0x0000, /* U+074c */
  0x0000, /* U+074d */
  0x0000, /* U+074e */
  0x0000, /* U+074f */
  0x0000, /* U+0750 */
  0x0000, /* U+0751 */
  0x0000, /* U+0752 */
  0x0000, /* U+0753 */
  0x0000, /* U+0754 */
  0x0000, /* U+0755 */
  0x0000, /* U+0756 */
  0x0000, /* U+0757 */
  0x0000, /* U+0758 */
  0x0000, /* U+0759 */
  0x0000, /* U+075a */
  0x0000, /* U+075b */
  0x0000, /* U+075c */
  0x0000, /* U+075d */
  0x0000, /* U+075e */
  0x0000, /* U+075f */
  0x0000, /* U+0760 */
  0x0000, /* U+0761 */
  0x0000, /* U+0762 */
  0x0000, /* U+0763 */
  0x0000, /* U+0764 */
  0x0000, /* U+0765 */
  0x0000, /* U+0766 */
  0x0000, /* U+0767 */
  0x0000, /* U+0768 */
  0x0000, /* U+0769 */
  0x0000, /* U+076a */
  0x0000, /* U+076b */
  0x0000, /* U+076c */
  0x0000, /* U+076d */
  0x0000, /* U+076e */
  0x0000, /* U+076f */
  0x0000, /* U+0770 */
  0x0000, /* U+0771 */
  0x0000, /* U+0772 */
  0x0000, /* U+0773 */
  0x0000, /* U+0774 */
  0x0000, /* U+0775 */
  0x0000, /* U+0776 */
  0x0000, /* U+0777 */
  0x0000, /* U+0778 */
  0x0000, /* U+0779 */
  0x0000, /* U+077a */
  0x0000, /* U+077b */
  0x0000, /* U+077c */
  0x0000, /* U+077d */
  0x0000, /* U+077e */
  0x0000, /* U+077f */
  0x0000, /* U+0780 */
  0x0000, /* U+0781 */
  0x0000, /* U+0782 */
  0x0000, /* U+0783 */
  0x0000, /* U+0784 */
  0x0000, /* U+0785 */
  0x0000, /* U+0786 */
  0x0000, /* U+0787 */
  0x0000, /* U+0788 */
  0x0000, /* U+0789 */
  0x0000, /* U+078a */
  0x0000, /* U+078b */
  0x0000, /* U+078c */
  0x0000, /* U+078d */
  0x0000, /* U+078e */
  0x0000, /* U+078f */
  0x0000, /* U+0790 */
  0x0000, /* U+0791 */
  0x0000, /* U+0792 */
  0x0000, /* U+0793 */
  0x0000, /* U+0794 */
  0x0000, /* U+0795 */
  0x0000, /* U+0796 */
  0x0000, /* U+0797 */
  0x0000, /* U+0798 */
  0x0000, /* U+0799 */
  0x0000, /* U+079a */
  0x0000, /* U+079b */
  0x0000, /* U+079c */
  0x0000, /* U+079d */
  0x0000, /* U+079e */
  0x0000, /* U+079f */
  0x0000, /* U+07a0 */
  0x0000, /* U+07a1 */
  0x0000, /* U+07a2 */
  0x0000, /* U+07a3 */
  0x0000, /* U+07a4 */
  0x0000, /* U+07a5 */
  0x0000, /* U+07a6 */
  0x0000, /* U+07a7 */
  0x0000, /* U+07a8 */
  0x0000, /* U+07a9 */
  0x0000, /* U+07aa */
  0x0000, /* U+07ab */
  0x0000, /* U+07ac */
  0x0000, /* U+07ad */
  0x0000, /* U+07ae */
  0x0000, /* U+07af */
  0x0000, /* U+07b0 */
  0x0000, /* U+07b1 */
  0x0000, /* U+07b2 */
  0x0000, /* U+07b3 */
  0x0000, /* U+07b4 */
  0x0000, /* U+07b5 */
  0x0000, /* U+07b6 */
  0x0000, /* U+07b7 */
  0x0000, /* U+07b8 */
  0x0000, /* U+07b9 */
  0x0000, /* U+07ba */
  0x0000, /* U+07bb */
  0x0000, /* U+07bc */
  0x0000, /* U+07bd */
  0x0000, /* U+07be */
  0x0000, /* U+07bf */
  0x0000, /* U+07c0 */
  0x0000, /* U+07c1 */
  0x0000, /* U+07c2 */
  0x0000, /* U+07c3 */
  0x0000, /* U+07c4 */
  0x0000, /* U+07c5 */
  0x0000, /* U+07c6 */
  0x0000, /* U+07c7 */
  0x0000, /* U+07c8 */
  0x0000, /* U+07c9 */
  0x0000, /* U+07ca */
  0x0000, /* U+07cb */
  0x0000, /* U+07cc */
  0x0000, /* U+07cd */
  0x0000, /* U+07ce */
  0x0000, /* U+07cf */
  0x0000, /* U+07d0 */
  0x0000, /* U+07d1 */
  0x0000, /* U+07d2 */
  0x0000, /* U+07d3 */
  0x0000, /* U+07d4 */
  0x0000, /* U+07d5 */
  0x0000, /* U+07d6 */
  0x0000, /* U+07d7 */
  0x0000, /* U+07d8 */
  0x0000, /* U+07d9 */
  0x0000, /* U+07da */
  0x0000, /* U+07db */
  0x0000, /* U+07dc */
  0x0000, /* U+07dd */
  0x0000, /* U+07de */
  0x0000, /* U+07df */
  0x0000, /* U+07e0 */
  0x0000, /* U+07e1 */
  0x0000, /* U+07e2 */
  0x0000, /* U+07e3 */
  0x0000, /* U+07e4 */
  0x0000, /* U+07e5 */
  0x0000, /* U+07e6 */
  0x0000, /* U+07e7 */
  0x0000, /* U+07e8 */
  0x0000, /* U+07e9 */
  0x0000, /* U+07ea */
  0x0000, /* U+07eb */
  0x0000, /* U+07ec */
  0x0000, /* U+07ed */
  0x0000, /* U+07ee */
  0x0000, /* U+07ef */
  0x0000, /* U+07f0 */
  0x0000, /* U+07f1 */
  0x0000, /* U+07f2 */
  0x0000, /* U+07f3 */
  0x0000, /* U+07f4 */
  0x0000, /* U+07f5 */
  0x0000, /* U+07f6 */
  0x0000, /* U+07f7 */
  0x0000, /* U+07f8 */
  0x0000, /* U+07f9 */
  0x0000, /* U+07fa */
  0x0000, /* U+07fb */
  0x0000, /* U+07fc */
  0x0000, /* U+07fd */
  0x0000, /* U+07fe */
  0x0000, /* U+07ff */
  0x0000, /* U+0800 */
  0x0000, /* U+0801 */
  0x0000, /* U+0802 */
  0x0000, /* U+0803 */
  0x0000, /* U+0804 */
  0x0000, /* U+0805 */
  0x0000, /* U+0806 */
  0x0000, /* U+0807 */
  0x0000, /* U+0808 */
  0x0000, /* U+0809 */
  0x0000, /* U+080a */
  0x0000, /* U+080b */
  0x0000, /* U+080c */
  0x0000, /* U+080d */
  0x0000, /* U+080e */
  0x0000, /* U+080f */
  0x0000, /* U+0810 */
  0x0000, /* U+0811 */
  0x0000, /* U+0812 */
  0x0000, /* U+0813 */
  0x0000, /* U+0814 */
  0x0000, /* U+0815 */
  0x0000, /* U+0816 */
  0x0000, /* U+0817 */
  0x0000, /* U+0818 */
  0x0000, /* U+0819 */
  0x0000, /* U+081a */
  0x0000, /* U+081b */
  0x0000, /* U+081c */
  0x0000, /* U+081d */
  0x0000, /* U+081e */
  0x0000, /* U+081f */
  0x0000, /* U+0820 */
  0x0000, /* U+0821 */
  0x0000, /* U+0822 */
  0x0000, /* U+0823 */
  0x0000, /* U+0824 */
  0x0000, /* U+0825 */
  0x0000, /* U+0826 */
  0x0000, /* U+0827 */
  0x0000, /* U+0828 */
  0x0000, /* U+0829 */
  0x0000, /* U+082a */
  0x0000, /* U+082b */
  0x0000, /* U+082c */
  0x0000, /* U+082d */
  0x0000, /* U+082e */
  0x0000, /* U+082f */
  0x0000, /* U+0830 */
  0x0000, /* U+0831 */
  0x0000, /* U+0832 */
  0x0000, /* U+0833 */
  0x0000, /* U+0834 */
  0x0000, /* U+0835 */
  0x0000, /* U+0836 */
  0x0000, /* U+0837 */
  0x0000, /* U+0838 */
  0x0000, /* U+0839 */
  0x0000, /* U+083a */
  0x0000, /* U+083b */
  0x0000, /* U+083c */
  0x0000, /* U+083d */
  0x0000, /* U+083e */
  0x0000, /* U+083f */
  0x0000, /* U+0840 */
  0x0000, /* U+0841 */
  0x0000, /* U+0842 */
  0x0000, /* U+0843 */
  0x0000, /* U+0844 */
  0x0000, /* U+0845 */
  0x0000, /* U+0846 */
  0x0000, /* U+0847 */
  0x0000, /* U+0848 */
  0x0000, /* U+0849 */
  0x0000, /* U+084a */
  0x0000, /* U+084b */
  0x0000, /* U+084c */
  0x0000, /* U+084d */
  0x0000, /* U+084e */
  0x0000, /* U+084f */
  0x0000, /* U+0850 */
  0x0000, /* U+0851 */
  0x0000, /* U+0852 */
  0x0000, /* U+0853 */
  0x0000, /* U+0854 */
  0x0000, /* U+0855 */
  0x0000, /* U+0856 */
  0x0000, /* U+0857 */
  0x0000, /* U+0858 */
  0x0000, /* U+0859 */
  0x0000, /* U+085a */
  0x0000, /* U+085b */
  0x0000, /* U+085c */
  0x0000, /* U+085d */
  0x0000, /* U+085e */
  0x0000, /* U+085f */
  0x0000, /* U+0860 */
  0x0000, /* U+0861 */
  0x0000, /* U+0862 */
  0x0000, /* U+0863 */
  0x0000, /* U+0864 */
  0x0000, /* U+0865 */
  0x0000, /* U+0866 */
  0x0000, /* U+0867 */
  0x0000, /* U+0868 */
  0x0000, /* U+0869 */
  0x0000, /* U+086a */
  0x0000, /* U+086b */
  0x0000, /* U+086c */
  0x0000, /* U+086d */
  0x0000, /* U+086e */
  0x0000, /* U+086f */
  0x0000, /* U+0870 */
  0x0000, /* U+0871 */
  0x0000, /* U+0872 */
  0x0000, /* U+0873 */
  0x0000, /* U+0874 */
  0x0000, /* U+0875 */
  0x0000, /* U+0876 */
  0x0000, /* U+0877 */
  0x0000, /* U+0878 */
  0x0000, /* U+0879 */
  0x0000, /* U+087a */
  0x0000, /* U+087b */
  0x0000, /* U+087c */
  0x0000, /* U+087d */
  0x0000, /* U+087e */
  0x0000, /* U+087f */
  0x0000, /* U+0880 */
  0x0000, /* U+0881 */
  0x0000, /* U+0882 */
  0x0000, /* U+0883 */
  0x0000, /* U+0884 */
  0x0000, /* U+0885 */
  0x0000, /* U+0886 */
  0x0000, /* U+0887 */
  0x0000, /* U+0888 */
  0x0000, /* U+0889 */
  0x0000, /* U+088a */
  0x0000, /* U+088b */
  0x0000, /* U+088c */
  0x0000, /* U+088d */
  0x0000, /* U+088e */
  0x0000, /* U+088f */
  0x0000, /* U+0890 */
  0x0000, /* U+0891 */
  0x0000, /* U+0892 */
  0x0000, /* U+0893 */
  0x0000, /* U+0894 */
  0x0000, /* U+0895 */
  0x0000, /* U+0896 */
  0x0000, /* U+0897 */
  0x0000, /* U+0898 */
  0x0000, /* U+0899 */
  0x0000, /* U+089a */
  0x0000, /* U+089b */
  0x0000, /* U+089c */
  0x0000, /* U+089d */
  0x0000, /* U+089e */
  0x0000, /* U+089f */
  0x0000, /* U+08a0 */
  0x0000, /* U+08a1 */
  0x0000, /* U+08a2 */
  0x0000, /* U+08a3 */
  0x0000, /* U+08a4 */
  0x0000, /* U+08a5 */
  0x0000, /* U+08a6 */
  0x0000, /* U+08a7 */
  0x0000, /* U+08a8 */
  0x0000, /* U+08a9 */
  0x0000, /* U+08aa */
  0x0000, /* U+08ab */
  0x0000, /* U+08ac */
  0x0000, /* U+08ad */
  0x0000, /* U+08ae */
  0x0000, /* U+08af */
  0x0000, /* U+08b0 */
  0x0000, /* U+08b1 */
  0x0000, /* U+08b2 */
  0x0000, /* U+08b3 */
  0x0000, /* U+08b4 */
  0x0000, /* U+08b5 */
  0x0000, /* U+08b6 */
  0x0000, /* U+08b7 */
  0x0000, /* U+08b8 */
  0x0000, /* U+08b9 */
  0x0000, /* U+08ba */
  0x0000, /* U+08bb */
  0x0000, /* U+08bc */
  0x0000, /* U+08bd */
  0x0000, /* U+08be */
  0x0000, /* U+08bf */
  0x0000, /* U+08c0 */
  0x0000, /* U+08c1 */
  0x0000, /* U+08c2 */
  0x0000, /* U+08c3 */
  0x0000, /* U+08c4 */
  0x0000, /* U+08c5 */
  0x0000, /* U+08c6 */
  0x0000, /* U+08c7 */
  0x0000, /* U+08c8 */
  0x0000, /* U+08c9 */
  0x0000, /* U+08ca */
  0x0000, /* U+08cb */
  0x0000, /* U+08cc */
  0x0000, /* U+08cd */
  0x0000, /* U+08ce */
  0x0000, /* U+08cf */
  0x0000, /* U+08d0 */
  0x0000, /* U+08d1 */
  0x0000, /* U+08d2 */
  0x0000, /* U+08d3 */
  0x0000, /* U+08d4 */
  0x0000, /* U+08d5 */
  0x0000, /* U+08d6 */
  0x0000, /* U+08d7 */
  0x0000, /* U+08d8 */
  0x0000, /* U+08d9 */
  0x0000, /* U+08da */
  0x0000, /* U+08db */
  0x0000, /* U+08dc */
  0x0000, /* U+08dd */
  0x0000, /* U+08de */
  0x0000, /* U+08df */
  0x0000, /* U+08e0 */
  0x0000, /* U+08e1 */
  0x0000, /* U+08e2 */
  0x0000, /* U+08e3 */
  0x0000, /* U+08e4 */
  0x0000, /* U+08e5 */
  0x0000, /* U+08e6 */
  0x0000, /* U+08e7 */
  0x0000, /* U+08e8 */
  0x0000, /* U+08e9 */
  0x0000, /* U+08ea */
  0x0000, /* U+08eb */
  0x0000, /* U+08ec */
  0x0000, /* U+08ed */
  0x0000, /* U+08ee */
  0x0000, /* U+08ef */
  0x0000, /* U+08f0 */
  0x0000, /* U+08f1 */
  0x0000, /* U+08f2 */
  0x0000, /* U+08f3 */
  0x0000, /* U+08f4 */
  0x0000, /* U+08f5 */
  0x0000, /* U+08f6 */
  0x0000, /* U+08f7 */
  0x0000, /* U+08f8 */
  0x0000, /* U+08f9 */
  0x0000, /* U+08fa */
  0x0000, /* U+08fb */
  0x0000, /* U+08fc */
  0x0000, /* U+08fd */
  0x0000, /* U+08fe */
  0x0000, /* U+08ff */
  0x0000, /* U+0900 */
  0x0000, /* U+0901 */
  0x0000, /* U+0902 */
  0x0000, /* U+0903 */
  0x0000, /* U+0904 */
  0x0000, /* U+0905 */
  0x0000, /* U+0906 */
  0x0000, /* U+0907 */
  0x0000, /* U+0908 */
  0x0000, /* U+0909 */
  0x0000, /* U+090a */
  0x0000, /* U+090b */
  0x0000, /* U+090c */
  0x0000, /* U+090d */
  0x0000, /* U+090e */
  0x0000, /* U+090f */
  0x0000, /* U+0910 */
  0x0000, /* U+0911 */
  0x0000, /* U+0912 */
  0x0000, /* U+0913 */
  0x0000, /* U+0914 */
  0x0000, /* U+0915 */
  0x0000, /* U+0916 */
  0x0000, /* U+0917 */
  0x0000, /* U+0918 */
  0x0000, /* U+0919 */
  0x0000, /* U+091a */
  0x0000, /* U+091b */
  0x0000, /* U+091c */
  0x0000, /* U+091d */
  0x0000, /* U+091e */
  0x0000, /* U+091f */
  0x0000, /* U+0920 */
  0x0000, /* U+0921 */
  0x0000, /* U+0922 */
  0x0000, /* U+0923 */
  0x0000, /* U+0924 */
  0x0000, /* U+0925 */
  0x0000, /* U+0926 */
  0x0000, /* U+0927 */
  0x0000, /* U+0928 */
  0x0000, /* U+0929 */
  0x0000, /* U+092a */
  0x0000, /* U+092b */
  0x0000, /* U+092c */
  0x0000, /* U+092d */
  0x0000, /* U+092e */
  0x0000, /* U+092f */
  0x0000, /* U+0930 */
  0x0000, /* U+0931 */
  0x0000, /* U+0932 */
  0x0000, /* U+0933 */
  0x0000, /* U+0934 */
  0x0000, /* U+0935 */
  0x0000, /* U+0936 */
  0x0000, /* U+0937 */
  0x0000, /* U+0938 */
  0x0000, /* U+0939 */
  0x0000, /* U+093a */
  0x0000, /* U+093b */
  0x0000, /* U+093c */
  0x0000, /* U+093d */
  0x0000, /* U+093e */
  0x0000, /* U+093f */
  0x0000, /* U+0940 */
  0x0000, /* U+0941 */
  0x0000, /* U+0942 */
  0x0000, /* U+0943 */
  0x0000, /* U+0944 */
  0x0000, /* U+0945 */
  0x0000, /* U+0946 */
  0x0000, /* U+0947 */
  0x0000, /* U+0948 */
  0x0000, /* U+0949 */
  0x0000, /* U+094a */
  0x0000, /* U+094b */
  0x0000, /* U+094c */
  0x0000, /* U+094d */
  0x0000, /* U+094e */
  0x0000, /* U+094f */
  0x0000, /* U+0950 */
  0x0000, /* U+0951 */
  0x0000, /* U+0952 */
  0x0000, /* U+0953 */
  0x0000, /* U+0954 */
  0x0000, /* U+0955 */
  0x0000, /* U+0956 */
  0x0000, /* U+0957 */
  0x0000, /* U+0958 */
  0x0000, /* U+0959 */
  0x0000, /* U+095a */
  0x0000, /* U+095b */
  0x0000, /* U+095c */
  0x0000, /* U+095d */
  0x0000, /* U+095e */
  0x0000, /* U+095f */
  0x0000, /* U+0960 */
  0x0000, /* U+0961 */
  0x0000, /* U+0962 */
  0x0000, /* U+0963 */
  0x0000, /* U+0964 */
  0x0000, /* U+0965 */
  0x0000, /* U+0966 */
  0x0000, /* U+0967 */
  0x0000, /* U+0968 */
  0x0000, /* U+0969 */
  0x0000, /* U+096a */
  0x0000, /* U+096b */
  0x0000, /* U+096c */
  0x0000, /* U+096d */
  0x0000, /* U+096e */
  0x0000, /* U+096f */
  0x0000, /* U+0970 */
  0x0000, /* U+0971 */
  0x0000, /* U+0972 */
  0x0000, /* U+0973 */
  0x0000, /* U+0974 */
  0x0000, /* U+0975 */
  0x0000, /* U+0976 */
  0x0000, /* U+0977 */
  0x0000, /* U+0978 */
  0x0000, /* U+0979 */
  0x0000, /* U+097a */
  0x0000, /* U+097b */
  0x0000, /* U+097c */
  0x0000, /* U+097d */
  0x0000, /* U+097e */
  0x0000, /* U+097f */
  0x0000, /* U+0980 */
  0x0000, /* U+0981 */
  0x0000, /* U+0982 */
  0x0000, /* U+0983 */
  0x0000, /* U+0984 */
  0x0000, /* U+0985 */
  0x0000, /* U+0986 */
  0x0000, /* U+0987 */
  0x0000, /* U+0988 */
  0x0000, /* U+0989 */
  0x0000, /* U+098a */
  0x0000, /* U+098b */
  0x0000, /* U+098c */
  0x0000, /* U+098d */
  0x0000, /* U+098e */
  0x0000, /* U+098f */
  0x0000, /* U+0990 */
  0x0000, /* U+0991 */
  0x0000, /* U+0992 */
  0x0000, /* U+0993 */
  0x0000, /* U+0994 */
  0x0000, /* U+0995 */
  0x0000, /* U+0996 */
  0x0000, /* U+0997 */
  0x0000, /* U+0998 */
  0x0000, /* U+0999 */
  0x0000, /* U+099a */
  0x0000, /* U+099b */
  0x0000, /* U+099c */
  0x0000, /* U+099d */
  0x0000, /* U+099e */
  0x0000, /* U+099f */
  0x0000, /* U+09a0 */
  0x0000, /* U+09a1 */
  0x0000, /* U+09a2 */
  0x0000, /* U+09a3 */
  0x0000, /* U+09a4 */
  0x0000, /* U+09a5 */
  0x0000, /* U+09a6 */
  0x0000, /* U+09a7 */
  0x0000, /* U+09a8 */
  0x0000, /* U+09a9 */
  0x0000, /* U+09aa */
  0x0000, /* U+09ab */
  0x0000, /* U+09ac */
  0x0000, /* U+09ad */
  0x0000, /* U+09ae */
  0x0000, /* U+09af */
  0x0000, /* U+09b0 */
  0x0000, /* U+09b1 */
  0x0000, /* U+09b2 */
  0x0000, /* U+09b3 */
  0x0000, /* U+09b4 */
  0x0000, /* U+09b5 */
  0x0000, /* U+09b6 */
  0x0000, /* U+09b7 */
  0x0000, /* U+09b8 */
  0x0000, /* U+09b9 */
  0x0000, /* U+09ba */
  0x0000, /* U+09bb */
  0x0000, /* U+09bc */
  0x0000, /* U+09bd */
  0x0000, /* U+09be */
  0x0000, /* U+09bf */
  0x0000, /* U+09c0 */
  0x0000, /* U+09c1 */
  0x0000, /* U+09c2 */
  0x0000, /* U+09c3 */
  0x0000, /* U+09c4 */
  0x0000, /* U+09c5 */
  0x0000, /* U+09c6 */
  0x0000, /* U+09c7 */
  0x0000, /* U+09c8 */
  0x0000, /* U+09c9 */
  0x0000, /* U+09ca */
  0x0000, /* U+09cb */
  0x0000, /* U+09cc */
  0x0000, /* U+09cd */
  0x0000, /* U+09ce */
  0x0000, /* U+09cf */
  0x0000, /* U+09d0 */
  0x0000, /* U+09d1 */
  0x0000, /* U+09d2 */
  0x0000, /* U+09d3 */
  0x0000, /* U+09d4 */
  0x0000, /* U+09d5 */
  0x0000, /* U+09d6 */
  0x0000, /* U+09d7 */
  0x0000, /* U+09d8 */
  0x0000, /* U+09d9 */
  0x0000, /* U+09da */
  0x0000, /* U+09db */
  0x0000, /* U+09dc */
  0x0000, /* U+09dd */
  0x0000, /* U+09de */
  0x0000, /* U+09df */
  0x0000, /* U+09e0 */
  0x0000, /* U+09e1 */
  0x0000, /* U+09e2 */
  0x0000, /* U+09e3 */
  0x0000, /* U+09e4 */
  0x0000, /* U+09e5 */
  0x0000, /* U+09e6 */
  0x0000, /* U+09e7 */
  0x0000, /* U+09e8 */
  0x0000, /* U+09e9 */
  0x0000, /* U+09ea */
  0x0000, /* U+09eb */
  0x0000, /* U+09ec */
  0x0000, /* U+09ed */
  0x0000, /* U+09ee */
  0x0000, /* U+09ef */
  0x0000, /* U+09f0 */
  0x0000, /* U+09f1 */
  0x0000, /* U+09f2 */
  0x0000, /* U+09f3 */
  0x0000, /* U+09f4 */
  0x0000, /* U+09f5 */
  0x0000, /* U+09f6 */
  0x0000, /* U+09f7 */
  0x0000, /* U+09f8 */
  0x0000, /* U+09f9 */
  0x0000, /* U+09fa */
  0x0000, /* U+09fb */
  0x0000, /* U+09fc */
  0x0000, /* U+09fd */
  0x0000, /* U+09fe */
  0x0000, /* U+09ff */
  0x0000, /* U+0a00 */
  0x0000, /* U+0a01 */
  0x0000, /* U+0a02 */
  0x0000, /* U+0a03 */
  0x0000, /* U+0a04 */
  0x0000, /* U+0a05 */
  0x0000, /* U+0a06 */
  0x0000, /* U+0a07 */
  0x0000, /* U+0a08 */
  0x0000, /* U+0a09 */
  0x0000, /* U+0a0a */
  0x0000, /* U+0a0b */
  0x0000, /* U+0a0c */
  0x0000, /* U+0a0d */
  0x0000, /* U+0a0e */
  0x0000, /* U+0a0f */
  0x0000, /* U+0a10 */
  0x0000, /* U+0a11 */
  0x0000, /* U+0a12 */
  0x0000, /* U+0a13 */
  0x0000, /* U+0a14 */
  0x0000, /* U+0a15 */
  0x0000, /* U+0a16 */
  0x0000, /* U+0a17 */
  0x0000, /* U+0a18 */
  0x0000, /* U+0a19 */
  0x0000, /* U+0a1a */
  0x0000, /* U+0a1b */
  0x0000, /* U+0a1c */
  0x0000, /* U+0a1d */
  0x0000, /* U+0a1e */
  0x0000, /* U+0a1f */
  0x0000, /* U+0a20 */
  0x0000, /* U+0a21 */
  0x0000, /* U+0a22 */
  0x0000, /* U+0a23 */
  0x0000, /* U+0a24 */
  0x0000, /* U+0a25 */
  0x0000, /* U+0a26 */
  0x0000, /* U+0a27 */
  0x0000, /* U+0a28 */
  0x0000, /* U+0a29 */
  0x0000, /* U+0a2a */
  0x0000, /* U+0a2b */
  0x0000, /* U+0a2c */
  0x0000, /* U+0a2d */
  0x0000, /* U+0a2e */
  0x0000, /* U+0a2f */
  0x0000, /* U+0a30 */
  0x0000, /* U+0a31 */
  0x0000, /* U+0a32 */
  0x0000, /* U+0a33 */
  0x0000, /* U+0a34 */
  0x0000, /* U+0a35 */
  0x0000, /* U+0a36 */
  0x0000, /* U+0a37 */
  0x0000, /* U+0a38 */
  0x0000, /* U+0a39 */
  0x0000, /* U+0a3a */
  0x0000, /* U+0a3b */
  0x0000, /* U+0a3c */
  0x0000, /* U+0a3d */
  0x0000, /* U+0a3e */
  0x0000, /* U+0a3f */
  0x0000, /* U+0a40 */
  0x0000, /* U+0a41 */
  0x0000, /* U+0a42 */
  0x0000, /* U+0a43 */
  0x0000, /* U+0a44 */
  0x0000, /* U+0a45 */
  0x0000, /* U+0a46 */
  0x0000, /* U+0a47 */
  0x0000, /* U+0a48 */
  0x0000, /* U+0a49 */
  0x0000, /* U+0a4a */
  0x0000, /* U+0a4b */
  0x0000, /* U+0a4c */
  0x0000, /* U+0a4d */
  0x0000, /* U+0a4e */
  0x0000, /* U+0a4f */
  0x0000, /* U+0a50 */
  0x0000, /* U+0a51 */
  0x0000, /* U+0a52 */
  0x0000, /* U+0a53 */
  0x0000, /* U+0a54 */
  0x0000, /* U+0a55 */
  0x0000, /* U+0a56 */
  0x0000, /* U+0a57 */
  0x0000, /* U+0a58 */
  0x0000, /* U+0a59 */
  0x0000, /* U+0a5a */
  0x0000, /* U+0a5b */
  0x0000, /* U+0a5c */
  0x0000, /* U+0a5d */
  0x0000, /* U+0a5e */
  0x0000, /* U+0a5f */
  0x0000, /* U+0a60 */
  0x0000, /* U+0a61 */
  0x0000, /* U+0a62 */
  0x0000, /* U+0a63 */
  0x0000, /* U+0a64 */
  0x0000, /* U+0a65 */
  0x0000, /* U+0a66 */
  0x0000, /* U+0a67 */
  0x0000, /* U+0a68 */
  0x0000, /* U+0a69 */
  0x0000, /* U+0a6a */
  0x0000, /* U+0a6b */
  0x0000, /* U+0a6c */
  0x0000, /* U+0a6d */
  0x0000, /* U+0a6e */
  0x0000, /* U+0a6f */
  0x0000, /* U+0a70 */
  0x0000, /* U+0a71 */
  0x0000, /* U+0a72 */
  0x0000, /* U+0a73 */
  0x0000, /* U+0a74 */
  0x0000, /* U+0a75 */
  0x0000, /* U+0a76 */
  0x0000, /* U+0a77 */
  0x0000, /* U+0a78 */
  0x0000, /* U+0a79 */
  0x0000, /* U+0a7a */
  0x0000, /* U+0a7b */
  0x0000, /* U+0a7c */
  0x0000, /* U+0a7d */
  0x0000, /* U+0a7e */
  0x0000, /* U+0a7f */
  0x0000, /* U+0a80 */
  0x0000, /* U+0a81 */
  0x0000, /* U+0a82 */
  0x0000, /* U+0a83 */
  0x0000, /* U+0a84 */
  0x0000, /* U+0a85 */
  0x0000, /* U+0a86 */
  0x0000, /* U+0a87 */
  0x0000, /* U+0a88 */
  0x0000, /* U+0a89 */
  0x0000, /* U+0a8a */
  0x0000, /* U+0a8b */
  0x0000, /* U+0a8c */
  0x0000, /* U+0a8d */
  0x0000, /* U+0a8e */
  0x0000, /* U+0a8f */
  0x0000, /* U+0a90 */
  0x0000, /* U+0a91 */
  0x0000, /* U+0a92 */
  0x0000, /* U+0a93 */
  0x0000, /* U+0a94 */
  0x0000, /* U+0a95 */
  0x0000, /* U+0a96 */
  0x0000, /* U+0a97 */
  0x0000, /* U+0a98 */
  0x0000, /* U+0a99 */
  0x0000, /* U+0a9a */
  0x0000, /* U+0a9b */
  0x0000, /* U+0a9c */
  0x0000, /* U+0a9d */
  0x0000, /* U+0a9e */
  0x0000, /* U+0a9f */
  0x0000, /* U+0aa0 */
  0x0000, /* U+0aa1 */
  0x0000, /* U+0aa2 */
  0x0000, /* U+0aa3 */
  0x0000, /* U+0aa4 */
  0x0000, /* U+0aa5 */
  0x0000, /* U+0aa6 */
  0x0000, /* U+0aa7 */
  0x0000, /* U+0aa8 */
  0x0000, /* U+0aa9 */
  0x0000, /* U+0aaa */
  0x0000, /* U+0aab */
  0x0000, /* U+0aac */
  0x0000, /* U+0aad */
  0x0000, /* U+0aae */
  0x0000, /* U+0aaf */
  0x0000, /* U+0ab0 */
  0x0000, /* U+0ab1 */
  0x0000, /* U+0ab2 */
  0x0000, /* U+0ab3 */
  0x0000, /* U+0ab4 */
  0x0000, /* U+0ab5 */
  0x0000, /* U+0ab6 */
  0x0000, /* U+0ab7 */
  0x0000, /* U+0ab8 */
  0x0000, /* U+0ab9 */
  0x0000, /* U+0aba */
  0x0000, /* U+0abb */
  0x0000, /* U+0abc */
  0x0000, /* U+0abd */
  0x0000, /* U+0abe */
  0x0000, /* U+0abf */
  0x0000, /* U+0ac0 */
  0x0000, /* U+0ac1 */
  0x0000, /* U+0ac2 */
  0x0000, /* U+0ac3 */
  0x0000, /* U+0ac4 */
  0x0000, /* U+0ac5 */
  0x0000, /* U+0ac6 */
  0x0000, /* U+0ac7 */
  0x0000, /* U+0ac8 */
  0x0000, /* U+0ac9 */
  0x0000, /* U+0aca */
  0x0000, /* U+0acb */
  0x0000, /* U+0acc */
  0x0000, /* U+0acd */
  0x0000, /* U+0ace */
  0x0000, /* U+0acf */
  0x0000, /* U+0ad0 */
  0x0000, /* U+0ad1 */
  0x0000, /* U+0ad2 */
  0x0000, /* U+0ad3 */
  0x0000, /* U+0ad4 */
  0x0000, /* U+0ad5 */
  0x0000, /* U+0ad6 */
  0x0000, /* U+0ad7 */
  0x0000, /* U+0ad8 */
  0x0000, /* U+0ad9 */
  0x0000, /* U+0ada */
  0x0000, /* U+0adb */
  0x0000, /* U+0adc */
  0x0000, /* U+0add */
  0x0000, /* U+0ade */
  0x0000, /* U+0adf */
  0x0000, /* U+0ae0 */
  0x0000, /* U+0ae1 */
  0x0000, /* U+0ae2 */
  0x0000, /* U+0ae3 */
  0x0000, /* U+0ae4 */
  0x0000, /* U+0ae5 */
  0x0000, /* U+0ae6 */
  0x0000, /* U+0ae7 */
  0x0000, /* U+0ae8 */
  0x0000, /* U+0ae9 */
  0x0000, /* U+0aea */
  0x0000, /* U+0aeb */
  0x0000, /* U+0aec */
  0x0000, /* U+0aed */
  0x0000, /* U+0aee */
  0x0000, /* U+0aef */
  0x0000, /* U+0af0 */
  0x0000, /* U+0af1 */
  0x0000, /* U+0af2 */
  0x0000, /* U+0af3 */
  0x0000, /* U+0af4 */
  0x0000, /* U+0af5 */
  0x0000, /* U+0af6 */
  0x0000, /* U+0af7 */
  0x0000, /* U+0af8 */
  0x0000, /* U+0af9 */
  0x0000, /* U+0afa */
  0x0000, /* U+0afb */
  0x0000, /* U+0afc */
  0x0000, /* U+0afd */
  0x0000, /* U+0afe */
  0x0000, /* U+0aff */
  0x0000, /* U+0b00 */
  0x0000, /* U+0b01 */
  0x0000, /* U+0b02 */
  0x0000, /* U+0b03 */
  0x0000, /* U+0b04 */
  0x0000, /* U+0b05 */
  0x0000, /* U+0b06 */
  0x0000, /* U+0b07 */
  0x0000, /* U+0b08 */
  0x0000, /* U+0b09 */
  0x0000, /* U+0b0a */
  0x0000, /* U+0b0b */
  0x0000, /* U+0b0c */
  0x0000, /* U+0b0d */
  0x0000, /* U+0b0e */
  0x0000, /* U+0b0f */
  0x0000, /* U+0b10 */
  0x0000, /* U+0b11 */
  0x0000, /* U+0b12 */
  0x0000, /* U+0b13 */
  0x0000, /* U+0b14 */
  0x0000, /* U+0b15 */
  0x0000, /* U+0b16 */
  0x0000, /* U+0b17 */
  0x0000, /* U+0b18 */
  0x0000, /* U+0b19 */
  0x0000, /* U+0b1a */
  0x0000, /* U+0b1b */
  0x0000, /* U+0b1c */
  0x0000, /* U+0b1d */
  0x0000, /* U+0b1e */
  0x0000, /* U+0b1f */
  0x0000, /* U+0b20 */
  0x0000, /* U+0b21 */
  0x0000, /* U+0b22 */
  0x0000, /* U+0b23 */
  0x0000, /* U+0b24 */
  0x0000, /* U+0b25 */
  0x0000, /* U+0b26 */
  0x0000, /* U+0b27 */
  0x0000, /* U+0b28 */
  0x0000, /* U+0b29 */
  0x0000, /* U+0b2a */
  0x0000, /* U+0b2b */
  0x0000, /* U+0b2c */
  0x0000, /* U+0b2d */
  0x0000, /* U+0b2e */
  0x0000, /* U+0b2f */
  0x0000, /* U+0b30 */
  0x0000, /* U+0b31 */
  0x0000, /* U+0b32 */
  0x0000, /* U+0b33 */
  0x0000, /* U+0b34 */
  0x0000, /* U+0b35 */
  0x0000, /* U+0b36 */
  0x0000, /* U+0b37 */
  0x0000, /* U+0b38 */
  0x0000, /* U+0b39 */
  0x0000, /* U+0b3a */
  0x0000, /* U+0b3b */
  0x0000, /* U+0b3c */
  0x0000, /* U+0b3d */
  0x0000, /* U+0b3e */
  0x0000, /* U+0b3f */
  0x0000, /* U+0b40 */
  0x0000, /* U+0b41 */
  0x0000, /* U+0b42 */
  0x0000, /* U+0b43 */
  0x0000, /* U+0b44 */
  0x0000, /* U+0b45 */
  0x0000, /* U+0b46 */
  0x0000, /* U+0b47 */
  0x0000, /* U+0b48 */
  0x0000, /* U+0b49 */
  0x0000, /* U+0b4a */
  0x0000, /* U+0b4b */
  0x0000, /* U+0b4c */
  0x0000, /* U+0b4d */
  0x0000, /* U+0b4e */
  0x0000, /* U+0b4f */
  0x0000, /* U+0b50 */
  0x0000, /* U+0b51 */
  0x0000, /* U+0b52 */
  0x0000, /* U+0b53 */
  0x0000, /* U+0b54 */
  0x0000, /* U+0b55 */
  0x0000, /* U+0b56 */
  0x0000, /* U+0b57 */
  0x0000, /* U+0b58 */
  0x0000, /* U+0b59 */
  0x0000, /* U+0b5a */
  0x0000, /* U+0b5b */
  0x0000, /* U+0b5c */
  0x0000, /* U+0b5d */
  0x0000, /* U+0b5e */
  0x0000, /* U+0b5f */
  0x0000, /* U+0b60 */
  0x0000, /* U+0b61 */
  0x0000, /* U+0b62 */
  0x0000, /* U+0b63 */
  0x0000, /* U+0b64 */
  0x0000, /* U+0b65 */
  0x0000, /* U+0b66 */
  0x0000, /* U+0b67 */
  0x0000, /* U+0b68 */
  0x0000, /* U+0b69 */
  0x0000, /* U+0b6a */
  0x0000, /* U+0b6b */
  0x0000, /* U+0b6c */
  0x0000, /* U+0b6d */
  0x0000, /* U+0b6e */
  0x0000, /* U+0b6f */
  0x0000, /* U+0b70 */
  0x0000, /* U+0b71 */
  0x0000, /* U+0b72 */
  0x0000, /* U+0b73 */
  0x0000, /* U+0b74 */
  0x0000, /* U+0b75 */
  0x0000, /* U+0b76 */
  0x0000, /* U+0b77 */
  0x0000, /* U+0b78 */
  0x0000, /* U+0b79 */
  0x0000, /* U+0b7a */
  0x0000, /* U+0b7b */
  0x0000, /* U+0b7c */
  0x0000, /* U+0b7d */
  0x0000, /* U+0b7e */
  0x0000, /* U+0b7f */
  0x0000, /* U+0b80 */
  0x0000, /* U+0b81 */
  0x0000, /* U+0b82 */
  0x0000, /* U+0b83 */
  0x0000, /* U+0b84 */
  0x0000, /* U+0b85 */
  0x0000, /* U+0b86 */
  0x0000, /* U+0b87 */
  0x0000, /* U+0b88 */
  0x0000, /* U+0b89 */
  0x0000, /* U+0b8a */
  0x0000, /* U+0b8b */
  0x0000, /* U+0b8c */
  0x0000, /* U+0b8d */
  0x0000, /* U+0b8e */
  0x0000, /* U+0b8f */
  0x0000, /* U+0b90 */
  0x0000, /* U+0b91 */
  0x0000, /* U+0b92 */
  0x0000, /* U+0b93 */
  0x0000, /* U+0b94 */
  0x0000, /* U+0b95 */
  0x0000, /* U+0b96 */
  0x0000, /* U+0b97 */
  0x0000, /* U+0b98 */
  0x0000, /* U+0b99 */
  0x0000, /* U+0b9a */
  0x0000, /* U+0b9b */
  0x0000, /* U+0b9c */
  0x0000, /* U+0b9d */
  0x0000, /* U+0b9e */
  0x0000, /* U+0b9f */
  0x0000, /* U+0ba0 */
  0x0000, /* U+0ba1 */
  0x0000, /* U+0ba2 */
  0x0000, /* U+0ba3 */
  0x0000, /* U+0ba4 */
  0x0000, /* U+0ba5 */
  0x0000, /* U+0ba6 */
  0x0000, /* U+0ba7 */
  0x0000, /* U+0ba8 */
  0x0000, /* U+0ba9 */
  0x0000, /* U+0baa */
  0x0000, /* U+0bab */
  0x0000, /* U+0bac */
  0x0000, /* U+0bad */
  0x0000, /* U+0bae */
  0x0000, /* U+0baf */
  0x0000, /* U+0bb0 */
  0x0000, /* U+0bb1 */
  0x0000, /* U+0bb2 */
  0x0000, /* U+0bb3 */
  0x0000, /* U+0bb4 */
  0x0000, /* U+0bb5 */
  0x0000, /* U+0bb6 */
  0x0000, /* U+0bb7 */
  0x0000, /* U+0bb8 */
  0x0000, /* U+0bb9 */
  0x0000, /* U+0bba */
  0x0000, /* U+0bbb */
  0x0000, /* U+0bbc */
  0x0000, /* U+0bbd */
  0x0000, /* U+0bbe */
  0x0000, /* U+0bbf */
  0x0000, /* U+0bc0 */
  0x0000, /* U+0bc1 */
  0x0000, /* U+0bc2 */
  0x0000, /* U+0bc3 */
  0x0000, /* U+0bc4 */
  0x0000, /* U+0bc5 */
  0x0000, /* U+0bc6 */
  0x0000, /* U+0bc7 */
  0x0000, /* U+0bc8 */
  0x0000, /* U+0bc9 */
  0x0000, /* U+0bca */
  0x0000, /* U+0bcb */
  0x0000, /* U+0bcc */
  0x0000, /* U+0bcd */
  0x0000, /* U+0bce */
  0x0000, /* U+0bcf */
  0x0000, /* U+0bd0 */
  0x0000, /* U+0bd1 */
  0x0000, /* U+0bd2 */
  0x0000, /* U+0bd3 */
  0x0000, /* U+0bd4 */
  0x0000, /* U+0bd5 */
  0x0000, /* U+0bd6 */
  0x0000, /* U+0bd7 */
  0x0000, /* U+0bd8 */
  0x0000, /* U+0bd9 */
  0x0000, /* U+0bda */
  0x0000, /* U+0bdb */
  0x0000, /* U+0bdc */
  0x0000, /* U+0bdd */
  0x0000, /* U+0bde */
  0x0000, /* U+0bdf */
  0x0000, /* U+0be0 */
  0x0000, /* U+0be1 */
  0x0000, /* U+0be2 */
  0x0000, /* U+0be3 */
  0x0000, /* U+0be4 */
  0x0000, /* U+0be5 */
  0x0000, /* U+0be6 */
  0x0000, /* U+0be7 */
  0x0000, /* U+0be8 */
  0x0000, /* U+0be9 */
  0x0000, /* U+0bea */
  0x0000, /* U+0beb */
  0x0000, /* U+0bec */
  0x0000, /* U+0bed */
  0x0000, /* U+0bee */
  0x0000, /* U+0bef */
  0x0000, /* U+0bf0 */
  0x0000, /* U+0bf1 */
  0x0000, /* U+0bf2 */
  0x0000, /* U+0bf3 */
  0x0000, /* U+0bf4 */
  0x0000, /* U+0bf5 */
  0x0000, /* U+0bf6 */
  0x0000, /* U+0bf7 */
  0x0000, /* U+0bf8 */
  0x0000, /* U+0bf9 */
  0x0000, /* U+0bfa */
  0x0000, /* U+0bfb */
  0x0000, /* U+0bfc */
  0x0000, /* U+0bfd */
  0x0000, /* U+0bfe */
  0x0000, /* U+0bff */
  0x0000, /* U+0c00 */
  0x0000, /* U+0c01 */
  0x0000, /* U+0c02 */
  0x0000, /* U+0c03 */
  0x0000, /* U+0c04 */
  0x0000, /* U+0c05 */
  0x0000, /* U+0c06 */
  0x0000, /* U+0c07 */
  0x0000, /* U+0c08 */
  0x0000, /* U+0c09 */
  0x0000, /* U+0c0a */
  0x0000, /* U+0c0b */
  0x0000, /* U+0c0c */
  0x0000, /* U+0c0d */
  0x0000, /* U+0c0e */
  0x0000, /* U+0c0f */
  0x0000, /* U+0c10 */
  0x0000, /* U+0c11 */
  0x0000, /* U+0c12 */
  0x0000, /* U+0c13 */
  0x0000, /* U+0c14 */
  0x0000, /* U+0c15 */
  0x0000, /* U+0c16 */
  0x0000, /* U+0c17 */
  0x0000, /* U+0c18 */
  0x0000, /* U+0c19 */
  0x0000, /* U+0c1a */
  0x0000, /* U+0c1b */
  0x0000, /* U+0c1c */
  0x0000, /* U+0c1d */
  0x0000, /* U+0c1e */
  0x0000, /* U+0c1f */
  0x0000, /* U+0c20 */
  0x0000, /* U+0c21 */
  0x0000, /* U+0c22 */
  0x0000, /* U+0c23 */
  0x0000, /* U+0c24 */
  0x0000, /* U+0c25 */
  0x0000, /* U+0c26 */
  0x0000, /* U+0c27 */
  0x0000, /* U+0c28 */
  0x0000, /* U+0c29 */
  0x0000, /* U+0c2a */
  0x0000, /* U+0c2b */
  0x0000, /* U+0c2c */
  0x0000, /* U+0c2d */
  0x0000, /* U+0c2e */
  0x0000, /* U+0c2f */
  0x0000, /* U+0c30 */
  0x0000, /* U+0c31 */
  0x0000, /* U+0c32 */
  0x0000, /* U+0c33 */
  0x0000, /* U+0c34 */
  0x0000, /* U+0c35 */
  0x0000, /* U+0c36 */
  0x0000, /* U+0c37 */
  0x0000, /* U+0c38 */
  0x0000, /* U+0c39 */
  0x0000, /* U+0c3a */
  0x0000, /* U+0c3b */
  0x0000, /* U+0c3c */
  0x0000, /* U+0c3d */
  0x0000, /* U+0c3e */
  0x0000, /* U+0c3f */
  0x0000, /* U+0c40 */
  0x0000, /* U+0c41 */
  0x0000, /* U+0c42 */
  0x0000, /* U+0c43 */
  0x0000, /* U+0c44 */
  0x0000, /* U+0c45 */
  0x0000, /* U+0c46 */
  0x0000, /* U+0c47 */
  0x0000, /* U+0c48 */
  0x0000, /* U+0c49 */
  0x0000, /* U+0c4a */
  0x0000, /* U+0c4b */
  0x0000, /* U+0c4c */
  0x0000, /* U+0c4d */
  0x0000, /* U+0c4e */
  0x0000, /* U+0c4f */
  0x0000, /* U+0c50 */
  0x0000, /* U+0c51 */
  0x0000, /* U+0c52 */
  0x0000, /* U+0c53 */
  0x0000, /* U+0c54 */
  0x0000, /* U+0c55 */
  0x0000, /* U+0c56 */
  0x0000, /* U+0c57 */
  0x0000, /* U+0c58 */
  0x0000, /* U+0c59 */
  0x0000, /* U+0c5a */
  0x0000, /* U+0c5b */
  0x0000, /* U+0c5c */
  0x0000, /* U+0c5d */
  0x0000, /* U+0c5e */
  0x0000, /* U+0c5f */
  0x0000, /* U+0c60 */
  0x0000, /* U+0c61 */
  0x0000, /* U+0c62 */
  0x0000, /* U+0c63 */
  0x0000, /* U+0c64 */
  0x0000, /* U+0c65 */
  0x0000, /* U+0c66 */
  0x0000, /* U+0c67 */
  0x0000, /* U+0c68 */
  0x0000, /* U+0c69 */
  0x0000, /* U+0c6a */
  0x0000, /* U+0c6b */
  0x0000, /* U+0c6c */
  0x0000, /* U+0c6d */
  0x0000, /* U+0c6e */
  0x0000, /* U+0c6f */
  0x0000, /* U+0c70 */
  0x0000, /* U+0c71 */
  0x0000, /* U+0c72 */
  0x0000, /* U+0c73 */
  0x0000, /* U+0c74 */
  0x0000, /* U+0c75 */
  0x0000, /* U+0c76 */
  0x0000, /* U+0c77 */
  0x0000, /* U+0c78 */
  0x0000, /* U+0c79 */
  0x0000, /* U+0c7a */
  0x0000, /* U+0c7b */
  0x0000, /* U+0c7c */
  0x0000, /* U+0c7d */
  0x0000, /* U+0c7e */
  0x0000, /* U+0c7f */
  0x0000, /* U+0c80 */
  0x0000, /* U+0c81 */
  0x0000, /* U+0c82 */
  0x0000, /* U+0c83 */
  0x0000, /* U+0c84 */
  0x0000, /* U+0c85 */
  0x0000, /* U+0c86 */
  0x0000, /* U+0c87 */
  0x0000, /* U+0c88 */
  0x0000, /* U+0c89 */
  0x0000, /* U+0c8a */
  0x0000, /* U+0c8b */
  0x0000, /* U+0c8c */
  0x0000, /* U+0c8d */
  0x0000, /* U+0c8e */
  0x0000, /* U+0c8f */
  0x0000, /* U+0c90 */
  0x0000, /* U+0c91 */
  0x0000, /* U+0c92 */
  0x0000, /* U+0c93 */
  0x0000, /* U+0c94 */
  0x0000, /* U+0c95 */
  0x0000, /* U+0c96 */
  0x0000, /* U+0c97 */
  0x0000, /* U+0c98 */
  0x0000, /* U+0c99 */
  0x0000, /* U+0c9a */
  0x0000, /* U+0c9b */
  0x0000, /* U+0c9c */
  0x0000, /* U+0c9d */
  0x0000, /* U+0c9e */
  0x0000, /* U+0c9f */
  0x0000, /* U+0ca0 */
  0x0000, /* U+0ca1 */
  0x0000, /* U+0ca2 */
  0x0000, /* U+0ca3 */
  0x0000, /* U+0ca4 */
  0x0000, /* U+0ca5 */
  0x0000, /* U+0ca6 */
  0x0000, /* U+0ca7 */
  0x0000, /* U+0ca8 */
  0x0000, /* U+0ca9 */
  0x0000, /* U+0caa */
  0x0000, /* U+0cab */
  0x0000, /* U+0cac */
  0x0000, /* U+0cad */
  0x0000, /* U+0cae */
  0x0000, /* U+0caf */
  0x0000, /* U+0cb0 */
  0x0000, /* U+0cb1 */
  0x0000, /* U+0cb2 */
  0x0000, /* U+0cb3 */
  0x0000, /* U+0cb4 */
  0x0000, /* U+0cb5 */
  0x0000, /* U+0cb6 */
  0x0000, /* U+0cb7 */
  0x0000, /* U+0cb8 */
  0x0000, /* U+0cb9 */
  0x0000, /* U+0cba */
  0x0000, /* U+0cbb */
  0x0000, /* U+0cbc */
  0x0000, /* U+0cbd */
  0x0000, /* U+0cbe */
  0x0000, /* U+0cbf */
  0x0000, /* U+0cc0 */
  0x0000, /* U+0cc1 */
  0x0000, /* U+0cc2 */
  0x0000, /* U+0cc3 */
  0x0000, /* U+0cc4 */
  0x0000, /* U+0cc5 */
  0x0000, /* U+0cc6 */
  0x0000, /* U+0cc7 */
  0x0000, /* U+0cc8 */
  0x0000, /* U+0cc9 */
  0x0000, /* U+0cca */
  0x0000, /* U+0ccb */
  0x0000, /* U+0ccc */
  0x0000, /* U+0ccd */
  0x0000, /* U+0cce */
  0x0000, /* U+0ccf */
  0x0000, /* U+0cd0 */
  0x0000, /* U+0cd1 */
  0x0000, /* U+0cd2 */
  0x0000, /* U+0cd3 */
  0x0000, /* U+0cd4 */
  0x0000, /* U+0cd5 */
  0x0000, /* U+0cd6 */
  0x0000, /* U+0cd7 */
  0x0000, /* U+0cd8 */
  0x0000, /* U+0cd9 */
  0x0000, /* U+0cda */
  0x0000, /* U+0cdb */
  0x0000, /* U+0cdc */
  0x0000, /* U+0cdd */
  0x0000, /* U+0cde */
  0x0000, /* U+0cdf */
  0x0000, /* U+0ce0 */
  0x0000, /* U+0ce1 */
  0x0000, /* U+0ce2 */
  0x0000, /* U+0ce3 */
  0x0000, /* U+0ce4 */
  0x0000, /* U+0ce5 */
  0x0000, /* U+0ce6 */
  0x0000, /* U+0ce7 */
  0x0000, /* U+0ce8 */
  0x0000, /* U+0ce9 */
  0x0000, /* U+0cea */
  0x0000, /* U+0ceb */
  0x0000, /* U+0cec */
  0x0000, /* U+0ced */
  0x0000, /* U+0cee */
  0x0000, /* U+0cef */
  0x0000, /* U+0cf0 */
  0x0000, /* U+0cf1 */
  0x0000, /* U+0cf2 */
  0x0000, /* U+0cf3 */
  0x0000, /* U+0cf4 */
  0x0000, /* U+0cf5 */
  0x0000, /* U+0cf6 */
  0x0000, /* U+0cf7 */
  0x0000, /* U+0cf8 */
  0x0000, /* U+0cf9 */
  0x0000, /* U+0cfa */
  0x0000, /* U+0cfb */
  0x0000, /* U+0cfc */
  0x0000, /* U+0cfd */
  0x0000, /* U+0cfe */
  0x0000, /* U+0cff */
  0x0000, /* U+0d00 */
  0x0000, /* U+0d01 */
  0x0000, /* U+0d02 */
  0x0000, /* U+0d03 */
  0x0000, /* U+0d04 */
  0x0000, /* U+0d05 */
  0x0000, /* U+0d06 */
  0x0000, /* U+0d07 */
  0x0000, /* U+0d08 */
  0x0000, /* U+0d09 */
  0x0000, /* U+0d0a */
  0x0000, /* U+0d0b */
  0x0000, /* U+0d0c */
  0x0000, /* U+0d0d */
  0x0000, /* U+0d0e */
  0x0000, /* U+0d0f */
  0x0000, /* U+0d10 */
  0x0000, /* U+0d11 */
  0x0000, /* U+0d12 */
  0x0000, /* U+0d13 */
  0x0000, /* U+0d14 */
  0x0000, /* U+0d15 */
  0x0000, /* U+0d16 */
  0x0000, /* U+0d17 */
  0x0000, /* U+0d18 */
  0x0000, /* U+0d19 */
  0x0000, /* U+0d1a */
  0x0000, /* U+0d1b */
  0x0000, /* U+0d1c */
  0x0000, /* U+0d1d */
  0x0000, /* U+0d1e */
  0x0000, /* U+0d1f */
  0x0000, /* U+0d20 */
  0x0000, /* U+0d21 */
  0x0000, /* U+0d22 */
  0x0000, /* U+0d23 */
  0x0000, /* U+0d24 */
  0x0000, /* U+0d25 */
  0x0000, /* U+0d26 */
  0x0000, /* U+0d27 */
  0x0000, /* U+0d28 */
  0x0000, /* U+0d29 */
  0x0000, /* U+0d2a */
  0x0000, /* U+0d2b */
  0x0000, /* U+0d2c */
  0x0000, /* U+0d2d */
  0x0000, /* U+0d2e */
  0x0000, /* U+0d2f */
  0x0000, /* U+0d30 */
  0x0000, /* U+0d31 */
  0x0000, /* U+0d32 */
  0x0000, /* U+0d33 */
  0x0000, /* U+0d34 */
  0x0000, /* U+0d35 */
  0x0000, /* U+0d36 */
  0x0000, /* U+0d37 */
  0x0000, /* U+0d38 */
  0x0000, /* U+0d39 */
  0x0000, /* U+0d3a */
  0x0000, /* U+0d3b */
  0x0000, /* U+0d3c */
  0x0000, /* U+0d3d */
  0x0000, /* U+0d3e */
  0x0000, /* U+0d3f */
  0x0000, /* U+0d40 */
  0x0000, /* U+0d41 */
  0x0000, /* U+0d42 */
  0x0000, /* U+0d43 */
  0x0000, /* U+0d44 */
  0x0000, /* U+0d45 */
  0x0000, /* U+0d46 */
  0x0000, /* U+0d47 */
  0x0000, /* U+0d48 */
  0x0000, /* U+0d49 */
  0x0000, /* U+0d4a */
  0x0000, /* U+0d4b */
  0x0000, /* U+0d4c */
  0x0000, /* U+0d4d */
  0x0000, /* U+0d4e */
  0x0000, /* U+0d4f */
  0x0000, /* U+0d50 */
  0x0000, /* U+0d51 */
  0x0000, /* U+0d52 */
  0x0000, /* U+0d53 */
  0x0000, /* U+0d54 */
  0x0000, /* U+0d55 */
  0x0000, /* U+0d56 */
  0x0000, /* U+0d57 */
  0x0000, /* U+0d58 */
  0x0000, /* U+0d59 */
  0x0000, /* U+0d5a */
  0x0000, /* U+0d5b */
  0x0000, /* U+0d5c */
  0x0000, /* U+0d5d */
  0x0000, /* U+0d5e */
  0x0000, /* U+0d5f */
  0x0000, /* U+0d60 */
  0x0000, /* U+0d61 */
  0x0000, /* U+0d62 */
  0x0000, /* U+0d63 */
  0x0000, /* U+0d64 */
  0x0000, /* U+0d65 */
  0x0000, /* U+0d66 */
  0x0000, /* U+0d67 */
  0x0000, /* U+0d68 */
  0x0000, /* U+0d69 */
  0x0000, /* U+0d6a */
  0x0000, /* U+0d6b */
  0x0000, /* U+0d6c */
  0x0000, /* U+0d6d */
  0x0000, /* U+0d6e */
  0x0000, /* U+0d6f */
  0x0000, /* U+0d70 */
  0x0000, /* U+0d71 */
  0x0000, /* U+0d72 */
  0x0000, /* U+0d73 */
  0x0000, /* U+0d74 */
  0x0000, /* U+0d75 */
  0x0000, /* U+0d76 */
  0x0000, /* U+0d77 */
  0x0000, /* U+0d78 */
  0x0000, /* U+0d79 */
  0x0000, /* U+0d7a */
  0x0000, /* U+0d7b */
  0x0000, /* U+0d7c */
  0x0000, /* U+0d7d */
  0x0000, /* U+0d7e */
  0x0000, /* U+0d7f */
  0x0000, /* U+0d80 */
  0x0000, /* U+0d81 */
  0x0000, /* U+0d82 */
  0x0000, /* U+0d83 */
  0x0000, /* U+0d84 */
  0x0000, /* U+0d85 */
  0x0000, /* U+0d86 */
  0x0000, /* U+0d87 */
  0x0000, /* U+0d88 */
  0x0000, /* U+0d89 */
  0x0000, /* U+0d8a */
  0x0000, /* U+0d8b */
  0x0000, /* U+0d8c */
  0x0000, /* U+0d8d */
  0x0000, /* U+0d8e */
  0x0000, /* U+0d8f */
  0x0000, /* U+0d90 */
  0x0000, /* U+0d91 */
  0x0000, /* U+0d92 */
  0x0000, /* U+0d93 */
  0x0000, /* U+0d94 */
  0x0000, /* U+0d95 */
  0x0000, /* U+0d96 */
  0x0000, /* U+0d97 */
  0x0000, /* U+0d98 */
  0x0000, /* U+0d99 */
  0x0000, /* U+0d9a */
  0x0000, /* U+0d9b */
  0x0000, /* U+0d9c */
  0x0000, /* U+0d9d */
  0x0000, /* U+0d9e */
  0x0000, /* U+0d9f */
  0x0000, /* U+0da0 */
  0x0000, /* U+0da1 */
  0x0000, /* U+0da2 */
  0x0000, /* U+0da3 */
  0x0000, /* U+0da4 */
  0x0000, /* U+0da5 */
  0x0000, /* U+0da6 */
  0x0000, /* U+0da7 */
  0x0000, /* U+0da8 */
  0x0000, /* U+0da9 */
  0x0000, /* U+0daa */
  0x0000, /* U+0dab */
  0x0000, /* U+0dac */
  0x0000, /* U+0dad */
  0x0000, /* U+0dae */
  0x0000, /* U+0daf */
  0x0000, /* U+0db0 */
  0x0000, /* U+0db1 */
  0x0000, /* U+0db2 */
  0x0000, /* U+0db3 */
  0x0000, /* U+0db4 */
  0x0000, /* U+0db5 */
  0x0000, /* U+0db6 */
  0x0000, /* U+0db7 */
  0x0000, /* U+0db8 */
  0x0000, /* U+0db9 */
  0x0000, /* U+0dba */
  0x0000, /* U+0dbb */
  0x0000, /* U+0dbc */
  0x0000, /* U+0dbd */
  0x0000, /* U+0dbe */
  0x0000, /* U+0dbf */
  0x0000, /* U+0dc0 */
  0x0000, /* U+0dc1 */
  0x0000, /* U+0dc2 */
  0x0000, /* U+0dc3 */
  0x0000, /* U+0dc4 */
  0x0000, /* U+0dc5 */
  0x0000, /* U+0dc6 */
  0x0000, /* U+0dc7 */
  0x0000, /* U+0dc8 */
  0x0000, /* U+0dc9 */
  0x0000, /* U+0dca */
  0x0000, /* U+0dcb */
  0x0000, /* U+0dcc */
  0x0000, /* U+0dcd */
  0x0000, /* U+0dce */
  0x0000, /* U+0dcf */
  0x0000, /* U+0dd0 */
  0x0000, /* U+0dd1 */
  0x0000, /* U+0dd2 */
  0x0000, /* U+0dd3 */
  0x0000, /* U+0dd4 */
  0x0000, /* U+0dd5 */
  0x0000, /* U+0dd6 */
  0x0000, /* U+0dd7 */
  0x0000, /* U+0dd8 */
  0x0000, /* U+0dd9 */
  0x0000, /* U+0dda */
  0x0000, /* U+0ddb */
  0x0000, /* U+0ddc */
  0x0000, /* U+0ddd */
  0x0000, /* U+0dde */
  0x0000, /* U+0ddf */
  0x0000, /* U+0de0 */
  0x0000, /* U+0de1 */
  0x0000, /* U+0de2 */
  0x0000, /* U+0de3 */
  0x0000, /* U+0de4 */
  0x0000, /* U+0de5 */
  0x0000, /* U+0de6 */
  0x0000, /* U+0de7 */
  0x0000, /* U+0de8 */
  0x0000, /* U+0de9 */
  0x0000, /* U+0dea */
  0x0000, /* U+0deb */
  0x0000, /* U+0dec */
  0x0000, /* U+0ded */
  0x0000, /* U+0dee */
  0x0000, /* U+0def */
  0x0000, /* U+0df0 */
  0x0000, /* U+0df1 */
  0x0000, /* U+0df2 */
  0x0000, /* U+0df3 */
  0x0000, /* U+0df4 */
  0x0000, /* U+0df5 */
  0x0000, /* U+0df6 */
  0x0000, /* U+0df7 */
  0x0000, /* U+0df8 */
  0x0000, /* U+0df9 */
  0x0000, /* U+0dfa */
  0x0000, /* U+0dfb */
  0x0000, /* U+0dfc */
  0x0000, /* U+0dfd */
  0x0000, /* U+0dfe */
  0x0000, /* U+0dff */
  0x0000, /* U+0e00 */
  0x0000, /* U+0e01 */
  0x0000, /* U+0e02 */
  0x0000, /* U+0e03 */
  0x0000, /* U+0e04 */
  0x0000, /* U+0e05 */
  0x0000, /* U+0e06 */
  0x0000, /* U+0e07 */
  0x0000, /* U+0e08 */
  0x0000, /* U+0e09 */
  0x0000, /* U+0e0a */
  0x0000, /* U+0e0b */
  0x0000, /* U+0e0c */
  0x0000, /* U+0e0d */
  0x0000, /* U+0e0e */
  0x0000, /* U+0e0f */
  0x0000, /* U+0e10 */
  0x0000, /* U+0e11 */
  0x0000, /* U+0e12 */
  0x0000, /* U+0e13 */
  0x0000, /* U+0e14 */
  0x0000, /* U+0e15 */
  0x0000, /* U+0e16 */
  0x0000, /* U+0e17 */
  0x0000, /* U+0e18 */
  0x0000, /* U+0e19 */
  0x0000, /* U+0e1a */
  0x0000, /* U+0e1b */
  0x0000, /* U+0e1c */
  0x0000, /* U+0e1d */
  0x0000, /* U+0e1e */
  0x0000, /* U+0e1f */
  0x0000, /* U+0e20 */
  0x0000, /* U+0e21 */
  0x0000, /* U+0e22 */
  0x0000, /* U+0e23 */
  0x0000, /* U+0e24 */
  0x0000, /* U+0e25 */
  0x0000, /* U+0e26 */
  0x0000, /* U+0e27 */
  0x0000, /* U+0e28 */
  0x0000, /* U+0e29 */
  0x0000, /* U+0e2a */
  0x0000, /* U+0e2b */
  0x0000, /* U+0e2c */
  0x0000, /* U+0e2d */
  0x0000, /* U+0e2e */
  0x0000, /* U+0e2f */
  0x0000, /* U+0e30 */
  0x0000, /* U+0e31 */
  0x0000, /* U+0e32 */
  0x0000, /* U+0e33 */
  0x0000, /* U+0e34 */
  0x0000, /* U+0e35 */
  0x0000, /* U+0e36 */
  0x0000, /* U+0e37 */
  0x0000, /* U+0e38 */
  0x0000, /* U+0e39 */
  0x0000, /* U+0e3a */
  0x0000, /* U+0e3b */
  0x0000, /* U+0e3c */
  0x0000, /* U+0e3d */
  0x0000, /* U+0e3e */
  0x0000, /* U+0e3f */
  0x0000, /* U+0e40 */
  0x0000, /* U+0e41 */
  0x0000, /* U+0e42 */
  0x0000, /* U+0e43 */
  0x0000, /* U+0e44 */
  0x0000, /* U+0e45 */
  0x0000, /* U+0e46 */
  0x0000, /* U+0e47 */
  0x0000, /* U+0e48 */
  0x0000, /* U+0e49 */
  0x0000, /* U+0e4a */
  0x0000, /* U+0e4b */
  0x0000, /* U+0e4c */
  0x0000, /* U+0e4d */
  0x0000, /* U+0e4e */
  0x0000, /* U+0e4f */
  0x0000, /* U+0e50 */
  0x0000, /* U+0e51 */
  0x0000, /* U+0e52 */
  0x0000, /* U+0e53 */
  0x0000, /* U+0e54 */
  0x0000, /* U+0e55 */
  0x0000, /* U+0e56 */
  0x0000, /* U+0e57 */
  0x0000, /* U+0e58 */
  0x0000, /* U+0e59 */
  0x0000, /* U+0e5a */
  0x0000, /* U+0e5b */
  0x0000, /* U+0e5c */
  0x0000, /* U+0e5d */
  0x0000, /* U+0e5e */
  0x0000, /* U+0e5f */
  0x0000, /* U+0e60 */
  0x0000, /* U+0e61 */
  0x0000, /* U+0e62 */
  0x0000, /* U+0e63 */
  0x0000, /* U+0e64 */
  0x0000, /* U+0e65 */
  0x0000, /* U+0e66 */
  0x0000, /* U+0e67 */
  0x0000, /* U+0e68 */
  0x0000, /* U+0e69 */
  0x0000, /* U+0e6a */
  0x0000, /* U+0e6b */
  0x0000, /* U+0e6c */
  0x0000, /* U+0e6d */
  0x0000, /* U+0e6e */
  0x0000, /* U+0e6f */
  0x0000, /* U+0e70 */
  0x0000, /* U+0e71 */
  0x0000, /* U+0e72 */
  0x0000, /* U+0e73 */
  0x0000, /* U+0e74 */
  0x0000, /* U+0e75 */
  0x0000, /* U+0e76 */
  0x0000, /* U+0e77 */
  0x0000, /* U+0e78 */
  0x0000, /* U+0e79 */
  0x0000, /* U+0e7a */
  0x0000, /* U+0e7b */
  0x0000, /* U+0e7c */
  0x0000, /* U+0e7d */
  0x0000, /* U+0e7e */
  0x0000, /* U+0e7f */
  0x0000, /* U+0e80 */
  0x0000, /* U+0e81 */
  0x0000, /* U+0e82 */
  0x0000, /* U+0e83 */
  0x0000, /* U+0e84 */
  0x0000, /* U+0e85 */
  0x0000, /* U+0e86 */
  0x0000, /* U+0e87 */
  0x0000, /* U+0e88 */
  0x0000, /* U+0e89 */
  0x0000, /* U+0e8a */
  0x0000, /* U+0e8b */
  0x0000, /* U+0e8c */
  0x0000, /* U+0e8d */
  0x0000, /* U+0e8e */
  0x0000, /* U+0e8f */
  0x0000, /* U+0e90 */
  0x0000, /* U+0e91 */
  0x0000, /* U+0e92 */
  0x0000, /* U+0e93 */
  0x0000, /* U+0e94 */
  0x0000, /* U+0e95 */
  0x0000, /* U+0e96 */
  0x0000, /* U+0e97 */
  0x0000, /* U+0e98 */
  0x0000, /* U+0e99 */
  0x0000, /* U+0e9a */
  0x0000, /* U+0e9b */
  0x0000, /* U+0e9c */
  0x0000, /* U+0e9d */
  0x0000, /* U+0e9e */
  0x0000, /* U+0e9f */
  0x0000, /* U+0ea0 */
  0x0000, /* U+0ea1 */
  0x0000, /* U+0ea2 */
  0x0000, /* U+0ea3 */
  0x0000, /* U+0ea4 */
  0x0000, /* U+0ea5 */
  0x0000, /* U+0ea6 */
  0x0000, /* U+0ea7 */
  0x0000, /* U+0ea8 */
  0x0000, /* U+0ea9 */
  0x0000, /* U+0eaa */
  0x0000, /* U+0eab */
  0x0000, /* U+0eac */
  0x0000, /* U+0ead */
  0x0000, /* U+0eae */
  0x0000, /* U+0eaf */
  0x0000, /* U+0eb0 */
  0x0000, /* U+0eb1 */
  0x0000, /* U+0eb2 */
  0x0000, /* U+0eb3 */
  0x0000, /* U+0eb4 */
  0x0000, /* U+0eb5 */
  0x0000, /* U+0eb6 */
  0x0000, /* U+0eb7 */
  0x0000, /* U+0eb8 */
  0x0000, /* U+0eb9 */
  0x0000, /* U+0eba */
  0x0000, /* U+0ebb */
  0x0000, /* U+0ebc */
  0x0000, /* U+0ebd */
  0x0000, /* U+0ebe */
  0x0000, /* U+0ebf */
  0x0000, /* U+0ec0 */
  0x0000, /* U+0ec1 */
  0x0000, /* U+0ec2 */
  0x0000, /* U+0ec3 */
  0x0000, /* U+0ec4 */
  0x0000, /* U+0ec5 */
  0x0000, /* U+0ec6 */
  0x0000, /* U+0ec7 */
  0x0000, /* U+0ec8 */
  0x0000, /* U+0ec9 */
  0x0000, /* U+0eca */
  0x0000, /* U+0ecb */
  0x0000, /* U+0ecc */
  0x0000, /* U+0ecd */
  0x0000, /* U+0ece */
  0x0000, /* U+0ecf */
  0x0000, /* U+0ed0 */
  0x0000, /* U+0ed1 */
  0x0000, /* U+0ed2 */
  0x0000, /* U+0ed3 */
  0x0000, /* U+0ed4 */
  0x0000, /* U+0ed5 */
  0x0000, /* U+0ed6 */
  0x0000, /* U+0ed7 */
  0x0000, /* U+0ed8 */
  0x0000, /* U+0ed9 */
  0x0000, /* U+0eda */
  0x0000, /* U+0edb */
  0x0000, /* U+0edc */
  0x0000, /* U+0edd */
  0x0000, /* U+0ede */
  0x0000, /* U+0edf */
  0x0000, /* U+0ee0 */
  0x0000, /* U+0ee1 */
  0x0000, /* U+0ee2 */
  0x0000, /* U+0ee3 */
  0x0000, /* U+0ee4 */
  0x0000, /* U+0ee5 */
  0x0000, /* U+0ee6 */
  0x0000, /* U+0ee7 */
  0x0000, /* U+0ee8 */
  0x0000, /* U+0ee9 */
  0x0000, /* U+0eea */
  0x0000, /* U+0eeb */
  0x0000, /* U+0eec */
  0x0000, /* U+0eed */
  0x0000, /* U+0eee */
  0x0000, /* U+0eef */
  0x0000, /* U+0ef0 */
  0x0000, /* U+0ef1 */
  0x0000, /* U+0ef2 */
  0x0000, /* U+0ef3 */
  0x0000, /* U+0ef4 */
  0x0000, /* U+0ef5 */
  0x0000, /* U+0ef6 */
  0x0000, /* U+0ef7 */
  0x0000, /* U+0ef8 */
  0x0000, /* U+0ef9 */
  0x0000, /* U+0efa */
  0x0000, /* U+0efb */
  0x0000, /* U+0efc */
  0x0000, /* U+0efd */
  0x0000, /* U+0efe */
  0x0000, /* U+0eff */
  0x0000, /* U+0f00 */
  0x0000, /* U+0f01 */
  0x0000, /* U+0f02 */
  0x0000, /* U+0f03 */
  0x0000, /* U+0f04 */
  0x0000, /* U+0f05 */
  0x0000, /* U+0f06 */
  0x0000, /* U+0f07 */
  0x0000, /* U+0f08 */
  0x0000, /* U+0f09 */
  0x0000, /* U+0f0a */
  0x0000, /* U+0f0b */
  0x0000, /* U+0f0c */
  0x0000, /* U+0f0d */
  0x0000, /* U+0f0e */
  0x0000, /* U+0f0f */
  0x0000, /* U+0f10 */
  0x0000, /* U+0f11 */
  0x0000, /* U+0f12 */
  0x0000, /* U+0f13 */
  0x0000, /* U+0f14 */
  0x0000, /* U+0f15 */
  0x0000, /* U+0f16 */
  0x0000, /* U+0f17 */
  0x0000, /* U+0f18 */
  0x0000, /* U+0f19 */
  0x0000, /* U+0f1a */
  0x0000, /* U+0f1b */
  0x0000, /* U+0f1c */
  0x0000, /* U+0f1d */
  0x0000, /* U+0f1e */
  0x0000, /* U+0f1f */
  0x0000, /* U+0f20 */
  0x0000, /* U+0f21 */
  0x0000, /* U+0f22 */
  0x0000, /* U+0f23 */
  0x0000, /* U+0f24 */
  0x0000, /* U+0f25 */
  0x0000, /* U+0f26 */
  0x0000, /* U+0f27 */
  0x0000, /* U+0f28 */
  0x0000, /* U+0f29 */
  0x0000, /* U+0f2a */
  0x0000, /* U+0f2b */
  0x0000, /* U+0f2c */
  0x0000, /* U+0f2d */
  0x0000, /* U+0f2e */
  0x0000, /* U+0f2f */
  0x0000, /* U+0f30 */
  0x0000, /* U+0f31 */
  0x0000, /* U+0f32 */
  0x0000, /* U+0f33 */
  0x0000, /* U+0f34 */
  0x0000, /* U+0f35 */
  0x0000, /* U+0f36 */
  0x0000, /* U+0f37 */
  0x0000, /* U+0f38 */
  0x0000, /* U+0f39 */
  0x0000, /* U+0f3a */
  0x0000, /* U+0f3b */
  0x0000, /* U+0f3c */
  0x0000, /* U+0f3d */
  0x0000, /* U+0f3e */
  0x0000, /* U+0f3f */
  0x0000, /* U+0f40 */
  0x0000, /* U+0f41 */
  0x0000, /* U+0f42 */
  0x0000, /* U+0f43 */
  0x0000, /* U+0f44 */
  0x0000, /* U+0f45 */
  0x0000, /* U+0f46 */
  0x0000, /* U+0f47 */
  0x0000, /* U+0f48 */
  0x0000, /* U+0f49 */
  0x0000, /* U+0f4a */
  0x0000, /* U+0f4b */
  0x0000, /* U+0f4c */
  0x0000, /* U+0f4d */
  0x0000, /* U+0f4e */
  0x0000, /* U+0f4f */
  0x0000, /* U+0f50 */
  0x0000, /* U+0f51 */
  0x0000, /* U+0f52 */
  0x0000, /* U+0f53 */
  0x0000, /* U+0f54 */
  0x0000, /* U+0f55 */
  0x0000, /* U+0f56 */
  0x0000, /* U+0f57 */
  0x0000, /* U+0f58 */
  0x0000, /* U+0f59 */
  0x0000, /* U+0f5a */
  0x0000, /* U+0f5b */
  0x0000, /* U+0f5c */
  0x0000, /* U+0f5d */
  0x0000, /* U+0f5e */
  0x0000, /* U+0f5f */
  0x0000, /* U+0f60 */
  0x0000, /* U+0f61 */
  0x0000, /* U+0f62 */
  0x0000, /* U+0f63 */
  0x0000, /* U+0f64 */
  0x0000, /* U+0f65 */
  0x0000, /* U+0f66 */
  0x0000, /* U+0f67 */
  0x0000, /* U+0f68 */
  0x0000, /* U+0f69 */
  0x0000, /* U+0f6a */
  0x0000, /* U+0f6b */
  0x0000, /* U+0f6c */
  0x0000, /* U+0f6d */
  0x0000, /* U+0f6e */
  0x0000, /* U+0f6f */
  0x0000, /* U+0f70 */
  0x0000, /* U+0f71 */
  0x0000, /* U+0f72 */
  0x0000, /* U+0f73 */
  0x0000, /* U+0f74 */
  0x0000, /* U+0f75 */
  0x0000, /* U+0f76 */
  0x0000, /* U+0f77 */
  0x0000, /* U+0f78 */
  0x0000, /* U+0f79 */
  0x0000, /* U+0f7a */
  0x0000, /* U+0f7b */
  0x0000, /* U+0f7c */
  0x0000, /* U+0f7d */
  0x0000, /* U+0f7e */
  0x0000, /* U+0f7f */
  0x0000, /* U+0f80 */
  0x0000, /* U+0f81 */
  0x0000, /* U+0f82 */
  0x0000, /* U+0f83 */
  0x0000, /* U+0f84 */
  0x0000, /* U+0f85 */
  0x0000, /* U+0f86 */
  0x0000, /* U+0f87 */
  0x0000, /* U+0f88 */
  0x0000, /* U+0f89 */
  0x0000, /* U+0f8a */
  0x0000, /* U+0f8b */
  0x0000, /* U+0f8c */
  0x0000, /* U+0f8d */
  0x0000, /* U+0f8e */
  0x0000, /* U+0f8f */
  0x0000, /* U+0f90 */
  0x0000, /* U+0f91 */
  0x0000, /* U+0f92 */
  0x0000, /* U+0f93 */
  0x0000, /* U+0f94 */
  0x0000, /* U+0f95 */
  0x0000, /* U+0f96 */
  0x0000, /* U+0f97 */
  0x0000, /* U+0f98 */
  0x0000, /* U+0f99 */
  0x0000, /* U+0f9a */
  0x0000, /* U+0f9b */
  0x0000, /* U+0f9c */
  0x0000, /* U+0f9d */
  0x0000, /* U+0f9e */
  0x0000, /* U+0f9f */
  0x0000, /* U+0fa0 */
  0x0000, /* U+0fa1 */
  0x0000, /* U+0fa2 */
  0x0000, /* U+0fa3 */
  0x0000, /* U+0fa4 */
  0x0000, /* U+0fa5 */
  0x0000, /* U+0fa6 */
  0x0000, /* U+0fa7 */
  0x0000, /* U+0fa8 */
  0x0000, /* U+0fa9 */
  0x0000, /* U+0faa */
  0x0000, /* U+0fab */
  0x0000, /* U+0fac */
  0x0000, /* U+0fad */
  0x0000, /* U+0fae */
  0x0000, /* U+0faf */
  0x0000, /* U+0fb0 */
  0x0000, /* U+0fb1 */
  0x0000, /* U+0fb2 */
  0x0000, /* U+0fb3 */
  0x0000, /* U+0fb4 */
  0x0000, /* U+0fb5 */
  0x0000, /* U+0fb6 */
  0x0000, /* U+0fb7 */
  0x0000, /* U+0fb8 */
  0x0000, /* U+0fb9 */
  0x0000, /* U+0fba */
  0x0000, /* U+0fbb */
  0x0000, /* U+0fbc */
  0x0000, /* U+0fbd */
  0x0000, /* U+0fbe */
  0x0000, /* U+0fbf */
  0x0000, /* U+0fc0 */
  0x0000, /* U+0fc1 */
  0x0000, /* U+0fc2 */
  0x0000, /* U+0fc3 */
  0x0000, /* U+0fc4 */
  0x0000, /* U+0fc5 */
  0x0000, /* U+0fc6 */
  0x0000, /* U+0fc7 */
  0x0000, /* U+0fc8 */
  0x0000, /* U+0fc9 */
  0x0000, /* U+0fca */
  0x0000, /* U+0fcb */
  0x0000, /* U+0fcc */
  0x0000, /* U+0fcd */
  0x0000, /* U+0fce */
  0x0000, /* U+0fcf */
  0x0000, /* U+0fd0 */
  0x0000, /* U+0fd1 */
  0x0000, /* U+0fd2 */
  0x0000, /* U+0fd3 */
  0x0000, /* U+0fd4 */
  0x0000, /* U+0fd5 */
  0x0000, /* U+0fd6 */
  0x0000, /* U+0fd7 */
  0x0000, /* U+0fd8 */
  0x0000, /* U+0fd9 */
  0x0000, /* U+0fda */
  0x0000, /* U+0fdb */
  0x0000, /* U+0fdc */
  0x0000, /* U+0fdd */
  0x0000, /* U+0fde */
  0x0000, /* U+0fdf */
  0x0000, /* U+0fe0 */
  0x0000, /* U+0fe1 */
  0x0000, /* U+0fe2 */
  0x0000, /* U+0fe3 */
  0x0000, /* U+0fe4 */
  0x0000, /* U+0fe5 */
  0x0000, /* U+0fe6 */
  0x0000, /* U+0fe7 */
  0x0000, /* U+0fe8 */
  0x0000, /* U+0fe9 */
  0x0000, /* U+0fea */
  0x0000, /* U+0feb */
  0x0000, /* U+0fec */
  0x0000, /* U+0fed */
  0x0000, /* U+0fee */
  0x0000, /* U+0fef */
  0x0000, /* U+0ff0 */
  0x0000, /* U+0ff1 */
  0x0000, /* U+0ff2 */
  0x0000, /* U+0ff3 */
  0x0000, /* U+0ff4 */
  0x0000, /* U+0ff5 */
  0x0000, /* U+0ff6 */
  0x0000, /* U+0ff7 */
  0x0000, /* U+0ff8 */
  0x0000, /* U+0ff9 */
  0x0000, /* U+0ffa */
  0x0000, /* U+0ffb */
  0x0000, /* U+0ffc */
  0x0000, /* U+0ffd */
  0x0000, /* U+0ffe */
  0x0000, /* U+0fff */
  0x0000, /* U+1000 */
  0x0000, /* U+1001 */
  0x0000, /* U+1002 */
  0x0000, /* U+1003 */
  0x0000, /* U+1004 */
  0x0000, /* U+1005 */
  0x0000, /* U+1006 */
  0x0000, /* U+1007 */
  0x0000, /* U+1008 */
  0x0000, /* U+1009 */
  0x0000, /* U+100a */
  0x0000, /* U+100b */
  0x0000, /* U+100c */
  0x0000, /* U+100d */
  0x0000, /* U+100e */
  0x0000, /* U+100f */
  0x0000, /* U+1010 */
  0x0000, /* U+1011 */
  0x0000, /* U+1012 */
  0x0000, /* U+1013 */
  0x0000, /* U+1014 */
  0x0000, /* U+1015 */
  0x0000, /* U+1016 */
  0x0000, /* U+1017 */
  0x0000, /* U+1018 */
  0x0000, /* U+1019 */
  0x0000, /* U+101a */
  0x0000, /* U+101b */
  0x0000, /* U+101c */
  0x0000, /* U+101d */
  0x0000, /* U+101e */
  0x0000, /* U+101f */
  0x0000, /* U+1020 */
  0x0000, /* U+1021 */
  0x0000, /* U+1022 */
  0x0000, /* U+1023 */
  0x0000, /* U+1024 */
  0x0000, /* U+1025 */
  0x0000, /* U+1026 */
  0x0000, /* U+1027 */
  0x0000, /* U+1028 */
  0x0000, /* U+1029 */
  0x0000, /* U+102a */
  0x0000, /* U+102b */
  0x0000, /* U+102c */
  0x0000, /* U+102d */
  0x0000, /* U+102e */
  0x0000, /* U+102f */
  0x0000, /* U+1030 */
  0x0000, /* U+1031 */
  0x0000, /* U+1032 */
  0x0000, /* U+1033 */
  0x0000, /* U+1034 */
  0x0000, /* U+1035 */
  0x0000, /* U+1036 */
  0x0000, /* U+1037 */
  0x0000, /* U+1038 */
  0x0000, /* U+1039 */
  0x0000, /* U+103a */
  0x0000, /* U+103b */
  0x0000, /* U+103c */
  0x0000, /* U+103d */
  0x0000, /* U+103e */
  0x0000, /* U+103f */
  0x0000, /* U+1040 */
  0x0000, /* U+1041 */
  0x0000, /* U+1042 */
  0x0000, /* U+1043 */
  0x0000, /* U+1044 */
  0x0000, /* U+1045 */
  0x0000, /* U+1046 */
  0x0000, /* U+1047 */
  0x0000, /* U+1048 */
  0x0000, /* U+1049 */
  0x0000, /* U+104a */
  0x0000, /* U+104b */
  0x0000, /* U+104c */
  0x0000, /* U+104d */
  0x0000, /* U+104e */
  0x0000, /* U+104f */
  0x0000, /* U+1050 */
  0x0000, /* U+1051 */
  0x0000, /* U+1052 */
  0x0000, /* U+1053 */
  0x0000, /* U+1054 */
  0x0000, /* U+1055 */
  0x0000, /* U+1056 */
  0x0000, /* U+1057 */
  0x0000, /* U+1058 */
  0x0000, /* U+1059 */
  0x0000, /* U+105a */
  0x0000, /* U+105b */
  0x0000, /* U+105c */
  0x0000, /* U+105d */
  0x0000, /* U+105e */
  0x0000, /* U+105f */
  0x0000, /* U+1060 */
  0x0000, /* U+1061 */
  0x0000, /* U+1062 */
  0x0000, /* U+1063 */
  0x0000, /* U+1064 */
  0x0000, /* U+1065 */
  0x0000, /* U+1066 */
  0x0000, /* U+1067 */
  0x0000, /* U+1068 */
  0x0000, /* U+1069 */
  0x0000, /* U+106a */
  0x0000, /* U+106b */
  0x0000, /* U+106c */
  0x0000, /* U+106d */
  0x0000, /* U+106e */
  0x0000, /* U+106f */
  0x0000, /* U+1070 */
  0x0000, /* U+1071 */
  0x0000, /* U+1072 */
  0x0000, /* U+1073 */
  0x0000, /* U+1074 */
  0x0000, /* U+1075 */
  0x0000, /* U+1076 */
  0x0000, /* U+1077 */
  0x0000, /* U+1078 */
  0x0000, /* U+1079 */
  0x0000, /* U+107a */
  0x0000, /* U+107b */
  0x0000, /* U+107c */
  0x0000, /* U+107d */
  0x0000, /* U+107e */
  0x0000, /* U+107f */
  0x0000, /* U+1080 */
  0x0000, /* U+1081 */
  0x0000, /* U+1082 */
  0x0000, /* U+1083 */
  0x0000, /* U+1084 */
  0x0000, /* U+1085 */
  0x0000, /* U+1086 */
  0x0000, /* U+1087 */
  0x0000, /* U+1088 */
  0x0000, /* U+1089 */
  0x0000, /* U+108a */
  0x0000, /* U+108b */
  0x0000, /* U+108c */
  0x0000, /* U+108d */
  0x0000, /* U+108e */
  0x0000, /* U+108f */
  0x0000, /* U+1090 */
  0x0000, /* U+1091 */
  0x0000, /* U+1092 */
  0x0000, /* U+1093 */
  0x0000, /* U+1094 */
  0x0000, /* U+1095 */
  0x0000, /* U+1096 */
  0x0000, /* U+1097 */
  0x0000, /* U+1098 */
  0x0000, /* U+1099 */
  0x0000, /* U+109a */
  0x0000, /* U+109b */
  0x0000, /* U+109c */
  0x0000, /* U+109d */
  0x0000, /* U+109e */
  0x0000, /* U+109f */
  0x0000, /* U+10a0 */
  0x0000, /* U+10a1 */
  0x0000, /* U+10a2 */
  0x0000, /* U+10a3 */
  0x0000, /* U+10a4 */
  0x0000, /* U+10a5 */
  0x0000, /* U+10a6 */
  0x0000, /* U+10a7 */
  0x0000, /* U+10a8 */
  0x0000, /* U+10a9 */
  0x0000, /* U+10aa */
  0x0000, /* U+10ab */
  0x0000, /* U+10ac */
  0x0000, /* U+10ad */
  0x0000, /* U+10ae */
  0x0000, /* U+10af */
  0x0000, /* U+10b0 */
  0x0000, /* U+10b1 */
  0x0000, /* U+10b2 */
  0x0000, /* U+10b3 */
  0x0000, /* U+10b4 */
  0x0000, /* U+10b5 */
  0x0000, /* U+10b6 */
  0x0000, /* U+10b7 */
  0x0000, /* U+10b8 */
  0x0000, /* U+10b9 */
  0x0000, /* U+10ba */
  0x0000, /* U+10bb */
  0x0000, /* U+10bc */
  0x0000, /* U+10bd */
  0x0000, /* U+10be */
  0x0000, /* U+10bf */
  0x0000, /* U+10c0 */
  0x0000, /* U+10c1 */
  0x0000, /* U+10c2 */
  0x0000, /* U+10c3 */
  0x0000, /* U+10c4 */
  0x0000, /* U+10c5 */
  0x0000, /* U+10c6 */
  0x0000, /* U+10c7 */
  0x0000, /* U+10c8 */
  0x0000, /* U+10c9 */
  0x0000, /* U+10ca */
  0x0000, /* U+10cb */
  0x0000, /* U+10cc */
  0x0000, /* U+10cd */
  0x0000, /* U+10ce */
  0x0000, /* U+10cf */
  0x0000, /* U+10d0 */
  0x0000, /* U+10d1 */
  0x0000, /* U+10d2 */
  0x0000, /* U+10d3 */
  0x0000, /* U+10d4 */
  0x0000, /* U+10d5 */
  0x0000, /* U+10d6 */
  0x0000, /* U+10d7 */
  0x0000, /* U+10d8 */
  0x0000, /* U+10d9 */
  0x0000, /* U+10da */
  0x0000, /* U+10db */
  0x0000, /* U+10dc */
  0x0000, /* U+10dd */
  0x0000, /* U+10de */
  0x0000, /* U+10df */
  0x0000, /* U+10e0 */
  0x0000, /* U+10e1 */
  0x0000, /* U+10e2 */
  0x0000, /* U+10e3 */
  0x0000, /* U+10e4 */
  0x0000, /* U+10e5 */
  0x0000, /* U+10e6 */
  0x0000, /* U+10e7 */
  0x0000, /* U+10e8 */
  0x0000, /* U+10e9 */
  0x0000, /* U+10ea */
  0x0000, /* U+10eb */
  0x0000, /* U+10ec */
  0x0000, /* U+10ed */
  0x0000, /* U+10ee */
  0x0000, /* U+10ef */
  0x0000, /* U+10f0 */
  0x0000, /* U+10f1 */
  0x0000, /* U+10f2 */
  0x0000, /* U+10f3 */
  0x0000, /* U+10f4 */
  0x0000, /* U+10f5 */
  0x0000, /* U+10f6 */
  0x0000, /* U+10f7 */
  0x0000, /* U+10f8 */
  0x0000, /* U+10f9 */
  0x0000, /* U+10fa */
  0x0000, /* U+10fb */
  0x0000, /* U+10fc */
  0x0000, /* U+10fd */
  0x0000, /* U+10fe */
  0x0000, /* U+10ff */
  0x0000, /* U+1100 */
  0x0000, /* U+1101 */
  0x0000, /* U+1102 */
  0x0000, /* U+1103 */
  0x0000, /* U+1104 */
  0x0000, /* U+1105 */
  0x0000, /* U+1106 */
  0x0000, /* U+1107 */
  0x0000, /* U+1108 */
  0x0000, /* U+1109 */
  0x0000, /* U+110a */
  0x0000, /* U+110b */
  0x0000, /* U+110c */
  0x0000, /* U+110d */
  0x0000, /* U+110e */
  0x0000, /* U+110f */
  0x0000, /* U+1110 */
  0x0000, /* U+1111 */
  0x0000, /* U+1112 */
  0x0000, /* U+1113 */
  0x0000, /* U+1114 */
  0x0000, /* U+1115 */
  0x0000, /* U+1116 */
  0x0000, /* U+1117 */
  0x0000, /* U+1118 */
  0x0000, /* U+1119 */
  0x0000, /* U+111a */
  0x0000, /* U+111b */
  0x0000, /* U+111c */
  0x0000, /* U+111d */
  0x0000, /* U+111e */
  0x0000, /* U+111f */
  0x0000, /* U+1120 */
  0x0000, /* U+1121 */
  0x0000, /* U+1122 */
  0x0000, /* U+1123 */
  0x0000, /* U+1124 */
  0x0000, /* U+1125 */
  0x0000, /* U+1126 */
  0x0000, /* U+1127 */
  0x0000, /* U+1128 */
  0x0000, /* U+1129 */
  0x0000, /* U+112a */
  0x0000, /* U+112b */
  0x0000, /* U+112c */
  0x0000, /* U+112d */
  0x0000, /* U+112e */
  0x0000, /* U+112f */
  0x0000, /* U+1130 */
  0x0000, /* U+1131 */
  0x0000, /* U+1132 */
  0x0000, /* U+1133 */
  0x0000, /* U+1134 */
  0x0000, /* U+1135 */
  0x0000, /* U+1136 */
  0x0000, /* U+1137 */
  0x0000, /* U+1138 */
  0x0000, /* U+1139 */
  0x0000, /* U+113a */
  0x0000, /* U+113b */
  0x0000, /* U+113c */
  0x0000, /* U+113d */
  0x0000, /* U+113e */
  0x0000, /* U+113f */
  0x0000, /* U+1140 */
  0x0000, /* U+1141 */
  0x0000, /* U+1142 */
  0x0000, /* U+1143 */
  0x0000, /* U+1144 */
  0x0000, /* U+1145 */
  0x0000, /* U+1146 */
  0x0000, /* U+1147 */
  0x0000, /* U+1148 */
  0x0000, /* U+1149 */
  0x0000, /* U+114a */
  0x0000, /* U+114b */
  0x0000, /* U+114c */
  0x0000, /* U+114d */
  0x0000, /* U+114e */
  0x0000, /* U+114f */
  0x0000, /* U+1150 */
  0x0000, /* U+1151 */
  0x0000, /* U+1152 */
  0x0000, /* U+1153 */
  0x0000, /* U+1154 */
  0x0000, /* U+1155 */
  0x0000, /* U+1156 */
  0x0000, /* U+1157 */
  0x0000, /* U+1158 */
  0x0000, /* U+1159 */
  0x0000, /* U+115a */
  0x0000, /* U+115b */
  0x0000, /* U+115c */
  0x0000, /* U+115d */
  0x0000, /* U+115e */
  0x0000, /* U+115f */
  0x0000, /* U+1160 */
  0x0000, /* U+1161 */
  0x0000, /* U+1162 */
  0x0000, /* U+1163 */
  0x0000, /* U+1164 */
  0x0000, /* U+1165 */
  0x0000, /* U+1166 */
  0x0000, /* U+1167 */
  0x0000, /* U+1168 */
  0x0000, /* U+1169 */
  0x0000, /* U+116a */
  0x0000, /* U+116b */
  0x0000, /* U+116c */
  0x0000, /* U+116d */
  0x0000, /* U+116e */
  0x0000, /* U+116f */
  0x0000, /* U+1170 */
  0x0000, /* U+1171 */
  0x0000, /* U+1172 */
  0x0000, /* U+1173 */
  0x0000, /* U+1174 */
  0x0000, /* U+1175 */
  0x0000, /* U+1176 */
  0x0000, /* U+1177 */
  0x0000, /* U+1178 */
  0x0000, /* U+1179 */
  0x0000, /* U+117a */
  0x0000, /* U+117b */
  0x0000, /* U+117c */
  0x0000, /* U+117d */
  0x0000, /* U+117e */
  0x0000, /* U+117f */
  0x0000, /* U+1180 */
  0x0000, /* U+1181 */
  0x0000, /* U+1182 */
  0x0000, /* U+1183 */
  0x0000, /* U+1184 */
  0x0000, /* U+1185 */
  0x0000, /* U+1186 */
  0x0000, /* U+1187 */
  0x0000, /* U+1188 */
  0x0000, /* U+1189 */
  0x0000, /* U+118a */
  0x0000, /* U+118b */
  0x0000, /* U+118c */
  0x0000, /* U+118d */
  0x0000, /* U+118e */
  0x0000, /* U+118f */
  0x0000, /* U+1190 */
  0x0000, /* U+1191 */
  0x0000, /* U+1192 */
  0x0000, /* U+1193 */
  0x0000, /* U+1194 */
  0x0000, /* U+1195 */
  0x0000, /* U+1196 */
  0x0000, /* U+1197 */
  0x0000, /* U+1198 */
  0x0000, /* U+1199 */
  0x0000, /* U+119a */
  0x0000, /* U+119b */
  0x0000, /* U+119c */
  0x0000, /* U+119d */
  0x0000, /* U+119e */
  0x0000, /* U+119f */
  0x0000, /* U+11a0 */
  0x0000, /* U+11a1 */
  0x0000, /* U+11a2 */
  0x0000, /* U+11a3 */
  0x0000, /* U+11a4 */
  0x0000, /* U+11a5 */
  0x0000, /* U+11a6 */
  0x0000, /* U+11a7 */
  0x0000, /* U+11a8 */
  0x0000, /* U+11a9 */
  0x0000, /* U+11aa */
  0x0000, /* U+11ab */
  0x0000, /* U+11ac */
  0x0000, /* U+11ad */
  0x0000, /* U+11ae */
  0x0000, /* U+11af */
  0x0000, /* U+11b0 */
  0x0000, /* U+11b1 */
  0x0000, /* U+11b2 */
  0x0000, /* U+11b3 */
  0x0000, /* U+11b4 */
  0x0000, /* U+11b5 */
  0x0000, /* U+11b6 */
  0x0000, /* U+11b7 */
  0x0000, /* U+11b8 */
  0x0000, /* U+11b9 */
  0x0000, /* U+11ba */
  0x0000, /* U+11bb */
  0x0000, /* U+11bc */
  0x0000, /* U+11bd */
  0x0000, /* U+11be */
  0x0000, /* U+11bf */
  0x0000, /* U+11c0 */
  0x0000, /* U+11c1 */
  0x0000, /* U+11c2 */
  0x0000, /* U+11c3 */
  0x0000, /* U+11c4 */
  0x0000, /* U+11c5 */
  0x0000, /* U+11c6 */
  0x0000, /* U+11c7 */
  0x0000, /* U+11c8 */
  0x0000, /* U+11c9 */
  0x0000, /* U+11ca */
  0x0000, /* U+11cb */
  0x0000, /* U+11cc */
  0x0000, /* U+11cd */
  0x0000, /* U+11ce */
  0x0000, /* U+11cf */
  0x0000, /* U+11d0 */
  0x0000, /* U+11d1 */
  0x0000, /* U+11d2 */
  0x0000, /* U+11d3 */
  0x0000, /* U+11d4 */
  0x0000, /* U+11d5 */
  0x0000, /* U+11d6 */
  0x0000, /* U+11d7 */
  0x0000, /* U+11d8 */
  0x0000, /* U+11d9 */
  0x0000, /* U+11da */
  0x0000, /* U+11db */
  0x0000, /* U+11dc */
  0x0000, /* U+11dd */
  0x0000, /* U+11de */
  0x0000, /* U+11df */
  0x0000, /* U+11e0 */
  0x0000, /* U+11e1 */
  0x0000, /* U+11e2 */
  0x0000, /* U+11e3 */
  0x0000, /* U+11e4 */
  0x0000, /* U+11e5 */
  0x0000, /* U+11e6 */
  0x0000, /* U+11e7 */
  0x0000, /* U+11e8 */
  0x0000, /* U+11e9 */
  0x0000, /* U+11ea */
  0x0000, /* U+11eb */
  0x0000, /* U+11ec */
  0x0000, /* U+11ed */
  0x0000, /* U+11ee */
  0x0000, /* U+11ef */
  0x0000, /* U+11f0 */
  0x0000, /* U+11f1 */
  0x0000, /* U+11f2 */
  0x0000, /* U+11f3 */
  0x0000, /* U+11f4 */
  0x0000, /* U+11f5 */
  0x0000, /* U+11f6 */
  0x0000, /* U+11f7 */
  0x0000, /* U+11f8 */
  0x0000, /* U+11f9 */
  0x0000, /* U+11fa */
  0x0000, /* U+11fb */
  0x0000, /* U+11fc */
  0x0000, /* U+11fd */
  0x0000, /* U+11fe */
  0x0000, /* U+11ff */
  0x0000, /* U+1200 */
  0x0000, /* U+1201 */
  0x0000, /* U+1202 */
  0x0000, /* U+1203 */
  0x0000, /* U+1204 */
  0x0000, /* U+1205 */
  0x0000, /* U+1206 */
  0x0000, /* U+1207 */
  0x0000, /* U+1208 */
  0x0000, /* U+1209 */
  0x0000, /* U+120a */
  0x0000, /* U+120b */
  0x0000, /* U+120c */
  0x0000, /* U+120d */
  0x0000, /* U+120e */
  0x0000, /* U+120f */
  0x0000, /* U+1210 */
  0x0000, /* U+1211 */
  0x0000, /* U+1212 */
  0x0000, /* U+1213 */
  0x0000, /* U+1214 */
  0x0000, /* U+1215 */
  0x0000, /* U+1216 */
  0x0000, /* U+1217 */
  0x0000, /* U+1218 */
  0x0000, /* U+1219 */
  0x0000, /* U+121a */
  0x0000, /* U+121b */
  0x0000, /* U+121c */
  0x0000, /* U+121d */
  0x0000, /* U+121e */
  0x0000, /* U+121f */
  0x0000, /* U+1220 */
  0x0000, /* U+1221 */
  0x0000, /* U+1222 */
  0x0000, /* U+1223 */
  0x0000, /* U+1224 */
  0x0000, /* U+1225 */
  0x0000, /* U+1226 */
  0x0000, /* U+1227 */
  0x0000, /* U+1228 */
  0x0000, /* U+1229 */
  0x0000, /* U+122a */
  0x0000, /* U+122b */
  0x0000, /* U+122c */
  0x0000, /* U+122d */
  0x0000, /* U+122e */
  0x0000, /* U+122f */
  0x0000, /* U+1230 */
  0x0000, /* U+1231 */
  0x0000, /* U+1232 */
  0x0000, /* U+1233 */
  0x0000, /* U+1234 */
  0x0000, /* U+1235 */
  0x0000, /* U+1236 */
  0x0000, /* U+1237 */
  0x0000, /* U+1238 */
  0x0000, /* U+1239 */
  0x0000, /* U+123a */
  0x0000, /* U+123b */
  0x0000, /* U+123c */
  0x0000, /* U+123d */
  0x0000, /* U+123e */
  0x0000, /* U+123f */
  0x0000, /* U+1240 */
  0x0000, /* U+1241 */
  0x0000, /* U+1242 */
  0x0000, /* U+1243 */
  0x0000, /* U+1244 */
  0x0000, /* U+1245 */
  0x0000, /* U+1246 */
  0x0000, /* U+1247 */
  0x0000, /* U+1248 */
  0x0000, /* U+1249 */
  0x0000, /* U+124a */
  0x0000, /* U+124b */
  0x0000, /* U+124c */
  0x0000, /* U+124d */
  0x0000, /* U+124e */
  0x0000, /* U+124f */
  0x0000, /* U+1250 */
  0x0000, /* U+1251 */
  0x0000, /* U+1252 */
  0x0000, /* U+1253 */
  0x0000, /* U+1254 */
  0x0000, /* U+1255 */
  0x0000, /* U+1256 */
  0x0000, /* U+1257 */
  0x0000, /* U+1258 */
  0x0000, /* U+1259 */
  0x0000, /* U+125a */
  0x0000, /* U+125b */
  0x0000, /* U+125c */
  0x0000, /* U+125d */
  0x0000, /* U+125e */
  0x0000, /* U+125f */
  0x0000, /* U+1260 */
  0x0000, /* U+1261 */
  0x0000, /* U+1262 */
  0x0000, /* U+1263 */
  0x0000, /* U+1264 */
  0x0000, /* U+1265 */
  0x0000, /* U+1266 */
  0x0000, /* U+1267 */
  0x0000, /* U+1268 */
  0x0000, /* U+1269 */
  0x0000, /* U+126a */
  0x0000, /* U+126b */
  0x0000, /* U+126c */
  0x0000, /* U+126d */
  0x0000, /* U+126e */
  0x0000, /* U+126f */
  0x0000, /* U+1270 */
  0x0000, /* U+1271 */
  0x0000, /* U+1272 */
  0x0000, /* U+1273 */
  0x0000, /* U+1274 */
  0x0000, /* U+1275 */
  0x0000, /* U+1276 */
  0x0000, /* U+1277 */
  0x0000, /* U+1278 */
  0x0000, /* U+1279 */
  0x0000, /* U+127a */
  0x0000, /* U+127b */
  0x0000, /* U+127c */
  0x0000, /* U+127d */
  0x0000, /* U+127e */
  0x0000, /* U+127f */
  0x0000, /* U+1280 */
  0x0000, /* U+1281 */
  0x0000, /* U+1282 */
  0x0000, /* U+1283 */
  0x0000, /* U+1284 */
  0x0000, /* U+1285 */
  0x0000, /* U+1286 */
  0x0000, /* U+1287 */
  0x0000, /* U+1288 */
  0x0000, /* U+1289 */
  0x0000, /* U+128a */
  0x0000, /* U+128b */
  0x0000, /* U+128c */
  0x0000, /* U+128d */
  0x0000, /* U+128e */
  0x0000, /* U+128f */
  0x0000, /* U+1290 */
  0x0000, /* U+1291 */
  0x0000, /* U+1292 */
  0x0000, /* U+1293 */
  0x0000, /* U+1294 */
  0x0000, /* U+1295 */
  0x0000, /* U+1296 */
  0x0000, /* U+1297 */
  0x0000, /* U+1298 */
  0x0000, /* U+1299 */
  0x0000, /* U+129a */
  0x0000, /* U+129b */
  0x0000, /* U+129c */
  0x0000, /* U+129d */
  0x0000, /* U+129e */
  0x0000, /* U+129f */
  0x0000, /* U+12a0 */
  0x0000, /* U+12a1 */
  0x0000, /* U+12a2 */
  0x0000, /* U+12a3 */
  0x0000, /* U+12a4 */
  0x0000, /* U+12a5 */
  0x0000, /* U+12a6 */
  0x0000, /* U+12a7 */
  0x0000, /* U+12a8 */
  0x0000, /* U+12a9 */
  0x0000, /* U+12aa */
  0x0000, /* U+12ab */
  0x0000, /* U+12ac */
  0x0000, /* U+12ad */
  0x0000, /* U+12ae */
  0x0000, /* U+12af */
  0x0000, /* U+12b0 */
  0x0000, /* U+12b1 */
  0x0000, /* U+12b2 */
  0x0000, /* U+12b3 */
  0x0000, /* U+12b4 */
  0x0000, /* U+12b5 */
  0x0000, /* U+12b6 */
  0x0000, /* U+12b7 */
  0x0000, /* U+12b8 */
  0x0000, /* U+12b9 */
  0x0000, /* U+12ba */
  0x0000, /* U+12bb */
  0x0000, /* U+12bc */
  0x0000, /* U+12bd */
  0x0000, /* U+12be */
  0x0000, /* U+12bf */
  0x0000, /* U+12c0 */
  0x0000, /* U+12c1 */
  0x0000, /* U+12c2 */
  0x0000, /* U+12c3 */
  0x0000, /* U+12c4 */
  0x0000, /* U+12c5 */
  0x0000, /* U+12c6 */
  0x0000, /* U+12c7 */
  0x0000, /* U+12c8 */
  0x0000, /* U+12c9 */
  0x0000, /* U+12ca */
  0x0000, /* U+12cb */
  0x0000, /* U+12cc */
  0x0000, /* U+12cd */
  0x0000, /* U+12ce */
  0x0000, /* U+12cf */
  0x0000, /* U+12d0 */
  0x0000, /* U+12d1 */
  0x0000, /* U+12d2 */
  0x0000, /* U+12d3 */
  0x0000, /* U+12d4 */
  0x0000, /* U+12d5 */
  0x0000, /* U+12d6 */
  0x0000, /* U+12d7 */
  0x0000, /* U+12d8 */
  0x0000, /* U+12d9 */
  0x0000, /* U+12da */
  0x0000, /* U+12db */
  0x0000, /* U+12dc */
  0x0000, /* U+12dd */
  0x0000, /* U+12de */
  0x0000, /* U+12df */
  0x0000, /* U+12e0 */
  0x0000, /* U+12e1 */
  0x0000, /* U+12e2 */
  0x0000, /* U+12e3 */
  0x0000, /* U+12e4 */
  0x0000, /* U+12e5 */
  0x0000, /* U+12e6 */
  0x0000, /* U+12e7 */
  0x0000, /* U+12e8 */
  0x0000, /* U+12e9 */
  0x0000, /* U+12ea */
  0x0000, /* U+12eb */
  0x0000, /* U+12ec */
  0x0000, /* U+12ed */
  0x0000, /* U+12ee */
  0x0000, /* U+12ef */
  0x0000, /* U+12f0 */
  0x0000, /* U+12f1 */
  0x0000, /* U+12f2 */
  0x0000, /* U+12f3 */
  0x0000, /* U+12f4 */
  0x0000, /* U+12f5 */
  0x0000, /* U+12f6 */
  0x0000, /* U+12f7 */
  0x0000, /* U+12f8 */
  0x0000, /* U+12f9 */
  0x0000, /* U+12fa */
  0x0000, /* U+12fb */
  0x0000, /* U+12fc */
  0x0000, /* U+12fd */
  0x0000, /* U+12fe */
  0x0000, /* U+12ff */
  0x0000, /* U+1300 */
  0x0000, /* U+1301 */
  0x0000, /* U+1302 */
  0x0000, /* U+1303 */
  0x0000, /* U+1304 */
  0x0000, /* U+1305 */
  0x0000, /* U+1306 */
  0x0000, /* U+1307 */
  0x0000, /* U+1308 */
  0x0000, /* U+1309 */
  0x0000, /* U+130a */
  0x0000, /* U+130b */
  0x0000, /* U+130c */
  0x0000, /* U+130d */
  0x0000, /* U+130e */
  0x0000, /* U+130f */
  0x0000, /* U+1310 */
  0x0000, /* U+1311 */
  0x0000, /* U+1312 */
  0x0000, /* U+1313 */
  0x0000, /* U+1314 */
  0x0000, /* U+1315 */
  0x0000, /* U+1316 */
  0x0000, /* U+1317 */
  0x0000, /* U+1318 */
  0x0000, /* U+1319 */
  0x0000, /* U+131a */
  0x0000, /* U+131b */
  0x0000, /* U+131c */
  0x0000, /* U+131d */
  0x0000, /* U+131e */
  0x0000, /* U+131f */
  0x0000, /* U+1320 */
  0x0000, /* U+1321 */
  0x0000, /* U+1322 */
  0x0000, /* U+1323 */
  0x0000, /* U+1324 */
  0x0000, /* U+1325 */
  0x0000, /* U+1326 */
  0x0000, /* U+1327 */
  0x0000, /* U+1328 */
  0x0000, /* U+1329 */
  0x0000, /* U+132a */
  0x0000, /* U+132b */
  0x0000, /* U+132c */
  0x0000, /* U+132d */
  0x0000, /* U+132e */
  0x0000, /* U+132f */
  0x0000, /* U+1330 */
  0x0000, /* U+1331 */
  0x0000, /* U+1332 */
  0x0000, /* U+1333 */
  0x0000, /* U+1334 */
  0x0000, /* U+1335 */
  0x0000, /* U+1336 */
  0x0000, /* U+1337 */
  0x0000, /* U+1338 */
  0x0000, /* U+1339 */
  0x0000, /* U+133a */
  0x0000, /* U+133b */
  0x0000, /* U+133c */
  0x0000, /* U+133d */
  0x0000, /* U+133e */
  0x0000, /* U+133f */
  0x0000, /* U+1340 */
  0x0000, /* U+1341 */
  0x0000, /* U+1342 */
  0x0000, /* U+1343 */
  0x0000, /* U+1344 */
  0x0000, /* U+1345 */
  0x0000, /* U+1346 */
  0x0000, /* U+1347 */
  0x0000, /* U+1348 */
  0x0000, /* U+1349 */
  0x0000, /* U+134a */
  0x0000, /* U+134b */
  0x0000, /* U+134c */
  0x0000, /* U+134d */
  0x0000, /* U+134e */
  0x0000, /* U+134f */
  0x0000, /* U+1350 */
  0x0000, /* U+1351 */
  0x0000, /* U+1352 */
  0x0000, /* U+1353 */
  0x0000, /* U+1354 */
  0x0000, /* U+1355 */
  0x0000, /* U+1356 */
  0x0000, /* U+1357 */
  0x0000, /* U+1358 */
  0x0000, /* U+1359 */
  0x0000, /* U+135a */
  0x0000, /* U+135b */
  0x0000, /* U+135c */
  0x0000, /* U+135d */
  0x0000, /* U+135e */
  0x0000, /* U+135f */
  0x0000, /* U+1360 */
  0x0000, /* U+1361 */
  0x0000, /* U+1362 */
  0x0000, /* U+1363 */
  0x0000, /* U+1364 */
  0x0000, /* U+1365 */
  0x0000, /* U+1366 */
  0x0000, /* U+1367 */
  0x0000, /* U+1368 */
  0x0000, /* U+1369 */
  0x0000, /* U+136a */
  0x0000, /* U+136b */
  0x0000, /* U+136c */
  0x0000, /* U+136d */
  0x0000, /* U+136e */
  0x0000, /* U+136f */
  0x0000, /* U+1370 */
  0x0000, /* U+1371 */
  0x0000, /* U+1372 */
  0x0000, /* U+1373 */
  0x0000, /* U+1374 */
  0x0000, /* U+1375 */
  0x0000, /* U+1376 */
  0x0000, /* U+1377 */
  0x0000, /* U+1378 */
  0x0000, /* U+1379 */
  0x0000, /* U+137a */
  0x0000, /* U+137b */
  0x0000, /* U+137c */
  0x0000, /* U+137d */
  0x0000, /* U+137e */
  0x0000, /* U+137f */
  0x0000, /* U+1380 */
  0x0000, /* U+1381 */
  0x0000, /* U+1382 */
  0x0000, /* U+1383 */
  0x0000, /* U+1384 */
  0x0000, /* U+1385 */
  0x0000, /* U+1386 */
  0x0000, /* U+1387 */
  0x0000, /* U+1388 */
  0x0000, /* U+1389 */
  0x0000, /* U+138a */
  0x0000, /* U+138b */
  0x0000, /* U+138c */
  0x0000, /* U+138d */
  0x0000, /* U+138e */
  0x0000, /* U+138f */
  0x0000, /* U+1390 */
  0x0000, /* U+1391 */
  0x0000, /* U+1392 */
  0x0000, /* U+1393 */
  0x0000, /* U+1394 */
  0x0000, /* U+1395 */
  0x0000, /* U+1396 */
  0x0000, /* U+1397 */
  0x0000, /* U+1398 */
  0x0000, /* U+1399 */
  0x0000, /* U+139a */
  0x0000, /* U+139b */
  0x0000, /* U+139c */
  0x0000, /* U+139d */
  0x0000, /* U+139e */
  0x0000, /* U+139f */
  0x0000, /* U+13a0 */
  0x0000, /* U+13a1 */
  0x0000, /* U+13a2 */
  0x0000, /* U+13a3 */
  0x0000, /* U+13a4 */
  0x0000, /* U+13a5 */
  0x0000, /* U+13a6 */
  0x0000, /* U+13a7 */
  0x0000, /* U+13a8 */
  0x0000, /* U+13a9 */
  0x0000, /* U+13aa */
  0x0000, /* U+13ab */
  0x0000, /* U+13ac */
  0x0000, /* U+13ad */
  0x0000, /* U+13ae */
  0x0000, /* U+13af */
  0x0000, /* U+13b0 */
  0x0000, /* U+13b1 */
  0x0000, /* U+13b2 */
  0x0000, /* U+13b3 */
  0x0000, /* U+13b4 */
  0x0000, /* U+13b5 */
  0x0000, /* U+13b6 */
  0x0000, /* U+13b7 */
  0x0000, /* U+13b8 */
  0x0000, /* U+13b9 */
  0x0000, /* U+13ba */
  0x0000, /* U+13bb */
  0x0000, /* U+13bc */
  0x0000, /* U+13bd */
  0x0000, /* U+13be */
  0x0000, /* U+13bf */
  0x0000, /* U+13c0 */
  0x0000, /* U+13c1 */
  0x0000, /* U+13c2 */
  0x0000, /* U+13c3 */
  0x0000, /* U+13c4 */
  0x0000, /* U+13c5 */
  0x0000, /* U+13c6 */
  0x0000, /* U+13c7 */
  0x0000, /* U+13c8 */
  0x0000, /* U+13c9 */
  0x0000, /* U+13ca */
  0x0000, /* U+13cb */
  0x0000, /* U+13cc */
  0x0000, /* U+13cd */
  0x0000, /* U+13ce */
  0x0000, /* U+13cf */
  0x0000, /* U+13d0 */
  0x0000, /* U+13d1 */
  0x0000, /* U+13d2 */
  0x0000, /* U+13d3 */
  0x0000, /* U+13d4 */
  0x0000, /* U+13d5 */
  0x0000, /* U+13d6 */
  0x0000, /* U+13d7 */
  0x0000, /* U+13d8 */
  0x0000, /* U+13d9 */
  0x0000, /* U+13da */
  0x0000, /* U+13db */
  0x0000, /* U+13dc */
  0x0000, /* U+13dd */
  0x0000, /* U+13de */
  0x0000, /* U+13df */
  0x0000, /* U+13e0 */
  0x0000, /* U+13e1 */
  0x0000, /* U+13e2 */
  0x0000, /* U+13e3 */
  0x0000, /* U+13e4 */
  0x0000, /* U+13e5 */
  0x0000, /* U+13e6 */
  0x0000, /* U+13e7 */
  0x0000, /* U+13e8 */
  0x0000, /* U+13e9 */
  0x0000, /* U+13ea */
  0x0000, /* U+13eb */
  0x0000, /* U+13ec */
  0x0000, /* U+13ed */
  0x0000, /* U+13ee */
  0x0000, /* U+13ef */
  0x0000, /* U+13f0 */
  0x0000, /* U+13f1 */
  0x0000, /* U+13f2 */
  0x0000, /* U+13f3 */
  0x0000, /* U+13f4 */
  0x0000, /* U+13f5 */
  0x0000, /* U+13f6 */
  0x0000, /* U+13f7 */
  0x0000, /* U+13f8 */
  0x0000, /* U+13f9 */
  0x0000, /* U+13fa */
  0x0000, /* U+13fb */
  0x0000, /* U+13fc */
  0x0000, /* U+13fd */
  0x0000, /* U+13fe */
  0x0000, /* U+13ff */
  0x0000, /* U+1400 */
  0x0000, /* U+1401 */
  0x0000, /* U+1402 */
  0x0000, /* U+1403 */
  0x0000, /* U+1404 */
  0x0000, /* U+1405 */
  0x0000, /* U+1406 */
  0x0000, /* U+1407 */
  0x0000, /* U+1408 */
  0x0000, /* U+1409 */
  0x0000, /* U+140a */
  0x0000, /* U+140b */
  0x0000, /* U+140c */
  0x0000, /* U+140d */
  0x0000, /* U+140e */
  0x0000, /* U+140f */
  0x0000, /* U+1410 */
  0x0000, /* U+1411 */
  0x0000, /* U+1412 */
  0x0000, /* U+1413 */
  0x0000, /* U+1414 */
  0x0000, /* U+1415 */
  0x0000, /* U+1416 */
  0x0000, /* U+1417 */
  0x0000, /* U+1418 */
  0x0000, /* U+1419 */
  0x0000, /* U+141a */
  0x0000, /* U+141b */
  0x0000, /* U+141c */
  0x0000, /* U+141d */
  0x0000, /* U+141e */
  0x0000, /* U+141f */
  0x0000, /* U+1420 */
  0x0000, /* U+1421 */
  0x0000, /* U+1422 */
  0x0000, /* U+1423 */
  0x0000, /* U+1424 */
  0x0000, /* U+1425 */
  0x0000, /* U+1426 */
  0x0000, /* U+1427 */
  0x0000, /* U+1428 */
  0x0000, /* U+1429 */
  0x0000, /* U+142a */
  0x0000, /* U+142b */
  0x0000, /* U+142c */
  0x0000, /* U+142d */
  0x0000, /* U+142e */
  0x0000, /* U+142f */
  0x0000, /* U+1430 */
  0x0000, /* U+1431 */
  0x0000, /* U+1432 */
  0x0000, /* U+1433 */
  0x0000, /* U+1434 */
  0x0000, /* U+1435 */
  0x0000, /* U+1436 */
  0x0000, /* U+1437 */
  0x0000, /* U+1438 */
  0x0000, /* U+1439 */
  0x0000, /* U+143a */
  0x0000, /* U+143b */
  0x0000, /* U+143c */
  0x0000, /* U+143d */
  0x0000, /* U+143e */
  0x0000, /* U+143f */
  0x0000, /* U+1440 */
  0x0000, /* U+1441 */
  0x0000, /* U+1442 */
  0x0000, /* U+1443 */
  0x0000, /* U+1444 */
  0x0000, /* U+1445 */
  0x0000, /* U+1446 */
  0x0000, /* U+1447 */
  0x0000, /* U+1448 */
  0x0000, /* U+1449 */
  0x0000, /* U+144a */
  0x0000, /* U+144b */
  0x0000, /* U+144c */
  0x0000, /* U+144d */
  0x0000, /* U+144e */
  0x0000, /* U+144f */
  0x0000, /* U+1450 */
  0x0000, /* U+1451 */
  0x0000, /* U+1452 */
  0x0000, /* U+1453 */
  0x0000, /* U+1454 */
  0x0000, /* U+1455 */
  0x0000, /* U+1456 */
  0x0000, /* U+1457 */
  0x0000, /* U+1458 */
  0x0000, /* U+1459 */
  0x0000, /* U+145a */
  0x0000, /* U+145b */
  0x0000, /* U+145c */
  0x0000, /* U+145d */
  0x0000, /* U+145e */
  0x0000, /* U+145f */
  0x0000, /* U+1460 */
  0x0000, /* U+1461 */
  0x0000, /* U+1462 */
  0x0000, /* U+1463 */
  0x0000, /* U+1464 */
  0x0000, /* U+1465 */
  0x0000, /* U+1466 */
  0x0000, /* U+1467 */
  0x0000, /* U+1468 */
  0x0000, /* U+1469 */
  0x0000, /* U+146a */
  0x0000, /* U+146b */
  0x0000, /* U+146c */
  0x0000, /* U+146d */
  0x0000, /* U+146e */
  0x0000, /* U+146f */
  0x0000, /* U+1470 */
  0x0000, /* U+1471 */
  0x0000, /* U+1472 */
  0x0000, /* U+1473 */
  0x0000, /* U+1474 */
  0x0000, /* U+1475 */
  0x0000, /* U+1476 */
  0x0000, /* U+1477 */
  0x0000, /* U+1478 */
  0x0000, /* U+1479 */
  0x0000, /* U+147a */
  0x0000, /* U+147b */
  0x0000, /* U+147c */
  0x0000, /* U+147d */
  0x0000, /* U+147e */
  0x0000, /* U+147f */
  0x0000, /* U+1480 */
  0x0000, /* U+1481 */
  0x0000, /* U+1482 */
  0x0000, /* U+1483 */
  0x0000, /* U+1484 */
  0x0000, /* U+1485 */
  0x0000, /* U+1486 */
  0x0000, /* U+1487 */
  0x0000, /* U+1488 */
  0x0000, /* U+1489 */
  0x0000, /* U+148a */
  0x0000, /* U+148b */
  0x0000, /* U+148c */
  0x0000, /* U+148d */
  0x0000, /* U+148e */
  0x0000, /* U+148f */
  0x0000, /* U+1490 */
  0x0000, /* U+1491 */
  0x0000, /* U+1492 */
  0x0000, /* U+1493 */
  0x0000, /* U+1494 */
  0x0000, /* U+1495 */
  0x0000, /* U+1496 */
  0x0000, /* U+1497 */
  0x0000, /* U+1498 */
  0x0000, /* U+1499 */
  0x0000, /* U+149a */
  0x0000, /* U+149b */
  0x0000, /* U+149c */
  0x0000, /* U+149d */
  0x0000, /* U+149e */
  0x0000, /* U+149f */
  0x0000, /* U+14a0 */
  0x0000, /* U+14a1 */
  0x0000, /* U+14a2 */
  0x0000, /* U+14a3 */
  0x0000, /* U+14a4 */
  0x0000, /* U+14a5 */
  0x0000, /* U+14a6 */
  0x0000, /* U+14a7 */
  0x0000, /* U+14a8 */
  0x0000, /* U+14a9 */
  0x0000, /* U+14aa */
  0x0000, /* U+14ab */
  0x0000, /* U+14ac */
  0x0000, /* U+14ad */
  0x0000, /* U+14ae */
  0x0000, /* U+14af */
  0x0000, /* U+14b0 */
  0x0000, /* U+14b1 */
  0x0000, /* U+14b2 */
  0x0000, /* U+14b3 */
  0x0000, /* U+14b4 */
  0x0000, /* U+14b5 */
  0x0000, /* U+14b6 */
  0x0000, /* U+14b7 */
  0x0000, /* U+14b8 */
  0x0000, /* U+14b9 */
  0x0000, /* U+14ba */
  0x0000, /* U+14bb */
  0x0000, /* U+14bc */
  0x0000, /* U+14bd */
  0x0000, /* U+14be */
  0x0000, /* U+14bf */
  0x0000, /* U+14c0 */
  0x0000, /* U+14c1 */
  0x0000, /* U+14c2 */
  0x0000, /* U+14c3 */
  0x0000, /* U+14c4 */
  0x0000, /* U+14c5 */
  0x0000, /* U+14c6 */
  0x0000, /* U+14c7 */
  0x0000, /* U+14c8 */
  0x0000, /* U+14c9 */
  0x0000, /* U+14ca */
  0x0000, /* U+14cb */
  0x0000, /* U+14cc */
  0x0000, /* U+14cd */
  0x0000, /* U+14ce */
  0x0000, /* U+14cf */
  0x0000, /* U+14d0 */
  0x0000, /* U+14d1 */
  0x0000, /* U+14d2 */
  0x0000, /* U+14d3 */
  0x0000, /* U+14d4 */
  0x0000, /* U+14d5 */
  0x0000, /* U+14d6 */
  0x0000, /* U+14d7 */
  0x0000, /* U+14d8 */
  0x0000, /* U+14d9 */
  0x0000, /* U+14da */
  0x0000, /* U+14db */
  0x0000, /* U+14dc */
  0x0000, /* U+14dd */
  0x0000, /* U+14de */
  0x0000, /* U+14df */
  0x0000, /* U+14e0 */
  0x0000, /* U+14e1 */
  0x0000, /* U+14e2 */
  0x0000, /* U+14e3 */
  0x0000, /* U+14e4 */
  0x0000, /* U+14e5 */
  0x0000, /* U+14e6 */
  0x0000, /* U+14e7 */
  0x0000, /* U+14e8 */
  0x0000, /* U+14e9 */
  0x0000, /* U+14ea */
  0x0000, /* U+14eb */
  0x0000, /* U+14ec */
  0x0000, /* U+14ed */
  0x0000, /* U+14ee */
  0x0000, /* U+14ef */
  0x0000, /* U+14f0 */
  0x0000, /* U+14f1 */
  0x0000, /* U+14f2 */
  0x0000, /* U+14f3 */
  0x0000, /* U+14f4 */
  0x0000, /* U+14f5 */
  0x0000, /* U+14f6 */
  0x0000, /* U+14f7 */
  0x0000, /* U+14f8 */
  0x0000, /* U+14f9 */
  0x0000, /* U+14fa */
  0x0000, /* U+14fb */
  0x0000, /* U+14fc */
  0x0000, /* U+14fd */
  0x0000, /* U+14fe */
  0x0000, /* U+14ff */
  0x0000, /* U+1500 */
  0x0000, /* U+1501 */
  0x0000, /* U+1502 */
  0x0000, /* U+1503 */
  0x0000, /* U+1504 */
  0x0000, /* U+1505 */
  0x0000, /* U+1506 */
  0x0000, /* U+1507 */
  0x0000, /* U+1508 */
  0x0000, /* U+1509 */
  0x0000, /* U+150a */
  0x0000, /* U+150b */
  0x0000, /* U+150c */
  0x0000, /* U+150d */
  0x0000, /* U+150e */
  0x0000, /* U+150f */
  0x0000, /* U+1510 */
  0x0000, /* U+1511 */
  0x0000, /* U+1512 */
  0x0000, /* U+1513 */
  0x0000, /* U+1514 */
  0x0000, /* U+1515 */
  0x0000, /* U+1516 */
  0x0000, /* U+1517 */
  0x0000, /* U+1518 */
  0x0000, /* U+1519 */
  0x0000, /* U+151a */
  0x0000, /* U+151b */
  0x0000, /* U+151c */
  0x0000, /* U+151d */
  0x0000, /* U+151e */
  0x0000, /* U+151f */
  0x0000, /* U+1520 */
  0x0000, /* U+1521 */
  0x0000, /* U+1522 */
  0x0000, /* U+1523 */
  0x0000, /* U+1524 */
  0x0000, /* U+1525 */
  0x0000, /* U+1526 */
  0x0000, /* U+1527 */
  0x0000, /* U+1528 */
  0x0000, /* U+1529 */
  0x0000, /* U+152a */
  0x0000, /* U+152b */
  0x0000, /* U+152c */
  0x0000, /* U+152d */
  0x0000, /* U+152e */
  0x0000, /* U+152f */
  0x0000, /* U+1530 */
  0x0000, /* U+1531 */
  0x0000, /* U+1532 */
  0x0000, /* U+1533 */
  0x0000, /* U+1534 */
  0x0000, /* U+1535 */
  0x0000, /* U+1536 */
  0x0000, /* U+1537 */
  0x0000, /* U+1538 */
  0x0000, /* U+1539 */
  0x0000, /* U+153a */
  0x0000, /* U+153b */
  0x0000, /* U+153c */
  0x0000, /* U+153d */
  0x0000, /* U+153e */
  0x0000, /* U+153f */
  0x0000, /* U+1540 */
  0x0000, /* U+1541 */
  0x0000, /* U+1542 */
  0x0000, /* U+1543 */
  0x0000, /* U+1544 */
  0x0000, /* U+1545 */
  0x0000, /* U+1546 */
  0x0000, /* U+1547 */
  0x0000, /* U+1548 */
  0x0000, /* U+1549 */
  0x0000, /* U+154a */
  0x0000, /* U+154b */
  0x0000, /* U+154c */
  0x0000, /* U+154d */
  0x0000, /* U+154e */
  0x0000, /* U+154f */
  0x0000, /* U+1550 */
  0x0000, /* U+1551 */
  0x0000, /* U+1552 */
  0x0000, /* U+1553 */
  0x0000, /* U+1554 */
  0x0000, /* U+1555 */
  0x0000, /* U+1556 */
  0x0000, /* U+1557 */
  0x0000, /* U+1558 */
  0x0000, /* U+1559 */
  0x0000, /* U+155a */
  0x0000, /* U+155b */
  0x0000, /* U+155c */
  0x0000, /* U+155d */
  0x0000, /* U+155e */
  0x0000, /* U+155f */
  0x0000, /* U+1560 */
  0x0000, /* U+1561 */
  0x0000, /* U+1562 */
  0x0000, /* U+1563 */
  0x0000, /* U+1564 */
  0x0000, /* U+1565 */
  0x0000, /* U+1566 */
  0x0000, /* U+1567 */
  0x0000, /* U+1568 */
  0x0000, /* U+1569 */
  0x0000, /* U+156a */
  0x0000, /* U+156b */
  0x0000, /* U+156c */
  0x0000, /* U+156d */
  0x0000, /* U+156e */
  0x0000, /* U+156f */
  0x0000, /* U+1570 */
  0x0000, /* U+1571 */
  0x0000, /* U+1572 */
  0x0000, /* U+1573 */
  0x0000, /* U+1574 */
  0x0000, /* U+1575 */
  0x0000, /* U+1576 */
  0x0000, /* U+1577 */
  0x0000, /* U+1578 */
  0x0000, /* U+1579 */
  0x0000, /* U+157a */
  0x0000, /* U+157b */
  0x0000, /* U+157c */
  0x0000, /* U+157d */
  0x0000, /* U+157e */
  0x0000, /* U+157f */
  0x0000, /* U+1580 */
  0x0000, /* U+1581 */
  0x0000, /* U+1582 */
  0x0000, /* U+1583 */
  0x0000, /* U+1584 */
  0x0000, /* U+1585 */
  0x0000, /* U+1586 */
  0x0000, /* U+1587 */
  0x0000, /* U+1588 */
  0x0000, /* U+1589 */
  0x0000, /* U+158a */
  0x0000, /* U+158b */
  0x0000, /* U+158c */
  0x0000, /* U+158d */
  0x0000, /* U+158e */
  0x0000, /* U+158f */
  0x0000, /* U+1590 */
  0x0000, /* U+1591 */
  0x0000, /* U+1592 */
  0x0000, /* U+1593 */
  0x0000, /* U+1594 */
  0x0000, /* U+1595 */
  0x0000, /* U+1596 */
  0x0000, /* U+1597 */
  0x0000, /* U+1598 */
  0x0000, /* U+1599 */
  0x0000, /* U+159a */
  0x0000, /* U+159b */
  0x0000, /* U+159c */
  0x0000, /* U+159d */
  0x0000, /* U+159e */
  0x0000, /* U+159f */
  0x0000, /* U+15a0 */
  0x0000, /* U+15a1 */
  0x0000, /* U+15a2 */
  0x0000, /* U+15a3 */
  0x0000, /* U+15a4 */
  0x0000, /* U+15a5 */
  0x0000, /* U+15a6 */
  0x0000, /* U+15a7 */
  0x0000, /* U+15a8 */
  0x0000, /* U+15a9 */
  0x0000, /* U+15aa */
  0x0000, /* U+15ab */
  0x0000, /* U+15ac */
  0x0000, /* U+15ad */
  0x0000, /* U+15ae */
  0x0000, /* U+15af */
  0x0000, /* U+15b0 */
  0x0000, /* U+15b1 */
  0x0000, /* U+15b2 */
  0x0000, /* U+15b3 */
  0x0000, /* U+15b4 */
  0x0000, /* U+15b5 */
  0x0000, /* U+15b6 */
  0x0000, /* U+15b7 */
  0x0000, /* U+15b8 */
  0x0000, /* U+15b9 */
  0x0000, /* U+15ba */
  0x0000, /* U+15bb */
  0x0000, /* U+15bc */
  0x0000, /* U+15bd */
  0x0000, /* U+15be */
  0x0000, /* U+15bf */
  0x0000, /* U+15c0 */
  0x0000, /* U+15c1 */
  0x0000, /* U+15c2 */
  0x0000, /* U+15c3 */
  0x0000, /* U+15c4 */
  0x0000, /* U+15c5 */
  0x0000, /* U+15c6 */
  0x0000, /* U+15c7 */
  0x0000, /* U+15c8 */
  0x0000, /* U+15c9 */
  0x0000, /* U+15ca */
  0x0000, /* U+15cb */
  0x0000, /* U+15cc */
  0x0000, /* U+15cd */
  0x0000, /* U+15ce */
  0x0000, /* U+15cf */
  0x0000, /* U+15d0 */
  0x0000, /* U+15d1 */
  0x0000, /* U+15d2 */
  0x0000, /* U+15d3 */
  0x0000, /* U+15d4 */
  0x0000, /* U+15d5 */
  0x0000, /* U+15d6 */
  0x0000, /* U+15d7 */
  0x0000, /* U+15d8 */
  0x0000, /* U+15d9 */
  0x0000, /* U+15da */
  0x0000, /* U+15db */
  0x0000, /* U+15dc */
  0x0000, /* U+15dd */
  0x0000, /* U+15de */
  0x0000, /* U+15df */
  0x0000, /* U+15e0 */
  0x0000, /* U+15e1 */
  0x0000, /* U+15e2 */
  0x0000, /* U+15e3 */
  0x0000, /* U+15e4 */
  0x0000, /* U+15e5 */
  0x0000, /* U+15e6 */
  0x0000, /* U+15e7 */
  0x0000, /* U+15e8 */
  0x0000, /* U+15e9 */
  0x0000, /* U+15ea */
  0x0000, /* U+15eb */
  0x0000, /* U+15ec */
  0x0000, /* U+15ed */
  0x0000, /* U+15ee */
  0x0000, /* U+15ef */
  0x0000, /* U+15f0 */
  0x0000, /* U+15f1 */
  0x0000, /* U+15f2 */
  0x0000, /* U+15f3 */
  0x0000, /* U+15f4 */
  0x0000, /* U+15f5 */
  0x0000, /* U+15f6 */
  0x0000, /* U+15f7 */
  0x0000, /* U+15f8 */
  0x0000, /* U+15f9 */
  0x0000, /* U+15fa */
  0x0000, /* U+15fb */
  0x0000, /* U+15fc */
  0x0000, /* U+15fd */
  0x0000, /* U+15fe */
  0x0000, /* U+15ff */
  0x0000, /* U+1600 */
  0x0000, /* U+1601 */
  0x0000, /* U+1602 */
  0x0000, /* U+1603 */
  0x0000, /* U+1604 */
  0x0000, /* U+1605 */
  0x0000, /* U+1606 */
  0x0000, /* U+1607 */
  0x0000, /* U+1608 */
  0x0000, /* U+1609 */
  0x0000, /* U+160a */
  0x0000, /* U+160b */
  0x0000, /* U+160c */
  0x0000, /* U+160d */
  0x0000, /* U+160e */
  0x0000, /* U+160f */
  0x0000, /* U+1610 */
  0x0000, /* U+1611 */
  0x0000, /* U+1612 */
  0x0000, /* U+1613 */
  0x0000, /* U+1614 */
  0x0000, /* U+1615 */
  0x0000, /* U+1616 */
  0x0000, /* U+1617 */
  0x0000, /* U+1618 */
  0x0000, /* U+1619 */
  0x0000, /* U+161a */
  0x0000, /* U+161b */
  0x0000, /* U+161c */
  0x0000, /* U+161d */
  0x0000, /* U+161e */
  0x0000, /* U+161f */
  0x0000, /* U+1620 */
  0x0000, /* U+1621 */
  0x0000, /* U+1622 */
  0x0000, /* U+1623 */
  0x0000, /* U+1624 */
  0x0000, /* U+1625 */
  0x0000, /* U+1626 */
  0x0000, /* U+1627 */
  0x0000, /* U+1628 */
  0x0000, /* U+1629 */
  0x0000, /* U+162a */
  0x0000, /* U+162b */
  0x0000, /* U+162c */
  0x0000, /* U+162d */
  0x0000, /* U+162e */
  0x0000, /* U+162f */
  0x0000, /* U+1630 */
  0x0000, /* U+1631 */
  0x0000, /* U+1632 */
  0x0000, /* U+1633 */
  0x0000, /* U+1634 */
  0x0000, /* U+1635 */
  0x0000, /* U+1636 */
  0x0000, /* U+1637 */
  0x0000, /* U+1638 */
  0x0000, /* U+1639 */
  0x0000, /* U+163a */
  0x0000, /* U+163b */
  0x0000, /* U+163c */
  0x0000, /* U+163d */
  0x0000, /* U+163e */
  0x0000, /* U+163f */
  0x0000, /* U+1640 */
  0x0000, /* U+1641 */
  0x0000, /* U+1642 */
  0x0000, /* U+1643 */
  0x0000, /* U+1644 */
  0x0000, /* U+1645 */
  0x0000, /* U+1646 */
  0x0000, /* U+1647 */
  0x0000, /* U+1648 */
  0x0000, /* U+1649 */
  0x0000, /* U+164a */
  0x0000, /* U+164b */
  0x0000, /* U+164c */
  0x0000, /* U+164d */
  0x0000, /* U+164e */
  0x0000, /* U+164f */
  0x0000, /* U+1650 */
  0x0000, /* U+1651 */
  0x0000, /* U+1652 */
  0x0000, /* U+1653 */
  0x0000, /* U+1654 */
  0x0000, /* U+1655 */
  0x0000, /* U+1656 */
  0x0000, /* U+1657 */
  0x0000, /* U+1658 */
  0x0000, /* U+1659 */
  0x0000, /* U+165a */
  0x0000, /* U+165b */
  0x0000, /* U+165c */
  0x0000, /* U+165d */
  0x0000, /* U+165e */
  0x0000, /* U+165f */
  0x0000, /* U+1660 */
  0x0000, /* U+1661 */
  0x0000, /* U+1662 */
  0x0000, /* U+1663 */
  0x0000, /* U+1664 */
  0x0000, /* U+1665 */
  0x0000, /* U+1666 */
  0x0000, /* U+1667 */
  0x0000, /* U+1668 */
  0x0000, /* U+1669 */
  0x0000, /* U+166a */
  0x0000, /* U+166b */
  0x0000, /* U+166c */
  0x0000, /* U+166d */
  0x0000, /* U+166e */
  0x0000, /* U+166f */
  0x0000, /* U+1670 */
  0x0000, /* U+1671 */
  0x0000, /* U+1672 */
  0x0000, /* U+1673 */
  0x0000, /* U+1674 */
  0x0000, /* U+1675 */
  0x0000, /* U+1676 */
  0x0000, /* U+1677 */
  0x0000, /* U+1678 */
  0x0000, /* U+1679 */
  0x0000, /* U+167a */
  0x0000, /* U+167b */
  0x0000, /* U+167c */
  0x0000, /* U+167d */
  0x0000, /* U+167e */
  0x0000, /* U+167f */
  0x0000, /* U+1680 */
  0x0000, /* U+1681 */
  0x0000, /* U+1682 */
  0x0000, /* U+1683 */
  0x0000, /* U+1684 */
  0x0000, /* U+1685 */
  0x0000, /* U+1686 */
  0x0000, /* U+1687 */
  0x0000, /* U+1688 */
  0x0000, /* U+1689 */
  0x0000, /* U+168a */
  0x0000, /* U+168b */
  0x0000, /* U+168c */
  0x0000, /* U+168d */
  0x0000, /* U+168e */
  0x0000, /* U+168f */
  0x0000, /* U+1690 */
  0x0000, /* U+1691 */
  0x0000, /* U+1692 */
  0x0000, /* U+1693 */
  0x0000, /* U+1694 */
  0x0000, /* U+1695 */
  0x0000, /* U+1696 */
  0x0000, /* U+1697 */
  0x0000, /* U+1698 */
  0x0000, /* U+1699 */
  0x0000, /* U+169a */
  0x0000, /* U+169b */
  0x0000, /* U+169c */
  0x0000, /* U+169d */
  0x0000, /* U+169e */
  0x0000, /* U+169f */
  0x0000, /* U+16a0 */
  0x0000, /* U+16a1 */
  0x0000, /* U+16a2 */
  0x0000, /* U+16a3 */
  0x0000, /* U+16a4 */
  0x0000, /* U+16a5 */
  0x0000, /* U+16a6 */
  0x0000, /* U+16a7 */
  0x0000, /* U+16a8 */
  0x0000, /* U+16a9 */
  0x0000, /* U+16aa */
  0x0000, /* U+16ab */
  0x0000, /* U+16ac */
  0x0000, /* U+16ad */
  0x0000, /* U+16ae */
  0x0000, /* U+16af */
  0x0000, /* U+16b0 */
  0x0000, /* U+16b1 */
  0x0000, /* U+16b2 */
  0x0000, /* U+16b3 */
  0x0000, /* U+16b4 */
  0x0000, /* U+16b5 */
  0x0000, /* U+16b6 */
  0x0000, /* U+16b7 */
  0x0000, /* U+16b8 */
  0x0000, /* U+16b9 */
  0x0000, /* U+16ba */
  0x0000, /* U+16bb */
  0x0000, /* U+16bc */
  0x0000, /* U+16bd */
  0x0000, /* U+16be */
  0x0000, /* U+16bf */
  0x0000, /* U+16c0 */
  0x0000, /* U+16c1 */
  0x0000, /* U+16c2 */
  0x0000, /* U+16c3 */
  0x0000, /* U+16c4 */
  0x0000, /* U+16c5 */
  0x0000, /* U+16c6 */
  0x0000, /* U+16c7 */
  0x0000, /* U+16c8 */
  0x0000, /* U+16c9 */
  0x0000, /* U+16ca */
  0x0000, /* U+16cb */
  0x0000, /* U+16cc */
  0x0000, /* U+16cd */
  0x0000, /* U+16ce */
  0x0000, /* U+16cf */
  0x0000, /* U+16d0 */
  0x0000, /* U+16d1 */
  0x0000, /* U+16d2 */
  0x0000, /* U+16d3 */
  0x0000, /* U+16d4 */
  0x0000, /* U+16d5 */
  0x0000, /* U+16d6 */
  0x0000, /* U+16d7 */
  0x0000, /* U+16d8 */
  0x0000, /* U+16d9 */
  0x0000, /* U+16da */
  0x0000, /* U+16db */
  0x0000, /* U+16dc */
  0x0000, /* U+16dd */
  0x0000, /* U+16de */
  0x0000, /* U+16df */
  0x0000, /* U+16e0 */
  0x0000, /* U+16e1 */
  0x0000, /* U+16e2 */
  0x0000, /* U+16e3 */
  0x0000, /* U+16e4 */
  0x0000, /* U+16e5 */
  0x0000, /* U+16e6 */
  0x0000, /* U+16e7 */
  0x0000, /* U+16e8 */
  0x0000, /* U+16e9 */
  0x0000, /* U+16ea */
  0x0000, /* U+16eb */
  0x0000, /* U+16ec */
  0x0000, /* U+16ed */
  0x0000, /* U+16ee */
  0x0000, /* U+16ef */
  0x0000, /* U+16f0 */
  0x0000, /* U+16f1 */
  0x0000, /* U+16f2 */
  0x0000, /* U+16f3 */
  0x0000, /* U+16f4 */
  0x0000, /* U+16f5 */
  0x0000, /* U+16f6 */
  0x0000, /* U+16f7 */
  0x0000, /* U+16f8 */
  0x0000, /* U+16f9 */
  0x0000, /* U+16fa */
  0x0000, /* U+16fb */
  0x0000, /* U+16fc */
  0x0000, /* U+16fd */
  0x0000, /* U+16fe */
  0x0000, /* U+16ff */
  0x0000, /* U+1700 */
  0x0000, /* U+1701 */
  0x0000, /* U+1702 */
  0x0000, /* U+1703 */
  0x0000, /* U+1704 */
  0x0000, /* U+1705 */
  0x0000, /* U+1706 */
  0x0000, /* U+1707 */
  0x0000, /* U+1708 */
  0x0000, /* U+1709 */
  0x0000, /* U+170a */
  0x0000, /* U+170b */
  0x0000, /* U+170c */
  0x0000, /* U+170d */
  0x0000, /* U+170e */
  0x0000, /* U+170f */
  0x0000, /* U+1710 */
  0x0000, /* U+1711 */
  0x0000, /* U+1712 */
  0x0000, /* U+1713 */
  0x0000, /* U+1714 */
  0x0000, /* U+1715 */
  0x0000, /* U+1716 */
  0x0000, /* U+1717 */
  0x0000, /* U+1718 */
  0x0000, /* U+1719 */
  0x0000, /* U+171a */
  0x0000, /* U+171b */
  0x0000, /* U+171c */
  0x0000, /* U+171d */
  0x0000, /* U+171e */
  0x0000, /* U+171f */
  0x0000, /* U+1720 */
  0x0000, /* U+1721 */
  0x0000, /* U+1722 */
  0x0000, /* U+1723 */
  0x0000, /* U+1724 */
  0x0000, /* U+1725 */
  0x0000, /* U+1726 */
  0x0000, /* U+1727 */
  0x0000, /* U+1728 */
  0x0000, /* U+1729 */
  0x0000, /* U+172a */
  0x0000, /* U+172b */
  0x0000, /* U+172c */
  0x0000, /* U+172d */
  0x0000, /* U+172e */
  0x0000, /* U+172f */
  0x0000, /* U+1730 */
  0x0000, /* U+1731 */
  0x0000, /* U+1732 */
  0x0000, /* U+1733 */
  0x0000, /* U+1734 */
  0x0000, /* U+1735 */
  0x0000, /* U+1736 */
  0x0000, /* U+1737 */
  0x0000, /* U+1738 */
  0x0000, /* U+1739 */
  0x0000, /* U+173a */
  0x0000, /* U+173b */
  0x0000, /* U+173c */
  0x0000, /* U+173d */
  0x0000, /* U+173e */
  0x0000, /* U+173f */
  0x0000, /* U+1740 */
  0x0000, /* U+1741 */
  0x0000, /* U+1742 */
  0x0000, /* U+1743 */
  0x0000, /* U+1744 */
  0x0000, /* U+1745 */
  0x0000, /* U+1746 */
  0x0000, /* U+1747 */
  0x0000, /* U+1748 */
  0x0000, /* U+1749 */
  0x0000, /* U+174a */
  0x0000, /* U+174b */
  0x0000, /* U+174c */
  0x0000, /* U+174d */
  0x0000, /* U+174e */
  0x0000, /* U+174f */
  0x0000, /* U+1750 */
  0x0000, /* U+1751 */
  0x0000, /* U+1752 */
  0x0000, /* U+1753 */
  0x0000, /* U+1754 */
  0x0000, /* U+1755 */
  0x0000, /* U+1756 */
  0x0000, /* U+1757 */
  0x0000, /* U+1758 */
  0x0000, /* U+1759 */
  0x0000, /* U+175a */
  0x0000, /* U+175b */
  0x0000, /* U+175c */
  0x0000, /* U+175d */
  0x0000, /* U+175e */
  0x0000, /* U+175f */
  0x0000, /* U+1760 */
  0x0000, /* U+1761 */
  0x0000, /* U+1762 */
  0x0000, /* U+1763 */
  0x0000, /* U+1764 */
  0x0000, /* U+1765 */
  0x0000, /* U+1766 */
  0x0000, /* U+1767 */
  0x0000, /* U+1768 */
  0x0000, /* U+1769 */
  0x0000, /* U+176a */
  0x0000, /* U+176b */
  0x0000, /* U+176c */
  0x0000, /* U+176d */
  0x0000, /* U+176e */
  0x0000, /* U+176f */
  0x0000, /* U+1770 */
  0x0000, /* U+1771 */
  0x0000, /* U+1772 */
  0x0000, /* U+1773 */
  0x0000, /* U+1774 */
  0x0000, /* U+1775 */
  0x0000, /* U+1776 */
  0x0000, /* U+1777 */
  0x0000, /* U+1778 */
  0x0000, /* U+1779 */
  0x0000, /* U+177a */
  0x0000, /* U+177b */
  0x0000, /* U+177c */
  0x0000, /* U+177d */
  0x0000, /* U+177e */
  0x0000, /* U+177f */
  0x0000, /* U+1780 */
  0x0000, /* U+1781 */
  0x0000, /* U+1782 */
  0x0000, /* U+1783 */
  0x0000, /* U+1784 */
  0x0000, /* U+1785 */
  0x0000, /* U+1786 */
  0x0000, /* U+1787 */
  0x0000, /* U+1788 */
  0x0000, /* U+1789 */
  0x0000, /* U+178a */
  0x0000, /* U+178b */
  0x0000, /* U+178c */
  0x0000, /* U+178d */
  0x0000, /* U+178e */
  0x0000, /* U+178f */
  0x0000, /* U+1790 */
  0x0000, /* U+1791 */
  0x0000, /* U+1792 */
  0x0000, /* U+1793 */
  0x0000, /* U+1794 */
  0x0000, /* U+1795 */
  0x0000, /* U+1796 */
  0x0000, /* U+1797 */
  0x0000, /* U+1798 */
  0x0000, /* U+1799 */
  0x0000, /* U+179a */
  0x0000, /* U+179b */
  0x0000, /* U+179c */
  0x0000, /* U+179d */
  0x0000, /* U+179e */
  0x0000, /* U+179f */
  0x0000, /* U+17a0 */
  0x0000, /* U+17a1 */
  0x0000, /* U+17a2 */
  0x0000, /* U+17a3 */
  0x0000, /* U+17a4 */
  0x0000, /* U+17a5 */
  0x0000, /* U+17a6 */
  0x0000, /* U+17a7 */
  0x0000, /* U+17a8 */
  0x0000, /* U+17a9 */
  0x0000, /* U+17aa */
  0x0000, /* U+17ab */
  0x0000, /* U+17ac */
  0x0000, /* U+17ad */
  0x0000, /* U+17ae */
  0x0000, /* U+17af */
  0x0000, /* U+17b0 */
  0x0000, /* U+17b1 */
  0x0000, /* U+17b2 */
  0x0000, /* U+17b3 */
  0x0000, /* U+17b4 */
  0x0000, /* U+17b5 */
  0x0000, /* U+17b6 */
  0x0000, /* U+17b7 */
  0x0000, /* U+17b8 */
  0x0000, /* U+17b9 */
  0x0000, /* U+17ba */
  0x0000, /* U+17bb */
  0x0000, /* U+17bc */
  0x0000, /* U+17bd */
  0x0000, /* U+17be */
  0x0000, /* U+17bf */
  0x0000, /* U+17c0 */
  0x0000, /* U+17c1 */
  0x0000, /* U+17c2 */
  0x0000, /* U+17c3 */
  0x0000, /* U+17c4 */
  0x0000, /* U+17c5 */
  0x0000, /* U+17c6 */
  0x0000, /* U+17c7 */
  0x0000, /* U+17c8 */
  0x0000, /* U+17c9 */
  0x0000, /* U+17ca */
  0x0000, /* U+17cb */
  0x0000, /* U+17cc */
  0x0000, /* U+17cd */
  0x0000, /* U+17ce */
  0x0000, /* U+17cf */
  0x0000, /* U+17d0 */
  0x0000, /* U+17d1 */
  0x0000, /* U+17d2 */
  0x0000, /* U+17d3 */
  0x0000, /* U+17d4 */
  0x0000, /* U+17d5 */
  0x0000, /* U+17d6 */
  0x0000, /* U+17d7 */
  0x0000, /* U+17d8 */
  0x0000, /* U+17d9 */
  0x0000, /* U+17da */
  0x0000, /* U+17db */
  0x0000, /* U+17dc */
  0x0000, /* U+17dd */
  0x0000, /* U+17de */
  0x0000, /* U+17df */
  0x0000, /* U+17e0 */
  0x0000, /* U+17e1 */
  0x0000, /* U+17e2 */
  0x0000, /* U+17e3 */
  0x0000, /* U+17e4 */
  0x0000, /* U+17e5 */
  0x0000, /* U+17e6 */
  0x0000, /* U+17e7 */
  0x0000, /* U+17e8 */
  0x0000, /* U+17e9 */
  0x0000, /* U+17ea */
  0x0000, /* U+17eb */
  0x0000, /* U+17ec */
  0x0000, /* U+17ed */
  0x0000, /* U+17ee */
  0x0000, /* U+17ef */
  0x0000, /* U+17f0 */
  0x0000, /* U+17f1 */
  0x0000, /* U+17f2 */
  0x0000, /* U+17f3 */
  0x0000, /* U+17f4 */
  0x0000, /* U+17f5 */
  0x0000, /* U+17f6 */
  0x0000, /* U+17f7 */
  0x0000, /* U+17f8 */
  0x0000, /* U+17f9 */
  0x0000, /* U+17fa */
  0x0000, /* U+17fb */
  0x0000, /* U+17fc */
  0x0000, /* U+17fd */
  0x0000, /* U+17fe */
  0x0000, /* U+17ff */
  0x0000, /* U+1800 */
  0x0000, /* U+1801 */
  0x0000, /* U+1802 */
  0x0000, /* U+1803 */
  0x0000, /* U+1804 */
  0x0000, /* U+1805 */
  0x0000, /* U+1806 */
  0x0000, /* U+1807 */
  0x0000, /* U+1808 */
  0x0000, /* U+1809 */
  0x0000, /* U+180a */
  0x0000, /* U+180b */
  0x0000, /* U+180c */
  0x0000, /* U+180d */
  0x0000, /* U+180e */
  0x0000, /* U+180f */
  0x0000, /* U+1810 */
  0x0000, /* U+1811 */
  0x0000, /* U+1812 */
  0x0000, /* U+1813 */
  0x0000, /* U+1814 */
  0x0000, /* U+1815 */
  0x0000, /* U+1816 */
  0x0000, /* U+1817 */
  0x0000, /* U+1818 */
  0x0000, /* U+1819 */
  0x0000, /* U+181a */
  0x0000, /* U+181b */
  0x0000, /* U+181c */
  0x0000, /* U+181d */
  0x0000, /* U+181e */
  0x0000, /* U+181f */
  0x0000, /* U+1820 */
  0x0000, /* U+1821 */
  0x0000, /* U+1822 */
  0x0000, /* U+1823 */
  0x0000, /* U+1824 */
  0x0000, /* U+1825 */
  0x0000, /* U+1826 */
  0x0000, /* U+1827 */
  0x0000, /* U+1828 */
  0x0000, /* U+1829 */
  0x0000, /* U+182a */
  0x0000, /* U+182b */
  0x0000, /* U+182c */
  0x0000, /* U+182d */
  0x0000, /* U+182e */
  0x0000, /* U+182f */
  0x0000, /* U+1830 */
  0x0000, /* U+1831 */
  0x0000, /* U+1832 */
  0x0000, /* U+1833 */
  0x0000, /* U+1834 */
  0x0000, /* U+1835 */
  0x0000, /* U+1836 */
  0x0000, /* U+1837 */
  0x0000, /* U+1838 */
  0x0000, /* U+1839 */
  0x0000, /* U+183a */
  0x0000, /* U+183b */
  0x0000, /* U+183c */
  0x0000, /* U+183d */
  0x0000, /* U+183e */
  0x0000, /* U+183f */
  0x0000, /* U+1840 */
  0x0000, /* U+1841 */
  0x0000, /* U+1842 */
  0x0000, /* U+1843 */
  0x0000, /* U+1844 */
  0x0000, /* U+1845 */
  0x0000, /* U+1846 */
  0x0000, /* U+1847 */
  0x0000, /* U+1848 */
  0x0000, /* U+1849 */
  0x0000, /* U+184a */
  0x0000, /* U+184b */
  0x0000, /* U+184c */
  0x0000, /* U+184d */
  0x0000, /* U+184e */
  0x0000, /* U+184f */
  0x0000, /* U+1850 */
  0x0000, /* U+1851 */
  0x0000, /* U+1852 */
  0x0000, /* U+1853 */
  0x0000, /* U+1854 */
  0x0000, /* U+1855 */
  0x0000, /* U+1856 */
  0x0000, /* U+1857 */
  0x0000, /* U+1858 */
  0x0000, /* U+1859 */
  0x0000, /* U+185a */
  0x0000, /* U+185b */
  0x0000, /* U+185c */
  0x0000, /* U+185d */
  0x0000, /* U+185e */
  0x0000, /* U+185f */
  0x0000, /* U+1860 */
  0x0000, /* U+1861 */
  0x0000, /* U+1862 */
  0x0000, /* U+1863 */
  0x0000, /* U+1864 */
  0x0000, /* U+1865 */
  0x0000, /* U+1866 */
  0x0000, /* U+1867 */
  0x0000, /* U+1868 */
  0x0000, /* U+1869 */
  0x0000, /* U+186a */
  0x0000, /* U+186b */
  0x0000, /* U+186c */
  0x0000, /* U+186d */
  0x0000, /* U+186e */
  0x0000, /* U+186f */
  0x0000, /* U+1870 */
  0x0000, /* U+1871 */
  0x0000, /* U+1872 */
  0x0000, /* U+1873 */
  0x0000, /* U+1874 */
  0x0000, /* U+1875 */
  0x0000, /* U+1876 */
  0x0000, /* U+1877 */
  0x0000, /* U+1878 */
  0x0000, /* U+1879 */
  0x0000, /* U+187a */
  0x0000, /* U+187b */
  0x0000, /* U+187c */
  0x0000, /* U+187d */
  0x0000, /* U+187e */
  0x0000, /* U+187f */
  0x0000, /* U+1880 */
  0x0000, /* U+1881 */
  0x0000, /* U+1882 */
  0x0000, /* U+1883 */
  0x0000, /* U+1884 */
  0x0000, /* U+1885 */
  0x0000, /* U+1886 */
  0x0000, /* U+1887 */
  0x0000, /* U+1888 */
  0x0000, /* U+1889 */
  0x0000, /* U+188a */
  0x0000, /* U+188b */
  0x0000, /* U+188c */
  0x0000, /* U+188d */
  0x0000, /* U+188e */
  0x0000, /* U+188f */
  0x0000, /* U+1890 */
  0x0000, /* U+1891 */
  0x0000, /* U+1892 */
  0x0000, /* U+1893 */
  0x0000, /* U+1894 */
  0x0000, /* U+1895 */
  0x0000, /* U+1896 */
  0x0000, /* U+1897 */
  0x0000, /* U+1898 */
  0x0000, /* U+1899 */
  0x0000, /* U+189a */
  0x0000, /* U+189b */
  0x0000, /* U+189c */
  0x0000, /* U+189d */
  0x0000, /* U+189e */
  0x0000, /* U+189f */
  0x0000, /* U+18a0 */
  0x0000, /* U+18a1 */
  0x0000, /* U+18a2 */
  0x0000, /* U+18a3 */
  0x0000, /* U+18a4 */
  0x0000, /* U+18a5 */
  0x0000, /* U+18a6 */
  0x0000, /* U+18a7 */
  0x0000, /* U+18a8 */
  0x0000, /* U+18a9 */
  0x0000, /* U+18aa */
  0x0000, /* U+18ab */
  0x0000, /* U+18ac */
  0x0000, /* U+18ad */
  0x0000, /* U+18ae */
  0x0000, /* U+18af */
  0x0000, /* U+18b0 */
  0x0000, /* U+18b1 */
  0x0000, /* U+18b2 */
  0x0000, /* U+18b3 */
  0x0000, /* U+18b4 */
  0x0000, /* U+18b5 */
  0x0000, /* U+18b6 */
  0x0000, /* U+18b7 */
  0x0000, /* U+18b8 */
  0x0000, /* U+18b9 */
  0x0000, /* U+18ba */
  0x0000, /* U+18bb */
  0x0000, /* U+18bc */
  0x0000, /* U+18bd */
  0x0000, /* U+18be */
  0x0000, /* U+18bf */
  0x0000, /* U+18c0 */
  0x0000, /* U+18c1 */
  0x0000, /* U+18c2 */
  0x0000, /* U+18c3 */
  0x0000, /* U+18c4 */
  0x0000, /* U+18c5 */
  0x0000, /* U+18c6 */
  0x0000, /* U+18c7 */
  0x0000, /* U+18c8 */
  0x0000, /* U+18c9 */
  0x0000, /* U+18ca */
  0x0000, /* U+18cb */
  0x0000, /* U+18cc */
  0x0000, /* U+18cd */
  0x0000, /* U+18ce */
  0x0000, /* U+18cf */
  0x0000, /* U+18d0 */
  0x0000, /* U+18d1 */
  0x0000, /* U+18d2 */
  0x0000, /* U+18d3 */
  0x0000, /* U+18d4 */
  0x0000, /* U+18d5 */
  0x0000, /* U+18d6 */
  0x0000, /* U+18d7 */
  0x0000, /* U+18d8 */
  0x0000, /* U+18d9 */
  0x0000, /* U+18da */
  0x0000, /* U+18db */
  0x0000, /* U+18dc */
  0x0000, /* U+18dd */
  0x0000, /* U+18de */
  0x0000, /* U+18df */
  0x0000, /* U+18e0 */
  0x0000, /* U+18e1 */
  0x0000, /* U+18e2 */
  0x0000, /* U+18e3 */
  0x0000, /* U+18e4 */
  0x0000, /* U+18e5 */
  0x0000, /* U+18e6 */
  0x0000, /* U+18e7 */
  0x0000, /* U+18e8 */
  0x0000, /* U+18e9 */
  0x0000, /* U+18ea */
  0x0000, /* U+18eb */
  0x0000, /* U+18ec */
  0x0000, /* U+18ed */
  0x0000, /* U+18ee */
  0x0000, /* U+18ef */
  0x0000, /* U+18f0 */
  0x0000, /* U+18f1 */
  0x0000, /* U+18f2 */
  0x0000, /* U+18f3 */
  0x0000, /* U+18f4 */
  0x0000, /* U+18f5 */
  0x0000, /* U+18f6 */
  0x0000, /* U+18f7 */
  0x0000, /* U+18f8 */
  0x0000, /* U+18f9 */
  0x0000, /* U+18fa */
  0x0000, /* U+18fb */
  0x0000, /* U+18fc */
  0x0000, /* U+18fd */
  0x0000, /* U+18fe */
  0x0000, /* U+18ff */
  0x0000, /* U+1900 */
  0x0000, /* U+1901 */
  0x0000, /* U+1902 */
  0x0000, /* U+1903 */
  0x0000, /* U+1904 */
  0x0000, /* U+1905 */
  0x0000, /* U+1906 */
  0x0000, /* U+1907 */
  0x0000, /* U+1908 */
  0x0000, /* U+1909 */
  0x0000, /* U+190a */
  0x0000, /* U+190b */
  0x0000, /* U+190c */
  0x0000, /* U+190d */
  0x0000, /* U+190e */
  0x0000, /* U+190f */
  0x0000, /* U+1910 */
  0x0000, /* U+1911 */
  0x0000, /* U+1912 */
  0x0000, /* U+1913 */
  0x0000, /* U+1914 */
  0x0000, /* U+1915 */
  0x0000, /* U+1916 */
  0x0000, /* U+1917 */
  0x0000, /* U+1918 */
  0x0000, /* U+1919 */
  0x0000, /* U+191a */
  0x0000, /* U+191b */
  0x0000, /* U+191c */
  0x0000, /* U+191d */
  0x0000, /* U+191e */
  0x0000, /* U+191f */
  0x0000, /* U+1920 */
  0x0000, /* U+1921 */
  0x0000, /* U+1922 */
  0x0000, /* U+1923 */
  0x0000, /* U+1924 */
  0x0000, /* U+1925 */
  0x0000, /* U+1926 */
  0x0000, /* U+1927 */
  0x0000, /* U+1928 */
  0x0000, /* U+1929 */
  0x0000, /* U+192a */
  0x0000, /* U+192b */
  0x0000, /* U+192c */
  0x0000, /* U+192d */
  0x0000, /* U+192e */
  0x0000, /* U+192f */
  0x0000, /* U+1930 */
  0x0000, /* U+1931 */
  0x0000, /* U+1932 */
  0x0000, /* U+1933 */
  0x0000, /* U+1934 */
  0x0000, /* U+1935 */
  0x0000, /* U+1936 */
  0x0000, /* U+1937 */
  0x0000, /* U+1938 */
  0x0000, /* U+1939 */
  0x0000, /* U+193a */
  0x0000, /* U+193b */
  0x0000, /* U+193c */
  0x0000, /* U+193d */
  0x0000, /* U+193e */
  0x0000, /* U+193f */
  0x0000, /* U+1940 */
  0x0000, /* U+1941 */
  0x0000, /* U+1942 */
  0x0000, /* U+1943 */
  0x0000, /* U+1944 */
  0x0000, /* U+1945 */
  0x0000, /* U+1946 */
  0x0000, /* U+1947 */
  0x0000, /* U+1948 */
  0x0000, /* U+1949 */
  0x0000, /* U+194a */
  0x0000, /* U+194b */
  0x0000, /* U+194c */
  0x0000, /* U+194d */
  0x0000, /* U+194e */
  0x0000, /* U+194f */
  0x0000, /* U+1950 */
  0x0000, /* U+1951 */
  0x0000, /* U+1952 */
  0x0000, /* U+1953 */
  0x0000, /* U+1954 */
  0x0000, /* U+1955 */
  0x0000, /* U+1956 */
  0x0000, /* U+1957 */
  0x0000, /* U+1958 */
  0x0000, /* U+1959 */
  0x0000, /* U+195a */
  0x0000, /* U+195b */
  0x0000, /* U+195c */
  0x0000, /* U+195d */
  0x0000, /* U+195e */
  0x0000, /* U+195f */
  0x0000, /* U+1960 */
  0x0000, /* U+1961 */
  0x0000, /* U+1962 */
  0x0000, /* U+1963 */
  0x0000, /* U+1964 */
  0x0000, /* U+1965 */
  0x0000, /* U+1966 */
  0x0000, /* U+1967 */
  0x0000, /* U+1968 */
  0x0000, /* U+1969 */
  0x0000, /* U+196a */
  0x0000, /* U+196b */
  0x0000, /* U+196c */
  0x0000, /* U+196d */
  0x0000, /* U+196e */
  0x0000, /* U+196f */
  0x0000, /* U+1970 */
  0x0000, /* U+1971 */
  0x0000, /* U+1972 */
  0x0000, /* U+1973 */
  0x0000, /* U+1974 */
  0x0000, /* U+1975 */
  0x0000, /* U+1976 */
  0x0000, /* U+1977 */
  0x0000, /* U+1978 */
  0x0000, /* U+1979 */
  0x0000, /* U+197a */
  0x0000, /* U+197b */
  0x0000, /* U+197c */
  0x0000, /* U+197d */
  0x0000, /* U+197e */
  0x0000, /* U+197f */
  0x0000, /* U+1980 */
  0x0000, /* U+1981 */
  0x0000, /* U+1982 */
  0x0000, /* U+1983 */
  0x0000, /* U+1984 */
  0x0000, /* U+1985 */
  0x0000, /* U+1986 */
  0x0000, /* U+1987 */
  0x0000, /* U+1988 */
  0x0000, /* U+1989 */
  0x0000, /* U+198a */
  0x0000, /* U+198b */
  0x0000, /* U+198c */
  0x0000, /* U+198d */
  0x0000, /* U+198e */
  0x0000, /* U+198f */
  0x0000, /* U+1990 */
  0x0000, /* U+1991 */
  0x0000, /* U+1992 */
  0x0000, /* U+1993 */
  0x0000, /* U+1994 */
  0x0000, /* U+1995 */
  0x0000, /* U+1996 */
  0x0000, /* U+1997 */
  0x0000, /* U+1998 */
  0x0000, /* U+1999 */
  0x0000, /* U+199a */
  0x0000, /* U+199b */
  0x0000, /* U+199c */
  0x0000, /* U+199d */
  0x0000, /* U+199e */
  0x0000, /* U+199f */
  0x0000, /* U+19a0 */
  0x0000, /* U+19a1 */
  0x0000, /* U+19a2 */
  0x0000, /* U+19a3 */
  0x0000, /* U+19a4 */
  0x0000, /* U+19a5 */
  0x0000, /* U+19a6 */
  0x0000, /* U+19a7 */
  0x0000, /* U+19a8 */
  0x0000, /* U+19a9 */
  0x0000, /* U+19aa */
  0x0000, /* U+19ab */
  0x0000, /* U+19ac */
  0x0000, /* U+19ad */
  0x0000, /* U+19ae */
  0x0000, /* U+19af */
  0x0000, /* U+19b0 */
  0x0000, /* U+19b1 */
  0x0000, /* U+19b2 */
  0x0000, /* U+19b3 */
  0x0000, /* U+19b4 */
  0x0000, /* U+19b5 */
  0x0000, /* U+19b6 */
  0x0000, /* U+19b7 */
  0x0000, /* U+19b8 */
  0x0000, /* U+19b9 */
  0x0000, /* U+19ba */
  0x0000, /* U+19bb */
  0x0000, /* U+19bc */
  0x0000, /* U+19bd */
  0x0000, /* U+19be */
  0x0000, /* U+19bf */
  0x0000, /* U+19c0 */
  0x0000, /* U+19c1 */
  0x0000, /* U+19c2 */
  0x0000, /* U+19c3 */
  0x0000, /* U+19c4 */
  0x0000, /* U+19c5 */
  0x0000, /* U+19c6 */
  0x0000, /* U+19c7 */
  0x0000, /* U+19c8 */
  0x0000, /* U+19c9 */
  0x0000, /* U+19ca */
  0x0000, /* U+19cb */
  0x0000, /* U+19cc */
  0x0000, /* U+19cd */
  0x0000, /* U+19ce */
  0x0000, /* U+19cf */
  0x0000, /* U+19d0 */
  0x0000, /* U+19d1 */
  0x0000, /* U+19d2 */
  0x0000, /* U+19d3 */
  0x0000, /* U+19d4 */
  0x0000, /* U+19d5 */
  0x0000, /* U+19d6 */
  0x0000, /* U+19d7 */
  0x0000, /* U+19d8 */
  0x0000, /* U+19d9 */
  0x0000, /* U+19da */
  0x0000, /* U+19db */
  0x0000, /* U+19dc */
  0x0000, /* U+19dd */
  0x0000, /* U+19de */
  0x0000, /* U+19df */
  0x0000, /* U+19e0 */
  0x0000, /* U+19e1 */
  0x0000, /* U+19e2 */
  0x0000, /* U+19e3 */
  0x0000, /* U+19e4 */
  0x0000, /* U+19e5 */
  0x0000, /* U+19e6 */
  0x0000, /* U+19e7 */
  0x0000, /* U+19e8 */
  0x0000, /* U+19e9 */
  0x0000, /* U+19ea */
  0x0000, /* U+19eb */
  0x0000, /* U+19ec */
  0x0000, /* U+19ed */
  0x0000, /* U+19ee */
  0x0000, /* U+19ef */
  0x0000, /* U+19f0 */
  0x0000, /* U+19f1 */
  0x0000, /* U+19f2 */
  0x0000, /* U+19f3 */
  0x0000, /* U+19f4 */
  0x0000, /* U+19f5 */
  0x0000, /* U+19f6 */
  0x0000, /* U+19f7 */
  0x0000, /* U+19f8 */
  0x0000, /* U+19f9 */
  0x0000, /* U+19fa */
  0x0000, /* U+19fb */
  0x0000, /* U+19fc */
  0x0000, /* U+19fd */
  0x0000, /* U+19fe */
  0x0000, /* U+19ff */
  0x0000, /* U+1a00 */
  0x0000, /* U+1a01 */
  0x0000, /* U+1a02 */
  0x0000, /* U+1a03 */
  0x0000, /* U+1a04 */
  0x0000, /* U+1a05 */
  0x0000, /* U+1a06 */
  0x0000, /* U+1a07 */
  0x0000, /* U+1a08 */
  0x0000, /* U+1a09 */
  0x0000, /* U+1a0a */
  0x0000, /* U+1a0b */
  0x0000, /* U+1a0c */
  0x0000, /* U+1a0d */
  0x0000, /* U+1a0e */
  0x0000, /* U+1a0f */
  0x0000, /* U+1a10 */
  0x0000, /* U+1a11 */
  0x0000, /* U+1a12 */
  0x0000, /* U+1a13 */
  0x0000, /* U+1a14 */
  0x0000, /* U+1a15 */
  0x0000, /* U+1a16 */
  0x0000, /* U+1a17 */
  0x0000, /* U+1a18 */
  0x0000, /* U+1a19 */
  0x0000, /* U+1a1a */
  0x0000, /* U+1a1b */
  0x0000, /* U+1a1c */
  0x0000, /* U+1a1d */
  0x0000, /* U+1a1e */
  0x0000, /* U+1a1f */
  0x0000, /* U+1a20 */
  0x0000, /* U+1a21 */
  0x0000, /* U+1a22 */
  0x0000, /* U+1a23 */
  0x0000, /* U+1a24 */
  0x0000, /* U+1a25 */
  0x0000, /* U+1a26 */
  0x0000, /* U+1a27 */
  0x0000, /* U+1a28 */
  0x0000, /* U+1a29 */
  0x0000, /* U+1a2a */
  0x0000, /* U+1a2b */
  0x0000, /* U+1a2c */
  0x0000, /* U+1a2d */
  0x0000, /* U+1a2e */
  0x0000, /* U+1a2f */
  0x0000, /* U+1a30 */
  0x0000, /* U+1a31 */
  0x0000, /* U+1a32 */
  0x0000, /* U+1a33 */
  0x0000, /* U+1a34 */
  0x0000, /* U+1a35 */
  0x0000, /* U+1a36 */
  0x0000, /* U+1a37 */
  0x0000, /* U+1a38 */
  0x0000, /* U+1a39 */
  0x0000, /* U+1a3a */
  0x0000, /* U+1a3b */
  0x0000, /* U+1a3c */
  0x0000, /* U+1a3d */
  0x0000, /* U+1a3e */
  0x0000, /* U+1a3f */
  0x0000, /* U+1a40 */
  0x0000, /* U+1a41 */
  0x0000, /* U+1a42 */
  0x0000, /* U+1a43 */
  0x0000, /* U+1a44 */
  0x0000, /* U+1a45 */
  0x0000, /* U+1a46 */
  0x0000, /* U+1a47 */
  0x0000, /* U+1a48 */
  0x0000, /* U+1a49 */
  0x0000, /* U+1a4a */
  0x0000, /* U+1a4b */
  0x0000, /* U+1a4c */
  0x0000, /* U+1a4d */
  0x0000, /* U+1a4e */
  0x0000, /* U+1a4f */
  0x0000, /* U+1a50 */
  0x0000, /* U+1a51 */
  0x0000, /* U+1a52 */
  0x0000, /* U+1a53 */
  0x0000, /* U+1a54 */
  0x0000, /* U+1a55 */
  0x0000, /* U+1a56 */
  0x0000, /* U+1a57 */
  0x0000, /* U+1a58 */
  0x0000, /* U+1a59 */
  0x0000, /* U+1a5a */
  0x0000, /* U+1a5b */
  0x0000, /* U+1a5c */
  0x0000, /* U+1a5d */
  0x0000, /* U+1a5e */
  0x0000, /* U+1a5f */
  0x0000, /* U+1a60 */
  0x0000, /* U+1a61 */
  0x0000, /* U+1a62 */
  0x0000, /* U+1a63 */
  0x0000, /* U+1a64 */
  0x0000, /* U+1a65 */
  0x0000, /* U+1a66 */
  0x0000, /* U+1a67 */
  0x0000, /* U+1a68 */
  0x0000, /* U+1a69 */
  0x0000, /* U+1a6a */
  0x0000, /* U+1a6b */
  0x0000, /* U+1a6c */
  0x0000, /* U+1a6d */
  0x0000, /* U+1a6e */
  0x0000, /* U+1a6f */
  0x0000, /* U+1a70 */
  0x0000, /* U+1a71 */
  0x0000, /* U+1a72 */
  0x0000, /* U+1a73 */
  0x0000, /* U+1a74 */
  0x0000, /* U+1a75 */
  0x0000, /* U+1a76 */
  0x0000, /* U+1a77 */
  0x0000, /* U+1a78 */
  0x0000, /* U+1a79 */
  0x0000, /* U+1a7a */
  0x0000, /* U+1a7b */
  0x0000, /* U+1a7c */
  0x0000, /* U+1a7d */
  0x0000, /* U+1a7e */
  0x0000, /* U+1a7f */
  0x0000, /* U+1a80 */
  0x0000, /* U+1a81 */
  0x0000, /* U+1a82 */
  0x0000, /* U+1a83 */
  0x0000, /* U+1a84 */
  0x0000, /* U+1a85 */
  0x0000, /* U+1a86 */
  0x0000, /* U+1a87 */
  0x0000, /* U+1a88 */
  0x0000, /* U+1a89 */
  0x0000, /* U+1a8a */
  0x0000, /* U+1a8b */
  0x0000, /* U+1a8c */
  0x0000, /* U+1a8d */
  0x0000, /* U+1a8e */
  0x0000, /* U+1a8f */
  0x0000, /* U+1a90 */
  0x0000, /* U+1a91 */
  0x0000, /* U+1a92 */
  0x0000, /* U+1a93 */
  0x0000, /* U+1a94 */
  0x0000, /* U+1a95 */
  0x0000, /* U+1a96 */
  0x0000, /* U+1a97 */
  0x0000, /* U+1a98 */
  0x0000, /* U+1a99 */
  0x0000, /* U+1a9a */
  0x0000, /* U+1a9b */
  0x0000, /* U+1a9c */
  0x0000, /* U+1a9d */
  0x0000, /* U+1a9e */
  0x0000, /* U+1a9f */
  0x0000, /* U+1aa0 */
  0x0000, /* U+1aa1 */
  0x0000, /* U+1aa2 */
  0x0000, /* U+1aa3 */
  0x0000, /* U+1aa4 */
  0x0000, /* U+1aa5 */
  0x0000, /* U+1aa6 */
  0x0000, /* U+1aa7 */
  0x0000, /* U+1aa8 */
  0x0000, /* U+1aa9 */
  0x0000, /* U+1aaa */
  0x0000, /* U+1aab */
  0x0000, /* U+1aac */
  0x0000, /* U+1aad */
  0x0000, /* U+1aae */
  0x0000, /* U+1aaf */
  0x0000, /* U+1ab0 */
  0x0000, /* U+1ab1 */
  0x0000, /* U+1ab2 */
  0x0000, /* U+1ab3 */
  0x0000, /* U+1ab4 */
  0x0000, /* U+1ab5 */
  0x0000, /* U+1ab6 */
  0x0000, /* U+1ab7 */
  0x0000, /* U+1ab8 */
  0x0000, /* U+1ab9 */
  0x0000, /* U+1aba */
  0x0000, /* U+1abb */
  0x0000, /* U+1abc */
  0x0000, /* U+1abd */
  0x0000, /* U+1abe */
  0x0000, /* U+1abf */
  0x0000, /* U+1ac0 */
  0x0000, /* U+1ac1 */
  0x0000, /* U+1ac2 */
  0x0000, /* U+1ac3 */
  0x0000, /* U+1ac4 */
  0x0000, /* U+1ac5 */
  0x0000, /* U+1ac6 */
  0x0000, /* U+1ac7 */
  0x0000, /* U+1ac8 */
  0x0000, /* U+1ac9 */
  0x0000, /* U+1aca */
  0x0000, /* U+1acb */
  0x0000, /* U+1acc */
  0x0000, /* U+1acd */
  0x0000, /* U+1ace */
  0x0000, /* U+1acf */
  0x0000, /* U+1ad0 */
  0x0000, /* U+1ad1 */
  0x0000, /* U+1ad2 */
  0x0000, /* U+1ad3 */
  0x0000, /* U+1ad4 */
  0x0000, /* U+1ad5 */
  0x0000, /* U+1ad6 */
  0x0000, /* U+1ad7 */
  0x0000, /* U+1ad8 */
  0x0000, /* U+1ad9 */
  0x0000, /* U+1ada */
  0x0000, /* U+1adb */
  0x0000, /* U+1adc */
  0x0000, /* U+1add */
  0x0000, /* U+1ade */
  0x0000, /* U+1adf */
  0x0000, /* U+1ae0 */
  0x0000, /* U+1ae1 */
  0x0000, /* U+1ae2 */
  0x0000, /* U+1ae3 */
  0x0000, /* U+1ae4 */
  0x0000, /* U+1ae5 */
  0x0000, /* U+1ae6 */
  0x0000, /* U+1ae7 */
  0x0000, /* U+1ae8 */
  0x0000, /* U+1ae9 */
  0x0000, /* U+1aea */
  0x0000, /* U+1aeb */
  0x0000, /* U+1aec */
  0x0000, /* U+1aed */
  0x0000, /* U+1aee */
  0x0000, /* U+1aef */
  0x0000, /* U+1af0 */
  0x0000, /* U+1af1 */
  0x0000, /* U+1af2 */
  0x0000, /* U+1af3 */
  0x0000, /* U+1af4 */
  0x0000, /* U+1af5 */
  0x0000, /* U+1af6 */
  0x0000, /* U+1af7 */
  0x0000, /* U+1af8 */
  0x0000, /* U+1af9 */
  0x0000, /* U+1afa */
  0x0000, /* U+1afb */
  0x0000, /* U+1afc */
  0x0000, /* U+1afd */
  0x0000, /* U+1afe */
  0x0000, /* U+1aff */
  0x0000, /* U+1b00 */
  0x0000, /* U+1b01 */
  0x0000, /* U+1b02 */
  0x0000, /* U+1b03 */
  0x0000, /* U+1b04 */
  0x0000, /* U+1b05 */
  0x0000, /* U+1b06 */
  0x0000, /* U+1b07 */
  0x0000, /* U+1b08 */
  0x0000, /* U+1b09 */
  0x0000, /* U+1b0a */
  0x0000, /* U+1b0b */
  0x0000, /* U+1b0c */
  0x0000, /* U+1b0d */
  0x0000, /* U+1b0e */
  0x0000, /* U+1b0f */
  0x0000, /* U+1b10 */
  0x0000, /* U+1b11 */
  0x0000, /* U+1b12 */
  0x0000, /* U+1b13 */
  0x0000, /* U+1b14 */
  0x0000, /* U+1b15 */
  0x0000, /* U+1b16 */
  0x0000, /* U+1b17 */
  0x0000, /* U+1b18 */
  0x0000, /* U+1b19 */
  0x0000, /* U+1b1a */
  0x0000, /* U+1b1b */
  0x0000, /* U+1b1c */
  0x0000, /* U+1b1d */
  0x0000, /* U+1b1e */
  0x0000, /* U+1b1f */
  0x0000, /* U+1b20 */
  0x0000, /* U+1b21 */
  0x0000, /* U+1b22 */
  0x0000, /* U+1b23 */
  0x0000, /* U+1b24 */
  0x0000, /* U+1b25 */
  0x0000, /* U+1b26 */
  0x0000, /* U+1b27 */
  0x0000, /* U+1b28 */
  0x0000, /* U+1b29 */
  0x0000, /* U+1b2a */
  0x0000, /* U+1b2b */
  0x0000, /* U+1b2c */
  0x0000, /* U+1b2d */
  0x0000, /* U+1b2e */
  0x0000, /* U+1b2f */
  0x0000, /* U+1b30 */
  0x0000, /* U+1b31 */
  0x0000, /* U+1b32 */
  0x0000, /* U+1b33 */
  0x0000, /* U+1b34 */
  0x0000, /* U+1b35 */
  0x0000, /* U+1b36 */
  0x0000, /* U+1b37 */
  0x0000, /* U+1b38 */
  0x0000, /* U+1b39 */
  0x0000, /* U+1b3a */
  0x0000, /* U+1b3b */
  0x0000, /* U+1b3c */
  0x0000, /* U+1b3d */
  0x0000, /* U+1b3e */
  0x0000, /* U+1b3f */
  0x0000, /* U+1b40 */
  0x0000, /* U+1b41 */
  0x0000, /* U+1b42 */
  0x0000, /* U+1b43 */
  0x0000, /* U+1b44 */
  0x0000, /* U+1b45 */
  0x0000, /* U+1b46 */
  0x0000, /* U+1b47 */
  0x0000, /* U+1b48 */
  0x0000, /* U+1b49 */
  0x0000, /* U+1b4a */
  0x0000, /* U+1b4b */
  0x0000, /* U+1b4c */
  0x0000, /* U+1b4d */
  0x0000, /* U+1b4e */
  0x0000, /* U+1b4f */
  0x0000, /* U+1b50 */
  0x0000, /* U+1b51 */
  0x0000, /* U+1b52 */
  0x0000, /* U+1b53 */
  0x0000, /* U+1b54 */
  0x0000, /* U+1b55 */
  0x0000, /* U+1b56 */
  0x0000, /* U+1b57 */
  0x0000, /* U+1b58 */
  0x0000, /* U+1b59 */
  0x0000, /* U+1b5a */
  0x0000, /* U+1b5b */
  0x0000, /* U+1b5c */
  0x0000, /* U+1b5d */
  0x0000, /* U+1b5e */
  0x0000, /* U+1b5f */
  0x0000, /* U+1b60 */
  0x0000, /* U+1b61 */
  0x0000, /* U+1b62 */
  0x0000, /* U+1b63 */
  0x0000, /* U+1b64 */
  0x0000, /* U+1b65 */
  0x0000, /* U+1b66 */
  0x0000, /* U+1b67 */
  0x0000, /* U+1b68 */
  0x0000, /* U+1b69 */
  0x0000, /* U+1b6a */
  0x0000, /* U+1b6b */
  0x0000, /* U+1b6c */
  0x0000, /* U+1b6d */
  0x0000, /* U+1b6e */
  0x0000, /* U+1b6f */
  0x0000, /* U+1b70 */
  0x0000, /* U+1b71 */
  0x0000, /* U+1b72 */
  0x0000, /* U+1b73 */
  0x0000, /* U+1b74 */
  0x0000, /* U+1b75 */
  0x0000, /* U+1b76 */
  0x0000, /* U+1b77 */
  0x0000, /* U+1b78 */
  0x0000, /* U+1b79 */
  0x0000, /* U+1b7a */
  0x0000, /* U+1b7b */
  0x0000, /* U+1b7c */
  0x0000, /* U+1b7d */
  0x0000, /* U+1b7e */
  0x0000, /* U+1b7f */
  0x0000, /* U+1b80 */
  0x0000, /* U+1b81 */
  0x0000, /* U+1b82 */
  0x0000, /* U+1b83 */
  0x0000, /* U+1b84 */
  0x0000, /* U+1b85 */
  0x0000, /* U+1b86 */
  0x0000, /* U+1b87 */
  0x0000, /* U+1b88 */
  0x0000, /* U+1b89 */
  0x0000, /* U+1b8a */
  0x0000, /* U+1b8b */
  0x0000, /* U+1b8c */
  0x0000, /* U+1b8d */
  0x0000, /* U+1b8e */
  0x0000, /* U+1b8f */
  0x0000, /* U+1b90 */
  0x0000, /* U+1b91 */
  0x0000, /* U+1b92 */
  0x0000, /* U+1b93 */
  0x0000, /* U+1b94 */
  0x0000, /* U+1b95 */
  0x0000, /* U+1b96 */
  0x0000, /* U+1b97 */
  0x0000, /* U+1b98 */
  0x0000, /* U+1b99 */
  0x0000, /* U+1b9a */
  0x0000, /* U+1b9b */
  0x0000, /* U+1b9c */
  0x0000, /* U+1b9d */
  0x0000, /* U+1b9e */
  0x0000, /* U+1b9f */
  0x0000, /* U+1ba0 */
  0x0000, /* U+1ba1 */
  0x0000, /* U+1ba2 */
  0x0000, /* U+1ba3 */
  0x0000, /* U+1ba4 */
  0x0000, /* U+1ba5 */
  0x0000, /* U+1ba6 */
  0x0000, /* U+1ba7 */
  0x0000, /* U+1ba8 */
  0x0000, /* U+1ba9 */
  0x0000, /* U+1baa */
  0x0000, /* U+1bab */
  0x0000, /* U+1bac */
  0x0000, /* U+1bad */
  0x0000, /* U+1bae */
  0x0000, /* U+1baf */
  0x0000, /* U+1bb0 */
  0x0000, /* U+1bb1 */
  0x0000, /* U+1bb2 */
  0x0000, /* U+1bb3 */
  0x0000, /* U+1bb4 */
  0x0000, /* U+1bb5 */
  0x0000, /* U+1bb6 */
  0x0000, /* U+1bb7 */
  0x0000, /* U+1bb8 */
  0x0000, /* U+1bb9 */
  0x0000, /* U+1bba */
  0x0000, /* U+1bbb */
  0x0000, /* U+1bbc */
  0x0000, /* U+1bbd */
  0x0000, /* U+1bbe */
  0x0000, /* U+1bbf */
  0x0000, /* U+1bc0 */
  0x0000, /* U+1bc1 */
  0x0000, /* U+1bc2 */
  0x0000, /* U+1bc3 */
  0x0000, /* U+1bc4 */
  0x0000, /* U+1bc5 */
  0x0000, /* U+1bc6 */
  0x0000, /* U+1bc7 */
  0x0000, /* U+1bc8 */
  0x0000, /* U+1bc9 */
  0x0000, /* U+1bca */
  0x0000, /* U+1bcb */
  0x0000, /* U+1bcc */
  0x0000, /* U+1bcd */
  0x0000, /* U+1bce */
  0x0000, /* U+1bcf */
  0x0000, /* U+1bd0 */
  0x0000, /* U+1bd1 */
  0x0000, /* U+1bd2 */
  0x0000, /* U+1bd3 */
  0x0000, /* U+1bd4 */
  0x0000, /* U+1bd5 */
  0x0000, /* U+1bd6 */
  0x0000, /* U+1bd7 */
  0x0000, /* U+1bd8 */
  0x0000, /* U+1bd9 */
  0x0000, /* U+1bda */
  0x0000, /* U+1bdb */
  0x0000, /* U+1bdc */
  0x0000, /* U+1bdd */
  0x0000, /* U+1bde */
  0x0000, /* U+1bdf */
  0x0000, /* U+1be0 */
  0x0000, /* U+1be1 */
  0x0000, /* U+1be2 */
  0x0000, /* U+1be3 */
  0x0000, /* U+1be4 */
  0x0000, /* U+1be5 */
  0x0000, /* U+1be6 */
  0x0000, /* U+1be7 */
  0x0000, /* U+1be8 */
  0x0000, /* U+1be9 */
  0x0000, /* U+1bea */
  0x0000, /* U+1beb */
  0x0000, /* U+1bec */
  0x0000, /* U+1bed */
  0x0000, /* U+1bee */
  0x0000, /* U+1bef */
  0x0000, /* U+1bf0 */
  0x0000, /* U+1bf1 */
  0x0000, /* U+1bf2 */
  0x0000, /* U+1bf3 */
  0x0000, /* U+1bf4 */
  0x0000, /* U+1bf5 */
  0x0000, /* U+1bf6 */
  0x0000, /* U+1bf7 */
  0x0000, /* U+1bf8 */
  0x0000, /* U+1bf9 */
  0x0000, /* U+1bfa */
  0x0000, /* U+1bfb */
  0x0000, /* U+1bfc */
  0x0000, /* U+1bfd */
  0x0000, /* U+1bfe */
  0x0000, /* U+1bff */
  0x0000, /* U+1c00 */
  0x0000, /* U+1c01 */
  0x0000, /* U+1c02 */
  0x0000, /* U+1c03 */
  0x0000, /* U+1c04 */
  0x0000, /* U+1c05 */
  0x0000, /* U+1c06 */
  0x0000, /* U+1c07 */
  0x0000, /* U+1c08 */
  0x0000, /* U+1c09 */
  0x0000, /* U+1c0a */
  0x0000, /* U+1c0b */
  0x0000, /* U+1c0c */
  0x0000, /* U+1c0d */
  0x0000, /* U+1c0e */
  0x0000, /* U+1c0f */
  0x0000, /* U+1c10 */
  0x0000, /* U+1c11 */
  0x0000, /* U+1c12 */
  0x0000, /* U+1c13 */
  0x0000, /* U+1c14 */
  0x0000, /* U+1c15 */
  0x0000, /* U+1c16 */
  0x0000, /* U+1c17 */
  0x0000, /* U+1c18 */
  0x0000, /* U+1c19 */
  0x0000, /* U+1c1a */
  0x0000, /* U+1c1b */
  0x0000, /* U+1c1c */
  0x0000, /* U+1c1d */
  0x0000, /* U+1c1e */
  0x0000, /* U+1c1f */
  0x0000, /* U+1c20 */
  0x0000, /* U+1c21 */
  0x0000, /* U+1c22 */
  0x0000, /* U+1c23 */
  0x0000, /* U+1c24 */
  0x0000, /* U+1c25 */
  0x0000, /* U+1c26 */
  0x0000, /* U+1c27 */
  0x0000, /* U+1c28 */
  0x0000, /* U+1c29 */
  0x0000, /* U+1c2a */
  0x0000, /* U+1c2b */
  0x0000, /* U+1c2c */
  0x0000, /* U+1c2d */
  0x0000, /* U+1c2e */
  0x0000, /* U+1c2f */
  0x0000, /* U+1c30 */
  0x0000, /* U+1c31 */
  0x0000, /* U+1c32 */
  0x0000, /* U+1c33 */
  0x0000, /* U+1c34 */
  0x0000, /* U+1c35 */
  0x0000, /* U+1c36 */
  0x0000, /* U+1c37 */
  0x0000, /* U+1c38 */
  0x0000, /* U+1c39 */
  0x0000, /* U+1c3a */
  0x0000, /* U+1c3b */
  0x0000, /* U+1c3c */
  0x0000, /* U+1c3d */
  0x0000, /* U+1c3e */
  0x0000, /* U+1c3f */
  0x0000, /* U+1c40 */
  0x0000, /* U+1c41 */
  0x0000, /* U+1c42 */
  0x0000, /* U+1c43 */
  0x0000, /* U+1c44 */
  0x0000, /* U+1c45 */
  0x0000, /* U+1c46 */
  0x0000, /* U+1c47 */
  0x0000, /* U+1c48 */
  0x0000, /* U+1c49 */
  0x0000, /* U+1c4a */
  0x0000, /* U+1c4b */
  0x0000, /* U+1c4c */
  0x0000, /* U+1c4d */
  0x0000, /* U+1c4e */
  0x0000, /* U+1c4f */
  0x0000, /* U+1c50 */
  0x0000, /* U+1c51 */
  0x0000, /* U+1c52 */
  0x0000, /* U+1c53 */
  0x0000, /* U+1c54 */
  0x0000, /* U+1c55 */
  0x0000, /* U+1c56 */
  0x0000, /* U+1c57 */
  0x0000, /* U+1c58 */
  0x0000, /* U+1c59 */
  0x0000, /* U+1c5a */
  0x0000, /* U+1c5b */
  0x0000, /* U+1c5c */
  0x0000, /* U+1c5d */
  0x0000, /* U+1c5e */
  0x0000, /* U+1c5f */
  0x0000, /* U+1c60 */
  0x0000, /* U+1c61 */
  0x0000, /* U+1c62 */
  0x0000, /* U+1c63 */
  0x0000, /* U+1c64 */
  0x0000, /* U+1c65 */
  0x0000, /* U+1c66 */
  0x0000, /* U+1c67 */
  0x0000, /* U+1c68 */
  0x0000, /* U+1c69 */
  0x0000, /* U+1c6a */
  0x0000, /* U+1c6b */
  0x0000, /* U+1c6c */
  0x0000, /* U+1c6d */
  0x0000, /* U+1c6e */
  0x0000, /* U+1c6f */
  0x0000, /* U+1c70 */
  0x0000, /* U+1c71 */
  0x0000, /* U+1c72 */
  0x0000, /* U+1c73 */
  0x0000, /* U+1c74 */
  0x0000, /* U+1c75 */
  0x0000, /* U+1c76 */
  0x0000, /* U+1c77 */
  0x0000, /* U+1c78 */
  0x0000, /* U+1c79 */
  0x0000, /* U+1c7a */
  0x0000, /* U+1c7b */
  0x0000, /* U+1c7c */
  0x0000, /* U+1c7d */
  0x0000, /* U+1c7e */
  0x0000, /* U+1c7f */
  0x0000, /* U+1c80 */
  0x0000, /* U+1c81 */
  0x0000, /* U+1c82 */
  0x0000, /* U+1c83 */
  0x0000, /* U+1c84 */
  0x0000, /* U+1c85 */
  0x0000, /* U+1c86 */
  0x0000, /* U+1c87 */
  0x0000, /* U+1c88 */
  0x0000, /* U+1c89 */
  0x0000, /* U+1c8a */
  0x0000, /* U+1c8b */
  0x0000, /* U+1c8c */
  0x0000, /* U+1c8d */
  0x0000, /* U+1c8e */
  0x0000, /* U+1c8f */
  0x0000, /* U+1c90 */
  0x0000, /* U+1c91 */
  0x0000, /* U+1c92 */
  0x0000, /* U+1c93 */
  0x0000, /* U+1c94 */
  0x0000, /* U+1c95 */
  0x0000, /* U+1c96 */
  0x0000, /* U+1c97 */
  0x0000, /* U+1c98 */
  0x0000, /* U+1c99 */
  0x0000, /* U+1c9a */
  0x0000, /* U+1c9b */
  0x0000, /* U+1c9c */
  0x0000, /* U+1c9d */
  0x0000, /* U+1c9e */
  0x0000, /* U+1c9f */
  0x0000, /* U+1ca0 */
  0x0000, /* U+1ca1 */
  0x0000, /* U+1ca2 */
  0x0000, /* U+1ca3 */
  0x0000, /* U+1ca4 */
  0x0000, /* U+1ca5 */
  0x0000, /* U+1ca6 */
  0x0000, /* U+1ca7 */
  0x0000, /* U+1ca8 */
  0x0000, /* U+1ca9 */
  0x0000, /* U+1caa */
  0x0000, /* U+1cab */
  0x0000, /* U+1cac */
  0x0000, /* U+1cad */
  0x0000, /* U+1cae */
  0x0000, /* U+1caf */
  0x0000, /* U+1cb0 */
  0x0000, /* U+1cb1 */
  0x0000, /* U+1cb2 */
  0x0000, /* U+1cb3 */
  0x0000, /* U+1cb4 */
  0x0000, /* U+1cb5 */
  0x0000, /* U+1cb6 */
  0x0000, /* U+1cb7 */
  0x0000, /* U+1cb8 */
  0x0000, /* U+1cb9 */
  0x0000, /* U+1cba */
  0x0000, /* U+1cbb */
  0x0000, /* U+1cbc */
  0x0000, /* U+1cbd */
  0x0000, /* U+1cbe */
  0x0000, /* U+1cbf */
  0x0000, /* U+1cc0 */
  0x0000, /* U+1cc1 */
  0x0000, /* U+1cc2 */
  0x0000, /* U+1cc3 */
  0x0000, /* U+1cc4 */
  0x0000, /* U+1cc5 */
  0x0000, /* U+1cc6 */
  0x0000, /* U+1cc7 */
  0x0000, /* U+1cc8 */
  0x0000, /* U+1cc9 */
  0x0000, /* U+1cca */
  0x0000, /* U+1ccb */
  0x0000, /* U+1ccc */
  0x0000, /* U+1ccd */
  0x0000, /* U+1cce */
  0x0000, /* U+1ccf */
  0x0000, /* U+1cd0 */
  0x0000, /* U+1cd1 */
  0x0000, /* U+1cd2 */
  0x0000, /* U+1cd3 */
  0x0000, /* U+1cd4 */
  0x0000, /* U+1cd5 */
  0x0000, /* U+1cd6 */
  0x0000, /* U+1cd7 */
  0x0000, /* U+1cd8 */
  0x0000, /* U+1cd9 */
  0x0000, /* U+1cda */
  0x0000, /* U+1cdb */
  0x0000, /* U+1cdc */
  0x0000, /* U+1cdd */
  0x0000, /* U+1cde */
  0x0000, /* U+1cdf */
  0x0000, /* U+1ce0 */
  0x0000, /* U+1ce1 */
  0x0000, /* U+1ce2 */
  0x0000, /* U+1ce3 */
  0x0000, /* U+1ce4 */
  0x0000, /* U+1ce5 */
  0x0000, /* U+1ce6 */
  0x0000, /* U+1ce7 */
  0x0000, /* U+1ce8 */
  0x0000, /* U+1ce9 */
  0x0000, /* U+1cea */
  0x0000, /* U+1ceb */
  0x0000, /* U+1cec */
  0x0000, /* U+1ced */
  0x0000, /* U+1cee */
  0x0000, /* U+1cef */
  0x0000, /* U+1cf0 */
  0x0000, /* U+1cf1 */
  0x0000, /* U+1cf2 */
  0x0000, /* U+1cf3 */
  0x0000, /* U+1cf4 */
  0x0000, /* U+1cf5 */
  0x0000, /* U+1cf6 */
  0x0000, /* U+1cf7 */
  0x0000, /* U+1cf8 */
  0x0000, /* U+1cf9 */
  0x0000, /* U+1cfa */
  0x0000, /* U+1cfb */
  0x0000, /* U+1cfc */
  0x0000, /* U+1cfd */
  0x0000, /* U+1cfe */
  0x0000, /* U+1cff */
  0x0000, /* U+1d00 */
  0x0000, /* U+1d01 */
  0x0000, /* U+1d02 */
  0x0000, /* U+1d03 */
  0x0000, /* U+1d04 */
  0x0000, /* U+1d05 */
  0x0000, /* U+1d06 */
  0x0000, /* U+1d07 */
  0x0000, /* U+1d08 */
  0x0000, /* U+1d09 */
  0x0000, /* U+1d0a */
  0x0000, /* U+1d0b */
  0x0000, /* U+1d0c */
  0x0000, /* U+1d0d */
  0x0000, /* U+1d0e */
  0x0000, /* U+1d0f */
  0x0000, /* U+1d10 */
  0x0000, /* U+1d11 */
  0x0000, /* U+1d12 */
  0x0000, /* U+1d13 */
  0x0000, /* U+1d14 */
  0x0000, /* U+1d15 */
  0x0000, /* U+1d16 */
  0x0000, /* U+1d17 */
  0x0000, /* U+1d18 */
  0x0000, /* U+1d19 */
  0x0000, /* U+1d1a */
  0x0000, /* U+1d1b */
  0x0000, /* U+1d1c */
  0x0000, /* U+1d1d */
  0x0000, /* U+1d1e */
  0x0000, /* U+1d1f */
  0x0000, /* U+1d20 */
  0x0000, /* U+1d21 */
  0x0000, /* U+1d22 */
  0x0000, /* U+1d23 */
  0x0000, /* U+1d24 */
  0x0000, /* U+1d25 */
  0x0000, /* U+1d26 */
  0x0000, /* U+1d27 */
  0x0000, /* U+1d28 */
  0x0000, /* U+1d29 */
  0x0000, /* U+1d2a */
  0x0000, /* U+1d2b */
  0x0000, /* U+1d2c */
  0x0000, /* U+1d2d */
  0x0000, /* U+1d2e */
  0x0000, /* U+1d2f */
  0x0000, /* U+1d30 */
  0x0000, /* U+1d31 */
  0x0000, /* U+1d32 */
  0x0000, /* U+1d33 */
  0x0000, /* U+1d34 */
  0x0000, /* U+1d35 */
  0x0000, /* U+1d36 */
  0x0000, /* U+1d37 */
  0x0000, /* U+1d38 */
  0x0000, /* U+1d39 */
  0x0000, /* U+1d3a */
  0x0000, /* U+1d3b */
  0x0000, /* U+1d3c */
  0x0000, /* U+1d3d */
  0x0000, /* U+1d3e */
  0x0000, /* U+1d3f */
  0x0000, /* U+1d40 */
  0x0000, /* U+1d41 */
  0x0000, /* U+1d42 */
  0x0000, /* U+1d43 */
  0x0000, /* U+1d44 */
  0x0000, /* U+1d45 */
  0x0000, /* U+1d46 */
  0x0000, /* U+1d47 */
  0x0000, /* U+1d48 */
  0x0000, /* U+1d49 */
  0x0000, /* U+1d4a */
  0x0000, /* U+1d4b */
  0x0000, /* U+1d4c */
  0x0000, /* U+1d4d */
  0x0000, /* U+1d4e */
  0x0000, /* U+1d4f */
  0x0000, /* U+1d50 */
  0x0000, /* U+1d51 */
  0x0000, /* U+1d52 */
  0x0000, /* U+1d53 */
  0x0000, /* U+1d54 */
  0x0000, /* U+1d55 */
  0x0000, /* U+1d56 */
  0x0000, /* U+1d57 */
  0x0000, /* U+1d58 */
  0x0000, /* U+1d59 */
  0x0000, /* U+1d5a */
  0x0000, /* U+1d5b */
  0x0000, /* U+1d5c */
  0x0000, /* U+1d5d */
  0x0000, /* U+1d5e */
  0x0000, /* U+1d5f */
  0x0000, /* U+1d60 */
  0x0000, /* U+1d61 */
  0x0000, /* U+1d62 */
  0x0000, /* U+1d63 */
  0x0000, /* U+1d64 */
  0x0000, /* U+1d65 */
  0x0000, /* U+1d66 */
  0x0000, /* U+1d67 */
  0x0000, /* U+1d68 */
  0x0000, /* U+1d69 */
  0x0000, /* U+1d6a */
  0x0000, /* U+1d6b */
  0x0000, /* U+1d6c */
  0x0000, /* U+1d6d */
  0x0000, /* U+1d6e */
  0x0000, /* U+1d6f */
  0x0000, /* U+1d70 */
  0x0000, /* U+1d71 */
  0x0000, /* U+1d72 */
  0x0000, /* U+1d73 */
  0x0000, /* U+1d74 */
  0x0000, /* U+1d75 */
  0x0000, /* U+1d76 */
  0x0000, /* U+1d77 */
  0x0000, /* U+1d78 */
  0x0000, /* U+1d79 */
  0x0000, /* U+1d7a */
  0x0000, /* U+1d7b */
  0x0000, /* U+1d7c */
  0x0000, /* U+1d7d */
  0x0000, /* U+1d7e */
  0x0000, /* U+1d7f */
  0x0000, /* U+1d80 */
  0x0000, /* U+1d81 */
  0x0000, /* U+1d82 */
  0x0000, /* U+1d83 */
  0x0000, /* U+1d84 */
  0x0000, /* U+1d85 */
  0x0000, /* U+1d86 */
  0x0000, /* U+1d87 */
  0x0000, /* U+1d88 */
  0x0000, /* U+1d89 */
  0x0000, /* U+1d8a */
  0x0000, /* U+1d8b */
  0x0000, /* U+1d8c */
  0x0000, /* U+1d8d */
  0x0000, /* U+1d8e */
  0x0000, /* U+1d8f */
  0x0000, /* U+1d90 */
  0x0000, /* U+1d91 */
  0x0000, /* U+1d92 */
  0x0000, /* U+1d93 */
  0x0000, /* U+1d94 */
  0x0000, /* U+1d95 */
  0x0000, /* U+1d96 */
  0x0000, /* U+1d97 */
  0x0000, /* U+1d98 */
  0x0000, /* U+1d99 */
  0x0000, /* U+1d9a */
  0x0000, /* U+1d9b */
  0x0000, /* U+1d9c */
  0x0000, /* U+1d9d */
  0x0000, /* U+1d9e */
  0x0000, /* U+1d9f */
  0x0000, /* U+1da0 */
  0x0000, /* U+1da1 */
  0x0000, /* U+1da2 */
  0x0000, /* U+1da3 */
  0x0000, /* U+1da4 */
  0x0000, /* U+1da5 */
  0x0000, /* U+1da6 */
  0x0000, /* U+1da7 */
  0x0000, /* U+1da8 */
  0x0000, /* U+1da9 */
  0x0000, /* U+1daa */
  0x0000, /* U+1dab */
  0x0000, /* U+1dac */
  0x0000, /* U+1dad */
  0x0000, /* U+1dae */
  0x0000, /* U+1daf */
  0x0000, /* U+1db0 */
  0x0000, /* U+1db1 */
  0x0000, /* U+1db2 */
  0x0000, /* U+1db3 */
  0x0000, /* U+1db4 */
  0x0000, /* U+1db5 */
  0x0000, /* U+1db6 */
  0x0000, /* U+1db7 */
  0x0000, /* U+1db8 */
  0x0000, /* U+1db9 */
  0x0000, /* U+1dba */
  0x0000, /* U+1dbb */
  0x0000, /* U+1dbc */
  0x0000, /* U+1dbd */
  0x0000, /* U+1dbe */
  0x0000, /* U+1dbf */
  0x0000, /* U+1dc0 */
  0x0000, /* U+1dc1 */
  0x0000, /* U+1dc2 */
  0x0000, /* U+1dc3 */
  0x0000, /* U+1dc4 */
  0x0000, /* U+1dc5 */
  0x0000, /* U+1dc6 */
  0x0000, /* U+1dc7 */
  0x0000, /* U+1dc8 */
  0x0000, /* U+1dc9 */
  0x0000, /* U+1dca */
  0x0000, /* U+1dcb */
  0x0000, /* U+1dcc */
  0x0000, /* U+1dcd */
  0x0000, /* U+1dce */
  0x0000, /* U+1dcf */
  0x0000, /* U+1dd0 */
  0x0000, /* U+1dd1 */
  0x0000, /* U+1dd2 */
  0x0000, /* U+1dd3 */
  0x0000, /* U+1dd4 */
  0x0000, /* U+1dd5 */
  0x0000, /* U+1dd6 */
  0x0000, /* U+1dd7 */
  0x0000, /* U+1dd8 */
  0x0000, /* U+1dd9 */
  0x0000, /* U+1dda */
  0x0000, /* U+1ddb */
  0x0000, /* U+1ddc */
  0x0000, /* U+1ddd */
  0x0000, /* U+1dde */
  0x0000, /* U+1ddf */
  0x0000, /* U+1de0 */
  0x0000, /* U+1de1 */
  0x0000, /* U+1de2 */
  0x0000, /* U+1de3 */
  0x0000, /* U+1de4 */
  0x0000, /* U+1de5 */
  0x0000, /* U+1de6 */
  0x0000, /* U+1de7 */
  0x0000, /* U+1de8 */
  0x0000, /* U+1de9 */
  0x0000, /* U+1dea */
  0x0000, /* U+1deb */
  0x0000, /* U+1dec */
  0x0000, /* U+1ded */
  0x0000, /* U+1dee */
  0x0000, /* U+1def */
  0x0000, /* U+1df0 */
  0x0000, /* U+1df1 */
  0x0000, /* U+1df2 */
  0x0000, /* U+1df3 */
  0x0000, /* U+1df4 */
  0x0000, /* U+1df5 */
  0x0000, /* U+1df6 */
  0x0000, /* U+1df7 */
  0x0000, /* U+1df8 */
  0x0000, /* U+1df9 */
  0x0000, /* U+1dfa */
  0x0000, /* U+1dfb */
  0x0000, /* U+1dfc */
  0x0000, /* U+1dfd */
  0x0000, /* U+1dfe */
  0x0000, /* U+1dff */
  0x0000, /* U+1e00 */
  0x0000, /* U+1e01 */
  0x0000, /* U+1e02 */
  0x0000, /* U+1e03 */
  0x0000, /* U+1e04 */
  0x0000, /* U+1e05 */
  0x0000, /* U+1e06 */
  0x0000, /* U+1e07 */
  0x0000, /* U+1e08 */
  0x0000, /* U+1e09 */
  0x0000, /* U+1e0a */
  0x0000, /* U+1e0b */
  0x0000, /* U+1e0c */
  0x0000, /* U+1e0d */
  0x0000, /* U+1e0e */
  0x0000, /* U+1e0f */
  0x0000, /* U+1e10 */
  0x0000, /* U+1e11 */
  0x0000, /* U+1e12 */
  0x0000, /* U+1e13 */
  0x0000, /* U+1e14 */
  0x0000, /* U+1e15 */
  0x0000, /* U+1e16 */
  0x0000, /* U+1e17 */
  0x0000, /* U+1e18 */
  0x0000, /* U+1e19 */
  0x0000, /* U+1e1a */
  0x0000, /* U+1e1b */
  0x0000, /* U+1e1c */
  0x0000, /* U+1e1d */
  0x0000, /* U+1e1e */
  0x0000, /* U+1e1f */
  0x0000, /* U+1e20 */
  0x0000, /* U+1e21 */
  0x0000, /* U+1e22 */
  0x0000, /* U+1e23 */
  0x0000, /* U+1e24 */
  0x0000, /* U+1e25 */
  0x0000, /* U+1e26 */
  0x0000, /* U+1e27 */
  0x0000, /* U+1e28 */
  0x0000, /* U+1e29 */
  0x0000, /* U+1e2a */
  0x0000, /* U+1e2b */
  0x0000, /* U+1e2c */
  0x0000, /* U+1e2d */
  0x0000, /* U+1e2e */
  0x0000, /* U+1e2f */
  0x0000, /* U+1e30 */
  0x0000, /* U+1e31 */
  0x0000, /* U+1e32 */
  0x0000, /* U+1e33 */
  0x0000, /* U+1e34 */
  0x0000, /* U+1e35 */
  0x0000, /* U+1e36 */
  0x0000, /* U+1e37 */
  0x0000, /* U+1e38 */
  0x0000, /* U+1e39 */
  0x0000, /* U+1e3a */
  0x0000, /* U+1e3b */
  0x0000, /* U+1e3c */
  0x0000, /* U+1e3d */
  0x0000, /* U+1e3e */
  0x0000, /* U+1e3f */
  0x0000, /* U+1e40 */
  0x0000, /* U+1e41 */
  0x0000, /* U+1e42 */
  0x0000, /* U+1e43 */
  0x0000, /* U+1e44 */
  0x0000, /* U+1e45 */
  0x0000, /* U+1e46 */
  0x0000, /* U+1e47 */
  0x0000, /* U+1e48 */
  0x0000, /* U+1e49 */
  0x0000, /* U+1e4a */
  0x0000, /* U+1e4b */
  0x0000, /* U+1e4c */
  0x0000, /* U+1e4d */
  0x0000, /* U+1e4e */
  0x0000, /* U+1e4f */
  0x0000, /* U+1e50 */
  0x0000, /* U+1e51 */
  0x0000, /* U+1e52 */
  0x0000, /* U+1e53 */
  0x0000, /* U+1e54 */
  0x0000, /* U+1e55 */
  0x0000, /* U+1e56 */
  0x0000, /* U+1e57 */
  0x0000, /* U+1e58 */
  0x0000, /* U+1e59 */
  0x0000, /* U+1e5a */
  0x0000, /* U+1e5b */
  0x0000, /* U+1e5c */
  0x0000, /* U+1e5d */
  0x0000, /* U+1e5e */
  0x0000, /* U+1e5f */
  0x0000, /* U+1e60 */
  0x0000, /* U+1e61 */
  0x0000, /* U+1e62 */
  0x0000, /* U+1e63 */
  0x0000, /* U+1e64 */
  0x0000, /* U+1e65 */
  0x0000, /* U+1e66 */
  0x0000, /* U+1e67 */
  0x0000, /* U+1e68 */
  0x0000, /* U+1e69 */
  0x0000, /* U+1e6a */
  0x0000, /* U+1e6b */
  0x0000, /* U+1e6c */
  0x0000, /* U+1e6d */
  0x0000, /* U+1e6e */
  0x0000, /* U+1e6f */
  0x0000, /* U+1e70 */
  0x0000, /* U+1e71 */
  0x0000, /* U+1e72 */
  0x0000, /* U+1e73 */
  0x0000, /* U+1e74 */
  0x0000, /* U+1e75 */
  0x0000, /* U+1e76 */
  0x0000, /* U+1e77 */
  0x0000, /* U+1e78 */
  0x0000, /* U+1e79 */
  0x0000, /* U+1e7a */
  0x0000, /* U+1e7b */
  0x0000, /* U+1e7c */
  0x0000, /* U+1e7d */
  0x0000, /* U+1e7e */
  0x0000, /* U+1e7f */
  0x0000, /* U+1e80 */
  0x0000, /* U+1e81 */
  0x0000, /* U+1e82 */
  0x0000, /* U+1e83 */
  0x0000, /* U+1e84 */
  0x0000, /* U+1e85 */
  0x0000, /* U+1e86 */
  0x0000, /* U+1e87 */
  0x0000, /* U+1e88 */
  0x0000, /* U+1e89 */
  0x0000, /* U+1e8a */
  0x0000, /* U+1e8b */
  0x0000, /* U+1e8c */
  0x0000, /* U+1e8d */
  0x0000, /* U+1e8e */
  0x0000, /* U+1e8f */
  0x0000, /* U+1e90 */
  0x0000, /* U+1e91 */
  0x0000, /* U+1e92 */
  0x0000, /* U+1e93 */
  0x0000, /* U+1e94 */
  0x0000, /* U+1e95 */
  0x0000, /* U+1e96 */
  0x0000, /* U+1e97 */
  0x0000, /* U+1e98 */
  0x0000, /* U+1e99 */
  0x0000, /* U+1e9a */
  0x0000, /* U+1e9b */
  0x0000, /* U+1e9c */
  0x0000, /* U+1e9d */
  0x0000, /* U+1e9e */
  0x0000, /* U+1e9f */
  0x0000, /* U+1ea0 */
  0x0000, /* U+1ea1 */
  0x0000, /* U+1ea2 */
  0x0000, /* U+1ea3 */
  0x0000, /* U+1ea4 */
  0x0000, /* U+1ea5 */
  0x0000, /* U+1ea6 */
  0x0000, /* U+1ea7 */
  0x0000, /* U+1ea8 */
  0x0000, /* U+1ea9 */
  0x0000, /* U+1eaa */
  0x0000, /* U+1eab */
  0x0000, /* U+1eac */
  0x0000, /* U+1ead */
  0x0000, /* U+1eae */
  0x0000, /* U+1eaf */
  0x0000, /* U+1eb0 */
  0x0000, /* U+1eb1 */
  0x0000, /* U+1eb2 */
  0x0000, /* U+1eb3 */
  0x0000, /* U+1eb4 */
  0x0000, /* U+1eb5 */
  0x0000, /* U+1eb6 */
  0x0000, /* U+1eb7 */
  0x0000, /* U+1eb8 */
  0x0000, /* U+1eb9 */
  0x0000, /* U+1eba */
  0x0000, /* U+1ebb */
  0x0000, /* U+1ebc */
  0x0000, /* U+1ebd */
  0x0000, /* U+1ebe */
  0x0000, /* U+1ebf */
  0x0000, /* U+1ec0 */
  0x0000, /* U+1ec1 */
  0x0000, /* U+1ec2 */
  0x0000, /* U+1ec3 */
  0x0000, /* U+1ec4 */
  0x0000, /* U+1ec5 */
  0x0000, /* U+1ec6 */
  0x0000, /* U+1ec7 */
  0x0000, /* U+1ec8 */
  0x0000, /* U+1ec9 */
  0x0000, /* U+1eca */
  0x0000, /* U+1ecb */
  0x0000, /* U+1ecc */
  0x0000, /* U+1ecd */
  0x0000, /* U+1ece */
  0x0000, /* U+1ecf */
  0x0000, /* U+1ed0 */
  0x0000, /* U+1ed1 */
  0x0000, /* U+1ed2 */
  0x0000, /* U+1ed3 */
  0x0000, /* U+1ed4 */
  0x0000, /* U+1ed5 */
  0x0000, /* U+1ed6 */
  0x0000, /* U+1ed7 */
  0x0000, /* U+1ed8 */
  0x0000, /* U+1ed9 */
  0x0000, /* U+1eda */
  0x0000, /* U+1edb */
  0x0000, /* U+1edc */
  0x0000, /* U+1edd */
  0x0000, /* U+1ede */
  0x0000, /* U+1edf */
  0x0000, /* U+1ee0 */
  0x0000, /* U+1ee1 */
  0x0000, /* U+1ee2 */
  0x0000, /* U+1ee3 */
  0x0000, /* U+1ee4 */
  0x0000, /* U+1ee5 */
  0x0000, /* U+1ee6 */
  0x0000, /* U+1ee7 */
  0x0000, /* U+1ee8 */
  0x0000, /* U+1ee9 */
  0x0000, /* U+1eea */
  0x0000, /* U+1eeb */
  0x0000, /* U+1eec */
  0x0000, /* U+1eed */
  0x0000, /* U+1eee */
  0x0000, /* U+1eef */
  0x0000, /* U+1ef0 */
  0x0000, /* U+1ef1 */
  0x0000, /* U+1ef2 */
  0x0000, /* U+1ef3 */
  0x0000, /* U+1ef4 */
  0x0000, /* U+1ef5 */
  0x0000, /* U+1ef6 */
  0x0000, /* U+1ef7 */
  0x0000, /* U+1ef8 */
  0x0000, /* U+1ef9 */
  0x0000, /* U+1efa */
  0x0000, /* U+1efb */
  0x0000, /* U+1efc */
  0x0000, /* U+1efd */
  0x0000, /* U+1efe */
  0x0000, /* U+1eff */
  0x0000, /* U+1f00 */
  0x0000, /* U+1f01 */
  0x0000, /* U+1f02 */
  0x0000, /* U+1f03 */
  0x0000, /* U+1f04 */
  0x0000, /* U+1f05 */
  0x0000, /* U+1f06 */
  0x0000, /* U+1f07 */
  0x0000, /* U+1f08 */
  0x0000, /* U+1f09 */
  0x0000, /* U+1f0a */
  0x0000, /* U+1f0b */
  0x0000, /* U+1f0c */
  0x0000, /* U+1f0d */
  0x0000, /* U+1f0e */
  0x0000, /* U+1f0f */
  0x0000, /* U+1f10 */
  0x0000, /* U+1f11 */
  0x0000, /* U+1f12 */
  0x0000, /* U+1f13 */
  0x0000, /* U+1f14 */
  0x0000, /* U+1f15 */
  0x0000, /* U+1f16 */
  0x0000, /* U+1f17 */
  0x0000, /* U+1f18 */
  0x0000, /* U+1f19 */
  0x0000, /* U+1f1a */
  0x0000, /* U+1f1b */
  0x0000, /* U+1f1c */
  0x0000, /* U+1f1d */
  0x0000, /* U+1f1e */
  0x0000, /* U+1f1f */
  0x0000, /* U+1f20 */
  0x0000, /* U+1f21 */
  0x0000, /* U+1f22 */
  0x0000, /* U+1f23 */
  0x0000, /* U+1f24 */
  0x0000, /* U+1f25 */
  0x0000, /* U+1f26 */
  0x0000, /* U+1f27 */
  0x0000, /* U+1f28 */
  0x0000, /* U+1f29 */
  0x0000, /* U+1f2a */
  0x0000, /* U+1f2b */
  0x0000, /* U+1f2c */
  0x0000, /* U+1f2d */
  0x0000, /* U+1f2e */
  0x0000, /* U+1f2f */
  0x0000, /* U+1f30 */
  0x0000, /* U+1f31 */
  0x0000, /* U+1f32 */
  0x0000, /* U+1f33 */
  0x0000, /* U+1f34 */
  0x0000, /* U+1f35 */
  0x0000, /* U+1f36 */
  0x0000, /* U+1f37 */
  0x0000, /* U+1f38 */
  0x0000, /* U+1f39 */
  0x0000, /* U+1f3a */
  0x0000, /* U+1f3b */
  0x0000, /* U+1f3c */
  0x0000, /* U+1f3d */
  0x0000, /* U+1f3e */
  0x0000, /* U+1f3f */
  0x0000, /* U+1f40 */
  0x0000, /* U+1f41 */
  0x0000, /* U+1f42 */
  0x0000, /* U+1f43 */
  0x0000, /* U+1f44 */
  0x0000, /* U+1f45 */
  0x0000, /* U+1f46 */
  0x0000, /* U+1f47 */
  0x0000, /* U+1f48 */
  0x0000, /* U+1f49 */
  0x0000, /* U+1f4a */
  0x0000, /* U+1f4b */
  0x0000, /* U+1f4c */
  0x0000, /* U+1f4d */
  0x0000, /* U+1f4e */
  0x0000, /* U+1f4f */
  0x0000, /* U+1f50 */
  0x0000, /* U+1f51 */
  0x0000, /* U+1f52 */
  0x0000, /* U+1f53 */
  0x0000, /* U+1f54 */
  0x0000, /* U+1f55 */
  0x0000, /* U+1f56 */
  0x0000, /* U+1f57 */
  0x0000, /* U+1f58 */
  0x0000, /* U+1f59 */
  0x0000, /* U+1f5a */
  0x0000, /* U+1f5b */
  0x0000, /* U+1f5c */
  0x0000, /* U+1f5d */
  0x0000, /* U+1f5e */
  0x0000, /* U+1f5f */
  0x0000, /* U+1f60 */
  0x0000, /* U+1f61 */
  0x0000, /* U+1f62 */
  0x0000, /* U+1f63 */
  0x0000, /* U+1f64 */
  0x0000, /* U+1f65 */
  0x0000, /* U+1f66 */
  0x0000, /* U+1f67 */
  0x0000, /* U+1f68 */
  0x0000, /* U+1f69 */
  0x0000, /* U+1f6a */
  0x0000, /* U+1f6b */
  0x0000, /* U+1f6c */
  0x0000, /* U+1f6d */
  0x0000, /* U+1f6e */
  0x0000, /* U+1f6f */
  0x0000, /* U+1f70 */
  0x0000, /* U+1f71 */
  0x0000, /* U+1f72 */
  0x0000, /* U+1f73 */
  0x0000, /* U+1f74 */
  0x0000, /* U+1f75 */
  0x0000, /* U+1f76 */
  0x0000, /* U+1f77 */
  0x0000, /* U+1f78 */
  0x0000, /* U+1f79 */
  0x0000, /* U+1f7a */
  0x0000, /* U+1f7b */
  0x0000, /* U+1f7c */
  0x0000, /* U+1f7d */
  0x0000, /* U+1f7e */
  0x0000, /* U+1f7f */
  0x0000, /* U+1f80 */
  0x0000, /* U+1f81 */
  0x0000, /* U+1f82 */
  0x0000, /* U+1f83 */
  0x0000, /* U+1f84 */
  0x0000, /* U+1f85 */
  0x0000, /* U+1f86 */
  0x0000, /* U+1f87 */
  0x0000, /* U+1f88 */
  0x0000, /* U+1f89 */
  0x0000, /* U+1f8a */
  0x0000, /* U+1f8b */
  0x0000, /* U+1f8c */
  0x0000, /* U+1f8d */
  0x0000, /* U+1f8e */
  0x0000, /* U+1f8f */
  0x0000, /* U+1f90 */
  0x0000, /* U+1f91 */
  0x0000, /* U+1f92 */
  0x0000, /* U+1f93 */
  0x0000, /* U+1f94 */
  0x0000, /* U+1f95 */
  0x0000, /* U+1f96 */
  0x0000, /* U+1f97 */
  0x0000, /* U+1f98 */
  0x0000, /* U+1f99 */
  0x0000, /* U+1f9a */
  0x0000, /* U+1f9b */
  0x0000, /* U+1f9c */
  0x0000, /* U+1f9d */
  0x0000, /* U+1f9e */
  0x0000, /* U+1f9f */
  0x0000, /* U+1fa0 */
  0x0000, /* U+1fa1 */
  0x0000, /* U+1fa2 */
  0x0000, /* U+1fa3 */
  0x0000, /* U+1fa4 */
  0x0000, /* U+1fa5 */
  0x0000, /* U+1fa6 */
  0x0000, /* U+1fa7 */
  0x0000, /* U+1fa8 */
  0x0000, /* U+1fa9 */
  0x0000, /* U+1faa */
  0x0000, /* U+1fab */
  0x0000, /* U+1fac */
  0x0000, /* U+1fad */
  0x0000, /* U+1fae */
  0x0000, /* U+1faf */
  0x0000, /* U+1fb0 */
  0x0000, /* U+1fb1 */
  0x0000, /* U+1fb2 */
  0x0000, /* U+1fb3 */
  0x0000, /* U+1fb4 */
  0x0000, /* U+1fb5 */
  0x0000, /* U+1fb6 */
  0x0000, /* U+1fb7 */
  0x0000, /* U+1fb8 */
  0x0000, /* U+1fb9 */
  0x0000, /* U+1fba */
  0x0000, /* U+1fbb */
  0x0000, /* U+1fbc */
  0x0000, /* U+1fbd */
  0x0000, /* U+1fbe */
  0x0000, /* U+1fbf */
  0x0000, /* U+1fc0 */
  0x0000, /* U+1fc1 */
  0x0000, /* U+1fc2 */
  0x0000, /* U+1fc3 */
  0x0000, /* U+1fc4 */
  0x0000, /* U+1fc5 */
  0x0000, /* U+1fc6 */
  0x0000, /* U+1fc7 */
  0x0000, /* U+1fc8 */
  0x0000, /* U+1fc9 */
  0x0000, /* U+1fca */
  0x0000, /* U+1fcb */
  0x0000, /* U+1fcc */
  0x0000, /* U+1fcd */
  0x0000, /* U+1fce */
  0x0000, /* U+1fcf */
  0x0000, /* U+1fd0 */
  0x0000, /* U+1fd1 */
  0x0000, /* U+1fd2 */
  0x0000, /* U+1fd3 */
  0x0000, /* U+1fd4 */
  0x0000, /* U+1fd5 */
  0x0000, /* U+1fd6 */
  0x0000, /* U+1fd7 */
  0x0000, /* U+1fd8 */
  0x0000, /* U+1fd9 */
  0x0000, /* U+1fda */
  0x0000, /* U+1fdb */
  0x0000, /* U+1fdc */
  0x0000, /* U+1fdd */
  0x0000, /* U+1fde */
  0x0000, /* U+1fdf */
  0x0000, /* U+1fe0 */
  0x0000, /* U+1fe1 */
  0x0000, /* U+1fe2 */
  0x0000, /* U+1fe3 */
  0x0000, /* U+1fe4 */
  0x0000, /* U+1fe5 */
  0x0000, /* U+1fe6 */
  0x0000, /* U+1fe7 */
  0x0000, /* U+1fe8 */
  0x0000, /* U+1fe9 */
  0x0000, /* U+1fea */
  0x0000, /* U+1feb */
  0x0000, /* U+1fec */
  0x0000, /* U+1fed */
  0x0000, /* U+1fee */
  0x0000, /* U+1fef */
  0x0000, /* U+1ff0 */
  0x0000, /* U+1ff1 */
  0x0000, /* U+1ff2 */
  0x0000, /* U+1ff3 */
  0x0000, /* U+1ff4 */
  0x0000, /* U+1ff5 */
  0x0000, /* U+1ff6 */
  0x0000, /* U+1ff7 */
  0x0000, /* U+1ff8 */
  0x0000, /* U+1ff9 */
  0x0000, /* U+1ffa */
  0x0000, /* U+1ffb */
  0x0000, /* U+1ffc */
  0x0000, /* U+1ffd */
  0x0000, /* U+1ffe */
  0x0000, /* U+1fff */
  0x0000, /* U+2000 */
  0x0000, /* U+2001 */
  0x0000, /* U+2002 */
  0x0000, /* U+2003 */
  0x0000, /* U+2004 */
  0x0000, /* U+2005 */
  0x0000, /* U+2006 */
  0x0000, /* U+2007 */
  0x0000, /* U+2008 */
  0x0000, /* U+2009 */
  0x0000, /* U+200a */
  0x0000, /* U+200b */
  0x0000, /* U+200c */
  0x0000, /* U+200d */
  0x0000, /* U+200e */
  0x0000, /* U+200f */
  0x815d, /* U+2010 */
  0x0000, /* U+2011 */
  0x0000, /* U+2012 */
  0x0000, /* U+2013 */
  0x0000, /* U+2014 */
  0x815c, /* U+2015 */
  0x0000, /* U+2016 */
  0x0000, /* U+2017 */
  0x8165, /* U+2018 */
  0x8166, /* U+2019 */
  0x0000, /* U+201a */
  0x0000, /* U+201b */
  0x8167, /* U+201c */
  0x8168, /* U+201d */
  0x0000, /* U+201e */
  0x0000, /* U+201f */
  0x81f5, /* U+2020 */
  0x81f6, /* U+2021 */
  0x0000, /* U+2022 */
  0x0000, /* U+2023 */
  0x0000, /* U+2024 */
  0x8164, /* U+2025 */
  0x8163, /* U+2026 */
  0x0000, /* U+2027 */
  0x0000, /* U+2028 */
  0x0000, /* U+2029 */
  0x0000, /* U+202a */
  0x0000, /* U+202b */
  0x0000, /* U+202c */
  0x0000, /* U+202d */
  0x0000, /* U+202e */
  0x0000, /* U+202f */
  0x81f1, /* U+2030 */
  0x0000, /* U+2031 */
  0x818c, /* U+2032 */
  0x818d, /* U+2033 */
  0x0000, /* U+2034 */
  0x0000, /* U+2035 */
  0x0000, /* U+2036 */
  0x0000, /* U+2037 */
  0x0000, /* U+2038 */
  0x0000, /* U+2039 */
  0x0000, /* U+203a */
  0x81a6, /* U+203b */
  0x0000, /* U+203c */
  0x0000, /* U+203d */
  0x0000, /* U+203e */
  0x0000, /* U+203f */
  0x0000, /* U+2040 */
  0x0000, /* U+2041 */
  0x0000, /* U+2042 */
  0x0000, /* U+2043 */
  0x0000, /* U+2044 */
  0x0000, /* U+2045 */
  0x0000, /* U+2046 */
  0x0000, /* U+2047 */
  0x0000, /* U+2048 */
  0x0000, /* U+2049 */
  0x0000, /* U+204a */
  0x0000, /* U+204b */
  0x0000, /* U+204c */
  0x0000, /* U+204d */
  0x0000, /* U+204e */
  0x0000, /* U+204f */
  0x0000, /* U+2050 */
  0x0000, /* U+2051 */
  0x0000, /* U+2052 */
  0x0000, /* U+2053 */
  0x0000, /* U+2054 */
  0x0000, /* U+2055 */
  0x0000, /* U+2056 */
  0x0000, /* U+2057 */
  0x0000, /* U+2058 */
  0x0000, /* U+2059 */
  0x0000, /* U+205a */
  0x0000, /* U+205b */
  0x0000, /* U+205c */
  0x0000, /* U+205d */
  0x0000, /* U+205e */
  0x0000, /* U+205f */
  0x0000, /* U+2060 */
  0x0000, /* U+2061 */
  0x0000, /* U+2062 */
  0x0000, /* U+2063 */
  0x0000, /* U+2064 */
  0x0000, /* U+2065 */
  0x0000, /* U+2066 */
  0x0000, /* U+2067 */
  0x0000, /* U+2068 */
  0x0000, /* U+2069 */
  0x0000, /* U+206a */
  0x0000, /* U+206b */
  0x0000, /* U+206c */
  0x0000, /* U+206d */
  0x0000, /* U+206e */
  0x0000, /* U+206f */
  0x0000, /* U+2070 */
  0x0000, /* U+2071 */
  0x0000, /* U+2072 */
  0x0000, /* U+2073 */
  0x0000, /* U+2074 */
  0x0000, /* U+2075 */
  0x0000, /* U+2076 */
  0x0000, /* U+2077 */
  0x0000, /* U+2078 */
  0x0000, /* U+2079 */
  0x0000, /* U+207a */
  0x0000, /* U+207b */
  0x0000, /* U+207c */
  0x0000, /* U+207d */
  0x0000, /* U+207e */
  0x0000, /* U+207f */
  0x0000, /* U+2080 */
  0x0000, /* U+2081 */
  0x0000, /* U+2082 */
  0x0000, /* U+2083 */
  0x0000, /* U+2084 */
  0x0000, /* U+2085 */
  0x0000, /* U+2086 */
  0x0000, /* U+2087 */
  0x0000, /* U+2088 */
  0x0000, /* U+2089 */
  0x0000, /* U+208a */
  0x0000, /* U+208b */
  0x0000, /* U+208c */
  0x0000, /* U+208d */
  0x0000, /* U+208e */
  0x0000, /* U+208f */
  0x0000, /* U+2090 */
  0x0000, /* U+2091 */
  0x0000, /* U+2092 */
  0x0000, /* U+2093 */
  0x0000, /* U+2094 */
  0x0000, /* U+2095 */
  0x0000, /* U+2096 */
  0x0000, /* U+2097 */
  0x0000, /* U+2098 */
  0x0000, /* U+2099 */
  0x0000, /* U+209a */
  0x0000, /* U+209b */
  0x0000, /* U+209c */
  0x0000, /* U+209d */
  0x0000, /* U+209e */
  0x0000, /* U+209f */
  0x0000, /* U+20a0 */
  0x0000, /* U+20a1 */
  0x0000, /* U+20a2 */
  0x0000, /* U+20a3 */
  0x0000, /* U+20a4 */
  0x0000, /* U+20a5 */
  0x0000, /* U+20a6 */
  0x0000, /* U+20a7 */
  0x0000, /* U+20a8 */
  0x0000, /* U+20a9 */
  0x0000, /* U+20aa */
  0x0000, /* U+20ab */
  0x0000, /* U+20ac */
  0x0000, /* U+20ad */
  0x0000, /* U+20ae */
  0x0000, /* U+20af */
  0x0000, /* U+20b0 */
  0x0000, /* U+20b1 */
  0x0000, /* U+20b2 */
  0x0000, /* U+20b3 */
  0x0000, /* U+20b4 */
  0x0000, /* U+20b5 */
  0x0000, /* U+20b6 */
  0x0000, /* U+20b7 */
  0x0000, /* U+20b8 */
  0x0000, /* U+20b9 */
  0x0000, /* U+20ba */
  0x0000, /* U+20bb */
  0x0000, /* U+20bc */
  0x0000, /* U+20bd */
  0x0000, /* U+20be */
  0x0000, /* U+20bf */
  0x0000, /* U+20c0 */
  0x0000, /* U+20c1 */
  0x0000, /* U+20c2 */
  0x0000, /* U+20c3 */
  0x0000, /* U+20c4 */
  0x0000, /* U+20c5 */
  0x0000, /* U+20c6 */
  0x0000, /* U+20c7 */
  0x0000, /* U+20c8 */
  0x0000, /* U+20c9 */
  0x0000, /* U+20ca */
  0x0000, /* U+20cb */
  0x0000, /* U+20cc */
  0x0000, /* U+20cd */
  0x0000, /* U+20ce */
  0x0000, /* U+20cf */
  0x0000, /* U+20d0 */
  0x0000, /* U+20d1 */
  0x0000, /* U+20d2 */
  0x0000, /* U+20d3 */
  0x0000, /* U+20d4 */
  0x0000, /* U+20d5 */
  0x0000, /* U+20d6 */
  0x0000, /* U+20d7 */
  0x0000, /* U+20d8 */
  0x0000, /* U+20d9 */
  0x0000, /* U+20da */
  0x0000, /* U+20db */
  0x0000, /* U+20dc */
  0x0000, /* U+20dd */
  0x0000, /* U+20de */
  0x0000, /* U+20df */
  0x0000, /* U+20e0 */
  0x0000, /* U+20e1 */
  0x0000, /* U+20e2 */
  0x0000, /* U+20e3 */
  0x0000, /* U+20e4 */
  0x0000, /* U+20e5 */
  0x0000, /* U+20e6 */
  0x0000, /* U+20e7 */
  0x0000, /* U+20e8 */
  0x0000, /* U+20e9 */
  0x0000, /* U+20ea */
  0x0000, /* U+20eb */
  0x0000, /* U+20ec */
  0x0000, /* U+20ed */
  0x0000, /* U+20ee */
  0x0000, /* U+20ef */
  0x0000, /* U+20f0 */
  0x0000, /* U+20f1 */
  0x0000, /* U+20f2 */
  0x0000, /* U+20f3 */
  0x0000, /* U+20f4 */
  0x0000, /* U+20f5 */
  0x0000, /* U+20f6 */
  0x0000, /* U+20f7 */
  0x0000, /* U+20f8 */
  0x0000, /* U+20f9 */
  0x0000, /* U+20fa */
  0x0000, /* U+20fb */
  0x0000, /* U+20fc */
  0x0000, /* U+20fd */
  0x0000, /* U+20fe */
  0x0000, /* U+20ff */
  0x0000, /* U+2100 */
  0x0000, /* U+2101 */
  0x0000, /* U+2102 */
  0x818e, /* U+2103 */
  0x0000, /* U+2104 */
  0x0000, /* U+2105 */
  0x0000, /* U+2106 */
  0x0000, /* U+2107 */
  0x0000, /* U+2108 */
  0x0000, /* U+2109 */
  0x0000, /* U+210a */
  0x0000, /* U+210b */
  0x0000, /* U+210c */
  0x0000, /* U+210d */
  0x0000, /* U+210e */
  0x0000, /* U+210f */
  0x0000, /* U+2110 */
  0x0000, /* U+2111 */
  0x0000, /* U+2112 */
  0x0000, /* U+2113 */
  0x0000, /* U+2114 */
  0x0000, /* U+2115 */
  0xfa59, /* U+2116 */
  0x0000, /* U+2117 */
  0x0000, /* U+2118 */
  0x0000, /* U+2119 */
  0x0000, /* U+211a */
  0x0000, /* U+211b */
  0x0000, /* U+211c */
  0x0000, /* U+211d */
  0x0000, /* U+211e */
  0x0000, /* U+211f */
  0x0000, /* U+2120 */
  0xfa5a, /* U+2121 */
  0x0000, /* U+2122 */
  0x0000, /* U+2123 */
  0x0000, /* U+2124 */
  0x0000, /* U+2125 */
  0x0000, /* U+2126 */
  0x0000, /* U+2127 */
  0x0000, /* U+2128 */
  0x0000, /* U+2129 */
  0x0000, /* U+212a */
  0x81f0, /* U+212b */
  0x0000, /* U+212c */
  0x0000, /* U+212d */
  0x0000, /* U+212e */
  0x0000, /* U+212f */
  0x0000, /* U+2130 */
  0x0000, /* U+2131 */
  0x0000, /* U+2132 */
  0x0000, /* U+2133 */
  0x0000, /* U+2134 */
  0x0000, /* U+2135 */
  0x0000, /* U+2136 */
  0x0000, /* U+2137 */
  0x0000, /* U+2138 */
  0x0000, /* U+2139 */
  0x0000, /* U+213a */
  0x0000, /* U+213b */
  0x0000, /* U+213c */
  0x0000, /* U+213d */
  0x0000, /* U+213e */
  0x0000, /* U+213f */
  0x0000, /* U+2140 */
  0x0000, /* U+2141 */
  0x0000, /* U+2142 */
  0x0000, /* U+2143 */
  0x0000, /* U+2144 */
  0x0000, /* U+2145 */
  0x0000, /* U+2146 */
  0x0000, /* U+2147 */
  0x0000, /* U+2148 */
  0x0000, /* U+2149 */
  0x0000, /* U+214a */
  0x0000, /* U+214b */
  0x0000, /* U+214c */
  0x0000, /* U+214d */
  0x0000, /* U+214e */
  0x0000, /* U+214f */
  0x0000, /* U+2150 */
  0x0000, /* U+2151 */
  0x0000, /* U+2152 */
  0x0000, /* U+2153 */
  0x0000, /* U+2154 */
  0x0000, /* U+2155 */
  0x0000, /* U+2156 */
  0x0000, /* U+2157 */
  0x0000, /* U+2158 */
  0x0000, /* U+2159 */
  0x0000, /* U+215a */
  0x0000, /* U+215b */
  0x0000, /* U+215c */
  0x0000, /* U+215d */
  0x0000, /* U+215e */
  0x0000, /* U+215f */
  0xfa4a, /* U+2160 */
  0xfa4b, /* U+2161 */
  0xfa4c, /* U+2162 */
  0xfa4d, /* U+2163 */
  0xfa4e, /* U+2164 */
  0xfa4f, /* U+2165 */
  0xfa50, /* U+2166 */
  0xfa51, /* U+2167 */
  0xfa52, /* U+2168 */
  0xfa53, /* U+2169 */
  0x0000, /* U+216a */
  0x0000, /* U+216b */
  0x0000, /* U+216c */
  0x0000, /* U+216d */
  0x0000, /* U+216e */
  0x0000, /* U+216f */
  0xfa40, /* U+2170 */
  0xfa41, /* U+2171 */
  0xfa42, /* U+2172 */
  0xfa43, /* U+2173 */
  0xfa44, /* U+2174 */
  0xfa45, /* U+2175 */
  0xfa46, /* U+2176 */
  0xfa47, /* U+2177 */
  0xfa48, /* U+2178 */
  0xfa49, /* U+2179 */
  0x0000, /* U+217a */
  0x0000, /* U+217b */
  0x0000, /* U+217c */
  0x0000, /* U+217d */
  0x0000, /* U+217e */
  0x0000, /* U+217f */
  0x0000, /* U+2180 */
  0x0000, /* U+2181 */
  0x0000, /* U+2182 */
  0x0000, /* U+2183 */
  0x0000, /* U+2184 */
  0x0000, /* U+2185 */
  0x0000, /* U+2186 */
  0x0000, /* U+2187 */
  0x0000, /* U+2188 */
  0x0000, /* U+2189 */
  0x0000, /* U+218a */
  0x0000, /* U+218b */
  0x0000, /* U+218c */
  0x0000, /* U+218d */
  0x0000, /* U+218e */
  0x0000, /* U+218f */
  0x81a9, /* U+2190 */
  0x81aa, /* U+2191 */
  0x81a8, /* U+2192 */
  0x81ab, /* U+2193 */
  0x0000, /* U+2194 */
  0x0000, /* U+2195 */
  0x0000, /* U+2196 */
  0x0000, /* U+2197 */
  0x0000, /* U+2198 */
  0x0000, /* U+2199 */
  0x0000, /* U+219a */
  0x0000, /* U+219b */
  0x0000, /* U+219c */
  0x0000, /* U+219d */
  0x0000, /* U+219e */
  0x0000, /* U+219f */
  0x0000, /* U+21a0 */
  0x0000, /* U+21a1 */
  0x0000, /* U+21a2 */
  0x0000, /* U+21a3 */
  0x0000, /* U+21a4 */
  0x0000, /* U+21a5 */
  0x0000, /* U+21a6 */
  0x0000, /* U+21a7 */
  0x0000, /* U+21a8 */
  0x0000, /* U+21a9 */
  0x0000, /* U+21aa */
  0x0000, /* U+21ab */
  0x0000, /* U+21ac */
  0x0000, /* U+21ad */
  0x0000, /* U+21ae */
  0x0000, /* U+21af */
  0x0000, /* U+21b0 */
  0x0000, /* U+21b1 */
  0x0000, /* U+21b2 */
  0x0000, /* U+21b3 */
  0x0000, /* U+21b4 */
  0x0000, /* U+21b5 */
  0x0000, /* U+21b6 */
  0x0000, /* U+21b7 */
  0x0000, /* U+21b8 */
  0x0000, /* U+21b9 */
  0x0000, /* U+21ba */
  0x0000, /* U+21bb */
  0x0000, /* U+21bc */
  0x0000, /* U+21bd */
  0x0000, /* U+21be */
  0x0000, /* U+21bf */
  0x0000, /* U+21c0 */
  0x0000, /* U+21c1 */
  0x0000, /* U+21c2 */
  0x0000, /* U+21c3 */
  0x0000, /* U+21c4 */
  0x0000, /* U+21c5 */
  0x0000, /* U+21c6 */
  0x0000, /* U+21c7 */
  0x0000, /* U+21c8 */
  0x0000, /* U+21c9 */
  0x0000, /* U+21ca */
  0x0000, /* U+21cb */
  0x0000, /* U+21cc */
  0x0000, /* U+21cd */
  0x0000, /* U+21ce */
  0x0000, /* U+21cf */
  0x0000, /* U+21d0 */
  0x0000, /* U+21d1 */
  0x81cb, /* U+21d2 */
  0x0000, /* U+21d3 */
  0x81cc, /* U+21d4 */
  0x0000, /* U+21d5 */
  0x0000, /* U+21d6 */
  0x0000, /* U+21d7 */
  0x0000, /* U+21d8 */
  0x0000, /* U+21d9 */
  0x0000, /* U+21da */
  0x0000, /* U+21db */
  0x0000, /* U+21dc */
  0x0000, /* U+21dd */
  0x0000, /* U+21de */
  0x0000, /* U+21df */
  0x0000, /* U+21e0 */
  0x0000, /* U+21e1 */
  0x0000, /* U+21e2 */
  0x0000, /* U+21e3 */
  0x0000, /* U+21e4 */
  0x0000, /* U+21e5 */
  0x0000, /* U+21e6 */
  0x0000, /* U+21e7 */
  0x0000, /* U+21e8 */
  0x0000, /* U+21e9 */
  0x0000, /* U+21ea */
  0x0000, /* U+21eb */
  0x0000, /* U+21ec */
  0x0000, /* U+21ed */
  0x0000, /* U+21ee */
  0x0000, /* U+21ef */
  0x0000, /* U+21f0 */
  0x0000, /* U+21f1 */
  0x0000, /* U+21f2 */
  0x0000, /* U+21f3 */
  0x0000, /* U+21f4 */
  0x0000, /* U+21f5 */
  0x0000, /* U+21f6 */
  0x0000, /* U+21f7 */
  0x0000, /* U+21f8 */
  0x0000, /* U+21f9 */
  0x0000, /* U+21fa */
  0x0000, /* U+21fb */
  0x0000, /* U+21fc */
  0x0000, /* U+21fd */
  0x0000, /* U+21fe */
  0x0000, /* U+21ff */
  0x81cd, /* U+2200 */
  0x0000, /* U+2201 */
  0x81dd, /* U+2202 */
  0x81ce, /* U+2203 */
  0x0000, /* U+2204 */
  0x0000, /* U+2205 */
  0x0000, /* U+2206 */
  0x81de, /* U+2207 */
  0x81b8, /* U+2208 */
  0x0000, /* U+2209 */
  0x0000, /* U+220a */
  0x81b9, /* U+220b */
  0x0000, /* U+220c */
  0x0000, /* U+220d */
  0x0000, /* U+220e */
  0x0000, /* U+220f */
  0x0000, /* U+2210 */
  0x8794, /* U+2211 */
  0x0000, /* U+2212 */
  0x0000, /* U+2213 */
  0x0000, /* U+2214 */
  0x0000, /* U+2215 */
  0x0000, /* U+2216 */
  0x0000, /* U+2217 */
  0x0000, /* U+2218 */
  0x0000, /* U+2219 */
  0x81e3, /* U+221a */
  0x0000, /* U+221b */
  0x0000, /* U+221c */
  0x81e5, /* U+221d */
  0x8187, /* U+221e */
  0x8798, /* U+221f */
  0x81da, /* U+2220 */
  0x0000, /* U+2221 */
  0x0000, /* U+2222 */
  0x0000, /* U+2223 */
  0x0000, /* U+2224 */
  0x8161, /* U+2225 */
  0x0000, /* U+2226 */
  0x81c8, /* U+2227 */
  0x81c9, /* U+2228 */
  0x81bf, /* U+2229 */
  0x81be, /* U+222a */
  0x81e7, /* U+222b */
  0x81e8, /* U+222c */
  0x0000, /* U+222d */
  0x8793, /* U+222e */
  0x0000, /* U+222f */
  0x0000, /* U+2230 */
  0x0000, /* U+2231 */
  0x0000, /* U+2232 */
  0x0000, /* U+2233 */
  0x8188, /* U+2234 */
  0x81e6, /* U+2235 */
  0x0000, /* U+2236 */
  0x0000, /* U+2237 */
  0x0000, /* U+2238 */
  0x0000, /* U+2239 */
  0x0000, /* U+223a */
  0x0000, /* U+223b */
  0x0000, /* U+223c */
  0x81e4, /* U+223d */
  0x0000, /* U+223e */
  0x0000, /* U+223f */
  0x0000, /* U+2240 */
  0x0000, /* U+2241 */
  0x0000, /* U+2242 */
  0x0000, /* U+2243 */
  0x0000, /* U+2244 */
  0x0000, /* U+2245 */
  0x0000, /* U+2246 */
  0x0000, /* U+2247 */
  0x0000, /* U+2248 */
  0x0000, /* U+2249 */
  0x0000, /* U+224a */
  0x0000, /* U+224b */
  0x0000, /* U+224c */
  0x0000, /* U+224d */
  0x0000, /* U+224e */
  0x0000, /* U+224f */
  0x0000, /* U+2250 */
  0x0000, /* U+2251 */
  0x81e0, /* U+2252 */
  0x0000, /* U+2253 */
  0x0000, /* U+2254 */
  0x0000, /* U+2255 */
  0x0000, /* U+2256 */
  0x0000, /* U+2257 */
  0x0000, /* U+2258 */
  0x0000, /* U+2259 */
  0x0000, /* U+225a */
  0x0000, /* U+225b */
  0x0000, /* U+225c */
  0x0000, /* U+225d */
  0x0000, /* U+225e */
  0x0000, /* U+225f */
  0x8182, /* U+2260 */
  0x81df, /* U+2261 */
  0x0000, /* U+2262 */
  0x0000, /* U+2263 */
  0x0000, /* U+2264 */
  0x0000, /* U+2265 */
  0x8185, /* U+2266 */
  0x8186, /* U+2267 */
  0x0000, /* U+2268 */
  0x0000, /* U+2269 */
  0x81e1, /* U+226a */
  0x81e2, /* U+226b */
  0x0000, /* U+226c */
  0x0000, /* U+226d */
  0x0000, /* U+226e */
  0x0000, /* U+226f */
  0x0000, /* U+2270 */
  0x0000, /* U+2271 */
  0x0000, /* U+2272 */
  0x0000, /* U+2273 */
  0x0000, /* U+2274 */
  0x0000, /* U+2275 */
  0x0000, /* U+2276 */
  0x0000, /* U+2277 */
  0x0000, /* U+2278 */
  0x0000, /* U+2279 */
  0x0000, /* U+227a */
  0x0000, /* U+227b */
  0x0000, /* U+227c */
  0x0000, /* U+227d */
  0x0000, /* U+227e */
  0x0000, /* U+227f */
  0x0000, /* U+2280 */
  0x0000, /* U+2281 */
  0x81bc, /* U+2282 */
  0x81bd, /* U+2283 */
  0x0000, /* U+2284 */
  0x0000, /* U+2285 */
  0x81ba, /* U+2286 */
  0x81bb, /* U+2287 */
  0x0000, /* U+2288 */
  0x0000, /* U+2289 */
  0x0000, /* U+228a */
  0x0000, /* U+228b */
  0x0000, /* U+228c */
  0x0000, /* U+228d */
  0x0000, /* U+228e */
  0x0000, /* U+228f */
  0x0000, /* U+2290 */
  0x0000, /* U+2291 */
  0x0000, /* U+2292 */
  0x0000, /* U+2293 */
  0x0000, /* U+2294 */
  0x0000, /* U+2295 */
  0x0000, /* U+2296 */
  0x0000, /* U+2297 */
  0x0000, /* U+2298 */
  0x0000, /* U+2299 */
  0x0000, /* U+229a */
  0x0000, /* U+229b */
  0x0000, /* U+229c */
  0x0000, /* U+229d */
  0x0000, /* U+229e */
  0x0000, /* U+229f */
  0x0000, /* U+22a0 */
  0x0000, /* U+22a1 */
  0x0000, /* U+22a2 */
  0x0000, /* U+22a3 */
  0x0000, /* U+22a4 */
  0x81db, /* U+22a5 */
  0x0000, /* U+22a6 */
  0x0000, /* U+22a7 */
  0x0000, /* U+22a8 */
  0x0000, /* U+22a9 */
  0x0000, /* U+22aa */
  0x0000, /* U+22ab */
  0x0000, /* U+22ac */
  0x0000, /* U+22ad */
  0x0000, /* U+22ae */
  0x0000, /* U+22af */
  0x0000, /* U+22b0 */
  0x0000, /* U+22b1 */
  0x0000, /* U+22b2 */
  0x0000, /* U+22b3 */
  0x0000, /* U+22b4 */
  0x0000, /* U+22b5 */
  0x0000, /* U+22b6 */
  0x0000, /* U+22b7 */
  0x0000, /* U+22b8 */
  0x0000, /* U+22b9 */
  0x0000, /* U+22ba */
  0x0000, /* U+22bb */
  0x0000, /* U+22bc */
  0x0000, /* U+22bd */
  0x0000, /* U+22be */
  0x8799, /* U+22bf */
  0x0000, /* U+22c0 */
  0x0000, /* U+22c1 */
  0x0000, /* U+22c2 */
  0x0000, /* U+22c3 */
  0x0000, /* U+22c4 */
  0x0000, /* U+22c5 */
  0x0000, /* U+22c6 */
  0x0000, /* U+22c7 */
  0x0000, /* U+22c8 */
  0x0000, /* U+22c9 */
  0x0000, /* U+22ca */
  0x0000, /* U+22cb */
  0x0000, /* U+22cc */
  0x0000, /* U+22cd */
  0x0000, /* U+22ce */
  0x0000, /* U+22cf */
  0x0000, /* U+22d0 */
  0x0000, /* U+22d1 */
  0x0000, /* U+22d2 */
  0x0000, /* U+22d3 */
  0x0000, /* U+22d4 */
  0x0000, /* U+22d5 */
  0x0000, /* U+22d6 */
  0x0000, /* U+22d7 */
  0x0000, /* U+22d8 */
  0x0000, /* U+22d9 */
  0x0000, /* U+22da */
  0x0000, /* U+22db */
  0x0000, /* U+22dc */
  0x0000, /* U+22dd */
  0x0000, /* U+22de */
  0x0000, /* U+22df */
  0x0000, /* U+22e0 */
  0x0000, /* U+22e1 */
  0x0000, /* U+22e2 */
  0x0000, /* U+22e3 */
  0x0000, /* U+22e4 */
  0x0000, /* U+22e5 */
  0x0000, /* U+22e6 */
  0x0000, /* U+22e7 */
  0x0000, /* U+22e8 */
  0x0000, /* U+22e9 */
  0x0000, /* U+22ea */
  0x0000, /* U+22eb */
  0x0000, /* U+22ec */
  0x0000, /* U+22ed */
  0x0000, /* U+22ee */
  0x0000, /* U+22ef */
  0x0000, /* U+22f0 */
  0x0000, /* U+22f1 */
  0x0000, /* U+22f2 */
  0x0000, /* U+22f3 */
  0x0000, /* U+22f4 */
  0x0000, /* U+22f5 */
  0x0000, /* U+22f6 */
  0x0000, /* U+22f7 */
  0x0000, /* U+22f8 */
  0x0000, /* U+22f9 */
  0x0000, /* U+22fa */
  0x0000, /* U+22fb */
  0x0000, /* U+22fc */
  0x0000, /* U+22fd */
  0x0000, /* U+22fe */
  0x0000, /* U+22ff */
  0x0000, /* U+2300 */
  0x0000, /* U+2301 */
  0x0000, /* U+2302 */
  0x0000, /* U+2303 */
  0x0000, /* U+2304 */
  0x0000, /* U+2305 */
  0x0000, /* U+2306 */
  0x0000, /* U+2307 */
  0x0000, /* U+2308 */
  0x0000, /* U+2309 */
  0x0000, /* U+230a */
  0x0000, /* U+230b */
  0x0000, /* U+230c */
  0x0000, /* U+230d */
  0x0000, /* U+230e */
  0x0000, /* U+230f */
  0x0000, /* U+2310 */
  0x0000, /* U+2311 */
  0x81dc, /* U+2312 */
  0x0000, /* U+2313 */
  0x0000, /* U+2314 */
  0x0000, /* U+2315 */
  0x0000, /* U+2316 */
  0x0000, /* U+2317 */
  0x0000, /* U+2318 */
  0x0000, /* U+2319 */
  0x0000, /* U+231a */
  0x0000, /* U+231b */
  0x0000, /* U+231c */
  0x0000, /* U+231d */
  0x0000, /* U+231e */
  0x0000, /* U+231f */
  0x0000, /* U+2320 */
  0x0000, /* U+2321 */
  0x0000, /* U+2322 */
  0x0000, /* U+2323 */
  0x0000, /* U+2324 */
  0x0000, /* U+2325 */
  0x0000, /* U+2326 */
  0x0000, /* U+2327 */
  0x0000, /* U+2328 */
  0x0000, /* U+2329 */
  0x0000, /* U+232a */
  0x0000, /* U+232b */
  0x0000, /* U+232c */
  0x0000, /* U+232d */
  0x0000, /* U+232e */
  0x0000, /* U+232f */
  0x0000, /* U+2330 */
  0x0000, /* U+2331 */
  0x0000, /* U+2332 */
  0x0000, /* U+2333 */
  0x0000, /* U+2334 */
  0x0000, /* U+2335 */
  0x0000, /* U+2336 */
  0x0000, /* U+2337 */
  0x0000, /* U+2338 */
  0x0000, /* U+2339 */
  0x0000, /* U+233a */
  0x0000, /* U+233b */
  0x0000, /* U+233c */
  0x0000, /* U+233d */
  0x0000, /* U+233e */
  0x0000, /* U+233f */
  0x0000, /* U+2340 */
  0x0000, /* U+2341 */
  0x0000, /* U+2342 */
  0x0000, /* U+2343 */
  0x0000, /* U+2344 */
  0x0000, /* U+2345 */
  0x0000, /* U+2346 */
  0x0000, /* U+2347 */
  0x0000, /* U+2348 */
  0x0000, /* U+2349 */
  0x0000, /* U+234a */
  0x0000, /* U+234b */
  0x0000, /* U+234c */
  0x0000, /* U+234d */
  0x0000, /* U+234e */
  0x0000, /* U+234f */
  0x0000, /* U+2350 */
  0x0000, /* U+2351 */
  0x0000, /* U+2352 */
  0x0000, /* U+2353 */
  0x0000, /* U+2354 */
  0x0000, /* U+2355 */
  0x0000, /* U+2356 */
  0x0000, /* U+2357 */
  0x0000, /* U+2358 */
  0x0000, /* U+2359 */
  0x0000, /* U+235a */
  0x0000, /* U+235b */
  0x0000, /* U+235c */
  0x0000, /* U+235d */
  0x0000, /* U+235e */
  0x0000, /* U+235f */
  0x0000, /* U+2360 */
  0x0000, /* U+2361 */
  0x0000, /* U+2362 */
  0x0000, /* U+2363 */
  0x0000, /* U+2364 */
  0x0000, /* U+2365 */
  0x0000, /* U+2366 */
  0x0000, /* U+2367 */
  0x0000, /* U+2368 */
  0x0000, /* U+2369 */
  0x0000, /* U+236a */
  0x0000, /* U+236b */
  0x0000, /* U+236c */
  0x0000, /* U+236d */
  0x0000, /* U+236e */
  0x0000, /* U+236f */
  0x0000, /* U+2370 */
  0x0000, /* U+2371 */
  0x0000, /* U+2372 */
  0x0000, /* U+2373 */
  0x0000, /* U+2374 */
  0x0000, /* U+2375 */
  0x0000, /* U+2376 */
  0x0000, /* U+2377 */
  0x0000, /* U+2378 */
  0x0000, /* U+2379 */
  0x0000, /* U+237a */
  0x0000, /* U+237b */
  0x0000, /* U+237c */
  0x0000, /* U+237d */
  0x0000, /* U+237e */
  0x0000, /* U+237f */
  0x0000, /* U+2380 */
  0x0000, /* U+2381 */
  0x0000, /* U+2382 */
  0x0000, /* U+2383 */
  0x0000, /* U+2384 */
  0x0000, /* U+2385 */
  0x0000, /* U+2386 */
  0x0000, /* U+2387 */
  0x0000, /* U+2388 */
  0x0000, /* U+2389 */
  0x0000, /* U+238a */
  0x0000, /* U+238b */
  0x0000, /* U+238c */
  0x0000, /* U+238d */
  0x0000, /* U+238e */
  0x0000, /* U+238f */
  0x0000, /* U+2390 */
  0x0000, /* U+2391 */
  0x0000, /* U+2392 */
  0x0000, /* U+2393 */
  0x0000, /* U+2394 */
  0x0000, /* U+2395 */
  0x0000, /* U+2396 */
  0x0000, /* U+2397 */
  0x0000, /* U+2398 */
  0x0000, /* U+2399 */
  0x0000, /* U+239a */
  0x0000, /* U+239b */
  0x0000, /* U+239c */
  0x0000, /* U+239d */
  0x0000, /* U+239e */
  0x0000, /* U+239f */
  0x0000, /* U+23a0 */
  0x0000, /* U+23a1 */
  0x0000, /* U+23a2 */
  0x0000, /* U+23a3 */
  0x0000, /* U+23a4 */
  0x0000, /* U+23a5 */
  0x0000, /* U+23a6 */
  0x0000, /* U+23a7 */
  0x0000, /* U+23a8 */
  0x0000, /* U+23a9 */
  0x0000, /* U+23aa */
  0x0000, /* U+23ab */
  0x0000, /* U+23ac */
  0x0000, /* U+23ad */
  0x0000, /* U+23ae */
  0x0000, /* U+23af */
  0x0000, /* U+23b0 */
  0x0000, /* U+23b1 */
  0x0000, /* U+23b2 */
  0x0000, /* U+23b3 */
  0x0000, /* U+23b4 */
  0x0000, /* U+23b5 */
  0x0000, /* U+23b6 */
  0x0000, /* U+23b7 */
  0x0000, /* U+23b8 */
  0x0000, /* U+23b9 */
  0x0000, /* U+23ba */
  0x0000, /* U+23bb */
  0x0000, /* U+23bc */
  0x0000, /* U+23bd */
  0x0000, /* U+23be */
  0x0000, /* U+23bf */
  0x0000, /* U+23c0 */
  0x0000, /* U+23c1 */
  0x0000, /* U+23c2 */
  0x0000, /* U+23c3 */
  0x0000, /* U+23c4 */
  0x0000, /* U+23c5 */
  0x0000, /* U+23c6 */
  0x0000, /* U+23c7 */
  0x0000, /* U+23c8 */
  0x0000, /* U+23c9 */
  0x0000, /* U+23ca */
  0x0000, /* U+23cb */
  0x0000, /* U+23cc */
  0x0000, /* U+23cd */
  0x0000, /* U+23ce */
  0x0000, /* U+23cf */
  0x0000, /* U+23d0 */
  0x0000, /* U+23d1 */
  0x0000, /* U+23d2 */
  0x0000, /* U+23d3 */
  0x0000, /* U+23d4 */
  0x0000, /* U+23d5 */
  0x0000, /* U+23d6 */
  0x0000, /* U+23d7 */
  0x0000, /* U+23d8 */
  0x0000, /* U+23d9 */
  0x0000, /* U+23da */
  0x0000, /* U+23db */
  0x0000, /* U+23dc */
  0x0000, /* U+23dd */
  0x0000, /* U+23de */
  0x0000, /* U+23df */
  0x0000, /* U+23e0 */
  0x0000, /* U+23e1 */
  0x0000, /* U+23e2 */
  0x0000, /* U+23e3 */
  0x0000, /* U+23e4 */
  0x0000, /* U+23e5 */
  0x0000, /* U+23e6 */
  0x0000, /* U+23e7 */
  0x0000, /* U+23e8 */
  0x0000, /* U+23e9 */
  0x0000, /* U+23ea */
  0x0000, /* U+23eb */
  0x0000, /* U+23ec */
  0x0000, /* U+23ed */
  0x0000, /* U+23ee */
  0x0000, /* U+23ef */
  0x0000, /* U+23f0 */
  0x0000, /* U+23f1 */
  0x0000, /* U+23f2 */
  0x0000, /* U+23f3 */
  0x0000, /* U+23f4 */
  0x0000, /* U+23f5 */
  0x0000, /* U+23f6 */
  0x0000, /* U+23f7 */
  0x0000, /* U+23f8 */
  0x0000, /* U+23f9 */
  0x0000, /* U+23fa */
  0x0000, /* U+23fb */
  0x0000, /* U+23fc */
  0x0000, /* U+23fd */
  0x0000, /* U+23fe */
  0x0000, /* U+23ff */
  0x0000, /* U+2400 */
  0x0000, /* U+2401 */
  0x0000, /* U+2402 */
  0x0000, /* U+2403 */
  0x0000, /* U+2404 */
  0x0000, /* U+2405 */
  0x0000, /* U+2406 */
  0x0000, /* U+2407 */
  0x0000, /* U+2408 */
  0x0000, /* U+2409 */
  0x0000, /* U+240a */
  0x0000, /* U+240b */
  0x0000, /* U+240c */
  0x0000, /* U+240d */
  0x0000, /* U+240e */
  0x0000, /* U+240f */
  0x0000, /* U+2410 */
  0x0000, /* U+2411 */
  0x0000, /* U+2412 */
  0x0000, /* U+2413 */
  0x0000, /* U+2414 */
  0x0000, /* U+2415 */
  0x0000, /* U+2416 */
  0x0000, /* U+2417 */
  0x0000, /* U+2418 */
  0x0000, /* U+2419 */
  0x0000, /* U+241a */
  0x0000, /* U+241b */
  0x0000, /* U+241c */
  0x0000, /* U+241d */
  0x0000, /* U+241e */
  0x0000, /* U+241f */
  0x0000, /* U+2420 */
  0x0000, /* U+2421 */
  0x0000, /* U+2422 */
  0x0000, /* U+2423 */
  0x0000, /* U+2424 */
  0x0000, /* U+2425 */
  0x0000, /* U+2426 */
  0x0000, /* U+2427 */
  0x0000, /* U+2428 */
  0x0000, /* U+2429 */
  0x0000, /* U+242a */
  0x0000, /* U+242b */
  0x0000, /* U+242c */
  0x0000, /* U+242d */
  0x0000, /* U+242e */
  0x0000, /* U+242f */
  0x0000, /* U+2430 */
  0x0000, /* U+2431 */
  0x0000, /* U+2432 */
  0x0000, /* U+2433 */
  0x0000, /* U+2434 */
  0x0000, /* U+2435 */
  0x0000, /* U+2436 */
  0x0000, /* U+2437 */
  0x0000, /* U+2438 */
  0x0000, /* U+2439 */
  0x0000, /* U+243a */
  0x0000, /* U+243b */
  0x0000, /* U+243c */
  0x0000, /* U+243d */
  0x0000, /* U+243e */
  0x0000, /* U+243f */
  0x0000, /* U+2440 */
  0x0000, /* U+2441 */
  0x0000, /* U+2442 */
  0x0000, /* U+2443 */
  0x0000, /* U+2444 */
  0x0000, /* U+2445 */
  0x0000, /* U+2446 */
  0x0000, /* U+2447 */
  0x0000, /* U+2448 */
  0x0000, /* U+2449 */
  0x0000, /* U+244a */
  0x0000, /* U+244b */
  0x0000, /* U+244c */
  0x0000, /* U+244d */
  0x0000, /* U+244e */
  0x0000, /* U+244f */
  0x0000, /* U+2450 */
  0x0000, /* U+2451 */
  0x0000, /* U+2452 */
  0x0000, /* U+2453 */
  0x0000, /* U+2454 */
  0x0000, /* U+2455 */
  0x0000, /* U+2456 */
  0x0000, /* U+2457 */
  0x0000, /* U+2458 */
  0x0000, /* U+2459 */
  0x0000, /* U+245a */
  0x0000, /* U+245b */
  0x0000, /* U+245c */
  0x0000, /* U+245d */
  0x0000, /* U+245e */
  0x0000, /* U+245f */
  0x8740, /* U+2460 */
  0x8741, /* U+2461 */
  0x8742, /* U+2462 */
  0x8743, /* U+2463 */
  0x8744, /* U+2464 */
  0x8745, /* U+2465 */
  0x8746, /* U+2466 */
  0x8747, /* U+2467 */
  0x8748, /* U+2468 */
  0x8749, /* U+2469 */
  0x874a, /* U+246a */
  0x874b, /* U+246b */
  0x874c, /* U+246c */
  0x874d, /* U+246d */
  0x874e, /* U+246e */
  0x874f, /* U+246f */
  0x8750, /* U+2470 */
  0x8751, /* U+2471 */
  0x8752, /* U+2472 */
  0x8753, /* U+2473 */
  0x0000, /* U+2474 */
  0x0000, /* U+2475 */
  0x0000, /* U+2476 */
  0x0000, /* U+2477 */
  0x0000, /* U+2478 */
  0x0000, /* U+2479 */
  0x0000, /* U+247a */
  0x0000, /* U+247b */
  0x0000, /* U+247c */
  0x0000, /* U+247d */
  0x0000, /* U+247e */
  0x0000, /* U+247f */
  0x0000, /* U+2480 */
  0x0000, /* U+2481 */
  0x0000, /* U+2482 */
  0x0000, /* U+2483 */
  0x0000, /* U+2484 */
  0x0000, /* U+2485 */
  0x0000, /* U+2486 */
  0x0000, /* U+2487 */
  0x0000, /* U+2488 */
  0x0000, /* U+2489 */
  0x0000, /* U+248a */
  0x0000, /* U+248b */
  0x0000, /* U+248c */
  0x0000, /* U+248d */
  0x0000, /* U+248e */
  0x0000, /* U+248f */
  0x0000, /* U+2490 */
  0x0000, /* U+2491 */
  0x0000, /* U+2492 */
  0x0000, /* U+2493 */
  0x0000, /* U+2494 */
  0x0000, /* U+2495 */
  0x0000, /* U+2496 */
  0x0000, /* U+2497 */
  0x0000, /* U+2498 */
  0x0000, /* U+2499 */
  0x0000, /* U+249a */
  0x0000, /* U+249b */
  0x0000, /* U+249c */
  0x0000, /* U+249d */
  0x0000, /* U+249e */
  0x0000, /* U+249f */
  0x0000, /* U+24a0 */
  0x0000, /* U+24a1 */
  0x0000, /* U+24a2 */
  0x0000, /* U+24a3 */
  0x0000, /* U+24a4 */
  0x0000, /* U+24a5 */
  0x0000, /* U+24a6 */
  0x0000, /* U+24a7 */
  0x0000, /* U+24a8 */
  0x0000, /* U+24a9 */
  0x0000, /* U+24aa */
  0x0000, /* U+24ab */
  0x0000, /* U+24ac */
  0x0000, /* U+24ad */
  0x0000, /* U+24ae */
  0x0000, /* U+24af */
  0x0000, /* U+24b0 */
  0x0000, /* U+24b1 */
  0x0000, /* U+24b2 */
  0x0000, /* U+24b3 */
  0x0000, /* U+24b4 */
  0x0000, /* U+24b5 */
  0x0000, /* U+24b6 */
  0x0000, /* U+24b7 */
  0x0000, /* U+24b8 */
  0x0000, /* U+24b9 */
  0x0000, /* U+24ba */
  0x0000, /* U+24bb */
  0x0000, /* U+24bc */
  0x0000, /* U+24bd */
  0x0000, /* U+24be */
  0x0000, /* U+24bf */
  0x0000, /* U+24c0 */
  0x0000, /* U+24c1 */
  0x0000, /* U+24c2 */
  0x0000, /* U+24c3 */
  0x0000, /* U+24c4 */
  0x0000, /* U+24c5 */
  0x0000, /* U+24c6 */
  0x0000, /* U+24c7 */
  0x0000, /* U+24c8 */
  0x0000, /* U+24c9 */
  0x0000, /* U+24ca */
  0x0000, /* U+24cb */
  0x0000, /* U+24cc */
  0x0000, /* U+24cd */
  0x0000, /* U+24ce */
  0x0000, /* U+24cf */
  0x0000, /* U+24d0 */
  0x0000, /* U+24d1 */
  0x0000, /* U+24d2 */
  0x0000, /* U+24d3 */
  0x0000, /* U+24d4 */
  0x0000, /* U+24d5 */
  0x0000, /* U+24d6 */
  0x0000, /* U+24d7 */
  0x0000, /* U+24d8 */
  0x0000, /* U+24d9 */
  0x0000, /* U+24da */
  0x0000, /* U+24db */
  0x0000, /* U+24dc */
  0x0000, /* U+24dd */
  0x0000, /* U+24de */
  0x0000, /* U+24df */
  0x0000, /* U+24e0 */
  0x0000, /* U+24e1 */
  0x0000, /* U+24e2 */
  0x0000, /* U+24e3 */
  0x0000, /* U+24e4 */
  0x0000, /* U+24e5 */
  0x0000, /* U+24e6 */
  0x0000, /* U+24e7 */
  0x0000, /* U+24e8 */
  0x0000, /* U+24e9 */
  0x0000, /* U+24ea */
  0x0000, /* U+24eb */
  0x0000, /* U+24ec */
  0x0000, /* U+24ed */
  0x0000, /* U+24ee */
  0x0000, /* U+24ef */
  0x0000, /* U+24f0 */
  0x0000, /* U+24f1 */
  0x0000, /* U+24f2 */
  0x0000, /* U+24f3 */
  0x0000, /* U+24f4 */
  0x0000, /* U+24f5 */
  0x0000, /* U+24f6 */
  0x0000, /* U+24f7 */
  0x0000, /* U+24f8 */
  0x0000, /* U+24f9 */
  0x0000, /* U+24fa */
  0x0000, /* U+24fb */
  0x0000, /* U+24fc */
  0x0000, /* U+24fd */
  0x0000, /* U+24fe */
  0x0000, /* U+24ff */
  0x849f, /* U+2500 */
  0x84aa, /* U+2501 */
  0x84a0, /* U+2502 */
  0x84ab, /* U+2503 */
  0x0000, /* U+2504 */
  0x0000, /* U+2505 */
  0x0000, /* U+2506 */
  0x0000, /* U+2507 */
  0x0000, /* U+2508 */
  0x0000, /* U+2509 */
  0x0000, /* U+250a */
  0x0000, /* U+250b */
  0x84a1, /* U+250c */
  0x0000, /* U+250d */
  0x0000, /* U+250e */
  0x84ac, /* U+250f */
  0x84a2, /* U+2510 */
  0x0000, /* U+2511 */
  0x0000, /* U+2512 */
  0x84ad, /* U+2513 */
  0x84a4, /* U+2514 */
  0x0000, /* U+2515 */
  0x0000, /* U+2516 */
  0x84af, /* U+2517 */
  0x84a3, /* U+2518 */
  0x0000, /* U+2519 */
  0x0000, /* U+251a */
  0x84ae, /* U+251b */
  0x84a5, /* U+251c */
  0x84ba, /* U+251d */
  0x0000, /* U+251e */
  0x0000, /* U+251f */
  0x84b5, /* U+2520 */
  0x0000, /* U+2521 */
  0x0000, /* U+2522 */
  0x84b0, /* U+2523 */
  0x84a7, /* U+2524 */
  0x84bc, /* U+2525 */
  0x0000, /* U+2526 */
  0x0000, /* U+2527 */
  0x84b7, /* U+2528 */
  0x0000, /* U+2529 */
  0x0000, /* U+252a */
  0x84b2, /* U+252b */
  0x84a6, /* U+252c */
  0x0000, /* U+252d */
  0x0000, /* U+252e */
  0x84b6, /* U+252f */
  0x84bb, /* U+2530 */
  0x0000, /* U+2531 */
  0x0000, /* U+2532 */
  0x84b1, /* U+2533 */
  0x84a8, /* U+2534 */
  0x0000, /* U+2535 */
  0x0000, /* U+2536 */
  0x84b8, /* U+2537 */
  0x84bd, /* U+2538 */
  0x0000, /* U+2539 */
  0x0000, /* U+253a */
  0x84b3, /* U+253b */
  0x84a9, /* U+253c */
  0x0000, /* U+253d */
  0x0000, /* U+253e */
  0x84b9, /* U+253f */
  0x0000, /* U+2540 */
  0x0000, /* U+2541 */
  0x84be, /* U+2542 */
  0x0000, /* U+2543 */
  0x0000, /* U+2544 */
  0x0000, /* U+2545 */
  0x0000, /* U+2546 */
  0x0000, /* U+2547 */
  0x0000, /* U+2548 */
  0x0000, /* U+2549 */
  0x0000, /* U+254a */
  0x84b4, /* U+254b */
  0x0000, /* U+254c */
  0x0000, /* U+254d */
  0x0000, /* U+254e */
  0x0000, /* U+254f */
  0x0000, /* U+2550 */
  0x0000, /* U+2551 */
  0x0000, /* U+2552 */
  0x0000, /* U+2553 */
  0x0000, /* U+2554 */
  0x0000, /* U+2555 */
  0x0000, /* U+2556 */
  0x0000, /* U+2557 */
  0x0000, /* U+2558 */
  0x0000, /* U+2559 */
  0x0000, /* U+255a */
  0x0000, /* U+255b */
  0x0000, /* U+255c */
  0x0000, /* U+255d */
  0x0000, /* U+255e */
  0x0000, /* U+255f */
  0x0000, /* U+2560 */
  0x0000, /* U+2561 */
  0x0000, /* U+2562 */
  0x0000, /* U+2563 */
  0x0000, /* U+2564 */
  0x0000, /* U+2565 */
  0x0000, /* U+2566 */
  0x0000, /* U+2567 */
  0x0000, /* U+2568 */
  0x0000, /* U+2569 */
  0x0000, /* U+256a */
  0x0000, /* U+256b */
  0x0000, /* U+256c */
  0x0000, /* U+256d */
  0x0000, /* U+256e */
  0x0000, /* U+256f */
  0x0000, /* U+2570 */
  0x0000, /* U+2571 */
  0x0000, /* U+2572 */
  0x0000, /* U+2573 */
  0x0000, /* U+2574 */
  0x0000, /* U+2575 */
  0x0000, /* U+2576 */
  0x0000, /* U+2577 */
  0x0000, /* U+2578 */
  0x0000, /* U+2579 */
  0x0000, /* U+257a */
  0x0000, /* U+257b */
  0x0000, /* U+257c */
  0x0000, /* U+257d */
  0x0000, /* U+257e */
  0x0000, /* U+257f */
  0x0000, /* U+2580 */
  0x0000, /* U+2581 */
  0x0000, /* U+2582 */
  0x0000, /* U+2583 */
  0x0000, /* U+2584 */
  0x0000, /* U+2585 */
  0x0000, /* U+2586 */
  0x0000, /* U+2587 */
  0x0000, /* U+2588 */
  0x0000, /* U+2589 */
  0x0000, /* U+258a */
  0x0000, /* U+258b */
  0x0000, /* U+258c */
  0x0000, /* U+258d */
  0x0000, /* U+258e */
  0x0000, /* U+258f */
  0x0000, /* U+2590 */
  0x0000, /* U+2591 */
  0x0000, /* U+2592 */
  0x0000, /* U+2593 */
  0x0000, /* U+2594 */
  0x0000, /* U+2595 */
  0x0000, /* U+2596 */
  0x0000, /* U+2597 */
  0x0000, /* U+2598 */
  0x0000, /* U+2599 */
  0x0000, /* U+259a */
  0x0000, /* U+259b */
  0x0000, /* U+259c */
  0x0000, /* U+259d */
  0x0000, /* U+259e */
  0x0000, /* U+259f */
  0x81a1, /* U+25a0 */
  0x81a0, /* U+25a1 */
  0x0000, /* U+25a2 */
  0x0000, /* U+25a3 */
  0x0000, /* U+25a4 */
  0x0000, /* U+25a5 */
  0x0000, /* U+25a6 */
  0x0000, /* U+25a7 */
  0x0000, /* U+25a8 */
  0x0000, /* U+25a9 */
  0x0000, /* U+25aa */
  0x0000, /* U+25ab */
  0x0000, /* U+25ac */
  0x0000, /* U+25ad */
  0x0000, /* U+25ae */
  0x0000, /* U+25af */
  0x0000, /* U+25b0 */
  0x0000, /* U+25b1 */
  0x81a3, /* U+25b2 */
  0x81a2, /* U+25b3 */
  0x0000, /* U+25b4 */
  0x0000, /* U+25b5 */
  0x0000, /* U+25b6 */
  0x0000, /* U+25b7 */
  0x0000, /* U+25b8 */
  0x0000, /* U+25b9 */
  0x0000, /* U+25ba */
  0x0000, /* U+25bb */
  0x81a5, /* U+25bc */
  0x81a4, /* U+25bd */
  0x0000, /* U+25be */
  0x0000, /* U+25bf */
  0x0000, /* U+25c0 */
  0x0000, /* U+25c1 */
  0x0000, /* U+25c2 */
  0x0000, /* U+25c3 */
  0x0000, /* U+25c4 */
  0x0000, /* U+25c5 */
  0x819f, /* U+25c6 */
  0x819e, /* U+25c7 */
  0x0000, /* U+25c8 */
  0x0000, /* U+25c9 */
  0x0000, /* U+25ca */
  0x819b, /* U+25cb */
  0x0000, /* U+25cc */
  0x0000, /* U+25cd */
  0x819d, /* U+25ce */
  0x819c, /* U+25cf */
  0x0000, /* U+25d0 */
  0x0000, /* U+25d1 */
  0x0000, /* U+25d2 */
  0x0000, /* U+25d3 */
  0x0000, /* U+25d4 */
  0x0000, /* U+25d5 */
  0x0000, /* U+25d6 */
  0x0000, /* U+25d7 */
  0x0000, /* U+25d8 */
  0x0000, /* U+25d9 */
  0x0000, /* U+25da */
  0x0000, /* U+25db */
  0x0000, /* U+25dc */
  0x0000, /* U+25dd */
  0x0000, /* U+25de */
  0x0000, /* U+25df */
  0x0000, /* U+25e0 */
  0x0000, /* U+25e1 */
  0x0000, /* U+25e2 */
  0x0000, /* U+25e3 */
  0x0000, /* U+25e4 */
  0x0000, /* U+25e5 */
  0x0000, /* U+25e6 */
  0x0000, /* U+25e7 */
  0x0000, /* U+25e8 */
  0x0000, /* U+25e9 */
  0x0000, /* U+25ea */
  0x0000, /* U+25eb */
  0x0000, /* U+25ec */
  0x0000, /* U+25ed */
  0x0000, /* U+25ee */
  0x81fc, /* U+25ef */
  0x0000, /* U+25f0 */
  0x0000, /* U+25f1 */
  0x0000, /* U+25f2 */
  0x0000, /* U+25f3 */
  0x0000, /* U+25f4 */
  0x0000, /* U+25f5 */
  0x0000, /* U+25f6 */
  0x0000, /* U+25f7 */
  0x0000, /* U+25f8 */
  0x0000, /* U+25f9 */
  0x0000, /* U+25fa */
  0x0000, /* U+25fb */
  0x0000, /* U+25fc */
  0x0000, /* U+25fd */
  0x0000, /* U+25fe */
  0x0000, /* U+25ff */
  0x0000, /* U+2600 */
  0x0000, /* U+2601 */
  0x0000, /* U+2602 */
  0x0000, /* U+2603 */
  0x0000, /* U+2604 */
  0x819a, /* U+2605 */
  0x8199, /* U+2606 */
  0x0000, /* U+2607 */
  0x0000, /* U+2608 */
  0x0000, /* U+2609 */
  0x0000, /* U+260a */
  0x0000, /* U+260b */
  0x0000, /* U+260c */
  0x0000, /* U+260d */
  0x0000, /* U+260e */
  0x0000, /* U+260f */
  0x0000, /* U+2610 */
  0x0000, /* U+2611 */
  0x0000, /* U+2612 */
  0x0000, /* U+2613 */
  0x0000, /* U+2614 */
  0x0000, /* U+2615 */
  0x0000, /* U+2616 */
  0x0000, /* U+2617 */
  0x0000, /* U+2618 */
  0x0000, /* U+2619 */
  0x0000, /* U+261a */
  0x0000, /* U+261b */
  0x0000, /* U+261c */
  0x0000, /* U+261d */
  0x0000, /* U+261e */
  0x0000, /* U+261f */
  0x0000, /* U+2620 */
  0x0000, /* U+2621 */
  0x0000, /* U+2622 */
  0x0000, /* U+2623 */
  0x0000, /* U+2624 */
  0x0000, /* U+2625 */
  0x0000, /* U+2626 */
  0x0000, /* U+2627 */
  0x0000, /* U+2628 */
  0x0000, /* U+2629 */
  0x0000, /* U+262a */
  0x0000, /* U+262b */
  0x0000, /* U+262c */
  0x0000, /* U+262d */
  0x0000, /* U+262e */
  0x0000, /* U+262f */
  0x0000, /* U+2630 */
  0x0000, /* U+2631 */
  0x0000, /* U+2632 */
  0x0000, /* U+2633 */
  0x0000, /* U+2634 */
  0x0000, /* U+2635 */
  0x0000, /* U+2636 */
  0x0000, /* U+2637 */
  0x0000, /* U+2638 */
  0x0000, /* U+2639 */
  0x0000, /* U+263a */
  0x0000, /* U+263b */
  0x0000, /* U+263c */
  0x0000, /* U+263d */
  0x0000, /* U+263e */
  0x0000, /* U+263f */
  0x818a, /* U+2640 */
  0x0000, /* U+2641 */
  0x8189, /* U+2642 */
  0x0000, /* U+2643 */
  0x0000, /* U+2644 */
  0x0000, /* U+2645 */
  0x0000, /* U+2646 */
  0x0000, /* U+2647 */
  0x0000, /* U+2648 */
  0x0000, /* U+2649 */
  0x0000, /* U+264a */
  0x0000, /* U+264b */
  0x0000, /* U+264c */
  0x0000, /* U+264d */
  0x0000, /* U+264e */
  0x0000, /* U+264f */
  0x0000, /* U+2650 */
  0x0000, /* U+2651 */
  0x0000, /* U+2652 */
  0x0000, /* U+2653 */
  0x0000, /* U+2654 */
  0x0000, /* U+2655 */
  0x0000, /* U+2656 */
  0x0000, /* U+2657 */
  0x0000, /* U+2658 */
  0x0000, /* U+2659 */
  0x0000, /* U+265a */
  0x0000, /* U+265b */
  0x0000, /* U+265c */
  0x0000, /* U+265d */
  0x0000, /* U+265e */
  0x0000, /* U+265f */
  0x0000, /* U+2660 */
  0x0000, /* U+2661 */
  0x0000, /* U+2662 */
  0x0000, /* U+2663 */
  0x0000, /* U+2664 */
  0x0000, /* U+2665 */
  0x0000, /* U+2666 */
  0x0000, /* U+2667 */
  0x0000, /* U+2668 */
  0x0000, /* U+2669 */
  0x81f4, /* U+266a */
  0x0000, /* U+266b */
  0x0000, /* U+266c */
  0x81f3, /* U+266d */
  0x0000, /* U+266e */
  0x81f2, /* U+266f */
  0x0000, /* U+2670 */
  0x0000, /* U+2671 */
  0x0000, /* U+2672 */
  0x0000, /* U+2673 */
  0x0000, /* U+2674 */
  0x0000, /* U+2675 */
  0x0000, /* U+2676 */
  0x0000, /* U+2677 */
  0x0000, /* U+2678 */
  0x0000, /* U+2679 */
  0x0000, /* U+267a */
  0x0000, /* U+267b */
  0x0000, /* U+267c */
  0x0000, /* U+267d */
  0x0000, /* U+267e */
  0x0000, /* U+267f */
  0x0000, /* U+2680 */
  0x0000, /* U+2681 */
  0x0000, /* U+2682 */
  0x0000, /* U+2683 */
  0x0000, /* U+2684 */
  0x0000, /* U+2685 */
  0x0000, /* U+2686 */
  0x0000, /* U+2687 */
  0x0000, /* U+2688 */
  0x0000, /* U+2689 */
  0x0000, /* U+268a */
  0x0000, /* U+268b */
  0x0000, /* U+268c */
  0x0000, /* U+268d */
  0x0000, /* U+268e */
  0x0000, /* U+268f */
  0x0000, /* U+2690 */
  0x0000, /* U+2691 */
  0x0000, /* U+2692 */
  0x0000, /* U+2693 */
  0x0000, /* U+2694 */
  0x0000, /* U+2695 */
  0x0000, /* U+2696 */
  0x0000, /* U+2697 */
  0x0000, /* U+2698 */
  0x0000, /* U+2699 */
  0x0000, /* U+269a */
  0x0000, /* U+269b */
  0x0000, /* U+269c */
  0x0000, /* U+269d */
  0x0000, /* U+269e */
  0x0000, /* U+269f */
  0x0000, /* U+26a0 */
  0x0000, /* U+26a1 */
  0x0000, /* U+26a2 */
  0x0000, /* U+26a3 */
  0x0000, /* U+26a4 */
  0x0000, /* U+26a5 */
  0x0000, /* U+26a6 */
  0x0000, /* U+26a7 */
  0x0000, /* U+26a8 */
  0x0000, /* U+26a9 */
  0x0000, /* U+26aa */
  0x0000, /* U+26ab */
  0x0000, /* U+26ac */
  0x0000, /* U+26ad */
  0x0000, /* U+26ae */
  0x0000, /* U+26af */
  0x0000, /* U+26b0 */
  0x0000, /* U+26b1 */
  0x0000, /* U+26b2 */
  0x0000, /* U+26b3 */
  0x0000, /* U+26b4 */
  0x0000, /* U+26b5 */
  0x0000, /* U+26b6 */
  0x0000, /* U+26b7 */
  0x0000, /* U+26b8 */
  0x0000, /* U+26b9 */
  0x0000, /* U+26ba */
  0x0000, /* U+26bb */
  0x0000, /* U+26bc */
  0x0000, /* U+26bd */
  0x0000, /* U+26be */
  0x0000, /* U+26bf */
  0x0000, /* U+26c0 */
  0x0000, /* U+26c1 */
  0x0000, /* U+26c2 */
  0x0000, /* U+26c3 */
  0x0000, /* U+26c4 */
  0x0000, /* U+26c5 */
  0x0000, /* U+26c6 */
  0x0000, /* U+26c7 */
  0x0000, /* U+26c8 */
  0x0000, /* U+26c9 */
  0x0000, /* U+26ca */
  0x0000, /* U+26cb */
  0x0000, /* U+26cc */
  0x0000, /* U+26cd */
  0x0000, /* U+26ce */
  0x0000, /* U+26cf */
  0x0000, /* U+26d0 */
  0x0000, /* U+26d1 */
  0x0000, /* U+26d2 */
  0x0000, /* U+26d3 */
  0x0000, /* U+26d4 */
  0x0000, /* U+26d5 */
  0x0000, /* U+26d6 */
  0x0000, /* U+26d7 */
  0x0000, /* U+26d8 */
  0x0000, /* U+26d9 */
  0x0000, /* U+26da */
  0x0000, /* U+26db */
  0x0000, /* U+26dc */
  0x0000, /* U+26dd */
  0x0000, /* U+26de */
  0x0000, /* U+26df */
  0x0000, /* U+26e0 */
  0x0000, /* U+26e1 */
  0x0000, /* U+26e2 */
  0x0000, /* U+26e3 */
  0x0000, /* U+26e4 */
  0x0000, /* U+26e5 */
  0x0000, /* U+26e6 */
  0x0000, /* U+26e7 */
  0x0000, /* U+26e8 */
  0x0000, /* U+26e9 */
  0x0000, /* U+26ea */
  0x0000, /* U+26eb */
  0x0000, /* U+26ec */
  0x0000, /* U+26ed */
  0x0000, /* U+26ee */
  0x0000, /* U+26ef */
  0x0000, /* U+26f0 */
  0x0000, /* U+26f1 */
  0x0000, /* U+26f2 */
  0x0000, /* U+26f3 */
  0x0000, /* U+26f4 */
  0x0000, /* U+26f5 */
  0x0000, /* U+26f6 */
  0x0000, /* U+26f7 */
  0x0000, /* U+26f8 */
  0x0000, /* U+26f9 */
  0x0000, /* U+26fa */
  0x0000, /* U+26fb */
  0x0000, /* U+26fc */
  0x0000, /* U+26fd */
  0x0000, /* U+26fe */
  0x0000, /* U+26ff */
  0x0000, /* U+2700 */
  0x0000, /* U+2701 */
  0x0000, /* U+2702 */
  0x0000, /* U+2703 */
  0x0000, /* U+2704 */
  0x0000, /* U+2705 */
  0x0000, /* U+2706 */
  0x0000, /* U+2707 */
  0x0000, /* U+2708 */
  0x0000, /* U+2709 */
  0x0000, /* U+270a */
  0x0000, /* U+270b */
  0x0000, /* U+270c */
  0x0000, /* U+270d */
  0x0000, /* U+270e */
  0x0000, /* U+270f */
  0x0000, /* U+2710 */
  0x0000, /* U+2711 */
  0x0000, /* U+2712 */
  0x0000, /* U+2713 */
  0x0000, /* U+2714 */
  0x0000, /* U+2715 */
  0x0000, /* U+2716 */
  0x0000, /* U+2717 */
  0x0000, /* U+2718 */
  0x0000, /* U+2719 */
  0x0000, /* U+271a */
  0x0000, /* U+271b */
  0x0000, /* U+271c */
  0x0000, /* U+271d */
  0x0000, /* U+271e */
  0x0000, /* U+271f */
  0x0000, /* U+2720 */
  0x0000, /* U+2721 */
  0x0000, /* U+2722 */
  0x0000, /* U+2723 */
  0x0000, /* U+2724 */
  0x0000, /* U+2725 */
  0x0000, /* U+2726 */
  0x0000, /* U+2727 */
  0x0000, /* U+2728 */
  0x0000, /* U+2729 */
  0x0000, /* U+272a */
  0x0000, /* U+272b */
  0x0000, /* U+272c */
  0x0000, /* U+272d */
  0x0000, /* U+272e */
  0x0000, /* U+272f */
  0x0000, /* U+2730 */
  0x0000, /* U+2731 */
  0x0000, /* U+2732 */
  0x0000, /* U+2733 */
  0x0000, /* U+2734 */
  0x0000, /* U+2735 */
  0x0000, /* U+2736 */
  0x0000, /* U+2737 */
  0x0000, /* U+2738 */
  0x0000, /* U+2739 */
  0x0000, /* U+273a */
  0x0000, /* U+273b */
  0x0000, /* U+273c */
  0x0000, /* U+273d */
  0x0000, /* U+273e */
  0x0000, /* U+273f */
  0x0000, /* U+2740 */
  0x0000, /* U+2741 */
  0x0000, /* U+2742 */
  0x0000, /* U+2743 */
  0x0000, /* U+2744 */
  0x0000, /* U+2745 */
  0x0000, /* U+2746 */
  0x0000, /* U+2747 */
  0x0000, /* U+2748 */
  0x0000, /* U+2749 */
  0x0000, /* U+274a */
  0x0000, /* U+274b */
  0x0000, /* U+274c */
  0x0000, /* U+274d */
  0x0000, /* U+274e */
  0x0000, /* U+274f */
  0x0000, /* U+2750 */
  0x0000, /* U+2751 */
  0x0000, /* U+2752 */
  0x0000, /* U+2753 */
  0x0000, /* U+2754 */
  0x0000, /* U+2755 */
  0x0000, /* U+2756 */
  0x0000, /* U+2757 */
  0x0000, /* U+2758 */
  0x0000, /* U+2759 */
  0x0000, /* U+275a */
  0x0000, /* U+275b */
  0x0000, /* U+275c */
  0x0000, /* U+275d */
  0x0000, /* U+275e */
  0x0000, /* U+275f */
  0x0000, /* U+2760 */
  0x0000, /* U+2761 */
  0x0000, /* U+2762 */
  0x0000, /* U+2763 */
  0x0000, /* U+2764 */
  0x0000, /* U+2765 */
  0x0000, /* U+2766 */
  0x0000, /* U+2767 */
  0x0000, /* U+2768 */
  0x0000, /* U+2769 */
  0x0000, /* U+276a */
  0x0000, /* U+276b */
  0x0000, /* U+276c */
  0x0000, /* U+276d */
  0x0000, /* U+276e */
  0x0000, /* U+276f */
  0x0000, /* U+2770 */
  0x0000, /* U+2771 */
  0x0000, /* U+2772 */
  0x0000, /* U+2773 */
  0x0000, /* U+2774 */
  0x0000, /* U+2775 */
  0x0000, /* U+2776 */
  0x0000, /* U+2777 */
  0x0000, /* U+2778 */
  0x0000, /* U+2779 */
  0x0000, /* U+277a */
  0x0000, /* U+277b */
  0x0000, /* U+277c */
  0x0000, /* U+277d */
  0x0000, /* U+277e */
  0x0000, /* U+277f */
  0x0000, /* U+2780 */
  0x0000, /* U+2781 */
  0x0000, /* U+2782 */
  0x0000, /* U+2783 */
  0x0000, /* U+2784 */
  0x0000, /* U+2785 */
  0x0000, /* U+2786 */
  0x0000, /* U+2787 */
  0x0000, /* U+2788 */
  0x0000, /* U+2789 */
  0x0000, /* U+278a */
  0x0000, /* U+278b */
  0x0000, /* U+278c */
  0x0000, /* U+278d */
  0x0000, /* U+278e */
  0x0000, /* U+278f */
  0x0000, /* U+2790 */
  0x0000, /* U+2791 */
  0x0000, /* U+2792 */
  0x0000, /* U+2793 */
  0x0000, /* U+2794 */
  0x0000, /* U+2795 */
  0x0000, /* U+2796 */
  0x0000, /* U+2797 */
  0x0000, /* U+2798 */
  0x0000, /* U+2799 */
  0x0000, /* U+279a */
  0x0000, /* U+279b */
  0x0000, /* U+279c */
  0x0000, /* U+279d */
  0x0000, /* U+279e */
  0x0000, /* U+279f */
  0x0000, /* U+27a0 */
  0x0000, /* U+27a1 */
  0x0000, /* U+27a2 */
  0x0000, /* U+27a3 */
  0x0000, /* U+27a4 */
  0x0000, /* U+27a5 */
  0x0000, /* U+27a6 */
  0x0000, /* U+27a7 */
  0x0000, /* U+27a8 */
  0x0000, /* U+27a9 */
  0x0000, /* U+27aa */
  0x0000, /* U+27ab */
  0x0000, /* U+27ac */
  0x0000, /* U+27ad */
  0x0000, /* U+27ae */
  0x0000, /* U+27af */
  0x0000, /* U+27b0 */
  0x0000, /* U+27b1 */
  0x0000, /* U+27b2 */
  0x0000, /* U+27b3 */
  0x0000, /* U+27b4 */
  0x0000, /* U+27b5 */
  0x0000, /* U+27b6 */
  0x0000, /* U+27b7 */
  0x0000, /* U+27b8 */
  0x0000, /* U+27b9 */
  0x0000, /* U+27ba */
  0x0000, /* U+27bb */
  0x0000, /* U+27bc */
  0x0000, /* U+27bd */
  0x0000, /* U+27be */
  0x0000, /* U+27bf */
  0x0000, /* U+27c0 */
  0x0000, /* U+27c1 */
  0x0000, /* U+27c2 */
  0x0000, /* U+27c3 */
  0x0000, /* U+27c4 */
  0x0000, /* U+27c5 */
  0x0000, /* U+27c6 */
  0x0000, /* U+27c7 */
  0x0000, /* U+27c8 */
  0x0000, /* U+27c9 */
  0x0000, /* U+27ca */
  0x0000, /* U+27cb */
  0x0000, /* U+27cc */
  0x0000, /* U+27cd */
  0x0000, /* U+27ce */
  0x0000, /* U+27cf */
  0x0000, /* U+27d0 */
  0x0000, /* U+27d1 */
  0x0000, /* U+27d2 */
  0x0000, /* U+27d3 */
  0x0000, /* U+27d4 */
  0x0000, /* U+27d5 */
  0x0000, /* U+27d6 */
  0x0000, /* U+27d7 */
  0x0000, /* U+27d8 */
  0x0000, /* U+27d9 */
  0x0000, /* U+27da */
  0x0000, /* U+27db */
  0x0000, /* U+27dc */
  0x0000, /* U+27dd */
  0x0000, /* U+27de */
  0x0000, /* U+27df */
  0x0000, /* U+27e0 */
  0x0000, /* U+27e1 */
  0x0000, /* U+27e2 */
  0x0000, /* U+27e3 */
  0x0000, /* U+27e4 */
  0x0000, /* U+27e5 */
  0x0000, /* U+27e6 */
  0x0000, /* U+27e7 */
  0x0000, /* U+27e8 */
  0x0000, /* U+27e9 */
  0x0000, /* U+27ea */
  0x0000, /* U+27eb */
  0x0000, /* U+27ec */
  0x0000, /* U+27ed */
  0x0000, /* U+27ee */
  0x0000, /* U+27ef */
  0x0000, /* U+27f0 */
  0x0000, /* U+27f1 */
  0x0000, /* U+27f2 */
  0x0000, /* U+27f3 */
  0x0000, /* U+27f4 */
  0x0000, /* U+27f5 */
  0x0000, /* U+27f6 */
  0x0000, /* U+27f7 */
  0x0000, /* U+27f8 */
  0x0000, /* U+27f9 */
  0x0000, /* U+27fa */
  0x0000, /* U+27fb */
  0x0000, /* U+27fc */
  0x0000, /* U+27fd */
  0x0000, /* U+27fe */
  0x0000, /* U+27ff */
  0x0000, /* U+2800 */
  0x0000, /* U+2801 */
  0x0000, /* U+2802 */
  0x0000, /* U+2803 */
  0x0000, /* U+2804 */
  0x0000, /* U+2805 */
  0x0000, /* U+2806 */
  0x0000, /* U+2807 */
  0x0000, /* U+2808 */
  0x0000, /* U+2809 */
  0x0000, /* U+280a */
  0x0000, /* U+280b */
  0x0000, /* U+280c */
  0x0000, /* U+280d */
  0x0000, /* U+280e */
  0x0000, /* U+280f */
  0x0000, /* U+2810 */
  0x0000, /* U+2811 */
  0x0000, /* U+2812 */
  0x0000, /* U+2813 */
  0x0000, /* U+2814 */
  0x0000, /* U+2815 */
  0x0000, /* U+2816 */
  0x0000, /* U+2817 */
  0x0000, /* U+2818 */
  0x0000, /* U+2819 */
  0x0000, /* U+281a */
  0x0000, /* U+281b */
  0x0000, /* U+281c */
  0x0000, /* U+281d */
  0x0000, /* U+281e */
  0x0000, /* U+281f */
  0x0000, /* U+2820 */
  0x0000, /* U+2821 */
  0x0000, /* U+2822 */
  0x0000, /* U+2823 */
  0x0000, /* U+2824 */
  0x0000, /* U+2825 */
  0x0000, /* U+2826 */
  0x0000, /* U+2827 */
  0x0000, /* U+2828 */
  0x0000, /* U+2829 */
  0x0000, /* U+282a */
  0x0000, /* U+282b */
  0x0000, /* U+282c */
  0x0000, /* U+282d */
  0x0000, /* U+282e */
  0x0000, /* U+282f */
  0x0000, /* U+2830 */
  0x0000, /* U+2831 */
  0x0000, /* U+2832 */
  0x0000, /* U+2833 */
  0x0000, /* U+2834 */
  0x0000, /* U+2835 */
  0x0000, /* U+2836 */
  0x0000, /* U+2837 */
  0x0000, /* U+2838 */
  0x0000, /* U+2839 */
  0x0000, /* U+283a */
  0x0000, /* U+283b */
  0x0000, /* U+283c */
  0x0000, /* U+283d */
  0x0000, /* U+283e */
  0x0000, /* U+283f */
  0x0000, /* U+2840 */
  0x0000, /* U+2841 */
  0x0000, /* U+2842 */
  0x0000, /* U+2843 */
  0x0000, /* U+2844 */
  0x0000, /* U+2845 */
  0x0000, /* U+2846 */
  0x0000, /* U+2847 */
  0x0000, /* U+2848 */
  0x0000, /* U+2849 */
  0x0000, /* U+284a */
  0x0000, /* U+284b */
  0x0000, /* U+284c */
  0x0000, /* U+284d */
  0x0000, /* U+284e */
  0x0000, /* U+284f */
  0x0000, /* U+2850 */
  0x0000, /* U+2851 */
  0x0000, /* U+2852 */
  0x0000, /* U+2853 */
  0x0000, /* U+2854 */
  0x0000, /* U+2855 */
  0x0000, /* U+2856 */
  0x0000, /* U+2857 */
  0x0000, /* U+2858 */
  0x0000, /* U+2859 */
  0x0000, /* U+285a */
  0x0000, /* U+285b */
  0x0000, /* U+285c */
  0x0000, /* U+285d */
  0x0000, /* U+285e */
  0x0000, /* U+285f */
  0x0000, /* U+2860 */
  0x0000, /* U+2861 */
  0x0000, /* U+2862 */
  0x0000, /* U+2863 */
  0x0000, /* U+2864 */
  0x0000, /* U+2865 */
  0x0000, /* U+2866 */
  0x0000, /* U+2867 */
  0x0000, /* U+2868 */
  0x0000, /* U+2869 */
  0x0000, /* U+286a */
  0x0000, /* U+286b */
  0x0000, /* U+286c */
  0x0000, /* U+286d */
  0x0000, /* U+286e */
  0x0000, /* U+286f */
  0x0000, /* U+2870 */
  0x0000, /* U+2871 */
  0x0000, /* U+2872 */
  0x0000, /* U+2873 */
  0x0000, /* U+2874 */
  0x0000, /* U+2875 */
  0x0000, /* U+2876 */
  0x0000, /* U+2877 */
  0x0000, /* U+2878 */
  0x0000, /* U+2879 */
  0x0000, /* U+287a */
  0x0000, /* U+287b */
  0x0000, /* U+287c */
  0x0000, /* U+287d */
  0x0000, /* U+287e */
  0x0000, /* U+287f */
  0x0000, /* U+2880 */
  0x0000, /* U+2881 */
  0x0000, /* U+2882 */
  0x0000, /* U+2883 */
  0x0000, /* U+2884 */
  0x0000, /* U+2885 */
  0x0000, /* U+2886 */
  0x0000, /* U+2887 */
  0x0000, /* U+2888 */
  0x0000, /* U+2889 */
  0x0000, /* U+288a */
  0x0000, /* U+288b */
  0x0000, /* U+288c */
  0x0000, /* U+288d */
  0x0000, /* U+288e */
  0x0000, /* U+288f */
  0x0000, /* U+2890 */
  0x0000, /* U+2891 */
  0x0000, /* U+2892 */
  0x0000, /* U+2893 */
  0x0000, /* U+2894 */
  0x0000, /* U+2895 */
  0x0000, /* U+2896 */
  0x0000, /* U+2897 */
  0x0000, /* U+2898 */
  0x0000, /* U+2899 */
  0x0000, /* U+289a */
  0x0000, /* U+289b */
  0x0000, /* U+289c */
  0x0000, /* U+289d */
  0x0000, /* U+289e */
  0x0000, /* U+289f */
  0x0000, /* U+28a0 */
  0x0000, /* U+28a1 */
  0x0000, /* U+28a2 */
  0x0000, /* U+28a3 */
  0x0000, /* U+28a4 */
  0x0000, /* U+28a5 */
  0x0000, /* U+28a6 */
  0x0000, /* U+28a7 */
  0x0000, /* U+28a8 */
  0x0000, /* U+28a9 */
  0x0000, /* U+28aa */
  0x0000, /* U+28ab */
  0x0000, /* U+28ac */
  0x0000, /* U+28ad */
  0x0000, /* U+28ae */
  0x0000, /* U+28af */
  0x0000, /* U+28b0 */
  0x0000, /* U+28b1 */
  0x0000, /* U+28b2 */
  0x0000, /* U+28b3 */
  0x0000, /* U+28b4 */
  0x0000, /* U+28b5 */
  0x0000, /* U+28b6 */
  0x0000, /* U+28b7 */
  0x0000, /* U+28b8 */
  0x0000, /* U+28b9 */
  0x0000, /* U+28ba */
  0x0000, /* U+28bb */
  0x0000, /* U+28bc */
  0x0000, /* U+28bd */
  0x0000, /* U+28be */
  0x0000, /* U+28bf */
  0x0000, /* U+28c0 */
  0x0000, /* U+28c1 */
  0x0000, /* U+28c2 */
  0x0000, /* U+28c3 */
  0x0000, /* U+28c4 */
  0x0000, /* U+28c5 */
  0x0000, /* U+28c6 */
  0x0000, /* U+28c7 */
  0x0000, /* U+28c8 */
  0x0000, /* U+28c9 */
  0x0000, /* U+28ca */
  0x0000, /* U+28cb */
  0x0000, /* U+28cc */
  0x0000, /* U+28cd */
  0x0000, /* U+28ce */
  0x0000, /* U+28cf */
  0x0000, /* U+28d0 */
  0x0000, /* U+28d1 */
  0x0000, /* U+28d2 */
  0x0000, /* U+28d3 */
  0x0000, /* U+28d4 */
  0x0000, /* U+28d5 */
  0x0000, /* U+28d6 */
  0x0000, /* U+28d7 */
  0x0000, /* U+28d8 */
  0x0000, /* U+28d9 */
  0x0000, /* U+28da */
  0x0000, /* U+28db */
  0x0000, /* U+28dc */
  0x0000, /* U+28dd */
  0x0000, /* U+28de */
  0x0000, /* U+28df */
  0x0000, /* U+28e0 */
  0x0000, /* U+28e1 */
  0x0000, /* U+28e2 */
  0x0000, /* U+28e3 */
  0x0000, /* U+28e4 */
  0x0000, /* U+28e5 */
  0x0000, /* U+28e6 */
  0x0000, /* U+28e7 */
  0x0000, /* U+28e8 */
  0x0000, /* U+28e9 */
  0x0000, /* U+28ea */
  0x0000, /* U+28eb */
  0x0000, /* U+28ec */
  0x0000, /* U+28ed */
  0x0000, /* U+28ee */
  0x0000, /* U+28ef */
  0x0000, /* U+28f0 */
  0x0000, /* U+28f1 */
  0x0000, /* U+28f2 */
  0x0000, /* U+28f3 */
  0x0000, /* U+28f4 */
  0x0000, /* U+28f5 */
  0x0000, /* U+28f6 */
  0x0000, /* U+28f7 */
  0x0000, /* U+28f8 */
  0x0000, /* U+28f9 */
  0x0000, /* U+28fa */
  0x0000, /* U+28fb */
  0x0000, /* U+28fc */
  0x0000, /* U+28fd */
  0x0000, /* U+28fe */
  0x0000, /* U+28ff */
  0x0000, /* U+2900 */
  0x0000, /* U+2901 */
  0x0000, /* U+2902 */
  0x0000, /* U+2903 */
  0x0000, /* U+2904 */
  0x0000, /* U+2905 */
  0x0000, /* U+2906 */
  0x0000, /* U+2907 */
  0x0000, /* U+2908 */
  0x0000, /* U+2909 */
  0x0000, /* U+290a */
  0x0000, /* U+290b */
  0x0000, /* U+290c */
  0x0000, /* U+290d */
  0x0000, /* U+290e */
  0x0000, /* U+290f */
  0x0000, /* U+2910 */
  0x0000, /* U+2911 */
  0x0000, /* U+2912 */
  0x0000, /* U+2913 */
  0x0000, /* U+2914 */
  0x0000, /* U+2915 */
  0x0000, /* U+2916 */
  0x0000, /* U+2917 */
  0x0000, /* U+2918 */
  0x0000, /* U+2919 */
  0x0000, /* U+291a */
  0x0000, /* U+291b */
  0x0000, /* U+291c */
  0x0000, /* U+291d */
  0x0000, /* U+291e */
  0x0000, /* U+291f */
  0x0000, /* U+2920 */
  0x0000, /* U+2921 */
  0x0000, /* U+2922 */
  0x0000, /* U+2923 */
  0x0000, /* U+2924 */
  0x0000, /* U+2925 */
  0x0000, /* U+2926 */
  0x0000, /* U+2927 */
  0x0000, /* U+2928 */
  0x0000, /* U+2929 */
  0x0000, /* U+292a */
  0x0000, /* U+292b */
  0x0000, /* U+292c */
  0x0000, /* U+292d */
  0x0000, /* U+292e */
  0x0000, /* U+292f */
  0x0000, /* U+2930 */
  0x0000, /* U+2931 */
  0x0000, /* U+2932 */
  0x0000, /* U+2933 */
  0x0000, /* U+2934 */
  0x0000, /* U+2935 */
  0x0000, /* U+2936 */
  0x0000, /* U+2937 */
  0x0000, /* U+2938 */
  0x0000, /* U+2939 */
  0x0000, /* U+293a */
  0x0000, /* U+293b */
  0x0000, /* U+293c */
  0x0000, /* U+293d */
  0x0000, /* U+293e */
  0x0000, /* U+293f */
  0x0000, /* U+2940 */
  0x0000, /* U+2941 */
  0x0000, /* U+2942 */
  0x0000, /* U+2943 */
  0x0000, /* U+2944 */
  0x0000, /* U+2945 */
  0x0000, /* U+2946 */
  0x0000, /* U+2947 */
  0x0000, /* U+2948 */
  0x0000, /* U+2949 */
  0x0000, /* U+294a */
  0x0000, /* U+294b */
  0x0000, /* U+294c */
  0x0000, /* U+294d */
  0x0000, /* U+294e */
  0x0000, /* U+294f */
  0x0000, /* U+2950 */
  0x0000, /* U+2951 */
  0x0000, /* U+2952 */
  0x0000, /* U+2953 */
  0x0000, /* U+2954 */
  0x0000, /* U+2955 */
  0x0000, /* U+2956 */
  0x0000, /* U+2957 */
  0x0000, /* U+2958 */
  0x0000, /* U+2959 */
  0x0000, /* U+295a */
  0x0000, /* U+295b */
  0x0000, /* U+295c */
  0x0000, /* U+295d */
  0x0000, /* U+295e */
  0x0000, /* U+295f */
  0x0000, /* U+2960 */
  0x0000, /* U+2961 */
  0x0000, /* U+2962 */
  0x0000, /* U+2963 */
  0x0000, /* U+2964 */
  0x0000, /* U+2965 */
  0x0000, /* U+2966 */
  0x0000, /* U+2967 */
  0x0000, /* U+2968 */
  0x0000, /* U+2969 */
  0x0000, /* U+296a */
  0x0000, /* U+296b */
  0x0000, /* U+296c */
  0x0000, /* U+296d */
  0x0000, /* U+296e */
  0x0000, /* U+296f */
  0x0000, /* U+2970 */
  0x0000, /* U+2971 */
  0x0000, /* U+2972 */
  0x0000, /* U+2973 */
  0x0000, /* U+2974 */
  0x0000, /* U+2975 */
  0x0000, /* U+2976 */
  0x0000, /* U+2977 */
  0x0000, /* U+2978 */
  0x0000, /* U+2979 */
  0x0000, /* U+297a */
  0x0000, /* U+297b */
  0x0000, /* U+297c */
  0x0000, /* U+297d */
  0x0000, /* U+297e */
  0x0000, /* U+297f */
  0x0000, /* U+2980 */
  0x0000, /* U+2981 */
  0x0000, /* U+2982 */
  0x0000, /* U+2983 */
  0x0000, /* U+2984 */
  0x0000, /* U+2985 */
  0x0000, /* U+2986 */
  0x0000, /* U+2987 */
  0x0000, /* U+2988 */
  0x0000, /* U+2989 */
  0x0000, /* U+298a */
  0x0000, /* U+298b */
  0x0000, /* U+298c */
  0x0000, /* U+298d */
  0x0000, /* U+298e */
  0x0000, /* U+298f */
  0x0000, /* U+2990 */
  0x0000, /* U+2991 */
  0x0000, /* U+2992 */
  0x0000, /* U+2993 */
  0x0000, /* U+2994 */
  0x0000, /* U+2995 */
  0x0000, /* U+2996 */
  0x0000, /* U+2997 */
  0x0000, /* U+2998 */
  0x0000, /* U+2999 */
  0x0000, /* U+299a */
  0x0000, /* U+299b */
  0x0000, /* U+299c */
  0x0000, /* U+299d */
  0x0000, /* U+299e */
  0x0000, /* U+299f */
  0x0000, /* U+29a0 */
  0x0000, /* U+29a1 */
  0x0000, /* U+29a2 */
  0x0000, /* U+29a3 */
  0x0000, /* U+29a4 */
  0x0000, /* U+29a5 */
  0x0000, /* U+29a6 */
  0x0000, /* U+29a7 */
  0x0000, /* U+29a8 */
  0x0000, /* U+29a9 */
  0x0000, /* U+29aa */
  0x0000, /* U+29ab */
  0x0000, /* U+29ac */
  0x0000, /* U+29ad */
  0x0000, /* U+29ae */
  0x0000, /* U+29af */
  0x0000, /* U+29b0 */
  0x0000, /* U+29b1 */
  0x0000, /* U+29b2 */
  0x0000, /* U+29b3 */
  0x0000, /* U+29b4 */
  0x0000, /* U+29b5 */
  0x0000, /* U+29b6 */
  0x0000, /* U+29b7 */
  0x0000, /* U+29b8 */
  0x0000, /* U+29b9 */
  0x0000, /* U+29ba */
  0x0000, /* U+29bb */
  0x0000, /* U+29bc */
  0x0000, /* U+29bd */
  0x0000, /* U+29be */
  0x0000, /* U+29bf */
  0x0000, /* U+29c0 */
  0x0000, /* U+29c1 */
  0x0000, /* U+29c2 */
  0x0000, /* U+29c3 */
  0x0000, /* U+29c4 */
  0x0000, /* U+29c5 */
  0x0000, /* U+29c6 */
  0x0000, /* U+29c7 */
  0x0000, /* U+29c8 */
  0x0000, /* U+29c9 */
  0x0000, /* U+29ca */
  0x0000, /* U+29cb */
  0x0000, /* U+29cc */
  0x0000, /* U+29cd */
  0x0000, /* U+29ce */
  0x0000, /* U+29cf */
  0x0000, /* U+29d0 */
  0x0000, /* U+29d1 */
  0x0000, /* U+29d2 */
  0x0000, /* U+29d3 */
  0x0000, /* U+29d4 */
  0x0000, /* U+29d5 */
  0x0000, /* U+29d6 */
  0x0000, /* U+29d7 */
  0x0000, /* U+29d8 */
  0x0000, /* U+29d9 */
  0x0000, /* U+29da */
  0x0000, /* U+29db */
  0x0000, /* U+29dc */
  0x0000, /* U+29dd */
  0x0000, /* U+29de */
  0x0000, /* U+29df */
  0x0000, /* U+29e0 */
  0x0000, /* U+29e1 */
  0x0000, /* U+29e2 */
  0x0000, /* U+29e3 */
  0x0000, /* U+29e4 */
  0x0000, /* U+29e5 */
  0x0000, /* U+29e6 */
  0x0000, /* U+29e7 */
  0x0000, /* U+29e8 */
  0x0000, /* U+29e9 */
  0x0000, /* U+29ea */
  0x0000, /* U+29eb */
  0x0000, /* U+29ec */
  0x0000, /* U+29ed */
  0x0000, /* U+29ee */
  0x0000, /* U+29ef */
  0x0000, /* U+29f0 */
  0x0000, /* U+29f1 */
  0x0000, /* U+29f2 */
  0x0000, /* U+29f3 */
  0x0000, /* U+29f4 */
  0x0000, /* U+29f5 */
  0x0000, /* U+29f6 */
  0x0000, /* U+29f7 */
  0x0000, /* U+29f8 */
  0x0000, /* U+29f9 */
  0x0000, /* U+29fa */
  0x0000, /* U+29fb */
  0x0000, /* U+29fc */
  0x0000, /* U+29fd */
  0x0000, /* U+29fe */
  0x0000, /* U+29ff */
  0x0000, /* U+2a00 */
  0x0000, /* U+2a01 */
  0x0000, /* U+2a02 */
  0x0000, /* U+2a03 */
  0x0000, /* U+2a04 */
  0x0000, /* U+2a05 */
  0x0000, /* U+2a06 */
  0x0000, /* U+2a07 */
  0x0000, /* U+2a08 */
  0x0000, /* U+2a09 */
  0x0000, /* U+2a0a */
  0x0000, /* U+2a0b */
  0x0000, /* U+2a0c */
  0x0000, /* U+2a0d */
  0x0000, /* U+2a0e */
  0x0000, /* U+2a0f */
  0x0000, /* U+2a10 */
  0x0000, /* U+2a11 */
  0x0000, /* U+2a12 */
  0x0000, /* U+2a13 */
  0x0000, /* U+2a14 */
  0x0000, /* U+2a15 */
  0x0000, /* U+2a16 */
  0x0000, /* U+2a17 */
  0x0000, /* U+2a18 */
  0x0000, /* U+2a19 */
  0x0000, /* U+2a1a */
  0x0000, /* U+2a1b */
  0x0000, /* U+2a1c */
  0x0000, /* U+2a1d */
  0x0000, /* U+2a1e */
  0x0000, /* U+2a1f */
  0x0000, /* U+2a20 */
  0x0000, /* U+2a21 */
  0x0000, /* U+2a22 */
  0x0000, /* U+2a23 */
  0x0000, /* U+2a24 */
  0x0000, /* U+2a25 */
  0x0000, /* U+2a26 */
  0x0000, /* U+2a27 */
  0x0000, /* U+2a28 */
  0x0000, /* U+2a29 */
  0x0000, /* U+2a2a */
  0x0000, /* U+2a2b */
  0x0000, /* U+2a2c */
  0x0000, /* U+2a2d */
  0x0000, /* U+2a2e */
  0x0000, /* U+2a2f */
  0x0000, /* U+2a30 */
  0x0000, /* U+2a31 */
  0x0000, /* U+2a32 */
  0x0000, /* U+2a33 */
  0x0000, /* U+2a34 */
  0x0000, /* U+2a35 */
  0x0000, /* U+2a36 */
  0x0000, /* U+2a37 */
  0x0000, /* U+2a38 */
  0x0000, /* U+2a39 */
  0x0000, /* U+2a3a */
  0x0000, /* U+2a3b */
  0x0000, /* U+2a3c */
  0x0000, /* U+2a3d */
  0x0000, /* U+2a3e */
  0x0000, /* U+2a3f */
  0x0000, /* U+2a40 */
  0x0000, /* U+2a41 */
  0x0000, /* U+2a42 */
  0x0000, /* U+2a43 */
  0x0000, /* U+2a44 */
  0x0000, /* U+2a45 */
  0x0000, /* U+2a46 */
  0x0000, /* U+2a47 */
  0x0000, /* U+2a48 */
  0x0000, /* U+2a49 */
  0x0000, /* U+2a4a */
  0x0000, /* U+2a4b */
  0x0000, /* U+2a4c */
  0x0000, /* U+2a4d */
  0x0000, /* U+2a4e */
  0x0000, /* U+2a4f */
  0x0000, /* U+2a50 */
  0x0000, /* U+2a51 */
  0x0000, /* U+2a52 */
  0x0000, /* U+2a53 */
  0x0000, /* U+2a54 */
  0x0000, /* U+2a55 */
  0x0000, /* U+2a56 */
  0x0000, /* U+2a57 */
  0x0000, /* U+2a58 */
  0x0000, /* U+2a59 */
  0x0000, /* U+2a5a */
  0x0000, /* U+2a5b */
  0x0000, /* U+2a5c */
  0x0000, /* U+2a5d */
  0x0000, /* U+2a5e */
  0x0000, /* U+2a5f */
  0x0000, /* U+2a60 */
  0x0000, /* U+2a61 */
  0x0000, /* U+2a62 */
  0x0000, /* U+2a63 */
  0x0000, /* U+2a64 */
  0x0000, /* U+2a65 */
  0x0000, /* U+2a66 */
  0x0000, /* U+2a67 */
  0x0000, /* U+2a68 */
  0x0000, /* U+2a69 */
  0x0000, /* U+2a6a */
  0x0000, /* U+2a6b */
  0x0000, /* U+2a6c */
  0x0000, /* U+2a6d */
  0x0000, /* U+2a6e */
  0x0000, /* U+2a6f */
  0x0000, /* U+2a70 */
  0x0000, /* U+2a71 */
  0x0000, /* U+2a72 */
  0x0000, /* U+2a73 */
  0x0000, /* U+2a74 */
  0x0000, /* U+2a75 */
  0x0000, /* U+2a76 */
  0x0000, /* U+2a77 */
  0x0000, /* U+2a78 */
  0x0000, /* U+2a79 */
  0x0000, /* U+2a7a */
  0x0000, /* U+2a7b */
  0x0000, /* U+2a7c */
  0x0000, /* U+2a7d */
  0x0000, /* U+2a7e */
  0x0000, /* U+2a7f */
  0x0000, /* U+2a80 */
  0x0000, /* U+2a81 */
  0x0000, /* U+2a82 */
  0x0000, /* U+2a83 */
  0x0000, /* U+2a84 */
  0x0000, /* U+2a85 */
  0x0000, /* U+2a86 */
  0x0000, /* U+2a87 */
  0x0000, /* U+2a88 */
  0x0000, /* U+2a89 */
  0x0000, /* U+2a8a */
  0x0000, /* U+2a8b */
  0x0000, /* U+2a8c */
  0x0000, /* U+2a8d */
  0x0000, /* U+2a8e */
  0x0000, /* U+2a8f */
  0x0000, /* U+2a90 */
  0x0000, /* U+2a91 */
  0x0000, /* U+2a92 */
  0x0000, /* U+2a93 */
  0x0000, /* U+2a94 */
  0x0000, /* U+2a95 */
  0x0000, /* U+2a96 */
  0x0000, /* U+2a97 */
  0x0000, /* U+2a98 */
  0x0000, /* U+2a99 */
  0x0000, /* U+2a9a */
  0x0000, /* U+2a9b */
  0x0000, /* U+2a9c */
  0x0000, /* U+2a9d */
  0x0000, /* U+2a9e */
  0x0000, /* U+2a9f */
  0x0000, /* U+2aa0 */
  0x0000, /* U+2aa1 */
  0x0000, /* U+2aa2 */
  0x0000, /* U+2aa3 */
  0x0000, /* U+2aa4 */
  0x0000, /* U+2aa5 */
  0x0000, /* U+2aa6 */
  0x0000, /* U+2aa7 */
  0x0000, /* U+2aa8 */
  0x0000, /* U+2aa9 */
  0x0000, /* U+2aaa */
  0x0000, /* U+2aab */
  0x0000, /* U+2aac */
  0x0000, /* U+2aad */
  0x0000, /* U+2aae */
  0x0000, /* U+2aaf */
  0x0000, /* U+2ab0 */
  0x0000, /* U+2ab1 */
  0x0000, /* U+2ab2 */
  0x0000, /* U+2ab3 */
  0x0000, /* U+2ab4 */
  0x0000, /* U+2ab5 */
  0x0000, /* U+2ab6 */
  0x0000, /* U+2ab7 */
  0x0000, /* U+2ab8 */
  0x0000, /* U+2ab9 */
  0x0000, /* U+2aba */
  0x0000, /* U+2abb */
  0x0000, /* U+2abc */
  0x0000, /* U+2abd */
  0x0000, /* U+2abe */
  0x0000, /* U+2abf */
  0x0000, /* U+2ac0 */
  0x0000, /* U+2ac1 */
  0x0000, /* U+2ac2 */
  0x0000, /* U+2ac3 */
  0x0000, /* U+2ac4 */
  0x0000, /* U+2ac5 */
  0x0000, /* U+2ac6 */
  0x0000, /* U+2ac7 */
  0x0000, /* U+2ac8 */
  0x0000, /* U+2ac9 */
  0x0000, /* U+2aca */
  0x0000, /* U+2acb */
  0x0000, /* U+2acc */
  0x0000, /* U+2acd */
  0x0000, /* U+2ace */
  0x0000, /* U+2acf */
  0x0000, /* U+2ad0 */
  0x0000, /* U+2ad1 */
  0x0000, /* U+2ad2 */
  0x0000, /* U+2ad3 */
  0x0000, /* U+2ad4 */
  0x0000, /* U+2ad5 */
  0x0000, /* U+2ad6 */
  0x0000, /* U+2ad7 */
  0x0000, /* U+2ad8 */
  0x0000, /* U+2ad9 */
  0x0000, /* U+2ada */
  0x0000, /* U+2adb */
  0x0000, /* U+2adc */
  0x0000, /* U+2add */
  0x0000, /* U+2ade */
  0x0000, /* U+2adf */
  0x0000, /* U+2ae0 */
  0x0000, /* U+2ae1 */
  0x0000, /* U+2ae2 */
  0x0000, /* U+2ae3 */
  0x0000, /* U+2ae4 */
  0x0000, /* U+2ae5 */
  0x0000, /* U+2ae6 */
  0x0000, /* U+2ae7 */
  0x0000, /* U+2ae8 */
  0x0000, /* U+2ae9 */
  0x0000, /* U+2aea */
  0x0000, /* U+2aeb */
  0x0000, /* U+2aec */
  0x0000, /* U+2aed */
  0x0000, /* U+2aee */
  0x0000, /* U+2aef */
  0x0000, /* U+2af0 */
  0x0000, /* U+2af1 */
  0x0000, /* U+2af2 */
  0x0000, /* U+2af3 */
  0x0000, /* U+2af4 */
  0x0000, /* U+2af5 */
  0x0000, /* U+2af6 */
  0x0000, /* U+2af7 */
  0x0000, /* U+2af8 */
  0x0000, /* U+2af9 */
  0x0000, /* U+2afa */
  0x0000, /* U+2afb */
  0x0000, /* U+2afc */
  0x0000, /* U+2afd */
  0x0000, /* U+2afe */
  0x0000, /* U+2aff */
  0x0000, /* U+2b00 */
  0x0000, /* U+2b01 */
  0x0000, /* U+2b02 */
  0x0000, /* U+2b03 */
  0x0000, /* U+2b04 */
  0x0000, /* U+2b05 */
  0x0000, /* U+2b06 */
  0x0000, /* U+2b07 */
  0x0000, /* U+2b08 */
  0x0000, /* U+2b09 */
  0x0000, /* U+2b0a */
  0x0000, /* U+2b0b */
  0x0000, /* U+2b0c */
  0x0000, /* U+2b0d */
  0x0000, /* U+2b0e */
  0x0000, /* U+2b0f */
  0x0000, /* U+2b10 */
  0x0000, /* U+2b11 */
  0x0000, /* U+2b12 */
  0x0000, /* U+2b13 */
  0x0000, /* U+2b14 */
  0x0000, /* U+2b15 */
  0x0000, /* U+2b16 */
  0x0000, /* U+2b17 */
  0x0000, /* U+2b18 */
  0x0000, /* U+2b19 */
  0x0000, /* U+2b1a */
  0x0000, /* U+2b1b */
  0x0000, /* U+2b1c */
  0x0000, /* U+2b1d */
  0x0000, /* U+2b1e */
  0x0000, /* U+2b1f */
  0x0000, /* U+2b20 */
  0x0000, /* U+2b21 */
  0x0000, /* U+2b22 */
  0x0000, /* U+2b23 */
  0x0000, /* U+2b24 */
  0x0000, /* U+2b25 */
  0x0000, /* U+2b26 */
  0x0000, /* U+2b27 */
  0x0000, /* U+2b28 */
  0x0000, /* U+2b29 */
  0x0000, /* U+2b2a */
  0x0000, /* U+2b2b */
  0x0000, /* U+2b2c */
  0x0000, /* U+2b2d */
  0x0000, /* U+2b2e */
  0x0000, /* U+2b2f */
  0x0000, /* U+2b30 */
  0x0000, /* U+2b31 */
  0x0000, /* U+2b32 */
  0x0000, /* U+2b33 */
  0x0000, /* U+2b34 */
  0x0000, /* U+2b35 */
  0x0000, /* U+2b36 */
  0x0000, /* U+2b37 */
  0x0000, /* U+2b38 */
  0x0000, /* U+2b39 */
  0x0000, /* U+2b3a */
  0x0000, /* U+2b3b */
  0x0000, /* U+2b3c */
  0x0000, /* U+2b3d */
  0x0000, /* U+2b3e */
  0x0000, /* U+2b3f */
  0x0000, /* U+2b40 */
  0x0000, /* U+2b41 */
  0x0000, /* U+2b42 */
  0x0000, /* U+2b43 */
  0x0000, /* U+2b44 */
  0x0000, /* U+2b45 */
  0x0000, /* U+2b46 */
  0x0000, /* U+2b47 */
  0x0000, /* U+2b48 */
  0x0000, /* U+2b49 */
  0x0000, /* U+2b4a */
  0x0000, /* U+2b4b */
  0x0000, /* U+2b4c */
  0x0000, /* U+2b4d */
  0x0000, /* U+2b4e */
  0x0000, /* U+2b4f */
  0x0000, /* U+2b50 */
  0x0000, /* U+2b51 */
  0x0000, /* U+2b52 */
  0x0000, /* U+2b53 */
  0x0000, /* U+2b54 */
  0x0000, /* U+2b55 */
  0x0000, /* U+2b56 */
  0x0000, /* U+2b57 */
  0x0000, /* U+2b58 */
  0x0000, /* U+2b59 */
  0x0000, /* U+2b5a */
  0x0000, /* U+2b5b */
  0x0000, /* U+2b5c */
  0x0000, /* U+2b5d */
  0x0000, /* U+2b5e */
  0x0000, /* U+2b5f */
  0x0000, /* U+2b60 */
  0x0000, /* U+2b61 */
  0x0000, /* U+2b62 */
  0x0000, /* U+2b63 */
  0x0000, /* U+2b64 */
  0x0000, /* U+2b65 */
  0x0000, /* U+2b66 */
  0x0000, /* U+2b67 */
  0x0000, /* U+2b68 */
  0x0000, /* U+2b69 */
  0x0000, /* U+2b6a */
  0x0000, /* U+2b6b */
  0x0000, /* U+2b6c */
  0x0000, /* U+2b6d */
  0x0000, /* U+2b6e */
  0x0000, /* U+2b6f */
  0x0000, /* U+2b70 */
  0x0000, /* U+2b71 */
  0x0000, /* U+2b72 */
  0x0000, /* U+2b73 */
  0x0000, /* U+2b74 */
  0x0000, /* U+2b75 */
  0x0000, /* U+2b76 */
  0x0000, /* U+2b77 */
  0x0000, /* U+2b78 */
  0x0000, /* U+2b79 */
  0x0000, /* U+2b7a */
  0x0000, /* U+2b7b */
  0x0000, /* U+2b7c */
  0x0000, /* U+2b7d */
  0x0000, /* U+2b7e */
  0x0000, /* U+2b7f */
  0x0000, /* U+2b80 */
  0x0000, /* U+2b81 */
  0x0000, /* U+2b82 */
  0x0000, /* U+2b83 */
  0x0000, /* U+2b84 */
  0x0000, /* U+2b85 */
  0x0000, /* U+2b86 */
  0x0000, /* U+2b87 */
  0x0000, /* U+2b88 */
  0x0000, /* U+2b89 */
  0x0000, /* U+2b8a */
  0x0000, /* U+2b8b */
  0x0000, /* U+2b8c */
  0x0000, /* U+2b8d */
  0x0000, /* U+2b8e */
  0x0000, /* U+2b8f */
  0x0000, /* U+2b90 */
  0x0000, /* U+2b91 */
  0x0000, /* U+2b92 */
  0x0000, /* U+2b93 */
  0x0000, /* U+2b94 */
  0x0000, /* U+2b95 */
  0x0000, /* U+2b96 */
  0x0000, /* U+2b97 */
  0x0000, /* U+2b98 */
  0x0000, /* U+2b99 */
  0x0000, /* U+2b9a */
  0x0000, /* U+2b9b */
  0x0000, /* U+2b9c */
  0x0000, /* U+2b9d */
  0x0000, /* U+2b9e */
  0x0000, /* U+2b9f */
  0x0000, /* U+2ba0 */
  0x0000, /* U+2ba1 */
  0x0000, /* U+2ba2 */
  0x0000, /* U+2ba3 */
  0x0000, /* U+2ba4 */
  0x0000, /* U+2ba5 */
  0x0000, /* U+2ba6 */
  0x0000, /* U+2ba7 */
  0x0000, /* U+2ba8 */
  0x0000, /* U+2ba9 */
  0x0000, /* U+2baa */
  0x0000, /* U+2bab */
  0x0000, /* U+2bac */
  0x0000, /* U+2bad */
  0x0000, /* U+2bae */
  0x0000, /* U+2baf */
  0x0000, /* U+2bb0 */
  0x0000, /* U+2bb1 */
  0x0000, /* U+2bb2 */
  0x0000, /* U+2bb3 */
  0x0000, /* U+2bb4 */
  0x0000, /* U+2bb5 */
  0x0000, /* U+2bb6 */
  0x0000, /* U+2bb7 */
  0x0000, /* U+2bb8 */
  0x0000, /* U+2bb9 */
  0x0000, /* U+2bba */
  0x0000, /* U+2bbb */
  0x0000, /* U+2bbc */
  0x0000, /* U+2bbd */
  0x0000, /* U+2bbe */
  0x0000, /* U+2bbf */
  0x0000, /* U+2bc0 */
  0x0000, /* U+2bc1 */
  0x0000, /* U+2bc2 */
  0x0000, /* U+2bc3 */
  0x0000, /* U+2bc4 */
  0x0000, /* U+2bc5 */
  0x0000, /* U+2bc6 */
  0x0000, /* U+2bc7 */
  0x0000, /* U+2bc8 */
  0x0000, /* U+2bc9 */
  0x0000, /* U+2bca */
  0x0000, /* U+2bcb */
  0x0000, /* U+2bcc */
  0x0000, /* U+2bcd */
  0x0000, /* U+2bce */
  0x0000, /* U+2bcf */
  0x0000, /* U+2bd0 */
  0x0000, /* U+2bd1 */
  0x0000, /* U+2bd2 */
  0x0000, /* U+2bd3 */
  0x0000, /* U+2bd4 */
  0x0000, /* U+2bd5 */
  0x0000, /* U+2bd6 */
  0x0000, /* U+2bd7 */
  0x0000, /* U+2bd8 */
  0x0000, /* U+2bd9 */
  0x0000, /* U+2bda */
  0x0000, /* U+2bdb */
  0x0000, /* U+2bdc */
  0x0000, /* U+2bdd */
  0x0000, /* U+2bde */
  0x0000, /* U+2bdf */
  0x0000, /* U+2be0 */
  0x0000, /* U+2be1 */
  0x0000, /* U+2be2 */
  0x0000, /* U+2be3 */
  0x0000, /* U+2be4 */
  0x0000, /* U+2be5 */
  0x0000, /* U+2be6 */
  0x0000, /* U+2be7 */
  0x0000, /* U+2be8 */
  0x0000, /* U+2be9 */
  0x0000, /* U+2bea */
  0x0000, /* U+2beb */
  0x0000, /* U+2bec */
  0x0000, /* U+2bed */
  0x0000, /* U+2bee */
  0x0000, /* U+2bef */
  0x0000, /* U+2bf0 */
  0x0000, /* U+2bf1 */
  0x0000, /* U+2bf2 */
  0x0000, /* U+2bf3 */
  0x0000, /* U+2bf4 */
  0x0000, /* U+2bf5 */
  0x0000, /* U+2bf6 */
  0x0000, /* U+2bf7 */
  0x0000, /* U+2bf8 */
  0x0000, /* U+2bf9 */
  0x0000, /* U+2bfa */
  0x0000, /* U+2bfb */
  0x0000, /* U+2bfc */
  0x0000, /* U+2bfd */
  0x0000, /* U+2bfe */
  0x0000, /* U+2bff */
  0x0000, /* U+2c00 */
  0x0000, /* U+2c01 */
  0x0000, /* U+2c02 */
  0x0000, /* U+2c03 */
  0x0000, /* U+2c04 */
  0x0000, /* U+2c05 */
  0x0000, /* U+2c06 */
  0x0000, /* U+2c07 */
  0x0000, /* U+2c08 */
  0x0000, /* U+2c09 */
  0x0000, /* U+2c0a */
  0x0000, /* U+2c0b */
  0x0000, /* U+2c0c */
  0x0000, /* U+2c0d */
  0x0000, /* U+2c0e */
  0x0000, /* U+2c0f */
  0x0000, /* U+2c10 */
  0x0000, /* U+2c11 */
  0x0000, /* U+2c12 */
  0x0000, /* U+2c13 */
  0x0000, /* U+2c14 */
  0x0000, /* U+2c15 */
  0x0000, /* U+2c16 */
  0x0000, /* U+2c17 */
  0x0000, /* U+2c18 */
  0x0000, /* U+2c19 */
  0x0000, /* U+2c1a */
  0x0000, /* U+2c1b */
  0x0000, /* U+2c1c */
  0x0000, /* U+2c1d */
  0x0000, /* U+2c1e */
  0x0000, /* U+2c1f */
  0x0000, /* U+2c20 */
  0x0000, /* U+2c21 */
  0x0000, /* U+2c22 */
  0x0000, /* U+2c23 */
  0x0000, /* U+2c24 */
  0x0000, /* U+2c25 */
  0x0000, /* U+2c26 */
  0x0000, /* U+2c27 */
  0x0000, /* U+2c28 */
  0x0000, /* U+2c29 */
  0x0000, /* U+2c2a */
  0x0000, /* U+2c2b */
  0x0000, /* U+2c2c */
  0x0000, /* U+2c2d */
  0x0000, /* U+2c2e */
  0x0000, /* U+2c2f */
  0x0000, /* U+2c30 */
  0x0000, /* U+2c31 */
  0x0000, /* U+2c32 */
  0x0000, /* U+2c33 */
  0x0000, /* U+2c34 */
  0x0000, /* U+2c35 */
  0x0000, /* U+2c36 */
  0x0000, /* U+2c37 */
  0x0000, /* U+2c38 */
  0x0000, /* U+2c39 */
  0x0000, /* U+2c3a */
  0x0000, /* U+2c3b */
  0x0000, /* U+2c3c */
  0x0000, /* U+2c3d */
  0x0000, /* U+2c3e */
  0x0000, /* U+2c3f */
  0x0000, /* U+2c40 */
  0x0000, /* U+2c41 */
  0x0000, /* U+2c42 */
  0x0000, /* U+2c43 */
  0x0000, /* U+2c44 */
  0x0000, /* U+2c45 */
  0x0000, /* U+2c46 */
  0x0000, /* U+2c47 */
  0x0000, /* U+2c48 */
  0x0000, /* U+2c49 */
  0x0000, /* U+2c4a */
  0x0000, /* U+2c4b */
  0x0000, /* U+2c4c */
  0x0000, /* U+2c4d */
  0x0000, /* U+2c4e */
  0x0000, /* U+2c4f */
  0x0000, /* U+2c50 */
  0x0000, /* U+2c51 */
  0x0000, /* U+2c52 */
  0x0000, /* U+2c53 */
  0x0000, /* U+2c54 */
  0x0000, /* U+2c55 */
  0x0000, /* U+2c56 */
  0x0000, /* U+2c57 */
  0x0000, /* U+2c58 */
  0x0000, /* U+2c59 */
  0x0000, /* U+2c5a */
  0x0000, /* U+2c5b */
  0x0000, /* U+2c5c */
  0x0000, /* U+2c5d */
  0x0000, /* U+2c5e */
  0x0000, /* U+2c5f */
  0x0000, /* U+2c60 */
  0x0000, /* U+2c61 */
  0x0000, /* U+2c62 */
  0x0000, /* U+2c63 */
  0x0000, /* U+2c64 */
  0x0000, /* U+2c65 */
  0x0000, /* U+2c66 */
  0x0000, /* U+2c67 */
  0x0000, /* U+2c68 */
  0x0000, /* U+2c69 */
  0x0000, /* U+2c6a */
  0x0000, /* U+2c6b */
  0x0000, /* U+2c6c */
  0x0000, /* U+2c6d */
  0x0000, /* U+2c6e */
  0x0000, /* U+2c6f */
  0x0000, /* U+2c70 */
  0x0000, /* U+2c71 */
  0x0000, /* U+2c72 */
  0x0000, /* U+2c73 */
  0x0000, /* U+2c74 */
  0x0000, /* U+2c75 */
  0x0000, /* U+2c76 */
  0x0000, /* U+2c77 */
  0x0000, /* U+2c78 */
  0x0000, /* U+2c79 */
  0x0000, /* U+2c7a */
  0x0000, /* U+2c7b */
  0x0000, /* U+2c7c */
  0x0000, /* U+2c7d */
  0x0000, /* U+2c7e */
  0x0000, /* U+2c7f */
  0x0000, /* U+2c80 */
  0x0000, /* U+2c81 */
  0x0000, /* U+2c82 */
  0x0000, /* U+2c83 */
  0x0000, /* U+2c84 */
  0x0000, /* U+2c85 */
  0x0000, /* U+2c86 */
  0x0000, /* U+2c87 */
  0x0000, /* U+2c88 */
  0x0000, /* U+2c89 */
  0x0000, /* U+2c8a */
  0x0000, /* U+2c8b */
  0x0000, /* U+2c8c */
  0x0000, /* U+2c8d */
  0x0000, /* U+2c8e */
  0x0000, /* U+2c8f */
  0x0000, /* U+2c90 */
  0x0000, /* U+2c91 */
  0x0000, /* U+2c92 */
  0x0000, /* U+2c93 */
  0x0000, /* U+2c94 */
  0x0000, /* U+2c95 */
  0x0000, /* U+2c96 */
  0x0000, /* U+2c97 */
  0x0000, /* U+2c98 */
  0x0000, /* U+2c99 */
  0x0000, /* U+2c9a */
  0x0000, /* U+2c9b */
  0x0000, /* U+2c9c */
  0x0000, /* U+2c9d */
  0x0000, /* U+2c9e */
  0x0000, /* U+2c9f */
  0x0000, /* U+2ca0 */
  0x0000, /* U+2ca1 */
  0x0000, /* U+2ca2 */
  0x0000, /* U+2ca3 */
  0x0000, /* U+2ca4 */
  0x0000, /* U+2ca5 */
  0x0000, /* U+2ca6 */
  0x0000, /* U+2ca7 */
  0x0000, /* U+2ca8 */
  0x0000, /* U+2ca9 */
  0x0000, /* U+2caa */
  0x0000, /* U+2cab */
  0x0000, /* U+2cac */
  0x0000, /* U+2cad */
  0x0000, /* U+2cae */
  0x0000, /* U+2caf */
  0x0000, /* U+2cb0 */
  0x0000, /* U+2cb1 */
  0x0000, /* U+2cb2 */
  0x0000, /* U+2cb3 */
  0x0000, /* U+2cb4 */
  0x0000, /* U+2cb5 */
  0x0000, /* U+2cb6 */
  0x0000, /* U+2cb7 */
  0x0000, /* U+2cb8 */
  0x0000, /* U+2cb9 */
  0x0000, /* U+2cba */
  0x0000, /* U+2cbb */
  0x0000, /* U+2cbc */
  0x0000, /* U+2cbd */
  0x0000, /* U+2cbe */
  0x0000, /* U+2cbf */
  0x0000, /* U+2cc0 */
  0x0000, /* U+2cc1 */
  0x0000, /* U+2cc2 */
  0x0000, /* U+2cc3 */
  0x0000, /* U+2cc4 */
  0x0000, /* U+2cc5 */
  0x0000, /* U+2cc6 */
  0x0000, /* U+2cc7 */
  0x0000, /* U+2cc8 */
  0x0000, /* U+2cc9 */
  0x0000, /* U+2cca */
  0x0000, /* U+2ccb */
  0x0000, /* U+2ccc */
  0x0000, /* U+2ccd */
  0x0000, /* U+2cce */
  0x0000, /* U+2ccf */
  0x0000, /* U+2cd0 */
  0x0000, /* U+2cd1 */
  0x0000, /* U+2cd2 */
  0x0000, /* U+2cd3 */
  0x0000, /* U+2cd4 */
  0x0000, /* U+2cd5 */
  0x0000, /* U+2cd6 */
  0x0000, /* U+2cd7 */
  0x0000, /* U+2cd8 */
  0x0000, /* U+2cd9 */
  0x0000, /* U+2cda */
  0x0000, /* U+2cdb */
  0x0000, /* U+2cdc */
  0x0000, /* U+2cdd */
  0x0000, /* U+2cde */
  0x0000, /* U+2cdf */
  0x0000, /* U+2ce0 */
  0x0000, /* U+2ce1 */
  0x0000, /* U+2ce2 */
  0x0000, /* U+2ce3 */
  0x0000, /* U+2ce4 */
  0x0000, /* U+2ce5 */
  0x0000, /* U+2ce6 */
  0x0000, /* U+2ce7 */
  0x0000, /* U+2ce8 */
  0x0000, /* U+2ce9 */
  0x0000, /* U+2cea */
  0x0000, /* U+2ceb */
  0x0000, /* U+2cec */
  0x0000, /* U+2ced */
  0x0000, /* U+2cee */
  0x0000, /* U+2cef */
  0x0000, /* U+2cf0 */
  0x0000, /* U+2cf1 */
  0x0000, /* U+2cf2 */
  0x0000, /* U+2cf3 */
  0x0000, /* U+2cf4 */
  0x0000, /* U+2cf5 */
  0x0000, /* U+2cf6 */
  0x0000, /* U+2cf7 */
  0x0000, /* U+2cf8 */
  0x0000, /* U+2cf9 */
  0x0000, /* U+2cfa */
  0x0000, /* U+2cfb */
  0x0000, /* U+2cfc */
  0x0000, /* U+2cfd */
  0x0000, /* U+2cfe */
  0x0000, /* U+2cff */
  0x0000, /* U+2d00 */
  0x0000, /* U+2d01 */
  0x0000, /* U+2d02 */
  0x0000, /* U+2d03 */
  0x0000, /* U+2d04 */
  0x0000, /* U+2d05 */
  0x0000, /* U+2d06 */
  0x0000, /* U+2d07 */
  0x0000, /* U+2d08 */
  0x0000, /* U+2d09 */
  0x0000, /* U+2d0a */
  0x0000, /* U+2d0b */
  0x0000, /* U+2d0c */
  0x0000, /* U+2d0d */
  0x0000, /* U+2d0e */
  0x0000, /* U+2d0f */
  0x0000, /* U+2d10 */
  0x0000, /* U+2d11 */
  0x0000, /* U+2d12 */
  0x0000, /* U+2d13 */
  0x0000, /* U+2d14 */
  0x0000, /* U+2d15 */
  0x0000, /* U+2d16 */
  0x0000, /* U+2d17 */
  0x0000, /* U+2d18 */
  0x0000, /* U+2d19 */
  0x0000, /* U+2d1a */
  0x0000, /* U+2d1b */
  0x0000, /* U+2d1c */
  0x0000, /* U+2d1d */
  0x0000, /* U+2d1e */
  0x0000, /* U+2d1f */
  0x0000, /* U+2d20 */
  0x0000, /* U+2d21 */
  0x0000, /* U+2d22 */
  0x0000, /* U+2d23 */
  0x0000, /* U+2d24 */
  0x0000, /* U+2d25 */
  0x0000, /* U+2d26 */
  0x0000, /* U+2d27 */
  0x0000, /* U+2d28 */
  0x0000, /* U+2d29 */
  0x0000, /* U+2d2a */
  0x0000, /* U+2d2b */
  0x0000, /* U+2d2c */
  0x0000, /* U+2d2d */
  0x0000, /* U+2d2e */
  0x0000, /* U+2d2f */
  0x0000, /* U+2d30 */
  0x0000, /* U+2d31 */
  0x0000, /* U+2d32 */
  0x0000, /* U+2d33 */
  0x0000, /* U+2d34 */
  0x0000, /* U+2d35 */
  0x0000, /* U+2d36 */
  0x0000, /* U+2d37 */
  0x0000, /* U+2d38 */
  0x0000, /* U+2d39 */
  0x0000, /* U+2d3a */
  0x0000, /* U+2d3b */
  0x0000, /* U+2d3c */
  0x0000, /* U+2d3d */
  0x0000, /* U+2d3e */
  0x0000, /* U+2d3f */
  0x0000, /* U+2d40 */
  0x0000, /* U+2d41 */
  0x0000, /* U+2d42 */
  0x0000, /* U+2d43 */
  0x0000, /* U+2d44 */
  0x0000, /* U+2d45 */
  0x0000, /* U+2d46 */
  0x0000, /* U+2d47 */
  0x0000, /* U+2d48 */
  0x0000, /* U+2d49 */
  0x0000, /* U+2d4a */
  0x0000, /* U+2d4b */
  0x0000, /* U+2d4c */
  0x0000, /* U+2d4d */
  0x0000, /* U+2d4e */
  0x0000, /* U+2d4f */
  0x0000, /* U+2d50 */
  0x0000, /* U+2d51 */
  0x0000, /* U+2d52 */
  0x0000, /* U+2d53 */
  0x0000, /* U+2d54 */
  0x0000, /* U+2d55 */
  0x0000, /* U+2d56 */
  0x0000, /* U+2d57 */
  0x0000, /* U+2d58 */
  0x0000, /* U+2d59 */
  0x0000, /* U+2d5a */
  0x0000, /* U+2d5b */
  0x0000, /* U+2d5c */
  0x0000, /* U+2d5d */
  0x0000, /* U+2d5e */
  0x0000, /* U+2d5f */
  0x0000, /* U+2d60 */
  0x0000, /* U+2d61 */
  0x0000, /* U+2d62 */
  0x0000, /* U+2d63 */
  0x0000, /* U+2d64 */
  0x0000, /* U+2d65 */
  0x0000, /* U+2d66 */
  0x0000, /* U+2d67 */
  0x0000, /* U+2d68 */
  0x0000, /* U+2d69 */
  0x0000, /* U+2d6a */
  0x0000, /* U+2d6b */
  0x0000, /* U+2d6c */
  0x0000, /* U+2d6d */
  0x0000, /* U+2d6e */
  0x0000, /* U+2d6f */
  0x0000, /* U+2d70 */
  0x0000, /* U+2d71 */
  0x0000, /* U+2d72 */
  0x0000, /* U+2d73 */
  0x0000, /* U+2d74 */
  0x0000, /* U+2d75 */
  0x0000, /* U+2d76 */
  0x0000, /* U+2d77 */
  0x0000, /* U+2d78 */
  0x0000, /* U+2d79 */
  0x0000, /* U+2d7a */
  0x0000, /* U+2d7b */
  0x0000, /* U+2d7c */
  0x0000, /* U+2d7d */
  0x0000, /* U+2d7e */
  0x0000, /* U+2d7f */
  0x0000, /* U+2d80 */
  0x0000, /* U+2d81 */
  0x0000, /* U+2d82 */
  0x0000, /* U+2d83 */
  0x0000, /* U+2d84 */
  0x0000, /* U+2d85 */
  0x0000, /* U+2d86 */
  0x0000, /* U+2d87 */
  0x0000, /* U+2d88 */
  0x0000, /* U+2d89 */
  0x0000, /* U+2d8a */
  0x0000, /* U+2d8b */
  0x0000, /* U+2d8c */
  0x0000, /* U+2d8d */
  0x0000, /* U+2d8e */
  0x0000, /* U+2d8f */
  0x0000, /* U+2d90 */
  0x0000, /* U+2d91 */
  0x0000, /* U+2d92 */
  0x0000, /* U+2d93 */
  0x0000, /* U+2d94 */
  0x0000, /* U+2d95 */
  0x0000, /* U+2d96 */
  0x0000, /* U+2d97 */
  0x0000, /* U+2d98 */
  0x0000, /* U+2d99 */
  0x0000, /* U+2d9a */
  0x0000, /* U+2d9b */
  0x0000, /* U+2d9c */
  0x0000, /* U+2d9d */
  0x0000, /* U+2d9e */
  0x0000, /* U+2d9f */
  0x0000, /* U+2da0 */
  0x0000, /* U+2da1 */
  0x0000, /* U+2da2 */
  0x0000, /* U+2da3 */
  0x0000, /* U+2da4 */
  0x0000, /* U+2da5 */
  0x0000, /* U+2da6 */
  0x0000, /* U+2da7 */
  0x0000, /* U+2da8 */
  0x0000, /* U+2da9 */
  0x0000, /* U+2daa */
  0x0000, /* U+2dab */
  0x0000, /* U+2dac */
  0x0000, /* U+2dad */
  0x0000, /* U+2dae */
  0x0000, /* U+2daf */
  0x0000, /* U+2db0 */
  0x0000, /* U+2db1 */
  0x0000, /* U+2db2 */
  0x0000, /* U+2db3 */
  0x0000, /* U+2db4 */
  0x0000, /* U+2db5 */
  0x0000, /* U+2db6 */
  0x0000, /* U+2db7 */
  0x0000, /* U+2db8 */
  0x0000, /* U+2db9 */
  0x0000, /* U+2dba */
  0x0000, /* U+2dbb */
  0x0000, /* U+2dbc */
  0x0000, /* U+2dbd */
  0x0000, /* U+2dbe */
  0x0000, /* U+2dbf */
  0x0000, /* U+2dc0 */
  0x0000, /* U+2dc1 */
  0x0000, /* U+2dc2 */
  0x0000, /* U+2dc3 */
  0x0000, /* U+2dc4 */
  0x0000, /* U+2dc5 */
  0x0000, /* U+2dc6 */
  0x0000, /* U+2dc7 */
  0x0000, /* U+2dc8 */
  0x0000, /* U+2dc9 */
  0x0000, /* U+2dca */
  0x0000, /* U+2dcb */
  0x0000, /* U+2dcc */
  0x0000, /* U+2dcd */
  0x0000, /* U+2dce */
  0x0000, /* U+2dcf */
  0x0000, /* U+2dd0 */
  0x0000, /* U+2dd1 */
  0x0000, /* U+2dd2 */
  0x0000, /* U+2dd3 */
  0x0000, /* U+2dd4 */
  0x0000, /* U+2dd5 */
  0x0000, /* U+2dd6 */
  0x0000, /* U+2dd7 */
  0x0000, /* U+2dd8 */
  0x0000, /* U+2dd9 */
  0x0000, /* U+2dda */
  0x0000, /* U+2ddb */
  0x0000, /* U+2ddc */
  0x0000, /* U+2ddd */
  0x0000, /* U+2dde */
  0x0000, /* U+2ddf */
  0x0000, /* U+2de0 */
  0x0000, /* U+2de1 */
  0x0000, /* U+2de2 */
  0x0000, /* U+2de3 */
  0x0000, /* U+2de4 */
  0x0000, /* U+2de5 */
  0x0000, /* U+2de6 */
  0x0000, /* U+2de7 */
  0x0000, /* U+2de8 */
  0x0000, /* U+2de9 */
  0x0000, /* U+2dea */
  0x0000, /* U+2deb */
  0x0000, /* U+2dec */
  0x0000, /* U+2ded */
  0x0000, /* U+2dee */
  0x0000, /* U+2def */
  0x0000, /* U+2df0 */
  0x0000, /* U+2df1 */
  0x0000, /* U+2df2 */
  0x0000, /* U+2df3 */
  0x0000, /* U+2df4 */
  0x0000, /* U+2df5 */
  0x0000, /* U+2df6 */
  0x0000, /* U+2df7 */
  0x0000, /* U+2df8 */
  0x0000, /* U+2df9 */
  0x0000, /* U+2dfa */
  0x0000, /* U+2dfb */
  0x0000, /* U+2dfc */
  0x0000, /* U+2dfd */
  0x0000, /* U+2dfe */
  0x0000, /* U+2dff */
  0x0000, /* U+2e00 */
  0x0000, /* U+2e01 */
  0x0000, /* U+2e02 */
  0x0000, /* U+2e03 */
  0x0000, /* U+2e04 */
  0x0000, /* U+2e05 */
  0x0000, /* U+2e06 */
  0x0000, /* U+2e07 */
  0x0000, /* U+2e08 */
  0x0000, /* U+2e09 */
  0x0000, /* U+2e0a */
  0x0000, /* U+2e0b */
  0x0000, /* U+2e0c */
  0x0000, /* U+2e0d */
  0x0000, /* U+2e0e */
  0x0000, /* U+2e0f */
  0x0000, /* U+2e10 */
  0x0000, /* U+2e11 */
  0x0000, /* U+2e12 */
  0x0000, /* U+2e13 */
  0x0000, /* U+2e14 */
  0x0000, /* U+2e15 */
  0x0000, /* U+2e16 */
  0x0000, /* U+2e17 */
  0x0000, /* U+2e18 */
  0x0000, /* U+2e19 */
  0x0000, /* U+2e1a */
  0x0000, /* U+2e1b */
  0x0000, /* U+2e1c */
  0x0000, /* U+2e1d */
  0x0000, /* U+2e1e */
  0x0000, /* U+2e1f */
  0x0000, /* U+2e20 */
  0x0000, /* U+2e21 */
  0x0000, /* U+2e22 */
  0x0000, /* U+2e23 */
  0x0000, /* U+2e24 */
  0x0000, /* U+2e25 */
  0x0000, /* U+2e26 */
  0x0000, /* U+2e27 */
  0x0000, /* U+2e28 */
  0x0000, /* U+2e29 */
  0x0000, /* U+2e2a */
  0x0000, /* U+2e2b */
  0x0000, /* U+2e2c */
  0x0000, /* U+2e2d */
  0x0000, /* U+2e2e */
  0x0000, /* U+2e2f */
  0x0000, /* U+2e30 */
  0x0000, /* U+2e31 */
  0x0000, /* U+2e32 */
  0x0000, /* U+2e33 */
  0x0000, /* U+2e34 */
  0x0000, /* U+2e35 */
  0x0000, /* U+2e36 */
  0x0000, /* U+2e37 */
  0x0000, /* U+2e38 */
  0x0000, /* U+2e39 */
  0x0000, /* U+2e3a */
  0x0000, /* U+2e3b */
  0x0000, /* U+2e3c */
  0x0000, /* U+2e3d */
  0x0000, /* U+2e3e */
  0x0000, /* U+2e3f */
  0x0000, /* U+2e40 */
  0x0000, /* U+2e41 */
  0x0000, /* U+2e42 */
  0x0000, /* U+2e43 */
  0x0000, /* U+2e44 */
  0x0000, /* U+2e45 */
  0x0000, /* U+2e46 */
  0x0000, /* U+2e47 */
  0x0000, /* U+2e48 */
  0x0000, /* U+2e49 */
  0x0000, /* U+2e4a */
  0x0000, /* U+2e4b */
  0x0000, /* U+2e4c */
  0x0000, /* U+2e4d */
  0x0000, /* U+2e4e */
  0x0000, /* U+2e4f */
  0x0000, /* U+2e50 */
  0x0000, /* U+2e51 */
  0x0000, /* U+2e52 */
  0x0000, /* U+2e53 */
  0x0000, /* U+2e54 */
  0x0000, /* U+2e55 */
  0x0000, /* U+2e56 */
  0x0000, /* U+2e57 */
  0x0000, /* U+2e58 */
  0x0000, /* U+2e59 */
  0x0000, /* U+2e5a */
  0x0000, /* U+2e5b */
  0x0000, /* U+2e5c */
  0x0000, /* U+2e5d */
  0x0000, /* U+2e5e */
  0x0000, /* U+2e5f */
  0x0000, /* U+2e60 */
  0x0000, /* U+2e61 */
  0x0000, /* U+2e62 */
  0x0000, /* U+2e63 */
  0x0000, /* U+2e64 */
  0x0000, /* U+2e65 */
  0x0000, /* U+2e66 */
  0x0000, /* U+2e67 */
  0x0000, /* U+2e68 */
  0x0000, /* U+2e69 */
  0x0000, /* U+2e6a */
  0x0000, /* U+2e6b */
  0x0000, /* U+2e6c */
  0x0000, /* U+2e6d */
  0x0000, /* U+2e6e */
  0x0000, /* U+2e6f */
  0x0000, /* U+2e70 */
  0x0000, /* U+2e71 */
  0x0000, /* U+2e72 */
  0x0000, /* U+2e73 */
  0x0000, /* U+2e74 */
  0x0000, /* U+2e75 */
  0x0000, /* U+2e76 */
  0x0000, /* U+2e77 */
  0x0000, /* U+2e78 */
  0x0000, /* U+2e79 */
  0x0000, /* U+2e7a */
  0x0000, /* U+2e7b */
  0x0000, /* U+2e7c */
  0x0000, /* U+2e7d */
  0x0000, /* U+2e7e */
  0x0000, /* U+2e7f */
  0x0000, /* U+2e80 */
  0x0000, /* U+2e81 */
  0x0000, /* U+2e82 */
  0x0000, /* U+2e83 */
  0x0000, /* U+2e84 */
  0x0000, /* U+2e85 */
  0x0000, /* U+2e86 */
  0x0000, /* U+2e87 */
  0x0000, /* U+2e88 */
  0x0000, /* U+2e89 */
  0x0000, /* U+2e8a */
  0x0000, /* U+2e8b */
  0x0000, /* U+2e8c */
  0x0000, /* U+2e8d */
  0x0000, /* U+2e8e */
  0x0000, /* U+2e8f */
  0x0000, /* U+2e90 */
  0x0000, /* U+2e91 */
  0x0000, /* U+2e92 */
  0x0000, /* U+2e93 */
  0x0000, /* U+2e94 */
  0x0000, /* U+2e95 */
  0x0000, /* U+2e96 */
  0x0000, /* U+2e97 */
  0x0000, /* U+2e98 */
  0x0000, /* U+2e99 */
  0x0000, /* U+2e9a */
  0x0000, /* U+2e9b */
  0x0000, /* U+2e9c */
  0x0000, /* U+2e9d */
  0x0000, /* U+2e9e */
  0x0000, /* U+2e9f */
  0x0000, /* U+2ea0 */
  0x0000, /* U+2ea1 */
  0x0000, /* U+2ea2 */
  0x0000, /* U+2ea3 */
  0x0000, /* U+2ea4 */
  0x0000, /* U+2ea5 */
  0x0000, /* U+2ea6 */
  0x0000, /* U+2ea7 */
  0x0000, /* U+2ea8 */
  0x0000, /* U+2ea9 */
  0x0000, /* U+2eaa */
  0x0000, /* U+2eab */
  0x0000, /* U+2eac */
  0x0000, /* U+2ead */
  0x0000, /* U+2eae */
  0x0000, /* U+2eaf */
  0x0000, /* U+2eb0 */
  0x0000, /* U+2eb1 */
  0x0000, /* U+2eb2 */
  0x0000, /* U+2eb3 */
  0x0000, /* U+2eb4 */
  0x0000, /* U+2eb5 */
  0x0000, /* U+2eb6 */
  0x0000, /* U+2eb7 */
  0x0000, /* U+2eb8 */
  0x0000, /* U+2eb9 */
  0x0000, /* U+2eba */
  0x0000, /* U+2ebb */
  0x0000, /* U+2ebc */
  0x0000, /* U+2ebd */
  0x0000, /* U+2ebe */
  0x0000, /* U+2ebf */
  0x0000, /* U+2ec0 */
  0x0000, /* U+2ec1 */
  0x0000, /* U+2ec2 */
  0x0000, /* U+2ec3 */
  0x0000, /* U+2ec4 */
  0x0000, /* U+2ec5 */
  0x0000, /* U+2ec6 */
  0x0000, /* U+2ec7 */
  0x0000, /* U+2ec8 */
  0x0000, /* U+2ec9 */
  0x0000, /* U+2eca */
  0x0000, /* U+2ecb */
  0x0000, /* U+2ecc */
  0x0000, /* U+2ecd */
  0x0000, /* U+2ece */
  0x0000, /* U+2ecf */
  0x0000, /* U+2ed0 */
  0x0000, /* U+2ed1 */
  0x0000, /* U+2ed2 */
  0x0000, /* U+2ed3 */
  0x0000, /* U+2ed4 */
  0x0000, /* U+2ed5 */
  0x0000, /* U+2ed6 */
  0x0000, /* U+2ed7 */
  0x0000, /* U+2ed8 */
  0x0000, /* U+2ed9 */
  0x0000, /* U+2eda */
  0x0000, /* U+2edb */
  0x0000, /* U+2edc */
  0x0000, /* U+2edd */
  0x0000, /* U+2ede */
  0x0000, /* U+2edf */
  0x0000, /* U+2ee0 */
  0x0000, /* U+2ee1 */
  0x0000, /* U+2ee2 */
  0x0000, /* U+2ee3 */
  0x0000, /* U+2ee4 */
  0x0000, /* U+2ee5 */
  0x0000, /* U+2ee6 */
  0x0000, /* U+2ee7 */
  0x0000, /* U+2ee8 */
  0x0000, /* U+2ee9 */
  0x0000, /* U+2eea */
  0x0000, /* U+2eeb */
  0x0000, /* U+2eec */
  0x0000, /* U+2eed */
  0x0000, /* U+2eee */
  0x0000, /* U+2eef */
  0x0000, /* U+2ef0 */
  0x0000, /* U+2ef1 */
  0x0000, /* U+2ef2 */
  0x0000, /* U+2ef3 */
  0x0000, /* U+2ef4 */
  0x0000, /* U+2ef5 */
  0x0000, /* U+2ef6 */
  0x0000, /* U+2ef7 */
  0x0000, /* U+2ef8 */
  0x0000, /* U+2ef9 */
  0x0000, /* U+2efa */
  0x0000, /* U+2efb */
  0x0000, /* U+2efc */
  0x0000, /* U+2efd */
  0x0000, /* U+2efe */
  0x0000, /* U+2eff */
  0x0000, /* U+2f00 */
  0x0000, /* U+2f01 */
  0x0000, /* U+2f02 */
  0x0000, /* U+2f03 */
  0x0000, /* U+2f04 */
  0x0000, /* U+2f05 */
  0x0000, /* U+2f06 */
  0x0000, /* U+2f07 */
  0x0000, /* U+2f08 */
  0x0000, /* U+2f09 */
  0x0000, /* U+2f0a */
  0x0000, /* U+2f0b */
  0x0000, /* U+2f0c */
  0x0000, /* U+2f0d */
  0x0000, /* U+2f0e */
  0x0000, /* U+2f0f */
  0x0000, /* U+2f10 */
  0x0000, /* U+2f11 */
  0x0000, /* U+2f12 */
  0x0000, /* U+2f13 */
  0x0000, /* U+2f14 */
  0x0000, /* U+2f15 */
  0x0000, /* U+2f16 */
  0x0000, /* U+2f17 */
  0x0000, /* U+2f18 */
  0x0000, /* U+2f19 */
  0x0000, /* U+2f1a */
  0x0000, /* U+2f1b */
  0x0000, /* U+2f1c */
  0x0000, /* U+2f1d */
  0x0000, /* U+2f1e */
  0x0000, /* U+2f1f */
  0x0000, /* U+2f20 */
  0x0000, /* U+2f21 */
  0x0000, /* U+2f22 */
  0x0000, /* U+2f23 */
  0x0000, /* U+2f24 */
  0x0000, /* U+2f25 */
  0x0000, /* U+2f26 */
  0x0000, /* U+2f27 */
  0x0000, /* U+2f28 */
  0x0000, /* U+2f29 */
  0x0000, /* U+2f2a */
  0x0000, /* U+2f2b */
  0x0000, /* U+2f2c */
  0x0000, /* U+2f2d */
  0x0000, /* U+2f2e */
  0x0000, /* U+2f2f */
  0x0000, /* U+2f30 */
  0x0000, /* U+2f31 */
  0x0000, /* U+2f32 */
  0x0000, /* U+2f33 */
  0x0000, /* U+2f34 */
  0x0000, /* U+2f35 */
  0x0000, /* U+2f36 */
  0x0000, /* U+2f37 */
  0x0000, /* U+2f38 */
  0x0000, /* U+2f39 */
  0x0000, /* U+2f3a */
  0x0000, /* U+2f3b */
  0x0000, /* U+2f3c */
  0x0000, /* U+2f3d */
  0x0000, /* U+2f3e */
  0x0000, /* U+2f3f */
  0x0000, /* U+2f40 */
  0x0000, /* U+2f41 */
  0x0000, /* U+2f42 */
  0x0000, /* U+2f43 */
  0x0000, /* U+2f44 */
  0x0000, /* U+2f45 */
  0x0000, /* U+2f46 */
  0x0000, /* U+2f47 */
  0x0000, /* U+2f48 */
  0x0000, /* U+2f49 */
  0x0000, /* U+2f4a */
  0x0000, /* U+2f4b */
  0x0000, /* U+2f4c */
  0x0000, /* U+2f4d */
  0x0000, /* U+2f4e */
  0x0000, /* U+2f4f */
  0x0000, /* U+2f50 */
  0x0000, /* U+2f51 */
  0x0000, /* U+2f52 */
  0x0000, /* U+2f53 */
  0x0000, /* U+2f54 */
  0x0000, /* U+2f55 */
  0x0000, /* U+2f56 */
  0x0000, /* U+2f57 */
  0x0000, /* U+2f58 */
  0x0000, /* U+2f59 */
  0x0000, /* U+2f5a */
  0x0000, /* U+2f5b */
  0x0000, /* U+2f5c */
  0x0000, /* U+2f5d */
  0x0000, /* U+2f5e */
  0x0000, /* U+2f5f */
  0x0000, /* U+2f60 */
  0x0000, /* U+2f61 */
  0x0000, /* U+2f62 */
  0x0000, /* U+2f63 */
  0x0000, /* U+2f64 */
  0x0000, /* U+2f65 */
  0x0000, /* U+2f66 */
  0x0000, /* U+2f67 */
  0x0000, /* U+2f68 */
  0x0000, /* U+2f69 */
  0x0000, /* U+2f6a */
  0x0000, /* U+2f6b */
  0x0000, /* U+2f6c */
  0x0000, /* U+2f6d */
  0x0000, /* U+2f6e */
  0x0000, /* U+2f6f */
  0x0000, /* U+2f70 */
  0x0000, /* U+2f71 */
  0x0000, /* U+2f72 */
  0x0000, /* U+2f73 */
  0x0000, /* U+2f74 */
  0x0000, /* U+2f75 */
  0x0000, /* U+2f76 */
  0x0000, /* U+2f77 */
  0x0000, /* U+2f78 */
  0x0000, /* U+2f79 */
  0x0000, /* U+2f7a */
  0x0000, /* U+2f7b */
  0x0000, /* U+2f7c */
  0x0000, /* U+2f7d */
  0x0000, /* U+2f7e */
  0x0000, /* U+2f7f */
  0x0000, /* U+2f80 */
  0x0000, /* U+2f81 */
  0x0000, /* U+2f82 */
  0x0000, /* U+2f83 */
  0x0000, /* U+2f84 */
  0x0000, /* U+2f85 */
  0x0000, /* U+2f86 */
  0x0000, /* U+2f87 */
  0x0000, /* U+2f88 */
  0x0000, /* U+2f89 */
  0x0000, /* U+2f8a */
  0x0000, /* U+2f8b */
  0x0000, /* U+2f8c */
  0x0000, /* U+2f8d */
  0x0000, /* U+2f8e */
  0x0000, /* U+2f8f */
  0x0000, /* U+2f90 */
  0x0000, /* U+2f91 */
  0x0000, /* U+2f92 */
  0x0000, /* U+2f93 */
  0x0000, /* U+2f94 */
  0x0000, /* U+2f95 */
  0x0000, /* U+2f96 */
  0x0000, /* U+2f97 */
  0x0000, /* U+2f98 */
  0x0000, /* U+2f99 */
  0x0000, /* U+2f9a */
  0x0000, /* U+2f9b */
  0x0000, /* U+2f9c */
  0x0000, /* U+2f9d */
  0x0000, /* U+2f9e */
  0x0000, /* U+2f9f */
  0x0000, /* U+2fa0 */
  0x0000, /* U+2fa1 */
  0x0000, /* U+2fa2 */
  0x0000, /* U+2fa3 */
  0x0000, /* U+2fa4 */
  0x0000, /* U+2fa5 */
  0x0000, /* U+2fa6 */
  0x0000, /* U+2fa7 */
  0x0000, /* U+2fa8 */
  0x0000, /* U+2fa9 */
  0x0000, /* U+2faa */
  0x0000, /* U+2fab */
  0x0000, /* U+2fac */
  0x0000, /* U+2fad */
  0x0000, /* U+2fae */
  0x0000, /* U+2faf */
  0x0000, /* U+2fb0 */
  0x0000, /* U+2fb1 */
  0x0000, /* U+2fb2 */
  0x0000, /* U+2fb3 */
  0x0000, /* U+2fb4 */
  0x0000, /* U+2fb5 */
  0x0000, /* U+2fb6 */
  0x0000, /* U+2fb7 */
  0x0000, /* U+2fb8 */
  0x0000, /* U+2fb9 */
  0x0000, /* U+2fba */
  0x0000, /* U+2fbb */
  0x0000, /* U+2fbc */
  0x0000, /* U+2fbd */
  0x0000, /* U+2fbe */
  0x0000, /* U+2fbf */
  0x0000, /* U+2fc0 */
  0x0000, /* U+2fc1 */
  0x0000, /* U+2fc2 */
  0x0000, /* U+2fc3 */
  0x0000, /* U+2fc4 */
  0x0000, /* U+2fc5 */
  0x0000, /* U+2fc6 */
  0x0000, /* U+2fc7 */
  0x0000, /* U+2fc8 */
  0x0000, /* U+2fc9 */
  0x0000, /* U+2fca */
  0x0000, /* U+2fcb */
  0x0000, /* U+2fcc */
  0x0000, /* U+2fcd */
  0x0000, /* U+2fce */
  0x0000, /* U+2fcf */
  0x0000, /* U+2fd0 */
  0x0000, /* U+2fd1 */
  0x0000, /* U+2fd2 */
  0x0000, /* U+2fd3 */
  0x0000, /* U+2fd4 */
  0x0000, /* U+2fd5 */
  0x0000, /* U+2fd6 */
  0x0000, /* U+2fd7 */
  0x0000, /* U+2fd8 */
  0x0000, /* U+2fd9 */
  0x0000, /* U+2fda */
  0x0000, /* U+2fdb */
  0x0000, /* U+2fdc */
  0x0000, /* U+2fdd */
  0x0000, /* U+2fde */
  0x0000, /* U+2fdf */
  0x0000, /* U+2fe0 */
  0x0000, /* U+2fe1 */
  0x0000, /* U+2fe2 */
  0x0000, /* U+2fe3 */
  0x0000, /* U+2fe4 */
  0x0000, /* U+2fe5 */
  0x0000, /* U+2fe6 */
  0x0000, /* U+2fe7 */
  0x0000, /* U+2fe8 */
  0x0000, /* U+2fe9 */
  0x0000, /* U+2fea */
  0x0000, /* U+2feb */
  0x0000, /* U+2fec */
  0x0000, /* U+2fed */
  0x0000, /* U+2fee */
  0x0000, /* U+2fef */
  0x0000, /* U+2ff0 */
  0x0000, /* U+2ff1 */
  0x0000, /* U+2ff2 */
  0x0000, /* U+2ff3 */
  0x0000, /* U+2ff4 */
  0x0000, /* U+2ff5 */
  0x0000, /* U+2ff6 */
  0x0000, /* U+2ff7 */
  0x0000, /* U+2ff8 */
  0x0000, /* U+2ff9 */
  0x0000, /* U+2ffa */
  0x0000, /* U+2ffb */
  0x0000, /* U+2ffc */
  0x0000, /* U+2ffd */
  0x0000, /* U+2ffe */
  0x0000, /* U+2fff */
  0x8140, /* U+3000 */
  0x8141, /* U+3001 */
  0x8142, /* U+3002 */
  0x8156, /* U+3003 */
  0x0000, /* U+3004 */
  0x8158, /* U+3005 */
  0x8159, /* U+3006 */
  0x815a, /* U+3007 */
  0x8171, /* U+3008 */
  0x8172, /* U+3009 */
  0x8173, /* U+300a */
  0x8174, /* U+300b */
  0x8175, /* U+300c */
  0x8176, /* U+300d */
  0x8177, /* U+300e */
  0x8178, /* U+300f */
  0x8179, /* U+3010 */
  0x817a, /* U+3011 */
  0x81a7, /* U+3012 */
  0x81ac, /* U+3013 */
  0x816b, /* U+3014 */
  0x816c, /* U+3015 */
  0x0000, /* U+3016 */
  0x0000, /* U+3017 */
  0x0000, /* U+3018 */
  0x0000, /* U+3019 */
  0x0000, /* U+301a */
  0x0000, /* U+301b */
  0x0000, /* U+301c */
  0x8780, /* U+301d */
  0x0000, /* U+301e */
  0x8781, /* U+301f */
  0x0000, /* U+3020 */
  0x0000, /* U+3021 */
  0x0000, /* U+3022 */
  0x0000, /* U+3023 */
  0x0000, /* U+3024 */
  0x0000, /* U+3025 */
  0x0000, /* U+3026 */
  0x0000, /* U+3027 */
  0x0000, /* U+3028 */
  0x0000, /* U+3029 */
  0x0000, /* U+302a */
  0x0000, /* U+302b */
  0x0000, /* U+302c */
  0x0000, /* U+302d */
  0x0000, /* U+302e */
  0x0000, /* U+302f */
  0x0000, /* U+3030 */
  0x0000, /* U+3031 */
  0x0000, /* U+3032 */
  0x0000, /* U+3033 */
  0x0000, /* U+3034 */
  0x0000, /* U+3035 */
  0x0000, /* U+3036 */
  0x0000, /* U+3037 */
  0x0000, /* U+3038 */
  0x0000, /* U+3039 */
  0x0000, /* U+303a */
  0x0000, /* U+303b */
  0x0000, /* U+303c */
  0x0000, /* U+303d */
  0x0000, /* U+303e */
  0x0000, /* U+303f */
  0x0000, /* U+3040 */
  0x829f, /* U+3041 */
  0x82a0, /* U+3042 */
  0x82a1, /* U+3043 */
  0x82a2, /* U+3044 */
  0x82a3, /* U+3045 */
  0x82a4, /* U+3046 */
  0x82a5, /* U+3047 */
  0x82a6, /* U+3048 */
  0x82a7, /* U+3049 */
  0x82a8, /* U+304a */
  0x82a9, /* U+304b */
  0x82aa, /* U+304c */
  0x82ab, /* U+304d */
  0x82ac, /* U+304e */
  0x82ad, /* U+304f */
  0x82ae, /* U+3050 */
  0x82af, /* U+3051 */
  0x82b0, /* U+3052 */
  0x82b1, /* U+3053 */
  0x82b2, /* U+3054 */
  0x82b3, /* U+3055 */
  0x82b4, /* U+3056 */
  0x82b5, /* U+3057 */
  0x82b6, /* U+3058 */
  0x82b7, /* U+3059 */
  0x82b8, /* U+305a */
  0x82b9, /* U+305b */
  0x82ba, /* U+305c */
  0x82bb, /* U+305d */
  0x82bc, /* U+305e */
  0x82bd, /* U+305f */
  0x82be, /* U+3060 */
  0x82bf, /* U+3061 */
  0x82c0, /* U+3062 */
  0x82c1, /* U+3063 */
  0x82c2, /* U+3064 */
  0x82c3, /* U+3065 */
  0x82c4, /* U+3066 */
  0x82c5, /* U+3067 */
  0x82c6, /* U+3068 */
  0x82c7, /* U+3069 */
  0x82c8, /* U+306a */
  0x82c9, /* U+306b */
  0x82ca, /* U+306c */
  0x82cb, /* U+306d */
  0x82cc, /* U+306e */
  0x82cd, /* U+306f */
  0x82ce, /* U+3070 */
  0x82cf, /* U+3071 */
  0x82d0, /* U+3072 */
  0x82d1, /* U+3073 */
  0x82d2, /* U+3074 */
  0x82d3, /* U+3075 */
  0x82d4, /* U+3076 */
  0x82d5, /* U+3077 */
  0x82d6, /* U+3078 */
  0x82d7, /* U+3079 */
  0x82d8, /* U+307a */
  0x82d9, /* U+307b */
  0x82da, /* U+307c */
  0x82db, /* U+307d */
  0x82dc, /* U+307e */
  0x82dd, /* U+307f */
  0x82de, /* U+3080 */
  0x82df, /* U+3081 */
  0x82e0, /* U+3082 */
  0x82e1, /* U+3083 */
  0x82e2, /* U+3084 */
  0x82e3, /* U+3085 */
  0x82e4, /* U+3086 */
  0x82e5, /* U+3087 */
  0x82e6, /* U+3088 */
  0x82e7, /* U+3089 */
  0x82e8, /* U+308a */
  0x82e9, /* U+308b */
  0x82ea, /* U+308c */
  0x82eb, /* U+308d */
  0x82ec, /* U+308e */
  0x82ed, /* U+308f */
  0x82ee, /* U+3090 */
  0x82ef, /* U+3091 */
  0x82f0, /* U+3092 */
  0x82f1, /* U+3093 */
  0x0000, /* U+3094 */
  0x0000, /* U+3095 */
  0x0000, /* U+3096 */
  0x0000, /* U+3097 */
  0x0000, /* U+3098 */
  0x0000, /* U+3099 */
  0x0000, /* U+309a */
  0x814a, /* U+309b */
  0x814b, /* U+309c */
  0x8154, /* U+309d */
  0x8155, /* U+309e */
  0x0000, /* U+309f */
  0x0000, /* U+30a0 */
  0x8340, /* U+30a1 */
  0x8341, /* U+30a2 */
  0x8342, /* U+30a3 */
  0x8343, /* U+30a4 */
  0x8344, /* U+30a5 */
  0x8345, /* U+30a6 */
  0x8346, /* U+30a7 */
  0x8347, /* U+30a8 */
  0x8348, /* U+30a9 */
  0x8349, /* U+30aa */
  0x834a, /* U+30ab */
  0x834b, /* U+30ac */
  0x834c, /* U+30ad */
  0x834d, /* U+30ae */
  0x834e, /* U+30af */
  0x834f, /* U+30b0 */
  0x8350, /* U+30b1 */
  0x8351, /* U+30b2 */
  0x8352, /* U+30b3 */
  0x8353, /* U+30b4 */
  0x8354, /* U+30b5 */
  0x8355, /* U+30b6 */
  0x8356, /* U+30b7 */
  0x8357, /* U+30b8 */
  0x8358, /* U+30b9 */
  0x8359, /* U+30ba */
  0x835a, /* U+30bb */
  0x835b, /* U+30bc */
  0x835c, /* U+30bd */
  0x835d, /* U+30be */
  0x835e, /* U+30bf */
  0x835f, /* U+30c0 */
  0x8360, /* U+30c1 */
  0x8361, /* U+30c2 */
  0x8362, /* U+30c3 */
  0x8363, /* U+30c4 */
  0x8364, /* U+30c5 */
  0x8365, /* U+30c6 */
  0x8366, /* U+30c7 */
  0x8367, /* U+30c8 */
  0x8368, /* U+30c9 */
  0x8369, /* U+30ca */
  0x836a, /* U+30cb */
  0x836b, /* U+30cc */
  0x836c, /* U+30cd */
  0x836d, /* U+30ce */
  0x836e, /* U+30cf */
  0x836f, /* U+30d0 */
  0x8370, /* U+30d1 */
  0x8371, /* U+30d2 */
  0x8372, /* U+30d3 */
  0x8373, /* U+30d4 */
  0x8374, /* U+30d5 */
  0x8375, /* U+30d6 */
  0x8376, /* U+30d7 */
  0x8377, /* U+30d8 */
  0x8378, /* U+30d9 */
  0x8379, /* U+30da */
  0x837a, /* U+30db */
  0x837b, /* U+30dc */
  0x837c, /* U+30dd */
  0x837d, /* U+30de */
  0x837e, /* U+30df */
  0x8380, /* U+30e0 */
  0x8381, /* U+30e1 */
  0x8382, /* U+30e2 */
  0x8383, /* U+30e3 */
  0x8384, /* U+30e4 */
  0x8385, /* U+30e5 */
  0x8386, /* U+30e6 */
  0x8387, /* U+30e7 */
  0x8388, /* U+30e8 */
  0x8389, /* U+30e9 */
  0x838a, /* U+30ea */
  0x838b, /* U+30eb */
  0x838c, /* U+30ec */
  0x838d, /* U+30ed */
  0x838e, /* U+30ee */
  0x838f, /* U+30ef */
  0x8390, /* U+30f0 */
  0x8391, /* U+30f1 */
  0x8392, /* U+30f2 */
  0x8393, /* U+30f3 */
  0x8394, /* U+30f4 */
  0x8395, /* U+30f5 */
  0x8396, /* U+30f6 */
  0x0000, /* U+30f7 */
  0x0000, /* U+30f8 */
  0x0000, /* U+30f9 */
  0x0000, /* U+30fa */
  0x8145, /* U+30fb */
  0x815b, /* U+30fc */
  0x8152, /* U+30fd */
  0x8153, /* U+30fe */
  0x0000, /* U+30ff */
  0x0000, /* U+3100 */
  0x0000, /* U+3101 */
  0x0000, /* U+3102 */
  0x0000, /* U+3103 */
  0x0000, /* U+3104 */
  0x0000, /* U+3105 */
  0x0000, /* U+3106 */
  0x0000, /* U+3107 */
  0x0000, /* U+3108 */
  0x0000, /* U+3109 */
  0x0000, /* U+310a */
  0x0000, /* U+310b */
  0x0000, /* U+310c */
  0x0000, /* U+310d */
  0x0000, /* U+310e */
  0x0000, /* U+310f */
  0x0000, /* U+3110 */
  0x0000, /* U+3111 */
  0x0000, /* U+3112 */
  0x0000, /* U+3113 */
  0x0000, /* U+3114 */
  0x0000, /* U+3115 */
  0x0000, /* U+3116 */
  0x0000, /* U+3117 */
  0x0000, /* U+3118 */
  0x0000, /* U+3119 */
  0x0000, /* U+311a */
  0x0000, /* U+311b */
  0x0000, /* U+311c */
  0x0000, /* U+311d */
  0x0000, /* U+311e */
  0x0000, /* U+311f */
  0x0000, /* U+3120 */
  0x0000, /* U+3121 */
  0x0000, /* U+3122 */
  0x0000, /* U+3123 */
  0x0000, /* U+3124 */
  0x0000, /* U+3125 */
  0x0000, /* U+3126 */
  0x0000, /* U+3127 */
  0x0000, /* U+3128 */
  0x0000, /* U+3129 */
  0x0000, /* U+312a */
  0x0000, /* U+312b */
  0x0000, /* U+312c */
  0x0000, /* U+312d */
  0x0000, /* U+312e */
  0x0000, /* U+312f */
  0x0000, /* U+3130 */
  0x0000, /* U+3131 */
  0x0000, /* U+3132 */
  0x0000, /* U+3133 */
  0x0000, /* U+3134 */
  0x0000, /* U+3135 */
  0x0000, /* U+3136 */
  0x0000, /* U+3137 */
  0x0000, /* U+3138 */
  0x0000, /* U+3139 */
  0x0000, /* U+313a */
  0x0000, /* U+313b */
  0x0000, /* U+313c */
  0x0000, /* U+313d */
  0x0000, /* U+313e */
  0x0000, /* U+313f */
  0x0000, /* U+3140 */
  0x0000, /* U+3141 */
  0x0000, /* U+3142 */
  0x0000, /* U+3143 */
  0x0000, /* U+3144 */
  0x0000, /* U+3145 */
  0x0000, /* U+3146 */
  0x0000, /* U+3147 */
  0x0000, /* U+3148 */
  0x0000, /* U+3149 */
  0x0000, /* U+314a */
  0x0000, /* U+314b */
  0x0000, /* U+314c */
  0x0000, /* U+314d */
  0x0000, /* U+314e */
  0x0000, /* U+314f */
  0x0000, /* U+3150 */
  0x0000, /* U+3151 */
  0x0000, /* U+3152 */
  0x0000, /* U+3153 */
  0x0000, /* U+3154 */
  0x0000, /* U+3155 */
  0x0000, /* U+3156 */
  0x0000, /* U+3157 */
  0x0000, /* U+3158 */
  0x0000, /* U+3159 */
  0x0000, /* U+315a */
  0x0000, /* U+315b */
  0x0000, /* U+315c */
  0x0000, /* U+315d */
  0x0000, /* U+315e */
  0x0000, /* U+315f */
  0x0000, /* U+3160 */
  0x0000, /* U+3161 */
  0x0000, /* U+3162 */
  0x0000, /* U+3163 */
  0x0000, /* U+3164 */
  0x0000, /* U+3165 */
  0x0000, /* U+3166 */
  0x0000, /* U+3167 */
  0x0000, /* U+3168 */
  0x0000, /* U+3169 */
  0x0000, /* U+316a */
  0x0000, /* U+316b */
  0x0000, /* U+316c */
  0x0000, /* U+316d */
  0x0000, /* U+316e */
  0x0000, /* U+316f */
  0x0000, /* U+3170 */
  0x0000, /* U+3171 */
  0x0000, /* U+3172 */
  0x0000, /* U+3173 */
  0x0000, /* U+3174 */
  0x0000, /* U+3175 */
  0x0000, /* U+3176 */
  0x0000, /* U+3177 */
  0x0000, /* U+3178 */
  0x0000, /* U+3179 */
  0x0000, /* U+317a */
  0x0000, /* U+317b */
  0x0000, /* U+317c */
  0x0000, /* U+317d */
  0x0000, /* U+317e */
  0x0000, /* U+317f */
  0x0000, /* U+3180 */
  0x0000, /* U+3181 */
  0x0000, /* U+3182 */
  0x0000, /* U+3183 */
  0x0000, /* U+3184 */
  0x0000, /* U+3185 */
  0x0000, /* U+3186 */
  0x0000, /* U+3187 */
  0x0000, /* U+3188 */
  0x0000, /* U+3189 */
  0x0000, /* U+318a */
  0x0000, /* U+318b */
  0x0000, /* U+318c */
  0x0000, /* U+318d */
  0x0000, /* U+318e */
  0x0000, /* U+318f */
  0x0000, /* U+3190 */
  0x0000, /* U+3191 */
  0x0000, /* U+3192 */
  0x0000, /* U+3193 */
  0x0000, /* U+3194 */
  0x0000, /* U+3195 */
  0x0000, /* U+3196 */
  0x0000, /* U+3197 */
  0x0000, /* U+3198 */
  0x0000, /* U+3199 */
  0x0000, /* U+319a */
  0x0000, /* U+319b */
  0x0000, /* U+319c */
  0x0000, /* U+319d */
  0x0000, /* U+319e */
  0x0000, /* U+319f */
  0x0000, /* U+31a0 */
  0x0000, /* U+31a1 */
  0x0000, /* U+31a2 */
  0x0000, /* U+31a3 */
  0x0000, /* U+31a4 */
  0x0000, /* U+31a5 */
  0x0000, /* U+31a6 */
  0x0000, /* U+31a7 */
  0x0000, /* U+31a8 */
  0x0000, /* U+31a9 */
  0x0000, /* U+31aa */
  0x0000, /* U+31ab */
  0x0000, /* U+31ac */
  0x0000, /* U+31ad */
  0x0000, /* U+31ae */
  0x0000, /* U+31af */
  0x0000, /* U+31b0 */
  0x0000, /* U+31b1 */
  0x0000, /* U+31b2 */
  0x0000, /* U+31b3 */
  0x0000, /* U+31b4 */
  0x0000, /* U+31b5 */
  0x0000, /* U+31b6 */
  0x0000, /* U+31b7 */
  0x0000, /* U+31b8 */
  0x0000, /* U+31b9 */
  0x0000, /* U+31ba */
  0x0000, /* U+31bb */
  0x0000, /* U+31bc */
  0x0000, /* U+31bd */
  0x0000, /* U+31be */
  0x0000, /* U+31bf */
  0x0000, /* U+31c0 */
  0x0000, /* U+31c1 */
  0x0000, /* U+31c2 */
  0x0000, /* U+31c3 */
  0x0000, /* U+31c4 */
  0x0000, /* U+31c5 */
  0x0000, /* U+31c6 */
  0x0000, /* U+31c7 */
  0x0000, /* U+31c8 */
  0x0000, /* U+31c9 */
  0x0000, /* U+31ca */
  0x0000, /* U+31cb */
  0x0000, /* U+31cc */
  0x0000, /* U+31cd */
  0x0000, /* U+31ce */
  0x0000, /* U+31cf */
  0x0000, /* U+31d0 */
  0x0000, /* U+31d1 */
  0x0000, /* U+31d2 */
  0x0000, /* U+31d3 */
  0x0000, /* U+31d4 */
  0x0000, /* U+31d5 */
  0x0000, /* U+31d6 */
  0x0000, /* U+31d7 */
  0x0000, /* U+31d8 */
  0x0000, /* U+31d9 */
  0x0000, /* U+31da */
  0x0000, /* U+31db */
  0x0000, /* U+31dc */
  0x0000, /* U+31dd */
  0x0000, /* U+31de */
  0x0000, /* U+31df */
  0x0000, /* U+31e0 */
  0x0000, /* U+31e1 */
  0x0000, /* U+31e2 */
  0x0000, /* U+31e3 */
  0x0000, /* U+31e4 */
  0x0000, /* U+31e5 */
  0x0000, /* U+31e6 */
  0x0000, /* U+31e7 */
  0x0000, /* U+31e8 */
  0x0000, /* U+31e9 */
  0x0000, /* U+31ea */
  0x0000, /* U+31eb */
  0x0000, /* U+31ec */
  0x0000, /* U+31ed */
  0x0000, /* U+31ee */
  0x0000, /* U+31ef */
  0x0000, /* U+31f0 */
  0x0000, /* U+31f1 */
  0x0000, /* U+31f2 */
  0x0000, /* U+31f3 */
  0x0000, /* U+31f4 */
  0x0000, /* U+31f5 */
  0x0000, /* U+31f6 */
  0x0000, /* U+31f7 */
  0x0000, /* U+31f8 */
  0x0000, /* U+31f9 */
  0x0000, /* U+31fa */
  0x0000, /* U+31fb */
  0x0000, /* U+31fc */
  0x0000, /* U+31fd */
  0x0000, /* U+31fe */
  0x0000, /* U+31ff */
  0x0000, /* U+3200 */
  0x0000, /* U+3201 */
  0x0000, /* U+3202 */
  0x0000, /* U+3203 */
  0x0000, /* U+3204 */
  0x0000, /* U+3205 */
  0x0000, /* U+3206 */
  0x0000, /* U+3207 */
  0x0000, /* U+3208 */
  0x0000, /* U+3209 */
  0x0000, /* U+320a */
  0x0000, /* U+320b */
  0x0000, /* U+320c */
  0x0000, /* U+320d */
  0x0000, /* U+320e */
  0x0000, /* U+320f */
  0x0000, /* U+3210 */
  0x0000, /* U+3211 */
  0x0000, /* U+3212 */
  0x0000, /* U+3213 */
  0x0000, /* U+3214 */
  0x0000, /* U+3215 */
  0x0000, /* U+3216 */
  0x0000, /* U+3217 */
  0x0000, /* U+3218 */
  0x0000, /* U+3219 */
  0x0000, /* U+321a */
  0x0000, /* U+321b */
  0x0000, /* U+321c */
  0x0000, /* U+321d */
  0x0000, /* U+321e */
  0x0000, /* U+321f */
  0x0000, /* U+3220 */
  0x0000, /* U+3221 */
  0x0000, /* U+3222 */
  0x0000, /* U+3223 */
  0x0000, /* U+3224 */
  0x0000, /* U+3225 */
  0x0000, /* U+3226 */
  0x0000, /* U+3227 */
  0x0000, /* U+3228 */
  0x0000, /* U+3229 */
  0x0000, /* U+322a */
  0x0000, /* U+322b */
  0x0000, /* U+322c */
  0x0000, /* U+322d */
  0x0000, /* U+322e */
  0x0000, /* U+322f */
  0x0000, /* U+3230 */
  0xfa58, /* U+3231 */
  0x878b, /* U+3232 */
  0x0000, /* U+3233 */
  0x0000, /* U+3234 */
  0x0000, /* U+3235 */
  0x0000, /* U+3236 */
  0x0000, /* U+3237 */
  0x0000, /* U+3238 */
  0x878c, /* U+3239 */
  0x0000, /* U+323a */
  0x0000, /* U+323b */
  0x0000, /* U+323c */
  0x0000, /* U+323d */
  0x0000, /* U+323e */
  0x0000, /* U+323f */
  0x0000, /* U+3240 */
  0x0000, /* U+3241 */
  0x0000, /* U+3242 */
  0x0000, /* U+3243 */
  0x0000, /* U+3244 */
  0x0000, /* U+3245 */
  0x0000, /* U+3246 */
  0x0000, /* U+3247 */
  0x0000, /* U+3248 */
  0x0000, /* U+3249 */
  0x0000, /* U+324a */
  0x0000, /* U+324b */
  0x0000, /* U+324c */
  0x0000, /* U+324d */
  0x0000, /* U+324e */
  0x0000, /* U+324f */
  0x0000, /* U+3250 */
  0x0000, /* U+3251 */
  0x0000, /* U+3252 */
  0x0000, /* U+3253 */
  0x0000, /* U+3254 */
  0x0000, /* U+3255 */
  0x0000, /* U+3256 */
  0x0000, /* U+3257 */
  0x0000, /* U+3258 */
  0x0000, /* U+3259 */
  0x0000, /* U+325a */
  0x0000, /* U+325b */
  0x0000, /* U+325c */
  0x0000, /* U+325d */
  0x0000, /* U+325e */
  0x0000, /* U+325f */
  0x0000, /* U+3260 */
  0x0000, /* U+3261 */
  0x0000, /* U+3262 */
  0x0000, /* U+3263 */
  0x0000, /* U+3264 */
  0x0000, /* U+3265 */
  0x0000, /* U+3266 */
  0x0000, /* U+3267 */
  0x0000, /* U+3268 */
  0x0000, /* U+3269 */
  0x0000, /* U+326a */
  0x0000, /* U+326b */
  0x0000, /* U+326c */
  0x0000, /* U+326d */
  0x0000, /* U+326e */
  0x0000, /* U+326f */
  0x0000, /* U+3270 */
  0x0000, /* U+3271 */
  0x0000, /* U+3272 */
  0x0000, /* U+3273 */
  0x0000, /* U+3274 */
  0x0000, /* U+3275 */
  0x0000, /* U+3276 */
  0x0000, /* U+3277 */
  0x0000, /* U+3278 */
  0x0000, /* U+3279 */
  0x0000, /* U+327a */
  0x0000, /* U+327b */
  0x0000, /* U+327c */
  0x0000, /* U+327d */
  0x0000, /* U+327e */
  0x0000, /* U+327f */
  0x0000, /* U+3280 */
  0x0000, /* U+3281 */
  0x0000, /* U+3282 */
  0x0000, /* U+3283 */
  0x0000, /* U+3284 */
  0x0000, /* U+3285 */
  0x0000, /* U+3286 */
  0x0000, /* U+3287 */
  0x0000, /* U+3288 */
  0x0000, /* U+3289 */
  0x0000, /* U+328a */
  0x0000, /* U+328b */
  0x0000, /* U+328c */
  0x0000, /* U+328d */
  0x0000, /* U+328e */
  0x0000, /* U+328f */
  0x0000, /* U+3290 */
  0x0000, /* U+3291 */
  0x0000, /* U+3292 */
  0x0000, /* U+3293 */
  0x0000, /* U+3294 */
  0x0000, /* U+3295 */
  0x0000, /* U+3296 */
  0x0000, /* U+3297 */
  0x0000, /* U+3298 */
  0x0000, /* U+3299 */
  0x0000, /* U+329a */
  0x0000, /* U+329b */
  0x0000, /* U+329c */
  0x0000, /* U+329d */
  0x0000, /* U+329e */
  0x0000, /* U+329f */
  0x0000, /* U+32a0 */
  0x0000, /* U+32a1 */
  0x0000, /* U+32a2 */
  0x0000, /* U+32a3 */
  0x8785, /* U+32a4 */
  0x8786, /* U+32a5 */
  0x8787, /* U+32a6 */
  0x8788, /* U+32a7 */
  0x8789, /* U+32a8 */
  0x0000, /* U+32a9 */
  0x0000, /* U+32aa */
  0x0000, /* U+32ab */
  0x0000, /* U+32ac */
  0x0000, /* U+32ad */
  0x0000, /* U+32ae */
  0x0000, /* U+32af */
  0x0000, /* U+32b0 */
  0x0000, /* U+32b1 */
  0x0000, /* U+32b2 */
  0x0000, /* U+32b3 */
  0x0000, /* U+32b4 */
  0x0000, /* U+32b5 */
  0x0000, /* U+32b6 */
  0x0000, /* U+32b7 */
  0x0000, /* U+32b8 */
  0x0000, /* U+32b9 */
  0x0000, /* U+32ba */
  0x0000, /* U+32bb */
  0x0000, /* U+32bc */
  0x0000, /* U+32bd */
  0x0000, /* U+32be */
  0x0000, /* U+32bf */
  0x0000, /* U+32c0 */
  0x0000, /* U+32c1 */
  0x0000, /* U+32c2 */
  0x0000, /* U+32c3 */
  0x0000, /* U+32c4 */
  0x0000, /* U+32c5 */
  0x0000, /* U+32c6 */
  0x0000, /* U+32c7 */
  0x0000, /* U+32c8 */
  0x0000, /* U+32c9 */
  0x0000, /* U+32ca */
  0x0000, /* U+32cb */
  0x0000, /* U+32cc */
  0x0000, /* U+32cd */
  0x0000, /* U+32ce */
  0x0000, /* U+32cf */
  0x0000, /* U+32d0 */
  0x0000, /* U+32d1 */
  0x0000, /* U+32d2 */
  0x0000, /* U+32d3 */
  0x0000, /* U+32d4 */
  0x0000, /* U+32d5 */
  0x0000, /* U+32d6 */
  0x0000, /* U+32d7 */
  0x0000, /* U+32d8 */
  0x0000, /* U+32d9 */
  0x0000, /* U+32da */
  0x0000, /* U+32db */
  0x0000, /* U+32dc */
  0x0000, /* U+32dd */
  0x0000, /* U+32de */
  0x0000, /* U+32df */
  0x0000, /* U+32e0 */
  0x0000, /* U+32e1 */
  0x0000, /* U+32e2 */
  0x0000, /* U+32e3 */
  0x0000, /* U+32e4 */
  0x0000, /* U+32e5 */
  0x0000, /* U+32e6 */
  0x0000, /* U+32e7 */
  0x0000, /* U+32e8 */
  0x0000, /* U+32e9 */
  0x0000, /* U+32ea */
  0x0000, /* U+32eb */
  0x0000, /* U+32ec */
  0x0000, /* U+32ed */
  0x0000, /* U+32ee */
  0x0000, /* U+32ef */
  0x0000, /* U+32f0 */
  0x0000, /* U+32f1 */
  0x0000, /* U+32f2 */
  0x0000, /* U+32f3 */
  0x0000, /* U+32f4 */
  0x0000, /* U+32f5 */
  0x0000, /* U+32f6 */
  0x0000, /* U+32f7 */
  0x0000, /* U+32f8 */
  0x0000, /* U+32f9 */
  0x0000, /* U+32fa */
  0x0000, /* U+32fb */
  0x0000, /* U+32fc */
  0x0000, /* U+32fd */
  0x0000, /* U+32fe */
  0x0000, /* U+32ff */
  0x0000, /* U+3300 */
  0x0000, /* U+3301 */
  0x0000, /* U+3302 */
  0x8765, /* U+3303 */
  0x0000, /* U+3304 */
  0x0000, /* U+3305 */
  0x0000, /* U+3306 */
  0x0000, /* U+3307 */
  0x0000, /* U+3308 */
  0x0000, /* U+3309 */
  0x0000, /* U+330a */
  0x0000, /* U+330b */
  0x0000, /* U+330c */
  0x8769, /* U+330d */
  0x0000, /* U+330e */
  0x0000, /* U+330f */
  0x0000, /* U+3310 */
  0x0000, /* U+3311 */
  0x0000, /* U+3312 */
  0x0000, /* U+3313 */
  0x8760, /* U+3314 */
  0x0000, /* U+3315 */
  0x0000, /* U+3316 */
  0x0000, /* U+3317 */
  0x8763, /* U+3318 */
  0x0000, /* U+3319 */
  0x0000, /* U+331a */
  0x0000, /* U+331b */
  0x0000, /* U+331c */
  0x0000, /* U+331d */
  0x0000, /* U+331e */
  0x0000, /* U+331f */
  0x0000, /* U+3320 */
  0x0000, /* U+3321 */
  0x8761, /* U+3322 */
  0x876b, /* U+3323 */
  0x0000, /* U+3324 */
  0x0000, /* U+3325 */
  0x876a, /* U+3326 */
  0x8764, /* U+3327 */
  0x0000, /* U+3328 */
  0x0000, /* U+3329 */
  0x0000, /* U+332a */
  0x876c, /* U+332b */
  0x0000, /* U+332c */
  0x0000, /* U+332d */
  0x0000, /* U+332e */
  0x0000, /* U+332f */
  0x0000, /* U+3330 */
  0x0000, /* U+3331 */
  0x0000, /* U+3332 */
  0x0000, /* U+3333 */
  0x0000, /* U+3334 */
  0x0000, /* U+3335 */
  0x8766, /* U+3336 */
  0x0000, /* U+3337 */
  0x0000, /* U+3338 */
  0x0000, /* U+3339 */
  0x0000, /* U+333a */
  0x876e, /* U+333b */
  0x0000, /* U+333c */
  0x0000, /* U+333d */
  0x0000, /* U+333e */
  0x0000, /* U+333f */
  0x0000, /* U+3340 */
  0x0000, /* U+3341 */
  0x0000, /* U+3342 */
  0x0000, /* U+3343 */
  0x0000, /* U+3344 */
  0x0000, /* U+3345 */
  0x0000, /* U+3346 */
  0x0000, /* U+3347 */
  0x0000, /* U+3348 */
  0x875f, /* U+3349 */
  0x876d, /* U+334a */
  0x0000, /* U+334b */
  0x0000, /* U+334c */
  0x8762, /* U+334d */
  0x0000, /* U+334e */
  0x0000, /* U+334f */
  0x0000, /* U+3350 */
  0x8767, /* U+3351 */
  0x0000, /* U+3352 */
  0x0000, /* U+3353 */
  0x0000, /* U+3354 */
  0x0000, /* U+3355 */
  0x0000, /* U+3356 */
  0x8768, /* U+3357 */
  0x0000, /* U+3358 */
  0x0000, /* U+3359 */
  0x0000, /* U+335a */
  0x0000, /* U+335b */
  0x0000, /* U+335c */
  0x0000, /* U+335d */
  0x0000, /* U+335e */
  0x0000, /* U+335f */
  0x0000, /* U+3360 */
  0x0000, /* U+3361 */
  0x0000, /* U+3362 */
  0x0000, /* U+3363 */
  0x0000, /* U+3364 */
  0x0000, /* U+3365 */
  0x0000, /* U+3366 */
  0x0000, /* U+3367 */
  0x0000, /* U+3368 */
  0x0000, /* U+3369 */
  0x0000, /* U+336a */
  0x0000, /* U+336b */
  0x0000, /* U+336c */
  0x0000, /* U+336d */
  0x0000, /* U+336e */
  0x0000, /* U+336f */
  0x0000, /* U+3370 */
  0x0000, /* U+3371 */
  0x0000, /* U+3372 */
  0x0000, /* U+3373 */
  0x0000, /* U+3374 */
  0x0000, /* U+3375 */
  0x0000, /* U+3376 */
  0x0000, /* U+3377 */
  0x0000, /* U+3378 */
  0x0000, /* U+3379 */
  0x0000, /* U+337a */
  0x877e, /* U+337b */
  0x878f, /* U+337c */
  0x878e, /* U+337d */
  0x878d, /* U+337e */
  0x0000, /* U+337f */
  0x0000, /* U+3380 */
  0x0000, /* U+3381 */
  0x0000, /* U+3382 */
  0x0000, /* U+3383 */
  0x0000, /* U+3384 */
  0x0000, /* U+3385 */
  0x0000, /* U+3386 */
  0x0000, /* U+3387 */
  0x0000, /* U+3388 */
  0x0000, /* U+3389 */
  0x0000, /* U+338a */
  0x0000, /* U+338b */
  0x0000, /* U+338c */
  0x0000, /* U+338d */
  0x8772, /* U+338e */
  0x8773, /* U+338f */
  0x0000, /* U+3390 */
  0x0000, /* U+3391 */
  0x0000, /* U+3392 */
  0x0000, /* U+3393 */
  0x0000, /* U+3394 */
  0x0000, /* U+3395 */
  0x0000, /* U+3396 */
  0x0000, /* U+3397 */
  0x0000, /* U+3398 */
  0x0000, /* U+3399 */
  0x0000, /* U+339a */
  0x0000, /* U+339b */
  0x876f, /* U+339c */
  0x8770, /* U+339d */
  0x8771, /* U+339e */
  0x0000, /* U+339f */
  0x0000, /* U+33a0 */
  0x8775, /* U+33a1 */
  0x0000, /* U+33a2 */
  0x0000, /* U+33a3 */
  0x0000, /* U+33a4 */
  0x0000, /* U+33a5 */
  0x0000, /* U+33a6 */
  0x0000, /* U+33a7 */
  0x0000, /* U+33a8 */
  0x0000, /* U+33a9 */
  0x0000, /* U+33aa */
  0x0000, /* U+33ab */
  0x0000, /* U+33ac */
  0x0000, /* U+33ad */
  0x0000, /* U+33ae */
  0x0000, /* U+33af */
  0x0000, /* U+33b0 */
  0x0000, /* U+33b1 */
  0x0000, /* U+33b2 */
  0x0000, /* U+33b3 */
  0x0000, /* U+33b4 */
  0x0000, /* U+33b5 */
  0x0000, /* U+33b6 */
  0x0000, /* U+33b7 */
  0x0000, /* U+33b8 */
  0x0000, /* U+33b9 */
  0x0000, /* U+33ba */
  0x0000, /* U+33bb */
  0x0000, /* U+33bc */
  0x0000, /* U+33bd */
  0x0000, /* U+33be */
  0x0000, /* U+33bf */
  0x0000, /* U+33c0 */
  0x0000, /* U+33c1 */
  0x0000, /* U+33c2 */
  0x0000, /* U+33c3 */
  0x8774, /* U+33c4 */
  0x0000, /* U+33c5 */
  0x0000, /* U+33c6 */
  0x0000, /* U+33c7 */
  0x0000, /* U+33c8 */
  0x0000, /* U+33c9 */
  0x0000, /* U+33ca */
  0x0000, /* U+33cb */
  0x0000, /* U+33cc */
  0x8783, /* U+33cd */
  0x0000, /* U+33ce */
  0x0000, /* U+33cf */
  0x0000, /* U+33d0 */
  0x0000, /* U+33d1 */
  0x0000, /* U+33d2 */
  0x0000, /* U+33d3 */
  0x0000, /* U+33d4 */
  0x0000, /* U+33d5 */
  0x0000, /* U+33d6 */
  0x0000, /* U+33d7 */
  0x0000, /* U+33d8 */
  0x0000, /* U+33d9 */
  0x0000, /* U+33da */
  0x0000, /* U+33db */
  0x0000, /* U+33dc */
  0x0000, /* U+33dd */
  0x0000, /* U+33de */
  0x0000, /* U+33df */
  0x0000, /* U+33e0 */
  0x0000, /* U+33e1 */
  0x0000, /* U+33e2 */
  0x0000, /* U+33e3 */
  0x0000, /* U+33e4 */
  0x0000, /* U+33e5 */
  0x0000, /* U+33e6 */
  0x0000, /* U+33e7 */
  0x0000, /* U+33e8 */
  0x0000, /* U+33e9 */
  0x0000, /* U+33ea */
  0x0000, /* U+33eb */
  0x0000, /* U+33ec */
  0x0000, /* U+33ed */
  0x0000, /* U+33ee */
  0x0000, /* U+33ef */
  0x0000, /* U+33f0 */
  0x0000, /* U+33f1 */
  0x0000, /* U+33f2 */
  0x0000, /* U+33f3 */
  0x0000, /* U+33f4 */
  0x0000, /* U+33f5 */
  0x0000, /* U+33f6 */
  0x0000, /* U+33f7 */
  0x0000, /* U+33f8 */
  0x0000, /* U+33f9 */
  0x0000, /* U+33fa */
  0x0000, /* U+33fb */
  0x0000, /* U+33fc */
  0x0000, /* U+33fd */
  0x0000, /* U+33fe */
  0x0000, /* U+33ff */
  0x0000, /* U+3400 */
  0x0000, /* U+3401 */
  0x0000, /* U+3402 */
  0x0000, /* U+3403 */
  0x0000, /* U+3404 */
  0x0000, /* U+3405 */
  0x0000, /* U+3406 */
  0x0000, /* U+3407 */
  0x0000, /* U+3408 */
  0x0000, /* U+3409 */
  0x0000, /* U+340a */
  0x0000, /* U+340b */
  0x0000, /* U+340c */
  0x0000, /* U+340d */
  0x0000, /* U+340e */
  0x0000, /* U+340f */
  0x0000, /* U+3410 */
  0x0000, /* U+3411 */
  0x0000, /* U+3412 */
  0x0000, /* U+3413 */
  0x0000, /* U+3414 */
  0x0000, /* U+3415 */
  0x0000, /* U+3416 */
  0x0000, /* U+3417 */
  0x0000, /* U+3418 */
  0x0000, /* U+3419 */
  0x0000, /* U+341a */
  0x0000, /* U+341b */
  0x0000, /* U+341c */
  0x0000, /* U+341d */
  0x0000, /* U+341e */
  0x0000, /* U+341f */
  0x0000, /* U+3420 */
  0x0000, /* U+3421 */
  0x0000, /* U+3422 */
  0x0000, /* U+3423 */
  0x0000, /* U+3424 */
  0x0000, /* U+3425 */
  0x0000, /* U+3426 */
  0x0000, /* U+3427 */
  0x0000, /* U+3428 */
  0x0000, /* U+3429 */
  0x0000, /* U+342a */
  0x0000, /* U+342b */
  0x0000, /* U+342c */
  0x0000, /* U+342d */
  0x0000, /* U+342e */
  0x0000, /* U+342f */
  0x0000, /* U+3430 */
  0x0000, /* U+3431 */
  0x0000, /* U+3432 */
  0x0000, /* U+3433 */
  0x0000, /* U+3434 */
  0x0000, /* U+3435 */
  0x0000, /* U+3436 */
  0x0000, /* U+3437 */
  0x0000, /* U+3438 */
  0x0000, /* U+3439 */
  0x0000, /* U+343a */
  0x0000, /* U+343b */
  0x0000, /* U+343c */
  0x0000, /* U+343d */
  0x0000, /* U+343e */
  0x0000, /* U+343f */
  0x0000, /* U+3440 */
  0x0000, /* U+3441 */
  0x0000, /* U+3442 */
  0x0000, /* U+3443 */
  0x0000, /* U+3444 */
  0x0000, /* U+3445 */
  0x0000, /* U+3446 */
  0x0000, /* U+3447 */
  0x0000, /* U+3448 */
  0x0000, /* U+3449 */
  0x0000, /* U+344a */
  0x0000, /* U+344b */
  0x0000, /* U+344c */
  0x0000, /* U+344d */
  0x0000, /* U+344e */
  0x0000, /* U+344f */
  0x0000, /* U+3450 */
  0x0000, /* U+3451 */
  0x0000, /* U+3452 */
  0x0000, /* U+3453 */
  0x0000, /* U+3454 */
  0x0000, /* U+3455 */
  0x0000, /* U+3456 */
  0x0000, /* U+3457 */
  0x0000, /* U+3458 */
  0x0000, /* U+3459 */
  0x0000, /* U+345a */
  0x0000, /* U+345b */
  0x0000, /* U+345c */
  0x0000, /* U+345d */
  0x0000, /* U+345e */
  0x0000, /* U+345f */
  0x0000, /* U+3460 */
  0x0000, /* U+3461 */
  0x0000, /* U+3462 */
  0x0000, /* U+3463 */
  0x0000, /* U+3464 */
  0x0000, /* U+3465 */
  0x0000, /* U+3466 */
  0x0000, /* U+3467 */
  0x0000, /* U+3468 */
  0x0000, /* U+3469 */
  0x0000, /* U+346a */
  0x0000, /* U+346b */
  0x0000, /* U+346c */
  0x0000, /* U+346d */
  0x0000, /* U+346e */
  0x0000, /* U+346f */
  0x0000, /* U+3470 */
  0x0000, /* U+3471 */
  0x0000, /* U+3472 */
  0x0000, /* U+3473 */
  0x0000, /* U+3474 */
  0x0000, /* U+3475 */
  0x0000, /* U+3476 */
  0x0000, /* U+3477 */
  0x0000, /* U+3478 */
  0x0000, /* U+3479 */
  0x0000, /* U+347a */
  0x0000, /* U+347b */
  0x0000, /* U+347c */
  0x0000, /* U+347d */
  0x0000, /* U+347e */
  0x0000, /* U+347f */
  0x0000, /* U+3480 */
  0x0000, /* U+3481 */
  0x0000, /* U+3482 */
  0x0000, /* U+3483 */
  0x0000, /* U+3484 */
  0x0000, /* U+3485 */
  0x0000, /* U+3486 */
  0x0000, /* U+3487 */
  0x0000, /* U+3488 */
  0x0000, /* U+3489 */
  0x0000, /* U+348a */
  0x0000, /* U+348b */
  0x0000, /* U+348c */
  0x0000, /* U+348d */
  0x0000, /* U+348e */
  0x0000, /* U+348f */
  0x0000, /* U+3490 */
  0x0000, /* U+3491 */
  0x0000, /* U+3492 */
  0x0000, /* U+3493 */
  0x0000, /* U+3494 */
  0x0000, /* U+3495 */
  0x0000, /* U+3496 */
  0x0000, /* U+3497 */
  0x0000, /* U+3498 */
  0x0000, /* U+3499 */
  0x0000, /* U+349a */
  0x0000, /* U+349b */
  0x0000, /* U+349c */
  0x0000, /* U+349d */
  0x0000, /* U+349e */
  0x0000, /* U+349f */
  0x0000, /* U+34a0 */
  0x0000, /* U+34a1 */
  0x0000, /* U+34a2 */
  0x0000, /* U+34a3 */
  0x0000, /* U+34a4 */
  0x0000, /* U+34a5 */
  0x0000, /* U+34a6 */
  0x0000, /* U+34a7 */
  0x0000, /* U+34a8 */
  0x0000, /* U+34a9 */
  0x0000, /* U+34aa */
  0x0000, /* U+34ab */
  0x0000, /* U+34ac */
  0x0000, /* U+34ad */
  0x0000, /* U+34ae */
  0x0000, /* U+34af */
  0x0000, /* U+34b0 */
  0x0000, /* U+34b1 */
  0x0000, /* U+34b2 */
  0x0000, /* U+34b3 */
  0x0000, /* U+34b4 */
  0x0000, /* U+34b5 */
  0x0000, /* U+34b6 */
  0x0000, /* U+34b7 */
  0x0000, /* U+34b8 */
  0x0000, /* U+34b9 */
  0x0000, /* U+34ba */
  0x0000, /* U+34bb */
  0x0000, /* U+34bc */
  0x0000, /* U+34bd */
  0x0000, /* U+34be */
  0x0000, /* U+34bf */
  0x0000, /* U+34c0 */
  0x0000, /* U+34c1 */
  0x0000, /* U+34c2 */
  0x0000, /* U+34c3 */
  0x0000, /* U+34c4 */
  0x0000, /* U+34c5 */
  0x0000, /* U+34c6 */
  0x0000, /* U+34c7 */
  0x0000, /* U+34c8 */
  0x0000, /* U+34c9 */
  0x0000, /* U+34ca */
  0x0000, /* U+34cb */
  0x0000, /* U+34cc */
  0x0000, /* U+34cd */
  0x0000, /* U+34ce */
  0x0000, /* U+34cf */
  0x0000, /* U+34d0 */
  0x0000, /* U+34d1 */
  0x0000, /* U+34d2 */
  0x0000, /* U+34d3 */
  0x0000, /* U+34d4 */
  0x0000, /* U+34d5 */
  0x0000, /* U+34d6 */
  0x0000, /* U+34d7 */
  0x0000, /* U+34d8 */
  0x0000, /* U+34d9 */
  0x0000, /* U+34da */
  0x0000, /* U+34db */
  0x0000, /* U+34dc */
  0x0000, /* U+34dd */
  0x0000, /* U+34de */
  0x0000, /* U+34df */
  0x0000, /* U+34e0 */
  0x0000, /* U+34e1 */
  0x0000, /* U+34e2 */
  0x0000, /* U+34e3 */
  0x0000, /* U+34e4 */
  0x0000, /* U+34e5 */
  0x0000, /* U+34e6 */
  0x0000, /* U+34e7 */
  0x0000, /* U+34e8 */
  0x0000, /* U+34e9 */
  0x0000, /* U+34ea */
  0x0000, /* U+34eb */
  0x0000, /* U+34ec */
  0x0000, /* U+34ed */
  0x0000, /* U+34ee */
  0x0000, /* U+34ef */
  0x0000, /* U+34f0 */
  0x0000, /* U+34f1 */
  0x0000, /* U+34f2 */
  0x0000, /* U+34f3 */
  0x0000, /* U+34f4 */
  0x0000, /* U+34f5 */
  0x0000, /* U+34f6 */
  0x0000, /* U+34f7 */
  0x0000, /* U+34f8 */
  0x0000, /* U+34f9 */
  0x0000, /* U+34fa */
  0x0000, /* U+34fb */
  0x0000, /* U+34fc */
  0x0000, /* U+34fd */
  0x0000, /* U+34fe */
  0x0000, /* U+34ff */
  0x0000, /* U+3500 */
  0x0000, /* U+3501 */
  0x0000, /* U+3502 */
  0x0000, /* U+3503 */
  0x0000, /* U+3504 */
  0x0000, /* U+3505 */
  0x0000, /* U+3506 */
  0x0000, /* U+3507 */
  0x0000, /* U+3508 */
  0x0000, /* U+3509 */
  0x0000, /* U+350a */
  0x0000, /* U+350b */
  0x0000, /* U+350c */
  0x0000, /* U+350d */
  0x0000, /* U+350e */
  0x0000, /* U+350f */
  0x0000, /* U+3510 */
  0x0000, /* U+3511 */
  0x0000, /* U+3512 */
  0x0000, /* U+3513 */
  0x0000, /* U+3514 */
  0x0000, /* U+3515 */
  0x0000, /* U+3516 */
  0x0000, /* U+3517 */
  0x0000, /* U+3518 */
  0x0000, /* U+3519 */
  0x0000, /* U+351a */
  0x0000, /* U+351b */
  0x0000, /* U+351c */
  0x0000, /* U+351d */
  0x0000, /* U+351e */
  0x0000, /* U+351f */
  0x0000, /* U+3520 */
  0x0000, /* U+3521 */
  0x0000, /* U+3522 */
  0x0000, /* U+3523 */
  0x0000, /* U+3524 */
  0x0000, /* U+3525 */
  0x0000, /* U+3526 */
  0x0000, /* U+3527 */
  0x0000, /* U+3528 */
  0x0000, /* U+3529 */
  0x0000, /* U+352a */
  0x0000, /* U+352b */
  0x0000, /* U+352c */
  0x0000, /* U+352d */
  0x0000, /* U+352e */
  0x0000, /* U+352f */
  0x0000, /* U+3530 */
  0x0000, /* U+3531 */
  0x0000, /* U+3532 */
  0x0000, /* U+3533 */
  0x0000, /* U+3534 */
  0x0000, /* U+3535 */
  0x0000, /* U+3536 */
  0x0000, /* U+3537 */
  0x0000, /* U+3538 */
  0x0000, /* U+3539 */
  0x0000, /* U+353a */
  0x0000, /* U+353b */
  0x0000, /* U+353c */
  0x0000, /* U+353d */
  0x0000, /* U+353e */
  0x0000, /* U+353f */
  0x0000, /* U+3540 */
  0x0000, /* U+3541 */
  0x0000, /* U+3542 */
  0x0000, /* U+3543 */
  0x0000, /* U+3544 */
  0x0000, /* U+3545 */
  0x0000, /* U+3546 */
  0x0000, /* U+3547 */
  0x0000, /* U+3548 */
  0x0000, /* U+3549 */
  0x0000, /* U+354a */
  0x0000, /* U+354b */
  0x0000, /* U+354c */
  0x0000, /* U+354d */
  0x0000, /* U+354e */
  0x0000, /* U+354f */
  0x0000, /* U+3550 */
  0x0000, /* U+3551 */
  0x0000, /* U+3552 */
  0x0000, /* U+3553 */
  0x0000, /* U+3554 */
  0x0000, /* U+3555 */
  0x0000, /* U+3556 */
  0x0000, /* U+3557 */
  0x0000, /* U+3558 */
  0x0000, /* U+3559 */
  0x0000, /* U+355a */
  0x0000, /* U+355b */
  0x0000, /* U+355c */
  0x0000, /* U+355d */
  0x0000, /* U+355e */
  0x0000, /* U+355f */
  0x0000, /* U+3560 */
  0x0000, /* U+3561 */
  0x0000, /* U+3562 */
  0x0000, /* U+3563 */
  0x0000, /* U+3564 */
  0x0000, /* U+3565 */
  0x0000, /* U+3566 */
  0x0000, /* U+3567 */
  0x0000, /* U+3568 */
  0x0000, /* U+3569 */
  0x0000, /* U+356a */
  0x0000, /* U+356b */
  0x0000, /* U+356c */
  0x0000, /* U+356d */
  0x0000, /* U+356e */
  0x0000, /* U+356f */
  0x0000, /* U+3570 */
  0x0000, /* U+3571 */
  0x0000, /* U+3572 */
  0x0000, /* U+3573 */
  0x0000, /* U+3574 */
  0x0000, /* U+3575 */
  0x0000, /* U+3576 */
  0x0000, /* U+3577 */
  0x0000, /* U+3578 */
  0x0000, /* U+3579 */
  0x0000, /* U+357a */
  0x0000, /* U+357b */
  0x0000, /* U+357c */
  0x0000, /* U+357d */
  0x0000, /* U+357e */
  0x0000, /* U+357f */
  0x0000, /* U+3580 */
  0x0000, /* U+3581 */
  0x0000, /* U+3582 */
  0x0000, /* U+3583 */
  0x0000, /* U+3584 */
  0x0000, /* U+3585 */
  0x0000, /* U+3586 */
  0x0000, /* U+3587 */
  0x0000, /* U+3588 */
  0x0000, /* U+3589 */
  0x0000, /* U+358a */
  0x0000, /* U+358b */
  0x0000, /* U+358c */
  0x0000, /* U+358d */
  0x0000, /* U+358e */
  0x0000, /* U+358f */
  0x0000, /* U+3590 */
  0x0000, /* U+3591 */
  0x0000, /* U+3592 */
  0x0000, /* U+3593 */
  0x0000, /* U+3594 */
  0x0000, /* U+3595 */
  0x0000, /* U+3596 */
  0x0000, /* U+3597 */
  0x0000, /* U+3598 */
  0x0000, /* U+3599 */
  0x0000, /* U+359a */
  0x0000, /* U+359b */
  0x0000, /* U+359c */
  0x0000, /* U+359d */
  0x0000, /* U+359e */
  0x0000, /* U+359f */
  0x0000, /* U+35a0 */
  0x0000, /* U+35a1 */
  0x0000, /* U+35a2 */
  0x0000, /* U+35a3 */
  0x0000, /* U+35a4 */
  0x0000, /* U+35a5 */
  0x0000, /* U+35a6 */
  0x0000, /* U+35a7 */
  0x0000, /* U+35a8 */
  0x0000, /* U+35a9 */
  0x0000, /* U+35aa */
  0x0000, /* U+35ab */
  0x0000, /* U+35ac */
  0x0000, /* U+35ad */
  0x0000, /* U+35ae */
  0x0000, /* U+35af */
  0x0000, /* U+35b0 */
  0x0000, /* U+35b1 */
  0x0000, /* U+35b2 */
  0x0000, /* U+35b3 */
  0x0000, /* U+35b4 */
  0x0000, /* U+35b5 */
  0x0000, /* U+35b6 */
  0x0000, /* U+35b7 */
  0x0000, /* U+35b8 */
  0x0000, /* U+35b9 */
  0x0000, /* U+35ba */
  0x0000, /* U+35bb */
  0x0000, /* U+35bc */
  0x0000, /* U+35bd */
  0x0000, /* U+35be */
  0x0000, /* U+35bf */
  0x0000, /* U+35c0 */
  0x0000, /* U+35c1 */
  0x0000, /* U+35c2 */
  0x0000, /* U+35c3 */
  0x0000, /* U+35c4 */
  0x0000, /* U+35c5 */
  0x0000, /* U+35c6 */
  0x0000, /* U+35c7 */
  0x0000, /* U+35c8 */
  0x0000, /* U+35c9 */
  0x0000, /* U+35ca */
  0x0000, /* U+35cb */
  0x0000, /* U+35cc */
  0x0000, /* U+35cd */
  0x0000, /* U+35ce */
  0x0000, /* U+35cf */
  0x0000, /* U+35d0 */
  0x0000, /* U+35d1 */
  0x0000, /* U+35d2 */
  0x0000, /* U+35d3 */
  0x0000, /* U+35d4 */
  0x0000, /* U+35d5 */
  0x0000, /* U+35d6 */
  0x0000, /* U+35d7 */
  0x0000, /* U+35d8 */
  0x0000, /* U+35d9 */
  0x0000, /* U+35da */
  0x0000, /* U+35db */
  0x0000, /* U+35dc */
  0x0000, /* U+35dd */
  0x0000, /* U+35de */
  0x0000, /* U+35df */
  0x0000, /* U+35e0 */
  0x0000, /* U+35e1 */
  0x0000, /* U+35e2 */
  0x0000, /* U+35e3 */
  0x0000, /* U+35e4 */
  0x0000, /* U+35e5 */
  0x0000, /* U+35e6 */
  0x0000, /* U+35e7 */
  0x0000, /* U+35e8 */
  0x0000, /* U+35e9 */
  0x0000, /* U+35ea */
  0x0000, /* U+35eb */
  0x0000, /* U+35ec */
  0x0000, /* U+35ed */
  0x0000, /* U+35ee */
  0x0000, /* U+35ef */
  0x0000, /* U+35f0 */
  0x0000, /* U+35f1 */
  0x0000, /* U+35f2 */
  0x0000, /* U+35f3 */
  0x0000, /* U+35f4 */
  0x0000, /* U+35f5 */
  0x0000, /* U+35f6 */
  0x0000, /* U+35f7 */
  0x0000, /* U+35f8 */
  0x0000, /* U+35f9 */
  0x0000, /* U+35fa */
  0x0000, /* U+35fb */
  0x0000, /* U+35fc */
  0x0000, /* U+35fd */
  0x0000, /* U+35fe */
  0x0000, /* U+35ff */
  0x0000, /* U+3600 */
  0x0000, /* U+3601 */
  0x0000, /* U+3602 */
  0x0000, /* U+3603 */
  0x0000, /* U+3604 */
  0x0000, /* U+3605 */
  0x0000, /* U+3606 */
  0x0000, /* U+3607 */
  0x0000, /* U+3608 */
  0x0000, /* U+3609 */
  0x0000, /* U+360a */
  0x0000, /* U+360b */
  0x0000, /* U+360c */
  0x0000, /* U+360d */
  0x0000, /* U+360e */
  0x0000, /* U+360f */
  0x0000, /* U+3610 */
  0x0000, /* U+3611 */
  0x0000, /* U+3612 */
  0x0000, /* U+3613 */
  0x0000, /* U+3614 */
  0x0000, /* U+3615 */
  0x0000, /* U+3616 */
  0x0000, /* U+3617 */
  0x0000, /* U+3618 */
  0x0000, /* U+3619 */
  0x0000, /* U+361a */
  0x0000, /* U+361b */
  0x0000, /* U+361c */
  0x0000, /* U+361d */
  0x0000, /* U+361e */
  0x0000, /* U+361f */
  0x0000, /* U+3620 */
  0x0000, /* U+3621 */
  0x0000, /* U+3622 */
  0x0000, /* U+3623 */
  0x0000, /* U+3624 */
  0x0000, /* U+3625 */
  0x0000, /* U+3626 */
  0x0000, /* U+3627 */
  0x0000, /* U+3628 */
  0x0000, /* U+3629 */
  0x0000, /* U+362a */
  0x0000, /* U+362b */
  0x0000, /* U+362c */
  0x0000, /* U+362d */
  0x0000, /* U+362e */
  0x0000, /* U+362f */
  0x0000, /* U+3630 */
  0x0000, /* U+3631 */
  0x0000, /* U+3632 */
  0x0000, /* U+3633 */
  0x0000, /* U+3634 */
  0x0000, /* U+3635 */
  0x0000, /* U+3636 */
  0x0000, /* U+3637 */
  0x0000, /* U+3638 */
  0x0000, /* U+3639 */
  0x0000, /* U+363a */
  0x0000, /* U+363b */
  0x0000, /* U+363c */
  0x0000, /* U+363d */
  0x0000, /* U+363e */
  0x0000, /* U+363f */
  0x0000, /* U+3640 */
  0x0000, /* U+3641 */
  0x0000, /* U+3642 */
  0x0000, /* U+3643 */
  0x0000, /* U+3644 */
  0x0000, /* U+3645 */
  0x0000, /* U+3646 */
  0x0000, /* U+3647 */
  0x0000, /* U+3648 */
  0x0000, /* U+3649 */
  0x0000, /* U+364a */
  0x0000, /* U+364b */
  0x0000, /* U+364c */
  0x0000, /* U+364d */
  0x0000, /* U+364e */
  0x0000, /* U+364f */
  0x0000, /* U+3650 */
  0x0000, /* U+3651 */
  0x0000, /* U+3652 */
  0x0000, /* U+3653 */
  0x0000, /* U+3654 */
  0x0000, /* U+3655 */
  0x0000, /* U+3656 */
  0x0000, /* U+3657 */
  0x0000, /* U+3658 */
  0x0000, /* U+3659 */
  0x0000, /* U+365a */
  0x0000, /* U+365b */
  0x0000, /* U+365c */
  0x0000, /* U+365d */
  0x0000, /* U+365e */
  0x0000, /* U+365f */
  0x0000, /* U+3660 */
  0x0000, /* U+3661 */
  0x0000, /* U+3662 */
  0x0000, /* U+3663 */
  0x0000, /* U+3664 */
  0x0000, /* U+3665 */
  0x0000, /* U+3666 */
  0x0000, /* U+3667 */
  0x0000, /* U+3668 */
  0x0000, /* U+3669 */
  0x0000, /* U+366a */
  0x0000, /* U+366b */
  0x0000, /* U+366c */
  0x0000, /* U+366d */
  0x0000, /* U+366e */
  0x0000, /* U+366f */
  0x0000, /* U+3670 */
  0x0000, /* U+3671 */
  0x0000, /* U+3672 */
  0x0000, /* U+3673 */
  0x0000, /* U+3674 */
  0x0000, /* U+3675 */
  0x0000, /* U+3676 */
  0x0000, /* U+3677 */
  0x0000, /* U+3678 */
  0x0000, /* U+3679 */
  0x0000, /* U+367a */
  0x0000, /* U+367b */
  0x0000, /* U+367c */
  0x0000, /* U+367d */
  0x0000, /* U+367e */
  0x0000, /* U+367f */
  0x0000, /* U+3680 */
  0x0000, /* U+3681 */
  0x0000, /* U+3682 */
  0x0000, /* U+3683 */
  0x0000, /* U+3684 */
  0x0000, /* U+3685 */
  0x0000, /* U+3686 */
  0x0000, /* U+3687 */
  0x0000, /* U+3688 */
  0x0000, /* U+3689 */
  0x0000, /* U+368a */
  0x0000, /* U+368b */
  0x0000, /* U+368c */
  0x0000, /* U+368d */
  0x0000, /* U+368e */
  0x0000, /* U+368f */
  0x0000, /* U+3690 */
  0x0000, /* U+3691 */
  0x0000, /* U+3692 */
  0x0000, /* U+3693 */
  0x0000, /* U+3694 */
  0x0000, /* U+3695 */
  0x0000, /* U+3696 */
  0x0000, /* U+3697 */
  0x0000, /* U+3698 */
  0x0000, /* U+3699 */
  0x0000, /* U+369a */
  0x0000, /* U+369b */
  0x0000, /* U+369c */
  0x0000, /* U+369d */
  0x0000, /* U+369e */
  0x0000, /* U+369f */
  0x0000, /* U+36a0 */
  0x0000, /* U+36a1 */
  0x0000, /* U+36a2 */
  0x0000, /* U+36a3 */
  0x0000, /* U+36a4 */
  0x0000, /* U+36a5 */
  0x0000, /* U+36a6 */
  0x0000, /* U+36a7 */
  0x0000, /* U+36a8 */
  0x0000, /* U+36a9 */
  0x0000, /* U+36aa */
  0x0000, /* U+36ab */
  0x0000, /* U+36ac */
  0x0000, /* U+36ad */
  0x0000, /* U+36ae */
  0x0000, /* U+36af */
  0x0000, /* U+36b0 */
  0x0000, /* U+36b1 */
  0x0000, /* U+36b2 */
  0x0000, /* U+36b3 */
  0x0000, /* U+36b4 */
  0x0000, /* U+36b5 */
  0x0000, /* U+36b6 */
  0x0000, /* U+36b7 */
  0x0000, /* U+36b8 */
  0x0000, /* U+36b9 */
  0x0000, /* U+36ba */
  0x0000, /* U+36bb */
  0x0000, /* U+36bc */
  0x0000, /* U+36bd */
  0x0000, /* U+36be */
  0x0000, /* U+36bf */
  0x0000, /* U+36c0 */
  0x0000, /* U+36c1 */
  0x0000, /* U+36c2 */
  0x0000, /* U+36c3 */
  0x0000, /* U+36c4 */
  0x0000, /* U+36c5 */
  0x0000, /* U+36c6 */
  0x0000, /* U+36c7 */
  0x0000, /* U+36c8 */
  0x0000, /* U+36c9 */
  0x0000, /* U+36ca */
  0x0000, /* U+36cb */
  0x0000, /* U+36cc */
  0x0000, /* U+36cd */
  0x0000, /* U+36ce */
  0x0000, /* U+36cf */
  0x0000, /* U+36d0 */
  0x0000, /* U+36d1 */
  0x0000, /* U+36d2 */
  0x0000, /* U+36d3 */
  0x0000, /* U+36d4 */
  0x0000, /* U+36d5 */
  0x0000, /* U+36d6 */
  0x0000, /* U+36d7 */
  0x0000, /* U+36d8 */
  0x0000, /* U+36d9 */
  0x0000, /* U+36da */
  0x0000, /* U+36db */
  0x0000, /* U+36dc */
  0x0000, /* U+36dd */
  0x0000, /* U+36de */
  0x0000, /* U+36df */
  0x0000, /* U+36e0 */
  0x0000, /* U+36e1 */
  0x0000, /* U+36e2 */
  0x0000, /* U+36e3 */
  0x0000, /* U+36e4 */
  0x0000, /* U+36e5 */
  0x0000, /* U+36e6 */
  0x0000, /* U+36e7 */
  0x0000, /* U+36e8 */
  0x0000, /* U+36e9 */
  0x0000, /* U+36ea */
  0x0000, /* U+36eb */
  0x0000, /* U+36ec */
  0x0000, /* U+36ed */
  0x0000, /* U+36ee */
  0x0000, /* U+36ef */
  0x0000, /* U+36f0 */
  0x0000, /* U+36f1 */
  0x0000, /* U+36f2 */
  0x0000, /* U+36f3 */
  0x0000, /* U+36f4 */
  0x0000, /* U+36f5 */
  0x0000, /* U+36f6 */
  0x0000, /* U+36f7 */
  0x0000, /* U+36f8 */
  0x0000, /* U+36f9 */
  0x0000, /* U+36fa */
  0x0000, /* U+36fb */
  0x0000, /* U+36fc */
  0x0000, /* U+36fd */
  0x0000, /* U+36fe */
  0x0000, /* U+36ff */
  0x0000, /* U+3700 */
  0x0000, /* U+3701 */
  0x0000, /* U+3702 */
  0x0000, /* U+3703 */
  0x0000, /* U+3704 */
  0x0000, /* U+3705 */
  0x0000, /* U+3706 */
  0x0000, /* U+3707 */
  0x0000, /* U+3708 */
  0x0000, /* U+3709 */
  0x0000, /* U+370a */
  0x0000, /* U+370b */
  0x0000, /* U+370c */
  0x0000, /* U+370d */
  0x0000, /* U+370e */
  0x0000, /* U+370f */
  0x0000, /* U+3710 */
  0x0000, /* U+3711 */
  0x0000, /* U+3712 */
  0x0000, /* U+3713 */
  0x0000, /* U+3714 */
  0x0000, /* U+3715 */
  0x0000, /* U+3716 */
  0x0000, /* U+3717 */
  0x0000, /* U+3718 */
  0x0000, /* U+3719 */
  0x0000, /* U+371a */
  0x0000, /* U+371b */
  0x0000, /* U+371c */
  0x0000, /* U+371d */
  0x0000, /* U+371e */
  0x0000, /* U+371f */
  0x0000, /* U+3720 */
  0x0000, /* U+3721 */
  0x0000, /* U+3722 */
  0x0000, /* U+3723 */
  0x0000, /* U+3724 */
  0x0000, /* U+3725 */
  0x0000, /* U+3726 */
  0x0000, /* U+3727 */
  0x0000, /* U+3728 */
  0x0000, /* U+3729 */
  0x0000, /* U+372a */
  0x0000, /* U+372b */
  0x0000, /* U+372c */
  0x0000, /* U+372d */
  0x0000, /* U+372e */
  0x0000, /* U+372f */
  0x0000, /* U+3730 */
  0x0000, /* U+3731 */
  0x0000, /* U+3732 */
  0x0000, /* U+3733 */
  0x0000, /* U+3734 */
  0x0000, /* U+3735 */
  0x0000, /* U+3736 */
  0x0000, /* U+3737 */
  0x0000, /* U+3738 */
  0x0000, /* U+3739 */
  0x0000, /* U+373a */
  0x0000, /* U+373b */
  0x0000, /* U+373c */
  0x0000, /* U+373d */
  0x0000, /* U+373e */
  0x0000, /* U+373f */
  0x0000, /* U+3740 */
  0x0000, /* U+3741 */
  0x0000, /* U+3742 */
  0x0000, /* U+3743 */
  0x0000, /* U+3744 */
  0x0000, /* U+3745 */
  0x0000, /* U+3746 */
  0x0000, /* U+3747 */
  0x0000, /* U+3748 */
  0x0000, /* U+3749 */
  0x0000, /* U+374a */
  0x0000, /* U+374b */
  0x0000, /* U+374c */
  0x0000, /* U+374d */
  0x0000, /* U+374e */
  0x0000, /* U+374f */
  0x0000, /* U+3750 */
  0x0000, /* U+3751 */
  0x0000, /* U+3752 */
  0x0000, /* U+3753 */
  0x0000, /* U+3754 */
  0x0000, /* U+3755 */
  0x0000, /* U+3756 */
  0x0000, /* U+3757 */
  0x0000, /* U+3758 */
  0x0000, /* U+3759 */
  0x0000, /* U+375a */
  0x0000, /* U+375b */
  0x0000, /* U+375c */
  0x0000, /* U+375d */
  0x0000, /* U+375e */
  0x0000, /* U+375f */
  0x0000, /* U+3760 */
  0x0000, /* U+3761 */
  0x0000, /* U+3762 */
  0x0000, /* U+3763 */
  0x0000, /* U+3764 */
  0x0000, /* U+3765 */
  0x0000, /* U+3766 */
  0x0000, /* U+3767 */
  0x0000, /* U+3768 */
  0x0000, /* U+3769 */
  0x0000, /* U+376a */
  0x0000, /* U+376b */
  0x0000, /* U+376c */
  0x0000, /* U+376d */
  0x0000, /* U+376e */
  0x0000, /* U+376f */
  0x0000, /* U+3770 */
  0x0000, /* U+3771 */
  0x0000, /* U+3772 */
  0x0000, /* U+3773 */
  0x0000, /* U+3774 */
  0x0000, /* U+3775 */
  0x0000, /* U+3776 */
  0x0000, /* U+3777 */
  0x0000, /* U+3778 */
  0x0000, /* U+3779 */
  0x0000, /* U+377a */
  0x0000, /* U+377b */
  0x0000, /* U+377c */
  0x0000, /* U+377d */
  0x0000, /* U+377e */
  0x0000, /* U+377f */
  0x0000, /* U+3780 */
  0x0000, /* U+3781 */
  0x0000, /* U+3782 */
  0x0000, /* U+3783 */
  0x0000, /* U+3784 */
  0x0000, /* U+3785 */
  0x0000, /* U+3786 */
  0x0000, /* U+3787 */
  0x0000, /* U+3788 */
  0x0000, /* U+3789 */
  0x0000, /* U+378a */
  0x0000, /* U+378b */
  0x0000, /* U+378c */
  0x0000, /* U+378d */
  0x0000, /* U+378e */
  0x0000, /* U+378f */
  0x0000, /* U+3790 */
  0x0000, /* U+3791 */
  0x0000, /* U+3792 */
  0x0000, /* U+3793 */
  0x0000, /* U+3794 */
  0x0000, /* U+3795 */
  0x0000, /* U+3796 */
  0x0000, /* U+3797 */
  0x0000, /* U+3798 */
  0x0000, /* U+3799 */
  0x0000, /* U+379a */
  0x0000, /* U+379b */
  0x0000, /* U+379c */
  0x0000, /* U+379d */
  0x0000, /* U+379e */
  0x0000, /* U+379f */
  0x0000, /* U+37a0 */
  0x0000, /* U+37a1 */
  0x0000, /* U+37a2 */
  0x0000, /* U+37a3 */
  0x0000, /* U+37a4 */
  0x0000, /* U+37a5 */
  0x0000, /* U+37a6 */
  0x0000, /* U+37a7 */
  0x0000, /* U+37a8 */
  0x0000, /* U+37a9 */
  0x0000, /* U+37aa */
  0x0000, /* U+37ab */
  0x0000, /* U+37ac */
  0x0000, /* U+37ad */
  0x0000, /* U+37ae */
  0x0000, /* U+37af */
  0x0000, /* U+37b0 */
  0x0000, /* U+37b1 */
  0x0000, /* U+37b2 */
  0x0000, /* U+37b3 */
  0x0000, /* U+37b4 */
  0x0000, /* U+37b5 */
  0x0000, /* U+37b6 */
  0x0000, /* U+37b7 */
  0x0000, /* U+37b8 */
  0x0000, /* U+37b9 */
  0x0000, /* U+37ba */
  0x0000, /* U+37bb */
  0x0000, /* U+37bc */
  0x0000, /* U+37bd */
  0x0000, /* U+37be */
  0x0000, /* U+37bf */
  0x0000, /* U+37c0 */
  0x0000, /* U+37c1 */
  0x0000, /* U+37c2 */
  0x0000, /* U+37c3 */
  0x0000, /* U+37c4 */
  0x0000, /* U+37c5 */
  0x0000, /* U+37c6 */
  0x0000, /* U+37c7 */
  0x0000, /* U+37c8 */
  0x0000, /* U+37c9 */
  0x0000, /* U+37ca */
  0x0000, /* U+37cb */
  0x0000, /* U+37cc */
  0x0000, /* U+37cd */
  0x0000, /* U+37ce */
  0x0000, /* U+37cf */
  0x0000, /* U+37d0 */
  0x0000, /* U+37d1 */
  0x0000, /* U+37d2 */
  0x0000, /* U+37d3 */
  0x0000, /* U+37d4 */
  0x0000, /* U+37d5 */
  0x0000, /* U+37d6 */
  0x0000, /* U+37d7 */
  0x0000, /* U+37d8 */
  0x0000, /* U+37d9 */
  0x0000, /* U+37da */
  0x0000, /* U+37db */
  0x0000, /* U+37dc */
  0x0000, /* U+37dd */
  0x0000, /* U+37de */
  0x0000, /* U+37df */
  0x0000, /* U+37e0 */
  0x0000, /* U+37e1 */
  0x0000, /* U+37e2 */
  0x0000, /* U+37e3 */
  0x0000, /* U+37e4 */
  0x0000, /* U+37e5 */
  0x0000, /* U+37e6 */
  0x0000, /* U+37e7 */
  0x0000, /* U+37e8 */
  0x0000, /* U+37e9 */
  0x0000, /* U+37ea */
  0x0000, /* U+37eb */
  0x0000, /* U+37ec */
  0x0000, /* U+37ed */
  0x0000, /* U+37ee */
  0x0000, /* U+37ef */
  0x0000, /* U+37f0 */
  0x0000, /* U+37f1 */
  0x0000, /* U+37f2 */
  0x0000, /* U+37f3 */
  0x0000, /* U+37f4 */
  0x0000, /* U+37f5 */
  0x0000, /* U+37f6 */
  0x0000, /* U+37f7 */
  0x0000, /* U+37f8 */
  0x0000, /* U+37f9 */
  0x0000, /* U+37fa */
  0x0000, /* U+37fb */
  0x0000, /* U+37fc */
  0x0000, /* U+37fd */
  0x0000, /* U+37fe */
  0x0000, /* U+37ff */
  0x0000, /* U+3800 */
  0x0000, /* U+3801 */
  0x0000, /* U+3802 */
  0x0000, /* U+3803 */
  0x0000, /* U+3804 */
  0x0000, /* U+3805 */
  0x0000, /* U+3806 */
  0x0000, /* U+3807 */
  0x0000, /* U+3808 */
  0x0000, /* U+3809 */
  0x0000, /* U+380a */
  0x0000, /* U+380b */
  0x0000, /* U+380c */
  0x0000, /* U+380d */
  0x0000, /* U+380e */
  0x0000, /* U+380f */
  0x0000, /* U+3810 */
  0x0000, /* U+3811 */
  0x0000, /* U+3812 */
  0x0000, /* U+3813 */
  0x0000, /* U+3814 */
  0x0000, /* U+3815 */
  0x0000, /* U+3816 */
  0x0000, /* U+3817 */
  0x0000, /* U+3818 */
  0x0000, /* U+3819 */
  0x0000, /* U+381a */
  0x0000, /* U+381b */
  0x0000, /* U+381c */
  0x0000, /* U+381d */
  0x0000, /* U+381e */
  0x0000, /* U+381f */
  0x0000, /* U+3820 */
  0x0000, /* U+3821 */
  0x0000, /* U+3822 */
  0x0000, /* U+3823 */
  0x0000, /* U+3824 */
  0x0000, /* U+3825 */
  0x0000, /* U+3826 */
  0x0000, /* U+3827 */
  0x0000, /* U+3828 */
  0x0000, /* U+3829 */
  0x0000, /* U+382a */
  0x0000, /* U+382b */
  0x0000, /* U+382c */
  0x0000, /* U+382d */
  0x0000, /* U+382e */
  0x0000, /* U+382f */
  0x0000, /* U+3830 */
  0x0000, /* U+3831 */
  0x0000, /* U+3832 */
  0x0000, /* U+3833 */
  0x0000, /* U+3834 */
  0x0000, /* U+3835 */
  0x0000, /* U+3836 */
  0x0000, /* U+3837 */
  0x0000, /* U+3838 */
  0x0000, /* U+3839 */
  0x0000, /* U+383a */
  0x0000, /* U+383b */
  0x0000, /* U+383c */
  0x0000, /* U+383d */
  0x0000, /* U+383e */
  0x0000, /* U+383f */
  0x0000, /* U+3840 */
  0x0000, /* U+3841 */
  0x0000, /* U+3842 */
  0x0000, /* U+3843 */
  0x0000, /* U+3844 */
  0x0000, /* U+3845 */
  0x0000, /* U+3846 */
  0x0000, /* U+3847 */
  0x0000, /* U+3848 */
  0x0000, /* U+3849 */
  0x0000, /* U+384a */
  0x0000, /* U+384b */
  0x0000, /* U+384c */
  0x0000, /* U+384d */
  0x0000, /* U+384e */
  0x0000, /* U+384f */
  0x0000, /* U+3850 */
  0x0000, /* U+3851 */
  0x0000, /* U+3852 */
  0x0000, /* U+3853 */
  0x0000, /* U+3854 */
  0x0000, /* U+3855 */
  0x0000, /* U+3856 */
  0x0000, /* U+3857 */
  0x0000, /* U+3858 */
  0x0000, /* U+3859 */
  0x0000, /* U+385a */
  0x0000, /* U+385b */
  0x0000, /* U+385c */
  0x0000, /* U+385d */
  0x0000, /* U+385e */
  0x0000, /* U+385f */
  0x0000, /* U+3860 */
  0x0000, /* U+3861 */
  0x0000, /* U+3862 */
  0x0000, /* U+3863 */
  0x0000, /* U+3864 */
  0x0000, /* U+3865 */
  0x0000, /* U+3866 */
  0x0000, /* U+3867 */
  0x0000, /* U+3868 */
  0x0000, /* U+3869 */
  0x0000, /* U+386a */
  0x0000, /* U+386b */
  0x0000, /* U+386c */
  0x0000, /* U+386d */
  0x0000, /* U+386e */
  0x0000, /* U+386f */
  0x0000, /* U+3870 */
  0x0000, /* U+3871 */
  0x0000, /* U+3872 */
  0x0000, /* U+3873 */
  0x0000, /* U+3874 */
  0x0000, /* U+3875 */
  0x0000, /* U+3876 */
  0x0000, /* U+3877 */
  0x0000, /* U+3878 */
  0x0000, /* U+3879 */
  0x0000, /* U+387a */
  0x0000, /* U+387b */
  0x0000, /* U+387c */
  0x0000, /* U+387d */
  0x0000, /* U+387e */
  0x0000, /* U+387f */
  0x0000, /* U+3880 */
  0x0000, /* U+3881 */
  0x0000, /* U+3882 */
  0x0000, /* U+3883 */
  0x0000, /* U+3884 */
  0x0000, /* U+3885 */
  0x0000, /* U+3886 */
  0x0000, /* U+3887 */
  0x0000, /* U+3888 */
  0x0000, /* U+3889 */
  0x0000, /* U+388a */
  0x0000, /* U+388b */
  0x0000, /* U+388c */
  0x0000, /* U+388d */
  0x0000, /* U+388e */
  0x0000, /* U+388f */
  0x0000, /* U+3890 */
  0x0000, /* U+3891 */
  0x0000, /* U+3892 */
  0x0000, /* U+3893 */
  0x0000, /* U+3894 */
  0x0000, /* U+3895 */
  0x0000, /* U+3896 */
  0x0000, /* U+3897 */
  0x0000, /* U+3898 */
  0x0000, /* U+3899 */
  0x0000, /* U+389a */
  0x0000, /* U+389b */
  0x0000, /* U+389c */
  0x0000, /* U+389d */
  0x0000, /* U+389e */
  0x0000, /* U+389f */
  0x0000, /* U+38a0 */
  0x0000, /* U+38a1 */
  0x0000, /* U+38a2 */
  0x0000, /* U+38a3 */
  0x0000, /* U+38a4 */
  0x0000, /* U+38a5 */
  0x0000, /* U+38a6 */
  0x0000, /* U+38a7 */
  0x0000, /* U+38a8 */
  0x0000, /* U+38a9 */
  0x0000, /* U+38aa */
  0x0000, /* U+38ab */
  0x0000, /* U+38ac */
  0x0000, /* U+38ad */
  0x0000, /* U+38ae */
  0x0000, /* U+38af */
  0x0000, /* U+38b0 */
  0x0000, /* U+38b1 */
  0x0000, /* U+38b2 */
  0x0000, /* U+38b3 */
  0x0000, /* U+38b4 */
  0x0000, /* U+38b5 */
  0x0000, /* U+38b6 */
  0x0000, /* U+38b7 */
  0x0000, /* U+38b8 */
  0x0000, /* U+38b9 */
  0x0000, /* U+38ba */
  0x0000, /* U+38bb */
  0x0000, /* U+38bc */
  0x0000, /* U+38bd */
  0x0000, /* U+38be */
  0x0000, /* U+38bf */
  0x0000, /* U+38c0 */
  0x0000, /* U+38c1 */
  0x0000, /* U+38c2 */
  0x0000, /* U+38c3 */
  0x0000, /* U+38c4 */
  0x0000, /* U+38c5 */
  0x0000, /* U+38c6 */
  0x0000, /* U+38c7 */
  0x0000, /* U+38c8 */
  0x0000, /* U+38c9 */
  0x0000, /* U+38ca */
  0x0000, /* U+38cb */
  0x0000, /* U+38cc */
  0x0000, /* U+38cd */
  0x0000, /* U+38ce */
  0x0000, /* U+38cf */
  0x0000, /* U+38d0 */
  0x0000, /* U+38d1 */
  0x0000, /* U+38d2 */
  0x0000, /* U+38d3 */
  0x0000, /* U+38d4 */
  0x0000, /* U+38d5 */
  0x0000, /* U+38d6 */
  0x0000, /* U+38d7 */
  0x0000, /* U+38d8 */
  0x0000, /* U+38d9 */
  0x0000, /* U+38da */
  0x0000, /* U+38db */
  0x0000, /* U+38dc */
  0x0000, /* U+38dd */
  0x0000, /* U+38de */
  0x0000, /* U+38df */
  0x0000, /* U+38e0 */
  0x0000, /* U+38e1 */
  0x0000, /* U+38e2 */
  0x0000, /* U+38e3 */
  0x0000, /* U+38e4 */
  0x0000, /* U+38e5 */
  0x0000, /* U+38e6 */
  0x0000, /* U+38e7 */
  0x0000, /* U+38e8 */
  0x0000, /* U+38e9 */
  0x0000, /* U+38ea */
  0x0000, /* U+38eb */
  0x0000, /* U+38ec */
  0x0000, /* U+38ed */
  0x0000, /* U+38ee */
  0x0000, /* U+38ef */
  0x0000, /* U+38f0 */
  0x0000, /* U+38f1 */
  0x0000, /* U+38f2 */
  0x0000, /* U+38f3 */
  0x0000, /* U+38f4 */
  0x0000, /* U+38f5 */
  0x0000, /* U+38f6 */
  0x0000, /* U+38f7 */
  0x0000, /* U+38f8 */
  0x0000, /* U+38f9 */
  0x0000, /* U+38fa */
  0x0000, /* U+38fb */
  0x0000, /* U+38fc */
  0x0000, /* U+38fd */
  0x0000, /* U+38fe */
  0x0000, /* U+38ff */
  0x0000, /* U+3900 */
  0x0000, /* U+3901 */
  0x0000, /* U+3902 */
  0x0000, /* U+3903 */
  0x0000, /* U+3904 */
  0x0000, /* U+3905 */
  0x0000, /* U+3906 */
  0x0000, /* U+3907 */
  0x0000, /* U+3908 */
  0x0000, /* U+3909 */
  0x0000, /* U+390a */
  0x0000, /* U+390b */
  0x0000, /* U+390c */
  0x0000, /* U+390d */
  0x0000, /* U+390e */
  0x0000, /* U+390f */
  0x0000, /* U+3910 */
  0x0000, /* U+3911 */
  0x0000, /* U+3912 */
  0x0000, /* U+3913 */
  0x0000, /* U+3914 */
  0x0000, /* U+3915 */
  0x0000, /* U+3916 */
  0x0000, /* U+3917 */
  0x0000, /* U+3918 */
  0x0000, /* U+3919 */
  0x0000, /* U+391a */
  0x0000, /* U+391b */
  0x0000, /* U+391c */
  0x0000, /* U+391d */
  0x0000, /* U+391e */
  0x0000, /* U+391f */
  0x0000, /* U+3920 */
  0x0000, /* U+3921 */
  0x0000, /* U+3922 */
  0x0000, /* U+3923 */
  0x0000, /* U+3924 */
  0x0000, /* U+3925 */
  0x0000, /* U+3926 */
  0x0000, /* U+3927 */
  0x0000, /* U+3928 */
  0x0000, /* U+3929 */
  0x0000, /* U+392a */
  0x0000, /* U+392b */
  0x0000, /* U+392c */
  0x0000, /* U+392d */
  0x0000, /* U+392e */
  0x0000, /* U+392f */
  0x0000, /* U+3930 */
  0x0000, /* U+3931 */
  0x0000, /* U+3932 */
  0x0000, /* U+3933 */
  0x0000, /* U+3934 */
  0x0000, /* U+3935 */
  0x0000, /* U+3936 */
  0x0000, /* U+3937 */
  0x0000, /* U+3938 */
  0x0000, /* U+3939 */
  0x0000, /* U+393a */
  0x0000, /* U+393b */
  0x0000, /* U+393c */
  0x0000, /* U+393d */
  0x0000, /* U+393e */
  0x0000, /* U+393f */
  0x0000, /* U+3940 */
  0x0000, /* U+3941 */
  0x0000, /* U+3942 */
  0x0000, /* U+3943 */
  0x0000, /* U+3944 */
  0x0000, /* U+3945 */
  0x0000, /* U+3946 */
  0x0000, /* U+3947 */
  0x0000, /* U+3948 */
  0x0000, /* U+3949 */
  0x0000, /* U+394a */
  0x0000, /* U+394b */
  0x0000, /* U+394c */
  0x0000, /* U+394d */
  0x0000, /* U+394e */
  0x0000, /* U+394f */
  0x0000, /* U+3950 */
  0x0000, /* U+3951 */
  0x0000, /* U+3952 */
  0x0000, /* U+3953 */
  0x0000, /* U+3954 */
  0x0000, /* U+3955 */
  0x0000, /* U+3956 */
  0x0000, /* U+3957 */
  0x0000, /* U+3958 */
  0x0000, /* U+3959 */
  0x0000, /* U+395a */
  0x0000, /* U+395b */
  0x0000, /* U+395c */
  0x0000, /* U+395d */
  0x0000, /* U+395e */
  0x0000, /* U+395f */
  0x0000, /* U+3960 */
  0x0000, /* U+3961 */
  0x0000, /* U+3962 */
  0x0000, /* U+3963 */
  0x0000, /* U+3964 */
  0x0000, /* U+3965 */
  0x0000, /* U+3966 */
  0x0000, /* U+3967 */
  0x0000, /* U+3968 */
  0x0000, /* U+3969 */
  0x0000, /* U+396a */
  0x0000, /* U+396b */
  0x0000, /* U+396c */
  0x0000, /* U+396d */
  0x0000, /* U+396e */
  0x0000, /* U+396f */
  0x0000, /* U+3970 */
  0x0000, /* U+3971 */
  0x0000, /* U+3972 */
  0x0000, /* U+3973 */
  0x0000, /* U+3974 */
  0x0000, /* U+3975 */
  0x0000, /* U+3976 */
  0x0000, /* U+3977 */
  0x0000, /* U+3978 */
  0x0000, /* U+3979 */
  0x0000, /* U+397a */
  0x0000, /* U+397b */
  0x0000, /* U+397c */
  0x0000, /* U+397d */
  0x0000, /* U+397e */
  0x0000, /* U+397f */
  0x0000, /* U+3980 */
  0x0000, /* U+3981 */
  0x0000, /* U+3982 */
  0x0000, /* U+3983 */
  0x0000, /* U+3984 */
  0x0000, /* U+3985 */
  0x0000, /* U+3986 */
  0x0000, /* U+3987 */
  0x0000, /* U+3988 */
  0x0000, /* U+3989 */
  0x0000, /* U+398a */
  0x0000, /* U+398b */
  0x0000, /* U+398c */
  0x0000, /* U+398d */
  0x0000, /* U+398e */
  0x0000, /* U+398f */
  0x0000, /* U+3990 */
  0x0000, /* U+3991 */
  0x0000, /* U+3992 */
  0x0000, /* U+3993 */
  0x0000, /* U+3994 */
  0x0000, /* U+3995 */
  0x0000, /* U+3996 */
  0x0000, /* U+3997 */
  0x0000, /* U+3998 */
  0x0000, /* U+3999 */
  0x0000, /* U+399a */
  0x0000, /* U+399b */
  0x0000, /* U+399c */
  0x0000, /* U+399d */
  0x0000, /* U+399e */
  0x0000, /* U+399f */
  0x0000, /* U+39a0 */
  0x0000, /* U+39a1 */
  0x0000, /* U+39a2 */
  0x0000, /* U+39a3 */
  0x0000, /* U+39a4 */
  0x0000, /* U+39a5 */
  0x0000, /* U+39a6 */
  0x0000, /* U+39a7 */
  0x0000, /* U+39a8 */
  0x0000, /* U+39a9 */
  0x0000, /* U+39aa */
  0x0000, /* U+39ab */
  0x0000, /* U+39ac */
  0x0000, /* U+39ad */
  0x0000, /* U+39ae */
  0x0000, /* U+39af */
  0x0000, /* U+39b0 */
  0x0000, /* U+39b1 */
  0x0000, /* U+39b2 */
  0x0000, /* U+39b3 */
  0x0000, /* U+39b4 */
  0x0000, /* U+39b5 */
  0x0000, /* U+39b6 */
  0x0000, /* U+39b7 */
  0x0000, /* U+39b8 */
  0x0000, /* U+39b9 */
  0x0000, /* U+39ba */
  0x0000, /* U+39bb */
  0x0000, /* U+39bc */
  0x0000, /* U+39bd */
  0x0000, /* U+39be */
  0x0000, /* U+39bf */
  0x0000, /* U+39c0 */
  0x0000, /* U+39c1 */
  0x0000, /* U+39c2 */
  0x0000, /* U+39c3 */
  0x0000, /* U+39c4 */
  0x0000, /* U+39c5 */
  0x0000, /* U+39c6 */
  0x0000, /* U+39c7 */
  0x0000, /* U+39c8 */
  0x0000, /* U+39c9 */
  0x0000, /* U+39ca */
  0x0000, /* U+39cb */
  0x0000, /* U+39cc */
  0x0000, /* U+39cd */
  0x0000, /* U+39ce */
  0x0000, /* U+39cf */
  0x0000, /* U+39d0 */
  0x0000, /* U+39d1 */
  0x0000, /* U+39d2 */
  0x0000, /* U+39d3 */
  0x0000, /* U+39d4 */
  0x0000, /* U+39d5 */
  0x0000, /* U+39d6 */
  0x0000, /* U+39d7 */
  0x0000, /* U+39d8 */
  0x0000, /* U+39d9 */
  0x0000, /* U+39da */
  0x0000, /* U+39db */
  0x0000, /* U+39dc */
  0x0000, /* U+39dd */
  0x0000, /* U+39de */
  0x0000, /* U+39df */
  0x0000, /* U+39e0 */
  0x0000, /* U+39e1 */
  0x0000, /* U+39e2 */
  0x0000, /* U+39e3 */
  0x0000, /* U+39e4 */
  0x0000, /* U+39e5 */
  0x0000, /* U+39e6 */
  0x0000, /* U+39e7 */
  0x0000, /* U+39e8 */
  0x0000, /* U+39e9 */
  0x0000, /* U+39ea */
  0x0000, /* U+39eb */
  0x0000, /* U+39ec */
  0x0000, /* U+39ed */
  0x0000, /* U+39ee */
  0x0000, /* U+39ef */
  0x0000, /* U+39f0 */
  0x0000, /* U+39f1 */
  0x0000, /* U+39f2 */
  0x0000, /* U+39f3 */
  0x0000, /* U+39f4 */
  0x0000, /* U+39f5 */
  0x0000, /* U+39f6 */
  0x0000, /* U+39f7 */
  0x0000, /* U+39f8 */
  0x0000, /* U+39f9 */
  0x0000, /* U+39fa */
  0x0000, /* U+39fb */
  0x0000, /* U+39fc */
  0x0000, /* U+39fd */
  0x0000, /* U+39fe */
  0x0000, /* U+39ff */
  0x0000, /* U+3a00 */
  0x0000, /* U+3a01 */
  0x0000, /* U+3a02 */
  0x0000, /* U+3a03 */
  0x0000, /* U+3a04 */
  0x0000, /* U+3a05 */
  0x0000, /* U+3a06 */
  0x0000, /* U+3a07 */
  0x0000, /* U+3a08 */
  0x0000, /* U+3a09 */
  0x0000, /* U+3a0a */
  0x0000, /* U+3a0b */
  0x0000, /* U+3a0c */
  0x0000, /* U+3a0d */
  0x0000, /* U+3a0e */
  0x0000, /* U+3a0f */
  0x0000, /* U+3a10 */
  0x0000, /* U+3a11 */
  0x0000, /* U+3a12 */
  0x0000, /* U+3a13 */
  0x0000, /* U+3a14 */
  0x0000, /* U+3a15 */
  0x0000, /* U+3a16 */
  0x0000, /* U+3a17 */
  0x0000, /* U+3a18 */
  0x0000, /* U+3a19 */
  0x0000, /* U+3a1a */
  0x0000, /* U+3a1b */
  0x0000, /* U+3a1c */
  0x0000, /* U+3a1d */
  0x0000, /* U+3a1e */
  0x0000, /* U+3a1f */
  0x0000, /* U+3a20 */
  0x0000, /* U+3a21 */
  0x0000, /* U+3a22 */
  0x0000, /* U+3a23 */
  0x0000, /* U+3a24 */
  0x0000, /* U+3a25 */
  0x0000, /* U+3a26 */
  0x0000, /* U+3a27 */
  0x0000, /* U+3a28 */
  0x0000, /* U+3a29 */
  0x0000, /* U+3a2a */
  0x0000, /* U+3a2b */
  0x0000, /* U+3a2c */
  0x0000, /* U+3a2d */
  0x0000, /* U+3a2e */
  0x0000, /* U+3a2f */
  0x0000, /* U+3a30 */
  0x0000, /* U+3a31 */
  0x0000, /* U+3a32 */
  0x0000, /* U+3a33 */
  0x0000, /* U+3a34 */
  0x0000, /* U+3a35 */
  0x0000, /* U+3a36 */
  0x0000, /* U+3a37 */
  0x0000, /* U+3a38 */
  0x0000, /* U+3a39 */
  0x0000, /* U+3a3a */
  0x0000, /* U+3a3b */
  0x0000, /* U+3a3c */
  0x0000, /* U+3a3d */
  0x0000, /* U+3a3e */
  0x0000, /* U+3a3f */
  0x0000, /* U+3a40 */
  0x0000, /* U+3a41 */
  0x0000, /* U+3a42 */
  0x0000, /* U+3a43 */
  0x0000, /* U+3a44 */
  0x0000, /* U+3a45 */
  0x0000, /* U+3a46 */
  0x0000, /* U+3a47 */
  0x0000, /* U+3a48 */
  0x0000, /* U+3a49 */
  0x0000, /* U+3a4a */
  0x0000, /* U+3a4b */
  0x0000, /* U+3a4c */
  0x0000, /* U+3a4d */
  0x0000, /* U+3a4e */
  0x0000, /* U+3a4f */
  0x0000, /* U+3a50 */
  0x0000, /* U+3a51 */
  0x0000, /* U+3a52 */
  0x0000, /* U+3a53 */
  0x0000, /* U+3a54 */
  0x0000, /* U+3a55 */
  0x0000, /* U+3a56 */
  0x0000, /* U+3a57 */
  0x0000, /* U+3a58 */
  0x0000, /* U+3a59 */
  0x0000, /* U+3a5a */
  0x0000, /* U+3a5b */
  0x0000, /* U+3a5c */
  0x0000, /* U+3a5d */
  0x0000, /* U+3a5e */
  0x0000, /* U+3a5f */
  0x0000, /* U+3a60 */
  0x0000, /* U+3a61 */
  0x0000, /* U+3a62 */
  0x0000, /* U+3a63 */
  0x0000, /* U+3a64 */
  0x0000, /* U+3a65 */
  0x0000, /* U+3a66 */
  0x0000, /* U+3a67 */
  0x0000, /* U+3a68 */
  0x0000, /* U+3a69 */
  0x0000, /* U+3a6a */
  0x0000, /* U+3a6b */
  0x0000, /* U+3a6c */
  0x0000, /* U+3a6d */
  0x0000, /* U+3a6e */
  0x0000, /* U+3a6f */
  0x0000, /* U+3a70 */
  0x0000, /* U+3a71 */
  0x0000, /* U+3a72 */
  0x0000, /* U+3a73 */
  0x0000, /* U+3a74 */
  0x0000, /* U+3a75 */
  0x0000, /* U+3a76 */
  0x0000, /* U+3a77 */
  0x0000, /* U+3a78 */
  0x0000, /* U+3a79 */
  0x0000, /* U+3a7a */
  0x0000, /* U+3a7b */
  0x0000, /* U+3a7c */
  0x0000, /* U+3a7d */
  0x0000, /* U+3a7e */
  0x0000, /* U+3a7f */
  0x0000, /* U+3a80 */
  0x0000, /* U+3a81 */
  0x0000, /* U+3a82 */
  0x0000, /* U+3a83 */
  0x0000, /* U+3a84 */
  0x0000, /* U+3a85 */
  0x0000, /* U+3a86 */
  0x0000, /* U+3a87 */
  0x0000, /* U+3a88 */
  0x0000, /* U+3a89 */
  0x0000, /* U+3a8a */
  0x0000, /* U+3a8b */
  0x0000, /* U+3a8c */
  0x0000, /* U+3a8d */
  0x0000, /* U+3a8e */
  0x0000, /* U+3a8f */
  0x0000, /* U+3a90 */
  0x0000, /* U+3a91 */
  0x0000, /* U+3a92 */
  0x0000, /* U+3a93 */
  0x0000, /* U+3a94 */
  0x0000, /* U+3a95 */
  0x0000, /* U+3a96 */
  0x0000, /* U+3a97 */
  0x0000, /* U+3a98 */
  0x0000, /* U+3a99 */
  0x0000, /* U+3a9a */
  0x0000, /* U+3a9b */
  0x0000, /* U+3a9c */
  0x0000, /* U+3a9d */
  0x0000, /* U+3a9e */
  0x0000, /* U+3a9f */
  0x0000, /* U+3aa0 */
  0x0000, /* U+3aa1 */
  0x0000, /* U+3aa2 */
  0x0000, /* U+3aa3 */
  0x0000, /* U+3aa4 */
  0x0000, /* U+3aa5 */
  0x0000, /* U+3aa6 */
  0x0000, /* U+3aa7 */
  0x0000, /* U+3aa8 */
  0x0000, /* U+3aa9 */
  0x0000, /* U+3aaa */
  0x0000, /* U+3aab */
  0x0000, /* U+3aac */
  0x0000, /* U+3aad */
  0x0000, /* U+3aae */
  0x0000, /* U+3aaf */
  0x0000, /* U+3ab0 */
  0x0000, /* U+3ab1 */
  0x0000, /* U+3ab2 */
  0x0000, /* U+3ab3 */
  0x0000, /* U+3ab4 */
  0x0000, /* U+3ab5 */
  0x0000, /* U+3ab6 */
  0x0000, /* U+3ab7 */
  0x0000, /* U+3ab8 */
  0x0000, /* U+3ab9 */
  0x0000, /* U+3aba */
  0x0000, /* U+3abb */
  0x0000, /* U+3abc */
  0x0000, /* U+3abd */
  0x0000, /* U+3abe */
  0x0000, /* U+3abf */
  0x0000, /* U+3ac0 */
  0x0000, /* U+3ac1 */
  0x0000, /* U+3ac2 */
  0x0000, /* U+3ac3 */
  0x0000, /* U+3ac4 */
  0x0000, /* U+3ac5 */
  0x0000, /* U+3ac6 */
  0x0000, /* U+3ac7 */
  0x0000, /* U+3ac8 */
  0x0000, /* U+3ac9 */
  0x0000, /* U+3aca */
  0x0000, /* U+3acb */
  0x0000, /* U+3acc */
  0x0000, /* U+3acd */
  0x0000, /* U+3ace */
  0x0000, /* U+3acf */
  0x0000, /* U+3ad0 */
  0x0000, /* U+3ad1 */
  0x0000, /* U+3ad2 */
  0x0000, /* U+3ad3 */
  0x0000, /* U+3ad4 */
  0x0000, /* U+3ad5 */
  0x0000, /* U+3ad6 */
  0x0000, /* U+3ad7 */
  0x0000, /* U+3ad8 */
  0x0000, /* U+3ad9 */
  0x0000, /* U+3ada */
  0x0000, /* U+3adb */
  0x0000, /* U+3adc */
  0x0000, /* U+3add */
  0x0000, /* U+3ade */
  0x0000, /* U+3adf */
  0x0000, /* U+3ae0 */
  0x0000, /* U+3ae1 */
  0x0000, /* U+3ae2 */
  0x0000, /* U+3ae3 */
  0x0000, /* U+3ae4 */
  0x0000, /* U+3ae5 */
  0x0000, /* U+3ae6 */
  0x0000, /* U+3ae7 */
  0x0000, /* U+3ae8 */
  0x0000, /* U+3ae9 */
  0x0000, /* U+3aea */
  0x0000, /* U+3aeb */
  0x0000, /* U+3aec */
  0x0000, /* U+3aed */
  0x0000, /* U+3aee */
  0x0000, /* U+3aef */
  0x0000, /* U+3af0 */
  0x0000, /* U+3af1 */
  0x0000, /* U+3af2 */
  0x0000, /* U+3af3 */
  0x0000, /* U+3af4 */
  0x0000, /* U+3af5 */
  0x0000, /* U+3af6 */
  0x0000, /* U+3af7 */
  0x0000, /* U+3af8 */
  0x0000, /* U+3af9 */
  0x0000, /* U+3afa */
  0x0000, /* U+3afb */
  0x0000, /* U+3afc */
  0x0000, /* U+3afd */
  0x0000, /* U+3afe */
  0x0000, /* U+3aff */
  0x0000, /* U+3b00 */
  0x0000, /* U+3b01 */
  0x0000, /* U+3b02 */
  0x0000, /* U+3b03 */
  0x0000, /* U+3b04 */
  0x0000, /* U+3b05 */
  0x0000, /* U+3b06 */
  0x0000, /* U+3b07 */
  0x0000, /* U+3b08 */
  0x0000, /* U+3b09 */
  0x0000, /* U+3b0a */
  0x0000, /* U+3b0b */
  0x0000, /* U+3b0c */
  0x0000, /* U+3b0d */
  0x0000, /* U+3b0e */
  0x0000, /* U+3b0f */
  0x0000, /* U+3b10 */
  0x0000, /* U+3b11 */
  0x0000, /* U+3b12 */
  0x0000, /* U+3b13 */
  0x0000, /* U+3b14 */
  0x0000, /* U+3b15 */
  0x0000, /* U+3b16 */
  0x0000, /* U+3b17 */
  0x0000, /* U+3b18 */
  0x0000, /* U+3b19 */
  0x0000, /* U+3b1a */
  0x0000, /* U+3b1b */
  0x0000, /* U+3b1c */
  0x0000, /* U+3b1d */
  0x0000, /* U+3b1e */
  0x0000, /* U+3b1f */
  0x0000, /* U+3b20 */
  0x0000, /* U+3b21 */
  0x0000, /* U+3b22 */
  0x0000, /* U+3b23 */
  0x0000, /* U+3b24 */
  0x0000, /* U+3b25 */
  0x0000, /* U+3b26 */
  0x0000, /* U+3b27 */
  0x0000, /* U+3b28 */
  0x0000, /* U+3b29 */
  0x0000, /* U+3b2a */
  0x0000, /* U+3b2b */
  0x0000, /* U+3b2c */
  0x0000, /* U+3b2d */
  0x0000, /* U+3b2e */
  0x0000, /* U+3b2f */
  0x0000, /* U+3b30 */
  0x0000, /* U+3b31 */
  0x0000, /* U+3b32 */
  0x0000, /* U+3b33 */
  0x0000, /* U+3b34 */
  0x0000, /* U+3b35 */
  0x0000, /* U+3b36 */
  0x0000, /* U+3b37 */
  0x0000, /* U+3b38 */
  0x0000, /* U+3b39 */
  0x0000, /* U+3b3a */
  0x0000, /* U+3b3b */
  0x0000, /* U+3b3c */
  0x0000, /* U+3b3d */
  0x0000, /* U+3b3e */
  0x0000, /* U+3b3f */
  0x0000, /* U+3b40 */
  0x0000, /* U+3b41 */
  0x0000, /* U+3b42 */
  0x0000, /* U+3b43 */
  0x0000, /* U+3b44 */
  0x0000, /* U+3b45 */
  0x0000, /* U+3b46 */
  0x0000, /* U+3b47 */
  0x0000, /* U+3b48 */
  0x0000, /* U+3b49 */
  0x0000, /* U+3b4a */
  0x0000, /* U+3b4b */
  0x0000, /* U+3b4c */
  0x0000, /* U+3b4d */
  0x0000, /* U+3b4e */
  0x0000, /* U+3b4f */
  0x0000, /* U+3b50 */
  0x0000, /* U+3b51 */
  0x0000, /* U+3b52 */
  0x0000, /* U+3b53 */
  0x0000, /* U+3b54 */
  0x0000, /* U+3b55 */
  0x0000, /* U+3b56 */
  0x0000, /* U+3b57 */
  0x0000, /* U+3b58 */
  0x0000, /* U+3b59 */
  0x0000, /* U+3b5a */
  0x0000, /* U+3b5b */
  0x0000, /* U+3b5c */
  0x0000, /* U+3b5d */
  0x0000, /* U+3b5e */
  0x0000, /* U+3b5f */
  0x0000, /* U+3b60 */
  0x0000, /* U+3b61 */
  0x0000, /* U+3b62 */
  0x0000, /* U+3b63 */
  0x0000, /* U+3b64 */
  0x0000, /* U+3b65 */
  0x0000, /* U+3b66 */
  0x0000, /* U+3b67 */
  0x0000, /* U+3b68 */
  0x0000, /* U+3b69 */
  0x0000, /* U+3b6a */
  0x0000, /* U+3b6b */
  0x0000, /* U+3b6c */
  0x0000, /* U+3b6d */
  0x0000, /* U+3b6e */
  0x0000, /* U+3b6f */
  0x0000, /* U+3b70 */
  0x0000, /* U+3b71 */
  0x0000, /* U+3b72 */
  0x0000, /* U+3b73 */
  0x0000, /* U+3b74 */
  0x0000, /* U+3b75 */
  0x0000, /* U+3b76 */
  0x0000, /* U+3b77 */
  0x0000, /* U+3b78 */
  0x0000, /* U+3b79 */
  0x0000, /* U+3b7a */
  0x0000, /* U+3b7b */
  0x0000, /* U+3b7c */
  0x0000, /* U+3b7d */
  0x0000, /* U+3b7e */
  0x0000, /* U+3b7f */
  0x0000, /* U+3b80 */
  0x0000, /* U+3b81 */
  0x0000, /* U+3b82 */
  0x0000, /* U+3b83 */
  0x0000, /* U+3b84 */
  0x0000, /* U+3b85 */
  0x0000, /* U+3b86 */
  0x0000, /* U+3b87 */
  0x0000, /* U+3b88 */
  0x0000, /* U+3b89 */
  0x0000, /* U+3b8a */
  0x0000, /* U+3b8b */
  0x0000, /* U+3b8c */
  0x0000, /* U+3b8d */
  0x0000, /* U+3b8e */
  0x0000, /* U+3b8f */
  0x0000, /* U+3b90 */
  0x0000, /* U+3b91 */
  0x0000, /* U+3b92 */
  0x0000, /* U+3b93 */
  0x0000, /* U+3b94 */
  0x0000, /* U+3b95 */
  0x0000, /* U+3b96 */
  0x0000, /* U+3b97 */
  0x0000, /* U+3b98 */
  0x0000, /* U+3b99 */
  0x0000, /* U+3b9a */
  0x0000, /* U+3b9b */
  0x0000, /* U+3b9c */
  0x0000, /* U+3b9d */
  0x0000, /* U+3b9e */
  0x0000, /* U+3b9f */
  0x0000, /* U+3ba0 */
  0x0000, /* U+3ba1 */
  0x0000, /* U+3ba2 */
  0x0000, /* U+3ba3 */
  0x0000, /* U+3ba4 */
  0x0000, /* U+3ba5 */
  0x0000, /* U+3ba6 */
  0x0000, /* U+3ba7 */
  0x0000, /* U+3ba8 */
  0x0000, /* U+3ba9 */
  0x0000, /* U+3baa */
  0x0000, /* U+3bab */
  0x0000, /* U+3bac */
  0x0000, /* U+3bad */
  0x0000, /* U+3bae */
  0x0000, /* U+3baf */
  0x0000, /* U+3bb0 */
  0x0000, /* U+3bb1 */
  0x0000, /* U+3bb2 */
  0x0000, /* U+3bb3 */
  0x0000, /* U+3bb4 */
  0x0000, /* U+3bb5 */
  0x0000, /* U+3bb6 */
  0x0000, /* U+3bb7 */
  0x0000, /* U+3bb8 */
  0x0000, /* U+3bb9 */
  0x0000, /* U+3bba */
  0x0000, /* U+3bbb */
  0x0000, /* U+3bbc */
  0x0000, /* U+3bbd */
  0x0000, /* U+3bbe */
  0x0000, /* U+3bbf */
  0x0000, /* U+3bc0 */
  0x0000, /* U+3bc1 */
  0x0000, /* U+3bc2 */
  0x0000, /* U+3bc3 */
  0x0000, /* U+3bc4 */
  0x0000, /* U+3bc5 */
  0x0000, /* U+3bc6 */
  0x0000, /* U+3bc7 */
  0x0000, /* U+3bc8 */
  0x0000, /* U+3bc9 */
  0x0000, /* U+3bca */
  0x0000, /* U+3bcb */
  0x0000, /* U+3bcc */
  0x0000, /* U+3bcd */
  0x0000, /* U+3bce */
  0x0000, /* U+3bcf */
  0x0000, /* U+3bd0 */
  0x0000, /* U+3bd1 */
  0x0000, /* U+3bd2 */
  0x0000, /* U+3bd3 */
  0x0000, /* U+3bd4 */
  0x0000, /* U+3bd5 */
  0x0000, /* U+3bd6 */
  0x0000, /* U+3bd7 */
  0x0000, /* U+3bd8 */
  0x0000, /* U+3bd9 */
  0x0000, /* U+3bda */
  0x0000, /* U+3bdb */
  0x0000, /* U+3bdc */
  0x0000, /* U+3bdd */
  0x0000, /* U+3bde */
  0x0000, /* U+3bdf */
  0x0000, /* U+3be0 */
  0x0000, /* U+3be1 */
  0x0000, /* U+3be2 */
  0x0000, /* U+3be3 */
  0x0000, /* U+3be4 */
  0x0000, /* U+3be5 */
  0x0000, /* U+3be6 */
  0x0000, /* U+3be7 */
  0x0000, /* U+3be8 */
  0x0000, /* U+3be9 */
  0x0000, /* U+3bea */
  0x0000, /* U+3beb */
  0x0000, /* U+3bec */
  0x0000, /* U+3bed */
  0x0000, /* U+3bee */
  0x0000, /* U+3bef */
  0x0000, /* U+3bf0 */
  0x0000, /* U+3bf1 */
  0x0000, /* U+3bf2 */
  0x0000, /* U+3bf3 */
  0x0000, /* U+3bf4 */
  0x0000, /* U+3bf5 */
  0x0000, /* U+3bf6 */
  0x0000, /* U+3bf7 */
  0x0000, /* U+3bf8 */
  0x0000, /* U+3bf9 */
  0x0000, /* U+3bfa */
  0x0000, /* U+3bfb */
  0x0000, /* U+3bfc */
  0x0000, /* U+3bfd */
  0x0000, /* U+3bfe */
  0x0000, /* U+3bff */
  0x0000, /* U+3c00 */
  0x0000, /* U+3c01 */
  0x0000, /* U+3c02 */
  0x0000, /* U+3c03 */
  0x0000, /* U+3c04 */
  0x0000, /* U+3c05 */
  0x0000, /* U+3c06 */
  0x0000, /* U+3c07 */
  0x0000, /* U+3c08 */
  0x0000, /* U+3c09 */
  0x0000, /* U+3c0a */
  0x0000, /* U+3c0b */
  0x0000, /* U+3c0c */
  0x0000, /* U+3c0d */
  0x0000, /* U+3c0e */
  0x0000, /* U+3c0f */
  0x0000, /* U+3c10 */
  0x0000, /* U+3c11 */
  0x0000, /* U+3c12 */
  0x0000, /* U+3c13 */
  0x0000, /* U+3c14 */
  0x0000, /* U+3c15 */
  0x0000, /* U+3c16 */
  0x0000, /* U+3c17 */
  0x0000, /* U+3c18 */
  0x0000, /* U+3c19 */
  0x0000, /* U+3c1a */
  0x0000, /* U+3c1b */
  0x0000, /* U+3c1c */
  0x0000, /* U+3c1d */
  0x0000, /* U+3c1e */
  0x0000, /* U+3c1f */
  0x0000, /* U+3c20 */
  0x0000, /* U+3c21 */
  0x0000, /* U+3c22 */
  0x0000, /* U+3c23 */
  0x0000, /* U+3c24 */
  0x0000, /* U+3c25 */
  0x0000, /* U+3c26 */
  0x0000, /* U+3c27 */
  0x0000, /* U+3c28 */
  0x0000, /* U+3c29 */
  0x0000, /* U+3c2a */
  0x0000, /* U+3c2b */
  0x0000, /* U+3c2c */
  0x0000, /* U+3c2d */
  0x0000, /* U+3c2e */
  0x0000, /* U+3c2f */
  0x0000, /* U+3c30 */
  0x0000, /* U+3c31 */
  0x0000, /* U+3c32 */
  0x0000, /* U+3c33 */
  0x0000, /* U+3c34 */
  0x0000, /* U+3c35 */
  0x0000, /* U+3c36 */
  0x0000, /* U+3c37 */
  0x0000, /* U+3c38 */
  0x0000, /* U+3c39 */
  0x0000, /* U+3c3a */
  0x0000, /* U+3c3b */
  0x0000, /* U+3c3c */
  0x0000, /* U+3c3d */
  0x0000, /* U+3c3e */
  0x0000, /* U+3c3f */
  0x0000, /* U+3c40 */
  0x0000, /* U+3c41 */
  0x0000, /* U+3c42 */
  0x0000, /* U+3c43 */
  0x0000, /* U+3c44 */
  0x0000, /* U+3c45 */
  0x0000, /* U+3c46 */
  0x0000, /* U+3c47 */
  0x0000, /* U+3c48 */
  0x0000, /* U+3c49 */
  0x0000, /* U+3c4a */
  0x0000, /* U+3c4b */
  0x0000, /* U+3c4c */
  0x0000, /* U+3c4d */
  0x0000, /* U+3c4e */
  0x0000, /* U+3c4f */
  0x0000, /* U+3c50 */
  0x0000, /* U+3c51 */
  0x0000, /* U+3c52 */
  0x0000, /* U+3c53 */
  0x0000, /* U+3c54 */
  0x0000, /* U+3c55 */
  0x0000, /* U+3c56 */
  0x0000, /* U+3c57 */
  0x0000, /* U+3c58 */
  0x0000, /* U+3c59 */
  0x0000, /* U+3c5a */
  0x0000, /* U+3c5b */
  0x0000, /* U+3c5c */
  0x0000, /* U+3c5d */
  0x0000, /* U+3c5e */
  0x0000, /* U+3c5f */
  0x0000, /* U+3c60 */
  0x0000, /* U+3c61 */
  0x0000, /* U+3c62 */
  0x0000, /* U+3c63 */
  0x0000, /* U+3c64 */
  0x0000, /* U+3c65 */
  0x0000, /* U+3c66 */
  0x0000, /* U+3c67 */
  0x0000, /* U+3c68 */
  0x0000, /* U+3c69 */
  0x0000, /* U+3c6a */
  0x0000, /* U+3c6b */
  0x0000, /* U+3c6c */
  0x0000, /* U+3c6d */
  0x0000, /* U+3c6e */
  0x0000, /* U+3c6f */
  0x0000, /* U+3c70 */
  0x0000, /* U+3c71 */
  0x0000, /* U+3c72 */
  0x0000, /* U+3c73 */
  0x0000, /* U+3c74 */
  0x0000, /* U+3c75 */
  0x0000, /* U+3c76 */
  0x0000, /* U+3c77 */
  0x0000, /* U+3c78 */
  0x0000, /* U+3c79 */
  0x0000, /* U+3c7a */
  0x0000, /* U+3c7b */
  0x0000, /* U+3c7c */
  0x0000, /* U+3c7d */
  0x0000, /* U+3c7e */
  0x0000, /* U+3c7f */
  0x0000, /* U+3c80 */
  0x0000, /* U+3c81 */
  0x0000, /* U+3c82 */
  0x0000, /* U+3c83 */
  0x0000, /* U+3c84 */
  0x0000, /* U+3c85 */
  0x0000, /* U+3c86 */
  0x0000, /* U+3c87 */
  0x0000, /* U+3c88 */
  0x0000, /* U+3c89 */
  0x0000, /* U+3c8a */
  0x0000, /* U+3c8b */
  0x0000, /* U+3c8c */
  0x0000, /* U+3c8d */
  0x0000, /* U+3c8e */
  0x0000, /* U+3c8f */
  0x0000, /* U+3c90 */
  0x0000, /* U+3c91 */
  0x0000, /* U+3c92 */
  0x0000, /* U+3c93 */
  0x0000, /* U+3c94 */
  0x0000, /* U+3c95 */
  0x0000, /* U+3c96 */
  0x0000, /* U+3c97 */
  0x0000, /* U+3c98 */
  0x0000, /* U+3c99 */
  0x0000, /* U+3c9a */
  0x0000, /* U+3c9b */
  0x0000, /* U+3c9c */
  0x0000, /* U+3c9d */
  0x0000, /* U+3c9e */
  0x0000, /* U+3c9f */
  0x0000, /* U+3ca0 */
  0x0000, /* U+3ca1 */
  0x0000, /* U+3ca2 */
  0x0000, /* U+3ca3 */
  0x0000, /* U+3ca4 */
  0x0000, /* U+3ca5 */
  0x0000, /* U+3ca6 */
  0x0000, /* U+3ca7 */
  0x0000, /* U+3ca8 */
  0x0000, /* U+3ca9 */
  0x0000, /* U+3caa */
  0x0000, /* U+3cab */
  0x0000, /* U+3cac */
  0x0000, /* U+3cad */
  0x0000, /* U+3cae */
  0x0000, /* U+3caf */
  0x0000, /* U+3cb0 */
  0x0000, /* U+3cb1 */
  0x0000, /* U+3cb2 */
  0x0000, /* U+3cb3 */
  0x0000, /* U+3cb4 */
  0x0000, /* U+3cb5 */
  0x0000, /* U+3cb6 */
  0x0000, /* U+3cb7 */
  0x0000, /* U+3cb8 */
  0x0000, /* U+3cb9 */
  0x0000, /* U+3cba */
  0x0000, /* U+3cbb */
  0x0000, /* U+3cbc */
  0x0000, /* U+3cbd */
  0x0000, /* U+3cbe */
  0x0000, /* U+3cbf */
  0x0000, /* U+3cc0 */
  0x0000, /* U+3cc1 */
  0x0000, /* U+3cc2 */
  0x0000, /* U+3cc3 */
  0x0000, /* U+3cc4 */
  0x0000, /* U+3cc5 */
  0x0000, /* U+3cc6 */
  0x0000, /* U+3cc7 */
  0x0000, /* U+3cc8 */
  0x0000, /* U+3cc9 */
  0x0000, /* U+3cca */
  0x0000, /* U+3ccb */
  0x0000, /* U+3ccc */
  0x0000, /* U+3ccd */
  0x0000, /* U+3cce */
  0x0000, /* U+3ccf */
  0x0000, /* U+3cd0 */
  0x0000, /* U+3cd1 */
  0x0000, /* U+3cd2 */
  0x0000, /* U+3cd3 */
  0x0000, /* U+3cd4 */
  0x0000, /* U+3cd5 */
  0x0000, /* U+3cd6 */
  0x0000, /* U+3cd7 */
  0x0000, /* U+3cd8 */
  0x0000, /* U+3cd9 */
  0x0000, /* U+3cda */
  0x0000, /* U+3cdb */
  0x0000, /* U+3cdc */
  0x0000, /* U+3cdd */
  0x0000, /* U+3cde */
  0x0000, /* U+3cdf */
  0x0000, /* U+3ce0 */
  0x0000, /* U+3ce1 */
  0x0000, /* U+3ce2 */
  0x0000, /* U+3ce3 */
  0x0000, /* U+3ce4 */
  0x0000, /* U+3ce5 */
  0x0000, /* U+3ce6 */
  0x0000, /* U+3ce7 */
  0x0000, /* U+3ce8 */
  0x0000, /* U+3ce9 */
  0x0000, /* U+3cea */
  0x0000, /* U+3ceb */
  0x0000, /* U+3cec */
  0x0000, /* U+3ced */
  0x0000, /* U+3cee */
  0x0000, /* U+3cef */
  0x0000, /* U+3cf0 */
  0x0000, /* U+3cf1 */
  0x0000, /* U+3cf2 */
  0x0000, /* U+3cf3 */
  0x0000, /* U+3cf4 */
  0x0000, /* U+3cf5 */
  0x0000, /* U+3cf6 */
  0x0000, /* U+3cf7 */
  0x0000, /* U+3cf8 */
  0x0000, /* U+3cf9 */
  0x0000, /* U+3cfa */
  0x0000, /* U+3cfb */
  0x0000, /* U+3cfc */
  0x0000, /* U+3cfd */
  0x0000, /* U+3cfe */
  0x0000, /* U+3cff */
  0x0000, /* U+3d00 */
  0x0000, /* U+3d01 */
  0x0000, /* U+3d02 */
  0x0000, /* U+3d03 */
  0x0000, /* U+3d04 */
  0x0000, /* U+3d05 */
  0x0000, /* U+3d06 */
  0x0000, /* U+3d07 */
  0x0000, /* U+3d08 */
  0x0000, /* U+3d09 */
  0x0000, /* U+3d0a */
  0x0000, /* U+3d0b */
  0x0000, /* U+3d0c */
  0x0000, /* U+3d0d */
  0x0000, /* U+3d0e */
  0x0000, /* U+3d0f */
  0x0000, /* U+3d10 */
  0x0000, /* U+3d11 */
  0x0000, /* U+3d12 */
  0x0000, /* U+3d13 */
  0x0000, /* U+3d14 */
  0x0000, /* U+3d15 */
  0x0000, /* U+3d16 */
  0x0000, /* U+3d17 */
  0x0000, /* U+3d18 */
  0x0000, /* U+3d19 */
  0x0000, /* U+3d1a */
  0x0000, /* U+3d1b */
  0x0000, /* U+3d1c */
  0x0000, /* U+3d1d */
  0x0000, /* U+3d1e */
  0x0000, /* U+3d1f */
  0x0000, /* U+3d20 */
  0x0000, /* U+3d21 */
  0x0000, /* U+3d22 */
  0x0000, /* U+3d23 */
  0x0000, /* U+3d24 */
  0x0000, /* U+3d25 */
  0x0000, /* U+3d26 */
  0x0000, /* U+3d27 */
  0x0000, /* U+3d28 */
  0x0000, /* U+3d29 */
  0x0000, /* U+3d2a */
  0x0000, /* U+3d2b */
  0x0000, /* U+3d2c */
  0x0000, /* U+3d2d */
  0x0000, /* U+3d2e */
  0x0000, /* U+3d2f */
  0x0000, /* U+3d30 */
  0x0000, /* U+3d31 */
  0x0000, /* U+3d32 */
  0x0000, /* U+3d33 */
  0x0000, /* U+3d34 */
  0x0000, /* U+3d35 */
  0x0000, /* U+3d36 */
  0x0000, /* U+3d37 */
  0x0000, /* U+3d38 */
  0x0000, /* U+3d39 */
  0x0000, /* U+3d3a */
  0x0000, /* U+3d3b */
  0x0000, /* U+3d3c */
  0x0000, /* U+3d3d */
  0x0000, /* U+3d3e */
  0x0000, /* U+3d3f */
  0x0000, /* U+3d40 */
  0x0000, /* U+3d41 */
  0x0000, /* U+3d42 */
  0x0000, /* U+3d43 */
  0x0000, /* U+3d44 */
  0x0000, /* U+3d45 */
  0x0000, /* U+3d46 */
  0x0000, /* U+3d47 */
  0x0000, /* U+3d48 */
  0x0000, /* U+3d49 */
  0x0000, /* U+3d4a */
  0x0000, /* U+3d4b */
  0x0000, /* U+3d4c */
  0x0000, /* U+3d4d */
  0x0000, /* U+3d4e */
  0x0000, /* U+3d4f */
  0x0000, /* U+3d50 */
  0x0000, /* U+3d51 */
  0x0000, /* U+3d52 */
  0x0000, /* U+3d53 */
  0x0000, /* U+3d54 */
  0x0000, /* U+3d55 */
  0x0000, /* U+3d56 */
  0x0000, /* U+3d57 */
  0x0000, /* U+3d58 */
  0x0000, /* U+3d59 */
  0x0000, /* U+3d5a */
  0x0000, /* U+3d5b */
  0x0000, /* U+3d5c */
  0x0000, /* U+3d5d */
  0x0000, /* U+3d5e */
  0x0000, /* U+3d5f */
  0x0000, /* U+3d60 */
  0x0000, /* U+3d61 */
  0x0000, /* U+3d62 */
  0x0000, /* U+3d63 */
  0x0000, /* U+3d64 */
  0x0000, /* U+3d65 */
  0x0000, /* U+3d66 */
  0x0000, /* U+3d67 */
  0x0000, /* U+3d68 */
  0x0000, /* U+3d69 */
  0x0000, /* U+3d6a */
  0x0000, /* U+3d6b */
  0x0000, /* U+3d6c */
  0x0000, /* U+3d6d */
  0x0000, /* U+3d6e */
  0x0000, /* U+3d6f */
  0x0000, /* U+3d70 */
  0x0000, /* U+3d71 */
  0x0000, /* U+3d72 */
  0x0000, /* U+3d73 */
  0x0000, /* U+3d74 */
  0x0000, /* U+3d75 */
  0x0000, /* U+3d76 */
  0x0000, /* U+3d77 */
  0x0000, /* U+3d78 */
  0x0000, /* U+3d79 */
  0x0000, /* U+3d7a */
  0x0000, /* U+3d7b */
  0x0000, /* U+3d7c */
  0x0000, /* U+3d7d */
  0x0000, /* U+3d7e */
  0x0000, /* U+3d7f */
  0x0000, /* U+3d80 */
  0x0000, /* U+3d81 */
  0x0000, /* U+3d82 */
  0x0000, /* U+3d83 */
  0x0000, /* U+3d84 */
  0x0000, /* U+3d85 */
  0x0000, /* U+3d86 */
  0x0000, /* U+3d87 */
  0x0000, /* U+3d88 */
  0x0000, /* U+3d89 */
  0x0000, /* U+3d8a */
  0x0000, /* U+3d8b */
  0x0000, /* U+3d8c */
  0x0000, /* U+3d8d */
  0x0000, /* U+3d8e */
  0x0000, /* U+3d8f */
  0x0000, /* U+3d90 */
  0x0000, /* U+3d91 */
  0x0000, /* U+3d92 */
  0x0000, /* U+3d93 */
  0x0000, /* U+3d94 */
  0x0000, /* U+3d95 */
  0x0000, /* U+3d96 */
  0x0000, /* U+3d97 */
  0x0000, /* U+3d98 */
  0x0000, /* U+3d99 */
  0x0000, /* U+3d9a */
  0x0000, /* U+3d9b */
  0x0000, /* U+3d9c */
  0x0000, /* U+3d9d */
  0x0000, /* U+3d9e */
  0x0000, /* U+3d9f */
  0x0000, /* U+3da0 */
  0x0000, /* U+3da1 */
  0x0000, /* U+3da2 */
  0x0000, /* U+3da3 */
  0x0000, /* U+3da4 */
  0x0000, /* U+3da5 */
  0x0000, /* U+3da6 */
  0x0000, /* U+3da7 */
  0x0000, /* U+3da8 */
  0x0000, /* U+3da9 */
  0x0000, /* U+3daa */
  0x0000, /* U+3dab */
  0x0000, /* U+3dac */
  0x0000, /* U+3dad */
  0x0000, /* U+3dae */
  0x0000, /* U+3daf */
  0x0000, /* U+3db0 */
  0x0000, /* U+3db1 */
  0x0000, /* U+3db2 */
  0x0000, /* U+3db3 */
  0x0000, /* U+3db4 */
  0x0000, /* U+3db5 */
  0x0000, /* U+3db6 */
  0x0000, /* U+3db7 */
  0x0000, /* U+3db8 */
  0x0000, /* U+3db9 */
  0x0000, /* U+3dba */
  0x0000, /* U+3dbb */
  0x0000, /* U+3dbc */
  0x0000, /* U+3dbd */
  0x0000, /* U+3dbe */
  0x0000, /* U+3dbf */
  0x0000, /* U+3dc0 */
  0x0000, /* U+3dc1 */
  0x0000, /* U+3dc2 */
  0x0000, /* U+3dc3 */
  0x0000, /* U+3dc4 */
  0x0000, /* U+3dc5 */
  0x0000, /* U+3dc6 */
  0x0000, /* U+3dc7 */
  0x0000, /* U+3dc8 */
  0x0000, /* U+3dc9 */
  0x0000, /* U+3dca */
  0x0000, /* U+3dcb */
  0x0000, /* U+3dcc */
  0x0000, /* U+3dcd */
  0x0000, /* U+3dce */
  0x0000, /* U+3dcf */
  0x0000, /* U+3dd0 */
  0x0000, /* U+3dd1 */
  0x0000, /* U+3dd2 */
  0x0000, /* U+3dd3 */
  0x0000, /* U+3dd4 */
  0x0000, /* U+3dd5 */
  0x0000, /* U+3dd6 */
  0x0000, /* U+3dd7 */
  0x0000, /* U+3dd8 */
  0x0000, /* U+3dd9 */
  0x0000, /* U+3dda */
  0x0000, /* U+3ddb */
  0x0000, /* U+3ddc */
  0x0000, /* U+3ddd */
  0x0000, /* U+3dde */
  0x0000, /* U+3ddf */
  0x0000, /* U+3de0 */
  0x0000, /* U+3de1 */
  0x0000, /* U+3de2 */
  0x0000, /* U+3de3 */
  0x0000, /* U+3de4 */
  0x0000, /* U+3de5 */
  0x0000, /* U+3de6 */
  0x0000, /* U+3de7 */
  0x0000, /* U+3de8 */
  0x0000, /* U+3de9 */
  0x0000, /* U+3dea */
  0x0000, /* U+3deb */
  0x0000, /* U+3dec */
  0x0000, /* U+3ded */
  0x0000, /* U+3dee */
  0x0000, /* U+3def */
  0x0000, /* U+3df0 */
  0x0000, /* U+3df1 */
  0x0000, /* U+3df2 */
  0x0000, /* U+3df3 */
  0x0000, /* U+3df4 */
  0x0000, /* U+3df5 */
  0x0000, /* U+3df6 */
  0x0000, /* U+3df7 */
  0x0000, /* U+3df8 */
  0x0000, /* U+3df9 */
  0x0000, /* U+3dfa */
  0x0000, /* U+3dfb */
  0x0000, /* U+3dfc */
  0x0000, /* U+3dfd */
  0x0000, /* U+3dfe */
  0x0000, /* U+3dff */
  0x0000, /* U+3e00 */
  0x0000, /* U+3e01 */
  0x0000, /* U+3e02 */
  0x0000, /* U+3e03 */
  0x0000, /* U+3e04 */
  0x0000, /* U+3e05 */
  0x0000, /* U+3e06 */
  0x0000, /* U+3e07 */
  0x0000, /* U+3e08 */
  0x0000, /* U+3e09 */
  0x0000, /* U+3e0a */
  0x0000, /* U+3e0b */
  0x0000, /* U+3e0c */
  0x0000, /* U+3e0d */
  0x0000, /* U+3e0e */
  0x0000, /* U+3e0f */
  0x0000, /* U+3e10 */
  0x0000, /* U+3e11 */
  0x0000, /* U+3e12 */
  0x0000, /* U+3e13 */
  0x0000, /* U+3e14 */
  0x0000, /* U+3e15 */
  0x0000, /* U+3e16 */
  0x0000, /* U+3e17 */
  0x0000, /* U+3e18 */
  0x0000, /* U+3e19 */
  0x0000, /* U+3e1a */
  0x0000, /* U+3e1b */
  0x0000, /* U+3e1c */
  0x0000, /* U+3e1d */
  0x0000, /* U+3e1e */
  0x0000, /* U+3e1f */
  0x0000, /* U+3e20 */
  0x0000, /* U+3e21 */
  0x0000, /* U+3e22 */
  0x0000, /* U+3e23 */
  0x0000, /* U+3e24 */
  0x0000, /* U+3e25 */
  0x0000, /* U+3e26 */
  0x0000, /* U+3e27 */
  0x0000, /* U+3e28 */
  0x0000, /* U+3e29 */
  0x0000, /* U+3e2a */
  0x0000, /* U+3e2b */
  0x0000, /* U+3e2c */
  0x0000, /* U+3e2d */
  0x0000, /* U+3e2e */
  0x0000, /* U+3e2f */
  0x0000, /* U+3e30 */
  0x0000, /* U+3e31 */
  0x0000, /* U+3e32 */
  0x0000, /* U+3e33 */
  0x0000, /* U+3e34 */
  0x0000, /* U+3e35 */
  0x0000, /* U+3e36 */
  0x0000, /* U+3e37 */
  0x0000, /* U+3e38 */
  0x0000, /* U+3e39 */
  0x0000, /* U+3e3a */
  0x0000, /* U+3e3b */
  0x0000, /* U+3e3c */
  0x0000, /* U+3e3d */
  0x0000, /* U+3e3e */
  0x0000, /* U+3e3f */
  0x0000, /* U+3e40 */
  0x0000, /* U+3e41 */
  0x0000, /* U+3e42 */
  0x0000, /* U+3e43 */
  0x0000, /* U+3e44 */
  0x0000, /* U+3e45 */
  0x0000, /* U+3e46 */
  0x0000, /* U+3e47 */
  0x0000, /* U+3e48 */
  0x0000, /* U+3e49 */
  0x0000, /* U+3e4a */
  0x0000, /* U+3e4b */
  0x0000, /* U+3e4c */
  0x0000, /* U+3e4d */
  0x0000, /* U+3e4e */
  0x0000, /* U+3e4f */
  0x0000, /* U+3e50 */
  0x0000, /* U+3e51 */
  0x0000, /* U+3e52 */
  0x0000, /* U+3e53 */
  0x0000, /* U+3e54 */
  0x0000, /* U+3e55 */
  0x0000, /* U+3e56 */
  0x0000, /* U+3e57 */
  0x0000, /* U+3e58 */
  0x0000, /* U+3e59 */
  0x0000, /* U+3e5a */
  0x0000, /* U+3e5b */
  0x0000, /* U+3e5c */
  0x0000, /* U+3e5d */
  0x0000, /* U+3e5e */
  0x0000, /* U+3e5f */
  0x0000, /* U+3e60 */
  0x0000, /* U+3e61 */
  0x0000, /* U+3e62 */
  0x0000, /* U+3e63 */
  0x0000, /* U+3e64 */
  0x0000, /* U+3e65 */
  0x0000, /* U+3e66 */
  0x0000, /* U+3e67 */
  0x0000, /* U+3e68 */
  0x0000, /* U+3e69 */
  0x0000, /* U+3e6a */
  0x0000, /* U+3e6b */
  0x0000, /* U+3e6c */
  0x0000, /* U+3e6d */
  0x0000, /* U+3e6e */
  0x0000, /* U+3e6f */
  0x0000, /* U+3e70 */
  0x0000, /* U+3e71 */
  0x0000, /* U+3e72 */
  0x0000, /* U+3e73 */
  0x0000, /* U+3e74 */
  0x0000, /* U+3e75 */
  0x0000, /* U+3e76 */
  0x0000, /* U+3e77 */
  0x0000, /* U+3e78 */
  0x0000, /* U+3e79 */
  0x0000, /* U+3e7a */
  0x0000, /* U+3e7b */
  0x0000, /* U+3e7c */
  0x0000, /* U+3e7d */
  0x0000, /* U+3e7e */
  0x0000, /* U+3e7f */
  0x0000, /* U+3e80 */
  0x0000, /* U+3e81 */
  0x0000, /* U+3e82 */
  0x0000, /* U+3e83 */
  0x0000, /* U+3e84 */
  0x0000, /* U+3e85 */
  0x0000, /* U+3e86 */
  0x0000, /* U+3e87 */
  0x0000, /* U+3e88 */
  0x0000, /* U+3e89 */
  0x0000, /* U+3e8a */
  0x0000, /* U+3e8b */
  0x0000, /* U+3e8c */
  0x0000, /* U+3e8d */
  0x0000, /* U+3e8e */
  0x0000, /* U+3e8f */
  0x0000, /* U+3e90 */
  0x0000, /* U+3e91 */
  0x0000, /* U+3e92 */
  0x0000, /* U+3e93 */
  0x0000, /* U+3e94 */
  0x0000, /* U+3e95 */
  0x0000, /* U+3e96 */
  0x0000, /* U+3e97 */
  0x0000, /* U+3e98 */
  0x0000, /* U+3e99 */
  0x0000, /* U+3e9a */
  0x0000, /* U+3e9b */
  0x0000, /* U+3e9c */
  0x0000, /* U+3e9d */
  0x0000, /* U+3e9e */
  0x0000, /* U+3e9f */
  0x0000, /* U+3ea0 */
  0x0000, /* U+3ea1 */
  0x0000, /* U+3ea2 */
  0x0000, /* U+3ea3 */
  0x0000, /* U+3ea4 */
  0x0000, /* U+3ea5 */
  0x0000, /* U+3ea6 */
  0x0000, /* U+3ea7 */
  0x0000, /* U+3ea8 */
  0x0000, /* U+3ea9 */
  0x0000, /* U+3eaa */
  0x0000, /* U+3eab */
  0x0000, /* U+3eac */
  0x0000, /* U+3ead */
  0x0000, /* U+3eae */
  0x0000, /* U+3eaf */
  0x0000, /* U+3eb0 */
  0x0000, /* U+3eb1 */
  0x0000, /* U+3eb2 */
  0x0000, /* U+3eb3 */
  0x0000, /* U+3eb4 */
  0x0000, /* U+3eb5 */
  0x0000, /* U+3eb6 */
  0x0000, /* U+3eb7 */
  0x0000, /* U+3eb8 */
  0x0000, /* U+3eb9 */
  0x0000, /* U+3eba */
  0x0000, /* U+3ebb */
  0x0000, /* U+3ebc */
  0x0000, /* U+3ebd */
  0x0000, /* U+3ebe */
  0x0000, /* U+3ebf */
  0x0000, /* U+3ec0 */
  0x0000, /* U+3ec1 */
  0x0000, /* U+3ec2 */
  0x0000, /* U+3ec3 */
  0x0000, /* U+3ec4 */
  0x0000, /* U+3ec5 */
  0x0000, /* U+3ec6 */
  0x0000, /* U+3ec7 */
  0x0000, /* U+3ec8 */
  0x0000, /* U+3ec9 */
  0x0000, /* U+3eca */
  0x0000, /* U+3ecb */
  0x0000, /* U+3ecc */
  0x0000, /* U+3ecd */
  0x0000, /* U+3ece */
  0x0000, /* U+3ecf */
  0x0000, /* U+3ed0 */
  0x0000, /* U+3ed1 */
  0x0000, /* U+3ed2 */
  0x0000, /* U+3ed3 */
  0x0000, /* U+3ed4 */
  0x0000, /* U+3ed5 */
  0x0000, /* U+3ed6 */
  0x0000, /* U+3ed7 */
  0x0000, /* U+3ed8 */
  0x0000, /* U+3ed9 */
  0x0000, /* U+3eda */
  0x0000, /* U+3edb */
  0x0000, /* U+3edc */
  0x0000, /* U+3edd */
  0x0000, /* U+3ede */
  0x0000, /* U+3edf */
  0x0000, /* U+3ee0 */
  0x0000, /* U+3ee1 */
  0x0000, /* U+3ee2 */
  0x0000, /* U+3ee3 */
  0x0000, /* U+3ee4 */
  0x0000, /* U+3ee5 */
  0x0000, /* U+3ee6 */
  0x0000, /* U+3ee7 */
  0x0000, /* U+3ee8 */
  0x0000, /* U+3ee9 */
  0x0000, /* U+3eea */
  0x0000, /* U+3eeb */
  0x0000, /* U+3eec */
  0x0000, /* U+3eed */
  0x0000, /* U+3eee */
  0x0000, /* U+3eef */
  0x0000, /* U+3ef0 */
  0x0000, /* U+3ef1 */
  0x0000, /* U+3ef2 */
  0x0000, /* U+3ef3 */
  0x0000, /* U+3ef4 */
  0x0000, /* U+3ef5 */
  0x0000, /* U+3ef6 */
  0x0000, /* U+3ef7 */
  0x0000, /* U+3ef8 */
  0x0000, /* U+3ef9 */
  0x0000, /* U+3efa */
  0x0000, /* U+3efb */
  0x0000, /* U+3efc */
  0x0000, /* U+3efd */
  0x0000, /* U+3efe */
  0x0000, /* U+3eff */
  0x0000, /* U+3f00 */
  0x0000, /* U+3f01 */
  0x0000, /* U+3f02 */
  0x0000, /* U+3f03 */
  0x0000, /* U+3f04 */
  0x0000, /* U+3f05 */
  0x0000, /* U+3f06 */
  0x0000, /* U+3f07 */
  0x0000, /* U+3f08 */
  0x0000, /* U+3f09 */
  0x0000, /* U+3f0a */
  0x0000, /* U+3f0b */
  0x0000, /* U+3f0c */
  0x0000, /* U+3f0d */
  0x0000, /* U+3f0e */
  0x0000, /* U+3f0f */
  0x0000, /* U+3f10 */
  0x0000, /* U+3f11 */
  0x0000, /* U+3f12 */
  0x0000, /* U+3f13 */
  0x0000, /* U+3f14 */
  0x0000, /* U+3f15 */
  0x0000, /* U+3f16 */
  0x0000, /* U+3f17 */
  0x0000, /* U+3f18 */
  0x0000, /* U+3f19 */
  0x0000, /* U+3f1a */
  0x0000, /* U+3f1b */
  0x0000, /* U+3f1c */
  0x0000, /* U+3f1d */
  0x0000, /* U+3f1e */
  0x0000, /* U+3f1f */
  0x0000, /* U+3f20 */
  0x0000, /* U+3f21 */
  0x0000, /* U+3f22 */
  0x0000, /* U+3f23 */
  0x0000, /* U+3f24 */
  0x0000, /* U+3f25 */
  0x0000, /* U+3f26 */
  0x0000, /* U+3f27 */
  0x0000, /* U+3f28 */
  0x0000, /* U+3f29 */
  0x0000, /* U+3f2a */
  0x0000, /* U+3f2b */
  0x0000, /* U+3f2c */
  0x0000, /* U+3f2d */
  0x0000, /* U+3f2e */
  0x0000, /* U+3f2f */
  0x0000, /* U+3f30 */
  0x0000, /* U+3f31 */
  0x0000, /* U+3f32 */
  0x0000, /* U+3f33 */
  0x0000, /* U+3f34 */
  0x0000, /* U+3f35 */
  0x0000, /* U+3f36 */
  0x0000, /* U+3f37 */
  0x0000, /* U+3f38 */
  0x0000, /* U+3f39 */
  0x0000, /* U+3f3a */
  0x0000, /* U+3f3b */
  0x0000, /* U+3f3c */
  0x0000, /* U+3f3d */
  0x0000, /* U+3f3e */
  0x0000, /* U+3f3f */
  0x0000, /* U+3f40 */
  0x0000, /* U+3f41 */
  0x0000, /* U+3f42 */
  0x0000, /* U+3f43 */
  0x0000, /* U+3f44 */
  0x0000, /* U+3f45 */
  0x0000, /* U+3f46 */
  0x0000, /* U+3f47 */
  0x0000, /* U+3f48 */
  0x0000, /* U+3f49 */
  0x0000, /* U+3f4a */
  0x0000, /* U+3f4b */
  0x0000, /* U+3f4c */
  0x0000, /* U+3f4d */
  0x0000, /* U+3f4e */
  0x0000, /* U+3f4f */
  0x0000, /* U+3f50 */
  0x0000, /* U+3f51 */
  0x0000, /* U+3f52 */
  0x0000, /* U+3f53 */
  0x0000, /* U+3f54 */
  0x0000, /* U+3f55 */
  0x0000, /* U+3f56 */
  0x0000, /* U+3f57 */
  0x0000, /* U+3f58 */
  0x0000, /* U+3f59 */
  0x0000, /* U+3f5a */
  0x0000, /* U+3f5b */
  0x0000, /* U+3f5c */
  0x0000, /* U+3f5d */
  0x0000, /* U+3f5e */
  0x0000, /* U+3f5f */
  0x0000, /* U+3f60 */
  0x0000, /* U+3f61 */
  0x0000, /* U+3f62 */
  0x0000, /* U+3f63 */
  0x0000, /* U+3f64 */
  0x0000, /* U+3f65 */
  0x0000, /* U+3f66 */
  0x0000, /* U+3f67 */
  0x0000, /* U+3f68 */
  0x0000, /* U+3f69 */
  0x0000, /* U+3f6a */
  0x0000, /* U+3f6b */
  0x0000, /* U+3f6c */
  0x0000, /* U+3f6d */
  0x0000, /* U+3f6e */
  0x0000, /* U+3f6f */
  0x0000, /* U+3f70 */
  0x0000, /* U+3f71 */
  0x0000, /* U+3f72 */
  0x0000, /* U+3f73 */
  0x0000, /* U+3f74 */
  0x0000, /* U+3f75 */
  0x0000, /* U+3f76 */
  0x0000, /* U+3f77 */
  0x0000, /* U+3f78 */
  0x0000, /* U+3f79 */
  0x0000, /* U+3f7a */
  0x0000, /* U+3f7b */
  0x0000, /* U+3f7c */
  0x0000, /* U+3f7d */
  0x0000, /* U+3f7e */
  0x0000, /* U+3f7f */
  0x0000, /* U+3f80 */
  0x0000, /* U+3f81 */
  0x0000, /* U+3f82 */
  0x0000, /* U+3f83 */
  0x0000, /* U+3f84 */
  0x0000, /* U+3f85 */
  0x0000, /* U+3f86 */
  0x0000, /* U+3f87 */
  0x0000, /* U+3f88 */
  0x0000, /* U+3f89 */
  0x0000, /* U+3f8a */
  0x0000, /* U+3f8b */
  0x0000, /* U+3f8c */
  0x0000, /* U+3f8d */
  0x0000, /* U+3f8e */
  0x0000, /* U+3f8f */
  0x0000, /* U+3f90 */
  0x0000, /* U+3f91 */
  0x0000, /* U+3f92 */
  0x0000, /* U+3f93 */
  0x0000, /* U+3f94 */
  0x0000, /* U+3f95 */
  0x0000, /* U+3f96 */
  0x0000, /* U+3f97 */
  0x0000, /* U+3f98 */
  0x0000, /* U+3f99 */
  0x0000, /* U+3f9a */
  0x0000, /* U+3f9b */
  0x0000, /* U+3f9c */
  0x0000, /* U+3f9d */
  0x0000, /* U+3f9e */
  0x0000, /* U+3f9f */
  0x0000, /* U+3fa0 */
  0x0000, /* U+3fa1 */
  0x0000, /* U+3fa2 */
  0x0000, /* U+3fa3 */
  0x0000, /* U+3fa4 */
  0x0000, /* U+3fa5 */
  0x0000, /* U+3fa6 */
  0x0000, /* U+3fa7 */
  0x0000, /* U+3fa8 */
  0x0000, /* U+3fa9 */
  0x0000, /* U+3faa */
  0x0000, /* U+3fab */
  0x0000, /* U+3fac */
  0x0000, /* U+3fad */
  0x0000, /* U+3fae */
  0x0000, /* U+3faf */
  0x0000, /* U+3fb0 */
  0x0000, /* U+3fb1 */
  0x0000, /* U+3fb2 */
  0x0000, /* U+3fb3 */
  0x0000, /* U+3fb4 */
  0x0000, /* U+3fb5 */
  0x0000, /* U+3fb6 */
  0x0000, /* U+3fb7 */
  0x0000, /* U+3fb8 */
  0x0000, /* U+3fb9 */
  0x0000, /* U+3fba */
  0x0000, /* U+3fbb */
  0x0000, /* U+3fbc */
  0x0000, /* U+3fbd */
  0x0000, /* U+3fbe */
  0x0000, /* U+3fbf */
  0x0000, /* U+3fc0 */
  0x0000, /* U+3fc1 */
  0x0000, /* U+3fc2 */
  0x0000, /* U+3fc3 */
  0x0000, /* U+3fc4 */
  0x0000, /* U+3fc5 */
  0x0000, /* U+3fc6 */
  0x0000, /* U+3fc7 */
  0x0000, /* U+3fc8 */
  0x0000, /* U+3fc9 */
  0x0000, /* U+3fca */
  0x0000, /* U+3fcb */
  0x0000, /* U+3fcc */
  0x0000, /* U+3fcd */
  0x0000, /* U+3fce */
  0x0000, /* U+3fcf */
  0x0000, /* U+3fd0 */
  0x0000, /* U+3fd1 */
  0x0000, /* U+3fd2 */
  0x0000, /* U+3fd3 */
  0x0000, /* U+3fd4 */
  0x0000, /* U+3fd5 */
  0x0000, /* U+3fd6 */
  0x0000, /* U+3fd7 */
  0x0000, /* U+3fd8 */
  0x0000, /* U+3fd9 */
  0x0000, /* U+3fda */
  0x0000, /* U+3fdb */
  0x0000, /* U+3fdc */
  0x0000, /* U+3fdd */
  0x0000, /* U+3fde */
  0x0000, /* U+3fdf */
  0x0000, /* U+3fe0 */
  0x0000, /* U+3fe1 */
  0x0000, /* U+3fe2 */
  0x0000, /* U+3fe3 */
  0x0000, /* U+3fe4 */
  0x0000, /* U+3fe5 */
  0x0000, /* U+3fe6 */
  0x0000, /* U+3fe7 */
  0x0000, /* U+3fe8 */
  0x0000, /* U+3fe9 */
  0x0000, /* U+3fea */
  0x0000, /* U+3feb */
  0x0000, /* U+3fec */
  0x0000, /* U+3fed */
  0x0000, /* U+3fee */
  0x0000, /* U+3fef */
  0x0000, /* U+3ff0 */
  0x0000, /* U+3ff1 */
  0x0000, /* U+3ff2 */
  0x0000, /* U+3ff3 */
  0x0000, /* U+3ff4 */
  0x0000, /* U+3ff5 */
  0x0000, /* U+3ff6 */
  0x0000, /* U+3ff7 */
  0x0000, /* U+3ff8 */
  0x0000, /* U+3ff9 */
  0x0000, /* U+3ffa */
  0x0000, /* U+3ffb */
  0x0000, /* U+3ffc */
  0x0000, /* U+3ffd */
  0x0000, /* U+3ffe */
  0x0000, /* U+3fff */
  0x0000, /* U+4000 */
  0x0000, /* U+4001 */
  0x0000, /* U+4002 */
  0x0000, /* U+4003 */
  0x0000, /* U+4004 */
  0x0000, /* U+4005 */
  0x0000, /* U+4006 */
  0x0000, /* U+4007 */
  0x0000, /* U+4008 */
  0x0000, /* U+4009 */
  0x0000, /* U+400a */
  0x0000, /* U+400b */
  0x0000, /* U+400c */
  0x0000, /* U+400d */
  0x0000, /* U+400e */
  0x0000, /* U+400f */
  0x0000, /* U+4010 */
  0x0000, /* U+4011 */
  0x0000, /* U+4012 */
  0x0000, /* U+4013 */
  0x0000, /* U+4014 */
  0x0000, /* U+4015 */
  0x0000, /* U+4016 */
  0x0000, /* U+4017 */
  0x0000, /* U+4018 */
  0x0000, /* U+4019 */
  0x0000, /* U+401a */
  0x0000, /* U+401b */
  0x0000, /* U+401c */
  0x0000, /* U+401d */
  0x0000, /* U+401e */
  0x0000, /* U+401f */
  0x0000, /* U+4020 */
  0x0000, /* U+4021 */
  0x0000, /* U+4022 */
  0x0000, /* U+4023 */
  0x0000, /* U+4024 */
  0x0000, /* U+4025 */
  0x0000, /* U+4026 */
  0x0000, /* U+4027 */
  0x0000, /* U+4028 */
  0x0000, /* U+4029 */
  0x0000, /* U+402a */
  0x0000, /* U+402b */
  0x0000, /* U+402c */
  0x0000, /* U+402d */
  0x0000, /* U+402e */
  0x0000, /* U+402f */
  0x0000, /* U+4030 */
  0x0000, /* U+4031 */
  0x0000, /* U+4032 */
  0x0000, /* U+4033 */
  0x0000, /* U+4034 */
  0x0000, /* U+4035 */
  0x0000, /* U+4036 */
  0x0000, /* U+4037 */
  0x0000, /* U+4038 */
  0x0000, /* U+4039 */
  0x0000, /* U+403a */
  0x0000, /* U+403b */
  0x0000, /* U+403c */
  0x0000, /* U+403d */
  0x0000, /* U+403e */
  0x0000, /* U+403f */
  0x0000, /* U+4040 */
  0x0000, /* U+4041 */
  0x0000, /* U+4042 */
  0x0000, /* U+4043 */
  0x0000, /* U+4044 */
  0x0000, /* U+4045 */
  0x0000, /* U+4046 */
  0x0000, /* U+4047 */
  0x0000, /* U+4048 */
  0x0000, /* U+4049 */
  0x0000, /* U+404a */
  0x0000, /* U+404b */
  0x0000, /* U+404c */
  0x0000, /* U+404d */
  0x0000, /* U+404e */
  0x0000, /* U+404f */
  0x0000, /* U+4050 */
  0x0000, /* U+4051 */
  0x0000, /* U+4052 */
  0x0000, /* U+4053 */
  0x0000, /* U+4054 */
  0x0000, /* U+4055 */
  0x0000, /* U+4056 */
  0x0000, /* U+4057 */
  0x0000, /* U+4058 */
  0x0000, /* U+4059 */
  0x0000, /* U+405a */
  0x0000, /* U+405b */
  0x0000, /* U+405c */
  0x0000, /* U+405d */
  0x0000, /* U+405e */
  0x0000, /* U+405f */
  0x0000, /* U+4060 */
  0x0000, /* U+4061 */
  0x0000, /* U+4062 */
  0x0000, /* U+4063 */
  0x0000, /* U+4064 */
  0x0000, /* U+4065 */
  0x0000, /* U+4066 */
  0x0000, /* U+4067 */
  0x0000, /* U+4068 */
  0x0000, /* U+4069 */
  0x0000, /* U+406a */
  0x0000, /* U+406b */
  0x0000, /* U+406c */
  0x0000, /* U+406d */
  0x0000, /* U+406e */
  0x0000, /* U+406f */
  0x0000, /* U+4070 */
  0x0000, /* U+4071 */
  0x0000, /* U+4072 */
  0x0000, /* U+4073 */
  0x0000, /* U+4074 */
  0x0000, /* U+4075 */
  0x0000, /* U+4076 */
  0x0000, /* U+4077 */
  0x0000, /* U+4078 */
  0x0000, /* U+4079 */
  0x0000, /* U+407a */
  0x0000, /* U+407b */
  0x0000, /* U+407c */
  0x0000, /* U+407d */
  0x0000, /* U+407e */
  0x0000, /* U+407f */
  0x0000, /* U+4080 */
  0x0000, /* U+4081 */
  0x0000, /* U+4082 */
  0x0000, /* U+4083 */
  0x0000, /* U+4084 */
  0x0000, /* U+4085 */
  0x0000, /* U+4086 */
  0x0000, /* U+4087 */
  0x0000, /* U+4088 */
  0x0000, /* U+4089 */
  0x0000, /* U+408a */
  0x0000, /* U+408b */
  0x0000, /* U+408c */
  0x0000, /* U+408d */
  0x0000, /* U+408e */
  0x0000, /* U+408f */
  0x0000, /* U+4090 */
  0x0000, /* U+4091 */
  0x0000, /* U+4092 */
  0x0000, /* U+4093 */
  0x0000, /* U+4094 */
  0x0000, /* U+4095 */
  0x0000, /* U+4096 */
  0x0000, /* U+4097 */
  0x0000, /* U+4098 */
  0x0000, /* U+4099 */
  0x0000, /* U+409a */
  0x0000, /* U+409b */
  0x0000, /* U+409c */
  0x0000, /* U+409d */
  0x0000, /* U+409e */
  0x0000, /* U+409f */
  0x0000, /* U+40a0 */
  0x0000, /* U+40a1 */
  0x0000, /* U+40a2 */
  0x0000, /* U+40a3 */
  0x0000, /* U+40a4 */
  0x0000, /* U+40a5 */
  0x0000, /* U+40a6 */
  0x0000, /* U+40a7 */
  0x0000, /* U+40a8 */
  0x0000, /* U+40a9 */
  0x0000, /* U+40aa */
  0x0000, /* U+40ab */
  0x0000, /* U+40ac */
  0x0000, /* U+40ad */
  0x0000, /* U+40ae */
  0x0000, /* U+40af */
  0x0000, /* U+40b0 */
  0x0000, /* U+40b1 */
  0x0000, /* U+40b2 */
  0x0000, /* U+40b3 */
  0x0000, /* U+40b4 */
  0x0000, /* U+40b5 */
  0x0000, /* U+40b6 */
  0x0000, /* U+40b7 */
  0x0000, /* U+40b8 */
  0x0000, /* U+40b9 */
  0x0000, /* U+40ba */
  0x0000, /* U+40bb */
  0x0000, /* U+40bc */
  0x0000, /* U+40bd */
  0x0000, /* U+40be */
  0x0000, /* U+40bf */
  0x0000, /* U+40c0 */
  0x0000, /* U+40c1 */
  0x0000, /* U+40c2 */
  0x0000, /* U+40c3 */
  0x0000, /* U+40c4 */
  0x0000, /* U+40c5 */
  0x0000, /* U+40c6 */
  0x0000, /* U+40c7 */
  0x0000, /* U+40c8 */
  0x0000, /* U+40c9 */
  0x0000, /* U+40ca */
  0x0000, /* U+40cb */
  0x0000, /* U+40cc */
  0x0000, /* U+40cd */
  0x0000, /* U+40ce */
  0x0000, /* U+40cf */
  0x0000, /* U+40d0 */
  0x0000, /* U+40d1 */
  0x0000, /* U+40d2 */
  0x0000, /* U+40d3 */
  0x0000, /* U+40d4 */
  0x0000, /* U+40d5 */
  0x0000, /* U+40d6 */
  0x0000, /* U+40d7 */
  0x0000, /* U+40d8 */
  0x0000, /* U+40d9 */
  0x0000, /* U+40da */
  0x0000, /* U+40db */
  0x0000, /* U+40dc */
  0x0000, /* U+40dd */
  0x0000, /* U+40de */
  0x0000, /* U+40df */
  0x0000, /* U+40e0 */
  0x0000, /* U+40e1 */
  0x0000, /* U+40e2 */
  0x0000, /* U+40e3 */
  0x0000, /* U+40e4 */
  0x0000, /* U+40e5 */
  0x0000, /* U+40e6 */
  0x0000, /* U+40e7 */
  0x0000, /* U+40e8 */
  0x0000, /* U+40e9 */
  0x0000, /* U+40ea */
  0x0000, /* U+40eb */
  0x0000, /* U+40ec */
  0x0000, /* U+40ed */
  0x0000, /* U+40ee */
  0x0000, /* U+40ef */
  0x0000, /* U+40f0 */
  0x0000, /* U+40f1 */
  0x0000, /* U+40f2 */
  0x0000, /* U+40f3 */
  0x0000, /* U+40f4 */
  0x0000, /* U+40f5 */
  0x0000, /* U+40f6 */
  0x0000, /* U+40f7 */
  0x0000, /* U+40f8 */
  0x0000, /* U+40f9 */
  0x0000, /* U+40fa */
  0x0000, /* U+40fb */
  0x0000, /* U+40fc */
  0x0000, /* U+40fd */
  0x0000, /* U+40fe */
  0x0000, /* U+40ff */
  0x0000, /* U+4100 */
  0x0000, /* U+4101 */
  0x0000, /* U+4102 */
  0x0000, /* U+4103 */
  0x0000, /* U+4104 */
  0x0000, /* U+4105 */
  0x0000, /* U+4106 */
  0x0000, /* U+4107 */
  0x0000, /* U+4108 */
  0x0000, /* U+4109 */
  0x0000, /* U+410a */
  0x0000, /* U+410b */
  0x0000, /* U+410c */
  0x0000, /* U+410d */
  0x0000, /* U+410e */
  0x0000, /* U+410f */
  0x0000, /* U+4110 */
  0x0000, /* U+4111 */
  0x0000, /* U+4112 */
  0x0000, /* U+4113 */
  0x0000, /* U+4114 */
  0x0000, /* U+4115 */
  0x0000, /* U+4116 */
  0x0000, /* U+4117 */
  0x0000, /* U+4118 */
  0x0000, /* U+4119 */
  0x0000, /* U+411a */
  0x0000, /* U+411b */
  0x0000, /* U+411c */
  0x0000, /* U+411d */
  0x0000, /* U+411e */
  0x0000, /* U+411f */
  0x0000, /* U+4120 */
  0x0000, /* U+4121 */
  0x0000, /* U+4122 */
  0x0000, /* U+4123 */
  0x0000, /* U+4124 */
  0x0000, /* U+4125 */
  0x0000, /* U+4126 */
  0x0000, /* U+4127 */
  0x0000, /* U+4128 */
  0x0000, /* U+4129 */
  0x0000, /* U+412a */
  0x0000, /* U+412b */
  0x0000, /* U+412c */
  0x0000, /* U+412d */
  0x0000, /* U+412e */
  0x0000, /* U+412f */
  0x0000, /* U+4130 */
  0x0000, /* U+4131 */
  0x0000, /* U+4132 */
  0x0000, /* U+4133 */
  0x0000, /* U+4134 */
  0x0000, /* U+4135 */
  0x0000, /* U+4136 */
  0x0000, /* U+4137 */
  0x0000, /* U+4138 */
  0x0000, /* U+4139 */
  0x0000, /* U+413a */
  0x0000, /* U+413b */
  0x0000, /* U+413c */
  0x0000, /* U+413d */
  0x0000, /* U+413e */
  0x0000, /* U+413f */
  0x0000, /* U+4140 */
  0x0000, /* U+4141 */
  0x0000, /* U+4142 */
  0x0000, /* U+4143 */
  0x0000, /* U+4144 */
  0x0000, /* U+4145 */
  0x0000, /* U+4146 */
  0x0000, /* U+4147 */
  0x0000, /* U+4148 */
  0x0000, /* U+4149 */
  0x0000, /* U+414a */
  0x0000, /* U+414b */
  0x0000, /* U+414c */
  0x0000, /* U+414d */
  0x0000, /* U+414e */
  0x0000, /* U+414f */
  0x0000, /* U+4150 */
  0x0000, /* U+4151 */
  0x0000, /* U+4152 */
  0x0000, /* U+4153 */
  0x0000, /* U+4154 */
  0x0000, /* U+4155 */
  0x0000, /* U+4156 */
  0x0000, /* U+4157 */
  0x0000, /* U+4158 */
  0x0000, /* U+4159 */
  0x0000, /* U+415a */
  0x0000, /* U+415b */
  0x0000, /* U+415c */
  0x0000, /* U+415d */
  0x0000, /* U+415e */
  0x0000, /* U+415f */
  0x0000, /* U+4160 */
  0x0000, /* U+4161 */
  0x0000, /* U+4162 */
  0x0000, /* U+4163 */
  0x0000, /* U+4164 */
  0x0000, /* U+4165 */
  0x0000, /* U+4166 */
  0x0000, /* U+4167 */
  0x0000, /* U+4168 */
  0x0000, /* U+4169 */
  0x0000, /* U+416a */
  0x0000, /* U+416b */
  0x0000, /* U+416c */
  0x0000, /* U+416d */
  0x0000, /* U+416e */
  0x0000, /* U+416f */
  0x0000, /* U+4170 */
  0x0000, /* U+4171 */
  0x0000, /* U+4172 */
  0x0000, /* U+4173 */
  0x0000, /* U+4174 */
  0x0000, /* U+4175 */
  0x0000, /* U+4176 */
  0x0000, /* U+4177 */
  0x0000, /* U+4178 */
  0x0000, /* U+4179 */
  0x0000, /* U+417a */
  0x0000, /* U+417b */
  0x0000, /* U+417c */
  0x0000, /* U+417d */
  0x0000, /* U+417e */
  0x0000, /* U+417f */
  0x0000, /* U+4180 */
  0x0000, /* U+4181 */
  0x0000, /* U+4182 */
  0x0000, /* U+4183 */
  0x0000, /* U+4184 */
  0x0000, /* U+4185 */
  0x0000, /* U+4186 */
  0x0000, /* U+4187 */
  0x0000, /* U+4188 */
  0x0000, /* U+4189 */
  0x0000, /* U+418a */
  0x0000, /* U+418b */
  0x0000, /* U+418c */
  0x0000, /* U+418d */
  0x0000, /* U+418e */
  0x0000, /* U+418f */
  0x0000, /* U+4190 */
  0x0000, /* U+4191 */
  0x0000, /* U+4192 */
  0x0000, /* U+4193 */
  0x0000, /* U+4194 */
  0x0000, /* U+4195 */
  0x0000, /* U+4196 */
  0x0000, /* U+4197 */
  0x0000, /* U+4198 */
  0x0000, /* U+4199 */
  0x0000, /* U+419a */
  0x0000, /* U+419b */
  0x0000, /* U+419c */
  0x0000, /* U+419d */
  0x0000, /* U+419e */
  0x0000, /* U+419f */
  0x0000, /* U+41a0 */
  0x0000, /* U+41a1 */
  0x0000, /* U+41a2 */
  0x0000, /* U+41a3 */
  0x0000, /* U+41a4 */
  0x0000, /* U+41a5 */
  0x0000, /* U+41a6 */
  0x0000, /* U+41a7 */
  0x0000, /* U+41a8 */
  0x0000, /* U+41a9 */
  0x0000, /* U+41aa */
  0x0000, /* U+41ab */
  0x0000, /* U+41ac */
  0x0000, /* U+41ad */
  0x0000, /* U+41ae */
  0x0000, /* U+41af */
  0x0000, /* U+41b0 */
  0x0000, /* U+41b1 */
  0x0000, /* U+41b2 */
  0x0000, /* U+41b3 */
  0x0000, /* U+41b4 */
  0x0000, /* U+41b5 */
  0x0000, /* U+41b6 */
  0x0000, /* U+41b7 */
  0x0000, /* U+41b8 */
  0x0000, /* U+41b9 */
  0x0000, /* U+41ba */
  0x0000, /* U+41bb */
  0x0000, /* U+41bc */
  0x0000, /* U+41bd */
  0x0000, /* U+41be */
  0x0000, /* U+41bf */
  0x0000, /* U+41c0 */
  0x0000, /* U+41c1 */
  0x0000, /* U+41c2 */
  0x0000, /* U+41c3 */
  0x0000, /* U+41c4 */
  0x0000, /* U+41c5 */
  0x0000, /* U+41c6 */
  0x0000, /* U+41c7 */
  0x0000, /* U+41c8 */
  0x0000, /* U+41c9 */
  0x0000, /* U+41ca */
  0x0000, /* U+41cb */
  0x0000, /* U+41cc */
  0x0000, /* U+41cd */
  0x0000, /* U+41ce */
  0x0000, /* U+41cf */
  0x0000, /* U+41d0 */
  0x0000, /* U+41d1 */
  0x0000, /* U+41d2 */
  0x0000, /* U+41d3 */
  0x0000, /* U+41d4 */
  0x0000, /* U+41d5 */
  0x0000, /* U+41d6 */
  0x0000, /* U+41d7 */
  0x0000, /* U+41d8 */
  0x0000, /* U+41d9 */
  0x0000, /* U+41da */
  0x0000, /* U+41db */
  0x0000, /* U+41dc */
  0x0000, /* U+41dd */
  0x0000, /* U+41de */
  0x0000, /* U+41df */
  0x0000, /* U+41e0 */
  0x0000, /* U+41e1 */
  0x0000, /* U+41e2 */
  0x0000, /* U+41e3 */
  0x0000, /* U+41e4 */
  0x0000, /* U+41e5 */
  0x0000, /* U+41e6 */
  0x0000, /* U+41e7 */
  0x0000, /* U+41e8 */
  0x0000, /* U+41e9 */
  0x0000, /* U+41ea */
  0x0000, /* U+41eb */
  0x0000, /* U+41ec */
  0x0000, /* U+41ed */
  0x0000, /* U+41ee */
  0x0000, /* U+41ef */
  0x0000, /* U+41f0 */
  0x0000, /* U+41f1 */
  0x0000, /* U+41f2 */
  0x0000, /* U+41f3 */
  0x0000, /* U+41f4 */
  0x0000, /* U+41f5 */
  0x0000, /* U+41f6 */
  0x0000, /* U+41f7 */
  0x0000, /* U+41f8 */
  0x0000, /* U+41f9 */
  0x0000, /* U+41fa */
  0x0000, /* U+41fb */
  0x0000, /* U+41fc */
  0x0000, /* U+41fd */
  0x0000, /* U+41fe */
  0x0000, /* U+41ff */
  0x0000, /* U+4200 */
  0x0000, /* U+4201 */
  0x0000, /* U+4202 */
  0x0000, /* U+4203 */
  0x0000, /* U+4204 */
  0x0000, /* U+4205 */
  0x0000, /* U+4206 */
  0x0000, /* U+4207 */
  0x0000, /* U+4208 */
  0x0000, /* U+4209 */
  0x0000, /* U+420a */
  0x0000, /* U+420b */
  0x0000, /* U+420c */
  0x0000, /* U+420d */
  0x0000, /* U+420e */
  0x0000, /* U+420f */
  0x0000, /* U+4210 */
  0x0000, /* U+4211 */
  0x0000, /* U+4212 */
  0x0000, /* U+4213 */
  0x0000, /* U+4214 */
  0x0000, /* U+4215 */
  0x0000, /* U+4216 */
  0x0000, /* U+4217 */
  0x0000, /* U+4218 */
  0x0000, /* U+4219 */
  0x0000, /* U+421a */
  0x0000, /* U+421b */
  0x0000, /* U+421c */
  0x0000, /* U+421d */
  0x0000, /* U+421e */
  0x0000, /* U+421f */
  0x0000, /* U+4220 */
  0x0000, /* U+4221 */
  0x0000, /* U+4222 */
  0x0000, /* U+4223 */
  0x0000, /* U+4224 */
  0x0000, /* U+4225 */
  0x0000, /* U+4226 */
  0x0000, /* U+4227 */
  0x0000, /* U+4228 */
  0x0000, /* U+4229 */
  0x0000, /* U+422a */
  0x0000, /* U+422b */
  0x0000, /* U+422c */
  0x0000, /* U+422d */
  0x0000, /* U+422e */
  0x0000, /* U+422f */
  0x0000, /* U+4230 */
  0x0000, /* U+4231 */
  0x0000, /* U+4232 */
  0x0000, /* U+4233 */
  0x0000, /* U+4234 */
  0x0000, /* U+4235 */
  0x0000, /* U+4236 */
  0x0000, /* U+4237 */
  0x0000, /* U+4238 */
  0x0000, /* U+4239 */
  0x0000, /* U+423a */
  0x0000, /* U+423b */
  0x0000, /* U+423c */
  0x0000, /* U+423d */
  0x0000, /* U+423e */
  0x0000, /* U+423f */
  0x0000, /* U+4240 */
  0x0000, /* U+4241 */
  0x0000, /* U+4242 */
  0x0000, /* U+4243 */
  0x0000, /* U+4244 */
  0x0000, /* U+4245 */
  0x0000, /* U+4246 */
  0x0000, /* U+4247 */
  0x0000, /* U+4248 */
  0x0000, /* U+4249 */
  0x0000, /* U+424a */
  0x0000, /* U+424b */
  0x0000, /* U+424c */
  0x0000, /* U+424d */
  0x0000, /* U+424e */
  0x0000, /* U+424f */
  0x0000, /* U+4250 */
  0x0000, /* U+4251 */
  0x0000, /* U+4252 */
  0x0000, /* U+4253 */
  0x0000, /* U+4254 */
  0x0000, /* U+4255 */
  0x0000, /* U+4256 */
  0x0000, /* U+4257 */
  0x0000, /* U+4258 */
  0x0000, /* U+4259 */
  0x0000, /* U+425a */
  0x0000, /* U+425b */
  0x0000, /* U+425c */
  0x0000, /* U+425d */
  0x0000, /* U+425e */
  0x0000, /* U+425f */
  0x0000, /* U+4260 */
  0x0000, /* U+4261 */
  0x0000, /* U+4262 */
  0x0000, /* U+4263 */
  0x0000, /* U+4264 */
  0x0000, /* U+4265 */
  0x0000, /* U+4266 */
  0x0000, /* U+4267 */
  0x0000, /* U+4268 */
  0x0000, /* U+4269 */
  0x0000, /* U+426a */
  0x0000, /* U+426b */
  0x0000, /* U+426c */
  0x0000, /* U+426d */
  0x0000, /* U+426e */
  0x0000, /* U+426f */
  0x0000, /* U+4270 */
  0x0000, /* U+4271 */
  0x0000, /* U+4272 */
  0x0000, /* U+4273 */
  0x0000, /* U+4274 */
  0x0000, /* U+4275 */
  0x0000, /* U+4276 */
  0x0000, /* U+4277 */
  0x0000, /* U+4278 */
  0x0000, /* U+4279 */
  0x0000, /* U+427a */
  0x0000, /* U+427b */
  0x0000, /* U+427c */
  0x0000, /* U+427d */
  0x0000, /* U+427e */
  0x0000, /* U+427f */
  0x0000, /* U+4280 */
  0x0000, /* U+4281 */
  0x0000, /* U+4282 */
  0x0000, /* U+4283 */
  0x0000, /* U+4284 */
  0x0000, /* U+4285 */
  0x0000, /* U+4286 */
  0x0000, /* U+4287 */
  0x0000, /* U+4288 */
  0x0000, /* U+4289 */
  0x0000, /* U+428a */
  0x0000, /* U+428b */
  0x0000, /* U+428c */
  0x0000, /* U+428d */
  0x0000, /* U+428e */
  0x0000, /* U+428f */
  0x0000, /* U+4290 */
  0x0000, /* U+4291 */
  0x0000, /* U+4292 */
  0x0000, /* U+4293 */
  0x0000, /* U+4294 */
  0x0000, /* U+4295 */
  0x0000, /* U+4296 */
  0x0000, /* U+4297 */
  0x0000, /* U+4298 */
  0x0000, /* U+4299 */
  0x0000, /* U+429a */
  0x0000, /* U+429b */
  0x0000, /* U+429c */
  0x0000, /* U+429d */
  0x0000, /* U+429e */
  0x0000, /* U+429f */
  0x0000, /* U+42a0 */
  0x0000, /* U+42a1 */
  0x0000, /* U+42a2 */
  0x0000, /* U+42a3 */
  0x0000, /* U+42a4 */
  0x0000, /* U+42a5 */
  0x0000, /* U+42a6 */
  0x0000, /* U+42a7 */
  0x0000, /* U+42a8 */
  0x0000, /* U+42a9 */
  0x0000, /* U+42aa */
  0x0000, /* U+42ab */
  0x0000, /* U+42ac */
  0x0000, /* U+42ad */
  0x0000, /* U+42ae */
  0x0000, /* U+42af */
  0x0000, /* U+42b0 */
  0x0000, /* U+42b1 */
  0x0000, /* U+42b2 */
  0x0000, /* U+42b3 */
  0x0000, /* U+42b4 */
  0x0000, /* U+42b5 */
  0x0000, /* U+42b6 */
  0x0000, /* U+42b7 */
  0x0000, /* U+42b8 */
  0x0000, /* U+42b9 */
  0x0000, /* U+42ba */
  0x0000, /* U+42bb */
  0x0000, /* U+42bc */
  0x0000, /* U+42bd */
  0x0000, /* U+42be */
  0x0000, /* U+42bf */
  0x0000, /* U+42c0 */
  0x0000, /* U+42c1 */
  0x0000, /* U+42c2 */
  0x0000, /* U+42c3 */
  0x0000, /* U+42c4 */
  0x0000, /* U+42c5 */
  0x0000, /* U+42c6 */
  0x0000, /* U+42c7 */
  0x0000, /* U+42c8 */
  0x0000, /* U+42c9 */
  0x0000, /* U+42ca */
  0x0000, /* U+42cb */
  0x0000, /* U+42cc */
  0x0000, /* U+42cd */
  0x0000, /* U+42ce */
  0x0000, /* U+42cf */
  0x0000, /* U+42d0 */
  0x0000, /* U+42d1 */
  0x0000, /* U+42d2 */
  0x0000, /* U+42d3 */
  0x0000, /* U+42d4 */
  0x0000, /* U+42d5 */
  0x0000, /* U+42d6 */
  0x0000, /* U+42d7 */
  0x0000, /* U+42d8 */
  0x0000, /* U+42d9 */
  0x0000, /* U+42da */
  0x0000, /* U+42db */
  0x0000, /* U+42dc */
  0x0000, /* U+42dd */
  0x0000, /* U+42de */
  0x0000, /* U+42df */
  0x0000, /* U+42e0 */
  0x0000, /* U+42e1 */
  0x0000, /* U+42e2 */
  0x0000, /* U+42e3 */
  0x0000, /* U+42e4 */
  0x0000, /* U+42e5 */
  0x0000, /* U+42e6 */
  0x0000, /* U+42e7 */
  0x0000, /* U+42e8 */
  0x0000, /* U+42e9 */
  0x0000, /* U+42ea */
  0x0000, /* U+42eb */
  0x0000, /* U+42ec */
  0x0000, /* U+42ed */
  0x0000, /* U+42ee */
  0x0000, /* U+42ef */
  0x0000, /* U+42f0 */
  0x0000, /* U+42f1 */
  0x0000, /* U+42f2 */
  0x0000, /* U+42f3 */
  0x0000, /* U+42f4 */
  0x0000, /* U+42f5 */
  0x0000, /* U+42f6 */
  0x0000, /* U+42f7 */
  0x0000, /* U+42f8 */
  0x0000, /* U+42f9 */
  0x0000, /* U+42fa */
  0x0000, /* U+42fb */
  0x0000, /* U+42fc */
  0x0000, /* U+42fd */
  0x0000, /* U+42fe */
  0x0000, /* U+42ff */
  0x0000, /* U+4300 */
  0x0000, /* U+4301 */
  0x0000, /* U+4302 */
  0x0000, /* U+4303 */
  0x0000, /* U+4304 */
  0x0000, /* U+4305 */
  0x0000, /* U+4306 */
  0x0000, /* U+4307 */
  0x0000, /* U+4308 */
  0x0000, /* U+4309 */
  0x0000, /* U+430a */
  0x0000, /* U+430b */
  0x0000, /* U+430c */
  0x0000, /* U+430d */
  0x0000, /* U+430e */
  0x0000, /* U+430f */
  0x0000, /* U+4310 */
  0x0000, /* U+4311 */
  0x0000, /* U+4312 */
  0x0000, /* U+4313 */
  0x0000, /* U+4314 */
  0x0000, /* U+4315 */
  0x0000, /* U+4316 */
  0x0000, /* U+4317 */
  0x0000, /* U+4318 */
  0x0000, /* U+4319 */
  0x0000, /* U+431a */
  0x0000, /* U+431b */
  0x0000, /* U+431c */
  0x0000, /* U+431d */
  0x0000, /* U+431e */
  0x0000, /* U+431f */
  0x0000, /* U+4320 */
  0x0000, /* U+4321 */
  0x0000, /* U+4322 */
  0x0000, /* U+4323 */
  0x0000, /* U+4324 */
  0x0000, /* U+4325 */
  0x0000, /* U+4326 */
  0x0000, /* U+4327 */
  0x0000, /* U+4328 */
  0x0000, /* U+4329 */
  0x0000, /* U+432a */
  0x0000, /* U+432b */
  0x0000, /* U+432c */
  0x0000, /* U+432d */
  0x0000, /* U+432e */
  0x0000, /* U+432f */
  0x0000, /* U+4330 */
  0x0000, /* U+4331 */
  0x0000, /* U+4332 */
  0x0000, /* U+4333 */
  0x0000, /* U+4334 */
  0x0000, /* U+4335 */
  0x0000, /* U+4336 */
  0x0000, /* U+4337 */
  0x0000, /* U+4338 */
  0x0000, /* U+4339 */
  0x0000, /* U+433a */
  0x0000, /* U+433b */
  0x0000, /* U+433c */
  0x0000, /* U+433d */
  0x0000, /* U+433e */
  0x0000, /* U+433f */
  0x0000, /* U+4340 */
  0x0000, /* U+4341 */
  0x0000, /* U+4342 */
  0x0000, /* U+4343 */
  0x0000, /* U+4344 */
  0x0000, /* U+4345 */
  0x0000, /* U+4346 */
  0x0000, /* U+4347 */
  0x0000, /* U+4348 */
  0x0000, /* U+4349 */
  0x0000, /* U+434a */
  0x0000, /* U+434b */
  0x0000, /* U+434c */
  0x0000, /* U+434d */
  0x0000, /* U+434e */
  0x0000, /* U+434f */
  0x0000, /* U+4350 */
  0x0000, /* U+4351 */
  0x0000, /* U+4352 */
  0x0000, /* U+4353 */
  0x0000, /* U+4354 */
  0x0000, /* U+4355 */
  0x0000, /* U+4356 */
  0x0000, /* U+4357 */
  0x0000, /* U+4358 */
  0x0000, /* U+4359 */
  0x0000, /* U+435a */
  0x0000, /* U+435b */
  0x0000, /* U+435c */
  0x0000, /* U+435d */
  0x0000, /* U+435e */
  0x0000, /* U+435f */
  0x0000, /* U+4360 */
  0x0000, /* U+4361 */
  0x0000, /* U+4362 */
  0x0000, /* U+4363 */
  0x0000, /* U+4364 */
  0x0000, /* U+4365 */
  0x0000, /* U+4366 */
  0x0000, /* U+4367 */
  0x0000, /* U+4368 */
  0x0000, /* U+4369 */
  0x0000, /* U+436a */
  0x0000, /* U+436b */
  0x0000, /* U+436c */
  0x0000, /* U+436d */
  0x0000, /* U+436e */
  0x0000, /* U+436f */
  0x0000, /* U+4370 */
  0x0000, /* U+4371 */
  0x0000, /* U+4372 */
  0x0000, /* U+4373 */
  0x0000, /* U+4374 */
  0x0000, /* U+4375 */
  0x0000, /* U+4376 */
  0x0000, /* U+4377 */
  0x0000, /* U+4378 */
  0x0000, /* U+4379 */
  0x0000, /* U+437a */
  0x0000, /* U+437b */
  0x0000, /* U+437c */
  0x0000, /* U+437d */
  0x0000, /* U+437e */
  0x0000, /* U+437f */
  0x0000, /* U+4380 */
  0x0000, /* U+4381 */
  0x0000, /* U+4382 */
  0x0000, /* U+4383 */
  0x0000, /* U+4384 */
  0x0000, /* U+4385 */
  0x0000, /* U+4386 */
  0x0000, /* U+4387 */
  0x0000, /* U+4388 */
  0x0000, /* U+4389 */
  0x0000, /* U+438a */
  0x0000, /* U+438b */
  0x0000, /* U+438c */
  0x0000, /* U+438d */
  0x0000, /* U+438e */
  0x0000, /* U+438f */
  0x0000, /* U+4390 */
  0x0000, /* U+4391 */
  0x0000, /* U+4392 */
  0x0000, /* U+4393 */
  0x0000, /* U+4394 */
  0x0000, /* U+4395 */
  0x0000, /* U+4396 */
  0x0000, /* U+4397 */
  0x0000, /* U+4398 */
  0x0000, /* U+4399 */
  0x0000, /* U+439a */
  0x0000, /* U+439b */
  0x0000, /* U+439c */
  0x0000, /* U+439d */
  0x0000, /* U+439e */
  0x0000, /* U+439f */
  0x0000, /* U+43a0 */
  0x0000, /* U+43a1 */
  0x0000, /* U+43a2 */
  0x0000, /* U+43a3 */
  0x0000, /* U+43a4 */
  0x0000, /* U+43a5 */
  0x0000, /* U+43a6 */
  0x0000, /* U+43a7 */
  0x0000, /* U+43a8 */
  0x0000, /* U+43a9 */
  0x0000, /* U+43aa */
  0x0000, /* U+43ab */
  0x0000, /* U+43ac */
  0x0000, /* U+43ad */
  0x0000, /* U+43ae */
  0x0000, /* U+43af */
  0x0000, /* U+43b0 */
  0x0000, /* U+43b1 */
  0x0000, /* U+43b2 */
  0x0000, /* U+43b3 */
  0x0000, /* U+43b4 */
  0x0000, /* U+43b5 */
  0x0000, /* U+43b6 */
  0x0000, /* U+43b7 */
  0x0000, /* U+43b8 */
  0x0000, /* U+43b9 */
  0x0000, /* U+43ba */
  0x0000, /* U+43bb */
  0x0000, /* U+43bc */
  0x0000, /* U+43bd */
  0x0000, /* U+43be */
  0x0000, /* U+43bf */
  0x0000, /* U+43c0 */
  0x0000, /* U+43c1 */
  0x0000, /* U+43c2 */
  0x0000, /* U+43c3 */
  0x0000, /* U+43c4 */
  0x0000, /* U+43c5 */
  0x0000, /* U+43c6 */
  0x0000, /* U+43c7 */
  0x0000, /* U+43c8 */
  0x0000, /* U+43c9 */
  0x0000, /* U+43ca */
  0x0000, /* U+43cb */
  0x0000, /* U+43cc */
  0x0000, /* U+43cd */
  0x0000, /* U+43ce */
  0x0000, /* U+43cf */
  0x0000, /* U+43d0 */
  0x0000, /* U+43d1 */
  0x0000, /* U+43d2 */
  0x0000, /* U+43d3 */
  0x0000, /* U+43d4 */
  0x0000, /* U+43d5 */
  0x0000, /* U+43d6 */
  0x0000, /* U+43d7 */
  0x0000, /* U+43d8 */
  0x0000, /* U+43d9 */
  0x0000, /* U+43da */
  0x0000, /* U+43db */
  0x0000, /* U+43dc */
  0x0000, /* U+43dd */
  0x0000, /* U+43de */
  0x0000, /* U+43df */
  0x0000, /* U+43e0 */
  0x0000, /* U+43e1 */
  0x0000, /* U+43e2 */
  0x0000, /* U+43e3 */
  0x0000, /* U+43e4 */
  0x0000, /* U+43e5 */
  0x0000, /* U+43e6 */
  0x0000, /* U+43e7 */
  0x0000, /* U+43e8 */
  0x0000, /* U+43e9 */
  0x0000, /* U+43ea */
  0x0000, /* U+43eb */
  0x0000, /* U+43ec */
  0x0000, /* U+43ed */
  0x0000, /* U+43ee */
  0x0000, /* U+43ef */
  0x0000, /* U+43f0 */
  0x0000, /* U+43f1 */
  0x0000, /* U+43f2 */
  0x0000, /* U+43f3 */
  0x0000, /* U+43f4 */
  0x0000, /* U+43f5 */
  0x0000, /* U+43f6 */
  0x0000, /* U+43f7 */
  0x0000, /* U+43f8 */
  0x0000, /* U+43f9 */
  0x0000, /* U+43fa */
  0x0000, /* U+43fb */
  0x0000, /* U+43fc */
  0x0000, /* U+43fd */
  0x0000, /* U+43fe */
  0x0000, /* U+43ff */
  0x0000, /* U+4400 */
  0x0000, /* U+4401 */
  0x0000, /* U+4402 */
  0x0000, /* U+4403 */
  0x0000, /* U+4404 */
  0x0000, /* U+4405 */
  0x0000, /* U+4406 */
  0x0000, /* U+4407 */
  0x0000, /* U+4408 */
  0x0000, /* U+4409 */
  0x0000, /* U+440a */
  0x0000, /* U+440b */
  0x0000, /* U+440c */
  0x0000, /* U+440d */
  0x0000, /* U+440e */
  0x0000, /* U+440f */
  0x0000, /* U+4410 */
  0x0000, /* U+4411 */
  0x0000, /* U+4412 */
  0x0000, /* U+4413 */
  0x0000, /* U+4414 */
  0x0000, /* U+4415 */
  0x0000, /* U+4416 */
  0x0000, /* U+4417 */
  0x0000, /* U+4418 */
  0x0000, /* U+4419 */
  0x0000, /* U+441a */
  0x0000, /* U+441b */
  0x0000, /* U+441c */
  0x0000, /* U+441d */
  0x0000, /* U+441e */
  0x0000, /* U+441f */
  0x0000, /* U+4420 */
  0x0000, /* U+4421 */
  0x0000, /* U+4422 */
  0x0000, /* U+4423 */
  0x0000, /* U+4424 */
  0x0000, /* U+4425 */
  0x0000, /* U+4426 */
  0x0000, /* U+4427 */
  0x0000, /* U+4428 */
  0x0000, /* U+4429 */
  0x0000, /* U+442a */
  0x0000, /* U+442b */
  0x0000, /* U+442c */
  0x0000, /* U+442d */
  0x0000, /* U+442e */
  0x0000, /* U+442f */
  0x0000, /* U+4430 */
  0x0000, /* U+4431 */
  0x0000, /* U+4432 */
  0x0000, /* U+4433 */
  0x0000, /* U+4434 */
  0x0000, /* U+4435 */
  0x0000, /* U+4436 */
  0x0000, /* U+4437 */
  0x0000, /* U+4438 */
  0x0000, /* U+4439 */
  0x0000, /* U+443a */
  0x0000, /* U+443b */
  0x0000, /* U+443c */
  0x0000, /* U+443d */
  0x0000, /* U+443e */
  0x0000, /* U+443f */
  0x0000, /* U+4440 */
  0x0000, /* U+4441 */
  0x0000, /* U+4442 */
  0x0000, /* U+4443 */
  0x0000, /* U+4444 */
  0x0000, /* U+4445 */
  0x0000, /* U+4446 */
  0x0000, /* U+4447 */
  0x0000, /* U+4448 */
  0x0000, /* U+4449 */
  0x0000, /* U+444a */
  0x0000, /* U+444b */
  0x0000, /* U+444c */
  0x0000, /* U+444d */
  0x0000, /* U+444e */
  0x0000, /* U+444f */
  0x0000, /* U+4450 */
  0x0000, /* U+4451 */
  0x0000, /* U+4452 */
  0x0000, /* U+4453 */
  0x0000, /* U+4454 */
  0x0000, /* U+4455 */
  0x0000, /* U+4456 */
  0x0000, /* U+4457 */
  0x0000, /* U+4458 */
  0x0000, /* U+4459 */
  0x0000, /* U+445a */
  0x0000, /* U+445b */
  0x0000, /* U+445c */
  0x0000, /* U+445d */
  0x0000, /* U+445e */
  0x0000, /* U+445f */
  0x0000, /* U+4460 */
  0x0000, /* U+4461 */
  0x0000, /* U+4462 */
  0x0000, /* U+4463 */
  0x0000, /* U+4464 */
  0x0000, /* U+4465 */
  0x0000, /* U+4466 */
  0x0000, /* U+4467 */
  0x0000, /* U+4468 */
  0x0000, /* U+4469 */
  0x0000, /* U+446a */
  0x0000, /* U+446b */
  0x0000, /* U+446c */
  0x0000, /* U+446d */
  0x0000, /* U+446e */
  0x0000, /* U+446f */
  0x0000, /* U+4470 */
  0x0000, /* U+4471 */
  0x0000, /* U+4472 */
  0x0000, /* U+4473 */
  0x0000, /* U+4474 */
  0x0000, /* U+4475 */
  0x0000, /* U+4476 */
  0x0000, /* U+4477 */
  0x0000, /* U+4478 */
  0x0000, /* U+4479 */
  0x0000, /* U+447a */
  0x0000, /* U+447b */
  0x0000, /* U+447c */
  0x0000, /* U+447d */
  0x0000, /* U+447e */
  0x0000, /* U+447f */
  0x0000, /* U+4480 */
  0x0000, /* U+4481 */
  0x0000, /* U+4482 */
  0x0000, /* U+4483 */
  0x0000, /* U+4484 */
  0x0000, /* U+4485 */
  0x0000, /* U+4486 */
  0x0000, /* U+4487 */
  0x0000, /* U+4488 */
  0x0000, /* U+4489 */
  0x0000, /* U+448a */
  0x0000, /* U+448b */
  0x0000, /* U+448c */
  0x0000, /* U+448d */
  0x0000, /* U+448e */
  0x0000, /* U+448f */
  0x0000, /* U+4490 */
  0x0000, /* U+4491 */
  0x0000, /* U+4492 */
  0x0000, /* U+4493 */
  0x0000, /* U+4494 */
  0x0000, /* U+4495 */
  0x0000, /* U+4496 */
  0x0000, /* U+4497 */
  0x0000, /* U+4498 */
  0x0000, /* U+4499 */
  0x0000, /* U+449a */
  0x0000, /* U+449b */
  0x0000, /* U+449c */
  0x0000, /* U+449d */
  0x0000, /* U+449e */
  0x0000, /* U+449f */
  0x0000, /* U+44a0 */
  0x0000, /* U+44a1 */
  0x0000, /* U+44a2 */
  0x0000, /* U+44a3 */
  0x0000, /* U+44a4 */
  0x0000, /* U+44a5 */
  0x0000, /* U+44a6 */
  0x0000, /* U+44a7 */
  0x0000, /* U+44a8 */
  0x0000, /* U+44a9 */
  0x0000, /* U+44aa */
  0x0000, /* U+44ab */
  0x0000, /* U+44ac */
  0x0000, /* U+44ad */
  0x0000, /* U+44ae */
  0x0000, /* U+44af */
  0x0000, /* U+44b0 */
  0x0000, /* U+44b1 */
  0x0000, /* U+44b2 */
  0x0000, /* U+44b3 */
  0x0000, /* U+44b4 */
  0x0000, /* U+44b5 */
  0x0000, /* U+44b6 */
  0x0000, /* U+44b7 */
  0x0000, /* U+44b8 */
  0x0000, /* U+44b9 */
  0x0000, /* U+44ba */
  0x0000, /* U+44bb */
  0x0000, /* U+44bc */
  0x0000, /* U+44bd */
  0x0000, /* U+44be */
  0x0000, /* U+44bf */
  0x0000, /* U+44c0 */
  0x0000, /* U+44c1 */
  0x0000, /* U+44c2 */
  0x0000, /* U+44c3 */
  0x0000, /* U+44c4 */
  0x0000, /* U+44c5 */
  0x0000, /* U+44c6 */
  0x0000, /* U+44c7 */
  0x0000, /* U+44c8 */
  0x0000, /* U+44c9 */
  0x0000, /* U+44ca */
  0x0000, /* U+44cb */
  0x0000, /* U+44cc */
  0x0000, /* U+44cd */
  0x0000, /* U+44ce */
  0x0000, /* U+44cf */
  0x0000, /* U+44d0 */
  0x0000, /* U+44d1 */
  0x0000, /* U+44d2 */
  0x0000, /* U+44d3 */
  0x0000, /* U+44d4 */
  0x0000, /* U+44d5 */
  0x0000, /* U+44d6 */
  0x0000, /* U+44d7 */
  0x0000, /* U+44d8 */
  0x0000, /* U+44d9 */
  0x0000, /* U+44da */
  0x0000, /* U+44db */
  0x0000, /* U+44dc */
  0x0000, /* U+44dd */
  0x0000, /* U+44de */
  0x0000, /* U+44df */
  0x0000, /* U+44e0 */
  0x0000, /* U+44e1 */
  0x0000, /* U+44e2 */
  0x0000, /* U+44e3 */
  0x0000, /* U+44e4 */
  0x0000, /* U+44e5 */
  0x0000, /* U+44e6 */
  0x0000, /* U+44e7 */
  0x0000, /* U+44e8 */
  0x0000, /* U+44e9 */
  0x0000, /* U+44ea */
  0x0000, /* U+44eb */
  0x0000, /* U+44ec */
  0x0000, /* U+44ed */
  0x0000, /* U+44ee */
  0x0000, /* U+44ef */
  0x0000, /* U+44f0 */
  0x0000, /* U+44f1 */
  0x0000, /* U+44f2 */
  0x0000, /* U+44f3 */
  0x0000, /* U+44f4 */
  0x0000, /* U+44f5 */
  0x0000, /* U+44f6 */
  0x0000, /* U+44f7 */
  0x0000, /* U+44f8 */
  0x0000, /* U+44f9 */
  0x0000, /* U+44fa */
  0x0000, /* U+44fb */
  0x0000, /* U+44fc */
  0x0000, /* U+44fd */
  0x0000, /* U+44fe */
  0x0000, /* U+44ff */
  0x0000, /* U+4500 */
  0x0000, /* U+4501 */
  0x0000, /* U+4502 */
  0x0000, /* U+4503 */
  0x0000, /* U+4504 */
  0x0000, /* U+4505 */
  0x0000, /* U+4506 */
  0x0000, /* U+4507 */
  0x0000, /* U+4508 */
  0x0000, /* U+4509 */
  0x0000, /* U+450a */
  0x0000, /* U+450b */
  0x0000, /* U+450c */
  0x0000, /* U+450d */
  0x0000, /* U+450e */
  0x0000, /* U+450f */
  0x0000, /* U+4510 */
  0x0000, /* U+4511 */
  0x0000, /* U+4512 */
  0x0000, /* U+4513 */
  0x0000, /* U+4514 */
  0x0000, /* U+4515 */
  0x0000, /* U+4516 */
  0x0000, /* U+4517 */
  0x0000, /* U+4518 */
  0x0000, /* U+4519 */
  0x0000, /* U+451a */
  0x0000, /* U+451b */
  0x0000, /* U+451c */
  0x0000, /* U+451d */
  0x0000, /* U+451e */
  0x0000, /* U+451f */
  0x0000, /* U+4520 */
  0x0000, /* U+4521 */
  0x0000, /* U+4522 */
  0x0000, /* U+4523 */
  0x0000, /* U+4524 */
  0x0000, /* U+4525 */
  0x0000, /* U+4526 */
  0x0000, /* U+4527 */
  0x0000, /* U+4528 */
  0x0000, /* U+4529 */
  0x0000, /* U+452a */
  0x0000, /* U+452b */
  0x0000, /* U+452c */
  0x0000, /* U+452d */
  0x0000, /* U+452e */
  0x0000, /* U+452f */
  0x0000, /* U+4530 */
  0x0000, /* U+4531 */
  0x0000, /* U+4532 */
  0x0000, /* U+4533 */
  0x0000, /* U+4534 */
  0x0000, /* U+4535 */
  0x0000, /* U+4536 */
  0x0000, /* U+4537 */
  0x0000, /* U+4538 */
  0x0000, /* U+4539 */
  0x0000, /* U+453a */
  0x0000, /* U+453b */
  0x0000, /* U+453c */
  0x0000, /* U+453d */
  0x0000, /* U+453e */
  0x0000, /* U+453f */
  0x0000, /* U+4540 */
  0x0000, /* U+4541 */
  0x0000, /* U+4542 */
  0x0000, /* U+4543 */
  0x0000, /* U+4544 */
  0x0000, /* U+4545 */
  0x0000, /* U+4546 */
  0x0000, /* U+4547 */
  0x0000, /* U+4548 */
  0x0000, /* U+4549 */
  0x0000, /* U+454a */
  0x0000, /* U+454b */
  0x0000, /* U+454c */
  0x0000, /* U+454d */
  0x0000, /* U+454e */
  0x0000, /* U+454f */
  0x0000, /* U+4550 */
  0x0000, /* U+4551 */
  0x0000, /* U+4552 */
  0x0000, /* U+4553 */
  0x0000, /* U+4554 */
  0x0000, /* U+4555 */
  0x0000, /* U+4556 */
  0x0000, /* U+4557 */
  0x0000, /* U+4558 */
  0x0000, /* U+4559 */
  0x0000, /* U+455a */
  0x0000, /* U+455b */
  0x0000, /* U+455c */
  0x0000, /* U+455d */
  0x0000, /* U+455e */
  0x0000, /* U+455f */
  0x0000, /* U+4560 */
  0x0000, /* U+4561 */
  0x0000, /* U+4562 */
  0x0000, /* U+4563 */
  0x0000, /* U+4564 */
  0x0000, /* U+4565 */
  0x0000, /* U+4566 */
  0x0000, /* U+4567 */
  0x0000, /* U+4568 */
  0x0000, /* U+4569 */
  0x0000, /* U+456a */
  0x0000, /* U+456b */
  0x0000, /* U+456c */
  0x0000, /* U+456d */
  0x0000, /* U+456e */
  0x0000, /* U+456f */
  0x0000, /* U+4570 */
  0x0000, /* U+4571 */
  0x0000, /* U+4572 */
  0x0000, /* U+4573 */
  0x0000, /* U+4574 */
  0x0000, /* U+4575 */
  0x0000, /* U+4576 */
  0x0000, /* U+4577 */
  0x0000, /* U+4578 */
  0x0000, /* U+4579 */
  0x0000, /* U+457a */
  0x0000, /* U+457b */
  0x0000, /* U+457c */
  0x0000, /* U+457d */
  0x0000, /* U+457e */
  0x0000, /* U+457f */
  0x0000, /* U+4580 */
  0x0000, /* U+4581 */
  0x0000, /* U+4582 */
  0x0000, /* U+4583 */
  0x0000, /* U+4584 */
  0x0000, /* U+4585 */
  0x0000, /* U+4586 */
  0x0000, /* U+4587 */
  0x0000, /* U+4588 */
  0x0000, /* U+4589 */
  0x0000, /* U+458a */
  0x0000, /* U+458b */
  0x0000, /* U+458c */
  0x0000, /* U+458d */
  0x0000, /* U+458e */
  0x0000, /* U+458f */
  0x0000, /* U+4590 */
  0x0000, /* U+4591 */
  0x0000, /* U+4592 */
  0x0000, /* U+4593 */
  0x0000, /* U+4594 */
  0x0000, /* U+4595 */
  0x0000, /* U+4596 */
  0x0000, /* U+4597 */
  0x0000, /* U+4598 */
  0x0000, /* U+4599 */
  0x0000, /* U+459a */
  0x0000, /* U+459b */
  0x0000, /* U+459c */
  0x0000, /* U+459d */
  0x0000, /* U+459e */
  0x0000, /* U+459f */
  0x0000, /* U+45a0 */
  0x0000, /* U+45a1 */
  0x0000, /* U+45a2 */
  0x0000, /* U+45a3 */
  0x0000, /* U+45a4 */
  0x0000, /* U+45a5 */
  0x0000, /* U+45a6 */
  0x0000, /* U+45a7 */
  0x0000, /* U+45a8 */
  0x0000, /* U+45a9 */
  0x0000, /* U+45aa */
  0x0000, /* U+45ab */
  0x0000, /* U+45ac */
  0x0000, /* U+45ad */
  0x0000, /* U+45ae */
  0x0000, /* U+45af */
  0x0000, /* U+45b0 */
  0x0000, /* U+45b1 */
  0x0000, /* U+45b2 */
  0x0000, /* U+45b3 */
  0x0000, /* U+45b4 */
  0x0000, /* U+45b5 */
  0x0000, /* U+45b6 */
  0x0000, /* U+45b7 */
  0x0000, /* U+45b8 */
  0x0000, /* U+45b9 */
  0x0000, /* U+45ba */
  0x0000, /* U+45bb */
  0x0000, /* U+45bc */
  0x0000, /* U+45bd */
  0x0000, /* U+45be */
  0x0000, /* U+45bf */
  0x0000, /* U+45c0 */
  0x0000, /* U+45c1 */
  0x0000, /* U+45c2 */
  0x0000, /* U+45c3 */
  0x0000, /* U+45c4 */
  0x0000, /* U+45c5 */
  0x0000, /* U+45c6 */
  0x0000, /* U+45c7 */
  0x0000, /* U+45c8 */
  0x0000, /* U+45c9 */
  0x0000, /* U+45ca */
  0x0000, /* U+45cb */
  0x0000, /* U+45cc */
  0x0000, /* U+45cd */
  0x0000, /* U+45ce */
  0x0000, /* U+45cf */
  0x0000, /* U+45d0 */
  0x0000, /* U+45d1 */
  0x0000, /* U+45d2 */
  0x0000, /* U+45d3 */
  0x0000, /* U+45d4 */
  0x0000, /* U+45d5 */
  0x0000, /* U+45d6 */
  0x0000, /* U+45d7 */
  0x0000, /* U+45d8 */
  0x0000, /* U+45d9 */
  0x0000, /* U+45da */
  0x0000, /* U+45db */
  0x0000, /* U+45dc */
  0x0000, /* U+45dd */
  0x0000, /* U+45de */
  0x0000, /* U+45df */
  0x0000, /* U+45e0 */
  0x0000, /* U+45e1 */
  0x0000, /* U+45e2 */
  0x0000, /* U+45e3 */
  0x0000, /* U+45e4 */
  0x0000, /* U+45e5 */
  0x0000, /* U+45e6 */
  0x0000, /* U+45e7 */
  0x0000, /* U+45e8 */
  0x0000, /* U+45e9 */
  0x0000, /* U+45ea */
  0x0000, /* U+45eb */
  0x0000, /* U+45ec */
  0x0000, /* U+45ed */
  0x0000, /* U+45ee */
  0x0000, /* U+45ef */
  0x0000, /* U+45f0 */
  0x0000, /* U+45f1 */
  0x0000, /* U+45f2 */
  0x0000, /* U+45f3 */
  0x0000, /* U+45f4 */
  0x0000, /* U+45f5 */
  0x0000, /* U+45f6 */
  0x0000, /* U+45f7 */
  0x0000, /* U+45f8 */
  0x0000, /* U+45f9 */
  0x0000, /* U+45fa */
  0x0000, /* U+45fb */
  0x0000, /* U+45fc */
  0x0000, /* U+45fd */
  0x0000, /* U+45fe */
  0x0000, /* U+45ff */
  0x0000, /* U+4600 */
  0x0000, /* U+4601 */
  0x0000, /* U+4602 */
  0x0000, /* U+4603 */
  0x0000, /* U+4604 */
  0x0000, /* U+4605 */
  0x0000, /* U+4606 */
  0x0000, /* U+4607 */
  0x0000, /* U+4608 */
  0x0000, /* U+4609 */
  0x0000, /* U+460a */
  0x0000, /* U+460b */
  0x0000, /* U+460c */
  0x0000, /* U+460d */
  0x0000, /* U+460e */
  0x0000, /* U+460f */
  0x0000, /* U+4610 */
  0x0000, /* U+4611 */
  0x0000, /* U+4612 */
  0x0000, /* U+4613 */
  0x0000, /* U+4614 */
  0x0000, /* U+4615 */
  0x0000, /* U+4616 */
  0x0000, /* U+4617 */
  0x0000, /* U+4618 */
  0x0000, /* U+4619 */
  0x0000, /* U+461a */
  0x0000, /* U+461b */
  0x0000, /* U+461c */
  0x0000, /* U+461d */
  0x0000, /* U+461e */
  0x0000, /* U+461f */
  0x0000, /* U+4620 */
  0x0000, /* U+4621 */
  0x0000, /* U+4622 */
  0x0000, /* U+4623 */
  0x0000, /* U+4624 */
  0x0000, /* U+4625 */
  0x0000, /* U+4626 */
  0x0000, /* U+4627 */
  0x0000, /* U+4628 */
  0x0000, /* U+4629 */
  0x0000, /* U+462a */
  0x0000, /* U+462b */
  0x0000, /* U+462c */
  0x0000, /* U+462d */
  0x0000, /* U+462e */
  0x0000, /* U+462f */
  0x0000, /* U+4630 */
  0x0000, /* U+4631 */
  0x0000, /* U+4632 */
  0x0000, /* U+4633 */
  0x0000, /* U+4634 */
  0x0000, /* U+4635 */
  0x0000, /* U+4636 */
  0x0000, /* U+4637 */
  0x0000, /* U+4638 */
  0x0000, /* U+4639 */
  0x0000, /* U+463a */
  0x0000, /* U+463b */
  0x0000, /* U+463c */
  0x0000, /* U+463d */
  0x0000, /* U+463e */
  0x0000, /* U+463f */
  0x0000, /* U+4640 */
  0x0000, /* U+4641 */
  0x0000, /* U+4642 */
  0x0000, /* U+4643 */
  0x0000, /* U+4644 */
  0x0000, /* U+4645 */
  0x0000, /* U+4646 */
  0x0000, /* U+4647 */
  0x0000, /* U+4648 */
  0x0000, /* U+4649 */
  0x0000, /* U+464a */
  0x0000, /* U+464b */
  0x0000, /* U+464c */
  0x0000, /* U+464d */
  0x0000, /* U+464e */
  0x0000, /* U+464f */
  0x0000, /* U+4650 */
  0x0000, /* U+4651 */
  0x0000, /* U+4652 */
  0x0000, /* U+4653 */
  0x0000, /* U+4654 */
  0x0000, /* U+4655 */
  0x0000, /* U+4656 */
  0x0000, /* U+4657 */
  0x0000, /* U+4658 */
  0x0000, /* U+4659 */
  0x0000, /* U+465a */
  0x0000, /* U+465b */
  0x0000, /* U+465c */
  0x0000, /* U+465d */
  0x0000, /* U+465e */
  0x0000, /* U+465f */
  0x0000, /* U+4660 */
  0x0000, /* U+4661 */
  0x0000, /* U+4662 */
  0x0000, /* U+4663 */
  0x0000, /* U+4664 */
  0x0000, /* U+4665 */
  0x0000, /* U+4666 */
  0x0000, /* U+4667 */
  0x0000, /* U+4668 */
  0x0000, /* U+4669 */
  0x0000, /* U+466a */
  0x0000, /* U+466b */
  0x0000, /* U+466c */
  0x0000, /* U+466d */
  0x0000, /* U+466e */
  0x0000, /* U+466f */
  0x0000, /* U+4670 */
  0x0000, /* U+4671 */
  0x0000, /* U+4672 */
  0x0000, /* U+4673 */
  0x0000, /* U+4674 */
  0x0000, /* U+4675 */
  0x0000, /* U+4676 */
  0x0000, /* U+4677 */
  0x0000, /* U+4678 */
  0x0000, /* U+4679 */
  0x0000, /* U+467a */
  0x0000, /* U+467b */
  0x0000, /* U+467c */
  0x0000, /* U+467d */
  0x0000, /* U+467e */
  0x0000, /* U+467f */
  0x0000, /* U+4680 */
  0x0000, /* U+4681 */
  0x0000, /* U+4682 */
  0x0000, /* U+4683 */
  0x0000, /* U+4684 */
  0x0000, /* U+4685 */
  0x0000, /* U+4686 */
  0x0000, /* U+4687 */
  0x0000, /* U+4688 */
  0x0000, /* U+4689 */
  0x0000, /* U+468a */
  0x0000, /* U+468b */
  0x0000, /* U+468c */
  0x0000, /* U+468d */
  0x0000, /* U+468e */
  0x0000, /* U+468f */
  0x0000, /* U+4690 */
  0x0000, /* U+4691 */
  0x0000, /* U+4692 */
  0x0000, /* U+4693 */
  0x0000, /* U+4694 */
  0x0000, /* U+4695 */
  0x0000, /* U+4696 */
  0x0000, /* U+4697 */
  0x0000, /* U+4698 */
  0x0000, /* U+4699 */
  0x0000, /* U+469a */
  0x0000, /* U+469b */
  0x0000, /* U+469c */
  0x0000, /* U+469d */
  0x0000, /* U+469e */
  0x0000, /* U+469f */
  0x0000, /* U+46a0 */
  0x0000, /* U+46a1 */
  0x0000, /* U+46a2 */
  0x0000, /* U+46a3 */
  0x0000, /* U+46a4 */
  0x0000, /* U+46a5 */
  0x0000, /* U+46a6 */
  0x0000, /* U+46a7 */
  0x0000, /* U+46a8 */
  0x0000, /* U+46a9 */
  0x0000, /* U+46aa */
  0x0000, /* U+46ab */
  0x0000, /* U+46ac */
  0x0000, /* U+46ad */
  0x0000, /* U+46ae */
  0x0000, /* U+46af */
  0x0000, /* U+46b0 */
  0x0000, /* U+46b1 */
  0x0000, /* U+46b2 */
  0x0000, /* U+46b3 */
  0x0000, /* U+46b4 */
  0x0000, /* U+46b5 */
  0x0000, /* U+46b6 */
  0x0000, /* U+46b7 */
  0x0000, /* U+46b8 */
  0x0000, /* U+46b9 */
  0x0000, /* U+46ba */
  0x0000, /* U+46bb */
  0x0000, /* U+46bc */
  0x0000, /* U+46bd */
  0x0000, /* U+46be */
  0x0000, /* U+46bf */
  0x0000, /* U+46c0 */
  0x0000, /* U+46c1 */
  0x0000, /* U+46c2 */
  0x0000, /* U+46c3 */
  0x0000, /* U+46c4 */
  0x0000, /* U+46c5 */
  0x0000, /* U+46c6 */
  0x0000, /* U+46c7 */
  0x0000, /* U+46c8 */
  0x0000, /* U+46c9 */
  0x0000, /* U+46ca */
  0x0000, /* U+46cb */
  0x0000, /* U+46cc */
  0x0000, /* U+46cd */
  0x0000, /* U+46ce */
  0x0000, /* U+46cf */
  0x0000, /* U+46d0 */
  0x0000, /* U+46d1 */
  0x0000, /* U+46d2 */
  0x0000, /* U+46d3 */
  0x0000, /* U+46d4 */
  0x0000, /* U+46d5 */
  0x0000, /* U+46d6 */
  0x0000, /* U+46d7 */
  0x0000, /* U+46d8 */
  0x0000, /* U+46d9 */
  0x0000, /* U+46da */
  0x0000, /* U+46db */
  0x0000, /* U+46dc */
  0x0000, /* U+46dd */
  0x0000, /* U+46de */
  0x0000, /* U+46df */
  0x0000, /* U+46e0 */
  0x0000, /* U+46e1 */
  0x0000, /* U+46e2 */
  0x0000, /* U+46e3 */
  0x0000, /* U+46e4 */
  0x0000, /* U+46e5 */
  0x0000, /* U+46e6 */
  0x0000, /* U+46e7 */
  0x0000, /* U+46e8 */
  0x0000, /* U+46e9 */
  0x0000, /* U+46ea */
  0x0000, /* U+46eb */
  0x0000, /* U+46ec */
  0x0000, /* U+46ed */
  0x0000, /* U+46ee */
  0x0000, /* U+46ef */
  0x0000, /* U+46f0 */
  0x0000, /* U+46f1 */
  0x0000, /* U+46f2 */
  0x0000, /* U+46f3 */
  0x0000, /* U+46f4 */
  0x0000, /* U+46f5 */
  0x0000, /* U+46f6 */
  0x0000, /* U+46f7 */
  0x0000, /* U+46f8 */
  0x0000, /* U+46f9 */
  0x0000, /* U+46fa */
  0x0000, /* U+46fb */
  0x0000, /* U+46fc */
  0x0000, /* U+46fd */
  0x0000, /* U+46fe */
  0x0000, /* U+46ff */
  0x0000, /* U+4700 */
  0x0000, /* U+4701 */
  0x0000, /* U+4702 */
  0x0000, /* U+4703 */
  0x0000, /* U+4704 */
  0x0000, /* U+4705 */
  0x0000, /* U+4706 */
  0x0000, /* U+4707 */
  0x0000, /* U+4708 */
  0x0000, /* U+4709 */
  0x0000, /* U+470a */
  0x0000, /* U+470b */
  0x0000, /* U+470c */
  0x0000, /* U+470d */
  0x0000, /* U+470e */
  0x0000, /* U+470f */
  0x0000, /* U+4710 */
  0x0000, /* U+4711 */
  0x0000, /* U+4712 */
  0x0000, /* U+4713 */
  0x0000, /* U+4714 */
  0x0000, /* U+4715 */
  0x0000, /* U+4716 */
  0x0000, /* U+4717 */
  0x0000, /* U+4718 */
  0x0000, /* U+4719 */
  0x0000, /* U+471a */
  0x0000, /* U+471b */
  0x0000, /* U+471c */
  0x0000, /* U+471d */
  0x0000, /* U+471e */
  0x0000, /* U+471f */
  0x0000, /* U+4720 */
  0x0000, /* U+4721 */
  0x0000, /* U+4722 */
  0x0000, /* U+4723 */
  0x0000, /* U+4724 */
  0x0000, /* U+4725 */
  0x0000, /* U+4726 */
  0x0000, /* U+4727 */
  0x0000, /* U+4728 */
  0x0000, /* U+4729 */
  0x0000, /* U+472a */
  0x0000, /* U+472b */
  0x0000, /* U+472c */
  0x0000, /* U+472d */
  0x0000, /* U+472e */
  0x0000, /* U+472f */
  0x0000, /* U+4730 */
  0x0000, /* U+4731 */
  0x0000, /* U+4732 */
  0x0000, /* U+4733 */
  0x0000, /* U+4734 */
  0x0000, /* U+4735 */
  0x0000, /* U+4736 */
  0x0000, /* U+4737 */
  0x0000, /* U+4738 */
  0x0000, /* U+4739 */
  0x0000, /* U+473a */
  0x0000, /* U+473b */
  0x0000, /* U+473c */
  0x0000, /* U+473d */
  0x0000, /* U+473e */
  0x0000, /* U+473f */
  0x0000, /* U+4740 */
  0x0000, /* U+4741 */
  0x0000, /* U+4742 */
  0x0000, /* U+4743 */
  0x0000, /* U+4744 */
  0x0000, /* U+4745 */
  0x0000, /* U+4746 */
  0x0000, /* U+4747 */
  0x0000, /* U+4748 */
  0x0000, /* U+4749 */
  0x0000, /* U+474a */
  0x0000, /* U+474b */
  0x0000, /* U+474c */
  0x0000, /* U+474d */
  0x0000, /* U+474e */
  0x0000, /* U+474f */
  0x0000, /* U+4750 */
  0x0000, /* U+4751 */
  0x0000, /* U+4752 */
  0x0000, /* U+4753 */
  0x0000, /* U+4754 */
  0x0000, /* U+4755 */
  0x0000, /* U+4756 */
  0x0000, /* U+4757 */
  0x0000, /* U+4758 */
  0x0000, /* U+4759 */
  0x0000, /* U+475a */
  0x0000, /* U+475b */
  0x0000, /* U+475c */
  0x0000, /* U+475d */
  0x0000, /* U+475e */
  0x0000, /* U+475f */
  0x0000, /* U+4760 */
  0x0000, /* U+4761 */
  0x0000, /* U+4762 */
  0x0000, /* U+4763 */
  0x0000, /* U+4764 */
  0x0000, /* U+4765 */
  0x0000, /* U+4766 */
  0x0000, /* U+4767 */
  0x0000, /* U+4768 */
  0x0000, /* U+4769 */
  0x0000, /* U+476a */
  0x0000, /* U+476b */
  0x0000, /* U+476c */
  0x0000, /* U+476d */
  0x0000, /* U+476e */
  0x0000, /* U+476f */
  0x0000, /* U+4770 */
  0x0000, /* U+4771 */
  0x0000, /* U+4772 */
  0x0000, /* U+4773 */
  0x0000, /* U+4774 */
  0x0000, /* U+4775 */
  0x0000, /* U+4776 */
  0x0000, /* U+4777 */
  0x0000, /* U+4778 */
  0x0000, /* U+4779 */
  0x0000, /* U+477a */
  0x0000, /* U+477b */
  0x0000, /* U+477c */
  0x0000, /* U+477d */
  0x0000, /* U+477e */
  0x0000, /* U+477f */
  0x0000, /* U+4780 */
  0x0000, /* U+4781 */
  0x0000, /* U+4782 */
  0x0000, /* U+4783 */
  0x0000, /* U+4784 */
  0x0000, /* U+4785 */
  0x0000, /* U+4786 */
  0x0000, /* U+4787 */
  0x0000, /* U+4788 */
  0x0000, /* U+4789 */
  0x0000, /* U+478a */
  0x0000, /* U+478b */
  0x0000, /* U+478c */
  0x0000, /* U+478d */
  0x0000, /* U+478e */
  0x0000, /* U+478f */
  0x0000, /* U+4790 */
  0x0000, /* U+4791 */
  0x0000, /* U+4792 */
  0x0000, /* U+4793 */
  0x0000, /* U+4794 */
  0x0000, /* U+4795 */
  0x0000, /* U+4796 */
  0x0000, /* U+4797 */
  0x0000, /* U+4798 */
  0x0000, /* U+4799 */
  0x0000, /* U+479a */
  0x0000, /* U+479b */
  0x0000, /* U+479c */
  0x0000, /* U+479d */
  0x0000, /* U+479e */
  0x0000, /* U+479f */
  0x0000, /* U+47a0 */
  0x0000, /* U+47a1 */
  0x0000, /* U+47a2 */
  0x0000, /* U+47a3 */
  0x0000, /* U+47a4 */
  0x0000, /* U+47a5 */
  0x0000, /* U+47a6 */
  0x0000, /* U+47a7 */
  0x0000, /* U+47a8 */
  0x0000, /* U+47a9 */
  0x0000, /* U+47aa */
  0x0000, /* U+47ab */
  0x0000, /* U+47ac */
  0x0000, /* U+47ad */
  0x0000, /* U+47ae */
  0x0000, /* U+47af */
  0x0000, /* U+47b0 */
  0x0000, /* U+47b1 */
  0x0000, /* U+47b2 */
  0x0000, /* U+47b3 */
  0x0000, /* U+47b4 */
  0x0000, /* U+47b5 */
  0x0000, /* U+47b6 */
  0x0000, /* U+47b7 */
  0x0000, /* U+47b8 */
  0x0000, /* U+47b9 */
  0x0000, /* U+47ba */
  0x0000, /* U+47bb */
  0x0000, /* U+47bc */
  0x0000, /* U+47bd */
  0x0000, /* U+47be */
  0x0000, /* U+47bf */
  0x0000, /* U+47c0 */
  0x0000, /* U+47c1 */
  0x0000, /* U+47c2 */
  0x0000, /* U+47c3 */
  0x0000, /* U+47c4 */
  0x0000, /* U+47c5 */
  0x0000, /* U+47c6 */
  0x0000, /* U+47c7 */
  0x0000, /* U+47c8 */
  0x0000, /* U+47c9 */
  0x0000, /* U+47ca */
  0x0000, /* U+47cb */
  0x0000, /* U+47cc */
  0x0000, /* U+47cd */
  0x0000, /* U+47ce */
  0x0000, /* U+47cf */
  0x0000, /* U+47d0 */
  0x0000, /* U+47d1 */
  0x0000, /* U+47d2 */
  0x0000, /* U+47d3 */
  0x0000, /* U+47d4 */
  0x0000, /* U+47d5 */
  0x0000, /* U+47d6 */
  0x0000, /* U+47d7 */
  0x0000, /* U+47d8 */
  0x0000, /* U+47d9 */
  0x0000, /* U+47da */
  0x0000, /* U+47db */
  0x0000, /* U+47dc */
  0x0000, /* U+47dd */
  0x0000, /* U+47de */
  0x0000, /* U+47df */
  0x0000, /* U+47e0 */
  0x0000, /* U+47e1 */
  0x0000, /* U+47e2 */
  0x0000, /* U+47e3 */
  0x0000, /* U+47e4 */
  0x0000, /* U+47e5 */
  0x0000, /* U+47e6 */
  0x0000, /* U+47e7 */
  0x0000, /* U+47e8 */
  0x0000, /* U+47e9 */
  0x0000, /* U+47ea */
  0x0000, /* U+47eb */
  0x0000, /* U+47ec */
  0x0000, /* U+47ed */
  0x0000, /* U+47ee */
  0x0000, /* U+47ef */
  0x0000, /* U+47f0 */
  0x0000, /* U+47f1 */
  0x0000, /* U+47f2 */
  0x0000, /* U+47f3 */
  0x0000, /* U+47f4 */
  0x0000, /* U+47f5 */
  0x0000, /* U+47f6 */
  0x0000, /* U+47f7 */
  0x0000, /* U+47f8 */
  0x0000, /* U+47f9 */
  0x0000, /* U+47fa */
  0x0000, /* U+47fb */
  0x0000, /* U+47fc */
  0x0000, /* U+47fd */
  0x0000, /* U+47fe */
  0x0000, /* U+47ff */
  0x0000, /* U+4800 */
  0x0000, /* U+4801 */
  0x0000, /* U+4802 */
  0x0000, /* U+4803 */
  0x0000, /* U+4804 */
  0x0000, /* U+4805 */
  0x0000, /* U+4806 */
  0x0000, /* U+4807 */
  0x0000, /* U+4808 */
  0x0000, /* U+4809 */
  0x0000, /* U+480a */
  0x0000, /* U+480b */
  0x0000, /* U+480c */
  0x0000, /* U+480d */
  0x0000, /* U+480e */
  0x0000, /* U+480f */
  0x0000, /* U+4810 */
  0x0000, /* U+4811 */
  0x0000, /* U+4812 */
  0x0000, /* U+4813 */
  0x0000, /* U+4814 */
  0x0000, /* U+4815 */
  0x0000, /* U+4816 */
  0x0000, /* U+4817 */
  0x0000, /* U+4818 */
  0x0000, /* U+4819 */
  0x0000, /* U+481a */
  0x0000, /* U+481b */
  0x0000, /* U+481c */
  0x0000, /* U+481d */
  0x0000, /* U+481e */
  0x0000, /* U+481f */
  0x0000, /* U+4820 */
  0x0000, /* U+4821 */
  0x0000, /* U+4822 */
  0x0000, /* U+4823 */
  0x0000, /* U+4824 */
  0x0000, /* U+4825 */
  0x0000, /* U+4826 */
  0x0000, /* U+4827 */
  0x0000, /* U+4828 */
  0x0000, /* U+4829 */
  0x0000, /* U+482a */
  0x0000, /* U+482b */
  0x0000, /* U+482c */
  0x0000, /* U+482d */
  0x0000, /* U+482e */
  0x0000, /* U+482f */
  0x0000, /* U+4830 */
  0x0000, /* U+4831 */
  0x0000, /* U+4832 */
  0x0000, /* U+4833 */
  0x0000, /* U+4834 */
  0x0000, /* U+4835 */
  0x0000, /* U+4836 */
  0x0000, /* U+4837 */
  0x0000, /* U+4838 */
  0x0000, /* U+4839 */
  0x0000, /* U+483a */
  0x0000, /* U+483b */
  0x0000, /* U+483c */
  0x0000, /* U+483d */
  0x0000, /* U+483e */
  0x0000, /* U+483f */
  0x0000, /* U+4840 */
  0x0000, /* U+4841 */
  0x0000, /* U+4842 */
  0x0000, /* U+4843 */
  0x0000, /* U+4844 */
  0x0000, /* U+4845 */
  0x0000, /* U+4846 */
  0x0000, /* U+4847 */
  0x0000, /* U+4848 */
  0x0000, /* U+4849 */
  0x0000, /* U+484a */
  0x0000, /* U+484b */
  0x0000, /* U+484c */
  0x0000, /* U+484d */
  0x0000, /* U+484e */
  0x0000, /* U+484f */
  0x0000, /* U+4850 */
  0x0000, /* U+4851 */
  0x0000, /* U+4852 */
  0x0000, /* U+4853 */
  0x0000, /* U+4854 */
  0x0000, /* U+4855 */
  0x0000, /* U+4856 */
  0x0000, /* U+4857 */
  0x0000, /* U+4858 */
  0x0000, /* U+4859 */
  0x0000, /* U+485a */
  0x0000, /* U+485b */
  0x0000, /* U+485c */
  0x0000, /* U+485d */
  0x0000, /* U+485e */
  0x0000, /* U+485f */
  0x0000, /* U+4860 */
  0x0000, /* U+4861 */
  0x0000, /* U+4862 */
  0x0000, /* U+4863 */
  0x0000, /* U+4864 */
  0x0000, /* U+4865 */
  0x0000, /* U+4866 */
  0x0000, /* U+4867 */
  0x0000, /* U+4868 */
  0x0000, /* U+4869 */
  0x0000, /* U+486a */
  0x0000, /* U+486b */
  0x0000, /* U+486c */
  0x0000, /* U+486d */
  0x0000, /* U+486e */
  0x0000, /* U+486f */
  0x0000, /* U+4870 */
  0x0000, /* U+4871 */
  0x0000, /* U+4872 */
  0x0000, /* U+4873 */
  0x0000, /* U+4874 */
  0x0000, /* U+4875 */
  0x0000, /* U+4876 */
  0x0000, /* U+4877 */
  0x0000, /* U+4878 */
  0x0000, /* U+4879 */
  0x0000, /* U+487a */
  0x0000, /* U+487b */
  0x0000, /* U+487c */
  0x0000, /* U+487d */
  0x0000, /* U+487e */
  0x0000, /* U+487f */
  0x0000, /* U+4880 */
  0x0000, /* U+4881 */
  0x0000, /* U+4882 */
  0x0000, /* U+4883 */
  0x0000, /* U+4884 */
  0x0000, /* U+4885 */
  0x0000, /* U+4886 */
  0x0000, /* U+4887 */
  0x0000, /* U+4888 */
  0x0000, /* U+4889 */
  0x0000, /* U+488a */
  0x0000, /* U+488b */
  0x0000, /* U+488c */
  0x0000, /* U+488d */
  0x0000, /* U+488e */
  0x0000, /* U+488f */
  0x0000, /* U+4890 */
  0x0000, /* U+4891 */
  0x0000, /* U+4892 */
  0x0000, /* U+4893 */
  0x0000, /* U+4894 */
  0x0000, /* U+4895 */
  0x0000, /* U+4896 */
  0x0000, /* U+4897 */
  0x0000, /* U+4898 */
  0x0000, /* U+4899 */
  0x0000, /* U+489a */
  0x0000, /* U+489b */
  0x0000, /* U+489c */
  0x0000, /* U+489d */
  0x0000, /* U+489e */
  0x0000, /* U+489f */
  0x0000, /* U+48a0 */
  0x0000, /* U+48a1 */
  0x0000, /* U+48a2 */
  0x0000, /* U+48a3 */
  0x0000, /* U+48a4 */
  0x0000, /* U+48a5 */
  0x0000, /* U+48a6 */
  0x0000, /* U+48a7 */
  0x0000, /* U+48a8 */
  0x0000, /* U+48a9 */
  0x0000, /* U+48aa */
  0x0000, /* U+48ab */
  0x0000, /* U+48ac */
  0x0000, /* U+48ad */
  0x0000, /* U+48ae */
  0x0000, /* U+48af */
  0x0000, /* U+48b0 */
  0x0000, /* U+48b1 */
  0x0000, /* U+48b2 */
  0x0000, /* U+48b3 */
  0x0000, /* U+48b4 */
  0x0000, /* U+48b5 */
  0x0000, /* U+48b6 */
  0x0000, /* U+48b7 */
  0x0000, /* U+48b8 */
  0x0000, /* U+48b9 */
  0x0000, /* U+48ba */
  0x0000, /* U+48bb */
  0x0000, /* U+48bc */
  0x0000, /* U+48bd */
  0x0000, /* U+48be */
  0x0000, /* U+48bf */
  0x0000, /* U+48c0 */
  0x0000, /* U+48c1 */
  0x0000, /* U+48c2 */
  0x0000, /* U+48c3 */
  0x0000, /* U+48c4 */
  0x0000, /* U+48c5 */
  0x0000, /* U+48c6 */
  0x0000, /* U+48c7 */
  0x0000, /* U+48c8 */
  0x0000, /* U+48c9 */
  0x0000, /* U+48ca */
  0x0000, /* U+48cb */
  0x0000, /* U+48cc */
  0x0000, /* U+48cd */
  0x0000, /* U+48ce */
  0x0000, /* U+48cf */
  0x0000, /* U+48d0 */
  0x0000, /* U+48d1 */
  0x0000, /* U+48d2 */
  0x0000, /* U+48d3 */
  0x0000, /* U+48d4 */
  0x0000, /* U+48d5 */
  0x0000, /* U+48d6 */
  0x0000, /* U+48d7 */
  0x0000, /* U+48d8 */
  0x0000, /* U+48d9 */
  0x0000, /* U+48da */
  0x0000, /* U+48db */
  0x0000, /* U+48dc */
  0x0000, /* U+48dd */
  0x0000, /* U+48de */
  0x0000, /* U+48df */
  0x0000, /* U+48e0 */
  0x0000, /* U+48e1 */
  0x0000, /* U+48e2 */
  0x0000, /* U+48e3 */
  0x0000, /* U+48e4 */
  0x0000, /* U+48e5 */
  0x0000, /* U+48e6 */
  0x0000, /* U+48e7 */
  0x0000, /* U+48e8 */
  0x0000, /* U+48e9 */
  0x0000, /* U+48ea */
  0x0000, /* U+48eb */
  0x0000, /* U+48ec */
  0x0000, /* U+48ed */
  0x0000, /* U+48ee */
  0x0000, /* U+48ef */
  0x0000, /* U+48f0 */
  0x0000, /* U+48f1 */
  0x0000, /* U+48f2 */
  0x0000, /* U+48f3 */
  0x0000, /* U+48f4 */
  0x0000, /* U+48f5 */
  0x0000, /* U+48f6 */
  0x0000, /* U+48f7 */
  0x0000, /* U+48f8 */
  0x0000, /* U+48f9 */
  0x0000, /* U+48fa */
  0x0000, /* U+48fb */
  0x0000, /* U+48fc */
  0x0000, /* U+48fd */
  0x0000, /* U+48fe */
  0x0000, /* U+48ff */
  0x0000, /* U+4900 */
  0x0000, /* U+4901 */
  0x0000, /* U+4902 */
  0x0000, /* U+4903 */
  0x0000, /* U+4904 */
  0x0000, /* U+4905 */
  0x0000, /* U+4906 */
  0x0000, /* U+4907 */
  0x0000, /* U+4908 */
  0x0000, /* U+4909 */
  0x0000, /* U+490a */
  0x0000, /* U+490b */
  0x0000, /* U+490c */
  0x0000, /* U+490d */
  0x0000, /* U+490e */
  0x0000, /* U+490f */
  0x0000, /* U+4910 */
  0x0000, /* U+4911 */
  0x0000, /* U+4912 */
  0x0000, /* U+4913 */
  0x0000, /* U+4914 */
  0x0000, /* U+4915 */
  0x0000, /* U+4916 */
  0x0000, /* U+4917 */
  0x0000, /* U+4918 */
  0x0000, /* U+4919 */
  0x0000, /* U+491a */
  0x0000, /* U+491b */
  0x0000, /* U+491c */
  0x0000, /* U+491d */
  0x0000, /* U+491e */
  0x0000, /* U+491f */
  0x0000, /* U+4920 */
  0x0000, /* U+4921 */
  0x0000, /* U+4922 */
  0x0000, /* U+4923 */
  0x0000, /* U+4924 */
  0x0000, /* U+4925 */
  0x0000, /* U+4926 */
  0x0000, /* U+4927 */
  0x0000, /* U+4928 */
  0x0000, /* U+4929 */
  0x0000, /* U+492a */
  0x0000, /* U+492b */
  0x0000, /* U+492c */
  0x0000, /* U+492d */
  0x0000, /* U+492e */
  0x0000, /* U+492f */
  0x0000, /* U+4930 */
  0x0000, /* U+4931 */
  0x0000, /* U+4932 */
  0x0000, /* U+4933 */
  0x0000, /* U+4934 */
  0x0000, /* U+4935 */
  0x0000, /* U+4936 */
  0x0000, /* U+4937 */
  0x0000, /* U+4938 */
  0x0000, /* U+4939 */
  0x0000, /* U+493a */
  0x0000, /* U+493b */
  0x0000, /* U+493c */
  0x0000, /* U+493d */
  0x0000, /* U+493e */
  0x0000, /* U+493f */
  0x0000, /* U+4940 */
  0x0000, /* U+4941 */
  0x0000, /* U+4942 */
  0x0000, /* U+4943 */
  0x0000, /* U+4944 */
  0x0000, /* U+4945 */
  0x0000, /* U+4946 */
  0x0000, /* U+4947 */
  0x0000, /* U+4948 */
  0x0000, /* U+4949 */
  0x0000, /* U+494a */
  0x0000, /* U+494b */
  0x0000, /* U+494c */
  0x0000, /* U+494d */
  0x0000, /* U+494e */
  0x0000, /* U+494f */
  0x0000, /* U+4950 */
  0x0000, /* U+4951 */
  0x0000, /* U+4952 */
  0x0000, /* U+4953 */
  0x0000, /* U+4954 */
  0x0000, /* U+4955 */
  0x0000, /* U+4956 */
  0x0000, /* U+4957 */
  0x0000, /* U+4958 */
  0x0000, /* U+4959 */
  0x0000, /* U+495a */
  0x0000, /* U+495b */
  0x0000, /* U+495c */
  0x0000, /* U+495d */
  0x0000, /* U+495e */
  0x0000, /* U+495f */
  0x0000, /* U+4960 */
  0x0000, /* U+4961 */
  0x0000, /* U+4962 */
  0x0000, /* U+4963 */
  0x0000, /* U+4964 */
  0x0000, /* U+4965 */
  0x0000, /* U+4966 */
  0x0000, /* U+4967 */
  0x0000, /* U+4968 */
  0x0000, /* U+4969 */
  0x0000, /* U+496a */
  0x0000, /* U+496b */
  0x0000, /* U+496c */
  0x0000, /* U+496d */
  0x0000, /* U+496e */
  0x0000, /* U+496f */
  0x0000, /* U+4970 */
  0x0000, /* U+4971 */
  0x0000, /* U+4972 */
  0x0000, /* U+4973 */
  0x0000, /* U+4974 */
  0x0000, /* U+4975 */
  0x0000, /* U+4976 */
  0x0000, /* U+4977 */
  0x0000, /* U+4978 */
  0x0000, /* U+4979 */
  0x0000, /* U+497a */
  0x0000, /* U+497b */
  0x0000, /* U+497c */
  0x0000, /* U+497d */
  0x0000, /* U+497e */
  0x0000, /* U+497f */
  0x0000, /* U+4980 */
  0x0000, /* U+4981 */
  0x0000, /* U+4982 */
  0x0000, /* U+4983 */
  0x0000, /* U+4984 */
  0x0000, /* U+4985 */
  0x0000, /* U+4986 */
  0x0000, /* U+4987 */
  0x0000, /* U+4988 */
  0x0000, /* U+4989 */
  0x0000, /* U+498a */
  0x0000, /* U+498b */
  0x0000, /* U+498c */
  0x0000, /* U+498d */
  0x0000, /* U+498e */
  0x0000, /* U+498f */
  0x0000, /* U+4990 */
  0x0000, /* U+4991 */
  0x0000, /* U+4992 */
  0x0000, /* U+4993 */
  0x0000, /* U+4994 */
  0x0000, /* U+4995 */
  0x0000, /* U+4996 */
  0x0000, /* U+4997 */
  0x0000, /* U+4998 */
  0x0000, /* U+4999 */
  0x0000, /* U+499a */
  0x0000, /* U+499b */
  0x0000, /* U+499c */
  0x0000, /* U+499d */
  0x0000, /* U+499e */
  0x0000, /* U+499f */
  0x0000, /* U+49a0 */
  0x0000, /* U+49a1 */
  0x0000, /* U+49a2 */
  0x0000, /* U+49a3 */
  0x0000, /* U+49a4 */
  0x0000, /* U+49a5 */
  0x0000, /* U+49a6 */
  0x0000, /* U+49a7 */
  0x0000, /* U+49a8 */
  0x0000, /* U+49a9 */
  0x0000, /* U+49aa */
  0x0000, /* U+49ab */
  0x0000, /* U+49ac */
  0x0000, /* U+49ad */
  0x0000, /* U+49ae */
  0x0000, /* U+49af */
  0x0000, /* U+49b0 */
  0x0000, /* U+49b1 */
  0x0000, /* U+49b2 */
  0x0000, /* U+49b3 */
  0x0000, /* U+49b4 */
  0x0000, /* U+49b5 */
  0x0000, /* U+49b6 */
  0x0000, /* U+49b7 */
  0x0000, /* U+49b8 */
  0x0000, /* U+49b9 */
  0x0000, /* U+49ba */
  0x0000, /* U+49bb */
  0x0000, /* U+49bc */
  0x0000, /* U+49bd */
  0x0000, /* U+49be */
  0x0000, /* U+49bf */
  0x0000, /* U+49c0 */
  0x0000, /* U+49c1 */
  0x0000, /* U+49c2 */
  0x0000, /* U+49c3 */
  0x0000, /* U+49c4 */
  0x0000, /* U+49c5 */
  0x0000, /* U+49c6 */
  0x0000, /* U+49c7 */
  0x0000, /* U+49c8 */
  0x0000, /* U+49c9 */
  0x0000, /* U+49ca */
  0x0000, /* U+49cb */
  0x0000, /* U+49cc */
  0x0000, /* U+49cd */
  0x0000, /* U+49ce */
  0x0000, /* U+49cf */
  0x0000, /* U+49d0 */
  0x0000, /* U+49d1 */
  0x0000, /* U+49d2 */
  0x0000, /* U+49d3 */
  0x0000, /* U+49d4 */
  0x0000, /* U+49d5 */
  0x0000, /* U+49d6 */
  0x0000, /* U+49d7 */
  0x0000, /* U+49d8 */
  0x0000, /* U+49d9 */
  0x0000, /* U+49da */
  0x0000, /* U+49db */
  0x0000, /* U+49dc */
  0x0000, /* U+49dd */
  0x0000, /* U+49de */
  0x0000, /* U+49df */
  0x0000, /* U+49e0 */
  0x0000, /* U+49e1 */
  0x0000, /* U+49e2 */
  0x0000, /* U+49e3 */
  0x0000, /* U+49e4 */
  0x0000, /* U+49e5 */
  0x0000, /* U+49e6 */
  0x0000, /* U+49e7 */
  0x0000, /* U+49e8 */
  0x0000, /* U+49e9 */
  0x0000, /* U+49ea */
  0x0000, /* U+49eb */
  0x0000, /* U+49ec */
  0x0000, /* U+49ed */
  0x0000, /* U+49ee */
  0x0000, /* U+49ef */
  0x0000, /* U+49f0 */
  0x0000, /* U+49f1 */
  0x0000, /* U+49f2 */
  0x0000, /* U+49f3 */
  0x0000, /* U+49f4 */
  0x0000, /* U+49f5 */
  0x0000, /* U+49f6 */
  0x0000, /* U+49f7 */
  0x0000, /* U+49f8 */
  0x0000, /* U+49f9 */
  0x0000, /* U+49fa */
  0x0000, /* U+49fb */
  0x0000, /* U+49fc */
  0x0000, /* U+49fd */
  0x0000, /* U+49fe */
  0x0000, /* U+49ff */
  0x0000, /* U+4a00 */
  0x0000, /* U+4a01 */
  0x0000, /* U+4a02 */
  0x0000, /* U+4a03 */
  0x0000, /* U+4a04 */
  0x0000, /* U+4a05 */
  0x0000, /* U+4a06 */
  0x0000, /* U+4a07 */
  0x0000, /* U+4a08 */
  0x0000, /* U+4a09 */
  0x0000, /* U+4a0a */
  0x0000, /* U+4a0b */
  0x0000, /* U+4a0c */
  0x0000, /* U+4a0d */
  0x0000, /* U+4a0e */
  0x0000, /* U+4a0f */
  0x0000, /* U+4a10 */
  0x0000, /* U+4a11 */
  0x0000, /* U+4a12 */
  0x0000, /* U+4a13 */
  0x0000, /* U+4a14 */
  0x0000, /* U+4a15 */
  0x0000, /* U+4a16 */
  0x0000, /* U+4a17 */
  0x0000, /* U+4a18 */
  0x0000, /* U+4a19 */
  0x0000, /* U+4a1a */
  0x0000, /* U+4a1b */
  0x0000, /* U+4a1c */
  0x0000, /* U+4a1d */
  0x0000, /* U+4a1e */
  0x0000, /* U+4a1f */
  0x0000, /* U+4a20 */
  0x0000, /* U+4a21 */
  0x0000, /* U+4a22 */
  0x0000, /* U+4a23 */
  0x0000, /* U+4a24 */
  0x0000, /* U+4a25 */
  0x0000, /* U+4a26 */
  0x0000, /* U+4a27 */
  0x0000, /* U+4a28 */
  0x0000, /* U+4a29 */
  0x0000, /* U+4a2a */
  0x0000, /* U+4a2b */
  0x0000, /* U+4a2c */
  0x0000, /* U+4a2d */
  0x0000, /* U+4a2e */
  0x0000, /* U+4a2f */
  0x0000, /* U+4a30 */
  0x0000, /* U+4a31 */
  0x0000, /* U+4a32 */
  0x0000, /* U+4a33 */
  0x0000, /* U+4a34 */
  0x0000, /* U+4a35 */
  0x0000, /* U+4a36 */
  0x0000, /* U+4a37 */
  0x0000, /* U+4a38 */
  0x0000, /* U+4a39 */
  0x0000, /* U+4a3a */
  0x0000, /* U+4a3b */
  0x0000, /* U+4a3c */
  0x0000, /* U+4a3d */
  0x0000, /* U+4a3e */
  0x0000, /* U+4a3f */
  0x0000, /* U+4a40 */
  0x0000, /* U+4a41 */
  0x0000, /* U+4a42 */
  0x0000, /* U+4a43 */
  0x0000, /* U+4a44 */
  0x0000, /* U+4a45 */
  0x0000, /* U+4a46 */
  0x0000, /* U+4a47 */
  0x0000, /* U+4a48 */
  0x0000, /* U+4a49 */
  0x0000, /* U+4a4a */
  0x0000, /* U+4a4b */
  0x0000, /* U+4a4c */
  0x0000, /* U+4a4d */
  0x0000, /* U+4a4e */
  0x0000, /* U+4a4f */
  0x0000, /* U+4a50 */
  0x0000, /* U+4a51 */
  0x0000, /* U+4a52 */
  0x0000, /* U+4a53 */
  0x0000, /* U+4a54 */
  0x0000, /* U+4a55 */
  0x0000, /* U+4a56 */
  0x0000, /* U+4a57 */
  0x0000, /* U+4a58 */
  0x0000, /* U+4a59 */
  0x0000, /* U+4a5a */
  0x0000, /* U+4a5b */
  0x0000, /* U+4a5c */
  0x0000, /* U+4a5d */
  0x0000, /* U+4a5e */
  0x0000, /* U+4a5f */
  0x0000, /* U+4a60 */
  0x0000, /* U+4a61 */
  0x0000, /* U+4a62 */
  0x0000, /* U+4a63 */
  0x0000, /* U+4a64 */
  0x0000, /* U+4a65 */
  0x0000, /* U+4a66 */
  0x0000, /* U+4a67 */
  0x0000, /* U+4a68 */
  0x0000, /* U+4a69 */
  0x0000, /* U+4a6a */
  0x0000, /* U+4a6b */
  0x0000, /* U+4a6c */
  0x0000, /* U+4a6d */
  0x0000, /* U+4a6e */
  0x0000, /* U+4a6f */
  0x0000, /* U+4a70 */
  0x0000, /* U+4a71 */
  0x0000, /* U+4a72 */
  0x0000, /* U+4a73 */
  0x0000, /* U+4a74 */
  0x0000, /* U+4a75 */
  0x0000, /* U+4a76 */
  0x0000, /* U+4a77 */
  0x0000, /* U+4a78 */
  0x0000, /* U+4a79 */
  0x0000, /* U+4a7a */
  0x0000, /* U+4a7b */
  0x0000, /* U+4a7c */
  0x0000, /* U+4a7d */
  0x0000, /* U+4a7e */
  0x0000, /* U+4a7f */
  0x0000, /* U+4a80 */
  0x0000, /* U+4a81 */
  0x0000, /* U+4a82 */
  0x0000, /* U+4a83 */
  0x0000, /* U+4a84 */
  0x0000, /* U+4a85 */
  0x0000, /* U+4a86 */
  0x0000, /* U+4a87 */
  0x0000, /* U+4a88 */
  0x0000, /* U+4a89 */
  0x0000, /* U+4a8a */
  0x0000, /* U+4a8b */
  0x0000, /* U+4a8c */
  0x0000, /* U+4a8d */
  0x0000, /* U+4a8e */
  0x0000, /* U+4a8f */
  0x0000, /* U+4a90 */
  0x0000, /* U+4a91 */
  0x0000, /* U+4a92 */
  0x0000, /* U+4a93 */
  0x0000, /* U+4a94 */
  0x0000, /* U+4a95 */
  0x0000, /* U+4a96 */
  0x0000, /* U+4a97 */
  0x0000, /* U+4a98 */
  0x0000, /* U+4a99 */
  0x0000, /* U+4a9a */
  0x0000, /* U+4a9b */
  0x0000, /* U+4a9c */
  0x0000, /* U+4a9d */
  0x0000, /* U+4a9e */
  0x0000, /* U+4a9f */
  0x0000, /* U+4aa0 */
  0x0000, /* U+4aa1 */
  0x0000, /* U+4aa2 */
  0x0000, /* U+4aa3 */
  0x0000, /* U+4aa4 */
  0x0000, /* U+4aa5 */
  0x0000, /* U+4aa6 */
  0x0000, /* U+4aa7 */
  0x0000, /* U+4aa8 */
  0x0000, /* U+4aa9 */
  0x0000, /* U+4aaa */
  0x0000, /* U+4aab */
  0x0000, /* U+4aac */
  0x0000, /* U+4aad */
  0x0000, /* U+4aae */
  0x0000, /* U+4aaf */
  0x0000, /* U+4ab0 */
  0x0000, /* U+4ab1 */
  0x0000, /* U+4ab2 */
  0x0000, /* U+4ab3 */
  0x0000, /* U+4ab4 */
  0x0000, /* U+4ab5 */
  0x0000, /* U+4ab6 */
  0x0000, /* U+4ab7 */
  0x0000, /* U+4ab8 */
  0x0000, /* U+4ab9 */
  0x0000, /* U+4aba */
  0x0000, /* U+4abb */
  0x0000, /* U+4abc */
  0x0000, /* U+4abd */
  0x0000, /* U+4abe */
  0x0000, /* U+4abf */
  0x0000, /* U+4ac0 */
  0x0000, /* U+4ac1 */
  0x0000, /* U+4ac2 */
  0x0000, /* U+4ac3 */
  0x0000, /* U+4ac4 */
  0x0000, /* U+4ac5 */
  0x0000, /* U+4ac6 */
  0x0000, /* U+4ac7 */
  0x0000, /* U+4ac8 */
  0x0000, /* U+4ac9 */
  0x0000, /* U+4aca */
  0x0000, /* U+4acb */
  0x0000, /* U+4acc */
  0x0000, /* U+4acd */
  0x0000, /* U+4ace */
  0x0000, /* U+4acf */
  0x0000, /* U+4ad0 */
  0x0000, /* U+4ad1 */
  0x0000, /* U+4ad2 */
  0x0000, /* U+4ad3 */
  0x0000, /* U+4ad4 */
  0x0000, /* U+4ad5 */
  0x0000, /* U+4ad6 */
  0x0000, /* U+4ad7 */
  0x0000, /* U+4ad8 */
  0x0000, /* U+4ad9 */
  0x0000, /* U+4ada */
  0x0000, /* U+4adb */
  0x0000, /* U+4adc */
  0x0000, /* U+4add */
  0x0000, /* U+4ade */
  0x0000, /* U+4adf */
  0x0000, /* U+4ae0 */
  0x0000, /* U+4ae1 */
  0x0000, /* U+4ae2 */
  0x0000, /* U+4ae3 */
  0x0000, /* U+4ae4 */
  0x0000, /* U+4ae5 */
  0x0000, /* U+4ae6 */
  0x0000, /* U+4ae7 */
  0x0000, /* U+4ae8 */
  0x0000, /* U+4ae9 */
  0x0000, /* U+4aea */
  0x0000, /* U+4aeb */
  0x0000, /* U+4aec */
  0x0000, /* U+4aed */
  0x0000, /* U+4aee */
  0x0000, /* U+4aef */
  0x0000, /* U+4af0 */
  0x0000, /* U+4af1 */
  0x0000, /* U+4af2 */
  0x0000, /* U+4af3 */
  0x0000, /* U+4af4 */
  0x0000, /* U+4af5 */
  0x0000, /* U+4af6 */
  0x0000, /* U+4af7 */
  0x0000, /* U+4af8 */
  0x0000, /* U+4af9 */
  0x0000, /* U+4afa */
  0x0000, /* U+4afb */
  0x0000, /* U+4afc */
  0x0000, /* U+4afd */
  0x0000, /* U+4afe */
  0x0000, /* U+4aff */
  0x0000, /* U+4b00 */
  0x0000, /* U+4b01 */
  0x0000, /* U+4b02 */
  0x0000, /* U+4b03 */
  0x0000, /* U+4b04 */
  0x0000, /* U+4b05 */
  0x0000, /* U+4b06 */
  0x0000, /* U+4b07 */
  0x0000, /* U+4b08 */
  0x0000, /* U+4b09 */
  0x0000, /* U+4b0a */
  0x0000, /* U+4b0b */
  0x0000, /* U+4b0c */
  0x0000, /* U+4b0d */
  0x0000, /* U+4b0e */
  0x0000, /* U+4b0f */
  0x0000, /* U+4b10 */
  0x0000, /* U+4b11 */
  0x0000, /* U+4b12 */
  0x0000, /* U+4b13 */
  0x0000, /* U+4b14 */
  0x0000, /* U+4b15 */
  0x0000, /* U+4b16 */
  0x0000, /* U+4b17 */
  0x0000, /* U+4b18 */
  0x0000, /* U+4b19 */
  0x0000, /* U+4b1a */
  0x0000, /* U+4b1b */
  0x0000, /* U+4b1c */
  0x0000, /* U+4b1d */
  0x0000, /* U+4b1e */
  0x0000, /* U+4b1f */
  0x0000, /* U+4b20 */
  0x0000, /* U+4b21 */
  0x0000, /* U+4b22 */
  0x0000, /* U+4b23 */
  0x0000, /* U+4b24 */
  0x0000, /* U+4b25 */
  0x0000, /* U+4b26 */
  0x0000, /* U+4b27 */
  0x0000, /* U+4b28 */
  0x0000, /* U+4b29 */
  0x0000, /* U+4b2a */
  0x0000, /* U+4b2b */
  0x0000, /* U+4b2c */
  0x0000, /* U+4b2d */
  0x0000, /* U+4b2e */
  0x0000, /* U+4b2f */
  0x0000, /* U+4b30 */
  0x0000, /* U+4b31 */
  0x0000, /* U+4b32 */
  0x0000, /* U+4b33 */
  0x0000, /* U+4b34 */
  0x0000, /* U+4b35 */
  0x0000, /* U+4b36 */
  0x0000, /* U+4b37 */
  0x0000, /* U+4b38 */
  0x0000, /* U+4b39 */
  0x0000, /* U+4b3a */
  0x0000, /* U+4b3b */
  0x0000, /* U+4b3c */
  0x0000, /* U+4b3d */
  0x0000, /* U+4b3e */
  0x0000, /* U+4b3f */
  0x0000, /* U+4b40 */
  0x0000, /* U+4b41 */
  0x0000, /* U+4b42 */
  0x0000, /* U+4b43 */
  0x0000, /* U+4b44 */
  0x0000, /* U+4b45 */
  0x0000, /* U+4b46 */
  0x0000, /* U+4b47 */
  0x0000, /* U+4b48 */
  0x0000, /* U+4b49 */
  0x0000, /* U+4b4a */
  0x0000, /* U+4b4b */
  0x0000, /* U+4b4c */
  0x0000, /* U+4b4d */
  0x0000, /* U+4b4e */
  0x0000, /* U+4b4f */
  0x0000, /* U+4b50 */
  0x0000, /* U+4b51 */
  0x0000, /* U+4b52 */
  0x0000, /* U+4b53 */
  0x0000, /* U+4b54 */
  0x0000, /* U+4b55 */
  0x0000, /* U+4b56 */
  0x0000, /* U+4b57 */
  0x0000, /* U+4b58 */
  0x0000, /* U+4b59 */
  0x0000, /* U+4b5a */
  0x0000, /* U+4b5b */
  0x0000, /* U+4b5c */
  0x0000, /* U+4b5d */
  0x0000, /* U+4b5e */
  0x0000, /* U+4b5f */
  0x0000, /* U+4b60 */
  0x0000, /* U+4b61 */
  0x0000, /* U+4b62 */
  0x0000, /* U+4b63 */
  0x0000, /* U+4b64 */
  0x0000, /* U+4b65 */
  0x0000, /* U+4b66 */
  0x0000, /* U+4b67 */
  0x0000, /* U+4b68 */
  0x0000, /* U+4b69 */
  0x0000, /* U+4b6a */
  0x0000, /* U+4b6b */
  0x0000, /* U+4b6c */
  0x0000, /* U+4b6d */
  0x0000, /* U+4b6e */
  0x0000, /* U+4b6f */
  0x0000, /* U+4b70 */
  0x0000, /* U+4b71 */
  0x0000, /* U+4b72 */
  0x0000, /* U+4b73 */
  0x0000, /* U+4b74 */
  0x0000, /* U+4b75 */
  0x0000, /* U+4b76 */
  0x0000, /* U+4b77 */
  0x0000, /* U+4b78 */
  0x0000, /* U+4b79 */
  0x0000, /* U+4b7a */
  0x0000, /* U+4b7b */
  0x0000, /* U+4b7c */
  0x0000, /* U+4b7d */
  0x0000, /* U+4b7e */
  0x0000, /* U+4b7f */
  0x0000, /* U+4b80 */
  0x0000, /* U+4b81 */
  0x0000, /* U+4b82 */
  0x0000, /* U+4b83 */
  0x0000, /* U+4b84 */
  0x0000, /* U+4b85 */
  0x0000, /* U+4b86 */
  0x0000, /* U+4b87 */
  0x0000, /* U+4b88 */
  0x0000, /* U+4b89 */
  0x0000, /* U+4b8a */
  0x0000, /* U+4b8b */
  0x0000, /* U+4b8c */
  0x0000, /* U+4b8d */
  0x0000, /* U+4b8e */
  0x0000, /* U+4b8f */
  0x0000, /* U+4b90 */
  0x0000, /* U+4b91 */
  0x0000, /* U+4b92 */
  0x0000, /* U+4b93 */
  0x0000, /* U+4b94 */
  0x0000, /* U+4b95 */
  0x0000, /* U+4b96 */
  0x0000, /* U+4b97 */
  0x0000, /* U+4b98 */
  0x0000, /* U+4b99 */
  0x0000, /* U+4b9a */
  0x0000, /* U+4b9b */
  0x0000, /* U+4b9c */
  0x0000, /* U+4b9d */
  0x0000, /* U+4b9e */
  0x0000, /* U+4b9f */
  0x0000, /* U+4ba0 */
  0x0000, /* U+4ba1 */
  0x0000, /* U+4ba2 */
  0x0000, /* U+4ba3 */
  0x0000, /* U+4ba4 */
  0x0000, /* U+4ba5 */
  0x0000, /* U+4ba6 */
  0x0000, /* U+4ba7 */
  0x0000, /* U+4ba8 */
  0x0000, /* U+4ba9 */
  0x0000, /* U+4baa */
  0x0000, /* U+4bab */
  0x0000, /* U+4bac */
  0x0000, /* U+4bad */
  0x0000, /* U+4bae */
  0x0000, /* U+4baf */
  0x0000, /* U+4bb0 */
  0x0000, /* U+4bb1 */
  0x0000, /* U+4bb2 */
  0x0000, /* U+4bb3 */
  0x0000, /* U+4bb4 */
  0x0000, /* U+4bb5 */
  0x0000, /* U+4bb6 */
  0x0000, /* U+4bb7 */
  0x0000, /* U+4bb8 */
  0x0000, /* U+4bb9 */
  0x0000, /* U+4bba */
  0x0000, /* U+4bbb */
  0x0000, /* U+4bbc */
  0x0000, /* U+4bbd */
  0x0000, /* U+4bbe */
  0x0000, /* U+4bbf */
  0x0000, /* U+4bc0 */
  0x0000, /* U+4bc1 */
  0x0000, /* U+4bc2 */
  0x0000, /* U+4bc3 */
  0x0000, /* U+4bc4 */
  0x0000, /* U+4bc5 */
  0x0000, /* U+4bc6 */
  0x0000, /* U+4bc7 */
  0x0000, /* U+4bc8 */
  0x0000, /* U+4bc9 */
  0x0000, /* U+4bca */
  0x0000, /* U+4bcb */
  0x0000, /* U+4bcc */
  0x0000, /* U+4bcd */
  0x0000, /* U+4bce */
  0x0000, /* U+4bcf */
  0x0000, /* U+4bd0 */
  0x0000, /* U+4bd1 */
  0x0000, /* U+4bd2 */
  0x0000, /* U+4bd3 */
  0x0000, /* U+4bd4 */
  0x0000, /* U+4bd5 */
  0x0000, /* U+4bd6 */
  0x0000, /* U+4bd7 */
  0x0000, /* U+4bd8 */
  0x0000, /* U+4bd9 */
  0x0000, /* U+4bda */
  0x0000, /* U+4bdb */
  0x0000, /* U+4bdc */
  0x0000, /* U+4bdd */
  0x0000, /* U+4bde */
  0x0000, /* U+4bdf */
  0x0000, /* U+4be0 */
  0x0000, /* U+4be1 */
  0x0000, /* U+4be2 */
  0x0000, /* U+4be3 */
  0x0000, /* U+4be4 */
  0x0000, /* U+4be5 */
  0x0000, /* U+4be6 */
  0x0000, /* U+4be7 */
  0x0000, /* U+4be8 */
  0x0000, /* U+4be9 */
  0x0000, /* U+4bea */
  0x0000, /* U+4beb */
  0x0000, /* U+4bec */
  0x0000, /* U+4bed */
  0x0000, /* U+4bee */
  0x0000, /* U+4bef */
  0x0000, /* U+4bf0 */
  0x0000, /* U+4bf1 */
  0x0000, /* U+4bf2 */
  0x0000, /* U+4bf3 */
  0x0000, /* U+4bf4 */
  0x0000, /* U+4bf5 */
  0x0000, /* U+4bf6 */
  0x0000, /* U+4bf7 */
  0x0000, /* U+4bf8 */
  0x0000, /* U+4bf9 */
  0x0000, /* U+4bfa */
  0x0000, /* U+4bfb */
  0x0000, /* U+4bfc */
  0x0000, /* U+4bfd */
  0x0000, /* U+4bfe */
  0x0000, /* U+4bff */
  0x0000, /* U+4c00 */
  0x0000, /* U+4c01 */
  0x0000, /* U+4c02 */
  0x0000, /* U+4c03 */
  0x0000, /* U+4c04 */
  0x0000, /* U+4c05 */
  0x0000, /* U+4c06 */
  0x0000, /* U+4c07 */
  0x0000, /* U+4c08 */
  0x0000, /* U+4c09 */
  0x0000, /* U+4c0a */
  0x0000, /* U+4c0b */
  0x0000, /* U+4c0c */
  0x0000, /* U+4c0d */
  0x0000, /* U+4c0e */
  0x0000, /* U+4c0f */
  0x0000, /* U+4c10 */
  0x0000, /* U+4c11 */
  0x0000, /* U+4c12 */
  0x0000, /* U+4c13 */
  0x0000, /* U+4c14 */
  0x0000, /* U+4c15 */
  0x0000, /* U+4c16 */
  0x0000, /* U+4c17 */
  0x0000, /* U+4c18 */
  0x0000, /* U+4c19 */
  0x0000, /* U+4c1a */
  0x0000, /* U+4c1b */
  0x0000, /* U+4c1c */
  0x0000, /* U+4c1d */
  0x0000, /* U+4c1e */
  0x0000, /* U+4c1f */
  0x0000, /* U+4c20 */
  0x0000, /* U+4c21 */
  0x0000, /* U+4c22 */
  0x0000, /* U+4c23 */
  0x0000, /* U+4c24 */
  0x0000, /* U+4c25 */
  0x0000, /* U+4c26 */
  0x0000, /* U+4c27 */
  0x0000, /* U+4c28 */
  0x0000, /* U+4c29 */
  0x0000, /* U+4c2a */
  0x0000, /* U+4c2b */
  0x0000, /* U+4c2c */
  0x0000, /* U+4c2d */
  0x0000, /* U+4c2e */
  0x0000, /* U+4c2f */
  0x0000, /* U+4c30 */
  0x0000, /* U+4c31 */
  0x0000, /* U+4c32 */
  0x0000, /* U+4c33 */
  0x0000, /* U+4c34 */
  0x0000, /* U+4c35 */
  0x0000, /* U+4c36 */
  0x0000, /* U+4c37 */
  0x0000, /* U+4c38 */
  0x0000, /* U+4c39 */
  0x0000, /* U+4c3a */
  0x0000, /* U+4c3b */
  0x0000, /* U+4c3c */
  0x0000, /* U+4c3d */
  0x0000, /* U+4c3e */
  0x0000, /* U+4c3f */
  0x0000, /* U+4c40 */
  0x0000, /* U+4c41 */
  0x0000, /* U+4c42 */
  0x0000, /* U+4c43 */
  0x0000, /* U+4c44 */
  0x0000, /* U+4c45 */
  0x0000, /* U+4c46 */
  0x0000, /* U+4c47 */
  0x0000, /* U+4c48 */
  0x0000, /* U+4c49 */
  0x0000, /* U+4c4a */
  0x0000, /* U+4c4b */
  0x0000, /* U+4c4c */
  0x0000, /* U+4c4d */
  0x0000, /* U+4c4e */
  0x0000, /* U+4c4f */
  0x0000, /* U+4c50 */
  0x0000, /* U+4c51 */
  0x0000, /* U+4c52 */
  0x0000, /* U+4c53 */
  0x0000, /* U+4c54 */
  0x0000, /* U+4c55 */
  0x0000, /* U+4c56 */
  0x0000, /* U+4c57 */
  0x0000, /* U+4c58 */
  0x0000, /* U+4c59 */
  0x0000, /* U+4c5a */
  0x0000, /* U+4c5b */
  0x0000, /* U+4c5c */
  0x0000, /* U+4c5d */
  0x0000, /* U+4c5e */
  0x0000, /* U+4c5f */
  0x0000, /* U+4c60 */
  0x0000, /* U+4c61 */
  0x0000, /* U+4c62 */
  0x0000, /* U+4c63 */
  0x0000, /* U+4c64 */
  0x0000, /* U+4c65 */
  0x0000, /* U+4c66 */
  0x0000, /* U+4c67 */
  0x0000, /* U+4c68 */
  0x0000, /* U+4c69 */
  0x0000, /* U+4c6a */
  0x0000, /* U+4c6b */
  0x0000, /* U+4c6c */
  0x0000, /* U+4c6d */
  0x0000, /* U+4c6e */
  0x0000, /* U+4c6f */
  0x0000, /* U+4c70 */
  0x0000, /* U+4c71 */
  0x0000, /* U+4c72 */
  0x0000, /* U+4c73 */
  0x0000, /* U+4c74 */
  0x0000, /* U+4c75 */
  0x0000, /* U+4c76 */
  0x0000, /* U+4c77 */
  0x0000, /* U+4c78 */
  0x0000, /* U+4c79 */
  0x0000, /* U+4c7a */
  0x0000, /* U+4c7b */
  0x0000, /* U+4c7c */
  0x0000, /* U+4c7d */
  0x0000, /* U+4c7e */
  0x0000, /* U+4c7f */
  0x0000, /* U+4c80 */
  0x0000, /* U+4c81 */
  0x0000, /* U+4c82 */
  0x0000, /* U+4c83 */
  0x0000, /* U+4c84 */
  0x0000, /* U+4c85 */
  0x0000, /* U+4c86 */
  0x0000, /* U+4c87 */
  0x0000, /* U+4c88 */
  0x0000, /* U+4c89 */
  0x0000, /* U+4c8a */
  0x0000, /* U+4c8b */
  0x0000, /* U+4c8c */
  0x0000, /* U+4c8d */
  0x0000, /* U+4c8e */
  0x0000, /* U+4c8f */
  0x0000, /* U+4c90 */
  0x0000, /* U+4c91 */
  0x0000, /* U+4c92 */
  0x0000, /* U+4c93 */
  0x0000, /* U+4c94 */
  0x0000, /* U+4c95 */
  0x0000, /* U+4c96 */
  0x0000, /* U+4c97 */
  0x0000, /* U+4c98 */
  0x0000, /* U+4c99 */
  0x0000, /* U+4c9a */
  0x0000, /* U+4c9b */
  0x0000, /* U+4c9c */
  0x0000, /* U+4c9d */
  0x0000, /* U+4c9e */
  0x0000, /* U+4c9f */
  0x0000, /* U+4ca0 */
  0x0000, /* U+4ca1 */
  0x0000, /* U+4ca2 */
  0x0000, /* U+4ca3 */
  0x0000, /* U+4ca4 */
  0x0000, /* U+4ca5 */
  0x0000, /* U+4ca6 */
  0x0000, /* U+4ca7 */
  0x0000, /* U+4ca8 */
  0x0000, /* U+4ca9 */
  0x0000, /* U+4caa */
  0x0000, /* U+4cab */
  0x0000, /* U+4cac */
  0x0000, /* U+4cad */
  0x0000, /* U+4cae */
  0x0000, /* U+4caf */
  0x0000, /* U+4cb0 */
  0x0000, /* U+4cb1 */
  0x0000, /* U+4cb2 */
  0x0000, /* U+4cb3 */
  0x0000, /* U+4cb4 */
  0x0000, /* U+4cb5 */
  0x0000, /* U+4cb6 */
  0x0000, /* U+4cb7 */
  0x0000, /* U+4cb8 */
  0x0000, /* U+4cb9 */
  0x0000, /* U+4cba */
  0x0000, /* U+4cbb */
  0x0000, /* U+4cbc */
  0x0000, /* U+4cbd */
  0x0000, /* U+4cbe */
  0x0000, /* U+4cbf */
  0x0000, /* U+4cc0 */
  0x0000, /* U+4cc1 */
  0x0000, /* U+4cc2 */
  0x0000, /* U+4cc3 */
  0x0000, /* U+4cc4 */
  0x0000, /* U+4cc5 */
  0x0000, /* U+4cc6 */
  0x0000, /* U+4cc7 */
  0x0000, /* U+4cc8 */
  0x0000, /* U+4cc9 */
  0x0000, /* U+4cca */
  0x0000, /* U+4ccb */
  0x0000, /* U+4ccc */
  0x0000, /* U+4ccd */
  0x0000, /* U+4cce */
  0x0000, /* U+4ccf */
  0x0000, /* U+4cd0 */
  0x0000, /* U+4cd1 */
  0x0000, /* U+4cd2 */
  0x0000, /* U+4cd3 */
  0x0000, /* U+4cd4 */
  0x0000, /* U+4cd5 */
  0x0000, /* U+4cd6 */
  0x0000, /* U+4cd7 */
  0x0000, /* U+4cd8 */
  0x0000, /* U+4cd9 */
  0x0000, /* U+4cda */
  0x0000, /* U+4cdb */
  0x0000, /* U+4cdc */
  0x0000, /* U+4cdd */
  0x0000, /* U+4cde */
  0x0000, /* U+4cdf */
  0x0000, /* U+4ce0 */
  0x0000, /* U+4ce1 */
  0x0000, /* U+4ce2 */
  0x0000, /* U+4ce3 */
  0x0000, /* U+4ce4 */
  0x0000, /* U+4ce5 */
  0x0000, /* U+4ce6 */
  0x0000, /* U+4ce7 */
  0x0000, /* U+4ce8 */
  0x0000, /* U+4ce9 */
  0x0000, /* U+4cea */
  0x0000, /* U+4ceb */
  0x0000, /* U+4cec */
  0x0000, /* U+4ced */
  0x0000, /* U+4cee */
  0x0000, /* U+4cef */
  0x0000, /* U+4cf0 */
  0x0000, /* U+4cf1 */
  0x0000, /* U+4cf2 */
  0x0000, /* U+4cf3 */
  0x0000, /* U+4cf4 */
  0x0000, /* U+4cf5 */
  0x0000, /* U+4cf6 */
  0x0000, /* U+4cf7 */
  0x0000, /* U+4cf8 */
  0x0000, /* U+4cf9 */
  0x0000, /* U+4cfa */
  0x0000, /* U+4cfb */
  0x0000, /* U+4cfc */
  0x0000, /* U+4cfd */
  0x0000, /* U+4cfe */
  0x0000, /* U+4cff */
  0x0000, /* U+4d00 */
  0x0000, /* U+4d01 */
  0x0000, /* U+4d02 */
  0x0000, /* U+4d03 */
  0x0000, /* U+4d04 */
  0x0000, /* U+4d05 */
  0x0000, /* U+4d06 */
  0x0000, /* U+4d07 */
  0x0000, /* U+4d08 */
  0x0000, /* U+4d09 */
  0x0000, /* U+4d0a */
  0x0000, /* U+4d0b */
  0x0000, /* U+4d0c */
  0x0000, /* U+4d0d */
  0x0000, /* U+4d0e */
  0x0000, /* U+4d0f */
  0x0000, /* U+4d10 */
  0x0000, /* U+4d11 */
  0x0000, /* U+4d12 */
  0x0000, /* U+4d13 */
  0x0000, /* U+4d14 */
  0x0000, /* U+4d15 */
  0x0000, /* U+4d16 */
  0x0000, /* U+4d17 */
  0x0000, /* U+4d18 */
  0x0000, /* U+4d19 */
  0x0000, /* U+4d1a */
  0x0000, /* U+4d1b */
  0x0000, /* U+4d1c */
  0x0000, /* U+4d1d */
  0x0000, /* U+4d1e */
  0x0000, /* U+4d1f */
  0x0000, /* U+4d20 */
  0x0000, /* U+4d21 */
  0x0000, /* U+4d22 */
  0x0000, /* U+4d23 */
  0x0000, /* U+4d24 */
  0x0000, /* U+4d25 */
  0x0000, /* U+4d26 */
  0x0000, /* U+4d27 */
  0x0000, /* U+4d28 */
  0x0000, /* U+4d29 */
  0x0000, /* U+4d2a */
  0x0000, /* U+4d2b */
  0x0000, /* U+4d2c */
  0x0000, /* U+4d2d */
  0x0000, /* U+4d2e */
  0x0000, /* U+4d2f */
  0x0000, /* U+4d30 */
  0x0000, /* U+4d31 */
  0x0000, /* U+4d32 */
  0x0000, /* U+4d33 */
  0x0000, /* U+4d34 */
  0x0000, /* U+4d35 */
  0x0000, /* U+4d36 */
  0x0000, /* U+4d37 */
  0x0000, /* U+4d38 */
  0x0000, /* U+4d39 */
  0x0000, /* U+4d3a */
  0x0000, /* U+4d3b */
  0x0000, /* U+4d3c */
  0x0000, /* U+4d3d */
  0x0000, /* U+4d3e */
  0x0000, /* U+4d3f */
  0x0000, /* U+4d40 */
  0x0000, /* U+4d41 */
  0x0000, /* U+4d42 */
  0x0000, /* U+4d43 */
  0x0000, /* U+4d44 */
  0x0000, /* U+4d45 */
  0x0000, /* U+4d46 */
  0x0000, /* U+4d47 */
  0x0000, /* U+4d48 */
  0x0000, /* U+4d49 */
  0x0000, /* U+4d4a */
  0x0000, /* U+4d4b */
  0x0000, /* U+4d4c */
  0x0000, /* U+4d4d */
  0x0000, /* U+4d4e */
  0x0000, /* U+4d4f */
  0x0000, /* U+4d50 */
  0x0000, /* U+4d51 */
  0x0000, /* U+4d52 */
  0x0000, /* U+4d53 */
  0x0000, /* U+4d54 */
  0x0000, /* U+4d55 */
  0x0000, /* U+4d56 */
  0x0000, /* U+4d57 */
  0x0000, /* U+4d58 */
  0x0000, /* U+4d59 */
  0x0000, /* U+4d5a */
  0x0000, /* U+4d5b */
  0x0000, /* U+4d5c */
  0x0000, /* U+4d5d */
  0x0000, /* U+4d5e */
  0x0000, /* U+4d5f */
  0x0000, /* U+4d60 */
  0x0000, /* U+4d61 */
  0x0000, /* U+4d62 */
  0x0000, /* U+4d63 */
  0x0000, /* U+4d64 */
  0x0000, /* U+4d65 */
  0x0000, /* U+4d66 */
  0x0000, /* U+4d67 */
  0x0000, /* U+4d68 */
  0x0000, /* U+4d69 */
  0x0000, /* U+4d6a */
  0x0000, /* U+4d6b */
  0x0000, /* U+4d6c */
  0x0000, /* U+4d6d */
  0x0000, /* U+4d6e */
  0x0000, /* U+4d6f */
  0x0000, /* U+4d70 */
  0x0000, /* U+4d71 */
  0x0000, /* U+4d72 */
  0x0000, /* U+4d73 */
  0x0000, /* U+4d74 */
  0x0000, /* U+4d75 */
  0x0000, /* U+4d76 */
  0x0000, /* U+4d77 */
  0x0000, /* U+4d78 */
  0x0000, /* U+4d79 */
  0x0000, /* U+4d7a */
  0x0000, /* U+4d7b */
  0x0000, /* U+4d7c */
  0x0000, /* U+4d7d */
  0x0000, /* U+4d7e */
  0x0000, /* U+4d7f */
  0x0000, /* U+4d80 */
  0x0000, /* U+4d81 */
  0x0000, /* U+4d82 */
  0x0000, /* U+4d83 */
  0x0000, /* U+4d84 */
  0x0000, /* U+4d85 */
  0x0000, /* U+4d86 */
  0x0000, /* U+4d87 */
  0x0000, /* U+4d88 */
  0x0000, /* U+4d89 */
  0x0000, /* U+4d8a */
  0x0000, /* U+4d8b */
  0x0000, /* U+4d8c */
  0x0000, /* U+4d8d */
  0x0000, /* U+4d8e */
  0x0000, /* U+4d8f */
  0x0000, /* U+4d90 */
  0x0000, /* U+4d91 */
  0x0000, /* U+4d92 */
  0x0000, /* U+4d93 */
  0x0000, /* U+4d94 */
  0x0000, /* U+4d95 */
  0x0000, /* U+4d96 */
  0x0000, /* U+4d97 */
  0x0000, /* U+4d98 */
  0x0000, /* U+4d99 */
  0x0000, /* U+4d9a */
  0x0000, /* U+4d9b */
  0x0000, /* U+4d9c */
  0x0000, /* U+4d9d */
  0x0000, /* U+4d9e */
  0x0000, /* U+4d9f */
  0x0000, /* U+4da0 */
  0x0000, /* U+4da1 */
  0x0000, /* U+4da2 */
  0x0000, /* U+4da3 */
  0x0000, /* U+4da4 */
  0x0000, /* U+4da5 */
  0x0000, /* U+4da6 */
  0x0000, /* U+4da7 */
  0x0000, /* U+4da8 */
  0x0000, /* U+4da9 */
  0x0000, /* U+4daa */
  0x0000, /* U+4dab */
  0x0000, /* U+4dac */
  0x0000, /* U+4dad */
  0x0000, /* U+4dae */
  0x0000, /* U+4daf */
  0x0000, /* U+4db0 */
  0x0000, /* U+4db1 */
  0x0000, /* U+4db2 */
  0x0000, /* U+4db3 */
  0x0000, /* U+4db4 */
  0x0000, /* U+4db5 */
  0x0000, /* U+4db6 */
  0x0000, /* U+4db7 */
  0x0000, /* U+4db8 */
  0x0000, /* U+4db9 */
  0x0000, /* U+4dba */
  0x0000, /* U+4dbb */
  0x0000, /* U+4dbc */
  0x0000, /* U+4dbd */
  0x0000, /* U+4dbe */
  0x0000, /* U+4dbf */
  0x0000, /* U+4dc0 */
  0x0000, /* U+4dc1 */
  0x0000, /* U+4dc2 */
  0x0000, /* U+4dc3 */
  0x0000, /* U+4dc4 */
  0x0000, /* U+4dc5 */
  0x0000, /* U+4dc6 */
  0x0000, /* U+4dc7 */
  0x0000, /* U+4dc8 */
  0x0000, /* U+4dc9 */
  0x0000, /* U+4dca */
  0x0000, /* U+4dcb */
  0x0000, /* U+4dcc */
  0x0000, /* U+4dcd */
  0x0000, /* U+4dce */
  0x0000, /* U+4dcf */
  0x0000, /* U+4dd0 */
  0x0000, /* U+4dd1 */
  0x0000, /* U+4dd2 */
  0x0000, /* U+4dd3 */
  0x0000, /* U+4dd4 */
  0x0000, /* U+4dd5 */
  0x0000, /* U+4dd6 */
  0x0000, /* U+4dd7 */
  0x0000, /* U+4dd8 */
  0x0000, /* U+4dd9 */
  0x0000, /* U+4dda */
  0x0000, /* U+4ddb */
  0x0000, /* U+4ddc */
  0x0000, /* U+4ddd */
  0x0000, /* U+4dde */
  0x0000, /* U+4ddf */
  0x0000, /* U+4de0 */
  0x0000, /* U+4de1 */
  0x0000, /* U+4de2 */
  0x0000, /* U+4de3 */
  0x0000, /* U+4de4 */
  0x0000, /* U+4de5 */
  0x0000, /* U+4de6 */
  0x0000, /* U+4de7 */
  0x0000, /* U+4de8 */
  0x0000, /* U+4de9 */
  0x0000, /* U+4dea */
  0x0000, /* U+4deb */
  0x0000, /* U+4dec */
  0x0000, /* U+4ded */
  0x0000, /* U+4dee */
  0x0000, /* U+4def */
  0x0000, /* U+4df0 */
  0x0000, /* U+4df1 */
  0x0000, /* U+4df2 */
  0x0000, /* U+4df3 */
  0x0000, /* U+4df4 */
  0x0000, /* U+4df5 */
  0x0000, /* U+4df6 */
  0x0000, /* U+4df7 */
  0x0000, /* U+4df8 */
  0x0000, /* U+4df9 */
  0x0000, /* U+4dfa */
  0x0000, /* U+4dfb */
  0x0000, /* U+4dfc */
  0x0000, /* U+4dfd */
  0x0000, /* U+4dfe */
  0x0000, /* U+4dff */
  0x88ea, /* U+4e00 */
  0x929a, /* U+4e01 */
  0x0000, /* U+4e02 */
  0x8eb5, /* U+4e03 */
  0x0000, /* U+4e04 */
  0x0000, /* U+4e05 */
  0x0000, /* U+4e06 */
  0x969c, /* U+4e07 */
  0x8fe4, /* U+4e08 */
  0x8e4f, /* U+4e09 */
  0x8fe3, /* U+4e0a */
  0x89ba, /* U+4e0b */
  0x0000, /* U+4e0c */
  0x9573, /* U+4e0d */
  0x975e, /* U+4e0e */
  0x0000, /* U+4e0f */
  0x98a0, /* U+4e10 */
  0x894e, /* U+4e11 */
  0x0000, /* U+4e12 */
  0x0000, /* U+4e13 */
  0x8a8e, /* U+4e14 */
  0x98a1, /* U+4e15 */
  0x90a2, /* U+4e16 */
  0x99c0, /* U+4e17 */
  0x8b75, /* U+4e18 */
  0x95b8, /* U+4e19 */
  0x0000, /* U+4e1a */
  0x0000, /* U+4e1b */
  0x0000, /* U+4e1c */
  0x0000, /* U+4e1d */
  0x8fe5, /* U+4e1e */
  0x0000, /* U+4e1f */
  0x0000, /* U+4e20 */
  0x97bc, /* U+4e21 */
  0x0000, /* U+4e22 */
  0x0000, /* U+4e23 */
  0x0000, /* U+4e24 */
  0x0000, /* U+4e25 */
  0x95c0, /* U+4e26 */
  0x0000, /* U+4e27 */
  0xfa68, /* U+4e28 */
  0x0000, /* U+4e29 */
  0x98a2, /* U+4e2a */
  0x0000, /* U+4e2b */
  0x0000, /* U+4e2c */
  0x9286, /* U+4e2d */
  0x0000, /* U+4e2e */
  0x0000, /* U+4e2f */
  0x0000, /* U+4e30 */
  0x98a3, /* U+4e31 */
  0x8bf8, /* U+4e32 */
  0x0000, /* U+4e33 */
  0x0000, /* U+4e34 */
  0x0000, /* U+4e35 */
  0x98a4, /* U+4e36 */
  0x0000, /* U+4e37 */
  0x8adb, /* U+4e38 */
  0x924f, /* U+4e39 */
  0x0000, /* U+4e3a */
  0x8ee5, /* U+4e3b */
  0x98a5, /* U+4e3c */
  0x0000, /* U+4e3d */
  0x0000, /* U+4e3e */
  0x98a6, /* U+4e3f */
  0x0000, /* U+4e40 */
  0x0000, /* U+4e41 */
  0x98a7, /* U+4e42 */
  0x9454, /* U+4e43 */
  0x0000, /* U+4e44 */
  0x8b76, /* U+4e45 */
  0x0000, /* U+4e46 */
  0x0000, /* U+4e47 */
  0x0000, /* U+4e48 */
  0x0000, /* U+4e49 */
  0x0000, /* U+4e4a */
  0x9456, /* U+4e4b */
  0x0000, /* U+4e4c */
  0x93e1, /* U+4e4d */
  0x8cc1, /* U+4e4e */
  0x9652, /* U+4e4f */
  0x0000, /* U+4e50 */
  0x0000, /* U+4e51 */
  0x0000, /* U+4e52 */
  0x0000, /* U+4e53 */
  0x0000, /* U+4e54 */
  0xe568, /* U+4e55 */
  0x98a8, /* U+4e56 */
  0x8fe6, /* U+4e57 */
  0x98a9, /* U+4e58 */
  0x89b3, /* U+4e59 */
  0x0000, /* U+4e5a */
  0x0000, /* U+4e5b */
  0x0000, /* U+4e5c */
  0x8be3, /* U+4e5d */
  0x8cee, /* U+4e5e */
  0x96e7, /* U+4e5f */
  0x0000, /* U+4e60 */
  0x0000, /* U+4e61 */
  0x9ba4, /* U+4e62 */
  0x0000, /* U+4e63 */
  0x0000, /* U+4e64 */
  0x0000, /* U+4e65 */
  0x0000, /* U+4e66 */
  0x0000, /* U+4e67 */
  0x0000, /* U+4e68 */
  0x0000, /* U+4e69 */
  0x0000, /* U+4e6a */
  0x0000, /* U+4e6b */
  0x0000, /* U+4e6c */
  0x0000, /* U+4e6d */
  0x0000, /* U+4e6e */
  0x0000, /* U+4e6f */
  0x0000, /* U+4e70 */
  0x9790, /* U+4e71 */
  0x0000, /* U+4e72 */
  0x93fb, /* U+4e73 */
  0x0000, /* U+4e74 */
  0x0000, /* U+4e75 */
  0x0000, /* U+4e76 */
  0x0000, /* U+4e77 */
  0x0000, /* U+4e78 */
  0x0000, /* U+4e79 */
  0x0000, /* U+4e7a */
  0x0000, /* U+4e7b */
  0x0000, /* U+4e7c */
  0x0000, /* U+4e7d */
  0x8aa3, /* U+4e7e */
  0x0000, /* U+4e7f */
  0x8b54, /* U+4e80 */
  0x0000, /* U+4e81 */
  0x98aa, /* U+4e82 */
  0x0000, /* U+4e83 */
  0x0000, /* U+4e84 */
  0x98ab, /* U+4e85 */
  0x97b9, /* U+4e86 */
  0x0000, /* U+4e87 */
  0x975c, /* U+4e88 */
  0x9188, /* U+4e89 */
  0x98ad, /* U+4e8a */
  0x8e96, /* U+4e8b */
  0x93f1, /* U+4e8c */
  0x0000, /* U+4e8d */
  0x98b0, /* U+4e8e */
  0x0000, /* U+4e8f */
  0x0000, /* U+4e90 */
  0x895d, /* U+4e91 */
  0x8cdd, /* U+4e92 */
  0x0000, /* U+4e93 */
  0x8cdc, /* U+4e94 */
  0x88e4, /* U+4e95 */
  0x0000, /* U+4e96 */
  0x0000, /* U+4e97 */
  0x986a, /* U+4e98 */
  0x9869, /* U+4e99 */
  0x0000, /* U+4e9a */
  0x8db1, /* U+4e9b */
  0x889f, /* U+4e9c */
  0x0000, /* U+4e9d */
  0x98b1, /* U+4e9e */
  0x98b2, /* U+4e9f */
  0x98b3, /* U+4ea0 */
  0x9653, /* U+4ea1 */
  0x98b4, /* U+4ea2 */
  0x0000, /* U+4ea3 */
  0x8cf0, /* U+4ea4 */
  0x88e5, /* U+4ea5 */
  0x9692, /* U+4ea6 */
  0x0000, /* U+4ea7 */
  0x8b9c, /* U+4ea8 */
  0x0000, /* U+4ea9 */
  0x0000, /* U+4eaa */
  0x8b9d, /* U+4eab */
  0x8b9e, /* U+4eac */
  0x92e0, /* U+4ead */
  0x97ba, /* U+4eae */
  0x0000, /* U+4eaf */
  0x98b5, /* U+4eb0 */
  0x0000, /* U+4eb1 */
  0x0000, /* U+4eb2 */
  0x98b6, /* U+4eb3 */
  0x0000, /* U+4eb4 */
  0x0000, /* U+4eb5 */
  0x98b7, /* U+4eb6 */
  0x0000, /* U+4eb7 */
  0x0000, /* U+4eb8 */
  0x0000, /* U+4eb9 */
  0x906c, /* U+4eba */
  0x0000, /* U+4ebb */
  0x0000, /* U+4ebc */
  0x0000, /* U+4ebd */
  0x0000, /* U+4ebe */
  0x0000, /* U+4ebf */
  0x8f59, /* U+4ec0 */
  0x906d, /* U+4ec1 */
  0x98bc, /* U+4ec2 */
  0x0000, /* U+4ec3 */
  0x98ba, /* U+4ec4 */
  0x0000, /* U+4ec5 */
  0x98bb, /* U+4ec6 */
  0x8b77, /* U+4ec7 */
  0x0000, /* U+4ec8 */
  0x0000, /* U+4ec9 */
  0x8da1, /* U+4eca */
  0x89ee, /* U+4ecb */
  0x0000, /* U+4ecc */
  0x98b9, /* U+4ecd */
  0x98b8, /* U+4ece */
  0x95a7, /* U+4ecf */
  0x0000, /* U+4ed0 */
  0x0000, /* U+4ed1 */
  0x0000, /* U+4ed2 */
  0x0000, /* U+4ed3 */
  0x8e65, /* U+4ed4 */
  0x8e64, /* U+4ed5 */
  0x91bc, /* U+4ed6 */
  0x98bd, /* U+4ed7 */
  0x9574, /* U+4ed8 */
  0x90e5, /* U+4ed9 */
  0x0000, /* U+4eda */
  0x0000, /* U+4edb */
  0x0000, /* U+4edc */
  0x8157, /* U+4edd */
  0x98be, /* U+4ede */
  0x98c0, /* U+4edf */
  0x0000, /* U+4ee0 */
  0xfa69, /* U+4ee1 */
  0x0000, /* U+4ee2 */
  0x91e3, /* U+4ee3 */
  0x97df, /* U+4ee4 */
  0x88c8, /* U+4ee5 */
  0x0000, /* U+4ee6 */
  0x0000, /* U+4ee7 */
  0x0000, /* U+4ee8 */
  0x0000, /* U+4ee9 */
  0x0000, /* U+4eea */
  0x0000, /* U+4eeb */
  0x0000, /* U+4eec */
  0x98bf, /* U+4eed */
  0x89bc, /* U+4eee */
  0x0000, /* U+4eef */
  0x8bc2, /* U+4ef0 */
  0x0000, /* U+4ef1 */
  0x9287, /* U+4ef2 */
  0x0000, /* U+4ef3 */
  0x0000, /* U+4ef4 */
  0x0000, /* U+4ef5 */
  0x8c8f, /* U+4ef6 */
  0x98c1, /* U+4ef7 */
  0x0000, /* U+4ef8 */
  0x0000, /* U+4ef9 */
  0x0000, /* U+4efa */
  0x9443, /* U+4efb */
  0xfa6a, /* U+4efc */
  0x0000, /* U+4efd */
  0x0000, /* U+4efe */
  0x0000, /* U+4eff */
  0xfa6b, /* U+4f00 */
  0x8ae9, /* U+4f01 */
  0x0000, /* U+4f02 */
  0xfa6c, /* U+4f03 */
  0x0000, /* U+4f04 */
  0x0000, /* U+4f05 */
  0x0000, /* U+4f06 */
  0x0000, /* U+4f07 */
  0x0000, /* U+4f08 */
  0x98c2, /* U+4f09 */
  0x88c9, /* U+4f0a */
  0x0000, /* U+4f0b */
  0x0000, /* U+4f0c */
  0x8cde, /* U+4f0d */
  0x8aea, /* U+4f0e */
  0x959a, /* U+4f0f */
  0x94b0, /* U+4f10 */
  0x8b78, /* U+4f11 */
  0x0000, /* U+4f12 */
  0x0000, /* U+4f13 */
  0x0000, /* U+4f14 */
  0x0000, /* U+4f15 */
  0x0000, /* U+4f16 */
  0x0000, /* U+4f17 */
  0x0000, /* U+4f18 */
  0x0000, /* U+4f19 */
  0x89ef, /* U+4f1a */
  0x0000, /* U+4f1b */
  0x98e5, /* U+4f1c */
  0x9360, /* U+4f1d */
  0x0000, /* U+4f1e */
  0x0000, /* U+4f1f */
  0x0000, /* U+4f20 */
  0x0000, /* U+4f21 */
  0x0000, /* U+4f22 */
  0x0000, /* U+4f23 */
  0x0000, /* U+4f24 */
  0x0000, /* U+4f25 */
  0x0000, /* U+4f26 */
  0x0000, /* U+4f27 */
  0x0000, /* U+4f28 */
  0x0000, /* U+4f29 */
  0x0000, /* U+4f2a */
  0x0000, /* U+4f2b */
  0x0000, /* U+4f2c */
  0x0000, /* U+4f2d */
  0x0000, /* U+4f2e */
  0x948c, /* U+4f2f */
  0x98c4, /* U+4f30 */
  0x0000, /* U+4f31 */
  0x0000, /* U+4f32 */
  0x0000, /* U+4f33 */
  0x94ba, /* U+4f34 */
  0x0000, /* U+4f35 */
  0x97e0, /* U+4f36 */
  0x0000, /* U+4f37 */
  0x904c, /* U+4f38 */
  0xfa6d, /* U+4f39 */
  0x8e66, /* U+4f3a */
  0x0000, /* U+4f3b */
  0x8e97, /* U+4f3c */
  0x89be, /* U+4f3d */
  0x0000, /* U+4f3e */
  0x0000, /* U+4f3f */
  0x0000, /* U+4f40 */
  0x0000, /* U+4f41 */
  0x0000, /* U+4f42 */
  0x92cf, /* U+4f43 */
  0x0000, /* U+4f44 */
  0x0000, /* U+4f45 */
  0x9241, /* U+4f46 */
  0x98c8, /* U+4f47 */
  0x0000, /* U+4f48 */
  0x0000, /* U+4f49 */
  0x0000, /* U+4f4a */
  0x0000, /* U+4f4b */
  0x0000, /* U+4f4c */
  0x88ca, /* U+4f4d */
  0x92e1, /* U+4f4e */
  0x8f5a, /* U+4f4f */
  0x8db2, /* U+4f50 */
  0x9743, /* U+4f51 */
  0x0000, /* U+4f52 */
  0x91cc, /* U+4f53 */
  0x0000, /* U+4f54 */
  0x89bd, /* U+4f55 */
  0xfa6e, /* U+4f56 */
  0x98c7, /* U+4f57 */
  0x0000, /* U+4f58 */
  0x975d, /* U+4f59 */
  0x98c3, /* U+4f5a */
  0x98c5, /* U+4f5b */
  0x8dec, /* U+4f5c */
  0x98c6, /* U+4f5d */
  0x9b43, /* U+4f5e */
  0x0000, /* U+4f5f */
  0x0000, /* U+4f60 */
  0x0000, /* U+4f61 */
  0x0000, /* U+4f62 */
  0x0000, /* U+4f63 */
  0x0000, /* U+4f64 */
  0x0000, /* U+4f65 */
  0x0000, /* U+4f66 */
  0x0000, /* U+4f67 */
  0x0000, /* U+4f68 */
  0x98ce, /* U+4f69 */
  0x0000, /* U+4f6a */
  0x0000, /* U+4f6b */
  0x0000, /* U+4f6c */
  0x0000, /* U+4f6d */
  0x0000, /* U+4f6e */
  0x98d1, /* U+4f6f */
  0x98cf, /* U+4f70 */
  0x0000, /* U+4f71 */
  0x0000, /* U+4f72 */
  0x89c0, /* U+4f73 */
  0x0000, /* U+4f74 */
  0x95b9, /* U+4f75 */
  0x98c9, /* U+4f76 */
  0x0000, /* U+4f77 */
  0x0000, /* U+4f78 */
  0x0000, /* U+4f79 */
  0x0000, /* U+4f7a */
  0x98cd, /* U+4f7b */
  0x8cf1, /* U+4f7c */
  0x0000, /* U+4f7d */
  0x0000, /* U+4f7e */
  0x8e67, /* U+4f7f */
  0x0000, /* U+4f80 */
  0x0000, /* U+4f81 */
  0x0000, /* U+4f82 */
  0x8aa4, /* U+4f83 */
  0x0000, /* U+4f84 */
  0x0000, /* U+4f85 */
  0x98d2, /* U+4f86 */
  0x0000, /* U+4f87 */
  0x98ca, /* U+4f88 */
  0x0000, /* U+4f89 */
  0xfa70, /* U+4f8a */
  0x97e1, /* U+4f8b */
  0x0000, /* U+4f8c */
  0x8e98, /* U+4f8d */
  0x0000, /* U+4f8e */
  0x98cb, /* U+4f8f */
  0x0000, /* U+4f90 */
  0x98d0, /* U+4f91 */
  0xfa6f, /* U+4f92 */
  0x0000, /* U+4f93 */
  0xfa72, /* U+4f94 */
  0x0000, /* U+4f95 */
  0x98d3, /* U+4f96 */
  0x0000, /* U+4f97 */
  0x98cc, /* U+4f98 */
  0x0000, /* U+4f99 */
  0xfa71, /* U+4f9a */
  0x8b9f, /* U+4f9b */
  0x0000, /* U+4f9c */
  0x88cb, /* U+4f9d */
  0x0000, /* U+4f9e */
  0x0000, /* U+4f9f */
  0x8ba0, /* U+4fa0 */
  0x89bf, /* U+4fa1 */
  0x0000, /* U+4fa2 */
  0x0000, /* U+4fa3 */
  0x0000, /* U+4fa4 */
  0x0000, /* U+4fa5 */
  0x0000, /* U+4fa6 */
  0x0000, /* U+4fa7 */
  0x0000, /* U+4fa8 */
  0x0000, /* U+4fa9 */
  0x0000, /* U+4faa */
  0x9b44, /* U+4fab */
  0x0000, /* U+4fac */
  0x9699, /* U+4fad */
  0x958e, /* U+4fae */
  0x8cf2, /* U+4faf */
  0x0000, /* U+4fb0 */
  0x0000, /* U+4fb1 */
  0x0000, /* U+4fb2 */
  0x0000, /* U+4fb3 */
  0x0000, /* U+4fb4 */
  0x904e, /* U+4fb5 */
  0x97b5, /* U+4fb6 */
  0x0000, /* U+4fb7 */
  0x0000, /* U+4fb8 */
  0x0000, /* U+4fb9 */
  0x0000, /* U+4fba */
  0x0000, /* U+4fbb */
  0x0000, /* U+4fbc */
  0x0000, /* U+4fbd */
  0x0000, /* U+4fbe */
  0x95d6, /* U+4fbf */
  0x0000, /* U+4fc0 */
  0x0000, /* U+4fc1 */
  0x8c57, /* U+4fc2 */
  0x91a3, /* U+4fc3 */
  0x89e2, /* U+4fc4 */
  0x0000, /* U+4fc5 */
  0x0000, /* U+4fc6 */
  0x0000, /* U+4fc7 */
  0x0000, /* U+4fc8 */
  0xfa61, /* U+4fc9 */
  0x8f72, /* U+4fca */
  0x0000, /* U+4fcb */
  0x0000, /* U+4fcc */
  0xfa73, /* U+4fcd */
  0x98d7, /* U+4fce */
  0x0000, /* U+4fcf */
  0x98dc, /* U+4fd0 */
  0x98da, /* U+4fd1 */
  0x0000, /* U+4fd2 */
  0x0000, /* U+4fd3 */
  0x98d5, /* U+4fd4 */
  0x0000, /* U+4fd5 */
  0x0000, /* U+4fd6 */
  0x91ad, /* U+4fd7 */
  0x98d8, /* U+4fd8 */
  0x0000, /* U+4fd9 */
  0x98db, /* U+4fda */
  0x98d9, /* U+4fdb */
  0x0000, /* U+4fdc */
  0x95db, /* U+4fdd */
  0x0000, /* U+4fde */
  0x98d6, /* U+4fdf */
  0x0000, /* U+4fe0 */
  0x904d, /* U+4fe1 */
  0x0000, /* U+4fe2 */
  0x9693, /* U+4fe3 */
  0x98dd, /* U+4fe4 */
  0x98de, /* U+4fe5 */
  0x0000, /* U+4fe6 */
  0x0000, /* U+4fe7 */
  0x0000, /* U+4fe8 */
  0x0000, /* U+4fe9 */
  0x0000, /* U+4fea */
  0x0000, /* U+4feb */
  0x0000, /* U+4fec */
  0x0000, /* U+4fed */
  0x8f43, /* U+4fee */
  0x98eb, /* U+4fef */
  0x0000, /* U+4ff0 */
  0x0000, /* U+4ff1 */
  0x0000, /* U+4ff2 */
  0x946f, /* U+4ff3 */
  0x0000, /* U+4ff4 */
  0x9555, /* U+4ff5 */
  0x98e6, /* U+4ff6 */
  0x0000, /* U+4ff7 */
  0x95ee, /* U+4ff8 */
  0x0000, /* U+4ff9 */
  0x89b4, /* U+4ffa */
  0x0000, /* U+4ffb */
  0x0000, /* U+4ffc */
  0x0000, /* U+4ffd */
  0x98ea, /* U+4ffe */
  0xfa76, /* U+4fff */
  0x0000, /* U+5000 */
  0x0000, /* U+5001 */
  0x0000, /* U+5002 */
  0x0000, /* U+5003 */
  0x0000, /* U+5004 */
  0x98e4, /* U+5005 */
  0x98ed, /* U+5006 */
  0x0000, /* U+5007 */
  0x0000, /* U+5008 */
  0x9171, /* U+5009 */
  0x0000, /* U+500a */
  0x8cc2, /* U+500b */
  0x0000, /* U+500c */
  0x947b, /* U+500d */
  0x0000, /* U+500e */
  0xe0c5, /* U+500f */
  0x0000, /* U+5010 */
  0x98ec, /* U+5011 */
  0x937c, /* U+5012 */
  0x0000, /* U+5013 */
  0x98e1, /* U+5014 */
  0x0000, /* U+5015 */
  0x8cf4, /* U+5016 */
  0x0000, /* U+5017 */
  0x0000, /* U+5018 */
  0x8cf3, /* U+5019 */
  0x98df, /* U+501a */
  0x0000, /* U+501b */
  0x0000, /* U+501c */
  0x0000, /* U+501d */
  0xfa77, /* U+501e */
  0x8ed8, /* U+501f */
  0x0000, /* U+5020 */
  0x98e7, /* U+5021 */
  0xfa75, /* U+5022 */
  0x95ed, /* U+5023 */
  0x926c, /* U+5024 */
  0x98e3, /* U+5025 */
  0x8c91, /* U+5026 */
  0x0000, /* U+5027 */
  0x98e0, /* U+5028 */
  0x98e8, /* U+5029 */
  0x98e2, /* U+502a */
  0x97cf, /* U+502b */
  0x98e9, /* U+502c */
  0x9860, /* U+502d */
  0x0000, /* U+502e */
  0x0000, /* U+502f */
  0x0000, /* U+5030 */
  0x0000, /* U+5031 */
  0x0000, /* U+5032 */
  0x0000, /* U+5033 */
  0x0000, /* U+5034 */
  0x0000, /* U+5035 */
  0x8be4, /* U+5036 */
  0x0000, /* U+5037 */
  0x0000, /* U+5038 */
  0x8c90, /* U+5039 */
  0x0000, /* U+503a */
  0x0000, /* U+503b */
  0x0000, /* U+503c */
  0x0000, /* U+503d */
  0x0000, /* U+503e */
  0x0000, /* U+503f */
  0xfa74, /* U+5040 */
  0x0000, /* U+5041 */
  0xfa7a, /* U+5042 */
  0x98ee, /* U+5043 */
  0x0000, /* U+5044 */
  0x0000, /* U+5045 */
  0xfa78, /* U+5046 */
  0x98ef, /* U+5047 */
  0x98f3, /* U+5048 */
  0x88cc, /* U+5049 */
  0x0000, /* U+504a */
  0x0000, /* U+504b */
  0x0000, /* U+504c */
  0x0000, /* U+504d */
  0x0000, /* U+504e */
  0x95ce, /* U+504f */
  0x98f2, /* U+5050 */
  0x0000, /* U+5051 */
  0x0000, /* U+5052 */
  0x0000, /* U+5053 */
  0x0000, /* U+5054 */
  0x98f1, /* U+5055 */
  0x98f5, /* U+5056 */
  0x0000, /* U+5057 */
  0x0000, /* U+5058 */
  0x0000, /* U+5059 */
  0x98f4, /* U+505a */
  0x0000, /* U+505b */
  0x92e2, /* U+505c */
  0x0000, /* U+505d */
  0x0000, /* U+505e */
  0x0000, /* U+505f */
  0x0000, /* U+5060 */
  0x0000, /* U+5061 */
  0x0000, /* U+5062 */
  0x0000, /* U+5063 */
  0x0000, /* U+5064 */
  0x8c92, /* U+5065 */
  0x0000, /* U+5066 */
  0x0000, /* U+5067 */
  0x0000, /* U+5068 */
  0x0000, /* U+5069 */
  0x0000, /* U+506a */
  0x0000, /* U+506b */
  0x98f6, /* U+506c */
  0x0000, /* U+506d */
  0x0000, /* U+506e */
  0x0000, /* U+506f */
  0xfa79, /* U+5070 */
  0x0000, /* U+5071 */
  0x8ec3, /* U+5072 */
  0x0000, /* U+5073 */
  0x91a4, /* U+5074 */
  0x92e3, /* U+5075 */
  0x8bf4, /* U+5076 */
  0x0000, /* U+5077 */
  0x98f7, /* U+5078 */
  0x0000, /* U+5079 */
  0x0000, /* U+507a */
  0x0000, /* U+507b */
  0x0000, /* U+507c */
  0x8b55, /* U+507d */
  0x0000, /* U+507e */
  0x0000, /* U+507f */
  0x98f8, /* U+5080 */
  0x0000, /* U+5081 */
  0x0000, /* U+5082 */
  0x0000, /* U+5083 */
  0x0000, /* U+5084 */
  0x98fa, /* U+5085 */
  0x0000, /* U+5086 */
  0x0000, /* U+5087 */
  0x0000, /* U+5088 */
  0x0000, /* U+5089 */
  0x0000, /* U+508a */
  0x0000, /* U+508b */
  0x0000, /* U+508c */
  0x9654, /* U+508d */
  0x0000, /* U+508e */
  0x0000, /* U+508f */
  0x0000, /* U+5090 */
  0x8c86, /* U+5091 */
  0x0000, /* U+5092 */
  0x0000, /* U+5093 */
  0xfa7b, /* U+5094 */
  0x0000, /* U+5095 */
  0x0000, /* U+5096 */
  0x0000, /* U+5097 */
  0x8e50, /* U+5098 */
  0x94f5, /* U+5099 */
  0x98f9, /* U+509a */
  0x0000, /* U+509b */
  0x0000, /* U+509c */
  0x0000, /* U+509d */
  0x0000, /* U+509e */
  0x0000, /* U+509f */
  0x0000, /* U+50a0 */
  0x0000, /* U+50a1 */
  0x0000, /* U+50a2 */
  0x0000, /* U+50a3 */
  0x0000, /* U+50a4 */
  0x0000, /* U+50a5 */
  0x0000, /* U+50a6 */
  0x0000, /* U+50a7 */
  0x0000, /* U+50a8 */
  0x0000, /* U+50a9 */
  0x0000, /* U+50aa */
  0x0000, /* U+50ab */
  0x8dc3, /* U+50ac */
  0x9762, /* U+50ad */
  0x0000, /* U+50ae */
  0x0000, /* U+50af */
  0x0000, /* U+50b0 */
  0x0000, /* U+50b1 */
  0x98fc, /* U+50b2 */
  0x9942, /* U+50b3 */
  0x98fb, /* U+50b4 */
  0x8dc2, /* U+50b5 */
  0x0000, /* U+50b6 */
  0x8f9d, /* U+50b7 */
  0x0000, /* U+50b8 */
  0x0000, /* U+50b9 */
  0x0000, /* U+50ba */
  0x0000, /* U+50bb */
  0x0000, /* U+50bc */
  0x0000, /* U+50bd */
  0x8c58, /* U+50be */
  0x0000, /* U+50bf */
  0x0000, /* U+50c0 */
  0x0000, /* U+50c1 */
  0x9943, /* U+50c2 */
  0x0000, /* U+50c3 */
  0x0000, /* U+50c4 */
  0x8bcd, /* U+50c5 */
  0x0000, /* U+50c6 */
  0x0000, /* U+50c7 */
  0x0000, /* U+50c8 */
  0x9940, /* U+50c9 */
  0x9941, /* U+50ca */
  0x0000, /* U+50cb */
  0x0000, /* U+50cc */
  0x93ad, /* U+50cd */
  0x0000, /* U+50ce */
  0x919c, /* U+50cf */
  0x0000, /* U+50d0 */
  0x8ba1, /* U+50d1 */
  0x0000, /* U+50d2 */
  0x0000, /* U+50d3 */
  0x0000, /* U+50d4 */
  0x966c, /* U+50d5 */
  0x9944, /* U+50d6 */
  0x0000, /* U+50d7 */
  0xfa7d, /* U+50d8 */
  0x0000, /* U+50d9 */
  0x97bb, /* U+50da */
  0x0000, /* U+50db */
  0x0000, /* U+50dc */
  0x0000, /* U+50dd */
  0x9945, /* U+50de */
  0x0000, /* U+50df */
  0x0000, /* U+50e0 */
  0x0000, /* U+50e1 */
  0x0000, /* U+50e2 */
  0x9948, /* U+50e3 */
  0x0000, /* U+50e4 */
  0x9946, /* U+50e5 */
  0x0000, /* U+50e6 */
  0x916d, /* U+50e7 */
  0x0000, /* U+50e8 */
  0x0000, /* U+50e9 */
  0x0000, /* U+50ea */
  0x0000, /* U+50eb */
  0x0000, /* U+50ec */
  0x9947, /* U+50ed */
  0x9949, /* U+50ee */
  0x0000, /* U+50ef */
  0x0000, /* U+50f0 */
  0x0000, /* U+50f1 */
  0x0000, /* U+50f2 */
  0x0000, /* U+50f3 */
  0xfa7c, /* U+50f4 */
  0x994b, /* U+50f5 */
  0x0000, /* U+50f6 */
  0x0000, /* U+50f7 */
  0x0000, /* U+50f8 */
  0x994a, /* U+50f9 */
  0x0000, /* U+50fa */
  0x95c6, /* U+50fb */
  0x0000, /* U+50fc */
  0x0000, /* U+50fd */
  0x0000, /* U+50fe */
  0x0000, /* U+50ff */
  0x8b56, /* U+5100 */
  0x994d, /* U+5101 */
  0x994e, /* U+5102 */
  0x0000, /* U+5103 */
  0x89ad, /* U+5104 */
  0x0000, /* U+5105 */
  0x0000, /* U+5106 */
  0x0000, /* U+5107 */
  0x0000, /* U+5108 */
  0x994c, /* U+5109 */
  0x0000, /* U+510a */
  0x0000, /* U+510b */
  0x0000, /* U+510c */
  0x0000, /* U+510d */
  0x0000, /* U+510e */
  0x0000, /* U+510f */
  0x0000, /* U+5110 */
  0x0000, /* U+5111 */
  0x8ef2, /* U+5112 */
  0x0000, /* U+5113 */
  0x9951, /* U+5114 */
  0x9950, /* U+5115 */
  0x994f, /* U+5116 */
  0x0000, /* U+5117 */
  0x98d4, /* U+5118 */
  0x0000, /* U+5119 */
  0x9952, /* U+511a */
  0x0000, /* U+511b */
  0x0000, /* U+511c */
  0x0000, /* U+511d */
  0x0000, /* U+511e */
  0x8f9e, /* U+511f */
  0x0000, /* U+5120 */
  0x9953, /* U+5121 */
  0x0000, /* U+5122 */
  0x0000, /* U+5123 */
  0x0000, /* U+5124 */
  0x0000, /* U+5125 */
  0x0000, /* U+5126 */
  0x0000, /* U+5127 */
  0x0000, /* U+5128 */
  0x0000, /* U+5129 */
  0x9744, /* U+512a */
  0x0000, /* U+512b */
  0x0000, /* U+512c */
  0x0000, /* U+512d */
  0x0000, /* U+512e */
  0x0000, /* U+512f */
  0x0000, /* U+5130 */
  0x0000, /* U+5131 */
  0x96d7, /* U+5132 */
  0x0000, /* U+5133 */
  0x0000, /* U+5134 */
  0x0000, /* U+5135 */
  0x0000, /* U+5136 */
  0x9955, /* U+5137 */
  0x0000, /* U+5138 */
  0x0000, /* U+5139 */
  0x9954, /* U+513a */
  0x9957, /* U+513b */
  0x9956, /* U+513c */
  0x0000, /* U+513d */
  0x0000, /* U+513e */
  0x9958, /* U+513f */
  0x9959, /* U+5140 */
  0x88f2, /* U+5141 */
  0x0000, /* U+5142 */
  0x8cb3, /* U+5143 */
  0x8c5a, /* U+5144 */
  0x8f5b, /* U+5145 */
  0x929b, /* U+5146 */
  0x8ba2, /* U+5147 */
  0x90e6, /* U+5148 */
  0x8cf5, /* U+5149 */
  0xfa7e, /* U+514a */
  0x8d8e, /* U+514b */
  0x995b, /* U+514c */
  0x96c6, /* U+514d */
  0x9365, /* U+514e */
  0x0000, /* U+514f */
  0x8e99, /* U+5150 */
  0x0000, /* U+5151 */
  0x995a, /* U+5152 */
  0x0000, /* U+5153 */
  0x995c, /* U+5154 */
  0x0000, /* U+5155 */
  0x0000, /* U+5156 */
  0x0000, /* U+5157 */
  0x0000, /* U+5158 */
  0x0000, /* U+5159 */
  0x937d, /* U+515a */
  0x0000, /* U+515b */
  0x8a95, /* U+515c */
  0x0000, /* U+515d */
  0x0000, /* U+515e */
  0x0000, /* U+515f */
  0x0000, /* U+5160 */
  0x0000, /* U+5161 */
  0x995d, /* U+5162 */
  0x0000, /* U+5163 */
  0xfa80, /* U+5164 */
  0x93fc, /* U+5165 */
  0x0000, /* U+5166 */
  0x0000, /* U+5167 */
  0x9153, /* U+5168 */
  0x995f, /* U+5169 */
  0x9960, /* U+516a */
  0x94aa, /* U+516b */
  0x8cf6, /* U+516c */
  0x985a, /* U+516d */
  0x9961, /* U+516e */
  0x0000, /* U+516f */
  0x0000, /* U+5170 */
  0x8ba4, /* U+5171 */
  0x0000, /* U+5172 */
  0x0000, /* U+5173 */
  0x0000, /* U+5174 */
  0x95ba, /* U+5175 */
  0x91b4, /* U+5176 */
  0x8bef, /* U+5177 */
  0x9354, /* U+5178 */
  0x0000, /* U+5179 */
  0x0000, /* U+517a */
  0x0000, /* U+517b */
  0x8c93, /* U+517c */
  0x0000, /* U+517d */
  0x0000, /* U+517e */
  0x0000, /* U+517f */
  0x9962, /* U+5180 */
  0x0000, /* U+5181 */
  0x9963, /* U+5182 */
  0x0000, /* U+5183 */
  0x0000, /* U+5184 */
  0x93e0, /* U+5185 */
  0x897e, /* U+5186 */
  0x0000, /* U+5187 */
  0x0000, /* U+5188 */
  0x9966, /* U+5189 */
  0x8dfb, /* U+518a */
  0x0000, /* U+518b */
  0x9965, /* U+518c */
  0x8dc4, /* U+518d */
  0x0000, /* U+518e */
  0x9967, /* U+518f */
  0xe3ec, /* U+5190 */
  0x9968, /* U+5191 */
  0x9660, /* U+5192 */
  0x9969, /* U+5193 */
  0x0000, /* U+5194 */
  0x996a, /* U+5195 */
  0x996b, /* U+5196 */
  0x8fe7, /* U+5197 */
  0x0000, /* U+5198 */
  0x8eca, /* U+5199 */
  0x0000, /* U+519a */
  0x0000, /* U+519b */
  0x0000, /* U+519c */
  0xfa81, /* U+519d */
  0x0000, /* U+519e */
  0x0000, /* U+519f */
  0x8aa5, /* U+51a0 */
  0x0000, /* U+51a1 */
  0x996e, /* U+51a2 */
  0x0000, /* U+51a3 */
  0x996c, /* U+51a4 */
  0x96bb, /* U+51a5 */
  0x996d, /* U+51a6 */
  0x0000, /* U+51a7 */
  0x9579, /* U+51a8 */
  0x996f, /* U+51a9 */
  0x9970, /* U+51aa */
  0x9971, /* U+51ab */
  0x937e, /* U+51ac */
  0x0000, /* U+51ad */
  0x0000, /* U+51ae */
  0x0000, /* U+51af */
  0x9975, /* U+51b0 */
  0x9973, /* U+51b1 */
  0x9974, /* U+51b2 */
  0x9972, /* U+51b3 */
  0x8de1, /* U+51b4 */
  0x9976, /* U+51b5 */
  0x96e8, /* U+51b6 */
  0x97e2, /* U+51b7 */
  0x0000, /* U+51b8 */
  0x0000, /* U+51b9 */
  0x0000, /* U+51ba */
  0x0000, /* U+51bb */
  0x0000, /* U+51bc */
  0x9977, /* U+51bd */
  0xfa82, /* U+51be */
  0x0000, /* U+51bf */
  0x0000, /* U+51c0 */
  0x0000, /* U+51c1 */
  0x0000, /* U+51c2 */
  0x0000, /* U+51c3 */
  0x90a6, /* U+51c4 */
  0x9978, /* U+51c5 */
  0x8f79, /* U+51c6 */
  0x0000, /* U+51c7 */
  0x0000, /* U+51c8 */
  0x9979, /* U+51c9 */
  0x0000, /* U+51ca */
  0x929c, /* U+51cb */
  0x97bd, /* U+51cc */
  0x9380, /* U+51cd */
  0x0000, /* U+51ce */
  0x0000, /* U+51cf */
  0x0000, /* U+51d0 */
  0x0000, /* U+51d1 */
  0x0000, /* U+51d2 */
  0x0000, /* U+51d3 */
  0x0000, /* U+51d4 */
  0x0000, /* U+51d5 */
  0x99c3, /* U+51d6 */
  0x0000, /* U+51d7 */
  0x0000, /* U+51d8 */
  0x0000, /* U+51d9 */
  0x0000, /* U+51da */
  0x997a, /* U+51db */
  0xeaa3, /* U+51dc */
  0x8bc3, /* U+51dd */
  0x0000, /* U+51de */
  0x0000, /* U+51df */
  0x997b, /* U+51e0 */
  0x967d, /* U+51e1 */
  0x0000, /* U+51e2 */
  0x0000, /* U+51e3 */
  0x0000, /* U+51e4 */
  0x0000, /* U+51e5 */
  0x8f88, /* U+51e6 */
  0x91fa, /* U+51e7 */
  0x0000, /* U+51e8 */
  0x997d, /* U+51e9 */
  0x93e2, /* U+51ea */
  0x0000, /* U+51eb */
  0xfa83, /* U+51ec */
  0x997e, /* U+51ed */
  0x0000, /* U+51ee */
  0x0000, /* U+51ef */
  0x9980, /* U+51f0 */
  0x8a4d, /* U+51f1 */
  0x0000, /* U+51f2 */
  0x0000, /* U+51f3 */
  0x0000, /* U+51f4 */
  0x9981, /* U+51f5 */
  0x8ba5, /* U+51f6 */
  0x0000, /* U+51f7 */
  0x93ca, /* U+51f8 */
  0x899a, /* U+51f9 */
  0x8f6f, /* U+51fa */
  0x0000, /* U+51fb */
  0x0000, /* U+51fc */
  0x949f, /* U+51fd */
  0x9982, /* U+51fe */
  0x0000, /* U+51ff */
  0x9381, /* U+5200 */
  0x0000, /* U+5201 */
  0x0000, /* U+5202 */
  0x906e, /* U+5203 */
  0x9983, /* U+5204 */
  0x0000, /* U+5205 */
  0x95aa, /* U+5206 */
  0x90d8, /* U+5207 */
  0x8aa0, /* U+5208 */
  0x0000, /* U+5209 */
  0x8aa7, /* U+520a */
  0x9984, /* U+520b */
  0x0000, /* U+520c */
  0x0000, /* U+520d */
  0x9986, /* U+520e */
  0x0000, /* U+520f */
  0x0000, /* U+5210 */
  0x8c59, /* U+5211 */
  0x0000, /* U+5212 */
  0x0000, /* U+5213 */
  0x9985, /* U+5214 */
  0xfa84, /* U+5215 */
  0x0000, /* U+5216 */
  0x97f1, /* U+5217 */
  0x0000, /* U+5218 */
  0x0000, /* U+5219 */
  0x0000, /* U+521a */
  0x0000, /* U+521b */
  0x0000, /* U+521c */
  0x8f89, /* U+521d */
  0x0000, /* U+521e */
  0x0000, /* U+521f */
  0x0000, /* U+5220 */
  0x0000, /* U+5221 */
  0x0000, /* U+5222 */
  0x0000, /* U+5223 */
  0x94bb, /* U+5224 */
  0x95ca, /* U+5225 */
  0x0000, /* U+5226 */
  0x9987, /* U+5227 */
  0x0000, /* U+5228 */
  0x9798, /* U+5229 */
  0x9988, /* U+522a */
  0x0000, /* U+522b */
  0x0000, /* U+522c */
  0x0000, /* U+522d */
  0x9989, /* U+522e */
  0x0000, /* U+522f */
  0x939e, /* U+5230 */
  0x0000, /* U+5231 */
  0x0000, /* U+5232 */
  0x998a, /* U+5233 */
  0x0000, /* U+5234 */
  0x0000, /* U+5235 */
  0x90a7, /* U+5236 */
  0x8dfc, /* U+5237 */
  0x8c94, /* U+5238 */
  0x998b, /* U+5239 */
  0x8e68, /* U+523a */
  0x8d8f, /* U+523b */
  0x0000, /* U+523c */
  0x0000, /* U+523d */
  0x0000, /* U+523e */
  0x0000, /* U+523f */
  0x0000, /* U+5240 */
  0x0000, /* U+5241 */
  0x0000, /* U+5242 */
  0x92e4, /* U+5243 */
  0x998d, /* U+5244 */
  0x0000, /* U+5245 */
  0x0000, /* U+5246 */
  0x91a5, /* U+5247 */
  0x0000, /* U+5248 */
  0x0000, /* U+5249 */
  0x8ded, /* U+524a */
  0x998e, /* U+524b */
  0x998f, /* U+524c */
  0x914f, /* U+524d */
  0x0000, /* U+524e */
  0x998c, /* U+524f */
  0x0000, /* U+5250 */
  0x0000, /* U+5251 */
  0x0000, /* U+5252 */
  0x0000, /* U+5253 */
  0x9991, /* U+5254 */
  0x0000, /* U+5255 */
  0x9655, /* U+5256 */
  0x0000, /* U+5257 */
  0x0000, /* U+5258 */
  0x0000, /* U+5259 */
  0x0000, /* U+525a */
  0x8d84, /* U+525b */
  0x0000, /* U+525c */
  0x0000, /* U+525d */
  0x9990, /* U+525e */
  0x0000, /* U+525f */
  0x0000, /* U+5260 */
  0x0000, /* U+5261 */
  0x0000, /* U+5262 */
  0x8c95, /* U+5263 */
  0x8ddc, /* U+5264 */
  0x948d, /* U+5265 */
  0x0000, /* U+5266 */
  0x0000, /* U+5267 */
  0x0000, /* U+5268 */
  0x9994, /* U+5269 */
  0x9992, /* U+526a */
  0x0000, /* U+526b */
  0x0000, /* U+526c */
  0x0000, /* U+526d */
  0x0000, /* U+526e */
  0x959b, /* U+526f */
  0x8fe8, /* U+5270 */
  0x999b, /* U+5271 */
  0x8a84, /* U+5272 */
  0x9995, /* U+5273 */
  0x9993, /* U+5274 */
  0x916e, /* U+5275 */
  0x0000, /* U+5276 */
  0x0000, /* U+5277 */
  0x0000, /* U+5278 */
  0x0000, /* U+5279 */
  0x0000, /* U+527a */
  0x0000, /* U+527b */
  0x0000, /* U+527c */
  0x9997, /* U+527d */
  0x0000, /* U+527e */
  0x9996, /* U+527f */
  0x0000, /* U+5280 */
  0x0000, /* U+5281 */
  0x0000, /* U+5282 */
  0x8a63, /* U+5283 */
  0x0000, /* U+5284 */
  0x0000, /* U+5285 */
  0x0000, /* U+5286 */
  0x8c80, /* U+5287 */
  0x999c, /* U+5288 */
  0x97ab, /* U+5289 */
  0x0000, /* U+528a */
  0x0000, /* U+528b */
  0x0000, /* U+528c */
  0x9998, /* U+528d */
  0x0000, /* U+528e */
  0x0000, /* U+528f */
  0x0000, /* U+5290 */
  0x999d, /* U+5291 */
  0x999a, /* U+5292 */
  0x0000, /* U+5293 */
  0x9999, /* U+5294 */
  0x0000, /* U+5295 */
  0x0000, /* U+5296 */
  0x0000, /* U+5297 */
  0x0000, /* U+5298 */
  0x0000, /* U+5299 */
  0x0000, /* U+529a */
  0x97cd, /* U+529b */
  0xfa85, /* U+529c */
  0x0000, /* U+529d */
  0x0000, /* U+529e */
  0x8cf7, /* U+529f */
  0x89c1, /* U+52a0 */
  0x0000, /* U+52a1 */
  0x0000, /* U+52a2 */
  0x97f2, /* U+52a3 */
  0x0000, /* U+52a4 */
  0x0000, /* U+52a5 */
  0xfa86, /* U+52a6 */
  0x0000, /* U+52a7 */
  0x0000, /* U+52a8 */
  0x8f95, /* U+52a9 */
  0x9377, /* U+52aa */
  0x8d85, /* U+52ab */
  0x99a0, /* U+52ac */
  0x99a1, /* U+52ad */
  0x0000, /* U+52ae */
  0xfb77, /* U+52af */
  0x0000, /* U+52b0 */
  0x97e3, /* U+52b1 */
  0x0000, /* U+52b2 */
  0x0000, /* U+52b3 */
  0x984a, /* U+52b4 */
  0x99a3, /* U+52b5 */
  0x0000, /* U+52b6 */
  0x0000, /* U+52b7 */
  0x0000, /* U+52b8 */
  0x8cf8, /* U+52b9 */
  0x0000, /* U+52ba */
  0x0000, /* U+52bb */
  0x99a2, /* U+52bc */
  0x0000, /* U+52bd */
  0x8a4e, /* U+52be */
  0x0000, /* U+52bf */
  0xfa87, /* U+52c0 */
  0x99a4, /* U+52c1 */
  0x0000, /* U+52c2 */
  0x9675, /* U+52c3 */
  0x0000, /* U+52c4 */
  0x92ba, /* U+52c5 */
  0x0000, /* U+52c6 */
  0x9745, /* U+52c7 */
  0x0000, /* U+52c8 */
  0x95d7, /* U+52c9 */
  0x0000, /* U+52ca */
  0x0000, /* U+52cb */
  0x0000, /* U+52cc */
  0x99a5, /* U+52cd */
  0x0000, /* U+52ce */
  0x0000, /* U+52cf */
  0x0000, /* U+52d0 */
  0x0000, /* U+52d1 */
  0xe8d3, /* U+52d2 */
  0x0000, /* U+52d3 */
  0x0000, /* U+52d4 */
  0x93ae, /* U+52d5 */
  0x0000, /* U+52d6 */
  0x99a6, /* U+52d7 */
  0x8aa8, /* U+52d8 */
  0x96b1, /* U+52d9 */
  0x0000, /* U+52da */
  0xfa88, /* U+52db */
  0x0000, /* U+52dc */
  0x8f9f, /* U+52dd */
  0x99a7, /* U+52de */
  0x95e5, /* U+52df */
  0x99ab, /* U+52e0 */
  0x0000, /* U+52e1 */
  0x90a8, /* U+52e2 */
  0x99a8, /* U+52e3 */
  0x8bce, /* U+52e4 */
  0x0000, /* U+52e5 */
  0x99a9, /* U+52e6 */
  0x8aa9, /* U+52e7 */
  0x0000, /* U+52e8 */
  0x0000, /* U+52e9 */
  0x0000, /* U+52ea */
  0x0000, /* U+52eb */
  0x0000, /* U+52ec */
  0x0000, /* U+52ed */
  0x0000, /* U+52ee */
  0x0000, /* U+52ef */
  0x0000, /* U+52f0 */
  0x0000, /* U+52f1 */
  0x8c4d, /* U+52f2 */
  0x99ac, /* U+52f3 */
  0x0000, /* U+52f4 */
  0x99ad, /* U+52f5 */
  0x0000, /* U+52f6 */
  0x0000, /* U+52f7 */
  0x99ae, /* U+52f8 */
  0x99af, /* U+52f9 */
  0x8ed9, /* U+52fa */
  0x0000, /* U+52fb */
  0x0000, /* U+52fc */
  0x0000, /* U+52fd */
  0x8cf9, /* U+52fe */
  0x96dc, /* U+52ff */
  0xfa89, /* U+5300 */
  0x96e6, /* U+5301 */
  0x93f5, /* U+5302 */
  0x0000, /* U+5303 */
  0x0000, /* U+5304 */
  0x95ef, /* U+5305 */
  0x99b0, /* U+5306 */
  0xfa8a, /* U+5307 */
  0x99b1, /* U+5308 */
  0x0000, /* U+5309 */
  0x0000, /* U+530a */
  0x0000, /* U+530b */
  0x0000, /* U+530c */
  0x99b3, /* U+530d */
  0x0000, /* U+530e */
  0x99b5, /* U+530f */
  0x99b4, /* U+5310 */
  0x0000, /* U+5311 */
  0x0000, /* U+5312 */
  0x0000, /* U+5313 */
  0x0000, /* U+5314 */
  0x99b6, /* U+5315 */
  0x89bb, /* U+5316 */
  0x966b, /* U+5317 */
  0x0000, /* U+5318 */
  0x8dfa, /* U+5319 */
  0x99b7, /* U+531a */
  0x0000, /* U+531b */
  0x0000, /* U+531c */
  0x9178, /* U+531d */
  0x0000, /* U+531e */
  0x0000, /* U+531f */
  0x8fa0, /* U+5320 */
  0x8ba7, /* U+5321 */
  0x0000, /* U+5322 */
  0x99b8, /* U+5323 */
  0xfa8b, /* U+5324 */
  0x0000, /* U+5325 */
  0x0000, /* U+5326 */
  0x0000, /* U+5327 */
  0x0000, /* U+5328 */
  0x0000, /* U+5329 */
  0x94d9, /* U+532a */
  0x0000, /* U+532b */
  0x0000, /* U+532c */
  0x0000, /* U+532d */
  0x0000, /* U+532e */
  0x99b9, /* U+532f */
  0x0000, /* U+5330 */
  0x99ba, /* U+5331 */
  0x0000, /* U+5332 */
  0x99bb, /* U+5333 */
  0x0000, /* U+5334 */
  0x0000, /* U+5335 */
  0x0000, /* U+5336 */
  0x0000, /* U+5337 */
  0x99bc, /* U+5338 */
  0x9543, /* U+5339 */
  0x8be6, /* U+533a */
  0x88e3, /* U+533b */
  0x0000, /* U+533c */
  0x0000, /* U+533d */
  0x0000, /* U+533e */
  0x93bd, /* U+533f */
  0x99bd, /* U+5340 */
  0x8f5c, /* U+5341 */
  0x0000, /* U+5342 */
  0x90e7, /* U+5343 */
  0x0000, /* U+5344 */
  0x99bf, /* U+5345 */
  0x99be, /* U+5346 */
  0x8fa1, /* U+5347 */
  0x8cdf, /* U+5348 */
  0x99c1, /* U+5349 */
  0x94bc, /* U+534a */
  0x0000, /* U+534b */
  0x0000, /* U+534c */
  0x99c2, /* U+534d */
  0x0000, /* U+534e */
  0x0000, /* U+534f */
  0x0000, /* U+5350 */
  0x94da, /* U+5351 */
  0x91b2, /* U+5352 */
  0x91ec, /* U+5353 */
  0x8ba6, /* U+5354 */
  0x0000, /* U+5355 */
  0x0000, /* U+5356 */
  0x93ec, /* U+5357 */
  0x9250, /* U+5358 */
  0x0000, /* U+5359 */
  0x948e, /* U+535a */
  0x0000, /* U+535b */
  0x966d, /* U+535c */
  0x0000, /* U+535d */
  0x99c4, /* U+535e */
  0x0000, /* U+535f */
  0x90e8, /* U+5360 */
  0x0000, /* U+5361 */
  0x0000, /* U+5362 */
  0x0000, /* U+5363 */
  0x0000, /* U+5364 */
  0x0000, /* U+5365 */
  0x8c54, /* U+5366 */
  0x0000, /* U+5367 */
  0x0000, /* U+5368 */
  0x99c5, /* U+5369 */
  0x0000, /* U+536a */
  0x0000, /* U+536b */
  0x0000, /* U+536c */
  0x0000, /* U+536d */
  0x99c6, /* U+536e */
  0x894b, /* U+536f */
  0x88f3, /* U+5370 */
  0x8aeb, /* U+5371 */
  0xfa8c, /* U+5372 */
  0x91a6, /* U+5373 */
  0x8b70, /* U+5374 */
  0x9791, /* U+5375 */
  0x0000, /* U+5376 */
  0x99c9, /* U+5377 */
  0x89b5, /* U+5378 */
  0x0000, /* U+5379 */
  0x0000, /* U+537a */
  0x99c8, /* U+537b */
  0x0000, /* U+537c */
  0x0000, /* U+537d */
  0x0000, /* U+537e */
  0x8ba8, /* U+537f */
  0x0000, /* U+5380 */
  0x0000, /* U+5381 */
  0x99ca, /* U+5382 */
  0x0000, /* U+5383 */
  0x96ef, /* U+5384 */
  0x0000, /* U+5385 */
  0x0000, /* U+5386 */
  0x0000, /* U+5387 */
  0x0000, /* U+5388 */
  0x0000, /* U+5389 */
  0x0000, /* U+538a */
  0x0000, /* U+538b */
  0x0000, /* U+538c */
  0x0000, /* U+538d */
  0x0000, /* U+538e */
  0x0000, /* U+538f */
  0x0000, /* U+5390 */
  0x0000, /* U+5391 */
  0x0000, /* U+5392 */
  0xfa8d, /* U+5393 */
  0x0000, /* U+5394 */
  0x0000, /* U+5395 */
  0x99cb, /* U+5396 */
  0x0000, /* U+5397 */
  0x97d0, /* U+5398 */
  0x0000, /* U+5399 */
  0x8cfa, /* U+539a */
  0x0000, /* U+539b */
  0x0000, /* U+539c */
  0x0000, /* U+539d */
  0x0000, /* U+539e */
  0x8cb4, /* U+539f */
  0x99cc, /* U+53a0 */
  0x0000, /* U+53a1 */
  0x0000, /* U+53a2 */
  0x0000, /* U+53a3 */
  0x0000, /* U+53a4 */
  0x99ce, /* U+53a5 */
  0x99cd, /* U+53a6 */
  0x0000, /* U+53a7 */
  0x907e, /* U+53a8 */
  0x8958, /* U+53a9 */
  0x0000, /* U+53aa */
  0x0000, /* U+53ab */
  0x0000, /* U+53ac */
  0x897d, /* U+53ad */
  0x99cf, /* U+53ae */
  0x0000, /* U+53af */
  0x99d0, /* U+53b0 */
  0x0000, /* U+53b1 */
  0xfa8e, /* U+53b2 */
  0x8cb5, /* U+53b3 */
  0x0000, /* U+53b4 */
  0x0000, /* U+53b5 */
  0x99d1, /* U+53b6 */
  0x0000, /* U+53b7 */
  0x0000, /* U+53b8 */
  0x0000, /* U+53b9 */
  0x0000, /* U+53ba */
  0x8b8e, /* U+53bb */
  0x0000, /* U+53bc */
  0x0000, /* U+53bd */
  0x0000, /* U+53be */
  0x0000, /* U+53bf */
  0x0000, /* U+53c0 */
  0x0000, /* U+53c1 */
  0x8e51, /* U+53c2 */
  0x99d2, /* U+53c3 */
  0x0000, /* U+53c4 */
  0x0000, /* U+53c5 */
  0x0000, /* U+53c6 */
  0x0000, /* U+53c7 */
  0x9694, /* U+53c8 */
  0x8db3, /* U+53c9 */
  0x8b79, /* U+53ca */
  0x9746, /* U+53cb */
  0x916f, /* U+53cc */
  0x94bd, /* U+53cd */
  0x8efb, /* U+53ce */
  0x0000, /* U+53cf */
  0x0000, /* U+53d0 */
  0x0000, /* U+53d1 */
  0x0000, /* U+53d2 */
  0x0000, /* U+53d3 */
  0x8f66, /* U+53d4 */
  0x0000, /* U+53d5 */
  0x8ee6, /* U+53d6 */
  0x8ef3, /* U+53d7 */
  0x0000, /* U+53d8 */
  0x8f96, /* U+53d9 */
  0x0000, /* U+53da */
  0x94be, /* U+53db */
  0x0000, /* U+53dc */
  0xfa8f, /* U+53dd */
  0x0000, /* U+53de */
  0x99d5, /* U+53df */
  0x0000, /* U+53e0 */
  0x8962, /* U+53e1 */
  0x9170, /* U+53e2 */
  0x8cfb, /* U+53e3 */
  0x8cc3, /* U+53e4 */
  0x8be5, /* U+53e5 */
  0x0000, /* U+53e6 */
  0x0000, /* U+53e7 */
  0x99d9, /* U+53e8 */
  0x9240, /* U+53e9 */
  0x91fc, /* U+53ea */
  0x8ba9, /* U+53eb */
  0x8fa2, /* U+53ec */
  0x99da, /* U+53ed */
  0x99d8, /* U+53ee */
  0x89c2, /* U+53ef */
  0x91e4, /* U+53f0 */
  0x8eb6, /* U+53f1 */
  0x8e6a, /* U+53f2 */
  0x8945, /* U+53f3 */
  0x0000, /* U+53f4 */
  0x0000, /* U+53f5 */
  0x8a90, /* U+53f6 */
  0x8d86, /* U+53f7 */
  0x8e69, /* U+53f8 */
  0x0000, /* U+53f9 */
  0x99db, /* U+53fa */
  0x0000, /* U+53fb */
  0x0000, /* U+53fc */
  0x0000, /* U+53fd */
  0x0000, /* U+53fe */
  0x0000, /* U+53ff */
  0x0000, /* U+5400 */
  0x99dc, /* U+5401 */
  0x0000, /* U+5402 */
  0x8b68, /* U+5403 */
  0x8a65, /* U+5404 */
  0x0000, /* U+5405 */
  0x0000, /* U+5406 */
  0x0000, /* U+5407 */
  0x8d87, /* U+5408 */
  0x8b67, /* U+5409 */
  0x92dd, /* U+540a */
  0x8944, /* U+540b */
  0x93af, /* U+540c */
  0x96bc, /* U+540d */
  0x8d40, /* U+540e */
  0x9799, /* U+540f */
  0x9366, /* U+5410 */
  0x8cfc, /* U+5411 */
  0x0000, /* U+5412 */
  0x0000, /* U+5413 */
  0x0000, /* U+5414 */
  0x0000, /* U+5415 */
  0x0000, /* U+5416 */
  0x0000, /* U+5417 */
  0x0000, /* U+5418 */
  0x0000, /* U+5419 */
  0x0000, /* U+541a */
  0x8c4e, /* U+541b */
  0x0000, /* U+541c */
  0x99e5, /* U+541d */
  0x0000, /* U+541e */
  0x8be1, /* U+541f */
  0x9669, /* U+5420 */
  0x0000, /* U+5421 */
  0x0000, /* U+5422 */
  0x0000, /* U+5423 */
  0x0000, /* U+5424 */
  0x0000, /* U+5425 */
  0x94db, /* U+5426 */
  0x0000, /* U+5427 */
  0x0000, /* U+5428 */
  0x99e4, /* U+5429 */
  0x0000, /* U+542a */
  0x8adc, /* U+542b */
  0x99df, /* U+542c */
  0x99e0, /* U+542d */
  0x99e2, /* U+542e */
  0x0000, /* U+542f */
  0x0000, /* U+5430 */
  0x0000, /* U+5431 */
  0x0000, /* U+5432 */
  0x0000, /* U+5433 */
  0x0000, /* U+5434 */
  0x0000, /* U+5435 */
  0x99e3, /* U+5436 */
  0x0000, /* U+5437 */
  0x8b7a, /* U+5438 */
  0x9081, /* U+5439 */
  0x0000, /* U+543a */
  0x95ab, /* U+543b */
  0x99e1, /* U+543c */
  0x99dd, /* U+543d */
  0x8ce1, /* U+543e */
  0x0000, /* U+543f */
  0x99de, /* U+5440 */
  0x0000, /* U+5441 */
  0x9843, /* U+5442 */
  0x0000, /* U+5443 */
  0x0000, /* U+5444 */
  0x0000, /* U+5445 */
  0x95f0, /* U+5446 */
  0x0000, /* U+5447 */
  0x92e6, /* U+5448 */
  0x8ce0, /* U+5449 */
  0x8d90, /* U+544a */
  0x0000, /* U+544b */
  0x0000, /* U+544c */
  0x0000, /* U+544d */
  0x99e6, /* U+544e */
  0x0000, /* U+544f */
  0x0000, /* U+5450 */
  0x93db, /* U+5451 */
  0x0000, /* U+5452 */
  0x0000, /* U+5453 */
  0x0000, /* U+5454 */
  0x0000, /* U+5455 */
  0x0000, /* U+5456 */
  0x0000, /* U+5457 */
  0x0000, /* U+5458 */
  0x0000, /* U+5459 */
  0x0000, /* U+545a */
  0x0000, /* U+545b */
  0x0000, /* U+545c */
  0x0000, /* U+545d */
  0x0000, /* U+545e */
  0x99ea, /* U+545f */
  0x0000, /* U+5460 */
  0x0000, /* U+5461 */
  0x0000, /* U+5462 */
  0x0000, /* U+5463 */
  0x0000, /* U+5464 */
  0x0000, /* U+5465 */
  0x0000, /* U+5466 */
  0x0000, /* U+5467 */
  0x8efc, /* U+5468 */
  0x0000, /* U+5469 */
  0x8ef4, /* U+546a */
  0x0000, /* U+546b */
  0x0000, /* U+546c */
  0x0000, /* U+546d */
  0x0000, /* U+546e */
  0x0000, /* U+546f */
  0x99ed, /* U+5470 */
  0x99eb, /* U+5471 */
  0x0000, /* U+5472 */
  0x96a1, /* U+5473 */
  0x0000, /* U+5474 */
  0x99e8, /* U+5475 */
  0x99f1, /* U+5476 */
  0x99ec, /* U+5477 */
  0x0000, /* U+5478 */
  0x0000, /* U+5479 */
  0x0000, /* U+547a */
  0x99ef, /* U+547b */
  0x8cc4, /* U+547c */
  0x96bd, /* U+547d */
  0x0000, /* U+547e */
  0x0000, /* U+547f */
  0x99f0, /* U+5480 */
  0x0000, /* U+5481 */
  0x0000, /* U+5482 */
  0x0000, /* U+5483 */
  0x99f2, /* U+5484 */
  0x0000, /* U+5485 */
  0x99f4, /* U+5486 */
  0x0000, /* U+5487 */
  0x0000, /* U+5488 */
  0x0000, /* U+5489 */
  0xfa92, /* U+548a */
  0x8dee, /* U+548b */
  0x9861, /* U+548c */
  0x0000, /* U+548d */
  0x99e9, /* U+548e */
  0x99e7, /* U+548f */
  0x99f3, /* U+5490 */
  0x0000, /* U+5491 */
  0x99ee, /* U+5492 */
  0x0000, /* U+5493 */
  0x0000, /* U+5494 */
  0x0000, /* U+5495 */
  0x0000, /* U+5496 */
  0x0000, /* U+5497 */
  0x0000, /* U+5498 */
  0x0000, /* U+5499 */
  0x0000, /* U+549a */
  0x0000, /* U+549b */
  0xfa91, /* U+549c */
  0x0000, /* U+549d */
  0x0000, /* U+549e */
  0x0000, /* U+549f */
  0x0000, /* U+54a0 */
  0x0000, /* U+54a1 */
  0x99f6, /* U+54a2 */
  0x0000, /* U+54a3 */
  0x9a42, /* U+54a4 */
  0x99f8, /* U+54a5 */
  0x0000, /* U+54a6 */
  0x0000, /* U+54a7 */
  0x99fc, /* U+54a8 */
  0xfa93, /* U+54a9 */
  0x0000, /* U+54aa */
  0x9a40, /* U+54ab */
  0x99f9, /* U+54ac */
  0x0000, /* U+54ad */
  0x0000, /* U+54ae */
  0x9a5d, /* U+54af */
  0x0000, /* U+54b0 */
  0x0000, /* U+54b1 */
  0x8de7, /* U+54b2 */
  0x8a50, /* U+54b3 */
  0x0000, /* U+54b4 */
  0x0000, /* U+54b5 */
  0x0000, /* U+54b6 */
  0x0000, /* U+54b7 */
  0x99f7, /* U+54b8 */
  0x0000, /* U+54b9 */
  0x0000, /* U+54ba */
  0x0000, /* U+54bb */
  0x9a44, /* U+54bc */
  0x88f4, /* U+54bd */
  0x9a43, /* U+54be */
  0x0000, /* U+54bf */
  0x88a3, /* U+54c0 */
  0x9569, /* U+54c1 */
  0x9a41, /* U+54c2 */
  0x0000, /* U+54c3 */
  0x99fa, /* U+54c4 */
  0x0000, /* U+54c5 */
  0x0000, /* U+54c6 */
  0x99f5, /* U+54c7 */
  0x99fb, /* U+54c8 */
  0x8dc6, /* U+54c9 */
  0x0000, /* U+54ca */
  0x0000, /* U+54cb */
  0x0000, /* U+54cc */
  0x0000, /* U+54cd */
  0x0000, /* U+54ce */
  0x0000, /* U+54cf */
  0x0000, /* U+54d0 */
  0x0000, /* U+54d1 */
  0x0000, /* U+54d2 */
  0x0000, /* U+54d3 */
  0x0000, /* U+54d4 */
  0x0000, /* U+54d5 */
  0x0000, /* U+54d6 */
  0x0000, /* U+54d7 */
  0x9a45, /* U+54d8 */
  0x0000, /* U+54d9 */
  0x0000, /* U+54da */
  0x0000, /* U+54db */
  0x0000, /* U+54dc */
  0x0000, /* U+54dd */
  0x0000, /* U+54de */
  0x0000, /* U+54df */
  0x0000, /* U+54e0 */
  0x88f5, /* U+54e1 */
  0x9a4e, /* U+54e2 */
  0x0000, /* U+54e3 */
  0x0000, /* U+54e4 */
  0x9a46, /* U+54e5 */
  0x9a47, /* U+54e6 */
  0x0000, /* U+54e7 */
  0x8fa3, /* U+54e8 */
  0x9689, /* U+54e9 */
  0x0000, /* U+54ea */
  0x0000, /* U+54eb */
  0x0000, /* U+54ec */
  0x9a4c, /* U+54ed */
  0x9a4b, /* U+54ee */
  0x0000, /* U+54ef */
  0x0000, /* U+54f0 */
  0x0000, /* U+54f1 */
  0x934e, /* U+54f2 */
  0x0000, /* U+54f3 */
  0x0000, /* U+54f4 */
  0x0000, /* U+54f5 */
  0x0000, /* U+54f6 */
  0x0000, /* U+54f7 */
  0x0000, /* U+54f8 */
  0x0000, /* U+54f9 */
  0x9a4d, /* U+54fa */
  0x0000, /* U+54fb */
  0x0000, /* U+54fc */
  0x9a4a, /* U+54fd */
  0x0000, /* U+54fe */
  0xfa94, /* U+54ff */
  0x0000, /* U+5500 */
  0x0000, /* U+5501 */
  0x0000, /* U+5502 */
  0x0000, /* U+5503 */
  0x8953, /* U+5504 */
  0x0000, /* U+5505 */
  0x8db4, /* U+5506 */
  0x904f, /* U+5507 */
  0x0000, /* U+5508 */
  0x0000, /* U+5509 */
  0x0000, /* U+550a */
  0x0000, /* U+550b */
  0x0000, /* U+550c */
  0x0000, /* U+550d */
  0x0000, /* U+550e */
  0x9a48, /* U+550f */
  0x9382, /* U+5510 */
  0x0000, /* U+5511 */
  0x0000, /* U+5512 */
  0x0000, /* U+5513 */
  0x9a49, /* U+5514 */
  0x0000, /* U+5515 */
  0x88a0, /* U+5516 */
  0x0000, /* U+5517 */
  0x0000, /* U+5518 */
  0x0000, /* U+5519 */
  0x0000, /* U+551a */
  0x0000, /* U+551b */
  0x0000, /* U+551c */
  0x0000, /* U+551d */
  0x0000, /* U+551e */
  0x0000, /* U+551f */
  0x0000, /* U+5520 */
  0x0000, /* U+5521 */
  0x0000, /* U+5522 */
  0x0000, /* U+5523 */
  0x0000, /* U+5524 */
  0x0000, /* U+5525 */
  0x0000, /* U+5526 */
  0x0000, /* U+5527 */
  0x0000, /* U+5528 */
  0x0000, /* U+5529 */
  0x0000, /* U+552a */
  0x0000, /* U+552b */
  0x0000, /* U+552c */
  0x0000, /* U+552d */
  0x9a53, /* U+552e */
  0x9742, /* U+552f */
  0x0000, /* U+5530 */
  0x8fa5, /* U+5531 */
  0x0000, /* U+5532 */
  0x9a59, /* U+5533 */
  0x0000, /* U+5534 */
  0x0000, /* U+5535 */
  0x0000, /* U+5536 */
  0x0000, /* U+5537 */
  0x9a58, /* U+5538 */
  0x9a4f, /* U+5539 */
  0x0000, /* U+553a */
  0x0000, /* U+553b */
  0x0000, /* U+553c */
  0x0000, /* U+553d */
  0x91c1, /* U+553e */
  0x0000, /* U+553f */
  0x9a50, /* U+5540 */
  0x0000, /* U+5541 */
  0x0000, /* U+5542 */
  0x0000, /* U+5543 */
  0x91ed, /* U+5544 */
  0x9a55, /* U+5545 */
  0x8fa4, /* U+5546 */
  0x0000, /* U+5547 */
  0x0000, /* U+5548 */
  0x0000, /* U+5549 */
  0x0000, /* U+554a */
  0x0000, /* U+554b */
  0x9a52, /* U+554c */
  0x0000, /* U+554d */
  0x0000, /* U+554e */
  0x96e2, /* U+554f */
  0x0000, /* U+5550 */
  0x0000, /* U+5551 */
  0x0000, /* U+5552 */
  0x8c5b, /* U+5553 */
  0x0000, /* U+5554 */
  0x0000, /* U+5555 */
  0x9a56, /* U+5556 */
  0x9a57, /* U+5557 */
  0x0000, /* U+5558 */
  0x0000, /* U+5559 */
  0x0000, /* U+555a */
  0x0000, /* U+555b */
  0x9a54, /* U+555c */
  0x9a5a, /* U+555d */
  0x0000, /* U+555e */
  0x0000, /* U+555f */
  0x0000, /* U+5560 */
  0x0000, /* U+5561 */
  0x0000, /* U+5562 */
  0x9a51, /* U+5563 */
  0x0000, /* U+5564 */
  0x0000, /* U+5565 */
  0x0000, /* U+5566 */
  0x0000, /* U+5567 */
  0x0000, /* U+5568 */
  0x0000, /* U+5569 */
  0x0000, /* U+556a */
  0x0000, /* U+556b */
  0x0000, /* U+556c */
  0x0000, /* U+556d */
  0x0000, /* U+556e */
  0x0000, /* U+556f */
  0x0000, /* U+5570 */
  0x0000, /* U+5571 */
  0x0000, /* U+5572 */
  0x0000, /* U+5573 */
  0x0000, /* U+5574 */
  0x0000, /* U+5575 */
  0x0000, /* U+5576 */
  0x0000, /* U+5577 */
  0x0000, /* U+5578 */
  0x0000, /* U+5579 */
  0x0000, /* U+557a */
  0x9a60, /* U+557b */
  0x9a65, /* U+557c */
  0x0000, /* U+557d */
  0x9a61, /* U+557e */
  0x0000, /* U+557f */
  0x9a5c, /* U+5580 */
  0x0000, /* U+5581 */
  0x0000, /* U+5582 */
  0x9a66, /* U+5583 */
  0x9150, /* U+5584 */
  0x0000, /* U+5585 */
  0xfa95, /* U+5586 */
  0x9a68, /* U+5587 */
  0x0000, /* U+5588 */
  0x8d41, /* U+5589 */
  0x9a5e, /* U+558a */
  0x929d, /* U+558b */
  0x0000, /* U+558c */
  0x0000, /* U+558d */
  0x0000, /* U+558e */
  0x0000, /* U+558f */
  0x0000, /* U+5590 */
  0x0000, /* U+5591 */
  0x0000, /* U+5592 */
  0x0000, /* U+5593 */
  0x0000, /* U+5594 */
  0x0000, /* U+5595 */
  0x0000, /* U+5596 */
  0x0000, /* U+5597 */
  0x9a62, /* U+5598 */
  0x9a5b, /* U+5599 */
  0x8aab, /* U+559a */
  0x0000, /* U+559b */
  0x8aec, /* U+559c */
  0x8a85, /* U+559d */
  0x9a63, /* U+559e */
  0x9a5f, /* U+559f */
  0x0000, /* U+55a0 */
  0x0000, /* U+55a1 */
  0x0000, /* U+55a2 */
  0x0000, /* U+55a3 */
  0x0000, /* U+55a4 */
  0x0000, /* U+55a5 */
  0x0000, /* U+55a6 */
  0x8c96, /* U+55a7 */
  0x9a69, /* U+55a8 */
  0x9a67, /* U+55a9 */
  0x9172, /* U+55aa */
  0x8b69, /* U+55ab */
  0x8baa, /* U+55ac */
  0x0000, /* U+55ad */
  0x9a64, /* U+55ae */
  0x0000, /* U+55af */
  0x8bf2, /* U+55b0 */
  0x0000, /* U+55b1 */
  0x0000, /* U+55b2 */
  0x0000, /* U+55b3 */
  0x0000, /* U+55b4 */
  0x0000, /* U+55b5 */
  0x8963, /* U+55b6 */
  0x0000, /* U+55b7 */
  0x0000, /* U+55b8 */
  0x0000, /* U+55b9 */
  0x0000, /* U+55ba */
  0x0000, /* U+55bb */
  0x0000, /* U+55bc */
  0x0000, /* U+55bd */
  0x0000, /* U+55be */
  0x0000, /* U+55bf */
  0x0000, /* U+55c0 */
  0x0000, /* U+55c1 */
  0x0000, /* U+55c2 */
  0x0000, /* U+55c3 */
  0x9a6d, /* U+55c4 */
  0x9a6b, /* U+55c5 */
  0x0000, /* U+55c6 */
  0x9aa5, /* U+55c7 */
  0x0000, /* U+55c8 */
  0x0000, /* U+55c9 */
  0x0000, /* U+55ca */
  0x0000, /* U+55cb */
  0x0000, /* U+55cc */
  0x0000, /* U+55cd */
  0x0000, /* U+55ce */
  0x0000, /* U+55cf */
  0x0000, /* U+55d0 */
  0x0000, /* U+55d1 */
  0x0000, /* U+55d2 */
  0x0000, /* U+55d3 */
  0x9a70, /* U+55d4 */
  0x0000, /* U+55d5 */
  0x0000, /* U+55d6 */
  0x0000, /* U+55d7 */
  0x0000, /* U+55d8 */
  0x0000, /* U+55d9 */
  0x9a6a, /* U+55da */
  0x0000, /* U+55db */
  0x9a6e, /* U+55dc */
  0x0000, /* U+55dd */
  0x0000, /* U+55de */
  0x9a6c, /* U+55df */
  0x0000, /* U+55e0 */
  0x0000, /* U+55e1 */
  0x0000, /* U+55e2 */
  0x8e6b, /* U+55e3 */
  0x9a6f, /* U+55e4 */
  0x0000, /* U+55e5 */
  0x0000, /* U+55e6 */
  0x0000, /* U+55e7 */
  0x0000, /* U+55e8 */
  0x0000, /* U+55e9 */
  0x0000, /* U+55ea */
  0x0000, /* U+55eb */
  0x0000, /* U+55ec */
  0x0000, /* U+55ed */
  0x0000, /* U+55ee */
  0x0000, /* U+55ef */
  0x0000, /* U+55f0 */
  0x0000, /* U+55f1 */
  0x0000, /* U+55f2 */
  0x0000, /* U+55f3 */
  0x0000, /* U+55f4 */
  0x0000, /* U+55f5 */
  0x0000, /* U+55f6 */
  0x9a72, /* U+55f7 */
  0x0000, /* U+55f8 */
  0x9a77, /* U+55f9 */
  0x0000, /* U+55fa */
  0x0000, /* U+55fb */
  0x0000, /* U+55fc */
  0x9a75, /* U+55fd */
  0x9a74, /* U+55fe */
  0x0000, /* U+55ff */
  0x0000, /* U+5600 */
  0x0000, /* U+5601 */
  0x0000, /* U+5602 */
  0x0000, /* U+5603 */
  0x0000, /* U+5604 */
  0x0000, /* U+5605 */
  0x9251, /* U+5606 */
  0x0000, /* U+5607 */
  0x0000, /* U+5608 */
  0x89c3, /* U+5609 */
  0x0000, /* U+560a */
  0x0000, /* U+560b */
  0x0000, /* U+560c */
  0x0000, /* U+560d */
  0x0000, /* U+560e */
  0x0000, /* U+560f */
  0x0000, /* U+5610 */
  0x0000, /* U+5611 */
  0x0000, /* U+5612 */
  0x0000, /* U+5613 */
  0x9a71, /* U+5614 */
  0x0000, /* U+5615 */
  0x9a73, /* U+5616 */
  0x8fa6, /* U+5617 */
  0x8952, /* U+5618 */
  0x0000, /* U+5619 */
  0x0000, /* U+561a */
  0x9a76, /* U+561b */
  0x0000, /* U+561c */
  0x0000, /* U+561d */
  0x0000, /* U+561e */
  0x0000, /* U+561f */
  0x0000, /* U+5620 */
  0x0000, /* U+5621 */
  0x0000, /* U+5622 */
  0x0000, /* U+5623 */
  0x0000, /* U+5624 */
  0x0000, /* U+5625 */
  0x0000, /* U+5626 */
  0x0000, /* U+5627 */
  0x0000, /* U+5628 */
  0x89dc, /* U+5629 */
  0x0000, /* U+562a */
  0x0000, /* U+562b */
  0x0000, /* U+562c */
  0x0000, /* U+562d */
  0x0000, /* U+562e */
  0x9a82, /* U+562f */
  0x0000, /* U+5630 */
  0x8ffa, /* U+5631 */
  0x9a7d, /* U+5632 */
  0x0000, /* U+5633 */
  0x9a7b, /* U+5634 */
  0x0000, /* U+5635 */
  0x9a7c, /* U+5636 */
  0x0000, /* U+5637 */
  0x9a7e, /* U+5638 */
  0x0000, /* U+5639 */
  0x0000, /* U+563a */
  0x0000, /* U+563b */
  0x0000, /* U+563c */
  0x0000, /* U+563d */
  0x0000, /* U+563e */
  0x0000, /* U+563f */
  0x0000, /* U+5640 */
  0x0000, /* U+5641 */
  0x895c, /* U+5642 */
  0x0000, /* U+5643 */
  0x0000, /* U+5644 */
  0x0000, /* U+5645 */
  0x0000, /* U+5646 */
  0x0000, /* U+5647 */
  0x0000, /* U+5648 */
  0x0000, /* U+5649 */
  0x0000, /* U+564a */
  0x0000, /* U+564b */
  0x9158, /* U+564c */
  0x0000, /* U+564d */
  0x9a78, /* U+564e */
  0x0000, /* U+564f */
  0x9a79, /* U+5650 */
  0x0000, /* U+5651 */
  0x0000, /* U+5652 */
  0x0000, /* U+5653 */
  0x0000, /* U+5654 */
  0x0000, /* U+5655 */
  0x0000, /* U+5656 */
  0x0000, /* U+5657 */
  0x0000, /* U+5658 */
  0x0000, /* U+5659 */
  0x0000, /* U+565a */
  0x8a9a, /* U+565b */
  0x0000, /* U+565c */
  0x0000, /* U+565d */
  0x0000, /* U+565e */
  0x0000, /* U+565f */
  0x0000, /* U+5660 */
  0x0000, /* U+5661 */
  0x0000, /* U+5662 */
  0x0000, /* U+5663 */
  0x9a81, /* U+5664 */
  0x0000, /* U+5665 */
  0x0000, /* U+5666 */
  0x0000, /* U+5667 */
  0x8aed, /* U+5668 */
  0x0000, /* U+5669 */
  0x9a84, /* U+566a */
  0x9a80, /* U+566b */
  0x9a83, /* U+566c */
  0x0000, /* U+566d */
  0x0000, /* U+566e */
  0x0000, /* U+566f */
  0x0000, /* U+5670 */
  0x0000, /* U+5671 */
  0x0000, /* U+5672 */
  0x0000, /* U+5673 */
  0x95ac, /* U+5674 */
  0x0000, /* U+5675 */
  0x0000, /* U+5676 */
  0x0000, /* U+5677 */
  0x93d3, /* U+5678 */
  0x0000, /* U+5679 */
  0x94b6, /* U+567a */
  0x0000, /* U+567b */
  0x0000, /* U+567c */
  0x0000, /* U+567d */
  0x0000, /* U+567e */
  0x0000, /* U+567f */
  0x9a86, /* U+5680 */
  0x0000, /* U+5681 */
  0x0000, /* U+5682 */
  0x0000, /* U+5683 */
  0x0000, /* U+5684 */
  0x0000, /* U+5685 */
  0x9a85, /* U+5686 */
  0x8a64, /* U+5687 */
  0x0000, /* U+5688 */
  0x0000, /* U+5689 */
  0x9a87, /* U+568a */
  0x0000, /* U+568b */
  0x0000, /* U+568c */
  0x0000, /* U+568d */
  0x0000, /* U+568e */
  0x9a8a, /* U+568f */
  0x0000, /* U+5690 */
  0x0000, /* U+5691 */
  0x0000, /* U+5692 */
  0x0000, /* U+5693 */
  0x9a89, /* U+5694 */
  0x0000, /* U+5695 */
  0x0000, /* U+5696 */
  0x0000, /* U+5697 */
  0x0000, /* U+5698 */
  0x0000, /* U+5699 */
  0x0000, /* U+569a */
  0x0000, /* U+569b */
  0x0000, /* U+569c */
  0x0000, /* U+569d */
  0x0000, /* U+569e */
  0x0000, /* U+569f */
  0x9a88, /* U+56a0 */
  0x0000, /* U+56a1 */
  0x9458, /* U+56a2 */
  0x0000, /* U+56a3 */
  0x0000, /* U+56a4 */
  0x9a8b, /* U+56a5 */
  0x0000, /* U+56a6 */
  0x0000, /* U+56a7 */
  0x0000, /* U+56a8 */
  0x0000, /* U+56a9 */
  0x0000, /* U+56aa */
  0x0000, /* U+56ab */
  0x0000, /* U+56ac */
  0x0000, /* U+56ad */
  0x9a8c, /* U+56ae */
  0x0000, /* U+56af */
  0x0000, /* U+56b0 */
  0x0000, /* U+56b1 */
  0x0000, /* U+56b2 */
  0x0000, /* U+56b3 */
  0x9a8e, /* U+56b4 */
  0x0000, /* U+56b5 */
  0x9a8d, /* U+56b6 */
  0x0000, /* U+56b7 */
  0x0000, /* U+56b8 */
  0x0000, /* U+56b9 */
  0x0000, /* U+56ba */
  0x0000, /* U+56bb */
  0x9a90, /* U+56bc */
  0x0000, /* U+56bd */
  0x0000, /* U+56be */
  0x0000, /* U+56bf */
  0x9a93, /* U+56c0 */
  0x9a91, /* U+56c1 */
  0x9a8f, /* U+56c2 */
  0x9a92, /* U+56c3 */
  0x0000, /* U+56c4 */
  0x0000, /* U+56c5 */
  0x0000, /* U+56c6 */
  0x0000, /* U+56c7 */
  0x9a94, /* U+56c8 */
  0x0000, /* U+56c9 */
  0x0000, /* U+56ca */
  0x0000, /* U+56cb */
  0x0000, /* U+56cc */
  0x0000, /* U+56cd */
  0x9a95, /* U+56ce */
  0x0000, /* U+56cf */
  0x0000, /* U+56d0 */
  0x9a96, /* U+56d1 */
  0x0000, /* U+56d2 */
  0x9a97, /* U+56d3 */
  0x0000, /* U+56d4 */
  0x0000, /* U+56d5 */
  0x0000, /* U+56d6 */
  0x9a98, /* U+56d7 */
  0x9964, /* U+56d8 */
  0x0000, /* U+56d9 */
  0x8efa, /* U+56da */
  0x8e6c, /* U+56db */
  0x0000, /* U+56dc */
  0x0000, /* U+56dd */
  0x89f1, /* U+56de */
  0x0000, /* U+56df */
  0x88f6, /* U+56e0 */
  0x0000, /* U+56e1 */
  0x0000, /* U+56e2 */
  0x9263, /* U+56e3 */
  0x0000, /* U+56e4 */
  0x0000, /* U+56e5 */
  0x0000, /* U+56e6 */
  0x0000, /* U+56e7 */
  0x0000, /* U+56e8 */
  0x0000, /* U+56e9 */
  0x0000, /* U+56ea */
  0x0000, /* U+56eb */
  0x0000, /* U+56ec */
  0x0000, /* U+56ed */
  0x9a99, /* U+56ee */
  0x0000, /* U+56ef */
  0x8da2, /* U+56f0 */
  0x0000, /* U+56f1 */
  0x88cd, /* U+56f2 */
  0x907d, /* U+56f3 */
  0x0000, /* U+56f4 */
  0x0000, /* U+56f5 */
  0x0000, /* U+56f6 */
  0x0000, /* U+56f7 */
  0x0000, /* U+56f8 */
  0x9a9a, /* U+56f9 */
  0x8cc5, /* U+56fa */
  0x0000, /* U+56fb */
  0x0000, /* U+56fc */
  0x8d91, /* U+56fd */
  0x0000, /* U+56fe */
  0x9a9c, /* U+56ff */
  0x9a9b, /* U+5700 */
  0x0000, /* U+5701 */
  0x0000, /* U+5702 */
  0x95de, /* U+5703 */
  0x9a9d, /* U+5704 */
  0x0000, /* U+5705 */
  0x0000, /* U+5706 */
  0x0000, /* U+5707 */
  0x9a9f, /* U+5708 */
  0x9a9e, /* U+5709 */
  0x0000, /* U+570a */
  0x9aa0, /* U+570b */
  0x0000, /* U+570c */
  0x9aa1, /* U+570d */
  0x0000, /* U+570e */
  0x8c97, /* U+570f */
  0x0000, /* U+5710 */
  0x0000, /* U+5711 */
  0x8980, /* U+5712 */
  0x9aa2, /* U+5713 */
  0x0000, /* U+5714 */
  0x0000, /* U+5715 */
  0x9aa4, /* U+5716 */
  0x0000, /* U+5717 */
  0x9aa3, /* U+5718 */
  0x0000, /* U+5719 */
  0x0000, /* U+571a */
  0x0000, /* U+571b */
  0x9aa6, /* U+571c */
  0x0000, /* U+571d */
  0x0000, /* U+571e */
  0x9379, /* U+571f */
  0x0000, /* U+5720 */
  0x0000, /* U+5721 */
  0x0000, /* U+5722 */
  0x0000, /* U+5723 */
  0x0000, /* U+5724 */
  0x0000, /* U+5725 */
  0x9aa7, /* U+5726 */
  0x88b3, /* U+5727 */
  0x8ddd, /* U+5728 */
  0x0000, /* U+5729 */
  0x0000, /* U+572a */
  0x0000, /* U+572b */
  0x0000, /* U+572c */
  0x8c5c, /* U+572d */
  0x0000, /* U+572e */
  0x0000, /* U+572f */
  0x926e, /* U+5730 */
  0x0000, /* U+5731 */
  0x0000, /* U+5732 */
  0x0000, /* U+5733 */
  0x0000, /* U+5734 */
  0x0000, /* U+5735 */
  0x0000, /* U+5736 */
  0x9aa8, /* U+5737 */
  0x9aa9, /* U+5738 */
  0x0000, /* U+5739 */
  0x0000, /* U+573a */
  0x9aab, /* U+573b */
  0x0000, /* U+573c */
  0x0000, /* U+573d */
  0x0000, /* U+573e */
  0x0000, /* U+573f */
  0x9aac, /* U+5740 */
  0x0000, /* U+5741 */
  0x8de2, /* U+5742 */
  0x0000, /* U+5743 */
  0x0000, /* U+5744 */
  0x0000, /* U+5745 */
  0x0000, /* U+5746 */
  0x8bcf, /* U+5747 */
  0x0000, /* U+5748 */
  0x0000, /* U+5749 */
  0x9656, /* U+574a */
  0x0000, /* U+574b */
  0x0000, /* U+574c */
  0x0000, /* U+574d */
  0x9aaa, /* U+574e */
  0x9aad, /* U+574f */
  0x8dbf, /* U+5750 */
  0x8d42, /* U+5751 */
  0x0000, /* U+5752 */
  0x0000, /* U+5753 */
  0x0000, /* U+5754 */
  0x0000, /* U+5755 */
  0x0000, /* U+5756 */
  0x0000, /* U+5757 */
  0x0000, /* U+5758 */
  0xfa96, /* U+5759 */
  0x0000, /* U+575a */
  0x0000, /* U+575b */
  0x0000, /* U+575c */
  0x0000, /* U+575d */
  0x0000, /* U+575e */
  0x0000, /* U+575f */
  0x0000, /* U+5760 */
  0x9ab1, /* U+5761 */
  0x0000, /* U+5762 */
  0x0000, /* U+5763 */
  0x8da3, /* U+5764 */
  0xfa97, /* U+5765 */
  0x9252, /* U+5766 */
  0x0000, /* U+5767 */
  0x0000, /* U+5768 */
  0x9aae, /* U+5769 */
  0x92d8, /* U+576a */
  0x0000, /* U+576b */
  0x0000, /* U+576c */
  0x0000, /* U+576d */
  0x0000, /* U+576e */
  0x0000, /* U+576f */
  0x0000, /* U+5770 */
  0x0000, /* U+5771 */
  0x0000, /* U+5772 */
  0x0000, /* U+5773 */
  0x0000, /* U+5774 */
  0x0000, /* U+5775 */
  0x0000, /* U+5776 */
  0x0000, /* U+5777 */
  0x0000, /* U+5778 */
  0x0000, /* U+5779 */
  0x0000, /* U+577a */
  0x0000, /* U+577b */
  0x0000, /* U+577c */
  0x0000, /* U+577d */
  0x0000, /* U+577e */
  0x9ab2, /* U+577f */
  0x0000, /* U+5780 */
  0x0000, /* U+5781 */
  0x9082, /* U+5782 */
  0x0000, /* U+5783 */
  0x0000, /* U+5784 */
  0x0000, /* U+5785 */
  0x0000, /* U+5786 */
  0x0000, /* U+5787 */
  0x9ab0, /* U+5788 */
  0x9ab3, /* U+5789 */
  0x0000, /* U+578a */
  0x8c5e, /* U+578b */
  0x0000, /* U+578c */
  0x0000, /* U+578d */
  0x0000, /* U+578e */
  0x0000, /* U+578f */
  0x0000, /* U+5790 */
  0x0000, /* U+5791 */
  0x0000, /* U+5792 */
  0x9ab4, /* U+5793 */
  0x0000, /* U+5794 */
  0x0000, /* U+5795 */
  0x0000, /* U+5796 */
  0x0000, /* U+5797 */
  0x0000, /* U+5798 */
  0x0000, /* U+5799 */
  0x0000, /* U+579a */
  0x0000, /* U+579b */
  0x0000, /* U+579c */
  0x0000, /* U+579d */
  0x0000, /* U+579e */
  0x0000, /* U+579f */
  0x9ab5, /* U+57a0 */
  0x0000, /* U+57a1 */
  0x8d43, /* U+57a2 */
  0x8a5f, /* U+57a3 */
  0x9ab7, /* U+57a4 */
  0x0000, /* U+57a5 */
  0x0000, /* U+57a6 */
  0x0000, /* U+57a7 */
  0x0000, /* U+57a8 */
  0x0000, /* U+57a9 */
  0x9ab8, /* U+57aa */
  0x0000, /* U+57ab */
  0xfa98, /* U+57ac */
  0x0000, /* U+57ad */
  0x0000, /* U+57ae */
  0x0000, /* U+57af */
  0x9ab9, /* U+57b0 */
  0x0000, /* U+57b1 */
  0x0000, /* U+57b2 */
  0x9ab6, /* U+57b3 */
  0x0000, /* U+57b4 */
  0x0000, /* U+57b5 */
  0x0000, /* U+57b6 */
  0x0000, /* U+57b7 */
  0x0000, /* U+57b8 */
  0x0000, /* U+57b9 */
  0x0000, /* U+57ba */
  0x0000, /* U+57bb */
  0x0000, /* U+57bc */
  0x0000, /* U+57bd */
  0x0000, /* U+57be */
  0x0000, /* U+57bf */
  0x9aaf, /* U+57c0 */
  0x0000, /* U+57c1 */
  0x0000, /* U+57c2 */
  0x9aba, /* U+57c3 */
  0x0000, /* U+57c4 */
  0x0000, /* U+57c5 */
  0x9abb, /* U+57c6 */
  0xfa9a, /* U+57c7 */
  0xfa99, /* U+57c8 */
  0x0000, /* U+57c9 */
  0x0000, /* U+57ca */
  0x9684, /* U+57cb */
  0x0000, /* U+57cc */
  0x0000, /* U+57cd */
  0x8fe9, /* U+57ce */
  0x0000, /* U+57cf */
  0x0000, /* U+57d0 */
  0x0000, /* U+57d1 */
  0x9abd, /* U+57d2 */
  0x9abe, /* U+57d3 */
  0x9abc, /* U+57d4 */
  0x0000, /* U+57d5 */
  0x9ac0, /* U+57d6 */
  0x0000, /* U+57d7 */
  0x0000, /* U+57d8 */
  0x0000, /* U+57d9 */
  0x0000, /* U+57da */
  0x0000, /* U+57db */
  0x9457, /* U+57dc */
  0x0000, /* U+57dd */
  0x0000, /* U+57de */
  0x88e6, /* U+57df */
  0x9575, /* U+57e0 */
  0x0000, /* U+57e1 */
  0x0000, /* U+57e2 */
  0x9ac1, /* U+57e3 */
  0x0000, /* U+57e4 */
  0x0000, /* U+57e5 */
  0x0000, /* U+57e6 */
  0x0000, /* U+57e7 */
  0x0000, /* U+57e8 */
  0x0000, /* U+57e9 */
  0x0000, /* U+57ea */
  0x0000, /* U+57eb */
  0x0000, /* U+57ec */
  0x0000, /* U+57ed */
  0x0000, /* U+57ee */
  0x0000, /* U+57ef */
  0x0000, /* U+57f0 */
  0x0000, /* U+57f1 */
  0x0000, /* U+57f2 */
  0x0000, /* U+57f3 */
  0x8ffb, /* U+57f4 */
  0x0000, /* U+57f5 */
  0x0000, /* U+57f6 */
  0x8eb7, /* U+57f7 */
  0x0000, /* U+57f8 */
  0x947c, /* U+57f9 */
  0x8aee, /* U+57fa */
  0x0000, /* U+57fb */
  0x8de9, /* U+57fc */
  0x0000, /* U+57fd */
  0x0000, /* U+57fe */
  0x0000, /* U+57ff */
  0x9678, /* U+5800 */
  0x0000, /* U+5801 */
  0x93b0, /* U+5802 */
  0x0000, /* U+5803 */
  0x0000, /* U+5804 */
  0x8c98, /* U+5805 */
  0x91cd, /* U+5806 */
  0x0000, /* U+5807 */
  0x0000, /* U+5808 */
  0x0000, /* U+5809 */
  0x9abf, /* U+580a */
  0x9ac2, /* U+580b */
  0x0000, /* U+580c */
  0x0000, /* U+580d */
  0x0000, /* U+580e */
  0x0000, /* U+580f */
  0x0000, /* U+5810 */
  0x0000, /* U+5811 */
  0x0000, /* U+5812 */
  0x0000, /* U+5813 */
  0x0000, /* U+5814 */
  0x91c2, /* U+5815 */
  0x0000, /* U+5816 */
  0x0000, /* U+5817 */
  0x0000, /* U+5818 */
  0x9ac3, /* U+5819 */
  0x0000, /* U+581a */
  0x0000, /* U+581b */
  0x0000, /* U+581c */
  0x9ac4, /* U+581d */
  0x0000, /* U+581e */
  0x0000, /* U+581f */
  0x0000, /* U+5820 */
  0x9ac6, /* U+5821 */
  0x0000, /* U+5822 */
  0x0000, /* U+5823 */
  0x92e7, /* U+5824 */
  0x0000, /* U+5825 */
  0x0000, /* U+5826 */
  0x0000, /* U+5827 */
  0x0000, /* U+5828 */
  0x0000, /* U+5829 */
  0x8aac, /* U+582a */
  0x0000, /* U+582b */
  0x0000, /* U+582c */
  0x0000, /* U+582d */
  0x0000, /* U+582e */
  0xea9f, /* U+582f */
  0x8981, /* U+5830 */
  0x95f1, /* U+5831 */
  0x0000, /* U+5832 */
  0x0000, /* U+5833 */
  0x8fea, /* U+5834 */
  0x9367, /* U+5835 */
  0x0000, /* U+5836 */
  0x0000, /* U+5837 */
  0x0000, /* U+5838 */
  0x0000, /* U+5839 */
  0x8de4, /* U+583a */
  0x0000, /* U+583b */
  0x0000, /* U+583c */
  0x9acc, /* U+583d */
  0x0000, /* U+583e */
  0x0000, /* U+583f */
  0x95bb, /* U+5840 */
  0x97db, /* U+5841 */
  0x0000, /* U+5842 */
  0x0000, /* U+5843 */
  0x0000, /* U+5844 */
  0x0000, /* U+5845 */
  0x0000, /* U+5846 */
  0x0000, /* U+5847 */
  0x0000, /* U+5848 */
  0x0000, /* U+5849 */
  0x89f2, /* U+584a */
  0x9ac8, /* U+584b */
  0x0000, /* U+584c */
  0x0000, /* U+584d */
  0x0000, /* U+584e */
  0x0000, /* U+584f */
  0x0000, /* U+5850 */
  0x9159, /* U+5851 */
  0x9acb, /* U+5852 */
  0x0000, /* U+5853 */
  0x9383, /* U+5854 */
  0x0000, /* U+5855 */
  0x0000, /* U+5856 */
  0x9368, /* U+5857 */
  0x9384, /* U+5858 */
  0x94b7, /* U+5859 */
  0x92cb, /* U+585a */
  0x0000, /* U+585b */
  0x0000, /* U+585c */
  0x0000, /* U+585d */
  0x8dc7, /* U+585e */
  0x0000, /* U+585f */
  0x0000, /* U+5860 */
  0x0000, /* U+5861 */
  0x9ac7, /* U+5862 */
  0x0000, /* U+5863 */
  0x0000, /* U+5864 */
  0x0000, /* U+5865 */
  0x0000, /* U+5866 */
  0x0000, /* U+5867 */
  0x0000, /* U+5868 */
  0x8996, /* U+5869 */
  0x0000, /* U+586a */
  0x9355, /* U+586b */
  0x0000, /* U+586c */
  0x0000, /* U+586d */
  0x0000, /* U+586e */
  0x0000, /* U+586f */
  0x9ac9, /* U+5870 */
  0x0000, /* U+5871 */
  0x9ac5, /* U+5872 */
  0x0000, /* U+5873 */
  0x0000, /* U+5874 */
  0x906f, /* U+5875 */
  0x0000, /* U+5876 */
  0x0000, /* U+5877 */
  0x0000, /* U+5878 */
  0x9acd, /* U+5879 */
  0x0000, /* U+587a */
  0x0000, /* U+587b */
  0x0000, /* U+587c */
  0x0000, /* U+587d */
  0x8f6d, /* U+587e */
  0x0000, /* U+587f */
  0x0000, /* U+5880 */
  0x0000, /* U+5881 */
  0x0000, /* U+5882 */
  0x8bab, /* U+5883 */
  0x0000, /* U+5884 */
  0x9ace, /* U+5885 */
  0x0000, /* U+5886 */
  0x0000, /* U+5887 */
  0x0000, /* U+5888 */
  0x0000, /* U+5889 */
  0x0000, /* U+588a */
  0x0000, /* U+588b */
  0x0000, /* U+588c */
  0x0000, /* U+588d */
  0x0000, /* U+588e */
  0x0000, /* U+588f */
  0x0000, /* U+5890 */
  0x0000, /* U+5891 */
  0x0000, /* U+5892 */
  0x95e6, /* U+5893 */
  0x0000, /* U+5894 */
  0x0000, /* U+5895 */
  0x0000, /* U+5896 */
  0x919d, /* U+5897 */
  0x0000, /* U+5898 */
  0x0000, /* U+5899 */
  0x0000, /* U+589a */
  0x0000, /* U+589b */
  0x92c4, /* U+589c */
  0x0000, /* U+589d */
  0xfa9d, /* U+589e */
  0x9ad0, /* U+589f */
  0x0000, /* U+58a0 */
  0x0000, /* U+58a1 */
  0x0000, /* U+58a2 */
  0x0000, /* U+58a3 */
  0x0000, /* U+58a4 */
  0x0000, /* U+58a5 */
  0x0000, /* U+58a6 */
  0x0000, /* U+58a7 */
  0x966e, /* U+58a8 */
  0x0000, /* U+58a9 */
  0x0000, /* U+58aa */
  0x9ad1, /* U+58ab */
  0x0000, /* U+58ac */
  0x0000, /* U+58ad */
  0x9ad6, /* U+58ae */
  0x0000, /* U+58af */
  0x0000, /* U+58b0 */
  0x0000, /* U+58b1 */
  0xfa9e, /* U+58b2 */
  0x95ad, /* U+58b3 */
  0x0000, /* U+58b4 */
  0x0000, /* U+58b5 */
  0x0000, /* U+58b6 */
  0x0000, /* U+58b7 */
  0x9ad5, /* U+58b8 */
  0x9acf, /* U+58b9 */
  0x9ad2, /* U+58ba */
  0x9ad4, /* U+58bb */
  0x0000, /* U+58bc */
  0x0000, /* U+58bd */
  0x8da4, /* U+58be */
  0x0000, /* U+58bf */
  0x0000, /* U+58c0 */
  0x95c7, /* U+58c1 */
  0x0000, /* U+58c2 */
  0x0000, /* U+58c3 */
  0x0000, /* U+58c4 */
  0x9ad7, /* U+58c5 */
  0x0000, /* U+58c6 */
  0x9264, /* U+58c7 */
  0x0000, /* U+58c8 */
  0x0000, /* U+58c9 */
  0x89f3, /* U+58ca */
  0x0000, /* U+58cb */
  0x8feb, /* U+58cc */
  0x0000, /* U+58cd */
  0x0000, /* U+58ce */
  0x0000, /* U+58cf */
  0x0000, /* U+58d0 */
  0x9ad9, /* U+58d1 */
  0x0000, /* U+58d2 */
  0x9ad8, /* U+58d3 */
  0x0000, /* U+58d4 */
  0x8d88, /* U+58d5 */
  0x0000, /* U+58d6 */
  0x9ada, /* U+58d7 */
  0x9adc, /* U+58d8 */
  0x9adb, /* U+58d9 */
  0x0000, /* U+58da */
  0x0000, /* U+58db */
  0x9ade, /* U+58dc */
  0x0000, /* U+58dd */
  0x9ad3, /* U+58de */
  0x9ae0, /* U+58df */
  0x0000, /* U+58e0 */
  0x0000, /* U+58e1 */
  0x0000, /* U+58e2 */
  0x0000, /* U+58e3 */
  0x9adf, /* U+58e4 */
  0x9add, /* U+58e5 */
  0x0000, /* U+58e6 */
  0x0000, /* U+58e7 */
  0x0000, /* U+58e8 */
  0x0000, /* U+58e9 */
  0x0000, /* U+58ea */
  0x8e6d, /* U+58eb */
  0x9070, /* U+58ec */
  0x0000, /* U+58ed */
  0x9173, /* U+58ee */
  0x9ae1, /* U+58ef */
  0x90ba, /* U+58f0 */
  0x88eb, /* U+58f1 */
  0x9484, /* U+58f2 */
  0x0000, /* U+58f3 */
  0x0000, /* U+58f4 */
  0x0000, /* U+58f5 */
  0x0000, /* U+58f6 */
  0x92d9, /* U+58f7 */
  0x0000, /* U+58f8 */
  0x9ae3, /* U+58f9 */
  0x9ae2, /* U+58fa */
  0x9ae4, /* U+58fb */
  0x9ae5, /* U+58fc */
  0x9ae6, /* U+58fd */
  0x0000, /* U+58fe */
  0x0000, /* U+58ff */
  0x0000, /* U+5900 */
  0x0000, /* U+5901 */
  0x9ae7, /* U+5902 */
  0x0000, /* U+5903 */
  0x0000, /* U+5904 */
  0x0000, /* U+5905 */
  0x0000, /* U+5906 */
  0x0000, /* U+5907 */
  0x0000, /* U+5908 */
  0x95cf, /* U+5909 */
  0x9ae8, /* U+590a */
  0xfa9f, /* U+590b */
  0x0000, /* U+590c */
  0x0000, /* U+590d */
  0x0000, /* U+590e */
  0x89c4, /* U+590f */
  0x9ae9, /* U+5910 */
  0x0000, /* U+5911 */
  0x0000, /* U+5912 */
  0x0000, /* U+5913 */
  0x0000, /* U+5914 */
  0x975b, /* U+5915 */
  0x8a4f, /* U+5916 */
  0x0000, /* U+5917 */
  0x99c7, /* U+5918 */
  0x8f67, /* U+5919 */
  0x91bd, /* U+591a */
  0x9aea, /* U+591b */
  0x96e9, /* U+591c */
  0x0000, /* U+591d */
  0x0000, /* U+591e */
  0x0000, /* U+591f */
  0x0000, /* U+5920 */
  0x0000, /* U+5921 */
  0x96b2, /* U+5922 */
  0x0000, /* U+5923 */
  0x0000, /* U+5924 */
  0x9aec, /* U+5925 */
  0x0000, /* U+5926 */
  0x91e5, /* U+5927 */
  0x0000, /* U+5928 */
  0x9356, /* U+5929 */
  0x91be, /* U+592a */
  0x9576, /* U+592b */
  0x9aed, /* U+592c */
  0x9aee, /* U+592d */
  0x899b, /* U+592e */
  0x0000, /* U+592f */
  0x0000, /* U+5930 */
  0x8eb8, /* U+5931 */
  0x9aef, /* U+5932 */
  0x0000, /* U+5933 */
  0x0000, /* U+5934 */
  0x0000, /* U+5935 */
  0x0000, /* U+5936 */
  0x88ce, /* U+5937 */
  0x9af0, /* U+5938 */
  0x0000, /* U+5939 */
  0x0000, /* U+593a */
  0x0000, /* U+593b */
  0x0000, /* U+593c */
  0x0000, /* U+593d */
  0x9af1, /* U+593e */
  0x0000, /* U+593f */
  0x0000, /* U+5940 */
  0x0000, /* U+5941 */
  0x0000, /* U+5942 */
  0x0000, /* U+5943 */
  0x8982, /* U+5944 */
  0x0000, /* U+5945 */
  0x0000, /* U+5946 */
  0x8aef, /* U+5947 */
  0x93de, /* U+5948 */
  0x95f2, /* U+5949 */
  0x0000, /* U+594a */
  0x0000, /* U+594b */
  0x0000, /* U+594c */
  0x0000, /* U+594d */
  0x9af5, /* U+594e */
  0x9174, /* U+594f */
  0x9af4, /* U+5950 */
  0x8c5f, /* U+5951 */
  0x0000, /* U+5952 */
  0xfaa0, /* U+5953 */
  0x967a, /* U+5954 */
  0x9af3, /* U+5955 */
  0x0000, /* U+5956 */
  0x9385, /* U+5957 */
  0x9af7, /* U+5958 */
  0x0000, /* U+5959 */
  0x9af6, /* U+595a */
  0xfaa1, /* U+595b */
  0x0000, /* U+595c */
  0xfaa2, /* U+595d */
  0x0000, /* U+595e */
  0x0000, /* U+595f */
  0x9af9, /* U+5960 */
  0x0000, /* U+5961 */
  0x9af8, /* U+5962 */
  0xfaa3, /* U+5963 */
  0x0000, /* U+5964 */
  0x899c, /* U+5965 */
  0x0000, /* U+5966 */
  0x9afa, /* U+5967 */
  0x8fa7, /* U+5968 */
  0x9afc, /* U+5969 */
  0x9244, /* U+596a */
  0x0000, /* U+596b */
  0x9afb, /* U+596c */
  0x0000, /* U+596d */
  0x95b1, /* U+596e */
  0x0000, /* U+596f */
  0x0000, /* U+5970 */
  0x0000, /* U+5971 */
  0x0000, /* U+5972 */
  0x8f97, /* U+5973 */
  0x937a, /* U+5974 */
  0x0000, /* U+5975 */
  0x0000, /* U+5976 */
  0x0000, /* U+5977 */
  0x9b40, /* U+5978 */
  0x0000, /* U+5979 */
  0x0000, /* U+597a */
  0x0000, /* U+597b */
  0x0000, /* U+597c */
  0x8d44, /* U+597d */
  0x0000, /* U+597e */
  0x0000, /* U+597f */
  0x0000, /* U+5980 */
  0x9b41, /* U+5981 */
  0x9440, /* U+5982 */
  0x94dc, /* U+5983 */
  0x96cf, /* U+5984 */
  0x0000, /* U+5985 */
  0x0000, /* U+5986 */
  0x0000, /* U+5987 */
  0x0000, /* U+5988 */
  0x0000, /* U+5989 */
  0x9444, /* U+598a */
  0x0000, /* U+598b */
  0x0000, /* U+598c */
  0x9b4a, /* U+598d */
  0x0000, /* U+598e */
  0x0000, /* U+598f */
  0x0000, /* U+5990 */
  0x0000, /* U+5991 */
  0x0000, /* U+5992 */
  0x8b57, /* U+5993 */
  0x0000, /* U+5994 */
  0x0000, /* U+5995 */
  0x9764, /* U+5996 */
  0x0000, /* U+5997 */
  0x0000, /* U+5998 */
  0x96ad, /* U+5999 */
  0x0000, /* U+599a */
  0x9baa, /* U+599b */
  0x0000, /* U+599c */
  0x9b42, /* U+599d */
  0x0000, /* U+599e */
  0x0000, /* U+599f */
  0x0000, /* U+59a0 */
  0x0000, /* U+59a1 */
  0x0000, /* U+59a2 */
  0x9b45, /* U+59a3 */
  0xfaa4, /* U+59a4 */
  0x91c3, /* U+59a5 */
  0x0000, /* U+59a6 */
  0x0000, /* U+59a7 */
  0x9657, /* U+59a8 */
  0x0000, /* U+59a9 */
  0x0000, /* U+59aa */
  0x0000, /* U+59ab */
  0x9369, /* U+59ac */
  0x0000, /* U+59ad */
  0x0000, /* U+59ae */
  0x0000, /* U+59af */
  0x0000, /* U+59b0 */
  0x0000, /* U+59b1 */
  0x9b46, /* U+59b2 */
  0x0000, /* U+59b3 */
  0x0000, /* U+59b4 */
  0x0000, /* U+59b5 */
  0x0000, /* U+59b6 */
  0x0000, /* U+59b7 */
  0x0000, /* U+59b8 */
  0x9685, /* U+59b9 */
  0xfaa5, /* U+59ba */
  0x8dc8, /* U+59bb */
  0x0000, /* U+59bc */
  0x0000, /* U+59bd */
  0x8fa8, /* U+59be */
  0x0000, /* U+59bf */
  0x0000, /* U+59c0 */
  0x0000, /* U+59c1 */
  0x0000, /* U+59c2 */
  0x0000, /* U+59c3 */
  0x0000, /* U+59c4 */
  0x0000, /* U+59c5 */
  0x9b47, /* U+59c6 */
  0x0000, /* U+59c7 */
  0x0000, /* U+59c8 */
  0x8e6f, /* U+59c9 */
  0x0000, /* U+59ca */
  0x8e6e, /* U+59cb */
  0x0000, /* U+59cc */
  0x0000, /* U+59cd */
  0x0000, /* U+59ce */
  0x0000, /* U+59cf */
  0x88b7, /* U+59d0 */
  0x8cc6, /* U+59d1 */
  0x0000, /* U+59d2 */
  0x90a9, /* U+59d3 */
  0x88cf, /* U+59d4 */
  0x0000, /* U+59d5 */
  0x0000, /* U+59d6 */
  0x0000, /* U+59d7 */
  0x0000, /* U+59d8 */
  0x9b4b, /* U+59d9 */
  0x9b4c, /* U+59da */
  0x0000, /* U+59db */
  0x9b49, /* U+59dc */
  0x0000, /* U+59dd */
  0x0000, /* U+59de */
  0x0000, /* U+59df */
  0x0000, /* U+59e0 */
  0x0000, /* U+59e1 */
  0x0000, /* U+59e2 */
  0x0000, /* U+59e3 */
  0x0000, /* U+59e4 */
  0x8957, /* U+59e5 */
  0x8aad, /* U+59e6 */
  0x0000, /* U+59e7 */
  0x9b48, /* U+59e8 */
  0x0000, /* U+59e9 */
  0x96c3, /* U+59ea */
  0x9550, /* U+59eb */
  0x0000, /* U+59ec */
  0x0000, /* U+59ed */
  0x0000, /* U+59ee */
  0x0000, /* U+59ef */
  0x0000, /* U+59f0 */
  0x0000, /* U+59f1 */
  0x0000, /* U+59f2 */
  0x0000, /* U+59f3 */
  0x0000, /* U+59f4 */
  0x0000, /* U+59f5 */
  0x88a6, /* U+59f6 */
  0x0000, /* U+59f7 */
  0x0000, /* U+59f8 */
  0x0000, /* U+59f9 */
  0x0000, /* U+59fa */
  0x88f7, /* U+59fb */
  0x0000, /* U+59fc */
  0x0000, /* U+59fd */
  0x0000, /* U+59fe */
  0x8e70, /* U+59ff */
  0x0000, /* U+5a00 */
  0x88d0, /* U+5a01 */
  0x0000, /* U+5a02 */
  0x88a1, /* U+5a03 */
  0x0000, /* U+5a04 */
  0x0000, /* U+5a05 */
  0x0000, /* U+5a06 */
  0x0000, /* U+5a07 */
  0x0000, /* U+5a08 */
  0x9b51, /* U+5a09 */
  0x0000, /* U+5a0a */
  0x0000, /* U+5a0b */
  0x0000, /* U+5a0c */
  0x0000, /* U+5a0d */
  0x0000, /* U+5a0e */
  0x0000, /* U+5a0f */
  0x0000, /* U+5a10 */
  0x9b4f, /* U+5a11 */
  0x0000, /* U+5a12 */
  0x0000, /* U+5a13 */
  0x0000, /* U+5a14 */
  0x0000, /* U+5a15 */
  0x0000, /* U+5a16 */
  0x0000, /* U+5a17 */
  0x96ba, /* U+5a18 */
  0x0000, /* U+5a19 */
  0x9b52, /* U+5a1a */
  0x0000, /* U+5a1b */
  0x9b50, /* U+5a1c */
  0x0000, /* U+5a1d */
  0x0000, /* U+5a1e */
  0x9b4e, /* U+5a1f */
  0x9050, /* U+5a20 */
  0x0000, /* U+5a21 */
  0x0000, /* U+5a22 */
  0x0000, /* U+5a23 */
  0x0000, /* U+5a24 */
  0x9b4d, /* U+5a25 */
  0x0000, /* U+5a26 */
  0x0000, /* U+5a27 */
  0x0000, /* U+5a28 */
  0x95d8, /* U+5a29 */
  0x0000, /* U+5a2a */
  0x0000, /* U+5a2b */
  0x0000, /* U+5a2c */
  0x0000, /* U+5a2d */
  0x0000, /* U+5a2e */
  0x8ce2, /* U+5a2f */
  0x0000, /* U+5a30 */
  0x0000, /* U+5a31 */
  0x0000, /* U+5a32 */
  0x0000, /* U+5a33 */
  0x0000, /* U+5a34 */
  0x9b56, /* U+5a35 */
  0x9b57, /* U+5a36 */
  0x0000, /* U+5a37 */
  0x0000, /* U+5a38 */
  0x0000, /* U+5a39 */
  0x0000, /* U+5a3a */
  0x0000, /* U+5a3b */
  0x8fa9, /* U+5a3c */
  0x0000, /* U+5a3d */
  0x0000, /* U+5a3e */
  0x0000, /* U+5a3f */
  0x9b53, /* U+5a40 */
  0x984b, /* U+5a41 */
  0x0000, /* U+5a42 */
  0x0000, /* U+5a43 */
  0x0000, /* U+5a44 */
  0x0000, /* U+5a45 */
  0x946b, /* U+5a46 */
  0x0000, /* U+5a47 */
  0x0000, /* U+5a48 */
  0x9b55, /* U+5a49 */
  0x0000, /* U+5a4a */
  0x0000, /* U+5a4b */
  0x0000, /* U+5a4c */
  0x0000, /* U+5a4d */
  0x0000, /* U+5a4e */
  0x0000, /* U+5a4f */
  0x0000, /* U+5a50 */
  0x0000, /* U+5a51 */
  0x0000, /* U+5a52 */
  0x0000, /* U+5a53 */
  0x0000, /* U+5a54 */
  0x0000, /* U+5a55 */
  0x0000, /* U+5a56 */
  0x0000, /* U+5a57 */
  0x0000, /* U+5a58 */
  0x0000, /* U+5a59 */
  0x8da5, /* U+5a5a */
  0x0000, /* U+5a5b */
  0x0000, /* U+5a5c */
  0x0000, /* U+5a5d */
  0x0000, /* U+5a5e */
  0x0000, /* U+5a5f */
  0x0000, /* U+5a60 */
  0x0000, /* U+5a61 */
  0x9b58, /* U+5a62 */
  0x0000, /* U+5a63 */
  0x0000, /* U+5a64 */
  0x0000, /* U+5a65 */
  0x9577, /* U+5a66 */
  0x0000, /* U+5a67 */
  0x0000, /* U+5a68 */
  0x0000, /* U+5a69 */
  0x9b59, /* U+5a6a */
  0x0000, /* U+5a6b */
  0x9b54, /* U+5a6c */
  0x0000, /* U+5a6d */
  0x0000, /* U+5a6e */
  0x0000, /* U+5a6f */
  0x0000, /* U+5a70 */
  0x0000, /* U+5a71 */
  0x0000, /* U+5a72 */
  0x0000, /* U+5a73 */
  0x0000, /* U+5a74 */
  0x0000, /* U+5a75 */
  0x0000, /* U+5a76 */
  0x0000, /* U+5a77 */
  0x0000, /* U+5a78 */
  0x0000, /* U+5a79 */
  0x0000, /* U+5a7a */
  0x0000, /* U+5a7b */
  0x0000, /* U+5a7c */
  0x0000, /* U+5a7d */
  0x0000, /* U+5a7e */
  0x96b9, /* U+5a7f */
  0x0000, /* U+5a80 */
  0x0000, /* U+5a81 */
  0x0000, /* U+5a82 */
  0x0000, /* U+5a83 */
  0x0000, /* U+5a84 */
  0x0000, /* U+5a85 */
  0x0000, /* U+5a86 */
  0x0000, /* U+5a87 */
  0x0000, /* U+5a88 */
  0x0000, /* U+5a89 */
  0x0000, /* U+5a8a */
  0x0000, /* U+5a8b */
  0x0000, /* U+5a8c */
  0x0000, /* U+5a8d */
  0x0000, /* U+5a8e */
  0x0000, /* U+5a8f */
  0x0000, /* U+5a90 */
  0x0000, /* U+5a91 */
  0x947d, /* U+5a92 */
  0x0000, /* U+5a93 */
  0x0000, /* U+5a94 */
  0x0000, /* U+5a95 */
  0x0000, /* U+5a96 */
  0x0000, /* U+5a97 */
  0x0000, /* U+5a98 */
  0x0000, /* U+5a99 */
  0x9b5a, /* U+5a9a */
  0x9551, /* U+5a9b */
  0x0000, /* U+5a9c */
  0x0000, /* U+5a9d */
  0x0000, /* U+5a9e */
  0x0000, /* U+5a9f */
  0x0000, /* U+5aa0 */
  0x0000, /* U+5aa1 */
  0x0000, /* U+5aa2 */
  0x0000, /* U+5aa3 */
  0x0000, /* U+5aa4 */
  0x0000, /* U+5aa5 */
  0x0000, /* U+5aa6 */
  0x0000, /* U+5aa7 */
  0x0000, /* U+5aa8 */
  0x0000, /* U+5aa9 */
  0x0000, /* U+5aaa */
  0x0000, /* U+5aab */
  0x0000, /* U+5aac */
  0x0000, /* U+5aad */
  0x0000, /* U+5aae */
  0x0000, /* U+5aaf */
  0x0000, /* U+5ab0 */
  0x0000, /* U+5ab1 */
  0x0000, /* U+5ab2 */
  0x0000, /* U+5ab3 */
  0x0000, /* U+5ab4 */
  0x0000, /* U+5ab5 */
  0x0000, /* U+5ab6 */
  0x0000, /* U+5ab7 */
  0x0000, /* U+5ab8 */
  0x0000, /* U+5ab9 */
  0x0000, /* U+5aba */
  0x0000, /* U+5abb */
  0x9b5b, /* U+5abc */
  0x9b5f, /* U+5abd */
  0x9b5c, /* U+5abe */
  0x0000, /* U+5abf */
  0x0000, /* U+5ac0 */
  0x89c5, /* U+5ac1 */
  0x9b5e, /* U+5ac2 */
  0x0000, /* U+5ac3 */
  0x0000, /* U+5ac4 */
  0x0000, /* U+5ac5 */
  0x0000, /* U+5ac6 */
  0x0000, /* U+5ac7 */
  0x0000, /* U+5ac8 */
  0x8eb9, /* U+5ac9 */
  0x0000, /* U+5aca */
  0x9b5d, /* U+5acb */
  0x8c99, /* U+5acc */
  0x0000, /* U+5acd */
  0x0000, /* U+5ace */
  0x0000, /* U+5acf */
  0x9b6b, /* U+5ad0 */
  0x0000, /* U+5ad1 */
  0x0000, /* U+5ad2 */
  0x0000, /* U+5ad3 */
  0x0000, /* U+5ad4 */
  0x0000, /* U+5ad5 */
  0x9b64, /* U+5ad6 */
  0x9b61, /* U+5ad7 */
  0x0000, /* U+5ad8 */
  0x0000, /* U+5ad9 */
  0x0000, /* U+5ada */
  0x0000, /* U+5adb */
  0x0000, /* U+5adc */
  0x0000, /* U+5add */
  0x0000, /* U+5ade */
  0x0000, /* U+5adf */
  0x0000, /* U+5ae0 */
  0x9284, /* U+5ae1 */
  0x0000, /* U+5ae2 */
  0x9b60, /* U+5ae3 */
  0x0000, /* U+5ae4 */
  0x0000, /* U+5ae5 */
  0x9b62, /* U+5ae6 */
  0x0000, /* U+5ae7 */
  0x0000, /* U+5ae8 */
  0x9b63, /* U+5ae9 */
  0x0000, /* U+5aea */
  0x0000, /* U+5aeb */
  0x0000, /* U+5aec */
  0x0000, /* U+5aed */
  0x0000, /* U+5aee */
  0x0000, /* U+5aef */
  0x0000, /* U+5af0 */
  0x0000, /* U+5af1 */
  0x0000, /* U+5af2 */
  0x0000, /* U+5af3 */
  0x0000, /* U+5af4 */
  0x0000, /* U+5af5 */
  0x0000, /* U+5af6 */
  0x0000, /* U+5af7 */
  0x0000, /* U+5af8 */
  0x0000, /* U+5af9 */
  0x9b65, /* U+5afa */
  0x9b66, /* U+5afb */
  0x0000, /* U+5afc */
  0x0000, /* U+5afd */
  0x0000, /* U+5afe */
  0x0000, /* U+5aff */
  0x0000, /* U+5b00 */
  0x0000, /* U+5b01 */
  0x0000, /* U+5b02 */
  0x0000, /* U+5b03 */
  0x0000, /* U+5b04 */
  0x0000, /* U+5b05 */
  0x0000, /* U+5b06 */
  0x0000, /* U+5b07 */
  0x0000, /* U+5b08 */
  0x8af0, /* U+5b09 */
  0x0000, /* U+5b0a */
  0x9b68, /* U+5b0b */
  0x9b67, /* U+5b0c */
  0x0000, /* U+5b0d */
  0x0000, /* U+5b0e */
  0x0000, /* U+5b0f */
  0x0000, /* U+5b10 */
  0x0000, /* U+5b11 */
  0x0000, /* U+5b12 */
  0x0000, /* U+5b13 */
  0x0000, /* U+5b14 */
  0x0000, /* U+5b15 */
  0x9b69, /* U+5b16 */
  0x0000, /* U+5b17 */
  0x0000, /* U+5b18 */
  0x0000, /* U+5b19 */
  0x0000, /* U+5b1a */
  0x0000, /* U+5b1b */
  0x0000, /* U+5b1c */
  0x0000, /* U+5b1d */
  0x0000, /* U+5b1e */
  0x0000, /* U+5b1f */
  0x0000, /* U+5b20 */
  0x0000, /* U+5b21 */
  0x8fec, /* U+5b22 */
  0x0000, /* U+5b23 */
  0x0000, /* U+5b24 */
  0x0000, /* U+5b25 */
  0x0000, /* U+5b26 */
  0x0000, /* U+5b27 */
  0x0000, /* U+5b28 */
  0x0000, /* U+5b29 */
  0x9b6c, /* U+5b2a */
  0x0000, /* U+5b2b */
  0x92da, /* U+5b2c */
  0x0000, /* U+5b2d */
  0x0000, /* U+5b2e */
  0x0000, /* U+5b2f */
  0x8964, /* U+5b30 */
  0x0000, /* U+5b31 */
  0x9b6a, /* U+5b32 */
  0x0000, /* U+5b33 */
  0x0000, /* U+5b34 */
  0x0000, /* U+5b35 */
  0x9b6d, /* U+5b36 */
  0x0000, /* U+5b37 */
  0x0000, /* U+5b38 */
  0x0000, /* U+5b39 */
  0x0000, /* U+5b3a */
  0x0000, /* U+5b3b */
  0x0000, /* U+5b3c */
  0x0000, /* U+5b3d */
  0x9b6e, /* U+5b3e */
  0x0000, /* U+5b3f */
  0x9b71, /* U+5b40 */
  0x0000, /* U+5b41 */
  0x0000, /* U+5b42 */
  0x9b6f, /* U+5b43 */
  0x0000, /* U+5b44 */
  0x9b70, /* U+5b45 */
  0x0000, /* U+5b46 */
  0x0000, /* U+5b47 */
  0x0000, /* U+5b48 */
  0x0000, /* U+5b49 */
  0x0000, /* U+5b4a */
  0x0000, /* U+5b4b */
  0x0000, /* U+5b4c */
  0x0000, /* U+5b4d */
  0x0000, /* U+5b4e */
  0x0000, /* U+5b4f */
  0x8e71, /* U+5b50 */
  0x9b72, /* U+5b51 */
  0x0000, /* U+5b52 */
  0x0000, /* U+5b53 */
  0x8d45, /* U+5b54 */
  0x9b73, /* U+5b55 */
  0xfaa6, /* U+5b56 */
  0x8e9a, /* U+5b57 */
  0x91b6, /* U+5b58 */
  0x0000, /* U+5b59 */
  0x9b74, /* U+5b5a */
  0x9b75, /* U+5b5b */
  0x8e79, /* U+5b5c */
  0x8d46, /* U+5b5d */
  0x0000, /* U+5b5e */
  0x96d0, /* U+5b5f */
  0x0000, /* U+5b60 */
  0x0000, /* U+5b61 */
  0x0000, /* U+5b62 */
  0x8b47, /* U+5b63 */
  0x8cc7, /* U+5b64 */
  0x9b76, /* U+5b65 */
  0x8a77, /* U+5b66 */
  0x0000, /* U+5b67 */
  0x0000, /* U+5b68 */
  0x9b77, /* U+5b69 */
  0x0000, /* U+5b6a */
  0x91b7, /* U+5b6b */
  0x0000, /* U+5b6c */
  0x0000, /* U+5b6d */
  0x0000, /* U+5b6e */
  0x0000, /* U+5b6f */
  0x9b78, /* U+5b70 */
  0x9ba1, /* U+5b71 */
  0x0000, /* U+5b72 */
  0x9b79, /* U+5b73 */
  0x0000, /* U+5b74 */
  0x9b7a, /* U+5b75 */
  0x0000, /* U+5b76 */
  0x0000, /* U+5b77 */
  0x9b7b, /* U+5b78 */
  0x0000, /* U+5b79 */
  0x9b7d, /* U+5b7a */
  0x0000, /* U+5b7b */
  0x0000, /* U+5b7c */
  0x0000, /* U+5b7d */
  0x0000, /* U+5b7e */
  0x0000, /* U+5b7f */
  0x9b7e, /* U+5b80 */
  0x0000, /* U+5b81 */
  0x0000, /* U+5b82 */
  0x9b80, /* U+5b83 */
  0x0000, /* U+5b84 */
  0x91ee, /* U+5b85 */
  0x0000, /* U+5b86 */
  0x8946, /* U+5b87 */
  0x8ee7, /* U+5b88 */
  0x88c0, /* U+5b89 */
  0x0000, /* U+5b8a */
  0x9176, /* U+5b8b */
  0x8aae, /* U+5b8c */
  0x8eb3, /* U+5b8d */
  0x0000, /* U+5b8e */
  0x8d47, /* U+5b8f */
  0x0000, /* U+5b90 */
  0x0000, /* U+5b91 */
  0x0000, /* U+5b92 */
  0x0000, /* U+5b93 */
  0x0000, /* U+5b94 */
  0x9386, /* U+5b95 */
  0x0000, /* U+5b96 */
  0x8f40, /* U+5b97 */
  0x8aaf, /* U+5b98 */
  0x9288, /* U+5b99 */
  0x92e8, /* U+5b9a */
  0x88b6, /* U+5b9b */
  0x8b58, /* U+5b9c */
  0x95f3, /* U+5b9d */
  0x0000, /* U+5b9e */
  0x8ec0, /* U+5b9f */
  0x0000, /* U+5ba0 */
  0x0000, /* U+5ba1 */
  0x8b71, /* U+5ba2 */
  0x90e9, /* U+5ba3 */
  0x8eba, /* U+5ba4 */
  0x9747, /* U+5ba5 */
  0x9b81, /* U+5ba6 */
  0x0000, /* U+5ba7 */
  0x0000, /* U+5ba8 */
  0x0000, /* U+5ba9 */
  0x0000, /* U+5baa */
  0x0000, /* U+5bab */
  0x0000, /* U+5bac */
  0x0000, /* U+5bad */
  0x8b7b, /* U+5bae */
  0x0000, /* U+5baf */
  0x8dc9, /* U+5bb0 */
  0x0000, /* U+5bb1 */
  0x0000, /* U+5bb2 */
  0x8a51, /* U+5bb3 */
  0x8983, /* U+5bb4 */
  0x8faa, /* U+5bb5 */
  0x89c6, /* U+5bb6 */
  0x0000, /* U+5bb7 */
  0x9b82, /* U+5bb8 */
  0x9765, /* U+5bb9 */
  0x0000, /* U+5bba */
  0x0000, /* U+5bbb */
  0x0000, /* U+5bbc */
  0x0000, /* U+5bbd */
  0x0000, /* U+5bbe */
  0x8f68, /* U+5bbf */
  0xfaa7, /* U+5bc0 */
  0x0000, /* U+5bc1 */
  0x8ee2, /* U+5bc2 */
  0x9b83, /* U+5bc3 */
  0x8af1, /* U+5bc4 */
  0x93d0, /* U+5bc5 */
  0x96a7, /* U+5bc6 */
  0x9b84, /* U+5bc7 */
  0x0000, /* U+5bc8 */
  0x9b85, /* U+5bc9 */
  0x0000, /* U+5bca */
  0x0000, /* U+5bcb */
  0x9578, /* U+5bcc */
  0x0000, /* U+5bcd */
  0x0000, /* U+5bce */
  0x0000, /* U+5bcf */
  0x9b87, /* U+5bd0 */
  0x0000, /* U+5bd1 */
  0x8aa6, /* U+5bd2 */
  0x8bf5, /* U+5bd3 */
  0x9b86, /* U+5bd4 */
  0x0000, /* U+5bd5 */
  0x0000, /* U+5bd6 */
  0x0000, /* U+5bd7 */
  0xfaa9, /* U+5bd8 */
  0x0000, /* U+5bd9 */
  0x0000, /* U+5bda */
  0x8ab0, /* U+5bdb */
  0x0000, /* U+5bdc */
  0x9051, /* U+5bdd */
  0x9b8b, /* U+5bde */
  0x8e40, /* U+5bdf */
  0x0000, /* U+5be0 */
  0x89c7, /* U+5be1 */
  0x9b8a, /* U+5be2 */
  0x0000, /* U+5be3 */
  0x9b88, /* U+5be4 */
  0x9b8c, /* U+5be5 */
  0x9b89, /* U+5be6 */
  0x944a, /* U+5be7 */
  0x9ecb, /* U+5be8 */
  0x9052, /* U+5be9 */
  0x0000, /* U+5bea */
  0x9b8d, /* U+5beb */
  0xfaaa, /* U+5bec */
  0x0000, /* U+5bed */
  0x97be, /* U+5bee */
  0x0000, /* U+5bef */
  0x9b8e, /* U+5bf0 */
  0x0000, /* U+5bf1 */
  0x0000, /* U+5bf2 */
  0x9b90, /* U+5bf3 */
  0x0000, /* U+5bf4 */
  0x929e, /* U+5bf5 */
  0x9b8f, /* U+5bf6 */
  0x0000, /* U+5bf7 */
  0x90a1, /* U+5bf8 */
  0x0000, /* U+5bf9 */
  0x8e9b, /* U+5bfa */
  0x0000, /* U+5bfb */
  0x0000, /* U+5bfc */
  0x0000, /* U+5bfd */
  0x91ce, /* U+5bfe */
  0x8ef5, /* U+5bff */
  0x0000, /* U+5c00 */
  0x9595, /* U+5c01 */
  0x90ea, /* U+5c02 */
  0x0000, /* U+5c03 */
  0x8ecb, /* U+5c04 */
  0x9b91, /* U+5c05 */
  0x8fab, /* U+5c06 */
  0x9b92, /* U+5c07 */
  0x9b93, /* U+5c08 */
  0x88d1, /* U+5c09 */
  0x91b8, /* U+5c0a */
  0x9071, /* U+5c0b */
  0x0000, /* U+5c0c */
  0x9b94, /* U+5c0d */
  0x93b1, /* U+5c0e */
  0x8fac, /* U+5c0f */
  0x0000, /* U+5c10 */
  0x8fad, /* U+5c11 */
  0x0000, /* U+5c12 */
  0x9b95, /* U+5c13 */
  0x0000, /* U+5c14 */
  0x0000, /* U+5c15 */
  0x90eb, /* U+5c16 */
  0x0000, /* U+5c17 */
  0x0000, /* U+5c18 */
  0x0000, /* U+5c19 */
  0x8fae, /* U+5c1a */
  0x0000, /* U+5c1b */
  0x0000, /* U+5c1c */
  0x0000, /* U+5c1d */
  0xfaab, /* U+5c1e */
  0x0000, /* U+5c1f */
  0x9b96, /* U+5c20 */
  0x0000, /* U+5c21 */
  0x9b97, /* U+5c22 */
  0x0000, /* U+5c23 */
  0x96de, /* U+5c24 */
  0x0000, /* U+5c25 */
  0x0000, /* U+5c26 */
  0x0000, /* U+5c27 */
  0x9b98, /* U+5c28 */
  0x0000, /* U+5c29 */
  0x0000, /* U+5c2a */
  0x0000, /* U+5c2b */
  0x0000, /* U+5c2c */
  0x8bc4, /* U+5c2d */
  0x0000, /* U+5c2e */
  0x0000, /* U+5c2f */
  0x0000, /* U+5c30 */
  0x8f41, /* U+5c31 */
  0x0000, /* U+5c32 */
  0x0000, /* U+5c33 */
  0x0000, /* U+5c34 */
  0x0000, /* U+5c35 */
  0x0000, /* U+5c36 */
  0x0000, /* U+5c37 */
  0x9b99, /* U+5c38 */
  0x9b9a, /* U+5c39 */
  0x8eda, /* U+5c3a */
  0x904b, /* U+5c3b */
  0x93f2, /* U+5c3c */
  0x9073, /* U+5c3d */
  0x94f6, /* U+5c3e */
  0x9441, /* U+5c3f */
  0x8bc7, /* U+5c40 */
  0x9b9b, /* U+5c41 */
  0x0000, /* U+5c42 */
  0x0000, /* U+5c43 */
  0x0000, /* U+5c44 */
  0x8b8f, /* U+5c45 */
  0x9b9c, /* U+5c46 */
  0x0000, /* U+5c47 */
  0x8bfc, /* U+5c48 */
  0x0000, /* U+5c49 */
  0x93cd, /* U+5c4a */
  0x89ae, /* U+5c4b */
  0x0000, /* U+5c4c */
  0x8e72, /* U+5c4d */
  0x9b9d, /* U+5c4e */
  0x9ba0, /* U+5c4f */
  0x9b9f, /* U+5c50 */
  0x8bfb, /* U+5c51 */
  0x0000, /* U+5c52 */
  0x9b9e, /* U+5c53 */
  0x0000, /* U+5c54 */
  0x9357, /* U+5c55 */
  0x0000, /* U+5c56 */
  0x0000, /* U+5c57 */
  0x0000, /* U+5c58 */
  0x0000, /* U+5c59 */
  0x0000, /* U+5c5a */
  0x0000, /* U+5c5b */
  0x0000, /* U+5c5c */
  0x0000, /* U+5c5d */
  0x91ae, /* U+5c5e */
  0x0000, /* U+5c5f */
  0x936a, /* U+5c60 */
  0x8ec6, /* U+5c61 */
  0x0000, /* U+5c62 */
  0x0000, /* U+5c63 */
  0x9177, /* U+5c64 */
  0x979a, /* U+5c65 */
  0x0000, /* U+5c66 */
  0x0000, /* U+5c67 */
  0x0000, /* U+5c68 */
  0x0000, /* U+5c69 */
  0x0000, /* U+5c6a */
  0x0000, /* U+5c6b */
  0x9ba2, /* U+5c6c */
  0x0000, /* U+5c6d */
  0x9ba3, /* U+5c6e */
  0x93d4, /* U+5c6f */
  0x0000, /* U+5c70 */
  0x8e52, /* U+5c71 */
  0x0000, /* U+5c72 */
  0x0000, /* U+5c73 */
  0x0000, /* U+5c74 */
  0x0000, /* U+5c75 */
  0x9ba5, /* U+5c76 */
  0x0000, /* U+5c77 */
  0x0000, /* U+5c78 */
  0x9ba6, /* U+5c79 */
  0x0000, /* U+5c7a */
  0x0000, /* U+5c7b */
  0x0000, /* U+5c7c */
  0x0000, /* U+5c7d */
  0x0000, /* U+5c7e */
  0x0000, /* U+5c7f */
  0x0000, /* U+5c80 */
  0x0000, /* U+5c81 */
  0x0000, /* U+5c82 */
  0x0000, /* U+5c83 */
  0x0000, /* U+5c84 */
  0x0000, /* U+5c85 */
  0x0000, /* U+5c86 */
  0x0000, /* U+5c87 */
  0x0000, /* U+5c88 */
  0x0000, /* U+5c89 */
  0x0000, /* U+5c8a */
  0x0000, /* U+5c8b */
  0x9ba7, /* U+5c8c */
  0x0000, /* U+5c8d */
  0x0000, /* U+5c8e */
  0x0000, /* U+5c8f */
  0x8af2, /* U+5c90 */
  0x9ba8, /* U+5c91 */
  0x0000, /* U+5c92 */
  0x0000, /* U+5c93 */
  0x9ba9, /* U+5c94 */
  0x0000, /* U+5c95 */
  0x0000, /* U+5c96 */
  0x0000, /* U+5c97 */
  0x0000, /* U+5c98 */
  0x0000, /* U+5c99 */
  0x0000, /* U+5c9a */
  0x0000, /* U+5c9b */
  0x0000, /* U+5c9c */
  0x0000, /* U+5c9d */
  0x0000, /* U+5c9e */
  0x0000, /* U+5c9f */
  0x0000, /* U+5ca0 */
  0x89aa, /* U+5ca1 */
  0x0000, /* U+5ca2 */
  0x0000, /* U+5ca3 */
  0x0000, /* U+5ca4 */
  0x0000, /* U+5ca5 */
  0xfaac, /* U+5ca6 */
  0x0000, /* U+5ca7 */
  0x915a, /* U+5ca8 */
  0x8ae2, /* U+5ca9 */
  0x0000, /* U+5caa */
  0x9bab, /* U+5cab */
  0x96a6, /* U+5cac */
  0x0000, /* U+5cad */
  0x0000, /* U+5cae */
  0x0000, /* U+5caf */
  0x0000, /* U+5cb0 */
  0x91d0, /* U+5cb1 */
  0x0000, /* U+5cb2 */
  0x8a78, /* U+5cb3 */
  0x0000, /* U+5cb4 */
  0x0000, /* U+5cb5 */
  0x9bad, /* U+5cb6 */
  0x9baf, /* U+5cb7 */
  0x8add, /* U+5cb8 */
  0x0000, /* U+5cb9 */
  0xfaad, /* U+5cba */
  0x9bac, /* U+5cbb */
  0x9bae, /* U+5cbc */
  0x0000, /* U+5cbd */
  0x9bb1, /* U+5cbe */
  0x0000, /* U+5cbf */
  0x0000, /* U+5cc0 */
  0x0000, /* U+5cc1 */
  0x0000, /* U+5cc2 */
  0x0000, /* U+5cc3 */
  0x0000, /* U+5cc4 */
  0x9bb0, /* U+5cc5 */
  0x0000, /* U+5cc6 */
  0x9bb2, /* U+5cc7 */
  0x0000, /* U+5cc8 */
  0x0000, /* U+5cc9 */
  0x0000, /* U+5cca */
  0x0000, /* U+5ccb */
  0x0000, /* U+5ccc */
  0x0000, /* U+5ccd */
  0x0000, /* U+5cce */
  0x0000, /* U+5ccf */
  0x0000, /* U+5cd0 */
  0x0000, /* U+5cd1 */
  0x0000, /* U+5cd2 */
  0x0000, /* U+5cd3 */
  0x0000, /* U+5cd4 */
  0x0000, /* U+5cd5 */
  0x0000, /* U+5cd6 */
  0x0000, /* U+5cd7 */
  0x0000, /* U+5cd8 */
  0x9bb3, /* U+5cd9 */
  0x0000, /* U+5cda */
  0x0000, /* U+5cdb */
  0x0000, /* U+5cdc */
  0x0000, /* U+5cdd */
  0x0000, /* U+5cde */
  0x0000, /* U+5cdf */
  0x93bb, /* U+5ce0 */
  0x8bac, /* U+5ce1 */
  0x0000, /* U+5ce2 */
  0x0000, /* U+5ce3 */
  0x0000, /* U+5ce4 */
  0x0000, /* U+5ce5 */
  0x0000, /* U+5ce6 */
  0x0000, /* U+5ce7 */
  0x89e3, /* U+5ce8 */
  0x9bb4, /* U+5ce9 */
  0x9bb9, /* U+5cea */
  0x0000, /* U+5ceb */
  0x0000, /* U+5cec */
  0x9bb7, /* U+5ced */
  0x0000, /* U+5cee */
  0x95f5, /* U+5cef */
  0x95f4, /* U+5cf0 */
  0x0000, /* U+5cf1 */
  0x0000, /* U+5cf2 */
  0x0000, /* U+5cf3 */
  0x0000, /* U+5cf4 */
  0xfaae, /* U+5cf5 */
  0x9387, /* U+5cf6 */
  0x0000, /* U+5cf7 */
  0x0000, /* U+5cf8 */
  0x0000, /* U+5cf9 */
  0x9bb6, /* U+5cfa */
  0x8f73, /* U+5cfb */
  0x0000, /* U+5cfc */
  0x9bb5, /* U+5cfd */
  0x0000, /* U+5cfe */
  0x0000, /* U+5cff */
  0x0000, /* U+5d00 */
  0x0000, /* U+5d01 */
  0x0000, /* U+5d02 */
  0x0000, /* U+5d03 */
  0x0000, /* U+5d04 */
  0x0000, /* U+5d05 */
  0x0000, /* U+5d06 */
  0x9092, /* U+5d07 */
  0x0000, /* U+5d08 */
  0x0000, /* U+5d09 */
  0x0000, /* U+5d0a */
  0x9bba, /* U+5d0b */
  0x0000, /* U+5d0c */
  0x0000, /* U+5d0d */
  0x8de8, /* U+5d0e */
  0x0000, /* U+5d0f */
  0x0000, /* U+5d10 */
  0x9bc0, /* U+5d11 */
  0x0000, /* U+5d12 */
  0x0000, /* U+5d13 */
  0x9bc1, /* U+5d14 */
  0x9bbb, /* U+5d15 */
  0x8a52, /* U+5d16 */
  0x9bbc, /* U+5d17 */
  0x9bc5, /* U+5d18 */
  0x9bc4, /* U+5d19 */
  0x9bc3, /* U+5d1a */
  0x9bbf, /* U+5d1b */
  0x0000, /* U+5d1c */
  0x0000, /* U+5d1d */
  0x0000, /* U+5d1e */
  0x9bbe, /* U+5d1f */
  0x0000, /* U+5d20 */
  0x0000, /* U+5d21 */
  0x9bc2, /* U+5d22 */
  0x0000, /* U+5d23 */
  0x0000, /* U+5d24 */
  0x0000, /* U+5d25 */
  0x0000, /* U+5d26 */
  0xfaaf, /* U+5d27 */
  0x0000, /* U+5d28 */
  0x95f6, /* U+5d29 */
  0x0000, /* U+5d2a */
  0x0000, /* U+5d2b */
  0x0000, /* U+5d2c */
  0x0000, /* U+5d2d */
  0x0000, /* U+5d2e */
  0x0000, /* U+5d2f */
  0x0000, /* U+5d30 */
  0x0000, /* U+5d31 */
  0x0000, /* U+5d32 */
  0x0000, /* U+5d33 */
  0x0000, /* U+5d34 */
  0x0000, /* U+5d35 */
  0x0000, /* U+5d36 */
  0x0000, /* U+5d37 */
  0x0000, /* U+5d38 */
  0x0000, /* U+5d39 */
  0x0000, /* U+5d3a */
  0x0000, /* U+5d3b */
  0x0000, /* U+5d3c */
  0x0000, /* U+5d3d */
  0x0000, /* U+5d3e */
  0x0000, /* U+5d3f */
  0x0000, /* U+5d40 */
  0x0000, /* U+5d41 */
  0xfab2, /* U+5d42 */
  0x0000, /* U+5d43 */
  0x0000, /* U+5d44 */
  0x0000, /* U+5d45 */
  0x0000, /* U+5d46 */
  0x0000, /* U+5d47 */
  0x0000, /* U+5d48 */
  0x0000, /* U+5d49 */
  0x0000, /* U+5d4a */
  0x9bc9, /* U+5d4b */
  0x9bc6, /* U+5d4c */
  0x0000, /* U+5d4d */
  0x9bc8, /* U+5d4e */
  0x0000, /* U+5d4f */
  0x9792, /* U+5d50 */
  0x0000, /* U+5d51 */
  0x9bc7, /* U+5d52 */
  0xfab0, /* U+5d53 */
  0x0000, /* U+5d54 */
  0x0000, /* U+5d55 */
  0x0000, /* U+5d56 */
  0x0000, /* U+5d57 */
  0x0000, /* U+5d58 */
  0x0000, /* U+5d59 */
  0x0000, /* U+5d5a */
  0x0000, /* U+5d5b */
  0x9bbd, /* U+5d5c */
  0x0000, /* U+5d5d */
  0x0000, /* U+5d5e */
  0x0000, /* U+5d5f */
  0x0000, /* U+5d60 */
  0x0000, /* U+5d61 */
  0x0000, /* U+5d62 */
  0x0000, /* U+5d63 */
  0x0000, /* U+5d64 */
  0x0000, /* U+5d65 */
  0x0000, /* U+5d66 */
  0x0000, /* U+5d67 */
  0x0000, /* U+5d68 */
  0x9093, /* U+5d69 */
  0x0000, /* U+5d6a */
  0x0000, /* U+5d6b */
  0x9bca, /* U+5d6c */
  0xfab3, /* U+5d6d */
  0x0000, /* U+5d6e */
  0x8db5, /* U+5d6f */
  0x0000, /* U+5d70 */
  0x0000, /* U+5d71 */
  0x0000, /* U+5d72 */
  0x9bcb, /* U+5d73 */
  0x0000, /* U+5d74 */
  0x0000, /* U+5d75 */
  0x9bcc, /* U+5d76 */
  0x0000, /* U+5d77 */
  0x0000, /* U+5d78 */
  0x0000, /* U+5d79 */
  0x0000, /* U+5d7a */
  0x0000, /* U+5d7b */
  0x0000, /* U+5d7c */
  0x0000, /* U+5d7d */
  0x0000, /* U+5d7e */
  0x0000, /* U+5d7f */
  0x0000, /* U+5d80 */
  0x0000, /* U+5d81 */
  0x9bcf, /* U+5d82 */
  0x0000, /* U+5d83 */
  0x9bce, /* U+5d84 */
  0x0000, /* U+5d85 */
  0x0000, /* U+5d86 */
  0x9bcd, /* U+5d87 */
  0x0000, /* U+5d88 */
  0x0000, /* U+5d89 */
  0x0000, /* U+5d8a */
  0x9388, /* U+5d8b */
  0x9bb8, /* U+5d8c */
  0x0000, /* U+5d8d */
  0x0000, /* U+5d8e */
  0x0000, /* U+5d8f */
  0x9bd5, /* U+5d90 */
  0x0000, /* U+5d91 */
  0x0000, /* U+5d92 */
  0x0000, /* U+5d93 */
  0x0000, /* U+5d94 */
  0x0000, /* U+5d95 */
  0x0000, /* U+5d96 */
  0x0000, /* U+5d97 */
  0x0000, /* U+5d98 */
  0x0000, /* U+5d99 */
  0x0000, /* U+5d9a */
  0x0000, /* U+5d9b */
  0x0000, /* U+5d9c */
  0x9bd1, /* U+5d9d */
  0x0000, /* U+5d9e */
  0x0000, /* U+5d9f */
  0x0000, /* U+5da0 */
  0x0000, /* U+5da1 */
  0x9bd0, /* U+5da2 */
  0x0000, /* U+5da3 */
  0x0000, /* U+5da4 */
  0x0000, /* U+5da5 */
  0x0000, /* U+5da6 */
  0x0000, /* U+5da7 */
  0x0000, /* U+5da8 */
  0x0000, /* U+5da9 */
  0x0000, /* U+5daa */
  0x0000, /* U+5dab */
  0x9bd2, /* U+5dac */
  0x0000, /* U+5dad */
  0x9bd3, /* U+5dae */
  0x0000, /* U+5daf */
  0x0000, /* U+5db0 */
  0x0000, /* U+5db1 */
  0x0000, /* U+5db2 */
  0x0000, /* U+5db3 */
  0x0000, /* U+5db4 */
  0x0000, /* U+5db5 */
  0x0000, /* U+5db6 */
  0x9bd6, /* U+5db7 */
  0xfab4, /* U+5db8 */
  0xfab5, /* U+5db9 */
  0x97e4, /* U+5dba */
  0x0000, /* U+5dbb */
  0x9bd7, /* U+5dbc */
  0x9bd4, /* U+5dbd */
  0x0000, /* U+5dbe */
  0x0000, /* U+5dbf */
  0x0000, /* U+5dc0 */
  0x0000, /* U+5dc1 */
  0x0000, /* U+5dc2 */
  0x0000, /* U+5dc3 */
  0x0000, /* U+5dc4 */
  0x0000, /* U+5dc5 */
  0x0000, /* U+5dc6 */
  0x0000, /* U+5dc7 */
  0x0000, /* U+5dc8 */
  0x9bd8, /* U+5dc9 */
  0x0000, /* U+5dca */
  0x0000, /* U+5dcb */
  0x8ade, /* U+5dcc */
  0x9bd9, /* U+5dcd */
  0x0000, /* U+5dce */
  0x0000, /* U+5dcf */
  0xfab6, /* U+5dd0 */
  0x0000, /* U+5dd1 */
  0x9bdb, /* U+5dd2 */
  0x9bda, /* U+5dd3 */
  0x0000, /* U+5dd4 */
  0x0000, /* U+5dd5 */
  0x9bdc, /* U+5dd6 */
  0x0000, /* U+5dd7 */
  0x0000, /* U+5dd8 */
  0x0000, /* U+5dd9 */
  0x0000, /* U+5dda */
  0x9bdd, /* U+5ddb */
  0x0000, /* U+5ddc */
  0x90ec, /* U+5ddd */
  0x8f42, /* U+5dde */
  0x0000, /* U+5ddf */
  0x0000, /* U+5de0 */
  0x8f84, /* U+5de1 */
  0x0000, /* U+5de2 */
  0x9183, /* U+5de3 */
  0x0000, /* U+5de4 */
  0x8d48, /* U+5de5 */
  0x8db6, /* U+5de6 */
  0x8d49, /* U+5de7 */
  0x8b90, /* U+5de8 */
  0x0000, /* U+5de9 */
  0x0000, /* U+5dea */
  0x9bde, /* U+5deb */
  0x0000, /* U+5dec */
  0x0000, /* U+5ded */
  0x8db7, /* U+5dee */
  0x0000, /* U+5def */
  0x0000, /* U+5df0 */
  0x8cc8, /* U+5df1 */
  0x9bdf, /* U+5df2 */
  0x96a4, /* U+5df3 */
  0x9462, /* U+5df4 */
  0x9be0, /* U+5df5 */
  0x0000, /* U+5df6 */
  0x8d4a, /* U+5df7 */
  0x0000, /* U+5df8 */
  0x0000, /* U+5df9 */
  0x0000, /* U+5dfa */
  0x8aaa, /* U+5dfb */
  0x0000, /* U+5dfc */
  0x9246, /* U+5dfd */
  0x8bd0, /* U+5dfe */
  0x0000, /* U+5dff */
  0x0000, /* U+5e00 */
  0x0000, /* U+5e01 */
  0x8e73, /* U+5e02 */
  0x957a, /* U+5e03 */
  0x0000, /* U+5e04 */
  0x0000, /* U+5e05 */
  0x94bf, /* U+5e06 */
  0x0000, /* U+5e07 */
  0x0000, /* U+5e08 */
  0x0000, /* U+5e09 */
  0x0000, /* U+5e0a */
  0x9be1, /* U+5e0b */
  0x8af3, /* U+5e0c */
  0x0000, /* U+5e0d */
  0x0000, /* U+5e0e */
  0x0000, /* U+5e0f */
  0x0000, /* U+5e10 */
  0x9be4, /* U+5e11 */
  0x0000, /* U+5e12 */
  0x0000, /* U+5e13 */
  0x0000, /* U+5e14 */
  0x0000, /* U+5e15 */
  0x929f, /* U+5e16 */
  0x0000, /* U+5e17 */
  0x0000, /* U+5e18 */
  0x9be3, /* U+5e19 */
  0x9be2, /* U+5e1a */
  0x9be5, /* U+5e1b */
  0x0000, /* U+5e1c */
  0x92e9, /* U+5e1d */
  0x0000, /* U+5e1e */
  0x0000, /* U+5e1f */
  0x0000, /* U+5e20 */
  0x0000, /* U+5e21 */
  0x0000, /* U+5e22 */
  0x0000, /* U+5e23 */
  0x0000, /* U+5e24 */
  0x9083, /* U+5e25 */
  0x0000, /* U+5e26 */
  0x0000, /* U+5e27 */
  0x0000, /* U+5e28 */
  0x0000, /* U+5e29 */
  0x0000, /* U+5e2a */
  0x8e74, /* U+5e2b */
  0x0000, /* U+5e2c */
  0x90c8, /* U+5e2d */
  0x0000, /* U+5e2e */
  0x91d1, /* U+5e2f */
  0x8b41, /* U+5e30 */
  0x0000, /* U+5e31 */
  0x0000, /* U+5e32 */
  0x92a0, /* U+5e33 */
  0x0000, /* U+5e34 */
  0x0000, /* U+5e35 */
  0x9be6, /* U+5e36 */
  0x9be7, /* U+5e37 */
  0x8fed, /* U+5e38 */
  0x0000, /* U+5e39 */
  0x0000, /* U+5e3a */
  0x0000, /* U+5e3b */
  0x0000, /* U+5e3c */
  0x9658, /* U+5e3d */
  0x0000, /* U+5e3e */
  0x0000, /* U+5e3f */
  0x9bea, /* U+5e40 */
  0x0000, /* U+5e41 */
  0x0000, /* U+5e42 */
  0x9be9, /* U+5e43 */
  0x9be8, /* U+5e44 */
  0x959d, /* U+5e45 */
  0x0000, /* U+5e46 */
  0x9bf1, /* U+5e47 */
  0x0000, /* U+5e48 */
  0x0000, /* U+5e49 */
  0x0000, /* U+5e4a */
  0x0000, /* U+5e4b */
  0x9679, /* U+5e4c */
  0x0000, /* U+5e4d */
  0x9beb, /* U+5e4e */
  0x0000, /* U+5e4f */
  0x0000, /* U+5e50 */
  0x0000, /* U+5e51 */
  0x0000, /* U+5e52 */
  0x0000, /* U+5e53 */
  0x9bed, /* U+5e54 */
  0x968b, /* U+5e55 */
  0x0000, /* U+5e56 */
  0x9bec, /* U+5e57 */
  0x0000, /* U+5e58 */
  0x0000, /* U+5e59 */
  0x0000, /* U+5e5a */
  0x0000, /* U+5e5b */
  0x0000, /* U+5e5c */
  0x0000, /* U+5e5d */
  0x0000, /* U+5e5e */
  0x9bee, /* U+5e5f */
  0x0000, /* U+5e60 */
  0x94a6, /* U+5e61 */
  0x9bef, /* U+5e62 */
  0x95bc, /* U+5e63 */
  0x9bf0, /* U+5e64 */
  0x0000, /* U+5e65 */
  0x0000, /* U+5e66 */
  0x0000, /* U+5e67 */
  0x0000, /* U+5e68 */
  0x0000, /* U+5e69 */
  0x0000, /* U+5e6a */
  0x0000, /* U+5e6b */
  0x0000, /* U+5e6c */
  0x0000, /* U+5e6d */
  0x0000, /* U+5e6e */
  0x0000, /* U+5e6f */
  0x0000, /* U+5e70 */
  0x0000, /* U+5e71 */
  0x8ab1, /* U+5e72 */
  0x95bd, /* U+5e73 */
  0x944e, /* U+5e74 */
  0x9bf2, /* U+5e75 */
  0x9bf3, /* U+5e76 */
  0x0000, /* U+5e77 */
  0x8d4b, /* U+5e78 */
  0x8ab2, /* U+5e79 */
  0x9bf4, /* U+5e7a */
  0x8cb6, /* U+5e7b */
  0x9763, /* U+5e7c */
  0x9748, /* U+5e7d */
  0x8af4, /* U+5e7e */
  0x9bf6, /* U+5e7f */
  0x0000, /* U+5e80 */
  0x92a1, /* U+5e81 */
  0x0000, /* U+5e82 */
  0x8d4c, /* U+5e83 */
  0x8faf, /* U+5e84 */
  0x0000, /* U+5e85 */
  0x0000, /* U+5e86 */
  0x94dd, /* U+5e87 */
  0x0000, /* U+5e88 */
  0x0000, /* U+5e89 */
  0x8fb0, /* U+5e8a */
  0x0000, /* U+5e8b */
  0x0000, /* U+5e8c */
  0x0000, /* U+5e8d */
  0x0000, /* U+5e8e */
  0x8f98, /* U+5e8f */
  0x0000, /* U+5e90 */
  0x0000, /* U+5e91 */
  0x0000, /* U+5e92 */
  0x0000, /* U+5e93 */
  0x0000, /* U+5e94 */
  0x92ea, /* U+5e95 */
  0x95f7, /* U+5e96 */
  0x9358, /* U+5e97 */
  0x0000, /* U+5e98 */
  0x0000, /* U+5e99 */
  0x8d4d, /* U+5e9a */
  0x0000, /* U+5e9b */
  0x957b, /* U+5e9c */
  0x0000, /* U+5e9d */
  0x0000, /* U+5e9e */
  0x0000, /* U+5e9f */
  0x9bf7, /* U+5ea0 */
  0x0000, /* U+5ea1 */
  0x0000, /* U+5ea2 */
  0x0000, /* U+5ea3 */
  0x0000, /* U+5ea4 */
  0x0000, /* U+5ea5 */
  0x9378, /* U+5ea6 */
  0x8dc0, /* U+5ea7 */
  0x0000, /* U+5ea8 */
  0x0000, /* U+5ea9 */
  0x0000, /* U+5eaa */
  0x8cc9, /* U+5eab */
  0x0000, /* U+5eac */
  0x92eb, /* U+5ead */
  0x0000, /* U+5eae */
  0x0000, /* U+5eaf */
  0x0000, /* U+5eb0 */
  0x0000, /* U+5eb1 */
  0x0000, /* U+5eb2 */
  0x0000, /* U+5eb3 */
  0x0000, /* U+5eb4 */
  0x88c1, /* U+5eb5 */
  0x8f8e, /* U+5eb6 */
  0x8d4e, /* U+5eb7 */
  0x9766, /* U+5eb8 */
  0x0000, /* U+5eb9 */
  0x0000, /* U+5eba */
  0x0000, /* U+5ebb */
  0x0000, /* U+5ebc */
  0x0000, /* U+5ebd */
  0x0000, /* U+5ebe */
  0x0000, /* U+5ebf */
  0x0000, /* U+5ec0 */
  0x9bf8, /* U+5ec1 */
  0x9bf9, /* U+5ec2 */
  0x9470, /* U+5ec3 */
  0x0000, /* U+5ec4 */
  0x0000, /* U+5ec5 */
  0x0000, /* U+5ec6 */
  0x0000, /* U+5ec7 */
  0x9bfa, /* U+5ec8 */
  0x97f5, /* U+5ec9 */
  0x984c, /* U+5eca */
  0x0000, /* U+5ecb */
  0x0000, /* U+5ecc */
  0x0000, /* U+5ecd */
  0x0000, /* U+5ece */
  0x9bfc, /* U+5ecf */
  0x9bfb, /* U+5ed0 */
  0x0000, /* U+5ed1 */
  0x0000, /* U+5ed2 */
  0x8a66, /* U+5ed3 */
  0x0000, /* U+5ed4 */
  0x0000, /* U+5ed5 */
  0x9c40, /* U+5ed6 */
  0x0000, /* U+5ed7 */
  0x0000, /* U+5ed8 */
  0x0000, /* U+5ed9 */
  0x9c43, /* U+5eda */
  0x9c44, /* U+5edb */
  0x0000, /* U+5edc */
  0x9c42, /* U+5edd */
  0x0000, /* U+5ede */
  0x955f, /* U+5edf */
  0x8fb1, /* U+5ee0 */
  0x9c46, /* U+5ee1 */
  0x9c45, /* U+5ee2 */
  0x9c41, /* U+5ee3 */
  0x0000, /* U+5ee4 */
  0x0000, /* U+5ee5 */
  0x0000, /* U+5ee6 */
  0x0000, /* U+5ee7 */
  0x9c47, /* U+5ee8 */
  0x9c48, /* U+5ee9 */
  0x0000, /* U+5eea */
  0x0000, /* U+5eeb */
  0x9c49, /* U+5eec */
  0x0000, /* U+5eed */
  0x0000, /* U+5eee */
  0x0000, /* U+5eef */
  0x9c4c, /* U+5ef0 */
  0x9c4a, /* U+5ef1 */
  0x0000, /* U+5ef2 */
  0x9c4b, /* U+5ef3 */
  0x9c4d, /* U+5ef4 */
  0x0000, /* U+5ef5 */
  0x8984, /* U+5ef6 */
  0x92ec, /* U+5ef7 */
  0x9c4e, /* U+5ef8 */
  0x0000, /* U+5ef9 */
  0x8c9a, /* U+5efa */
  0x89f4, /* U+5efb */
  0x9455, /* U+5efc */
  0x0000, /* U+5efd */
  0x9c4f, /* U+5efe */
  0x93f9, /* U+5eff */
  0x0000, /* U+5f00 */
  0x95d9, /* U+5f01 */
  0x0000, /* U+5f02 */
  0x9c50, /* U+5f03 */
  0x984d, /* U+5f04 */
  0x0000, /* U+5f05 */
  0x0000, /* U+5f06 */
  0x0000, /* U+5f07 */
  0x0000, /* U+5f08 */
  0x9c51, /* U+5f09 */
  0x95be, /* U+5f0a */
  0x9c54, /* U+5f0b */
  0x989f, /* U+5f0c */
  0x98af, /* U+5f0d */
  0x0000, /* U+5f0e */
  0x8eae, /* U+5f0f */
  0x93f3, /* U+5f10 */
  0x9c55, /* U+5f11 */
  0x0000, /* U+5f12 */
  0x8b7c, /* U+5f13 */
  0x92a2, /* U+5f14 */
  0x88f8, /* U+5f15 */
  0x9c56, /* U+5f16 */
  0x95a4, /* U+5f17 */
  0x8d4f, /* U+5f18 */
  0x0000, /* U+5f19 */
  0x0000, /* U+5f1a */
  0x926f, /* U+5f1b */
  0x0000, /* U+5f1c */
  0x0000, /* U+5f1d */
  0x0000, /* U+5f1e */
  0x92ed, /* U+5f1f */
  0x0000, /* U+5f20 */
  0xfab7, /* U+5f21 */
  0x0000, /* U+5f22 */
  0x0000, /* U+5f23 */
  0x0000, /* U+5f24 */
  0x96ed, /* U+5f25 */
  0x8cb7, /* U+5f26 */
  0x8cca, /* U+5f27 */
  0x0000, /* U+5f28 */
  0x9c57, /* U+5f29 */
  0x0000, /* U+5f2a */
  0x0000, /* U+5f2b */
  0x0000, /* U+5f2c */
  0x9c58, /* U+5f2d */
  0x0000, /* U+5f2e */
  0x9c5e, /* U+5f2f */
  0x0000, /* U+5f30 */
  0x8ee3, /* U+5f31 */
  0x0000, /* U+5f32 */
  0x0000, /* U+5f33 */
  0xfab8, /* U+5f34 */
  0x92a3, /* U+5f35 */
  0x0000, /* U+5f36 */
  0x8bad, /* U+5f37 */
  0x9c59, /* U+5f38 */
  0x0000, /* U+5f39 */
  0x0000, /* U+5f3a */
  0x0000, /* U+5f3b */
  0x954a, /* U+5f3c */
  0x0000, /* U+5f3d */
  0x9265, /* U+5f3e */
  0x0000, /* U+5f3f */
  0x0000, /* U+5f40 */
  0x9c5a, /* U+5f41 */
  0x0000, /* U+5f42 */
  0x0000, /* U+5f43 */
  0x0000, /* U+5f44 */
  0xfa67, /* U+5f45 */
  0x0000, /* U+5f46 */
  0x0000, /* U+5f47 */
  0x9c5b, /* U+5f48 */
  0x0000, /* U+5f49 */
  0x8bae, /* U+5f4a */
  0x0000, /* U+5f4b */
  0x9c5c, /* U+5f4c */
  0x0000, /* U+5f4d */
  0x9c5d, /* U+5f4e */
  0x0000, /* U+5f4f */
  0x0000, /* U+5f50 */
  0x9c5f, /* U+5f51 */
  0x0000, /* U+5f52 */
  0x9396, /* U+5f53 */
  0x0000, /* U+5f54 */
  0x0000, /* U+5f55 */
  0x9c60, /* U+5f56 */
  0x9c61, /* U+5f57 */
  0x0000, /* U+5f58 */
  0x9c62, /* U+5f59 */
  0x0000, /* U+5f5a */
  0x0000, /* U+5f5b */
  0x9c53, /* U+5f5c */
  0x9c52, /* U+5f5d */
  0x0000, /* U+5f5e */
  0x0000, /* U+5f5f */
  0x0000, /* U+5f60 */
  0x9c63, /* U+5f61 */
  0x8c60, /* U+5f62 */
  0x0000, /* U+5f63 */
  0x0000, /* U+5f64 */
  0x0000, /* U+5f65 */
  0x9546, /* U+5f66 */
  0xfab9, /* U+5f67 */
  0x0000, /* U+5f68 */
  0x8dca, /* U+5f69 */
  0x9556, /* U+5f6a */
  0x92a4, /* U+5f6b */
  0x956a, /* U+5f6c */
  0x9c64, /* U+5f6d */
  0x0000, /* U+5f6e */
  0x0000, /* U+5f6f */
  0x8fb2, /* U+5f70 */
  0x8965, /* U+5f71 */
  0x0000, /* U+5f72 */
  0x9c65, /* U+5f73 */
  0x0000, /* U+5f74 */
  0x0000, /* U+5f75 */
  0x0000, /* U+5f76 */
  0x9c66, /* U+5f77 */
  0x0000, /* U+5f78 */
  0x96f0, /* U+5f79 */
  0x0000, /* U+5f7a */
  0x0000, /* U+5f7b */
  0x94de, /* U+5f7c */
  0x0000, /* U+5f7d */
  0x0000, /* U+5f7e */
  0x9c69, /* U+5f7f */
  0x899d, /* U+5f80 */
  0x90aa, /* U+5f81 */
  0x9c68, /* U+5f82 */
  0x9c67, /* U+5f83 */
  0x8c61, /* U+5f84 */
  0x91d2, /* U+5f85 */
  0x0000, /* U+5f86 */
  0x9c6d, /* U+5f87 */
  0x9c6b, /* U+5f88 */
  0x0000, /* U+5f89 */
  0x9c6a, /* U+5f8a */
  0x97a5, /* U+5f8b */
  0x8ce3, /* U+5f8c */
  0x0000, /* U+5f8d */
  0x0000, /* U+5f8e */
  0x0000, /* U+5f8f */
  0x8f99, /* U+5f90 */
  0x9c6c, /* U+5f91 */
  0x936b, /* U+5f92 */
  0x8f5d, /* U+5f93 */
  0x0000, /* U+5f94 */
  0x0000, /* U+5f95 */
  0x0000, /* U+5f96 */
  0x93be, /* U+5f97 */
  0x9c70, /* U+5f98 */
  0x9c6f, /* U+5f99 */
  0x0000, /* U+5f9a */
  0x0000, /* U+5f9b */
  0x0000, /* U+5f9c */
  0x0000, /* U+5f9d */
  0x9c6e, /* U+5f9e */
  0x0000, /* U+5f9f */
  0x9c71, /* U+5fa0 */
  0x8ce4, /* U+5fa1 */
  0x0000, /* U+5fa2 */
  0x0000, /* U+5fa3 */
  0x0000, /* U+5fa4 */
  0x0000, /* U+5fa5 */
  0x0000, /* U+5fa6 */
  0x0000, /* U+5fa7 */
  0x9c72, /* U+5fa8 */
  0x959c, /* U+5fa9 */
  0x8f7a, /* U+5faa */
  0x0000, /* U+5fab */
  0x0000, /* U+5fac */
  0x9c73, /* U+5fad */
  0x94f7, /* U+5fae */
  0x0000, /* U+5faf */
  0x0000, /* U+5fb0 */
  0x0000, /* U+5fb1 */
  0x0000, /* U+5fb2 */
  0x93bf, /* U+5fb3 */
  0x92a5, /* U+5fb4 */
  0x0000, /* U+5fb5 */
  0x0000, /* U+5fb6 */
  0xfaba, /* U+5fb7 */
  0x0000, /* U+5fb8 */
  0x934f, /* U+5fb9 */
  0x0000, /* U+5fba */
  0x0000, /* U+5fbb */
  0x9c74, /* U+5fbc */
  0x8b4a, /* U+5fbd */
  0x0000, /* U+5fbe */
  0x0000, /* U+5fbf */
  0x0000, /* U+5fc0 */
  0x0000, /* U+5fc1 */
  0x0000, /* U+5fc2 */
  0x9053, /* U+5fc3 */
  0x0000, /* U+5fc4 */
  0x954b, /* U+5fc5 */
  0x0000, /* U+5fc6 */
  0x0000, /* U+5fc7 */
  0x0000, /* U+5fc8 */
  0x0000, /* U+5fc9 */
  0x0000, /* U+5fca */
  0x0000, /* U+5fcb */
  0x8af5, /* U+5fcc */
  0x9445, /* U+5fcd */
  0x0000, /* U+5fce */
  0x0000, /* U+5fcf */
  0x0000, /* U+5fd0 */
  0x0000, /* U+5fd1 */
  0x0000, /* U+5fd2 */
  0x0000, /* U+5fd3 */
  0x0000, /* U+5fd4 */
  0x0000, /* U+5fd5 */
  0x9c75, /* U+5fd6 */
  0x8e75, /* U+5fd7 */
  0x9659, /* U+5fd8 */
  0x965a, /* U+5fd9 */
  0x0000, /* U+5fda */
  0x0000, /* U+5fdb */
  0x899e, /* U+5fdc */
  0x9c7a, /* U+5fdd */
  0xfabb, /* U+5fde */
  0x0000, /* U+5fdf */
  0x9289, /* U+5fe0 */
  0x0000, /* U+5fe1 */
  0x0000, /* U+5fe2 */
  0x0000, /* U+5fe3 */
  0x9c77, /* U+5fe4 */
  0x0000, /* U+5fe5 */
  0x0000, /* U+5fe6 */
  0x0000, /* U+5fe7 */
  0x0000, /* U+5fe8 */
  0x0000, /* U+5fe9 */
  0x0000, /* U+5fea */
  0x89f5, /* U+5feb */
  0x0000, /* U+5fec */
  0x0000, /* U+5fed */
  0x0000, /* U+5fee */
  0x0000, /* U+5fef */
  0x9cab, /* U+5ff0 */
  0x9c79, /* U+5ff1 */
  0x0000, /* U+5ff2 */
  0x0000, /* U+5ff3 */
  0x0000, /* U+5ff4 */
  0x944f, /* U+5ff5 */
  0x0000, /* U+5ff6 */
  0x0000, /* U+5ff7 */
  0x9c78, /* U+5ff8 */
  0x0000, /* U+5ff9 */
  0x0000, /* U+5ffa */
  0x9c76, /* U+5ffb */
  0x0000, /* U+5ffc */
  0x8d9a, /* U+5ffd */
  0x0000, /* U+5ffe */
  0x9c7c, /* U+5fff */
  0x0000, /* U+6000 */
  0x0000, /* U+6001 */
  0x0000, /* U+6002 */
  0x0000, /* U+6003 */
  0x0000, /* U+6004 */
  0x0000, /* U+6005 */
  0x0000, /* U+6006 */
  0x0000, /* U+6007 */
  0x0000, /* U+6008 */
  0x0000, /* U+6009 */
  0x0000, /* U+600a */
  0x0000, /* U+600b */
  0x0000, /* U+600c */
  0x0000, /* U+600d */
  0x9c83, /* U+600e */
  0x9c89, /* U+600f */
  0x9c81, /* U+6010 */
  0x0000, /* U+6011 */
  0x937b, /* U+6012 */
  0x0000, /* U+6013 */
  0x0000, /* U+6014 */
  0x9c86, /* U+6015 */
  0x957c, /* U+6016 */
  0x0000, /* U+6017 */
  0x0000, /* U+6018 */
  0x9c80, /* U+6019 */
  0x0000, /* U+601a */
  0x9c85, /* U+601b */
  0x97e5, /* U+601c */
  0x8e76, /* U+601d */
  0x0000, /* U+601e */
  0x0000, /* U+601f */
  0x91d3, /* U+6020 */
  0x9c7d, /* U+6021 */
  0x0000, /* U+6022 */
  0x0000, /* U+6023 */
  0x0000, /* U+6024 */
  0x8b7d, /* U+6025 */
  0x9c88, /* U+6026 */
  0x90ab, /* U+6027 */
  0x8985, /* U+6028 */
  0x9c82, /* U+6029 */
  0x89f6, /* U+602a */
  0x9c87, /* U+602b */
  0x0000, /* U+602c */
  0x0000, /* U+602d */
  0x0000, /* U+602e */
  0x8baf, /* U+602f */
  0x0000, /* U+6030 */
  0x9c84, /* U+6031 */
  0x0000, /* U+6032 */
  0x0000, /* U+6033 */
  0x0000, /* U+6034 */
  0x0000, /* U+6035 */
  0x0000, /* U+6036 */
  0x0000, /* U+6037 */
  0x0000, /* U+6038 */
  0x0000, /* U+6039 */
  0x9c8a, /* U+603a */
  0x0000, /* U+603b */
  0x0000, /* U+603c */
  0x0000, /* U+603d */
  0x0000, /* U+603e */
  0x0000, /* U+603f */
  0x0000, /* U+6040 */
  0x9c8c, /* U+6041 */
  0x9c96, /* U+6042 */
  0x9c94, /* U+6043 */
  0x0000, /* U+6044 */
  0x0000, /* U+6045 */
  0x9c91, /* U+6046 */
  0x0000, /* U+6047 */
  0x0000, /* U+6048 */
  0x0000, /* U+6049 */
  0x9c90, /* U+604a */
  0x97f6, /* U+604b */
  0x0000, /* U+604c */
  0x9c92, /* U+604d */
  0x0000, /* U+604e */
  0x0000, /* U+604f */
  0x8bb0, /* U+6050 */
  0x0000, /* U+6051 */
  0x8d50, /* U+6052 */
  0x0000, /* U+6053 */
  0x0000, /* U+6054 */
  0x8f9a, /* U+6055 */
  0x0000, /* U+6056 */
  0x0000, /* U+6057 */
  0x0000, /* U+6058 */
  0x9c99, /* U+6059 */
  0x9c8b, /* U+605a */
  0x0000, /* U+605b */
  0x0000, /* U+605c */
  0xfabc, /* U+605d */
  0x0000, /* U+605e */
  0x9c8f, /* U+605f */
  0x9c7e, /* U+6060 */
  0x0000, /* U+6061 */
  0x89f8, /* U+6062 */
  0x9c93, /* U+6063 */
  0x9c95, /* U+6064 */
  0x9270, /* U+6065 */
  0x0000, /* U+6066 */
  0x0000, /* U+6067 */
  0x8da6, /* U+6068 */
  0x89b6, /* U+6069 */
  0x9c8d, /* U+606a */
  0x9c98, /* U+606b */
  0x9c97, /* U+606c */
  0x8bb1, /* U+606d */
  0x0000, /* U+606e */
  0x91a7, /* U+606f */
  0x8a86, /* U+6070 */
  0x0000, /* U+6071 */
  0x0000, /* U+6072 */
  0x0000, /* U+6073 */
  0x0000, /* U+6074 */
  0x8c62, /* U+6075 */
  0x0000, /* U+6076 */
  0x9c8e, /* U+6077 */
  0x0000, /* U+6078 */
  0x0000, /* U+6079 */
  0x0000, /* U+607a */
  0x0000, /* U+607b */
  0x0000, /* U+607c */
  0x0000, /* U+607d */
  0x0000, /* U+607e */
  0x0000, /* U+607f */
  0x0000, /* U+6080 */
  0x9c9a, /* U+6081 */
  0x0000, /* U+6082 */
  0x9c9d, /* U+6083 */
  0x9c9f, /* U+6084 */
  0xfabd, /* U+6085 */
  0x0000, /* U+6086 */
  0x0000, /* U+6087 */
  0x0000, /* U+6088 */
  0x8ebb, /* U+6089 */
  0xfabe, /* U+608a */
  0x9ca5, /* U+608b */
  0x92ee, /* U+608c */
  0x9c9b, /* U+608d */
  0x0000, /* U+608e */
  0x0000, /* U+608f */
  0x0000, /* U+6090 */
  0x0000, /* U+6091 */
  0x9ca3, /* U+6092 */
  0x0000, /* U+6093 */
  0x89f7, /* U+6094 */
  0x0000, /* U+6095 */
  0x9ca1, /* U+6096 */
  0x9ca2, /* U+6097 */
  0x0000, /* U+6098 */
  0x0000, /* U+6099 */
  0x9c9e, /* U+609a */
  0x9ca0, /* U+609b */
  0x0000, /* U+609c */
  0x0000, /* U+609d */
  0x0000, /* U+609e */
  0x8ce5, /* U+609f */
  0x9749, /* U+60a0 */
  0x0000, /* U+60a1 */
  0x0000, /* U+60a2 */
  0x8ab3, /* U+60a3 */
  0x0000, /* U+60a4 */
  0x0000, /* U+60a5 */
  0x8978, /* U+60a6 */
  0x9ca4, /* U+60a7 */
  0x0000, /* U+60a8 */
  0x9459, /* U+60a9 */
  0x88ab, /* U+60aa */
  0x0000, /* U+60ab */
  0x0000, /* U+60ac */
  0x0000, /* U+60ad */
  0x0000, /* U+60ae */
  0x0000, /* U+60af */
  0x0000, /* U+60b0 */
  0x0000, /* U+60b1 */
  0x94df, /* U+60b2 */
  0x9c7b, /* U+60b3 */
  0x9caa, /* U+60b4 */
  0x9cae, /* U+60b5 */
  0x96e3, /* U+60b6 */
  0x0000, /* U+60b7 */
  0x9ca7, /* U+60b8 */
  0x0000, /* U+60b9 */
  0x0000, /* U+60ba */
  0x0000, /* U+60bb */
  0x9389, /* U+60bc */
  0x9cac, /* U+60bd */
  0x0000, /* U+60be */
  0x0000, /* U+60bf */
  0x0000, /* U+60c0 */
  0x0000, /* U+60c1 */
  0x0000, /* U+60c2 */
  0x0000, /* U+60c3 */
  0x0000, /* U+60c4 */
  0x8fee, /* U+60c5 */
  0x9cad, /* U+60c6 */
  0x93d5, /* U+60c7 */
  0x0000, /* U+60c8 */
  0x0000, /* U+60c9 */
  0x0000, /* U+60ca */
  0x0000, /* U+60cb */
  0x0000, /* U+60cc */
  0x0000, /* U+60cd */
  0x0000, /* U+60ce */
  0x0000, /* U+60cf */
  0x0000, /* U+60d0 */
  0x9866, /* U+60d1 */
  0x0000, /* U+60d2 */
  0x9ca9, /* U+60d3 */
  0x0000, /* U+60d4 */
  0xfac0, /* U+60d5 */
  0x0000, /* U+60d6 */
  0x0000, /* U+60d7 */
  0x9caf, /* U+60d8 */
  0x0000, /* U+60d9 */
  0x8d9b, /* U+60da */
  0x0000, /* U+60db */
  0x90c9, /* U+60dc */
  0x0000, /* U+60dd */
  0xfabf, /* U+60de */
  0x88d2, /* U+60df */
  0x9ca8, /* U+60e0 */
  0x9ca6, /* U+60e1 */
  0x0000, /* U+60e2 */
  0x9179, /* U+60e3 */
  0x0000, /* U+60e4 */
  0x0000, /* U+60e5 */
  0x0000, /* U+60e6 */
  0x9c9c, /* U+60e7 */
  0x8e53, /* U+60e8 */
  0x0000, /* U+60e9 */
  0x0000, /* U+60ea */
  0x0000, /* U+60eb */
  0x0000, /* U+60ec */
  0x0000, /* U+60ed */
  0x0000, /* U+60ee */
  0x0000, /* U+60ef */
  0x91c4, /* U+60f0 */
  0x9cbb, /* U+60f1 */
  0xfac2, /* U+60f2 */
  0x917a, /* U+60f3 */
  0x9cb6, /* U+60f4 */
  0x0000, /* U+60f5 */
  0x9cb3, /* U+60f6 */
  0x9cb4, /* U+60f7 */
  0x0000, /* U+60f8 */
  0x8ee4, /* U+60f9 */
  0x9cb7, /* U+60fa */
  0x9cba, /* U+60fb */
  0x0000, /* U+60fc */
  0x0000, /* U+60fd */
  0x0000, /* U+60fe */
  0x0000, /* U+60ff */
  0x9cb5, /* U+6100 */
  0x8f44, /* U+6101 */
  0x0000, /* U+6102 */
  0x9cb8, /* U+6103 */
  0x0000, /* U+6104 */
  0x0000, /* U+6105 */
  0x9cb2, /* U+6106 */
  0x0000, /* U+6107 */
  0x96fa, /* U+6108 */
  0x96f9, /* U+6109 */
  0x0000, /* U+610a */
  0x0000, /* U+610b */
  0x0000, /* U+610c */
  0x9cbc, /* U+610d */
  0x9cbd, /* U+610e */
  0x88d3, /* U+610f */
  0x0000, /* U+6110 */
  0xfac3, /* U+6111 */
  0x0000, /* U+6112 */
  0x0000, /* U+6113 */
  0x0000, /* U+6114 */
  0x9cb1, /* U+6115 */
  0x0000, /* U+6116 */
  0x0000, /* U+6117 */
  0x0000, /* U+6118 */
  0x0000, /* U+6119 */
  0x8bf0, /* U+611a */
  0x88a4, /* U+611b */
  0x0000, /* U+611c */
  0x0000, /* U+611d */
  0x0000, /* U+611e */
  0x8ab4, /* U+611f */
  0xfac1, /* U+6120 */
  0x9cb9, /* U+6121 */
  0x0000, /* U+6122 */
  0x0000, /* U+6123 */
  0x0000, /* U+6124 */
  0x0000, /* U+6125 */
  0x0000, /* U+6126 */
  0x9cc1, /* U+6127 */
  0x9cc0, /* U+6128 */
  0x0000, /* U+6129 */
  0x0000, /* U+612a */
  0x0000, /* U+612b */
  0x9cc5, /* U+612c */
  0x0000, /* U+612d */
  0x0000, /* U+612e */
  0x0000, /* U+612f */
  0xfac5, /* U+6130 */
  0x0000, /* U+6131 */
  0x0000, /* U+6132 */
  0x0000, /* U+6133 */
  0x9cc6, /* U+6134 */
  0x0000, /* U+6135 */
  0x0000, /* U+6136 */
  0xfac4, /* U+6137 */
  0x0000, /* U+6138 */
  0x0000, /* U+6139 */
  0x0000, /* U+613a */
  0x0000, /* U+613b */
  0x9cc4, /* U+613c */
  0x9cc7, /* U+613d */
  0x9cbf, /* U+613e */
  0x9cc3, /* U+613f */
  0x0000, /* U+6140 */
  0x0000, /* U+6141 */
  0x9cc8, /* U+6142 */
  0x0000, /* U+6143 */
  0x9cc9, /* U+6144 */
  0x0000, /* U+6145 */
  0x0000, /* U+6146 */
  0x9cbe, /* U+6147 */
  0x8e9c, /* U+6148 */
  0x0000, /* U+6149 */
  0x9cc2, /* U+614a */
  0x91d4, /* U+614b */
  0x8d51, /* U+614c */
  0x9cb0, /* U+614d */
  0x9054, /* U+614e */
  0x0000, /* U+614f */
  0x0000, /* U+6150 */
  0x0000, /* U+6151 */
  0x0000, /* U+6152 */
  0x9cd6, /* U+6153 */
  0x0000, /* U+6154 */
  0x95e7, /* U+6155 */
  0x0000, /* U+6156 */
  0x0000, /* U+6157 */
  0x9ccc, /* U+6158 */
  0x9ccd, /* U+6159 */
  0x9cce, /* U+615a */
  0x0000, /* U+615b */
  0x0000, /* U+615c */
  0x9cd5, /* U+615d */
  0x0000, /* U+615e */
  0x9cd4, /* U+615f */
  0x0000, /* U+6160 */
  0x0000, /* U+6161 */
  0x969d, /* U+6162 */
  0x8ab5, /* U+6163 */
  0x0000, /* U+6164 */
  0x9cd2, /* U+6165 */
  0x0000, /* U+6166 */
  0x8c64, /* U+6167 */
  0x8a53, /* U+6168 */
  0x0000, /* U+6169 */
  0x0000, /* U+616a */
  0x9ccf, /* U+616b */
  0x0000, /* U+616c */
  0x0000, /* U+616d */
  0x97b6, /* U+616e */
  0x9cd1, /* U+616f */
  0x88d4, /* U+6170 */
  0x9cd3, /* U+6171 */
  0x0000, /* U+6172 */
  0x9cca, /* U+6173 */
  0x9cd0, /* U+6174 */
  0x9cd7, /* U+6175 */
  0x8c63, /* U+6176 */
  0x9ccb, /* U+6177 */
  0x0000, /* U+6178 */
  0x0000, /* U+6179 */
  0x0000, /* U+617a */
  0x0000, /* U+617b */
  0x0000, /* U+617c */
  0x0000, /* U+617d */
  0x977c, /* U+617e */
  0x0000, /* U+617f */
  0x0000, /* U+6180 */
  0x0000, /* U+6181 */
  0x974a, /* U+6182 */
  0x0000, /* U+6183 */
  0x0000, /* U+6184 */
  0x0000, /* U+6185 */
  0x0000, /* U+6186 */
  0x9cda, /* U+6187 */
  0x0000, /* U+6188 */
  0x0000, /* U+6189 */
  0x9cde, /* U+618a */
  0x0000, /* U+618b */
  0x0000, /* U+618c */
  0x0000, /* U+618d */
  0x919e, /* U+618e */
  0x0000, /* U+618f */
  0x97f7, /* U+6190 */
  0x9cdf, /* U+6191 */
  0x0000, /* U+6192 */
  0x0000, /* U+6193 */
  0x9cdc, /* U+6194 */
  0x0000, /* U+6195 */
  0x9cd9, /* U+6196 */
  0x0000, /* U+6197 */
  0xfac6, /* U+6198 */
  0x9cd8, /* U+6199 */
  0x9cdd, /* U+619a */
  0x0000, /* U+619b */
  0x0000, /* U+619c */
  0x0000, /* U+619d */
  0x0000, /* U+619e */
  0x0000, /* U+619f */
  0x0000, /* U+61a0 */
  0x0000, /* U+61a1 */
  0x0000, /* U+61a2 */
  0x0000, /* U+61a3 */
  0x95ae, /* U+61a4 */
  0x0000, /* U+61a5 */
  0x0000, /* U+61a6 */
  0x93b2, /* U+61a7 */
  0x0000, /* U+61a8 */
  0x8c65, /* U+61a9 */
  0x0000, /* U+61aa */
  0x9ce0, /* U+61ab */
  0x9cdb, /* U+61ac */
  0x0000, /* U+61ad */
  0x9ce1, /* U+61ae */
  0x0000, /* U+61af */
  0x0000, /* U+61b0 */
  0x0000, /* U+61b1 */
  0x8c9b, /* U+61b2 */
  0x0000, /* U+61b3 */
  0x0000, /* U+61b4 */
  0x0000, /* U+61b5 */
  0x89af, /* U+61b6 */
  0x0000, /* U+61b7 */
  0x0000, /* U+61b8 */
  0x0000, /* U+61b9 */
  0x9ce9, /* U+61ba */
  0x0000, /* U+61bb */
  0x0000, /* U+61bc */
  0x0000, /* U+61bd */
  0x8ab6, /* U+61be */
  0x0000, /* U+61bf */
  0x0000, /* U+61c0 */
  0x0000, /* U+61c1 */
  0x0000, /* U+61c2 */
  0x9ce7, /* U+61c3 */
  0x0000, /* U+61c4 */
  0x0000, /* U+61c5 */
  0x9ce8, /* U+61c6 */
  0x8da7, /* U+61c7 */
  0x9ce6, /* U+61c8 */
  0x9ce4, /* U+61c9 */
  0x9ce3, /* U+61ca */
  0x9cea, /* U+61cb */
  0x9ce2, /* U+61cc */
  0x9cec, /* U+61cd */
  0x0000, /* U+61ce */
  0x0000, /* U+61cf */
  0x89f9, /* U+61d0 */
  0x0000, /* U+61d1 */
  0x0000, /* U+61d2 */
  0x0000, /* U+61d3 */
  0x0000, /* U+61d4 */
  0x0000, /* U+61d5 */
  0x0000, /* U+61d6 */
  0x0000, /* U+61d7 */
  0x0000, /* U+61d8 */
  0x0000, /* U+61d9 */
  0x0000, /* U+61da */
  0x0000, /* U+61db */
  0x0000, /* U+61dc */
  0x0000, /* U+61dd */
  0x0000, /* U+61de */
  0x0000, /* U+61df */
  0x0000, /* U+61e0 */
  0x0000, /* U+61e1 */
  0x0000, /* U+61e2 */
  0x9cee, /* U+61e3 */
  0x0000, /* U+61e4 */
  0x0000, /* U+61e5 */
  0x9ced, /* U+61e6 */
  0x0000, /* U+61e7 */
  0x0000, /* U+61e8 */
  0x0000, /* U+61e9 */
  0x0000, /* U+61ea */
  0x0000, /* U+61eb */
  0x0000, /* U+61ec */
  0x0000, /* U+61ed */
  0x0000, /* U+61ee */
  0x0000, /* U+61ef */
  0x0000, /* U+61f0 */
  0x0000, /* U+61f1 */
  0x92a6, /* U+61f2 */
  0x0000, /* U+61f3 */
  0x9cf1, /* U+61f4 */
  0x0000, /* U+61f5 */
  0x9cef, /* U+61f6 */
  0x9ce5, /* U+61f7 */
  0x8c9c, /* U+61f8 */
  0x0000, /* U+61f9 */
  0x9cf0, /* U+61fa */
  0x0000, /* U+61fb */
  0x9cf4, /* U+61fc */
  0x9cf3, /* U+61fd */
  0x9cf5, /* U+61fe */
  0x9cf2, /* U+61ff */
  0x9cf6, /* U+6200 */
  0x0000, /* U+6201 */
  0x0000, /* U+6202 */
  0x0000, /* U+6203 */
  0x0000, /* U+6204 */
  0x0000, /* U+6205 */
  0x0000, /* U+6206 */
  0x0000, /* U+6207 */
  0x9cf7, /* U+6208 */
  0x9cf8, /* U+6209 */
  0x95e8, /* U+620a */
  0x0000, /* U+620b */
  0x9cfa, /* U+620c */
  0x9cf9, /* U+620d */
  0x8f5e, /* U+620e */
  0x0000, /* U+620f */
  0x90ac, /* U+6210 */
  0x89e4, /* U+6211 */
  0x89fa, /* U+6212 */
  0xfac7, /* U+6213 */
  0x9cfb, /* U+6214 */
  0x0000, /* U+6215 */
  0x88bd, /* U+6216 */
  0x0000, /* U+6217 */
  0x0000, /* U+6218 */
  0x0000, /* U+6219 */
  0x90ca, /* U+621a */
  0x9cfc, /* U+621b */
  0x0000, /* U+621c */
  0xe6c1, /* U+621d */
  0x9d40, /* U+621e */
  0x8c81, /* U+621f */
  0x0000, /* U+6220 */
  0x9d41, /* U+6221 */
  0x0000, /* U+6222 */
  0x0000, /* U+6223 */
  0x0000, /* U+6224 */
  0x0000, /* U+6225 */
  0x90ed, /* U+6226 */
  0x0000, /* U+6227 */
  0x0000, /* U+6228 */
  0x0000, /* U+6229 */
  0x9d42, /* U+622a */
  0x0000, /* U+622b */
  0x0000, /* U+622c */
  0x0000, /* U+622d */
  0x9d43, /* U+622e */
  0x8b59, /* U+622f */
  0x9d44, /* U+6230 */
  0x0000, /* U+6231 */
  0x9d45, /* U+6232 */
  0x9d46, /* U+6233 */
  0x91d5, /* U+6234 */
  0x0000, /* U+6235 */
  0x0000, /* U+6236 */
  0x0000, /* U+6237 */
  0x8ccb, /* U+6238 */
  0x0000, /* U+6239 */
  0x0000, /* U+623a */
  0x96df, /* U+623b */
  0x0000, /* U+623c */
  0x0000, /* U+623d */
  0x0000, /* U+623e */
  0x965b, /* U+623f */
  0x8f8a, /* U+6240 */
  0x9d47, /* U+6241 */
  0x0000, /* U+6242 */
  0x0000, /* U+6243 */
  0x0000, /* U+6244 */
  0x0000, /* U+6245 */
  0x0000, /* U+6246 */
  0x90ee, /* U+6247 */
  0xe7bb, /* U+6248 */
  0x94e0, /* U+6249 */
  0x0000, /* U+624a */
  0x8ee8, /* U+624b */
  0x0000, /* U+624c */
  0x8dcb, /* U+624d */
  0x9d48, /* U+624e */
  0x0000, /* U+624f */
  0x0000, /* U+6250 */
  0x0000, /* U+6251 */
  0x0000, /* U+6252 */
  0x91c5, /* U+6253 */
  0x0000, /* U+6254 */
  0x95a5, /* U+6255 */
  0x0000, /* U+6256 */
  0x0000, /* U+6257 */
  0x91ef, /* U+6258 */
  0x0000, /* U+6259 */
  0x0000, /* U+625a */
  0x9d4b, /* U+625b */
  0x0000, /* U+625c */
  0x0000, /* U+625d */
  0x9d49, /* U+625e */
  0x0000, /* U+625f */
  0x9d4c, /* U+6260 */
  0x0000, /* U+6261 */
  0x0000, /* U+6262 */
  0x9d4a, /* U+6263 */
  0x0000, /* U+6264 */
  0x0000, /* U+6265 */
  0x0000, /* U+6266 */
  0x0000, /* U+6267 */
  0x9d4d, /* U+6268 */
  0x0000, /* U+6269 */
  0x0000, /* U+626a */
  0x0000, /* U+626b */
  0x0000, /* U+626c */
  0x0000, /* U+626d */
  0x95af, /* U+626e */
  0x0000, /* U+626f */
  0x0000, /* U+6270 */
  0x88b5, /* U+6271 */
  0x0000, /* U+6272 */
  0x0000, /* U+6273 */
  0x0000, /* U+6274 */
  0x0000, /* U+6275 */
  0x957d, /* U+6276 */
  0x0000, /* U+6277 */
  0x0000, /* U+6278 */
  0x94e1, /* U+6279 */
  0x0000, /* U+627a */
  0x0000, /* U+627b */
  0x9d4e, /* U+627c */
  0x0000, /* U+627d */
  0x9d51, /* U+627e */
  0x8fb3, /* U+627f */
  0x8b5a, /* U+6280 */
  0x0000, /* U+6281 */
  0x9d4f, /* U+6282 */
  0x9d56, /* U+6283 */
  0x8fb4, /* U+6284 */
  0x0000, /* U+6285 */
  0x0000, /* U+6286 */
  0x0000, /* U+6287 */
  0x0000, /* U+6288 */
  0x9d50, /* U+6289 */
  0x9463, /* U+628a */
  0x0000, /* U+628b */
  0x0000, /* U+628c */
  0x0000, /* U+628d */
  0x0000, /* U+628e */
  0x0000, /* U+628f */
  0x0000, /* U+6290 */
  0x977d, /* U+6291 */
  0x9d52, /* U+6292 */
  0x9d53, /* U+6293 */
  0x9d57, /* U+6294 */
  0x938a, /* U+6295 */
  0x9d54, /* U+6296 */
  0x8d52, /* U+6297 */
  0x90dc, /* U+6298 */
  0x0000, /* U+6299 */
  0x0000, /* U+629a */
  0x9d65, /* U+629b */
  0x94b2, /* U+629c */
  0x0000, /* U+629d */
  0x91f0, /* U+629e */
  0x0000, /* U+629f */
  0x0000, /* U+62a0 */
  0x0000, /* U+62a1 */
  0x0000, /* U+62a2 */
  0x0000, /* U+62a3 */
  0x0000, /* U+62a4 */
  0x0000, /* U+62a5 */
  0xfac8, /* U+62a6 */
  0x0000, /* U+62a7 */
  0x0000, /* U+62a8 */
  0x0000, /* U+62a9 */
  0x0000, /* U+62aa */
  0x94e2, /* U+62ab */
  0x9dab, /* U+62ac */
  0x0000, /* U+62ad */
  0x0000, /* U+62ae */
  0x0000, /* U+62af */
  0x0000, /* U+62b0 */
  0x95f8, /* U+62b1 */
  0x0000, /* U+62b2 */
  0x0000, /* U+62b3 */
  0x0000, /* U+62b4 */
  0x92ef, /* U+62b5 */
  0x0000, /* U+62b6 */
  0x0000, /* U+62b7 */
  0x0000, /* U+62b8 */
  0x9695, /* U+62b9 */
  0x0000, /* U+62ba */
  0x9d5a, /* U+62bb */
  0x899f, /* U+62bc */
  0x928a, /* U+62bd */
  0x0000, /* U+62be */
  0x0000, /* U+62bf */
  0x0000, /* U+62c0 */
  0x0000, /* U+62c1 */
  0x9d63, /* U+62c2 */
  0x0000, /* U+62c3 */
  0x0000, /* U+62c4 */
  0x9253, /* U+62c5 */
  0x9d5d, /* U+62c6 */
  0x9d64, /* U+62c7 */
  0x9d5f, /* U+62c8 */
  0x9d66, /* U+62c9 */
  0x9d62, /* U+62ca */
  0x0000, /* U+62cb */
  0x9d61, /* U+62cc */
  0x948f, /* U+62cd */
  0x0000, /* U+62ce */
  0x9d5b, /* U+62cf */
  0x89fb, /* U+62d0 */
  0x9d59, /* U+62d1 */
  0x8b91, /* U+62d2 */
  0x91f1, /* U+62d3 */
  0x9d55, /* U+62d4 */
  0x0000, /* U+62d5 */
  0x0000, /* U+62d6 */
  0x9d58, /* U+62d7 */
  0x8d53, /* U+62d8 */
  0x90d9, /* U+62d9 */
  0x0000, /* U+62da */
  0x8fb5, /* U+62db */
  0x9d60, /* U+62dc */
  0x9471, /* U+62dd */
  0x0000, /* U+62de */
  0x0000, /* U+62df */
  0x8b92, /* U+62e0 */
  0x8a67, /* U+62e1 */
  0x0000, /* U+62e2 */
  0x0000, /* U+62e3 */
  0x0000, /* U+62e4 */
  0x0000, /* U+62e5 */
  0x0000, /* U+62e6 */
  0x0000, /* U+62e7 */
  0x0000, /* U+62e8 */
  0x0000, /* U+62e9 */
  0x0000, /* U+62ea */
  0x0000, /* U+62eb */
  0x8a87, /* U+62ec */
  0x9040, /* U+62ed */
  0x9d68, /* U+62ee */
  0x9d6d, /* U+62ef */
  0x0000, /* U+62f0 */
  0x9d69, /* U+62f1 */
  0x0000, /* U+62f2 */
  0x8c9d, /* U+62f3 */
  0x0000, /* U+62f4 */
  0x9d6e, /* U+62f5 */
  0x8e41, /* U+62f6 */
  0x8d89, /* U+62f7 */
  0x0000, /* U+62f8 */
  0x0000, /* U+62f9 */
  0x0000, /* U+62fa */
  0x0000, /* U+62fb */
  0x0000, /* U+62fc */
  0x0000, /* U+62fd */
  0x8f45, /* U+62fe */
  0x9d5c, /* U+62ff */
  0x0000, /* U+6300 */
  0x8e9d, /* U+6301 */
  0x9d6b, /* U+6302 */
  0x0000, /* U+6303 */
  0x0000, /* U+6304 */
  0x0000, /* U+6305 */
  0x0000, /* U+6306 */
  0x8e77, /* U+6307 */
  0x9d6c, /* U+6308 */
  0x88c2, /* U+6309 */
  0x0000, /* U+630a */
  0x0000, /* U+630b */
  0x9d67, /* U+630c */
  0x0000, /* U+630d */
  0x0000, /* U+630e */
  0x0000, /* U+630f */
  0x0000, /* U+6310 */
  0x92a7, /* U+6311 */
  0x0000, /* U+6312 */
  0x0000, /* U+6313 */
  0x0000, /* U+6314 */
  0x0000, /* U+6315 */
  0x0000, /* U+6316 */
  0x0000, /* U+6317 */
  0x0000, /* U+6318 */
  0x8b93, /* U+6319 */
  0x0000, /* U+631a */
  0x0000, /* U+631b */
  0x0000, /* U+631c */
  0x0000, /* U+631d */
  0x0000, /* U+631e */
  0x8bb2, /* U+631f */
  0x0000, /* U+6320 */
  0x0000, /* U+6321 */
  0x0000, /* U+6322 */
  0x0000, /* U+6323 */
  0x0000, /* U+6324 */
  0x0000, /* U+6325 */
  0x0000, /* U+6326 */
  0x9d6a, /* U+6327 */
  0x88a5, /* U+6328 */
  0x0000, /* U+6329 */
  0x0000, /* U+632a */
  0x8dc1, /* U+632b */
  0x0000, /* U+632c */
  0x0000, /* U+632d */
  0x0000, /* U+632e */
  0x9055, /* U+632f */
  0x0000, /* U+6330 */
  0x0000, /* U+6331 */
  0x0000, /* U+6332 */
  0x0000, /* U+6333 */
  0x0000, /* U+6334 */
  0x0000, /* U+6335 */
  0x0000, /* U+6336 */
  0x0000, /* U+6337 */
  0x0000, /* U+6338 */
  0x0000, /* U+6339 */
  0x92f0, /* U+633a */
  0x0000, /* U+633b */
  0x0000, /* U+633c */
  0x94d2, /* U+633d */
  0x9d70, /* U+633e */
  0x917d, /* U+633f */
  0x0000, /* U+6340 */
  0x0000, /* U+6341 */
  0x0000, /* U+6342 */
  0x0000, /* U+6343 */
  0x0000, /* U+6344 */
  0x0000, /* U+6345 */
  0x0000, /* U+6346 */
  0x0000, /* U+6347 */
  0x0000, /* U+6348 */
  0x91a8, /* U+6349 */
  0x0000, /* U+634a */
  0x0000, /* U+634b */
  0x8e4a, /* U+634c */
  0x9d71, /* U+634d */
  0x0000, /* U+634e */
  0x9d73, /* U+634f */
  0x9d6f, /* U+6350 */
  0x0000, /* U+6351 */
  0x0000, /* U+6352 */
  0x0000, /* U+6353 */
  0x0000, /* U+6354 */
  0x95df, /* U+6355 */
  0x0000, /* U+6356 */
  0x92bb, /* U+6357 */
  0x0000, /* U+6358 */
  0x0000, /* U+6359 */
  0x0000, /* U+635a */
  0x0000, /* U+635b */
  0x917b, /* U+635c */
  0x0000, /* U+635d */
  0x0000, /* U+635e */
  0x0000, /* U+635f */
  0x0000, /* U+6360 */
  0x0000, /* U+6361 */
  0x0000, /* U+6362 */
  0x0000, /* U+6363 */
  0x0000, /* U+6364 */
  0x0000, /* U+6365 */
  0x0000, /* U+6366 */
  0x95f9, /* U+6367 */
  0x8ecc, /* U+6368 */
  0x9d80, /* U+6369 */
  0x0000, /* U+636a */
  0x9d7e, /* U+636b */
  0x0000, /* U+636c */
  0x0000, /* U+636d */
  0x9098, /* U+636e */
  0x0000, /* U+636f */
  0x0000, /* U+6370 */
  0x0000, /* U+6371 */
  0x8c9e, /* U+6372 */
  0x0000, /* U+6373 */
  0x0000, /* U+6374 */
  0x0000, /* U+6375 */
  0x9d78, /* U+6376 */
  0x8fb7, /* U+6377 */
  0x0000, /* U+6378 */
  0x0000, /* U+6379 */
  0x93e6, /* U+637a */
  0x9450, /* U+637b */
  0x0000, /* U+637c */
  0x0000, /* U+637d */
  0x0000, /* U+637e */
  0x0000, /* U+637f */
  0x9d76, /* U+6380 */
  0x0000, /* U+6381 */
  0x0000, /* U+6382 */
  0x917c, /* U+6383 */
  0x0000, /* U+6384 */
  0x0000, /* U+6385 */
  0x0000, /* U+6386 */
  0x0000, /* U+6387 */
  0x8ef6, /* U+6388 */
  0x9d7b, /* U+6389 */
  0x0000, /* U+638a */
  0x0000, /* U+638b */
  0x8fb6, /* U+638c */
  0x0000, /* U+638d */
  0x9d75, /* U+638e */
  0x9d7a, /* U+638f */
  0x0000, /* U+6390 */
  0x0000, /* U+6391 */
  0x9472, /* U+6392 */
  0x0000, /* U+6393 */
  0x0000, /* U+6394 */
  0x0000, /* U+6395 */
  0x9d74, /* U+6396 */
  0x0000, /* U+6397 */
  0x8c40, /* U+6398 */
  0x0000, /* U+6399 */
  0x0000, /* U+639a */
  0x8a7c, /* U+639b */
  0x0000, /* U+639c */
  0x0000, /* U+639d */
  0x0000, /* U+639e */
  0x9d7c, /* U+639f */
  0x97a9, /* U+63a0 */
  0x8dcc, /* U+63a1 */
  0x9254, /* U+63a2 */
  0x9d79, /* U+63a3 */
  0x0000, /* U+63a4 */
  0x90da, /* U+63a5 */
  0x0000, /* U+63a6 */
  0x8d54, /* U+63a7 */
  0x9084, /* U+63a8 */
  0x8986, /* U+63a9 */
  0x915b, /* U+63aa */
  0x9d77, /* U+63ab */
  0x8b64, /* U+63ac */
  0x0000, /* U+63ad */
  0x0000, /* U+63ae */
  0x0000, /* U+63af */
  0x0000, /* U+63b0 */
  0x0000, /* U+63b1 */
  0x8c66, /* U+63b2 */
  0x0000, /* U+63b3 */
  0x92cd, /* U+63b4 */
  0x9d7d, /* U+63b5 */
  0x0000, /* U+63b6 */
  0x0000, /* U+63b7 */
  0x0000, /* U+63b8 */
  0x0000, /* U+63b9 */
  0x0000, /* U+63ba */
  0x917e, /* U+63bb */
  0x0000, /* U+63bc */
  0x0000, /* U+63bd */
  0x9d81, /* U+63be */
  0x0000, /* U+63bf */
  0x9d83, /* U+63c0 */
  0x0000, /* U+63c1 */
  0x0000, /* U+63c2 */
  0x91b5, /* U+63c3 */
  0x9d89, /* U+63c4 */
  0x0000, /* U+63c5 */
  0x9d84, /* U+63c6 */
  0x0000, /* U+63c7 */
  0x0000, /* U+63c8 */
  0x9d86, /* U+63c9 */
  0x0000, /* U+63ca */
  0x0000, /* U+63cb */
  0x0000, /* U+63cc */
  0x0000, /* U+63cd */
  0x0000, /* U+63ce */
  0x9560, /* U+63cf */
  0x92f1, /* U+63d0 */
  0x0000, /* U+63d1 */
  0x9d87, /* U+63d2 */
  0x0000, /* U+63d3 */
  0x0000, /* U+63d4 */
  0x0000, /* U+63d5 */
  0x974b, /* U+63d6 */
  0x0000, /* U+63d7 */
  0x0000, /* U+63d8 */
  0x0000, /* U+63d9 */
  0x9767, /* U+63da */
  0x8ab7, /* U+63db */
  0x0000, /* U+63dc */
  0x0000, /* U+63dd */
  0x0000, /* U+63de */
  0x0000, /* U+63df */
  0x0000, /* U+63e0 */
  0x88ac, /* U+63e1 */
  0x0000, /* U+63e2 */
  0x9d85, /* U+63e3 */
  0x0000, /* U+63e4 */
  0x0000, /* U+63e5 */
  0x0000, /* U+63e6 */
  0x0000, /* U+63e7 */
  0x0000, /* U+63e8 */
  0x9d82, /* U+63e9 */
  0x0000, /* U+63ea */
  0x0000, /* U+63eb */
  0x0000, /* U+63ec */
  0x0000, /* U+63ed */
  0x8af6, /* U+63ee */
  0x0000, /* U+63ef */
  0x0000, /* U+63f0 */
  0x0000, /* U+63f1 */
  0x0000, /* U+63f2 */
  0x0000, /* U+63f3 */
  0x8987, /* U+63f4 */
  0xfac9, /* U+63f5 */
  0x9d88, /* U+63f6 */
  0x0000, /* U+63f7 */
  0x0000, /* U+63f8 */
  0x0000, /* U+63f9 */
  0x9768, /* U+63fa */
  0x0000, /* U+63fb */
  0x0000, /* U+63fc */
  0x0000, /* U+63fd */
  0x0000, /* U+63fe */
  0x0000, /* U+63ff */
  0x0000, /* U+6400 */
  0x0000, /* U+6401 */
  0x0000, /* U+6402 */
  0x0000, /* U+6403 */
  0x0000, /* U+6404 */
  0x0000, /* U+6405 */
  0x9d8c, /* U+6406 */
  0x0000, /* U+6407 */
  0x0000, /* U+6408 */
  0x0000, /* U+6409 */
  0x0000, /* U+640a */
  0x0000, /* U+640b */
  0x0000, /* U+640c */
  0x91b9, /* U+640d */
  0x0000, /* U+640e */
  0x9d93, /* U+640f */
  0x0000, /* U+6410 */
  0x0000, /* U+6411 */
  0x0000, /* U+6412 */
  0x9d8d, /* U+6413 */
  0x0000, /* U+6414 */
  0x0000, /* U+6415 */
  0x9d8a, /* U+6416 */
  0x9d91, /* U+6417 */
  0x0000, /* U+6418 */
  0x0000, /* U+6419 */
  0x0000, /* U+641a */
  0x0000, /* U+641b */
  0x9d72, /* U+641c */
  0x0000, /* U+641d */
  0x0000, /* U+641e */
  0x0000, /* U+641f */
  0x0000, /* U+6420 */
  0x0000, /* U+6421 */
  0x0000, /* U+6422 */
  0x0000, /* U+6423 */
  0x0000, /* U+6424 */
  0x0000, /* U+6425 */
  0x9d8e, /* U+6426 */
  0x0000, /* U+6427 */
  0x9d92, /* U+6428 */
  0x0000, /* U+6429 */
  0x0000, /* U+642a */
  0x0000, /* U+642b */
  0x94c0, /* U+642c */
  0x938b, /* U+642d */
  0x0000, /* U+642e */
  0x0000, /* U+642f */
  0x0000, /* U+6430 */
  0x0000, /* U+6431 */
  0x0000, /* U+6432 */
  0x0000, /* U+6433 */
  0x9d8b, /* U+6434 */
  0x0000, /* U+6435 */
  0x9d8f, /* U+6436 */
  0x0000, /* U+6437 */
  0x0000, /* U+6438 */
  0x0000, /* U+6439 */
  0x8c67, /* U+643a */
  0x0000, /* U+643b */
  0x0000, /* U+643c */
  0x0000, /* U+643d */
  0x8def, /* U+643e */
  0x0000, /* U+643f */
  0x0000, /* U+6440 */
  0x0000, /* U+6441 */
  0x90db, /* U+6442 */
  0x0000, /* U+6443 */
  0x0000, /* U+6444 */
  0x0000, /* U+6445 */
  0x0000, /* U+6446 */
  0x0000, /* U+6447 */
  0x0000, /* U+6448 */
  0x0000, /* U+6449 */
  0x0000, /* U+644a */
  0x0000, /* U+644b */
  0x0000, /* U+644c */
  0x0000, /* U+644d */
  0x9d97, /* U+644e */
  0x0000, /* U+644f */
  0x0000, /* U+6450 */
  0x0000, /* U+6451 */
  0x0000, /* U+6452 */
  0x0000, /* U+6453 */
  0x0000, /* U+6454 */
  0x0000, /* U+6455 */
  0x0000, /* U+6456 */
  0x0000, /* U+6457 */
  0x9345, /* U+6458 */
  0x0000, /* U+6459 */
  0x0000, /* U+645a */
  0x0000, /* U+645b */
  0x0000, /* U+645c */
  0x0000, /* U+645d */
  0x0000, /* U+645e */
  0x0000, /* U+645f */
  0xfaca, /* U+6460 */
  0x0000, /* U+6461 */
  0x0000, /* U+6462 */
  0x0000, /* U+6463 */
  0x0000, /* U+6464 */
  0x0000, /* U+6465 */
  0x0000, /* U+6466 */
  0x9d94, /* U+6467 */
  0x0000, /* U+6468 */
  0x9680, /* U+6469 */
  0x0000, /* U+646a */
  0x0000, /* U+646b */
  0x0000, /* U+646c */
  0x0000, /* U+646d */
  0x0000, /* U+646e */
  0x9d95, /* U+646f */
  0x0000, /* U+6470 */
  0x0000, /* U+6471 */
  0x0000, /* U+6472 */
  0x0000, /* U+6473 */
  0x0000, /* U+6474 */
  0x0000, /* U+6475 */
  0x9d96, /* U+6476 */
  0x0000, /* U+6477 */
  0x96cc, /* U+6478 */
  0x0000, /* U+6479 */
  0x90a0, /* U+647a */
  0x0000, /* U+647b */
  0x0000, /* U+647c */
  0x0000, /* U+647d */
  0x0000, /* U+647e */
  0x0000, /* U+647f */
  0x0000, /* U+6480 */
  0x0000, /* U+6481 */
  0x0000, /* U+6482 */
  0x8c82, /* U+6483 */
  0x0000, /* U+6484 */
  0x0000, /* U+6485 */
  0x0000, /* U+6486 */
  0x0000, /* U+6487 */
  0x9d9d, /* U+6488 */
  0x0000, /* U+6489 */
  0x0000, /* U+648a */
  0x0000, /* U+648b */
  0x0000, /* U+648c */
  0x0000, /* U+648d */
  0x0000, /* U+648e */
  0x0000, /* U+648f */
  0x0000, /* U+6490 */
  0x0000, /* U+6491 */
  0x8e54, /* U+6492 */
  0x9d9a, /* U+6493 */
  0x0000, /* U+6494 */
  0x9d99, /* U+6495 */
  0x0000, /* U+6496 */
  0x0000, /* U+6497 */
  0x0000, /* U+6498 */
  0x0000, /* U+6499 */
  0x9451, /* U+649a */
  0x0000, /* U+649b */
  0x0000, /* U+649c */
  0xfacb, /* U+649d */
  0x93b3, /* U+649e */
  0x0000, /* U+649f */
  0x0000, /* U+64a0 */
  0x0000, /* U+64a1 */
  0x0000, /* U+64a2 */
  0x0000, /* U+64a3 */
  0x9350, /* U+64a4 */
  0x9d9b, /* U+64a5 */
  0x0000, /* U+64a6 */
  0x0000, /* U+64a7 */
  0x0000, /* U+64a8 */
  0x9d9c, /* U+64a9 */
  0x0000, /* U+64aa */
  0x958f, /* U+64ab */
  0x0000, /* U+64ac */
  0x9464, /* U+64ad */
  0x8e42, /* U+64ae */
  0x0000, /* U+64af */
  0x90ef, /* U+64b0 */
  0x0000, /* U+64b1 */
  0x966f, /* U+64b2 */
  0x0000, /* U+64b3 */
  0x0000, /* U+64b4 */
  0x0000, /* U+64b5 */
  0x0000, /* U+64b6 */
  0x0000, /* U+64b7 */
  0x0000, /* U+64b8 */
  0x8a68, /* U+64b9 */
  0x0000, /* U+64ba */
  0x9da3, /* U+64bb */
  0x9d9e, /* U+64bc */
  0x0000, /* U+64bd */
  0x0000, /* U+64be */
  0x0000, /* U+64bf */
  0x0000, /* U+64c0 */
  0x9769, /* U+64c1 */
  0x9da5, /* U+64c2 */
  0x0000, /* U+64c3 */
  0x0000, /* U+64c4 */
  0x9da1, /* U+64c5 */
  0x0000, /* U+64c6 */
  0x9da2, /* U+64c7 */
  0x0000, /* U+64c8 */
  0x0000, /* U+64c9 */
  0x0000, /* U+64ca */
  0x0000, /* U+64cb */
  0x0000, /* U+64cc */
  0x9180, /* U+64cd */
  0xfacc, /* U+64ce */
  0x0000, /* U+64cf */
  0x0000, /* U+64d0 */
  0x0000, /* U+64d1 */
  0x9da0, /* U+64d2 */
  0x0000, /* U+64d3 */
  0x9d5e, /* U+64d4 */
  0x0000, /* U+64d5 */
  0x0000, /* U+64d6 */
  0x0000, /* U+64d7 */
  0x9da4, /* U+64d8 */
  0x0000, /* U+64d9 */
  0x9d9f, /* U+64da */
  0x0000, /* U+64db */
  0x0000, /* U+64dc */
  0x0000, /* U+64dd */
  0x0000, /* U+64de */
  0x0000, /* U+64df */
  0x9da9, /* U+64e0 */
  0x9daa, /* U+64e1 */
  0x9346, /* U+64e2 */
  0x9dac, /* U+64e3 */
  0x0000, /* U+64e4 */
  0x0000, /* U+64e5 */
  0x8e43, /* U+64e6 */
  0x9da7, /* U+64e7 */
  0x0000, /* U+64e8 */
  0x0000, /* U+64e9 */
  0x0000, /* U+64ea */
  0x0000, /* U+64eb */
  0x8b5b, /* U+64ec */
  0x0000, /* U+64ed */
  0x0000, /* U+64ee */
  0x9dad, /* U+64ef */
  0x0000, /* U+64f0 */
  0x9da6, /* U+64f1 */
  0x9db1, /* U+64f2 */
  0x0000, /* U+64f3 */
  0x9db0, /* U+64f4 */
  0x0000, /* U+64f5 */
  0x9daf, /* U+64f6 */
  0x0000, /* U+64f7 */
  0x0000, /* U+64f8 */
  0x0000, /* U+64f9 */
  0x9db2, /* U+64fa */
  0x0000, /* U+64fb */
  0x0000, /* U+64fc */
  0x9db4, /* U+64fd */
  0x8fef, /* U+64fe */
  0x0000, /* U+64ff */
  0x9db3, /* U+6500 */
  0x0000, /* U+6501 */
  0x0000, /* U+6502 */
  0x0000, /* U+6503 */
  0x0000, /* U+6504 */
  0x9db7, /* U+6505 */
  0x0000, /* U+6506 */
  0x0000, /* U+6507 */
  0x0000, /* U+6508 */
  0x0000, /* U+6509 */
  0x0000, /* U+650a */
  0x0000, /* U+650b */
  0x0000, /* U+650c */
  0x0000, /* U+650d */
  0x0000, /* U+650e */
  0x0000, /* U+650f */
  0x0000, /* U+6510 */
  0x0000, /* U+6511 */
  0x0000, /* U+6512 */
  0x0000, /* U+6513 */
  0x0000, /* U+6514 */
  0x0000, /* U+6515 */
  0x0000, /* U+6516 */
  0x0000, /* U+6517 */
  0x9db5, /* U+6518 */
  0x0000, /* U+6519 */
  0x0000, /* U+651a */
  0x0000, /* U+651b */
  0x9db6, /* U+651c */
  0x9d90, /* U+651d */
  0x0000, /* U+651e */
  0x0000, /* U+651f */
  0x0000, /* U+6520 */
  0x0000, /* U+6521 */
  0x0000, /* U+6522 */
  0x9db9, /* U+6523 */
  0x9db8, /* U+6524 */
  0x0000, /* U+6525 */
  0x0000, /* U+6526 */
  0x0000, /* U+6527 */
  0x0000, /* U+6528 */
  0x0000, /* U+6529 */
  0x9d98, /* U+652a */
  0x9dba, /* U+652b */
  0x9dae, /* U+652c */
  0x0000, /* U+652d */
  0x0000, /* U+652e */
  0x8e78, /* U+652f */
  0x0000, /* U+6530 */
  0x0000, /* U+6531 */
  0x0000, /* U+6532 */
  0x0000, /* U+6533 */
  0x9dbb, /* U+6534 */
  0x9dbc, /* U+6535 */
  0x9dbe, /* U+6536 */
  0x9dbd, /* U+6537 */
  0x9dbf, /* U+6538 */
  0x89fc, /* U+6539 */
  0x0000, /* U+653a */
  0x8d55, /* U+653b */
  0x0000, /* U+653c */
  0x0000, /* U+653d */
  0x95fa, /* U+653e */
  0x90ad, /* U+653f */
  0x0000, /* U+6540 */
  0x0000, /* U+6541 */
  0x0000, /* U+6542 */
  0x0000, /* U+6543 */
  0x0000, /* U+6544 */
  0x8ccc, /* U+6545 */
  0x0000, /* U+6546 */
  0x0000, /* U+6547 */
  0x9dc1, /* U+6548 */
  0x0000, /* U+6549 */
  0x0000, /* U+654a */
  0x0000, /* U+654b */
  0x0000, /* U+654c */
  0x9dc4, /* U+654d */
  0xfacd, /* U+654e */
  0x9571, /* U+654f */
  0x0000, /* U+6550 */
  0x8b7e, /* U+6551 */
  0x0000, /* U+6552 */
  0x0000, /* U+6553 */
  0x0000, /* U+6554 */
  0x9dc3, /* U+6555 */
  0x9dc2, /* U+6556 */
  0x9473, /* U+6557 */
  0x9dc5, /* U+6558 */
  0x8bb3, /* U+6559 */
  0x0000, /* U+655a */
  0x0000, /* U+655b */
  0x0000, /* U+655c */
  0x9dc7, /* U+655d */
  0x9dc6, /* U+655e */
  0x0000, /* U+655f */
  0x0000, /* U+6560 */
  0x0000, /* U+6561 */
  0x8ab8, /* U+6562 */
  0x8e55, /* U+6563 */
  0x0000, /* U+6564 */
  0x0000, /* U+6565 */
  0x93d6, /* U+6566 */
  0x0000, /* U+6567 */
  0x0000, /* U+6568 */
  0x0000, /* U+6569 */
  0x0000, /* U+656a */
  0x0000, /* U+656b */
  0x8c68, /* U+656c */
  0x0000, /* U+656d */
  0x0000, /* U+656e */
  0x0000, /* U+656f */
  0x9094, /* U+6570 */
  0x0000, /* U+6571 */
  0x9dc8, /* U+6572 */
  0x0000, /* U+6573 */
  0x90ae, /* U+6574 */
  0x9347, /* U+6575 */
  0x0000, /* U+6576 */
  0x957e, /* U+6577 */
  0x9dc9, /* U+6578 */
  0x0000, /* U+6579 */
  0x0000, /* U+657a */
  0x0000, /* U+657b */
  0x0000, /* U+657c */
  0x0000, /* U+657d */
  0x0000, /* U+657e */
  0x0000, /* U+657f */
  0x0000, /* U+6580 */
  0x0000, /* U+6581 */
  0x9dca, /* U+6582 */
  0x9dcb, /* U+6583 */
  0x0000, /* U+6584 */
  0x0000, /* U+6585 */
  0x0000, /* U+6586 */
  0x95b6, /* U+6587 */
  0x9b7c, /* U+6588 */
  0x90c4, /* U+6589 */
  0x0000, /* U+658a */
  0x0000, /* U+658b */
  0x956b, /* U+658c */
  0x0000, /* U+658d */
  0x8dd6, /* U+658e */
  0x0000, /* U+658f */
  0x94e3, /* U+6590 */
  0x94c1, /* U+6591 */
  0x0000, /* U+6592 */
  0x0000, /* U+6593 */
  0x0000, /* U+6594 */
  0x0000, /* U+6595 */
  0x0000, /* U+6596 */
  0x936c, /* U+6597 */
  0x0000, /* U+6598 */
  0x97bf, /* U+6599 */
  0x0000, /* U+659a */
  0x9dcd, /* U+659b */
  0x8ece, /* U+659c */
  0x0000, /* U+659d */
  0x0000, /* U+659e */
  0x9dce, /* U+659f */
  0x0000, /* U+65a0 */
  0x88b4, /* U+65a1 */
  0x0000, /* U+65a2 */
  0x0000, /* U+65a3 */
  0x8bd2, /* U+65a4 */
  0x90cb, /* U+65a5 */
  0x0000, /* U+65a6 */
  0x9580, /* U+65a7 */
  0x0000, /* U+65a8 */
  0x0000, /* U+65a9 */
  0x0000, /* U+65aa */
  0x9dcf, /* U+65ab */
  0x8e61, /* U+65ac */
  0x9266, /* U+65ad */
  0x0000, /* U+65ae */
  0x8e7a, /* U+65af */
  0x9056, /* U+65b0 */
  0x0000, /* U+65b1 */
  0x0000, /* U+65b2 */
  0x0000, /* U+65b3 */
  0x0000, /* U+65b4 */
  0x0000, /* U+65b5 */
  0x0000, /* U+65b6 */
  0x9dd0, /* U+65b7 */
  0x0000, /* U+65b8 */
  0x95fb, /* U+65b9 */
  0x0000, /* U+65ba */
  0x0000, /* U+65bb */
  0x8997, /* U+65bc */
  0x8e7b, /* U+65bd */
  0x0000, /* U+65be */
  0x0000, /* U+65bf */
  0x0000, /* U+65c0 */
  0x9dd3, /* U+65c1 */
  0x0000, /* U+65c2 */
  0x9dd1, /* U+65c3 */
  0x9dd4, /* U+65c4 */
  0x97b7, /* U+65c5 */
  0x9dd2, /* U+65c6 */
  0x0000, /* U+65c7 */
  0x0000, /* U+65c8 */
  0x0000, /* U+65c9 */
  0x0000, /* U+65ca */
  0x90f9, /* U+65cb */
  0x9dd5, /* U+65cc */
  0x0000, /* U+65cd */
  0x0000, /* U+65ce */
  0x91b0, /* U+65cf */
  0x0000, /* U+65d0 */
  0x0000, /* U+65d1 */
  0x9dd6, /* U+65d2 */
  0x0000, /* U+65d3 */
  0x0000, /* U+65d4 */
  0x0000, /* U+65d5 */
  0x0000, /* U+65d6 */
  0x8af8, /* U+65d7 */
  0x0000, /* U+65d8 */
  0x9dd8, /* U+65d9 */
  0x0000, /* U+65da */
  0x9dd7, /* U+65db */
  0x0000, /* U+65dc */
  0x0000, /* U+65dd */
  0x0000, /* U+65de */
  0x0000, /* U+65df */
  0x9dd9, /* U+65e0 */
  0x9dda, /* U+65e1 */
  0x8af9, /* U+65e2 */
  0x0000, /* U+65e3 */
  0x0000, /* U+65e4 */
  0x93fa, /* U+65e5 */
  0x9255, /* U+65e6 */
  0x8b8c, /* U+65e7 */
  0x8e7c, /* U+65e8 */
  0x9181, /* U+65e9 */
  0x0000, /* U+65ea */
  0x0000, /* U+65eb */
  0x8f7b, /* U+65ec */
  0x88ae, /* U+65ed */
  0x0000, /* U+65ee */
  0x0000, /* U+65ef */
  0x0000, /* U+65f0 */
  0x9ddb, /* U+65f1 */
  0x0000, /* U+65f2 */
  0x0000, /* U+65f3 */
  0x0000, /* U+65f4 */
  0x0000, /* U+65f5 */
  0x0000, /* U+65f6 */
  0x0000, /* U+65f7 */
  0x0000, /* U+65f8 */
  0x0000, /* U+65f9 */
  0x89a0, /* U+65fa */
  0x9ddf, /* U+65fb */
  0x0000, /* U+65fc */
  0x0000, /* U+65fd */
  0x0000, /* U+65fe */
  0x0000, /* U+65ff */
  0xface, /* U+6600 */
  0x0000, /* U+6601 */
  0x8d56, /* U+6602 */
  0x9dde, /* U+6603 */
  0x0000, /* U+6604 */
  0x0000, /* U+6605 */
  0x8da9, /* U+6606 */
  0x8fb8, /* U+6607 */
  0x0000, /* U+6608 */
  0xfad1, /* U+6609 */
  0x9ddd, /* U+660a */
  0x0000, /* U+660b */
  0x8fb9, /* U+660c */
  0x0000, /* U+660d */
  0x96be, /* U+660e */
  0x8da8, /* U+660f */
  0x0000, /* U+6610 */
  0x0000, /* U+6611 */
  0x0000, /* U+6612 */
  0x88d5, /* U+6613 */
  0x90cc, /* U+6614 */
  0xfacf, /* U+6615 */
  0x0000, /* U+6616 */
  0x0000, /* U+6617 */
  0x0000, /* U+6618 */
  0x0000, /* U+6619 */
  0x0000, /* U+661a */
  0x0000, /* U+661b */
  0x9de4, /* U+661c */
  0x0000, /* U+661d */
  0xfad3, /* U+661e */
  0x90af, /* U+661f */
  0x8966, /* U+6620 */
  0x0000, /* U+6621 */
  0x0000, /* U+6622 */
  0x0000, /* U+6623 */
  0xfad4, /* U+6624 */
  0x8f74, /* U+6625 */
  0x0000, /* U+6626 */
  0x9686, /* U+6627 */
  0x8df0, /* U+6628 */
  0x0000, /* U+6629 */
  0x0000, /* U+662a */
  0x0000, /* U+662b */
  0x0000, /* U+662c */
  0x8fba, /* U+662d */
  0xfad2, /* U+662e */
  0x90a5, /* U+662f */
  0x0000, /* U+6630 */
  0xfa63, /* U+6631 */
  0x0000, /* U+6632 */
  0x0000, /* U+6633 */
  0x9de3, /* U+6634 */
  0x9de1, /* U+6635 */
  0x9de2, /* U+6636 */
  0x0000, /* U+6637 */
  0x0000, /* U+6638 */
  0x0000, /* U+6639 */
  0x0000, /* U+663a */
  0xfad0, /* U+663b */
  0x928b, /* U+663c */
  0x0000, /* U+663d */
  0x0000, /* U+663e */
  0x9e45, /* U+663f */
  0x0000, /* U+6640 */
  0x9de8, /* U+6641 */
  0x8e9e, /* U+6642 */
  0x8d57, /* U+6643 */
  0x9de6, /* U+6644 */
  0x0000, /* U+6645 */
  0x0000, /* U+6646 */
  0x0000, /* U+6647 */
  0x0000, /* U+6648 */
  0x9de7, /* U+6649 */
  0x0000, /* U+664a */
  0x9057, /* U+664b */
  0x0000, /* U+664c */
  0x0000, /* U+664d */
  0x0000, /* U+664e */
  0x9de5, /* U+664f */
  0x0000, /* U+6650 */
  0x0000, /* U+6651 */
  0x8e4e, /* U+6652 */
  0x0000, /* U+6653 */
  0x0000, /* U+6654 */
  0x0000, /* U+6655 */
  0x0000, /* U+6656 */
  0xfad6, /* U+6657 */
  0x0000, /* U+6658 */
  0xfad7, /* U+6659 */
  0x0000, /* U+665a */
  0x0000, /* U+665b */
  0x0000, /* U+665c */
  0x9dea, /* U+665d */
  0x9de9, /* U+665e */
  0x9dee, /* U+665f */
  0x0000, /* U+6660 */
  0x0000, /* U+6661 */
  0x9def, /* U+6662 */
  0x0000, /* U+6663 */
  0x9deb, /* U+6664 */
  0xfad5, /* U+6665 */
  0x8a41, /* U+6666 */
  0x9dec, /* U+6667 */
  0x9ded, /* U+6668 */
  0x94d3, /* U+6669 */
  0x0000, /* U+666a */
  0x0000, /* U+666b */
  0x0000, /* U+666c */
  0x0000, /* U+666d */
  0x9581, /* U+666e */
  0x8c69, /* U+666f */
  0x9df0, /* U+6670 */
  0x0000, /* U+6671 */
  0x0000, /* U+6672 */
  0xfad9, /* U+6673 */
  0x90b0, /* U+6674 */
  0x0000, /* U+6675 */
  0x8fbb, /* U+6676 */
  0x0000, /* U+6677 */
  0x0000, /* U+6678 */
  0x0000, /* U+6679 */
  0x9271, /* U+667a */
  0x0000, /* U+667b */
  0x0000, /* U+667c */
  0x0000, /* U+667d */
  0x0000, /* U+667e */
  0x0000, /* U+667f */
  0x0000, /* U+6680 */
  0x8bc5, /* U+6681 */
  0x0000, /* U+6682 */
  0x9df1, /* U+6683 */
  0x9df5, /* U+6684 */
  0x0000, /* U+6685 */
  0x0000, /* U+6686 */
  0x89c9, /* U+6687 */
  0x9df2, /* U+6688 */
  0x9df4, /* U+6689 */
  0x0000, /* U+668a */
  0x0000, /* U+668b */
  0x0000, /* U+668c */
  0x0000, /* U+668d */
  0x9df3, /* U+668e */
  0x0000, /* U+668f */
  0x0000, /* U+6690 */
  0x8f8b, /* U+6691 */
  0x0000, /* U+6692 */
  0x0000, /* U+6693 */
  0x0000, /* U+6694 */
  0x0000, /* U+6695 */
  0x9267, /* U+6696 */
  0x88c3, /* U+6697 */
  0x9df6, /* U+6698 */
  0xfada, /* U+6699 */
  0x0000, /* U+669a */
  0x0000, /* U+669b */
  0x0000, /* U+669c */
  0x9df7, /* U+669d */
  0x0000, /* U+669e */
  0x0000, /* U+669f */
  0xfadb, /* U+66a0 */
  0x0000, /* U+66a1 */
  0x92a8, /* U+66a2 */
  0x0000, /* U+66a3 */
  0x0000, /* U+66a4 */
  0x0000, /* U+66a5 */
  0x97ef, /* U+66a6 */
  0x0000, /* U+66a7 */
  0x0000, /* U+66a8 */
  0x0000, /* U+66a9 */
  0x0000, /* U+66aa */
  0x8e62, /* U+66ab */
  0x0000, /* U+66ac */
  0x0000, /* U+66ad */
  0x95e9, /* U+66ae */
  0x0000, /* U+66af */
  0x0000, /* U+66b0 */
  0x0000, /* U+66b1 */
  0xfadc, /* U+66b2 */
  0x0000, /* U+66b3 */
  0x965c, /* U+66b4 */
  0x0000, /* U+66b5 */
  0x0000, /* U+66b6 */
  0x0000, /* U+66b7 */
  0x9e41, /* U+66b8 */
  0x9df9, /* U+66b9 */
  0x0000, /* U+66ba */
  0x0000, /* U+66bb */
  0x9dfc, /* U+66bc */
  0x0000, /* U+66bd */
  0x9dfb, /* U+66be */
  0xfadd, /* U+66bf */
  0x0000, /* U+66c0 */
  0x9df8, /* U+66c1 */
  0x0000, /* U+66c2 */
  0x0000, /* U+66c3 */
  0x9e40, /* U+66c4 */
  0x0000, /* U+66c5 */
  0x0000, /* U+66c6 */
  0x93dc, /* U+66c7 */
  0x0000, /* U+66c8 */
  0x9dfa, /* U+66c9 */
  0x0000, /* U+66ca */
  0x0000, /* U+66cb */
  0x0000, /* U+66cc */
  0x0000, /* U+66cd */
  0x0000, /* U+66ce */
  0x0000, /* U+66cf */
  0x0000, /* U+66d0 */
  0x0000, /* U+66d1 */
  0x0000, /* U+66d2 */
  0x0000, /* U+66d3 */
  0x0000, /* U+66d4 */
  0x0000, /* U+66d5 */
  0x9e42, /* U+66d6 */
  0x0000, /* U+66d7 */
  0x0000, /* U+66d8 */
  0x8f8c, /* U+66d9 */
  0x9e43, /* U+66da */
  0x0000, /* U+66db */
  0x976a, /* U+66dc */
  0x9498, /* U+66dd */
  0x0000, /* U+66de */
  0x0000, /* U+66df */
  0x9e44, /* U+66e0 */
  0x0000, /* U+66e1 */
  0x0000, /* U+66e2 */
  0x0000, /* U+66e3 */
  0x0000, /* U+66e4 */
  0x0000, /* U+66e5 */
  0x9e46, /* U+66e6 */
  0x0000, /* U+66e7 */
  0x0000, /* U+66e8 */
  0x9e47, /* U+66e9 */
  0x0000, /* U+66ea */
  0x0000, /* U+66eb */
  0x0000, /* U+66ec */
  0x0000, /* U+66ed */
  0x0000, /* U+66ee */
  0x0000, /* U+66ef */
  0x9e48, /* U+66f0 */
  0x0000, /* U+66f1 */
  0x8bc8, /* U+66f2 */
  0x8967, /* U+66f3 */
  0x8d58, /* U+66f4 */
  0x9e49, /* U+66f5 */
  0x0000, /* U+66f6 */
  0x9e4a, /* U+66f7 */
  0x8f91, /* U+66f8 */
  0x9182, /* U+66f9 */
  0xfade, /* U+66fa */
  0xfa66, /* U+66fb */
  0x99d6, /* U+66fc */
  0x915d, /* U+66fd */
  0x915c, /* U+66fe */
  0x91d6, /* U+66ff */
  0x8dc5, /* U+6700 */
  0x0000, /* U+6701 */
  0x0000, /* U+6702 */
  0x98f0, /* U+6703 */
  0x0000, /* U+6704 */
  0x0000, /* U+6705 */
  0x0000, /* U+6706 */
  0x0000, /* U+6707 */
  0x8c8e, /* U+6708 */
  0x974c, /* U+6709 */
  0x0000, /* U+670a */
  0x95fc, /* U+670b */
  0x0000, /* U+670c */
  0x959e, /* U+670d */
  0xfadf, /* U+670e */
  0x9e4b, /* U+670f */
  0x0000, /* U+6710 */
  0x0000, /* U+6711 */
  0x0000, /* U+6712 */
  0x0000, /* U+6713 */
  0x8df1, /* U+6714 */
  0x92bd, /* U+6715 */
  0x9e4c, /* U+6716 */
  0x984e, /* U+6717 */
  0x0000, /* U+6718 */
  0x0000, /* U+6719 */
  0x0000, /* U+671a */
  0x965d, /* U+671b */
  0x0000, /* U+671c */
  0x92a9, /* U+671d */
  0x9e4d, /* U+671e */
  0x8afa, /* U+671f */
  0x0000, /* U+6720 */
  0x0000, /* U+6721 */
  0x0000, /* U+6722 */
  0x0000, /* U+6723 */
  0x0000, /* U+6724 */
  0x0000, /* U+6725 */
  0x9e4e, /* U+6726 */
  0x9e4f, /* U+6727 */
  0x96d8, /* U+6728 */
  0x0000, /* U+6729 */
  0x96a2, /* U+672a */
  0x9696, /* U+672b */
  0x967b, /* U+672c */
  0x8e44, /* U+672d */
  0x9e51, /* U+672e */
  0x0000, /* U+672f */
  0x0000, /* U+6730 */
  0x8ee9, /* U+6731 */
  0x0000, /* U+6732 */
  0x0000, /* U+6733 */
  0x9670, /* U+6734 */
  0x0000, /* U+6735 */
  0x9e53, /* U+6736 */
  0x9e56, /* U+6737 */
  0x9e55, /* U+6738 */
  0x0000, /* U+6739 */
  0x8af7, /* U+673a */
  0x0000, /* U+673b */
  0x0000, /* U+673c */
  0x8b80, /* U+673d */
  0x0000, /* U+673e */
  0x9e52, /* U+673f */
  0x0000, /* U+6740 */
  0x9e54, /* U+6741 */
  0x0000, /* U+6742 */
  0x0000, /* U+6743 */
  0x0000, /* U+6744 */
  0x0000, /* U+6745 */
  0x9e57, /* U+6746 */
  0x0000, /* U+6747 */
  0x0000, /* U+6748 */
  0x9099, /* U+6749 */
  0x0000, /* U+674a */
  0x0000, /* U+674b */
  0x0000, /* U+674c */
  0x0000, /* U+674d */
  0x979b, /* U+674e */
  0x88c7, /* U+674f */
  0x8dde, /* U+6750 */
  0x91ba, /* U+6751 */
  0x0000, /* U+6752 */
  0x8edb, /* U+6753 */
  0x0000, /* U+6754 */
  0x0000, /* U+6755 */
  0x8ff1, /* U+6756 */
  0x0000, /* U+6757 */
  0x0000, /* U+6758 */
  0x9e5a, /* U+6759 */
  0x0000, /* U+675a */
  0x0000, /* U+675b */
  0x936d, /* U+675c */
  0x0000, /* U+675d */
  0x9e58, /* U+675e */
  0x91a9, /* U+675f */
  0x9e59, /* U+6760 */
  0x8ff0, /* U+6761 */
  0x96db, /* U+6762 */
  0x9e5b, /* U+6763 */
  0x9e5c, /* U+6764 */
  0x9788, /* U+6765 */
  0xfae1, /* U+6766 */
  0x0000, /* U+6767 */
  0x0000, /* U+6768 */
  0x0000, /* U+6769 */
  0x9e61, /* U+676a */
  0x0000, /* U+676b */
  0x0000, /* U+676c */
  0x8d59, /* U+676d */
  0x0000, /* U+676e */
  0x9474, /* U+676f */
  0x9e5e, /* U+6770 */
  0x938c, /* U+6771 */
  0x9ddc, /* U+6772 */
  0x9de0, /* U+6773 */
  0x0000, /* U+6774 */
  0x8b6e, /* U+6775 */
  0x0000, /* U+6776 */
  0x9466, /* U+6777 */
  0x0000, /* U+6778 */
  0x0000, /* U+6779 */
  0x0000, /* U+677a */
  0x0000, /* U+677b */
  0x9e60, /* U+677c */
  0x0000, /* U+677d */
  0x8fbc, /* U+677e */
  0x94c2, /* U+677f */
  0x0000, /* U+6780 */
  0x0000, /* U+6781 */
  0x0000, /* U+6782 */
  0x0000, /* U+6783 */
  0x0000, /* U+6784 */
  0x9e66, /* U+6785 */
  0x0000, /* U+6786 */
  0x94f8, /* U+6787 */
  0x0000, /* U+6788 */
  0x9e5d, /* U+6789 */
  0x0000, /* U+678a */
  0x9e63, /* U+678b */
  0x9e62, /* U+678c */
  0x0000, /* U+678d */
  0x0000, /* U+678e */
  0x0000, /* U+678f */
  0x90cd, /* U+6790 */
  0x0000, /* U+6791 */
  0x0000, /* U+6792 */
  0x0000, /* U+6793 */
  0x0000, /* U+6794 */
  0x968d, /* U+6795 */
  0x0000, /* U+6796 */
  0x97d1, /* U+6797 */
  0x0000, /* U+6798 */
  0x0000, /* U+6799 */
  0x9687, /* U+679a */
  0x0000, /* U+679b */
  0x89ca, /* U+679c */
  0x8e7d, /* U+679d */
  0x0000, /* U+679e */
  0x0000, /* U+679f */
  0x9867, /* U+67a0 */
  0x9e65, /* U+67a1 */
  0x9095, /* U+67a2 */
  0x0000, /* U+67a3 */
  0x0000, /* U+67a4 */
  0x0000, /* U+67a5 */
  0x9e64, /* U+67a6 */
  0x0000, /* U+67a7 */
  0x0000, /* U+67a8 */
  0x9e5f, /* U+67a9 */
  0x0000, /* U+67aa */
  0x0000, /* U+67ab */
  0x0000, /* U+67ac */
  0x0000, /* U+67ad */
  0x0000, /* U+67ae */
  0x8ccd, /* U+67af */
  0x0000, /* U+67b0 */
  0x0000, /* U+67b1 */
  0x0000, /* U+67b2 */
  0x9e6b, /* U+67b3 */
  0x9e69, /* U+67b4 */
  0x0000, /* U+67b5 */
  0x89cb, /* U+67b6 */
  0x9e67, /* U+67b7 */
  0x9e6d, /* U+67b8 */
  0x9e73, /* U+67b9 */
  0x0000, /* U+67ba */
  0xfae2, /* U+67bb */
  0x0000, /* U+67bc */
  0x0000, /* U+67bd */
  0x0000, /* U+67be */
  0x0000, /* U+67bf */
  0xfae4, /* U+67c0 */
  0x91c6, /* U+67c1 */
  0x0000, /* U+67c2 */
  0x0000, /* U+67c3 */
  0x95bf, /* U+67c4 */
  0x0000, /* U+67c5 */
  0x9e75, /* U+67c6 */
  0x0000, /* U+67c7 */
  0x0000, /* U+67c8 */
  0x0000, /* U+67c9 */
  0x9541, /* U+67ca */
  0x0000, /* U+67cb */
  0x0000, /* U+67cc */
  0x0000, /* U+67cd */
  0x9e74, /* U+67ce */
  0x9490, /* U+67cf */
  0x965e, /* U+67d0 */
  0x8ab9, /* U+67d1 */
  0x0000, /* U+67d2 */
  0x90f5, /* U+67d3 */
  0x8f5f, /* U+67d4 */
  0x0000, /* U+67d5 */
  0x0000, /* U+67d6 */
  0x0000, /* U+67d7 */
  0x92d1, /* U+67d8 */
  0x0000, /* U+67d9 */
  0x974d, /* U+67da */
  0x0000, /* U+67db */
  0x0000, /* U+67dc */
  0x9e70, /* U+67dd */
  0x9e6f, /* U+67de */
  0x0000, /* U+67df */
  0x0000, /* U+67e0 */
  0x0000, /* U+67e1 */
  0x9e71, /* U+67e2 */
  0x0000, /* U+67e3 */
  0x9e6e, /* U+67e4 */
  0x0000, /* U+67e5 */
  0x0000, /* U+67e6 */
  0x9e76, /* U+67e7 */
  0x0000, /* U+67e8 */
  0x9e6c, /* U+67e9 */
  0x0000, /* U+67ea */
  0x0000, /* U+67eb */
  0x9e6a, /* U+67ec */
  0x0000, /* U+67ed */
  0x9e72, /* U+67ee */
  0x9e68, /* U+67ef */
  0x0000, /* U+67f0 */
  0x928c, /* U+67f1 */
  0x0000, /* U+67f2 */
  0x96f6, /* U+67f3 */
  0x8ec4, /* U+67f4 */
  0x8df2, /* U+67f5 */
  0x0000, /* U+67f6 */
  0x0000, /* U+67f7 */
  0x0000, /* U+67f8 */
  0x0000, /* U+67f9 */
  0x0000, /* U+67fa */
  0x8db8, /* U+67fb */
  0x0000, /* U+67fc */
  0x0000, /* U+67fd */
  0x968f, /* U+67fe */
  0x8a60, /* U+67ff */
  0x0000, /* U+6800 */
  0xfae5, /* U+6801 */
  0x92cc, /* U+6802 */
  0x93c8, /* U+6803 */
  0x8968, /* U+6804 */
  0x0000, /* U+6805 */
  0x0000, /* U+6806 */
  0x0000, /* U+6807 */
  0x0000, /* U+6808 */
  0x0000, /* U+6809 */
  0x0000, /* U+680a */
  0x0000, /* U+680b */
  0x0000, /* U+680c */
  0x0000, /* U+680d */
  0x0000, /* U+680e */
  0x0000, /* U+680f */
  0x0000, /* U+6810 */
  0x0000, /* U+6811 */
  0x0000, /* U+6812 */
  0x90f0, /* U+6813 */
  0x0000, /* U+6814 */
  0x0000, /* U+6815 */
  0x90b2, /* U+6816 */
  0x8c49, /* U+6817 */
  0x0000, /* U+6818 */
  0x0000, /* U+6819 */
  0x0000, /* U+681a */
  0x0000, /* U+681b */
  0x0000, /* U+681c */
  0x0000, /* U+681d */
  0x9e78, /* U+681e */
  0x0000, /* U+681f */
  0x0000, /* U+6820 */
  0x8d5a, /* U+6821 */
  0x8a9c, /* U+6822 */
  0x0000, /* U+6823 */
  0x0000, /* U+6824 */
  0x0000, /* U+6825 */
  0x0000, /* U+6826 */
  0x0000, /* U+6827 */
  0x0000, /* U+6828 */
  0x9e7a, /* U+6829 */
  0x8a94, /* U+682a */
  0x9e81, /* U+682b */
  0x0000, /* U+682c */
  0x0000, /* U+682d */
  0x0000, /* U+682e */
  0x0000, /* U+682f */
  0x0000, /* U+6830 */
  0x0000, /* U+6831 */
  0x9e7d, /* U+6832 */
  0x0000, /* U+6833 */
  0x90f1, /* U+6834 */
  0x0000, /* U+6835 */
  0x0000, /* U+6836 */
  0x0000, /* U+6837 */
  0x8a6a, /* U+6838 */
  0x8daa, /* U+6839 */
  0x0000, /* U+683a */
  0x0000, /* U+683b */
  0x8a69, /* U+683c */
  0x8dcd, /* U+683d */
  0x0000, /* U+683e */
  0x0000, /* U+683f */
  0x9e7b, /* U+6840 */
  0x8c85, /* U+6841 */
  0x8c6a, /* U+6842 */
  0x938d, /* U+6843 */
  0xfae6, /* U+6844 */
  0x0000, /* U+6845 */
  0x9e79, /* U+6846 */
  0x0000, /* U+6847 */
  0x88c4, /* U+6848 */
  0x0000, /* U+6849 */
  0x0000, /* U+684a */
  0x0000, /* U+684b */
  0x0000, /* U+684c */
  0x9e7c, /* U+684d */
  0x9e7e, /* U+684e */
  0x0000, /* U+684f */
  0x8bcb, /* U+6850 */
  0x8c4b, /* U+6851 */
  0xfae3, /* U+6852 */
  0x8aba, /* U+6853 */
  0x8b6a, /* U+6854 */
  0x0000, /* U+6855 */
  0x0000, /* U+6856 */
  0x0000, /* U+6857 */
  0x0000, /* U+6858 */
  0x9e82, /* U+6859 */
  0x0000, /* U+685a */
  0x0000, /* U+685b */
  0x8df7, /* U+685c */
  0x9691, /* U+685d */
  0x0000, /* U+685e */
  0x8e56, /* U+685f */
  0x0000, /* U+6860 */
  0x0000, /* U+6861 */
  0x0000, /* U+6862 */
  0x9e83, /* U+6863 */
  0x0000, /* U+6864 */
  0x0000, /* U+6865 */
  0x0000, /* U+6866 */
  0x954f, /* U+6867 */
  0x0000, /* U+6868 */
  0x0000, /* U+6869 */
  0x0000, /* U+686a */
  0x0000, /* U+686b */
  0x0000, /* U+686c */
  0x0000, /* U+686d */
  0x0000, /* U+686e */
  0x0000, /* U+686f */
  0x0000, /* U+6870 */
  0x0000, /* U+6871 */
  0x0000, /* U+6872 */
  0x0000, /* U+6873 */
  0x9e8f, /* U+6874 */
  0x0000, /* U+6875 */
  0x89b1, /* U+6876 */
  0x9e84, /* U+6877 */
  0x0000, /* U+6878 */
  0x0000, /* U+6879 */
  0x0000, /* U+687a */
  0x0000, /* U+687b */
  0x0000, /* U+687c */
  0x0000, /* U+687d */
  0x9e95, /* U+687e */
  0x9e85, /* U+687f */
  0x0000, /* U+6880 */
  0x97c0, /* U+6881 */
  0x0000, /* U+6882 */
  0x9e8c, /* U+6883 */
  0x0000, /* U+6884 */
  0x947e, /* U+6885 */
  0x0000, /* U+6886 */
  0x0000, /* U+6887 */
  0x0000, /* U+6888 */
  0x0000, /* U+6889 */
  0x0000, /* U+688a */
  0x0000, /* U+688b */
  0x0000, /* U+688c */
  0x9e94, /* U+688d */
  0x0000, /* U+688e */
  0x9e87, /* U+688f */
  0x0000, /* U+6890 */
  0x0000, /* U+6891 */
  0x0000, /* U+6892 */
  0x88b2, /* U+6893 */
  0x9e89, /* U+6894 */
  0x0000, /* U+6895 */
  0x0000, /* U+6896 */
  0x8d5b, /* U+6897 */
  0x0000, /* U+6898 */
  0x0000, /* U+6899 */
  0x0000, /* U+689a */
  0x9e8b, /* U+689b */
  0x0000, /* U+689c */
  0x9e8a, /* U+689d */
  0x0000, /* U+689e */
  0x9e86, /* U+689f */
  0x9e91, /* U+68a0 */
  0x0000, /* U+68a1 */
  0x8fbd, /* U+68a2 */
  0x0000, /* U+68a3 */
  0x0000, /* U+68a4 */
  0x0000, /* U+68a5 */
  0x9aeb, /* U+68a6 */
  0x8ce6, /* U+68a7 */
  0x979c, /* U+68a8 */
  0x0000, /* U+68a9 */
  0x0000, /* U+68aa */
  0x0000, /* U+68ab */
  0x0000, /* U+68ac */
  0x9e88, /* U+68ad */
  0x0000, /* U+68ae */
  0x92f2, /* U+68af */
  0x8a42, /* U+68b0 */
  0x8dab, /* U+68b1 */
  0x0000, /* U+68b2 */
  0x9e80, /* U+68b3 */
  0x0000, /* U+68b4 */
  0x9e90, /* U+68b5 */
  0x8a81, /* U+68b6 */
  0x0000, /* U+68b7 */
  0x0000, /* U+68b8 */
  0x9e8e, /* U+68b9 */
  0x9e92, /* U+68ba */
  0x0000, /* U+68bb */
  0x938e, /* U+68bc */
  0x0000, /* U+68bd */
  0x0000, /* U+68be */
  0x0000, /* U+68bf */
  0x0000, /* U+68c0 */
  0x0000, /* U+68c1 */
  0x0000, /* U+68c2 */
  0x0000, /* U+68c3 */
  0x8afc, /* U+68c4 */
  0x0000, /* U+68c5 */
  0x9eb0, /* U+68c6 */
  0x0000, /* U+68c7 */
  0xfa64, /* U+68c8 */
  0x96c7, /* U+68c9 */
  0x9e97, /* U+68ca */
  0x8afb, /* U+68cb */
  0x0000, /* U+68cc */
  0x9e9e, /* U+68cd */
  0x0000, /* U+68ce */
  0xfae7, /* U+68cf */
  0x0000, /* U+68d0 */
  0x0000, /* U+68d1 */
  0x965f, /* U+68d2 */
  0x0000, /* U+68d3 */
  0x9e9f, /* U+68d4 */
  0x9ea1, /* U+68d5 */
  0x0000, /* U+68d6 */
  0x9ea5, /* U+68d7 */
  0x9e99, /* U+68d8 */
  0x0000, /* U+68d9 */
  0x9249, /* U+68da */
  0x0000, /* U+68db */
  0x0000, /* U+68dc */
  0x0000, /* U+68dd */
  0x0000, /* U+68de */
  0x938f, /* U+68df */
  0x9ea9, /* U+68e0 */
  0x9e9c, /* U+68e1 */
  0x0000, /* U+68e2 */
  0x9ea6, /* U+68e3 */
  0x0000, /* U+68e4 */
  0x0000, /* U+68e5 */
  0x0000, /* U+68e6 */
  0x9ea0, /* U+68e7 */
  0x0000, /* U+68e8 */
  0x0000, /* U+68e9 */
  0x0000, /* U+68ea */
  0x0000, /* U+68eb */
  0x0000, /* U+68ec */
  0x0000, /* U+68ed */
  0x9058, /* U+68ee */
  0x9eaa, /* U+68ef */
  0x0000, /* U+68f0 */
  0x0000, /* U+68f1 */
  0x90b1, /* U+68f2 */
  0x0000, /* U+68f3 */
  0x0000, /* U+68f4 */
  0x0000, /* U+68f5 */
  0x0000, /* U+68f6 */
  0x0000, /* U+68f7 */
  0x0000, /* U+68f8 */
  0x9ea8, /* U+68f9 */
  0x8abb, /* U+68fa */
  0x0000, /* U+68fb */
  0x0000, /* U+68fc */
  0x0000, /* U+68fd */
  0x0000, /* U+68fe */
  0x0000, /* U+68ff */
  0x986f, /* U+6900 */
  0x9e96, /* U+6901 */
  0x0000, /* U+6902 */
  0x0000, /* U+6903 */
  0x9ea4, /* U+6904 */
  0x88d6, /* U+6905 */
  0x0000, /* U+6906 */
  0x0000, /* U+6907 */
  0x9e98, /* U+6908 */
  0x0000, /* U+6909 */
  0x0000, /* U+690a */
  0x96b8, /* U+690b */
  0x9e9d, /* U+690c */
  0x9041, /* U+690d */
  0x92c5, /* U+690e */
  0x9e93, /* U+690f */
  0x0000, /* U+6910 */
  0x0000, /* U+6911 */
  0x9ea3, /* U+6912 */
  0x0000, /* U+6913 */
  0x0000, /* U+6914 */
  0x0000, /* U+6915 */
  0x0000, /* U+6916 */
  0x0000, /* U+6917 */
  0x0000, /* U+6918 */
  0x909a, /* U+6919 */
  0x9ead, /* U+691a */
  0x8a91, /* U+691b */
  0x8c9f, /* U+691c */
  0x0000, /* U+691d */
  0x0000, /* U+691e */
  0x0000, /* U+691f */
  0x0000, /* U+6920 */
  0x9eaf, /* U+6921 */
  0x9e9a, /* U+6922 */
  0x9eae, /* U+6923 */
  0x0000, /* U+6924 */
  0x9ea7, /* U+6925 */
  0x9e9b, /* U+6926 */
  0x0000, /* U+6927 */
  0x9eab, /* U+6928 */
  0x0000, /* U+6929 */
  0x9eac, /* U+692a */
  0x0000, /* U+692b */
  0x0000, /* U+692c */
  0x0000, /* U+692d */
  0x0000, /* U+692e */
  0x0000, /* U+692f */
  0x9ebd, /* U+6930 */
  0x0000, /* U+6931 */
  0x0000, /* U+6932 */
  0x0000, /* U+6933 */
  0x93cc, /* U+6934 */
  0x0000, /* U+6935 */
  0x9ea2, /* U+6936 */
  0x0000, /* U+6937 */
  0x0000, /* U+6938 */
  0x9eb9, /* U+6939 */
  0x0000, /* U+693a */
  0x0000, /* U+693b */
  0x0000, /* U+693c */
  0x9ebb, /* U+693d */
  0x0000, /* U+693e */
  0x92d6, /* U+693f */
  0x0000, /* U+6940 */
  0x0000, /* U+6941 */
  0x0000, /* U+6942 */
  0x0000, /* U+6943 */
  0x0000, /* U+6944 */
  0x0000, /* U+6945 */
  0x0000, /* U+6946 */
  0x0000, /* U+6947 */
  0x0000, /* U+6948 */
  0x0000, /* U+6949 */
  0x976b, /* U+694a */
  0x0000, /* U+694b */
  0x0000, /* U+694c */
  0x0000, /* U+694d */
  0x0000, /* U+694e */
  0x0000, /* U+694f */
  0x0000, /* U+6950 */
  0x0000, /* U+6951 */
  0x0000, /* U+6952 */
  0x9596, /* U+6953 */
  0x9eb6, /* U+6954 */
  0x91c8, /* U+6955 */
  0x0000, /* U+6956 */
  0x0000, /* U+6957 */
  0x0000, /* U+6958 */
  0x9ebc, /* U+6959 */
  0x915e, /* U+695a */
  0x0000, /* U+695b */
  0x9eb3, /* U+695c */
  0x9ec0, /* U+695d */
  0x9ebf, /* U+695e */
  0x0000, /* U+695f */
  0x93ed, /* U+6960 */
  0x9ebe, /* U+6961 */
  0x93e8, /* U+6962 */
  0x0000, /* U+6963 */
  0x0000, /* U+6964 */
  0x0000, /* U+6965 */
  0x0000, /* U+6966 */
  0x0000, /* U+6967 */
  0xfae9, /* U+6968 */
  0x0000, /* U+6969 */
  0x9ec2, /* U+696a */
  0x9eb5, /* U+696b */
  0x0000, /* U+696c */
  0x8bc6, /* U+696d */
  0x9eb8, /* U+696e */
  0x8f7c, /* U+696f */
  0x0000, /* U+6970 */
  0x0000, /* U+6971 */
  0x0000, /* U+6972 */
  0x9480, /* U+6973 */
  0x9eba, /* U+6974 */
  0x8bc9, /* U+6975 */
  0x0000, /* U+6976 */
  0x9eb2, /* U+6977 */
  0x9eb4, /* U+6978 */
  0x9eb1, /* U+6979 */
  0x0000, /* U+697a */
  0x0000, /* U+697b */
  0x984f, /* U+697c */
  0x8a79, /* U+697d */
  0x9eb7, /* U+697e */
  0x0000, /* U+697f */
  0x0000, /* U+6980 */
  0x9ec1, /* U+6981 */
  0x8a54, /* U+6982 */
  0x0000, /* U+6983 */
  0x0000, /* U+6984 */
  0x0000, /* U+6985 */
  0x0000, /* U+6986 */
  0x0000, /* U+6987 */
  0x0000, /* U+6988 */
  0x0000, /* U+6989 */
  0x8de5, /* U+698a */
  0x0000, /* U+698b */
  0x0000, /* U+698c */
  0x0000, /* U+698d */
  0x897c, /* U+698e */
  0x0000, /* U+698f */
  0x0000, /* U+6990 */
  0x9ed2, /* U+6991 */
  0x0000, /* U+6992 */
  0x0000, /* U+6993 */
  0x9850, /* U+6994 */
  0x9ed5, /* U+6995 */
  0x0000, /* U+6996 */
  0x0000, /* U+6997 */
  0xfaeb, /* U+6998 */
  0x0000, /* U+6999 */
  0x0000, /* U+699a */
  0x9059, /* U+699b */
  0x9ed4, /* U+699c */
  0x0000, /* U+699d */
  0x0000, /* U+699e */
  0x0000, /* U+699f */
  0x9ed3, /* U+69a0 */
  0x0000, /* U+69a1 */
  0x0000, /* U+69a2 */
  0x0000, /* U+69a3 */
  0x0000, /* U+69a4 */
  0x0000, /* U+69a5 */
  0x0000, /* U+69a6 */
  0x9ed0, /* U+69a7 */
  0x0000, /* U+69a8 */
  0x0000, /* U+69a9 */
  0x0000, /* U+69aa */
  0x0000, /* U+69ab */
  0x0000, /* U+69ac */
  0x0000, /* U+69ad */
  0x9ec4, /* U+69ae */
  0x0000, /* U+69af */
  0x0000, /* U+69b0 */
  0x9ee1, /* U+69b1 */
  0x9ec3, /* U+69b2 */
  0x0000, /* U+69b3 */
  0x9ed6, /* U+69b4 */
  0x0000, /* U+69b5 */
  0x0000, /* U+69b6 */
  0x0000, /* U+69b7 */
  0x0000, /* U+69b8 */
  0x0000, /* U+69b9 */
  0x0000, /* U+69ba */
  0x9ece, /* U+69bb */
  0x0000, /* U+69bc */
  0x0000, /* U+69bd */
  0x9ec9, /* U+69be */
  0x9ec6, /* U+69bf */
  0x0000, /* U+69c0 */
  0x9ec7, /* U+69c1 */
  0x0000, /* U+69c2 */
  0x9ecf, /* U+69c3 */
  0x0000, /* U+69c4 */
  0x0000, /* U+69c5 */
  0x0000, /* U+69c6 */
  0xeaa0, /* U+69c7 */
  0x0000, /* U+69c8 */
  0x0000, /* U+69c9 */
  0x9ecc, /* U+69ca */
  0x8d5c, /* U+69cb */
  0x92c6, /* U+69cc */
  0x9184, /* U+69cd */
  0x9eca, /* U+69ce */
  0x0000, /* U+69cf */
  0x9ec5, /* U+69d0 */
  0x0000, /* U+69d1 */
  0x0000, /* U+69d2 */
  0x9ec8, /* U+69d3 */
  0x0000, /* U+69d4 */
  0x0000, /* U+69d5 */
  0x0000, /* U+69d6 */
  0x0000, /* U+69d7 */
  0x976c, /* U+69d8 */
  0x968a, /* U+69d9 */
  0x0000, /* U+69da */
  0x0000, /* U+69db */
  0x0000, /* U+69dc */
  0x9ecd, /* U+69dd */
  0x9ed7, /* U+69de */
  0x0000, /* U+69df */
  0x0000, /* U+69e0 */
  0x0000, /* U+69e1 */
  0xfaec, /* U+69e2 */
  0x0000, /* U+69e3 */
  0x0000, /* U+69e4 */
  0x0000, /* U+69e5 */
  0x0000, /* U+69e6 */
  0x9edf, /* U+69e7 */
  0x9ed8, /* U+69e8 */
  0x0000, /* U+69e9 */
  0x0000, /* U+69ea */
  0x9ee5, /* U+69eb */
  0x0000, /* U+69ec */
  0x9ee3, /* U+69ed */
  0x0000, /* U+69ee */
  0x0000, /* U+69ef */
  0x0000, /* U+69f0 */
  0x0000, /* U+69f1 */
  0x9ede, /* U+69f2 */
  0x0000, /* U+69f3 */
  0x0000, /* U+69f4 */
  0x0000, /* U+69f5 */
  0x0000, /* U+69f6 */
  0x0000, /* U+69f7 */
  0x0000, /* U+69f8 */
  0x9edd, /* U+69f9 */
  0x0000, /* U+69fa */
  0x92ce, /* U+69fb */
  0x0000, /* U+69fc */
  0x9185, /* U+69fd */
  0x0000, /* U+69fe */
  0x9edb, /* U+69ff */
  0x0000, /* U+6a00 */
  0x0000, /* U+6a01 */
  0x9ed9, /* U+6a02 */
  0x0000, /* U+6a03 */
  0x0000, /* U+6a04 */
  0x9ee0, /* U+6a05 */
  0x0000, /* U+6a06 */
  0x0000, /* U+6a07 */
  0x0000, /* U+6a08 */
  0x0000, /* U+6a09 */
  0x9ee6, /* U+6a0a */
  0x94f3, /* U+6a0b */
  0x9eec, /* U+6a0c */
  0x0000, /* U+6a0d */
  0x0000, /* U+6a0e */
  0x0000, /* U+6a0f */
  0x0000, /* U+6a10 */
  0x0000, /* U+6a11 */
  0x9ee7, /* U+6a12 */
  0x9eea, /* U+6a13 */
  0x9ee4, /* U+6a14 */
  0x0000, /* U+6a15 */
  0x0000, /* U+6a16 */
  0x9294, /* U+6a17 */
  0x0000, /* U+6a18 */
  0x9557, /* U+6a19 */
  0x0000, /* U+6a1a */
  0x9eda, /* U+6a1b */
  0x0000, /* U+6a1c */
  0x0000, /* U+6a1d */
  0x9ee2, /* U+6a1e */
  0x8fbe, /* U+6a1f */
  0x0000, /* U+6a20 */
  0x96cd, /* U+6a21 */
  0x9ef6, /* U+6a22 */
  0x9ee9, /* U+6a23 */
  0x0000, /* U+6a24 */
  0x0000, /* U+6a25 */
  0x0000, /* U+6a26 */
  0x0000, /* U+6a27 */
  0x0000, /* U+6a28 */
  0x8ca0, /* U+6a29 */
  0x89a1, /* U+6a2a */
  0x8a7e, /* U+6a2b */
  0x0000, /* U+6a2c */
  0x0000, /* U+6a2d */
  0x9ed1, /* U+6a2e */
  0x0000, /* U+6a2f */
  0xfaed, /* U+6a30 */
  0x0000, /* U+6a31 */
  0x0000, /* U+6a32 */
  0x0000, /* U+6a33 */
  0x0000, /* U+6a34 */
  0x8fbf, /* U+6a35 */
  0x9eee, /* U+6a36 */
  0x0000, /* U+6a37 */
  0x9ef5, /* U+6a38 */
  0x8ef7, /* U+6a39 */
  0x8a92, /* U+6a3a */
  0x0000, /* U+6a3b */
  0x0000, /* U+6a3c */
  0x924d, /* U+6a3d */
  0x0000, /* U+6a3e */
  0x0000, /* U+6a3f */
  0x0000, /* U+6a40 */
  0x0000, /* U+6a41 */
  0x0000, /* U+6a42 */
  0x0000, /* U+6a43 */
  0x9eeb, /* U+6a44 */
  0x0000, /* U+6a45 */
  0xfaef, /* U+6a46 */
  0x9ef0, /* U+6a47 */
  0x9ef4, /* U+6a48 */
  0x0000, /* U+6a49 */
  0x0000, /* U+6a4a */
  0x8bb4, /* U+6a4b */
  0x0000, /* U+6a4c */
  0x0000, /* U+6a4d */
  0x0000, /* U+6a4e */
  0x0000, /* U+6a4f */
  0x0000, /* U+6a50 */
  0x0000, /* U+6a51 */
  0x0000, /* U+6a52 */
  0x0000, /* U+6a53 */
  0x0000, /* U+6a54 */
  0x0000, /* U+6a55 */
  0x0000, /* U+6a56 */
  0x0000, /* U+6a57 */
  0x8b6b, /* U+6a58 */
  0x9ef2, /* U+6a59 */
  0x0000, /* U+6a5a */
  0x0000, /* U+6a5b */
  0x0000, /* U+6a5c */
  0x0000, /* U+6a5d */
  0x0000, /* U+6a5e */
  0x8b40, /* U+6a5f */
  0x0000, /* U+6a60 */
  0x93c9, /* U+6a61 */
  0x9ef1, /* U+6a62 */
  0x0000, /* U+6a63 */
  0x0000, /* U+6a64 */
  0x0000, /* U+6a65 */
  0x9ef3, /* U+6a66 */
  0x0000, /* U+6a67 */
  0x0000, /* U+6a68 */
  0x0000, /* U+6a69 */
  0x0000, /* U+6a6a */
  0xfaee, /* U+6a6b */
  0x0000, /* U+6a6c */
  0x0000, /* U+6a6d */
  0x0000, /* U+6a6e */
  0x0000, /* U+6a6f */
  0x0000, /* U+6a70 */
  0x0000, /* U+6a71 */
  0x9eed, /* U+6a72 */
  0xfaf0, /* U+6a73 */
  0x0000, /* U+6a74 */
  0x0000, /* U+6a75 */
  0x0000, /* U+6a76 */
  0x0000, /* U+6a77 */
  0x9eef, /* U+6a78 */
  0x0000, /* U+6a79 */
  0x0000, /* U+6a7a */
  0x0000, /* U+6a7b */
  0x0000, /* U+6a7c */
  0x0000, /* U+6a7d */
  0xfaf1, /* U+6a7e */
  0x8a80, /* U+6a7f */
  0x9268, /* U+6a80 */
  0x0000, /* U+6a81 */
  0x0000, /* U+6a82 */
  0x0000, /* U+6a83 */
  0x9efa, /* U+6a84 */
  0x0000, /* U+6a85 */
  0x0000, /* U+6a86 */
  0x0000, /* U+6a87 */
  0x0000, /* U+6a88 */
  0x0000, /* U+6a89 */
  0x0000, /* U+6a8a */
  0x0000, /* U+6a8b */
  0x0000, /* U+6a8c */
  0x9ef8, /* U+6a8d */
  0x8ce7, /* U+6a8e */
  0x0000, /* U+6a8f */
  0x9ef7, /* U+6a90 */
  0x0000, /* U+6a91 */
  0x0000, /* U+6a92 */
  0x0000, /* U+6a93 */
  0x0000, /* U+6a94 */
  0x0000, /* U+6a95 */
  0x0000, /* U+6a96 */
  0x9f40, /* U+6a97 */
  0x0000, /* U+6a98 */
  0x0000, /* U+6a99 */
  0x0000, /* U+6a9a */
  0x0000, /* U+6a9b */
  0x9e77, /* U+6a9c */
  0x0000, /* U+6a9d */
  0x0000, /* U+6a9e */
  0x0000, /* U+6a9f */
  0x9ef9, /* U+6aa0 */
  0x0000, /* U+6aa1 */
  0x9efb, /* U+6aa2 */
  0x9efc, /* U+6aa3 */
  0x0000, /* U+6aa4 */
  0x0000, /* U+6aa5 */
  0x0000, /* U+6aa6 */
  0x0000, /* U+6aa7 */
  0x0000, /* U+6aa8 */
  0x0000, /* U+6aa9 */
  0x9f4b, /* U+6aaa */
  0x0000, /* U+6aab */
  0x9f47, /* U+6aac */
  0x0000, /* U+6aad */
  0x9e8d, /* U+6aae */
  0x0000, /* U+6aaf */
  0x0000, /* U+6ab0 */
  0x0000, /* U+6ab1 */
  0x0000, /* U+6ab2 */
  0x9f46, /* U+6ab3 */
  0x0000, /* U+6ab4 */
  0x0000, /* U+6ab5 */
  0x0000, /* U+6ab6 */
  0x0000, /* U+6ab7 */
  0x9f45, /* U+6ab8 */
  0x0000, /* U+6ab9 */
  0x0000, /* U+6aba */
  0x9f42, /* U+6abb */
  0x0000, /* U+6abc */
  0x0000, /* U+6abd */
  0x0000, /* U+6abe */
  0x0000, /* U+6abf */
  0x0000, /* U+6ac0 */
  0x9ee8, /* U+6ac1 */
  0x9f44, /* U+6ac2 */
  0x9f43, /* U+6ac3 */
  0x0000, /* U+6ac4 */
  0x0000, /* U+6ac5 */
  0x0000, /* U+6ac6 */
  0x0000, /* U+6ac7 */
  0x0000, /* U+6ac8 */
  0x0000, /* U+6ac9 */
  0x0000, /* U+6aca */
  0x0000, /* U+6acb */
  0x0000, /* U+6acc */
  0x0000, /* U+6acd */
  0x0000, /* U+6ace */
  0x0000, /* U+6acf */
  0x0000, /* U+6ad0 */
  0x9f49, /* U+6ad1 */
  0x0000, /* U+6ad2 */
  0x9845, /* U+6ad3 */
  0x0000, /* U+6ad4 */
  0x0000, /* U+6ad5 */
  0x0000, /* U+6ad6 */
  0x0000, /* U+6ad7 */
  0x0000, /* U+6ad8 */
  0x0000, /* U+6ad9 */
  0x9f4c, /* U+6ada */
  0x8bf9, /* U+6adb */
  0x0000, /* U+6adc */
  0x0000, /* U+6add */
  0x9f48, /* U+6ade */
  0x9f4a, /* U+6adf */
  0x0000, /* U+6ae0 */
  0x0000, /* U+6ae1 */
  0xfaf2, /* U+6ae2 */
  0x0000, /* U+6ae3 */
  0xfaf3, /* U+6ae4 */
  0x0000, /* U+6ae5 */
  0x0000, /* U+6ae6 */
  0x0000, /* U+6ae7 */
  0x94a5, /* U+6ae8 */
  0x0000, /* U+6ae9 */
  0x9f4d, /* U+6aea */
  0x0000, /* U+6aeb */
  0x0000, /* U+6aec */
  0x0000, /* U+6aed */
  0x0000, /* U+6aee */
  0x0000, /* U+6aef */
  0x0000, /* U+6af0 */
  0x0000, /* U+6af1 */
  0x0000, /* U+6af2 */
  0x0000, /* U+6af3 */
  0x0000, /* U+6af4 */
  0x0000, /* U+6af5 */
  0x0000, /* U+6af6 */
  0x0000, /* U+6af7 */
  0x0000, /* U+6af8 */
  0x0000, /* U+6af9 */
  0x9f51, /* U+6afa */
  0x9f4e, /* U+6afb */
  0x0000, /* U+6afc */
  0x0000, /* U+6afd */
  0x0000, /* U+6afe */
  0x0000, /* U+6aff */
  0x0000, /* U+6b00 */
  0x0000, /* U+6b01 */
  0x0000, /* U+6b02 */
  0x0000, /* U+6b03 */
  0x9793, /* U+6b04 */
  0x9f4f, /* U+6b05 */
  0x0000, /* U+6b06 */
  0x0000, /* U+6b07 */
  0x0000, /* U+6b08 */
  0x0000, /* U+6b09 */
  0x9edc, /* U+6b0a */
  0x0000, /* U+6b0b */
  0x0000, /* U+6b0c */
  0x0000, /* U+6b0d */
  0x0000, /* U+6b0e */
  0x0000, /* U+6b0f */
  0x0000, /* U+6b10 */
  0x0000, /* U+6b11 */
  0x9f52, /* U+6b12 */
  0x0000, /* U+6b13 */
  0x0000, /* U+6b14 */
  0x0000, /* U+6b15 */
  0x9f53, /* U+6b16 */
  0x0000, /* U+6b17 */
  0x0000, /* U+6b18 */
  0x0000, /* U+6b19 */
  0x0000, /* U+6b1a */
  0x0000, /* U+6b1b */
  0x0000, /* U+6b1c */
  0x8954, /* U+6b1d */
  0x0000, /* U+6b1e */
  0x9f55, /* U+6b1f */
  0x8c87, /* U+6b20 */
  0x8e9f, /* U+6b21 */
  0x0000, /* U+6b22 */
  0x8bd3, /* U+6b23 */
  0x0000, /* U+6b24 */
  0x0000, /* U+6b25 */
  0x0000, /* U+6b26 */
  0x89a2, /* U+6b27 */
  0x0000, /* U+6b28 */
  0x0000, /* U+6b29 */
  0x0000, /* U+6b2a */
  0x0000, /* U+6b2b */
  0x0000, /* U+6b2c */
  0x0000, /* U+6b2d */
  0x0000, /* U+6b2e */
  0x0000, /* U+6b2f */
  0x0000, /* U+6b30 */
  0x0000, /* U+6b31 */
  0x977e, /* U+6b32 */
  0x0000, /* U+6b33 */
  0x0000, /* U+6b34 */
  0x0000, /* U+6b35 */
  0x0000, /* U+6b36 */
  0x9f57, /* U+6b37 */
  0x9f56, /* U+6b38 */
  0x9f59, /* U+6b39 */
  0x8b5c, /* U+6b3a */
  0x0000, /* U+6b3b */
  0x0000, /* U+6b3c */
  0x8bd4, /* U+6b3d */
  0x8abc, /* U+6b3e */
  0x0000, /* U+6b3f */
  0x0000, /* U+6b40 */
  0x0000, /* U+6b41 */
  0x0000, /* U+6b42 */
  0x9f5c, /* U+6b43 */
  0x0000, /* U+6b44 */
  0x0000, /* U+6b45 */
  0x0000, /* U+6b46 */
  0x9f5b, /* U+6b47 */
  0x0000, /* U+6b48 */
  0x9f5d, /* U+6b49 */
  0x0000, /* U+6b4a */
  0x0000, /* U+6b4b */
  0x89cc, /* U+6b4c */
  0x0000, /* U+6b4d */
  0x9256, /* U+6b4e */
  0x0000, /* U+6b4f */
  0x9f5e, /* U+6b50 */
  0x0000, /* U+6b51 */
  0x0000, /* U+6b52 */
  0x8abd, /* U+6b53 */
  0x9f60, /* U+6b54 */
  0x0000, /* U+6b55 */
  0x0000, /* U+6b56 */
  0x0000, /* U+6b57 */
  0x0000, /* U+6b58 */
  0x9f5f, /* U+6b59 */
  0x0000, /* U+6b5a */
  0x9f61, /* U+6b5b */
  0x0000, /* U+6b5c */
  0x0000, /* U+6b5d */
  0x0000, /* U+6b5e */
  0x9f62, /* U+6b5f */
  0x0000, /* U+6b60 */
  0x9f63, /* U+6b61 */
  0x8e7e, /* U+6b62 */
  0x90b3, /* U+6b63 */
  0x8d9f, /* U+6b64 */
  0x0000, /* U+6b65 */
  0x9590, /* U+6b66 */
  0x0000, /* U+6b67 */
  0x0000, /* U+6b68 */
  0x95e0, /* U+6b69 */
  0x9863, /* U+6b6a */
  0x0000, /* U+6b6b */
  0x0000, /* U+6b6c */
  0x0000, /* U+6b6d */
  0x0000, /* U+6b6e */
  0x8e95, /* U+6b6f */
  0x0000, /* U+6b70 */
  0x0000, /* U+6b71 */
  0x0000, /* U+6b72 */
  0x8dce, /* U+6b73 */
  0x97f0, /* U+6b74 */
  0x0000, /* U+6b75 */
  0x0000, /* U+6b76 */
  0x0000, /* U+6b77 */
  0x9f64, /* U+6b78 */
  0x9f65, /* U+6b79 */
  0x0000, /* U+6b7a */
  0x8e80, /* U+6b7b */
  0x0000, /* U+6b7c */
  0x0000, /* U+6b7d */
  0x0000, /* U+6b7e */
  0x9f66, /* U+6b7f */
  0x9f67, /* U+6b80 */
  0x0000, /* U+6b81 */
  0x0000, /* U+6b82 */
  0x9f69, /* U+6b83 */
  0x9f68, /* U+6b84 */
  0x0000, /* U+6b85 */
  0x9677, /* U+6b86 */
  0x0000, /* U+6b87 */
  0x0000, /* U+6b88 */
  0x8f7d, /* U+6b89 */
  0x8eea, /* U+6b8a */
  0x8e63, /* U+6b8b */
  0x0000, /* U+6b8c */
  0x9f6a, /* U+6b8d */
  0x0000, /* U+6b8e */
  0x0000, /* U+6b8f */
  0x0000, /* U+6b90 */
  0x0000, /* U+6b91 */
  0x0000, /* U+6b92 */
  0x0000, /* U+6b93 */
  0x0000, /* U+6b94 */
  0x9f6c, /* U+6b95 */
  0x9042, /* U+6b96 */
  0x0000, /* U+6b97 */
  0x9f6b, /* U+6b98 */
  0x0000, /* U+6b99 */
  0x0000, /* U+6b9a */
  0x0000, /* U+6b9b */
  0x0000, /* U+6b9c */
  0x0000, /* U+6b9d */
  0x9f6d, /* U+6b9e */
  0x0000, /* U+6b9f */
  0x0000, /* U+6ba0 */
  0x0000, /* U+6ba1 */
  0x0000, /* U+6ba2 */
  0x0000, /* U+6ba3 */
  0x9f6e, /* U+6ba4 */
  0x0000, /* U+6ba5 */
  0x0000, /* U+6ba6 */
  0x0000, /* U+6ba7 */
  0x0000, /* U+6ba8 */
  0x0000, /* U+6ba9 */
  0x9f6f, /* U+6baa */
  0x9f70, /* U+6bab */
  0x0000, /* U+6bac */
  0x0000, /* U+6bad */
  0x0000, /* U+6bae */
  0x9f71, /* U+6baf */
  0x0000, /* U+6bb0 */
  0x9f73, /* U+6bb1 */
  0x9f72, /* U+6bb2 */
  0x9f74, /* U+6bb3 */
  0x89a3, /* U+6bb4 */
  0x9269, /* U+6bb5 */
  0x0000, /* U+6bb6 */
  0x9f75, /* U+6bb7 */
  0x0000, /* U+6bb8 */
  0x0000, /* U+6bb9 */
  0x8e45, /* U+6bba */
  0x8a6b, /* U+6bbb */
  0x9f76, /* U+6bbc */
  0x0000, /* U+6bbd */
  0x0000, /* U+6bbe */
  0x9361, /* U+6bbf */
  0x9aca, /* U+6bc0 */
  0x0000, /* U+6bc1 */
  0x0000, /* U+6bc2 */
  0x0000, /* U+6bc3 */
  0x0000, /* U+6bc4 */
  0x8b42, /* U+6bc5 */
  0x9f77, /* U+6bc6 */
  0x0000, /* U+6bc7 */
  0x0000, /* U+6bc8 */
  0x0000, /* U+6bc9 */
  0x0000, /* U+6bca */
  0x9f78, /* U+6bcb */
  0x0000, /* U+6bcc */
  0x95ea, /* U+6bcd */
  0x9688, /* U+6bce */
  0x0000, /* U+6bcf */
  0x0000, /* U+6bd0 */
  0x0000, /* U+6bd1 */
  0x93c5, /* U+6bd2 */
  0x9f79, /* U+6bd3 */
  0x94e4, /* U+6bd4 */
  0x0000, /* U+6bd5 */
  0xfaf4, /* U+6bd6 */
  0x0000, /* U+6bd7 */
  0x94f9, /* U+6bd8 */
  0x0000, /* U+6bd9 */
  0x0000, /* U+6bda */
  0x96d1, /* U+6bdb */
  0x0000, /* U+6bdc */
  0x0000, /* U+6bdd */
  0x0000, /* U+6bde */
  0x9f7a, /* U+6bdf */
  0x0000, /* U+6be0 */
  0x0000, /* U+6be1 */
  0x0000, /* U+6be2 */
  0x0000, /* U+6be3 */
  0x0000, /* U+6be4 */
  0x0000, /* U+6be5 */
  0x0000, /* U+6be6 */
  0x0000, /* U+6be7 */
  0x0000, /* U+6be8 */
  0x0000, /* U+6be9 */
  0x0000, /* U+6bea */
  0x9f7c, /* U+6beb */
  0x9f7b, /* U+6bec */
  0x0000, /* U+6bed */
  0x0000, /* U+6bee */
  0x9f7e, /* U+6bef */
  0x0000, /* U+6bf0 */
  0x0000, /* U+6bf1 */
  0x0000, /* U+6bf2 */
  0x9f7d, /* U+6bf3 */
  0x0000, /* U+6bf4 */
  0x0000, /* U+6bf5 */
  0x0000, /* U+6bf6 */
  0x0000, /* U+6bf7 */
  0x0000, /* U+6bf8 */
  0x0000, /* U+6bf9 */
  0x0000, /* U+6bfa */
  0x0000, /* U+6bfb */
  0x0000, /* U+6bfc */
  0x0000, /* U+6bfd */
  0x0000, /* U+6bfe */
  0x0000, /* U+6bff */
  0x0000, /* U+6c00 */
  0x0000, /* U+6c01 */
  0x0000, /* U+6c02 */
  0x0000, /* U+6c03 */
  0x0000, /* U+6c04 */
  0x0000, /* U+6c05 */
  0x0000, /* U+6c06 */
  0x0000, /* U+6c07 */
  0x9f81, /* U+6c08 */
  0x0000, /* U+6c09 */
  0x0000, /* U+6c0a */
  0x0000, /* U+6c0b */
  0x0000, /* U+6c0c */
  0x0000, /* U+6c0d */
  0x0000, /* U+6c0e */
  0x8e81, /* U+6c0f */
  0x0000, /* U+6c10 */
  0x96af, /* U+6c11 */
  0x0000, /* U+6c12 */
  0x9f82, /* U+6c13 */
  0x9f83, /* U+6c14 */
  0x0000, /* U+6c15 */
  0x0000, /* U+6c16 */
  0x8b43, /* U+6c17 */
  0x0000, /* U+6c18 */
  0x0000, /* U+6c19 */
  0x0000, /* U+6c1a */
  0x9f84, /* U+6c1b */
  0x0000, /* U+6c1c */
  0x0000, /* U+6c1d */
  0x0000, /* U+6c1e */
  0x0000, /* U+6c1f */
  0x0000, /* U+6c20 */
  0x0000, /* U+6c21 */
  0x0000, /* U+6c22 */
  0x9f86, /* U+6c23 */
  0x9f85, /* U+6c24 */
  0x0000, /* U+6c25 */
  0x0000, /* U+6c26 */
  0x0000, /* U+6c27 */
  0x0000, /* U+6c28 */
  0x0000, /* U+6c29 */
  0x0000, /* U+6c2a */
  0x0000, /* U+6c2b */
  0x0000, /* U+6c2c */
  0x0000, /* U+6c2d */
  0x0000, /* U+6c2e */
  0x0000, /* U+6c2f */
  0x0000, /* U+6c30 */
  0x0000, /* U+6c31 */
  0x0000, /* U+6c32 */
  0x0000, /* U+6c33 */
  0x9085, /* U+6c34 */
  0x0000, /* U+6c35 */
  0x0000, /* U+6c36 */
  0x9558, /* U+6c37 */
  0x8969, /* U+6c38 */
  0x0000, /* U+6c39 */
  0x0000, /* U+6c3a */
  0x0000, /* U+6c3b */
  0x0000, /* U+6c3c */
  0x0000, /* U+6c3d */
  0x94c3, /* U+6c3e */
  0xfaf5, /* U+6c3f */
  0x92f3, /* U+6c40 */
  0x8f60, /* U+6c41 */
  0x8b81, /* U+6c42 */
  0x0000, /* U+6c43 */
  0x0000, /* U+6c44 */
  0x0000, /* U+6c45 */
  0x0000, /* U+6c46 */
  0x0000, /* U+6c47 */
  0x0000, /* U+6c48 */
  0x0000, /* U+6c49 */
  0x0000, /* U+6c4a */
  0x0000, /* U+6c4b */
  0x0000, /* U+6c4c */
  0x0000, /* U+6c4d */
  0x94c4, /* U+6c4e */
  0x0000, /* U+6c4f */
  0x8eac, /* U+6c50 */
  0x0000, /* U+6c51 */
  0x0000, /* U+6c52 */
  0x0000, /* U+6c53 */
  0x0000, /* U+6c54 */
  0x9f88, /* U+6c55 */
  0x0000, /* U+6c56 */
  0x8abe, /* U+6c57 */
  0x0000, /* U+6c58 */
  0x0000, /* U+6c59 */
  0x8998, /* U+6c5a */
  0x0000, /* U+6c5b */
  0xfaf6, /* U+6c5c */
  0x93f0, /* U+6c5d */
  0x9f87, /* U+6c5e */
  0x8d5d, /* U+6c5f */
  0x9272, /* U+6c60 */
  0x0000, /* U+6c61 */
  0x9f89, /* U+6c62 */
  0x0000, /* U+6c63 */
  0x0000, /* U+6c64 */
  0x0000, /* U+6c65 */
  0x0000, /* U+6c66 */
  0x0000, /* U+6c67 */
  0x9f91, /* U+6c68 */
  0x0000, /* U+6c69 */
  0x9f8a, /* U+6c6a */
  0x0000, /* U+6c6b */
  0x0000, /* U+6c6c */
  0x0000, /* U+6c6d */
  0x0000, /* U+6c6e */
  0xfaf8, /* U+6c6f */
  0x91bf, /* U+6c70 */
  0x0000, /* U+6c71 */
  0x8b82, /* U+6c72 */
  0x9f92, /* U+6c73 */
  0x0000, /* U+6c74 */
  0x0000, /* U+6c75 */
  0x0000, /* U+6c76 */
  0x0000, /* U+6c77 */
  0x0000, /* U+6c78 */
  0x0000, /* U+6c79 */
  0x8c88, /* U+6c7a */
  0x0000, /* U+6c7b */
  0x0000, /* U+6c7c */
  0x8b44, /* U+6c7d */
  0x9f90, /* U+6c7e */
  0x0000, /* U+6c7f */
  0x0000, /* U+6c80 */
  0x9f8e, /* U+6c81 */
  0x9f8b, /* U+6c82 */
  0x9780, /* U+6c83 */
  0x0000, /* U+6c84 */
  0x0000, /* U+6c85 */
  0xfaf7, /* U+6c86 */
  0x0000, /* U+6c87 */
  0x92be, /* U+6c88 */
  0x0000, /* U+6c89 */
  0x0000, /* U+6c8a */
  0x0000, /* U+6c8b */
  0x93d7, /* U+6c8c */
  0x9f8c, /* U+6c8d */
  0x0000, /* U+6c8e */
  0x0000, /* U+6c8f */
  0x9f94, /* U+6c90 */
  0x0000, /* U+6c91 */
  0x9f93, /* U+6c92 */
  0x8c42, /* U+6c93 */
  0x0000, /* U+6c94 */
  0x0000, /* U+6c95 */
  0x89ab, /* U+6c96 */
  0x0000, /* U+6c97 */
  0x0000, /* U+6c98 */
  0x8db9, /* U+6c99 */
  0x9f8d, /* U+6c9a */
  0x9f8f, /* U+6c9b */
  0x0000, /* U+6c9c */
  0x0000, /* U+6c9d */
  0x0000, /* U+6c9e */
  0x0000, /* U+6c9f */
  0x0000, /* U+6ca0 */
  0x9676, /* U+6ca1 */
  0x91f2, /* U+6ca2 */
  0x0000, /* U+6ca3 */
  0x0000, /* U+6ca4 */
  0x0000, /* U+6ca5 */
  0x0000, /* U+6ca6 */
  0x0000, /* U+6ca7 */
  0x0000, /* U+6ca8 */
  0x0000, /* U+6ca9 */
  0x0000, /* U+6caa */
  0x9697, /* U+6cab */
  0x0000, /* U+6cac */
  0x0000, /* U+6cad */
  0x9f9c, /* U+6cae */
  0x0000, /* U+6caf */
  0x0000, /* U+6cb0 */
  0x9f9d, /* U+6cb1 */
  0x0000, /* U+6cb2 */
  0x89cd, /* U+6cb3 */
  0x0000, /* U+6cb4 */
  0x0000, /* U+6cb5 */
  0x0000, /* U+6cb6 */
  0x0000, /* U+6cb7 */
  0x95a6, /* U+6cb8 */
  0x96fb, /* U+6cb9 */
  0x9f9f, /* U+6cba */
  0x8ea1, /* U+6cbb */
  0x8fc0, /* U+6cbc */
  0x9f98, /* U+6cbd */
  0x9f9e, /* U+6cbe */
  0x8988, /* U+6cbf */
  0x0000, /* U+6cc0 */
  0x8bb5, /* U+6cc1 */
  0x0000, /* U+6cc2 */
  0x0000, /* U+6cc3 */
  0x9f95, /* U+6cc4 */
  0x9f9a, /* U+6cc5 */
  0x0000, /* U+6cc6 */
  0x0000, /* U+6cc7 */
  0x0000, /* U+6cc8 */
  0x90f2, /* U+6cc9 */
  0x9491, /* U+6cca */
  0x0000, /* U+6ccb */
  0x94e5, /* U+6ccc */
  0x0000, /* U+6ccd */
  0x0000, /* U+6cce */
  0x0000, /* U+6ccf */
  0x0000, /* U+6cd0 */
  0x0000, /* U+6cd1 */
  0x0000, /* U+6cd2 */
  0x9f97, /* U+6cd3 */
  0x0000, /* U+6cd4 */
  0x9640, /* U+6cd5 */
  0x0000, /* U+6cd6 */
  0x9f99, /* U+6cd7 */
  0x0000, /* U+6cd8 */
  0x9fa2, /* U+6cd9 */
  0xfaf9, /* U+6cda */
  0x9fa0, /* U+6cdb */
  0x0000, /* U+6cdc */
  0x9f9b, /* U+6cdd */
  0x0000, /* U+6cde */
  0x0000, /* U+6cdf */
  0x0000, /* U+6ce0 */
  0x9641, /* U+6ce1 */
  0x9467, /* U+6ce2 */
  0x8b83, /* U+6ce3 */
  0x0000, /* U+6ce4 */
  0x9344, /* U+6ce5 */
  0x0000, /* U+6ce6 */
  0x0000, /* U+6ce7 */
  0x928d, /* U+6ce8 */
  0x0000, /* U+6ce9 */
  0x9fa3, /* U+6cea */
  0x0000, /* U+6ceb */
  0x0000, /* U+6cec */
  0x0000, /* U+6ced */
  0x0000, /* U+6cee */
  0x9fa1, /* U+6cef */
  0x91d7, /* U+6cf0 */
  0x9f96, /* U+6cf1 */
  0x0000, /* U+6cf2 */
  0x896a, /* U+6cf3 */
  0x0000, /* U+6cf4 */
  0x0000, /* U+6cf5 */
  0x0000, /* U+6cf6 */
  0x0000, /* U+6cf7 */
  0x0000, /* U+6cf8 */
  0x0000, /* U+6cf9 */
  0x0000, /* U+6cfa */
  0x0000, /* U+6cfb */
  0x0000, /* U+6cfc */
  0x0000, /* U+6cfd */
  0x0000, /* U+6cfe */
  0x0000, /* U+6cff */
  0x0000, /* U+6d00 */
  0x0000, /* U+6d01 */
  0x0000, /* U+6d02 */
  0x0000, /* U+6d03 */
  0xfafa, /* U+6d04 */
  0x0000, /* U+6d05 */
  0x0000, /* U+6d06 */
  0x0000, /* U+6d07 */
  0x0000, /* U+6d08 */
  0x0000, /* U+6d09 */
  0x0000, /* U+6d0a */
  0x976d, /* U+6d0b */
  0x9fae, /* U+6d0c */
  0x0000, /* U+6d0d */
  0x0000, /* U+6d0e */
  0x0000, /* U+6d0f */
  0x0000, /* U+6d10 */
  0x0000, /* U+6d11 */
  0x9fad, /* U+6d12 */
  0x0000, /* U+6d13 */
  0x0000, /* U+6d14 */
  0x0000, /* U+6d15 */
  0x0000, /* U+6d16 */
  0x90f4, /* U+6d17 */
  0x0000, /* U+6d18 */
  0x9faa, /* U+6d19 */
  0x0000, /* U+6d1a */
  0x978c, /* U+6d1b */
  0x0000, /* U+6d1c */
  0x0000, /* U+6d1d */
  0x93b4, /* U+6d1e */
  0x9fa4, /* U+6d1f */
  0x0000, /* U+6d20 */
  0x0000, /* U+6d21 */
  0x0000, /* U+6d22 */
  0x0000, /* U+6d23 */
  0x0000, /* U+6d24 */
  0x92c3, /* U+6d25 */
  0x0000, /* U+6d26 */
  0x0000, /* U+6d27 */
  0x0000, /* U+6d28 */
  0x896b, /* U+6d29 */
  0x8d5e, /* U+6d2a */
  0x9fa7, /* U+6d2b */
  0x0000, /* U+6d2c */
  0x0000, /* U+6d2d */
  0x0000, /* U+6d2e */
  0x0000, /* U+6d2f */
  0x0000, /* U+6d30 */
  0x0000, /* U+6d31 */
  0x8f46, /* U+6d32 */
  0x9fac, /* U+6d33 */
  0x0000, /* U+6d34 */
  0x9fab, /* U+6d35 */
  0x9fa6, /* U+6d36 */
  0x0000, /* U+6d37 */
  0x9fa9, /* U+6d38 */
  0x0000, /* U+6d39 */
  0x0000, /* U+6d3a */
  0x8a88, /* U+6d3b */
  0x0000, /* U+6d3c */
  0x9fa8, /* U+6d3d */
  0x9468, /* U+6d3e */
  0x0000, /* U+6d3f */
  0x0000, /* U+6d40 */
  0x97ac, /* U+6d41 */
  0x0000, /* U+6d42 */
  0x0000, /* U+6d43 */
  0x8ff2, /* U+6d44 */
  0x90f3, /* U+6d45 */
  0x0000, /* U+6d46 */
  0x0000, /* U+6d47 */
  0x0000, /* U+6d48 */
  0x0000, /* U+6d49 */
  0x0000, /* U+6d4a */
  0x0000, /* U+6d4b */
  0x0000, /* U+6d4c */
  0x0000, /* U+6d4d */
  0x0000, /* U+6d4e */
  0x0000, /* U+6d4f */
  0x0000, /* U+6d50 */
  0x0000, /* U+6d51 */
  0x0000, /* U+6d52 */
  0x0000, /* U+6d53 */
  0x0000, /* U+6d54 */
  0x0000, /* U+6d55 */
  0x0000, /* U+6d56 */
  0x0000, /* U+6d57 */
  0x0000, /* U+6d58 */
  0x9fb4, /* U+6d59 */
  0x9fb2, /* U+6d5a */
  0x0000, /* U+6d5b */
  0x956c, /* U+6d5c */
  0x0000, /* U+6d5d */
  0x0000, /* U+6d5e */
  0x0000, /* U+6d5f */
  0x0000, /* U+6d60 */
  0x0000, /* U+6d61 */
  0x0000, /* U+6d62 */
  0x9faf, /* U+6d63 */
  0x9fb1, /* U+6d64 */
  0x0000, /* U+6d65 */
  0x8959, /* U+6d66 */
  0x0000, /* U+6d67 */
  0x0000, /* U+6d68 */
  0x8d5f, /* U+6d69 */
  0x9851, /* U+6d6a */
  0x0000, /* U+6d6b */
  0x8a5c, /* U+6d6c */
  0x0000, /* U+6d6d */
  0x9582, /* U+6d6e */
  0xfafc, /* U+6d6f */
  0x0000, /* U+6d70 */
  0x0000, /* U+6d71 */
  0x0000, /* U+6d72 */
  0x0000, /* U+6d73 */
  0x9781, /* U+6d74 */
  0x0000, /* U+6d75 */
  0x0000, /* U+6d76 */
  0x8a43, /* U+6d77 */
  0x905a, /* U+6d78 */
  0x9fb3, /* U+6d79 */
  0x0000, /* U+6d7a */
  0x0000, /* U+6d7b */
  0x0000, /* U+6d7c */
  0x0000, /* U+6d7d */
  0x0000, /* U+6d7e */
  0x0000, /* U+6d7f */
  0x0000, /* U+6d80 */
  0x0000, /* U+6d81 */
  0x0000, /* U+6d82 */
  0x0000, /* U+6d83 */
  0x0000, /* U+6d84 */
  0x9fb8, /* U+6d85 */
  0x0000, /* U+6d86 */
  0xfafb, /* U+6d87 */
  0x8fc1, /* U+6d88 */
  0x0000, /* U+6d89 */
  0x0000, /* U+6d8a */
  0x0000, /* U+6d8b */
  0x974f, /* U+6d8c */
  0x0000, /* U+6d8d */
  0x9fb5, /* U+6d8e */
  0x0000, /* U+6d8f */
  0x0000, /* U+6d90 */
  0x0000, /* U+6d91 */
  0x0000, /* U+6d92 */
  0x9fb0, /* U+6d93 */
  0x0000, /* U+6d94 */
  0x9fb6, /* U+6d95 */
  0xfb40, /* U+6d96 */
  0x0000, /* U+6d97 */
  0x0000, /* U+6d98 */
  0x97dc, /* U+6d99 */
  0x0000, /* U+6d9a */
  0x9393, /* U+6d9b */
  0x93c0, /* U+6d9c */
  0x0000, /* U+6d9d */
  0x0000, /* U+6d9e */
  0x0000, /* U+6d9f */
  0x0000, /* U+6da0 */
  0x0000, /* U+6da1 */
  0x0000, /* U+6da2 */
  0x0000, /* U+6da3 */
  0x0000, /* U+6da4 */
  0x0000, /* U+6da5 */
  0x0000, /* U+6da6 */
  0x0000, /* U+6da7 */
  0x0000, /* U+6da8 */
  0x0000, /* U+6da9 */
  0x0000, /* U+6daa */
  0x0000, /* U+6dab */
  0xfb41, /* U+6dac */
  0x0000, /* U+6dad */
  0x0000, /* U+6dae */
  0x8a55, /* U+6daf */
  0x0000, /* U+6db0 */
  0x0000, /* U+6db1 */
  0x8974, /* U+6db2 */
  0x0000, /* U+6db3 */
  0x0000, /* U+6db4 */
  0x9fbc, /* U+6db5 */
  0x0000, /* U+6db6 */
  0x0000, /* U+6db7 */
  0x9fbf, /* U+6db8 */
  0x0000, /* U+6db9 */
  0x0000, /* U+6dba */
  0x0000, /* U+6dbb */
  0x97c1, /* U+6dbc */
  0x0000, /* U+6dbd */
  0x0000, /* U+6dbe */
  0x0000, /* U+6dbf */
  0x9784, /* U+6dc0 */
  0x0000, /* U+6dc1 */
  0x0000, /* U+6dc2 */
  0x0000, /* U+6dc3 */
  0x0000, /* U+6dc4 */
  0x9fc6, /* U+6dc5 */
  0x9fc0, /* U+6dc6 */
  0x9fbd, /* U+6dc7 */
  0x0000, /* U+6dc8 */
  0x0000, /* U+6dc9 */
  0x0000, /* U+6dca */
  0x97d2, /* U+6dcb */
  0x9fc3, /* U+6dcc */
  0x0000, /* U+6dcd */
  0x0000, /* U+6dce */
  0xfb42, /* U+6dcf */
  0x0000, /* U+6dd0 */
  0x8f69, /* U+6dd1 */
  0x9fc5, /* U+6dd2 */
  0x0000, /* U+6dd3 */
  0x0000, /* U+6dd4 */
  0x9fca, /* U+6dd5 */
  0x0000, /* U+6dd6 */
  0x0000, /* U+6dd7 */
  0x9391, /* U+6dd8 */
  0x9fc8, /* U+6dd9 */
  0x0000, /* U+6dda */
  0x0000, /* U+6ddb */
  0x0000, /* U+6ddc */
  0x0000, /* U+6ddd */
  0x9fc2, /* U+6dde */
  0x0000, /* U+6ddf */
  0x0000, /* U+6de0 */
  0x9257, /* U+6de1 */
  0x0000, /* U+6de2 */
  0x0000, /* U+6de3 */
  0x9fc9, /* U+6de4 */
  0x0000, /* U+6de5 */
  0x9fbe, /* U+6de6 */
  0x0000, /* U+6de7 */
  0x9fc4, /* U+6de8 */
  0x0000, /* U+6de9 */
  0x9fcb, /* U+6dea */
  0x88fa, /* U+6deb */
  0x9fc1, /* U+6dec */
  0x0000, /* U+6ded */
  0x9fcc, /* U+6dee */
  0x0000, /* U+6def */
  0x0000, /* U+6df0 */
  0x905b, /* U+6df1 */
  0xfb44, /* U+6df2 */
  0x8f7e, /* U+6df3 */
  0x0000, /* U+6df4 */
  0x95a3, /* U+6df5 */
  0x0000, /* U+6df6 */
  0x8dac, /* U+6df7 */
  0xfb43, /* U+6df8 */
  0x9fb9, /* U+6df9 */
  0x9fc7, /* U+6dfa */
  0x9359, /* U+6dfb */
  0xfb45, /* U+6dfc */
  0x0000, /* U+6dfd */
  0x0000, /* U+6dfe */
  0x0000, /* U+6dff */
  0x0000, /* U+6e00 */
  0x0000, /* U+6e01 */
  0x0000, /* U+6e02 */
  0x0000, /* U+6e03 */
  0x0000, /* U+6e04 */
  0x90b4, /* U+6e05 */
  0x0000, /* U+6e06 */
  0x8a89, /* U+6e07 */
  0x8dcf, /* U+6e08 */
  0x8fc2, /* U+6e09 */
  0x9fbb, /* U+6e0a */
  0x8f61, /* U+6e0b */
  0x0000, /* U+6e0c */
  0x0000, /* U+6e0d */
  0x0000, /* U+6e0e */
  0x0000, /* U+6e0f */
  0x0000, /* U+6e10 */
  0x0000, /* U+6e11 */
  0x0000, /* U+6e12 */
  0x8c6b, /* U+6e13 */
  0x0000, /* U+6e14 */
  0x9fba, /* U+6e15 */
  0x0000, /* U+6e16 */
  0x0000, /* U+6e17 */
  0x0000, /* U+6e18 */
  0x9fd0, /* U+6e19 */
  0x8f8d, /* U+6e1a */
  0x8cb8, /* U+6e1b */
  0x0000, /* U+6e1c */
  0x9fdf, /* U+6e1d */
  0x0000, /* U+6e1e */
  0x9fd9, /* U+6e1f */
  0x8b94, /* U+6e20 */
  0x936e, /* U+6e21 */
  0x0000, /* U+6e22 */
  0x9fd4, /* U+6e23 */
  0x9fdd, /* U+6e24 */
  0x88ad, /* U+6e25 */
  0x8951, /* U+6e26 */
  0xfb48, /* U+6e27 */
  0x0000, /* U+6e28 */
  0x89b7, /* U+6e29 */
  0x0000, /* U+6e2a */
  0x9fd6, /* U+6e2b */
  0x91aa, /* U+6e2c */
  0x9fcd, /* U+6e2d */
  0x9fcf, /* U+6e2e */
  0x8d60, /* U+6e2f */
  0x0000, /* U+6e30 */
  0x0000, /* U+6e31 */
  0x0000, /* U+6e32 */
  0x0000, /* U+6e33 */
  0x0000, /* U+6e34 */
  0x0000, /* U+6e35 */
  0x0000, /* U+6e36 */
  0x0000, /* U+6e37 */
  0x9fe0, /* U+6e38 */
  0xfb46, /* U+6e39 */
  0x9fdb, /* U+6e3a */
  0x0000, /* U+6e3b */
  0xfb49, /* U+6e3c */
  0x0000, /* U+6e3d */
  0x9fd3, /* U+6e3e */
  0x0000, /* U+6e3f */
  0x0000, /* U+6e40 */
  0x0000, /* U+6e41 */
  0x0000, /* U+6e42 */
  0x9fda, /* U+6e43 */
  0x0000, /* U+6e44 */
  0x0000, /* U+6e45 */
  0x0000, /* U+6e46 */
  0x0000, /* U+6e47 */
  0x0000, /* U+6e48 */
  0x0000, /* U+6e49 */
  0x96a9, /* U+6e4a */
  0x0000, /* U+6e4b */
  0x0000, /* U+6e4c */
  0x9fd8, /* U+6e4d */
  0x9fdc, /* U+6e4e */
  0x0000, /* U+6e4f */
  0x0000, /* U+6e50 */
  0x0000, /* U+6e51 */
  0x0000, /* U+6e52 */
  0x0000, /* U+6e53 */
  0x0000, /* U+6e54 */
  0x0000, /* U+6e55 */
  0x8cce, /* U+6e56 */
  0x0000, /* U+6e57 */
  0x8fc3, /* U+6e58 */
  0x0000, /* U+6e59 */
  0x0000, /* U+6e5a */
  0x9258, /* U+6e5b */
  0xfb47, /* U+6e5c */
  0x0000, /* U+6e5d */
  0x0000, /* U+6e5e */
  0x9fd2, /* U+6e5f */
  0x0000, /* U+6e60 */
  0x0000, /* U+6e61 */
  0x0000, /* U+6e62 */
  0x0000, /* U+6e63 */
  0x0000, /* U+6e64 */
  0x0000, /* U+6e65 */
  0x0000, /* U+6e66 */
  0x974e, /* U+6e67 */
  0x0000, /* U+6e68 */
  0x0000, /* U+6e69 */
  0x0000, /* U+6e6a */
  0x9fd5, /* U+6e6b */
  0x0000, /* U+6e6c */
  0x0000, /* U+6e6d */
  0x9fce, /* U+6e6e */
  0x9392, /* U+6e6f */
  0x0000, /* U+6e70 */
  0x0000, /* U+6e71 */
  0x9fd1, /* U+6e72 */
  0x0000, /* U+6e73 */
  0x0000, /* U+6e74 */
  0x0000, /* U+6e75 */
  0x9fd7, /* U+6e76 */
  0x0000, /* U+6e77 */
  0x0000, /* U+6e78 */
  0x0000, /* U+6e79 */
  0x0000, /* U+6e7a */
  0x0000, /* U+6e7b */
  0x0000, /* U+6e7c */
  0x0000, /* U+6e7d */
  0x9870, /* U+6e7e */
  0x8ebc, /* U+6e7f */
  0x969e, /* U+6e80 */
  0x0000, /* U+6e81 */
  0x9fe1, /* U+6e82 */
  0x0000, /* U+6e83 */
  0x0000, /* U+6e84 */
  0x0000, /* U+6e85 */
  0x0000, /* U+6e86 */
  0x0000, /* U+6e87 */
  0x0000, /* U+6e88 */
  0x0000, /* U+6e89 */
  0x0000, /* U+6e8a */
  0x0000, /* U+6e8b */
  0x94ac, /* U+6e8c */
  0x0000, /* U+6e8d */
  0x0000, /* U+6e8e */
  0x9fed, /* U+6e8f */
  0x8cb9, /* U+6e90 */
  0x0000, /* U+6e91 */
  0x0000, /* U+6e92 */
  0x0000, /* U+6e93 */
  0x0000, /* U+6e94 */
  0x0000, /* U+6e95 */
  0x8f80, /* U+6e96 */
  0x0000, /* U+6e97 */
  0x9fe3, /* U+6e98 */
  0x0000, /* U+6e99 */
  0x0000, /* U+6e9a */
  0x0000, /* U+6e9b */
  0x97ad, /* U+6e9c */
  0x8d61, /* U+6e9d */
  0x0000, /* U+6e9e */
  0x9ff0, /* U+6e9f */
  0x0000, /* U+6ea0 */
  0x0000, /* U+6ea1 */
  0x88ec, /* U+6ea2 */
  0x0000, /* U+6ea3 */
  0x0000, /* U+6ea4 */
  0x9fee, /* U+6ea5 */
  0x0000, /* U+6ea6 */
  0x0000, /* U+6ea7 */
  0x0000, /* U+6ea8 */
  0x0000, /* U+6ea9 */
  0x9fe2, /* U+6eaa */
  0x0000, /* U+6eab */
  0x0000, /* U+6eac */
  0x0000, /* U+6ead */
  0x0000, /* U+6eae */
  0x9fe8, /* U+6eaf */
  0x0000, /* U+6eb0 */
  0x0000, /* U+6eb1 */
  0x9fea, /* U+6eb2 */
  0x0000, /* U+6eb3 */
  0x0000, /* U+6eb4 */
  0x0000, /* U+6eb5 */
  0x976e, /* U+6eb6 */
  0x9fe5, /* U+6eb7 */
  0x0000, /* U+6eb8 */
  0x0000, /* U+6eb9 */
  0x934d, /* U+6eba */
  0x0000, /* U+6ebb */
  0x0000, /* U+6ebc */
  0x9fe7, /* U+6ebd */
  0x0000, /* U+6ebe */
  0xfb4a, /* U+6ebf */
  0x0000, /* U+6ec0 */
  0x0000, /* U+6ec1 */
  0x9fef, /* U+6ec2 */
  0x0000, /* U+6ec3 */
  0x9fe9, /* U+6ec4 */
  0x96c5, /* U+6ec5 */
  0x0000, /* U+6ec6 */
  0x0000, /* U+6ec7 */
  0x0000, /* U+6ec8 */
  0x9fe4, /* U+6ec9 */
  0x0000, /* U+6eca */
  0x8ea0, /* U+6ecb */
  0x9ffc, /* U+6ecc */
  0x0000, /* U+6ecd */
  0x0000, /* U+6ece */
  0x0000, /* U+6ecf */
  0x0000, /* U+6ed0 */
  0x8a8a, /* U+6ed1 */
  0x0000, /* U+6ed2 */
  0x9fe6, /* U+6ed3 */
  0x9feb, /* U+6ed4 */
  0x9fec, /* U+6ed5 */
  0x0000, /* U+6ed6 */
  0x0000, /* U+6ed7 */
  0x0000, /* U+6ed8 */
  0x0000, /* U+6ed9 */
  0x0000, /* U+6eda */
  0x0000, /* U+6edb */
  0x0000, /* U+6edc */
  0x91ea, /* U+6edd */
  0x91d8, /* U+6ede */
  0x0000, /* U+6edf */
  0x0000, /* U+6ee0 */
  0x0000, /* U+6ee1 */
  0x0000, /* U+6ee2 */
  0x0000, /* U+6ee3 */
  0x0000, /* U+6ee4 */
  0x0000, /* U+6ee5 */
  0x0000, /* U+6ee6 */
  0x0000, /* U+6ee7 */
  0x0000, /* U+6ee8 */
  0x0000, /* U+6ee9 */
  0x0000, /* U+6eea */
  0x0000, /* U+6eeb */
  0x9ff4, /* U+6eec */
  0x0000, /* U+6eed */
  0x0000, /* U+6eee */
  0x9ffa, /* U+6eef */
  0x0000, /* U+6ef0 */
  0x0000, /* U+6ef1 */
  0x9ff8, /* U+6ef2 */
  0x0000, /* U+6ef3 */
  0x9348, /* U+6ef4 */
  0x0000, /* U+6ef5 */
  0x0000, /* U+6ef6 */
  0xe042, /* U+6ef7 */
  0x9ff5, /* U+6ef8 */
  0x0000, /* U+6ef9 */
  0x0000, /* U+6efa */
  0x0000, /* U+6efb */
  0x0000, /* U+6efc */
  0x0000, /* U+6efd */
  0x9ff6, /* U+6efe */
  0x9fde, /* U+6eff */
  0x0000, /* U+6f00 */
  0x8b99, /* U+6f01 */
  0x9559, /* U+6f02 */
  0x0000, /* U+6f03 */
  0x0000, /* U+6f04 */
  0x0000, /* U+6f05 */
  0x8ebd, /* U+6f06 */
  0x0000, /* U+6f07 */
  0x0000, /* U+6f08 */
  0x8d97, /* U+6f09 */
  0x0000, /* U+6f0a */
  0x0000, /* U+6f0b */
  0x0000, /* U+6f0c */
  0x0000, /* U+6f0d */
  0x0000, /* U+6f0e */
  0x9852, /* U+6f0f */
  0x0000, /* U+6f10 */
  0x9ff2, /* U+6f11 */
  0x0000, /* U+6f12 */
  0xe041, /* U+6f13 */
  0x8989, /* U+6f14 */
  0x9186, /* U+6f15 */
  0x0000, /* U+6f16 */
  0x0000, /* U+6f17 */
  0x0000, /* U+6f18 */
  0x0000, /* U+6f19 */
  0x0000, /* U+6f1a */
  0x0000, /* U+6f1b */
  0x0000, /* U+6f1c */
  0x0000, /* U+6f1d */
  0x0000, /* U+6f1e */
  0x0000, /* U+6f1f */
  0x9499, /* U+6f20 */
  0x0000, /* U+6f21 */
  0x8abf, /* U+6f22 */
  0x97f8, /* U+6f23 */
  0x0000, /* U+6f24 */
  0x0000, /* U+6f25 */
  0x0000, /* U+6f26 */
  0x0000, /* U+6f27 */
  0x0000, /* U+6f28 */
  0x0000, /* U+6f29 */
  0x0000, /* U+6f2a */
  0x969f, /* U+6f2b */
  0x92d0, /* U+6f2c */
  0x0000, /* U+6f2d */
  0x0000, /* U+6f2e */
  0x0000, /* U+6f2f */
  0x0000, /* U+6f30 */
  0x9ff9, /* U+6f31 */
  0x9ffb, /* U+6f32 */
  0x0000, /* U+6f33 */
  0x0000, /* U+6f34 */
  0x0000, /* U+6f35 */
  0x0000, /* U+6f36 */
  0x0000, /* U+6f37 */
  0x9151, /* U+6f38 */
  0x0000, /* U+6f39 */
  0x0000, /* U+6f3a */
  0x0000, /* U+6f3b */
  0x0000, /* U+6f3c */
  0x0000, /* U+6f3d */
  0xe040, /* U+6f3e */
  0x9ff7, /* U+6f3f */
  0x0000, /* U+6f40 */
  0x9ff1, /* U+6f41 */
  0x0000, /* U+6f42 */
  0x0000, /* U+6f43 */
  0x0000, /* U+6f44 */
  0x8ac1, /* U+6f45 */
  0x0000, /* U+6f46 */
  0x0000, /* U+6f47 */
  0x0000, /* U+6f48 */
  0x0000, /* U+6f49 */
  0x0000, /* U+6f4a */
  0x0000, /* U+6f4b */
  0x0000, /* U+6f4c */
  0x0000, /* U+6f4d */
  0x0000, /* U+6f4e */
  0x0000, /* U+6f4f */
  0x0000, /* U+6f50 */
  0x0000, /* U+6f51 */
  0x0000, /* U+6f52 */
  0x0000, /* U+6f53 */
  0x8c89, /* U+6f54 */
  0x0000, /* U+6f55 */
  0x0000, /* U+6f56 */
  0x0000, /* U+6f57 */
  0xe04e, /* U+6f58 */
  0x0000, /* U+6f59 */
  0x0000, /* U+6f5a */
  0xe049, /* U+6f5b */
  0x90f6, /* U+6f5c */
  0x0000, /* U+6f5d */
  0x0000, /* U+6f5e */
  0x8a83, /* U+6f5f */
  0x0000, /* U+6f60 */
  0x0000, /* U+6f61 */
  0x0000, /* U+6f62 */
  0x0000, /* U+6f63 */
  0x8f81, /* U+6f64 */
  0x0000, /* U+6f65 */
  0xe052, /* U+6f66 */
  0x0000, /* U+6f67 */
  0x0000, /* U+6f68 */
  0x0000, /* U+6f69 */
  0x0000, /* U+6f6a */
  0x0000, /* U+6f6b */
  0x0000, /* U+6f6c */
  0xe04b, /* U+6f6d */
  0x92aa, /* U+6f6e */
  0xe048, /* U+6f6f */
  0x92d7, /* U+6f70 */
  0x0000, /* U+6f71 */
  0x0000, /* U+6f72 */
  0x0000, /* U+6f73 */
  0xe06b, /* U+6f74 */
  0x0000, /* U+6f75 */
  0x0000, /* U+6f76 */
  0x0000, /* U+6f77 */
  0xe045, /* U+6f78 */
  0x0000, /* U+6f79 */
  0xe044, /* U+6f7a */
  0x0000, /* U+6f7b */
  0xe04d, /* U+6f7c */
  0x0000, /* U+6f7d */
  0x0000, /* U+6f7e */
  0x0000, /* U+6f7f */
  0xe047, /* U+6f80 */
  0xe046, /* U+6f81 */
  0xe04c, /* U+6f82 */
  0x0000, /* U+6f83 */
  0x909f, /* U+6f84 */
  0x0000, /* U+6f85 */
  0xe043, /* U+6f86 */
  0x0000, /* U+6f87 */
  0xfb4b, /* U+6f88 */
  0x0000, /* U+6f89 */
  0x0000, /* U+6f8a */
  0x0000, /* U+6f8b */
  0x0000, /* U+6f8c */
  0x0000, /* U+6f8d */
  0xe04f, /* U+6f8e */
  0x0000, /* U+6f8f */
  0x0000, /* U+6f90 */
  0xe050, /* U+6f91 */
  0x0000, /* U+6f92 */
  0x0000, /* U+6f93 */
  0x0000, /* U+6f94 */
  0x0000, /* U+6f95 */
  0x0000, /* U+6f96 */
  0x8ac0, /* U+6f97 */
  0x0000, /* U+6f98 */
  0x0000, /* U+6f99 */
  0x0000, /* U+6f9a */
  0x0000, /* U+6f9b */
  0x0000, /* U+6f9c */
  0x0000, /* U+6f9d */
  0x0000, /* U+6f9e */
  0x0000, /* U+6f9f */
  0x0000, /* U+6fa0 */
  0xe055, /* U+6fa1 */
  0x0000, /* U+6fa2 */
  0xe054, /* U+6fa3 */
  0xe056, /* U+6fa4 */
  0x0000, /* U+6fa5 */
  0x0000, /* U+6fa6 */
  0x0000, /* U+6fa7 */
  0x0000, /* U+6fa8 */
  0x0000, /* U+6fa9 */
  0xe059, /* U+6faa */
  0x0000, /* U+6fab */
  0x0000, /* U+6fac */
  0x0000, /* U+6fad */
  0x0000, /* U+6fae */
  0x0000, /* U+6faf */
  0x0000, /* U+6fb0 */
  0x9362, /* U+6fb1 */
  0x0000, /* U+6fb2 */
  0xe053, /* U+6fb3 */
  0x0000, /* U+6fb4 */
  0xfb4c, /* U+6fb5 */
  0x0000, /* U+6fb6 */
  0x0000, /* U+6fb7 */
  0x0000, /* U+6fb8 */
  0xe057, /* U+6fb9 */
  0x0000, /* U+6fba */
  0x0000, /* U+6fbb */
  0x0000, /* U+6fbc */
  0x0000, /* U+6fbd */
  0x0000, /* U+6fbe */
  0x0000, /* U+6fbf */
  0x8c83, /* U+6fc0 */
  0x91f7, /* U+6fc1 */
  0xe051, /* U+6fc2 */
  0x945a, /* U+6fc3 */
  0x0000, /* U+6fc4 */
  0x0000, /* U+6fc5 */
  0xe058, /* U+6fc6 */
  0x0000, /* U+6fc7 */
  0x0000, /* U+6fc8 */
  0x0000, /* U+6fc9 */
  0x0000, /* U+6fca */
  0x0000, /* U+6fcb */
  0x0000, /* U+6fcc */
  0x0000, /* U+6fcd */
  0x0000, /* U+6fce */
  0x0000, /* U+6fcf */
  0x0000, /* U+6fd0 */
  0x0000, /* U+6fd1 */
  0x0000, /* U+6fd2 */
  0x0000, /* U+6fd3 */
  0xe05d, /* U+6fd4 */
  0xe05b, /* U+6fd5 */
  0x0000, /* U+6fd6 */
  0x0000, /* U+6fd7 */
  0xe05e, /* U+6fd8 */
  0x0000, /* U+6fd9 */
  0x0000, /* U+6fda */
  0xe061, /* U+6fdb */
  0x0000, /* U+6fdc */
  0x0000, /* U+6fdd */
  0x0000, /* U+6fde */
  0xe05a, /* U+6fdf */
  0x8d8a, /* U+6fe0 */
  0x9447, /* U+6fe1 */
  0x0000, /* U+6fe2 */
  0x0000, /* U+6fe3 */
  0x9fb7, /* U+6fe4 */
  0x0000, /* U+6fe5 */
  0x0000, /* U+6fe6 */
  0x0000, /* U+6fe7 */
  0x0000, /* U+6fe8 */
  0x0000, /* U+6fe9 */
  0x0000, /* U+6fea */
  0x9794, /* U+6feb */
  0xe05c, /* U+6fec */
  0x0000, /* U+6fed */
  0xe060, /* U+6fee */
  0x91f3, /* U+6fef */
  0x0000, /* U+6ff0 */
  0xe05f, /* U+6ff1 */
  0x0000, /* U+6ff2 */
  0xe04a, /* U+6ff3 */
  0x0000, /* U+6ff4 */
  0xfb4d, /* U+6ff5 */
  0xe889, /* U+6ff6 */
  0x0000, /* U+6ff7 */
  0x0000, /* U+6ff8 */
  0x0000, /* U+6ff9 */
  0xe064, /* U+6ffa */
  0x0000, /* U+6ffb */
  0x0000, /* U+6ffc */
  0x0000, /* U+6ffd */
  0xe068, /* U+6ffe */
  0x0000, /* U+6fff */
  0x0000, /* U+7000 */
  0xe066, /* U+7001 */
  0x0000, /* U+7002 */
  0x0000, /* U+7003 */
  0x0000, /* U+7004 */
  0xfb4e, /* U+7005 */
  0x0000, /* U+7006 */
  0xfb4f, /* U+7007 */
  0x0000, /* U+7008 */
  0xe062, /* U+7009 */
  0x0000, /* U+700a */
  0xe063, /* U+700b */
  0x0000, /* U+700c */
  0x0000, /* U+700d */
  0x0000, /* U+700e */
  0xe067, /* U+700f */
  0x0000, /* U+7010 */
  0xe065, /* U+7011 */
  0x0000, /* U+7012 */
  0x0000, /* U+7013 */
  0x0000, /* U+7014 */
  0x956d, /* U+7015 */
  0x0000, /* U+7016 */
  0x0000, /* U+7017 */
  0xe06d, /* U+7018 */
  0x0000, /* U+7019 */
  0xe06a, /* U+701a */
  0xe069, /* U+701b */
  0x0000, /* U+701c */
  0xe06c, /* U+701d */
  0x93d2, /* U+701e */
  0xe06e, /* U+701f */
  0x0000, /* U+7020 */
  0x0000, /* U+7021 */
  0x0000, /* U+7022 */
  0x0000, /* U+7023 */
  0x0000, /* U+7024 */
  0x0000, /* U+7025 */
  0x9295, /* U+7026 */
  0x91eb, /* U+7027 */
  0xfb50, /* U+7028 */
  0x0000, /* U+7029 */
  0x0000, /* U+702a */
  0x0000, /* U+702b */
  0x90a3, /* U+702c */
  0x0000, /* U+702d */
  0x0000, /* U+702e */
  0x0000, /* U+702f */
  0xe06f, /* U+7030 */
  0x0000, /* U+7031 */
  0xe071, /* U+7032 */
  0x0000, /* U+7033 */
  0x0000, /* U+7034 */
  0x0000, /* U+7035 */
  0x0000, /* U+7036 */
  0x0000, /* U+7037 */
  0x0000, /* U+7038 */
  0x0000, /* U+7039 */
  0x0000, /* U+703a */
  0x0000, /* U+703b */
  0x0000, /* U+703c */
  0x0000, /* U+703d */
  0xe070, /* U+703e */
  0x0000, /* U+703f */
  0x0000, /* U+7040 */
  0x0000, /* U+7041 */
  0x0000, /* U+7042 */
  0x0000, /* U+7043 */
  0x0000, /* U+7044 */
  0x0000, /* U+7045 */
  0x0000, /* U+7046 */
  0x0000, /* U+7047 */
  0x0000, /* U+7048 */
  0x0000, /* U+7049 */
  0x0000, /* U+704a */
  0x0000, /* U+704b */
  0x9ff3, /* U+704c */
  0x0000, /* U+704d */
  0x0000, /* U+704e */
  0x0000, /* U+704f */
  0x0000, /* U+7050 */
  0xe072, /* U+7051 */
  0x0000, /* U+7052 */
  0x0000, /* U+7053 */
  0x0000, /* U+7054 */
  0x0000, /* U+7055 */
  0x0000, /* U+7056 */
  0x0000, /* U+7057 */
  0x93e5, /* U+7058 */
  0x0000, /* U+7059 */
  0x0000, /* U+705a */
  0x0000, /* U+705b */
  0x0000, /* U+705c */
  0x0000, /* U+705d */
  0x0000, /* U+705e */
  0x0000, /* U+705f */
  0x0000, /* U+7060 */
  0x0000, /* U+7061 */
  0x0000, /* U+7062 */
  0xe073, /* U+7063 */
  0x0000, /* U+7064 */
  0x0000, /* U+7065 */
  0x0000, /* U+7066 */
  0x0000, /* U+7067 */
  0x0000, /* U+7068 */
  0x0000, /* U+7069 */
  0x0000, /* U+706a */
  0x89ce, /* U+706b */
  0x0000, /* U+706c */
  0x0000, /* U+706d */
  0x0000, /* U+706e */
  0x9394, /* U+706f */
  0x8a44, /* U+7070 */
  0x0000, /* U+7071 */
  0x0000, /* U+7072 */
  0x0000, /* U+7073 */
  0x0000, /* U+7074 */
  0x0000, /* U+7075 */
  0x0000, /* U+7076 */
  0x0000, /* U+7077 */
  0x8b84, /* U+7078 */
  0x0000, /* U+7079 */
  0x0000, /* U+707a */
  0x0000, /* U+707b */
  0x8edc, /* U+707c */
  0x8dd0, /* U+707d */
  0x0000, /* U+707e */
  0x0000, /* U+707f */
  0x0000, /* U+7080 */
  0x0000, /* U+7081 */
  0x0000, /* U+7082 */
  0x0000, /* U+7083 */
  0x0000, /* U+7084 */
  0xfb51, /* U+7085 */
  0x0000, /* U+7086 */
  0x0000, /* U+7087 */
  0x0000, /* U+7088 */
  0x9846, /* U+7089 */
  0x9086, /* U+708a */
  0x0000, /* U+708b */
  0x0000, /* U+708c */
  0x0000, /* U+708d */
  0x898a, /* U+708e */
  0x0000, /* U+708f */
  0x0000, /* U+7090 */
  0x0000, /* U+7091 */
  0xe075, /* U+7092 */
  0x0000, /* U+7093 */
  0x0000, /* U+7094 */
  0x0000, /* U+7095 */
  0x0000, /* U+7096 */
  0x0000, /* U+7097 */
  0x0000, /* U+7098 */
  0xe074, /* U+7099 */
  0x0000, /* U+709a */
  0x0000, /* U+709b */
  0x0000, /* U+709c */
  0x0000, /* U+709d */
  0x0000, /* U+709e */
  0x0000, /* U+709f */
  0x0000, /* U+70a0 */
  0x0000, /* U+70a1 */
  0x0000, /* U+70a2 */
  0x0000, /* U+70a3 */
  0x0000, /* U+70a4 */
  0x0000, /* U+70a5 */
  0x0000, /* U+70a6 */
  0x0000, /* U+70a7 */
  0x0000, /* U+70a8 */
  0x0000, /* U+70a9 */
  0x0000, /* U+70aa */
  0xfb52, /* U+70ab */
  0xe078, /* U+70ac */
  0x9259, /* U+70ad */
  0xe07b, /* U+70ae */
  0xe076, /* U+70af */
  0x0000, /* U+70b0 */
  0x0000, /* U+70b1 */
  0x0000, /* U+70b2 */
  0xe07a, /* U+70b3 */
  0x0000, /* U+70b4 */
  0x0000, /* U+70b5 */
  0x0000, /* U+70b6 */
  0x0000, /* U+70b7 */
  0xe079, /* U+70b8 */
  0x935f, /* U+70b9 */
  0x88d7, /* U+70ba */
  0xfa62, /* U+70bb */
  0x0000, /* U+70bc */
  0x0000, /* U+70bd */
  0x0000, /* U+70be */
  0x0000, /* U+70bf */
  0x0000, /* U+70c0 */
  0x0000, /* U+70c1 */
  0x0000, /* U+70c2 */
  0x0000, /* U+70c3 */
  0x0000, /* U+70c4 */
  0x0000, /* U+70c5 */
  0x0000, /* U+70c6 */
  0x0000, /* U+70c7 */
  0x97f3, /* U+70c8 */
  0x0000, /* U+70c9 */
  0x0000, /* U+70ca */
  0xe07d, /* U+70cb */
  0x0000, /* U+70cc */
  0x0000, /* U+70cd */
  0x0000, /* U+70ce */
  0x8947, /* U+70cf */
  0x0000, /* U+70d0 */
  0x0000, /* U+70d1 */
  0x0000, /* U+70d2 */
  0x0000, /* U+70d3 */
  0x0000, /* U+70d4 */
  0x0000, /* U+70d5 */
  0x0000, /* U+70d6 */
  0x0000, /* U+70d7 */
  0x0000, /* U+70d8 */
  0xe080, /* U+70d9 */
  0x0000, /* U+70da */
  0x0000, /* U+70db */
  0x0000, /* U+70dc */
  0xe07e, /* U+70dd */
  0x0000, /* U+70de */
  0xe07c, /* U+70df */
  0x0000, /* U+70e0 */
  0x0000, /* U+70e1 */
  0x0000, /* U+70e2 */
  0x0000, /* U+70e3 */
  0x0000, /* U+70e4 */
  0x0000, /* U+70e5 */
  0x0000, /* U+70e6 */
  0x0000, /* U+70e7 */
  0x0000, /* U+70e8 */
  0x0000, /* U+70e9 */
  0x0000, /* U+70ea */
  0x0000, /* U+70eb */
  0x0000, /* U+70ec */
  0x0000, /* U+70ed */
  0x0000, /* U+70ee */
  0x0000, /* U+70ef */
  0x0000, /* U+70f0 */
  0xe077, /* U+70f1 */
  0x0000, /* U+70f2 */
  0x0000, /* U+70f3 */
  0x0000, /* U+70f4 */
  0x0000, /* U+70f5 */
  0x0000, /* U+70f6 */
  0x0000, /* U+70f7 */
  0x0000, /* U+70f8 */
  0x9642, /* U+70f9 */
  0x0000, /* U+70fa */
  0x0000, /* U+70fb */
  0x0000, /* U+70fc */
  0xe082, /* U+70fd */
  0x0000, /* U+70fe */
  0x0000, /* U+70ff */
  0x0000, /* U+7100 */
  0x0000, /* U+7101 */
  0x0000, /* U+7102 */
  0x0000, /* U+7103 */
  0xfb54, /* U+7104 */
  0x0000, /* U+7105 */
  0x0000, /* U+7106 */
  0x0000, /* U+7107 */
  0x0000, /* U+7108 */
  0xe081, /* U+7109 */
  0x0000, /* U+710a */
  0x0000, /* U+710b */
  0x0000, /* U+710c */
  0x0000, /* U+710d */
  0x0000, /* U+710e */
  0xfb53, /* U+710f */
  0x0000, /* U+7110 */
  0x0000, /* U+7111 */
  0x0000, /* U+7112 */
  0x0000, /* U+7113 */
  0x898b, /* U+7114 */
  0x0000, /* U+7115 */
  0x0000, /* U+7116 */
  0x0000, /* U+7117 */
  0x0000, /* U+7118 */
  0xe084, /* U+7119 */
  0x95b0, /* U+711a */
  0x0000, /* U+711b */
  0xe083, /* U+711c */
  0x0000, /* U+711d */
  0x0000, /* U+711e */
  0x0000, /* U+711f */
  0x0000, /* U+7120 */
  0x96b3, /* U+7121 */
  0x0000, /* U+7122 */
  0x0000, /* U+7123 */
  0x0000, /* U+7124 */
  0x0000, /* U+7125 */
  0x8fc5, /* U+7126 */
  0x0000, /* U+7127 */
  0x0000, /* U+7128 */
  0x0000, /* U+7129 */
  0x0000, /* U+712a */
  0x0000, /* U+712b */
  0x0000, /* U+712c */
  0x0000, /* U+712d */
  0x0000, /* U+712e */
  0x0000, /* U+712f */
  0x0000, /* U+7130 */
  0x0000, /* U+7131 */
  0x0000, /* U+7132 */
  0x0000, /* U+7133 */
  0x0000, /* U+7134 */
  0x0000, /* U+7135 */
  0x9152, /* U+7136 */
  0x0000, /* U+7137 */
  0x0000, /* U+7138 */
  0x0000, /* U+7139 */
  0x0000, /* U+713a */
  0x0000, /* U+713b */
  0x8fc4, /* U+713c */
  0x0000, /* U+713d */
  0x0000, /* U+713e */
  0x0000, /* U+713f */
  0x0000, /* U+7140 */
  0x0000, /* U+7141 */
  0x0000, /* U+7142 */
  0x0000, /* U+7143 */
  0x0000, /* U+7144 */
  0x0000, /* U+7145 */
  0xfb56, /* U+7146 */
  0xfb57, /* U+7147 */
  0x0000, /* U+7148 */
  0x97f9, /* U+7149 */
  0x0000, /* U+714a */
  0x0000, /* U+714b */
  0xe08a, /* U+714c */
  0x0000, /* U+714d */
  0x90f7, /* U+714e */
  0x0000, /* U+714f */
  0x0000, /* U+7150 */
  0x0000, /* U+7151 */
  0x0000, /* U+7152 */
  0x0000, /* U+7153 */
  0x0000, /* U+7154 */
  0xe086, /* U+7155 */
  0xe08b, /* U+7156 */
  0x0000, /* U+7157 */
  0x0000, /* U+7158 */
  0x898c, /* U+7159 */
  0x0000, /* U+715a */
  0x0000, /* U+715b */
  0xfb55, /* U+715c */
  0x0000, /* U+715d */
  0x0000, /* U+715e */
  0x0000, /* U+715f */
  0x0000, /* U+7160 */
  0x0000, /* U+7161 */
  0xe089, /* U+7162 */
  0x0000, /* U+7163 */
  0x9481, /* U+7164 */
  0xe085, /* U+7165 */
  0xe088, /* U+7166 */
  0x8fc6, /* U+7167 */
  0x0000, /* U+7168 */
  0x94cf, /* U+7169 */
  0x0000, /* U+716a */
  0x0000, /* U+716b */
  0xe08c, /* U+716c */
  0x0000, /* U+716d */
  0x8ecf, /* U+716e */
  0x0000, /* U+716f */
  0x0000, /* U+7170 */
  0x0000, /* U+7171 */
  0x0000, /* U+7172 */
  0x0000, /* U+7173 */
  0x0000, /* U+7174 */
  0x0000, /* U+7175 */
  0x0000, /* U+7176 */
  0x0000, /* U+7177 */
  0x0000, /* U+7178 */
  0x0000, /* U+7179 */
  0x0000, /* U+717a */
  0x0000, /* U+717b */
  0x0000, /* U+717c */
  0x90f8, /* U+717d */
  0x0000, /* U+717e */
  0x0000, /* U+717f */
  0x0000, /* U+7180 */
  0x0000, /* U+7181 */
  0x0000, /* U+7182 */
  0x0000, /* U+7183 */
  0xe08f, /* U+7184 */
  0x0000, /* U+7185 */
  0x0000, /* U+7186 */
  0x0000, /* U+7187 */
  0xe087, /* U+7188 */
  0x0000, /* U+7189 */
  0x8c46, /* U+718a */
  0x0000, /* U+718b */
  0x0000, /* U+718c */
  0x0000, /* U+718d */
  0x0000, /* U+718e */
  0xe08d, /* U+718f */
  0x0000, /* U+7190 */
  0x0000, /* U+7191 */
  0x0000, /* U+7192 */
  0x0000, /* U+7193 */
  0x976f, /* U+7194 */
  0xe090, /* U+7195 */
  0x0000, /* U+7196 */
  0x0000, /* U+7197 */
  0x0000, /* U+7198 */
  0xeaa4, /* U+7199 */
  0x0000, /* U+719a */
  0x0000, /* U+719b */
  0x0000, /* U+719c */
  0x0000, /* U+719d */
  0x0000, /* U+719e */
  0x8f6e, /* U+719f */
  0x0000, /* U+71a0 */
  0x0000, /* U+71a1 */
  0x0000, /* U+71a2 */
  0x0000, /* U+71a3 */
  0x0000, /* U+71a4 */
  0x0000, /* U+71a5 */
  0x0000, /* U+71a6 */
  0x0000, /* U+71a7 */
  0xe091, /* U+71a8 */
  0x0000, /* U+71a9 */
  0x0000, /* U+71aa */
  0x0000, /* U+71ab */
  0xe092, /* U+71ac */
  0x0000, /* U+71ad */
  0x0000, /* U+71ae */
  0x0000, /* U+71af */
  0x0000, /* U+71b0 */
  0x944d, /* U+71b1 */
  0x0000, /* U+71b2 */
  0x0000, /* U+71b3 */
  0x0000, /* U+71b4 */
  0x0000, /* U+71b5 */
  0x0000, /* U+71b6 */
  0x0000, /* U+71b7 */
  0x0000, /* U+71b8 */
  0xe094, /* U+71b9 */
  0x0000, /* U+71ba */
  0x0000, /* U+71bb */
  0x0000, /* U+71bc */
  0x0000, /* U+71bd */
  0xe095, /* U+71be */
  0x0000, /* U+71bf */
  0x0000, /* U+71c0 */
  0xfb59, /* U+71c1 */
  0x0000, /* U+71c2 */
  0x9452, /* U+71c3 */
  0x0000, /* U+71c4 */
  0x0000, /* U+71c5 */
  0x0000, /* U+71c6 */
  0x0000, /* U+71c7 */
  0x9395, /* U+71c8 */
  0xe097, /* U+71c9 */
  0x0000, /* U+71ca */
  0x0000, /* U+71cb */
  0x0000, /* U+71cc */
  0x0000, /* U+71cd */
  0xe099, /* U+71ce */
  0x0000, /* U+71cf */
  0x97d3, /* U+71d0 */
  0x0000, /* U+71d1 */
  0xe096, /* U+71d2 */
  0x0000, /* U+71d3 */
  0xe098, /* U+71d4 */
  0x898d, /* U+71d5 */
  0x0000, /* U+71d6 */
  0xe093, /* U+71d7 */
  0x0000, /* U+71d8 */
  0x0000, /* U+71d9 */
  0x0000, /* U+71da */
  0x0000, /* U+71db */
  0x0000, /* U+71dc */
  0x0000, /* U+71dd */
  0x0000, /* U+71de */
  0x9a7a, /* U+71df */
  0xe09a, /* U+71e0 */
  0x0000, /* U+71e1 */
  0x0000, /* U+71e2 */
  0x0000, /* U+71e3 */
  0x0000, /* U+71e4 */
  0x9187, /* U+71e5 */
  0x8e57, /* U+71e6 */
  0xe09c, /* U+71e7 */
  0x0000, /* U+71e8 */
  0x0000, /* U+71e9 */
  0x0000, /* U+71ea */
  0x0000, /* U+71eb */
  0xe09b, /* U+71ec */
  0x9043, /* U+71ed */
  0x99d7, /* U+71ee */
  0x0000, /* U+71ef */
  0x0000, /* U+71f0 */
  0x0000, /* U+71f1 */
  0x0000, /* U+71f2 */
  0x0000, /* U+71f3 */
  0x0000, /* U+71f4 */
  0xe09d, /* U+71f5 */
  0x0000, /* U+71f6 */
  0x0000, /* U+71f7 */
  0x0000, /* U+71f8 */
  0xe09f, /* U+71f9 */
  0x0000, /* U+71fa */
  0xe08e, /* U+71fb */
  0xe09e, /* U+71fc */
  0x0000, /* U+71fd */
  0xfb5a, /* U+71fe */
  0xe0a0, /* U+71ff */
  0x0000, /* U+7200 */
  0x0000, /* U+7201 */
  0x0000, /* U+7202 */
  0x0000, /* U+7203 */
  0x0000, /* U+7204 */
  0x0000, /* U+7205 */
  0x949a, /* U+7206 */
  0x0000, /* U+7207 */
  0x0000, /* U+7208 */
  0x0000, /* U+7209 */
  0x0000, /* U+720a */
  0x0000, /* U+720b */
  0x0000, /* U+720c */
  0xe0a1, /* U+720d */
  0x0000, /* U+720e */
  0x0000, /* U+720f */
  0xe0a2, /* U+7210 */
  0x0000, /* U+7211 */
  0x0000, /* U+7212 */
  0x0000, /* U+7213 */
  0x0000, /* U+7214 */
  0x0000, /* U+7215 */
  0x0000, /* U+7216 */
  0x0000, /* U+7217 */
  0x0000, /* U+7218 */
  0x0000, /* U+7219 */
  0x0000, /* U+721a */
  0xe0a3, /* U+721b */
  0x0000, /* U+721c */
  0x0000, /* U+721d */
  0x0000, /* U+721e */
  0x0000, /* U+721f */
  0x0000, /* U+7220 */
  0x0000, /* U+7221 */
  0x0000, /* U+7222 */
  0x0000, /* U+7223 */
  0x0000, /* U+7224 */
  0x0000, /* U+7225 */
  0x0000, /* U+7226 */
  0x0000, /* U+7227 */
  0xe0a4, /* U+7228 */
  0x0000, /* U+7229 */
  0x92dc, /* U+722a */
  0x0000, /* U+722b */
  0xe0a6, /* U+722c */
  0xe0a5, /* U+722d */
  0x0000, /* U+722e */
  0x0000, /* U+722f */
  0xe0a7, /* U+7230 */
  0x0000, /* U+7231 */
  0xe0a8, /* U+7232 */
  0x0000, /* U+7233 */
  0x0000, /* U+7234 */
  0x8edd, /* U+7235 */
  0x9583, /* U+7236 */
  0x0000, /* U+7237 */
  0x0000, /* U+7238 */
  0x0000, /* U+7239 */
  0x96ea, /* U+723a */
  0xe0a9, /* U+723b */
  0xe0aa, /* U+723c */
  0x9175, /* U+723d */
  0x8ea2, /* U+723e */
  0xe0ab, /* U+723f */
  0xe0ac, /* U+7240 */
  0x0000, /* U+7241 */
  0x0000, /* U+7242 */
  0x0000, /* U+7243 */
  0x0000, /* U+7244 */
  0x0000, /* U+7245 */
  0xe0ad, /* U+7246 */
  0x95d0, /* U+7247 */
  0x94c5, /* U+7248 */
  0x0000, /* U+7249 */
  0x0000, /* U+724a */
  0xe0ae, /* U+724b */
  0x9476, /* U+724c */
  0x0000, /* U+724d */
  0x0000, /* U+724e */
  0x0000, /* U+724f */
  0x0000, /* U+7250 */
  0x0000, /* U+7251 */
  0x92ab, /* U+7252 */
  0x0000, /* U+7253 */
  0x0000, /* U+7254 */
  0x0000, /* U+7255 */
  0x0000, /* U+7256 */
  0x0000, /* U+7257 */
  0xe0af, /* U+7258 */
  0x89e5, /* U+7259 */
  0x0000, /* U+725a */
  0x8b8d, /* U+725b */
  0x0000, /* U+725c */
  0x96c4, /* U+725d */
  0x0000, /* U+725e */
  0x96b4, /* U+725f */
  0x0000, /* U+7260 */
  0x89b2, /* U+7261 */
  0x9853, /* U+7262 */
  0x0000, /* U+7263 */
  0x0000, /* U+7264 */
  0x0000, /* U+7265 */
  0x0000, /* U+7266 */
  0x9671, /* U+7267 */
  0x0000, /* U+7268 */
  0x95a8, /* U+7269 */
  0x0000, /* U+726a */
  0x0000, /* U+726b */
  0x0000, /* U+726c */
  0x0000, /* U+726d */
  0x0000, /* U+726e */
  0x0000, /* U+726f */
  0x0000, /* U+7270 */
  0x0000, /* U+7271 */
  0x90b5, /* U+7272 */
  0x0000, /* U+7273 */
  0xe0b0, /* U+7274 */
  0x0000, /* U+7275 */
  0x0000, /* U+7276 */
  0x0000, /* U+7277 */
  0x0000, /* U+7278 */
  0x93c1, /* U+7279 */
  0x0000, /* U+727a */
  0x0000, /* U+727b */
  0x0000, /* U+727c */
  0x8ca1, /* U+727d */
  0xe0b1, /* U+727e */
  0x0000, /* U+727f */
  0x8dd2, /* U+7280 */
  0xe0b3, /* U+7281 */
  0xe0b2, /* U+7282 */
  0x0000, /* U+7283 */
  0x0000, /* U+7284 */
  0x0000, /* U+7285 */
  0x0000, /* U+7286 */
  0xe0b4, /* U+7287 */
  0x0000, /* U+7288 */
  0x0000, /* U+7289 */
  0x0000, /* U+728a */
  0x0000, /* U+728b */
  0x0000, /* U+728c */
  0x0000, /* U+728d */
  0x0000, /* U+728e */
  0x0000, /* U+728f */
  0x0000, /* U+7290 */
  0x0000, /* U+7291 */
  0xe0b5, /* U+7292 */
  0x0000, /* U+7293 */
  0x0000, /* U+7294 */
  0x0000, /* U+7295 */
  0xe0b6, /* U+7296 */
  0x0000, /* U+7297 */
  0x0000, /* U+7298 */
  0x0000, /* U+7299 */
  0x0000, /* U+729a */
  0x0000, /* U+729b */
  0x0000, /* U+729c */
  0x0000, /* U+729d */
  0x0000, /* U+729e */
  0x0000, /* U+729f */
  0x8b5d, /* U+72a0 */
  0x0000, /* U+72a1 */
  0xe0b7, /* U+72a2 */
  0x0000, /* U+72a3 */
  0x0000, /* U+72a4 */
  0x0000, /* U+72a5 */
  0x0000, /* U+72a6 */
  0xe0b8, /* U+72a7 */
  0x0000, /* U+72a8 */
  0x0000, /* U+72a9 */
  0x0000, /* U+72aa */
  0x0000, /* U+72ab */
  0x8ca2, /* U+72ac */
  0x0000, /* U+72ad */
  0x0000, /* U+72ae */
  0x94c6, /* U+72af */
  0x0000, /* U+72b0 */
  0xfb5b, /* U+72b1 */
  0xe0ba, /* U+72b2 */
  0x0000, /* U+72b3 */
  0x0000, /* U+72b4 */
  0x0000, /* U+72b5 */
  0x8ff3, /* U+72b6 */
  0x0000, /* U+72b7 */
  0x0000, /* U+72b8 */
  0xe0b9, /* U+72b9 */
  0x0000, /* U+72ba */
  0x0000, /* U+72bb */
  0x0000, /* U+72bc */
  0x0000, /* U+72bd */
  0xfb5c, /* U+72be */
  0x0000, /* U+72bf */
  0x0000, /* U+72c0 */
  0x0000, /* U+72c1 */
  0x8bb6, /* U+72c2 */
  0xe0bb, /* U+72c3 */
  0xe0bd, /* U+72c4 */
  0x0000, /* U+72c5 */
  0xe0bc, /* U+72c6 */
  0x0000, /* U+72c7 */
  0x0000, /* U+72c8 */
  0x0000, /* U+72c9 */
  0x0000, /* U+72ca */
  0x0000, /* U+72cb */
  0x0000, /* U+72cc */
  0x0000, /* U+72cd */
  0xe0be, /* U+72ce */
  0x0000, /* U+72cf */
  0x8ccf, /* U+72d0 */
  0x0000, /* U+72d1 */
  0xe0bf, /* U+72d2 */
  0x0000, /* U+72d3 */
  0x0000, /* U+72d4 */
  0x0000, /* U+72d5 */
  0x0000, /* U+72d6 */
  0x8be7, /* U+72d7 */
  0x0000, /* U+72d8 */
  0x915f, /* U+72d9 */
  0x0000, /* U+72da */
  0x8d9d, /* U+72db */
  0x0000, /* U+72dc */
  0x0000, /* U+72dd */
  0x0000, /* U+72de */
  0x0000, /* U+72df */
  0xe0c1, /* U+72e0 */
  0xe0c2, /* U+72e1 */
  0xe0c0, /* U+72e2 */
  0x0000, /* U+72e3 */
  0x0000, /* U+72e4 */
  0x0000, /* U+72e5 */
  0x0000, /* U+72e6 */
  0x0000, /* U+72e7 */
  0x0000, /* U+72e8 */
  0x8eeb, /* U+72e9 */
  0x0000, /* U+72ea */
  0x0000, /* U+72eb */
  0x93c6, /* U+72ec */
  0x8bb7, /* U+72ed */
  0x0000, /* U+72ee */
  0x0000, /* U+72ef */
  0x0000, /* U+72f0 */
  0x0000, /* U+72f1 */
  0x0000, /* U+72f2 */
  0x0000, /* U+72f3 */
  0x0000, /* U+72f4 */
  0x0000, /* U+72f5 */
  0x0000, /* U+72f6 */
  0xe0c4, /* U+72f7 */
  0x924b, /* U+72f8 */
  0xe0c3, /* U+72f9 */
  0x0000, /* U+72fa */
  0x0000, /* U+72fb */
  0x9854, /* U+72fc */
  0x9482, /* U+72fd */
  0x0000, /* U+72fe */
  0x0000, /* U+72ff */
  0x0000, /* U+7300 */
  0x0000, /* U+7301 */
  0x0000, /* U+7302 */
  0x0000, /* U+7303 */
  0x0000, /* U+7304 */
  0x0000, /* U+7305 */
  0x0000, /* U+7306 */
  0x0000, /* U+7307 */
  0x0000, /* U+7308 */
  0x0000, /* U+7309 */
  0xe0c7, /* U+730a */
  0x0000, /* U+730b */
  0x0000, /* U+730c */
  0x0000, /* U+730d */
  0x0000, /* U+730e */
  0x0000, /* U+730f */
  0x0000, /* U+7310 */
  0x0000, /* U+7311 */
  0x0000, /* U+7312 */
  0x0000, /* U+7313 */
  0x0000, /* U+7314 */
  0x0000, /* U+7315 */
  0xe0c9, /* U+7316 */
  0xe0c6, /* U+7317 */
  0x0000, /* U+7318 */
  0x0000, /* U+7319 */
  0x0000, /* U+731a */
  0x96d2, /* U+731b */
  0xe0c8, /* U+731c */
  0xe0ca, /* U+731d */
  0x0000, /* U+731e */
  0x97c2, /* U+731f */
  0x0000, /* U+7320 */
  0x0000, /* U+7321 */
  0x0000, /* U+7322 */
  0x0000, /* U+7323 */
  0xfb5d, /* U+7324 */
  0xe0ce, /* U+7325 */
  0x0000, /* U+7326 */
  0x0000, /* U+7327 */
  0x0000, /* U+7328 */
  0xe0cd, /* U+7329 */
  0x9296, /* U+732a */
  0x944c, /* U+732b */
  0x0000, /* U+732c */
  0x0000, /* U+732d */
  0x8ca3, /* U+732e */
  0xe0cc, /* U+732f */
  0x0000, /* U+7330 */
  0x0000, /* U+7331 */
  0x0000, /* U+7332 */
  0x0000, /* U+7333 */
  0xe0cb, /* U+7334 */
  0x0000, /* U+7335 */
  0x9750, /* U+7336 */
  0x9751, /* U+7337 */
  0x0000, /* U+7338 */
  0x0000, /* U+7339 */
  0x0000, /* U+733a */
  0x0000, /* U+733b */
  0x0000, /* U+733c */
  0x0000, /* U+733d */
  0xe0cf, /* U+733e */
  0x898e, /* U+733f */
  0x0000, /* U+7340 */
  0x0000, /* U+7341 */
  0x0000, /* U+7342 */
  0x0000, /* U+7343 */
  0x8d96, /* U+7344 */
  0x8e82, /* U+7345 */
  0x0000, /* U+7346 */
  0x0000, /* U+7347 */
  0x0000, /* U+7348 */
  0x0000, /* U+7349 */
  0x0000, /* U+734a */
  0x0000, /* U+734b */
  0x0000, /* U+734c */
  0x0000, /* U+734d */
  0xe0d0, /* U+734e */
  0xe0d1, /* U+734f */
  0x0000, /* U+7350 */
  0x0000, /* U+7351 */
  0x0000, /* U+7352 */
  0x0000, /* U+7353 */
  0x0000, /* U+7354 */
  0x0000, /* U+7355 */
  0x0000, /* U+7356 */
  0xe0d3, /* U+7357 */
  0x0000, /* U+7358 */
  0x0000, /* U+7359 */
  0x0000, /* U+735a */
  0x0000, /* U+735b */
  0x0000, /* U+735c */
  0x0000, /* U+735d */
  0x0000, /* U+735e */
  0x0000, /* U+735f */
  0x0000, /* U+7360 */
  0x0000, /* U+7361 */
  0x0000, /* U+7362 */
  0x8f62, /* U+7363 */
  0x0000, /* U+7364 */
  0x0000, /* U+7365 */
  0x0000, /* U+7366 */
  0x0000, /* U+7367 */
  0xe0d5, /* U+7368 */
  0x0000, /* U+7369 */
  0xe0d4, /* U+736a */
  0x0000, /* U+736b */
  0x0000, /* U+736c */
  0x0000, /* U+736d */
  0x0000, /* U+736e */
  0x0000, /* U+736f */
  0xe0d6, /* U+7370 */
  0x0000, /* U+7371 */
  0x8a6c, /* U+7372 */
  0x0000, /* U+7373 */
  0x0000, /* U+7374 */
  0xe0d8, /* U+7375 */
  0x0000, /* U+7376 */
  0xfb5f, /* U+7377 */
  0xe0d7, /* U+7378 */
  0x0000, /* U+7379 */
  0xe0da, /* U+737a */
  0xe0d9, /* U+737b */
  0x0000, /* U+737c */
  0x0000, /* U+737d */
  0x0000, /* U+737e */
  0x0000, /* U+737f */
  0x0000, /* U+7380 */
  0x0000, /* U+7381 */
  0x0000, /* U+7382 */
  0x0000, /* U+7383 */
  0x8cba, /* U+7384 */
  0x0000, /* U+7385 */
  0x0000, /* U+7386 */
  0x97a6, /* U+7387 */
  0x0000, /* U+7388 */
  0x8bca, /* U+7389 */
  0x0000, /* U+738a */
  0x89a4, /* U+738b */
  0x0000, /* U+738c */
  0x0000, /* U+738d */
  0x0000, /* U+738e */
  0x0000, /* U+738f */
  0x0000, /* U+7390 */
  0x0000, /* U+7391 */
  0x0000, /* U+7392 */
  0x0000, /* U+7393 */
  0x0000, /* U+7394 */
  0x0000, /* U+7395 */
  0x8be8, /* U+7396 */
  0x0000, /* U+7397 */
  0x0000, /* U+7398 */
  0x0000, /* U+7399 */
  0x0000, /* U+739a */
  0x0000, /* U+739b */
  0x0000, /* U+739c */
  0x0000, /* U+739d */
  0x0000, /* U+739e */
  0x0000, /* U+739f */
  0x0000, /* U+73a0 */
  0x0000, /* U+73a1 */
  0x0000, /* U+73a2 */
  0x0000, /* U+73a3 */
  0x0000, /* U+73a4 */
  0x0000, /* U+73a5 */
  0x0000, /* U+73a6 */
  0x0000, /* U+73a7 */
  0x0000, /* U+73a8 */
  0x8adf, /* U+73a9 */
  0x0000, /* U+73aa */
  0x0000, /* U+73ab */
  0x0000, /* U+73ac */
  0x0000, /* U+73ad */
  0x0000, /* U+73ae */
  0x0000, /* U+73af */
  0x0000, /* U+73b0 */
  0x0000, /* U+73b1 */
  0x97e6, /* U+73b2 */
  0xe0dc, /* U+73b3 */
  0x0000, /* U+73b4 */
  0x0000, /* U+73b5 */
  0x0000, /* U+73b6 */
  0x0000, /* U+73b7 */
  0x0000, /* U+73b8 */
  0x0000, /* U+73b9 */
  0x0000, /* U+73ba */
  0xe0de, /* U+73bb */
  0x0000, /* U+73bc */
  0xfb60, /* U+73bd */
  0x0000, /* U+73be */
  0x0000, /* U+73bf */
  0xe0df, /* U+73c0 */
  0x0000, /* U+73c1 */
  0x89cf, /* U+73c2 */
  0x0000, /* U+73c3 */
  0x0000, /* U+73c4 */
  0x0000, /* U+73c5 */
  0x0000, /* U+73c6 */
  0x0000, /* U+73c7 */
  0xe0db, /* U+73c8 */
  0xfb61, /* U+73c9 */
  0x8e58, /* U+73ca */
  0x0000, /* U+73cb */
  0x0000, /* U+73cc */
  0x92bf, /* U+73cd */
  0xe0dd, /* U+73ce */
  0x0000, /* U+73cf */
  0x0000, /* U+73d0 */
  0x0000, /* U+73d1 */
  0xfb64, /* U+73d2 */
  0x0000, /* U+73d3 */
  0x0000, /* U+73d4 */
  0x0000, /* U+73d5 */
  0xfb62, /* U+73d6 */
  0x0000, /* U+73d7 */
  0x0000, /* U+73d8 */
  0x0000, /* U+73d9 */
  0x0000, /* U+73da */
  0x0000, /* U+73db */
  0x0000, /* U+73dc */
  0x0000, /* U+73dd */
  0xe0e2, /* U+73de */
  0x0000, /* U+73df */
  0x8eec, /* U+73e0 */
  0x0000, /* U+73e1 */
  0x0000, /* U+73e2 */
  0xfb63, /* U+73e3 */
  0x0000, /* U+73e4 */
  0xe0e0, /* U+73e5 */
  0x0000, /* U+73e6 */
  0x0000, /* U+73e7 */
  0x0000, /* U+73e8 */
  0x0000, /* U+73e9 */
  0x8c5d, /* U+73ea */
  0x0000, /* U+73eb */
  0x0000, /* U+73ec */
  0x94c7, /* U+73ed */
  0xe0e1, /* U+73ee */
  0x0000, /* U+73ef */
  0x0000, /* U+73f0 */
  0xe0fc, /* U+73f1 */
  0x0000, /* U+73f2 */
  0x0000, /* U+73f3 */
  0x0000, /* U+73f4 */
  0xfb66, /* U+73f5 */
  0x0000, /* U+73f6 */
  0x0000, /* U+73f7 */
  0xe0e7, /* U+73f8 */
  0x0000, /* U+73f9 */
  0x0000, /* U+73fa */
  0x0000, /* U+73fb */
  0x0000, /* U+73fc */
  0x0000, /* U+73fd */
  0x8cbb, /* U+73fe */
  0x0000, /* U+73ff */
  0x0000, /* U+7400 */
  0x0000, /* U+7401 */
  0x0000, /* U+7402 */
  0x8b85, /* U+7403 */
  0x0000, /* U+7404 */
  0xe0e4, /* U+7405 */
  0x979d, /* U+7406 */
  0xfb65, /* U+7407 */
  0x0000, /* U+7408 */
  0x97ae, /* U+7409 */
  0x0000, /* U+740a */
  0x0000, /* U+740b */
  0x0000, /* U+740c */
  0x0000, /* U+740d */
  0x0000, /* U+740e */
  0x0000, /* U+740f */
  0x0000, /* U+7410 */
  0x0000, /* U+7411 */
  0x0000, /* U+7412 */
  0x0000, /* U+7413 */
  0x0000, /* U+7414 */
  0x0000, /* U+7415 */
  0x0000, /* U+7416 */
  0x0000, /* U+7417 */
  0x0000, /* U+7418 */
  0x0000, /* U+7419 */
  0x0000, /* U+741a */
  0x0000, /* U+741b */
  0x0000, /* U+741c */
  0x0000, /* U+741d */
  0x0000, /* U+741e */
  0x0000, /* U+741f */
  0x0000, /* U+7420 */
  0x0000, /* U+7421 */
  0x91f4, /* U+7422 */
  0x0000, /* U+7423 */
  0x0000, /* U+7424 */
  0xe0e6, /* U+7425 */
  0xfb67, /* U+7426 */
  0x0000, /* U+7427 */
  0x0000, /* U+7428 */
  0xfb69, /* U+7429 */
  0xfb68, /* U+742a */
  0x0000, /* U+742b */
  0x0000, /* U+742c */
  0x0000, /* U+742d */
  0xfb6a, /* U+742e */
  0x0000, /* U+742f */
  0x0000, /* U+7430 */
  0x0000, /* U+7431 */
  0xe0e8, /* U+7432 */
  0x97d4, /* U+7433 */
  0x8bd5, /* U+7434 */
  0x94fa, /* U+7435 */
  0x9469, /* U+7436 */
  0x0000, /* U+7437 */
  0x0000, /* U+7438 */
  0x0000, /* U+7439 */
  0xe0e9, /* U+743a */
  0x0000, /* U+743b */
  0x0000, /* U+743c */
  0x0000, /* U+743d */
  0x0000, /* U+743e */
  0xe0eb, /* U+743f */
  0x0000, /* U+7440 */
  0xe0ee, /* U+7441 */
  0x0000, /* U+7442 */
  0x0000, /* U+7443 */
  0x0000, /* U+7444 */
  0x0000, /* U+7445 */
  0x0000, /* U+7446 */
  0x0000, /* U+7447 */
  0x0000, /* U+7448 */
  0x0000, /* U+7449 */
  0x0000, /* U+744a */
  0x0000, /* U+744b */
  0x0000, /* U+744c */
  0x0000, /* U+744d */
  0x0000, /* U+744e */
  0x0000, /* U+744f */
  0x0000, /* U+7450 */
  0x0000, /* U+7451 */
  0x0000, /* U+7452 */
  0x0000, /* U+7453 */
  0x0000, /* U+7454 */
  0xe0ea, /* U+7455 */
  0x0000, /* U+7456 */
  0x0000, /* U+7457 */
  0x0000, /* U+7458 */
  0xe0ed, /* U+7459 */
  0x8ce8, /* U+745a */
  0x896c, /* U+745b */
  0xe0ef, /* U+745c */
  0x0000, /* U+745d */
  0x9090, /* U+745e */
  0xe0ec, /* U+745f */
  0x97da, /* U+7460 */
  0x0000, /* U+7461 */
  0xfb6b, /* U+7462 */
  0xe0f2, /* U+7463 */
  0xeaa2, /* U+7464 */
  0x0000, /* U+7465 */
  0x0000, /* U+7466 */
  0x0000, /* U+7467 */
  0x0000, /* U+7468 */
  0xe0f0, /* U+7469 */
  0xe0f3, /* U+746a */
  0x0000, /* U+746b */
  0x0000, /* U+746c */
  0x0000, /* U+746d */
  0x0000, /* U+746e */
  0xe0e5, /* U+746f */
  0xe0f1, /* U+7470 */
  0x0000, /* U+7471 */
  0x0000, /* U+7472 */
  0x8dba, /* U+7473 */
  0x0000, /* U+7474 */
  0x0000, /* U+7475 */
  0xe0f4, /* U+7476 */
  0x0000, /* U+7477 */
  0x0000, /* U+7478 */
  0x0000, /* U+7479 */
  0x0000, /* U+747a */
  0x0000, /* U+747b */
  0x0000, /* U+747c */
  0x0000, /* U+747d */
  0xe0f5, /* U+747e */
  0x0000, /* U+747f */
  0x0000, /* U+7480 */
  0x0000, /* U+7481 */
  0x0000, /* U+7482 */
  0x979e, /* U+7483 */
  0x0000, /* U+7484 */
  0x0000, /* U+7485 */
  0x0000, /* U+7486 */
  0x0000, /* U+7487 */
  0x0000, /* U+7488 */
  0xfb6c, /* U+7489 */
  0x0000, /* U+748a */
  0xe0f6, /* U+748b */
  0x0000, /* U+748c */
  0x0000, /* U+748d */
  0x0000, /* U+748e */
  0x0000, /* U+748f */
  0x0000, /* U+7490 */
  0x0000, /* U+7491 */
  0x0000, /* U+7492 */
  0x0000, /* U+7493 */
  0x0000, /* U+7494 */
  0x0000, /* U+7495 */
  0x0000, /* U+7496 */
  0x0000, /* U+7497 */
  0x0000, /* U+7498 */
  0x0000, /* U+7499 */
  0x0000, /* U+749a */
  0x0000, /* U+749b */
  0x0000, /* U+749c */
  0x0000, /* U+749d */
  0xe0f7, /* U+749e */
  0xfb6d, /* U+749f */
  0x0000, /* U+74a0 */
  0x0000, /* U+74a1 */
  0xe0e3, /* U+74a2 */
  0x0000, /* U+74a3 */
  0x0000, /* U+74a4 */
  0x0000, /* U+74a5 */
  0x0000, /* U+74a6 */
  0xe0f8, /* U+74a7 */
  0x0000, /* U+74a8 */
  0x0000, /* U+74a9 */
  0x0000, /* U+74aa */
  0x0000, /* U+74ab */
  0x0000, /* U+74ac */
  0x0000, /* U+74ad */
  0x0000, /* U+74ae */
  0x0000, /* U+74af */
  0x8ac2, /* U+74b0 */
  0x0000, /* U+74b1 */
  0x0000, /* U+74b2 */
  0x0000, /* U+74b3 */
  0x0000, /* U+74b4 */
  0x0000, /* U+74b5 */
  0x0000, /* U+74b6 */
  0x0000, /* U+74b7 */
  0x0000, /* U+74b8 */
  0x0000, /* U+74b9 */
  0x0000, /* U+74ba */
  0x0000, /* U+74bb */
  0x0000, /* U+74bc */
  0x8ea3, /* U+74bd */
  0x0000, /* U+74be */
  0x0000, /* U+74bf */
  0x0000, /* U+74c0 */
  0x0000, /* U+74c1 */
  0x0000, /* U+74c2 */
  0x0000, /* U+74c3 */
  0x0000, /* U+74c4 */
  0x0000, /* U+74c5 */
  0x0000, /* U+74c6 */
  0x0000, /* U+74c7 */
  0x0000, /* U+74c8 */
  0x0000, /* U+74c9 */
  0xe0f9, /* U+74ca */
  0x0000, /* U+74cb */
  0x0000, /* U+74cc */
  0x0000, /* U+74cd */
  0x0000, /* U+74ce */
  0xe0fa, /* U+74cf */
  0x0000, /* U+74d0 */
  0x0000, /* U+74d1 */
  0x0000, /* U+74d2 */
  0x0000, /* U+74d3 */
  0xe0fb, /* U+74d4 */
  0x0000, /* U+74d5 */
  0x0000, /* U+74d6 */
  0x0000, /* U+74d7 */
  0x0000, /* U+74d8 */
  0x0000, /* U+74d9 */
  0x0000, /* U+74da */
  0x0000, /* U+74db */
  0x895a, /* U+74dc */
  0x0000, /* U+74dd */
  0x0000, /* U+74de */
  0x0000, /* U+74df */
  0xe140, /* U+74e0 */
  0x0000, /* U+74e1 */
  0x955a, /* U+74e2 */
  0xe141, /* U+74e3 */
  0x0000, /* U+74e4 */
  0x0000, /* U+74e5 */
  0x8aa2, /* U+74e6 */
  0xe142, /* U+74e7 */
  0x0000, /* U+74e8 */
  0xe143, /* U+74e9 */
  0x0000, /* U+74ea */
  0x0000, /* U+74eb */
  0x0000, /* U+74ec */
  0x0000, /* U+74ed */
  0xe144, /* U+74ee */
  0x0000, /* U+74ef */
  0xe146, /* U+74f0 */
  0xe147, /* U+74f1 */
  0xe145, /* U+74f2 */
  0x0000, /* U+74f3 */
  0x0000, /* U+74f4 */
  0x0000, /* U+74f5 */
  0x9572, /* U+74f6 */
  0xe149, /* U+74f7 */
  0xe148, /* U+74f8 */
  0x0000, /* U+74f9 */
  0x0000, /* U+74fa */
  0x0000, /* U+74fb */
  0x0000, /* U+74fc */
  0x0000, /* U+74fd */
  0x0000, /* U+74fe */
  0x0000, /* U+74ff */
  0x0000, /* U+7500 */
  0xfb6e, /* U+7501 */
  0x0000, /* U+7502 */
  0xe14b, /* U+7503 */
  0xe14a, /* U+7504 */
  0xe14c, /* U+7505 */
  0x0000, /* U+7506 */
  0x0000, /* U+7507 */
  0x0000, /* U+7508 */
  0x0000, /* U+7509 */
  0x0000, /* U+750a */
  0x0000, /* U+750b */
  0xe14d, /* U+750c */
  0xe14f, /* U+750d */
  0xe14e, /* U+750e */
  0x0000, /* U+750f */
  0x0000, /* U+7510 */
  0x8d99, /* U+7511 */
  0x0000, /* U+7512 */
  0xe151, /* U+7513 */
  0x0000, /* U+7514 */
  0xe150, /* U+7515 */
  0x0000, /* U+7516 */
  0x0000, /* U+7517 */
  0x8ac3, /* U+7518 */
  0x0000, /* U+7519 */
  0x9072, /* U+751a */
  0x0000, /* U+751b */
  0x935b, /* U+751c */
  0x0000, /* U+751d */
  0xe152, /* U+751e */
  0x90b6, /* U+751f */
  0x0000, /* U+7520 */
  0x0000, /* U+7521 */
  0x0000, /* U+7522 */
  0x8e59, /* U+7523 */
  0x0000, /* U+7524 */
  0x8999, /* U+7525 */
  0xe153, /* U+7526 */
  0x0000, /* U+7527 */
  0x9770, /* U+7528 */
  0x0000, /* U+7529 */
  0x0000, /* U+752a */
  0x95e1, /* U+752b */
  0xe154, /* U+752c */
  0x0000, /* U+752d */
  0x0000, /* U+752e */
  0xfaa8, /* U+752f */
  0x9363, /* U+7530 */
  0x9752, /* U+7531 */
  0x8d62, /* U+7532 */
  0x905c, /* U+7533 */
  0x0000, /* U+7534 */
  0x0000, /* U+7535 */
  0x0000, /* U+7536 */
  0x926a, /* U+7537 */
  0x99b2, /* U+7538 */
  0x0000, /* U+7539 */
  0x92ac, /* U+753a */
  0x89e6, /* U+753b */
  0xe155, /* U+753c */
  0x0000, /* U+753d */
  0x0000, /* U+753e */
  0x0000, /* U+753f */
  0x0000, /* U+7540 */
  0x0000, /* U+7541 */
  0x0000, /* U+7542 */
  0x0000, /* U+7543 */
  0xe156, /* U+7544 */
  0x0000, /* U+7545 */
  0xe15b, /* U+7546 */
  0x0000, /* U+7547 */
  0x0000, /* U+7548 */
  0xe159, /* U+7549 */
  0xe158, /* U+754a */
  0x9dc0, /* U+754b */
  0x8a45, /* U+754c */
  0xe157, /* U+754d */
  0x0000, /* U+754e */
  0x88d8, /* U+754f */
  0x0000, /* U+7550 */
  0x94a8, /* U+7551 */
  0x0000, /* U+7552 */
  0x0000, /* U+7553 */
  0x94c8, /* U+7554 */
  0x0000, /* U+7555 */
  0x0000, /* U+7556 */
  0x0000, /* U+7557 */
  0x0000, /* U+7558 */
  0x97af, /* U+7559 */
  0xe15c, /* U+755a */
  0xe15a, /* U+755b */
  0x927b, /* U+755c */
  0x90a4, /* U+755d */
  0x0000, /* U+755e */
  0x0000, /* U+755f */
  0x94a9, /* U+7560 */
  0x0000, /* U+7561 */
  0x954c, /* U+7562 */
  0x0000, /* U+7563 */
  0xe15e, /* U+7564 */
  0x97aa, /* U+7565 */
  0x8c6c, /* U+7566 */
  0xe15f, /* U+7567 */
  0x0000, /* U+7568 */
  0xe15d, /* U+7569 */
  0x94d4, /* U+756a */
  0xe160, /* U+756b */
  0x0000, /* U+756c */
  0xe161, /* U+756d */
  0x0000, /* U+756e */
  0xfb6f, /* U+756f */
  0x88d9, /* U+7570 */
  0x0000, /* U+7571 */
  0x0000, /* U+7572 */
  0x8ff4, /* U+7573 */
  0xe166, /* U+7574 */
  0x0000, /* U+7575 */
  0xe163, /* U+7576 */
  0x93eb, /* U+7577 */
  0xe162, /* U+7578 */
  0x0000, /* U+7579 */
  0x0000, /* U+757a */
  0x0000, /* U+757b */
  0x0000, /* U+757c */
  0x0000, /* U+757d */
  0x0000, /* U+757e */
  0x8b45, /* U+757f */
  0x0000, /* U+7580 */
  0x0000, /* U+7581 */
  0xe169, /* U+7582 */
  0x0000, /* U+7583 */
  0x0000, /* U+7584 */
  0x0000, /* U+7585 */
  0xe164, /* U+7586 */
  0xe165, /* U+7587 */
  0x0000, /* U+7588 */
  0xe168, /* U+7589 */
  0xe167, /* U+758a */
  0x9544, /* U+758b */
  0x0000, /* U+758c */
  0x0000, /* U+758d */
  0x9161, /* U+758e */
  0x9160, /* U+758f */
  0x0000, /* U+7590 */
  0x8b5e, /* U+7591 */
  0x0000, /* U+7592 */
  0x0000, /* U+7593 */
  0xe16a, /* U+7594 */
  0x0000, /* U+7595 */
  0x0000, /* U+7596 */
  0x0000, /* U+7597 */
  0x0000, /* U+7598 */
  0x0000, /* U+7599 */
  0xe16b, /* U+759a */
  0x0000, /* U+759b */
  0x0000, /* U+759c */
  0xe16c, /* U+759d */
  0x0000, /* U+759e */
  0x0000, /* U+759f */
  0x0000, /* U+75a0 */
  0x0000, /* U+75a1 */
  0x0000, /* U+75a2 */
  0xe16e, /* U+75a3 */
  0x0000, /* U+75a4 */
  0xe16d, /* U+75a5 */
  0x0000, /* U+75a6 */
  0x0000, /* U+75a7 */
  0x0000, /* U+75a8 */
  0x0000, /* U+75a9 */
  0x0000, /* U+75aa */
  0x8975, /* U+75ab */
  0x0000, /* U+75ac */
  0x0000, /* U+75ad */
  0x0000, /* U+75ae */
  0x0000, /* U+75af */
  0x0000, /* U+75b0 */
  0xe176, /* U+75b1 */
  0x94e6, /* U+75b2 */
  0xe170, /* U+75b3 */
  0x0000, /* U+75b4 */
  0xe172, /* U+75b5 */
  0x0000, /* U+75b6 */
  0x0000, /* U+75b7 */
  0xe174, /* U+75b8 */
  0x905d, /* U+75b9 */
  0x0000, /* U+75ba */
  0x0000, /* U+75bb */
  0xe175, /* U+75bc */
  0xe173, /* U+75bd */
  0x8ebe, /* U+75be */
  0x0000, /* U+75bf */
  0x0000, /* U+75c0 */
  0x0000, /* U+75c1 */
  0xe16f, /* U+75c2 */
  0xe171, /* U+75c3 */
  0x0000, /* U+75c4 */
  0x9561, /* U+75c5 */
  0x0000, /* U+75c6 */
  0x8fc7, /* U+75c7 */
  0x0000, /* U+75c8 */
  0x0000, /* U+75c9 */
  0xe178, /* U+75ca */
  0x0000, /* U+75cb */
  0x0000, /* U+75cc */
  0xe177, /* U+75cd */
  0x0000, /* U+75ce */
  0x0000, /* U+75cf */
  0x0000, /* U+75d0 */
  0x0000, /* U+75d1 */
  0xe179, /* U+75d2 */
  0x0000, /* U+75d3 */
  0x8ea4, /* U+75d4 */
  0x8dad, /* U+75d5 */
  0x0000, /* U+75d6 */
  0x0000, /* U+75d7 */
  0x9397, /* U+75d8 */
  0xe17a, /* U+75d9 */
  0x0000, /* U+75da */
  0x92c9, /* U+75db */
  0x0000, /* U+75dc */
  0x0000, /* U+75dd */
  0xe17c, /* U+75de */
  0x0000, /* U+75df */
  0x0000, /* U+75e0 */
  0x0000, /* U+75e1 */
  0x979f, /* U+75e2 */
  0xe17b, /* U+75e3 */
  0x0000, /* U+75e4 */
  0x0000, /* U+75e5 */
  0x0000, /* U+75e6 */
  0x0000, /* U+75e7 */
  0x0000, /* U+75e8 */
  0x9189, /* U+75e9 */
  0x0000, /* U+75ea */
  0x0000, /* U+75eb */
  0x0000, /* U+75ec */
  0x0000, /* U+75ed */
  0x0000, /* U+75ee */
  0x0000, /* U+75ef */
  0xe182, /* U+75f0 */
  0x0000, /* U+75f1 */
  0xe184, /* U+75f2 */
  0xe185, /* U+75f3 */
  0x9273, /* U+75f4 */
  0x0000, /* U+75f5 */
  0x0000, /* U+75f6 */
  0x0000, /* U+75f7 */
  0x0000, /* U+75f8 */
  0x0000, /* U+75f9 */
  0xe183, /* U+75fa */
  0x0000, /* U+75fb */
  0xe180, /* U+75fc */
  0x0000, /* U+75fd */
  0xe17d, /* U+75fe */
  0xe17e, /* U+75ff */
  0x0000, /* U+7600 */
  0xe181, /* U+7601 */
  0x0000, /* U+7602 */
  0x0000, /* U+7603 */
  0x0000, /* U+7604 */
  0x0000, /* U+7605 */
  0x0000, /* U+7606 */
  0x0000, /* U+7607 */
  0x0000, /* U+7608 */
  0xe188, /* U+7609 */
  0x0000, /* U+760a */
  0xe186, /* U+760b */
  0x0000, /* U+760c */
  0xe187, /* U+760d */
  0x0000, /* U+760e */
  0x0000, /* U+760f */
  0x0000, /* U+7610 */
  0x0000, /* U+7611 */
  0x0000, /* U+7612 */
  0x0000, /* U+7613 */
  0x0000, /* U+7614 */
  0x0000, /* U+7615 */
  0x0000, /* U+7616 */
  0x0000, /* U+7617 */
  0x0000, /* U+7618 */
  0x0000, /* U+7619 */
  0x0000, /* U+761a */
  0x0000, /* U+761b */
  0x0000, /* U+761c */
  0x0000, /* U+761d */
  0x0000, /* U+761e */
  0xe189, /* U+761f */
  0xe18b, /* U+7620 */
  0xe18c, /* U+7621 */
  0xe18d, /* U+7622 */
  0x0000, /* U+7623 */
  0xe18e, /* U+7624 */
  0x0000, /* U+7625 */
  0x0000, /* U+7626 */
  0xe18a, /* U+7627 */
  0x0000, /* U+7628 */
  0x0000, /* U+7629 */
  0x0000, /* U+762a */
  0x0000, /* U+762b */
  0x0000, /* U+762c */
  0x0000, /* U+762d */
  0x0000, /* U+762e */
  0x0000, /* U+762f */
  0xe190, /* U+7630 */
  0x0000, /* U+7631 */
  0x0000, /* U+7632 */
  0x0000, /* U+7633 */
  0xe18f, /* U+7634 */
  0x0000, /* U+7635 */
  0x0000, /* U+7636 */
  0x0000, /* U+7637 */
  0x0000, /* U+7638 */
  0x0000, /* U+7639 */
  0x0000, /* U+763a */
  0xe191, /* U+763b */
  0x0000, /* U+763c */
  0x0000, /* U+763d */
  0x0000, /* U+763e */
  0x0000, /* U+763f */
  0x0000, /* U+7640 */
  0x0000, /* U+7641 */
  0x97c3, /* U+7642 */
  0x0000, /* U+7643 */
  0x0000, /* U+7644 */
  0x0000, /* U+7645 */
  0xe194, /* U+7646 */
  0xe192, /* U+7647 */
  0xe193, /* U+7648 */
  0x0000, /* U+7649 */
  0x0000, /* U+764a */
  0x0000, /* U+764b */
  0x8ae0, /* U+764c */
  0x0000, /* U+764d */
  0x0000, /* U+764e */
  0x0000, /* U+764f */
  0x0000, /* U+7650 */
  0x0000, /* U+7651 */
  0x96fc, /* U+7652 */
  0x0000, /* U+7653 */
  0x0000, /* U+7654 */
  0x0000, /* U+7655 */
  0x95c8, /* U+7656 */
  0x0000, /* U+7657 */
  0xe196, /* U+7658 */
  0x0000, /* U+7659 */
  0x0000, /* U+765a */
  0x0000, /* U+765b */
  0xe195, /* U+765c */
  0x0000, /* U+765d */
  0x0000, /* U+765e */
  0x0000, /* U+765f */
  0x0000, /* U+7660 */
  0xe197, /* U+7661 */
  0xe198, /* U+7662 */
  0x0000, /* U+7663 */
  0x0000, /* U+7664 */
  0x0000, /* U+7665 */
  0x0000, /* U+7666 */
  0xe19c, /* U+7667 */
  0xe199, /* U+7668 */
  0xe19a, /* U+7669 */
  0xe19b, /* U+766a */
  0x0000, /* U+766b */
  0xe19d, /* U+766c */
  0x0000, /* U+766d */
  0x0000, /* U+766e */
  0x0000, /* U+766f */
  0xe19e, /* U+7670 */
  0x0000, /* U+7671 */
  0xe19f, /* U+7672 */
  0x0000, /* U+7673 */
  0x0000, /* U+7674 */
  0x0000, /* U+7675 */
  0xe1a0, /* U+7676 */
  0x0000, /* U+7677 */
  0xe1a1, /* U+7678 */
  0x0000, /* U+7679 */
  0x94ad, /* U+767a */
  0x936f, /* U+767b */
  0xe1a2, /* U+767c */
  0x9492, /* U+767d */
  0x9553, /* U+767e */
  0x0000, /* U+767f */
  0xe1a3, /* U+7680 */
  0x0000, /* U+7681 */
  0xfb70, /* U+7682 */
  0xe1a4, /* U+7683 */
  0x9349, /* U+7684 */
  0x0000, /* U+7685 */
  0x8a46, /* U+7686 */
  0x8d63, /* U+7687 */
  0xe1a5, /* U+7688 */
  0x0000, /* U+7689 */
  0x0000, /* U+768a */
  0xe1a6, /* U+768b */
  0x0000, /* U+768c */
  0x0000, /* U+768d */
  0xe1a7, /* U+768e */
  0x0000, /* U+768f */
  0x8e48, /* U+7690 */
  0x0000, /* U+7691 */
  0x0000, /* U+7692 */
  0xe1a9, /* U+7693 */
  0x0000, /* U+7694 */
  0x0000, /* U+7695 */
  0xe1a8, /* U+7696 */
  0x0000, /* U+7697 */
  0x0000, /* U+7698 */
  0xe1aa, /* U+7699 */
  0xe1ab, /* U+769a */
  0xfb73, /* U+769b */
  0xfb71, /* U+769c */
  0x0000, /* U+769d */
  0xfb72, /* U+769e */
  0x0000, /* U+769f */
  0x0000, /* U+76a0 */
  0x0000, /* U+76a1 */
  0x0000, /* U+76a2 */
  0x0000, /* U+76a3 */
  0x0000, /* U+76a4 */
  0x0000, /* U+76a5 */
  0xfb74, /* U+76a6 */
  0x0000, /* U+76a7 */
  0x0000, /* U+76a8 */
  0x0000, /* U+76a9 */
  0x0000, /* U+76aa */
  0x0000, /* U+76ab */
  0x0000, /* U+76ac */
  0x0000, /* U+76ad */
  0x94e7, /* U+76ae */
  0x0000, /* U+76af */
  0xe1ac, /* U+76b0 */
  0x0000, /* U+76b1 */
  0x0000, /* U+76b2 */
  0x0000, /* U+76b3 */
  0xe1ad, /* U+76b4 */
  0x0000, /* U+76b5 */
  0x0000, /* U+76b6 */
  0xea89, /* U+76b7 */
  0xe1ae, /* U+76b8 */
  0xe1af, /* U+76b9 */
  0xe1b0, /* U+76ba */
  0x0000, /* U+76bb */
  0x0000, /* U+76bc */
  0x0000, /* U+76bd */
  0x0000, /* U+76be */
  0x8e4d, /* U+76bf */
  0x0000, /* U+76c0 */
  0x0000, /* U+76c1 */
  0xe1b1, /* U+76c2 */
  0x9475, /* U+76c3 */
  0x0000, /* U+76c4 */
  0x0000, /* U+76c5 */
  0x967e, /* U+76c6 */
  0x0000, /* U+76c7 */
  0x896d, /* U+76c8 */
  0x0000, /* U+76c9 */
  0x8976, /* U+76ca */
  0x0000, /* U+76cb */
  0x0000, /* U+76cc */
  0xe1b2, /* U+76cd */
  0x0000, /* U+76ce */
  0x0000, /* U+76cf */
  0x0000, /* U+76d0 */
  0x0000, /* U+76d1 */
  0xe1b4, /* U+76d2 */
  0x0000, /* U+76d3 */
  0x0000, /* U+76d4 */
  0x0000, /* U+76d5 */
  0xe1b3, /* U+76d6 */
  0x9390, /* U+76d7 */
  0x0000, /* U+76d8 */
  0x0000, /* U+76d9 */
  0x0000, /* U+76da */
  0x90b7, /* U+76db */
  0x9f58, /* U+76dc */
  0x0000, /* U+76dd */
  0xe1b5, /* U+76de */
  0x96bf, /* U+76df */
  0x0000, /* U+76e0 */
  0xe1b6, /* U+76e1 */
  0x0000, /* U+76e2 */
  0x8ac4, /* U+76e3 */
  0x94d5, /* U+76e4 */
  0xe1b7, /* U+76e5 */
  0x0000, /* U+76e6 */
  0xe1b8, /* U+76e7 */
  0x0000, /* U+76e8 */
  0x0000, /* U+76e9 */
  0xe1b9, /* U+76ea */
  0x0000, /* U+76eb */
  0x0000, /* U+76ec */
  0x0000, /* U+76ed */
  0x96da, /* U+76ee */
  0x0000, /* U+76ef */
  0x0000, /* U+76f0 */
  0x0000, /* U+76f1 */
  0x96d3, /* U+76f2 */
  0x0000, /* U+76f3 */
  0x92bc, /* U+76f4 */
  0x0000, /* U+76f5 */
  0x0000, /* U+76f6 */
  0x0000, /* U+76f7 */
  0x918a, /* U+76f8 */
  0x0000, /* U+76f9 */
  0x0000, /* U+76fa */
  0xe1bb, /* U+76fb */
  0x0000, /* U+76fc */
  0x0000, /* U+76fd */
  0x8f82, /* U+76fe */
  0x0000, /* U+76ff */
  0x0000, /* U+7700 */
  0x8fc8, /* U+7701 */
  0x0000, /* U+7702 */
  0x0000, /* U+7703 */
  0xe1be, /* U+7704 */
  0x0000, /* U+7705 */
  0x0000, /* U+7706 */
  0xe1bd, /* U+7707 */
  0xe1bc, /* U+7708 */
  0x94fb, /* U+7709 */
  0x0000, /* U+770a */
  0x8ac5, /* U+770b */
  0x8ca7, /* U+770c */
  0x0000, /* U+770d */
  0x0000, /* U+770e */
  0x0000, /* U+770f */
  0x0000, /* U+7710 */
  0x0000, /* U+7711 */
  0x0000, /* U+7712 */
  0x0000, /* U+7713 */
  0x0000, /* U+7714 */
  0x0000, /* U+7715 */
  0x0000, /* U+7716 */
  0x0000, /* U+7717 */
  0x0000, /* U+7718 */
  0x0000, /* U+7719 */
  0x0000, /* U+771a */
  0xe1c4, /* U+771b */
  0x0000, /* U+771c */
  0x0000, /* U+771d */
  0xe1c1, /* U+771e */
  0x905e, /* U+771f */
  0x96b0, /* U+7720 */
  0x0000, /* U+7721 */
  0x0000, /* U+7722 */
  0x0000, /* U+7723 */
  0xe1c0, /* U+7724 */
  0xe1c2, /* U+7725 */
  0xe1c3, /* U+7726 */
  0x0000, /* U+7727 */
  0x0000, /* U+7728 */
  0xe1bf, /* U+7729 */
  0x0000, /* U+772a */
  0x0000, /* U+772b */
  0x0000, /* U+772c */
  0x0000, /* U+772d */
  0x0000, /* U+772e */
  0x0000, /* U+772f */
  0x0000, /* U+7730 */
  0x0000, /* U+7731 */
  0x0000, /* U+7732 */
  0x0000, /* U+7733 */
  0x0000, /* U+7734 */
  0x0000, /* U+7735 */
  0x0000, /* U+7736 */
  0xe1c5, /* U+7737 */
  0xe1c6, /* U+7738 */
  0x0000, /* U+7739 */
  0x92ad, /* U+773a */
  0x0000, /* U+773b */
  0x8ae1, /* U+773c */
  0x0000, /* U+773d */
  0x0000, /* U+773e */
  0x0000, /* U+773f */
  0x9285, /* U+7740 */
  0x0000, /* U+7741 */
  0x0000, /* U+7742 */
  0x0000, /* U+7743 */
  0x0000, /* U+7744 */
  0x0000, /* U+7745 */
  0xfb76, /* U+7746 */
  0xe1c7, /* U+7747 */
  0x0000, /* U+7748 */
  0x0000, /* U+7749 */
  0x0000, /* U+774a */
  0x0000, /* U+774b */
  0x0000, /* U+774c */
  0x0000, /* U+774d */
  0x0000, /* U+774e */
  0x0000, /* U+774f */
  0x0000, /* U+7750 */
  0x0000, /* U+7751 */
  0x0000, /* U+7752 */
  0x0000, /* U+7753 */
  0x0000, /* U+7754 */
  0x0000, /* U+7755 */
  0x0000, /* U+7756 */
  0x0000, /* U+7757 */
  0x0000, /* U+7758 */
  0x0000, /* U+7759 */
  0xe1c8, /* U+775a */
  0xe1cb, /* U+775b */
  0x0000, /* U+775c */
  0x0000, /* U+775d */
  0x0000, /* U+775e */
  0x0000, /* U+775f */
  0x0000, /* U+7760 */
  0x9087, /* U+7761 */
  0x0000, /* U+7762 */
  0x93c2, /* U+7763 */
  0x0000, /* U+7764 */
  0xe1cc, /* U+7765 */
  0x9672, /* U+7766 */
  0x0000, /* U+7767 */
  0xe1c9, /* U+7768 */
  0x0000, /* U+7769 */
  0x0000, /* U+776a */
  0xe1ca, /* U+776b */
  0x0000, /* U+776c */
  0x0000, /* U+776d */
  0x0000, /* U+776e */
  0x0000, /* U+776f */
  0x0000, /* U+7770 */
  0x0000, /* U+7771 */
  0x0000, /* U+7772 */
  0x0000, /* U+7773 */
  0x0000, /* U+7774 */
  0x0000, /* U+7775 */
  0x0000, /* U+7776 */
  0x0000, /* U+7777 */
  0x0000, /* U+7778 */
  0xe1cf, /* U+7779 */
  0x0000, /* U+777a */
  0x0000, /* U+777b */
  0x0000, /* U+777c */
  0x0000, /* U+777d */
  0xe1ce, /* U+777e */
  0xe1cd, /* U+777f */
  0x0000, /* U+7780 */
  0x0000, /* U+7781 */
  0x0000, /* U+7782 */
  0x0000, /* U+7783 */
  0x0000, /* U+7784 */
  0x0000, /* U+7785 */
  0x0000, /* U+7786 */
  0x0000, /* U+7787 */
  0x0000, /* U+7788 */
  0x0000, /* U+7789 */
  0x0000, /* U+778a */
  0xe1d1, /* U+778b */
  0x0000, /* U+778c */
  0x0000, /* U+778d */
  0xe1d0, /* U+778e */
  0x0000, /* U+778f */
  0x0000, /* U+7790 */
  0xe1d2, /* U+7791 */
  0x0000, /* U+7792 */
  0x0000, /* U+7793 */
  0x0000, /* U+7794 */
  0x0000, /* U+7795 */
  0x0000, /* U+7796 */
  0x0000, /* U+7797 */
  0x0000, /* U+7798 */
  0x0000, /* U+7799 */
  0x0000, /* U+779a */
  0x0000, /* U+779b */
  0x0000, /* U+779c */
  0x0000, /* U+779d */
  0xe1d4, /* U+779e */
  0x0000, /* U+779f */
  0xe1d3, /* U+77a0 */
  0x0000, /* U+77a1 */
  0x0000, /* U+77a2 */
  0x0000, /* U+77a3 */
  0x0000, /* U+77a4 */
  0x95cb, /* U+77a5 */
  0x0000, /* U+77a6 */
  0x0000, /* U+77a7 */
  0x0000, /* U+77a8 */
  0x0000, /* U+77a9 */
  0x0000, /* U+77aa */
  0x0000, /* U+77ab */
  0x8f75, /* U+77ac */
  0x97c4, /* U+77ad */
  0x0000, /* U+77ae */
  0x0000, /* U+77af */
  0xe1d5, /* U+77b0 */
  0x0000, /* U+77b1 */
  0x0000, /* U+77b2 */
  0x93b5, /* U+77b3 */
  0x0000, /* U+77b4 */
  0x0000, /* U+77b5 */
  0xe1d6, /* U+77b6 */
  0x0000, /* U+77b7 */
  0x0000, /* U+77b8 */
  0xe1d7, /* U+77b9 */
  0x0000, /* U+77ba */
  0xe1db, /* U+77bb */
  0xe1d9, /* U+77bc */
  0xe1da, /* U+77bd */
  0x0000, /* U+77be */
  0xe1d8, /* U+77bf */
  0x0000, /* U+77c0 */
  0x0000, /* U+77c1 */
  0x0000, /* U+77c2 */
  0x0000, /* U+77c3 */
  0x0000, /* U+77c4 */
  0x0000, /* U+77c5 */
  0x0000, /* U+77c6 */
  0xe1dc, /* U+77c7 */
  0x0000, /* U+77c8 */
  0x0000, /* U+77c9 */
  0x0000, /* U+77ca */
  0x0000, /* U+77cb */
  0x0000, /* U+77cc */
  0xe1dd, /* U+77cd */
  0x0000, /* U+77ce */
  0x0000, /* U+77cf */
  0x0000, /* U+77d0 */
  0x0000, /* U+77d1 */
  0x0000, /* U+77d2 */
  0x0000, /* U+77d3 */
  0x0000, /* U+77d4 */
  0x0000, /* U+77d5 */
  0x0000, /* U+77d6 */
  0xe1de, /* U+77d7 */
  0x0000, /* U+77d8 */
  0x0000, /* U+77d9 */
  0xe1df, /* U+77da */
  0x96b5, /* U+77db */
  0xe1e0, /* U+77dc */
  0x0000, /* U+77dd */
  0x0000, /* U+77de */
  0x0000, /* U+77df */
  0x0000, /* U+77e0 */
  0x0000, /* U+77e1 */
  0x96ee, /* U+77e2 */
  0xe1e1, /* U+77e3 */
  0x0000, /* U+77e4 */
  0x926d, /* U+77e5 */
  0x0000, /* U+77e6 */
  0x948a, /* U+77e7 */
  0x0000, /* U+77e8 */
  0x8be9, /* U+77e9 */
  0x0000, /* U+77ea */
  0x0000, /* U+77eb */
  0x0000, /* U+77ec */
  0x925a, /* U+77ed */
  0xe1e2, /* U+77ee */
  0x8bb8, /* U+77ef */
  0x0000, /* U+77f0 */
  0x0000, /* U+77f1 */
  0x0000, /* U+77f2 */
  0x90ce, /* U+77f3 */
  0x0000, /* U+77f4 */
  0x0000, /* U+77f5 */
  0x0000, /* U+77f6 */
  0x0000, /* U+77f7 */
  0x0000, /* U+77f8 */
  0x0000, /* U+77f9 */
  0x0000, /* U+77fa */
  0x0000, /* U+77fb */
  0xe1e3, /* U+77fc */
  0x0000, /* U+77fd */
  0x0000, /* U+77fe */
  0x0000, /* U+77ff */
  0x0000, /* U+7800 */
  0x0000, /* U+7801 */
  0x8dbb, /* U+7802 */
  0x0000, /* U+7803 */
  0x0000, /* U+7804 */
  0x0000, /* U+7805 */
  0x0000, /* U+7806 */
  0x0000, /* U+7807 */
  0x0000, /* U+7808 */
  0x0000, /* U+7809 */
  0x0000, /* U+780a */
  0x0000, /* U+780b */
  0xe1e4, /* U+780c */
  0x0000, /* U+780d */
  0x0000, /* U+780e */
  0x0000, /* U+780f */
  0x0000, /* U+7810 */
  0x0000, /* U+7811 */
  0xe1e5, /* U+7812 */
  0x0000, /* U+7813 */
  0x8ca4, /* U+7814 */
  0x8dd3, /* U+7815 */
  0x0000, /* U+7816 */
  0x0000, /* U+7817 */
  0x0000, /* U+7818 */
  0x0000, /* U+7819 */
  0x0000, /* U+781a */
  0x0000, /* U+781b */
  0x0000, /* U+781c */
  0x0000, /* U+781d */
  0x0000, /* U+781e */
  0x0000, /* U+781f */
  0xe1e7, /* U+7820 */
  0xfb78, /* U+7821 */
  0x0000, /* U+7822 */
  0x0000, /* U+7823 */
  0x0000, /* U+7824 */
  0x9375, /* U+7825 */
  0x8dd4, /* U+7826 */
  0x8b6d, /* U+7827 */
  0x0000, /* U+7828 */
  0x0000, /* U+7829 */
  0x0000, /* U+782a */
  0x0000, /* U+782b */
  0x0000, /* U+782c */
  0x0000, /* U+782d */
  0x0000, /* U+782e */
  0x0000, /* U+782f */
  0x0000, /* U+7830 */
  0x0000, /* U+7831 */
  0x9643, /* U+7832 */
  0x0000, /* U+7833 */
  0x946a, /* U+7834 */
  0x0000, /* U+7835 */
  0x0000, /* U+7836 */
  0x0000, /* U+7837 */
  0x0000, /* U+7838 */
  0x0000, /* U+7839 */
  0x9376, /* U+783a */
  0x0000, /* U+783b */
  0x0000, /* U+783c */
  0x0000, /* U+783d */
  0x0000, /* U+783e */
  0x8d7b, /* U+783f */
  0x0000, /* U+7840 */
  0x0000, /* U+7841 */
  0x0000, /* U+7842 */
  0x0000, /* U+7843 */
  0x0000, /* U+7844 */
  0xe1e9, /* U+7845 */
  0x0000, /* U+7846 */
  0x0000, /* U+7847 */
  0x0000, /* U+7848 */
  0x0000, /* U+7849 */
  0x0000, /* U+784a */
  0x0000, /* U+784b */
  0x0000, /* U+784c */
  0x0000, /* U+784d */
  0xfb79, /* U+784e */
  0x0000, /* U+784f */
  0x0000, /* U+7850 */
  0x0000, /* U+7851 */
  0x0000, /* U+7852 */
  0x0000, /* U+7853 */
  0x0000, /* U+7854 */
  0x0000, /* U+7855 */
  0x0000, /* U+7856 */
  0x0000, /* U+7857 */
  0x0000, /* U+7858 */
  0x0000, /* U+7859 */
  0x0000, /* U+785a */
  0x0000, /* U+785b */
  0x0000, /* U+785c */
  0x8fc9, /* U+785d */
  0x0000, /* U+785e */
  0x0000, /* U+785f */
  0x0000, /* U+7860 */
  0x0000, /* U+7861 */
  0x0000, /* U+7862 */
  0x0000, /* U+7863 */
  0xfb7a, /* U+7864 */
  0x0000, /* U+7865 */
  0x0000, /* U+7866 */
  0x0000, /* U+7867 */
  0x0000, /* U+7868 */
  0x0000, /* U+7869 */
  0x0000, /* U+786a */
  0x97b0, /* U+786b */
  0x8d64, /* U+786c */
  0x0000, /* U+786d */
  0x0000, /* U+786e */
  0x8ca5, /* U+786f */
  0x0000, /* U+7870 */
  0x0000, /* U+7871 */
  0x94a1, /* U+7872 */
  0x0000, /* U+7873 */
  0xe1eb, /* U+7874 */
  0x0000, /* U+7875 */
  0x0000, /* U+7876 */
  0x0000, /* U+7877 */
  0x0000, /* U+7878 */
  0x0000, /* U+7879 */
  0xfb7b, /* U+787a */
  0x0000, /* U+787b */
  0xe1ed, /* U+787c */
  0x0000, /* U+787d */
  0x0000, /* U+787e */
  0x0000, /* U+787f */
  0x0000, /* U+7880 */
  0x8ce9, /* U+7881 */
  0x0000, /* U+7882 */
  0x0000, /* U+7883 */
  0x0000, /* U+7884 */
  0x0000, /* U+7885 */
  0xe1ec, /* U+7886 */
  0x92f4, /* U+7887 */
  0x0000, /* U+7888 */
  0x0000, /* U+7889 */
  0x0000, /* U+788a */
  0x0000, /* U+788b */
  0xe1ef, /* U+788c */
  0x8a56, /* U+788d */
  0xe1ea, /* U+788e */
  0x0000, /* U+788f */
  0x0000, /* U+7890 */
  0x94e8, /* U+7891 */
  0x0000, /* U+7892 */
  0x894f, /* U+7893 */
  0x0000, /* U+7894 */
  0x8dea, /* U+7895 */
  0x0000, /* U+7896 */
  0x9871, /* U+7897 */
  0x0000, /* U+7898 */
  0x0000, /* U+7899 */
  0xe1ee, /* U+789a */
  0x0000, /* U+789b */
  0x0000, /* U+789c */
  0x0000, /* U+789d */
  0x0000, /* U+789e */
  0x0000, /* U+789f */
  0x0000, /* U+78a0 */
  0x0000, /* U+78a1 */
  0x0000, /* U+78a2 */
  0xe1f0, /* U+78a3 */
  0x0000, /* U+78a4 */
  0x0000, /* U+78a5 */
  0x0000, /* U+78a6 */
  0x95c9, /* U+78a7 */
  0x0000, /* U+78a8 */
  0x90d7, /* U+78a9 */
  0xe1f2, /* U+78aa */
  0x0000, /* U+78ab */
  0x0000, /* U+78ac */
  0x0000, /* U+78ad */
  0x0000, /* U+78ae */
  0xe1f3, /* U+78af */
  0x0000, /* U+78b0 */
  0x0000, /* U+78b1 */
  0x0000, /* U+78b2 */
  0x0000, /* U+78b3 */
  0x0000, /* U+78b4 */
  0xe1f1, /* U+78b5 */
  0x0000, /* U+78b6 */
  0x0000, /* U+78b7 */
  0x0000, /* U+78b8 */
  0x0000, /* U+78b9 */
  0x8a6d, /* U+78ba */
  0x0000, /* U+78bb */
  0xe1f9, /* U+78bc */
  0x0000, /* U+78bd */
  0xe1f8, /* U+78be */
  0x0000, /* U+78bf */
  0x0000, /* U+78c0 */
  0x8ea5, /* U+78c1 */
  0x0000, /* U+78c2 */
  0x0000, /* U+78c3 */
  0x0000, /* U+78c4 */
  0xe1fa, /* U+78c5 */
  0xe1f5, /* U+78c6 */
  0x0000, /* U+78c7 */
  0x0000, /* U+78c8 */
  0x0000, /* U+78c9 */
  0xe1fb, /* U+78ca */
  0xe1f6, /* U+78cb */
  0x0000, /* U+78cc */
  0x0000, /* U+78cd */
  0x0000, /* U+78ce */
  0x0000, /* U+78cf */
  0x94d6, /* U+78d0 */
  0xe1f4, /* U+78d1 */
  0x0000, /* U+78d2 */
  0x0000, /* U+78d3 */
  0xe1f7, /* U+78d4 */
  0x0000, /* U+78d5 */
  0x0000, /* U+78d6 */
  0x0000, /* U+78d7 */
  0x0000, /* U+78d8 */
  0x0000, /* U+78d9 */
  0xe241, /* U+78da */
  0x0000, /* U+78db */
  0x0000, /* U+78dc */
  0x0000, /* U+78dd */
  0x0000, /* U+78de */
  0x0000, /* U+78df */
  0x0000, /* U+78e0 */
  0x0000, /* U+78e1 */
  0x0000, /* U+78e2 */
  0x0000, /* U+78e3 */
  0x0000, /* U+78e4 */
  0x0000, /* U+78e5 */
  0x0000, /* U+78e6 */
  0xe240, /* U+78e7 */
  0x9681, /* U+78e8 */
  0x0000, /* U+78e9 */
  0x0000, /* U+78ea */
  0x0000, /* U+78eb */
  0xe1fc, /* U+78ec */
  0x0000, /* U+78ed */
  0x0000, /* U+78ee */
  0x88e9, /* U+78ef */
  0x0000, /* U+78f0 */
  0x0000, /* U+78f1 */
  0x0000, /* U+78f2 */
  0x0000, /* U+78f3 */
  0xe243, /* U+78f4 */
  0x0000, /* U+78f5 */
  0x0000, /* U+78f6 */
  0x0000, /* U+78f7 */
  0x0000, /* U+78f8 */
  0x0000, /* U+78f9 */
  0x0000, /* U+78fa */
  0x0000, /* U+78fb */
  0x0000, /* U+78fc */
  0xe242, /* U+78fd */
  0x0000, /* U+78fe */
  0x0000, /* U+78ff */
  0x0000, /* U+7900 */
  0x8fca, /* U+7901 */
  0x0000, /* U+7902 */
  0x0000, /* U+7903 */
  0x0000, /* U+7904 */
  0x0000, /* U+7905 */
  0x0000, /* U+7906 */
  0xe244, /* U+7907 */
  0x0000, /* U+7908 */
  0x0000, /* U+7909 */
  0x0000, /* U+790a */
  0x0000, /* U+790b */
  0x0000, /* U+790c */
  0x0000, /* U+790d */
  0x9162, /* U+790e */
  0x0000, /* U+790f */
  0x0000, /* U+7910 */
  0xe246, /* U+7911 */
  0xe245, /* U+7912 */
  0x0000, /* U+7913 */
  0x0000, /* U+7914 */
  0x0000, /* U+7915 */
  0x0000, /* U+7916 */
  0x0000, /* U+7917 */
  0x0000, /* U+7918 */
  0xe247, /* U+7919 */
  0x0000, /* U+791a */
  0x0000, /* U+791b */
  0x0000, /* U+791c */
  0x0000, /* U+791d */
  0x0000, /* U+791e */
  0x0000, /* U+791f */
  0x0000, /* U+7920 */
  0x0000, /* U+7921 */
  0x0000, /* U+7922 */
  0x0000, /* U+7923 */
  0x0000, /* U+7924 */
  0x0000, /* U+7925 */
  0xe1e6, /* U+7926 */
  0x0000, /* U+7927 */
  0x0000, /* U+7928 */
  0x0000, /* U+7929 */
  0xe1e8, /* U+792a */
  0xe249, /* U+792b */
  0xe248, /* U+792c */
  0x0000, /* U+792d */
  0x0000, /* U+792e */
  0x0000, /* U+792f */
  0xfb7c, /* U+7930 */
  0x0000, /* U+7931 */
  0x0000, /* U+7932 */
  0x0000, /* U+7933 */
  0x0000, /* U+7934 */
  0x0000, /* U+7935 */
  0x0000, /* U+7936 */
  0x0000, /* U+7937 */
  0x0000, /* U+7938 */
  0x0000, /* U+7939 */
  0x8ea6, /* U+793a */
  0x0000, /* U+793b */
  0x97e7, /* U+793c */
  0x0000, /* U+793d */
  0x8ed0, /* U+793e */
  0x0000, /* U+793f */
  0xe24a, /* U+7940 */
  0x8c56, /* U+7941 */
  0x0000, /* U+7942 */
  0x0000, /* U+7943 */
  0x0000, /* U+7944 */
  0x0000, /* U+7945 */
  0x0000, /* U+7946 */
  0x8b5f, /* U+7947 */
  0x8b46, /* U+7948 */
  0x8e83, /* U+7949 */
  0x0000, /* U+794a */
  0x0000, /* U+794b */
  0x0000, /* U+794c */
  0x0000, /* U+794d */
  0x0000, /* U+794e */
  0x0000, /* U+794f */
  0x9753, /* U+7950 */
  0x0000, /* U+7951 */
  0x0000, /* U+7952 */
  0xe250, /* U+7953 */
  0x0000, /* U+7954 */
  0xe24f, /* U+7955 */
  0x9163, /* U+7956 */
  0xe24c, /* U+7957 */
  0x0000, /* U+7958 */
  0x0000, /* U+7959 */
  0xe24e, /* U+795a */
  0x0000, /* U+795b */
  0x0000, /* U+795c */
  0x8f6a, /* U+795d */
  0x905f, /* U+795e */
  0xe24d, /* U+795f */
  0xe24b, /* U+7960 */
  0x0000, /* U+7961 */
  0x9449, /* U+7962 */
  0x0000, /* U+7963 */
  0x0000, /* U+7964 */
  0x8fcb, /* U+7965 */
  0x0000, /* U+7966 */
  0x0000, /* U+7967 */
  0x955b, /* U+7968 */
  0x0000, /* U+7969 */
  0x0000, /* U+796a */
  0x0000, /* U+796b */
  0x0000, /* U+796c */
  0x8dd5, /* U+796d */
  0x0000, /* U+796e */
  0x0000, /* U+796f */
  0x0000, /* U+7970 */
  0x0000, /* U+7971 */
  0x0000, /* U+7972 */
  0x0000, /* U+7973 */
  0x0000, /* U+7974 */
  0x0000, /* U+7975 */
  0x0000, /* U+7976 */
  0x9398, /* U+7977 */
  0x0000, /* U+7978 */
  0x0000, /* U+7979 */
  0xe251, /* U+797a */
  0x0000, /* U+797b */
  0x0000, /* U+797c */
  0x0000, /* U+797d */
  0x0000, /* U+797e */
  0xe252, /* U+797f */
  0xe268, /* U+7980 */
  0x8bd6, /* U+7981 */
  0x0000, /* U+7982 */
  0x0000, /* U+7983 */
  0x985c, /* U+7984 */
  0x9154, /* U+7985 */
  0x0000, /* U+7986 */
  0x0000, /* U+7987 */
  0x0000, /* U+7988 */
  0x0000, /* U+7989 */
  0xe253, /* U+798a */
  0x0000, /* U+798b */
  0x0000, /* U+798c */
  0x89d0, /* U+798d */
  0x92f5, /* U+798e */
  0x959f, /* U+798f */
  0x0000, /* U+7990 */
  0x0000, /* U+7991 */
  0x0000, /* U+7992 */
  0x0000, /* U+7993 */
  0xfb81, /* U+7994 */
  0x0000, /* U+7995 */
  0x0000, /* U+7996 */
  0x0000, /* U+7997 */
  0x0000, /* U+7998 */
  0x0000, /* U+7999 */
  0x0000, /* U+799a */
  0xfb83, /* U+799b */
  0x0000, /* U+799c */
  0xe254, /* U+799d */
  0x0000, /* U+799e */
  0x0000, /* U+799f */
  0x0000, /* U+79a0 */
  0x0000, /* U+79a1 */
  0x0000, /* U+79a2 */
  0x0000, /* U+79a3 */
  0x0000, /* U+79a4 */
  0x0000, /* U+79a5 */
  0x8b9a, /* U+79a6 */
  0xe255, /* U+79a7 */
  0x0000, /* U+79a8 */
  0x0000, /* U+79a9 */
  0xe257, /* U+79aa */
  0x0000, /* U+79ab */
  0x0000, /* U+79ac */
  0x0000, /* U+79ad */
  0xe258, /* U+79ae */
  0x0000, /* U+79af */
  0x9448, /* U+79b0 */
  0x0000, /* U+79b1 */
  0x0000, /* U+79b2 */
  0xe259, /* U+79b3 */
  0x0000, /* U+79b4 */
  0x0000, /* U+79b5 */
  0x0000, /* U+79b6 */
  0x0000, /* U+79b7 */
  0x0000, /* U+79b8 */
  0xe25a, /* U+79b9 */
  0xe25b, /* U+79ba */
  0x0000, /* U+79bb */
  0x0000, /* U+79bc */
  0x8bd7, /* U+79bd */
  0x89d1, /* U+79be */
  0x93c3, /* U+79bf */
  0x8f47, /* U+79c0 */
  0x8e84, /* U+79c1 */
  0x0000, /* U+79c2 */
  0x0000, /* U+79c3 */
  0x0000, /* U+79c4 */
  0x0000, /* U+79c5 */
  0x0000, /* U+79c6 */
  0x0000, /* U+79c7 */
  0x0000, /* U+79c8 */
  0xe25c, /* U+79c9 */
  0x0000, /* U+79ca */
  0x8f48, /* U+79cb */
  0x0000, /* U+79cc */
  0x0000, /* U+79cd */
  0x0000, /* U+79ce */
  0x0000, /* U+79cf */
  0x0000, /* U+79d0 */
  0x89c8, /* U+79d1 */
  0x9562, /* U+79d2 */
  0x0000, /* U+79d3 */
  0x0000, /* U+79d4 */
  0xe25d, /* U+79d5 */
  0x0000, /* U+79d6 */
  0x0000, /* U+79d7 */
  0x94e9, /* U+79d8 */
  0x0000, /* U+79d9 */
  0x0000, /* U+79da */
  0x0000, /* U+79db */
  0x0000, /* U+79dc */
  0x0000, /* U+79dd */
  0x0000, /* U+79de */
  0x9164, /* U+79df */
  0x0000, /* U+79e0 */
  0xe260, /* U+79e1 */
  0x0000, /* U+79e2 */
  0xe261, /* U+79e3 */
  0x9489, /* U+79e4 */
  0x0000, /* U+79e5 */
  0x9060, /* U+79e6 */
  0xe25e, /* U+79e7 */
  0x0000, /* U+79e8 */
  0x9281, /* U+79e9 */
  0x0000, /* U+79ea */
  0x0000, /* U+79eb */
  0xe25f, /* U+79ec */
  0x0000, /* U+79ed */
  0x0000, /* U+79ee */
  0x0000, /* U+79ef */
  0x8fcc, /* U+79f0 */
  0x0000, /* U+79f1 */
  0x0000, /* U+79f2 */
  0x0000, /* U+79f3 */
  0x0000, /* U+79f4 */
  0x0000, /* U+79f5 */
  0x0000, /* U+79f6 */
  0x0000, /* U+79f7 */
  0x0000, /* U+79f8 */
  0x0000, /* U+79f9 */
  0x0000, /* U+79fa */
  0x88da, /* U+79fb */
  0x0000, /* U+79fc */
  0x0000, /* U+79fd */
  0x0000, /* U+79fe */
  0x0000, /* U+79ff */
  0x8b48, /* U+7a00 */
  0x0000, /* U+7a01 */
  0x0000, /* U+7a02 */
  0x0000, /* U+7a03 */
  0x0000, /* U+7a04 */
  0x0000, /* U+7a05 */
  0x0000, /* U+7a06 */
  0x0000, /* U+7a07 */
  0xe262, /* U+7a08 */
  0x0000, /* U+7a09 */
  0x0000, /* U+7a0a */
  0x92f6, /* U+7a0b */
  0x0000, /* U+7a0c */
  0xe263, /* U+7a0d */
  0x90c5, /* U+7a0e */
  0x0000, /* U+7a0f */
  0x0000, /* U+7a10 */
  0x0000, /* U+7a11 */
  0x0000, /* U+7a12 */
  0x0000, /* U+7a13 */
  0x96ab, /* U+7a14 */
  0x0000, /* U+7a15 */
  0x0000, /* U+7a16 */
  0x9542, /* U+7a17 */
  0xe264, /* U+7a18 */
  0xe265, /* U+7a19 */
  0x9274, /* U+7a1a */
  0x0000, /* U+7a1b */
  0x97c5, /* U+7a1c */
  0x0000, /* U+7a1d */
  0x0000, /* U+7a1e */
  0xe267, /* U+7a1f */
  0xe266, /* U+7a20 */
  0x0000, /* U+7a21 */
  0x0000, /* U+7a22 */
  0x0000, /* U+7a23 */
  0x0000, /* U+7a24 */
  0x0000, /* U+7a25 */
  0x0000, /* U+7a26 */
  0x0000, /* U+7a27 */
  0x0000, /* U+7a28 */
  0x0000, /* U+7a29 */
  0x0000, /* U+7a2a */
  0x0000, /* U+7a2b */
  0x0000, /* U+7a2c */
  0x0000, /* U+7a2d */
  0x8eed, /* U+7a2e */
  0x0000, /* U+7a2f */
  0x0000, /* U+7a30 */
  0xe269, /* U+7a31 */
  0x88ee, /* U+7a32 */
  0x0000, /* U+7a33 */
  0x0000, /* U+7a34 */
  0x0000, /* U+7a35 */
  0x0000, /* U+7a36 */
  0xe26c, /* U+7a37 */
  0x0000, /* U+7a38 */
  0x0000, /* U+7a39 */
  0x0000, /* U+7a3a */
  0xe26a, /* U+7a3b */
  0x89d2, /* U+7a3c */
  0x8c6d, /* U+7a3d */
  0xe26b, /* U+7a3e */
  0x8d65, /* U+7a3f */
  0x8d92, /* U+7a40 */
  0x0000, /* U+7a41 */
  0x95e4, /* U+7a42 */
  0xe26d, /* U+7a43 */
  0x0000, /* U+7a44 */
  0x0000, /* U+7a45 */
  0x9673, /* U+7a46 */
  0x0000, /* U+7a47 */
  0x0000, /* U+7a48 */
  0xe26f, /* U+7a49 */
  0x0000, /* U+7a4a */
  0x0000, /* U+7a4b */
  0x0000, /* U+7a4c */
  0x90cf, /* U+7a4d */
  0x896e, /* U+7a4e */
  0x89b8, /* U+7a4f */
  0x88aa, /* U+7a50 */
  0x0000, /* U+7a51 */
  0x0000, /* U+7a52 */
  0x0000, /* U+7a53 */
  0x0000, /* U+7a54 */
  0x0000, /* U+7a55 */
  0x0000, /* U+7a56 */
  0xe26e, /* U+7a57 */
  0x0000, /* U+7a58 */
  0x0000, /* U+7a59 */
  0x0000, /* U+7a5a */
  0x0000, /* U+7a5b */
  0x0000, /* U+7a5c */
  0x0000, /* U+7a5d */
  0x0000, /* U+7a5e */
  0x0000, /* U+7a5f */
  0x0000, /* U+7a60 */
  0xe270, /* U+7a61 */
  0xe271, /* U+7a62 */
  0x8ff5, /* U+7a63 */
  0x0000, /* U+7a64 */
  0x0000, /* U+7a65 */
  0x0000, /* U+7a66 */
  0x0000, /* U+7a67 */
  0x0000, /* U+7a68 */
  0xe272, /* U+7a69 */
  0x0000, /* U+7a6a */
  0x8a6e, /* U+7a6b */
  0x0000, /* U+7a6c */
  0x0000, /* U+7a6d */
  0x0000, /* U+7a6e */
  0x0000, /* U+7a6f */
  0xe274, /* U+7a70 */
  0x0000, /* U+7a71 */
  0x0000, /* U+7a72 */
  0x0000, /* U+7a73 */
  0x8c8a, /* U+7a74 */
  0x0000, /* U+7a75 */
  0x8b86, /* U+7a76 */
  0x0000, /* U+7a77 */
  0x0000, /* U+7a78 */
  0xe275, /* U+7a79 */
  0x8bf3, /* U+7a7a */
  0x0000, /* U+7a7b */
  0x0000, /* U+7a7c */
  0xe276, /* U+7a7d */
  0x0000, /* U+7a7e */
  0x90fa, /* U+7a7f */
  0x0000, /* U+7a80 */
  0x93cb, /* U+7a81 */
  0x0000, /* U+7a82 */
  0x90de, /* U+7a83 */
  0x8df3, /* U+7a84 */
  0x0000, /* U+7a85 */
  0x0000, /* U+7a86 */
  0x0000, /* U+7a87 */
  0xe277, /* U+7a88 */
  0x0000, /* U+7a89 */
  0x0000, /* U+7a8a */
  0x0000, /* U+7a8b */
  0x0000, /* U+7a8c */
  0x0000, /* U+7a8d */
  0x0000, /* U+7a8e */
  0x0000, /* U+7a8f */
  0x0000, /* U+7a90 */
  0x0000, /* U+7a91 */
  0x9282, /* U+7a92 */
  0x918b, /* U+7a93 */
  0x0000, /* U+7a94 */
  0xe279, /* U+7a95 */
  0xe27b, /* U+7a96 */
  0xe278, /* U+7a97 */
  0xe27a, /* U+7a98 */
  0x0000, /* U+7a99 */
  0x0000, /* U+7a9a */
  0x0000, /* U+7a9b */
  0x0000, /* U+7a9c */
  0x0000, /* U+7a9d */
  0x0000, /* U+7a9e */
  0x8c41, /* U+7a9f */
  0x0000, /* U+7aa0 */
  0x0000, /* U+7aa1 */
  0x0000, /* U+7aa2 */
  0x0000, /* U+7aa3 */
  0x0000, /* U+7aa4 */
  0x0000, /* U+7aa5 */
  0x0000, /* U+7aa6 */
  0x0000, /* U+7aa7 */
  0x0000, /* U+7aa8 */
  0xe27c, /* U+7aa9 */
  0x8c45, /* U+7aaa */
  0x0000, /* U+7aab */
  0x0000, /* U+7aac */
  0x0000, /* U+7aad */
  0x8b87, /* U+7aae */
  0x9771, /* U+7aaf */
  0xe27e, /* U+7ab0 */
  0x0000, /* U+7ab1 */
  0x0000, /* U+7ab2 */
  0x0000, /* U+7ab3 */
  0x0000, /* U+7ab4 */
  0x0000, /* U+7ab5 */
  0xe280, /* U+7ab6 */
  0x0000, /* U+7ab7 */
  0x0000, /* U+7ab8 */
  0x0000, /* U+7ab9 */
  0x894d, /* U+7aba */
  0x0000, /* U+7abb */
  0x0000, /* U+7abc */
  0x0000, /* U+7abd */
  0x0000, /* U+7abe */
  0xe283, /* U+7abf */
  0x0000, /* U+7ac0 */
  0x0000, /* U+7ac1 */
  0x0000, /* U+7ac2 */
  0x8a96, /* U+7ac3 */
  0xe282, /* U+7ac4 */
  0xe281, /* U+7ac5 */
  0x0000, /* U+7ac6 */
  0xe285, /* U+7ac7 */
  0xe27d, /* U+7ac8 */
  0x0000, /* U+7ac9 */
  0xe286, /* U+7aca */
  0x97a7, /* U+7acb */
  0x0000, /* U+7acc */
  0xe287, /* U+7acd */
  0x0000, /* U+7ace */
  0xe288, /* U+7acf */
  0x0000, /* U+7ad0 */
  0xfb84, /* U+7ad1 */
  0x9af2, /* U+7ad2 */
  0xe28a, /* U+7ad3 */
  0x0000, /* U+7ad4 */
  0xe289, /* U+7ad5 */
  0x0000, /* U+7ad6 */
  0x0000, /* U+7ad7 */
  0x0000, /* U+7ad8 */
  0xe28b, /* U+7ad9 */
  0xe28c, /* U+7ada */
  0x0000, /* U+7adb */
  0x97b3, /* U+7adc */
  0xe28d, /* U+7add */
  0x0000, /* U+7ade */
  0xe8ed, /* U+7adf */
  0x8fcd, /* U+7ae0 */
  0xe28e, /* U+7ae1 */
  0xe28f, /* U+7ae2 */
  0x8f76, /* U+7ae3 */
  0x0000, /* U+7ae4 */
  0x93b6, /* U+7ae5 */
  0xe290, /* U+7ae6 */
  0xfb85, /* U+7ae7 */
  0x0000, /* U+7ae8 */
  0x0000, /* U+7ae9 */
  0x9247, /* U+7aea */
  0xfb87, /* U+7aeb */
  0x0000, /* U+7aec */
  0xe291, /* U+7aed */
  0x0000, /* U+7aee */
  0x925b, /* U+7aef */
  0xe292, /* U+7af0 */
  0x0000, /* U+7af1 */
  0x0000, /* U+7af2 */
  0x0000, /* U+7af3 */
  0x0000, /* U+7af4 */
  0x0000, /* U+7af5 */
  0x8ba3, /* U+7af6 */
  0x0000, /* U+7af7 */
  0x995e, /* U+7af8 */
  0x927c, /* U+7af9 */
  0x8eb1, /* U+7afa */
  0x0000, /* U+7afb */
  0x0000, /* U+7afc */
  0x0000, /* U+7afd */
  0x0000, /* U+7afe */
  0x8ac6, /* U+7aff */
  0x0000, /* U+7b00 */
  0x0000, /* U+7b01 */
  0xe293, /* U+7b02 */
  0x0000, /* U+7b03 */
  0xe2a0, /* U+7b04 */
  0x0000, /* U+7b05 */
  0xe296, /* U+7b06 */
  0x0000, /* U+7b07 */
  0x8b88, /* U+7b08 */
  0x0000, /* U+7b09 */
  0xe295, /* U+7b0a */
  0xe2a2, /* U+7b0b */
  0x0000, /* U+7b0c */
  0x0000, /* U+7b0d */
  0x0000, /* U+7b0e */
  0xe294, /* U+7b0f */
  0x0000, /* U+7b10 */
  0x8fce, /* U+7b11 */
  0x0000, /* U+7b12 */
  0x0000, /* U+7b13 */
  0x0000, /* U+7b14 */
  0x0000, /* U+7b15 */
  0x0000, /* U+7b16 */
  0x0000, /* U+7b17 */
  0xe298, /* U+7b18 */
  0xe299, /* U+7b19 */
  0x0000, /* U+7b1a */
  0x934a, /* U+7b1b */
  0x0000, /* U+7b1c */
  0x0000, /* U+7b1d */
  0xe29a, /* U+7b1e */
  0x0000, /* U+7b1f */
  0x8a7d, /* U+7b20 */
  0x0000, /* U+7b21 */
  0x0000, /* U+7b22 */
  0x0000, /* U+7b23 */
  0x0000, /* U+7b24 */
  0x9079, /* U+7b25 */
  0x9584, /* U+7b26 */
  0x0000, /* U+7b27 */
  0xe29c, /* U+7b28 */
  0x0000, /* U+7b29 */
  0x0000, /* U+7b2a */
  0x0000, /* U+7b2b */
  0x91e6, /* U+7b2c */
  0x0000, /* U+7b2d */
  0x0000, /* U+7b2e */
  0x0000, /* U+7b2f */
  0x0000, /* U+7b30 */
  0x0000, /* U+7b31 */
  0x0000, /* U+7b32 */
  0xe297, /* U+7b33 */
  0x0000, /* U+7b34 */
  0xe29b, /* U+7b35 */
  0xe29d, /* U+7b36 */
  0x0000, /* U+7b37 */
  0x0000, /* U+7b38 */
  0x8df9, /* U+7b39 */
  0x0000, /* U+7b3a */
  0x0000, /* U+7b3b */
  0x0000, /* U+7b3c */
  0x0000, /* U+7b3d */
  0x0000, /* U+7b3e */
  0x0000, /* U+7b3f */
  0x0000, /* U+7b40 */
  0x0000, /* U+7b41 */
  0x0000, /* U+7b42 */
  0x0000, /* U+7b43 */
  0x0000, /* U+7b44 */
  0xe2a4, /* U+7b45 */
  0x954d, /* U+7b46 */
  0x0000, /* U+7b47 */
  0x94a4, /* U+7b48 */
  0x9399, /* U+7b49 */
  0x0000, /* U+7b4a */
  0x8bd8, /* U+7b4b */
  0xe2a3, /* U+7b4c */
  0xe2a1, /* U+7b4d */
  0x0000, /* U+7b4e */
  0x94b3, /* U+7b4f */
  0xe29e, /* U+7b50 */
  0x927d, /* U+7b51 */
  0x939b, /* U+7b52 */
  0x0000, /* U+7b53 */
  0x939a, /* U+7b54 */
  0x0000, /* U+7b55 */
  0x8df4, /* U+7b56 */
  0x0000, /* U+7b57 */
  0x0000, /* U+7b58 */
  0x0000, /* U+7b59 */
  0x0000, /* U+7b5a */
  0x0000, /* U+7b5b */
  0x0000, /* U+7b5c */
  0xe2b6, /* U+7b5d */
  0x0000, /* U+7b5e */
  0x0000, /* U+7b5f */
  0x0000, /* U+7b60 */
  0x0000, /* U+7b61 */
  0x0000, /* U+7b62 */
  0x0000, /* U+7b63 */
  0x0000, /* U+7b64 */
  0xe2a6, /* U+7b65 */
  0x0000, /* U+7b66 */
  0xe2a8, /* U+7b67 */
  0x0000, /* U+7b68 */
  0x0000, /* U+7b69 */
  0x0000, /* U+7b6a */
  0x0000, /* U+7b6b */
  0xe2ab, /* U+7b6c */
  0x0000, /* U+7b6d */
  0xe2ac, /* U+7b6e */
  0x0000, /* U+7b6f */
  0xe2a9, /* U+7b70 */
  0xe2aa, /* U+7b71 */
  0x0000, /* U+7b72 */
  0x0000, /* U+7b73 */
  0xe2a7, /* U+7b74 */
  0xe2a5, /* U+7b75 */
  0x0000, /* U+7b76 */
  0x0000, /* U+7b77 */
  0x0000, /* U+7b78 */
  0x0000, /* U+7b79 */
  0xe29f, /* U+7b7a */
  0x0000, /* U+7b7b */
  0x0000, /* U+7b7c */
  0x0000, /* U+7b7d */
  0x0000, /* U+7b7e */
  0x0000, /* U+7b7f */
  0x0000, /* U+7b80 */
  0x0000, /* U+7b81 */
  0x0000, /* U+7b82 */
  0x0000, /* U+7b83 */
  0x0000, /* U+7b84 */
  0x0000, /* U+7b85 */
  0x95cd, /* U+7b86 */
  0x89d3, /* U+7b87 */
  0x0000, /* U+7b88 */
  0x0000, /* U+7b89 */
  0x0000, /* U+7b8a */
  0xe2b3, /* U+7b8b */
  0x0000, /* U+7b8c */
  0xe2b0, /* U+7b8d */
  0x0000, /* U+7b8e */
  0xe2b5, /* U+7b8f */
  0x0000, /* U+7b90 */
  0x0000, /* U+7b91 */
  0xe2b4, /* U+7b92 */
  0x0000, /* U+7b93 */
  0x9493, /* U+7b94 */
  0x96a5, /* U+7b95 */
  0x0000, /* U+7b96 */
  0x8e5a, /* U+7b97 */
  0xe2ae, /* U+7b98 */
  0xe2b7, /* U+7b99 */
  0xe2b2, /* U+7b9a */
  0x0000, /* U+7b9b */
  0xe2b1, /* U+7b9c */
  0xe2ad, /* U+7b9d */
  0xfb88, /* U+7b9e */
  0xe2af, /* U+7b9f */
  0x0000, /* U+7ba0 */
  0x8ac7, /* U+7ba1 */
  0x0000, /* U+7ba2 */
  0x0000, /* U+7ba3 */
  0x0000, /* U+7ba4 */
  0x0000, /* U+7ba5 */
  0x0000, /* U+7ba6 */
  0x0000, /* U+7ba7 */
  0x0000, /* U+7ba8 */
  0x0000, /* U+7ba9 */
  0x925c, /* U+7baa */
  0x0000, /* U+7bab */
  0x0000, /* U+7bac */
  0x90fb, /* U+7bad */
  0x0000, /* U+7bae */
  0x0000, /* U+7baf */
  0x0000, /* U+7bb0 */
  0x94a0, /* U+7bb1 */
  0x0000, /* U+7bb2 */
  0x0000, /* U+7bb3 */
  0xe2bc, /* U+7bb4 */
  0x0000, /* U+7bb5 */
  0x0000, /* U+7bb6 */
  0x0000, /* U+7bb7 */
  0x94a2, /* U+7bb8 */
  0x0000, /* U+7bb9 */
  0x0000, /* U+7bba */
  0x0000, /* U+7bbb */
  0x0000, /* U+7bbc */
  0x0000, /* U+7bbd */
  0x0000, /* U+7bbe */
  0x0000, /* U+7bbf */
  0x90df, /* U+7bc0 */
  0xe2b9, /* U+7bc1 */
  0x0000, /* U+7bc2 */
  0x0000, /* U+7bc3 */
  0x94cd, /* U+7bc4 */
  0x0000, /* U+7bc5 */
  0xe2bd, /* U+7bc6 */
  0x95d1, /* U+7bc7 */
  0x0000, /* U+7bc8 */
  0x927a, /* U+7bc9 */
  0x0000, /* U+7bca */
  0xe2b8, /* U+7bcb */
  0xe2ba, /* U+7bcc */
  0x0000, /* U+7bcd */
  0x0000, /* U+7bce */
  0xe2bb, /* U+7bcf */
  0x0000, /* U+7bd0 */
  0x0000, /* U+7bd1 */
  0x0000, /* U+7bd2 */
  0x0000, /* U+7bd3 */
  0x0000, /* U+7bd4 */
  0x0000, /* U+7bd5 */
  0x0000, /* U+7bd6 */
  0x0000, /* U+7bd7 */
  0x0000, /* U+7bd8 */
  0x0000, /* U+7bd9 */
  0x0000, /* U+7bda */
  0x0000, /* U+7bdb */
  0x0000, /* U+7bdc */
  0xe2be, /* U+7bdd */
  0x0000, /* U+7bde */
  0x0000, /* U+7bdf */
  0x8ec2, /* U+7be0 */
  0x0000, /* U+7be1 */
  0x0000, /* U+7be2 */
  0x0000, /* U+7be3 */
  0x93c4, /* U+7be4 */
  0xe2c3, /* U+7be5 */
  0xe2c2, /* U+7be6 */
  0x0000, /* U+7be7 */
  0x0000, /* U+7be8 */
  0xe2bf, /* U+7be9 */
  0x0000, /* U+7bea */
  0x0000, /* U+7beb */
  0x0000, /* U+7bec */
  0x9855, /* U+7bed */
  0x0000, /* U+7bee */
  0x0000, /* U+7bef */
  0x0000, /* U+7bf0 */
  0x0000, /* U+7bf1 */
  0x0000, /* U+7bf2 */
  0xe2c8, /* U+7bf3 */
  0x0000, /* U+7bf4 */
  0x0000, /* U+7bf5 */
  0xe2cc, /* U+7bf6 */
  0xe2c9, /* U+7bf7 */
  0x0000, /* U+7bf8 */
  0x0000, /* U+7bf9 */
  0x0000, /* U+7bfa */
  0x0000, /* U+7bfb */
  0x0000, /* U+7bfc */
  0x0000, /* U+7bfd */
  0x0000, /* U+7bfe */
  0x0000, /* U+7bff */
  0xe2c5, /* U+7c00 */
  0x0000, /* U+7c01 */
  0x0000, /* U+7c02 */
  0x0000, /* U+7c03 */
  0x0000, /* U+7c04 */
  0x0000, /* U+7c05 */
  0x0000, /* U+7c06 */
  0xe2c6, /* U+7c07 */
  0x0000, /* U+7c08 */
  0x0000, /* U+7c09 */
  0x0000, /* U+7c0a */
  0x0000, /* U+7c0b */
  0x0000, /* U+7c0c */
  0xe2cb, /* U+7c0d */
  0x0000, /* U+7c0e */
  0x0000, /* U+7c0f */
  0x0000, /* U+7c10 */
  0xe2c0, /* U+7c11 */
  0x99d3, /* U+7c12 */
  0xe2c7, /* U+7c13 */
  0xe2c1, /* U+7c14 */
  0x0000, /* U+7c15 */
  0x0000, /* U+7c16 */
  0xe2ca, /* U+7c17 */
  0x0000, /* U+7c18 */
  0x0000, /* U+7c19 */
  0x0000, /* U+7c1a */
  0x0000, /* U+7c1b */
  0x0000, /* U+7c1c */
  0x0000, /* U+7c1d */
  0x0000, /* U+7c1e */
  0xe2d0, /* U+7c1f */
  0x0000, /* U+7c20 */
  0x8ac8, /* U+7c21 */
  0x0000, /* U+7c22 */
  0xe2cd, /* U+7c23 */
  0x0000, /* U+7c24 */
  0x0000, /* U+7c25 */
  0x0000, /* U+7c26 */
  0xe2ce, /* U+7c27 */
  0x0000, /* U+7c28 */
  0x0000, /* U+7c29 */
  0xe2cf, /* U+7c2a */
  0xe2d2, /* U+7c2b */
  0x0000, /* U+7c2c */
  0x0000, /* U+7c2d */
  0x0000, /* U+7c2e */
  0x0000, /* U+7c2f */
  0x0000, /* U+7c30 */
  0x0000, /* U+7c31 */
  0x0000, /* U+7c32 */
  0x0000, /* U+7c33 */
  0x0000, /* U+7c34 */
  0x0000, /* U+7c35 */
  0x0000, /* U+7c36 */
  0xe2d1, /* U+7c37 */
  0x94f4, /* U+7c38 */
  0x0000, /* U+7c39 */
  0x0000, /* U+7c3a */
  0x0000, /* U+7c3b */
  0x0000, /* U+7c3c */
  0xe2d3, /* U+7c3d */
  0x97fa, /* U+7c3e */
  0x95eb, /* U+7c3f */
  0xe2d8, /* U+7c40 */
  0x0000, /* U+7c41 */
  0x0000, /* U+7c42 */
  0xe2d5, /* U+7c43 */
  0x0000, /* U+7c44 */
  0x0000, /* U+7c45 */
  0x0000, /* U+7c46 */
  0x0000, /* U+7c47 */
  0x0000, /* U+7c48 */
  0x0000, /* U+7c49 */
  0x0000, /* U+7c4a */
  0x0000, /* U+7c4b */
  0xe2d4, /* U+7c4c */
  0x90d0, /* U+7c4d */
  0x0000, /* U+7c4e */
  0xe2d7, /* U+7c4f */
  0xe2d9, /* U+7c50 */
  0x0000, /* U+7c51 */
  0x0000, /* U+7c52 */
  0x0000, /* U+7c53 */
  0xe2d6, /* U+7c54 */
  0x0000, /* U+7c55 */
  0xe2dd, /* U+7c56 */
  0x0000, /* U+7c57 */
  0xe2da, /* U+7c58 */
  0x0000, /* U+7c59 */
  0x0000, /* U+7c5a */
  0x0000, /* U+7c5b */
  0x0000, /* U+7c5c */
  0x0000, /* U+7c5d */
  0x0000, /* U+7c5e */
  0xe2db, /* U+7c5f */
  0xe2c4, /* U+7c60 */
  0x0000, /* U+7c61 */
  0x0000, /* U+7c62 */
  0x0000, /* U+7c63 */
  0xe2dc, /* U+7c64 */
  0xe2de, /* U+7c65 */
  0x0000, /* U+7c66 */
  0x0000, /* U+7c67 */
  0x0000, /* U+7c68 */
  0x0000, /* U+7c69 */
  0x0000, /* U+7c6a */
  0x0000, /* U+7c6b */
  0xe2df, /* U+7c6c */
  0x0000, /* U+7c6d */
  0x0000, /* U+7c6e */
  0x0000, /* U+7c6f */
  0x0000, /* U+7c70 */
  0x0000, /* U+7c71 */
  0x0000, /* U+7c72 */
  0x95c4, /* U+7c73 */
  0x0000, /* U+7c74 */
  0xe2e0, /* U+7c75 */
  0x0000, /* U+7c76 */
  0x0000, /* U+7c77 */
  0x0000, /* U+7c78 */
  0x0000, /* U+7c79 */
  0x0000, /* U+7c7a */
  0x0000, /* U+7c7b */
  0x0000, /* U+7c7c */
  0x0000, /* U+7c7d */
  0x96e0, /* U+7c7e */
  0x0000, /* U+7c7f */
  0x0000, /* U+7c80 */
  0x8bcc, /* U+7c81 */
  0x8c48, /* U+7c82 */
  0xe2e1, /* U+7c83 */
  0x0000, /* U+7c84 */
  0x0000, /* U+7c85 */
  0x0000, /* U+7c86 */
  0x0000, /* U+7c87 */
  0x0000, /* U+7c88 */
  0x95b2, /* U+7c89 */
  0x0000, /* U+7c8a */
  0x9088, /* U+7c8b */
  0x0000, /* U+7c8c */
  0x96ae, /* U+7c8d */
  0x0000, /* U+7c8e */
  0x0000, /* U+7c8f */
  0xe2e2, /* U+7c90 */
  0x0000, /* U+7c91 */
  0x97b1, /* U+7c92 */
  0x0000, /* U+7c93 */
  0x0000, /* U+7c94 */
  0x9494, /* U+7c95 */
  0x0000, /* U+7c96 */
  0x9165, /* U+7c97 */
  0x9453, /* U+7c98 */
  0x0000, /* U+7c99 */
  0x0000, /* U+7c9a */
  0x8f6c, /* U+7c9b */
  0x0000, /* U+7c9c */
  0x0000, /* U+7c9d */
  0x0000, /* U+7c9e */
  0x88be, /* U+7c9f */
  0x0000, /* U+7ca0 */
  0xe2e7, /* U+7ca1 */
  0xe2e5, /* U+7ca2 */
  0x0000, /* U+7ca3 */
  0xe2e3, /* U+7ca4 */
  0x8a9f, /* U+7ca5 */
  0x0000, /* U+7ca6 */
  0x8fcf, /* U+7ca7 */
  0xe2e8, /* U+7ca8 */
  0x0000, /* U+7ca9 */
  0x0000, /* U+7caa */
  0xe2e6, /* U+7cab */
  0x0000, /* U+7cac */
  0xe2e4, /* U+7cad */
  0xe2ec, /* U+7cae */
  0x0000, /* U+7caf */
  0x0000, /* U+7cb0 */
  0xe2eb, /* U+7cb1 */
  0xe2ea, /* U+7cb2 */
  0xe2e9, /* U+7cb3 */
  0x0000, /* U+7cb4 */
  0x0000, /* U+7cb5 */
  0x0000, /* U+7cb6 */
  0x0000, /* U+7cb7 */
  0x0000, /* U+7cb8 */
  0xe2ed, /* U+7cb9 */
  0x0000, /* U+7cba */
  0x0000, /* U+7cbb */
  0x0000, /* U+7cbc */
  0xe2ee, /* U+7cbd */
  0x90b8, /* U+7cbe */
  0x0000, /* U+7cbf */
  0xe2ef, /* U+7cc0 */
  0x0000, /* U+7cc1 */
  0xe2f1, /* U+7cc2 */
  0x0000, /* U+7cc3 */
  0x0000, /* U+7cc4 */
  0xe2f0, /* U+7cc5 */
  0x0000, /* U+7cc6 */
  0x0000, /* U+7cc7 */
  0x0000, /* U+7cc8 */
  0x0000, /* U+7cc9 */
  0x8cd0, /* U+7cca */
  0x0000, /* U+7ccb */
  0x0000, /* U+7ccc */
  0x0000, /* U+7ccd */
  0x9157, /* U+7cce */
  0x0000, /* U+7ccf */
  0x0000, /* U+7cd0 */
  0x0000, /* U+7cd1 */
  0xe2f3, /* U+7cd2 */
  0x0000, /* U+7cd3 */
  0x0000, /* U+7cd4 */
  0x0000, /* U+7cd5 */
  0x939c, /* U+7cd6 */
  0x0000, /* U+7cd7 */
  0xe2f2, /* U+7cd8 */
  0x0000, /* U+7cd9 */
  0x0000, /* U+7cda */
  0x0000, /* U+7cdb */
  0xe2f4, /* U+7cdc */
  0x0000, /* U+7cdd */
  0x95b3, /* U+7cde */
  0x918c, /* U+7cdf */
  0x8d66, /* U+7ce0 */
  0x0000, /* U+7ce1 */
  0xe2f5, /* U+7ce2 */
  0x0000, /* U+7ce3 */
  0x0000, /* U+7ce4 */
  0x0000, /* U+7ce5 */
  0x0000, /* U+7ce6 */
  0x97c6, /* U+7ce7 */
  0x0000, /* U+7ce8 */
  0x0000, /* U+7ce9 */
  0x0000, /* U+7cea */
  0x0000, /* U+7ceb */
  0x0000, /* U+7cec */
  0x0000, /* U+7ced */
  0x0000, /* U+7cee */
  0xe2f7, /* U+7cef */
  0x0000, /* U+7cf0 */
  0x0000, /* U+7cf1 */
  0xe2f8, /* U+7cf2 */
  0x0000, /* U+7cf3 */
  0xe2f9, /* U+7cf4 */
  0x0000, /* U+7cf5 */
  0xe2fa, /* U+7cf6 */
  0x0000, /* U+7cf7 */
  0x8e85, /* U+7cf8 */
  0x0000, /* U+7cf9 */
  0xe2fb, /* U+7cfa */
  0x8c6e, /* U+7cfb */
  0x0000, /* U+7cfc */
  0x0000, /* U+7cfd */
  0x8b8a, /* U+7cfe */
  0x0000, /* U+7cff */
  0x8b49, /* U+7d00 */
  0x0000, /* U+7d01 */
  0xe340, /* U+7d02 */
  0x0000, /* U+7d03 */
  0x96f1, /* U+7d04 */
  0x8d67, /* U+7d05 */
  0xe2fc, /* U+7d06 */
  0x0000, /* U+7d07 */
  0x0000, /* U+7d08 */
  0x0000, /* U+7d09 */
  0xe343, /* U+7d0a */
  0x96e4, /* U+7d0b */
  0x0000, /* U+7d0c */
  0x945b, /* U+7d0d */
  0x0000, /* U+7d0e */
  0x0000, /* U+7d0f */
  0x9552, /* U+7d10 */
  0x0000, /* U+7d11 */
  0x0000, /* U+7d12 */
  0x0000, /* U+7d13 */
  0x8f83, /* U+7d14 */
  0xe342, /* U+7d15 */
  0x0000, /* U+7d16 */
  0x8ed1, /* U+7d17 */
  0x8d68, /* U+7d18 */
  0x8e86, /* U+7d19 */
  0x8b89, /* U+7d1a */
  0x95b4, /* U+7d1b */
  0xe341, /* U+7d1c */
  0x0000, /* U+7d1d */
  0x0000, /* U+7d1e */
  0x0000, /* U+7d1f */
  0x9166, /* U+7d20 */
  0x9661, /* U+7d21 */
  0x8df5, /* U+7d22 */
  0x0000, /* U+7d23 */
  0x0000, /* U+7d24 */
  0x0000, /* U+7d25 */
  0x0000, /* U+7d26 */
  0x0000, /* U+7d27 */
  0x0000, /* U+7d28 */
  0x0000, /* U+7d29 */
  0x0000, /* U+7d2a */
  0x8e87, /* U+7d2b */
  0x92db, /* U+7d2c */
  0x0000, /* U+7d2d */
  0xe346, /* U+7d2e */
  0x97dd, /* U+7d2f */
  0x8dd7, /* U+7d30 */
  0x0000, /* U+7d31 */
  0xe347, /* U+7d32 */
  0x9061, /* U+7d33 */
  0x0000, /* U+7d34 */
  0xe349, /* U+7d35 */
  0x0000, /* U+7d36 */
  0x0000, /* U+7d37 */
  0x0000, /* U+7d38 */
  0x8fd0, /* U+7d39 */
  0x8dae, /* U+7d3a */
  0x0000, /* U+7d3b */
  0x0000, /* U+7d3c */
  0x0000, /* U+7d3d */
  0x0000, /* U+7d3e */
  0xe348, /* U+7d3f */
  0x0000, /* U+7d40 */
  0x0000, /* U+7d41 */
  0x8f49, /* U+7d42 */
  0x8cbc, /* U+7d43 */
  0x9167, /* U+7d44 */
  0xe344, /* U+7d45 */
  0xe34a, /* U+7d46 */
  0x0000, /* U+7d47 */
  0xfb8a, /* U+7d48 */
  0x0000, /* U+7d49 */
  0x0000, /* U+7d4a */
  0xe345, /* U+7d4b */
  0x8c6f, /* U+7d4c */
  0x0000, /* U+7d4d */
  0xe34d, /* U+7d4e */
  0xe351, /* U+7d4f */
  0x8c8b, /* U+7d50 */
  0x0000, /* U+7d51 */
  0x0000, /* U+7d52 */
  0x0000, /* U+7d53 */
  0x0000, /* U+7d54 */
  0x0000, /* U+7d55 */
  0xe34c, /* U+7d56 */
  0x0000, /* U+7d57 */
  0x0000, /* U+7d58 */
  0x0000, /* U+7d59 */
  0x0000, /* U+7d5a */
  0xe355, /* U+7d5b */
  0xfb8b, /* U+7d5c */
  0x0000, /* U+7d5d */
  0x8d69, /* U+7d5e */
  0x0000, /* U+7d5f */
  0x0000, /* U+7d60 */
  0x978d, /* U+7d61 */
  0x88ba, /* U+7d62 */
  0xe352, /* U+7d63 */
  0x0000, /* U+7d64 */
  0x0000, /* U+7d65 */
  0x8b8b, /* U+7d66 */
  0x0000, /* U+7d67 */
  0xe34f, /* U+7d68 */
  0x0000, /* U+7d69 */
  0x0000, /* U+7d6a */
  0x0000, /* U+7d6b */
  0x0000, /* U+7d6c */
  0x0000, /* U+7d6d */
  0xe350, /* U+7d6e */
  0x0000, /* U+7d6f */
  0x0000, /* U+7d70 */
  0x939d, /* U+7d71 */
  0xe34e, /* U+7d72 */
  0xe34b, /* U+7d73 */
  0x0000, /* U+7d74 */
  0x8a47, /* U+7d75 */
  0x90e2, /* U+7d76 */
  0x0000, /* U+7d77 */
  0x0000, /* U+7d78 */
  0x8ca6, /* U+7d79 */
  0x0000, /* U+7d7a */
  0x0000, /* U+7d7b */
  0x0000, /* U+7d7c */
  0xe357, /* U+7d7d */
  0x0000, /* U+7d7e */
  0x0000, /* U+7d7f */
  0x0000, /* U+7d80 */
  0x0000, /* U+7d81 */
  0x0000, /* U+7d82 */
  0x0000, /* U+7d83 */
  0x0000, /* U+7d84 */
  0x0000, /* U+7d85 */
  0x0000, /* U+7d86 */
  0x0000, /* U+7d87 */
  0x0000, /* U+7d88 */
  0xe354, /* U+7d89 */
  0x0000, /* U+7d8a */
  0x0000, /* U+7d8b */
  0x0000, /* U+7d8c */
  0x0000, /* U+7d8d */
  0x0000, /* U+7d8e */
  0xe356, /* U+7d8f */
  0x0000, /* U+7d90 */
  0x0000, /* U+7d91 */
  0x0000, /* U+7d92 */
  0xe353, /* U+7d93 */
  0x0000, /* U+7d94 */
  0x0000, /* U+7d95 */
  0x0000, /* U+7d96 */
  0x0000, /* U+7d97 */
  0x0000, /* U+7d98 */
  0x8c70, /* U+7d99 */
  0x91b1, /* U+7d9a */
  0xe358, /* U+7d9b */
  0x918e, /* U+7d9c */
  0x0000, /* U+7d9d */
  0x0000, /* U+7d9e */
  0xe365, /* U+7d9f */
  0xfb8d, /* U+7da0 */
  0x0000, /* U+7da1 */
  0xe361, /* U+7da2 */
  0xe35b, /* U+7da3 */
  0x0000, /* U+7da4 */
  0x0000, /* U+7da5 */
  0x0000, /* U+7da6 */
  0x0000, /* U+7da7 */
  0x0000, /* U+7da8 */
  0x0000, /* U+7da9 */
  0x0000, /* U+7daa */
  0xe35f, /* U+7dab */
  0x8ef8, /* U+7dac */
  0x88db, /* U+7dad */
  0xe35a, /* U+7dae */
  0xe362, /* U+7daf */
  0xe366, /* U+7db0 */
  0x8d6a, /* U+7db1 */
  0x96d4, /* U+7db2 */
  0x0000, /* U+7db3 */
  0x92d4, /* U+7db4 */
  0xe35c, /* U+7db5 */
  0x0000, /* U+7db6 */
  0xfb8c, /* U+7db7 */
  0xe364, /* U+7db8 */
  0x0000, /* U+7db9 */
  0xe359, /* U+7dba */
  0x925d, /* U+7dbb */
  0x0000, /* U+7dbc */
  0xe35e, /* U+7dbd */
  0x88bb, /* U+7dbe */
  0x96c8, /* U+7dbf */
  0x0000, /* U+7dc0 */
  0x0000, /* U+7dc1 */
  0x0000, /* U+7dc2 */
  0x0000, /* U+7dc3 */
  0x0000, /* U+7dc4 */
  0x0000, /* U+7dc5 */
  0x0000, /* U+7dc6 */
  0xe35d, /* U+7dc7 */
  0x0000, /* U+7dc8 */
  0x0000, /* U+7dc9 */
  0x8bd9, /* U+7dca */
  0x94ea, /* U+7dcb */
  0x0000, /* U+7dcc */
  0x0000, /* U+7dcd */
  0x0000, /* U+7dce */
  0x918d, /* U+7dcf */
  0x0000, /* U+7dd0 */
  0x97ce, /* U+7dd1 */
  0x8f8f, /* U+7dd2 */
  0x0000, /* U+7dd3 */
  0x0000, /* U+7dd4 */
  0xe38e, /* U+7dd5 */
  0xfb8e, /* U+7dd6 */
  0x0000, /* U+7dd7 */
  0xe367, /* U+7dd8 */
  0x0000, /* U+7dd9 */
  0x90fc, /* U+7dda */
  0x0000, /* U+7ddb */
  0xe363, /* U+7ddc */
  0xe368, /* U+7ddd */
  0xe36a, /* U+7dde */
  0x0000, /* U+7ddf */
  0x92f7, /* U+7de0 */
  0xe36d, /* U+7de1 */
  0x0000, /* U+7de2 */
  0x0000, /* U+7de3 */
  0xe369, /* U+7de4 */
  0x0000, /* U+7de5 */
  0x0000, /* U+7de6 */
  0x0000, /* U+7de7 */
  0x95d2, /* U+7de8 */
  0x8ac9, /* U+7de9 */
  0x0000, /* U+7dea */
  0x0000, /* U+7deb */
  0x96c9, /* U+7dec */
  0x0000, /* U+7ded */
  0x0000, /* U+7dee */
  0x88dc, /* U+7def */
  0x0000, /* U+7df0 */
  0x0000, /* U+7df1 */
  0xe36c, /* U+7df2 */
  0x0000, /* U+7df3 */
  0x97fb, /* U+7df4 */
  0x0000, /* U+7df5 */
  0x0000, /* U+7df6 */
  0x0000, /* U+7df7 */
  0x0000, /* U+7df8 */
  0x0000, /* U+7df9 */
  0x0000, /* U+7dfa */
  0xe36b, /* U+7dfb */
  0x0000, /* U+7dfc */
  0x0000, /* U+7dfd */
  0x0000, /* U+7dfe */
  0x0000, /* U+7dff */
  0x0000, /* U+7e00 */
  0x898f, /* U+7e01 */
  0x0000, /* U+7e02 */
  0x0000, /* U+7e03 */
  0x93ea, /* U+7e04 */
  0xe36e, /* U+7e05 */
  0x0000, /* U+7e06 */
  0x0000, /* U+7e07 */
  0x0000, /* U+7e08 */
  0xe375, /* U+7e09 */
  0xe36f, /* U+7e0a */
  0xe376, /* U+7e0b */
  0x0000, /* U+7e0c */
  0x0000, /* U+7e0d */
  0x0000, /* U+7e0e */
  0x0000, /* U+7e0f */
  0x0000, /* U+7e10 */
  0x0000, /* U+7e11 */
  0xe372, /* U+7e12 */
  0x0000, /* U+7e13 */
  0x0000, /* U+7e14 */
  0x0000, /* U+7e15 */
  0x0000, /* U+7e16 */
  0x0000, /* U+7e17 */
  0x0000, /* U+7e18 */
  0x0000, /* U+7e19 */
  0x0000, /* U+7e1a */
  0x949b, /* U+7e1b */
  0x0000, /* U+7e1c */
  0x0000, /* U+7e1d */
  0x8ec8, /* U+7e1e */
  0xe374, /* U+7e1f */
  0x0000, /* U+7e20 */
  0xe371, /* U+7e21 */
  0xe377, /* U+7e22 */
  0xe370, /* U+7e23 */
  0x0000, /* U+7e24 */
  0x0000, /* U+7e25 */
  0x8f63, /* U+7e26 */
  0x0000, /* U+7e27 */
  0x0000, /* U+7e28 */
  0x0000, /* U+7e29 */
  0x0000, /* U+7e2a */
  0x9644, /* U+7e2b */
  0x0000, /* U+7e2c */
  0x0000, /* U+7e2d */
  0x8f6b, /* U+7e2e */
  0x0000, /* U+7e2f */
  0x0000, /* U+7e30 */
  0xe373, /* U+7e31 */
  0xe380, /* U+7e32 */
  0x0000, /* U+7e33 */
  0x0000, /* U+7e34 */
  0xe37b, /* U+7e35 */
  0x0000, /* U+7e36 */
  0xe37e, /* U+7e37 */
  0x0000, /* U+7e38 */
  0xe37c, /* U+7e39 */
  0xe381, /* U+7e3a */
  0xe37a, /* U+7e3b */
  0x0000, /* U+7e3c */
  0xe360, /* U+7e3d */
  0x90d1, /* U+7e3e */
  0x0000, /* U+7e3f */
  0x0000, /* U+7e40 */
  0x94c9, /* U+7e41 */
  0x0000, /* U+7e42 */
  0xe37d, /* U+7e43 */
  0x0000, /* U+7e44 */
  0x0000, /* U+7e45 */
  0xe378, /* U+7e46 */
  0x0000, /* U+7e47 */
  0x0000, /* U+7e48 */
  0x0000, /* U+7e49 */
  0x9140, /* U+7e4a */
  0x8c71, /* U+7e4b */
  0x0000, /* U+7e4c */
  0x8f4a, /* U+7e4d */
  0x0000, /* U+7e4e */
  0x0000, /* U+7e4f */
  0x0000, /* U+7e50 */
  0x0000, /* U+7e51 */
  0xfb8f, /* U+7e52 */
  0x0000, /* U+7e53 */
  0x9044, /* U+7e54 */
  0x9155, /* U+7e55 */
  0xe384, /* U+7e56 */
  0x0000, /* U+7e57 */
  0x0000, /* U+7e58 */
  0xe386, /* U+7e59 */
  0xe387, /* U+7e5a */
  0x0000, /* U+7e5b */
  0x0000, /* U+7e5c */
  0xe383, /* U+7e5d */
  0xe385, /* U+7e5e */
  0x0000, /* U+7e5f */
  0x0000, /* U+7e60 */
  0x0000, /* U+7e61 */
  0x0000, /* U+7e62 */
  0x0000, /* U+7e63 */
  0x0000, /* U+7e64 */
  0x0000, /* U+7e65 */
  0xe379, /* U+7e66 */
  0xe382, /* U+7e67 */
  0x0000, /* U+7e68 */
  0xe38a, /* U+7e69 */
  0xe389, /* U+7e6a */
  0x0000, /* U+7e6b */
  0x0000, /* U+7e6c */
  0x969a, /* U+7e6d */
  0x0000, /* U+7e6e */
  0x0000, /* U+7e6f */
  0x8c4a, /* U+7e70 */
  0x0000, /* U+7e71 */
  0x0000, /* U+7e72 */
  0x0000, /* U+7e73 */
  0x0000, /* U+7e74 */
  0x0000, /* U+7e75 */
  0x0000, /* U+7e76 */
  0x0000, /* U+7e77 */
  0x0000, /* U+7e78 */
  0xe388, /* U+7e79 */
  0x0000, /* U+7e7a */
  0xe38c, /* U+7e7b */
  0xe38b, /* U+7e7c */
  0xe38f, /* U+7e7d */
  0x0000, /* U+7e7e */
  0xe391, /* U+7e7f */
  0x0000, /* U+7e80 */
  0x0000, /* U+7e81 */
  0x8e5b, /* U+7e82 */
  0xe38d, /* U+7e83 */
  0x0000, /* U+7e84 */
  0x0000, /* U+7e85 */
  0x0000, /* U+7e86 */
  0x0000, /* U+7e87 */
  0xe392, /* U+7e88 */
  0xe393, /* U+7e89 */
  0xfa5c, /* U+7e8a */
  0x0000, /* U+7e8b */
  0xe394, /* U+7e8c */
  0x0000, /* U+7e8d */
  0xe39a, /* U+7e8e */
  0x935a, /* U+7e8f */
  0xe396, /* U+7e90 */
  0x0000, /* U+7e91 */
  0xe395, /* U+7e92 */
  0xe397, /* U+7e93 */
  0xe398, /* U+7e94 */
  0x0000, /* U+7e95 */
  0xe399, /* U+7e96 */
  0x0000, /* U+7e97 */
  0x0000, /* U+7e98 */
  0x0000, /* U+7e99 */
  0x0000, /* U+7e9a */
  0xe39b, /* U+7e9b */
  0xe39c, /* U+7e9c */
  0x0000, /* U+7e9d */
  0x0000, /* U+7e9e */
  0x0000, /* U+7e9f */
  0x0000, /* U+7ea0 */
  0x0000, /* U+7ea1 */
  0x0000, /* U+7ea2 */
  0x0000, /* U+7ea3 */
  0x0000, /* U+7ea4 */
  0x0000, /* U+7ea5 */
  0x0000, /* U+7ea6 */
  0x0000, /* U+7ea7 */
  0x0000, /* U+7ea8 */
  0x0000, /* U+7ea9 */
  0x0000, /* U+7eaa */
  0x0000, /* U+7eab */
  0x0000, /* U+7eac */
  0x0000, /* U+7ead */
  0x0000, /* U+7eae */
  0x0000, /* U+7eaf */
  0x0000, /* U+7eb0 */
  0x0000, /* U+7eb1 */
  0x0000, /* U+7eb2 */
  0x0000, /* U+7eb3 */
  0x0000, /* U+7eb4 */
  0x0000, /* U+7eb5 */
  0x0000, /* U+7eb6 */
  0x0000, /* U+7eb7 */
  0x0000, /* U+7eb8 */
  0x0000, /* U+7eb9 */
  0x0000, /* U+7eba */
  0x0000, /* U+7ebb */
  0x0000, /* U+7ebc */
  0x0000, /* U+7ebd */
  0x0000, /* U+7ebe */
  0x0000, /* U+7ebf */
  0x0000, /* U+7ec0 */
  0x0000, /* U+7ec1 */
  0x0000, /* U+7ec2 */
  0x0000, /* U+7ec3 */
  0x0000, /* U+7ec4 */
  0x0000, /* U+7ec5 */
  0x0000, /* U+7ec6 */
  0x0000, /* U+7ec7 */
  0x0000, /* U+7ec8 */
  0x0000, /* U+7ec9 */
  0x0000, /* U+7eca */
  0x0000, /* U+7ecb */
  0x0000, /* U+7ecc */
  0x0000, /* U+7ecd */
  0x0000, /* U+7ece */
  0x0000, /* U+7ecf */
  0x0000, /* U+7ed0 */
  0x0000, /* U+7ed1 */
  0x0000, /* U+7ed2 */
  0x0000, /* U+7ed3 */
  0x0000, /* U+7ed4 */
  0x0000, /* U+7ed5 */
  0x0000, /* U+7ed6 */
  0x0000, /* U+7ed7 */
  0x0000, /* U+7ed8 */
  0x0000, /* U+7ed9 */
  0x0000, /* U+7eda */
  0x0000, /* U+7edb */
  0x0000, /* U+7edc */
  0x0000, /* U+7edd */
  0x0000, /* U+7ede */
  0x0000, /* U+7edf */
  0x0000, /* U+7ee0 */
  0x0000, /* U+7ee1 */
  0x0000, /* U+7ee2 */
  0x0000, /* U+7ee3 */
  0x0000, /* U+7ee4 */
  0x0000, /* U+7ee5 */
  0x0000, /* U+7ee6 */
  0x0000, /* U+7ee7 */
  0x0000, /* U+7ee8 */
  0x0000, /* U+7ee9 */
  0x0000, /* U+7eea */
  0x0000, /* U+7eeb */
  0x0000, /* U+7eec */
  0x0000, /* U+7eed */
  0x0000, /* U+7eee */
  0x0000, /* U+7eef */
  0x0000, /* U+7ef0 */
  0x0000, /* U+7ef1 */
  0x0000, /* U+7ef2 */
  0x0000, /* U+7ef3 */
  0x0000, /* U+7ef4 */
  0x0000, /* U+7ef5 */
  0x0000, /* U+7ef6 */
  0x0000, /* U+7ef7 */
  0x0000, /* U+7ef8 */
  0x0000, /* U+7ef9 */
  0x0000, /* U+7efa */
  0x0000, /* U+7efb */
  0x0000, /* U+7efc */
  0x0000, /* U+7efd */
  0x0000, /* U+7efe */
  0x0000, /* U+7eff */
  0x0000, /* U+7f00 */
  0x0000, /* U+7f01 */
  0x0000, /* U+7f02 */
  0x0000, /* U+7f03 */
  0x0000, /* U+7f04 */
  0x0000, /* U+7f05 */
  0x0000, /* U+7f06 */
  0x0000, /* U+7f07 */
  0x0000, /* U+7f08 */
  0x0000, /* U+7f09 */
  0x0000, /* U+7f0a */
  0x0000, /* U+7f0b */
  0x0000, /* U+7f0c */
  0x0000, /* U+7f0d */
  0x0000, /* U+7f0e */
  0x0000, /* U+7f0f */
  0x0000, /* U+7f10 */
  0x0000, /* U+7f11 */
  0x0000, /* U+7f12 */
  0x0000, /* U+7f13 */
  0x0000, /* U+7f14 */
  0x0000, /* U+7f15 */
  0x0000, /* U+7f16 */
  0x0000, /* U+7f17 */
  0x0000, /* U+7f18 */
  0x0000, /* U+7f19 */
  0x0000, /* U+7f1a */
  0x0000, /* U+7f1b */
  0x0000, /* U+7f1c */
  0x0000, /* U+7f1d */
  0x0000, /* U+7f1e */
  0x0000, /* U+7f1f */
  0x0000, /* U+7f20 */
  0x0000, /* U+7f21 */
  0x0000, /* U+7f22 */
  0x0000, /* U+7f23 */
  0x0000, /* U+7f24 */
  0x0000, /* U+7f25 */
  0x0000, /* U+7f26 */
  0x0000, /* U+7f27 */
  0x0000, /* U+7f28 */
  0x0000, /* U+7f29 */
  0x0000, /* U+7f2a */
  0x0000, /* U+7f2b */
  0x0000, /* U+7f2c */
  0x0000, /* U+7f2d */
  0x0000, /* U+7f2e */
  0x0000, /* U+7f2f */
  0x0000, /* U+7f30 */
  0x0000, /* U+7f31 */
  0x0000, /* U+7f32 */
  0x0000, /* U+7f33 */
  0x0000, /* U+7f34 */
  0x0000, /* U+7f35 */
  0x8aca, /* U+7f36 */
  0x0000, /* U+7f37 */
  0xe39d, /* U+7f38 */
  0x0000, /* U+7f39 */
  0xe39e, /* U+7f3a */
  0x0000, /* U+7f3b */
  0x0000, /* U+7f3c */
  0x0000, /* U+7f3d */
  0x0000, /* U+7f3e */
  0x0000, /* U+7f3f */
  0x0000, /* U+7f40 */
  0x0000, /* U+7f41 */
  0x0000, /* U+7f42 */
  0x0000, /* U+7f43 */
  0x0000, /* U+7f44 */
  0xe39f, /* U+7f45 */
  0x0000, /* U+7f46 */
  0xfb90, /* U+7f47 */
  0x0000, /* U+7f48 */
  0x0000, /* U+7f49 */
  0x0000, /* U+7f4a */
  0x0000, /* U+7f4b */
  0xe3a0, /* U+7f4c */
  0xe3a1, /* U+7f4d */
  0xe3a2, /* U+7f4e */
  0x0000, /* U+7f4f */
  0xe3a3, /* U+7f50 */
  0xe3a4, /* U+7f51 */
  0x0000, /* U+7f52 */
  0x0000, /* U+7f53 */
  0xe3a6, /* U+7f54 */
  0xe3a5, /* U+7f55 */
  0x0000, /* U+7f56 */
  0x0000, /* U+7f57 */
  0xe3a7, /* U+7f58 */
  0x0000, /* U+7f59 */
  0x0000, /* U+7f5a */
  0x0000, /* U+7f5b */
  0x0000, /* U+7f5c */
  0x0000, /* U+7f5d */
  0x0000, /* U+7f5e */
  0xe3a8, /* U+7f5f */
  0xe3a9, /* U+7f60 */
  0x0000, /* U+7f61 */
  0x0000, /* U+7f62 */
  0x0000, /* U+7f63 */
  0x0000, /* U+7f64 */
  0x0000, /* U+7f65 */
  0x0000, /* U+7f66 */
  0xe3ac, /* U+7f67 */
  0xe3aa, /* U+7f68 */
  0xe3ab, /* U+7f69 */
  0x8ddf, /* U+7f6a */
  0x8c72, /* U+7f6b */
  0x0000, /* U+7f6c */
  0x0000, /* U+7f6d */
  0x9275, /* U+7f6e */
  0x0000, /* U+7f6f */
  0x94b1, /* U+7f70 */
  0x0000, /* U+7f71 */
  0x8f90, /* U+7f72 */
  0x0000, /* U+7f73 */
  0x0000, /* U+7f74 */
  0x946c, /* U+7f75 */
  0x0000, /* U+7f76 */
  0x94eb, /* U+7f77 */
  0xe3ad, /* U+7f78 */
  0x9ceb, /* U+7f79 */
  0x0000, /* U+7f7a */
  0x0000, /* U+7f7b */
  0x0000, /* U+7f7c */
  0x0000, /* U+7f7d */
  0x0000, /* U+7f7e */
  0x0000, /* U+7f7f */
  0x0000, /* U+7f80 */
  0x0000, /* U+7f81 */
  0xe3ae, /* U+7f82 */
  0xe3b0, /* U+7f83 */
  0x0000, /* U+7f84 */
  0x9785, /* U+7f85 */
  0xe3af, /* U+7f86 */
  0xe3b2, /* U+7f87 */
  0xe3b1, /* U+7f88 */
  0x0000, /* U+7f89 */
  0x9772, /* U+7f8a */
  0x0000, /* U+7f8b */
  0xe3b3, /* U+7f8c */
  0x0000, /* U+7f8d */
  0x94fc, /* U+7f8e */
  0x0000, /* U+7f8f */
  0x0000, /* U+7f90 */
  0x0000, /* U+7f91 */
  0x0000, /* U+7f92 */
  0x0000, /* U+7f93 */
  0xe3b4, /* U+7f94 */
  0x0000, /* U+7f95 */
  0x0000, /* U+7f96 */
  0x0000, /* U+7f97 */
  0x0000, /* U+7f98 */
  0x0000, /* U+7f99 */
  0xe3b7, /* U+7f9a */
  0x0000, /* U+7f9b */
  0x0000, /* U+7f9c */
  0xe3b6, /* U+7f9d */
  0xe3b5, /* U+7f9e */
  0x0000, /* U+7f9f */
  0x0000, /* U+7fa0 */
  0xfb91, /* U+7fa1 */
  0x0000, /* U+7fa2 */
  0xe3b8, /* U+7fa3 */
  0x8c51, /* U+7fa4 */
  0x0000, /* U+7fa5 */
  0x0000, /* U+7fa6 */
  0x0000, /* U+7fa7 */
  0x9141, /* U+7fa8 */
  0x8b60, /* U+7fa9 */
  0x0000, /* U+7faa */
  0x0000, /* U+7fab */
  0x0000, /* U+7fac */
  0x0000, /* U+7fad */
  0xe3bc, /* U+7fae */
  0xe3b9, /* U+7faf */
  0x0000, /* U+7fb0 */
  0x0000, /* U+7fb1 */
  0xe3ba, /* U+7fb2 */
  0x0000, /* U+7fb3 */
  0x0000, /* U+7fb4 */
  0x0000, /* U+7fb5 */
  0xe3bd, /* U+7fb6 */
  0x0000, /* U+7fb7 */
  0xe3be, /* U+7fb8 */
  0xe3bb, /* U+7fb9 */
  0x0000, /* U+7fba */
  0x0000, /* U+7fbb */
  0x0000, /* U+7fbc */
  0x8948, /* U+7fbd */
  0x0000, /* U+7fbe */
  0x0000, /* U+7fbf */
  0x0000, /* U+7fc0 */
  0x89a5, /* U+7fc1 */
  0x0000, /* U+7fc2 */
  0x0000, /* U+7fc3 */
  0x0000, /* U+7fc4 */
  0xe3c0, /* U+7fc5 */
  0xe3c1, /* U+7fc6 */
  0x0000, /* U+7fc7 */
  0x0000, /* U+7fc8 */
  0x0000, /* U+7fc9 */
  0xe3c2, /* U+7fca */
  0x0000, /* U+7fcb */
  0x9782, /* U+7fcc */
  0x0000, /* U+7fcd */
  0x0000, /* U+7fce */
  0x0000, /* U+7fcf */
  0x0000, /* U+7fd0 */
  0x0000, /* U+7fd1 */
  0x8f4b, /* U+7fd2 */
  0x0000, /* U+7fd3 */
  0xe3c4, /* U+7fd4 */
  0xe3c3, /* U+7fd5 */
  0x0000, /* U+7fd6 */
  0x0000, /* U+7fd7 */
  0x0000, /* U+7fd8 */
  0x0000, /* U+7fd9 */
  0x0000, /* U+7fda */
  0x0000, /* U+7fdb */
  0x0000, /* U+7fdc */
  0x0000, /* U+7fdd */
  0x0000, /* U+7fde */
  0x0000, /* U+7fdf */
  0x9089, /* U+7fe0 */
  0xe3c5, /* U+7fe1 */
  0x0000, /* U+7fe2 */
  0x0000, /* U+7fe3 */
  0x0000, /* U+7fe4 */
  0x0000, /* U+7fe5 */
  0xe3c6, /* U+7fe6 */
  0x0000, /* U+7fe7 */
  0x0000, /* U+7fe8 */
  0xe3c7, /* U+7fe9 */
  0x0000, /* U+7fea */
  0x8ae3, /* U+7feb */
  0x0000, /* U+7fec */
  0x0000, /* U+7fed */
  0x0000, /* U+7fee */
  0x0000, /* U+7fef */
  0x8acb, /* U+7ff0 */
  0x0000, /* U+7ff1 */
  0x0000, /* U+7ff2 */
  0xe3c8, /* U+7ff3 */
  0x0000, /* U+7ff4 */
  0x0000, /* U+7ff5 */
  0x0000, /* U+7ff6 */
  0x0000, /* U+7ff7 */
  0x0000, /* U+7ff8 */
  0xe3c9, /* U+7ff9 */
  0x0000, /* U+7ffa */
  0x967c, /* U+7ffb */
  0x9783, /* U+7ffc */
  0x0000, /* U+7ffd */
  0x0000, /* U+7ffe */
  0x0000, /* U+7fff */
  0x9773, /* U+8000 */
  0x9856, /* U+8001 */
  0x0000, /* U+8002 */
  0x8d6c, /* U+8003 */
  0xe3cc, /* U+8004 */
  0x8ed2, /* U+8005 */
  0xe3cb, /* U+8006 */
  0x0000, /* U+8007 */
  0x0000, /* U+8008 */
  0x0000, /* U+8009 */
  0x0000, /* U+800a */
  0xe3cd, /* U+800b */
  0x8ea7, /* U+800c */
  0x0000, /* U+800d */
  0x0000, /* U+800e */
  0x0000, /* U+800f */
  0x91cf, /* U+8010 */
  0x0000, /* U+8011 */
  0xe3ce, /* U+8012 */
  0x0000, /* U+8013 */
  0x0000, /* U+8014 */
  0x8d6b, /* U+8015 */
  0x0000, /* U+8016 */
  0x96d5, /* U+8017 */
  0xe3cf, /* U+8018 */
  0xe3d0, /* U+8019 */
  0x0000, /* U+801a */
  0x0000, /* U+801b */
  0xe3d1, /* U+801c */
  0x0000, /* U+801d */
  0x0000, /* U+801e */
  0x0000, /* U+801f */
  0x0000, /* U+8020 */
  0xe3d2, /* U+8021 */
  0x0000, /* U+8022 */
  0x0000, /* U+8023 */
  0x0000, /* U+8024 */
  0x0000, /* U+8025 */
  0x0000, /* U+8026 */
  0x0000, /* U+8027 */
  0xe3d3, /* U+8028 */
  0x0000, /* U+8029 */
  0x0000, /* U+802a */
  0x0000, /* U+802b */
  0x0000, /* U+802c */
  0x0000, /* U+802d */
  0x0000, /* U+802e */
  0x0000, /* U+802f */
  0x0000, /* U+8030 */
  0x0000, /* U+8031 */
  0x0000, /* U+8032 */
  0x8ea8, /* U+8033 */
  0x0000, /* U+8034 */
  0x0000, /* U+8035 */
  0x96eb, /* U+8036 */
  0x0000, /* U+8037 */
  0x0000, /* U+8038 */
  0x0000, /* U+8039 */
  0x0000, /* U+803a */
  0xe3d5, /* U+803b */
  0x0000, /* U+803c */
  0x925e, /* U+803d */
  0x0000, /* U+803e */
  0xe3d4, /* U+803f */
  0x0000, /* U+8040 */
  0x0000, /* U+8041 */
  0x0000, /* U+8042 */
  0x0000, /* U+8043 */
  0x0000, /* U+8044 */
  0x0000, /* U+8045 */
  0xe3d7, /* U+8046 */
  0x0000, /* U+8047 */
  0x0000, /* U+8048 */
  0x0000, /* U+8049 */
  0xe3d6, /* U+804a */
  0x0000, /* U+804b */
  0x0000, /* U+804c */
  0x0000, /* U+804d */
  0x0000, /* U+804e */
  0x0000, /* U+804f */
  0x0000, /* U+8050 */
  0x0000, /* U+8051 */
  0xe3d8, /* U+8052 */
  0x0000, /* U+8053 */
  0x0000, /* U+8054 */
  0x0000, /* U+8055 */
  0x90b9, /* U+8056 */
  0x0000, /* U+8057 */
  0xe3d9, /* U+8058 */
  0x0000, /* U+8059 */
  0xe3da, /* U+805a */
  0x0000, /* U+805b */
  0x0000, /* U+805c */
  0x0000, /* U+805d */
  0x95b7, /* U+805e */
  0xe3db, /* U+805f */
  0x0000, /* U+8060 */
  0x918f, /* U+8061 */
  0xe3dc, /* U+8062 */
  0x0000, /* U+8063 */
  0x0000, /* U+8064 */
  0x0000, /* U+8065 */
  0x0000, /* U+8066 */
  0x0000, /* U+8067 */
  0xe3dd, /* U+8068 */
  0x0000, /* U+8069 */
  0x0000, /* U+806a */
  0x0000, /* U+806b */
  0x0000, /* U+806c */
  0x0000, /* U+806d */
  0x0000, /* U+806e */
  0x97fc, /* U+806f */
  0xe3e0, /* U+8070 */
  0x0000, /* U+8071 */
  0xe3df, /* U+8072 */
  0xe3de, /* U+8073 */
  0x92ae, /* U+8074 */
  0x0000, /* U+8075 */
  0xe3e1, /* U+8076 */
  0x9045, /* U+8077 */
  0x0000, /* U+8078 */
  0xe3e2, /* U+8079 */
  0x0000, /* U+807a */
  0x0000, /* U+807b */
  0x0000, /* U+807c */
  0xe3e3, /* U+807d */
  0x9857, /* U+807e */
  0xe3e4, /* U+807f */
  0x0000, /* U+8080 */
  0x0000, /* U+8081 */
  0x0000, /* U+8082 */
  0x0000, /* U+8083 */
  0xe3e5, /* U+8084 */
  0xe3e7, /* U+8085 */
  0xe3e6, /* U+8086 */
  0x94a3, /* U+8087 */
  0x0000, /* U+8088 */
  0x93f7, /* U+8089 */
  0x0000, /* U+808a */
  0x985d, /* U+808b */
  0x94a7, /* U+808c */
  0x0000, /* U+808d */
  0x0000, /* U+808e */
  0x0000, /* U+808f */
  0x0000, /* U+8090 */
  0x0000, /* U+8091 */
  0x0000, /* U+8092 */
  0xe3e9, /* U+8093 */
  0x0000, /* U+8094 */
  0x0000, /* U+8095 */
  0x8fd1, /* U+8096 */
  0x0000, /* U+8097 */
  0x9549, /* U+8098 */
  0x0000, /* U+8099 */
  0xe3ea, /* U+809a */
  0xe3e8, /* U+809b */
  0x0000, /* U+809c */
  0x8acc, /* U+809d */
  0x0000, /* U+809e */
  0x0000, /* U+809f */
  0x0000, /* U+80a0 */
  0x8cd2, /* U+80a1 */
  0x8e88, /* U+80a2 */
  0x0000, /* U+80a3 */
  0x0000, /* U+80a4 */
  0x94ec, /* U+80a5 */
  0x0000, /* U+80a6 */
  0x0000, /* U+80a7 */
  0x0000, /* U+80a8 */
  0x8ca8, /* U+80a9 */
  0x9662, /* U+80aa */
  0x0000, /* U+80ab */
  0xe3ed, /* U+80ac */
  0xe3eb, /* U+80ad */
  0x0000, /* U+80ae */
  0x8d6d, /* U+80af */
  0x0000, /* U+80b0 */
  0x8d6e, /* U+80b1 */
  0x88e7, /* U+80b2 */
  0x0000, /* U+80b3 */
  0x8de6, /* U+80b4 */
  0x0000, /* U+80b5 */
  0x0000, /* U+80b6 */
  0x0000, /* U+80b7 */
  0x0000, /* U+80b8 */
  0x0000, /* U+80b9 */
  0x9478, /* U+80ba */
  0x0000, /* U+80bb */
  0x0000, /* U+80bc */
  0x0000, /* U+80bd */
  0x0000, /* U+80be */
  0x0000, /* U+80bf */
  0x0000, /* U+80c0 */
  0x0000, /* U+80c1 */
  0x0000, /* U+80c2 */
  0x88dd, /* U+80c3 */
  0xe3f2, /* U+80c4 */
  0x0000, /* U+80c5 */
  0x925f, /* U+80c6 */
  0x0000, /* U+80c7 */
  0x0000, /* U+80c8 */
  0x0000, /* U+80c9 */
  0x0000, /* U+80ca */
  0x0000, /* U+80cb */
  0x9477, /* U+80cc */
  0x0000, /* U+80cd */
  0x91d9, /* U+80ce */
  0x0000, /* U+80cf */
  0x0000, /* U+80d0 */
  0x0000, /* U+80d1 */
  0x0000, /* U+80d2 */
  0x0000, /* U+80d3 */
  0x0000, /* U+80d4 */
  0x0000, /* U+80d5 */
  0xe3f4, /* U+80d6 */
  0x0000, /* U+80d7 */
  0x0000, /* U+80d8 */
  0xe3f0, /* U+80d9 */
  0xe3f3, /* U+80da */
  0xe3ee, /* U+80db */
  0x0000, /* U+80dc */
  0xe3f1, /* U+80dd */
  0x9645, /* U+80de */
  0x0000, /* U+80df */
  0x0000, /* U+80e0 */
  0x8cd3, /* U+80e1 */
  0x0000, /* U+80e2 */
  0x0000, /* U+80e3 */
  0x88fb, /* U+80e4 */
  0xe3ef, /* U+80e5 */
  0x0000, /* U+80e6 */
  0x0000, /* U+80e7 */
  0x0000, /* U+80e8 */
  0x0000, /* U+80e9 */
  0x0000, /* U+80ea */
  0x0000, /* U+80eb */
  0x0000, /* U+80ec */
  0x0000, /* U+80ed */
  0x0000, /* U+80ee */
  0xe3f6, /* U+80ef */
  0x0000, /* U+80f0 */
  0xe3f7, /* U+80f1 */
  0x0000, /* U+80f2 */
  0x0000, /* U+80f3 */
  0x93b7, /* U+80f4 */
  0x0000, /* U+80f5 */
  0x0000, /* U+80f6 */
  0x0000, /* U+80f7 */
  0x8bb9, /* U+80f8 */
  0x0000, /* U+80f9 */
  0x0000, /* U+80fa */
  0x0000, /* U+80fb */
  0xe445, /* U+80fc */
  0x945c, /* U+80fd */
  0x0000, /* U+80fe */
  0x0000, /* U+80ff */
  0x0000, /* U+8100 */
  0x0000, /* U+8101 */
  0x8e89, /* U+8102 */
  0x0000, /* U+8103 */
  0x0000, /* U+8104 */
  0x8bba, /* U+8105 */
  0x90c6, /* U+8106 */
  0x9865, /* U+8107 */
  0x96ac, /* U+8108 */
  0xe3f5, /* U+8109 */
  0x90d2, /* U+810a */
  0x0000, /* U+810b */
  0x0000, /* U+810c */
  0x0000, /* U+810d */
  0x0000, /* U+810e */
  0x0000, /* U+810f */
  0x0000, /* U+8110 */
  0x0000, /* U+8111 */
  0x0000, /* U+8112 */
  0x0000, /* U+8113 */
  0x0000, /* U+8114 */
  0x0000, /* U+8115 */
  0x0000, /* U+8116 */
  0x0000, /* U+8117 */
  0x0000, /* U+8118 */
  0x0000, /* U+8119 */
  0x8b72, /* U+811a */
  0xe3f8, /* U+811b */
  0x0000, /* U+811c */
  0x0000, /* U+811d */
  0x0000, /* U+811e */
  0x0000, /* U+811f */
  0x0000, /* U+8120 */
  0x0000, /* U+8121 */
  0x0000, /* U+8122 */
  0xe3fa, /* U+8123 */
  0x0000, /* U+8124 */
  0x0000, /* U+8125 */
  0x0000, /* U+8126 */
  0x0000, /* U+8127 */
  0x0000, /* U+8128 */
  0xe3f9, /* U+8129 */
  0x0000, /* U+812a */
  0x0000, /* U+812b */
  0x0000, /* U+812c */
  0x0000, /* U+812d */
  0x0000, /* U+812e */
  0xe3fb, /* U+812f */
  0x0000, /* U+8130 */
  0x9245, /* U+8131 */
  0x0000, /* U+8132 */
  0x945d, /* U+8133 */
  0x0000, /* U+8134 */
  0x0000, /* U+8135 */
  0x0000, /* U+8136 */
  0x0000, /* U+8137 */
  0x0000, /* U+8138 */
  0x92af, /* U+8139 */
  0x0000, /* U+813a */
  0x0000, /* U+813b */
  0x0000, /* U+813c */
  0x0000, /* U+813d */
  0xe442, /* U+813e */
  0x0000, /* U+813f */
  0x0000, /* U+8140 */
  0x0000, /* U+8141 */
  0x0000, /* U+8142 */
  0x0000, /* U+8143 */
  0x0000, /* U+8144 */
  0x0000, /* U+8145 */
  0xe441, /* U+8146 */
  0x0000, /* U+8147 */
  0x0000, /* U+8148 */
  0x0000, /* U+8149 */
  0x0000, /* U+814a */
  0xe3fc, /* U+814b */
  0x0000, /* U+814c */
  0x0000, /* U+814d */
  0x9074, /* U+814e */
  0x0000, /* U+814f */
  0x9585, /* U+8150 */
  0xe444, /* U+8151 */
  0x0000, /* U+8152 */
  0xe443, /* U+8153 */
  0x8d6f, /* U+8154 */
  0x9872, /* U+8155 */
  0x0000, /* U+8156 */
  0x0000, /* U+8157 */
  0x0000, /* U+8158 */
  0x0000, /* U+8159 */
  0x0000, /* U+815a */
  0x0000, /* U+815b */
  0x0000, /* U+815c */
  0x0000, /* U+815d */
  0x0000, /* U+815e */
  0xe454, /* U+815f */
  0x0000, /* U+8160 */
  0x0000, /* U+8161 */
  0x0000, /* U+8162 */
  0x0000, /* U+8163 */
  0x0000, /* U+8164 */
  0xe448, /* U+8165 */
  0xe449, /* U+8166 */
  0x0000, /* U+8167 */
  0x0000, /* U+8168 */
  0x0000, /* U+8169 */
  0x0000, /* U+816a */
  0x8eee, /* U+816b */
  0x0000, /* U+816c */
  0x0000, /* U+816d */
  0xe447, /* U+816e */
  0x0000, /* U+816f */
  0x8d98, /* U+8170 */
  0xe446, /* U+8171 */
  0x0000, /* U+8172 */
  0x0000, /* U+8173 */
  0xe44a, /* U+8174 */
  0x0000, /* U+8175 */
  0x0000, /* U+8176 */
  0x0000, /* U+8177 */
  0x92b0, /* U+8178 */
  0x95a0, /* U+8179 */
  0x9142, /* U+817a */
  0x0000, /* U+817b */
  0x0000, /* U+817c */
  0x0000, /* U+817d */
  0x0000, /* U+817e */
  0x91da, /* U+817f */
  0xe44e, /* U+8180 */
  0x0000, /* U+8181 */
  0xe44f, /* U+8182 */
  0xe44b, /* U+8183 */
  0x0000, /* U+8184 */
  0x0000, /* U+8185 */
  0x0000, /* U+8186 */
  0x0000, /* U+8187 */
  0xe44c, /* U+8188 */
  0x0000, /* U+8189 */
  0xe44d, /* U+818a */
  0x0000, /* U+818b */
  0x0000, /* U+818c */
  0x0000, /* U+818d */
  0x0000, /* U+818e */
  0x8d70, /* U+818f */
  0x0000, /* U+8190 */
  0x0000, /* U+8191 */
  0x0000, /* U+8192 */
  0xe455, /* U+8193 */
  0x0000, /* U+8194 */
  0xe451, /* U+8195 */
  0x0000, /* U+8196 */
  0x0000, /* U+8197 */
  0x0000, /* U+8198 */
  0x0000, /* U+8199 */
  0x9586, /* U+819a */
  0x0000, /* U+819b */
  0x968c, /* U+819c */
  0x9547, /* U+819d */
  0x0000, /* U+819e */
  0x0000, /* U+819f */
  0xe450, /* U+81a0 */
  0x0000, /* U+81a1 */
  0x0000, /* U+81a2 */
  0xe453, /* U+81a3 */
  0xe452, /* U+81a4 */
  0x0000, /* U+81a5 */
  0x0000, /* U+81a6 */
  0x0000, /* U+81a7 */
  0x9663, /* U+81a8 */
  0xe456, /* U+81a9 */
  0x0000, /* U+81aa */
  0x0000, /* U+81ab */
  0x0000, /* U+81ac */
  0x0000, /* U+81ad */
  0x0000, /* U+81ae */
  0x0000, /* U+81af */
  0xe457, /* U+81b0 */
  0x0000, /* U+81b1 */
  0x0000, /* U+81b2 */
  0x9156, /* U+81b3 */
  0x0000, /* U+81b4 */
  0xe458, /* U+81b5 */
  0x0000, /* U+81b6 */
  0x0000, /* U+81b7 */
  0xe45a, /* U+81b8 */
  0x0000, /* U+81b9 */
  0xe45e, /* U+81ba */
  0x0000, /* U+81bb */
  0x0000, /* U+81bc */
  0xe45b, /* U+81bd */
  0xe459, /* U+81be */
  0x945e, /* U+81bf */
  0xe45c, /* U+81c0 */
  0x0000, /* U+81c1 */
  0xe45d, /* U+81c2 */
  0x0000, /* U+81c3 */
  0x0000, /* U+81c4 */
  0x0000, /* U+81c5 */
  0x89b0, /* U+81c6 */
  0x0000, /* U+81c7 */
  0xe464, /* U+81c8 */
  0xe45f, /* U+81c9 */
  0x0000, /* U+81ca */
  0x0000, /* U+81cb */
  0x0000, /* U+81cc */
  0xe460, /* U+81cd */
  0x0000, /* U+81ce */
  0x0000, /* U+81cf */
  0x0000, /* U+81d0 */
  0xe461, /* U+81d1 */
  0x0000, /* U+81d2 */
  0x919f, /* U+81d3 */
  0x0000, /* U+81d4 */
  0x0000, /* U+81d5 */
  0x0000, /* U+81d6 */
  0x0000, /* U+81d7 */
  0xe463, /* U+81d8 */
  0xe462, /* U+81d9 */
  0xe465, /* U+81da */
  0x0000, /* U+81db */
  0x0000, /* U+81dc */
  0x0000, /* U+81dd */
  0x0000, /* U+81de */
  0xe466, /* U+81df */
  0xe467, /* U+81e0 */
  0x0000, /* U+81e1 */
  0x0000, /* U+81e2 */
  0x9062, /* U+81e3 */
  0x0000, /* U+81e4 */
  0x89e7, /* U+81e5 */
  0x0000, /* U+81e6 */
  0xe468, /* U+81e7 */
  0x97d5, /* U+81e8 */
  0x0000, /* U+81e9 */
  0x8ea9, /* U+81ea */
  0x0000, /* U+81eb */
  0x0000, /* U+81ec */
  0x8f4c, /* U+81ed */
  0x0000, /* U+81ee */
  0x0000, /* U+81ef */
  0x0000, /* U+81f0 */
  0x0000, /* U+81f1 */
  0x0000, /* U+81f2 */
  0x8e8a, /* U+81f3 */
  0x9276, /* U+81f4 */
  0x0000, /* U+81f5 */
  0x0000, /* U+81f6 */
  0x0000, /* U+81f7 */
  0x0000, /* U+81f8 */
  0x0000, /* U+81f9 */
  0xe469, /* U+81fa */
  0xe46a, /* U+81fb */
  0x8950, /* U+81fc */
  0x0000, /* U+81fd */
  0xe46b, /* U+81fe */
  0x0000, /* U+81ff */
  0x0000, /* U+8200 */
  0xe46c, /* U+8201 */
  0xe46d, /* U+8202 */
  0x0000, /* U+8203 */
  0x0000, /* U+8204 */
  0xe46e, /* U+8205 */
  0x0000, /* U+8206 */
  0xe46f, /* U+8207 */
  0x8bbb, /* U+8208 */
  0x9da8, /* U+8209 */
  0xe470, /* U+820a */
  0x0000, /* U+820b */
  0x90e3, /* U+820c */
  0xe471, /* U+820d */
  0x8ec9, /* U+820e */
  0x0000, /* U+820f */
  0xe472, /* U+8210 */
  0x0000, /* U+8211 */
  0x98ae, /* U+8212 */
  0x0000, /* U+8213 */
  0x0000, /* U+8214 */
  0x0000, /* U+8215 */
  0xe473, /* U+8216 */
  0x95dc, /* U+8217 */
  0x8ada, /* U+8218 */
  0x0000, /* U+8219 */
  0x0000, /* U+821a */
  0x9143, /* U+821b */
  0x8f77, /* U+821c */
  0x0000, /* U+821d */
  0x9591, /* U+821e */
  0x8f4d, /* U+821f */
  0x0000, /* U+8220 */
  0x0000, /* U+8221 */
  0x0000, /* U+8222 */
  0x0000, /* U+8223 */
  0x0000, /* U+8224 */
  0x0000, /* U+8225 */
  0x0000, /* U+8226 */
  0x0000, /* U+8227 */
  0x0000, /* U+8228 */
  0xe474, /* U+8229 */
  0x8d71, /* U+822a */
  0xe475, /* U+822b */
  0x94ca, /* U+822c */
  0x0000, /* U+822d */
  0xe484, /* U+822e */
  0x0000, /* U+822f */
  0x0000, /* U+8230 */
  0x0000, /* U+8231 */
  0x0000, /* U+8232 */
  0xe477, /* U+8233 */
  0x0000, /* U+8234 */
  0x91c7, /* U+8235 */
  0x9495, /* U+8236 */
  0x8cbd, /* U+8237 */
  0xe476, /* U+8238 */
  0x9144, /* U+8239 */
  0x0000, /* U+823a */
  0x0000, /* U+823b */
  0x0000, /* U+823c */
  0x0000, /* U+823d */
  0x0000, /* U+823e */
  0x0000, /* U+823f */
  0xe478, /* U+8240 */
  0x0000, /* U+8241 */
  0x0000, /* U+8242 */
  0x0000, /* U+8243 */
  0x0000, /* U+8244 */
  0x0000, /* U+8245 */
  0x0000, /* U+8246 */
  0x92f8, /* U+8247 */
  0x0000, /* U+8248 */
  0x0000, /* U+8249 */
  0x0000, /* U+824a */
  0x0000, /* U+824b */
  0x0000, /* U+824c */
  0x0000, /* U+824d */
  0x0000, /* U+824e */
  0x0000, /* U+824f */
  0x0000, /* U+8250 */
  0x0000, /* U+8251 */
  0x0000, /* U+8252 */
  0x0000, /* U+8253 */
  0x0000, /* U+8254 */
  0x0000, /* U+8255 */
  0x0000, /* U+8256 */
  0x0000, /* U+8257 */
  0xe47a, /* U+8258 */
  0xe479, /* U+8259 */
  0xe47c, /* U+825a */
  0x0000, /* U+825b */
  0x0000, /* U+825c */
  0xe47b, /* U+825d */
  0x0000, /* U+825e */
  0xe47d, /* U+825f */
  0x0000, /* U+8260 */
  0x0000, /* U+8261 */
  0xe480, /* U+8262 */
  0x0000, /* U+8263 */
  0xe47e, /* U+8264 */
  0x0000, /* U+8265 */
  0x8acd, /* U+8266 */
  0x0000, /* U+8267 */
  0xe481, /* U+8268 */
  0x0000, /* U+8269 */
  0xe482, /* U+826a */
  0xe483, /* U+826b */
  0x0000, /* U+826c */
  0x0000, /* U+826d */
  0x8daf, /* U+826e */
  0x97c7, /* U+826f */
  0x0000, /* U+8270 */
  0xe485, /* U+8271 */
  0x9046, /* U+8272 */
  0x0000, /* U+8273 */
  0x0000, /* U+8274 */
  0x0000, /* U+8275 */
  0x8990, /* U+8276 */
  0xe486, /* U+8277 */
  0xe487, /* U+8278 */
  0x0000, /* U+8279 */
  0x0000, /* U+827a */
  0x0000, /* U+827b */
  0x0000, /* U+827c */
  0x0000, /* U+827d */
  0xe488, /* U+827e */
  0x0000, /* U+827f */
  0x0000, /* U+8280 */
  0x0000, /* U+8281 */
  0x0000, /* U+8282 */
  0x0000, /* U+8283 */
  0x0000, /* U+8284 */
  0x0000, /* U+8285 */
  0x0000, /* U+8286 */
  0x0000, /* U+8287 */
  0x0000, /* U+8288 */
  0x0000, /* U+8289 */
  0x0000, /* U+828a */
  0x88f0, /* U+828b */
  0x0000, /* U+828c */
  0xe489, /* U+828d */
  0x0000, /* U+828e */
  0x0000, /* U+828f */
  0x0000, /* U+8290 */
  0x0000, /* U+8291 */
  0xe48a, /* U+8292 */
  0x0000, /* U+8293 */
  0x0000, /* U+8294 */
  0x0000, /* U+8295 */
  0x0000, /* U+8296 */
  0x0000, /* U+8297 */
  0x0000, /* U+8298 */
  0x9587, /* U+8299 */
  0x0000, /* U+829a */
  0x0000, /* U+829b */
  0x0000, /* U+829c */
  0x8ec5, /* U+829d */
  0x0000, /* U+829e */
  0xe48c, /* U+829f */
  0x0000, /* U+82a0 */
  0x0000, /* U+82a1 */
  0x0000, /* U+82a2 */
  0x0000, /* U+82a3 */
  0x0000, /* U+82a4 */
  0x8a48, /* U+82a5 */
  0x88b0, /* U+82a6 */
  0x0000, /* U+82a7 */
  0x0000, /* U+82a8 */
  0x0000, /* U+82a9 */
  0x0000, /* U+82aa */
  0xe48b, /* U+82ab */
  0xe48e, /* U+82ac */
  0x946d, /* U+82ad */
  0x0000, /* U+82ae */
  0x9063, /* U+82af */
  0x0000, /* U+82b0 */
  0x89d4, /* U+82b1 */
  0x0000, /* U+82b2 */
  0x9646, /* U+82b3 */
  0x0000, /* U+82b4 */
  0x0000, /* U+82b5 */
  0x0000, /* U+82b6 */
  0x0000, /* U+82b7 */
  0x8c7c, /* U+82b8 */
  0x8bda, /* U+82b9 */
  0x0000, /* U+82ba */
  0xe48d, /* U+82bb */
  0x0000, /* U+82bc */
  0x89e8, /* U+82bd */
  0x0000, /* U+82be */
  0x0000, /* U+82bf */
  0x0000, /* U+82c0 */
  0x0000, /* U+82c1 */
  0x0000, /* U+82c2 */
  0x0000, /* U+82c3 */
  0x0000, /* U+82c4 */
  0x8aa1, /* U+82c5 */
  0x0000, /* U+82c6 */
  0x0000, /* U+82c7 */
  0x0000, /* U+82c8 */
  0x0000, /* U+82c9 */
  0x0000, /* U+82ca */
  0x0000, /* U+82cb */
  0x0000, /* U+82cc */
  0x0000, /* U+82cd */
  0x0000, /* U+82ce */
  0x0000, /* U+82cf */
  0x0000, /* U+82d0 */
  0x8991, /* U+82d1 */
  0xe492, /* U+82d2 */
  0x97e8, /* U+82d3 */
  0x91db, /* U+82d4 */
  0x0000, /* U+82d5 */
  0x0000, /* U+82d6 */
  0x9563, /* U+82d7 */
  0x0000, /* U+82d8 */
  0xe49e, /* U+82d9 */
  0x0000, /* U+82da */
  0x89d5, /* U+82db */
  0xe49c, /* U+82dc */
  0x0000, /* U+82dd */
  0xe49a, /* U+82de */
  0xe491, /* U+82df */
  0x0000, /* U+82e0 */
  0xe48f, /* U+82e1 */
  0x0000, /* U+82e2 */
  0xe490, /* U+82e3 */
  0x0000, /* U+82e4 */
  0x8ee1, /* U+82e5 */
  0x8bea, /* U+82e6 */
  0x9297, /* U+82e7 */
  0x0000, /* U+82e8 */
  0x0000, /* U+82e9 */
  0x0000, /* U+82ea */
  0x93cf, /* U+82eb */
  0x0000, /* U+82ec */
  0x0000, /* U+82ed */
  0x0000, /* U+82ee */
  0x0000, /* U+82ef */
  0x0000, /* U+82f0 */
  0x8970, /* U+82f1 */
  0x0000, /* U+82f2 */
  0xe494, /* U+82f3 */
  0xe493, /* U+82f4 */
  0x0000, /* U+82f5 */
  0x0000, /* U+82f6 */
  0x0000, /* U+82f7 */
  0x0000, /* U+82f8 */
  0xe499, /* U+82f9 */
  0xe495, /* U+82fa */
  0xe498, /* U+82fb */
  0x0000, /* U+82fc */
  0x0000, /* U+82fd */
  0x0000, /* U+82fe */
  0x0000, /* U+82ff */
  0x0000, /* U+8300 */
  0xfb93, /* U+8301 */
  0x96ce, /* U+8302 */
  0xe497, /* U+8303 */
  0x89d6, /* U+8304 */
  0x8a9d, /* U+8305 */
  0xe49b, /* U+8306 */
  0x0000, /* U+8307 */
  0x0000, /* U+8308 */
  0xe49d, /* U+8309 */
  0x0000, /* U+830a */
  0x0000, /* U+830b */
  0x0000, /* U+830c */
  0x0000, /* U+830d */
  0x8c73, /* U+830e */
  0x0000, /* U+830f */
  0x0000, /* U+8310 */
  0x0000, /* U+8311 */
  0x0000, /* U+8312 */
  0x0000, /* U+8313 */
  0x0000, /* U+8314 */
  0x0000, /* U+8315 */
  0xe4a1, /* U+8316 */
  0xe4aa, /* U+8317 */
  0xe4ab, /* U+8318 */
  0x0000, /* U+8319 */
  0x0000, /* U+831a */
  0x0000, /* U+831b */
  0x88a9, /* U+831c */
  0x0000, /* U+831d */
  0x0000, /* U+831e */
  0x0000, /* U+831f */
  0x0000, /* U+8320 */
  0x0000, /* U+8321 */
  0x0000, /* U+8322 */
  0xe4b2, /* U+8323 */
  0x0000, /* U+8324 */
  0x0000, /* U+8325 */
  0x0000, /* U+8326 */
  0x0000, /* U+8327 */
  0x88ef, /* U+8328 */
  0x0000, /* U+8329 */
  0x0000, /* U+832a */
  0xe4a9, /* U+832b */
  0x0000, /* U+832c */
  0x0000, /* U+832d */
  0x0000, /* U+832e */
  0xe4a8, /* U+832f */
  0x0000, /* U+8330 */
  0xe4a3, /* U+8331 */
  0xe4a2, /* U+8332 */
  0x0000, /* U+8333 */
  0xe4a0, /* U+8334 */
  0xe49f, /* U+8335 */
  0x9283, /* U+8336 */
  0x0000, /* U+8337 */
  0x91f9, /* U+8338 */
  0xe4a5, /* U+8339 */
  0x0000, /* U+833a */
  0x0000, /* U+833b */
  0x0000, /* U+833c */
  0x0000, /* U+833d */
  0x0000, /* U+833e */
  0x0000, /* U+833f */
  0xe4a4, /* U+8340 */
  0x0000, /* U+8341 */
  0x0000, /* U+8342 */
  0x0000, /* U+8343 */
  0x0000, /* U+8344 */
  0xe4a7, /* U+8345 */
  0x0000, /* U+8346 */
  0x0000, /* U+8347 */
  0x0000, /* U+8348 */
  0x9190, /* U+8349 */
  0x8c74, /* U+834a */
  0x0000, /* U+834b */
  0x0000, /* U+834c */
  0x0000, /* U+834d */
  0x0000, /* U+834e */
  0x8960, /* U+834f */
  0xe4a6, /* U+8350 */
  0x0000, /* U+8351 */
  0x8d72, /* U+8352 */
  0x0000, /* U+8353 */
  0x0000, /* U+8354 */
  0x0000, /* U+8355 */
  0x0000, /* U+8356 */
  0x0000, /* U+8357 */
  0x9191, /* U+8358 */
  0x0000, /* U+8359 */
  0x0000, /* U+835a */
  0x0000, /* U+835b */
  0x0000, /* U+835c */
  0x0000, /* U+835d */
  0x0000, /* U+835e */
  0x0000, /* U+835f */
  0x0000, /* U+8360 */
  0x0000, /* U+8361 */
  0xfb94, /* U+8362 */
  0x0000, /* U+8363 */
  0x0000, /* U+8364 */
  0x0000, /* U+8365 */
  0x0000, /* U+8366 */
  0x0000, /* U+8367 */
  0x0000, /* U+8368 */
  0x0000, /* U+8369 */
  0x0000, /* U+836a */
  0x0000, /* U+836b */
  0x0000, /* U+836c */
  0x0000, /* U+836d */
  0x0000, /* U+836e */
  0x0000, /* U+836f */
  0x0000, /* U+8370 */
  0x0000, /* U+8371 */
  0x0000, /* U+8372 */
  0xe4b8, /* U+8373 */
  0x0000, /* U+8374 */
  0xe4b9, /* U+8375 */
  0x0000, /* U+8376 */
  0x89d7, /* U+8377 */
  0x0000, /* U+8378 */
  0x0000, /* U+8379 */
  0x0000, /* U+837a */
  0x89ac, /* U+837b */
  0xe4b6, /* U+837c */
  0x0000, /* U+837d */
  0x0000, /* U+837e */
  0xfb95, /* U+837f */
  0x0000, /* U+8380 */
  0x0000, /* U+8381 */
  0x0000, /* U+8382 */
  0x0000, /* U+8383 */
  0x0000, /* U+8384 */
  0xe4ac, /* U+8385 */
  0x0000, /* U+8386 */
  0xe4b4, /* U+8387 */
  0x0000, /* U+8388 */
  0xe4bb, /* U+8389 */
  0xe4b5, /* U+838a */
  0x0000, /* U+838b */
  0x0000, /* U+838c */
  0x0000, /* U+838d */
  0xe4b3, /* U+838e */
  0x0000, /* U+838f */
  0x0000, /* U+8390 */
  0x0000, /* U+8391 */
  0x0000, /* U+8392 */
  0xe496, /* U+8393 */
  0x0000, /* U+8394 */
  0x0000, /* U+8395 */
  0xe4b1, /* U+8396 */
  0x0000, /* U+8397 */
  0x0000, /* U+8398 */
  0x0000, /* U+8399 */
  0xe4ad, /* U+839a */
  0x0000, /* U+839b */
  0x0000, /* U+839c */
  0x0000, /* U+839d */
  0x8ace, /* U+839e */
  0xe4af, /* U+839f */
  0xe4ba, /* U+83a0 */
  0x0000, /* U+83a1 */
  0xe4b0, /* U+83a2 */
  0x0000, /* U+83a3 */
  0x0000, /* U+83a4 */
  0x0000, /* U+83a5 */
  0x0000, /* U+83a6 */
  0x0000, /* U+83a7 */
  0xe4bc, /* U+83a8 */
  0x0000, /* U+83a9 */
  0xe4ae, /* U+83aa */
  0x949c, /* U+83ab */
  0x0000, /* U+83ac */
  0x0000, /* U+83ad */
  0x0000, /* U+83ae */
  0x0000, /* U+83af */
  0x0000, /* U+83b0 */
  0x9789, /* U+83b1 */
  0x0000, /* U+83b2 */
  0x0000, /* U+83b3 */
  0x0000, /* U+83b4 */
  0xe4b7, /* U+83b5 */
  0x0000, /* U+83b6 */
  0x0000, /* U+83b7 */
  0x0000, /* U+83b8 */
  0x0000, /* U+83b9 */
  0x0000, /* U+83ba */
  0x0000, /* U+83bb */
  0x0000, /* U+83bc */
  0xe4cd, /* U+83bd */
  0x0000, /* U+83be */
  0x0000, /* U+83bf */
  0x0000, /* U+83c0 */
  0xe4c5, /* U+83c1 */
  0x0000, /* U+83c2 */
  0x0000, /* U+83c3 */
  0x0000, /* U+83c4 */
  0x909b, /* U+83c5 */
  0x0000, /* U+83c6 */
  0xfb96, /* U+83c7 */
  0x0000, /* U+83c8 */
  0x0000, /* U+83c9 */
  0x8b65, /* U+83ca */
  0x0000, /* U+83cb */
  0x8bdb, /* U+83cc */
  0x0000, /* U+83cd */
  0xe4c0, /* U+83ce */
  0x0000, /* U+83cf */
  0x0000, /* U+83d0 */
  0x0000, /* U+83d1 */
  0x0000, /* U+83d2 */
  0x89d9, /* U+83d3 */
  0x0000, /* U+83d4 */
  0x0000, /* U+83d5 */
  0x8fd2, /* U+83d6 */
  0x0000, /* U+83d7 */
  0xe4c3, /* U+83d8 */
  0x0000, /* U+83d9 */
  0x0000, /* U+83da */
  0x0000, /* U+83db */
  0x8dd8, /* U+83dc */
  0x0000, /* U+83dd */
  0x0000, /* U+83de */
  0x9370, /* U+83df */
  0xe4c8, /* U+83e0 */
  0x0000, /* U+83e1 */
  0x0000, /* U+83e2 */
  0x0000, /* U+83e3 */
  0x0000, /* U+83e4 */
  0x0000, /* U+83e5 */
  0x0000, /* U+83e6 */
  0x0000, /* U+83e7 */
  0x0000, /* U+83e8 */
  0x95ec, /* U+83e9 */
  0x0000, /* U+83ea */
  0xe4bf, /* U+83eb */
  0x0000, /* U+83ec */
  0x0000, /* U+83ed */
  0x0000, /* U+83ee */
  0x89d8, /* U+83ef */
  0x8cd4, /* U+83f0 */
  0x9548, /* U+83f1 */
  0xe4c9, /* U+83f2 */
  0x0000, /* U+83f3 */
  0xe4bd, /* U+83f4 */
  0x0000, /* U+83f5 */
  0xfb97, /* U+83f6 */
  0xe4c6, /* U+83f7 */
  0x0000, /* U+83f8 */
  0x0000, /* U+83f9 */
  0x0000, /* U+83fa */
  0xe4d0, /* U+83fb */
  0x0000, /* U+83fc */
  0xe4c1, /* U+83fd */
  0x0000, /* U+83fe */
  0x0000, /* U+83ff */
  0x0000, /* U+8400 */
  0x0000, /* U+8401 */
  0x0000, /* U+8402 */
  0xe4c2, /* U+8403 */
  0x93b8, /* U+8404 */
  0x0000, /* U+8405 */
  0x0000, /* U+8406 */
  0xe4c7, /* U+8407 */
  0x0000, /* U+8408 */
  0x0000, /* U+8409 */
  0x0000, /* U+840a */
  0xe4c4, /* U+840b */
  0x9647, /* U+840c */
  0xe4ca, /* U+840d */
  0x88de, /* U+840e */
  0x0000, /* U+840f */
  0x0000, /* U+8410 */
  0x0000, /* U+8411 */
  0x0000, /* U+8412 */
  0xe4be, /* U+8413 */
  0x0000, /* U+8414 */
  0x0000, /* U+8415 */
  0x0000, /* U+8416 */
  0x0000, /* U+8417 */
  0x0000, /* U+8418 */
  0x0000, /* U+8419 */
  0x0000, /* U+841a */
  0x0000, /* U+841b */
  0x0000, /* U+841c */
  0x0000, /* U+841d */
  0x0000, /* U+841e */
  0x0000, /* U+841f */
  0xe4cc, /* U+8420 */
  0x0000, /* U+8421 */
  0xe4cb, /* U+8422 */
  0x0000, /* U+8423 */
  0x0000, /* U+8424 */
  0x0000, /* U+8425 */
  0x0000, /* U+8426 */
  0x0000, /* U+8427 */
  0x0000, /* U+8428 */
  0x948b, /* U+8429 */
  0xe4d2, /* U+842a */
  0x0000, /* U+842b */
  0xe4dd, /* U+842c */
  0x0000, /* U+842d */
  0x0000, /* U+842e */
  0x0000, /* U+842f */
  0x0000, /* U+8430 */
  0x8a9e, /* U+8431 */
  0x0000, /* U+8432 */
  0x0000, /* U+8433 */
  0x0000, /* U+8434 */
  0xe4e0, /* U+8435 */
  0x0000, /* U+8436 */
  0x0000, /* U+8437 */
  0xe4ce, /* U+8438 */
  0x0000, /* U+8439 */
  0x0000, /* U+843a */
  0x0000, /* U+843b */
  0xe4d3, /* U+843c */
  0x978e, /* U+843d */
  0x0000, /* U+843e */
  0x0000, /* U+843f */
  0x0000, /* U+8440 */
  0x0000, /* U+8441 */
  0x0000, /* U+8442 */
  0x0000, /* U+8443 */
  0x0000, /* U+8444 */
  0x0000, /* U+8445 */
  0xe4dc, /* U+8446 */
  0x0000, /* U+8447 */
  0xfb98, /* U+8448 */
  0x9774, /* U+8449 */
  0x0000, /* U+844a */
  0x0000, /* U+844b */
  0x0000, /* U+844c */
  0x0000, /* U+844d */
  0x97a8, /* U+844e */
  0x0000, /* U+844f */
  0x0000, /* U+8450 */
  0x0000, /* U+8451 */
  0x0000, /* U+8452 */
  0x0000, /* U+8453 */
  0x0000, /* U+8454 */
  0x0000, /* U+8455 */
  0x0000, /* U+8456 */
  0x9298, /* U+8457 */
  0x0000, /* U+8458 */
  0x0000, /* U+8459 */
  0x0000, /* U+845a */
  0x8a8b, /* U+845b */
  0x0000, /* U+845c */
  0x0000, /* U+845d */
  0x0000, /* U+845e */
  0x0000, /* U+845f */
  0x0000, /* U+8460 */
  0x9592, /* U+8461 */
  0xe4e2, /* U+8462 */
  0x939f, /* U+8463 */
  0x0000, /* U+8464 */
  0x0000, /* U+8465 */
  0x88af, /* U+8466 */
  0x0000, /* U+8467 */
  0x0000, /* U+8468 */
  0xe4db, /* U+8469 */
  0x0000, /* U+846a */
  0xe4d7, /* U+846b */
  0x9192, /* U+846c */
  0xe4d1, /* U+846d */
  0xe4d9, /* U+846e */
  0xe4de, /* U+846f */
  0x0000, /* U+8470 */
  0x944b, /* U+8471 */
  0x0000, /* U+8472 */
  0x0000, /* U+8473 */
  0x0000, /* U+8474 */
  0x88a8, /* U+8475 */
  0x0000, /* U+8476 */
  0xe4d6, /* U+8477 */
  0x0000, /* U+8478 */
  0xe4df, /* U+8479 */
  0x9598, /* U+847a */
  0x0000, /* U+847b */
  0x0000, /* U+847c */
  0x0000, /* U+847d */
  0x0000, /* U+847e */
  0x0000, /* U+847f */
  0x0000, /* U+8480 */
  0x0000, /* U+8481 */
  0xe4da, /* U+8482 */
  0x0000, /* U+8483 */
  0xe4d5, /* U+8484 */
  0x0000, /* U+8485 */
  0x0000, /* U+8486 */
  0x0000, /* U+8487 */
  0x0000, /* U+8488 */
  0x0000, /* U+8489 */
  0x0000, /* U+848a */
  0x8fd3, /* U+848b */
  0x0000, /* U+848c */
  0x0000, /* U+848d */
  0x0000, /* U+848e */
  0x0000, /* U+848f */
  0x8f4e, /* U+8490 */
  0x0000, /* U+8491 */
  0x0000, /* U+8492 */
  0x0000, /* U+8493 */
  0x8eaa, /* U+8494 */
  0x0000, /* U+8495 */
  0x0000, /* U+8496 */
  0x0000, /* U+8497 */
  0x0000, /* U+8498 */
  0x96d6, /* U+8499 */
  0x0000, /* U+849a */
  0x0000, /* U+849b */
  0x9566, /* U+849c */
  0x0000, /* U+849d */
  0x0000, /* U+849e */
  0xe4e5, /* U+849f */
  0x0000, /* U+84a0 */
  0xe4ee, /* U+84a1 */
  0x0000, /* U+84a2 */
  0x0000, /* U+84a3 */
  0x0000, /* U+84a4 */
  0x0000, /* U+84a5 */
  0x0000, /* U+84a6 */
  0x0000, /* U+84a7 */
  0x0000, /* U+84a8 */
  0x0000, /* U+84a9 */
  0x0000, /* U+84aa */
  0x0000, /* U+84ab */
  0x0000, /* U+84ac */
  0xe4d8, /* U+84ad */
  0x0000, /* U+84ae */
  0x0000, /* U+84af */
  0x0000, /* U+84b0 */
  0x0000, /* U+84b1 */
  0x8a97, /* U+84b2 */
  0x0000, /* U+84b3 */
  0xfb99, /* U+84b4 */
  0x0000, /* U+84b5 */
  0x0000, /* U+84b6 */
  0x0000, /* U+84b7 */
  0x8ff6, /* U+84b8 */
  0xe4e3, /* U+84b9 */
  0x0000, /* U+84ba */
  0xe4e8, /* U+84bb */
  0x9193, /* U+84bc */
  0x0000, /* U+84bd */
  0x0000, /* U+84be */
  0xe4e4, /* U+84bf */
  0x0000, /* U+84c0 */
  0xe4eb, /* U+84c1 */
  0x0000, /* U+84c2 */
  0x0000, /* U+84c3 */
  0x927e, /* U+84c4 */
  0x0000, /* U+84c5 */
  0xe4ec, /* U+84c6 */
  0x0000, /* U+84c7 */
  0x0000, /* U+84c8 */
  0x9775, /* U+84c9 */
  0xe4e1, /* U+84ca */
  0x8a57, /* U+84cb */
  0x0000, /* U+84cc */
  0xe4e7, /* U+84cd */
  0x0000, /* U+84ce */
  0x0000, /* U+84cf */
  0xe4ea, /* U+84d0 */
  0x96aa, /* U+84d1 */
  0x0000, /* U+84d2 */
  0x0000, /* U+84d3 */
  0x0000, /* U+84d4 */
  0x0000, /* U+84d5 */
  0xe4ed, /* U+84d6 */
  0x0000, /* U+84d7 */
  0x0000, /* U+84d8 */
  0xe4e6, /* U+84d9 */
  0xe4e9, /* U+84da */
  0x0000, /* U+84db */
  0xfa60, /* U+84dc */
  0x0000, /* U+84dd */
  0x0000, /* U+84de */
  0x0000, /* U+84df */
  0x0000, /* U+84e0 */
  0x0000, /* U+84e1 */
  0x0000, /* U+84e2 */
  0x0000, /* U+84e3 */
  0x0000, /* U+84e4 */
  0x0000, /* U+84e5 */
  0x0000, /* U+84e6 */
  0x0000, /* U+84e7 */
  0x0000, /* U+84e8 */
  0x0000, /* U+84e9 */
  0x0000, /* U+84ea */
  0x0000, /* U+84eb */
  0x9648, /* U+84ec */
  0x0000, /* U+84ed */
  0x9840, /* U+84ee */
  0x0000, /* U+84ef */
  0x0000, /* U+84f0 */
  0x0000, /* U+84f1 */
  0x0000, /* U+84f2 */
  0x0000, /* U+84f3 */
  0xe4f1, /* U+84f4 */
  0x0000, /* U+84f5 */
  0x0000, /* U+84f6 */
  0x0000, /* U+84f7 */
  0x0000, /* U+84f8 */
  0x0000, /* U+84f9 */
  0x0000, /* U+84fa */
  0x0000, /* U+84fb */
  0xe4f8, /* U+84fc */
  0x0000, /* U+84fd */
  0x0000, /* U+84fe */
  0xe4f0, /* U+84ff */
  0x8ec1, /* U+8500 */
  0x0000, /* U+8501 */
  0x0000, /* U+8502 */
  0x0000, /* U+8503 */
  0x0000, /* U+8504 */
  0x0000, /* U+8505 */
  0xe4cf, /* U+8506 */
  0x0000, /* U+8507 */
  0x0000, /* U+8508 */
  0x0000, /* U+8509 */
  0x0000, /* U+850a */
  0x0000, /* U+850b */
  0x0000, /* U+850c */
  0x0000, /* U+850d */
  0x0000, /* U+850e */
  0x0000, /* U+850f */
  0x0000, /* U+8510 */
  0x95cc, /* U+8511 */
  0x0000, /* U+8512 */
  0x96a0, /* U+8513 */
  0xe4f7, /* U+8514 */
  0xe4f6, /* U+8515 */
  0x0000, /* U+8516 */
  0xe4f2, /* U+8517 */
  0xe4f3, /* U+8518 */
  0x0000, /* U+8519 */
  0x8955, /* U+851a */
  0x0000, /* U+851b */
  0x0000, /* U+851c */
  0x0000, /* U+851d */
  0x0000, /* U+851e */
  0xe4f5, /* U+851f */
  0x0000, /* U+8520 */
  0xe4ef, /* U+8521 */
  0x0000, /* U+8522 */
  0x0000, /* U+8523 */
  0x0000, /* U+8524 */
  0x0000, /* U+8525 */
  0x92d3, /* U+8526 */
  0x0000, /* U+8527 */
  0x0000, /* U+8528 */
  0x0000, /* U+8529 */
  0x0000, /* U+852a */
  0x0000, /* U+852b */
  0xe4f4, /* U+852c */
  0x88fc, /* U+852d */
  0x0000, /* U+852e */
  0x0000, /* U+852f */
  0x0000, /* U+8530 */
  0x0000, /* U+8531 */
  0x0000, /* U+8532 */
  0x0000, /* U+8533 */
  0x0000, /* U+8534 */
  0x91a0, /* U+8535 */
  0x0000, /* U+8536 */
  0x0000, /* U+8537 */
  0x0000, /* U+8538 */
  0x0000, /* U+8539 */
  0x0000, /* U+853a */
  0x0000, /* U+853b */
  0x0000, /* U+853c */
  0x95c1, /* U+853d */
  0x0000, /* U+853e */
  0x0000, /* U+853f */
  0xe4f9, /* U+8540 */
  0xe540, /* U+8541 */
  0x0000, /* U+8542 */
  0x94d7, /* U+8543 */
  0x0000, /* U+8544 */
  0x0000, /* U+8545 */
  0x0000, /* U+8546 */
  0x0000, /* U+8547 */
  0xe4fc, /* U+8548 */
  0x8fd4, /* U+8549 */
  0x8ec7, /* U+854a */
  0xe542, /* U+854b */
  0x0000, /* U+854c */
  0x0000, /* U+854d */
  0x8bbc, /* U+854e */
  0x0000, /* U+854f */
  0x0000, /* U+8550 */
  0x0000, /* U+8551 */
  0x0000, /* U+8552 */
  0xfb9a, /* U+8553 */
  0x0000, /* U+8554 */
  0xe543, /* U+8555 */
  0x0000, /* U+8556 */
  0x9599, /* U+8557 */
  0xe4fb, /* U+8558 */
  0xfb9b, /* U+8559 */
  0xe4d4, /* U+855a */
  0x0000, /* U+855b */
  0x0000, /* U+855c */
  0x0000, /* U+855d */
  0x0000, /* U+855e */
  0x0000, /* U+855f */
  0x0000, /* U+8560 */
  0x0000, /* U+8561 */
  0x0000, /* U+8562 */
  0xe4fa, /* U+8563 */
  0x0000, /* U+8564 */
  0x0000, /* U+8565 */
  0x0000, /* U+8566 */
  0x0000, /* U+8567 */
  0x986e, /* U+8568 */
  0x93a0, /* U+8569 */
  0x9593, /* U+856a */
  0xfb9c, /* U+856b */
  0x0000, /* U+856c */
  0xe54a, /* U+856d */
  0x0000, /* U+856e */
  0x0000, /* U+856f */
  0x0000, /* U+8570 */
  0x0000, /* U+8571 */
  0x0000, /* U+8572 */
  0x0000, /* U+8573 */
  0x0000, /* U+8574 */
  0x0000, /* U+8575 */
  0x0000, /* U+8576 */
  0xe550, /* U+8577 */
  0x0000, /* U+8578 */
  0x0000, /* U+8579 */
  0x0000, /* U+857a */
  0x0000, /* U+857b */
  0x0000, /* U+857c */
  0x0000, /* U+857d */
  0xe551, /* U+857e */
  0x0000, /* U+857f */
  0xe544, /* U+8580 */
  0x0000, /* U+8581 */
  0x0000, /* U+8582 */
  0x0000, /* U+8583 */
  0x9496, /* U+8584 */
  0x0000, /* U+8585 */
  0x0000, /* U+8586 */
  0xe54e, /* U+8587 */
  0xe546, /* U+8588 */
  0x0000, /* U+8589 */
  0xe548, /* U+858a */
  0x0000, /* U+858b */
  0x0000, /* U+858c */
  0x0000, /* U+858d */
  0x0000, /* U+858e */
  0x0000, /* U+858f */
  0xe552, /* U+8590 */
  0xe547, /* U+8591 */
  0x0000, /* U+8592 */
  0x0000, /* U+8593 */
  0xe54b, /* U+8594 */
  0x0000, /* U+8595 */
  0x0000, /* U+8596 */
  0x8992, /* U+8597 */
  0x0000, /* U+8598 */
  0x93e3, /* U+8599 */
  0x0000, /* U+859a */
  0xe54c, /* U+859b */
  0xe54f, /* U+859c */
  0x0000, /* U+859d */
  0x0000, /* U+859e */
  0x0000, /* U+859f */
  0x0000, /* U+85a0 */
  0x0000, /* U+85a1 */
  0x0000, /* U+85a2 */
  0x0000, /* U+85a3 */
  0xe545, /* U+85a4 */
  0x0000, /* U+85a5 */
  0x9145, /* U+85a6 */
  0x0000, /* U+85a7 */
  0xe549, /* U+85a8 */
  0x8e46, /* U+85a9 */
  0x9064, /* U+85aa */
  0x8c4f, /* U+85ab */
  0x96f2, /* U+85ac */
  0x0000, /* U+85ad */
  0x96f7, /* U+85ae */
  0x8f92, /* U+85af */
  0xfb9e, /* U+85b0 */
  0x0000, /* U+85b1 */
  0x0000, /* U+85b2 */
  0x0000, /* U+85b3 */
  0x0000, /* U+85b4 */
  0x0000, /* U+85b5 */
  0x0000, /* U+85b6 */
  0x0000, /* U+85b7 */
  0x0000, /* U+85b8 */
  0xe556, /* U+85b9 */
  0xe554, /* U+85ba */
  0x0000, /* U+85bb */
  0x0000, /* U+85bc */
  0x0000, /* U+85bd */
  0x0000, /* U+85be */
  0x0000, /* U+85bf */
  0x0000, /* U+85c0 */
  0x986d, /* U+85c1 */
  0x0000, /* U+85c2 */
  0x0000, /* U+85c3 */
  0x0000, /* U+85c4 */
  0x0000, /* U+85c5 */
  0x0000, /* U+85c6 */
  0x0000, /* U+85c7 */
  0x0000, /* U+85c8 */
  0xe553, /* U+85c9 */
  0x0000, /* U+85ca */
  0x0000, /* U+85cb */
  0x0000, /* U+85cc */
  0x9795, /* U+85cd */
  0x0000, /* U+85ce */
  0xe555, /* U+85cf */
  0xe557, /* U+85d0 */
  0x0000, /* U+85d1 */
  0x0000, /* U+85d2 */
  0x0000, /* U+85d3 */
  0x0000, /* U+85d4 */
  0xe558, /* U+85d5 */
  0x0000, /* U+85d6 */
  0x0000, /* U+85d7 */
  0x0000, /* U+85d8 */
  0x0000, /* U+85d9 */
  0x0000, /* U+85da */
  0x0000, /* U+85db */
  0xe55b, /* U+85dc */
  0xe559, /* U+85dd */
  0x0000, /* U+85de */
  0x0000, /* U+85df */
  0x0000, /* U+85e0 */
  0x0000, /* U+85e1 */
  0x0000, /* U+85e2 */
  0x0000, /* U+85e3 */
  0x93a1, /* U+85e4 */
  0xe55a, /* U+85e5 */
  0x0000, /* U+85e6 */
  0x0000, /* U+85e7 */
  0x0000, /* U+85e8 */
  0x94cb, /* U+85e9 */
  0xe54d, /* U+85ea */
  0x0000, /* U+85eb */
  0x0000, /* U+85ec */
  0x0000, /* U+85ed */
  0x0000, /* U+85ee */
  0x0000, /* U+85ef */
  0x0000, /* U+85f0 */
  0x0000, /* U+85f1 */
  0x0000, /* U+85f2 */
  0x0000, /* U+85f3 */
  0x0000, /* U+85f4 */
  0x0000, /* U+85f5 */
  0x0000, /* U+85f6 */
  0x8f93, /* U+85f7 */
  0x0000, /* U+85f8 */
  0xe55c, /* U+85f9 */
  0xe561, /* U+85fa */
  0x9194, /* U+85fb */
  0x0000, /* U+85fc */
  0x0000, /* U+85fd */
  0xe560, /* U+85fe */
  0x0000, /* U+85ff */
  0x0000, /* U+8600 */
  0x0000, /* U+8601 */
  0xe541, /* U+8602 */
  0x0000, /* U+8603 */
  0x0000, /* U+8604 */
  0x0000, /* U+8605 */
  0xe562, /* U+8606 */
  0x9168, /* U+8607 */
  0x0000, /* U+8608 */
  0x0000, /* U+8609 */
  0xe55d, /* U+860a */
  0xe55f, /* U+860b */
  0x0000, /* U+860c */
  0x0000, /* U+860d */
  0x0000, /* U+860e */
  0x0000, /* U+860f */
  0x0000, /* U+8610 */
  0x0000, /* U+8611 */
  0x0000, /* U+8612 */
  0xe55e, /* U+8613 */
  0x0000, /* U+8614 */
  0x0000, /* U+8615 */
  0x9f50, /* U+8616 */
  0x9f41, /* U+8617 */
  0x0000, /* U+8618 */
  0x0000, /* U+8619 */
  0xe564, /* U+861a */
  0x0000, /* U+861b */
  0x0000, /* U+861c */
  0x0000, /* U+861d */
  0x0000, /* U+861e */
  0x0000, /* U+861f */
  0x0000, /* U+8620 */
  0x0000, /* U+8621 */
  0xe563, /* U+8622 */
  0x0000, /* U+8623 */
  0x0000, /* U+8624 */
  0x0000, /* U+8625 */
  0x0000, /* U+8626 */
  0x0000, /* U+8627 */
  0x0000, /* U+8628 */
  0x0000, /* U+8629 */
  0x0000, /* U+862a */
  0x0000, /* U+862b */
  0x0000, /* U+862c */
  0x9796, /* U+862d */
  0x0000, /* U+862e */
  0xe1ba, /* U+862f */
  0xe565, /* U+8630 */
  0x0000, /* U+8631 */
  0x0000, /* U+8632 */
  0x0000, /* U+8633 */
  0x0000, /* U+8634 */
  0x0000, /* U+8635 */
  0x0000, /* U+8636 */
  0x0000, /* U+8637 */
  0x0000, /* U+8638 */
  0x0000, /* U+8639 */
  0x0000, /* U+863a */
  0x0000, /* U+863b */
  0x0000, /* U+863c */
  0x0000, /* U+863d */
  0x0000, /* U+863e */
  0xe566, /* U+863f */
  0x0000, /* U+8640 */
  0x0000, /* U+8641 */
  0x0000, /* U+8642 */
  0x0000, /* U+8643 */
  0x0000, /* U+8644 */
  0x0000, /* U+8645 */
  0x0000, /* U+8646 */
  0x0000, /* U+8647 */
  0x0000, /* U+8648 */
  0x0000, /* U+8649 */
  0x0000, /* U+864a */
  0x0000, /* U+864b */
  0x0000, /* U+864c */
  0xe567, /* U+864d */
  0x8cd5, /* U+864e */
  0x0000, /* U+864f */
  0x8b73, /* U+8650 */
  0x0000, /* U+8651 */
  0x0000, /* U+8652 */
  0x0000, /* U+8653 */
  0xe569, /* U+8654 */
  0x997c, /* U+8655 */
  0x0000, /* U+8656 */
  0x0000, /* U+8657 */
  0x0000, /* U+8658 */
  0x0000, /* U+8659 */
  0x8b95, /* U+865a */
  0x0000, /* U+865b */
  0x97b8, /* U+865c */
  0x0000, /* U+865d */
  0x8bf1, /* U+865e */
  0xe56a, /* U+865f */
  0x0000, /* U+8660 */
  0x0000, /* U+8661 */
  0x0000, /* U+8662 */
  0x0000, /* U+8663 */
  0x0000, /* U+8664 */
  0x0000, /* U+8665 */
  0x0000, /* U+8666 */
  0xe56b, /* U+8667 */
  0x0000, /* U+8668 */
  0x0000, /* U+8669 */
  0x0000, /* U+866a */
  0x928e, /* U+866b */
  0x0000, /* U+866c */
  0x0000, /* U+866d */
  0x0000, /* U+866e */
  0x0000, /* U+866f */
  0x0000, /* U+8670 */
  0xe56c, /* U+8671 */
  0x0000, /* U+8672 */
  0x0000, /* U+8673 */
  0x0000, /* U+8674 */
  0x0000, /* U+8675 */
  0x0000, /* U+8676 */
  0x0000, /* U+8677 */
  0x0000, /* U+8678 */
  0x93f8, /* U+8679 */
  0x0000, /* U+867a */
  0x88b8, /* U+867b */
  0x0000, /* U+867c */
  0x0000, /* U+867d */
  0x0000, /* U+867e */
  0x0000, /* U+867f */
  0x0000, /* U+8680 */
  0x0000, /* U+8681 */
  0x0000, /* U+8682 */
  0x0000, /* U+8683 */
  0x0000, /* U+8684 */
  0x0000, /* U+8685 */
  0x0000, /* U+8686 */
  0x0000, /* U+8687 */
  0x0000, /* U+8688 */
  0x0000, /* U+8689 */
  0x89e1, /* U+868a */
  0xe571, /* U+868b */
  0xe572, /* U+868c */
  0x0000, /* U+868d */
  0x0000, /* U+868e */
  0x0000, /* U+868f */
  0x0000, /* U+8690 */
  0x0000, /* U+8691 */
  0x0000, /* U+8692 */
  0xe56d, /* U+8693 */
  0x0000, /* U+8694 */
  0x8e5c, /* U+8695 */
  0x0000, /* U+8696 */
  0x0000, /* U+8697 */
  0x0000, /* U+8698 */
  0x0000, /* U+8699 */
  0x0000, /* U+869a */
  0x0000, /* U+869b */
  0x0000, /* U+869c */
  0x0000, /* U+869d */
  0x0000, /* U+869e */
  0x0000, /* U+869f */
  0x0000, /* U+86a0 */
  0x0000, /* U+86a1 */
  0x0000, /* U+86a2 */
  0xe56e, /* U+86a3 */
  0x9461, /* U+86a4 */
  0x0000, /* U+86a5 */
  0x0000, /* U+86a6 */
  0x0000, /* U+86a7 */
  0x0000, /* U+86a8 */
  0xe56f, /* U+86a9 */
  0xe570, /* U+86aa */
  0xe57a, /* U+86ab */
  0x0000, /* U+86ac */
  0x0000, /* U+86ad */
  0x0000, /* U+86ae */
  0xe574, /* U+86af */
  0xe577, /* U+86b0 */
  0x0000, /* U+86b1 */
  0x0000, /* U+86b2 */
  0x0000, /* U+86b3 */
  0x0000, /* U+86b4 */
  0x0000, /* U+86b5 */
  0xe573, /* U+86b6 */
  0x0000, /* U+86b7 */
  0x0000, /* U+86b8 */
  0x0000, /* U+86b9 */
  0x0000, /* U+86ba */
  0x0000, /* U+86bb */
  0x0000, /* U+86bc */
  0x0000, /* U+86bd */
  0x0000, /* U+86be */
  0x0000, /* U+86bf */
  0x0000, /* U+86c0 */
  0x0000, /* U+86c1 */
  0x0000, /* U+86c2 */
  0x0000, /* U+86c3 */
  0xe575, /* U+86c4 */
  0x0000, /* U+86c5 */
  0xe576, /* U+86c6 */
  0x8ed6, /* U+86c7 */
  0x0000, /* U+86c8 */
  0xe578, /* U+86c9 */
  0x0000, /* U+86ca */
  0x9260, /* U+86cb */
  0x0000, /* U+86cc */
  0x8c75, /* U+86cd */
  0x8a61, /* U+86ce */
  0x0000, /* U+86cf */
  0x0000, /* U+86d0 */
  0x0000, /* U+86d1 */
  0x0000, /* U+86d2 */
  0x0000, /* U+86d3 */
  0xe57b, /* U+86d4 */
  0x0000, /* U+86d5 */
  0x0000, /* U+86d6 */
  0x0000, /* U+86d7 */
  0x0000, /* U+86d8 */
  0x8a5e, /* U+86d9 */
  0x0000, /* U+86da */
  0xe581, /* U+86db */
  0x0000, /* U+86dc */
  0x0000, /* U+86dd */
  0xe57c, /* U+86de */
  0xe580, /* U+86df */
  0x0000, /* U+86e0 */
  0x0000, /* U+86e1 */
  0x0000, /* U+86e2 */
  0x0000, /* U+86e3 */
  0x94b8, /* U+86e4 */
  0x0000, /* U+86e5 */
  0x0000, /* U+86e6 */
  0x0000, /* U+86e7 */
  0x0000, /* U+86e8 */
  0xe57d, /* U+86e9 */
  0x0000, /* U+86ea */
  0x0000, /* U+86eb */
  0xe57e, /* U+86ec */
  0x9567, /* U+86ed */
  0x94d8, /* U+86ee */
  0xe582, /* U+86ef */
  0x0000, /* U+86f0 */
  0x0000, /* U+86f1 */
  0x0000, /* U+86f2 */
  0x0000, /* U+86f3 */
  0x0000, /* U+86f4 */
  0x0000, /* U+86f5 */
  0x0000, /* U+86f6 */
  0x0000, /* U+86f7 */
  0x91fb, /* U+86f8 */
  0xe58c, /* U+86f9 */
  0x0000, /* U+86fa */
  0xe588, /* U+86fb */
  0x0000, /* U+86fc */
  0x0000, /* U+86fd */
  0x89e9, /* U+86fe */
  0x0000, /* U+86ff */
  0xe586, /* U+8700 */
  0x0000, /* U+8701 */
  0x9649, /* U+8702 */
  0xe587, /* U+8703 */
  0x0000, /* U+8704 */
  0x0000, /* U+8705 */
  0xe584, /* U+8706 */
  0x0000, /* U+8707 */
  0xe585, /* U+8708 */
  0xe58a, /* U+8709 */
  0xe58d, /* U+870a */
  0x0000, /* U+870b */
  0x0000, /* U+870c */
  0xe58b, /* U+870d */
  0x0000, /* U+870e */
  0x0000, /* U+870f */
  0x0000, /* U+8710 */
  0xe589, /* U+8711 */
  0xe583, /* U+8712 */
  0x0000, /* U+8713 */
  0x0000, /* U+8714 */
  0x0000, /* U+8715 */
  0x0000, /* U+8716 */
  0x0000, /* U+8717 */
  0x9277, /* U+8718 */
  0x0000, /* U+8719 */
  0xe594, /* U+871a */
  0x0000, /* U+871b */
  0x96a8, /* U+871c */
  0x0000, /* U+871d */
  0x0000, /* U+871e */
  0x0000, /* U+871f */
  0x0000, /* U+8720 */
  0x0000, /* U+8721 */
  0x0000, /* U+8722 */
  0x0000, /* U+8723 */
  0x0000, /* U+8724 */
  0xe592, /* U+8725 */
  0x0000, /* U+8726 */
  0x0000, /* U+8727 */
  0x0000, /* U+8728 */
  0xe593, /* U+8729 */
  0x0000, /* U+872a */
  0x0000, /* U+872b */
  0x0000, /* U+872c */
  0x0000, /* U+872d */
  0x0000, /* U+872e */
  0x0000, /* U+872f */
  0x0000, /* U+8730 */
  0x0000, /* U+8731 */
  0x0000, /* U+8732 */
  0x0000, /* U+8733 */
  0xe58e, /* U+8734 */
  0x0000, /* U+8735 */
  0x0000, /* U+8736 */
  0xe590, /* U+8737 */
  0x0000, /* U+8738 */
  0x0000, /* U+8739 */
  0x0000, /* U+873a */
  0xe591, /* U+873b */
  0x0000, /* U+873c */
  0x0000, /* U+873d */
  0x0000, /* U+873e */
  0xe58f, /* U+873f */
  0x0000, /* U+8740 */
  0x0000, /* U+8741 */
  0x0000, /* U+8742 */
  0x0000, /* U+8743 */
  0x0000, /* U+8744 */
  0x0000, /* U+8745 */
  0x0000, /* U+8746 */
  0x0000, /* U+8747 */
  0x0000, /* U+8748 */
  0x90e4, /* U+8749 */
  0x0000, /* U+874a */
  0x9858, /* U+874b */
  0xe598, /* U+874c */
  0x0000, /* U+874d */
  0xe599, /* U+874e */
  0x0000, /* U+874f */
  0x0000, /* U+8750 */
  0x0000, /* U+8751 */
  0x0000, /* U+8752 */
  0xe59f, /* U+8753 */
  0x0000, /* U+8754 */
  0x9049, /* U+8755 */
  0x0000, /* U+8756 */
  0xe59b, /* U+8757 */
  0x0000, /* U+8758 */
  0xe59e, /* U+8759 */
  0x0000, /* U+875a */
  0x0000, /* U+875b */
  0x0000, /* U+875c */
  0x0000, /* U+875d */
  0x0000, /* U+875e */
  0xe596, /* U+875f */
  0xe595, /* U+8760 */
  0x0000, /* U+8761 */
  0x0000, /* U+8762 */
  0xe5a0, /* U+8763 */
  0x0000, /* U+8764 */
  0x0000, /* U+8765 */
  0x89da, /* U+8766 */
  0x0000, /* U+8767 */
  0xe59c, /* U+8768 */
  0x0000, /* U+8769 */
  0xe5a1, /* U+876a */
  0x0000, /* U+876b */
  0x0000, /* U+876c */
  0x0000, /* U+876d */
  0xe59d, /* U+876e */
  0x0000, /* U+876f */
  0x0000, /* U+8770 */
  0x0000, /* U+8771 */
  0x0000, /* U+8772 */
  0x0000, /* U+8773 */
  0xe59a, /* U+8774 */
  0x0000, /* U+8775 */
  0x92b1, /* U+8776 */
  0x0000, /* U+8777 */
  0xe597, /* U+8778 */
  0x0000, /* U+8779 */
  0x0000, /* U+877a */
  0x0000, /* U+877b */
  0x0000, /* U+877c */
  0x0000, /* U+877d */
  0x0000, /* U+877e */
  0x9488, /* U+877f */
  0x0000, /* U+8780 */
  0x0000, /* U+8781 */
  0xe5a5, /* U+8782 */
  0x0000, /* U+8783 */
  0x0000, /* U+8784 */
  0x0000, /* U+8785 */
  0x0000, /* U+8786 */
  0x0000, /* U+8787 */
  0x0000, /* U+8788 */
  0x0000, /* U+8789 */
  0x0000, /* U+878a */
  0x0000, /* U+878b */
  0x0000, /* U+878c */
  0x975a, /* U+878d */
  0x0000, /* U+878e */
  0x0000, /* U+878f */
  0x0000, /* U+8790 */
  0x0000, /* U+8791 */
  0x0000, /* U+8792 */
  0x0000, /* U+8793 */
  0x0000, /* U+8794 */
  0x0000, /* U+8795 */
  0x0000, /* U+8796 */
  0x0000, /* U+8797 */
  0x0000, /* U+8798 */
  0x0000, /* U+8799 */
  0x0000, /* U+879a */
  0x0000, /* U+879b */
  0x0000, /* U+879c */
  0x0000, /* U+879d */
  0x0000, /* U+879e */
  0xe5a4, /* U+879f */
  0x0000, /* U+87a0 */
  0x0000, /* U+87a1 */
  0xe5a3, /* U+87a2 */
  0x0000, /* U+87a3 */
  0x0000, /* U+87a4 */
  0x0000, /* U+87a5 */
  0x0000, /* U+87a6 */
  0x0000, /* U+87a7 */
  0x0000, /* U+87a8 */
  0x0000, /* U+87a9 */
  0x0000, /* U+87aa */
  0xe5ac, /* U+87ab */
  0x0000, /* U+87ac */
  0x0000, /* U+87ad */
  0x0000, /* U+87ae */
  0xe5a6, /* U+87af */
  0x0000, /* U+87b0 */
  0x0000, /* U+87b1 */
  0x0000, /* U+87b2 */
  0xe5ae, /* U+87b3 */
  0x0000, /* U+87b4 */
  0x0000, /* U+87b5 */
  0x0000, /* U+87b6 */
  0x0000, /* U+87b7 */
  0x0000, /* U+87b8 */
  0x0000, /* U+87b9 */
  0x9786, /* U+87ba */
  0xe5b1, /* U+87bb */
  0x0000, /* U+87bc */
  0xe5a8, /* U+87bd */
  0x0000, /* U+87be */
  0x0000, /* U+87bf */
  0xe5a9, /* U+87c0 */
  0x0000, /* U+87c1 */
  0x0000, /* U+87c2 */
  0x0000, /* U+87c3 */
  0xe5ad, /* U+87c4 */
  0x0000, /* U+87c5 */
  0xe5b0, /* U+87c6 */
  0xe5af, /* U+87c7 */
  0x0000, /* U+87c8 */
  0x0000, /* U+87c9 */
  0x0000, /* U+87ca */
  0xe5a7, /* U+87cb */
  0x0000, /* U+87cc */
  0x0000, /* U+87cd */
  0x0000, /* U+87ce */
  0x0000, /* U+87cf */
  0xe5aa, /* U+87d0 */
  0x0000, /* U+87d1 */
  0xe5bb, /* U+87d2 */
  0x0000, /* U+87d3 */
  0x0000, /* U+87d4 */
  0x0000, /* U+87d5 */
  0x0000, /* U+87d6 */
  0x0000, /* U+87d7 */
  0x0000, /* U+87d8 */
  0x0000, /* U+87d9 */
  0x0000, /* U+87da */
  0x0000, /* U+87db */
  0x0000, /* U+87dc */
  0x0000, /* U+87dd */
  0x0000, /* U+87de */
  0x0000, /* U+87df */
  0xe5b4, /* U+87e0 */
  0x0000, /* U+87e1 */
  0x0000, /* U+87e2 */
  0x0000, /* U+87e3 */
  0x0000, /* U+87e4 */
  0x0000, /* U+87e5 */
  0x0000, /* U+87e6 */
  0x0000, /* U+87e7 */
  0x0000, /* U+87e8 */
  0x0000, /* U+87e9 */
  0x0000, /* U+87ea */
  0x0000, /* U+87eb */
  0x0000, /* U+87ec */
  0x0000, /* U+87ed */
  0x0000, /* U+87ee */
  0xe5b2, /* U+87ef */
  0x0000, /* U+87f0 */
  0x0000, /* U+87f1 */
  0xe5b3, /* U+87f2 */
  0x0000, /* U+87f3 */
  0x0000, /* U+87f4 */
  0x0000, /* U+87f5 */
  0xe5b8, /* U+87f6 */
  0xe5b9, /* U+87f7 */
  0x0000, /* U+87f8 */
  0x8a49, /* U+87f9 */
  0x0000, /* U+87fa */
  0x8b61, /* U+87fb */
  0x0000, /* U+87fc */
  0x0000, /* U+87fd */
  0xe5b7, /* U+87fe */
  0x0000, /* U+87ff */
  0x0000, /* U+8800 */
  0x0000, /* U+8801 */
  0x0000, /* U+8802 */
  0x0000, /* U+8803 */
  0x0000, /* U+8804 */
  0xe5a2, /* U+8805 */
  0x0000, /* U+8806 */
  0xfba1, /* U+8807 */
  0x0000, /* U+8808 */
  0x0000, /* U+8809 */
  0x0000, /* U+880a */
  0x0000, /* U+880b */
  0x0000, /* U+880c */
  0xe5b6, /* U+880d */
  0xe5ba, /* U+880e */
  0xe5b5, /* U+880f */
  0x0000, /* U+8810 */
  0xe5bc, /* U+8811 */
  0x0000, /* U+8812 */
  0x0000, /* U+8813 */
  0x0000, /* U+8814 */
  0xe5be, /* U+8815 */
  0xe5bd, /* U+8816 */
  0x0000, /* U+8817 */
  0x0000, /* U+8818 */
  0x0000, /* U+8819 */
  0x0000, /* U+881a */
  0x0000, /* U+881b */
  0x0000, /* U+881c */
  0x0000, /* U+881d */
  0x0000, /* U+881e */
  0x0000, /* U+881f */
  0x0000, /* U+8820 */
  0xe5c0, /* U+8821 */
  0xe5bf, /* U+8822 */
  0xe579, /* U+8823 */
  0x0000, /* U+8824 */
  0x0000, /* U+8825 */
  0x0000, /* U+8826 */
  0xe5c4, /* U+8827 */
  0x0000, /* U+8828 */
  0x0000, /* U+8829 */
  0x0000, /* U+882a */
  0x0000, /* U+882b */
  0x0000, /* U+882c */
  0x0000, /* U+882d */
  0x0000, /* U+882e */
  0x0000, /* U+882f */
  0x0000, /* U+8830 */
  0xe5c1, /* U+8831 */
  0x0000, /* U+8832 */
  0x0000, /* U+8833 */
  0x0000, /* U+8834 */
  0x0000, /* U+8835 */
  0xe5c2, /* U+8836 */
  0x0000, /* U+8837 */
  0x0000, /* U+8838 */
  0xe5c3, /* U+8839 */
  0x0000, /* U+883a */
  0xe5c5, /* U+883b */
  0x0000, /* U+883c */
  0x0000, /* U+883d */
  0x0000, /* U+883e */
  0x0000, /* U+883f */
  0x8c8c, /* U+8840 */
  0x0000, /* U+8841 */
  0xe5c7, /* U+8842 */
  0x0000, /* U+8843 */
  0xe5c6, /* U+8844 */
  0x0000, /* U+8845 */
  0x8f4f, /* U+8846 */
  0x0000, /* U+8847 */
  0x0000, /* U+8848 */
  0x0000, /* U+8849 */
  0x0000, /* U+884a */
  0x0000, /* U+884b */
  0x8d73, /* U+884c */
  0x9fa5, /* U+884d */
  0x0000, /* U+884e */
  0x0000, /* U+884f */
  0x0000, /* U+8850 */
  0x0000, /* U+8851 */
  0xe5c8, /* U+8852 */
  0x8f70, /* U+8853 */
  0x0000, /* U+8854 */
  0x0000, /* U+8855 */
  0x0000, /* U+8856 */
  0x8a58, /* U+8857 */
  0x0000, /* U+8858 */
  0xe5c9, /* U+8859 */
  0x0000, /* U+885a */
  0x8971, /* U+885b */
  0x0000, /* U+885c */
  0x8fd5, /* U+885d */
  0xe5ca, /* U+885e */
  0x0000, /* U+885f */
  0x0000, /* U+8860 */
  0x8d74, /* U+8861 */
  0xe5cb, /* U+8862 */
  0x88df, /* U+8863 */
  0x0000, /* U+8864 */
  0x0000, /* U+8865 */
  0x0000, /* U+8866 */
  0x0000, /* U+8867 */
  0x955c, /* U+8868 */
  0x0000, /* U+8869 */
  0x0000, /* U+886a */
  0xe5cc, /* U+886b */
  0x0000, /* U+886c */
  0x0000, /* U+886d */
  0x0000, /* U+886e */
  0x0000, /* U+886f */
  0x908a, /* U+8870 */
  0x0000, /* U+8871 */
  0xe5d3, /* U+8872 */
  0x0000, /* U+8873 */
  0x0000, /* U+8874 */
  0xe5d0, /* U+8875 */
  0x0000, /* U+8876 */
  0x928f, /* U+8877 */
  0x0000, /* U+8878 */
  0x0000, /* U+8879 */
  0x0000, /* U+887a */
  0x0000, /* U+887b */
  0x0000, /* U+887c */
  0xe5d1, /* U+887d */
  0xe5ce, /* U+887e */
  0x8bdc, /* U+887f */
  0x0000, /* U+8880 */
  0xe5cd, /* U+8881 */
  0xe5d4, /* U+8882 */
  0x0000, /* U+8883 */
  0x0000, /* U+8884 */
  0x0000, /* U+8885 */
  0x0000, /* U+8886 */
  0x0000, /* U+8887 */
  0x8c55, /* U+8888 */
  0x0000, /* U+8889 */
  0x0000, /* U+888a */
  0x91dc, /* U+888b */
  0x0000, /* U+888c */
  0xe5da, /* U+888d */
  0x0000, /* U+888e */
  0x0000, /* U+888f */
  0x0000, /* U+8890 */
  0x0000, /* U+8891 */
  0xe5d6, /* U+8892 */
  0x0000, /* U+8893 */
  0x0000, /* U+8894 */
  0x0000, /* U+8895 */
  0x91b3, /* U+8896 */
  0xe5d5, /* U+8897 */
  0x0000, /* U+8898 */
  0xe5d8, /* U+8899 */
  0x0000, /* U+889a */
  0x0000, /* U+889b */
  0x0000, /* U+889c */
  0x0000, /* U+889d */
  0xe5cf, /* U+889e */
  0x0000, /* U+889f */
  0x0000, /* U+88a0 */
  0x0000, /* U+88a1 */
  0xe5d9, /* U+88a2 */
  0x0000, /* U+88a3 */
  0xe5db, /* U+88a4 */
  0x0000, /* U+88a5 */
  0x0000, /* U+88a6 */
  0x0000, /* U+88a7 */
  0x0000, /* U+88a8 */
  0x0000, /* U+88a9 */
  0x0000, /* U+88aa */
  0x94ed, /* U+88ab */
  0x0000, /* U+88ac */
  0x0000, /* U+88ad */
  0xe5d7, /* U+88ae */
  0x0000, /* U+88af */
  0xe5dc, /* U+88b0 */
  0xe5de, /* U+88b1 */
  0x0000, /* U+88b2 */
  0x0000, /* U+88b3 */
  0x8cd1, /* U+88b4 */
  0xe5d2, /* U+88b5 */
  0x0000, /* U+88b6 */
  0x88bf, /* U+88b7 */
  0x0000, /* U+88b8 */
  0x0000, /* U+88b9 */
  0x0000, /* U+88ba */
  0x0000, /* U+88bb */
  0x0000, /* U+88bc */
  0x0000, /* U+88bd */
  0x0000, /* U+88be */
  0xe5dd, /* U+88bf */
  0x0000, /* U+88c0 */
  0x8dd9, /* U+88c1 */
  0x97f4, /* U+88c2 */
  0xe5df, /* U+88c3 */
  0xe5e0, /* U+88c4 */
  0x9195, /* U+88c5 */
  0x0000, /* U+88c6 */
  0x0000, /* U+88c7 */
  0x0000, /* U+88c8 */
  0x0000, /* U+88c9 */
  0x0000, /* U+88ca */
  0x0000, /* U+88cb */
  0x0000, /* U+88cc */
  0x0000, /* U+88cd */
  0x0000, /* U+88ce */
  0x97a0, /* U+88cf */
  0x0000, /* U+88d0 */
  0x0000, /* U+88d1 */
  0x0000, /* U+88d2 */
  0x0000, /* U+88d3 */
  0xe5e1, /* U+88d4 */
  0x9754, /* U+88d5 */
  0x0000, /* U+88d6 */
  0x0000, /* U+88d7 */
  0xe5e2, /* U+88d8 */
  0xe5e3, /* U+88d9 */
  0x0000, /* U+88da */
  0x0000, /* U+88db */
  0x95e2, /* U+88dc */
  0xe5e4, /* U+88dd */
  0x0000, /* U+88de */
  0x8dbe, /* U+88df */
  0x0000, /* U+88e0 */
  0x97a1, /* U+88e1 */
  0x0000, /* U+88e2 */
  0x0000, /* U+88e3 */
  0x0000, /* U+88e4 */
  0x0000, /* U+88e5 */
  0x0000, /* U+88e6 */
  0x0000, /* U+88e7 */
  0xe5e9, /* U+88e8 */
  0x0000, /* U+88e9 */
  0x0000, /* U+88ea */
  0x0000, /* U+88eb */
  0x0000, /* U+88ec */
  0x0000, /* U+88ed */
  0x0000, /* U+88ee */
  0x0000, /* U+88ef */
  0x0000, /* U+88f0 */
  0x0000, /* U+88f1 */
  0xe5ea, /* U+88f2 */
  0x8fd6, /* U+88f3 */
  0xe5e8, /* U+88f4 */
  0xfba2, /* U+88f5 */
  0x0000, /* U+88f6 */
  0x0000, /* U+88f7 */
  0x9787, /* U+88f8 */
  0xe5e5, /* U+88f9 */
  0x0000, /* U+88fa */
  0x0000, /* U+88fb */
  0xe5e7, /* U+88fc */
  0x90bb, /* U+88fd */
  0x909e, /* U+88fe */
  0x0000, /* U+88ff */
  0x0000, /* U+8900 */
  0x0000, /* U+8901 */
  0xe5e6, /* U+8902 */
  0x0000, /* U+8903 */
  0xe5eb, /* U+8904 */
  0x0000, /* U+8905 */
  0x0000, /* U+8906 */
  0x95a1, /* U+8907 */
  0x0000, /* U+8908 */
  0x0000, /* U+8909 */
  0xe5ed, /* U+890a */
  0x0000, /* U+890b */
  0xe5ec, /* U+890c */
  0x0000, /* U+890d */
  0x0000, /* U+890e */
  0x0000, /* U+890f */
  0x8a8c, /* U+8910 */
  0x0000, /* U+8911 */
  0x964a, /* U+8912 */
  0xe5ee, /* U+8913 */
  0x0000, /* U+8914 */
  0x0000, /* U+8915 */
  0x0000, /* U+8916 */
  0x0000, /* U+8917 */
  0x0000, /* U+8918 */
  0x0000, /* U+8919 */
  0x0000, /* U+891a */
  0x0000, /* U+891b */
  0xfa5d, /* U+891c */
  0xe5fa, /* U+891d */
  0xe5f0, /* U+891e */
  0x0000, /* U+891f */
  0x0000, /* U+8920 */
  0x0000, /* U+8921 */
  0x0000, /* U+8922 */
  0x0000, /* U+8923 */
  0x0000, /* U+8924 */
  0xe5f1, /* U+8925 */
  0x0000, /* U+8926 */
  0x0000, /* U+8927 */
  0x0000, /* U+8928 */
  0x0000, /* U+8929 */
  0xe5f2, /* U+892a */
  0xe5f3, /* U+892b */
  0x0000, /* U+892c */
  0x0000, /* U+892d */
  0x0000, /* U+892e */
  0x0000, /* U+892f */
  0x0000, /* U+8930 */
  0x0000, /* U+8931 */
  0x0000, /* U+8932 */
  0x0000, /* U+8933 */
  0x0000, /* U+8934 */
  0x0000, /* U+8935 */
  0xe5f7, /* U+8936 */
  0x0000, /* U+8937 */
  0xe5f8, /* U+8938 */
  0x0000, /* U+8939 */
  0x0000, /* U+893a */
  0xe5f6, /* U+893b */
  0x0000, /* U+893c */
  0x0000, /* U+893d */
  0x0000, /* U+893e */
  0x0000, /* U+893f */
  0x0000, /* U+8940 */
  0xe5f4, /* U+8941 */
  0x0000, /* U+8942 */
  0xe5ef, /* U+8943 */
  0xe5f5, /* U+8944 */
  0x0000, /* U+8945 */
  0x0000, /* U+8946 */
  0x0000, /* U+8947 */
  0x0000, /* U+8948 */
  0x0000, /* U+8949 */
  0x0000, /* U+894a */
  0x0000, /* U+894b */
  0xe5f9, /* U+894c */
  0xe8b5, /* U+894d */
  0x0000, /* U+894e */
  0x0000, /* U+894f */
  0x0000, /* U+8950 */
  0x0000, /* U+8951 */
  0x0000, /* U+8952 */
  0x0000, /* U+8953 */
  0x0000, /* U+8954 */
  0x0000, /* U+8955 */
  0x89a6, /* U+8956 */
  0x0000, /* U+8957 */
  0x0000, /* U+8958 */
  0x0000, /* U+8959 */
  0x0000, /* U+895a */
  0x0000, /* U+895b */
  0x0000, /* U+895c */
  0x0000, /* U+895d */
  0xe5fc, /* U+895e */
  0x8bdd, /* U+895f */
  0xe5fb, /* U+8960 */
  0x0000, /* U+8961 */
  0x0000, /* U+8962 */
  0x0000, /* U+8963 */
  0xe641, /* U+8964 */
  0x0000, /* U+8965 */
  0xe640, /* U+8966 */
  0x0000, /* U+8967 */
  0x0000, /* U+8968 */
  0x0000, /* U+8969 */
  0xe643, /* U+896a */
  0x0000, /* U+896b */
  0x0000, /* U+896c */
  0xe642, /* U+896d */
  0x0000, /* U+896e */
  0xe644, /* U+896f */
  0x0000, /* U+8970 */
  0x0000, /* U+8971 */
  0x8f50, /* U+8972 */
  0x0000, /* U+8973 */
  0xe645, /* U+8974 */
  0x0000, /* U+8975 */
  0x0000, /* U+8976 */
  0xe646, /* U+8977 */
  0x0000, /* U+8978 */
  0x0000, /* U+8979 */
  0x0000, /* U+897a */
  0x0000, /* U+897b */
  0x0000, /* U+897c */
  0x0000, /* U+897d */
  0xe647, /* U+897e */
  0x90bc, /* U+897f */
  0x0000, /* U+8980 */
  0x9776, /* U+8981 */
  0x0000, /* U+8982 */
  0xe648, /* U+8983 */
  0x0000, /* U+8984 */
  0x0000, /* U+8985 */
  0x95a2, /* U+8986 */
  0x9465, /* U+8987 */
  0xe649, /* U+8988 */
  0x0000, /* U+8989 */
  0xe64a, /* U+898a */
  0x8ca9, /* U+898b */
  0x0000, /* U+898c */
  0x0000, /* U+898d */
  0x0000, /* U+898e */
  0x8b4b, /* U+898f */
  0x0000, /* U+8990 */
  0x0000, /* U+8991 */
  0x0000, /* U+8992 */
  0xe64b, /* U+8993 */
  0x0000, /* U+8994 */
  0x0000, /* U+8995 */
  0x8e8b, /* U+8996 */
  0x9460, /* U+8997 */
  0xe64c, /* U+8998 */
  0x0000, /* U+8999 */
  0x8a6f, /* U+899a */
  0x0000, /* U+899b */
  0x0000, /* U+899c */
  0x0000, /* U+899d */
  0x0000, /* U+899e */
  0x0000, /* U+899f */
  0x0000, /* U+89a0 */
  0xe64d, /* U+89a1 */
  0x0000, /* U+89a2 */
  0x0000, /* U+89a3 */
  0x0000, /* U+89a4 */
  0x0000, /* U+89a5 */
  0xe64f, /* U+89a6 */
  0x9797, /* U+89a7 */
  0x0000, /* U+89a8 */
  0xe64e, /* U+89a9 */
  0x9065, /* U+89aa */
  0x0000, /* U+89ab */
  0xe650, /* U+89ac */
  0x0000, /* U+89ad */
  0x0000, /* U+89ae */
  0xe651, /* U+89af */
  0x0000, /* U+89b0 */
  0x0000, /* U+89b1 */
  0xe652, /* U+89b2 */
  0x8acf, /* U+89b3 */
  0x0000, /* U+89b4 */
  0x0000, /* U+89b5 */
  0x0000, /* U+89b6 */
  0x0000, /* U+89b7 */
  0x0000, /* U+89b8 */
  0x0000, /* U+89b9 */
  0xe653, /* U+89ba */
  0x0000, /* U+89bb */
  0x0000, /* U+89bc */
  0xe654, /* U+89bd */
  0x0000, /* U+89be */
  0xe655, /* U+89bf */
  0xe656, /* U+89c0 */
  0x0000, /* U+89c1 */
  0x0000, /* U+89c2 */
  0x0000, /* U+89c3 */
  0x0000, /* U+89c4 */
  0x0000, /* U+89c5 */
  0x0000, /* U+89c6 */
  0x0000, /* U+89c7 */
  0x0000, /* U+89c8 */
  0x0000, /* U+89c9 */
  0x0000, /* U+89ca */
  0x0000, /* U+89cb */
  0x0000, /* U+89cc */
  0x0000, /* U+89cd */
  0x0000, /* U+89ce */
  0x0000, /* U+89cf */
  0x0000, /* U+89d0 */
  0x0000, /* U+89d1 */
  0x8a70, /* U+89d2 */
  0x0000, /* U+89d3 */
  0x0000, /* U+89d4 */
  0x0000, /* U+89d5 */
  0x0000, /* U+89d6 */
  0x0000, /* U+89d7 */
  0x0000, /* U+89d8 */
  0x0000, /* U+89d9 */
  0xe657, /* U+89da */
  0x0000, /* U+89db */
  0xe658, /* U+89dc */
  0xe659, /* U+89dd */
  0x0000, /* U+89de */
  0x0000, /* U+89df */
  0x0000, /* U+89e0 */
  0x0000, /* U+89e1 */
  0x0000, /* U+89e2 */
  0x89f0, /* U+89e3 */
  0x0000, /* U+89e4 */
  0x0000, /* U+89e5 */
  0x9047, /* U+89e6 */
  0xe65a, /* U+89e7 */
  0x0000, /* U+89e8 */
  0x0000, /* U+89e9 */
  0x0000, /* U+89ea */
  0x0000, /* U+89eb */
  0x0000, /* U+89ec */
  0x0000, /* U+89ed */
  0x0000, /* U+89ee */
  0x0000, /* U+89ef */
  0x0000, /* U+89f0 */
  0x0000, /* U+89f1 */
  0x0000, /* U+89f2 */
  0x0000, /* U+89f3 */
  0xe65b, /* U+89f4 */
  0x0000, /* U+89f5 */
  0x0000, /* U+89f6 */
  0x0000, /* U+89f7 */
  0xe65c, /* U+89f8 */
  0x0000, /* U+89f9 */
  0x0000, /* U+89fa */
  0x0000, /* U+89fb */
  0x0000, /* U+89fc */
  0x0000, /* U+89fd */
  0x0000, /* U+89fe */
  0x0000, /* U+89ff */
  0x8cbe, /* U+8a00 */
  0x0000, /* U+8a01 */
  0x92f9, /* U+8a02 */
  0xe65d, /* U+8a03 */
  0x0000, /* U+8a04 */
  0x0000, /* U+8a05 */
  0x0000, /* U+8a06 */
  0x0000, /* U+8a07 */
  0x8c76, /* U+8a08 */
  0x0000, /* U+8a09 */
  0x9075, /* U+8a0a */
  0x0000, /* U+8a0b */
  0xe660, /* U+8a0c */
  0x0000, /* U+8a0d */
  0x93a2, /* U+8a0e */
  0x0000, /* U+8a0f */
  0xe65f, /* U+8a10 */
  0x0000, /* U+8a11 */
  0xfba3, /* U+8a12 */
  0x8c50, /* U+8a13 */
  0x0000, /* U+8a14 */
  0x0000, /* U+8a15 */
  0xe65e, /* U+8a16 */
  0x91f5, /* U+8a17 */
  0x8b4c, /* U+8a18 */
  0x0000, /* U+8a19 */
  0x0000, /* U+8a1a */
  0xe661, /* U+8a1b */
  0x0000, /* U+8a1c */
  0xe662, /* U+8a1d */
  0x0000, /* U+8a1e */
  0x8fd7, /* U+8a1f */
  0x0000, /* U+8a20 */
  0x0000, /* U+8a21 */
  0x0000, /* U+8a22 */
  0x8c8d, /* U+8a23 */
  0x0000, /* U+8a24 */
  0xe663, /* U+8a25 */
  0x0000, /* U+8a26 */
  0x0000, /* U+8a27 */
  0x0000, /* U+8a28 */
  0x0000, /* U+8a29 */
  0x964b, /* U+8a2a */
  0x0000, /* U+8a2b */
  0x0000, /* U+8a2c */
  0x90dd, /* U+8a2d */
  0x0000, /* U+8a2e */
  0x0000, /* U+8a2f */
  0x0000, /* U+8a30 */
  0x8b96, /* U+8a31 */
  0x0000, /* U+8a32 */
  0x96f3, /* U+8a33 */
  0x9169, /* U+8a34 */
  0x0000, /* U+8a35 */
  0xe664, /* U+8a36 */
  0xfba4, /* U+8a37 */
  0x0000, /* U+8a38 */
  0x0000, /* U+8a39 */
  0x9066, /* U+8a3a */
  0x9290, /* U+8a3b */
  0x8fd8, /* U+8a3c */
  0x0000, /* U+8a3d */
  0x0000, /* U+8a3e */
  0x0000, /* U+8a3f */
  0x0000, /* U+8a40 */
  0xe665, /* U+8a41 */
  0x0000, /* U+8a42 */
  0x0000, /* U+8a43 */
  0x0000, /* U+8a44 */
  0x0000, /* U+8a45 */
  0xe668, /* U+8a46 */
  0x0000, /* U+8a47 */
  0xe669, /* U+8a48 */
  0x0000, /* U+8a49 */
  0x0000, /* U+8a4a */
  0x0000, /* U+8a4b */
  0x0000, /* U+8a4c */
  0x0000, /* U+8a4d */
  0x0000, /* U+8a4e */
  0x0000, /* U+8a4f */
  0x8dbc, /* U+8a50 */
  0x91c0, /* U+8a51 */
  0xe667, /* U+8a52 */
  0x0000, /* U+8a53 */
  0x8fd9, /* U+8a54 */
  0x955d, /* U+8a55 */
  0x0000, /* U+8a56 */
  0x0000, /* U+8a57 */
  0x0000, /* U+8a58 */
  0x0000, /* U+8a59 */
  0x0000, /* U+8a5a */
  0xe666, /* U+8a5b */
  0x0000, /* U+8a5c */
  0x0000, /* U+8a5d */
  0x8e8c, /* U+8a5e */
  0x0000, /* U+8a5f */
  0x8972, /* U+8a60 */
  0x0000, /* U+8a61 */
  0xe66d, /* U+8a62 */
  0x8c77, /* U+8a63 */
  0x0000, /* U+8a64 */
  0x0000, /* U+8a65 */
  0x8e8e, /* U+8a66 */
  0x0000, /* U+8a67 */
  0x0000, /* U+8a68 */
  0x8e8d, /* U+8a69 */
  0x0000, /* U+8a6a */
  0x986c, /* U+8a6b */
  0xe66c, /* U+8a6c */
  0xe66b, /* U+8a6d */
  0x9146, /* U+8a6e */
  0x0000, /* U+8a6f */
  0x8b6c, /* U+8a70 */
  0x9862, /* U+8a71 */
  0x8a59, /* U+8a72 */
  0x8fda, /* U+8a73 */
  0x0000, /* U+8a74 */
  0x0000, /* U+8a75 */
  0x0000, /* U+8a76 */
  0x0000, /* U+8a77 */
  0x0000, /* U+8a78 */
  0xfba5, /* U+8a79 */
  0x0000, /* U+8a7a */
  0x0000, /* U+8a7b */
  0xe66a, /* U+8a7c */
  0x0000, /* U+8a7d */
  0x0000, /* U+8a7e */
  0x0000, /* U+8a7f */
  0x0000, /* U+8a80 */
  0x0000, /* U+8a81 */
  0xe66f, /* U+8a82 */
  0x0000, /* U+8a83 */
  0xe670, /* U+8a84 */
  0xe66e, /* U+8a85 */
  0x0000, /* U+8a86 */
  0x8cd6, /* U+8a87 */
  0x0000, /* U+8a88 */
  0x975f, /* U+8a89 */
  0x0000, /* U+8a8a */
  0x0000, /* U+8a8b */
  0x8e8f, /* U+8a8c */
  0x9446, /* U+8a8d */
  0x0000, /* U+8a8e */
  0x0000, /* U+8a8f */
  0x0000, /* U+8a90 */
  0xe673, /* U+8a91 */
  0x0000, /* U+8a92 */
  0x90be, /* U+8a93 */
  0x0000, /* U+8a94 */
  0x9261, /* U+8a95 */
  0x0000, /* U+8a96 */
  0x0000, /* U+8a97 */
  0x9755, /* U+8a98 */
  0x0000, /* U+8a99 */
  0xe676, /* U+8a9a */
  0x0000, /* U+8a9b */
  0x0000, /* U+8a9c */
  0x0000, /* U+8a9d */
  0x8cea, /* U+8a9e */
  0x0000, /* U+8a9f */
  0x90bd, /* U+8aa0 */
  0xe672, /* U+8aa1 */
  0x0000, /* U+8aa2 */
  0xe677, /* U+8aa3 */
  0x8ceb, /* U+8aa4 */
  0xe674, /* U+8aa5 */
  0xe675, /* U+8aa6 */
  0xfba6, /* U+8aa7 */
  0xe671, /* U+8aa8 */
  0x0000, /* U+8aa9 */
  0x0000, /* U+8aaa */
  0x0000, /* U+8aab */
  0x90e0, /* U+8aac */
  0x93c7, /* U+8aad */
  0x0000, /* U+8aae */
  0x0000, /* U+8aaf */
  0x924e, /* U+8ab0 */
  0x0000, /* U+8ab1 */
  0x89db, /* U+8ab2 */
  0x0000, /* U+8ab3 */
  0x0000, /* U+8ab4 */
  0x0000, /* U+8ab5 */
  0x0000, /* U+8ab6 */
  0x0000, /* U+8ab7 */
  0x0000, /* U+8ab8 */
  0x94ee, /* U+8ab9 */
  0x0000, /* U+8aba */
  0x0000, /* U+8abb */
  0x8b62, /* U+8abc */
  0x0000, /* U+8abd */
  0xfba7, /* U+8abe */
  0x92b2, /* U+8abf */
  0x0000, /* U+8ac0 */
  0x0000, /* U+8ac1 */
  0xe67a, /* U+8ac2 */
  0x0000, /* U+8ac3 */
  0xe678, /* U+8ac4 */
  0x0000, /* U+8ac5 */
  0x0000, /* U+8ac6 */
  0x926b, /* U+8ac7 */
  0x0000, /* U+8ac8 */
  0x0000, /* U+8ac9 */
  0x0000, /* U+8aca */
  0x90bf, /* U+8acb */
  0x8ad0, /* U+8acc */
  0xe679, /* U+8acd */
  0x0000, /* U+8ace */
  0x907a, /* U+8acf */
  0x0000, /* U+8ad0 */
  0x0000, /* U+8ad1 */
  0x97c8, /* U+8ad2 */
  0x0000, /* U+8ad3 */
  0x0000, /* U+8ad4 */
  0x0000, /* U+8ad5 */
  0x985f, /* U+8ad6 */
  0x0000, /* U+8ad7 */
  0x0000, /* U+8ad8 */
  0x0000, /* U+8ad9 */
  0xe67b, /* U+8ada */
  0xe687, /* U+8adb */
  0x92b3, /* U+8adc */
  0x0000, /* U+8add */
  0xe686, /* U+8ade */
  0xfba8, /* U+8adf */
  0xe683, /* U+8ae0 */
  0xe68b, /* U+8ae1 */
  0xe684, /* U+8ae2 */
  0x0000, /* U+8ae3 */
  0xe680, /* U+8ae4 */
  0x0000, /* U+8ae5 */
  0x92fa, /* U+8ae6 */
  0xe67e, /* U+8ae7 */
  0x0000, /* U+8ae8 */
  0x0000, /* U+8ae9 */
  0x0000, /* U+8aea */
  0xe67c, /* U+8aeb */
  0x0000, /* U+8aec */
  0x9740, /* U+8aed */
  0x8e90, /* U+8aee */
  0x0000, /* U+8aef */
  0x0000, /* U+8af0 */
  0xe681, /* U+8af1 */
  0x0000, /* U+8af2 */
  0xe67d, /* U+8af3 */
  0x0000, /* U+8af4 */
  0x0000, /* U+8af5 */
  0xfbaa, /* U+8af6 */
  0xe685, /* U+8af7 */
  0x8f94, /* U+8af8 */
  0x0000, /* U+8af9 */
  0x8cbf, /* U+8afa */
  0x0000, /* U+8afb */
  0x0000, /* U+8afc */
  0x0000, /* U+8afd */
  0x91f8, /* U+8afe */
  0x0000, /* U+8aff */
  0x9664, /* U+8b00 */
  0x8979, /* U+8b01 */
  0x88e0, /* U+8b02 */
  0x0000, /* U+8b03 */
  0x93a3, /* U+8b04 */
  0x0000, /* U+8b05 */
  0x0000, /* U+8b06 */
  0xe689, /* U+8b07 */
  0x0000, /* U+8b08 */
  0x0000, /* U+8b09 */
  0x0000, /* U+8b0a */
  0x0000, /* U+8b0b */
  0xe688, /* U+8b0c */
  0x0000, /* U+8b0d */
  0x93e4, /* U+8b0e */
  0x0000, /* U+8b0f */
  0xe68d, /* U+8b10 */
  0x0000, /* U+8b11 */
  0x0000, /* U+8b12 */
  0x0000, /* U+8b13 */
  0xe682, /* U+8b14 */
  0x0000, /* U+8b15 */
  0xe68c, /* U+8b16 */
  0xe68e, /* U+8b17 */
  0x0000, /* U+8b18 */
  0x8caa, /* U+8b19 */
  0xe68a, /* U+8b1a */
  0x8d75, /* U+8b1b */
  0x0000, /* U+8b1c */
  0x8ed3, /* U+8b1d */
  0x0000, /* U+8b1e */
  0x0000, /* U+8b1f */
  0xe68f, /* U+8b20 */
  0x9777, /* U+8b21 */
  0x0000, /* U+8b22 */
  0x0000, /* U+8b23 */
  0x0000, /* U+8b24 */
  0x0000, /* U+8b25 */
  0xe692, /* U+8b26 */
  0x0000, /* U+8b27 */
  0xe695, /* U+8b28 */
  0x0000, /* U+8b29 */
  0x0000, /* U+8b2a */
  0xe693, /* U+8b2b */
  0x9554, /* U+8b2c */
  0x0000, /* U+8b2d */
  0x0000, /* U+8b2e */
  0x0000, /* U+8b2f */
  0x0000, /* U+8b30 */
  0x0000, /* U+8b31 */
  0x0000, /* U+8b32 */
  0xe690, /* U+8b33 */
  0x0000, /* U+8b34 */
  0x0000, /* U+8b35 */
  0x0000, /* U+8b36 */
  0x0000, /* U+8b37 */
  0x0000, /* U+8b38 */
  0x8bde, /* U+8b39 */
  0x0000, /* U+8b3a */
  0x0000, /* U+8b3b */
  0x0000, /* U+8b3c */
  0x0000, /* U+8b3d */
  0xe694, /* U+8b3e */
  0x0000, /* U+8b3f */
  0x0000, /* U+8b40 */
  0xe696, /* U+8b41 */
  0x0000, /* U+8b42 */
  0x0000, /* U+8b43 */
  0x0000, /* U+8b44 */
  0x0000, /* U+8b45 */
  0x0000, /* U+8b46 */
  0x0000, /* U+8b47 */
  0x0000, /* U+8b48 */
  0xe69a, /* U+8b49 */
  0x0000, /* U+8b4a */
  0x0000, /* U+8b4b */
  0xe697, /* U+8b4c */
  0x0000, /* U+8b4d */
  0xe699, /* U+8b4e */
  0xe698, /* U+8b4f */
  0x0000, /* U+8b50 */
  0x0000, /* U+8b51 */
  0x0000, /* U+8b52 */
  0xfbab, /* U+8b53 */
  0x0000, /* U+8b54 */
  0x0000, /* U+8b55 */
  0xe69b, /* U+8b56 */
  0x0000, /* U+8b57 */
  0x8eaf, /* U+8b58 */
  0x0000, /* U+8b59 */
  0xe69d, /* U+8b5a */
  0xe69c, /* U+8b5b */
  0x9588, /* U+8b5c */
  0x0000, /* U+8b5d */
  0x0000, /* U+8b5e */
  0xe69f, /* U+8b5f */
  0x0000, /* U+8b60 */
  0x0000, /* U+8b61 */
  0x0000, /* U+8b62 */
  0x0000, /* U+8b63 */
  0x0000, /* U+8b64 */
  0x0000, /* U+8b65 */
  0x8c78, /* U+8b66 */
  0x0000, /* U+8b67 */
  0x0000, /* U+8b68 */
  0x0000, /* U+8b69 */
  0x0000, /* U+8b6a */
  0xe69e, /* U+8b6b */
  0xe6a0, /* U+8b6c */
  0x0000, /* U+8b6d */
  0x0000, /* U+8b6e */
  0xe6a1, /* U+8b6f */
  0x8b63, /* U+8b70 */
  0xe3bf, /* U+8b71 */
  0x8ff7, /* U+8b72 */
  0x0000, /* U+8b73 */
  0xe6a2, /* U+8b74 */
  0x0000, /* U+8b75 */
  0x0000, /* U+8b76 */
  0x8cec, /* U+8b77 */
  0x0000, /* U+8b78 */
  0x0000, /* U+8b79 */
  0x0000, /* U+8b7a */
  0x0000, /* U+8b7b */
  0x0000, /* U+8b7c */
  0xe6a3, /* U+8b7d */
  0x0000, /* U+8b7e */
  0xfbac, /* U+8b7f */
  0xe6a4, /* U+8b80 */
  0x0000, /* U+8b81 */
  0x0000, /* U+8b82 */
  0x8e5d, /* U+8b83 */
  0x0000, /* U+8b84 */
  0x0000, /* U+8b85 */
  0x0000, /* U+8b86 */
  0x0000, /* U+8b87 */
  0x0000, /* U+8b88 */
  0x0000, /* U+8b89 */
  0x9dcc, /* U+8b8a */
  0x0000, /* U+8b8b */
  0xe6a5, /* U+8b8c */
  0x0000, /* U+8b8d */
  0xe6a6, /* U+8b8e */
  0x0000, /* U+8b8f */
  0x8f51, /* U+8b90 */
  0x0000, /* U+8b91 */
  0xe6a7, /* U+8b92 */
  0xe6a8, /* U+8b93 */
  0x0000, /* U+8b94 */
  0x0000, /* U+8b95 */
  0xe6a9, /* U+8b96 */
  0x0000, /* U+8b97 */
  0x0000, /* U+8b98 */
  0xe6aa, /* U+8b99 */
  0xe6ab, /* U+8b9a */
  0x0000, /* U+8b9b */
  0x0000, /* U+8b9c */
  0x0000, /* U+8b9d */
  0x0000, /* U+8b9e */
  0x0000, /* U+8b9f */
  0x0000, /* U+8ba0 */
  0x0000, /* U+8ba1 */
  0x0000, /* U+8ba2 */
  0x0000, /* U+8ba3 */
  0x0000, /* U+8ba4 */
  0x0000, /* U+8ba5 */
  0x0000, /* U+8ba6 */
  0x0000, /* U+8ba7 */
  0x0000, /* U+8ba8 */
  0x0000, /* U+8ba9 */
  0x0000, /* U+8baa */
  0x0000, /* U+8bab */
  0x0000, /* U+8bac */
  0x0000, /* U+8bad */
  0x0000, /* U+8bae */
  0x0000, /* U+8baf */
  0x0000, /* U+8bb0 */
  0x0000, /* U+8bb1 */
  0x0000, /* U+8bb2 */
  0x0000, /* U+8bb3 */
  0x0000, /* U+8bb4 */
  0x0000, /* U+8bb5 */
  0x0000, /* U+8bb6 */
  0x0000, /* U+8bb7 */
  0x0000, /* U+8bb8 */
  0x0000, /* U+8bb9 */
  0x0000, /* U+8bba */
  0x0000, /* U+8bbb */
  0x0000, /* U+8bbc */
  0x0000, /* U+8bbd */
  0x0000, /* U+8bbe */
  0x0000, /* U+8bbf */
  0x0000, /* U+8bc0 */
  0x0000, /* U+8bc1 */
  0x0000, /* U+8bc2 */
  0x0000, /* U+8bc3 */
  0x0000, /* U+8bc4 */
  0x0000, /* U+8bc5 */
  0x0000, /* U+8bc6 */
  0x0000, /* U+8bc7 */
  0x0000, /* U+8bc8 */
  0x0000, /* U+8bc9 */
  0x0000, /* U+8bca */
  0x0000, /* U+8bcb */
  0x0000, /* U+8bcc */
  0x0000, /* U+8bcd */
  0x0000, /* U+8bce */
  0x0000, /* U+8bcf */
  0x0000, /* U+8bd0 */
  0x0000, /* U+8bd1 */
  0x0000, /* U+8bd2 */
  0x0000, /* U+8bd3 */
  0x0000, /* U+8bd4 */
  0x0000, /* U+8bd5 */
  0x0000, /* U+8bd6 */
  0x0000, /* U+8bd7 */
  0x0000, /* U+8bd8 */
  0x0000, /* U+8bd9 */
  0x0000, /* U+8bda */
  0x0000, /* U+8bdb */
  0x0000, /* U+8bdc */
  0x0000, /* U+8bdd */
  0x0000, /* U+8bde */
  0x0000, /* U+8bdf */
  0x0000, /* U+8be0 */
  0x0000, /* U+8be1 */
  0x0000, /* U+8be2 */
  0x0000, /* U+8be3 */
  0x0000, /* U+8be4 */
  0x0000, /* U+8be5 */
  0x0000, /* U+8be6 */
  0x0000, /* U+8be7 */
  0x0000, /* U+8be8 */
  0x0000, /* U+8be9 */
  0x0000, /* U+8bea */
  0x0000, /* U+8beb */
  0x0000, /* U+8bec */
  0x0000, /* U+8bed */
  0x0000, /* U+8bee */
  0x0000, /* U+8bef */
  0x0000, /* U+8bf0 */
  0x0000, /* U+8bf1 */
  0x0000, /* U+8bf2 */
  0x0000, /* U+8bf3 */
  0x0000, /* U+8bf4 */
  0x0000, /* U+8bf5 */
  0x0000, /* U+8bf6 */
  0x0000, /* U+8bf7 */
  0x0000, /* U+8bf8 */
  0x0000, /* U+8bf9 */
  0x0000, /* U+8bfa */
  0x0000, /* U+8bfb */
  0x0000, /* U+8bfc */
  0x0000, /* U+8bfd */
  0x0000, /* U+8bfe */
  0x0000, /* U+8bff */
  0x0000, /* U+8c00 */
  0x0000, /* U+8c01 */
  0x0000, /* U+8c02 */
  0x0000, /* U+8c03 */
  0x0000, /* U+8c04 */
  0x0000, /* U+8c05 */
  0x0000, /* U+8c06 */
  0x0000, /* U+8c07 */
  0x0000, /* U+8c08 */
  0x0000, /* U+8c09 */
  0x0000, /* U+8c0a */
  0x0000, /* U+8c0b */
  0x0000, /* U+8c0c */
  0x0000, /* U+8c0d */
  0x0000, /* U+8c0e */
  0x0000, /* U+8c0f */
  0x0000, /* U+8c10 */
  0x0000, /* U+8c11 */
  0x0000, /* U+8c12 */
  0x0000, /* U+8c13 */
  0x0000, /* U+8c14 */
  0x0000, /* U+8c15 */
  0x0000, /* U+8c16 */
  0x0000, /* U+8c17 */
  0x0000, /* U+8c18 */
  0x0000, /* U+8c19 */
  0x0000, /* U+8c1a */
  0x0000, /* U+8c1b */
  0x0000, /* U+8c1c */
  0x0000, /* U+8c1d */
  0x0000, /* U+8c1e */
  0x0000, /* U+8c1f */
  0x0000, /* U+8c20 */
  0x0000, /* U+8c21 */
  0x0000, /* U+8c22 */
  0x0000, /* U+8c23 */
  0x0000, /* U+8c24 */
  0x0000, /* U+8c25 */
  0x0000, /* U+8c26 */
  0x0000, /* U+8c27 */
  0x0000, /* U+8c28 */
  0x0000, /* U+8c29 */
  0x0000, /* U+8c2a */
  0x0000, /* U+8c2b */
  0x0000, /* U+8c2c */
  0x0000, /* U+8c2d */
  0x0000, /* U+8c2e */
  0x0000, /* U+8c2f */
  0x0000, /* U+8c30 */
  0x0000, /* U+8c31 */
  0x0000, /* U+8c32 */
  0x0000, /* U+8c33 */
  0x0000, /* U+8c34 */
  0x0000, /* U+8c35 */
  0x0000, /* U+8c36 */
  0x924a, /* U+8c37 */
  0x0000, /* U+8c38 */
  0x0000, /* U+8c39 */
  0xe6ac, /* U+8c3a */
  0x0000, /* U+8c3b */
  0x0000, /* U+8c3c */
  0x0000, /* U+8c3d */
  0x0000, /* U+8c3e */
  0xe6ae, /* U+8c3f */
  0x0000, /* U+8c40 */
  0xe6ad, /* U+8c41 */
  0x0000, /* U+8c42 */
  0x0000, /* U+8c43 */
  0x0000, /* U+8c44 */
  0x0000, /* U+8c45 */
  0x93a4, /* U+8c46 */
  0x0000, /* U+8c47 */
  0xe6af, /* U+8c48 */
  0x0000, /* U+8c49 */
  0x964c, /* U+8c4a */
  0x0000, /* U+8c4b */
  0xe6b0, /* U+8c4c */
  0x0000, /* U+8c4d */
  0xe6b1, /* U+8c4e */
  0x0000, /* U+8c4f */
  0xe6b2, /* U+8c50 */
  0x0000, /* U+8c51 */
  0x0000, /* U+8c52 */
  0x0000, /* U+8c53 */
  0x0000, /* U+8c54 */
  0xe6b3, /* U+8c55 */
  0x0000, /* U+8c56 */
  0x0000, /* U+8c57 */
  0x0000, /* U+8c58 */
  0x0000, /* U+8c59 */
  0x93d8, /* U+8c5a */
  0x0000, /* U+8c5b */
  0x0000, /* U+8c5c */
  0x0000, /* U+8c5d */
  0x0000, /* U+8c5e */
  0x0000, /* U+8c5f */
  0x0000, /* U+8c60 */
  0x8fdb, /* U+8c61 */
  0xe6b4, /* U+8c62 */
  0x0000, /* U+8c63 */
  0x0000, /* U+8c64 */
  0x0000, /* U+8c65 */
  0x0000, /* U+8c66 */
  0x0000, /* U+8c67 */
  0x0000, /* U+8c68 */
  0x0000, /* U+8c69 */
  0x8d8b, /* U+8c6a */
  0x98ac, /* U+8c6b */
  0xe6b5, /* U+8c6c */
  0x0000, /* U+8c6d */
  0x0000, /* U+8c6e */
  0x0000, /* U+8c6f */
  0x0000, /* U+8c70 */
  0x0000, /* U+8c71 */
  0x0000, /* U+8c72 */
  0x0000, /* U+8c73 */
  0x0000, /* U+8c74 */
  0x0000, /* U+8c75 */
  0x0000, /* U+8c76 */
  0x0000, /* U+8c77 */
  0xe6b6, /* U+8c78 */
  0x955e, /* U+8c79 */
  0xe6b7, /* U+8c7a */
  0x0000, /* U+8c7b */
  0xe6bf, /* U+8c7c */
  0x0000, /* U+8c7d */
  0x0000, /* U+8c7e */
  0x0000, /* U+8c7f */
  0x0000, /* U+8c80 */
  0x0000, /* U+8c81 */
  0xe6b8, /* U+8c82 */
  0x0000, /* U+8c83 */
  0x0000, /* U+8c84 */
  0xe6ba, /* U+8c85 */
  0x0000, /* U+8c86 */
  0x0000, /* U+8c87 */
  0x0000, /* U+8c88 */
  0xe6b9, /* U+8c89 */
  0xe6bb, /* U+8c8a */
  0x0000, /* U+8c8b */
  0x9665, /* U+8c8c */
  0xe6bc, /* U+8c8d */
  0xe6bd, /* U+8c8e */
  0x0000, /* U+8c8f */
  0x0000, /* U+8c90 */
  0x0000, /* U+8c91 */
  0x0000, /* U+8c92 */
  0x0000, /* U+8c93 */
  0xe6be, /* U+8c94 */
  0x0000, /* U+8c95 */
  0x0000, /* U+8c96 */
  0x0000, /* U+8c97 */
  0xe6c0, /* U+8c98 */
  0x0000, /* U+8c99 */
  0x0000, /* U+8c9a */
  0x0000, /* U+8c9b */
  0x0000, /* U+8c9c */
  0x8a4c, /* U+8c9d */
  0x92e5, /* U+8c9e */
  0x0000, /* U+8c9f */
  0x9589, /* U+8ca0 */
  0x8de0, /* U+8ca1 */
  0x8d76, /* U+8ca2 */
  0x0000, /* U+8ca3 */
  0x0000, /* U+8ca4 */
  0x0000, /* U+8ca5 */
  0x0000, /* U+8ca6 */
  0x956e, /* U+8ca7 */
  0x89dd, /* U+8ca8 */
  0x94cc, /* U+8ca9 */
  0xe6c3, /* U+8caa */
  0x8ad1, /* U+8cab */
  0x90d3, /* U+8cac */
  0xe6c2, /* U+8cad */
  0xe6c7, /* U+8cae */
  0x9299, /* U+8caf */
  0x96e1, /* U+8cb0 */
  0x0000, /* U+8cb1 */
  0xe6c5, /* U+8cb2 */
  0xe6c6, /* U+8cb3 */
  0x8b4d, /* U+8cb4 */
  0x0000, /* U+8cb5 */
  0xe6c8, /* U+8cb6 */
  0x9483, /* U+8cb7 */
  0x91dd, /* U+8cb8 */
  0x0000, /* U+8cb9 */
  0x0000, /* U+8cba */
  0x94ef, /* U+8cbb */
  0x935c, /* U+8cbc */
  0xe6c4, /* U+8cbd */
  0x0000, /* U+8cbe */
  0x9666, /* U+8cbf */
  0x89ea, /* U+8cc0 */
  0xe6ca, /* U+8cc1 */
  0x9847, /* U+8cc2 */
  0x92c0, /* U+8cc3 */
  0x9864, /* U+8cc4 */
  0x0000, /* U+8cc5 */
  0x0000, /* U+8cc6 */
  0x8e91, /* U+8cc7 */
  0xe6c9, /* U+8cc8 */
  0x0000, /* U+8cc9 */
  0x91af, /* U+8cca */
  0x0000, /* U+8ccb */
  0x0000, /* U+8ccc */
  0xe6da, /* U+8ccd */
  0x9147, /* U+8cce */
  0x0000, /* U+8ccf */
  0x0000, /* U+8cd0 */
  0x93f6, /* U+8cd1 */
  0x0000, /* U+8cd2 */
  0x956f, /* U+8cd3 */
  0x0000, /* U+8cd4 */
  0x0000, /* U+8cd5 */
  0x0000, /* U+8cd6 */
  0x0000, /* U+8cd7 */
  0x0000, /* U+8cd8 */
  0x0000, /* U+8cd9 */
  0xe6cd, /* U+8cda */
  0x8e5e, /* U+8cdb */
  0x8e92, /* U+8cdc */
  0x0000, /* U+8cdd */
  0x8fdc, /* U+8cde */
  0x0000, /* U+8cdf */
  0x9485, /* U+8ce0 */
  0x0000, /* U+8ce1 */
  0x8cab, /* U+8ce2 */
  0xe6cc, /* U+8ce3 */
  0xe6cb, /* U+8ce4 */
  0x0000, /* U+8ce5 */
  0x958a, /* U+8ce6 */
  0x0000, /* U+8ce7 */
  0x0000, /* U+8ce8 */
  0x0000, /* U+8ce9 */
  0x8ebf, /* U+8cea */
  0x0000, /* U+8ceb */
  0x0000, /* U+8cec */
  0x9371, /* U+8ced */
  0x0000, /* U+8cee */
  0x0000, /* U+8cef */
  0xfbad, /* U+8cf0 */
  0x0000, /* U+8cf1 */
  0x0000, /* U+8cf2 */
  0x0000, /* U+8cf3 */
  0xfbae, /* U+8cf4 */
  0x0000, /* U+8cf5 */
  0x0000, /* U+8cf6 */
  0x0000, /* U+8cf7 */
  0x0000, /* U+8cf8 */
  0x0000, /* U+8cf9 */
  0xe6cf, /* U+8cfa */
  0xe6d0, /* U+8cfb */
  0x8d77, /* U+8cfc */
  0xe6ce, /* U+8cfd */
  0x0000, /* U+8cfe */
  0x0000, /* U+8cff */
  0x0000, /* U+8d00 */
  0x0000, /* U+8d01 */
  0x0000, /* U+8d02 */
  0x0000, /* U+8d03 */
  0xe6d1, /* U+8d04 */
  0xe6d2, /* U+8d05 */
  0x0000, /* U+8d06 */
  0xe6d4, /* U+8d07 */
  0x91a1, /* U+8d08 */
  0x0000, /* U+8d09 */
  0xe6d3, /* U+8d0a */
  0x8ae4, /* U+8d0b */
  0x0000, /* U+8d0c */
  0xe6d6, /* U+8d0d */
  0x0000, /* U+8d0e */
  0xe6d5, /* U+8d0f */
  0xe6d7, /* U+8d10 */
  0x0000, /* U+8d11 */
  0xfbaf, /* U+8d12 */
  0xe6d9, /* U+8d13 */
  0xe6db, /* U+8d14 */
  0x0000, /* U+8d15 */
  0xe6dc, /* U+8d16 */
  0x0000, /* U+8d17 */
  0x0000, /* U+8d18 */
  0x0000, /* U+8d19 */
  0x0000, /* U+8d1a */
  0x0000, /* U+8d1b */
  0x0000, /* U+8d1c */
  0x0000, /* U+8d1d */
  0x0000, /* U+8d1e */
  0x0000, /* U+8d1f */
  0x0000, /* U+8d20 */
  0x0000, /* U+8d21 */
  0x0000, /* U+8d22 */
  0x0000, /* U+8d23 */
  0x0000, /* U+8d24 */
  0x0000, /* U+8d25 */
  0x0000, /* U+8d26 */
  0x0000, /* U+8d27 */
  0x0000, /* U+8d28 */
  0x0000, /* U+8d29 */
  0x0000, /* U+8d2a */
  0x0000, /* U+8d2b */
  0x0000, /* U+8d2c */
  0x0000, /* U+8d2d */
  0x0000, /* U+8d2e */
  0x0000, /* U+8d2f */
  0x0000, /* U+8d30 */
  0x0000, /* U+8d31 */
  0x0000, /* U+8d32 */
  0x0000, /* U+8d33 */
  0x0000, /* U+8d34 */
  0x0000, /* U+8d35 */
  0x0000, /* U+8d36 */
  0x0000, /* U+8d37 */
  0x0000, /* U+8d38 */
  0x0000, /* U+8d39 */
  0x0000, /* U+8d3a */
  0x0000, /* U+8d3b */
  0x0000, /* U+8d3c */
  0x0000, /* U+8d3d */
  0x0000, /* U+8d3e */
  0x0000, /* U+8d3f */
  0x0000, /* U+8d40 */
  0x0000, /* U+8d41 */
  0x0000, /* U+8d42 */
  0x0000, /* U+8d43 */
  0x0000, /* U+8d44 */
  0x0000, /* U+8d45 */
  0x0000, /* U+8d46 */
  0x0000, /* U+8d47 */
  0x0000, /* U+8d48 */
  0x0000, /* U+8d49 */
  0x0000, /* U+8d4a */
  0x0000, /* U+8d4b */
  0x0000, /* U+8d4c */
  0x0000, /* U+8d4d */
  0x0000, /* U+8d4e */
  0x0000, /* U+8d4f */
  0x0000, /* U+8d50 */
  0x0000, /* U+8d51 */
  0x0000, /* U+8d52 */
  0x0000, /* U+8d53 */
  0x0000, /* U+8d54 */
  0x0000, /* U+8d55 */
  0x0000, /* U+8d56 */
  0x0000, /* U+8d57 */
  0x0000, /* U+8d58 */
  0x0000, /* U+8d59 */
  0x0000, /* U+8d5a */
  0x0000, /* U+8d5b */
  0x0000, /* U+8d5c */
  0x0000, /* U+8d5d */
  0x0000, /* U+8d5e */
  0x0000, /* U+8d5f */
  0x0000, /* U+8d60 */
  0x0000, /* U+8d61 */
  0x0000, /* U+8d62 */
  0x0000, /* U+8d63 */
  0x90d4, /* U+8d64 */
  0x0000, /* U+8d65 */
  0x8ecd, /* U+8d66 */
  0xe6dd, /* U+8d67 */
  0x0000, /* U+8d68 */
  0x0000, /* U+8d69 */
  0x0000, /* U+8d6a */
  0x8a71, /* U+8d6b */
  0x0000, /* U+8d6c */
  0xe6de, /* U+8d6d */
  0x0000, /* U+8d6e */
  0x0000, /* U+8d6f */
  0x9196, /* U+8d70 */
  0xe6df, /* U+8d71 */
  0x0000, /* U+8d72 */
  0xe6e0, /* U+8d73 */
  0x958b, /* U+8d74 */
  0x0000, /* U+8d75 */
  0xfbb0, /* U+8d76 */
  0x8b4e, /* U+8d77 */
  0x0000, /* U+8d78 */
  0x0000, /* U+8d79 */
  0x0000, /* U+8d7a */
  0x0000, /* U+8d7b */
  0x0000, /* U+8d7c */
  0x0000, /* U+8d7d */
  0x0000, /* U+8d7e */
  0x0000, /* U+8d7f */
  0x0000, /* U+8d80 */
  0xe6e1, /* U+8d81 */
  0x0000, /* U+8d82 */
  0x0000, /* U+8d83 */
  0x0000, /* U+8d84 */
  0x92b4, /* U+8d85 */
  0x0000, /* U+8d86 */
  0x0000, /* U+8d87 */
  0x0000, /* U+8d88 */
  0x0000, /* U+8d89 */
  0x897a, /* U+8d8a */
  0x0000, /* U+8d8b */
  0x0000, /* U+8d8c */
  0x0000, /* U+8d8d */
  0x0000, /* U+8d8e */
  0x0000, /* U+8d8f */
  0x0000, /* U+8d90 */
  0x0000, /* U+8d91 */
  0x0000, /* U+8d92 */
  0x0000, /* U+8d93 */
  0x0000, /* U+8d94 */
  0x0000, /* U+8d95 */
  0x0000, /* U+8d96 */
  0x0000, /* U+8d97 */
  0x0000, /* U+8d98 */
  0xe6e2, /* U+8d99 */
  0x0000, /* U+8d9a */
  0x0000, /* U+8d9b */
  0x0000, /* U+8d9c */
  0x0000, /* U+8d9d */
  0x0000, /* U+8d9e */
  0x0000, /* U+8d9f */
  0x0000, /* U+8da0 */
  0x0000, /* U+8da1 */
  0x0000, /* U+8da2 */
  0x8eef, /* U+8da3 */
  0x0000, /* U+8da4 */
  0x0000, /* U+8da5 */
  0x0000, /* U+8da6 */
  0x0000, /* U+8da7 */
  0x9096, /* U+8da8 */
  0x0000, /* U+8da9 */
  0x0000, /* U+8daa */
  0x0000, /* U+8dab */
  0x0000, /* U+8dac */
  0x0000, /* U+8dad */
  0x0000, /* U+8dae */
  0x0000, /* U+8daf */
  0x0000, /* U+8db0 */
  0x0000, /* U+8db1 */
  0x0000, /* U+8db2 */
  0x91ab, /* U+8db3 */
  0x0000, /* U+8db4 */
  0x0000, /* U+8db5 */
  0x0000, /* U+8db6 */
  0x0000, /* U+8db7 */
  0x0000, /* U+8db8 */
  0x0000, /* U+8db9 */
  0xe6e5, /* U+8dba */
  0x0000, /* U+8dbb */
  0x0000, /* U+8dbc */
  0x0000, /* U+8dbd */
  0xe6e4, /* U+8dbe */
  0x0000, /* U+8dbf */
  0x0000, /* U+8dc0 */
  0x0000, /* U+8dc1 */
  0xe6e3, /* U+8dc2 */
  0x0000, /* U+8dc3 */
  0x0000, /* U+8dc4 */
  0x0000, /* U+8dc5 */
  0x0000, /* U+8dc6 */
  0x0000, /* U+8dc7 */
  0x0000, /* U+8dc8 */
  0x0000, /* U+8dc9 */
  0x0000, /* U+8dca */
  0xe6eb, /* U+8dcb */
  0xe6e9, /* U+8dcc */
  0x0000, /* U+8dcd */
  0x0000, /* U+8dce */
  0xe6e6, /* U+8dcf */
  0x0000, /* U+8dd0 */
  0x0000, /* U+8dd1 */
  0x0000, /* U+8dd2 */
  0x0000, /* U+8dd3 */
  0x0000, /* U+8dd4 */
  0x0000, /* U+8dd5 */
  0xe6e8, /* U+8dd6 */
  0x0000, /* U+8dd7 */
  0x0000, /* U+8dd8 */
  0x0000, /* U+8dd9 */
  0xe6e7, /* U+8dda */
  0xe6ea, /* U+8ddb */
  0x0000, /* U+8ddc */
  0x8b97, /* U+8ddd */
  0x0000, /* U+8dde */
  0xe6ee, /* U+8ddf */
  0x0000, /* U+8de0 */
  0x90d5, /* U+8de1 */
  0x0000, /* U+8de2 */
  0xe6ef, /* U+8de3 */
  0x0000, /* U+8de4 */
  0x0000, /* U+8de5 */
  0x0000, /* U+8de6 */
  0x0000, /* U+8de7 */
  0x8cd7, /* U+8de8 */
  0x0000, /* U+8de9 */
  0xe6ec, /* U+8dea */
  0xe6ed, /* U+8deb */
  0x0000, /* U+8dec */
  0x0000, /* U+8ded */
  0x0000, /* U+8dee */
  0x9848, /* U+8def */
  0x0000, /* U+8df0 */
  0x0000, /* U+8df1 */
  0x0000, /* U+8df2 */
  0x92b5, /* U+8df3 */
  0x0000, /* U+8df4 */
  0x9148, /* U+8df5 */
  0x0000, /* U+8df6 */
  0x0000, /* U+8df7 */
  0x0000, /* U+8df8 */
  0x0000, /* U+8df9 */
  0x0000, /* U+8dfa */
  0x0000, /* U+8dfb */
  0xe6f0, /* U+8dfc */
  0x0000, /* U+8dfd */
  0x0000, /* U+8dfe */
  0xe6f3, /* U+8dff */
  0x0000, /* U+8e00 */
  0x0000, /* U+8e01 */
  0x0000, /* U+8e02 */
  0x0000, /* U+8e03 */
  0x0000, /* U+8e04 */
  0x0000, /* U+8e05 */
  0x0000, /* U+8e06 */
  0x0000, /* U+8e07 */
  0xe6f1, /* U+8e08 */
  0xe6f2, /* U+8e09 */
  0x9778, /* U+8e0a */
  0x0000, /* U+8e0b */
  0x0000, /* U+8e0c */
  0x0000, /* U+8e0d */
  0x0000, /* U+8e0e */
  0x93a5, /* U+8e0f */
  0xe6f6, /* U+8e10 */
  0x0000, /* U+8e11 */
  0x0000, /* U+8e12 */
  0x0000, /* U+8e13 */
  0x0000, /* U+8e14 */
  0x0000, /* U+8e15 */
  0x0000, /* U+8e16 */
  0x0000, /* U+8e17 */
  0x0000, /* U+8e18 */
  0x0000, /* U+8e19 */
  0x0000, /* U+8e1a */
  0x0000, /* U+8e1b */
  0x0000, /* U+8e1c */
  0xe6f4, /* U+8e1d */
  0xe6f5, /* U+8e1e */
  0xe6f7, /* U+8e1f */
  0x0000, /* U+8e20 */
  0x0000, /* U+8e21 */
  0x0000, /* U+8e22 */
  0x0000, /* U+8e23 */
  0x0000, /* U+8e24 */
  0x0000, /* U+8e25 */
  0x0000, /* U+8e26 */
  0x0000, /* U+8e27 */
  0x0000, /* U+8e28 */
  0x0000, /* U+8e29 */
  0xe748, /* U+8e2a */
  0x0000, /* U+8e2b */
  0x0000, /* U+8e2c */
  0x0000, /* U+8e2d */
  0x0000, /* U+8e2e */
  0x0000, /* U+8e2f */
  0xe6fa, /* U+8e30 */
  0x0000, /* U+8e31 */
  0x0000, /* U+8e32 */
  0x0000, /* U+8e33 */
  0xe6fb, /* U+8e34 */
  0xe6f9, /* U+8e35 */
  0x0000, /* U+8e36 */
  0x0000, /* U+8e37 */
  0x0000, /* U+8e38 */
  0x0000, /* U+8e39 */
  0x0000, /* U+8e3a */
  0x0000, /* U+8e3b */
  0x0000, /* U+8e3c */
  0x0000, /* U+8e3d */
  0x0000, /* U+8e3e */
  0x0000, /* U+8e3f */
  0x0000, /* U+8e40 */
  0x0000, /* U+8e41 */
  0xe6f8, /* U+8e42 */
  0x0000, /* U+8e43 */
  0x92fb, /* U+8e44 */
  0x0000, /* U+8e45 */
  0x0000, /* U+8e46 */
  0xe740, /* U+8e47 */
  0xe744, /* U+8e48 */
  0xe741, /* U+8e49 */
  0xe6fc, /* U+8e4a */
  0x0000, /* U+8e4b */
  0xe742, /* U+8e4c */
  0x0000, /* U+8e4d */
  0x0000, /* U+8e4e */
  0x0000, /* U+8e4f */
  0xe743, /* U+8e50 */
  0x0000, /* U+8e51 */
  0x0000, /* U+8e52 */
  0x0000, /* U+8e53 */
  0x0000, /* U+8e54 */
  0xe74a, /* U+8e55 */
  0x0000, /* U+8e56 */
  0x0000, /* U+8e57 */
  0x0000, /* U+8e58 */
  0xe745, /* U+8e59 */
  0x0000, /* U+8e5a */
  0x0000, /* U+8e5b */
  0x0000, /* U+8e5c */
  0x0000, /* U+8e5d */
  0x0000, /* U+8e5e */
  0x90d6, /* U+8e5f */
  0xe747, /* U+8e60 */
  0x0000, /* U+8e61 */
  0x0000, /* U+8e62 */
  0xe749, /* U+8e63 */
  0xe746, /* U+8e64 */
  0x0000, /* U+8e65 */
  0x0000, /* U+8e66 */
  0x0000, /* U+8e67 */
  0x0000, /* U+8e68 */
  0x0000, /* U+8e69 */
  0x0000, /* U+8e6a */
  0x0000, /* U+8e6b */
  0x0000, /* U+8e6c */
  0x0000, /* U+8e6d */
  0x0000, /* U+8e6e */
  0x0000, /* U+8e6f */
  0x0000, /* U+8e70 */
  0x0000, /* U+8e71 */
  0xe74c, /* U+8e72 */
  0x0000, /* U+8e73 */
  0x8f52, /* U+8e74 */
  0x0000, /* U+8e75 */
  0xe74b, /* U+8e76 */
  0x0000, /* U+8e77 */
  0x0000, /* U+8e78 */
  0x0000, /* U+8e79 */
  0x0000, /* U+8e7a */
  0x0000, /* U+8e7b */
  0xe74d, /* U+8e7c */
  0x0000, /* U+8e7d */
  0x0000, /* U+8e7e */
  0x0000, /* U+8e7f */
  0x0000, /* U+8e80 */
  0xe74e, /* U+8e81 */
  0x0000, /* U+8e82 */
  0x0000, /* U+8e83 */
  0xe751, /* U+8e84 */
  0xe750, /* U+8e85 */
  0x0000, /* U+8e86 */
  0xe74f, /* U+8e87 */
  0x0000, /* U+8e88 */
  0x0000, /* U+8e89 */
  0xe753, /* U+8e8a */
  0xe752, /* U+8e8b */
  0x0000, /* U+8e8c */
  0x96f4, /* U+8e8d */
  0x0000, /* U+8e8e */
  0x0000, /* U+8e8f */
  0x0000, /* U+8e90 */
  0xe755, /* U+8e91 */
  0x0000, /* U+8e92 */
  0xe754, /* U+8e93 */
  0xe756, /* U+8e94 */
  0x0000, /* U+8e95 */
  0x0000, /* U+8e96 */
  0x0000, /* U+8e97 */
  0x0000, /* U+8e98 */
  0xe757, /* U+8e99 */
  0x0000, /* U+8e9a */
  0x0000, /* U+8e9b */
  0x0000, /* U+8e9c */
  0x0000, /* U+8e9d */
  0x0000, /* U+8e9e */
  0x0000, /* U+8e9f */
  0x0000, /* U+8ea0 */
  0xe759, /* U+8ea1 */
  0x0000, /* U+8ea2 */
  0x0000, /* U+8ea3 */
  0x0000, /* U+8ea4 */
  0x0000, /* U+8ea5 */
  0x0000, /* U+8ea6 */
  0x0000, /* U+8ea7 */
  0x0000, /* U+8ea8 */
  0x0000, /* U+8ea9 */
  0xe758, /* U+8eaa */
  0x9067, /* U+8eab */
  0xe75a, /* U+8eac */
  0x0000, /* U+8ead */
  0x0000, /* U+8eae */
  0x8beb, /* U+8eaf */
  0xe75b, /* U+8eb0 */
  0xe75d, /* U+8eb1 */
  0x0000, /* U+8eb2 */
  0x0000, /* U+8eb3 */
  0x0000, /* U+8eb4 */
  0x0000, /* U+8eb5 */
  0x0000, /* U+8eb6 */
  0x0000, /* U+8eb7 */
  0x0000, /* U+8eb8 */
  0x0000, /* U+8eb9 */
  0x0000, /* U+8eba */
  0x0000, /* U+8ebb */
  0x0000, /* U+8ebc */
  0x0000, /* U+8ebd */
  0xe75e, /* U+8ebe */
  0x0000, /* U+8ebf */
  0x0000, /* U+8ec0 */
  0x0000, /* U+8ec1 */
  0x0000, /* U+8ec2 */
  0x0000, /* U+8ec3 */
  0x0000, /* U+8ec4 */
  0xe75f, /* U+8ec5 */
  0xe75c, /* U+8ec6 */
  0x0000, /* U+8ec7 */
  0xe760, /* U+8ec8 */
  0x0000, /* U+8ec9 */
  0x8ed4, /* U+8eca */
  0xe761, /* U+8ecb */
  0x8b4f, /* U+8ecc */
  0x8c52, /* U+8ecd */
  0x0000, /* U+8ece */
  0xfbb2, /* U+8ecf */
  0x0000, /* U+8ed0 */
  0x0000, /* U+8ed1 */
  0x8cac, /* U+8ed2 */
  0x0000, /* U+8ed3 */
  0x0000, /* U+8ed4 */
  0x0000, /* U+8ed5 */
  0x0000, /* U+8ed6 */
  0x0000, /* U+8ed7 */
  0x0000, /* U+8ed8 */
  0x0000, /* U+8ed9 */
  0x0000, /* U+8eda */
  0xe762, /* U+8edb */
  0x0000, /* U+8edc */
  0x0000, /* U+8edd */
  0x0000, /* U+8ede */
  0x93ee, /* U+8edf */
  0x0000, /* U+8ee0 */
  0x0000, /* U+8ee1 */
  0x935d, /* U+8ee2 */
  0xe763, /* U+8ee3 */
  0x0000, /* U+8ee4 */
  0x0000, /* U+8ee5 */
  0x0000, /* U+8ee6 */
  0x0000, /* U+8ee7 */
  0x0000, /* U+8ee8 */
  0x0000, /* U+8ee9 */
  0x0000, /* U+8eea */
  0xe766, /* U+8eeb */
  0x0000, /* U+8eec */
  0x0000, /* U+8eed */
  0x0000, /* U+8eee */
  0x0000, /* U+8eef */
  0x0000, /* U+8ef0 */
  0x0000, /* U+8ef1 */
  0x0000, /* U+8ef2 */
  0x0000, /* U+8ef3 */
  0x0000, /* U+8ef4 */
  0x0000, /* U+8ef5 */
  0x0000, /* U+8ef6 */
  0x0000, /* U+8ef7 */
  0x8eb2, /* U+8ef8 */
  0x0000, /* U+8ef9 */
  0x0000, /* U+8efa */
  0xe765, /* U+8efb */
  0xe764, /* U+8efc */
  0x8c79, /* U+8efd */
  0xe767, /* U+8efe */
  0x0000, /* U+8eff */
  0x0000, /* U+8f00 */
  0x0000, /* U+8f01 */
  0x0000, /* U+8f02 */
  0x8a72, /* U+8f03 */
  0x0000, /* U+8f04 */
  0xe769, /* U+8f05 */
  0x0000, /* U+8f06 */
  0x0000, /* U+8f07 */
  0x0000, /* U+8f08 */
  0x8dda, /* U+8f09 */
  0xe768, /* U+8f0a */
  0x0000, /* U+8f0b */
  0xe771, /* U+8f0c */
  0x0000, /* U+8f0d */
  0x0000, /* U+8f0e */
  0x0000, /* U+8f0f */
  0x0000, /* U+8f10 */
  0x0000, /* U+8f11 */
  0xe76b, /* U+8f12 */
  0xe76d, /* U+8f13 */
  0x95e3, /* U+8f14 */
  0xe76a, /* U+8f15 */
  0x0000, /* U+8f16 */
  0x0000, /* U+8f17 */
  0x0000, /* U+8f18 */
  0xe76c, /* U+8f19 */
  0x0000, /* U+8f1a */
  0xe770, /* U+8f1b */
  0xe76e, /* U+8f1c */
  0x8b50, /* U+8f1d */
  0x0000, /* U+8f1e */
  0xe76f, /* U+8f1f */
  0x0000, /* U+8f20 */
  0x0000, /* U+8f21 */
  0x0000, /* U+8f22 */
  0x0000, /* U+8f23 */
  0x0000, /* U+8f24 */
  0x0000, /* U+8f25 */
  0xe772, /* U+8f26 */
  0x0000, /* U+8f27 */
  0x0000, /* U+8f28 */
  0x9479, /* U+8f29 */
  0x97d6, /* U+8f2a */
  0x0000, /* U+8f2b */
  0x0000, /* U+8f2c */
  0x0000, /* U+8f2d */
  0x0000, /* U+8f2e */
  0x8f53, /* U+8f2f */
  0x0000, /* U+8f30 */
  0x0000, /* U+8f31 */
  0x0000, /* U+8f32 */
  0xe773, /* U+8f33 */
  0x0000, /* U+8f34 */
  0x0000, /* U+8f35 */
  0x0000, /* U+8f36 */
  0x0000, /* U+8f37 */
  0x9741, /* U+8f38 */
  0xe775, /* U+8f39 */
  0x0000, /* U+8f3a */
  0xe774, /* U+8f3b */
  0x0000, /* U+8f3c */
  0x0000, /* U+8f3d */
  0xe778, /* U+8f3e */
  0x9760, /* U+8f3f */
  0x0000, /* U+8f40 */
  0x0000, /* U+8f41 */
  0xe777, /* U+8f42 */
  0x0000, /* U+8f43 */
  0x8a8d, /* U+8f44 */
  0xe776, /* U+8f45 */
  0xe77b, /* U+8f46 */
  0x0000, /* U+8f47 */
  0x0000, /* U+8f48 */
  0xe77a, /* U+8f49 */
  0x0000, /* U+8f4a */
  0x0000, /* U+8f4b */
  0xe779, /* U+8f4c */
  0x9351, /* U+8f4d */
  0xe77c, /* U+8f4e */
  0x0000, /* U+8f4f */
  0x0000, /* U+8f50 */
  0x0000, /* U+8f51 */
  0x0000, /* U+8f52 */
  0x0000, /* U+8f53 */
  0x0000, /* U+8f54 */
  0x0000, /* U+8f55 */
  0x0000, /* U+8f56 */
  0xe77d, /* U+8f57 */
  0x0000, /* U+8f58 */
  0x0000, /* U+8f59 */
  0x0000, /* U+8f5a */
  0x0000, /* U+8f5b */
  0xe77e, /* U+8f5c */
  0x0000, /* U+8f5d */
  0x0000, /* U+8f5e */
  0x8d8c, /* U+8f5f */
  0x0000, /* U+8f60 */
  0x8c44, /* U+8f61 */
  0xe780, /* U+8f62 */
  0xe781, /* U+8f63 */
  0xe782, /* U+8f64 */
  0x0000, /* U+8f65 */
  0x0000, /* U+8f66 */
  0x0000, /* U+8f67 */
  0x0000, /* U+8f68 */
  0x0000, /* U+8f69 */
  0x0000, /* U+8f6a */
  0x0000, /* U+8f6b */
  0x0000, /* U+8f6c */
  0x0000, /* U+8f6d */
  0x0000, /* U+8f6e */
  0x0000, /* U+8f6f */
  0x0000, /* U+8f70 */
  0x0000, /* U+8f71 */
  0x0000, /* U+8f72 */
  0x0000, /* U+8f73 */
  0x0000, /* U+8f74 */
  0x0000, /* U+8f75 */
  0x0000, /* U+8f76 */
  0x0000, /* U+8f77 */
  0x0000, /* U+8f78 */
  0x0000, /* U+8f79 */
  0x0000, /* U+8f7a */
  0x0000, /* U+8f7b */
  0x0000, /* U+8f7c */
  0x0000, /* U+8f7d */
  0x0000, /* U+8f7e */
  0x0000, /* U+8f7f */
  0x0000, /* U+8f80 */
  0x0000, /* U+8f81 */
  0x0000, /* U+8f82 */
  0x0000, /* U+8f83 */
  0x0000, /* U+8f84 */
  0x0000, /* U+8f85 */
  0x0000, /* U+8f86 */
  0x0000, /* U+8f87 */
  0x0000, /* U+8f88 */
  0x0000, /* U+8f89 */
  0x0000, /* U+8f8a */
  0x0000, /* U+8f8b */
  0x0000, /* U+8f8c */
  0x0000, /* U+8f8d */
  0x0000, /* U+8f8e */
  0x0000, /* U+8f8f */
  0x0000, /* U+8f90 */
  0x0000, /* U+8f91 */
  0x0000, /* U+8f92 */
  0x0000, /* U+8f93 */
  0x0000, /* U+8f94 */
  0x0000, /* U+8f95 */
  0x0000, /* U+8f96 */
  0x0000, /* U+8f97 */
  0x0000, /* U+8f98 */
  0x0000, /* U+8f99 */
  0x0000, /* U+8f9a */
  0x9068, /* U+8f9b */
  0xe783, /* U+8f9c */
  0x0000, /* U+8f9d */
  0x8eab, /* U+8f9e */
  0xe784, /* U+8f9f */
  0x0000, /* U+8fa0 */
  0x0000, /* U+8fa1 */
  0x0000, /* U+8fa2 */
  0xe785, /* U+8fa3 */
  0x0000, /* U+8fa4 */
  0x0000, /* U+8fa5 */
  0x0000, /* U+8fa6 */
  0x999f, /* U+8fa7 */
  0x999e, /* U+8fa8 */
  0x0000, /* U+8fa9 */
  0x0000, /* U+8faa */
  0x0000, /* U+8fab */
  0x0000, /* U+8fac */
  0xe786, /* U+8fad */
  0xe390, /* U+8fae */
  0xe787, /* U+8faf */
  0x9243, /* U+8fb0 */
  0x904a, /* U+8fb1 */
  0x945f, /* U+8fb2 */
  0x0000, /* U+8fb3 */
  0x0000, /* U+8fb4 */
  0x0000, /* U+8fb5 */
  0x0000, /* U+8fb6 */
  0xe788, /* U+8fb7 */
  0x0000, /* U+8fb8 */
  0x0000, /* U+8fb9 */
  0x95d3, /* U+8fba */
  0x92d2, /* U+8fbb */
  0x8d9e, /* U+8fbc */
  0x0000, /* U+8fbd */
  0x0000, /* U+8fbe */
  0x9248, /* U+8fbf */
  0x0000, /* U+8fc0 */
  0x0000, /* U+8fc1 */
  0x8949, /* U+8fc2 */
  0x0000, /* U+8fc3 */
  0x9698, /* U+8fc4 */
  0x9076, /* U+8fc5 */
  0x0000, /* U+8fc6 */
  0x0000, /* U+8fc7 */
  0x0000, /* U+8fc8 */
  0x0000, /* U+8fc9 */
  0x0000, /* U+8fca */
  0x0000, /* U+8fcb */
  0x0000, /* U+8fcc */
  0x0000, /* U+8fcd */
  0x8c7d, /* U+8fce */
  0x0000, /* U+8fcf */
  0x0000, /* U+8fd0 */
  0x8bdf, /* U+8fd1 */
  0x0000, /* U+8fd2 */
  0x0000, /* U+8fd3 */
  0x95d4, /* U+8fd4 */
  0x0000, /* U+8fd5 */
  0x0000, /* U+8fd6 */
  0x0000, /* U+8fd7 */
  0x0000, /* U+8fd8 */
  0x0000, /* U+8fd9 */
  0xe789, /* U+8fda */
  0x0000, /* U+8fdb */
  0x0000, /* U+8fdc */
  0x0000, /* U+8fdd */
  0x0000, /* U+8fde */
  0x0000, /* U+8fdf */
  0x0000, /* U+8fe0 */
  0x0000, /* U+8fe1 */
  0xe78b, /* U+8fe2 */
  0x0000, /* U+8fe3 */
  0x0000, /* U+8fe4 */
  0xe78a, /* U+8fe5 */
  0x89de, /* U+8fe6 */
  0x0000, /* U+8fe7 */
  0x0000, /* U+8fe8 */
  0x93f4, /* U+8fe9 */
  0xe78c, /* U+8fea */
  0x9497, /* U+8feb */
  0x0000, /* U+8fec */
  0x9352, /* U+8fed */
  0x0000, /* U+8fee */
  0xe78d, /* U+8fef */
  0x8f71, /* U+8ff0 */
  0x0000, /* U+8ff1 */
  0x0000, /* U+8ff2 */
  0x0000, /* U+8ff3 */
  0xe78f, /* U+8ff4 */
  0x0000, /* U+8ff5 */
  0x0000, /* U+8ff6 */
  0x96c0, /* U+8ff7 */
  0xe79e, /* U+8ff8 */
  0xe791, /* U+8ff9 */
  0xe792, /* U+8ffa */
  0x0000, /* U+8ffb */
  0x0000, /* U+8ffc */
  0x92c7, /* U+8ffd */
  0x0000, /* U+8ffe */
  0x0000, /* U+8fff */
  0x91de, /* U+9000 */
  0x9197, /* U+9001 */
  0x0000, /* U+9002 */
  0x93a6, /* U+9003 */
  0x0000, /* U+9004 */
  0xe790, /* U+9005 */
  0x8b74, /* U+9006 */
  0x0000, /* U+9007 */
  0x0000, /* U+9008 */
  0x0000, /* U+9009 */
  0x0000, /* U+900a */
  0xe799, /* U+900b */
  0x0000, /* U+900c */
  0xe796, /* U+900d */
  0xe7a3, /* U+900e */
  0x93a7, /* U+900f */
  0x9280, /* U+9010 */
  0xe793, /* U+9011 */
  0x0000, /* U+9012 */
  0x92fc, /* U+9013 */
  0x9372, /* U+9014 */
  0xe794, /* U+9015 */
  0xe798, /* U+9016 */
  0x9080, /* U+9017 */
  0x0000, /* U+9018 */
  0x9487, /* U+9019 */
  0x92ca, /* U+901a */
  0x0000, /* U+901b */
  0x0000, /* U+901c */
  0x90c0, /* U+901d */
  0xe797, /* U+901e */
  0x91ac, /* U+901f */
  0x91a2, /* U+9020 */
  0xe795, /* U+9021 */
  0x88a7, /* U+9022 */
  0x9841, /* U+9023 */
  0x0000, /* U+9024 */
  0x0000, /* U+9025 */
  0x0000, /* U+9026 */
  0xe79a, /* U+9027 */
  0x0000, /* U+9028 */
  0x0000, /* U+9029 */
  0x0000, /* U+902a */
  0x0000, /* U+902b */
  0x0000, /* U+902c */
  0x0000, /* U+902d */
  0x91df, /* U+902e */
  0x0000, /* U+902f */
  0x0000, /* U+9030 */
  0x8f54, /* U+9031 */
  0x9069, /* U+9032 */
  0x0000, /* U+9033 */
  0x0000, /* U+9034 */
  0xe79c, /* U+9035 */
  0xe79b, /* U+9036 */
  0x0000, /* U+9037 */
  0x88ed, /* U+9038 */
  0xe79d, /* U+9039 */
  0x0000, /* U+903a */
  0x0000, /* U+903b */
  0x954e, /* U+903c */
  0x0000, /* U+903d */
  0xe7a5, /* U+903e */
  0x0000, /* U+903f */
  0x0000, /* U+9040 */
  0x93d9, /* U+9041 */
  0x908b, /* U+9042 */
  0x0000, /* U+9043 */
  0x0000, /* U+9044 */
  0x9278, /* U+9045 */
  0x0000, /* U+9046 */
  0x8bf6, /* U+9047 */
  0x0000, /* U+9048 */
  0xe7a4, /* U+9049 */
  0x9756, /* U+904a */
  0x895e, /* U+904b */
  0x0000, /* U+904c */
  0x95d5, /* U+904d */
  0x89df, /* U+904e */
  0xe79f, /* U+904f */
  0xe7a0, /* U+9050 */
  0xe7a1, /* U+9051 */
  0xe7a2, /* U+9052 */
  0x93b9, /* U+9053 */
  0x9242, /* U+9054 */
  0x88e1, /* U+9055 */
  0xe7a6, /* U+9056 */
  0x0000, /* U+9057 */
  0xe7a7, /* U+9058 */
  0xeaa1, /* U+9059 */
  0x0000, /* U+905a */
  0x0000, /* U+905b */
  0x91bb, /* U+905c */
  0x0000, /* U+905d */
  0xe7a8, /* U+905e */
  0x0000, /* U+905f */
  0x8993, /* U+9060 */
  0x916b, /* U+9061 */
  0x0000, /* U+9062 */
  0x8cad, /* U+9063 */
  0x0000, /* U+9064 */
  0x9779, /* U+9065 */
  0x0000, /* U+9066 */
  0xfbb5, /* U+9067 */
  0xe7a9, /* U+9068 */
  0x934b, /* U+9069 */
  0x0000, /* U+906a */
  0x0000, /* U+906b */
  0x0000, /* U+906c */
  0x9198, /* U+906d */
  0x8ed5, /* U+906e */
  0xe7aa, /* U+906f */
  0x0000, /* U+9070 */
  0x0000, /* U+9071 */
  0xe7ad, /* U+9072 */
  0x0000, /* U+9073 */
  0x0000, /* U+9074 */
  0x8f85, /* U+9075 */
  0xe7ab, /* U+9076 */
  0x914a, /* U+9077 */
  0x9149, /* U+9078 */
  0x0000, /* U+9079 */
  0x88e2, /* U+907a */
  0x0000, /* U+907b */
  0x97c9, /* U+907c */
  0xe7af, /* U+907d */
  0x0000, /* U+907e */
  0x94f0, /* U+907f */
  0xe7b1, /* U+9080 */
  0xe7b0, /* U+9081 */
  0xe7ae, /* U+9082 */
  0xe284, /* U+9083 */
  0x8ad2, /* U+9084 */
  0x0000, /* U+9085 */
  0x0000, /* U+9086 */
  0xe78e, /* U+9087 */
  0x0000, /* U+9088 */
  0xe7b3, /* U+9089 */
  0xe7b2, /* U+908a */
  0x0000, /* U+908b */
  0x0000, /* U+908c */
  0x0000, /* U+908d */
  0x0000, /* U+908e */
  0xe7b4, /* U+908f */
  0x0000, /* U+9090 */
  0x9757, /* U+9091 */
  0x0000, /* U+9092 */
  0x0000, /* U+9093 */
  0x0000, /* U+9094 */
  0x0000, /* U+9095 */
  0x0000, /* U+9096 */
  0x0000, /* U+9097 */
  0x0000, /* U+9098 */
  0x0000, /* U+9099 */
  0x0000, /* U+909a */
  0x0000, /* U+909b */
  0x0000, /* U+909c */
  0x0000, /* U+909d */
  0x0000, /* U+909e */
  0x0000, /* U+909f */
  0x0000, /* U+90a0 */
  0x0000, /* U+90a1 */
  0x0000, /* U+90a2 */
  0x93df, /* U+90a3 */
  0x0000, /* U+90a4 */
  0x0000, /* U+90a5 */
  0x964d, /* U+90a6 */
  0x0000, /* U+90a7 */
  0xe7b5, /* U+90a8 */
  0x0000, /* U+90a9 */
  0x8ed7, /* U+90aa */
  0x0000, /* U+90ab */
  0x0000, /* U+90ac */
  0x0000, /* U+90ad */
  0x0000, /* U+90ae */
  0xe7b6, /* U+90af */
  0x0000, /* U+90b0 */
  0xe7b7, /* U+90b1 */
  0x0000, /* U+90b2 */
  0x0000, /* U+90b3 */
  0x0000, /* U+90b4 */
  0xe7b8, /* U+90b5 */
  0x0000, /* U+90b6 */
  0x0000, /* U+90b7 */
  0x9340, /* U+90b8 */
  0x0000, /* U+90b9 */
  0x0000, /* U+90ba */
  0x0000, /* U+90bb */
  0x0000, /* U+90bc */
  0x0000, /* U+90bd */
  0x0000, /* U+90be */
  0x0000, /* U+90bf */
  0x0000, /* U+90c0 */
  0x88e8, /* U+90c1 */
  0x0000, /* U+90c2 */
  0x0000, /* U+90c3 */
  0x0000, /* U+90c4 */
  0x0000, /* U+90c5 */
  0x0000, /* U+90c6 */
  0x0000, /* U+90c7 */
  0x0000, /* U+90c8 */
  0x0000, /* U+90c9 */
  0x8d78, /* U+90ca */
  0x0000, /* U+90cb */
  0x0000, /* U+90cc */
  0x0000, /* U+90cd */
  0x9859, /* U+90ce */
  0x0000, /* U+90cf */
  0x0000, /* U+90d0 */
  0x0000, /* U+90d1 */
  0x0000, /* U+90d2 */
  0x0000, /* U+90d3 */
  0x0000, /* U+90d4 */
  0x0000, /* U+90d5 */
  0x0000, /* U+90d6 */
  0x0000, /* U+90d7 */
  0x0000, /* U+90d8 */
  0x0000, /* U+90d9 */
  0x0000, /* U+90da */
  0xe7bc, /* U+90db */
  0x0000, /* U+90dc */
  0x0000, /* U+90dd */
  0xfbb6, /* U+90de */
  0x0000, /* U+90df */
  0x0000, /* U+90e0 */
  0x8c53, /* U+90e1 */
  0xe7b9, /* U+90e2 */
  0x0000, /* U+90e3 */
  0xe7ba, /* U+90e4 */
  0x0000, /* U+90e5 */
  0x0000, /* U+90e6 */
  0x0000, /* U+90e7 */
  0x9594, /* U+90e8 */
  0x0000, /* U+90e9 */
  0x0000, /* U+90ea */
  0x0000, /* U+90eb */
  0x0000, /* U+90ec */
  0x8a73, /* U+90ed */
  0x0000, /* U+90ee */
  0x0000, /* U+90ef */
  0x0000, /* U+90f0 */
  0x0000, /* U+90f1 */
  0x0000, /* U+90f2 */
  0x0000, /* U+90f3 */
  0x0000, /* U+90f4 */
  0x9758, /* U+90f5 */
  0x0000, /* U+90f6 */
  0x8bbd, /* U+90f7 */
  0x0000, /* U+90f8 */
  0x0000, /* U+90f9 */
  0x0000, /* U+90fa */
  0x0000, /* U+90fb */
  0x0000, /* U+90fc */
  0x9373, /* U+90fd */
  0x0000, /* U+90fe */
  0x0000, /* U+90ff */
  0x0000, /* U+9100 */
  0x0000, /* U+9101 */
  0xe7bd, /* U+9102 */
  0x0000, /* U+9103 */
  0x0000, /* U+9104 */
  0x0000, /* U+9105 */
  0x0000, /* U+9106 */
  0x0000, /* U+9107 */
  0x0000, /* U+9108 */
  0x0000, /* U+9109 */
  0x0000, /* U+910a */
  0x0000, /* U+910b */
  0x0000, /* U+910c */
  0x0000, /* U+910d */
  0x0000, /* U+910e */
  0x0000, /* U+910f */
  0x0000, /* U+9110 */
  0x0000, /* U+9111 */
  0xe7be, /* U+9112 */
  0x0000, /* U+9113 */
  0x0000, /* U+9114 */
  0xfbb8, /* U+9115 */
  0x0000, /* U+9116 */
  0x0000, /* U+9117 */
  0x0000, /* U+9118 */
  0xe7bf, /* U+9119 */
  0x0000, /* U+911a */
  0x0000, /* U+911b */
  0x0000, /* U+911c */
  0x0000, /* U+911d */
  0x0000, /* U+911e */
  0x0000, /* U+911f */
  0x0000, /* U+9120 */
  0x0000, /* U+9121 */
  0x0000, /* U+9122 */
  0x0000, /* U+9123 */
  0x0000, /* U+9124 */
  0x0000, /* U+9125 */
  0x0000, /* U+9126 */
  0xfbb9, /* U+9127 */
  0x0000, /* U+9128 */
  0x0000, /* U+9129 */
  0x0000, /* U+912a */
  0x0000, /* U+912b */
  0x0000, /* U+912c */
  0x9341, /* U+912d */
  0x0000, /* U+912e */
  0x0000, /* U+912f */
  0xe7c1, /* U+9130 */
  0x0000, /* U+9131 */
  0xe7c0, /* U+9132 */
  0x0000, /* U+9133 */
  0x0000, /* U+9134 */
  0x0000, /* U+9135 */
  0x0000, /* U+9136 */
  0x0000, /* U+9137 */
  0x0000, /* U+9138 */
  0x0000, /* U+9139 */
  0x0000, /* U+913a */
  0x0000, /* U+913b */
  0x0000, /* U+913c */
  0x0000, /* U+913d */
  0x0000, /* U+913e */
  0x0000, /* U+913f */
  0x0000, /* U+9140 */
  0x0000, /* U+9141 */
  0x0000, /* U+9142 */
  0x0000, /* U+9143 */
  0x0000, /* U+9144 */
  0x0000, /* U+9145 */
  0x0000, /* U+9146 */
  0x0000, /* U+9147 */
  0x0000, /* U+9148 */
  0x93d1, /* U+9149 */
  0xe7c2, /* U+914a */
  0x8f55, /* U+914b */
  0x8ede, /* U+914c */
  0x947a, /* U+914d */
  0x9291, /* U+914e */
  0x0000, /* U+914f */
  0x0000, /* U+9150 */
  0x0000, /* U+9151 */
  0x8ef0, /* U+9152 */
  0x0000, /* U+9153 */
  0x908c, /* U+9154 */
  0x0000, /* U+9155 */
  0xe7c3, /* U+9156 */
  0x0000, /* U+9157 */
  0xe7c4, /* U+9158 */
  0x0000, /* U+9159 */
  0x0000, /* U+915a */
  0x0000, /* U+915b */
  0x0000, /* U+915c */
  0x0000, /* U+915d */
  0x0000, /* U+915e */
  0x0000, /* U+915f */
  0x0000, /* U+9160 */
  0x0000, /* U+9161 */
  0x907c, /* U+9162 */
  0xe7c5, /* U+9163 */
  0x0000, /* U+9164 */
  0xe7c6, /* U+9165 */
  0x0000, /* U+9166 */
  0x0000, /* U+9167 */
  0x0000, /* U+9168 */
  0xe7c7, /* U+9169 */
  0x978f, /* U+916a */
  0x0000, /* U+916b */
  0x8f56, /* U+916c */
  0x0000, /* U+916d */
  0x0000, /* U+916e */
  0x0000, /* U+916f */
  0x0000, /* U+9170 */
  0x0000, /* U+9171 */
  0xe7c9, /* U+9172 */
  0xe7c8, /* U+9173 */
  0x0000, /* U+9174 */
  0x8d79, /* U+9175 */
  0x0000, /* U+9176 */
  0x8d93, /* U+9177 */
  0x8e5f, /* U+9178 */
  0x0000, /* U+9179 */
  0x0000, /* U+917a */
  0x0000, /* U+917b */
  0x0000, /* U+917c */
  0x0000, /* U+917d */
  0x0000, /* U+917e */
  0x0000, /* U+917f */
  0x0000, /* U+9180 */
  0x0000, /* U+9181 */
  0xe7cc, /* U+9182 */
  0x0000, /* U+9183 */
  0x0000, /* U+9184 */
  0x0000, /* U+9185 */
  0x0000, /* U+9186 */
  0x8f86, /* U+9187 */
  0x0000, /* U+9188 */
  0xe7cb, /* U+9189 */
  0x0000, /* U+918a */
  0xe7ca, /* U+918b */
  0x0000, /* U+918c */
  0x91e7, /* U+918d */
  0x0000, /* U+918e */
  0x0000, /* U+918f */
  0x8ced, /* U+9190 */
  0x0000, /* U+9191 */
  0x90c1, /* U+9192 */
  0x0000, /* U+9193 */
  0x0000, /* U+9194 */
  0x0000, /* U+9195 */
  0x0000, /* U+9196 */
  0x94ae, /* U+9197 */
  0x0000, /* U+9198 */
  0x0000, /* U+9199 */
  0x0000, /* U+919a */
  0x0000, /* U+919b */
  0x8f58, /* U+919c */
  0x0000, /* U+919d */
  0x0000, /* U+919e */
  0x0000, /* U+919f */
  0x0000, /* U+91a0 */
  0x0000, /* U+91a1 */
  0xe7cd, /* U+91a2 */
  0x0000, /* U+91a3 */
  0x8fdd, /* U+91a4 */
  0x0000, /* U+91a5 */
  0x0000, /* U+91a6 */
  0x0000, /* U+91a7 */
  0x0000, /* U+91a8 */
  0x0000, /* U+91a9 */
  0xe7d0, /* U+91aa */
  0xe7ce, /* U+91ab */
  0x0000, /* U+91ac */
  0x0000, /* U+91ad */
  0x0000, /* U+91ae */
  0xe7cf, /* U+91af */
  0x0000, /* U+91b0 */
  0x0000, /* U+91b1 */
  0x0000, /* U+91b2 */
  0x0000, /* U+91b3 */
  0xe7d2, /* U+91b4 */
  0xe7d1, /* U+91b5 */
  0x0000, /* U+91b6 */
  0x0000, /* U+91b7 */
  0x8ff8, /* U+91b8 */
  0x0000, /* U+91b9 */
  0xe7d3, /* U+91ba */
  0x0000, /* U+91bb */
  0x0000, /* U+91bc */
  0x0000, /* U+91bd */
  0x0000, /* U+91be */
  0x0000, /* U+91bf */
  0xe7d4, /* U+91c0 */
  0xe7d5, /* U+91c1 */
  0x0000, /* U+91c2 */
  0x0000, /* U+91c3 */
  0x0000, /* U+91c4 */
  0x0000, /* U+91c5 */
  0x94ce, /* U+91c6 */
  0x8dd1, /* U+91c7 */
  0x8edf, /* U+91c8 */
  0xe7d6, /* U+91c9 */
  0x0000, /* U+91ca */
  0xe7d7, /* U+91cb */
  0x97a2, /* U+91cc */
  0x8f64, /* U+91cd */
  0x96ec, /* U+91ce */
  0x97ca, /* U+91cf */
  0xe7d8, /* U+91d0 */
  0x8be0, /* U+91d1 */
  0x0000, /* U+91d2 */
  0x0000, /* U+91d3 */
  0x0000, /* U+91d4 */
  0x0000, /* U+91d5 */
  0xe7d9, /* U+91d6 */
  0xfbbb, /* U+91d7 */
  0x9342, /* U+91d8 */
  0x0000, /* U+91d9 */
  0xfbba, /* U+91da */
  0xe7dc, /* U+91db */
  0x8a98, /* U+91dc */
  0x906a, /* U+91dd */
  0xfbbc, /* U+91de */
  0xe7da, /* U+91df */
  0x0000, /* U+91e0 */
  0xe7db, /* U+91e1 */
  0x0000, /* U+91e2 */
  0x92de, /* U+91e3 */
  0xfbbf, /* U+91e4 */
  0xfbc0, /* U+91e5 */
  0x9674, /* U+91e6 */
  0x8bfa, /* U+91e7 */
  0x0000, /* U+91e8 */
  0x0000, /* U+91e9 */
  0x0000, /* U+91ea */
  0x0000, /* U+91eb */
  0x0000, /* U+91ec */
  0xfbbd, /* U+91ed */
  0xfbbe, /* U+91ee */
  0x0000, /* U+91ef */
  0x0000, /* U+91f0 */
  0x0000, /* U+91f1 */
  0x0000, /* U+91f2 */
  0x0000, /* U+91f3 */
  0x0000, /* U+91f4 */
  0xe7de, /* U+91f5 */
  0xe7df, /* U+91f6 */
  0x0000, /* U+91f7 */
  0x0000, /* U+91f8 */
  0x0000, /* U+91f9 */
  0x0000, /* U+91fa */
  0x0000, /* U+91fb */
  0xe7dd, /* U+91fc */
  0x0000, /* U+91fd */
  0x0000, /* U+91fe */
  0xe7e1, /* U+91ff */
  0x0000, /* U+9200 */
  0x0000, /* U+9201 */
  0x0000, /* U+9202 */
  0x0000, /* U+9203 */
  0x0000, /* U+9204 */
  0x0000, /* U+9205 */
  0xfbc1, /* U+9206 */
  0x0000, /* U+9207 */
  0x0000, /* U+9208 */
  0x0000, /* U+9209 */
  0xfbc3, /* U+920a */
  0x0000, /* U+920b */
  0x0000, /* U+920c */
  0x93dd, /* U+920d */
  0x8a62, /* U+920e */
  0x0000, /* U+920f */
  0xfbc2, /* U+9210 */
  0xe7e5, /* U+9211 */
  0x0000, /* U+9212 */
  0x0000, /* U+9213 */
  0xe7e2, /* U+9214 */
  0xe7e4, /* U+9215 */
  0x0000, /* U+9216 */
  0x0000, /* U+9217 */
  0x0000, /* U+9218 */
  0x0000, /* U+9219 */
  0x0000, /* U+921a */
  0x0000, /* U+921b */
  0x0000, /* U+921c */
  0x0000, /* U+921d */
  0xe7e0, /* U+921e */
  0x0000, /* U+921f */
  0x0000, /* U+9220 */
  0x0000, /* U+9221 */
  0x0000, /* U+9222 */
  0x0000, /* U+9223 */
  0x0000, /* U+9224 */
  0x0000, /* U+9225 */
  0x0000, /* U+9226 */
  0x0000, /* U+9227 */
  0x0000, /* U+9228 */
  0xe86e, /* U+9229 */
  0x0000, /* U+922a */
  0x0000, /* U+922b */
  0xe7e3, /* U+922c */
  0x0000, /* U+922d */
  0x0000, /* U+922e */
  0x0000, /* U+922f */
  0x0000, /* U+9230 */
  0x0000, /* U+9231 */
  0x0000, /* U+9232 */
  0x0000, /* U+9233 */
  0x97e9, /* U+9234 */
  0x0000, /* U+9235 */
  0x0000, /* U+9236 */
  0x8cd8, /* U+9237 */
  0x0000, /* U+9238 */
  0xfbca, /* U+9239 */
  0xfbc4, /* U+923a */
  0x0000, /* U+923b */
  0xfbc6, /* U+923c */
  0x0000, /* U+923d */
  0x0000, /* U+923e */
  0xe7ed, /* U+923f */
  0xfbc5, /* U+9240 */
  0x0000, /* U+9241 */
  0x0000, /* U+9242 */
  0x0000, /* U+9243 */
  0x9353, /* U+9244 */
  0xe7e8, /* U+9245 */
  0x0000, /* U+9246 */
  0x0000, /* U+9247 */
  0xe7eb, /* U+9248 */
  0xe7e9, /* U+9249 */
  0x0000, /* U+924a */
  0xe7ee, /* U+924b */
  0x0000, /* U+924c */
  0x0000, /* U+924d */
  0xfbc7, /* U+924e */
  0x0000, /* U+924f */
  0xe7ef, /* U+9250 */
  0xfbc9, /* U+9251 */
  0x0000, /* U+9252 */
  0x0000, /* U+9253 */
  0x0000, /* U+9254 */
  0x0000, /* U+9255 */
  0x0000, /* U+9256 */
  0xe7e7, /* U+9257 */
  0x0000, /* U+9258 */
  0xfbc8, /* U+9259 */
  0xe7f4, /* U+925a */
  0x8994, /* U+925b */
  0x0000, /* U+925c */
  0x0000, /* U+925d */
  0xe7e6, /* U+925e */
  0x0000, /* U+925f */
  0x0000, /* U+9260 */
  0x0000, /* U+9261 */
  0x94ab, /* U+9262 */
  0x0000, /* U+9263 */
  0xe7ea, /* U+9264 */
  0x0000, /* U+9265 */
  0x8fde, /* U+9266 */
  0xfbcb, /* U+9267 */
  0x0000, /* U+9268 */
  0x0000, /* U+9269 */
  0x0000, /* U+926a */
  0x0000, /* U+926b */
  0x0000, /* U+926c */
  0x0000, /* U+926d */
  0x0000, /* U+926e */
  0x0000, /* U+926f */
  0x0000, /* U+9270 */
  0x8d7a, /* U+9271 */
  0x0000, /* U+9272 */
  0x0000, /* U+9273 */
  0x0000, /* U+9274 */
  0x0000, /* U+9275 */
  0x0000, /* U+9276 */
  0xfbcd, /* U+9277 */
  0xfbce, /* U+9278 */
  0x0000, /* U+9279 */
  0x0000, /* U+927a */
  0x0000, /* U+927b */
  0x0000, /* U+927c */
  0x0000, /* U+927d */
  0x9667, /* U+927e */
  0x0000, /* U+927f */
  0x8be2, /* U+9280 */
  0x0000, /* U+9281 */
  0x0000, /* U+9282 */
  0x8f65, /* U+9283 */
  0x0000, /* U+9284 */
  0x93ba, /* U+9285 */
  0x0000, /* U+9286 */
  0x0000, /* U+9287 */
  0xfa5f, /* U+9288 */
  0x0000, /* U+9289 */
  0x0000, /* U+928a */
  0x0000, /* U+928b */
  0x0000, /* U+928c */
  0x0000, /* U+928d */
  0x0000, /* U+928e */
  0x0000, /* U+928f */
  0x0000, /* U+9290 */
  0x914c, /* U+9291 */
  0x0000, /* U+9292 */
  0xe7f2, /* U+9293 */
  0x0000, /* U+9294 */
  0xe7ec, /* U+9295 */
  0xe7f1, /* U+9296 */
  0x0000, /* U+9297 */
  0x96c1, /* U+9298 */
  0x0000, /* U+9299 */
  0x92b6, /* U+929a */
  0xe7f3, /* U+929b */
  0xe7f0, /* U+929c */
  0x0000, /* U+929d */
  0x0000, /* U+929e */
  0x0000, /* U+929f */
  0x0000, /* U+92a0 */
  0x0000, /* U+92a1 */
  0x0000, /* U+92a2 */
  0x0000, /* U+92a3 */
  0x0000, /* U+92a4 */
  0x0000, /* U+92a5 */
  0x0000, /* U+92a6 */
  0xfbcc, /* U+92a7 */
  0x0000, /* U+92a8 */
  0x0000, /* U+92a9 */
  0x0000, /* U+92aa */
  0x0000, /* U+92ab */
  0x0000, /* U+92ac */
  0x914b, /* U+92ad */
  0x0000, /* U+92ae */
  0x0000, /* U+92af */
  0x0000, /* U+92b0 */
  0x0000, /* U+92b1 */
  0x0000, /* U+92b2 */
  0x0000, /* U+92b3 */
  0x0000, /* U+92b4 */
  0x0000, /* U+92b5 */
  0x0000, /* U+92b6 */
  0xe7f7, /* U+92b7 */
  0x0000, /* U+92b8 */
  0xe7f6, /* U+92b9 */
  0x0000, /* U+92ba */
  0x0000, /* U+92bb */
  0x0000, /* U+92bc */
  0x0000, /* U+92bd */
  0x0000, /* U+92be */
  0x0000, /* U+92bf */
  0x0000, /* U+92c0 */
  0x0000, /* U+92c1 */
  0x0000, /* U+92c2 */
  0x0000, /* U+92c3 */
  0x0000, /* U+92c4 */
  0x0000, /* U+92c5 */
  0x0000, /* U+92c6 */
  0x0000, /* U+92c7 */
  0x0000, /* U+92c8 */
  0x0000, /* U+92c9 */
  0x0000, /* U+92ca */
  0x0000, /* U+92cb */
  0x0000, /* U+92cc */
  0x0000, /* U+92cd */
  0x0000, /* U+92ce */
  0xe7f5, /* U+92cf */
  0xfbd2, /* U+92d0 */
  0x0000, /* U+92d1 */
  0x964e, /* U+92d2 */
  0xfbd6, /* U+92d3 */
  0x0000, /* U+92d4 */
  0xfbd4, /* U+92d5 */
  0x0000, /* U+92d6 */
  0xfbd0, /* U+92d7 */
  0x0000, /* U+92d8 */
  0xfbd1, /* U+92d9 */
  0x0000, /* U+92da */
  0x0000, /* U+92db */
  0x0000, /* U+92dc */
  0x0000, /* U+92dd */
  0x0000, /* U+92de */
  0x0000, /* U+92df */
  0xfbd5, /* U+92e0 */
  0x0000, /* U+92e1 */
  0x0000, /* U+92e2 */
  0x0000, /* U+92e3 */
  0x8f9b, /* U+92e4 */
  0x0000, /* U+92e5 */
  0x0000, /* U+92e6 */
  0xfbcf, /* U+92e7 */
  0x0000, /* U+92e8 */
  0xe7f8, /* U+92e9 */
  0x95dd, /* U+92ea */
  0x0000, /* U+92eb */
  0x0000, /* U+92ec */
  0x8973, /* U+92ed */
  0x0000, /* U+92ee */
  0x0000, /* U+92ef */
  0x0000, /* U+92f0 */
  0x0000, /* U+92f1 */
  0x9565, /* U+92f2 */
  0x9292, /* U+92f3 */
  0x0000, /* U+92f4 */
  0x0000, /* U+92f5 */
  0x0000, /* U+92f6 */
  0x0000, /* U+92f7 */
  0x8b98, /* U+92f8 */
  0xfa65, /* U+92f9 */
  0xe7fa, /* U+92fa */
  0xfbd9, /* U+92fb */
  0x8d7c, /* U+92fc */
  0x0000, /* U+92fd */
  0x0000, /* U+92fe */
  0xfbdc, /* U+92ff */
  0x0000, /* U+9300 */
  0x0000, /* U+9301 */
  0xfbde, /* U+9302 */
  0x0000, /* U+9303 */
  0x0000, /* U+9304 */
  0x0000, /* U+9305 */
  0x8e4b, /* U+9306 */
  0x0000, /* U+9307 */
  0x0000, /* U+9308 */
  0x0000, /* U+9309 */
  0x0000, /* U+930a */
  0x0000, /* U+930b */
  0x0000, /* U+930c */
  0x0000, /* U+930d */
  0x0000, /* U+930e */
  0xe7f9, /* U+930f */
  0x908d, /* U+9310 */
  0x0000, /* U+9311 */
  0x0000, /* U+9312 */
  0x0000, /* U+9313 */
  0x0000, /* U+9314 */
  0x0000, /* U+9315 */
  0x0000, /* U+9316 */
  0x0000, /* U+9317 */
  0x908e, /* U+9318 */
  0xe840, /* U+9319 */
  0xe842, /* U+931a */
  0x0000, /* U+931b */
  0x0000, /* U+931c */
  0xfbdd, /* U+931d */
  0xfbdb, /* U+931e */
  0x0000, /* U+931f */
  0x8ff9, /* U+9320 */
  0xfbd8, /* U+9321 */
  0xe841, /* U+9322 */
  0xe843, /* U+9323 */
  0x0000, /* U+9324 */
  0xfbd7, /* U+9325 */
  0x8bd1, /* U+9326 */
  0x0000, /* U+9327 */
  0x9564, /* U+9328 */
  0x0000, /* U+9329 */
  0x0000, /* U+932a */
  0x8ee0, /* U+932b */
  0x9842, /* U+932c */
  0x0000, /* U+932d */
  0xe7fc, /* U+932e */
  0x8df6, /* U+932f */
  0x0000, /* U+9330 */
  0x0000, /* U+9331 */
  0x985e, /* U+9332 */
  0x0000, /* U+9333 */
  0x0000, /* U+9334 */
  0xe845, /* U+9335 */
  0x0000, /* U+9336 */
  0x0000, /* U+9337 */
  0x0000, /* U+9338 */
  0x0000, /* U+9339 */
  0xe844, /* U+933a */
  0xe846, /* U+933b */
  0x0000, /* U+933c */
  0x0000, /* U+933d */
  0x0000, /* U+933e */
  0x0000, /* U+933f */
  0x0000, /* U+9340 */
  0x0000, /* U+9341 */
  0x0000, /* U+9342 */
  0x0000, /* U+9343 */
  0xe7fb, /* U+9344 */
  0x0000, /* U+9345 */
  0x0000, /* U+9346 */
  0x0000, /* U+9347 */
  0xfa5e, /* U+9348 */
  0x0000, /* U+9349 */
  0x0000, /* U+934a */
  0x93e7, /* U+934b */
  0x0000, /* U+934c */
  0x9374, /* U+934d */
  0x0000, /* U+934e */
  0x0000, /* U+934f */
  0x0000, /* U+9350 */
  0x0000, /* U+9351 */
  0x0000, /* U+9352 */
  0x0000, /* U+9353 */
  0x92d5, /* U+9354 */
  0x0000, /* U+9355 */
  0xe84b, /* U+9356 */
  0xfbe0, /* U+9357 */
  0x0000, /* U+9358 */
  0x0000, /* U+9359 */
  0x0000, /* U+935a */
  0x9262, /* U+935b */
  0xe847, /* U+935c */
  0x0000, /* U+935d */
  0x0000, /* U+935e */
  0x0000, /* U+935f */
  0xe848, /* U+9360 */
  0x0000, /* U+9361 */
  0x0000, /* U+9362 */
  0x0000, /* U+9363 */
  0x0000, /* U+9364 */
  0x0000, /* U+9365 */
  0x0000, /* U+9366 */
  0x0000, /* U+9367 */
  0x0000, /* U+9368 */
  0x0000, /* U+9369 */
  0x0000, /* U+936a */
  0x0000, /* U+936b */
  0x8c4c, /* U+936c */
  0x0000, /* U+936d */
  0xe84a, /* U+936e */
  0x0000, /* U+936f */
  0xfbdf, /* U+9370 */
  0x0000, /* U+9371 */
  0x0000, /* U+9372 */
  0x0000, /* U+9373 */
  0x0000, /* U+9374 */
  0x8cae, /* U+9375 */
  0x0000, /* U+9376 */
  0x0000, /* U+9377 */
  0x0000, /* U+9378 */
  0x0000, /* U+9379 */
  0x0000, /* U+937a */
  0x0000, /* U+937b */
  0xe849, /* U+937c */
  0x0000, /* U+937d */
  0x8fdf, /* U+937e */
  0x0000, /* U+937f */
  0x0000, /* U+9380 */
  0x0000, /* U+9381 */
  0x0000, /* U+9382 */
  0x0000, /* U+9383 */
  0x0000, /* U+9384 */
  0x0000, /* U+9385 */
  0x0000, /* U+9386 */
  0x0000, /* U+9387 */
  0x0000, /* U+9388 */
  0x0000, /* U+9389 */
  0x0000, /* U+938a */
  0x0000, /* U+938b */
  0x8a99, /* U+938c */
  0x0000, /* U+938d */
  0x0000, /* U+938e */
  0x0000, /* U+938f */
  0x0000, /* U+9390 */
  0x0000, /* U+9391 */
  0x0000, /* U+9392 */
  0x0000, /* U+9393 */
  0xe84f, /* U+9394 */
  0x0000, /* U+9395 */
  0x8dbd, /* U+9396 */
  0x9199, /* U+9397 */
  0x0000, /* U+9398 */
  0x0000, /* U+9399 */
  0x92c8, /* U+939a */
  0x0000, /* U+939b */
  0x0000, /* U+939c */
  0x0000, /* U+939d */
  0x0000, /* U+939e */
  0x0000, /* U+939f */
  0x0000, /* U+93a0 */
  0x0000, /* U+93a1 */
  0x0000, /* U+93a2 */
  0x0000, /* U+93a3 */
  0xfbe1, /* U+93a4 */
  0x0000, /* U+93a5 */
  0x0000, /* U+93a6 */
  0x8a5a, /* U+93a7 */
  0x0000, /* U+93a8 */
  0x0000, /* U+93a9 */
  0x0000, /* U+93aa */
  0x0000, /* U+93ab */
  0xe84d, /* U+93ac */
  0xe84e, /* U+93ad */
  0x92c1, /* U+93ae */
  0x0000, /* U+93af */
  0xe84c, /* U+93b0 */
  0x0000, /* U+93b1 */
  0x0000, /* U+93b2 */
  0x0000, /* U+93b3 */
  0x0000, /* U+93b4 */
  0x0000, /* U+93b5 */
  0x0000, /* U+93b6 */
  0x0000, /* U+93b7 */
  0x0000, /* U+93b8 */
  0xe850, /* U+93b9 */
  0x0000, /* U+93ba */
  0x0000, /* U+93bb */
  0x0000, /* U+93bc */
  0x0000, /* U+93bd */
  0x0000, /* U+93be */
  0x0000, /* U+93bf */
  0x0000, /* U+93c0 */
  0x0000, /* U+93c1 */
  0x0000, /* U+93c2 */
  0xe856, /* U+93c3 */
  0x0000, /* U+93c4 */
  0x0000, /* U+93c5 */
  0xfbe2, /* U+93c6 */
  0x0000, /* U+93c7 */
  0xe859, /* U+93c8 */
  0x0000, /* U+93c9 */
  0x0000, /* U+93ca */
  0x0000, /* U+93cb */
  0x0000, /* U+93cc */
  0x0000, /* U+93cd */
  0x0000, /* U+93ce */
  0x0000, /* U+93cf */
  0xe858, /* U+93d0 */
  0x934c, /* U+93d1 */
  0x0000, /* U+93d2 */
  0x0000, /* U+93d3 */
  0x0000, /* U+93d4 */
  0x0000, /* U+93d5 */
  0xe851, /* U+93d6 */
  0xe852, /* U+93d7 */
  0xe855, /* U+93d8 */
  0x0000, /* U+93d9 */
  0x0000, /* U+93da */
  0x0000, /* U+93db */
  0x0000, /* U+93dc */
  0xe857, /* U+93dd */
  0xfbe3, /* U+93de */
  0x0000, /* U+93df */
  0x0000, /* U+93e0 */
  0x8bbe, /* U+93e1 */
  0x0000, /* U+93e2 */
  0x0000, /* U+93e3 */
  0xe85a, /* U+93e4 */
  0xe854, /* U+93e5 */
  0x0000, /* U+93e6 */
  0x0000, /* U+93e7 */
  0xe853, /* U+93e8 */
  0x0000, /* U+93e9 */
  0x0000, /* U+93ea */
  0x0000, /* U+93eb */
  0x0000, /* U+93ec */
  0x0000, /* U+93ed */
  0x0000, /* U+93ee */
  0x0000, /* U+93ef */
  0x0000, /* U+93f0 */
  0x0000, /* U+93f1 */
  0x0000, /* U+93f2 */
  0x0000, /* U+93f3 */
  0x0000, /* U+93f4 */
  0x0000, /* U+93f5 */
  0x0000, /* U+93f6 */
  0x0000, /* U+93f7 */
  0xfbe4, /* U+93f8 */
  0x0000, /* U+93f9 */
  0x0000, /* U+93fa */
  0x0000, /* U+93fb */
  0x0000, /* U+93fc */
  0x0000, /* U+93fd */
  0x0000, /* U+93fe */
  0x0000, /* U+93ff */
  0x0000, /* U+9400 */
  0x0000, /* U+9401 */
  0x0000, /* U+9402 */
  0xe85e, /* U+9403 */
  0x0000, /* U+9404 */
  0x0000, /* U+9405 */
  0x0000, /* U+9406 */
  0xe85f, /* U+9407 */
  0x0000, /* U+9408 */
  0x0000, /* U+9409 */
  0x0000, /* U+940a */
  0x0000, /* U+940b */
  0x0000, /* U+940c */
  0x0000, /* U+940d */
  0x0000, /* U+940e */
  0x0000, /* U+940f */
  0xe860, /* U+9410 */
  0x0000, /* U+9411 */
  0x0000, /* U+9412 */
  0xe85d, /* U+9413 */
  0xe85c, /* U+9414 */
  0x0000, /* U+9415 */
  0x0000, /* U+9416 */
  0x0000, /* U+9417 */
  0x8fe0, /* U+9418 */
  0x93a8, /* U+9419 */
  0xe85b, /* U+941a */
  0x0000, /* U+941b */
  0x0000, /* U+941c */
  0x0000, /* U+941d */
  0x0000, /* U+941e */
  0x0000, /* U+941f */
  0x0000, /* U+9420 */
  0xe864, /* U+9421 */
  0x0000, /* U+9422 */
  0x0000, /* U+9423 */
  0x0000, /* U+9424 */
  0x0000, /* U+9425 */
  0x0000, /* U+9426 */
  0x0000, /* U+9427 */
  0x0000, /* U+9428 */
  0x0000, /* U+9429 */
  0x0000, /* U+942a */
  0xe862, /* U+942b */
  0x0000, /* U+942c */
  0x0000, /* U+942d */
  0x0000, /* U+942e */
  0x0000, /* U+942f */
  0x0000, /* U+9430 */
  0xfbe5, /* U+9431 */
  0x0000, /* U+9432 */
  0x0000, /* U+9433 */
  0x0000, /* U+9434 */
  0xe863, /* U+9435 */
  0xe861, /* U+9436 */
  0x0000, /* U+9437 */
  0x91f6, /* U+9438 */
  0x0000, /* U+9439 */
  0xe865, /* U+943a */
  0x0000, /* U+943b */
  0x0000, /* U+943c */
  0x0000, /* U+943d */
  0x0000, /* U+943e */
  0x0000, /* U+943f */
  0x0000, /* U+9440 */
  0xe866, /* U+9441 */
  0x0000, /* U+9442 */
  0x0000, /* U+9443 */
  0xe868, /* U+9444 */
  0xfbe6, /* U+9445 */
  0x0000, /* U+9446 */
  0x0000, /* U+9447 */
  0xfbe7, /* U+9448 */
  0x0000, /* U+9449 */
  0x0000, /* U+944a */
  0x0000, /* U+944b */
  0x0000, /* U+944c */
  0x0000, /* U+944d */
  0x0000, /* U+944e */
  0x0000, /* U+944f */
  0x0000, /* U+9450 */
  0x8ad3, /* U+9451 */
  0xe867, /* U+9452 */
  0x96f8, /* U+9453 */
  0x0000, /* U+9454 */
  0x0000, /* U+9455 */
  0x0000, /* U+9456 */
  0x0000, /* U+9457 */
  0x0000, /* U+9458 */
  0x0000, /* U+9459 */
  0xe873, /* U+945a */
  0xe869, /* U+945b */
  0x0000, /* U+945c */
  0x0000, /* U+945d */
  0xe86c, /* U+945e */
  0x0000, /* U+945f */
  0xe86a, /* U+9460 */
  0x0000, /* U+9461 */
  0xe86b, /* U+9462 */
  0x0000, /* U+9463 */
  0x0000, /* U+9464 */
  0x0000, /* U+9465 */
  0x0000, /* U+9466 */
  0x0000, /* U+9467 */
  0x0000, /* U+9468 */
  0x0000, /* U+9469 */
  0xe86d, /* U+946a */
  0x0000, /* U+946b */
  0x0000, /* U+946c */
  0x0000, /* U+946d */
  0x0000, /* U+946e */
  0x0000, /* U+946f */
  0xe86f, /* U+9470 */
  0x0000, /* U+9471 */
  0x0000, /* U+9472 */
  0x0000, /* U+9473 */
  0x0000, /* U+9474 */
  0xe870, /* U+9475 */
  0x0000, /* U+9476 */
  0xe871, /* U+9477 */
  0x0000, /* U+9478 */
  0x0000, /* U+9479 */
  0x0000, /* U+947a */
  0x0000, /* U+947b */
  0xe874, /* U+947c */
  0xe872, /* U+947d */
  0xe875, /* U+947e */
  0xe877, /* U+947f */
  0x0000, /* U+9480 */
  0xe876, /* U+9481 */
  0x0000, /* U+9482 */
  0x0000, /* U+9483 */
  0x0000, /* U+9484 */
  0x0000, /* U+9485 */
  0x0000, /* U+9486 */
  0x0000, /* U+9487 */
  0x0000, /* U+9488 */
  0x0000, /* U+9489 */
  0x0000, /* U+948a */
  0x0000, /* U+948b */
  0x0000, /* U+948c */
  0x0000, /* U+948d */
  0x0000, /* U+948e */
  0x0000, /* U+948f */
  0x0000, /* U+9490 */
  0x0000, /* U+9491 */
  0x0000, /* U+9492 */
  0x0000, /* U+9493 */
  0x0000, /* U+9494 */
  0x0000, /* U+9495 */
  0x0000, /* U+9496 */
  0x0000, /* U+9497 */
  0x0000, /* U+9498 */
  0x0000, /* U+9499 */
  0x0000, /* U+949a */
  0x0000, /* U+949b */
  0x0000, /* U+949c */
  0x0000, /* U+949d */
  0x0000, /* U+949e */
  0x0000, /* U+949f */
  0x0000, /* U+94a0 */
  0x0000, /* U+94a1 */
  0x0000, /* U+94a2 */
  0x0000, /* U+94a3 */
  0x0000, /* U+94a4 */
  0x0000, /* U+94a5 */
  0x0000, /* U+94a6 */
  0x0000, /* U+94a7 */
  0x0000, /* U+94a8 */
  0x0000, /* U+94a9 */
  0x0000, /* U+94aa */
  0x0000, /* U+94ab */
  0x0000, /* U+94ac */
  0x0000, /* U+94ad */
  0x0000, /* U+94ae */
  0x0000, /* U+94af */
  0x0000, /* U+94b0 */
  0x0000, /* U+94b1 */
  0x0000, /* U+94b2 */
  0x0000, /* U+94b3 */
  0x0000, /* U+94b4 */
  0x0000, /* U+94b5 */
  0x0000, /* U+94b6 */
  0x0000, /* U+94b7 */
  0x0000, /* U+94b8 */
  0x0000, /* U+94b9 */
  0x0000, /* U+94ba */
  0x0000, /* U+94bb */
  0x0000, /* U+94bc */
  0x0000, /* U+94bd */
  0x0000, /* U+94be */
  0x0000, /* U+94bf */
  0x0000, /* U+94c0 */
  0x0000, /* U+94c1 */
  0x0000, /* U+94c2 */
  0x0000, /* U+94c3 */
  0x0000, /* U+94c4 */
  0x0000, /* U+94c5 */
  0x0000, /* U+94c6 */
  0x0000, /* U+94c7 */
  0x0000, /* U+94c8 */
  0x0000, /* U+94c9 */
  0x0000, /* U+94ca */
  0x0000, /* U+94cb */
  0x0000, /* U+94cc */
  0x0000, /* U+94cd */
  0x0000, /* U+94ce */
  0x0000, /* U+94cf */
  0x0000, /* U+94d0 */
  0x0000, /* U+94d1 */
  0x0000, /* U+94d2 */
  0x0000, /* U+94d3 */
  0x0000, /* U+94d4 */
  0x0000, /* U+94d5 */
  0x0000, /* U+94d6 */
  0x0000, /* U+94d7 */
  0x0000, /* U+94d8 */
  0x0000, /* U+94d9 */
  0x0000, /* U+94da */
  0x0000, /* U+94db */
  0x0000, /* U+94dc */
  0x0000, /* U+94dd */
  0x0000, /* U+94de */
  0x0000, /* U+94df */
  0x0000, /* U+94e0 */
  0x0000, /* U+94e1 */
  0x0000, /* U+94e2 */
  0x0000, /* U+94e3 */
  0x0000, /* U+94e4 */
  0x0000, /* U+94e5 */
  0x0000, /* U+94e6 */
  0x0000, /* U+94e7 */
  0x0000, /* U+94e8 */
  0x0000, /* U+94e9 */
  0x0000, /* U+94ea */
  0x0000, /* U+94eb */
  0x0000, /* U+94ec */
  0x0000, /* U+94ed */
  0x0000, /* U+94ee */
  0x0000, /* U+94ef */
  0x0000, /* U+94f0 */
  0x0000, /* U+94f1 */
  0x0000, /* U+94f2 */
  0x0000, /* U+94f3 */
  0x0000, /* U+94f4 */
  0x0000, /* U+94f5 */
  0x0000, /* U+94f6 */
  0x0000, /* U+94f7 */
  0x0000, /* U+94f8 */
  0x0000, /* U+94f9 */
  0x0000, /* U+94fa */
  0x0000, /* U+94fb */
  0x0000, /* U+94fc */
  0x0000, /* U+94fd */
  0x0000, /* U+94fe */
  0x0000, /* U+94ff */
  0x0000, /* U+9500 */
  0x0000, /* U+9501 */
  0x0000, /* U+9502 */
  0x0000, /* U+9503 */
  0x0000, /* U+9504 */
  0x0000, /* U+9505 */
  0x0000, /* U+9506 */
  0x0000, /* U+9507 */
  0x0000, /* U+9508 */
  0x0000, /* U+9509 */
  0x0000, /* U+950a */
  0x0000, /* U+950b */
  0x0000, /* U+950c */
  0x0000, /* U+950d */
  0x0000, /* U+950e */
  0x0000, /* U+950f */
  0x0000, /* U+9510 */
  0x0000, /* U+9511 */
  0x0000, /* U+9512 */
  0x0000, /* U+9513 */
  0x0000, /* U+9514 */
  0x0000, /* U+9515 */
  0x0000, /* U+9516 */
  0x0000, /* U+9517 */
  0x0000, /* U+9518 */
  0x0000, /* U+9519 */
  0x0000, /* U+951a */
  0x0000, /* U+951b */
  0x0000, /* U+951c */
  0x0000, /* U+951d */
  0x0000, /* U+951e */
  0x0000, /* U+951f */
  0x0000, /* U+9520 */
  0x0000, /* U+9521 */
  0x0000, /* U+9522 */
  0x0000, /* U+9523 */
  0x0000, /* U+9524 */
  0x0000, /* U+9525 */
  0x0000, /* U+9526 */
  0x0000, /* U+9527 */
  0x0000, /* U+9528 */
  0x0000, /* U+9529 */
  0x0000, /* U+952a */
  0x0000, /* U+952b */
  0x0000, /* U+952c */
  0x0000, /* U+952d */
  0x0000, /* U+952e */
  0x0000, /* U+952f */
  0x0000, /* U+9530 */
  0x0000, /* U+9531 */
  0x0000, /* U+9532 */
  0x0000, /* U+9533 */
  0x0000, /* U+9534 */
  0x0000, /* U+9535 */
  0x0000, /* U+9536 */
  0x0000, /* U+9537 */
  0x0000, /* U+9538 */
  0x0000, /* U+9539 */
  0x0000, /* U+953a */
  0x0000, /* U+953b */
  0x0000, /* U+953c */
  0x0000, /* U+953d */
  0x0000, /* U+953e */
  0x0000, /* U+953f */
  0x0000, /* U+9540 */
  0x0000, /* U+9541 */
  0x0000, /* U+9542 */
  0x0000, /* U+9543 */
  0x0000, /* U+9544 */
  0x0000, /* U+9545 */
  0x0000, /* U+9546 */
  0x0000, /* U+9547 */
  0x0000, /* U+9548 */
  0x0000, /* U+9549 */
  0x0000, /* U+954a */
  0x0000, /* U+954b */
  0x0000, /* U+954c */
  0x0000, /* U+954d */
  0x0000, /* U+954e */
  0x0000, /* U+954f */
  0x0000, /* U+9550 */
  0x0000, /* U+9551 */
  0x0000, /* U+9552 */
  0x0000, /* U+9553 */
  0x0000, /* U+9554 */
  0x0000, /* U+9555 */
  0x0000, /* U+9556 */
  0x0000, /* U+9557 */
  0x0000, /* U+9558 */
  0x0000, /* U+9559 */
  0x0000, /* U+955a */
  0x0000, /* U+955b */
  0x0000, /* U+955c */
  0x0000, /* U+955d */
  0x0000, /* U+955e */
  0x0000, /* U+955f */
  0x0000, /* U+9560 */
  0x0000, /* U+9561 */
  0x0000, /* U+9562 */
  0x0000, /* U+9563 */
  0x0000, /* U+9564 */
  0x0000, /* U+9565 */
  0x0000, /* U+9566 */
  0x0000, /* U+9567 */
  0x0000, /* U+9568 */
  0x0000, /* U+9569 */
  0x0000, /* U+956a */
  0x0000, /* U+956b */
  0x0000, /* U+956c */
  0x0000, /* U+956d */
  0x0000, /* U+956e */
  0x0000, /* U+956f */
  0x0000, /* U+9570 */
  0x0000, /* U+9571 */
  0x0000, /* U+9572 */
  0x0000, /* U+9573 */
  0x0000, /* U+9574 */
  0x0000, /* U+9575 */
  0x0000, /* U+9576 */
  0x92b7, /* U+9577 */
  0x0000, /* U+9578 */
  0x0000, /* U+9579 */
  0x0000, /* U+957a */
  0x0000, /* U+957b */
  0x0000, /* U+957c */
  0x0000, /* U+957d */
  0x0000, /* U+957e */
  0x0000, /* U+957f */
  0x96e5, /* U+9580 */
  0x0000, /* U+9581 */
  0xe878, /* U+9582 */
  0x914d, /* U+9583 */
  0x0000, /* U+9584 */
  0x0000, /* U+9585 */
  0x0000, /* U+9586 */
  0xe879, /* U+9587 */
  0x0000, /* U+9588 */
  0x95c2, /* U+9589 */
  0xe87a, /* U+958a */
  0x8a4a, /* U+958b */
  0x0000, /* U+958c */
  0x0000, /* U+958d */
  0x0000, /* U+958e */
  0x895b, /* U+958f */
  0x0000, /* U+9590 */
  0x8ad5, /* U+9591 */
  0xfbe8, /* U+9592 */
  0x8ad4, /* U+9593 */
  0xe87b, /* U+9594 */
  0x0000, /* U+9595 */
  0xe87c, /* U+9596 */
  0x0000, /* U+9597 */
  0xe87d, /* U+9598 */
  0xe87e, /* U+9599 */
  0x0000, /* U+959a */
  0x0000, /* U+959b */
  0x0000, /* U+959c */
  0x0000, /* U+959d */
  0x0000, /* U+959e */
  0x0000, /* U+959f */
  0xe880, /* U+95a0 */
  0x0000, /* U+95a1 */
  0x8ad6, /* U+95a2 */
  0x8a74, /* U+95a3 */
  0x8d7d, /* U+95a4 */
  0x94b4, /* U+95a5 */
  0x0000, /* U+95a6 */
  0xe882, /* U+95a7 */
  0xe881, /* U+95a8 */
  0x0000, /* U+95a9 */
  0x0000, /* U+95aa */
  0x0000, /* U+95ab */
  0x0000, /* U+95ac */
  0xe883, /* U+95ad */
  0x0000, /* U+95ae */
  0x0000, /* U+95af */
  0x0000, /* U+95b0 */
  0x0000, /* U+95b1 */
  0x897b, /* U+95b2 */
  0x0000, /* U+95b3 */
  0x0000, /* U+95b4 */
  0x0000, /* U+95b5 */
  0x0000, /* U+95b6 */
  0x0000, /* U+95b7 */
  0x0000, /* U+95b8 */
  0xe886, /* U+95b9 */
  0x0000, /* U+95ba */
  0xe885, /* U+95bb */
  0xe884, /* U+95bc */
  0x0000, /* U+95bd */
  0xe887, /* U+95be */
  0x0000, /* U+95bf */
  0x0000, /* U+95c0 */
  0x0000, /* U+95c1 */
  0x0000, /* U+95c2 */
  0xe88a, /* U+95c3 */
  0x0000, /* U+95c4 */
  0x0000, /* U+95c5 */
  0x0000, /* U+95c6 */
  0x88c5, /* U+95c7 */
  0x0000, /* U+95c8 */
  0x0000, /* U+95c9 */
  0xe888, /* U+95ca */
  0x0000, /* U+95cb */
  0xe88c, /* U+95cc */
  0xe88b, /* U+95cd */
  0x0000, /* U+95ce */
  0x0000, /* U+95cf */
  0x0000, /* U+95d0 */
  0x0000, /* U+95d1 */
  0x0000, /* U+95d2 */
  0x0000, /* U+95d3 */
  0xe88e, /* U+95d4 */
  0xe88d, /* U+95d5 */
  0xe88f, /* U+95d6 */
  0x0000, /* U+95d7 */
  0x93ac, /* U+95d8 */
  0x0000, /* U+95d9 */
  0x0000, /* U+95da */
  0x0000, /* U+95db */
  0xe890, /* U+95dc */
  0x0000, /* U+95dd */
  0x0000, /* U+95de */
  0x0000, /* U+95df */
  0x0000, /* U+95e0 */
  0xe891, /* U+95e1 */
  0xe893, /* U+95e2 */
  0x0000, /* U+95e3 */
  0x0000, /* U+95e4 */
  0xe892, /* U+95e5 */
  0x0000, /* U+95e6 */
  0x0000, /* U+95e7 */
  0x0000, /* U+95e8 */
  0x0000, /* U+95e9 */
  0x0000, /* U+95ea */
  0x0000, /* U+95eb */
  0x0000, /* U+95ec */
  0x0000, /* U+95ed */
  0x0000, /* U+95ee */
  0x0000, /* U+95ef */
  0x0000, /* U+95f0 */
  0x0000, /* U+95f1 */
  0x0000, /* U+95f2 */
  0x0000, /* U+95f3 */
  0x0000, /* U+95f4 */
  0x0000, /* U+95f5 */
  0x0000, /* U+95f6 */
  0x0000, /* U+95f7 */
  0x0000, /* U+95f8 */
  0x0000, /* U+95f9 */
  0x0000, /* U+95fa */
  0x0000, /* U+95fb */
  0x0000, /* U+95fc */
  0x0000, /* U+95fd */
  0x0000, /* U+95fe */
  0x0000, /* U+95ff */
  0x0000, /* U+9600 */
  0x0000, /* U+9601 */
  0x0000, /* U+9602 */
  0x0000, /* U+9603 */
  0x0000, /* U+9604 */
  0x0000, /* U+9605 */
  0x0000, /* U+9606 */
  0x0000, /* U+9607 */
  0x0000, /* U+9608 */
  0x0000, /* U+9609 */
  0x0000, /* U+960a */
  0x0000, /* U+960b */
  0x0000, /* U+960c */
  0x0000, /* U+960d */
  0x0000, /* U+960e */
  0x0000, /* U+960f */
  0x0000, /* U+9610 */
  0x0000, /* U+9611 */
  0x0000, /* U+9612 */
  0x0000, /* U+9613 */
  0x0000, /* U+9614 */
  0x0000, /* U+9615 */
  0x0000, /* U+9616 */
  0x0000, /* U+9617 */
  0x0000, /* U+9618 */
  0x0000, /* U+9619 */
  0x0000, /* U+961a */
  0x0000, /* U+961b */
  0x958c, /* U+961c */
  0x0000, /* U+961d */
  0x0000, /* U+961e */
  0x0000, /* U+961f */
  0x0000, /* U+9620 */
  0xe894, /* U+9621 */
  0x0000, /* U+9622 */
  0x0000, /* U+9623 */
  0x0000, /* U+9624 */
  0x0000, /* U+9625 */
  0x0000, /* U+9626 */
  0x0000, /* U+9627 */
  0xe895, /* U+9628 */
  0x0000, /* U+9629 */
  0x8de3, /* U+962a */
  0x0000, /* U+962b */
  0x0000, /* U+962c */
  0x0000, /* U+962d */
  0xe896, /* U+962e */
  0xe897, /* U+962f */
  0x0000, /* U+9630 */
  0x0000, /* U+9631 */
  0x9668, /* U+9632 */
  0x0000, /* U+9633 */
  0x0000, /* U+9634 */
  0x0000, /* U+9635 */
  0x0000, /* U+9636 */
  0x0000, /* U+9637 */
  0x0000, /* U+9638 */
  0x0000, /* U+9639 */
  0x0000, /* U+963a */
  0x916a, /* U+963b */
  0x0000, /* U+963c */
  0x0000, /* U+963d */
  0x0000, /* U+963e */
  0x88a2, /* U+963f */
  0x91c9, /* U+9640 */
  0x0000, /* U+9641 */
  0xe898, /* U+9642 */
  0x0000, /* U+9643 */
  0x958d, /* U+9644 */
  0x0000, /* U+9645 */
  0x0000, /* U+9646 */
  0x0000, /* U+9647 */
  0x0000, /* U+9648 */
  0x0000, /* U+9649 */
  0x0000, /* U+964a */
  0xe89b, /* U+964b */
  0xe899, /* U+964c */
  0x8d7e, /* U+964d */
  0x0000, /* U+964e */
  0xe89a, /* U+964f */
  0x8cc0, /* U+9650 */
  0x0000, /* U+9651 */
  0x0000, /* U+9652 */
  0x0000, /* U+9653 */
  0x0000, /* U+9654 */
  0x0000, /* U+9655 */
  0x0000, /* U+9656 */
  0x0000, /* U+9657 */
  0x0000, /* U+9658 */
  0x0000, /* U+9659 */
  0x0000, /* U+965a */
  0x95c3, /* U+965b */
  0xe89d, /* U+965c */
  0xe89f, /* U+965d */
  0xe89e, /* U+965e */
  0xe8a0, /* U+965f */
  0x0000, /* U+9660 */
  0x0000, /* U+9661 */
  0x8940, /* U+9662 */
  0x9077, /* U+9663 */
  0x8f9c, /* U+9664 */
  0x8ad7, /* U+9665 */
  0xe8a1, /* U+9666 */
  0x0000, /* U+9667 */
  0x0000, /* U+9668 */
  0x0000, /* U+9669 */
  0x9486, /* U+966a */
  0x0000, /* U+966b */
  0xe8a3, /* U+966c */
  0x0000, /* U+966d */
  0x0000, /* U+966e */
  0x0000, /* U+966f */
  0x8941, /* U+9670 */
  0x0000, /* U+9671 */
  0xe8a2, /* U+9672 */
  0x92c2, /* U+9673 */
  0x0000, /* U+9674 */
  0x97cb, /* U+9675 */
  0x93a9, /* U+9676 */
  0xe89c, /* U+9677 */
  0x97a4, /* U+9678 */
  0x0000, /* U+9679 */
  0x8caf, /* U+967a */
  0x0000, /* U+967b */
  0x0000, /* U+967c */
  0x977a, /* U+967d */
  0x0000, /* U+967e */
  0x0000, /* U+967f */
  0x0000, /* U+9680 */
  0x0000, /* U+9681 */
  0x0000, /* U+9682 */
  0x0000, /* U+9683 */
  0x0000, /* U+9684 */
  0x8bf7, /* U+9685 */
  0x97b2, /* U+9686 */
  0x0000, /* U+9687 */
  0x8c47, /* U+9688 */
  0x0000, /* U+9689 */
  0x91e0, /* U+968a */
  0xe440, /* U+968b */
  0x0000, /* U+968c */
  0xe8a4, /* U+968d */
  0x8a4b, /* U+968e */
  0x908f, /* U+968f */
  0x0000, /* U+9690 */
  0x0000, /* U+9691 */
  0x0000, /* U+9692 */
  0x0000, /* U+9693 */
  0x8a75, /* U+9694 */
  0xe8a6, /* U+9695 */
  0x0000, /* U+9696 */
  0xe8a7, /* U+9697 */
  0xe8a5, /* U+9698 */
  0x8c84, /* U+9699 */
  0x0000, /* U+969a */
  0x8ddb, /* U+969b */
  0x8fe1, /* U+969c */
  0xfbeb, /* U+969d */
  0x0000, /* U+969e */
  0x0000, /* U+969f */
  0x8942, /* U+96a0 */
  0x0000, /* U+96a1 */
  0x0000, /* U+96a2 */
  0x97d7, /* U+96a3 */
  0x0000, /* U+96a4 */
  0x0000, /* U+96a5 */
  0x0000, /* U+96a6 */
  0xe8a9, /* U+96a7 */
  0xe7ac, /* U+96a8 */
  0x0000, /* U+96a9 */
  0xe8a8, /* U+96aa */
  0x0000, /* U+96ab */
  0x0000, /* U+96ac */
  0x0000, /* U+96ad */
  0x0000, /* U+96ae */
  0xfbec, /* U+96af */
  0xe8ac, /* U+96b0 */
  0xe8aa, /* U+96b1 */
  0xe8ab, /* U+96b2 */
  0x0000, /* U+96b3 */
  0xe8ad, /* U+96b4 */
  0x0000, /* U+96b5 */
  0xe8ae, /* U+96b6 */
  0x97ea, /* U+96b7 */
  0xe8af, /* U+96b8 */
  0xe8b0, /* U+96b9 */
  0x0000, /* U+96ba */
  0x90c7, /* U+96bb */
  0x94b9, /* U+96bc */
  0x0000, /* U+96bd */
  0x0000, /* U+96be */
  0x0000, /* U+96bf */
  0x909d, /* U+96c0 */
  0x8ae5, /* U+96c1 */
  0x0000, /* U+96c2 */
  0x0000, /* U+96c3 */
  0x9759, /* U+96c4 */
  0x89eb, /* U+96c5 */
  0x8f57, /* U+96c6 */
  0x8cd9, /* U+96c7 */
  0x0000, /* U+96c8 */
  0xe8b3, /* U+96c9 */
  0x0000, /* U+96ca */
  0xe8b2, /* U+96cb */
  0x8e93, /* U+96cc */
  0xe8b4, /* U+96cd */
  0xe8b1, /* U+96ce */
  0x0000, /* U+96cf */
  0x0000, /* U+96d0 */
  0x8e47, /* U+96d1 */
  0x0000, /* U+96d2 */
  0x0000, /* U+96d3 */
  0x0000, /* U+96d4 */
  0xe8b8, /* U+96d5 */
  0xe5ab, /* U+96d6 */
  0x0000, /* U+96d7 */
  0x0000, /* U+96d8 */
  0x99d4, /* U+96d9 */
  0x0000, /* U+96da */
  0x9097, /* U+96db */
  0xe8b6, /* U+96dc */
  0x0000, /* U+96dd */
  0x0000, /* U+96de */
  0x0000, /* U+96df */
  0x0000, /* U+96e0 */
  0x0000, /* U+96e1 */
  0x97a3, /* U+96e2 */
  0x93ef, /* U+96e3 */
  0x0000, /* U+96e4 */
  0x0000, /* U+96e5 */
  0x0000, /* U+96e6 */
  0x0000, /* U+96e7 */
  0x894a, /* U+96e8 */
  0x0000, /* U+96e9 */
  0x90e1, /* U+96ea */
  0x8eb4, /* U+96eb */
  0x0000, /* U+96ec */
  0x0000, /* U+96ed */
  0x0000, /* U+96ee */
  0x0000, /* U+96ef */
  0x95b5, /* U+96f0 */
  0x0000, /* U+96f1 */
  0x895f, /* U+96f2 */
  0x0000, /* U+96f3 */
  0x0000, /* U+96f4 */
  0x0000, /* U+96f5 */
  0x97eb, /* U+96f6 */
  0x978b, /* U+96f7 */
  0x0000, /* U+96f8 */
  0xe8b9, /* U+96f9 */
  0x0000, /* U+96fa */
  0x9364, /* U+96fb */
  0x0000, /* U+96fc */
  0x0000, /* U+96fd */
  0x0000, /* U+96fe */
  0x0000, /* U+96ff */
  0x8ef9, /* U+9700 */
  0x0000, /* U+9701 */
  0x0000, /* U+9702 */
  0x0000, /* U+9703 */
  0xe8ba, /* U+9704 */
  0x0000, /* U+9705 */
  0xe8bb, /* U+9706 */
  0x906b, /* U+9707 */
  0xe8bc, /* U+9708 */
  0x0000, /* U+9709 */
  0x97ec, /* U+970a */
  0x0000, /* U+970b */
  0x0000, /* U+970c */
  0xe8b7, /* U+970d */
  0xe8be, /* U+970e */
  0xe8c0, /* U+970f */
  0x0000, /* U+9710 */
  0xe8bf, /* U+9711 */
  0x0000, /* U+9712 */
  0xe8bd, /* U+9713 */
  0x0000, /* U+9714 */
  0x0000, /* U+9715 */
  0xe8c1, /* U+9716 */
  0x0000, /* U+9717 */
  0x0000, /* U+9718 */
  0xe8c2, /* U+9719 */
  0x0000, /* U+971a */
  0x0000, /* U+971b */
  0x919a, /* U+971c */
  0x0000, /* U+971d */
  0x89e0, /* U+971e */
  0x0000, /* U+971f */
  0x0000, /* U+9720 */
  0x0000, /* U+9721 */
  0x0000, /* U+9722 */
  0x0000, /* U+9723 */
  0xe8c3, /* U+9724 */
  0x0000, /* U+9725 */
  0x0000, /* U+9726 */
  0x96b6, /* U+9727 */
  0x0000, /* U+9728 */
  0x0000, /* U+9729 */
  0xe8c4, /* U+972a */
  0x0000, /* U+972b */
  0x0000, /* U+972c */
  0x0000, /* U+972d */
  0x0000, /* U+972e */
  0x0000, /* U+972f */
  0xe8c5, /* U+9730 */
  0x0000, /* U+9731 */
  0x9849, /* U+9732 */
  0xfbed, /* U+9733 */
  0x0000, /* U+9734 */
  0x0000, /* U+9735 */
  0x0000, /* U+9736 */
  0x0000, /* U+9737 */
  0x9e50, /* U+9738 */
  0xe8c6, /* U+9739 */
  0x0000, /* U+973a */
  0xfbee, /* U+973b */
  0x0000, /* U+973c */
  0xe8c7, /* U+973d */
  0xe8c8, /* U+973e */
  0x0000, /* U+973f */
  0x0000, /* U+9740 */
  0x0000, /* U+9741 */
  0xe8cc, /* U+9742 */
  0xfbef, /* U+9743 */
  0xe8c9, /* U+9744 */
  0x0000, /* U+9745 */
  0xe8ca, /* U+9746 */
  0x0000, /* U+9747 */
  0xe8cb, /* U+9748 */
  0xe8cd, /* U+9749 */
  0x0000, /* U+974a */
  0x0000, /* U+974b */
  0x0000, /* U+974c */
  0xfbf0, /* U+974d */
  0x0000, /* U+974e */
  0xfbf1, /* U+974f */
  0x0000, /* U+9750 */
  0xfbf2, /* U+9751 */
  0x90c2, /* U+9752 */
  0x0000, /* U+9753 */
  0x0000, /* U+9754 */
  0xfbf3, /* U+9755 */
  0x96f5, /* U+9756 */
  0x0000, /* U+9757 */
  0x0000, /* U+9758 */
  0x90c3, /* U+9759 */
  0x0000, /* U+975a */
  0x0000, /* U+975b */
  0xe8ce, /* U+975c */
  0x0000, /* U+975d */
  0x94f1, /* U+975e */
  0x0000, /* U+975f */
  0xe8cf, /* U+9760 */
  0xea72, /* U+9761 */
  0x96ca, /* U+9762 */
  0x0000, /* U+9763 */
  0xe8d0, /* U+9764 */
  0x0000, /* U+9765 */
  0xe8d1, /* U+9766 */
  0x0000, /* U+9767 */
  0xe8d2, /* U+9768 */
  0x8a76, /* U+9769 */
  0x0000, /* U+976a */
  0xe8d4, /* U+976b */
  0x0000, /* U+976c */
  0x9078, /* U+976d */
  0x0000, /* U+976e */
  0x0000, /* U+976f */
  0x0000, /* U+9770 */
  0xe8d5, /* U+9771 */
  0x0000, /* U+9772 */
  0x0000, /* U+9773 */
  0x8c43, /* U+9774 */
  0x0000, /* U+9775 */
  0x0000, /* U+9776 */
  0x0000, /* U+9777 */
  0x0000, /* U+9778 */
  0xe8d6, /* U+9779 */
  0xe8da, /* U+977a */
  0x0000, /* U+977b */
  0xe8d8, /* U+977c */
  0x0000, /* U+977d */
  0x0000, /* U+977e */
  0x0000, /* U+977f */
  0x0000, /* U+9780 */
  0xe8d9, /* U+9781 */
  0x0000, /* U+9782 */
  0x0000, /* U+9783 */
  0x8a93, /* U+9784 */
  0xe8d7, /* U+9785 */
  0xe8db, /* U+9786 */
  0x0000, /* U+9787 */
  0x0000, /* U+9788 */
  0x0000, /* U+9789 */
  0x0000, /* U+978a */
  0xe8dc, /* U+978b */
  0x0000, /* U+978c */
  0x88c6, /* U+978d */
  0x0000, /* U+978e */
  0xe8dd, /* U+978f */
  0xe8de, /* U+9790 */
  0x0000, /* U+9791 */
  0x0000, /* U+9792 */
  0x0000, /* U+9793 */
  0x0000, /* U+9794 */
  0x0000, /* U+9795 */
  0x0000, /* U+9796 */
  0x0000, /* U+9797 */
  0x8fe2, /* U+9798 */
  0x0000, /* U+9799 */
  0x0000, /* U+979a */
  0x0000, /* U+979b */
  0xe8df, /* U+979c */
  0x0000, /* U+979d */
  0x0000, /* U+979e */
  0x0000, /* U+979f */
  0x8b66, /* U+97a0 */
  0x0000, /* U+97a1 */
  0x0000, /* U+97a2 */
  0xe8e2, /* U+97a3 */
  0x0000, /* U+97a4 */
  0x0000, /* U+97a5 */
  0xe8e1, /* U+97a6 */
  0x0000, /* U+97a7 */
  0xe8e0, /* U+97a8 */
  0x0000, /* U+97a9 */
  0x0000, /* U+97aa */
  0xe691, /* U+97ab */
  0x0000, /* U+97ac */
  0x95da, /* U+97ad */
  0x0000, /* U+97ae */
  0x0000, /* U+97af */
  0x0000, /* U+97b0 */
  0x0000, /* U+97b1 */
  0x0000, /* U+97b2 */
  0xe8e3, /* U+97b3 */
  0xe8e4, /* U+97b4 */
  0x0000, /* U+97b5 */
  0x0000, /* U+97b6 */
  0x0000, /* U+97b7 */
  0x0000, /* U+97b8 */
  0x0000, /* U+97b9 */
  0x0000, /* U+97ba */
  0x0000, /* U+97bb */
  0x0000, /* U+97bc */
  0x0000, /* U+97bd */
  0x0000, /* U+97be */
  0x0000, /* U+97bf */
  0x0000, /* U+97c0 */
  0x0000, /* U+97c1 */
  0x0000, /* U+97c2 */
  0xe8e5, /* U+97c3 */
  0x0000, /* U+97c4 */
  0x0000, /* U+97c5 */
  0xe8e6, /* U+97c6 */
  0x0000, /* U+97c7 */
  0xe8e7, /* U+97c8 */
  0x0000, /* U+97c9 */
  0x0000, /* U+97ca */
  0xe8e8, /* U+97cb */
  0x0000, /* U+97cc */
  0x0000, /* U+97cd */
  0x0000, /* U+97ce */
  0x0000, /* U+97cf */
  0x0000, /* U+97d0 */
  0x0000, /* U+97d1 */
  0x0000, /* U+97d2 */
  0x8ad8, /* U+97d3 */
  0x0000, /* U+97d4 */
  0x0000, /* U+97d5 */
  0x0000, /* U+97d6 */
  0x0000, /* U+97d7 */
  0x0000, /* U+97d8 */
  0x0000, /* U+97d9 */
  0x0000, /* U+97da */
  0x0000, /* U+97db */
  0xe8e9, /* U+97dc */
  0x0000, /* U+97dd */
  0x0000, /* U+97de */
  0x0000, /* U+97df */
  0x0000, /* U+97e0 */
  0x0000, /* U+97e1 */
  0x0000, /* U+97e2 */
  0x0000, /* U+97e3 */
  0x0000, /* U+97e4 */
  0x0000, /* U+97e5 */
  0x0000, /* U+97e6 */
  0x0000, /* U+97e7 */
  0x0000, /* U+97e8 */
  0x0000, /* U+97e9 */
  0x0000, /* U+97ea */
  0x0000, /* U+97eb */
  0x0000, /* U+97ec */
  0xe8ea, /* U+97ed */
  0x9442, /* U+97ee */
  0x0000, /* U+97ef */
  0x0000, /* U+97f0 */
  0x0000, /* U+97f1 */
  0xe8ec, /* U+97f2 */
  0x89b9, /* U+97f3 */
  0x0000, /* U+97f4 */
  0xe8ef, /* U+97f5 */
  0xe8ee, /* U+97f6 */
  0x0000, /* U+97f7 */
  0x0000, /* U+97f8 */
  0x0000, /* U+97f9 */
  0x0000, /* U+97fa */
  0x8943, /* U+97fb */
  0x0000, /* U+97fc */
  0x0000, /* U+97fd */
  0x0000, /* U+97fe */
  0x8bbf, /* U+97ff */
  0x0000, /* U+9800 */
  0x95c5, /* U+9801 */
  0x92b8, /* U+9802 */
  0x8da0, /* U+9803 */
  0x0000, /* U+9804 */
  0x8d80, /* U+9805 */
  0x8f87, /* U+9806 */
  0x0000, /* U+9807 */
  0x907b, /* U+9808 */
  0x0000, /* U+9809 */
  0x0000, /* U+980a */
  0x0000, /* U+980b */
  0xe8f1, /* U+980c */
  0x0000, /* U+980d */
  0x0000, /* U+980e */
  0xe8f0, /* U+980f */
  0x9761, /* U+9810 */
  0x8ae6, /* U+9811 */
  0x94d0, /* U+9812 */
  0x93da, /* U+9813 */
  0x0000, /* U+9814 */
  0x0000, /* U+9815 */
  0x0000, /* U+9816 */
  0x909c, /* U+9817 */
  0x97cc, /* U+9818 */
  0x0000, /* U+9819 */
  0x8c7a, /* U+981a */
  0x0000, /* U+981b */
  0x0000, /* U+981c */
  0x0000, /* U+981d */
  0x0000, /* U+981e */
  0x0000, /* U+981f */
  0x0000, /* U+9820 */
  0xe8f4, /* U+9821 */
  0x0000, /* U+9822 */
  0x0000, /* U+9823 */
  0xe8f3, /* U+9824 */
  0x0000, /* U+9825 */
  0x0000, /* U+9826 */
  0x0000, /* U+9827 */
  0x0000, /* U+9828 */
  0x0000, /* U+9829 */
  0x0000, /* U+982a */
  0x0000, /* U+982b */
  0x966a, /* U+982c */
  0x93aa, /* U+982d */
  0x0000, /* U+982e */
  0x0000, /* U+982f */
  0x0000, /* U+9830 */
  0x0000, /* U+9831 */
  0x0000, /* U+9832 */
  0x0000, /* U+9833 */
  0x896f, /* U+9834 */
  0x0000, /* U+9835 */
  0x0000, /* U+9836 */
  0xe8f5, /* U+9837 */
  0xe8f2, /* U+9838 */
  0x0000, /* U+9839 */
  0x0000, /* U+983a */
  0x9570, /* U+983b */
  0x978a, /* U+983c */
  0xe8f6, /* U+983d */
  0x0000, /* U+983e */
  0x0000, /* U+983f */
  0x0000, /* U+9840 */
  0x0000, /* U+9841 */
  0x0000, /* U+9842 */
  0x0000, /* U+9843 */
  0x0000, /* U+9844 */
  0x0000, /* U+9845 */
  0xe8f7, /* U+9846 */
  0x0000, /* U+9847 */
  0x0000, /* U+9848 */
  0x0000, /* U+9849 */
  0x0000, /* U+984a */
  0xe8f9, /* U+984b */
  0x91e8, /* U+984c */
  0x8a7a, /* U+984d */
  0x8a7b, /* U+984e */
  0xe8f8, /* U+984f */
  0x0000, /* U+9850 */
  0x0000, /* U+9851 */
  0x0000, /* U+9852 */
  0x0000, /* U+9853 */
  0x8ae7, /* U+9854 */
  0x8cb0, /* U+9855 */
  0x0000, /* U+9856 */
  0xfbf4, /* U+9857 */
  0x8ae8, /* U+9858 */
  0x0000, /* U+9859 */
  0x0000, /* U+985a */
  0x935e, /* U+985b */
  0x0000, /* U+985c */
  0x0000, /* U+985d */
  0x97de, /* U+985e */
  0x0000, /* U+985f */
  0x0000, /* U+9860 */
  0x0000, /* U+9861 */
  0x0000, /* U+9862 */
  0x0000, /* U+9863 */
  0x0000, /* U+9864 */
  0xfbf5, /* U+9865 */
  0x0000, /* U+9866 */
  0x8cda, /* U+9867 */
  0x0000, /* U+9868 */
  0x0000, /* U+9869 */
  0x0000, /* U+986a */
  0xe8fa, /* U+986b */
  0x0000, /* U+986c */
  0x0000, /* U+986d */
  0x0000, /* U+986e */
  0xe8fb, /* U+986f */
  0xe8fc, /* U+9870 */
  0xe940, /* U+9871 */
  0x0000, /* U+9872 */
  0xe942, /* U+9873 */
  0xe941, /* U+9874 */
  0x0000, /* U+9875 */
  0x0000, /* U+9876 */
  0x0000, /* U+9877 */
  0x0000, /* U+9878 */
  0x0000, /* U+9879 */
  0x0000, /* U+987a */
  0x0000, /* U+987b */
  0x0000, /* U+987c */
  0x0000, /* U+987d */
  0x0000, /* U+987e */
  0x0000, /* U+987f */
  0x0000, /* U+9880 */
  0x0000, /* U+9881 */
  0x0000, /* U+9882 */
  0x0000, /* U+9883 */
  0x0000, /* U+9884 */
  0x0000, /* U+9885 */
  0x0000, /* U+9886 */
  0x0000, /* U+9887 */
  0x0000, /* U+9888 */
  0x0000, /* U+9889 */
  0x0000, /* U+988a */
  0x0000, /* U+988b */
  0x0000, /* U+988c */
  0x0000, /* U+988d */
  0x0000, /* U+988e */
  0x0000, /* U+988f */
  0x0000, /* U+9890 */
  0x0000, /* U+9891 */
  0x0000, /* U+9892 */
  0x0000, /* U+9893 */
  0x0000, /* U+9894 */
  0x0000, /* U+9895 */
  0x0000, /* U+9896 */
  0x0000, /* U+9897 */
  0x0000, /* U+9898 */
  0x0000, /* U+9899 */
  0x0000, /* U+989a */
  0x0000, /* U+989b */
  0x0000, /* U+989c */
  0x0000, /* U+989d */
  0x0000, /* U+989e */
  0x0000, /* U+989f */
  0x0000, /* U+98a0 */
  0x0000, /* U+98a1 */
  0x0000, /* U+98a2 */
  0x0000, /* U+98a3 */
  0x0000, /* U+98a4 */
  0x0000, /* U+98a5 */
  0x0000, /* U+98a6 */
  0x0000, /* U+98a7 */
  0x9597, /* U+98a8 */
  0x0000, /* U+98a9 */
  0xe943, /* U+98aa */
  0x0000, /* U+98ab */
  0x0000, /* U+98ac */
  0x0000, /* U+98ad */
  0x0000, /* U+98ae */
  0xe944, /* U+98af */
  0x0000, /* U+98b0 */
  0xe945, /* U+98b1 */
  0x0000, /* U+98b2 */
  0x0000, /* U+98b3 */
  0x0000, /* U+98b4 */
  0x0000, /* U+98b5 */
  0xe946, /* U+98b6 */
  0x0000, /* U+98b7 */
  0x0000, /* U+98b8 */
  0x0000, /* U+98b9 */
  0x0000, /* U+98ba */
  0x0000, /* U+98bb */
  0x0000, /* U+98bc */
  0x0000, /* U+98bd */
  0x0000, /* U+98be */
  0x0000, /* U+98bf */
  0x0000, /* U+98c0 */
  0x0000, /* U+98c1 */
  0x0000, /* U+98c2 */
  0xe948, /* U+98c3 */
  0xe947, /* U+98c4 */
  0x0000, /* U+98c5 */
  0xe949, /* U+98c6 */
  0x0000, /* U+98c7 */
  0x0000, /* U+98c8 */
  0x0000, /* U+98c9 */
  0x0000, /* U+98ca */
  0x0000, /* U+98cb */
  0x0000, /* U+98cc */
  0x0000, /* U+98cd */
  0x0000, /* U+98ce */
  0x0000, /* U+98cf */
  0x0000, /* U+98d0 */
  0x0000, /* U+98d1 */
  0x0000, /* U+98d2 */
  0x0000, /* U+98d3 */
  0x0000, /* U+98d4 */
  0x0000, /* U+98d5 */
  0x0000, /* U+98d6 */
  0x0000, /* U+98d7 */
  0x0000, /* U+98d8 */
  0x0000, /* U+98d9 */
  0x0000, /* U+98da */
  0x94f2, /* U+98db */
  0xe3ca, /* U+98dc */
  0x0000, /* U+98dd */
  0x0000, /* U+98de */
  0x9048, /* U+98df */
  0x0000, /* U+98e0 */
  0x0000, /* U+98e1 */
  0x8b51, /* U+98e2 */
  0x0000, /* U+98e3 */
  0x0000, /* U+98e4 */
  0x0000, /* U+98e5 */
  0x0000, /* U+98e6 */
  0x0000, /* U+98e7 */
  0x0000, /* U+98e8 */
  0xe94a, /* U+98e9 */
  0x0000, /* U+98ea */
  0xe94b, /* U+98eb */
  0x0000, /* U+98ec */
  0x99aa, /* U+98ed */
  0x9f5a, /* U+98ee */
  0x94d1, /* U+98ef */
  0x0000, /* U+98f0 */
  0x0000, /* U+98f1 */
  0x88f9, /* U+98f2 */
  0x0000, /* U+98f3 */
  0x88b9, /* U+98f4 */
  0x0000, /* U+98f5 */
  0x0000, /* U+98f6 */
  0x0000, /* U+98f7 */
  0x0000, /* U+98f8 */
  0x0000, /* U+98f9 */
  0x0000, /* U+98fa */
  0x0000, /* U+98fb */
  0x8e94, /* U+98fc */
  0x964f, /* U+98fd */
  0x8ffc, /* U+98fe */
  0x0000, /* U+98ff */
  0x0000, /* U+9900 */
  0x0000, /* U+9901 */
  0x0000, /* U+9902 */
  0xe94c, /* U+9903 */
  0x0000, /* U+9904 */
  0x96dd, /* U+9905 */
  0x0000, /* U+9906 */
  0x0000, /* U+9907 */
  0x0000, /* U+9908 */
  0xe94d, /* U+9909 */
  0x977b, /* U+990a */
  0x0000, /* U+990b */
  0x8961, /* U+990c */
  0x0000, /* U+990d */
  0x0000, /* U+990e */
  0x0000, /* U+990f */
  0x8e60, /* U+9910 */
  0x0000, /* U+9911 */
  0xe94e, /* U+9912 */
  0x89ec, /* U+9913 */
  0xe94f, /* U+9914 */
  0x0000, /* U+9915 */
  0x0000, /* U+9916 */
  0x0000, /* U+9917 */
  0xe950, /* U+9918 */
  0x0000, /* U+9919 */
  0x0000, /* U+991a */
  0x0000, /* U+991b */
  0x0000, /* U+991c */
  0xe952, /* U+991d */
  0xe953, /* U+991e */
  0x0000, /* U+991f */
  0xe955, /* U+9920 */
  0xe951, /* U+9921 */
  0x0000, /* U+9922 */
  0x0000, /* U+9923 */
  0xe954, /* U+9924 */
  0x0000, /* U+9925 */
  0x0000, /* U+9926 */
  0xfbf8, /* U+9927 */
  0x8ad9, /* U+9928 */
  0x0000, /* U+9929 */
  0x0000, /* U+992a */
  0x0000, /* U+992b */
  0xe956, /* U+992c */
  0x0000, /* U+992d */
  0xe957, /* U+992e */
  0x0000, /* U+992f */
  0x0000, /* U+9930 */
  0x0000, /* U+9931 */
  0x0000, /* U+9932 */
  0x0000, /* U+9933 */
  0x0000, /* U+9934 */
  0x0000, /* U+9935 */
  0x0000, /* U+9936 */
  0x0000, /* U+9937 */
  0x0000, /* U+9938 */
  0x0000, /* U+9939 */
  0x0000, /* U+993a */
  0x0000, /* U+993b */
  0x0000, /* U+993c */
  0xe958, /* U+993d */
  0xe959, /* U+993e */
  0x0000, /* U+993f */
  0x0000, /* U+9940 */
  0x0000, /* U+9941 */
  0xe95a, /* U+9942 */
  0x0000, /* U+9943 */
  0x0000, /* U+9944 */
  0xe95c, /* U+9945 */
  0x0000, /* U+9946 */
  0x0000, /* U+9947 */
  0x0000, /* U+9948 */
  0xe95b, /* U+9949 */
  0x0000, /* U+994a */
  0xe95e, /* U+994b */
  0xe961, /* U+994c */
  0x0000, /* U+994d */
  0x0000, /* U+994e */
  0x0000, /* U+994f */
  0xe95d, /* U+9950 */
  0xe95f, /* U+9951 */
  0xe960, /* U+9952 */
  0x0000, /* U+9953 */
  0x0000, /* U+9954 */
  0xe962, /* U+9955 */
  0x0000, /* U+9956 */
  0x8bc0, /* U+9957 */
  0x0000, /* U+9958 */
  0x0000, /* U+9959 */
  0x0000, /* U+995a */
  0x0000, /* U+995b */
  0x0000, /* U+995c */
  0x0000, /* U+995d */
  0x0000, /* U+995e */
  0x0000, /* U+995f */
  0x0000, /* U+9960 */
  0x0000, /* U+9961 */
  0x0000, /* U+9962 */
  0x0000, /* U+9963 */
  0x0000, /* U+9964 */
  0x0000, /* U+9965 */
  0x0000, /* U+9966 */
  0x0000, /* U+9967 */
  0x0000, /* U+9968 */
  0x0000, /* U+9969 */
  0x0000, /* U+996a */
  0x0000, /* U+996b */
  0x0000, /* U+996c */
  0x0000, /* U+996d */
  0x0000, /* U+996e */
  0x0000, /* U+996f */
  0x0000, /* U+9970 */
  0x0000, /* U+9971 */
  0x0000, /* U+9972 */
  0x0000, /* U+9973 */
  0x0000, /* U+9974 */
  0x0000, /* U+9975 */
  0x0000, /* U+9976 */
  0x0000, /* U+9977 */
  0x0000, /* U+9978 */
  0x0000, /* U+9979 */
  0x0000, /* U+997a */
  0x0000, /* U+997b */
  0x0000, /* U+997c */
  0x0000, /* U+997d */
  0x0000, /* U+997e */
  0x0000, /* U+997f */
  0x0000, /* U+9980 */
  0x0000, /* U+9981 */
  0x0000, /* U+9982 */
  0x0000, /* U+9983 */
  0x0000, /* U+9984 */
  0x0000, /* U+9985 */
  0x0000, /* U+9986 */
  0x0000, /* U+9987 */
  0x0000, /* U+9988 */
  0x0000, /* U+9989 */
  0x0000, /* U+998a */
  0x0000, /* U+998b */
  0x0000, /* U+998c */
  0x0000, /* U+998d */
  0x0000, /* U+998e */
  0x0000, /* U+998f */
  0x0000, /* U+9990 */
  0x0000, /* U+9991 */
  0x0000, /* U+9992 */
  0x0000, /* U+9993 */
  0x0000, /* U+9994 */
  0x0000, /* U+9995 */
  0x8ef1, /* U+9996 */
  0xe963, /* U+9997 */
  0xe964, /* U+9998 */
  0x8d81, /* U+9999 */
  0x0000, /* U+999a */
  0x0000, /* U+999b */
  0x0000, /* U+999c */
  0x0000, /* U+999d */
  0xfbfa, /* U+999e */
  0x0000, /* U+999f */
  0x0000, /* U+99a0 */
  0x0000, /* U+99a1 */
  0x0000, /* U+99a2 */
  0x0000, /* U+99a3 */
  0x0000, /* U+99a4 */
  0xe965, /* U+99a5 */
  0x0000, /* U+99a6 */
  0x0000, /* U+99a7 */
  0x8a5d, /* U+99a8 */
  0x0000, /* U+99a9 */
  0x0000, /* U+99aa */
  0x0000, /* U+99ab */
  0x946e, /* U+99ac */
  0xe966, /* U+99ad */
  0xe967, /* U+99ae */
  0x0000, /* U+99af */
  0x0000, /* U+99b0 */
  0x0000, /* U+99b1 */
  0x0000, /* U+99b2 */
  0x9279, /* U+99b3 */
  0x93e9, /* U+99b4 */
  0x0000, /* U+99b5 */
  0x0000, /* U+99b6 */
  0x0000, /* U+99b7 */
  0x0000, /* U+99b8 */
  0x0000, /* U+99b9 */
  0x0000, /* U+99ba */
  0x0000, /* U+99bb */
  0xe968, /* U+99bc */
  0x0000, /* U+99bd */
  0x0000, /* U+99be */
  0x0000, /* U+99bf */
  0x0000, /* U+99c0 */
  0x949d, /* U+99c1 */
  0x0000, /* U+99c2 */
  0x0000, /* U+99c3 */
  0x91ca, /* U+99c4 */
  0x8977, /* U+99c5 */
  0x8bec, /* U+99c6 */
  0x0000, /* U+99c7 */
  0x8bed, /* U+99c8 */
  0x0000, /* U+99c9 */
  0x0000, /* U+99ca */
  0x0000, /* U+99cb */
  0x0000, /* U+99cc */
  0x0000, /* U+99cd */
  0x0000, /* U+99ce */
  0x0000, /* U+99cf */
  0x9293, /* U+99d0 */
  0xe96d, /* U+99d1 */
  0x8bee, /* U+99d2 */
  0x0000, /* U+99d3 */
  0x0000, /* U+99d4 */
  0x89ed, /* U+99d5 */
  0x0000, /* U+99d6 */
  0x0000, /* U+99d7 */
  0xe96c, /* U+99d8 */
  0x0000, /* U+99d9 */
  0x0000, /* U+99da */
  0xe96a, /* U+99db */
  0x0000, /* U+99dc */
  0xe96b, /* U+99dd */
  0x0000, /* U+99de */
  0xe969, /* U+99df */
  0x0000, /* U+99e0 */
  0x0000, /* U+99e1 */
  0xe977, /* U+99e2 */
  0x0000, /* U+99e3 */
  0x0000, /* U+99e4 */
  0x0000, /* U+99e5 */
  0x0000, /* U+99e6 */
  0x0000, /* U+99e7 */
  0x0000, /* U+99e8 */
  0x0000, /* U+99e9 */
  0x0000, /* U+99ea */
  0x0000, /* U+99eb */
  0x0000, /* U+99ec */
  0xe96e, /* U+99ed */
  0xe96f, /* U+99ee */
  0x0000, /* U+99ef */
  0x0000, /* U+99f0 */
  0xe970, /* U+99f1 */
  0xe971, /* U+99f2 */
  0x0000, /* U+99f3 */
  0x0000, /* U+99f4 */
  0x0000, /* U+99f5 */
  0x0000, /* U+99f6 */
  0x0000, /* U+99f7 */
  0xe973, /* U+99f8 */
  0x0000, /* U+99f9 */
  0x0000, /* U+99fa */
  0xe972, /* U+99fb */
  0x0000, /* U+99fc */
  0x0000, /* U+99fd */
  0x0000, /* U+99fe */
  0x8f78, /* U+99ff */
  0x0000, /* U+9a00 */
  0xe974, /* U+9a01 */
  0x0000, /* U+9a02 */
  0x0000, /* U+9a03 */
  0x0000, /* U+9a04 */
  0xe976, /* U+9a05 */
  0x0000, /* U+9a06 */
  0x0000, /* U+9a07 */
  0x0000, /* U+9a08 */
  0x0000, /* U+9a09 */
  0x0000, /* U+9a0a */
  0x0000, /* U+9a0b */
  0x0000, /* U+9a0c */
  0x0000, /* U+9a0d */
  0x8b52, /* U+9a0e */
  0xe975, /* U+9a0f */
  0x0000, /* U+9a10 */
  0x0000, /* U+9a11 */
  0x919b, /* U+9a12 */
  0x8cb1, /* U+9a13 */
  0x0000, /* U+9a14 */
  0x0000, /* U+9a15 */
  0x0000, /* U+9a16 */
  0x0000, /* U+9a17 */
  0x0000, /* U+9a18 */
  0xe978, /* U+9a19 */
  0x0000, /* U+9a1a */
  0x0000, /* U+9a1b */
  0x0000, /* U+9a1c */
  0x0000, /* U+9a1d */
  0x0000, /* U+9a1e */
  0x0000, /* U+9a1f */
  0x0000, /* U+9a20 */
  0x0000, /* U+9a21 */
  0x0000, /* U+9a22 */
  0x0000, /* U+9a23 */
  0x0000, /* U+9a24 */
  0x0000, /* U+9a25 */
  0x0000, /* U+9a26 */
  0x0000, /* U+9a27 */
  0x91cb, /* U+9a28 */
  0x0000, /* U+9a29 */
  0x0000, /* U+9a2a */
  0xe979, /* U+9a2b */
  0x0000, /* U+9a2c */
  0x0000, /* U+9a2d */
  0x0000, /* U+9a2e */
  0x0000, /* U+9a2f */
  0x93ab, /* U+9a30 */
  0x0000, /* U+9a31 */
  0x0000, /* U+9a32 */
  0x0000, /* U+9a33 */
  0x0000, /* U+9a34 */
  0x0000, /* U+9a35 */
  0x0000, /* U+9a36 */
  0xe97a, /* U+9a37 */
  0x0000, /* U+9a38 */
  0x0000, /* U+9a39 */
  0x0000, /* U+9a3a */
  0x0000, /* U+9a3b */
  0x0000, /* U+9a3c */
  0x0000, /* U+9a3d */
  0xe980, /* U+9a3e */
  0x0000, /* U+9a3f */
  0xe97d, /* U+9a40 */
  0x0000, /* U+9a41 */
  0xe97c, /* U+9a42 */
  0xe97e, /* U+9a43 */
  0x0000, /* U+9a44 */
  0xe97b, /* U+9a45 */
  0x0000, /* U+9a46 */
  0x0000, /* U+9a47 */
  0x0000, /* U+9a48 */
  0x0000, /* U+9a49 */
  0x0000, /* U+9a4a */
  0x0000, /* U+9a4b */
  0x0000, /* U+9a4c */
  0xe982, /* U+9a4d */
  0xfbfb, /* U+9a4e */
  0x0000, /* U+9a4f */
  0x0000, /* U+9a50 */
  0x0000, /* U+9a51 */
  0x0000, /* U+9a52 */
  0x0000, /* U+9a53 */
  0x0000, /* U+9a54 */
  0xe981, /* U+9a55 */
  0x0000, /* U+9a56 */
  0xe984, /* U+9a57 */
  0x0000, /* U+9a58 */
  0x0000, /* U+9a59 */
  0x8bc1, /* U+9a5a */
  0xe983, /* U+9a5b */
  0x0000, /* U+9a5c */
  0x0000, /* U+9a5d */
  0x0000, /* U+9a5e */
  0xe985, /* U+9a5f */
  0x0000, /* U+9a60 */
  0x0000, /* U+9a61 */
  0xe986, /* U+9a62 */
  0x0000, /* U+9a63 */
  0xe988, /* U+9a64 */
  0xe987, /* U+9a65 */
  0x0000, /* U+9a66 */
  0x0000, /* U+9a67 */
  0x0000, /* U+9a68 */
  0xe989, /* U+9a69 */
  0xe98b, /* U+9a6a */
  0xe98a, /* U+9a6b */
  0x0000, /* U+9a6c */
  0x0000, /* U+9a6d */
  0x0000, /* U+9a6e */
  0x0000, /* U+9a6f */
  0x0000, /* U+9a70 */
  0x0000, /* U+9a71 */
  0x0000, /* U+9a72 */
  0x0000, /* U+9a73 */
  0x0000, /* U+9a74 */
  0x0000, /* U+9a75 */
  0x0000, /* U+9a76 */
  0x0000, /* U+9a77 */
  0x0000, /* U+9a78 */
  0x0000, /* U+9a79 */
  0x0000, /* U+9a7a */
  0x0000, /* U+9a7b */
  0x0000, /* U+9a7c */
  0x0000, /* U+9a7d */
  0x0000, /* U+9a7e */
  0x0000, /* U+9a7f */
  0x0000, /* U+9a80 */
  0x0000, /* U+9a81 */
  0x0000, /* U+9a82 */
  0x0000, /* U+9a83 */
  0x0000, /* U+9a84 */
  0x0000, /* U+9a85 */
  0x0000, /* U+9a86 */
  0x0000, /* U+9a87 */
  0x0000, /* U+9a88 */
  0x0000, /* U+9a89 */
  0x0000, /* U+9a8a */
  0x0000, /* U+9a8b */
  0x0000, /* U+9a8c */
  0x0000, /* U+9a8d */
  0x0000, /* U+9a8e */
  0x0000, /* U+9a8f */
  0x0000, /* U+9a90 */
  0x0000, /* U+9a91 */
  0x0000, /* U+9a92 */
  0x0000, /* U+9a93 */
  0x0000, /* U+9a94 */
  0x0000, /* U+9a95 */
  0x0000, /* U+9a96 */
  0x0000, /* U+9a97 */
  0x0000, /* U+9a98 */
  0x0000, /* U+9a99 */
  0x0000, /* U+9a9a */
  0x0000, /* U+9a9b */
  0x0000, /* U+9a9c */
  0x0000, /* U+9a9d */
  0x0000, /* U+9a9e */
  0x0000, /* U+9a9f */
  0x0000, /* U+9aa0 */
  0x0000, /* U+9aa1 */
  0x0000, /* U+9aa2 */
  0x0000, /* U+9aa3 */
  0x0000, /* U+9aa4 */
  0x0000, /* U+9aa5 */
  0x0000, /* U+9aa6 */
  0x0000, /* U+9aa7 */
  0x8d9c, /* U+9aa8 */
  0x0000, /* U+9aa9 */
  0x0000, /* U+9aaa */
  0x0000, /* U+9aab */
  0x0000, /* U+9aac */
  0xe98c, /* U+9aad */
  0x0000, /* U+9aae */
  0x0000, /* U+9aaf */
  0xe98d, /* U+9ab0 */
  0x0000, /* U+9ab1 */
  0x0000, /* U+9ab2 */
  0x0000, /* U+9ab3 */
  0x0000, /* U+9ab4 */
  0x0000, /* U+9ab5 */
  0x0000, /* U+9ab6 */
  0x0000, /* U+9ab7 */
  0x8a5b, /* U+9ab8 */
  0x0000, /* U+9ab9 */
  0x0000, /* U+9aba */
  0x0000, /* U+9abb */
  0xe98e, /* U+9abc */
  0x0000, /* U+9abd */
  0x0000, /* U+9abe */
  0x0000, /* U+9abf */
  0xe98f, /* U+9ac0 */
  0x0000, /* U+9ac1 */
  0x0000, /* U+9ac2 */
  0x0000, /* U+9ac3 */
  0x9091, /* U+9ac4 */
  0x0000, /* U+9ac5 */
  0x0000, /* U+9ac6 */
  0x0000, /* U+9ac7 */
  0x0000, /* U+9ac8 */
  0x0000, /* U+9ac9 */
  0x0000, /* U+9aca */
  0x0000, /* U+9acb */
  0x0000, /* U+9acc */
  0x0000, /* U+9acd */
  0x0000, /* U+9ace */
  0xe990, /* U+9acf */
  0x0000, /* U+9ad0 */
  0xe991, /* U+9ad1 */
  0x0000, /* U+9ad2 */
  0xe992, /* U+9ad3 */
  0xe993, /* U+9ad4 */
  0x0000, /* U+9ad5 */
  0x0000, /* U+9ad6 */
  0x0000, /* U+9ad7 */
  0x8d82, /* U+9ad8 */
  0xfbfc, /* U+9ad9 */
  0x0000, /* U+9ada */
  0x0000, /* U+9adb */
  0xfc40, /* U+9adc */
  0x0000, /* U+9add */
  0xe994, /* U+9ade */
  0xe995, /* U+9adf */
  0x0000, /* U+9ae0 */
  0x0000, /* U+9ae1 */
  0xe996, /* U+9ae2 */
  0xe997, /* U+9ae3 */
  0x0000, /* U+9ae4 */
  0x0000, /* U+9ae5 */
  0xe998, /* U+9ae6 */
  0x0000, /* U+9ae7 */
  0x0000, /* U+9ae8 */
  0x0000, /* U+9ae9 */
  0x94af, /* U+9aea */
  0xe99a, /* U+9aeb */
  0x0000, /* U+9aec */
  0x9545, /* U+9aed */
  0xe99b, /* U+9aee */
  0xe999, /* U+9aef */
  0x0000, /* U+9af0 */
  0xe99d, /* U+9af1 */
  0x0000, /* U+9af2 */
  0x0000, /* U+9af3 */
  0xe99c, /* U+9af4 */
  0x0000, /* U+9af5 */
  0x0000, /* U+9af6 */
  0xe99e, /* U+9af7 */
  0x0000, /* U+9af8 */
  0x0000, /* U+9af9 */
  0x0000, /* U+9afa */
  0xe99f, /* U+9afb */
  0x0000, /* U+9afc */
  0x0000, /* U+9afd */
  0x0000, /* U+9afe */
  0x0000, /* U+9aff */
  0x0000, /* U+9b00 */
  0x0000, /* U+9b01 */
  0x0000, /* U+9b02 */
  0x0000, /* U+9b03 */
  0x0000, /* U+9b04 */
  0x0000, /* U+9b05 */
  0xe9a0, /* U+9b06 */
  0x0000, /* U+9b07 */
  0x0000, /* U+9b08 */
  0x0000, /* U+9b09 */
  0x0000, /* U+9b0a */
  0x0000, /* U+9b0b */
  0x0000, /* U+9b0c */
  0x0000, /* U+9b0d */
  0x0000, /* U+9b0e */
  0x0000, /* U+9b0f */
  0x0000, /* U+9b10 */
  0x0000, /* U+9b11 */
  0x0000, /* U+9b12 */
  0x0000, /* U+9b13 */
  0x0000, /* U+9b14 */
  0x0000, /* U+9b15 */
  0x0000, /* U+9b16 */
  0x0000, /* U+9b17 */
  0xe9a1, /* U+9b18 */
  0x0000, /* U+9b19 */
  0xe9a2, /* U+9b1a */
  0x0000, /* U+9b1b */
  0x0000, /* U+9b1c */
  0x0000, /* U+9b1d */
  0x0000, /* U+9b1e */
  0xe9a3, /* U+9b1f */
  0x0000, /* U+9b20 */
  0x0000, /* U+9b21 */
  0xe9a4, /* U+9b22 */
  0xe9a5, /* U+9b23 */
  0x0000, /* U+9b24 */
  0xe9a6, /* U+9b25 */
  0x0000, /* U+9b26 */
  0xe9a7, /* U+9b27 */
  0xe9a8, /* U+9b28 */
  0xe9a9, /* U+9b29 */
  0xe9aa, /* U+9b2a */
  0x0000, /* U+9b2b */
  0x0000, /* U+9b2c */
  0x0000, /* U+9b2d */
  0xe9ab, /* U+9b2e */
  0xe9ac, /* U+9b2f */
  0x0000, /* U+9b30 */
  0x9f54, /* U+9b31 */
  0xe9ad, /* U+9b32 */
  0x0000, /* U+9b33 */
  0x0000, /* U+9b34 */
  0x0000, /* U+9b35 */
  0x0000, /* U+9b36 */
  0x0000, /* U+9b37 */
  0x0000, /* U+9b38 */
  0x0000, /* U+9b39 */
  0x0000, /* U+9b3a */
  0xe2f6, /* U+9b3b */
  0x8b53, /* U+9b3c */
  0x0000, /* U+9b3d */
  0x0000, /* U+9b3e */
  0x0000, /* U+9b3f */
  0x0000, /* U+9b40 */
  0x8a40, /* U+9b41 */
  0x8db0, /* U+9b42 */
  0xe9af, /* U+9b43 */
  0xe9ae, /* U+9b44 */
  0x96a3, /* U+9b45 */
  0x0000, /* U+9b46 */
  0x0000, /* U+9b47 */
  0x0000, /* U+9b48 */
  0x0000, /* U+9b49 */
  0x0000, /* U+9b4a */
  0x0000, /* U+9b4b */
  0x0000, /* U+9b4c */
  0xe9b1, /* U+9b4d */
  0xe9b2, /* U+9b4e */
  0xe9b0, /* U+9b4f */
  0x0000, /* U+9b50 */
  0xe9b3, /* U+9b51 */
  0x0000, /* U+9b52 */
  0x0000, /* U+9b53 */
  0x9682, /* U+9b54 */
  0x0000, /* U+9b55 */
  0x0000, /* U+9b56 */
  0x0000, /* U+9b57 */
  0xe9b4, /* U+9b58 */
  0x0000, /* U+9b59 */
  0x8b9b, /* U+9b5a */
  0x0000, /* U+9b5b */
  0x0000, /* U+9b5c */
  0x0000, /* U+9b5d */
  0x0000, /* U+9b5e */
  0x0000, /* U+9b5f */
  0x0000, /* U+9b60 */
  0x0000, /* U+9b61 */
  0x0000, /* U+9b62 */
  0x0000, /* U+9b63 */
  0x0000, /* U+9b64 */
  0x0000, /* U+9b65 */
  0x0000, /* U+9b66 */
  0x0000, /* U+9b67 */
  0x0000, /* U+9b68 */
  0x0000, /* U+9b69 */
  0x0000, /* U+9b6a */
  0x0000, /* U+9b6b */
  0x0000, /* U+9b6c */
  0x0000, /* U+9b6d */
  0x0000, /* U+9b6e */
  0x9844, /* U+9b6f */
  0x0000, /* U+9b70 */
  0x0000, /* U+9b71 */
  0xfc42, /* U+9b72 */
  0x0000, /* U+9b73 */
  0xe9b5, /* U+9b74 */
  0xfc41, /* U+9b75 */
  0x0000, /* U+9b76 */
  0x0000, /* U+9b77 */
  0x0000, /* U+9b78 */
  0x0000, /* U+9b79 */
  0x0000, /* U+9b7a */
  0x0000, /* U+9b7b */
  0x0000, /* U+9b7c */
  0x0000, /* U+9b7d */
  0x0000, /* U+9b7e */
  0x0000, /* U+9b7f */
  0x0000, /* U+9b80 */
  0x0000, /* U+9b81 */
  0x0000, /* U+9b82 */
  0xe9b7, /* U+9b83 */
  0x0000, /* U+9b84 */
  0x0000, /* U+9b85 */
  0x0000, /* U+9b86 */
  0x0000, /* U+9b87 */
  0x0000, /* U+9b88 */
  0x0000, /* U+9b89 */
  0x0000, /* U+9b8a */
  0x0000, /* U+9b8b */
  0x0000, /* U+9b8c */
  0x0000, /* U+9b8d */
  0x88bc, /* U+9b8e */
  0xfc43, /* U+9b8f */
  0x0000, /* U+9b90 */
  0xe9b8, /* U+9b91 */
  0x95a9, /* U+9b92 */
  0xe9b6, /* U+9b93 */
  0x0000, /* U+9b94 */
  0x0000, /* U+9b95 */
  0xe9b9, /* U+9b96 */
  0xe9ba, /* U+9b97 */
  0x0000, /* U+9b98 */
  0x0000, /* U+9b99 */
  0x0000, /* U+9b9a */
  0x0000, /* U+9b9b */
  0x0000, /* U+9b9c */
  0x0000, /* U+9b9d */
  0x0000, /* U+9b9e */
  0xe9bb, /* U+9b9f */
  0xe9bc, /* U+9ba0 */
  0x0000, /* U+9ba1 */
  0x0000, /* U+9ba2 */
  0x0000, /* U+9ba3 */
  0x0000, /* U+9ba4 */
  0x0000, /* U+9ba5 */
  0x0000, /* U+9ba6 */
  0x0000, /* U+9ba7 */
  0xe9bd, /* U+9ba8 */
  0x0000, /* U+9ba9 */
  0x968e, /* U+9baa */
  0x8e4c, /* U+9bab */
  0x0000, /* U+9bac */
  0x8df8, /* U+9bad */
  0x914e, /* U+9bae */
  0x0000, /* U+9baf */
  0x0000, /* U+9bb0 */
  0xfc44, /* U+9bb1 */
  0x0000, /* U+9bb2 */
  0x0000, /* U+9bb3 */
  0xe9be, /* U+9bb4 */
  0x0000, /* U+9bb5 */
  0x0000, /* U+9bb6 */
  0x0000, /* U+9bb7 */
  0x0000, /* U+9bb8 */
  0xe9c1, /* U+9bb9 */
  0x0000, /* U+9bba */
  0xfc45, /* U+9bbb */
  0x0000, /* U+9bbc */
  0x0000, /* U+9bbd */
  0x0000, /* U+9bbe */
  0x0000, /* U+9bbf */
  0xe9bf, /* U+9bc0 */
  0x0000, /* U+9bc1 */
  0x0000, /* U+9bc2 */
  0x0000, /* U+9bc3 */
  0x0000, /* U+9bc4 */
  0x0000, /* U+9bc5 */
  0xe9c2, /* U+9bc6 */
  0x0000, /* U+9bc7 */
  0x0000, /* U+9bc8 */
  0x8cef, /* U+9bc9 */
  0xe9c0, /* U+9bca */
  0x0000, /* U+9bcb */
  0x0000, /* U+9bcc */
  0x0000, /* U+9bcd */
  0x0000, /* U+9bce */
  0xe9c3, /* U+9bcf */
  0x0000, /* U+9bd0 */
  0xe9c4, /* U+9bd1 */
  0xe9c5, /* U+9bd2 */
  0x0000, /* U+9bd3 */
  0xe9c9, /* U+9bd4 */
  0x0000, /* U+9bd5 */
  0x8e49, /* U+9bd6 */
  0x0000, /* U+9bd7 */
  0x0000, /* U+9bd8 */
  0x0000, /* U+9bd9 */
  0x0000, /* U+9bda */
  0x91e2, /* U+9bdb */
  0x0000, /* U+9bdc */
  0x0000, /* U+9bdd */
  0x0000, /* U+9bde */
  0x0000, /* U+9bdf */
  0x0000, /* U+9be0 */
  0xe9ca, /* U+9be1 */
  0xe9c7, /* U+9be2 */
  0xe9c6, /* U+9be3 */
  0xe9c8, /* U+9be4 */
  0x0000, /* U+9be5 */
  0x0000, /* U+9be6 */
  0x0000, /* U+9be7 */
  0x8c7e, /* U+9be8 */
  0x0000, /* U+9be9 */
  0x0000, /* U+9bea */
  0x0000, /* U+9beb */
  0x0000, /* U+9bec */
  0x0000, /* U+9bed */
  0x0000, /* U+9bee */
  0x0000, /* U+9bef */
  0xe9ce, /* U+9bf0 */
  0xe9cd, /* U+9bf1 */
  0xe9cc, /* U+9bf2 */
  0x0000, /* U+9bf3 */
  0x0000, /* U+9bf4 */
  0x88b1, /* U+9bf5 */
  0x0000, /* U+9bf6 */
  0x0000, /* U+9bf7 */
  0x0000, /* U+9bf8 */
  0x0000, /* U+9bf9 */
  0x0000, /* U+9bfa */
  0x0000, /* U+9bfb */
  0x0000, /* U+9bfc */
  0x0000, /* U+9bfd */
  0x0000, /* U+9bfe */
  0x0000, /* U+9bff */
  0xfc46, /* U+9c00 */
  0x0000, /* U+9c01 */
  0x0000, /* U+9c02 */
  0x0000, /* U+9c03 */
  0xe9d8, /* U+9c04 */
  0x0000, /* U+9c05 */
  0xe9d4, /* U+9c06 */
  0x0000, /* U+9c07 */
  0xe9d5, /* U+9c08 */
  0xe9d1, /* U+9c09 */
  0xe9d7, /* U+9c0a */
  0x0000, /* U+9c0b */
  0xe9d3, /* U+9c0c */
  0x8a82, /* U+9c0d */
  0x0000, /* U+9c0e */
  0x0000, /* U+9c0f */
  0x986b, /* U+9c10 */
  0x0000, /* U+9c11 */
  0xe9d6, /* U+9c12 */
  0xe9d2, /* U+9c13 */
  0xe9d0, /* U+9c14 */
  0xe9cf, /* U+9c15 */
  0x0000, /* U+9c16 */
  0x0000, /* U+9c17 */
  0x0000, /* U+9c18 */
  0x0000, /* U+9c19 */
  0x0000, /* U+9c1a */
  0xe9da, /* U+9c1b */
  0x0000, /* U+9c1c */
  0x0000, /* U+9c1d */
  0x0000, /* U+9c1e */
  0x0000, /* U+9c1f */
  0x0000, /* U+9c20 */
  0xe9dd, /* U+9c21 */
  0x0000, /* U+9c22 */
  0x0000, /* U+9c23 */
  0xe9dc, /* U+9c24 */
  0xe9db, /* U+9c25 */
  0x0000, /* U+9c26 */
  0x0000, /* U+9c27 */
  0x0000, /* U+9c28 */
  0x0000, /* U+9c29 */
  0x0000, /* U+9c2a */
  0x0000, /* U+9c2b */
  0x0000, /* U+9c2c */
  0x9568, /* U+9c2d */
  0xe9d9, /* U+9c2e */
  0x88f1, /* U+9c2f */
  0xe9de, /* U+9c30 */
  0x0000, /* U+9c31 */
  0xe9e0, /* U+9c32 */
  0x0000, /* U+9c33 */
  0x0000, /* U+9c34 */
  0x0000, /* U+9c35 */
  0x0000, /* U+9c36 */
  0x0000, /* U+9c37 */
  0x0000, /* U+9c38 */
  0x8a8f, /* U+9c39 */
  0xe9cb, /* U+9c3a */
  0x8956, /* U+9c3b */
  0x0000, /* U+9c3c */
  0x0000, /* U+9c3d */
  0xe9e2, /* U+9c3e */
  0x0000, /* U+9c3f */
  0x0000, /* U+9c40 */
  0x0000, /* U+9c41 */
  0x0000, /* U+9c42 */
  0x0000, /* U+9c43 */
  0x0000, /* U+9c44 */
  0x0000, /* U+9c45 */
  0xe9e1, /* U+9c46 */
  0xe9df, /* U+9c47 */
  0x924c, /* U+9c48 */
  0x0000, /* U+9c49 */
  0x0000, /* U+9c4a */
  0x0000, /* U+9c4b */
  0x0000, /* U+9c4c */
  0x0000, /* U+9c4d */
  0x0000, /* U+9c4e */
  0x0000, /* U+9c4f */
  0x0000, /* U+9c50 */
  0x0000, /* U+9c51 */
  0x9690, /* U+9c52 */
  0x0000, /* U+9c53 */
  0x0000, /* U+9c54 */
  0x0000, /* U+9c55 */
  0x0000, /* U+9c56 */
  0x97d8, /* U+9c57 */
  0x0000, /* U+9c58 */
  0x0000, /* U+9c59 */
  0xe9e3, /* U+9c5a */
  0x0000, /* U+9c5b */
  0x0000, /* U+9c5c */
  0x0000, /* U+9c5d */
  0x0000, /* U+9c5e */
  0x0000, /* U+9c5f */
  0xe9e4, /* U+9c60 */
  0x0000, /* U+9c61 */
  0x0000, /* U+9c62 */
  0x0000, /* U+9c63 */
  0x0000, /* U+9c64 */
  0x0000, /* U+9c65 */
  0x0000, /* U+9c66 */
  0xe9e5, /* U+9c67 */
  0x0000, /* U+9c68 */
  0x0000, /* U+9c69 */
  0x0000, /* U+9c6a */
  0x0000, /* U+9c6b */
  0x0000, /* U+9c6c */
  0x0000, /* U+9c6d */
  0x0000, /* U+9c6e */
  0x0000, /* U+9c6f */
  0x0000, /* U+9c70 */
  0x0000, /* U+9c71 */
  0x0000, /* U+9c72 */
  0x0000, /* U+9c73 */
  0x0000, /* U+9c74 */
  0x0000, /* U+9c75 */
  0xe9e6, /* U+9c76 */
  0x0000, /* U+9c77 */
  0xe9e7, /* U+9c78 */
  0x0000, /* U+9c79 */
  0x0000, /* U+9c7a */
  0x0000, /* U+9c7b */
  0x0000, /* U+9c7c */
  0x0000, /* U+9c7d */
  0x0000, /* U+9c7e */
  0x0000, /* U+9c7f */
  0x0000, /* U+9c80 */
  0x0000, /* U+9c81 */
  0x0000, /* U+9c82 */
  0x0000, /* U+9c83 */
  0x0000, /* U+9c84 */
  0x0000, /* U+9c85 */
  0x0000, /* U+9c86 */
  0x0000, /* U+9c87 */
  0x0000, /* U+9c88 */
  0x0000, /* U+9c89 */
  0x0000, /* U+9c8a */
  0x0000, /* U+9c8b */
  0x0000, /* U+9c8c */
  0x0000, /* U+9c8d */
  0x0000, /* U+9c8e */
  0x0000, /* U+9c8f */
  0x0000, /* U+9c90 */
  0x0000, /* U+9c91 */
  0x0000, /* U+9c92 */
  0x0000, /* U+9c93 */
  0x0000, /* U+9c94 */
  0x0000, /* U+9c95 */
  0x0000, /* U+9c96 */
  0x0000, /* U+9c97 */
  0x0000, /* U+9c98 */
  0x0000, /* U+9c99 */
  0x0000, /* U+9c9a */
  0x0000, /* U+9c9b */
  0x0000, /* U+9c9c */
  0x0000, /* U+9c9d */
  0x0000, /* U+9c9e */
  0x0000, /* U+9c9f */
  0x0000, /* U+9ca0 */
  0x0000, /* U+9ca1 */
  0x0000, /* U+9ca2 */
  0x0000, /* U+9ca3 */
  0x0000, /* U+9ca4 */
  0x0000, /* U+9ca5 */
  0x0000, /* U+9ca6 */
  0x0000, /* U+9ca7 */
  0x0000, /* U+9ca8 */
  0x0000, /* U+9ca9 */
  0x0000, /* U+9caa */
  0x0000, /* U+9cab */
  0x0000, /* U+9cac */
  0x0000, /* U+9cad */
  0x0000, /* U+9cae */
  0x0000, /* U+9caf */
  0x0000, /* U+9cb0 */
  0x0000, /* U+9cb1 */
  0x0000, /* U+9cb2 */
  0x0000, /* U+9cb3 */
  0x0000, /* U+9cb4 */
  0x0000, /* U+9cb5 */
  0x0000, /* U+9cb6 */
  0x0000, /* U+9cb7 */
  0x0000, /* U+9cb8 */
  0x0000, /* U+9cb9 */
  0x0000, /* U+9cba */
  0x0000, /* U+9cbb */
  0x0000, /* U+9cbc */
  0x0000, /* U+9cbd */
  0x0000, /* U+9cbe */
  0x0000, /* U+9cbf */
  0x0000, /* U+9cc0 */
  0x0000, /* U+9cc1 */
  0x0000, /* U+9cc2 */
  0x0000, /* U+9cc3 */
  0x0000, /* U+9cc4 */
  0x0000, /* U+9cc5 */
  0x0000, /* U+9cc6 */
  0x0000, /* U+9cc7 */
  0x0000, /* U+9cc8 */
  0x0000, /* U+9cc9 */
  0x0000, /* U+9cca */
  0x0000, /* U+9ccb */
  0x0000, /* U+9ccc */
  0x0000, /* U+9ccd */
  0x0000, /* U+9cce */
  0x0000, /* U+9ccf */
  0x0000, /* U+9cd0 */
  0x0000, /* U+9cd1 */
  0x0000, /* U+9cd2 */
  0x0000, /* U+9cd3 */
  0x0000, /* U+9cd4 */
  0x0000, /* U+9cd5 */
  0x0000, /* U+9cd6 */
  0x0000, /* U+9cd7 */
  0x0000, /* U+9cd8 */
  0x0000, /* U+9cd9 */
  0x0000, /* U+9cda */
  0x0000, /* U+9cdb */
  0x0000, /* U+9cdc */
  0x0000, /* U+9cdd */
  0x0000, /* U+9cde */
  0x0000, /* U+9cdf */
  0x0000, /* U+9ce0 */
  0x0000, /* U+9ce1 */
  0x0000, /* U+9ce2 */
  0x0000, /* U+9ce3 */
  0x0000, /* U+9ce4 */
  0x92b9, /* U+9ce5 */
  0x0000, /* U+9ce6 */
  0xe9e8, /* U+9ce7 */
  0x0000, /* U+9ce8 */
  0x94b5, /* U+9ce9 */
  0x0000, /* U+9cea */
  0xe9ed, /* U+9ceb */
  0xe9e9, /* U+9cec */
  0x0000, /* U+9ced */
  0x0000, /* U+9cee */
  0x0000, /* U+9cef */
  0xe9ea, /* U+9cf0 */
  0x0000, /* U+9cf1 */
  0x0000, /* U+9cf2 */
  0x9650, /* U+9cf3 */
  0x96c2, /* U+9cf4 */
  0x0000, /* U+9cf5 */
  0x93ce, /* U+9cf6 */
  0x0000, /* U+9cf7 */
  0x0000, /* U+9cf8 */
  0x0000, /* U+9cf9 */
  0x0000, /* U+9cfa */
  0x0000, /* U+9cfb */
  0x0000, /* U+9cfc */
  0x0000, /* U+9cfd */
  0x0000, /* U+9cfe */
  0x0000, /* U+9cff */
  0x0000, /* U+9d00 */
  0x0000, /* U+9d01 */
  0x0000, /* U+9d02 */
  0xe9ee, /* U+9d03 */
  0x0000, /* U+9d04 */
  0x0000, /* U+9d05 */
  0xe9ef, /* U+9d06 */
  0x93bc, /* U+9d07 */
  0xe9ec, /* U+9d08 */
  0xe9eb, /* U+9d09 */
  0x0000, /* U+9d0a */
  0x0000, /* U+9d0b */
  0x0000, /* U+9d0c */
  0x0000, /* U+9d0d */
  0x89a8, /* U+9d0e */
  0x0000, /* U+9d0f */
  0x0000, /* U+9d10 */
  0x0000, /* U+9d11 */
  0xe9f7, /* U+9d12 */
  0x0000, /* U+9d13 */
  0x0000, /* U+9d14 */
  0xe9f6, /* U+9d15 */
  0x0000, /* U+9d16 */
  0x0000, /* U+9d17 */
  0x0000, /* U+9d18 */
  0x0000, /* U+9d19 */
  0x0000, /* U+9d1a */
  0x8995, /* U+9d1b */
  0x0000, /* U+9d1c */
  0x0000, /* U+9d1d */
  0x0000, /* U+9d1e */
  0xe9f4, /* U+9d1f */
  0x0000, /* U+9d20 */
  0x0000, /* U+9d21 */
  0x0000, /* U+9d22 */
  0xe9f3, /* U+9d23 */
  0x0000, /* U+9d24 */
  0x0000, /* U+9d25 */
  0xe9f1, /* U+9d26 */
  0x0000, /* U+9d27 */
  0x8a9b, /* U+9d28 */
  0x0000, /* U+9d29 */
  0xe9f0, /* U+9d2a */
  0x8eb0, /* U+9d2b */
  0x89a7, /* U+9d2c */
  0x0000, /* U+9d2d */
  0x0000, /* U+9d2e */
  0x0000, /* U+9d2f */
  0x0000, /* U+9d30 */
  0x0000, /* U+9d31 */
  0x0000, /* U+9d32 */
  0x0000, /* U+9d33 */
  0x0000, /* U+9d34 */
  0x0000, /* U+9d35 */
  0x0000, /* U+9d36 */
  0x0000, /* U+9d37 */
  0x0000, /* U+9d38 */
  0x0000, /* U+9d39 */
  0x0000, /* U+9d3a */
  0x8d83, /* U+9d3b */
  0x0000, /* U+9d3c */
  0x0000, /* U+9d3d */
  0xe9fa, /* U+9d3e */
  0xe9f9, /* U+9d3f */
  0x0000, /* U+9d40 */
  0xe9f8, /* U+9d41 */
  0x0000, /* U+9d42 */
  0x0000, /* U+9d43 */
  0xe9f5, /* U+9d44 */
  0x0000, /* U+9d45 */
  0xe9fb, /* U+9d46 */
  0x0000, /* U+9d47 */
  0xe9fc, /* U+9d48 */
  0x0000, /* U+9d49 */
  0x0000, /* U+9d4a */
  0x0000, /* U+9d4b */
  0x0000, /* U+9d4c */
  0x0000, /* U+9d4d */
  0x0000, /* U+9d4e */
  0x0000, /* U+9d4f */
  0xea44, /* U+9d50 */
  0xea43, /* U+9d51 */
  0x0000, /* U+9d52 */
  0x0000, /* U+9d53 */
  0x0000, /* U+9d54 */
  0x0000, /* U+9d55 */
  0x0000, /* U+9d56 */
  0x0000, /* U+9d57 */
  0x0000, /* U+9d58 */
  0xea45, /* U+9d59 */
  0x0000, /* U+9d5a */
  0x0000, /* U+9d5b */
  0x894c, /* U+9d5c */
  0xea40, /* U+9d5d */
  0xea41, /* U+9d5e */
  0x0000, /* U+9d5f */
  0x8d94, /* U+9d60 */
  0x96b7, /* U+9d61 */
  0x0000, /* U+9d62 */
  0x0000, /* U+9d63 */
  0xea42, /* U+9d64 */
  0x0000, /* U+9d65 */
  0x0000, /* U+9d66 */
  0x0000, /* U+9d67 */
  0x0000, /* U+9d68 */
  0x0000, /* U+9d69 */
  0x0000, /* U+9d6a */
  0xfc48, /* U+9d6b */
  0x9651, /* U+9d6c */
  0x0000, /* U+9d6d */
  0x0000, /* U+9d6e */
  0xea4a, /* U+9d6f */
  0xfc47, /* U+9d70 */
  0x0000, /* U+9d71 */
  0xea46, /* U+9d72 */
  0x0000, /* U+9d73 */
  0x0000, /* U+9d74 */
  0x0000, /* U+9d75 */
  0x0000, /* U+9d76 */
  0x0000, /* U+9d77 */
  0x0000, /* U+9d78 */
  0x0000, /* U+9d79 */
  0xea4b, /* U+9d7a */
  0x0000, /* U+9d7b */
  0x0000, /* U+9d7c */
  0x0000, /* U+9d7d */
  0x0000, /* U+9d7e */
  0x0000, /* U+9d7f */
  0x0000, /* U+9d80 */
  0x0000, /* U+9d81 */
  0x0000, /* U+9d82 */
  0x0000, /* U+9d83 */
  0x0000, /* U+9d84 */
  0x0000, /* U+9d85 */
  0x0000, /* U+9d86 */
  0xea48, /* U+9d87 */
  0x0000, /* U+9d88 */
  0xea47, /* U+9d89 */
  0x0000, /* U+9d8a */
  0x0000, /* U+9d8b */
  0x0000, /* U+9d8c */
  0x0000, /* U+9d8d */
  0x0000, /* U+9d8e */
  0x8c7b, /* U+9d8f */
  0x0000, /* U+9d90 */
  0x0000, /* U+9d91 */
  0x0000, /* U+9d92 */
  0x0000, /* U+9d93 */
  0x0000, /* U+9d94 */
  0x0000, /* U+9d95 */
  0x0000, /* U+9d96 */
  0x0000, /* U+9d97 */
  0x0000, /* U+9d98 */
  0x0000, /* U+9d99 */
  0xea4c, /* U+9d9a */
  0x0000, /* U+9d9b */
  0x0000, /* U+9d9c */
  0x0000, /* U+9d9d */
  0x0000, /* U+9d9e */
  0x0000, /* U+9d9f */
  0x0000, /* U+9da0 */
  0x0000, /* U+9da1 */
  0x0000, /* U+9da2 */
  0x0000, /* U+9da3 */
  0xea4d, /* U+9da4 */
  0x0000, /* U+9da5 */
  0x0000, /* U+9da6 */
  0x0000, /* U+9da7 */
  0x0000, /* U+9da8 */
  0xea4e, /* U+9da9 */
  0x0000, /* U+9daa */
  0xea49, /* U+9dab */
  0x0000, /* U+9dac */
  0x0000, /* U+9dad */
  0x0000, /* U+9dae */
  0xe9f2, /* U+9daf */
  0x0000, /* U+9db0 */
  0x0000, /* U+9db1 */
  0xea4f, /* U+9db2 */
  0x0000, /* U+9db3 */
  0x92df, /* U+9db4 */
  0x0000, /* U+9db5 */
  0x0000, /* U+9db6 */
  0x0000, /* U+9db7 */
  0xea53, /* U+9db8 */
  0x0000, /* U+9db9 */
  0xea54, /* U+9dba */
  0xea52, /* U+9dbb */
  0x0000, /* U+9dbc */
  0x0000, /* U+9dbd */
  0x0000, /* U+9dbe */
  0x0000, /* U+9dbf */
  0x0000, /* U+9dc0 */
  0xea51, /* U+9dc1 */
  0xea57, /* U+9dc2 */
  0x0000, /* U+9dc3 */
  0xea50, /* U+9dc4 */
  0x0000, /* U+9dc5 */
  0xea55, /* U+9dc6 */
  0x0000, /* U+9dc7 */
  0x0000, /* U+9dc8 */
  0x0000, /* U+9dc9 */
  0x0000, /* U+9dca */
  0x0000, /* U+9dcb */
  0x0000, /* U+9dcc */
  0x0000, /* U+9dcd */
  0x0000, /* U+9dce */
  0xea56, /* U+9dcf */
  0x0000, /* U+9dd0 */
  0x0000, /* U+9dd1 */
  0x0000, /* U+9dd2 */
  0xea59, /* U+9dd3 */
  0x0000, /* U+9dd4 */
  0x0000, /* U+9dd5 */
  0x0000, /* U+9dd6 */
  0x0000, /* U+9dd7 */
  0x0000, /* U+9dd8 */
  0xea58, /* U+9dd9 */
  0x0000, /* U+9dda */
  0x0000, /* U+9ddb */
  0x0000, /* U+9ddc */
  0x0000, /* U+9ddd */
  0x0000, /* U+9dde */
  0x0000, /* U+9ddf */
  0x0000, /* U+9de0 */
  0x0000, /* U+9de1 */
  0x0000, /* U+9de2 */
  0x0000, /* U+9de3 */
  0x0000, /* U+9de4 */
  0x0000, /* U+9de5 */
  0xea5b, /* U+9de6 */
  0x0000, /* U+9de7 */
  0x0000, /* U+9de8 */
  0x0000, /* U+9de9 */
  0x0000, /* U+9dea */
  0x0000, /* U+9deb */
  0x0000, /* U+9dec */
  0xea5c, /* U+9ded */
  0x0000, /* U+9dee */
  0xea5d, /* U+9def */
  0x0000, /* U+9df0 */
  0x0000, /* U+9df1 */
  0x9868, /* U+9df2 */
  0x0000, /* U+9df3 */
  0x0000, /* U+9df4 */
  0x0000, /* U+9df5 */
  0x0000, /* U+9df6 */
  0x0000, /* U+9df7 */
  0xea5a, /* U+9df8 */
  0x91e9, /* U+9df9 */
  0x8deb, /* U+9dfa */
  0x0000, /* U+9dfb */
  0x0000, /* U+9dfc */
  0xea5e, /* U+9dfd */
  0x0000, /* U+9dfe */
  0x0000, /* U+9dff */
  0x0000, /* U+9e00 */
  0x0000, /* U+9e01 */
  0x0000, /* U+9e02 */
  0x0000, /* U+9e03 */
  0x0000, /* U+9e04 */
  0x0000, /* U+9e05 */
  0x0000, /* U+9e06 */
  0x0000, /* U+9e07 */
  0x0000, /* U+9e08 */
  0x0000, /* U+9e09 */
  0x0000, /* U+9e0a */
  0x0000, /* U+9e0b */
  0x0000, /* U+9e0c */
  0x0000, /* U+9e0d */
  0x0000, /* U+9e0e */
  0x0000, /* U+9e0f */
  0x0000, /* U+9e10 */
  0x0000, /* U+9e11 */
  0x0000, /* U+9e12 */
  0x0000, /* U+9e13 */
  0x0000, /* U+9e14 */
  0x0000, /* U+9e15 */
  0x0000, /* U+9e16 */
  0x0000, /* U+9e17 */
  0x0000, /* U+9e18 */
  0xfc4a, /* U+9e19 */
  0xea5f, /* U+9e1a */
  0xea60, /* U+9e1b */
  0x0000, /* U+9e1c */
  0x0000, /* U+9e1d */
  0xea61, /* U+9e1e */
  0x0000, /* U+9e1f */
  0x0000, /* U+9e20 */
  0x0000, /* U+9e21 */
  0x0000, /* U+9e22 */
  0x0000, /* U+9e23 */
  0x0000, /* U+9e24 */
  0x0000, /* U+9e25 */
  0x0000, /* U+9e26 */
  0x0000, /* U+9e27 */
  0x0000, /* U+9e28 */
  0x0000, /* U+9e29 */
  0x0000, /* U+9e2a */
  0x0000, /* U+9e2b */
  0x0000, /* U+9e2c */
  0x0000, /* U+9e2d */
  0x0000, /* U+9e2e */
  0x0000, /* U+9e2f */
  0x0000, /* U+9e30 */
  0x0000, /* U+9e31 */
  0x0000, /* U+9e32 */
  0x0000, /* U+9e33 */
  0x0000, /* U+9e34 */
  0x0000, /* U+9e35 */
  0x0000, /* U+9e36 */
  0x0000, /* U+9e37 */
  0x0000, /* U+9e38 */
  0x0000, /* U+9e39 */
  0x0000, /* U+9e3a */
  0x0000, /* U+9e3b */
  0x0000, /* U+9e3c */
  0x0000, /* U+9e3d */
  0x0000, /* U+9e3e */
  0x0000, /* U+9e3f */
  0x0000, /* U+9e40 */
  0x0000, /* U+9e41 */
  0x0000, /* U+9e42 */
  0x0000, /* U+9e43 */
  0x0000, /* U+9e44 */
  0x0000, /* U+9e45 */
  0x0000, /* U+9e46 */
  0x0000, /* U+9e47 */
  0x0000, /* U+9e48 */
  0x0000, /* U+9e49 */
  0x0000, /* U+9e4a */
  0x0000, /* U+9e4b */
  0x0000, /* U+9e4c */
  0x0000, /* U+9e4d */
  0x0000, /* U+9e4e */
  0x0000, /* U+9e4f */
  0x0000, /* U+9e50 */
  0x0000, /* U+9e51 */
  0x0000, /* U+9e52 */
  0x0000, /* U+9e53 */
  0x0000, /* U+9e54 */
  0x0000, /* U+9e55 */
  0x0000, /* U+9e56 */
  0x0000, /* U+9e57 */
  0x0000, /* U+9e58 */
  0x0000, /* U+9e59 */
  0x0000, /* U+9e5a */
  0x0000, /* U+9e5b */
  0x0000, /* U+9e5c */
  0x0000, /* U+9e5d */
  0x0000, /* U+9e5e */
  0x0000, /* U+9e5f */
  0x0000, /* U+9e60 */
  0x0000, /* U+9e61 */
  0x0000, /* U+9e62 */
  0x0000, /* U+9e63 */
  0x0000, /* U+9e64 */
  0x0000, /* U+9e65 */
  0x0000, /* U+9e66 */
  0x0000, /* U+9e67 */
  0x0000, /* U+9e68 */
  0x0000, /* U+9e69 */
  0x0000, /* U+9e6a */
  0x0000, /* U+9e6b */
  0x0000, /* U+9e6c */
  0x0000, /* U+9e6d */
  0x0000, /* U+9e6e */
  0x0000, /* U+9e6f */
  0x0000, /* U+9e70 */
  0x0000, /* U+9e71 */
  0x0000, /* U+9e72 */
  0x0000, /* U+9e73 */
  0x0000, /* U+9e74 */
  0xea62, /* U+9e75 */
  0x0000, /* U+9e76 */
  0x0000, /* U+9e77 */
  0x8cb2, /* U+9e78 */
  0xea63, /* U+9e79 */
  0x0000, /* U+9e7a */
  0x0000, /* U+9e7b */
  0x0000, /* U+9e7c */
  0xea64, /* U+9e7d */
  0x0000, /* U+9e7e */
  0x8ead, /* U+9e7f */
  0x0000, /* U+9e80 */
  0xea65, /* U+9e81 */
  0x0000, /* U+9e82 */
  0x0000, /* U+9e83 */
  0x0000, /* U+9e84 */
  0x0000, /* U+9e85 */
  0x0000, /* U+9e86 */
  0x0000, /* U+9e87 */
  0xea66, /* U+9e88 */
  0x0000, /* U+9e89 */
  0x0000, /* U+9e8a */
  0xea67, /* U+9e8b */
  0xea68, /* U+9e8c */
  0x0000, /* U+9e8d */
  0x0000, /* U+9e8e */
  0x0000, /* U+9e8f */
  0x0000, /* U+9e90 */
  0xea6b, /* U+9e91 */
  0xea69, /* U+9e92 */
  0x985b, /* U+9e93 */
  0x0000, /* U+9e94 */
  0xea6a, /* U+9e95 */
  0x0000, /* U+9e96 */
  0x97ed, /* U+9e97 */
  0x0000, /* U+9e98 */
  0x0000, /* U+9e99 */
  0x0000, /* U+9e9a */
  0x0000, /* U+9e9b */
  0x0000, /* U+9e9c */
  0xea6c, /* U+9e9d */
  0x0000, /* U+9e9e */
  0x97d9, /* U+9e9f */
  0x0000, /* U+9ea0 */
  0x0000, /* U+9ea1 */
  0x0000, /* U+9ea2 */
  0x0000, /* U+9ea3 */
  0x0000, /* U+9ea4 */
  0xea6d, /* U+9ea5 */
  0x949e, /* U+9ea6 */
  0x0000, /* U+9ea7 */
  0x0000, /* U+9ea8 */
  0xea6e, /* U+9ea9 */
  0xea70, /* U+9eaa */
  0x0000, /* U+9eab */
  0x0000, /* U+9eac */
  0xea71, /* U+9ead */
  0x0000, /* U+9eae */
  0x0000, /* U+9eaf */
  0x0000, /* U+9eb0 */
  0x0000, /* U+9eb1 */
  0x0000, /* U+9eb2 */
  0x0000, /* U+9eb3 */
  0x0000, /* U+9eb4 */
  0x0000, /* U+9eb5 */
  0x0000, /* U+9eb6 */
  0x0000, /* U+9eb7 */
  0xea6f, /* U+9eb8 */
  0x8d8d, /* U+9eb9 */
  0x96cb, /* U+9eba */
  0x9683, /* U+9ebb */
  0x9bf5, /* U+9ebc */
  0x0000, /* U+9ebd */
  0x9f80, /* U+9ebe */
  0x969b, /* U+9ebf */
  0x0000, /* U+9ec0 */
  0x0000, /* U+9ec1 */
  0x0000, /* U+9ec2 */
  0x0000, /* U+9ec3 */
  0x89a9, /* U+9ec4 */
  0x0000, /* U+9ec5 */
  0x0000, /* U+9ec6 */
  0x0000, /* U+9ec7 */
  0x0000, /* U+9ec8 */
  0x0000, /* U+9ec9 */
  0x0000, /* U+9eca */
  0x0000, /* U+9ecb */
  0xea73, /* U+9ecc */
  0x8b6f, /* U+9ecd */
  0xea74, /* U+9ece */
  0xea75, /* U+9ecf */
  0xea76, /* U+9ed0 */
  0xfc4b, /* U+9ed1 */
  0x8d95, /* U+9ed2 */
  0x0000, /* U+9ed3 */
  0xea77, /* U+9ed4 */
  0x0000, /* U+9ed5 */
  0x0000, /* U+9ed6 */
  0x0000, /* U+9ed7 */
  0xe0d2, /* U+9ed8 */
  0x96d9, /* U+9ed9 */
  0x0000, /* U+9eda */
  0x91e1, /* U+9edb */
  0xea78, /* U+9edc */
  0xea7a, /* U+9edd */
  0xea79, /* U+9ede */
  0x0000, /* U+9edf */
  0xea7b, /* U+9ee0 */
  0x0000, /* U+9ee1 */
  0x0000, /* U+9ee2 */
  0x0000, /* U+9ee3 */
  0x0000, /* U+9ee4 */
  0xea7c, /* U+9ee5 */
  0x0000, /* U+9ee6 */
  0x0000, /* U+9ee7 */
  0xea7d, /* U+9ee8 */
  0x0000, /* U+9ee9 */
  0x0000, /* U+9eea */
  0x0000, /* U+9eeb */
  0x0000, /* U+9eec */
  0x0000, /* U+9eed */
  0x0000, /* U+9eee */
  0xea7e, /* U+9eef */
  0x0000, /* U+9ef0 */
  0x0000, /* U+9ef1 */
  0x0000, /* U+9ef2 */
  0x0000, /* U+9ef3 */
  0xea80, /* U+9ef4 */
  0x0000, /* U+9ef5 */
  0xea81, /* U+9ef6 */
  0xea82, /* U+9ef7 */
  0x0000, /* U+9ef8 */
  0xea83, /* U+9ef9 */
  0x0000, /* U+9efa */
  0xea84, /* U+9efb */
  0xea85, /* U+9efc */
  0xea86, /* U+9efd */
  0x0000, /* U+9efe */
  0x0000, /* U+9eff */
  0x0000, /* U+9f00 */
  0x0000, /* U+9f01 */
  0x0000, /* U+9f02 */
  0x0000, /* U+9f03 */
  0x0000, /* U+9f04 */
  0x0000, /* U+9f05 */
  0x0000, /* U+9f06 */
  0xea87, /* U+9f07 */
  0xea88, /* U+9f08 */
  0x0000, /* U+9f09 */
  0x0000, /* U+9f0a */
  0x0000, /* U+9f0b */
  0x0000, /* U+9f0c */
  0x0000, /* U+9f0d */
  0x9343, /* U+9f0e */
  0x0000, /* U+9f0f */
  0x0000, /* U+9f10 */
  0x0000, /* U+9f11 */
  0x0000, /* U+9f12 */
  0x8cdb, /* U+9f13 */
  0x0000, /* U+9f14 */
  0xea8a, /* U+9f15 */
  0x0000, /* U+9f16 */
  0x0000, /* U+9f17 */
  0x0000, /* U+9f18 */
  0x0000, /* U+9f19 */
  0x0000, /* U+9f1a */
  0x0000, /* U+9f1b */
  0x0000, /* U+9f1c */
  0x0000, /* U+9f1d */
  0x0000, /* U+9f1e */
  0x0000, /* U+9f1f */
  0x916c, /* U+9f20 */
  0xea8b, /* U+9f21 */
  0x0000, /* U+9f22 */
  0x0000, /* U+9f23 */
  0x0000, /* U+9f24 */
  0x0000, /* U+9f25 */
  0x0000, /* U+9f26 */
  0x0000, /* U+9f27 */
  0x0000, /* U+9f28 */
  0x0000, /* U+9f29 */
  0x0000, /* U+9f2a */
  0x0000, /* U+9f2b */
  0xea8c, /* U+9f2c */
  0x0000, /* U+9f2d */
  0x0000, /* U+9f2e */
  0x0000, /* U+9f2f */
  0x0000, /* U+9f30 */
  0x0000, /* U+9f31 */
  0x0000, /* U+9f32 */
  0x0000, /* U+9f33 */
  0x0000, /* U+9f34 */
  0x0000, /* U+9f35 */
  0x0000, /* U+9f36 */
  0x0000, /* U+9f37 */
  0x0000, /* U+9f38 */
  0x0000, /* U+9f39 */
  0x0000, /* U+9f3a */
  0x9540, /* U+9f3b */
  0x0000, /* U+9f3c */
  0x0000, /* U+9f3d */
  0xea8d, /* U+9f3e */
  0x0000, /* U+9f3f */
  0x0000, /* U+9f40 */
  0x0000, /* U+9f41 */
  0x0000, /* U+9f42 */
  0x0000, /* U+9f43 */
  0x0000, /* U+9f44 */
  0x0000, /* U+9f45 */
  0x0000, /* U+9f46 */
  0x0000, /* U+9f47 */
  0x0000, /* U+9f48 */
  0x0000, /* U+9f49 */
  0xea8e, /* U+9f4a */
  0xe256, /* U+9f4b */
  0x0000, /* U+9f4c */
  0x0000, /* U+9f4d */
  0xe6d8, /* U+9f4e */
  0xe8eb, /* U+9f4f */
  0x0000, /* U+9f50 */
  0x0000, /* U+9f51 */
  0xea8f, /* U+9f52 */
  0x0000, /* U+9f53 */
  0xea90, /* U+9f54 */
  0x0000, /* U+9f55 */
  0x0000, /* U+9f56 */
  0x0000, /* U+9f57 */
  0x0000, /* U+9f58 */
  0x0000, /* U+9f59 */
  0x0000, /* U+9f5a */
  0x0000, /* U+9f5b */
  0x0000, /* U+9f5c */
  0x0000, /* U+9f5d */
  0x0000, /* U+9f5e */
  0xea92, /* U+9f5f */
  0xea93, /* U+9f60 */
  0xea94, /* U+9f61 */
  0x97ee, /* U+9f62 */
  0xea91, /* U+9f63 */
  0x0000, /* U+9f64 */
  0x0000, /* U+9f65 */
  0xea95, /* U+9f66 */
  0xea96, /* U+9f67 */
  0x0000, /* U+9f68 */
  0x0000, /* U+9f69 */
  0xea98, /* U+9f6a */
  0x0000, /* U+9f6b */
  0xea97, /* U+9f6c */
  0x0000, /* U+9f6d */
  0x0000, /* U+9f6e */
  0x0000, /* U+9f6f */
  0x0000, /* U+9f70 */
  0x0000, /* U+9f71 */
  0xea9a, /* U+9f72 */
  0x0000, /* U+9f73 */
  0x0000, /* U+9f74 */
  0x0000, /* U+9f75 */
  0xea9b, /* U+9f76 */
  0xea99, /* U+9f77 */
  0x0000, /* U+9f78 */
  0x0000, /* U+9f79 */
  0x0000, /* U+9f7a */
  0x0000, /* U+9f7b */
  0x0000, /* U+9f7c */
  0x0000, /* U+9f7d */
  0x0000, /* U+9f7e */
  0x0000, /* U+9f7f */
  0x0000, /* U+9f80 */
  0x0000, /* U+9f81 */
  0x0000, /* U+9f82 */
  0x0000, /* U+9f83 */
  0x0000, /* U+9f84 */
  0x0000, /* U+9f85 */
  0x0000, /* U+9f86 */
  0x0000, /* U+9f87 */
  0x0000, /* U+9f88 */
  0x0000, /* U+9f89 */
  0x0000, /* U+9f8a */
  0x0000, /* U+9f8b */
  0x0000, /* U+9f8c */
  0x97b4, /* U+9f8d */
  0x0000, /* U+9f8e */
  0x0000, /* U+9f8f */
  0x0000, /* U+9f90 */
  0x0000, /* U+9f91 */
  0x0000, /* U+9f92 */
  0x0000, /* U+9f93 */
  0x0000, /* U+9f94 */
  0xea9c, /* U+9f95 */
  0x0000, /* U+9f96 */
  0x0000, /* U+9f97 */
  0x0000, /* U+9f98 */
  0x0000, /* U+9f99 */
  0x0000, /* U+9f9a */
  0x0000, /* U+9f9b */
  0xea9d, /* U+9f9c */
  0xe273, /* U+9f9d */
  0x0000, /* U+9f9e */
  0x0000, /* U+9f9f */
  0xea9e, /* U+9fa0 */
  0x0000, /* U+9fa1 */
  0x0000, /* U+9fa2 */
  0x0000, /* U+9fa3 */
  0x0000, /* U+9fa4 */
  0x0000, /* U+9fa5 */
  0x0000, /* U+9fa6 */
  0x0000, /* U+9fa7 */
  0x0000, /* U+9fa8 */
  0x0000, /* U+9fa9 */
  0x0000, /* U+9faa */
  0x0000, /* U+9fab */
  0x0000, /* U+9fac */
  0x0000, /* U+9fad */
  0x0000, /* U+9fae */
  0x0000, /* U+9faf */
  0x0000, /* U+9fb0 */
  0x0000, /* U+9fb1 */
  0x0000, /* U+9fb2 */
  0x0000, /* U+9fb3 */
  0x0000, /* U+9fb4 */
  0x0000, /* U+9fb5 */
  0x0000, /* U+9fb6 */
  0x0000, /* U+9fb7 */
  0x0000, /* U+9fb8 */
  0x0000, /* U+9fb9 */
  0x0000, /* U+9fba */
  0x0000, /* U+9fbb */
  0x0000, /* U+9fbc */
  0x0000, /* U+9fbd */
  0x0000, /* U+9fbe */
  0x0000, /* U+9fbf */
  0x0000, /* U+9fc0 */
  0x0000, /* U+9fc1 */
  0x0000, /* U+9fc2 */
  0x0000, /* U+9fc3 */
  0x0000, /* U+9fc4 */
  0x0000, /* U+9fc5 */
  0x0000, /* U+9fc6 */
  0x0000, /* U+9fc7 */
  0x0000, /* U+9fc8 */
  0x0000, /* U+9fc9 */
  0x0000, /* U+9fca */
  0x0000, /* U+9fcb */
  0x0000, /* U+9fcc */
  0x0000, /* U+9fcd */
  0x0000, /* U+9fce */
  0x0000, /* U+9fcf */
  0x0000, /* U+9fd0 */
  0x0000, /* U+9fd1 */
  0x0000, /* U+9fd2 */
  0x0000, /* U+9fd3 */
  0x0000, /* U+9fd4 */
  0x0000, /* U+9fd5 */
  0x0000, /* U+9fd6 */
  0x0000, /* U+9fd7 */
  0x0000, /* U+9fd8 */
  0x0000, /* U+9fd9 */
  0x0000, /* U+9fda */
  0x0000, /* U+9fdb */
  0x0000, /* U+9fdc */
  0x0000, /* U+9fdd */
  0x0000, /* U+9fde */
  0x0000, /* U+9fdf */
  0x0000, /* U+9fe0 */
  0x0000, /* U+9fe1 */
  0x0000, /* U+9fe2 */
  0x0000, /* U+9fe3 */
  0x0000, /* U+9fe4 */
  0x0000, /* U+9fe5 */
  0x0000, /* U+9fe6 */
  0x0000, /* U+9fe7 */
  0x0000, /* U+9fe8 */
  0x0000, /* U+9fe9 */
  0x0000, /* U+9fea */
  0x0000, /* U+9feb */
  0x0000, /* U+9fec */
  0x0000, /* U+9fed */
  0x0000, /* U+9fee */
  0x0000, /* U+9fef */
  0x0000, /* U+9ff0 */
  0x0000, /* U+9ff1 */
  0x0000, /* U+9ff2 */
  0x0000, /* U+9ff3 */
  0x0000, /* U+9ff4 */
  0x0000, /* U+9ff5 */
  0x0000, /* U+9ff6 */
  0x0000, /* U+9ff7 */
  0x0000, /* U+9ff8 */
  0x0000, /* U+9ff9 */
  0x0000, /* U+9ffa */
  0x0000, /* U+9ffb */
  0x0000, /* U+9ffc */
  0x0000, /* U+9ffd */
  0x0000, /* U+9ffe */
  0x0000, /* U+9fff */
  0x0000, /* U+a000 */
  0x0000, /* U+a001 */
  0x0000, /* U+a002 */
  0x0000, /* U+a003 */
  0x0000, /* U+a004 */
  0x0000, /* U+a005 */
  0x0000, /* U+a006 */
  0x0000, /* U+a007 */
  0x0000, /* U+a008 */
  0x0000, /* U+a009 */
  0x0000, /* U+a00a */
  0x0000, /* U+a00b */
  0x0000, /* U+a00c */
  0x0000, /* U+a00d */
  0x0000, /* U+a00e */
  0x0000, /* U+a00f */
  0x0000, /* U+a010 */
  0x0000, /* U+a011 */
  0x0000, /* U+a012 */
  0x0000, /* U+a013 */
  0x0000, /* U+a014 */
  0x0000, /* U+a015 */
  0x0000, /* U+a016 */
  0x0000, /* U+a017 */
  0x0000, /* U+a018 */
  0x0000, /* U+a019 */
  0x0000, /* U+a01a */
  0x0000, /* U+a01b */
  0x0000, /* U+a01c */
  0x0000, /* U+a01d */
  0x0000, /* U+a01e */
  0x0000, /* U+a01f */
  0x0000, /* U+a020 */
  0x0000, /* U+a021 */
  0x0000, /* U+a022 */
  0x0000, /* U+a023 */
  0x0000, /* U+a024 */
  0x0000, /* U+a025 */
  0x0000, /* U+a026 */
  0x0000, /* U+a027 */
  0x0000, /* U+a028 */
  0x0000, /* U+a029 */
  0x0000, /* U+a02a */
  0x0000, /* U+a02b */
  0x0000, /* U+a02c */
  0x0000, /* U+a02d */
  0x0000, /* U+a02e */
  0x0000, /* U+a02f */
  0x0000, /* U+a030 */
  0x0000, /* U+a031 */
  0x0000, /* U+a032 */
  0x0000, /* U+a033 */
  0x0000, /* U+a034 */
  0x0000, /* U+a035 */
  0x0000, /* U+a036 */
  0x0000, /* U+a037 */
  0x0000, /* U+a038 */
  0x0000, /* U+a039 */
  0x0000, /* U+a03a */
  0x0000, /* U+a03b */
  0x0000, /* U+a03c */
  0x0000, /* U+a03d */
  0x0000, /* U+a03e */
  0x0000, /* U+a03f */
  0x0000, /* U+a040 */
  0x0000, /* U+a041 */
  0x0000, /* U+a042 */
  0x0000, /* U+a043 */
  0x0000, /* U+a044 */
  0x0000, /* U+a045 */
  0x0000, /* U+a046 */
  0x0000, /* U+a047 */
  0x0000, /* U+a048 */
  0x0000, /* U+a049 */
  0x0000, /* U+a04a */
  0x0000, /* U+a04b */
  0x0000, /* U+a04c */
  0x0000, /* U+a04d */
  0x0000, /* U+a04e */
  0x0000, /* U+a04f */
  0x0000, /* U+a050 */
  0x0000, /* U+a051 */
  0x0000, /* U+a052 */
  0x0000, /* U+a053 */
  0x0000, /* U+a054 */
  0x0000, /* U+a055 */
  0x0000, /* U+a056 */
  0x0000, /* U+a057 */
  0x0000, /* U+a058 */
  0x0000, /* U+a059 */
  0x0000, /* U+a05a */
  0x0000, /* U+a05b */
  0x0000, /* U+a05c */
  0x0000, /* U+a05d */
  0x0000, /* U+a05e */
  0x0000, /* U+a05f */
  0x0000, /* U+a060 */
  0x0000, /* U+a061 */
  0x0000, /* U+a062 */
  0x0000, /* U+a063 */
  0x0000, /* U+a064 */
  0x0000, /* U+a065 */
  0x0000, /* U+a066 */
  0x0000, /* U+a067 */
  0x0000, /* U+a068 */
  0x0000, /* U+a069 */
  0x0000, /* U+a06a */
  0x0000, /* U+a06b */
  0x0000, /* U+a06c */
  0x0000, /* U+a06d */
  0x0000, /* U+a06e */
  0x0000, /* U+a06f */
  0x0000, /* U+a070 */
  0x0000, /* U+a071 */
  0x0000, /* U+a072 */
  0x0000, /* U+a073 */
  0x0000, /* U+a074 */
  0x0000, /* U+a075 */
  0x0000, /* U+a076 */
  0x0000, /* U+a077 */
  0x0000, /* U+a078 */
  0x0000, /* U+a079 */
  0x0000, /* U+a07a */
  0x0000, /* U+a07b */
  0x0000, /* U+a07c */
  0x0000, /* U+a07d */
  0x0000, /* U+a07e */
  0x0000, /* U+a07f */
  0x0000, /* U+a080 */
  0x0000, /* U+a081 */
  0x0000, /* U+a082 */
  0x0000, /* U+a083 */
  0x0000, /* U+a084 */
  0x0000, /* U+a085 */
  0x0000, /* U+a086 */
  0x0000, /* U+a087 */
  0x0000, /* U+a088 */
  0x0000, /* U+a089 */
  0x0000, /* U+a08a */
  0x0000, /* U+a08b */
  0x0000, /* U+a08c */
  0x0000, /* U+a08d */
  0x0000, /* U+a08e */
  0x0000, /* U+a08f */
  0x0000, /* U+a090 */
  0x0000, /* U+a091 */
  0x0000, /* U+a092 */
  0x0000, /* U+a093 */
  0x0000, /* U+a094 */
  0x0000, /* U+a095 */
  0x0000, /* U+a096 */
  0x0000, /* U+a097 */
  0x0000, /* U+a098 */
  0x0000, /* U+a099 */
  0x0000, /* U+a09a */
  0x0000, /* U+a09b */
  0x0000, /* U+a09c */
  0x0000, /* U+a09d */
  0x0000, /* U+a09e */
  0x0000, /* U+a09f */
  0x0000, /* U+a0a0 */
  0x0000, /* U+a0a1 */
  0x0000, /* U+a0a2 */
  0x0000, /* U+a0a3 */
  0x0000, /* U+a0a4 */
  0x0000, /* U+a0a5 */
  0x0000, /* U+a0a6 */
  0x0000, /* U+a0a7 */
  0x0000, /* U+a0a8 */
  0x0000, /* U+a0a9 */
  0x0000, /* U+a0aa */
  0x0000, /* U+a0ab */
  0x0000, /* U+a0ac */
  0x0000, /* U+a0ad */
  0x0000, /* U+a0ae */
  0x0000, /* U+a0af */
  0x0000, /* U+a0b0 */
  0x0000, /* U+a0b1 */
  0x0000, /* U+a0b2 */
  0x0000, /* U+a0b3 */
  0x0000, /* U+a0b4 */
  0x0000, /* U+a0b5 */
  0x0000, /* U+a0b6 */
  0x0000, /* U+a0b7 */
  0x0000, /* U+a0b8 */
  0x0000, /* U+a0b9 */
  0x0000, /* U+a0ba */
  0x0000, /* U+a0bb */
  0x0000, /* U+a0bc */
  0x0000, /* U+a0bd */
  0x0000, /* U+a0be */
  0x0000, /* U+a0bf */
  0x0000, /* U+a0c0 */
  0x0000, /* U+a0c1 */
  0x0000, /* U+a0c2 */
  0x0000, /* U+a0c3 */
  0x0000, /* U+a0c4 */
  0x0000, /* U+a0c5 */
  0x0000, /* U+a0c6 */
  0x0000, /* U+a0c7 */
  0x0000, /* U+a0c8 */
  0x0000, /* U+a0c9 */
  0x0000, /* U+a0ca */
  0x0000, /* U+a0cb */
  0x0000, /* U+a0cc */
  0x0000, /* U+a0cd */
  0x0000, /* U+a0ce */
  0x0000, /* U+a0cf */
  0x0000, /* U+a0d0 */
  0x0000, /* U+a0d1 */
  0x0000, /* U+a0d2 */
  0x0000, /* U+a0d3 */
  0x0000, /* U+a0d4 */
  0x0000, /* U+a0d5 */
  0x0000, /* U+a0d6 */
  0x0000, /* U+a0d7 */
  0x0000, /* U+a0d8 */
  0x0000, /* U+a0d9 */
  0x0000, /* U+a0da */
  0x0000, /* U+a0db */
  0x0000, /* U+a0dc */
  0x0000, /* U+a0dd */
  0x0000, /* U+a0de */
  0x0000, /* U+a0df */
  0x0000, /* U+a0e0 */
  0x0000, /* U+a0e1 */
  0x0000, /* U+a0e2 */
  0x0000, /* U+a0e3 */
  0x0000, /* U+a0e4 */
  0x0000, /* U+a0e5 */
  0x0000, /* U+a0e6 */
  0x0000, /* U+a0e7 */
  0x0000, /* U+a0e8 */
  0x0000, /* U+a0e9 */
  0x0000, /* U+a0ea */
  0x0000, /* U+a0eb */
  0x0000, /* U+a0ec */
  0x0000, /* U+a0ed */
  0x0000, /* U+a0ee */
  0x0000, /* U+a0ef */
  0x0000, /* U+a0f0 */
  0x0000, /* U+a0f1 */
  0x0000, /* U+a0f2 */
  0x0000, /* U+a0f3 */
  0x0000, /* U+a0f4 */
  0x0000, /* U+a0f5 */
  0x0000, /* U+a0f6 */
  0x0000, /* U+a0f7 */
  0x0000, /* U+a0f8 */
  0x0000, /* U+a0f9 */
  0x0000, /* U+a0fa */
  0x0000, /* U+a0fb */
  0x0000, /* U+a0fc */
  0x0000, /* U+a0fd */
  0x0000, /* U+a0fe */
  0x0000, /* U+a0ff */
  0x0000, /* U+a100 */
  0x0000, /* U+a101 */
  0x0000, /* U+a102 */
  0x0000, /* U+a103 */
  0x0000, /* U+a104 */
  0x0000, /* U+a105 */
  0x0000, /* U+a106 */
  0x0000, /* U+a107 */
  0x0000, /* U+a108 */
  0x0000, /* U+a109 */
  0x0000, /* U+a10a */
  0x0000, /* U+a10b */
  0x0000, /* U+a10c */
  0x0000, /* U+a10d */
  0x0000, /* U+a10e */
  0x0000, /* U+a10f */
  0x0000, /* U+a110 */
  0x0000, /* U+a111 */
  0x0000, /* U+a112 */
  0x0000, /* U+a113 */
  0x0000, /* U+a114 */
  0x0000, /* U+a115 */
  0x0000, /* U+a116 */
  0x0000, /* U+a117 */
  0x0000, /* U+a118 */
  0x0000, /* U+a119 */
  0x0000, /* U+a11a */
  0x0000, /* U+a11b */
  0x0000, /* U+a11c */
  0x0000, /* U+a11d */
  0x0000, /* U+a11e */
  0x0000, /* U+a11f */
  0x0000, /* U+a120 */
  0x0000, /* U+a121 */
  0x0000, /* U+a122 */
  0x0000, /* U+a123 */
  0x0000, /* U+a124 */
  0x0000, /* U+a125 */
  0x0000, /* U+a126 */
  0x0000, /* U+a127 */
  0x0000, /* U+a128 */
  0x0000, /* U+a129 */
  0x0000, /* U+a12a */
  0x0000, /* U+a12b */
  0x0000, /* U+a12c */
  0x0000, /* U+a12d */
  0x0000, /* U+a12e */
  0x0000, /* U+a12f */
  0x0000, /* U+a130 */
  0x0000, /* U+a131 */
  0x0000, /* U+a132 */
  0x0000, /* U+a133 */
  0x0000, /* U+a134 */
  0x0000, /* U+a135 */
  0x0000, /* U+a136 */
  0x0000, /* U+a137 */
  0x0000, /* U+a138 */
  0x0000, /* U+a139 */
  0x0000, /* U+a13a */
  0x0000, /* U+a13b */
  0x0000, /* U+a13c */
  0x0000, /* U+a13d */
  0x0000, /* U+a13e */
  0x0000, /* U+a13f */
  0x0000, /* U+a140 */
  0x0000, /* U+a141 */
  0x0000, /* U+a142 */
  0x0000, /* U+a143 */
  0x0000, /* U+a144 */
  0x0000, /* U+a145 */
  0x0000, /* U+a146 */
  0x0000, /* U+a147 */
  0x0000, /* U+a148 */
  0x0000, /* U+a149 */
  0x0000, /* U+a14a */
  0x0000, /* U+a14b */
  0x0000, /* U+a14c */
  0x0000, /* U+a14d */
  0x0000, /* U+a14e */
  0x0000, /* U+a14f */
  0x0000, /* U+a150 */
  0x0000, /* U+a151 */
  0x0000, /* U+a152 */
  0x0000, /* U+a153 */
  0x0000, /* U+a154 */
  0x0000, /* U+a155 */
  0x0000, /* U+a156 */
  0x0000, /* U+a157 */
  0x0000, /* U+a158 */
  0x0000, /* U+a159 */
  0x0000, /* U+a15a */
  0x0000, /* U+a15b */
  0x0000, /* U+a15c */
  0x0000, /* U+a15d */
  0x0000, /* U+a15e */
  0x0000, /* U+a15f */
  0x0000, /* U+a160 */
  0x0000, /* U+a161 */
  0x0000, /* U+a162 */
  0x0000, /* U+a163 */
  0x0000, /* U+a164 */
  0x0000, /* U+a165 */
  0x0000, /* U+a166 */
  0x0000, /* U+a167 */
  0x0000, /* U+a168 */
  0x0000, /* U+a169 */
  0x0000, /* U+a16a */
  0x0000, /* U+a16b */
  0x0000, /* U+a16c */
  0x0000, /* U+a16d */
  0x0000, /* U+a16e */
  0x0000, /* U+a16f */
  0x0000, /* U+a170 */
  0x0000, /* U+a171 */
  0x0000, /* U+a172 */
  0x0000, /* U+a173 */
  0x0000, /* U+a174 */
  0x0000, /* U+a175 */
  0x0000, /* U+a176 */
  0x0000, /* U+a177 */
  0x0000, /* U+a178 */
  0x0000, /* U+a179 */
  0x0000, /* U+a17a */
  0x0000, /* U+a17b */
  0x0000, /* U+a17c */
  0x0000, /* U+a17d */
  0x0000, /* U+a17e */
  0x0000, /* U+a17f */
  0x0000, /* U+a180 */
  0x0000, /* U+a181 */
  0x0000, /* U+a182 */
  0x0000, /* U+a183 */
  0x0000, /* U+a184 */
  0x0000, /* U+a185 */
  0x0000, /* U+a186 */
  0x0000, /* U+a187 */
  0x0000, /* U+a188 */
  0x0000, /* U+a189 */
  0x0000, /* U+a18a */
  0x0000, /* U+a18b */
  0x0000, /* U+a18c */
  0x0000, /* U+a18d */
  0x0000, /* U+a18e */
  0x0000, /* U+a18f */
  0x0000, /* U+a190 */
  0x0000, /* U+a191 */
  0x0000, /* U+a192 */
  0x0000, /* U+a193 */
  0x0000, /* U+a194 */
  0x0000, /* U+a195 */
  0x0000, /* U+a196 */
  0x0000, /* U+a197 */
  0x0000, /* U+a198 */
  0x0000, /* U+a199 */
  0x0000, /* U+a19a */
  0x0000, /* U+a19b */
  0x0000, /* U+a19c */
  0x0000, /* U+a19d */
  0x0000, /* U+a19e */
  0x0000, /* U+a19f */
  0x0000, /* U+a1a0 */
  0x0000, /* U+a1a1 */
  0x0000, /* U+a1a2 */
  0x0000, /* U+a1a3 */
  0x0000, /* U+a1a4 */
  0x0000, /* U+a1a5 */
  0x0000, /* U+a1a6 */
  0x0000, /* U+a1a7 */
  0x0000, /* U+a1a8 */
  0x0000, /* U+a1a9 */
  0x0000, /* U+a1aa */
  0x0000, /* U+a1ab */
  0x0000, /* U+a1ac */
  0x0000, /* U+a1ad */
  0x0000, /* U+a1ae */
  0x0000, /* U+a1af */
  0x0000, /* U+a1b0 */
  0x0000, /* U+a1b1 */
  0x0000, /* U+a1b2 */
  0x0000, /* U+a1b3 */
  0x0000, /* U+a1b4 */
  0x0000, /* U+a1b5 */
  0x0000, /* U+a1b6 */
  0x0000, /* U+a1b7 */
  0x0000, /* U+a1b8 */
  0x0000, /* U+a1b9 */
  0x0000, /* U+a1ba */
  0x0000, /* U+a1bb */
  0x0000, /* U+a1bc */
  0x0000, /* U+a1bd */
  0x0000, /* U+a1be */
  0x0000, /* U+a1bf */
  0x0000, /* U+a1c0 */
  0x0000, /* U+a1c1 */
  0x0000, /* U+a1c2 */
  0x0000, /* U+a1c3 */
  0x0000, /* U+a1c4 */
  0x0000, /* U+a1c5 */
  0x0000, /* U+a1c6 */
  0x0000, /* U+a1c7 */
  0x0000, /* U+a1c8 */
  0x0000, /* U+a1c9 */
  0x0000, /* U+a1ca */
  0x0000, /* U+a1cb */
  0x0000, /* U+a1cc */
  0x0000, /* U+a1cd */
  0x0000, /* U+a1ce */
  0x0000, /* U+a1cf */
  0x0000, /* U+a1d0 */
  0x0000, /* U+a1d1 */
  0x0000, /* U+a1d2 */
  0x0000, /* U+a1d3 */
  0x0000, /* U+a1d4 */
  0x0000, /* U+a1d5 */
  0x0000, /* U+a1d6 */
  0x0000, /* U+a1d7 */
  0x0000, /* U+a1d8 */
  0x0000, /* U+a1d9 */
  0x0000, /* U+a1da */
  0x0000, /* U+a1db */
  0x0000, /* U+a1dc */
  0x0000, /* U+a1dd */
  0x0000, /* U+a1de */
  0x0000, /* U+a1df */
  0x0000, /* U+a1e0 */
  0x0000, /* U+a1e1 */
  0x0000, /* U+a1e2 */
  0x0000, /* U+a1e3 */
  0x0000, /* U+a1e4 */
  0x0000, /* U+a1e5 */
  0x0000, /* U+a1e6 */
  0x0000, /* U+a1e7 */
  0x0000, /* U+a1e8 */
  0x0000, /* U+a1e9 */
  0x0000, /* U+a1ea */
  0x0000, /* U+a1eb */
  0x0000, /* U+a1ec */
  0x0000, /* U+a1ed */
  0x0000, /* U+a1ee */
  0x0000, /* U+a1ef */
  0x0000, /* U+a1f0 */
  0x0000, /* U+a1f1 */
  0x0000, /* U+a1f2 */
  0x0000, /* U+a1f3 */
  0x0000, /* U+a1f4 */
  0x0000, /* U+a1f5 */
  0x0000, /* U+a1f6 */
  0x0000, /* U+a1f7 */
  0x0000, /* U+a1f8 */
  0x0000, /* U+a1f9 */
  0x0000, /* U+a1fa */
  0x0000, /* U+a1fb */
  0x0000, /* U+a1fc */
  0x0000, /* U+a1fd */
  0x0000, /* U+a1fe */
  0x0000, /* U+a1ff */
  0x0000, /* U+a200 */
  0x0000, /* U+a201 */
  0x0000, /* U+a202 */
  0x0000, /* U+a203 */
  0x0000, /* U+a204 */
  0x0000, /* U+a205 */
  0x0000, /* U+a206 */
  0x0000, /* U+a207 */
  0x0000, /* U+a208 */
  0x0000, /* U+a209 */
  0x0000, /* U+a20a */
  0x0000, /* U+a20b */
  0x0000, /* U+a20c */
  0x0000, /* U+a20d */
  0x0000, /* U+a20e */
  0x0000, /* U+a20f */
  0x0000, /* U+a210 */
  0x0000, /* U+a211 */
  0x0000, /* U+a212 */
  0x0000, /* U+a213 */
  0x0000, /* U+a214 */
  0x0000, /* U+a215 */
  0x0000, /* U+a216 */
  0x0000, /* U+a217 */
  0x0000, /* U+a218 */
  0x0000, /* U+a219 */
  0x0000, /* U+a21a */
  0x0000, /* U+a21b */
  0x0000, /* U+a21c */
  0x0000, /* U+a21d */
  0x0000, /* U+a21e */
  0x0000, /* U+a21f */
  0x0000, /* U+a220 */
  0x0000, /* U+a221 */
  0x0000, /* U+a222 */
  0x0000, /* U+a223 */
  0x0000, /* U+a224 */
  0x0000, /* U+a225 */
  0x0000, /* U+a226 */
  0x0000, /* U+a227 */
  0x0000, /* U+a228 */
  0x0000, /* U+a229 */
  0x0000, /* U+a22a */
  0x0000, /* U+a22b */
  0x0000, /* U+a22c */
  0x0000, /* U+a22d */
  0x0000, /* U+a22e */
  0x0000, /* U+a22f */
  0x0000, /* U+a230 */
  0x0000, /* U+a231 */
  0x0000, /* U+a232 */
  0x0000, /* U+a233 */
  0x0000, /* U+a234 */
  0x0000, /* U+a235 */
  0x0000, /* U+a236 */
  0x0000, /* U+a237 */
  0x0000, /* U+a238 */
  0x0000, /* U+a239 */
  0x0000, /* U+a23a */
  0x0000, /* U+a23b */
  0x0000, /* U+a23c */
  0x0000, /* U+a23d */
  0x0000, /* U+a23e */
  0x0000, /* U+a23f */
  0x0000, /* U+a240 */
  0x0000, /* U+a241 */
  0x0000, /* U+a242 */
  0x0000, /* U+a243 */
  0x0000, /* U+a244 */
  0x0000, /* U+a245 */
  0x0000, /* U+a246 */
  0x0000, /* U+a247 */
  0x0000, /* U+a248 */
  0x0000, /* U+a249 */
  0x0000, /* U+a24a */
  0x0000, /* U+a24b */
  0x0000, /* U+a24c */
  0x0000, /* U+a24d */
  0x0000, /* U+a24e */
  0x0000, /* U+a24f */
  0x0000, /* U+a250 */
  0x0000, /* U+a251 */
  0x0000, /* U+a252 */
  0x0000, /* U+a253 */
  0x0000, /* U+a254 */
  0x0000, /* U+a255 */
  0x0000, /* U+a256 */
  0x0000, /* U+a257 */
  0x0000, /* U+a258 */
  0x0000, /* U+a259 */
  0x0000, /* U+a25a */
  0x0000, /* U+a25b */
  0x0000, /* U+a25c */
  0x0000, /* U+a25d */
  0x0000, /* U+a25e */
  0x0000, /* U+a25f */
  0x0000, /* U+a260 */
  0x0000, /* U+a261 */
  0x0000, /* U+a262 */
  0x0000, /* U+a263 */
  0x0000, /* U+a264 */
  0x0000, /* U+a265 */
  0x0000, /* U+a266 */
  0x0000, /* U+a267 */
  0x0000, /* U+a268 */
  0x0000, /* U+a269 */
  0x0000, /* U+a26a */
  0x0000, /* U+a26b */
  0x0000, /* U+a26c */
  0x0000, /* U+a26d */
  0x0000, /* U+a26e */
  0x0000, /* U+a26f */
  0x0000, /* U+a270 */
  0x0000, /* U+a271 */
  0x0000, /* U+a272 */
  0x0000, /* U+a273 */
  0x0000, /* U+a274 */
  0x0000, /* U+a275 */
  0x0000, /* U+a276 */
  0x0000, /* U+a277 */
  0x0000, /* U+a278 */
  0x0000, /* U+a279 */
  0x0000, /* U+a27a */
  0x0000, /* U+a27b */
  0x0000, /* U+a27c */
  0x0000, /* U+a27d */
  0x0000, /* U+a27e */
  0x0000, /* U+a27f */
  0x0000, /* U+a280 */
  0x0000, /* U+a281 */
  0x0000, /* U+a282 */
  0x0000, /* U+a283 */
  0x0000, /* U+a284 */
  0x0000, /* U+a285 */
  0x0000, /* U+a286 */
  0x0000, /* U+a287 */
  0x0000, /* U+a288 */
  0x0000, /* U+a289 */
  0x0000, /* U+a28a */
  0x0000, /* U+a28b */
  0x0000, /* U+a28c */
  0x0000, /* U+a28d */
  0x0000, /* U+a28e */
  0x0000, /* U+a28f */
  0x0000, /* U+a290 */
  0x0000, /* U+a291 */
  0x0000, /* U+a292 */
  0x0000, /* U+a293 */
  0x0000, /* U+a294 */
  0x0000, /* U+a295 */
  0x0000, /* U+a296 */
  0x0000, /* U+a297 */
  0x0000, /* U+a298 */
  0x0000, /* U+a299 */
  0x0000, /* U+a29a */
  0x0000, /* U+a29b */
  0x0000, /* U+a29c */
  0x0000, /* U+a29d */
  0x0000, /* U+a29e */
  0x0000, /* U+a29f */
  0x0000, /* U+a2a0 */
  0x0000, /* U+a2a1 */
  0x0000, /* U+a2a2 */
  0x0000, /* U+a2a3 */
  0x0000, /* U+a2a4 */
  0x0000, /* U+a2a5 */
  0x0000, /* U+a2a6 */
  0x0000, /* U+a2a7 */
  0x0000, /* U+a2a8 */
  0x0000, /* U+a2a9 */
  0x0000, /* U+a2aa */
  0x0000, /* U+a2ab */
  0x0000, /* U+a2ac */
  0x0000, /* U+a2ad */
  0x0000, /* U+a2ae */
  0x0000, /* U+a2af */
  0x0000, /* U+a2b0 */
  0x0000, /* U+a2b1 */
  0x0000, /* U+a2b2 */
  0x0000, /* U+a2b3 */
  0x0000, /* U+a2b4 */
  0x0000, /* U+a2b5 */
  0x0000, /* U+a2b6 */
  0x0000, /* U+a2b7 */
  0x0000, /* U+a2b8 */
  0x0000, /* U+a2b9 */
  0x0000, /* U+a2ba */
  0x0000, /* U+a2bb */
  0x0000, /* U+a2bc */
  0x0000, /* U+a2bd */
  0x0000, /* U+a2be */
  0x0000, /* U+a2bf */
  0x0000, /* U+a2c0 */
  0x0000, /* U+a2c1 */
  0x0000, /* U+a2c2 */
  0x0000, /* U+a2c3 */
  0x0000, /* U+a2c4 */
  0x0000, /* U+a2c5 */
  0x0000, /* U+a2c6 */
  0x0000, /* U+a2c7 */
  0x0000, /* U+a2c8 */
  0x0000, /* U+a2c9 */
  0x0000, /* U+a2ca */
  0x0000, /* U+a2cb */
  0x0000, /* U+a2cc */
  0x0000, /* U+a2cd */
  0x0000, /* U+a2ce */
  0x0000, /* U+a2cf */
  0x0000, /* U+a2d0 */
  0x0000, /* U+a2d1 */
  0x0000, /* U+a2d2 */
  0x0000, /* U+a2d3 */
  0x0000, /* U+a2d4 */
  0x0000, /* U+a2d5 */
  0x0000, /* U+a2d6 */
  0x0000, /* U+a2d7 */
  0x0000, /* U+a2d8 */
  0x0000, /* U+a2d9 */
  0x0000, /* U+a2da */
  0x0000, /* U+a2db */
  0x0000, /* U+a2dc */
  0x0000, /* U+a2dd */
  0x0000, /* U+a2de */
  0x0000, /* U+a2df */
  0x0000, /* U+a2e0 */
  0x0000, /* U+a2e1 */
  0x0000, /* U+a2e2 */
  0x0000, /* U+a2e3 */
  0x0000, /* U+a2e4 */
  0x0000, /* U+a2e5 */
  0x0000, /* U+a2e6 */
  0x0000, /* U+a2e7 */
  0x0000, /* U+a2e8 */
  0x0000, /* U+a2e9 */
  0x0000, /* U+a2ea */
  0x0000, /* U+a2eb */
  0x0000, /* U+a2ec */
  0x0000, /* U+a2ed */
  0x0000, /* U+a2ee */
  0x0000, /* U+a2ef */
  0x0000, /* U+a2f0 */
  0x0000, /* U+a2f1 */
  0x0000, /* U+a2f2 */
  0x0000, /* U+a2f3 */
  0x0000, /* U+a2f4 */
  0x0000, /* U+a2f5 */
  0x0000, /* U+a2f6 */
  0x0000, /* U+a2f7 */
  0x0000, /* U+a2f8 */
  0x0000, /* U+a2f9 */
  0x0000, /* U+a2fa */
  0x0000, /* U+a2fb */
  0x0000, /* U+a2fc */
  0x0000, /* U+a2fd */
  0x0000, /* U+a2fe */
  0x0000, /* U+a2ff */
  0x0000, /* U+a300 */
  0x0000, /* U+a301 */
  0x0000, /* U+a302 */
  0x0000, /* U+a303 */
  0x0000, /* U+a304 */
  0x0000, /* U+a305 */
  0x0000, /* U+a306 */
  0x0000, /* U+a307 */
  0x0000, /* U+a308 */
  0x0000, /* U+a309 */
  0x0000, /* U+a30a */
  0x0000, /* U+a30b */
  0x0000, /* U+a30c */
  0x0000, /* U+a30d */
  0x0000, /* U+a30e */
  0x0000, /* U+a30f */
  0x0000, /* U+a310 */
  0x0000, /* U+a311 */
  0x0000, /* U+a312 */
  0x0000, /* U+a313 */
  0x0000, /* U+a314 */
  0x0000, /* U+a315 */
  0x0000, /* U+a316 */
  0x0000, /* U+a317 */
  0x0000, /* U+a318 */
  0x0000, /* U+a319 */
  0x0000, /* U+a31a */
  0x0000, /* U+a31b */
  0x0000, /* U+a31c */
  0x0000, /* U+a31d */
  0x0000, /* U+a31e */
  0x0000, /* U+a31f */
  0x0000, /* U+a320 */
  0x0000, /* U+a321 */
  0x0000, /* U+a322 */
  0x0000, /* U+a323 */
  0x0000, /* U+a324 */
  0x0000, /* U+a325 */
  0x0000, /* U+a326 */
  0x0000, /* U+a327 */
  0x0000, /* U+a328 */
  0x0000, /* U+a329 */
  0x0000, /* U+a32a */
  0x0000, /* U+a32b */
  0x0000, /* U+a32c */
  0x0000, /* U+a32d */
  0x0000, /* U+a32e */
  0x0000, /* U+a32f */
  0x0000, /* U+a330 */
  0x0000, /* U+a331 */
  0x0000, /* U+a332 */
  0x0000, /* U+a333 */
  0x0000, /* U+a334 */
  0x0000, /* U+a335 */
  0x0000, /* U+a336 */
  0x0000, /* U+a337 */
  0x0000, /* U+a338 */
  0x0000, /* U+a339 */
  0x0000, /* U+a33a */
  0x0000, /* U+a33b */
  0x0000, /* U+a33c */
  0x0000, /* U+a33d */
  0x0000, /* U+a33e */
  0x0000, /* U+a33f */
  0x0000, /* U+a340 */
  0x0000, /* U+a341 */
  0x0000, /* U+a342 */
  0x0000, /* U+a343 */
  0x0000, /* U+a344 */
  0x0000, /* U+a345 */
  0x0000, /* U+a346 */
  0x0000, /* U+a347 */
  0x0000, /* U+a348 */
  0x0000, /* U+a349 */
  0x0000, /* U+a34a */
  0x0000, /* U+a34b */
  0x0000, /* U+a34c */
  0x0000, /* U+a34d */
  0x0000, /* U+a34e */
  0x0000, /* U+a34f */
  0x0000, /* U+a350 */
  0x0000, /* U+a351 */
  0x0000, /* U+a352 */
  0x0000, /* U+a353 */
  0x0000, /* U+a354 */
  0x0000, /* U+a355 */
  0x0000, /* U+a356 */
  0x0000, /* U+a357 */
  0x0000, /* U+a358 */
  0x0000, /* U+a359 */
  0x0000, /* U+a35a */
  0x0000, /* U+a35b */
  0x0000, /* U+a35c */
  0x0000, /* U+a35d */
  0x0000, /* U+a35e */
  0x0000, /* U+a35f */
  0x0000, /* U+a360 */
  0x0000, /* U+a361 */
  0x0000, /* U+a362 */
  0x0000, /* U+a363 */
  0x0000, /* U+a364 */
  0x0000, /* U+a365 */
  0x0000, /* U+a366 */
  0x0000, /* U+a367 */
  0x0000, /* U+a368 */
  0x0000, /* U+a369 */
  0x0000, /* U+a36a */
  0x0000, /* U+a36b */
  0x0000, /* U+a36c */
  0x0000, /* U+a36d */
  0x0000, /* U+a36e */
  0x0000, /* U+a36f */
  0x0000, /* U+a370 */
  0x0000, /* U+a371 */
  0x0000, /* U+a372 */
  0x0000, /* U+a373 */
  0x0000, /* U+a374 */
  0x0000, /* U+a375 */
  0x0000, /* U+a376 */
  0x0000, /* U+a377 */
  0x0000, /* U+a378 */
  0x0000, /* U+a379 */
  0x0000, /* U+a37a */
  0x0000, /* U+a37b */
  0x0000, /* U+a37c */
  0x0000, /* U+a37d */
  0x0000, /* U+a37e */
  0x0000, /* U+a37f */
  0x0000, /* U+a380 */
  0x0000, /* U+a381 */
  0x0000, /* U+a382 */
  0x0000, /* U+a383 */
  0x0000, /* U+a384 */
  0x0000, /* U+a385 */
  0x0000, /* U+a386 */
  0x0000, /* U+a387 */
  0x0000, /* U+a388 */
  0x0000, /* U+a389 */
  0x0000, /* U+a38a */
  0x0000, /* U+a38b */
  0x0000, /* U+a38c */
  0x0000, /* U+a38d */
  0x0000, /* U+a38e */
  0x0000, /* U+a38f */
  0x0000, /* U+a390 */
  0x0000, /* U+a391 */
  0x0000, /* U+a392 */
  0x0000, /* U+a393 */
  0x0000, /* U+a394 */
  0x0000, /* U+a395 */
  0x0000, /* U+a396 */
  0x0000, /* U+a397 */
  0x0000, /* U+a398 */
  0x0000, /* U+a399 */
  0x0000, /* U+a39a */
  0x0000, /* U+a39b */
  0x0000, /* U+a39c */
  0x0000, /* U+a39d */
  0x0000, /* U+a39e */
  0x0000, /* U+a39f */
  0x0000, /* U+a3a0 */
  0x0000, /* U+a3a1 */
  0x0000, /* U+a3a2 */
  0x0000, /* U+a3a3 */
  0x0000, /* U+a3a4 */
  0x0000, /* U+a3a5 */
  0x0000, /* U+a3a6 */
  0x0000, /* U+a3a7 */
  0x0000, /* U+a3a8 */
  0x0000, /* U+a3a9 */
  0x0000, /* U+a3aa */
  0x0000, /* U+a3ab */
  0x0000, /* U+a3ac */
  0x0000, /* U+a3ad */
  0x0000, /* U+a3ae */
  0x0000, /* U+a3af */
  0x0000, /* U+a3b0 */
  0x0000, /* U+a3b1 */
  0x0000, /* U+a3b2 */
  0x0000, /* U+a3b3 */
  0x0000, /* U+a3b4 */
  0x0000, /* U+a3b5 */
  0x0000, /* U+a3b6 */
  0x0000, /* U+a3b7 */
  0x0000, /* U+a3b8 */
  0x0000, /* U+a3b9 */
  0x0000, /* U+a3ba */
  0x0000, /* U+a3bb */
  0x0000, /* U+a3bc */
  0x0000, /* U+a3bd */
  0x0000, /* U+a3be */
  0x0000, /* U+a3bf */
  0x0000, /* U+a3c0 */
  0x0000, /* U+a3c1 */
  0x0000, /* U+a3c2 */
  0x0000, /* U+a3c3 */
  0x0000, /* U+a3c4 */
  0x0000, /* U+a3c5 */
  0x0000, /* U+a3c6 */
  0x0000, /* U+a3c7 */
  0x0000, /* U+a3c8 */
  0x0000, /* U+a3c9 */
  0x0000, /* U+a3ca */
  0x0000, /* U+a3cb */
  0x0000, /* U+a3cc */
  0x0000, /* U+a3cd */
  0x0000, /* U+a3ce */
  0x0000, /* U+a3cf */
  0x0000, /* U+a3d0 */
  0x0000, /* U+a3d1 */
  0x0000, /* U+a3d2 */
  0x0000, /* U+a3d3 */
  0x0000, /* U+a3d4 */
  0x0000, /* U+a3d5 */
  0x0000, /* U+a3d6 */
  0x0000, /* U+a3d7 */
  0x0000, /* U+a3d8 */
  0x0000, /* U+a3d9 */
  0x0000, /* U+a3da */
  0x0000, /* U+a3db */
  0x0000, /* U+a3dc */
  0x0000, /* U+a3dd */
  0x0000, /* U+a3de */
  0x0000, /* U+a3df */
  0x0000, /* U+a3e0 */
  0x0000, /* U+a3e1 */
  0x0000, /* U+a3e2 */
  0x0000, /* U+a3e3 */
  0x0000, /* U+a3e4 */
  0x0000, /* U+a3e5 */
  0x0000, /* U+a3e6 */
  0x0000, /* U+a3e7 */
  0x0000, /* U+a3e8 */
  0x0000, /* U+a3e9 */
  0x0000, /* U+a3ea */
  0x0000, /* U+a3eb */
  0x0000, /* U+a3ec */
  0x0000, /* U+a3ed */
  0x0000, /* U+a3ee */
  0x0000, /* U+a3ef */
  0x0000, /* U+a3f0 */
  0x0000, /* U+a3f1 */
  0x0000, /* U+a3f2 */
  0x0000, /* U+a3f3 */
  0x0000, /* U+a3f4 */
  0x0000, /* U+a3f5 */
  0x0000, /* U+a3f6 */
  0x0000, /* U+a3f7 */
  0x0000, /* U+a3f8 */
  0x0000, /* U+a3f9 */
  0x0000, /* U+a3fa */
  0x0000, /* U+a3fb */
  0x0000, /* U+a3fc */
  0x0000, /* U+a3fd */
  0x0000, /* U+a3fe */
  0x0000, /* U+a3ff */
  0x0000, /* U+a400 */
  0x0000, /* U+a401 */
  0x0000, /* U+a402 */
  0x0000, /* U+a403 */
  0x0000, /* U+a404 */
  0x0000, /* U+a405 */
  0x0000, /* U+a406 */
  0x0000, /* U+a407 */
  0x0000, /* U+a408 */
  0x0000, /* U+a409 */
  0x0000, /* U+a40a */
  0x0000, /* U+a40b */
  0x0000, /* U+a40c */
  0x0000, /* U+a40d */
  0x0000, /* U+a40e */
  0x0000, /* U+a40f */
  0x0000, /* U+a410 */
  0x0000, /* U+a411 */
  0x0000, /* U+a412 */
  0x0000, /* U+a413 */
  0x0000, /* U+a414 */
  0x0000, /* U+a415 */
  0x0000, /* U+a416 */
  0x0000, /* U+a417 */
  0x0000, /* U+a418 */
  0x0000, /* U+a419 */
  0x0000, /* U+a41a */
  0x0000, /* U+a41b */
  0x0000, /* U+a41c */
  0x0000, /* U+a41d */
  0x0000, /* U+a41e */
  0x0000, /* U+a41f */
  0x0000, /* U+a420 */
  0x0000, /* U+a421 */
  0x0000, /* U+a422 */
  0x0000, /* U+a423 */
  0x0000, /* U+a424 */
  0x0000, /* U+a425 */
  0x0000, /* U+a426 */
  0x0000, /* U+a427 */
  0x0000, /* U+a428 */
  0x0000, /* U+a429 */
  0x0000, /* U+a42a */
  0x0000, /* U+a42b */
  0x0000, /* U+a42c */
  0x0000, /* U+a42d */
  0x0000, /* U+a42e */
  0x0000, /* U+a42f */
  0x0000, /* U+a430 */
  0x0000, /* U+a431 */
  0x0000, /* U+a432 */
  0x0000, /* U+a433 */
  0x0000, /* U+a434 */
  0x0000, /* U+a435 */
  0x0000, /* U+a436 */
  0x0000, /* U+a437 */
  0x0000, /* U+a438 */
  0x0000, /* U+a439 */
  0x0000, /* U+a43a */
  0x0000, /* U+a43b */
  0x0000, /* U+a43c */
  0x0000, /* U+a43d */
  0x0000, /* U+a43e */
  0x0000, /* U+a43f */
  0x0000, /* U+a440 */
  0x0000, /* U+a441 */
  0x0000, /* U+a442 */
  0x0000, /* U+a443 */
  0x0000, /* U+a444 */
  0x0000, /* U+a445 */
  0x0000, /* U+a446 */
  0x0000, /* U+a447 */
  0x0000, /* U+a448 */
  0x0000, /* U+a449 */
  0x0000, /* U+a44a */
  0x0000, /* U+a44b */
  0x0000, /* U+a44c */
  0x0000, /* U+a44d */
  0x0000, /* U+a44e */
  0x0000, /* U+a44f */
  0x0000, /* U+a450 */
  0x0000, /* U+a451 */
  0x0000, /* U+a452 */
  0x0000, /* U+a453 */
  0x0000, /* U+a454 */
  0x0000, /* U+a455 */
  0x0000, /* U+a456 */
  0x0000, /* U+a457 */
  0x0000, /* U+a458 */
  0x0000, /* U+a459 */
  0x0000, /* U+a45a */
  0x0000, /* U+a45b */
  0x0000, /* U+a45c */
  0x0000, /* U+a45d */
  0x0000, /* U+a45e */
  0x0000, /* U+a45f */
  0x0000, /* U+a460 */
  0x0000, /* U+a461 */
  0x0000, /* U+a462 */
  0x0000, /* U+a463 */
  0x0000, /* U+a464 */
  0x0000, /* U+a465 */
  0x0000, /* U+a466 */
  0x0000, /* U+a467 */
  0x0000, /* U+a468 */
  0x0000, /* U+a469 */
  0x0000, /* U+a46a */
  0x0000, /* U+a46b */
  0x0000, /* U+a46c */
  0x0000, /* U+a46d */
  0x0000, /* U+a46e */
  0x0000, /* U+a46f */
  0x0000, /* U+a470 */
  0x0000, /* U+a471 */
  0x0000, /* U+a472 */
  0x0000, /* U+a473 */
  0x0000, /* U+a474 */
  0x0000, /* U+a475 */
  0x0000, /* U+a476 */
  0x0000, /* U+a477 */
  0x0000, /* U+a478 */
  0x0000, /* U+a479 */
  0x0000, /* U+a47a */
  0x0000, /* U+a47b */
  0x0000, /* U+a47c */
  0x0000, /* U+a47d */
  0x0000, /* U+a47e */
  0x0000, /* U+a47f */
  0x0000, /* U+a480 */
  0x0000, /* U+a481 */
  0x0000, /* U+a482 */
  0x0000, /* U+a483 */
  0x0000, /* U+a484 */
  0x0000, /* U+a485 */
  0x0000, /* U+a486 */
  0x0000, /* U+a487 */
  0x0000, /* U+a488 */
  0x0000, /* U+a489 */
  0x0000, /* U+a48a */
  0x0000, /* U+a48b */
  0x0000, /* U+a48c */
  0x0000, /* U+a48d */
  0x0000, /* U+a48e */
  0x0000, /* U+a48f */
  0x0000, /* U+a490 */
  0x0000, /* U+a491 */
  0x0000, /* U+a492 */
  0x0000, /* U+a493 */
  0x0000, /* U+a494 */
  0x0000, /* U+a495 */
  0x0000, /* U+a496 */
  0x0000, /* U+a497 */
  0x0000, /* U+a498 */
  0x0000, /* U+a499 */
  0x0000, /* U+a49a */
  0x0000, /* U+a49b */
  0x0000, /* U+a49c */
  0x0000, /* U+a49d */
  0x0000, /* U+a49e */
  0x0000, /* U+a49f */
  0x0000, /* U+a4a0 */
  0x0000, /* U+a4a1 */
  0x0000, /* U+a4a2 */
  0x0000, /* U+a4a3 */
  0x0000, /* U+a4a4 */
  0x0000, /* U+a4a5 */
  0x0000, /* U+a4a6 */
  0x0000, /* U+a4a7 */
  0x0000, /* U+a4a8 */
  0x0000, /* U+a4a9 */
  0x0000, /* U+a4aa */
  0x0000, /* U+a4ab */
  0x0000, /* U+a4ac */
  0x0000, /* U+a4ad */
  0x0000, /* U+a4ae */
  0x0000, /* U+a4af */
  0x0000, /* U+a4b0 */
  0x0000, /* U+a4b1 */
  0x0000, /* U+a4b2 */
  0x0000, /* U+a4b3 */
  0x0000, /* U+a4b4 */
  0x0000, /* U+a4b5 */
  0x0000, /* U+a4b6 */
  0x0000, /* U+a4b7 */
  0x0000, /* U+a4b8 */
  0x0000, /* U+a4b9 */
  0x0000, /* U+a4ba */
  0x0000, /* U+a4bb */
  0x0000, /* U+a4bc */
  0x0000, /* U+a4bd */
  0x0000, /* U+a4be */
  0x0000, /* U+a4bf */
  0x0000, /* U+a4c0 */
  0x0000, /* U+a4c1 */
  0x0000, /* U+a4c2 */
  0x0000, /* U+a4c3 */
  0x0000, /* U+a4c4 */
  0x0000, /* U+a4c5 */
  0x0000, /* U+a4c6 */
  0x0000, /* U+a4c7 */
  0x0000, /* U+a4c8 */
  0x0000, /* U+a4c9 */
  0x0000, /* U+a4ca */
  0x0000, /* U+a4cb */
  0x0000, /* U+a4cc */
  0x0000, /* U+a4cd */
  0x0000, /* U+a4ce */
  0x0000, /* U+a4cf */
  0x0000, /* U+a4d0 */
  0x0000, /* U+a4d1 */
  0x0000, /* U+a4d2 */
  0x0000, /* U+a4d3 */
  0x0000, /* U+a4d4 */
  0x0000, /* U+a4d5 */
  0x0000, /* U+a4d6 */
  0x0000, /* U+a4d7 */
  0x0000, /* U+a4d8 */
  0x0000, /* U+a4d9 */
  0x0000, /* U+a4da */
  0x0000, /* U+a4db */
  0x0000, /* U+a4dc */
  0x0000, /* U+a4dd */
  0x0000, /* U+a4de */
  0x0000, /* U+a4df */
  0x0000, /* U+a4e0 */
  0x0000, /* U+a4e1 */
  0x0000, /* U+a4e2 */
  0x0000, /* U+a4e3 */
  0x0000, /* U+a4e4 */
  0x0000, /* U+a4e5 */
  0x0000, /* U+a4e6 */
  0x0000, /* U+a4e7 */
  0x0000, /* U+a4e8 */
  0x0000, /* U+a4e9 */
  0x0000, /* U+a4ea */
  0x0000, /* U+a4eb */
  0x0000, /* U+a4ec */
  0x0000, /* U+a4ed */
  0x0000, /* U+a4ee */
  0x0000, /* U+a4ef */
  0x0000, /* U+a4f0 */
  0x0000, /* U+a4f1 */
  0x0000, /* U+a4f2 */
  0x0000, /* U+a4f3 */
  0x0000, /* U+a4f4 */
  0x0000, /* U+a4f5 */
  0x0000, /* U+a4f6 */
  0x0000, /* U+a4f7 */
  0x0000, /* U+a4f8 */
  0x0000, /* U+a4f9 */
  0x0000, /* U+a4fa */
  0x0000, /* U+a4fb */
  0x0000, /* U+a4fc */
  0x0000, /* U+a4fd */
  0x0000, /* U+a4fe */
  0x0000, /* U+a4ff */
  0x0000, /* U+a500 */
  0x0000, /* U+a501 */
  0x0000, /* U+a502 */
  0x0000, /* U+a503 */
  0x0000, /* U+a504 */
  0x0000, /* U+a505 */
  0x0000, /* U+a506 */
  0x0000, /* U+a507 */
  0x0000, /* U+a508 */
  0x0000, /* U+a509 */
  0x0000, /* U+a50a */
  0x0000, /* U+a50b */
  0x0000, /* U+a50c */
  0x0000, /* U+a50d */
  0x0000, /* U+a50e */
  0x0000, /* U+a50f */
  0x0000, /* U+a510 */
  0x0000, /* U+a511 */
  0x0000, /* U+a512 */
  0x0000, /* U+a513 */
  0x0000, /* U+a514 */
  0x0000, /* U+a515 */
  0x0000, /* U+a516 */
  0x0000, /* U+a517 */
  0x0000, /* U+a518 */
  0x0000, /* U+a519 */
  0x0000, /* U+a51a */
  0x0000, /* U+a51b */
  0x0000, /* U+a51c */
  0x0000, /* U+a51d */
  0x0000, /* U+a51e */
  0x0000, /* U+a51f */
  0x0000, /* U+a520 */
  0x0000, /* U+a521 */
  0x0000, /* U+a522 */
  0x0000, /* U+a523 */
  0x0000, /* U+a524 */
  0x0000, /* U+a525 */
  0x0000, /* U+a526 */
  0x0000, /* U+a527 */
  0x0000, /* U+a528 */
  0x0000, /* U+a529 */
  0x0000, /* U+a52a */
  0x0000, /* U+a52b */
  0x0000, /* U+a52c */
  0x0000, /* U+a52d */
  0x0000, /* U+a52e */
  0x0000, /* U+a52f */
  0x0000, /* U+a530 */
  0x0000, /* U+a531 */
  0x0000, /* U+a532 */
  0x0000, /* U+a533 */
  0x0000, /* U+a534 */
  0x0000, /* U+a535 */
  0x0000, /* U+a536 */
  0x0000, /* U+a537 */
  0x0000, /* U+a538 */
  0x0000, /* U+a539 */
  0x0000, /* U+a53a */
  0x0000, /* U+a53b */
  0x0000, /* U+a53c */
  0x0000, /* U+a53d */
  0x0000, /* U+a53e */
  0x0000, /* U+a53f */
  0x0000, /* U+a540 */
  0x0000, /* U+a541 */
  0x0000, /* U+a542 */
  0x0000, /* U+a543 */
  0x0000, /* U+a544 */
  0x0000, /* U+a545 */
  0x0000, /* U+a546 */
  0x0000, /* U+a547 */
  0x0000, /* U+a548 */
  0x0000, /* U+a549 */
  0x0000, /* U+a54a */
  0x0000, /* U+a54b */
  0x0000, /* U+a54c */
  0x0000, /* U+a54d */
  0x0000, /* U+a54e */
  0x0000, /* U+a54f */
  0x0000, /* U+a550 */
  0x0000, /* U+a551 */
  0x0000, /* U+a552 */
  0x0000, /* U+a553 */
  0x0000, /* U+a554 */
  0x0000, /* U+a555 */
  0x0000, /* U+a556 */
  0x0000, /* U+a557 */
  0x0000, /* U+a558 */
  0x0000, /* U+a559 */
  0x0000, /* U+a55a */
  0x0000, /* U+a55b */
  0x0000, /* U+a55c */
  0x0000, /* U+a55d */
  0x0000, /* U+a55e */
  0x0000, /* U+a55f */
  0x0000, /* U+a560 */
  0x0000, /* U+a561 */
  0x0000, /* U+a562 */
  0x0000, /* U+a563 */
  0x0000, /* U+a564 */
  0x0000, /* U+a565 */
  0x0000, /* U+a566 */
  0x0000, /* U+a567 */
  0x0000, /* U+a568 */
  0x0000, /* U+a569 */
  0x0000, /* U+a56a */
  0x0000, /* U+a56b */
  0x0000, /* U+a56c */
  0x0000, /* U+a56d */
  0x0000, /* U+a56e */
  0x0000, /* U+a56f */
  0x0000, /* U+a570 */
  0x0000, /* U+a571 */
  0x0000, /* U+a572 */
  0x0000, /* U+a573 */
  0x0000, /* U+a574 */
  0x0000, /* U+a575 */
  0x0000, /* U+a576 */
  0x0000, /* U+a577 */
  0x0000, /* U+a578 */
  0x0000, /* U+a579 */
  0x0000, /* U+a57a */
  0x0000, /* U+a57b */
  0x0000, /* U+a57c */
  0x0000, /* U+a57d */
  0x0000, /* U+a57e */
  0x0000, /* U+a57f */
  0x0000, /* U+a580 */
  0x0000, /* U+a581 */
  0x0000, /* U+a582 */
  0x0000, /* U+a583 */
  0x0000, /* U+a584 */
  0x0000, /* U+a585 */
  0x0000, /* U+a586 */
  0x0000, /* U+a587 */
  0x0000, /* U+a588 */
  0x0000, /* U+a589 */
  0x0000, /* U+a58a */
  0x0000, /* U+a58b */
  0x0000, /* U+a58c */
  0x0000, /* U+a58d */
  0x0000, /* U+a58e */
  0x0000, /* U+a58f */
  0x0000, /* U+a590 */
  0x0000, /* U+a591 */
  0x0000, /* U+a592 */
  0x0000, /* U+a593 */
  0x0000, /* U+a594 */
  0x0000, /* U+a595 */
  0x0000, /* U+a596 */
  0x0000, /* U+a597 */
  0x0000, /* U+a598 */
  0x0000, /* U+a599 */
  0x0000, /* U+a59a */
  0x0000, /* U+a59b */
  0x0000, /* U+a59c */
  0x0000, /* U+a59d */
  0x0000, /* U+a59e */
  0x0000, /* U+a59f */
  0x0000, /* U+a5a0 */
  0x0000, /* U+a5a1 */
  0x0000, /* U+a5a2 */
  0x0000, /* U+a5a3 */
  0x0000, /* U+a5a4 */
  0x0000, /* U+a5a5 */
  0x0000, /* U+a5a6 */
  0x0000, /* U+a5a7 */
  0x0000, /* U+a5a8 */
  0x0000, /* U+a5a9 */
  0x0000, /* U+a5aa */
  0x0000, /* U+a5ab */
  0x0000, /* U+a5ac */
  0x0000, /* U+a5ad */
  0x0000, /* U+a5ae */
  0x0000, /* U+a5af */
  0x0000, /* U+a5b0 */
  0x0000, /* U+a5b1 */
  0x0000, /* U+a5b2 */
  0x0000, /* U+a5b3 */
  0x0000, /* U+a5b4 */
  0x0000, /* U+a5b5 */
  0x0000, /* U+a5b6 */
  0x0000, /* U+a5b7 */
  0x0000, /* U+a5b8 */
  0x0000, /* U+a5b9 */
  0x0000, /* U+a5ba */
  0x0000, /* U+a5bb */
  0x0000, /* U+a5bc */
  0x0000, /* U+a5bd */
  0x0000, /* U+a5be */
  0x0000, /* U+a5bf */
  0x0000, /* U+a5c0 */
  0x0000, /* U+a5c1 */
  0x0000, /* U+a5c2 */
  0x0000, /* U+a5c3 */
  0x0000, /* U+a5c4 */
  0x0000, /* U+a5c5 */
  0x0000, /* U+a5c6 */
  0x0000, /* U+a5c7 */
  0x0000, /* U+a5c8 */
  0x0000, /* U+a5c9 */
  0x0000, /* U+a5ca */
  0x0000, /* U+a5cb */
  0x0000, /* U+a5cc */
  0x0000, /* U+a5cd */
  0x0000, /* U+a5ce */
  0x0000, /* U+a5cf */
  0x0000, /* U+a5d0 */
  0x0000, /* U+a5d1 */
  0x0000, /* U+a5d2 */
  0x0000, /* U+a5d3 */
  0x0000, /* U+a5d4 */
  0x0000, /* U+a5d5 */
  0x0000, /* U+a5d6 */
  0x0000, /* U+a5d7 */
  0x0000, /* U+a5d8 */
  0x0000, /* U+a5d9 */
  0x0000, /* U+a5da */
  0x0000, /* U+a5db */
  0x0000, /* U+a5dc */
  0x0000, /* U+a5dd */
  0x0000, /* U+a5de */
  0x0000, /* U+a5df */
  0x0000, /* U+a5e0 */
  0x0000, /* U+a5e1 */
  0x0000, /* U+a5e2 */
  0x0000, /* U+a5e3 */
  0x0000, /* U+a5e4 */
  0x0000, /* U+a5e5 */
  0x0000, /* U+a5e6 */
  0x0000, /* U+a5e7 */
  0x0000, /* U+a5e8 */
  0x0000, /* U+a5e9 */
  0x0000, /* U+a5ea */
  0x0000, /* U+a5eb */
  0x0000, /* U+a5ec */
  0x0000, /* U+a5ed */
  0x0000, /* U+a5ee */
  0x0000, /* U+a5ef */
  0x0000, /* U+a5f0 */
  0x0000, /* U+a5f1 */
  0x0000, /* U+a5f2 */
  0x0000, /* U+a5f3 */
  0x0000, /* U+a5f4 */
  0x0000, /* U+a5f5 */
  0x0000, /* U+a5f6 */
  0x0000, /* U+a5f7 */
  0x0000, /* U+a5f8 */
  0x0000, /* U+a5f9 */
  0x0000, /* U+a5fa */
  0x0000, /* U+a5fb */
  0x0000, /* U+a5fc */
  0x0000, /* U+a5fd */
  0x0000, /* U+a5fe */
  0x0000, /* U+a5ff */
  0x0000, /* U+a600 */
  0x0000, /* U+a601 */
  0x0000, /* U+a602 */
  0x0000, /* U+a603 */
  0x0000, /* U+a604 */
  0x0000, /* U+a605 */
  0x0000, /* U+a606 */
  0x0000, /* U+a607 */
  0x0000, /* U+a608 */
  0x0000, /* U+a609 */
  0x0000, /* U+a60a */
  0x0000, /* U+a60b */
  0x0000, /* U+a60c */
  0x0000, /* U+a60d */
  0x0000, /* U+a60e */
  0x0000, /* U+a60f */
  0x0000, /* U+a610 */
  0x0000, /* U+a611 */
  0x0000, /* U+a612 */
  0x0000, /* U+a613 */
  0x0000, /* U+a614 */
  0x0000, /* U+a615 */
  0x0000, /* U+a616 */
  0x0000, /* U+a617 */
  0x0000, /* U+a618 */
  0x0000, /* U+a619 */
  0x0000, /* U+a61a */
  0x0000, /* U+a61b */
  0x0000, /* U+a61c */
  0x0000, /* U+a61d */
  0x0000, /* U+a61e */
  0x0000, /* U+a61f */
  0x0000, /* U+a620 */
  0x0000, /* U+a621 */
  0x0000, /* U+a622 */
  0x0000, /* U+a623 */
  0x0000, /* U+a624 */
  0x0000, /* U+a625 */
  0x0000, /* U+a626 */
  0x0000, /* U+a627 */
  0x0000, /* U+a628 */
  0x0000, /* U+a629 */
  0x0000, /* U+a62a */
  0x0000, /* U+a62b */
  0x0000, /* U+a62c */
  0x0000, /* U+a62d */
  0x0000, /* U+a62e */
  0x0000, /* U+a62f */
  0x0000, /* U+a630 */
  0x0000, /* U+a631 */
  0x0000, /* U+a632 */
  0x0000, /* U+a633 */
  0x0000, /* U+a634 */
  0x0000, /* U+a635 */
  0x0000, /* U+a636 */
  0x0000, /* U+a637 */
  0x0000, /* U+a638 */
  0x0000, /* U+a639 */
  0x0000, /* U+a63a */
  0x0000, /* U+a63b */
  0x0000, /* U+a63c */
  0x0000, /* U+a63d */
  0x0000, /* U+a63e */
  0x0000, /* U+a63f */
  0x0000, /* U+a640 */
  0x0000, /* U+a641 */
  0x0000, /* U+a642 */
  0x0000, /* U+a643 */
  0x0000, /* U+a644 */
  0x0000, /* U+a645 */
  0x0000, /* U+a646 */
  0x0000, /* U+a647 */
  0x0000, /* U+a648 */
  0x0000, /* U+a649 */
  0x0000, /* U+a64a */
  0x0000, /* U+a64b */
  0x0000, /* U+a64c */
  0x0000, /* U+a64d */
  0x0000, /* U+a64e */
  0x0000, /* U+a64f */
  0x0000, /* U+a650 */
  0x0000, /* U+a651 */
  0x0000, /* U+a652 */
  0x0000, /* U+a653 */
  0x0000, /* U+a654 */
  0x0000, /* U+a655 */
  0x0000, /* U+a656 */
  0x0000, /* U+a657 */
  0x0000, /* U+a658 */
  0x0000, /* U+a659 */
  0x0000, /* U+a65a */
  0x0000, /* U+a65b */
  0x0000, /* U+a65c */
  0x0000, /* U+a65d */
  0x0000, /* U+a65e */
  0x0000, /* U+a65f */
  0x0000, /* U+a660 */
  0x0000, /* U+a661 */
  0x0000, /* U+a662 */
  0x0000, /* U+a663 */
  0x0000, /* U+a664 */
  0x0000, /* U+a665 */
  0x0000, /* U+a666 */
  0x0000, /* U+a667 */
  0x0000, /* U+a668 */
  0x0000, /* U+a669 */
  0x0000, /* U+a66a */
  0x0000, /* U+a66b */
  0x0000, /* U+a66c */
  0x0000, /* U+a66d */
  0x0000, /* U+a66e */
  0x0000, /* U+a66f */
  0x0000, /* U+a670 */
  0x0000, /* U+a671 */
  0x0000, /* U+a672 */
  0x0000, /* U+a673 */
  0x0000, /* U+a674 */
  0x0000, /* U+a675 */
  0x0000, /* U+a676 */
  0x0000, /* U+a677 */
  0x0000, /* U+a678 */
  0x0000, /* U+a679 */
  0x0000, /* U+a67a */
  0x0000, /* U+a67b */
  0x0000, /* U+a67c */
  0x0000, /* U+a67d */
  0x0000, /* U+a67e */
  0x0000, /* U+a67f */
  0x0000, /* U+a680 */
  0x0000, /* U+a681 */
  0x0000, /* U+a682 */
  0x0000, /* U+a683 */
  0x0000, /* U+a684 */
  0x0000, /* U+a685 */
  0x0000, /* U+a686 */
  0x0000, /* U+a687 */
  0x0000, /* U+a688 */
  0x0000, /* U+a689 */
  0x0000, /* U+a68a */
  0x0000, /* U+a68b */
  0x0000, /* U+a68c */
  0x0000, /* U+a68d */
  0x0000, /* U+a68e */
  0x0000, /* U+a68f */
  0x0000, /* U+a690 */
  0x0000, /* U+a691 */
  0x0000, /* U+a692 */
  0x0000, /* U+a693 */
  0x0000, /* U+a694 */
  0x0000, /* U+a695 */
  0x0000, /* U+a696 */
  0x0000, /* U+a697 */
  0x0000, /* U+a698 */
  0x0000, /* U+a699 */
  0x0000, /* U+a69a */
  0x0000, /* U+a69b */
  0x0000, /* U+a69c */
  0x0000, /* U+a69d */
  0x0000, /* U+a69e */
  0x0000, /* U+a69f */
  0x0000, /* U+a6a0 */
  0x0000, /* U+a6a1 */
  0x0000, /* U+a6a2 */
  0x0000, /* U+a6a3 */
  0x0000, /* U+a6a4 */
  0x0000, /* U+a6a5 */
  0x0000, /* U+a6a6 */
  0x0000, /* U+a6a7 */
  0x0000, /* U+a6a8 */
  0x0000, /* U+a6a9 */
  0x0000, /* U+a6aa */
  0x0000, /* U+a6ab */
  0x0000, /* U+a6ac */
  0x0000, /* U+a6ad */
  0x0000, /* U+a6ae */
  0x0000, /* U+a6af */
  0x0000, /* U+a6b0 */
  0x0000, /* U+a6b1 */
  0x0000, /* U+a6b2 */
  0x0000, /* U+a6b3 */
  0x0000, /* U+a6b4 */
  0x0000, /* U+a6b5 */
  0x0000, /* U+a6b6 */
  0x0000, /* U+a6b7 */
  0x0000, /* U+a6b8 */
  0x0000, /* U+a6b9 */
  0x0000, /* U+a6ba */
  0x0000, /* U+a6bb */
  0x0000, /* U+a6bc */
  0x0000, /* U+a6bd */
  0x0000, /* U+a6be */
  0x0000, /* U+a6bf */
  0x0000, /* U+a6c0 */
  0x0000, /* U+a6c1 */
  0x0000, /* U+a6c2 */
  0x0000, /* U+a6c3 */
  0x0000, /* U+a6c4 */
  0x0000, /* U+a6c5 */
  0x0000, /* U+a6c6 */
  0x0000, /* U+a6c7 */
  0x0000, /* U+a6c8 */
  0x0000, /* U+a6c9 */
  0x0000, /* U+a6ca */
  0x0000, /* U+a6cb */
  0x0000, /* U+a6cc */
  0x0000, /* U+a6cd */
  0x0000, /* U+a6ce */
  0x0000, /* U+a6cf */
  0x0000, /* U+a6d0 */
  0x0000, /* U+a6d1 */
  0x0000, /* U+a6d2 */
  0x0000, /* U+a6d3 */
  0x0000, /* U+a6d4 */
  0x0000, /* U+a6d5 */
  0x0000, /* U+a6d6 */
  0x0000, /* U+a6d7 */
  0x0000, /* U+a6d8 */
  0x0000, /* U+a6d9 */
  0x0000, /* U+a6da */
  0x0000, /* U+a6db */
  0x0000, /* U+a6dc */
  0x0000, /* U+a6dd */
  0x0000, /* U+a6de */
  0x0000, /* U+a6df */
  0x0000, /* U+a6e0 */
  0x0000, /* U+a6e1 */
  0x0000, /* U+a6e2 */
  0x0000, /* U+a6e3 */
  0x0000, /* U+a6e4 */
  0x0000, /* U+a6e5 */
  0x0000, /* U+a6e6 */
  0x0000, /* U+a6e7 */
  0x0000, /* U+a6e8 */
  0x0000, /* U+a6e9 */
  0x0000, /* U+a6ea */
  0x0000, /* U+a6eb */
  0x0000, /* U+a6ec */
  0x0000, /* U+a6ed */
  0x0000, /* U+a6ee */
  0x0000, /* U+a6ef */
  0x0000, /* U+a6f0 */
  0x0000, /* U+a6f1 */
  0x0000, /* U+a6f2 */
  0x0000, /* U+a6f3 */
  0x0000, /* U+a6f4 */
  0x0000, /* U+a6f5 */
  0x0000, /* U+a6f6 */
  0x0000, /* U+a6f7 */
  0x0000, /* U+a6f8 */
  0x0000, /* U+a6f9 */
  0x0000, /* U+a6fa */
  0x0000, /* U+a6fb */
  0x0000, /* U+a6fc */
  0x0000, /* U+a6fd */
  0x0000, /* U+a6fe */
  0x0000, /* U+a6ff */
  0x0000, /* U+a700 */
  0x0000, /* U+a701 */
  0x0000, /* U+a702 */
  0x0000, /* U+a703 */
  0x0000, /* U+a704 */
  0x0000, /* U+a705 */
  0x0000, /* U+a706 */
  0x0000, /* U+a707 */
  0x0000, /* U+a708 */
  0x0000, /* U+a709 */
  0x0000, /* U+a70a */
  0x0000, /* U+a70b */
  0x0000, /* U+a70c */
  0x0000, /* U+a70d */
  0x0000, /* U+a70e */
  0x0000, /* U+a70f */
  0x0000, /* U+a710 */
  0x0000, /* U+a711 */
  0x0000, /* U+a712 */
  0x0000, /* U+a713 */
  0x0000, /* U+a714 */
  0x0000, /* U+a715 */
  0x0000, /* U+a716 */
  0x0000, /* U+a717 */
  0x0000, /* U+a718 */
  0x0000, /* U+a719 */
  0x0000, /* U+a71a */
  0x0000, /* U+a71b */
  0x0000, /* U+a71c */
  0x0000, /* U+a71d */
  0x0000, /* U+a71e */
  0x0000, /* U+a71f */
  0x0000, /* U+a720 */
  0x0000, /* U+a721 */
  0x0000, /* U+a722 */
  0x0000, /* U+a723 */
  0x0000, /* U+a724 */
  0x0000, /* U+a725 */
  0x0000, /* U+a726 */
  0x0000, /* U+a727 */
  0x0000, /* U+a728 */
  0x0000, /* U+a729 */
  0x0000, /* U+a72a */
  0x0000, /* U+a72b */
  0x0000, /* U+a72c */
  0x0000, /* U+a72d */
  0x0000, /* U+a72e */
  0x0000, /* U+a72f */
  0x0000, /* U+a730 */
  0x0000, /* U+a731 */
  0x0000, /* U+a732 */
  0x0000, /* U+a733 */
  0x0000, /* U+a734 */
  0x0000, /* U+a735 */
  0x0000, /* U+a736 */
  0x0000, /* U+a737 */
  0x0000, /* U+a738 */
  0x0000, /* U+a739 */
  0x0000, /* U+a73a */
  0x0000, /* U+a73b */
  0x0000, /* U+a73c */
  0x0000, /* U+a73d */
  0x0000, /* U+a73e */
  0x0000, /* U+a73f */
  0x0000, /* U+a740 */
  0x0000, /* U+a741 */
  0x0000, /* U+a742 */
  0x0000, /* U+a743 */
  0x0000, /* U+a744 */
  0x0000, /* U+a745 */
  0x0000, /* U+a746 */
  0x0000, /* U+a747 */
  0x0000, /* U+a748 */
  0x0000, /* U+a749 */
  0x0000, /* U+a74a */
  0x0000, /* U+a74b */
  0x0000, /* U+a74c */
  0x0000, /* U+a74d */
  0x0000, /* U+a74e */
  0x0000, /* U+a74f */
  0x0000, /* U+a750 */
  0x0000, /* U+a751 */
  0x0000, /* U+a752 */
  0x0000, /* U+a753 */
  0x0000, /* U+a754 */
  0x0000, /* U+a755 */
  0x0000, /* U+a756 */
  0x0000, /* U+a757 */
  0x0000, /* U+a758 */
  0x0000, /* U+a759 */
  0x0000, /* U+a75a */
  0x0000, /* U+a75b */
  0x0000, /* U+a75c */
  0x0000, /* U+a75d */
  0x0000, /* U+a75e */
  0x0000, /* U+a75f */
  0x0000, /* U+a760 */
  0x0000, /* U+a761 */
  0x0000, /* U+a762 */
  0x0000, /* U+a763 */
  0x0000, /* U+a764 */
  0x0000, /* U+a765 */
  0x0000, /* U+a766 */
  0x0000, /* U+a767 */
  0x0000, /* U+a768 */
  0x0000, /* U+a769 */
  0x0000, /* U+a76a */
  0x0000, /* U+a76b */
  0x0000, /* U+a76c */
  0x0000, /* U+a76d */
  0x0000, /* U+a76e */
  0x0000, /* U+a76f */
  0x0000, /* U+a770 */
  0x0000, /* U+a771 */
  0x0000, /* U+a772 */
  0x0000, /* U+a773 */
  0x0000, /* U+a774 */
  0x0000, /* U+a775 */
  0x0000, /* U+a776 */
  0x0000, /* U+a777 */
  0x0000, /* U+a778 */
  0x0000, /* U+a779 */
  0x0000, /* U+a77a */
  0x0000, /* U+a77b */
  0x0000, /* U+a77c */
  0x0000, /* U+a77d */
  0x0000, /* U+a77e */
  0x0000, /* U+a77f */
  0x0000, /* U+a780 */
  0x0000, /* U+a781 */
  0x0000, /* U+a782 */
  0x0000, /* U+a783 */
  0x0000, /* U+a784 */
  0x0000, /* U+a785 */
  0x0000, /* U+a786 */
  0x0000, /* U+a787 */
  0x0000, /* U+a788 */
  0x0000, /* U+a789 */
  0x0000, /* U+a78a */
  0x0000, /* U+a78b */
  0x0000, /* U+a78c */
  0x0000, /* U+a78d */
  0x0000, /* U+a78e */
  0x0000, /* U+a78f */
  0x0000, /* U+a790 */
  0x0000, /* U+a791 */
  0x0000, /* U+a792 */
  0x0000, /* U+a793 */
  0x0000, /* U+a794 */
  0x0000, /* U+a795 */
  0x0000, /* U+a796 */
  0x0000, /* U+a797 */
  0x0000, /* U+a798 */
  0x0000, /* U+a799 */
  0x0000, /* U+a79a */
  0x0000, /* U+a79b */
  0x0000, /* U+a79c */
  0x0000, /* U+a79d */
  0x0000, /* U+a79e */
  0x0000, /* U+a79f */
  0x0000, /* U+a7a0 */
  0x0000, /* U+a7a1 */
  0x0000, /* U+a7a2 */
  0x0000, /* U+a7a3 */
  0x0000, /* U+a7a4 */
  0x0000, /* U+a7a5 */
  0x0000, /* U+a7a6 */
  0x0000, /* U+a7a7 */
  0x0000, /* U+a7a8 */
  0x0000, /* U+a7a9 */
  0x0000, /* U+a7aa */
  0x0000, /* U+a7ab */
  0x0000, /* U+a7ac */
  0x0000, /* U+a7ad */
  0x0000, /* U+a7ae */
  0x0000, /* U+a7af */
  0x0000, /* U+a7b0 */
  0x0000, /* U+a7b1 */
  0x0000, /* U+a7b2 */
  0x0000, /* U+a7b3 */
  0x0000, /* U+a7b4 */
  0x0000, /* U+a7b5 */
  0x0000, /* U+a7b6 */
  0x0000, /* U+a7b7 */
  0x0000, /* U+a7b8 */
  0x0000, /* U+a7b9 */
  0x0000, /* U+a7ba */
  0x0000, /* U+a7bb */
  0x0000, /* U+a7bc */
  0x0000, /* U+a7bd */
  0x0000, /* U+a7be */
  0x0000, /* U+a7bf */
  0x0000, /* U+a7c0 */
  0x0000, /* U+a7c1 */
  0x0000, /* U+a7c2 */
  0x0000, /* U+a7c3 */
  0x0000, /* U+a7c4 */
  0x0000, /* U+a7c5 */
  0x0000, /* U+a7c6 */
  0x0000, /* U+a7c7 */
  0x0000, /* U+a7c8 */
  0x0000, /* U+a7c9 */
  0x0000, /* U+a7ca */
  0x0000, /* U+a7cb */
  0x0000, /* U+a7cc */
  0x0000, /* U+a7cd */
  0x0000, /* U+a7ce */
  0x0000, /* U+a7cf */
  0x0000, /* U+a7d0 */
  0x0000, /* U+a7d1 */
  0x0000, /* U+a7d2 */
  0x0000, /* U+a7d3 */
  0x0000, /* U+a7d4 */
  0x0000, /* U+a7d5 */
  0x0000, /* U+a7d6 */
  0x0000, /* U+a7d7 */
  0x0000, /* U+a7d8 */
  0x0000, /* U+a7d9 */
  0x0000, /* U+a7da */
  0x0000, /* U+a7db */
  0x0000, /* U+a7dc */
  0x0000, /* U+a7dd */
  0x0000, /* U+a7de */
  0x0000, /* U+a7df */
  0x0000, /* U+a7e0 */
  0x0000, /* U+a7e1 */
  0x0000, /* U+a7e2 */
  0x0000, /* U+a7e3 */
  0x0000, /* U+a7e4 */
  0x0000, /* U+a7e5 */
  0x0000, /* U+a7e6 */
  0x0000, /* U+a7e7 */
  0x0000, /* U+a7e8 */
  0x0000, /* U+a7e9 */
  0x0000, /* U+a7ea */
  0x0000, /* U+a7eb */
  0x0000, /* U+a7ec */
  0x0000, /* U+a7ed */
  0x0000, /* U+a7ee */
  0x0000, /* U+a7ef */
  0x0000, /* U+a7f0 */
  0x0000, /* U+a7f1 */
  0x0000, /* U+a7f2 */
  0x0000, /* U+a7f3 */
  0x0000, /* U+a7f4 */
  0x0000, /* U+a7f5 */
  0x0000, /* U+a7f6 */
  0x0000, /* U+a7f7 */
  0x0000, /* U+a7f8 */
  0x0000, /* U+a7f9 */
  0x0000, /* U+a7fa */
  0x0000, /* U+a7fb */
  0x0000, /* U+a7fc */
  0x0000, /* U+a7fd */
  0x0000, /* U+a7fe */
  0x0000, /* U+a7ff */
  0x0000, /* U+a800 */
  0x0000, /* U+a801 */
  0x0000, /* U+a802 */
  0x0000, /* U+a803 */
  0x0000, /* U+a804 */
  0x0000, /* U+a805 */
  0x0000, /* U+a806 */
  0x0000, /* U+a807 */
  0x0000, /* U+a808 */
  0x0000, /* U+a809 */
  0x0000, /* U+a80a */
  0x0000, /* U+a80b */
  0x0000, /* U+a80c */
  0x0000, /* U+a80d */
  0x0000, /* U+a80e */
  0x0000, /* U+a80f */
  0x0000, /* U+a810 */
  0x0000, /* U+a811 */
  0x0000, /* U+a812 */
  0x0000, /* U+a813 */
  0x0000, /* U+a814 */
  0x0000, /* U+a815 */
  0x0000, /* U+a816 */
  0x0000, /* U+a817 */
  0x0000, /* U+a818 */
  0x0000, /* U+a819 */
  0x0000, /* U+a81a */
  0x0000, /* U+a81b */
  0x0000, /* U+a81c */
  0x0000, /* U+a81d */
  0x0000, /* U+a81e */
  0x0000, /* U+a81f */
  0x0000, /* U+a820 */
  0x0000, /* U+a821 */
  0x0000, /* U+a822 */
  0x0000, /* U+a823 */
  0x0000, /* U+a824 */
  0x0000, /* U+a825 */
  0x0000, /* U+a826 */
  0x0000, /* U+a827 */
  0x0000, /* U+a828 */
  0x0000, /* U+a829 */
  0x0000, /* U+a82a */
  0x0000, /* U+a82b */
  0x0000, /* U+a82c */
  0x0000, /* U+a82d */
  0x0000, /* U+a82e */
  0x0000, /* U+a82f */
  0x0000, /* U+a830 */
  0x0000, /* U+a831 */
  0x0000, /* U+a832 */
  0x0000, /* U+a833 */
  0x0000, /* U+a834 */
  0x0000, /* U+a835 */
  0x0000, /* U+a836 */
  0x0000, /* U+a837 */
  0x0000, /* U+a838 */
  0x0000, /* U+a839 */
  0x0000, /* U+a83a */
  0x0000, /* U+a83b */
  0x0000, /* U+a83c */
  0x0000, /* U+a83d */
  0x0000, /* U+a83e */
  0x0000, /* U+a83f */
  0x0000, /* U+a840 */
  0x0000, /* U+a841 */
  0x0000, /* U+a842 */
  0x0000, /* U+a843 */
  0x0000, /* U+a844 */
  0x0000, /* U+a845 */
  0x0000, /* U+a846 */
  0x0000, /* U+a847 */
  0x0000, /* U+a848 */
  0x0000, /* U+a849 */
  0x0000, /* U+a84a */
  0x0000, /* U+a84b */
  0x0000, /* U+a84c */
  0x0000, /* U+a84d */
  0x0000, /* U+a84e */
  0x0000, /* U+a84f */
  0x0000, /* U+a850 */
  0x0000, /* U+a851 */
  0x0000, /* U+a852 */
  0x0000, /* U+a853 */
  0x0000, /* U+a854 */
  0x0000, /* U+a855 */
  0x0000, /* U+a856 */
  0x0000, /* U+a857 */
  0x0000, /* U+a858 */
  0x0000, /* U+a859 */
  0x0000, /* U+a85a */
  0x0000, /* U+a85b */
  0x0000, /* U+a85c */
  0x0000, /* U+a85d */
  0x0000, /* U+a85e */
  0x0000, /* U+a85f */
  0x0000, /* U+a860 */
  0x0000, /* U+a861 */
  0x0000, /* U+a862 */
  0x0000, /* U+a863 */
  0x0000, /* U+a864 */
  0x0000, /* U+a865 */
  0x0000, /* U+a866 */
  0x0000, /* U+a867 */
  0x0000, /* U+a868 */
  0x0000, /* U+a869 */
  0x0000, /* U+a86a */
  0x0000, /* U+a86b */
  0x0000, /* U+a86c */
  0x0000, /* U+a86d */
  0x0000, /* U+a86e */
  0x0000, /* U+a86f */
  0x0000, /* U+a870 */
  0x0000, /* U+a871 */
  0x0000, /* U+a872 */
  0x0000, /* U+a873 */
  0x0000, /* U+a874 */
  0x0000, /* U+a875 */
  0x0000, /* U+a876 */
  0x0000, /* U+a877 */
  0x0000, /* U+a878 */
  0x0000, /* U+a879 */
  0x0000, /* U+a87a */
  0x0000, /* U+a87b */
  0x0000, /* U+a87c */
  0x0000, /* U+a87d */
  0x0000, /* U+a87e */
  0x0000, /* U+a87f */
  0x0000, /* U+a880 */
  0x0000, /* U+a881 */
  0x0000, /* U+a882 */
  0x0000, /* U+a883 */
  0x0000, /* U+a884 */
  0x0000, /* U+a885 */
  0x0000, /* U+a886 */
  0x0000, /* U+a887 */
  0x0000, /* U+a888 */
  0x0000, /* U+a889 */
  0x0000, /* U+a88a */
  0x0000, /* U+a88b */
  0x0000, /* U+a88c */
  0x0000, /* U+a88d */
  0x0000, /* U+a88e */
  0x0000, /* U+a88f */
  0x0000, /* U+a890 */
  0x0000, /* U+a891 */
  0x0000, /* U+a892 */
  0x0000, /* U+a893 */
  0x0000, /* U+a894 */
  0x0000, /* U+a895 */
  0x0000, /* U+a896 */
  0x0000, /* U+a897 */
  0x0000, /* U+a898 */
  0x0000, /* U+a899 */
  0x0000, /* U+a89a */
  0x0000, /* U+a89b */
  0x0000, /* U+a89c */
  0x0000, /* U+a89d */
  0x0000, /* U+a89e */
  0x0000, /* U+a89f */
  0x0000, /* U+a8a0 */
  0x0000, /* U+a8a1 */
  0x0000, /* U+a8a2 */
  0x0000, /* U+a8a3 */
  0x0000, /* U+a8a4 */
  0x0000, /* U+a8a5 */
  0x0000, /* U+a8a6 */
  0x0000, /* U+a8a7 */
  0x0000, /* U+a8a8 */
  0x0000, /* U+a8a9 */
  0x0000, /* U+a8aa */
  0x0000, /* U+a8ab */
  0x0000, /* U+a8ac */
  0x0000, /* U+a8ad */
  0x0000, /* U+a8ae */
  0x0000, /* U+a8af */
  0x0000, /* U+a8b0 */
  0x0000, /* U+a8b1 */
  0x0000, /* U+a8b2 */
  0x0000, /* U+a8b3 */
  0x0000, /* U+a8b4 */
  0x0000, /* U+a8b5 */
  0x0000, /* U+a8b6 */
  0x0000, /* U+a8b7 */
  0x0000, /* U+a8b8 */
  0x0000, /* U+a8b9 */
  0x0000, /* U+a8ba */
  0x0000, /* U+a8bb */
  0x0000, /* U+a8bc */
  0x0000, /* U+a8bd */
  0x0000, /* U+a8be */
  0x0000, /* U+a8bf */
  0x0000, /* U+a8c0 */
  0x0000, /* U+a8c1 */
  0x0000, /* U+a8c2 */
  0x0000, /* U+a8c3 */
  0x0000, /* U+a8c4 */
  0x0000, /* U+a8c5 */
  0x0000, /* U+a8c6 */
  0x0000, /* U+a8c7 */
  0x0000, /* U+a8c8 */
  0x0000, /* U+a8c9 */
  0x0000, /* U+a8ca */
  0x0000, /* U+a8cb */
  0x0000, /* U+a8cc */
  0x0000, /* U+a8cd */
  0x0000, /* U+a8ce */
  0x0000, /* U+a8cf */
  0x0000, /* U+a8d0 */
  0x0000, /* U+a8d1 */
  0x0000, /* U+a8d2 */
  0x0000, /* U+a8d3 */
  0x0000, /* U+a8d4 */
  0x0000, /* U+a8d5 */
  0x0000, /* U+a8d6 */
  0x0000, /* U+a8d7 */
  0x0000, /* U+a8d8 */
  0x0000, /* U+a8d9 */
  0x0000, /* U+a8da */
  0x0000, /* U+a8db */
  0x0000, /* U+a8dc */
  0x0000, /* U+a8dd */
  0x0000, /* U+a8de */
  0x0000, /* U+a8df */
  0x0000, /* U+a8e0 */
  0x0000, /* U+a8e1 */
  0x0000, /* U+a8e2 */
  0x0000, /* U+a8e3 */
  0x0000, /* U+a8e4 */
  0x0000, /* U+a8e5 */
  0x0000, /* U+a8e6 */
  0x0000, /* U+a8e7 */
  0x0000, /* U+a8e8 */
  0x0000, /* U+a8e9 */
  0x0000, /* U+a8ea */
  0x0000, /* U+a8eb */
  0x0000, /* U+a8ec */
  0x0000, /* U+a8ed */
  0x0000, /* U+a8ee */
  0x0000, /* U+a8ef */
  0x0000, /* U+a8f0 */
  0x0000, /* U+a8f1 */
  0x0000, /* U+a8f2 */
  0x0000, /* U+a8f3 */
  0x0000, /* U+a8f4 */
  0x0000, /* U+a8f5 */
  0x0000, /* U+a8f6 */
  0x0000, /* U+a8f7 */
  0x0000, /* U+a8f8 */
  0x0000, /* U+a8f9 */
  0x0000, /* U+a8fa */
  0x0000, /* U+a8fb */
  0x0000, /* U+a8fc */
  0x0000, /* U+a8fd */
  0x0000, /* U+a8fe */
  0x0000, /* U+a8ff */
  0x0000, /* U+a900 */
  0x0000, /* U+a901 */
  0x0000, /* U+a902 */
  0x0000, /* U+a903 */
  0x0000, /* U+a904 */
  0x0000, /* U+a905 */
  0x0000, /* U+a906 */
  0x0000, /* U+a907 */
  0x0000, /* U+a908 */
  0x0000, /* U+a909 */
  0x0000, /* U+a90a */
  0x0000, /* U+a90b */
  0x0000, /* U+a90c */
  0x0000, /* U+a90d */
  0x0000, /* U+a90e */
  0x0000, /* U+a90f */
  0x0000, /* U+a910 */
  0x0000, /* U+a911 */
  0x0000, /* U+a912 */
  0x0000, /* U+a913 */
  0x0000, /* U+a914 */
  0x0000, /* U+a915 */
  0x0000, /* U+a916 */
  0x0000, /* U+a917 */
  0x0000, /* U+a918 */
  0x0000, /* U+a919 */
  0x0000, /* U+a91a */
  0x0000, /* U+a91b */
  0x0000, /* U+a91c */
  0x0000, /* U+a91d */
  0x0000, /* U+a91e */
  0x0000, /* U+a91f */
  0x0000, /* U+a920 */
  0x0000, /* U+a921 */
  0x0000, /* U+a922 */
  0x0000, /* U+a923 */
  0x0000, /* U+a924 */
  0x0000, /* U+a925 */
  0x0000, /* U+a926 */
  0x0000, /* U+a927 */
  0x0000, /* U+a928 */
  0x0000, /* U+a929 */
  0x0000, /* U+a92a */
  0x0000, /* U+a92b */
  0x0000, /* U+a92c */
  0x0000, /* U+a92d */
  0x0000, /* U+a92e */
  0x0000, /* U+a92f */
  0x0000, /* U+a930 */
  0x0000, /* U+a931 */
  0x0000, /* U+a932 */
  0x0000, /* U+a933 */
  0x0000, /* U+a934 */
  0x0000, /* U+a935 */
  0x0000, /* U+a936 */
  0x0000, /* U+a937 */
  0x0000, /* U+a938 */
  0x0000, /* U+a939 */
  0x0000, /* U+a93a */
  0x0000, /* U+a93b */
  0x0000, /* U+a93c */
  0x0000, /* U+a93d */
  0x0000, /* U+a93e */
  0x0000, /* U+a93f */
  0x0000, /* U+a940 */
  0x0000, /* U+a941 */
  0x0000, /* U+a942 */
  0x0000, /* U+a943 */
  0x0000, /* U+a944 */
  0x0000, /* U+a945 */
  0x0000, /* U+a946 */
  0x0000, /* U+a947 */
  0x0000, /* U+a948 */
  0x0000, /* U+a949 */
  0x0000, /* U+a94a */
  0x0000, /* U+a94b */
  0x0000, /* U+a94c */
  0x0000, /* U+a94d */
  0x0000, /* U+a94e */
  0x0000, /* U+a94f */
  0x0000, /* U+a950 */
  0x0000, /* U+a951 */
  0x0000, /* U+a952 */
  0x0000, /* U+a953 */
  0x0000, /* U+a954 */
  0x0000, /* U+a955 */
  0x0000, /* U+a956 */
  0x0000, /* U+a957 */
  0x0000, /* U+a958 */
  0x0000, /* U+a959 */
  0x0000, /* U+a95a */
  0x0000, /* U+a95b */
  0x0000, /* U+a95c */
  0x0000, /* U+a95d */
  0x0000, /* U+a95e */
  0x0000, /* U+a95f */
  0x0000, /* U+a960 */
  0x0000, /* U+a961 */
  0x0000, /* U+a962 */
  0x0000, /* U+a963 */
  0x0000, /* U+a964 */
  0x0000, /* U+a965 */
  0x0000, /* U+a966 */
  0x0000, /* U+a967 */
  0x0000, /* U+a968 */
  0x0000, /* U+a969 */
  0x0000, /* U+a96a */
  0x0000, /* U+a96b */
  0x0000, /* U+a96c */
  0x0000, /* U+a96d */
  0x0000, /* U+a96e */
  0x0000, /* U+a96f */
  0x0000, /* U+a970 */
  0x0000, /* U+a971 */
  0x0000, /* U+a972 */
  0x0000, /* U+a973 */
  0x0000, /* U+a974 */
  0x0000, /* U+a975 */
  0x0000, /* U+a976 */
  0x0000, /* U+a977 */
  0x0000, /* U+a978 */
  0x0000, /* U+a979 */
  0x0000, /* U+a97a */
  0x0000, /* U+a97b */
  0x0000, /* U+a97c */
  0x0000, /* U+a97d */
  0x0000, /* U+a97e */
  0x0000, /* U+a97f */
  0x0000, /* U+a980 */
  0x0000, /* U+a981 */
  0x0000, /* U+a982 */
  0x0000, /* U+a983 */
  0x0000, /* U+a984 */
  0x0000, /* U+a985 */
  0x0000, /* U+a986 */
  0x0000, /* U+a987 */
  0x0000, /* U+a988 */
  0x0000, /* U+a989 */
  0x0000, /* U+a98a */
  0x0000, /* U+a98b */
  0x0000, /* U+a98c */
  0x0000, /* U+a98d */
  0x0000, /* U+a98e */
  0x0000, /* U+a98f */
  0x0000, /* U+a990 */
  0x0000, /* U+a991 */
  0x0000, /* U+a992 */
  0x0000, /* U+a993 */
  0x0000, /* U+a994 */
  0x0000, /* U+a995 */
  0x0000, /* U+a996 */
  0x0000, /* U+a997 */
  0x0000, /* U+a998 */
  0x0000, /* U+a999 */
  0x0000, /* U+a99a */
  0x0000, /* U+a99b */
  0x0000, /* U+a99c */
  0x0000, /* U+a99d */
  0x0000, /* U+a99e */
  0x0000, /* U+a99f */
  0x0000, /* U+a9a0 */
  0x0000, /* U+a9a1 */
  0x0000, /* U+a9a2 */
  0x0000, /* U+a9a3 */
  0x0000, /* U+a9a4 */
  0x0000, /* U+a9a5 */
  0x0000, /* U+a9a6 */
  0x0000, /* U+a9a7 */
  0x0000, /* U+a9a8 */
  0x0000, /* U+a9a9 */
  0x0000, /* U+a9aa */
  0x0000, /* U+a9ab */
  0x0000, /* U+a9ac */
  0x0000, /* U+a9ad */
  0x0000, /* U+a9ae */
  0x0000, /* U+a9af */
  0x0000, /* U+a9b0 */
  0x0000, /* U+a9b1 */
  0x0000, /* U+a9b2 */
  0x0000, /* U+a9b3 */
  0x0000, /* U+a9b4 */
  0x0000, /* U+a9b5 */
  0x0000, /* U+a9b6 */
  0x0000, /* U+a9b7 */
  0x0000, /* U+a9b8 */
  0x0000, /* U+a9b9 */
  0x0000, /* U+a9ba */
  0x0000, /* U+a9bb */
  0x0000, /* U+a9bc */
  0x0000, /* U+a9bd */
  0x0000, /* U+a9be */
  0x0000, /* U+a9bf */
  0x0000, /* U+a9c0 */
  0x0000, /* U+a9c1 */
  0x0000, /* U+a9c2 */
  0x0000, /* U+a9c3 */
  0x0000, /* U+a9c4 */
  0x0000, /* U+a9c5 */
  0x0000, /* U+a9c6 */
  0x0000, /* U+a9c7 */
  0x0000, /* U+a9c8 */
  0x0000, /* U+a9c9 */
  0x0000, /* U+a9ca