/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_92__
#define __TIFFEP_TIVARS_92__

#include "tiffep.h"

/*************************/
/* Structure definitions */
/*************************/

/* TI92 calculators */

/*
  This structure is used for storing a real
*/
struct real_number_92_
{
  // TI encoding
  byte flags;
  byte exponent[2];
  byte mantissa[7];
};
typedef struct real_number_92_ RealNumber_92;

/*
  This structure is used for storing a complex number
*/
struct complex_number_92_
{
  RealNumber_92 real_part;
  RealNumber_92 imag_part;
};
typedef struct complex_number_92_ CplxNumber_92;

/*
  This structure is used for storing a real list
*/
struct var_real_list_92_
{
  // TI encoding
  word nelts;       // number of elements in the list
  RealNumber_92 *elts; // array of elements (Real)
};
typedef struct var_real_vector_92_ RealList_92;


/*
  This structure is used for storing a real matrix
*/
struct var_real_matrix_92_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_92 *elts; // array of elements (Real)
};
typedef struct var_real_matrix_92_ RealMatrix_92;


/*
  This structure is used to store an Y-equation object
*/
struct var_y_equation_92_
{
  word n_tokens;
  byte *tokens;
};
typedef struct var_y_equation_92_ YVariable_92;


/*
  This structure is used for storing a Graphic Data Base object
*/
struct functions_92_
{
  byte flags;
  YVariable_92 fnct;
};

struct var_gdb_function_92_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 x_res;

  struct functions_92_ fnct_table[10];
};

struct var_gdb_polar_92_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 theta_min;
  RealNumber_92 theta_max;
  RealNumber_92 theta_step;
  
  struct functions_92_ fnct_table[10];
};

struct var_gdb_param_92_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 t_min;
  RealNumber_92 t_max;
  RealNumber_92 t_step;
  
  struct functions_92_ fnct_table[12];
};

struct var_gdb_seq_92_
{
  // TI encoding
  word length;
  byte mode_id;
  byte mode_settings;
  byte unused;

  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 n_min;
  RealNumber_92 n_max;
  RealNumber_92 un_start;
  RealNumber_92 vn_start;
  RealNumber_92 n_start;
  
  struct functions_92_ fnct_table[2];
};

union var_gdb_92_
{
  struct var_gdb_function_92_ fnct;
  struct var_gdb_polar_92_    polar;
  struct var_gdb_param_92_    param;
  struct var_gdb_seq_92_      seq;
};
typedef union var_gdb_92_ Gdb_92;

/*
  This structure is used for storing a picture object
*/
struct var_picture_92_
{
  // TI encoding
  word size;
  word rows;
  word cols;
  byte bitmap[3840];
};
typedef struct var_picture_92_ Picture_92;

/*
  This structure is used for storing a program object
*/
typedef YVariable_92 Program_92;

/*
  This structure is used for storing a Window Settings object
*/
struct var_wndsettings_normal_92_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 theta_min;
  RealNumber_92 theta_max;
  RealNumber_92 theta_step;
  RealNumber_92 t_min;
  RealNumber_92 t_max;
  RealNumber_92 t_step;
  RealNumber_92 n_min;
  RealNumber_92 n_max;
  RealNumber_92 un_start;
  RealNumber_92 vn_start;
  RealNumber_92 n_start;
};

struct var_wndsettings_saved_92_
{
  // TI encoding
  word unused;
  RealNumber_92 x_min;
  RealNumber_92 x_max;
  RealNumber_92 x_scl;
  RealNumber_92 y_min;
  RealNumber_92 y_max;
  RealNumber_92 y_scl;
  RealNumber_92 theta_min;
  RealNumber_92 theta_max;
  RealNumber_92 theta_step;
  RealNumber_92 t_min;
  RealNumber_92 t_max;
  RealNumber_92 t_step;
  RealNumber_92 n_min;
  RealNumber_92 n_max;
  RealNumber_92 un_start;
  RealNumber_92 vn_start;
  RealNumber_92 n_start;
};

union var_wndsettings_92_
{
  struct var_wndsettings_normal_92_ fnct;
  struct var_wndsettings_saved_92_    zsto;
};
typedef union var_wndsettings_92_ WndSettings_92;

/*
  This structure is used for storing a Table Settings object
*/
struct var_tblsettings_92_
{
  // TI encoding
  word unused;
  RealNumber_92 tbl_min;
  RealNumber_92 delta_tbl;
};

typedef struct var_tblsettings_92_ TblSettings_92;

/*
  This structure is used for storing a string
*/
struct var_string_92_
{
  // TI encoding
  byte unused;  // always 0x00
  byte *string; // zero terminated
  byte unused2; // always 0x2d
};
typedef struct var_string_92_ String_92;

/*
  This structure is used for storing a text object
*/
struct var_text_92_
{
  // TI encoding
  word curs_pos; // cursor position
  byte *text;    // string zero terminated
  byte unused2;  // always 0x2d
};
typedef struct var_text_92_ Text_92;

#endif




