// C++ header file partially generated from Ada using cproto.adb

extern "C" {

//----------------------------------------------------------------------------
// OS                                                                       --
//                                                                          --
// Part of TextTools                                                        --
// Designed and Programmed by Ken O. Burtch                                 --
//                                                                          --
//----------------------------------------------------------------------------
//                                                                          --
//                 Copyright (C) 1999-2001 Ken O. Burtch                    --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------


//-> Housekeeping

extern void startup_os( void );

// StartupOS initializes the OS package.  This must be the first subprogram
// executed in the OS package.
// Errors: none

extern void idle_os( a_time_stamp idle_period );

// IdleOS executes idle time tasks when the user's computer is idle.
// Errors: none

extern void shutdown_os( void );

// ShutDownOS shuts down the OS package.  This must be the final subprogram
// executed in the OS package.
// Errors: none

//-> File Systems
//
// This is a list of the file systems recognized (or someday recognized)
// by the OS package.
//
// UNIX    - 255 character UNIX
// UNIX 14 - 14 character UNIX
// DOSFS   - 8.3 character DOS
// OS/2    - 255 character OS2
// NONE    - no file system

enum a_file_system {unixfs, unix14_fs, dosfs, os2_fs, none};


//-> Pathnames
//
// A pathname is just a string.
//
// Path aliases are shortforms.  Predefined are
// $tmp  = Temporary Directory (eg. /tmp/ )
// $sys  = User's System Directory ( eg /home/bob/System )
// $home = User's System Directory ( eg /home/bob )

typedef str255 a_pathname;

//-> O/S Shell Interface
//
// These invoke system() with the specified command.  Except for the
// boolean function, all others return CoreSystemError if the command
// failed (ie. returned a bad status).  All return CoreParamError if
// the string is can't be converted to a C String for the call.

// extern int unix( str255 s );
// shell string, return status
// extern void unix( str255 s );
// shell string
// extern str255 unix( str255 s );
// shell string, return output

// extern int unix( char * s );
// extern void unix( char * s );
// extern str255 unix( char * s );
//function  UNIX( s : string ) return Str255List.List;

// UNIX executes a UNIX shell command.  The boolean function version returns
// true if there were no errors.  The Str255 version returns the (first)
// string that results from executing the command.
// Errors: TT_SystemError - the shell command errored
//         TT_ParamError  - the command string was too long to handle

//extern void run_it( char * cmd, char * parm1, char * parm2, char * parm3 = "", str255_list._list *results );
// Execute command, return results in "results" and exit status in
// status.


//-> File System Calls

extern void validate_filename( a_file_system fs, a_pathname *oldfn, a_pathname *newfn, str255 *errmsg );

// validate_filename verifies that a pathname is syntactically correct
// for the specified file system. If the filename is unacceptable,
// the reason is outlined in errmsg and a legal filename with the
// problem characters removed is returned.  (The new filename typically
// has underscores in place of illegal characters.)  If the filename is
// acceptable, errmsg is empty.
// Errors: none

extern void validate_pathname( a_file_system fs, a_pathname oldfn, a_pathname *newfn, str255 *errmsg );

// Like validate_filename, but validates a path

// GetEnvironment( TheList : Str255List.List );
// GetEnvironmentVariable( Variable : str255 ) return str255;

//-> File Utility Calls

enum a_file_usage {no_usage, read_only, normal, run};

extern unsigned char not_empty( a_pathname s );

// not_empty is true if the specified file has a length greater than zero.
// Errors: CoreParamError - the path is too long to be handled
//         KB: should return other disk errors

extern unsigned char is_dir( a_pathname s );

// is_dir is true if the pathname specifies a directory.
// Errors: none

extern unsigned char is_file( a_pathname s );

// is_file is true if the pathname specifies a readable, existing file.
// Errors: none

extern void make_temp_file_name( a_pathname s );

// MakeTempFileName returns the path to a temporary file.
// Errors: none

// extern int lock( a_pathname file );

// NOT YET WRITTEN
// Locks a file for your private use.
// Errors: none

// extern void unlock( a_pathname file );
//unlocks a file

extern void erase( a_pathname file );
//deletes a file

extern void trash( a_pathname file );
//file to trash can

extern void empty_trash( void );
//empties the trash can

extern void move( a_pathname file1, a_pathname file2 );
//moves a file

extern a_pathname shrink( a_pathname file );
//compress a file

extern a_pathname expand( a_pathname file );
//uncompress a file

extern void archive( a_pathname arch, a_pathname file );
//add a file to an archive

extern void extract( a_pathname arch, a_pathname file );
//remove a file from archive

// extern void armour( a_pathname file, a_pathname keyfile = null_str255 );
// extern void disarmour( a_pathname file, a_pathname keyfile = null_str255 );
// extern void usage( a_pathname file, a_file_usage me = normal, a_file_usage us = read_only, a_file_usage everyone = read_only );

//-> Caching Control

// extern void begin_session( void );
// extern void end_session( void );


//-> Basic Directory Utilities

extern long space_used( a_pathname dir );
// bytes in and under dir, as with `du -sf` * blocksize


//-> Device Utilities

// extern long space_free( a_pathname dev );
// bytes free in device
// extern long total_space( a_pathname dev );
// total bytes on device
// extern long entries_free( a_pathname dev );
// inodes free on device
// extern long total_entries( a_pathname dev );
// total inodes on device
// extern a_pathname on_device( a_pathname path );


//-> Hardware Utilities

extern long total_mem( void );

extern long free_mem( void );

extern long real_total_mem( void );

extern long real_free_mem( void );


//-> Host Utilities

extern str255 get_free_cluster_host( void );

// GetFreeClusterHost returns the name of a free (ie. low activity)
// machine from the current computer cluster network.  If there is no
// cluster, the name of the current computer is returned.
// Security considerations: what does this mean for remote windows?
// Errors: none


//-> Str255List files

extern void load_list( a_pathname path, str255list_list *str_list );
extern void save_list( a_pathname path, str255list_list *str_list );


//-> Processes

// extern long my_id( void );
// ID for my process/program
// extern void nice( int change );
// change process' priority onthefly
// get/set password
// get login directory
// get user id / username
// get group id
extern int is_local( void );
// true if user is local to server

//-> Paths
//
// A path can't be an object because it's used multiple times in
// parameter lists; gnat to balk on dispatching even when there is
// no dispatching.

enum a_path_type {unknown, file, http, ftp, window, runnable};
// How about a variant record?

extern void set_path( a_pathname s );
// change current path
extern a_pathname get_path( void );
// return current path

extern void path_alias( str255 alias, a_pathname path );

// PathAlias defines an alias for Lintel pathnames.  There are no checks
// to see if the alias is a legitimate path.
// Errors: storage exception if out of memory

// extern void decompose_path( a_pathname path, a_path_type *path_type, str255 *host, a_pathname *filepath );

// DecomposePath takes a path or URL and separates it into it's three
// components: the type of access, the computer address, and the path.
// Unknown URL's are returned as type "unknown".  There are no checks
// to see if the Lintel URL is accessible.  The path is expanded before
// it's decomposed.
//  Note: ftp login not supported yet--can we?
// Errors: none

extern a_pathname expand_path( a_pathname path );

// ExpandPath returns the path with any path aliases replaced with
// the prefix they represent.  There are no checks to see if the
// resulting path is legitimate.
//   For example, if the alias "$TMP" is defined as "/usr/tmp", then
// ExpandPath would return "/usr/tmp/file" if the path is "$TMP/file".
// Errors: none

extern void split_path( str255 path, str255 *dir, str255 *file );

// SplitPath splits off the trailing file in a path, the one after
// the last slash.  This routine has not been updated for aliases
// or URL's (yet).
// Errors: none

//-> Calander Functions
//
// ATimeStamp is defined in common.

typedef struct _a_time {
  long seconds;
  long microseconds;
} a_time;

typedef struct _a_time_zone {
  int minutes; // minutes west of Greenwich
  int savings; // additional daylight savings minutes
} a_time_zone;

extern str255 get_date( void );
// return date in dd/mm/yy format
extern str255 get_time( void );
// return time in hr:mm:ss format
// extern void get_clock( a_time *time, a_time_zone *timezone );
// Linux unistd.h
extern str255 get_long_date( void );
// return full English date
extern a_time_stamp get_time_stamp( void );
// get a sortable time-stamp
// (in milliseconds)
extern void wait( float seconds );

//-> Text File

extern void add_file( str255 file, str255 text );

//-> Logging

extern void session_log( str255 message );
// extern void session_log( char * ada_message );
// extern void session_log( str255 message, an_error_code error_code );
// extern void session_log( char * ada_message, an_error_code error_code );

}
