/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#include "TeMultiGeometry.h"


TeMultiGeometry::TeMultiGeometry(const TeMultiGeometry& other)
{
	polygons_.copyElements(other.polygons_);
	lines_.copyElements(other.lines_);
	points_.copyElements(other.points_);
	cells_.copyElements(other.cells_);
}

TeMultiGeometry& 	
TeMultiGeometry::operator= (const TeMultiGeometry& other)
{
	if ( this != &other )
	{
		polygons_.copyElements(other.polygons_);
		lines_.copyElements(other.lines_);
		points_.copyElements(other.points_);
		cells_.copyElements(other.cells_);
	}
	return *this;
}
	
	
bool 
TeMultiGeometry::getGeometry(TePolygonSet& result)
{
	if(!hasPolygons())
		return false;
	result.copyElements(polygons_);
	return true;
}


bool 
TeMultiGeometry::getGeometry(TeLineSet& result)
{
	if(!hasLines())
		return false;
	result.copyElements(lines_);
	return true;
}
	
bool 
TeMultiGeometry::getGeometry(TePointSet& result)
{
	if(!hasPoints())
		return false;
	result.copyElements(points_);
	return true;
}
	
bool 
TeMultiGeometry::getGeometry(TeCellSet& result)
{
	if(!hasCells())
		return false;
	result.copyElements(cells_);
	return true;
}
	
bool 
TeMultiGeometry::getGeometry(vector<TeGeometry*>& result) 
{
	bool status = false;
	if(hasPolygons())
	{
		for(int i=0; i< (int)polygons_.size(); ++i)
		{
			TePolygon* pol = new TePolygon();
			(*pol) = polygons_[i];
			result.push_back (pol);
			status = true;
		}
	}
	if(hasLines())
	{
		for(int i=0; i< (int)lines_.size(); ++i)
		{
			TeLine2D* lin = new TeLine2D();
			(*lin) = lines_[i];
			result.push_back (lin);
			status = true;
		}
	}
	if(hasPoints())
	{
		for(int i=0; i< (int)points_.size(); ++i)
		{
			TePoint* pon = new TePoint();
			(*pon) = points_[i];
			result.push_back (pon);
			status = true;
		}
	}
	if(hasCells())
	{
		for(int i=0; i< (int)cells_.size(); ++i)
		{
			TeCell* cell = new TeCell();
			(*cell) = cells_[i];
			result.push_back (cell);
			status = true;
		}
	}
	return status;
}

void 
TeMultiGeometry::setGeometry(vector<TeGeometry*>& result)
{
	this->clear();
	vector<TeGeometry*>::iterator it = result.begin();
	
	while(it!=result.end())
	{
		TeGeometry* geom = (*it);
		
		if(dynamic_cast<TePolygon*> (geom))
			polygons_.add (*((TePolygon*)geom));
		else if (dynamic_cast<TePolygonSet*> (geom))
			polygons_ = *((TePolygonSet*) geom);
		else if(dynamic_cast<TeLine2D*> (geom))
			lines_.add (*((TeLine2D*)geom));
		else if(dynamic_cast<TeLineSet*> (geom))
			lines_ = *((TeLineSet*)geom);
		else if(dynamic_cast<TePoint*> (geom))
			points_.add (*((TePoint*)geom));
		else if(dynamic_cast<TePointSet*> (geom))
			points_ = *((TePointSet*)geom);
		else if(dynamic_cast<TeCell*> (geom))
			cells_.add (*((TeCell*)geom));
		else if(dynamic_cast<TeCellSet*> (geom))
			cells_ = *((TeCellSet*)geom);

		++it;
	}
}

void 
TeMultiGeometry::clear()
{
	polygons_.clear ();
	lines_.clear ();
	points_.clear ();
	cells_.clear ();
}
