
#include <TePDIAgnostic.hpp>

#include <TePDISharedPtr.cpp>

#include <string>

int main()
{
  PDIAGN_LOGMSG( "Test started." );

  PDIAGN_DEBUG_MODE_CHECK;

  try{
    TePDISharedPtr< int > sptr1( new int );

    *sptr1 = 12345;

    TePDISharedPtr< int > sptr2;

    sptr2 = sptr1;

    *sptr2 = 54321;

    PDIAGN_TRUE_OR_THROW( *sptr2 == 54321,
      "Invalid pointer 2 reference" );

    PDIAGN_TRUE_OR_THROW( *sptr1 == 54321,
      "Invalid pointer 1 reference" );

    sptr1.reset( new int );

    *sptr1 = 6789;

    PDIAGN_TRUE_OR_THROW( *sptr1 == 6789,
      "Invalid pointer 1 reference" );

    PDIAGN_TRUE_OR_THROW( *sptr2 == 54321,
      "Invalid pointer 2 reference" );

    TePDISharedPtr< int > sptr3( sptr2 );

    PDIAGN_TRUE_OR_THROW( *sptr3 == 54321,
      "Invalid pointer 2 reference" );

    /* Static shared pointer test */

    int temp_int = 54321;
    int* temp_int_ptr = &temp_int;

    if( true ) {
      TePDISharedPtr< int > sptr4( temp_int_ptr, true );
    }

    PDIAGN_TRUE_OR_THROW( *temp_int_ptr == 54321,
      "Invalid naked pointer reference" );
  }
  catch(...){
    PDIAGN_LOGERR( "Test Failed.");
    return EXIT_FAILURE;
  }

  PDIAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
