/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: reply.h,v 1.1.1.1 2001/09/25 00:33:31 michael Exp $ */

#ifndef REPLY_H
#define REPLY_H 1

#include "linkedlist.h"
#include "const.h"

/* snsp_reply_line, snsp_reply */

typedef enum {
	snsp_reply_line_type_negative = 0,
	snsp_reply_line_type_positive = 1 
} snsp_reply_line_type_t;

typedef enum {
	snsp_reply_line_linetype_singleline = 0,
	snsp_reply_line_linetype_multiline = 1
} snsp_reply_line_linetype_t;

typedef struct snsp_reply_line {
	snsp_reply_line_type_t	type;
	LINKED_LIST_T(char *)	*code; 
	LINKED_LIST_T(char *)	*parameters; 
} snsp_reply_line_t;

typedef struct snsp_reply {
	LINKED_LIST_T(snsp_reply_line_t*)		*lines; 
} snsp_reply_t;

snsp_reply_line_t* snsp_reply_line_alloc ();
void snsp_reply_line_free ( snsp_reply_line_t **reply_line );
char *snsp_reply_line_render ( snsp_reply_line_t *reply_line, 
		               snsp_reply_line_linetype_t mline );
snsp_reply_line_t* snsp_reply_line_parse ( char *reply_line_str,
	snsp_reply_line_linetype_t *mline);

snsp_reply_t* snsp_reply_alloc ( );
void snsp_reply_free ( snsp_reply_t **reply );
char *snsp_reply_render ( snsp_reply_t *reply );
snsp_reply_t *snsp_reply_parse ( char *reply_str);

snsp_reply_line_t*
snsp_reply_line_create ( snsp_reply_line_type_t reply_line_type,
			 ... );
snsp_reply_t* snsp_reply_create ( char dummy, ... );

#endif /* REPLY_H */
