/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

class PrimitiveObjects {
    static int BYTE_LOWER_BOUND = 0;
    static int BYTE_UPPER_BOUND = 255;
    static int CHARACTER_LOWER_BOUND = 0;
    static int CHARACTER_UPPER_BOUND = 255;
    static int SHORT_LOWER_BOUND = -1000;
    static int SHORT_UPPER_BOUND = 1000;
    static int INTEGER_LOWER_BOUND = -1000;
    static int INTEGER_UPPER_BOUND = 1000;
    static int LONG_LOWER_BOUND = -1000;
    static int LONG_UPPER_BOUND = 1000;
    static Byte[] mBytes = PrimitiveObjects.createBytes();
    static Character[] mCharacters = PrimitiveObjects.createCharacters();
    static Short[] mShorts = PrimitiveObjects.createShorts();
    static Integer[] mIntegers = PrimitiveObjects.createIntegers();
    static Long[] mLongs = PrimitiveObjects.createLongs();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    PrimitiveObjects() {
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Byte getByte(byte by) {
        if (by >= BYTE_LOWER_BOUND && by <= BYTE_UPPER_BOUND) {
            return mBytes[by - BYTE_LOWER_BOUND];
        }
        return new Byte(by);
    }

    public static Character getCharacter(char c) {
        if (c >= CHARACTER_LOWER_BOUND && c <= CHARACTER_UPPER_BOUND) {
            return mCharacters[c - CHARACTER_LOWER_BOUND];
        }
        return new Character(c);
    }

    public static Short getShort(short s) {
        if (s >= SHORT_LOWER_BOUND && s <= SHORT_UPPER_BOUND) {
            return mShorts[s - SHORT_LOWER_BOUND];
        }
        return new Short(s);
    }

    public static Integer getInteger(int n) {
        if (n >= INTEGER_LOWER_BOUND && n <= INTEGER_UPPER_BOUND) {
            return mIntegers[n - INTEGER_LOWER_BOUND];
        }
        return new Integer(n);
    }

    public static Long getLong(long l) {
        if (l >= (long)LONG_LOWER_BOUND && l <= (long)LONG_UPPER_BOUND) {
            return mLongs[(int)l - LONG_LOWER_BOUND];
        }
        return new Long(l);
    }

    public static Float getFloat(float f) {
        return new Float(f);
    }

    public static Double getDouble(double d) {
        return new Double(d);
    }

    public static Class getPrimitiveObjectClass(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveObjects.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveObjects.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveObjects.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (clazz == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveObjects.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (clazz == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveObjects.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveObjects.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveObjects.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveObjects.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return clazz;
    }

    static Byte[] createBytes() {
        int n = BYTE_UPPER_BOUND - BYTE_LOWER_BOUND + 1;
        Byte[] byteArray = new Byte[n];
        byte by = (byte)BYTE_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            byteArray[n2] = new Byte(by);
            ++n2;
            by = (byte)(by + 1);
        }
        return byteArray;
    }

    static Character[] createCharacters() {
        int n = CHARACTER_UPPER_BOUND - CHARACTER_LOWER_BOUND + 1;
        Character[] characterArray = new Character[n];
        char c = (char)CHARACTER_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            characterArray[n2] = new Character(c);
            ++n2;
            c = (char)(c + '\u0001');
        }
        return characterArray;
    }

    static Short[] createShorts() {
        int n = SHORT_UPPER_BOUND - SHORT_LOWER_BOUND + 1;
        Short[] shortArray = new Short[n];
        short s = (short)SHORT_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            shortArray[n2] = new Short(s);
            ++n2;
            s = (short)(s + 1);
        }
        return shortArray;
    }

    static Integer[] createIntegers() {
        int n = INTEGER_UPPER_BOUND - INTEGER_LOWER_BOUND + 1;
        Integer[] integerArray = new Integer[n];
        int n2 = INTEGER_LOWER_BOUND;
        int n3 = 0;
        while (n3 < n) {
            integerArray[n3] = new Integer(n2);
            ++n3;
            ++n2;
        }
        return integerArray;
    }

    static Long[] createLongs() {
        int n = LONG_UPPER_BOUND - LONG_LOWER_BOUND + 1;
        Long[] longArray = new Long[n];
        long l = LONG_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            longArray[n2] = new Long(l);
            ++n2;
            ++l;
        }
        return longArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

