/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.util;


import java.io.*;

/**
 * A reader which maps all bytes read from the input stream 1:1
 * into chars, hereby using all bytes 0-255.
 */
public class RawByteReader
    extends java.io.Reader
{
    private InputStream stream;
    
    public RawByteReader(InputStream stream)
    {
        this.stream=stream;
    }

    public int read(char[] cbuf,
                    int    off,
                    int    len)
        throws IOException
    {
        try {
            byte[] bbuf=new byte[len];
            int result=stream.read(bbuf);
            
            if(result==-1) {
                return -1; 
            }
            int i;
            int off_i=off;
            for(i=0; i<result; ++i, ++off_i) {
                int current= bbuf[i] & 0xFF;
                cbuf[off_i]=(char)current;
            }
            return result;
        } catch(IOException ioEx) {
            throw ioEx;
        } catch(Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public long skip(long n)
        throws IOException
    {
        return stream.skip(n);
    }

    public boolean markSupported()
    {
        return stream.markSupported();
    }

    public void mark(int readAheadLimit)
        throws IOException
    {
        stream.mark(readAheadLimit);
    }

    public void reset()
        throws IOException
    {
        stream.reset();
    }

    public void close()
        throws IOException
    {
        stream.close();
    }
    
}


