/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.ParameterMetaData;
import java.sql.SQLException;


public class ClientParameterMetaDataSapDB
    implements ParameterMetaData
{
    private ParameterMetaData originalMetaData;
    private ClientConnectionSapDB clientConnection;

    static ParameterMetaData createNew(ParameterMetaData originalMetaData,
                                       ClientConnectionSapDB clientConnection)
    {
        ParameterMetaData pd=new ClientParameterMetaDataSapDB(originalMetaData, clientConnection);
        return pd;
    }
    
    private ClientParameterMetaDataSapDB(ParameterMetaData originalMetaData, 
                                        ClientConnectionSapDB clientConnection)
    {
        this.originalMetaData=originalMetaData;
        this.clientConnection=clientConnection;
    }
    
    void exceptionOccurred(SQLException sqlEx) 
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }
    
    // Code for delegation of java.sql.ParameterMetaData methods to originalMetaData

    public int isNullable(int param1) throws SQLException
    {
        try {
            return originalMetaData.isNullable(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isSigned(int param1) throws SQLException
    {
        try {
            return originalMetaData.isSigned(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getPrecision(int param1) throws SQLException
    {
        try {
            return originalMetaData.getPrecision(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getScale(int param1) throws SQLException
    {
        try {
            return originalMetaData.getScale(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getParameterCount() throws SQLException
    {
        try {
            return originalMetaData.getParameterCount();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getParameterType(int param1) throws SQLException
    {
        try {
            return originalMetaData.getParameterType(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getParameterTypeName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getParameterTypeName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getParameterClassName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getParameterClassName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getParameterMode(int param1) throws SQLException
    {
        try {
            return originalMetaData.getParameterMode(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

}
