/*!
	========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/
package com.sap.dbtech.jdbc.translators;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.vsp00.StreamHandle;

/**
 * Getval instance for simple ASCII OMS Streams.
 */
public class BinaryABAPStreamGetval 
	extends AbstractABAPStreamGetval {
	
	public BinaryABAPStreamGetval(ABAPStreamTranslator translator) {
		super(translator);
		addColumn(StreamHandle.Stream_OUT_C,
				  StreamHandle.StreamType_Char_C,
				  1,
				  0,
				  1,
				  0);
	}

	public byte[] getBytes() 
		throws SQLException {
		if(data == null) {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_NODATA));
		}
		return data.bytes();	
	}


	public Object getObject() 
		throws SQLException {
		return getBytes();	
	}
	
	public Blob getBlob() 
		throws SQLException {
		if(data == null) {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_NODATA));
		}
		return new BlobImplementation(data.bytes());
	}
	
	static class BlobImplementation
		implements Blob
	{
		byte[] data;
		
		BlobImplementation(byte[] data)
		{
			this.data = data;	
		}

		public long length() throws SQLException {
			return data.length;
		}

		public void truncate(long len) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "truncate"));
		}

		public byte[] getBytes(long pos, int length) throws SQLException {
			if(pos > data.length || pos < 1) {
				throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_INVALID_BLOB_POSITION, new Long(pos)));
			} else {
				int copy = (int) Math.min(length, data.length + 1 - pos);
				byte[] result = new byte[copy];
				System.arraycopy(data, (int) (pos-1), result, 0, copy);
				return result;
			}
		}

		public int setBytes(long pos, byte[] bytes) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "setBytes"));
		}

		public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "setBytes"));
		}

		public long position(byte[] pattern, long start) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "position"));
		}

		public InputStream getBinaryStream() throws SQLException {
			return new ByteArrayInputStream(data);
		}

		public OutputStream setBinaryStream(long pos) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "setBinaryStream"));
		}

		public long position(Blob pattern, long start) throws SQLException {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_BLOB_UNSUPPORTED, "position"));
		}
	}
}
