/*
 * Copyright (c) 2001-2006 Hewlett-Packard Development Company, L.P.
 * Contributed by Stephane Eranian <eranian@hpl.hp.com>
 *
 * This header file contains obsolete user-level perfmon interface
 * definitions for the Itanium Processor Family architecture.
 *
 * please use replacements as indicated below whenever possible.
 */

#ifndef _PERFMON_COMPAT_H_
#define _PERFMON_COMPAT_H_

#ifndef __ia64__
#error "you should not include this file on non Itanium platforms"
#endif

/*
 * old perfmon2 interface for backward compatibility.
 * Do not use in portable applications.
 */
extern int perfmonctl(int fd, int cmd, void *arg, int narg);

/*
 * obsolete perfmon comamnds supported on all CPU models
 */
#define PFM_WRITE_PMCS		0x01 
#define PFM_WRITE_PMDS		0x02 
#define PFM_READ_PMDS		0x03 
#define PFM_STOP		0x04
#define PFM_START		0x05
#define PFM_ENABLE		0x06 /* obsolete */
#define PFM_DISABLE		0x07 /* obsolete */
#define PFM_CREATE_CONTEXT	0x08
#define PFM_DESTROY_CONTEXT	0x09 /* obsolete use close() */
#define PFM_RESTART		0x0a
#define PFM_PROTECT_CONTEXT	0x0b /* obsolete */
#define PFM_GET_FEATURES	0x0c /* obsolete: use /proc/sys/kernel/perfmon */
#define PFM_DEBUG		0x0d /* obsolete: use /proc/sys/kernel/perfmon/debug */
#define PFM_UNPROTECT_CONTEXT	0x0e /* obsolete */
#define PFM_GET_PMC_RESET_VAL	0x0f /* obsolete: use /proc/perfmon_mappings */
#define PFM_LOAD_CONTEXT	0x10
#define PFM_UNLOAD_CONTEXT	0x11

/*
 * PMU model specific commands (may not be supported on all PMU models)
 */
#define PFM_WRITE_IBRS		0x20 /* obsolete: use PFM_WRITE_PMCS[256-263] */
#define PFM_WRITE_DBRS		0x21 /* obsolete: use PFM_WRITE_PMCS[264-271] */

/*
 * argument to PFM_CREATE_CONTEXT
 * Obsolete: use PFM_CREATE_CONTEXT2 with pfarg_ctx_t argument
 */
typedef struct {
	pfm_uuid_t     ctx_smpl_buf_id;	 /* which buffer format to use (if needed) */
	unsigned long  ctx_flags;	 /* noblock/block */
	unsigned int   ctx_reserved1;	 /* for future use */
	int	       ctx_fd;		 /* return arg: unique identification for context */
	void	       *ctx_smpl_vaddr;	 /* return arg: virtual address of sampling buffer, is used */
	unsigned long  ctx_reserved3[11];/* for future use */
} pfarg_context_t;


/*
 * argument structure for PFM_WRITE_PMCS/PFM_WRITE_PMDS/PFM_WRITE_PMDS
 *
 * This data structure and associated commands are NOW OBOSOLTE, use
 * pfarg_pmd_t and pfarg_pmc_t instead.
 */
typedef struct {
	unsigned int	reg_num;	   /* which register */
	unsigned short	reg_set;	   /* event set for this register */
	unsigned short	reg_reserved1;	   /* for future use */

	unsigned long	reg_value;	   /* initial pmc/pmd value */
	unsigned long	reg_flags;	   /* input: pmc/pmd flags, return: reg error */

	unsigned long	reg_long_reset;	   /* reset after buffer overflow notification */
	unsigned long	reg_short_reset;   /* reset after counter overflow */

	unsigned long	reg_reset_pmds[4]; /* which other counters to reset on overflow */
	unsigned long	reg_random_seed;   /* seed value when randomization is used */
	unsigned long	reg_random_mask;   /* bitmask used to limit random value */
	unsigned long   reg_last_reset_val;/* return: PMD last reset value */

	unsigned long	reg_smpl_pmds[4];  	/* which pmds are accessed when PMC overflows */
	unsigned long	reg_smpl_eventid;  	/* opaque sampling event identifier */
	unsigned long   reg_ovfl_switch_cnt;	/* how many overflow before switch for next set */

	unsigned long   reg_reserved2[2];   /* for future use */
} pfarg_reg_t;

/*
 * argument to PFM_WRITE_IBRS/PFM_WRITE_DBRS
 * OBSOLETE: use PFM_WRITE_PMCS instead
 */
typedef struct {
	unsigned int	dbreg_num;		/* which debug register */
	unsigned short	dbreg_set;		/* event set for this register */
	unsigned short	dbreg_reserved1;	/* for future use */
	unsigned long	dbreg_value;		/* value for debug register */
	unsigned long	dbreg_flags;		/* return: dbreg error */
	unsigned long	dbreg_reserved2[1];	/* for future use */
} pfarg_dbreg_t;

/*
 * OBSOLETE: use PFM_GET_CONFIG
 *
 * argument to PFM_GET_FEATURES
 */
typedef struct {
	unsigned int	ft_version;	/* perfmon: major [16-31], minor [0-15] */
	unsigned int	ft_reserved;	/* reserved for future use */
	unsigned long	reserved[4];	/* for future use */
} pfarg_features_t;

#endif /* _PERFMON_COMPAT_H_ */
