#include "osl/effect/moveSignature.h"
#include "osl/misc/loki.h"
#include <iostream>

namespace osl
{
namespace effect
{
  std::ostream& operator<<(std::ostream& os,const MoveSignature signature){
    os << "Signature[";
    for(int i=7;i>=0;i--){
      if((signature&(1<<i))!=0) os<< "1";
      else os<< "0";
    }
    return os << "]";
  }


  template<Ptype T>
  void MoveSignatureTable::setSignature(){
    signatures[static_cast<int>(newPtypeO(BLACK,T)-PTYPEO_MIN)]=
      SignatureTraits<T>::signature | getPlayerMask<BLACK>();
    signatures[static_cast<int>(newPtypeO(WHITE,T)-PTYPEO_MIN)]=
      SignatureTraits<T>::signature | getPlayerMask<WHITE>();
  }

  template<Ptype T>
  void MoveSignatureTable::setSignatures(Int2Type<T>){
    setSignature<T>();
    setSignatures<static_cast<Ptype>(T+1)>(Int2Type<static_cast<Ptype>(T+1) >());
  }

  template<>
  void MoveSignatureTable::setSignatures<ROOK>(Int2Type<ROOK>){
    setSignature<ROOK>();
  }
  
  MoveSignatureTable::MoveSignatureTable(){
    setSignatures<PPAWN>(Int2Type<PPAWN>());
    signatures[PTYPEO_EMPTY-PTYPEO_MIN]=signature_EMPTY;
    signatures[PTYPEO_EDGE-PTYPEO_MIN]=signature_EDGE;
  }
} // namespace effect
} // namespace osl
