#ifndef _ADD_EFFECT_TABLE_H
#define _ADD_EFFECT_TABLE_H

#include "osl/ptype.h"
#include "osl/offset32.h"
#include "osl/container/nearMask.h"
#include "osl/misc/carray.h"
#include "osl/misc/carray2d.h"
#include "osl/misc/carray3d.h"

namespace osl
{
  namespace move_generator
  {
  /**
   * 利きをつける手を生成するためのテーブル．
   * 
   */
  class AddEffectTable
  {
    CArray2d<NearMask, PTYPE_SIZE, Offset32::SIZE> nearMask;
    CArray2d<NearMask, PTYPE_SIZE, Offset32::SIZE> nearMaskWithPromote;
    CArray2d<NearMask, PTYPE_SIZE, Offset32::SIZE> nearMaskLong;
    /** 実は 4 bit * 8 のテーブルにするのが自然だった */
    CArray3d<Offset,PTYPE_SIZE,Offset32::SIZE,8> offsetLong;
    CArray<NearMask,Offset32::SIZE> nearMaskPBISHOP;
    CArray2d<Offset,Offset32::SIZE,8> offsetPBISHOP;
    CArray<NearMask,Offset32::SIZE> nearMaskPROOK;
    CArray2d<Offset,Offset32::SIZE,8> offsetPROOK;
    void setNearMaskLong(Ptype ptype,int dx, int dy);
  public:
    AddEffectTable();
    /**
     * @param P(template) - 手番のプレイヤー
     * @param ptype - 動かそうとする駒の種類
     * @param from - 動かそうとする駒の位置
     * @param to - 利きをつけたいマス
     */
    template<Player P>
    NearMask getNearMask(Ptype ptype,Square from, Square to) const{
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return nearMask[ptype][offset32.index()];
    }
    template<Player P>
    NearMask getNearMaskWithPromote(Ptype ptype,Square from, Square to) const{
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return nearMaskWithPromote[ptype][offset32.index()];
    }
    template<Player P>
    NearMask getNearMaskLong(Ptype ptype,Square from, Square to) const{
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return nearMaskLong[ptype][offset32.index()];
    }
    template<Player P>
    Offset getOffsetLong(Ptype ptype,Square from, Square to,int n) const 
    {
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard() && 
	     0<=n && n<8);
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return offsetLong[ptype](offset32.index(),n);
    }
    template<Player P>
    NearMask getNearMaskPBISHOP(Square from, Square to) const{
      assert(from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return nearMaskPBISHOP[offset32.index()];
    }
    template<Player P>
    Offset getOffsetPBISHOP(Square from, Square to,int n) const 
    {
      assert(from.isOnBoard() && to.isOnBoard() && 0<=n && n<8);
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return offsetPBISHOP(offset32.index(),n);
    }
    template<Player P>
    NearMask getNearMaskPROOK(Square from, Square to) const{
      assert(from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return nearMaskPROOK[offset32.index()];
    }
    template<Player P>
    Offset getOffsetPROOK(Square from, Square to,int n) const
    {
      assert(from.isOnBoard() && to.isOnBoard() && 0<=n && n<8);
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return offsetPROOK(offset32.index(),n);
    }
  };

  extern const AddEffectTable Add_Effect_Table;

  } // namespace move_generator
} // namespace osl
#endif /* _ADD_EFFECT_TABLE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
