#!/usr/bin/ruby
Copyright = %$Copyleft: (c) 2001 Nakada.Nobuyoshi <nobu.nokada@softhome.net> $.freeze
RCSID = %w$Id: install.rb,v 0.8 2002/03/23 07:36:26 nobu Exp $[1..-1].each {|s| s.freeze}.freeze
Version = RCSID[1].split('.').collect {|s| s.to_i}.extend(Comparable).freeze
Release = RCSID[2]

srcdir = File.dirname(__FILE__)
$:.unshift(srcdir)
require 'optparse'
require 'rbconfig'
require 'ftools'

ARGV.options {|q|
  @exec = true
  @verbose = true
  @more = true
  @main = true
  @doc = true
  @man = true
  @mantype = '.gz'
  q.banner = "Usage: ruby #{q.program_name} [OPTIONS] [more]\n"
  q.summary_width = 44
  q.on('--site-install', '--default', 'install to site_ruby') {@dest = nil}
  q.on('--more-install', 'install some more files') {|@more|}
  q.on('-l', '--less', 'not install optional files') {@more = false}
  q.on('-m', '--[no-]man-install[=DIR]', 'install manuals') {|@man|}
  q.on('-d', '--[no-]doc-install[=DIR]', 'install documents') {|@doc|}
  q.on('-M', '--compression=TYPE', [".bz2", ".gz"], 'manual compression') {|@mantype|}
  q.on('-C', '--destdir=DIR', '--destination-directory', String, 'install to DIR') {|@dest|}
  q.on('-P', '--prefix', '--destdir-prefix=DIR', String, 'install directory prefix') {|@prefix|}
  q.on('-q', '--no-verbose', '--[no-]quiet', 'run verbosely/quietly') {|@verbose|}
  q.on('-n', '--no-install', '--show-only', FalseClass, 'show settings and exit') {|@exec|}
  q.on('-L', '--list-only', 'list installed files only and exit') {|@list|}
  q.order! do |nonopt|
    begin
      q.parse("--#{nonopt}")
    rescue OptionParser::InvalidOption
      raise OptionParser::InvalidArgument, nonopt if @dest
      @dest = nonopt
    end
  end
} or (puts ARGV.options; exit 1)

COMPRESS = {".gz" => "gzip", ".bz2" => "bzip2"}
def COMPRESS.[](f)
  t = f.sub(/\.\w+$/, '')
  f = t if cmd = super($&)
  [f, cmd]
end

if @list
  @main = @exec
  def makedirs(d)
  end
  def install(src, dest, mode = 0644)
    print(dest, "\n")
  end
elsif @exec
  def makedirs(d)
    File.makedirs(d, @verbose)
  end
  def install(src, dest, mode = 0644)
    File.safe_unlink(dest)
    dest, cmd = COMPRESS[dest]
    File.install(src, dest, mode, @verbose)
    system(cmd, dest) if cmd
  end
else
  def makedirs(d)
    puts("install -d #{d}")
  end
  def install(src, dest, mode = 0644)
    dest, cmd = COMPRESS[dest]
    printf("install -m %o %s %s\n", mode, src, dest)
    printf("%s %s\n", cmd, dest) if cmd
  end
end

if @prefix
  def prefix(dir)
    dir = dir.sub!(/\A[a-z]:/i, '') if File::ALT_SEPARATOR == ';'
    dir.sub(/\A\/*/, @prefix + '/')
  end
else
  def prefix(dir)
    dir
  end
end

@dest ||= Config::CONFIG['sitedir']
@dest = prefix(@dest)
if srcdir == '.'
  srcdir = ''
else
  srcdir.sub!(/[^\/]\z/, '\&/')
end

if @main
  files = ["#{srcdir}optparse.rb"]
  files.concat(Dir.glob("#{srcdir}optparse/**/*.rb")) if @more

  dirs = {}
  files.each do |f|
    dest = File.join(@dest, f[srcdir.length..-1])
    dirs[d = File.dirname(dest)] ||= (makedirs(d); true)
    install(f, dest)
  end
end

if @man
  if @man == true
    @man = Config::CONFIG["mandir"]
  end
  @man = prefix(@man)
  ["", ".ja"].each do |lang|
    makedirs(dir = @man+lang.tr(".", "/")+"/man3")
    install("#{srcdir}optparse#{lang}.1", file = dir+"/optparse.3r#{@mantype}")
  end
end

if @doc
  if @doc == true
    @doc = Config::CONFIG["docdir"] ||
      Config::CONFIG["datadir"]+"/doc/ruby/optparse-"+OptionParser::Revision
  end
  @doc = prefix(@doc)
  DOCS = %w[
    ChangeLog ChangeLog.html README.en README.ja FIRSTSTEP.ja.rd FIRSTSTEP.ja.html
    optparse.html optparse.ja.rd optparse.ja.html rmi.html
    cmd.rb cmd-ls.rb getopts.test getopts.test.en opttest.rb
  ]

  makedirs(@doc)
  DOCS.each do |file|
    install(srcdir+file, File.join(@doc, file))
  end
end
