/* GNU Objective C Runtime class related functions
   Copyright (C) 1993, 1995, 1996, 1997 Free Software Foundation, Inc.
   Contributed by Kresten Krab Thorup and Dennis Glatting.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

GNU CC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
GNU CC; see the file COPYING.  If not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with files compiled with
   GCC to produce an executable, this does not cause the resulting executable
   to be covered by the GNU General Public License. This exception does not
   however invalidate any other reasons why the executable file might be
   covered by the GNU General Public License.  */

#ifndef __objc_globals_H__
#define __objc_globals_H__

#include "objc-decls.h"
#include "objc-api.h"

/*
  Global variables used in the Objective-C runtime.
*/

/* ******************** from class.c: ******************** */

/* The table of classname->class.  Used for objc_lookup_class and friends */
objc_EXPORT cache_ptr __objc_class_hash;                     /* !T:MUTEX */

/* This is a hook which is called by objc_get_class and 
   objc_lookup_class if the runtime is not able to find the class.
   This may e.g. try to load in the class using dynamic loading */
objc_EXPORT Class (*_objc_lookup_class)(const char* name);   /* !T:SAFE */


/* True when class links has been resolved */     
objc_EXPORT BOOL __objc_class_links_resolved;                /* !T:UNUSED */

/* ******************** from init.c: ********************* */

/* This list contains all modules currently loaded into the runtime */
objc_EXPORT struct objc_list* __objc_module_list;            /* !T:MUTEX */

/* This list contains all proto_list's not yet assigned class links */
objc_EXPORT struct objc_list* __objc_unclaimed_proto_list;   /* !T:MUTEX */

/* List of unresolved static instances.  */
objc_EXPORT struct objc_list *__objc_uninitialized_statics;  /* !T:MUTEX */

/* Global runtime "write" mutex. */
objc_EXPORT objc_mutex_t __objc_runtime_mutex;

/* Number of threads that are alive. */
objc_EXPORT int __objc_runtime_threads_alive;                /* !T:MUTEX */

/* This is a hook which is called by __objc_exec_class every time a class
   or a category is loaded into the runtime.  This may e.g. help a
   dynamic loader determine the classes that have been loaded when
   an object file is dynamically linked in */
objc_EXPORT void (*_objc_load_callback)(Class class, Category *category); /* !T:SAFE*/

/* Is all categories/classes resolved? */
objc_EXPORT BOOL __objc_dangling_categories;                 /* !T:UNUSED */

/* This is a linked list of objc_class_tree trees. The head of these trees
   are root classes (their super class is Nil). These different trees
   represent different class hierarchies. */
objc_EXPORT struct objc_list *__objc_class_tree_list;

/* Keeps the +load methods who have been already executed. This hash should
   not be destroyed during the execution of the program. */
objc_EXPORT cache_ptr __objc_load_methods;


/* ******************** from selector.c: ********************* */

/* Tables mapping selector names to uid and opposite */
objc_EXPORT struct sarray* __objc_selector_array; /* uid -> sel-list !T:MUTEX */
objc_EXPORT struct sarray* __objc_selector_names; /* uid -> name     !T:MUTEX */
objc_EXPORT cache_ptr      __objc_selector_hash;  /* name -> uid     !T:MUTEX */

/* Number of selectors stored in each of the above tables */
objc_EXPORT int __objc_selector_max_index;        /* !T:MUTEX */

#endif /* __objc_globals_H__ */
