/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.heartbeat;

import java.io.IOException;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.ReflectionException;

import mx4j.tools.connector.RemoteMBeanServer;

/**
 * Interface to be implemented by HeartBeatListener. Adds local interface
 * to be used by clients monitoring status of communication.
 *
 * @author <a href="mailto:mgore@users.sourceforge.net">Michael Gorelik</a>
 * @version $Revision: 1.5 $
 */
public interface HeartBeatListenerControl
{

   public static final String LOST_HEARTBEAT = "lostHeartbeat";

   /**
    * Add listener to a remote heartbeat source and register application to
    * receive heart beat failure notification from HeartBeatListener.
    */
   public void registerObserver(RemoteMBeanServer connector, Object connectorType, Object address, String sourceCanonName, NotificationListener observer)
      throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException;

   /**
    * Removes the specified heartbeat observer.
    */
   public void unregisterObserver(String sourceCanonName, NotificationListener listener);
}
