/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.interceptor;

import mx4j.log.Logger;

/**
 * This interceptor registers and logs invocation times along the adaptor's interceptor chain
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.3 $
 */
public class TimingAdaptorInterceptor extends AdaptorInterceptor
{
	private ThreadLocal m_time = new ThreadLocal();

	protected void preInvoke(Invocation invocation) throws Exception
	{
		m_time.set(new Long(System.currentTimeMillis()));
	}

	protected void postInvoke(Invocation invocation) throws Exception
	{
		long end = System.currentTimeMillis();
		long invocationTime = end - ((Long)m_time.get()).longValue();

		Logger logger = getLogger();
		if (logger.isEnabledFor(Logger.INFO)) {logger.info("Invocation time: " + invocationTime);}
	}

	public String getType()
	{
		return "timing";
	}
}
