/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management.modelmbean;

import javax.management.RuntimeOperationsException;
import javax.management.MBeanException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Descriptor;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.2 $
 */
public interface ModelMBeanInfo extends Cloneable
{
	public Descriptor[] getDescriptors(String descriptorType) throws MBeanException, RuntimeOperationsException;
	public void setDescriptors(Descriptor[] descriptors) throws MBeanException, RuntimeOperationsException;
	public Descriptor getDescriptor(String descriptorName, String descriptorType) throws MBeanException, RuntimeOperationsException;
	public void setDescriptor(Descriptor descriptor, String descriptorType) throws MBeanException, RuntimeOperationsException;
	public Descriptor getMBeanDescriptor() throws MBeanException, RuntimeOperationsException;
	public void setMBeanDescriptor(Descriptor descriptor) throws MBeanException, RuntimeOperationsException;
	public ModelMBeanAttributeInfo getAttribute(String name) throws MBeanException, RuntimeOperationsException;
	public ModelMBeanOperationInfo getOperation(String name) throws MBeanException, RuntimeOperationsException;
	// The following should be there for symmetry at least
	public ModelMBeanConstructorInfo getConstructor(String name) throws MBeanException, RuntimeOperationsException;
	public ModelMBeanNotificationInfo getNotification(String name) throws MBeanException, RuntimeOperationsException;
	public Object clone();
	public String getClassName();
	public String getDescription();
	public MBeanConstructorInfo[] getConstructors();
	public MBeanAttributeInfo[] getAttributes();
	public MBeanOperationInfo[] getOperations();
	public MBeanNotificationInfo[] getNotifications();
}
