/* $Id: ResConf.xs,v 1.17 2002/02/05 10:08:53 m-kasahr Exp $ */
/*
 * Copyright (c) 2000 Japan Network Information Center.  All rights reserved.
 *  
 * By using this file, you agree to the terms and conditions set forth bellow.
 * 
 *                      LICENSE TERMS AND CONDITIONS 
 * 
 * The following License Terms and Conditions apply, unless a different
 * license is obtained from Japan Network Information Center ("JPNIC"),
 * a Japanese association, Fuundo Bldg., 1-2 Kanda Ogawamachi, Chiyoda-ku,
 * Tokyo, Japan.
 * 
 * 1. Use, Modification and Redistribution (including distribution of any
 *    modified or derived work) in source and/or binary forms is permitted
 *    under this License Terms and Conditions.
 * 
 * 2. Redistribution of source code must retain the copyright notices as they
 *    appear in each source code file, this License Terms and Conditions.
 * 
 * 3. Redistribution in binary form must reproduce the Copyright Notice,
 *    this License Terms and Conditions, in the documentation and/or other
 *    materials provided with the distribution.  For the purposes of binary
 *    distribution the "Copyright Notice" refers to the following language:
 *    "Copyright (c) Japan Network Information Center.  All rights reserved."
 * 
 * 4. Neither the name of JPNIC may be used to endorse or promote products
 *    derived from this Software without specific prior written approval of
 *    JPNIC.
 * 
 * 5. Disclaimer/Limitation of Liability: THIS SOFTWARE IS PROVIDED BY JPNIC
 *    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *    PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL JPNIC BE LIABLE
 *    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *    OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * 6. Indemnification by Licensee
 *    Any person or entities using and/or redistributing this Software under
 *    this License Terms and Conditions shall defend indemnify and hold
 *    harmless JPNIC from and against any and all judgements damages,
 *    expenses, settlement liabilities, cost and other liabilities of any
 *    kind as a result of use and redistribution of this Software or any
 *    claim, suite, action, litigation or proceeding by any third party
 *    arising out of or relates to this License Terms and Conditions.
 * 
 * 7. Governing Law, Jurisdiction and Venue
 *    This License Terms and Conditions shall be governed by and and
 *    construed in accordance with the law of Japan. Any person or entities
 *    using and/or redistributing this Software under this License Terms and
 *    Conditions hereby agrees and consent to the personal and exclusive
 *    jurisdiction and venue of Tokyo District Court of Japan.
 */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <mdn/res.h>
#include <mdn/converter.h>

typedef mdn_resconf_t MDN__ResConf;

#include "lasterror.h"

static int
encoding_option_value(char *option_name)
{
    if (strcmp(option_name, "rtcheck") == 0)
	return MDN_CONVERTER_RTCHECK;
    else if (strcmp(option_name, "delayedopen") == 0)
	return MDN_CONVERTER_DELAYEDOPEN;
    return 0;
}

#ifdef SvUTF8_on
static int
is_utf8(const char *actions)
{
    int utf8 = -1;	/* unknown */
    int c;

    while ((c = *actions++) != '\0') {
	switch (c) {
	case 'l':
	case 'i':
	case 'a':
	    /*
	     * These are the actions that convert something to UTF-8.
	     */
	    utf8 = 1;
	    break;
	case 'L':
	case 'I':
	case 'A':
	    /*
	     * These are the actions that convert UTF-8 to something else.
	     */
	    utf8 = 0;
	    break;
	case 'd':
	case 'M':
	case 'm':
	case 'n':
	case 'p':
	case 'N':
	case 'u':
	    /*
	     * These actions assume that the input is UTF-8 encoded,
	     * and the result is also UTF-8.
	     */
	    utf8 = 1;
	    break;
	}
    }
    return (utf8 == 1);
}
#endif

/******************************************************************/
MODULE = MDN::ResConf		PACKAGE = MDN::ResConf

PROTOTYPES: ENABLE

BOOT:
    {
	mdn_result_t result;
	set_last_error(mdn_success, NULL);
	result = mdn_resconf_initialize();
	if (result != mdn_success) {
	    my_croak(result, NULL);
	}
    }

SV*
lasterror(package_name)
	const char *package_name
    CODE:
	RETVAL = newSVpv(last_error_message, 0);
    OUTPUT:
	RETVAL

MDN::ResConf
new(package_name)
	const char *package_name
    PREINIT:
	mdn_resconf_t context;
	mdn_result_t result;
    CODE:
	result = mdn_resconf_create(&context);
        if (result == mdn_success) {
	    RETVAL = context;
	} else {
	    my_croak(result, NULL);
	}
    OUTPUT:
	RETVAL

int
load_file(self, file_name = NULL)
	MDN::ResConf self
	const char *file_name
    PREINIT:
	mdn_result_t result;
    CODE:
	result = mdn_resconf_loadfile(self, file_name);
        if (result == mdn_success) {
	    RETVAL = 1;
        } else if (result == mdn_nofile || result == mdn_invalid_syntax) {
	    RETVAL = 0;
	    set_last_error(result, file_name);
	} else if (result == mdn_invalid_name) {
	    RETVAL = 0;
	    set_last_error(result, NULL);
        } else {
	    my_croak(result, file_name);
	}
    OUTPUT:
	RETVAL

void
DESTROY(self)
	MDN::ResConf self
    CODE:
	mdn_resconf_destroy(self);

SV*
nameconv(self, actions, from)
	MDN::ResConf self
	const char *actions
	const char *from
    PREINIT:
	mdn_result_t result;
	char *to;
	size_t to_length;
    CODE:
	to_length = strlen(from) + 1;
	for (;;) {
	    to = (char *)safemalloc(to_length);
	    result = mdn_res_nameconv(self, actions, from, to, to_length);
	    if (result == mdn_success) {
		RETVAL = newSVpv(to, 0);
#ifdef SvUTF8_on
		/*
		 * Determine whether the result is a UTF-8 string or not
		 * by examining 'actions', and set UTF8 flag if it is.
		 */
		if (is_utf8(actions)) {
		    SvUTF8_on(RETVAL);
		}
#endif
		break;
	    } else if (result == mdn_invalid_encoding 
		|| result == mdn_invalid_name
		|| result == mdn_nomapping
		|| result == mdn_prohibited) {
		RETVAL = &PL_sv_undef;
		set_last_error(result, from);
		break;
	    } else if (result == mdn_invalid_action) {
		RETVAL = &PL_sv_undef;
		set_last_error(result, actions);
		break;
	    } else if (result != mdn_buffer_overflow) {
		my_croak(result, from);
	    }
	    safefree(to);
	    to_length += to_length;
	}
	safefree(to);
    OUTPUT:
	RETVAL

void
enable(package_name, on_off)
	const char *package_name
	int on_off
    CODE:
	mdn_res_enable(on_off);

int
set_idn_encoding(self, name, ...)
	MDN::ResConf self
	const char *name
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *option_name;
	STRLEN option_length;
	int option_value = 0;
	int i;
    CODE:
	for (i = 2; i < items; i++) {
	    option_name = SvPV(ST(i), option_length);
	    option_value |= encoding_option_value(option_name);
	}
	result = mdn_resconf_setidnconvertername(self, name, option_value);
	if (result == mdn_success) {
	    RETVAL = 1;
	} else if (result == mdn_invalid_name) {
	    RETVAL = 0;
	    set_last_error(result, name);
	} else if (result != mdn_buffer_overflow) {
	    my_croak(result, name);
	}
    OUTPUT:
	RETVAL

int
set_local_encoding(self, name, ...)
	MDN::ResConf self
	const char *name
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *option_name;
	STRLEN option_length;
	int option_value = 0;
	int i;
    CODE:
	for (i = 2; i < items; i++) {
	    option_name = SvPV(ST(i), option_length);
	    option_value |= encoding_option_value(option_name);
	}
	result = mdn_resconf_setlocalconvertername(self, name, option_value);
	if (result == mdn_success) {
	    RETVAL = 1;
	} else if (result == mdn_invalid_name) {
	    RETVAL = 0;
	    set_last_error(result, name);
	} else if (result != mdn_buffer_overflow) {
	    my_croak(result, name);
	}
    OUTPUT:
	RETVAL

int
set_alternate_encoding(self, name, ...)
	MDN::ResConf self
	const char *name
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *option_name;
	STRLEN option_length;
	int option_value = 0;
	int i;
    CODE:
	for (i = 2; i < items; i++) {
	    option_name = SvPV(ST(i), option_length);
	    option_value |= encoding_option_value(option_name);
	}
	result = mdn_resconf_setalternateconvertername(self, name,
	    option_value);
	if (result == mdn_success) {
	    RETVAL = 1;
	} else if (result == mdn_invalid_name) {
	    RETVAL = 0;
	    set_last_error(result, name);
	} else if (result != mdn_buffer_overflow) {
	    my_croak(result, name);
	}
    OUTPUT:
	RETVAL

int
set_nameprep_version(self, name)
	MDN::ResConf self
	const char *name
    PREINIT:
	mdn_result_t result;
    CODE:
	result = mdn_resconf_setnameprepversion(self, name);
	if (result == mdn_success) {
	    RETVAL = 1;
	} else if (result == mdn_invalid_name) {
	    RETVAL = 0;
	    set_last_error(result, name);
	} else if (result != mdn_buffer_overflow) {
	    my_croak(result, name);
	}
    OUTPUT:
	RETVAL

int
add_delimiter_map(self, ...)
	MDN::ResConf self
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	unsigned long ucs;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 1; i < items; i++) {
	    ucs = (unsigned long)SvNV(ST(i));
	    result = mdn_resconf_addalldelimitermapucs(self, &ucs, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_codepoint
		|| result == mdn_failure) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		char ucs_string[16];
		sprintf(ucs_string, "U+%04lX", ucs);
		my_croak(result, ucs_string);
	    }
	}
    OUTPUT:
	RETVAL

int
add_local_map(self, tld, ...)
	MDN::ResConf self
	const char *tld;
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *name;
	STRLEN name_length;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 2; i < items; i++) {
	    name = SvPV(ST(i), name_length);
	    result = mdn_resconf_addalllocalmapselectornames(self, tld,
		(const char **)&name, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_name) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		my_croak(result, name);
	    }
	}
    OUTPUT:
	RETVAL

int
add_nameprep_map(self, ...)
	MDN::ResConf self
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *name;
	STRLEN name_length;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 1; i < items; i++) {
	    name = SvPV(ST(i), name_length);
	    result = mdn_resconf_addallmappernames(self,
		(const char **)&name, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_name) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		my_croak(result, name);
	    }
	}
    OUTPUT:
	RETVAL

int
add_nameprep_normalize(self, ...)
	MDN::ResConf self
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *name;
	STRLEN name_length;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 1; i < items; i++) {
	    name = SvPV(ST(i), name_length);
	    result = mdn_resconf_addallnormalizernames(self,
		(const char **)&name, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_name) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		my_croak(result, name);
	    }
	}
    OUTPUT:
	RETVAL

int
add_nameprep_prohibit(self, ...)
	MDN::ResConf self
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *name;
	STRLEN name_length;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 1; i < items; i++) {
	    name = SvPV(ST(i), name_length);
	    result = mdn_resconf_addallprohibitcheckernames(self,
		(const char **)&name, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_name) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		my_croak(result, name);
	    }
	}
    OUTPUT:
	RETVAL

int
add_nameprep_unassigned(self, ...)
	MDN::ResConf self
    PROTOTYPE: $@
    PREINIT:
	mdn_result_t result;
	char *name;
	STRLEN name_length;
	int i;
    CODE:
	RETVAL = 1;
	for (i = 1; i < items; i++) {
	    name = SvPV(ST(i), name_length);
	    result = mdn_resconf_addallunassignedcheckernames(self,
		(const char **)&name, 1);
	    if (result == mdn_success) {
		continue;
	    } else if (result == mdn_invalid_name) {
		RETVAL = 0;
		set_last_error(result, NULL);
		break;
	    } else {
		my_croak(result, name);
	    }
	}
    OUTPUT:
	RETVAL

void
unset_idn_encoding(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setidnconverter(self, NULL);

void
unset_local_encoding(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setlocalconverter(self, NULL);

void
unset_alternate_encoding(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setalternateconverter(self, NULL);

void
unset_nameprep_version(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setdelimitermap(self, NULL);
	mdn_resconf_setnormalizer(self, NULL);
	mdn_resconf_setprohibitchecker(self, NULL);
	mdn_resconf_setunassignedchecker(self, NULL);

void
unset_delimiter_map(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setdelimitermap(self, NULL);

void
unset_local_map(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setlocalmapselector(self, NULL);

void
unset_nameprep_map(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setmapper(self, NULL);

void
unset_nameprep_normalize(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setnormalizer(self, NULL);

void
unset_nameprep_prohibit(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setprohibitchecker(self, NULL);

void
unset_nameprep_unassigned(self)
        MDN::ResConf self
    CODE:
	mdn_resconf_setunassignedchecker(self, NULL);
