# Test file for TeX::Kpathsea module
# Just a few basic tests, nothing too great.  Of course we assume
# that we have a working TeX installation, or at the very least a
# minimal texmf tree.  There's not much point going further otherwise.

use strict;
use TeX::Kpathsea qw(:formats :functions :misc);

print "Testing TeX::Kpathsea module\n";
print "Checking some variables:\n";
if ($TeX::Kpathsea::VERSION < 3) {
	die "\$TeX::Kpathsea::VERSION is silly: $TeX::Kpathsea::VERSION\n";
} else {
	print "  TeX::Kpathsea version is: $TeX::Kpathsea::VERSION\n";
}
if (! $kpse_version) {
	die "Problem with \$kpse_version\n";
} else {
	print "  based on $kpse_version\n";
}

print "Checking some path searches:\n";
for my $progname (qw(tex latex)) {
	print "  Changing progname to $progname:\n";
	kpse_reset_program_name($progname);
	$progname eq $kpse_program_name or
		die "Couldn't change program name: \$kpse_program_name = $kpse_program_name\n";
	print '    $TEXINPUTS: ', kpse_var_expand('$TEXINPUTS'), "\n";
	print '    plain.tex: ', kpse_find_file('plain.tex', kpse_tex_format(), 0),"\n";
	print '    myplain.tex: ',
		kpse_find_file('myplain.tex', kpse_tex_format(), 0),"\n";
	print '    <empty>: ', kpse_find_file('', kpse_tex_format(), 0),"\n";
}

print "Checking glyph searching:\n";
my $glyph_ret = new kpse_glyph_file_type;
print "  cmr10 (with glyph_ret):\n";
print "  ", kpse_find_glyph('cmr10', 300, $kpse_pk_format, $glyph_ret), "\n";
print "  cmr10 (without glyph_ret; expect a warning here):\n";
print "  ", kpse_find_glyph('cmr10', 300, $kpse_pk_format), "\n";

print "End of tests for TeX::Kpathsea module\n";
