/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ShapeUtilities;

public class ShapeUtilitiesTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$ShapeUtilitiesTests;

    public ShapeUtilitiesTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$ShapeUtilitiesTests != null ? class$org$jfree$util$junit$ShapeUtilitiesTests : (class$org$jfree$util$junit$ShapeUtilitiesTests = ShapeUtilitiesTests.class$("org.jfree.util.junit.ShapeUtilitiesTests")));
    }

    public void testEqualLine2Ds() {
        Assert.assertTrue((boolean)ShapeUtilities.equal(null, null));
        Line2D l1 = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Line2D.Float l2 = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Assert.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
        l1 = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        Assert.assertFalse((boolean)ShapeUtilities.equal(l1, l2));
        l2 = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        Assert.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
        l1 = new Line2D.Double(4.0, 3.0, 2.0, 1.0);
        Assert.assertTrue((boolean)ShapeUtilities.equal(l1, l2));
    }

    public void testEqualShapes() {
        Shape s1 = null;
        Shape s2 = null;
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        s1 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Assert.assertFalse((boolean)s1.equals(s2));
        s1 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Assert.assertTrue((boolean)s1.equals(s2));
        s1 = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Assert.assertFalse((boolean)s1.equals(s2));
        s1 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        s2 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Assert.assertFalse((boolean)s1.equals(s2));
        int[] nArray = new int[3];
        nArray[1] = 1;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[2] = 1;
        Polygon p1 = new Polygon(nArray, nArray2, 3);
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[2] = 1;
        Polygon p2 = new Polygon(nArray3, nArray4, 3);
        s1 = p1;
        s2 = p2;
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        p2 = new Polygon(nArray5, nArray6, 3);
        s2 = p2;
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        GeneralPath g1 = new GeneralPath();
        g1.moveTo(1.0f, 2.0f);
        g1.lineTo(3.0f, 4.0f);
        g1.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g1.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g1.closePath();
        s1 = g1;
        Assert.assertFalse((boolean)ShapeUtilities.equal(s1, s2));
        GeneralPath g2 = new GeneralPath();
        g2.moveTo(1.0f, 2.0f);
        g2.lineTo(3.0f, 4.0f);
        g2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g2.closePath();
        s2 = g2;
        Assert.assertTrue((boolean)ShapeUtilities.equal(s1, s2));
        Assert.assertFalse((boolean)s1.equals(s2));
    }

    public void testIntersects() {
        Rectangle2D.Float r1 = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        Rectangle2D.Float r2 = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        ((Rectangle2D)r1).setRect(100.0, 0.0, 100.0, 0.0);
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
        ((Rectangle2D)r1).setRect(0.0, 0.0, 0.0, 0.0);
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
        ((Rectangle2D)r1).setRect(50.0, 50.0, 10.0, 0.0);
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r1, r2));
        Assert.assertTrue((boolean)ShapeUtilities.intersects(r2, r1));
    }
}

