/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.PaintList;

public class PaintListTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$PaintListTests;

    public PaintListTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$PaintListTests != null ? class$org$jfree$util$junit$PaintListTests : (class$org$jfree$util$junit$PaintListTests = PaintListTests.class$("org.jfree.util.junit.PaintListTests")));
    }

    public void testCloning() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = null;
        try {
            l2 = (PaintList)l1.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("PaintListTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((l1 != l2 ? 1 : 0) != 0);
        Assert.assertTrue((l1.getClass() == l2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l1.equals(l2));
        l2.setPaint(0, Color.green);
        Assert.assertFalse((boolean)l1.equals(l2));
    }

    public void testEquals() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = new PaintList();
        l2.setPaint(0, Color.red);
        l2.setPaint(1, Color.blue);
        l2.setPaint(2, null);
        Assert.assertTrue((boolean)l1.equals(l2));
        Assert.assertTrue((boolean)l2.equals(l2));
    }

    public void testEquals2() {
        PaintList l1 = new PaintList();
        Color color1 = new Color(200, 200, 200);
        l1.setPaint(0, color1);
        PaintList l2 = new PaintList();
        Color color2 = new Color(200, 200, 200);
        l2.setPaint(0, color2);
        Assert.assertEquals((Object)l1, (Object)l2);
    }

    public void testEquals3() {
        PaintList l1 = new PaintList();
        GradientPaint p1 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.blue);
        l1.setPaint(0, p1);
        PaintList l2 = new PaintList();
        GradientPaint p2 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.blue);
        l2.setPaint(0, p2);
        Assert.assertEquals((Object)l1, (Object)l2);
    }

    public void testSerialization() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (PaintList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)l1, l2);
    }
}

