/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupMember.java,v 1.11 2006/02/26 00:59:06 pietschy Exp $
 */
package org.pietschy.command;

import javax.swing.*;
import java.util.List;


/**
 * GroupMembers are responsible for managing the children of a {@link CommandGroup}.  Members provide a layer
 * of abstraction that allows for the lazy addition of children to a group as well as providing customized control
 * over how children are rendered within the groups container, for example {@link GroupMemberFactory#createInlineMember(CommandGroup, CommandGroup) inline groups}.
 * @author andrewp
 * @version $Revision: 1.11 $
 */
public interface
GroupMember
{
   /**
    * This method is responsible for adding this members buttons to the specified container.
    *
    * @param parent
    * @param factory
    * @param faceId
    * @param previousButtons
    * @param buttonIndex
    */
   public void addComponentTo(JComponent parent, Object factory, String faceId, List previousButtons, int buttonIndex);

   public boolean isMemberFor(Command c);

   public boolean isDependantOn(Command c);

   public void acceptVisitor(GroupVisitor visitor);

   public void addNotify();

   public void removeNotify();
}
