package org.pietschy.command.delegate;

import org.pietschy.command.ActionCommandExecutor;

import java.util.EventObject;

/**
 * This event is fired whenever a {@link DelegateMediator}s current container
 * list changes.  The {@link #getExcecutor(String)} method can be used to find
 * most appropriate executor.
 *
 */
public class DelegateMediatorEvent extends EventObject
{
   private DelegateContainer[] containers;

   public DelegateMediatorEvent(DelegateMediator source, DelegateContainer[] containers)
   {
      super(source);
      this.containers = containers;
   }

   public DelegateContainer[] getContainers()
   {
      return containers;
   }

   /**
    * Searches the container hierarchy and gets the first executor it finds.
    * @param id the id to search for.
    * @return the first executor in the container hierarchy or <code>null</code> if
    * non exists.
    */
   public ActionCommandExecutor
   getExcecutor(String id)
   {
      for (int i = 0; i < containers.length; i++)
      {
         ActionCommandExecutor command = containers[i].getCommandExecutor(id);
         if (command != null)
         {
              return command;
         }
      }

      return null;
   }
}
