/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DefaultConditionEvaluator.java,v 1.5 2006/02/26 00:59:05 pietschy Exp $
 */
package org.pietschy.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author andrewp
 * @version $Revision: 1.5 $
 */
public class
DefaultConditionEvaluator
implements ConditionEvaluator
{
   Pattern pattern = Pattern.compile("\\!?\\s*mac");

   public DefaultConditionEvaluator()
   {
   }

   public boolean
   evaluate(String expression)
   throws EvaluationException
   {
      expression = expression.trim();

      Matcher m = pattern.matcher(expression);

      if (!m.matches())
         throw new EvaluationException("expression '" + expression + "' didn't match 'mac' or '!mac'");

      boolean macOS = !expression.startsWith("!");

      return CommandManager.isMacOS() == macOS;
   }
}
