/*
 * Key/Value Data Structure
 *
 * @Copyright (C) 2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_KEY_VALUE_H_
#define _GALAGO_KEY_VALUE_H_

#include <glib-object.h>

typedef struct
{
	char *key;
	GValue *value;

} GalagoKeyValue;

GalagoKeyValue *galago_key_value_new(const char *key, GValue *value);
void galago_key_value_destroy(GalagoKeyValue *key_value);

void galago_key_value_set_key(GalagoKeyValue *key_value,
							  const char *key);
const char *galago_key_value_get_key(const GalagoKeyValue *key_value);

void galago_key_value_set_value(GalagoKeyValue *key_value, GValue *value);
const GValue *galago_key_value_get_value(const GalagoKeyValue *key_value);

#endif /* _GALAGO_KEY_VALUE_H_ */
