// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: algorithms.h,v 1.10 2001/05/22 04:17:41 jgg Exp $
/* ######################################################################

   Algorithms - A set of misc algorithms
   
   This simulate class displays what the ordering code has done and
   analyses it with a fresh new dependency cache. In this way we can
   see all of the effects of an upgrade run.

   pkgDistUpgrade computes an upgrade that causes as many packages as
   possible to move to the newest verison.
   
   pkgApplyStatus sets the target state based on the content of the status
   field in the status file. It is important to get proper crash recovery.

   pkgFixBroken corrects a broken system so that it is in a sane state.
 
   pkgAllUpgrade attempts to upgade as many packages as possible but 
   without installing new packages.
   
   The problem resolver class contains a number of complex algorithms
   to try to best-guess an upgrade state. It solves the problem of 
   maximizing the number of install state packages while having no broken
   packages. 

   ##################################################################### */
									/*}}}*/
#ifndef PKGLIB_ALGORITHMS_H
#define PKGLIB_ALGORITHMS_H

#ifdef __GNUG__
#pragma interface "apt-pkg/algorithms.h"
#endif 

#include <apt-pkg/packagemanager.h>
#include <apt-pkg/depcache.h>

#include <iostream>

using std::ostream;

namespace ept {
namespace t {
namespace cache {
namespace apt {

template< typename pkgDepCache >
class Resolver
{
    struct ScoreOrder {
        Resolver *res;
        bool operator()( pkgCache::Package const *A, pkgCache::Package const *B ) {
            if (res->Scores[(A)->ID] < res->Scores[(B)->ID])
                return true;
            return false;
        }
    };

    ScoreOrder scoreOrder() {
        ScoreOrder o;
        o.res = this;
        return o;
    }

   pkgDepCache &Cache;
   typedef pkgCache::PkgIterator PkgIterator;
   typedef pkgCache::VerIterator VerIterator;
   typedef pkgCache::DepIterator DepIterator;
   typedef pkgCache::PrvIterator PrvIterator;
   typedef pkgCache::Version Version;
   typedef pkgCache::Package Package;
   
   enum Flags {Protected = (1 << 0), PreInstalled = (1 << 1),
               Upgradable = (1 << 2), ReInstateTried = (1 << 3),
               ToRemove = (1 << 4)};
   signed short *Scores;
   unsigned char *Flags;
   bool Debug;
   
   struct PackageKill
   {
      PkgIterator Pkg;
      DepIterator Dep;
   };

   void MakeScores();
   bool DoUpgrade(pkgCache::PkgIterator Pkg);
   
   public:
   
   inline void Protect(pkgCache::PkgIterator Pkg) {Flags[Pkg->ID] |= Protected;};
   inline void Remove(pkgCache::PkgIterator Pkg) {Flags[Pkg->ID] |= ToRemove;};
   inline void Clear(pkgCache::PkgIterator Pkg) {Flags[Pkg->ID] &= ~(Protected | ToRemove);};
   
   // Try to intelligently resolve problems by installing and removing packages   
   bool Resolve(bool BrokenFix = false);
   
   // Try to resolve problems only by using keep
   bool ResolveByKeep();

   // Install all protected packages   
   void InstallProtect();   
   
   Resolver(pkgDepCache *Cache);
   ~Resolver();
};

template< typename pkgDepCache >
bool pkgDistUpgrade(pkgDepCache &Cache);
template< typename pkgDepCache >
bool pkgApplyStatus(pkgDepCache &Cache);
template< typename pkgDepCache >
bool pkgFixBroken(pkgDepCache &Cache);
template< typename pkgDepCache >
bool pkgAllUpgrade(pkgDepCache &Cache);
template< typename pkgDepCache >
bool pkgMinimizeUpgrade(pkgDepCache &Cache);

}
}
}
}
		     
#endif
