/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__STATE_HPP)
#include <State.hpp>
#endif

#if   !defined(__CONTEXT_HPP)
#include <Context.hpp>
#endif

namespace corelinux
{
   //
   // Default constructor
   //

   State::State( void )
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   State::State( StateCref ) throw ( Assertion )
   {
      NEVER_GET_HERE;
   }

   //
   // Destructor
   //

   State::~State( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   StateRef State::operator=( StateCref ) throw ( Assertion )
   {
      NEVER_GET_HERE;
      return (*this);
   }

   //
   // Equality operator
   //

   bool  State::operator==( StateCref aState ) const
   {
      return ( this == &aState );
   }

   // Sets the state in the context

   void  State::setCurrentState( ContextPtr aContext , StatePtr aState )  
      throw ( NullPointerException )
   {
      if( aContext != NULLPTR )
      {
         aContext->changeState(aState);
      }
      else
      {
         throw NullPointerException( LOCATION );
      }
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/17 03:44:10 $
   $Locker:  $
*/



