#!/bin/sh

PERL=$(which perl)
MAKE=$(which make)
PERL5LIB="$DESTDIR/usr/share/perl5/"

echo "=========================================================================="
echo "Make $1"
echo "PERL5LIB = $PERL5LIB"
echo "DESTDIR = $DESTDIR"
echo "=========================================================================="

#--- unpacking tar.gz in proper folders
if [ "$1" = "unpack" ]; then
    test -d build-area || mkdir build-area
    
    cd tarballs
    for dir in *
    do
    	if [ -d $dir ]; then
    		cd $dir
			for file in *.tar.gz
			do 
				test -d ../../build-area/$dir || mkdir ../../build-area/$dir
				tar -C ../../build-area/$dir -xzf $file
			done
			cd ..
		fi
    done
    cd ..

    # special hack for broken CSRF
    # See #593102
    perl debian/fixcsrf.pl
fi

if [ "$1" = "build" ]; then

	cd build-area
	for dir in *
	do
		if [ -d $dir ]; then
    		cd $dir
			for module in *
			do 
				cd $module
        		if [ -r Build.PL ];
		        then
					PERL5LIB=$PERL5LIB $PERL Build.PL installdirs=vendor
					PERL5LIB=$PERL5LIB $PERL Build
					PERL5LIB=$PERL5LIB TEST_POD=1 $PERL Build test
					PERL5LIB=$PERL5LIB $PERL Build install destdir=$DESTDIR
	        	else
					PERL5LIB=$PERL5LIB $PERL Makefile.PL INSTALLDIRS=vendor
					PERL5LIB=$PERL5LIB $MAKE
					PERL5LIB=$PERL5LIB TEST_POD=1 $MAKE test
					$MAKE install DESTDIR=$DESTDIR
	    	    fi
				cd ..
			done
			cd ..
		fi
	done
cd ..
fi
