/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <endian.h>
#include "libcdg123.h"

int cdgLoadColorTable(struct cdgStream *stream, struct cdgColorTabStruct *data, int page) {

	int i ;
	short colorvalue ;

	for(i=0+page ; i<8+page ; i++) {
		colorvalue = data->colorSpec[i-page] ;

#if __BYTE_ORDER == __LITTLE_ENDIAN
		colorvalue = (colorvalue >> 8) | (colorvalue << 8) ;
#endif
		stream->colorTable[i][2] = (colorvalue & 0x0F) * 255 / 15 ;
		stream->colorTable[i][1] = (((colorvalue >> 4) & 0x0B) | ((colorvalue >> 6) & 0x0C)) * 255 / 15 ;
		stream->colorTable[i][0] = ((colorvalue >> 10) & 0x0F) * 255 / 15 ;
	}

	return 0 ;
}
