# Manual.pm 
# Copyright (c) 2006 Jonathan Rockway <jrockway@cpan.org>

package Catalyst::Manual;

use strict;
use warnings;

our $VERSION = '5.9004';

=head1 NAME

Catalyst::Manual - The Catalyst developer's manual


=head1 SYNOPSIS

    perldoc Catalyst::Manual::Intro
    perldoc Catalyst::Manual::Tutorial


=head1 SEE ALSO

Install L<Task::Catalyst::Tutorial|Task::Catalyst::Tutorial> to
install all the dependencies you need to follow along with the
Tutorial.  You can also refer to 
L<Catalyst::Manual::Tutorial::Intro|Catalyst::Manual::Tutorial::01_Intro>
for more information on installation options.

Some "Getting Started" Links:

=over 4

=item *

L<Catalyst::Manual::About|Catalyst::Manual::About>

=item *

L<Catalyst::Manual::Intro>

=item *

L<Catalyst::Manual::Tutorial>

=item *

L<Catalyst::Manual::Actions>

=item *

L<Catalyst::Manual::Cookbook>

=item *

L<Catalyst::Manual::DevelopmentProcess>

=item *

L<Catalyst::Manual::ExtendingCatalyst>

=item *

L<Catalyst::Manual::Internals>

=item *

L<Catalyst::Manual::Plugins|Catalyst::Manual::Plugins>

=back

=head2 Books

For additional information on Catalyst, there are currently two books available:

=over 4

=item *

The Definitive Guide to Catalyst: Writing Extendable, Scalable and 
Maintainable PerlBased Web Applications

By: Kieren Diment, Matt Trout 
Available July 12, 2009
ISBN 10: 1-4302-2365-0
ISBN 13: 978-1-4302-2365-8
http://www.apress.com/book/view/9781430223658

=item *

Accelerating Perl Web Application Development

By: Jonathan Rockway
Published December, 2007
ISBN 10: 1847190952
ISBN 13: 978-1-847190-95-6
http://www.packtpub.com/catalyst-perl-web-application/book

=back

=head1 AUTHORS

Catalyst Contributors, see Catalyst.pm

=head1 COPYRIGHT

This library is free software. You can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
