/* 
**  directives.c
** $Id: directives.c,v 1.23 2002/05/20 00:45:56 brian Exp $
*/ 

#include "mod_mp3.h"

// extern static const mp3_dispatch *mp3_dispatches;

MP3_EXPORT(const char *) add_mp3_accept(cmd_parms *cmd, void *mconfig, char *value) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	if (!cfg->accept) {
		cfg->accept = ap_make_array (cmd->pool, 1, sizeof (char *));
	}

	*(char **) ap_push_array (cfg->accept) = ap_pstrdup (cmd->pool, value);

	return NULL;
}

MP3_EXPORT(const char *) add_mp3_deny(cmd_parms *cmd, void *mconfig, char *value) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	if (!cfg->deny) {
		cfg->deny = ap_make_array (cmd->pool, 1, sizeof (char *));
	}

	*(char **) ap_push_array (cfg->deny) = ap_pstrdup (cmd->pool, value);

	return NULL;
}

MP3_EXPORT(const char *) set_limit_connections(cmd_parms *cmd, void *mconfig, char *value) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	int limit = 0;
	limit = atoi(value);
	cfg->connection_limit = (limit > 0) ? limit : 0;

	return NULL;
}

MP3_EXPORT(const char *) set_limit_bytespertrack(cmd_parms *cmd, void *mconfig, char *value) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	int limit = 0;
	limit = atoi(value);
	cfg->max_bytes = (limit > 0) ? limit : 0;

	return NULL;
}

MP3_EXPORT(const char *) add_default_op(cmd_parms *cmd, void *mconfig, char *param, char *type) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	if (type && (cfg->default_handlers == NULL))
		cfg->default_handlers = ap_make_table(cmd->pool, 1);

	if (type)
		ap_table_set(cfg->default_handlers, param, type);

	if (!type)
		cfg->default_op = ap_pstrdup(cmd->pool, param);

	return NULL;
}

MP3_EXPORT(const char *) add_log(cmd_parms *cmd, void *mconfig, char *filename) {
	mp3_conf *cfg = (mp3_conf *) mconfig;

	if (!(cfg->log = (int)ap_popenf(cmd->pool, filename, (O_WRONLY | O_APPEND | O_CREAT),(S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)))) {
		ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
			"Can not open mp3 log file: %s(%s)", filename, strerror(errno));
		exit(1);
	}
	cfg->log_filename = ap_pstrdup(cmd->pool, filename);

	return NULL;
}

MP3_EXPORT(const char *) add_mp3(cmd_parms *cmd, void *mconfig, char *param) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	struct stat sbuf;

	/* Silent error, bad thing */
	if (stat(param, &sbuf))
		return NULL;


	if (S_ISDIR(sbuf.st_mode)) {
	/*
		if (cfg->load_directories == NULL)
			cfg->load_directories = ap_make_array (cmd->pool, 5, sizeof (char *));
		*(char **) ap_push_array (cfg->load_directories) = ap_pstrdup (cmd->pool, param);
		*/

		if (load_directory(cmd->pool, cfg, param) != OK) {
			ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
				"Could not load the directory: %s(%s)", param, strerror(errno));
		}
	} else {
	/*
		if (cfg->load_files == NULL)
			cfg->load_files = ap_make_array (cmd->pool, 5, sizeof (char *));
		*(char **) ap_push_array (cfg->load_files) = ap_pstrdup (cmd->pool, param);
		*/

		if (load_file(cmd->pool, cfg, param, param, cfg->cache_enabled) != OK) {
			ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
				"Could not load the file: %s(%s)", param, strerror(errno));
		}
	}


	return NULL;
}

#ifdef STREAM_SUPPORT
MP3_EXPORT(const char *) add_stream(cmd_parms *cmd, void *mconfig, char *param) {
	mp3_conf *cfg = (mp3_conf *) mconfig;
	FILE *file;
	const char *filename = NULL;

	if (cfg->stream != NULL) {
		ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
			"Can not load stream twice: %s(%s)", param, strerror(errno));
		exit(1);
	}
	cfg->stream = ap_pstrdup(cmd->pool, param);
	filename = ap_psprintf(cmd->temp_pool, "/tmp/mod_mp3.%s", param);

	if (!(file = ap_pfopen (cmd->temp_pool, filename, "w"))) {
		ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
			"Can not open shard file: %s(%s)", filename, strerror(errno));
		exit(1);
	}
	fprintf(file, "%d", cfg->shmid); 
	ap_register_cleanup(cmd->pool, (char *)file, cleanup_file, ap_null_cleanup);

	return NULL;
}
#endif

MP3_EXPORT(const char *) add_mp3_playlist(cmd_parms *cmd, void *mconfig, char *param) {
	mp3_conf *cfg = (mp3_conf *) mconfig;

	if (cfg->playlist == NULL)
		cfg->playlist = ap_pstrdup(cmd->pool, param);

	if (cfg->dispatch->set) {
#ifdef DEBUG
		printf("Setting using %s\n", cfg->dispatch->name);
#endif 
		if (load_playlist(cmd->pool, cfg, param, cfg->cache_enabled) != OK) {
			ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
				"Could not load the playlist: %s(%s)", param, strerror(errno));
		}
	}

	return NULL;
}

MP3_EXPORT(const char *) enable_cache(cmd_parms *cmd, void *mconfig, int flag) {
	mp3_conf *cfg = (mp3_conf *) mconfig;

	cfg->cache_enabled = 1;

	return NULL;
}
