/* 
**  mod_mp3.h
*/ 

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "http_log.h"
#include "fnmatch.h"
#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include "directives.h"
#include "version.h"

#define CORE_PRIVATE
#define DEFAULT_LIMIT  0 	/* This is set to zero by default so searches return all posssible
													* matches (and playlists return all possible records.
													*/

#define WATCHPOINT printf("WATCHPOINT %s %d\n", __FILE__, __LINE__);

#define MP3_EXPORT(type) type

module MODULE_VAR_EXPORT mp3_module;
#define DEFAULT_CAST_NAME "Apache/mod_mp3 cast"
#define DEFAULT_GENRE_NAME "misc"

#define DEFAULT_FILES 100  /* If you are loading a log of files, increase this number to make Apache start faster */

/* Atrributes */
#define MP3_RESET 1
#define MP3_RELOAD 2


#define MP3_CRLF "\015\012"

#define BITRATE 128
#define NUM_GENRE 148
#define CHILDREN 255

#define TIME_FORMAT "%a %b %d %H:%M:%S %Y"
/* This is the XML header file */
#define RSS09HEADER "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\"\n\"http://www.scripting.com/dtd/rss-0_91.dtd\">\n\n<rss version=\"0.91\">\n\n"

#define RSS09FOOTER "\n</rss>"

#define RSS10HEADER "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<rdf:RDF\n\t\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n\t\txmlns=\"http://purl.org/rss/1.0/\"\n\t\txmlns:audio=\"http://media.tangent.org/rss/1.0/\"\n\t\txmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n\t\txmlns:syn=\"http://purl.org/rss/1.0/modules/syndication/\"\n\t>\n"


#define MBMHEADER "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<rdf:RDF\n\t\txmlns:rdf=\"http://www.w3.org/TR/1999/02/22-rdf-syntax-ns#\"\n\t\txmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n\t\txmlns:mq=\"http://musicbrainz.org/mm/mq-1.0#\"\n\t\txmlns:mm=\"http://musicbrainz.org/mm/mm-2.0#\">\n\n"

#define RDFFOOTER "</rdf:RDF>"

typedef struct {
	time_t time;											/* Time of last regeneration */
	int servers[CHILDREN];		        /* Servers we are tracking for live connections. Each one represents a childs_num */
} scoreboard;												/* This is shared memory stuff for each instance */

typedef struct {
	int shmid;					/* SHM id to the scoreboard  */
	time_t generation;	/* Last time the files were reloaded  */
	scoreboard *board;  /* Scoreboard for the server */
} mp3_server_conf;		/* This the info that is stored on each section (directory, location, virtualhost...) */

typedef struct {
	off_t size;							/* Size of a file */
	char *name;				/* Name of the file */
	char *filename;		/* Filename name */
	char *signature;	/* MD5 signature of the filename */
	char *artist;			/* Artist of the song */
	char *album;			/* Album the song came from */
	char *comment;		/* Comment attached to the song */
	char *track;  		/* Track on the album */
	char *year;   		/* Year of release */
	char *genre;   		/* Music Genre */
	time_t time;						/* Time that the file was last modified */
	void *data;							/* The file (if cache has been enabled */
} mp3_data;								/* This is where we store file info */

typedef struct {
	table *args; 					/* Parsed query args */
	const char *op;				/* Current operation */
	const char *command;	/* Current command */
	const char *order;		/* Current order to play in */
	const char *pattern;	/* Any pattern that we may be search on */
	const char *id;				/* Any pattern that we may be search on */
	int random;						/* Should the music be played in a random order */
	int limit;						/* Limit for this connection */
	const char *url;			/* URL for the stream */
	int shout; 						/* Stream via Shout protocol */
	int udp; 							/* Send udp stream */
	array_header *files;	/* Songs to play */
	int type;							/* This means:
													-1 means HTTP headers
													0 means shout headers
													1 use ICY headers
													2 means vorbis
												*/
	const char *token;		/* Token that was passed in by the URL */
} request_data;					/* This is created for every connection */

typedef struct {
	const char *name;
	void *(*create)(pool *p);
	int (*child)(void *, pool *p);
	int (*request)(void *, pool *);
	mp3_data *(*get)(void *, pool *, char *);
	int (*set)(void *, pool *, mp3_data *);
	mp3_data * (*each)(void *, pool *, array_header *, const char *);
	mp3_data * (*random)(void *, pool *);
	array_header * (*search)(void *info, pool *, const char *, int);
} mp3_dispatch;

typedef struct {
	int enabled;  											/* If the mp3 engine is enabled */
	int random_enabled;									/* If the playlist should be random */
	int cache_enabled;									/* If cache is enabled */
	int reload_request;									/* This causes reloads to occr every request */
	int connection_limit;               /* Limitted connections to play */
	int limit;                          /* Limit for searches and lists */
	int loop;               						/* If connections should loop (AKA never end) */
	int log;														/* File descriptor for the log file */
	const char *log_filename;						/* Filename for log file */
	const char *stream;									/* If this connection is a stream, and its name */
	const char *encoder;								/* Application to use to re-encode mp3 */
	const char *cast_name;							/* Name of the cast */
	const char *genre_name;							/* Genre name for the music */
	const char *content_type;						/* Mime Type */
	const char *default_op;							/* Default operation */
	const char *playlist;							/* The last playlist to be loaded */
	array_header *accept;								/* Files to accept */
	array_header *deny;									/* Files to deny */
	array_header *files;								/* See mp3 data, this is the list */
	table *default_handlers;						/* Default operation */
	mp3_dispatch *dispatch;							/* What we dispatch on */
	void *context;				              /* Context data for current dispatch */
} mp3_conf;														/* This the info that is stored on each section (directory, location, virtualhost...) */

#include "proto.h"
