-- File Name: motif_graphics.ads    Unit Type:  Package spec

-- Unit Name: Motif_Graphics

-- By  Jim Bean;  Original version 24-Oct-96

-- Abstract: Low Level Display CRT data for HUD project

-- Environment:  Embedded Intel using Linux kernel.
--               GNU Linux Ada

with X_Toolkit;
with Common;

package Motif_Graphics is

   Wide: constant := 320;
   High: constant := 200;

   type A_X_Point is range 0 .. Wide - 1;
   type A_Y_Point is range 0 .. High - 1;

   type A_Point is record
      X: A_X_Point;
      Y: A_Y_Point;
   end record;

-----------------------------------------------------------------------

   procedure Make_CRT;

-----------------------------------------------------------------------

   procedure Show_CRT;

-----------------------------------------------------------------------

   procedure Put_Pixel (X_Pos: in Integer;
                        Y_Pos: in Integer;
                        Color: in Common.Color_Indices);

----------------------------------------------------------

   procedure Draw_Line (A: in A_Point;
                        B: in A_Point;
                        C: in Common.Color_Indices);

-----------------------------------------------------------------------

   procedure Draw_Box;

end Motif_Graphics;
