/* Generated By:JJTree: Do not edit this line. D:/jython/CVS.parser/org/python/parser\JJTPythonGrammarState.java */

// Modified by hand. The two closeNodeScope method have been rewritten
// completely and is used when building the AST tree bottom-up.

package org.python.parser;

class JJTPythonGrammarState {
    private java.util.Stack nodes;
    private IntStack marks;
    private IntStack lines;
    private IntStack columns;

    private int sp; // number of nodes on stack
    private int mk; // current mark
    private boolean node_created;

    private TreeBuilder builder;

    JJTPythonGrammarState() {
        nodes = new java.util.Stack();
        marks = new IntStack();
        lines = new IntStack();
        columns = new IntStack();
        sp = 0;
        mk = 0;
        builder = new TreeBuilder(this);
    }

    /* Determines whether the current node was actually closed and
       pushed.  This should only be called in the final user action of a
       node scope.  */
    boolean nodeCreated() {
        return node_created;
    }

    /* Call this to reinitialize the node stack.  It is called
       automatically by the parser's ReInit() method. */
    void reset() {
        nodes.removeAllElements();
        marks.removeAllElements();
        sp = 0;
        mk = 0;
    }

    /* Returns the root node of the AST.  It only makes sense to call
       this after a successful parse. */
    Node rootNode() {
        return (Node)nodes.elementAt(0);
    }

    /* Pushes a node on to the stack. */
    void pushNode(Node n) {
        nodes.push(n);
        ++sp;
    }

    /* Returns the node on the top of the stack, and remove it from the
       stack.  */
    Node popNode() {
        if (--sp < mk) {
            mk = marks.pop();
        }
        return (Node)nodes.pop();
    }

    /* Returns the node currently on the top of the stack. */
    Node peekNode() {
        return (Node)nodes.peek();
    }

    /* Returns the number of children on the stack in the current node
       scope. */
    int nodeArity() {
        return sp - mk;
    }

    void pushNodePos(int line, int col) {
        lines.push(line);
        columns.push(col);
    }

    void setNodePos() {
        SimpleNode n = (SimpleNode) peekNode();
        n.beginLine = lines.pop();
        n.beginColumn = columns.pop();
    }


    void clearNodeScope(Node n) {
        while (sp > mk) {
            popNode();
        }
        mk = marks.pop();
    }


    void openNodeScope(Node n) {
        marks.push(mk);
        mk = sp;
    }


    /* A definite node is constructed from a specified number of
       children.  That number of nodes are popped from the stack and
       made the children of the definite node.  Then the definite node
       is pushed on to the stack. */
    void closeNodeScope(Node n, int num) throws ParseException {
        SimpleNode sn = (SimpleNode) n;
        mk = marks.pop();
        SimpleNode newNode = null;
        try {
            newNode = builder.closeNode(sn, num);
        } catch (ParseException exc) {
            throw exc;
        } catch (Exception exc) {
            exc.printStackTrace();
            throw new ParseException("Internal error:" + exc);
        }
        if (newNode == null) {
            throw new ParseException("Internal AST builder error");
        }
        pushNode(newNode);
        node_created = true;
    }


    /* A conditional node is constructed if its condition is true.  All
       the nodes that have been pushed since the node was opened are
       made children of the the conditional node, which is then pushed
       on to the stack.  If the condition is false the node is not
       constructed and they are left on the stack. */
    void closeNodeScope(Node n, boolean condition) throws ParseException {
        SimpleNode sn = (SimpleNode) n;
        if (condition) {
            SimpleNode newNode = null;
            try {
                newNode = builder.closeNode(sn, nodeArity());
            } catch (ParseException exc) {
                throw exc;
            } catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Internal error:" + exc);
            }
            if (newNode == null) {
                throw new ParseException("Internal AST builder error");
            }
            mk = marks.pop();
            pushNode(newNode);
            node_created = true;
        } else {
            mk = marks.pop();
            node_created = false;
        }
    }

    public void dumpTop(String reason) {
        int a = nodeArity();
        System.out.println("dumpTop:" + reason);
        System.out.println("arity:" + a);
        for (int i = 0; i < a; i++) {
            Node n = (Node) nodes.elementAt(nodes.size() - i-1);
            System.out.println("   " + n);
        }
    }

    public Node openNode(int id) {
        return builder.openNode(id);
    }

    public void dump(String reason) {
        int a = nodeArity();
        System.out.println("dump:" + reason);
        System.out.println("  mk:" + mk + "  sp:" + sp);
        for (int i = 0; i < nodes.size(); i++) {
            Node n = (Node) nodes.elementAt(i);
            System.out.println("   " + n);
        }
        for (int i = 0; i < marks.size(); i++) {
            System.out.println("   " + marks.elementAt(i));
        }
    }
}


class IntStack {
    int[] stack;
    int sp = 0;

    public IntStack() {
        stack = new int[50];
    }


    public void removeAllElements() {
        sp = 0;
    }

    public int size() {
        return sp;
    }

    public int elementAt(int idx) {
        return stack[idx];
    }

    public void push(int val) {
        if (sp >= stack.length) {
            int[] newstack = new int[sp*2];
            System.arraycopy(stack, 0, newstack, 0, sp);
            stack = newstack;
        }
        stack[sp++] = val;
    }

    public int pop() {
        return stack[--sp];
    }
}
