/*
 * File    : MediaBagSelector.java
 * Created : 22-mar-2004 15:36
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2018 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.bags;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.17
 */
public class MediaBagSelector extends javax.swing.JPanel {

  // Modified: 14-09-2010 - suggested by Camille Manoury
  // The cell properties editor now allows to directly import images
  // and other files into the media library

  Options options;

  /** Creates new form MediaBagSelector */
  public MediaBagSelector(Options options) {
    this.options = options;
    initComponents();
    mediaList.addListSelectionListener(selListener);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated
  // Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    listPanel = new javax.swing.JPanel();
    scrollList = new javax.swing.JScrollPane();
    mediaList = new javax.swing.JList<>();
    addMediaBtn = new javax.swing.JButton();
    elementPanel = new javax.swing.JPanel();
    previewLabel = new javax.swing.JLabel();
    nameLb = new javax.swing.JLabel();
    nameText = new javax.swing.JLabel();
    fileLb = new javax.swing.JLabel();
    fileText = new javax.swing.JLabel();
    javax.swing.JLabel typeLb = new javax.swing.JLabel();
    typeTx = new javax.swing.JLabel();
    javax.swing.JLabel sizeLb = new javax.swing.JLabel();
    sizeTx = new javax.swing.JLabel();

    setLayout(new java.awt.GridBagLayout());

    listPanel.setLayout(new java.awt.BorderLayout());

    scrollList.setMinimumSize(new java.awt.Dimension(200, 400));
    scrollList.setPreferredSize(new java.awt.Dimension(200, 400));
    scrollList.setViewportView(mediaList);

    listPanel.add(scrollList, java.awt.BorderLayout.CENTER);

    addMediaBtn.setIcon(ResourceManager.getImageIcon("icons/media_new.gif"));
    addMediaBtn.setText(options.getMsg("edit_media_new"));
    addMediaBtn.setToolTipText(options.getMsg("edit_media_new_tooltip"));
    addMediaBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        addMediaBtnActionPerformed(evt);
      }
    });
    listPanel.add(addMediaBtn, java.awt.BorderLayout.PAGE_END);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
    add(listPanel, gridBagConstraints);

    elementPanel.setLayout(new java.awt.GridBagLayout());

    previewLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    previewLabel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
    previewLabel.setMinimumSize(new java.awt.Dimension(100, 100));
    previewLabel.setPreferredSize(new java.awt.Dimension(100, 100));
    previewLabel.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(java.awt.event.MouseEvent evt) {
        previewLabelMousePressed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weighty = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 7, 3);
    elementPanel.add(previewLabel, gridBagConstraints);

    nameLb.setText(options.getMsg("edit_name"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(nameLb, gridBagConstraints);

    nameText.setMinimumSize(new java.awt.Dimension(200, 16));
    nameText.setPreferredSize(new java.awt.Dimension(200, 17));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(nameText, gridBagConstraints);

    fileLb.setText(options.getMsg("edit_file"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(fileLb, gridBagConstraints);

    fileText.setMinimumSize(new java.awt.Dimension(200, 16));
    fileText.setPreferredSize(new java.awt.Dimension(200, 17));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(fileText, gridBagConstraints);

    typeLb.setText(options.getMsg("edit_media_type"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(typeLb, gridBagConstraints);

    typeTx.setText("-");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(typeTx, gridBagConstraints);

    sizeLb.setText(options.getMsg("edit_media_size"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(sizeLb, gridBagConstraints);

    sizeTx.setText("0 Kb");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    elementPanel.add(sizeTx, gridBagConstraints);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.weighty = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
    add(elementPanel, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  private void previewLabelMousePressed(java.awt.event.MouseEvent evt) { // GEN-FIRST:event_previewLabelMousePressed

    if (current != null)
      current.testMedia(this, options);
  } // GEN-LAST:event_previewLabelMousePressed

  private void addMediaBtnActionPerformed(java.awt.event.ActionEvent evt) { // GEN-FIRST:event_addMediaBtnActionPerformed

    if (mbe != null) {
      MediaBagElementEditor[] mbele = mbe.createNewMediaBagElements(options, this, filters);
      if (mbele != null && mbele.length > 0) {
        mediaList.setListData(mbe.getChildrenList(filters).toArray());
        setSelected(mbele[0]);
        mediaList.setSelectedValue(mbele[0], true);
      }
    }
  } // GEN-LAST:event_addMediaBtnActionPerformed

  MediaBagEditor mbe;
  MediaBagElementEditor current;
  int filters;

  protected void setMediaBagEditor(MediaBagEditor mbe, int filters) {
    this.mbe = mbe;
    this.filters = filters;
    setSelected(null);
    mediaList.setListData(mbe == null ? new String[0] : mbe.getChildrenList(filters).toArray());
  }

  protected void setSelected(MediaBagElementEditor mbed) {
    current = mbed;
    nameText.setText(current == null ? "" : current.getName());

    fileText.setText(current == null ? "" : current.getMediaBagElement().getFileName());

    typeTx.setText(mbed == null ? "" : mbed.getDescription(options));

    long fSize = -1;
    if (mbed != null)
      fSize = mbed.getFileSize();
    sizeTx.setText(fSize < 0 ? "" : options.getMessages().fileSize(fSize));

    previewLabel.setIcon(mbed == null ? null
        : mbed.getMediaBagElement().getThumbNail(90, 90, mbed.getMediaBag().getProject().getFileSystem()));
    if (mbed != null)
      mbed.getMediaBagElement().clearData();
  }

  protected MediaBagElementEditor getSelected() {
    return current;
  }

  private ListSelectionListener selListener = new ListSelectionListener() {
    public void valueChanged(ListSelectionEvent evt) {
      if (evt != null && !evt.getValueIsAdjusting()) {
        setSelected((MediaBagElementEditor) mediaList.getSelectedValue());
      }
    }
  };

  private static Map<Options, MediaBagSelector> dlgPanels = new HashMap<Options, MediaBagSelector>(1);

  public static String getMediaName(String initialValue, Options options, Component parent, MediaBagEditor mbe,
      int filters) {
    String result = null;
    Messages msg = options.getMessages();
    MediaBagSelector mbs = dlgPanels.get(options);
    if (mbs == null) {
      mbs = new MediaBagSelector(options);
      dlgPanels.put(options, mbs);
    }
    mbs.setMediaBagEditor(mbe, filters);
    MediaBagElementEditor mbed = initialValue == null ? null : (MediaBagElementEditor) mbe.getChildByName(initialValue);
    mbs.setSelected(mbed);
    mbs.mediaList.setSelectedValue(mbed, true);

    boolean b = msg.showInputDlg(parent, mbs, "edit_media_dlg_title");
    if (b) {
      MediaBagElementEditor mbele = mbs.getSelected();
      if (mbele != null)
        result = mbele.getName();
    }
    mbs.setMediaBagEditor(null, -1);
    return result;
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton addMediaBtn;
  private javax.swing.JPanel elementPanel;
  private javax.swing.JLabel fileLb;
  private javax.swing.JLabel fileText;
  private javax.swing.JPanel listPanel;
  private javax.swing.JList<Object> mediaList;
  private javax.swing.JLabel nameLb;
  private javax.swing.JLabel nameText;
  private javax.swing.JLabel previewLabel;
  private javax.swing.JScrollPane scrollList;
  private javax.swing.JLabel sizeTx;
  private javax.swing.JLabel typeTx;
  // End of variables declaration//GEN-END:variables

}
