/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1type (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gtk_container_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_border_width
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1border_1width (JNIEnv 
        *env, jclass cls, jint container, jint borderWidth) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        gint32 borderWidth_g = (gint32) borderWidth;
        {
            gtk_container_set_border_width (container_g, borderWidth_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_border_width
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1border_1width (JNIEnv 
        *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            jint result_j = (jint) (gtk_container_get_border_width (container_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_add
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1add (JNIEnv *env, jclass cls, 
        jint container, jint widget) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_container_add (container_g, widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_remove
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1remove (JNIEnv *env, jclass 
        cls, jint container, jint widget) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_container_remove (container_g, widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_resize_mode
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1resize_1mode (JNIEnv 
        *env, jclass cls, jint container, jint mode) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkResizeMode mode_g = (GtkResizeMode) mode;
        {
            gtk_container_set_resize_mode (container_g, mode_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_resize_mode
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1resize_1mode (JNIEnv 
        *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            jint result_j = (jint) (gtk_container_get_resize_mode (container_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_check_resize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1check_1resize (JNIEnv *env, 
        jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            gtk_container_check_resize (container_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_children
     * Signature: (I)[I
     */
    JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1children (JNIEnv *env, 
        jclass cls, jint container) 
    {
		return getList(env,gtk_container_get_children((GtkContainer*)container));
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_propagate_expose
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1propagate_1expose (JNIEnv 
        *env, jclass cls, jint container, jint child, jint event) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkWidget *child_g = (GtkWidget *)child;
        GdkEventExpose *event_g = (GdkEventExpose *)event;
        {
            gtk_container_propagate_expose (container_g, child_g, event_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_focus_chain
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1focus_1chain (JNIEnv 
        *env, jclass cls, jint container, jint focusableWidgets) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GList *focusableWidgets_g = (GList *)focusableWidgets;
        {
            gtk_container_set_focus_chain (container_g, focusableWidgets_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_focus_chain
     * Signature: (I[Lint ;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1focus_1chain (JNIEnv 
        *env, jclass cls, jint container, jintArray focusableWidgets) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        gint *focusableWidgets_g_g = (gint *) (*env)->GetIntArrayElements (env, focusableWidgets, 
            NULL);
        GList **focusableWidgets_g = (GList **)focusableWidgets_g_g;
        {
            jboolean result_j = (jboolean) (gtk_container_get_focus_chain (container_g, 
                    focusableWidgets_g));
            (*env)->ReleaseIntArrayElements (env, focusableWidgets, focusableWidgets_g_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_unset_focus_chain
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1unset_1focus_1chain (JNIEnv 
        *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            gtk_container_unset_focus_chain (container_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_reallocate_redraws
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1reallocate_1redraws (
        JNIEnv *env, jclass cls, jint container, jboolean needsRedraws) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        gboolean needsRedraws_g = (gboolean) needsRedraws;
        {
            gtk_container_set_reallocate_redraws (container_g, needsRedraws_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_focus_child
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1focus_1child (JNIEnv 
        *env, jclass cls, jint container, jint child) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkWidget *child_g = (GtkWidget *)child;
        {
            gtk_container_set_focus_child (container_g, child_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_focus_vadjustment
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1focus_1vadjustment (
        JNIEnv *env, jclass cls, jint container, jint adjustment) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkAdjustment *adjustment_g = (GtkAdjustment *)adjustment;
        {
            gtk_container_set_focus_vadjustment (container_g, adjustment_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_focus_vadjustment
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1focus_1vadjustment (
        JNIEnv *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            return (jint)gtk_container_get_focus_vadjustment (container_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_set_focus_hadjustment
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1set_1focus_1hadjustment (
        JNIEnv *env, jclass cls, jint container, jint adjustment) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        GtkAdjustment *adjustment_g = (GtkAdjustment *)adjustment;
        {
            gtk_container_set_focus_hadjustment (container_g, adjustment_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_get_focus_hadjustment
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1get_1focus_1hadjustment (
        JNIEnv *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            return (jint)gtk_container_get_focus_hadjustment (container_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_resize_children
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Container_gtk_1container_1resize_1children (JNIEnv 
        *env, jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            gtk_container_resize_children (container_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Container
     * Method:    gtk_container_child_type
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Container_gtk_1container_1child_1type (JNIEnv *env, 
        jclass cls, jint container) 
    {
        GtkContainer *container_g = (GtkContainer *)container;
        {
            return (jint)gtk_container_child_type (container_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
