/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Flags;

/**
 * Controls hiding of various elements of a VFSURI when
 * it is converted to a String.
 */
public class VFSURIHideOptions extends Flags {
    static final private int _NONE = 0;

    static final public VFSURIHideOptions NONE = new VFSURIHideOptions(_NONE);

    static final private int _USER_NAME = 1 << 0;

    static final public VFSURIHideOptions USER_NAME = new VFSURIHideOptions(_USER_NAME);

    static final private int _PASSWORD = 1 << 1;

    static final public VFSURIHideOptions PASSWORD = new VFSURIHideOptions(_PASSWORD);

    static final private int _HOST_NAME = 1 << 2;

    static final public VFSURIHideOptions HOST_NAME = new VFSURIHideOptions(_HOST_NAME);

    static final private int _HOST_PORT = 1 << 3;

    static final public VFSURIHideOptions HOST_PORT = new VFSURIHideOptions(_HOST_PORT);

    static final private int _TOPLEVEL_METHOD = 1 << 4;

    static final public VFSURIHideOptions TOPLEVEL_METHOD = new VFSURIHideOptions(_TOPLEVEL_METHOD);

    static final private int _FRAGMENT_IDENTIFIER = 1 << 8;

    static final public VFSURIHideOptions FRAGMENT_IDENTIFIER = new VFSURIHideOptions(_FRAGMENT_IDENTIFIER);


    
    static final private VFSURIHideOptions[] theInterned = new VFSURIHideOptions[] { NONE,
    		PASSWORD, HOST_NAME, HOST_PORT, TOPLEVEL_METHOD, FRAGMENT_IDENTIFIER };

    static private java.util.Hashtable theInternedExtras;

    static final private VFSURIHideOptions theSacrificialOne = new VFSURIHideOptions(0);

    static public VFSURIHideOptions intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSURIHideOptions already = (VFSURIHideOptions) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSURIHideOptions(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSURIHideOptions(int value) {
        value_ = value;
    }

    public VFSURIHideOptions or(VFSURIHideOptions other) {
        return intern(value_ | other.value_);
    }

    public VFSURIHideOptions and(VFSURIHideOptions other) {
        return intern(value_ & other.value_);
    }

    public VFSURIHideOptions xor(VFSURIHideOptions other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSURIHideOptions other) {
        return (value_ & other.value_) == other.value_;
    }
}
