use Irssi 20020916.1556 ();
use strict;

use vars qw($VERSION %IRSSI);

$VERSION="0.1.5";
%IRSSI = (
	authors=> 'BC-bd',
	contact=> 'bd@bc-bd.org',
	name=> 'thankop',
	description=> 'Remembers the last person oping you on a channel',
	license=> 'GPL v2',
	url=> 'http://bc-bd.org/software.php3#irssi',
);

#########
# USAGE
###
#
# Type '/thankop' in a channel window to thank the person opping you
#
##########
# OPTIONS
####
#
# /set thankop_command [command]
#		* command  : to be executed. The following $'s are expanded
#		    $N : Nick (some dude)
#		    
#		eg:
#		
#		  /set thankop_command say $N: w00t!
#
#		Would say
#
#		  <nick>: w00t!
#
#		To the channel you got op in, with <nick> beeing the nick who
#		opped you
#
################
###
# Changelog
#
# Version 0.1.5
#  - change back to setting instead of theme item
#
# Version 0.1.4
#  - added theme item to customize the message (idea from mordeth)
#
# Version 0.1.3
#  - removed '/' from the ->command (thx to mordeth)
#  - removed debug messages (where commented out)
#  
# Version 0.1.2
#  - added version dependency, since some 0.8.4 users complained about a not
#      working script
#  
# Version 0.1.1
#  - unsetting of hash values is done with delete not unset.
#
# Version 0.1.0
#  - initial release
#  
###
################

my %modes;
my %op;

sub cmd_thankop {
	my ($data, $server, $witem) = @_;

	if (exists($op{$witem->{name}})) {
		my $cmd = Irssi::settings_get_str('thankop_command');
		my $by = $op{$witem->{name}};
		
		$cmd =~ s/\$N/$by/;

		$witem->command($cmd);
	} else {
		$witem->print("thankop: I don't know who op'ed you in here");
	}
}

sub mode_changed {
	my ($channel, $nick, $by) = @_;

	return if ($channel->{server}->{nick} ne $nick->{nick});
	
	if ($modes{$channel->{name}} == 0 && $channel->{chanop}) {
		$op{$channel->{name}} = $by;
	}

	$modes{$channel->{name}} = $channel->{chanop};
}

sub channel_joined {
	my ($channel) = @_;

	$modes{$channel->{name}} = $channel->{chanop};
}

sub channel_destroyed {
	my ($channel) = @_;

	delete($modes{$channel->{name}});
	delete($op{$channel->{name}});
}

sub init_modes {
	foreach my $channel (Irssi::channels()) {
		if ($channel->{chat_type} eq 'IRC') {
			$modes{$channel->{name}} = $channel->{chanop};
		}
	}
}

init_modes();

Irssi::command_bind('thankop','cmd_thankop');
Irssi::signal_add_last('nick mode changed', 'mode_changed');
Irssi::signal_add_last('channel joined', 'channel_joined');
Irssi::signal_add_last('channel destroyed', 'channel_destroyed');

Irssi::settings_add_str('thankop', 'thankop_command', 'say $N: opthx');
