/***************************************************************************
                          undostack.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef UNDOSTACK_H
#define UNDOSTACK_H

#include <Commands/command.h>
#include <qstack.h>


/**This is the stack that maintains all actions that can be 
undone.
  *@author Jon Anderson
  */

class UndoStack {
public: 
	UndoStack();
	~UndoStack();
	static UndoStack *getInstance();
	void clear();
	void setSize(int i) {size = i;};
	void push(Command *);
	Command * pop();
	bool isEmpty(){return stack->isEmpty();};
  Command* current() {return stack->current();};

private:
	static UndoStack *undo;
	QStack<Command> *stack;
	int size;
};

#endif
