/***************************************************************************
                          objectselector.h  -  description
                             -------------------                                         
    begin                : Thu Jul 26 08:26:09 PDT 2001
                                           
    author               : Kevin T. Seghetti (kts@worldfoundry.org)
    copyright            : (C) 2001 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// kts: I started with the QT listbox example, as I finished I realized I should
// have learned how to use the QT dialog editor instead of laying it out manually
// someday maybe I will come back and update this
// I also would like to make this non-modal so the user can leave it open
// and have it update the list as objects are added & deleted, but I would
// have to learn a lot more to do that

//==============================================================================
                                      
#ifndef OBJECTSELECTOR_H
#define OBJECTSELECTOR_H

//==============================================================================

class QListBox;
class QButtonGroup;

#include <qdialog.h>

//==============================================================================

class ObjectListSelector: public QDialog
{
    Q_OBJECT
public:
    ObjectListSelector();
    ~ObjectListSelector();

private slots:
   void sortOrderCreated();
    void sortAscending();
    void sortDescending();
    void selectNone();
    void selectAll();
    void invertSelection();
    void toggleMultipleColumns();
    void showAll();
    void showVisible();
    void showHidden();
    void ok();
    void hideSelected();
    void unhideSelected();

private:
    void ReloadList(bool getSelection=FALSE);
   void SetVisibility(bool visible);

    QListBox * listBox;
    QButtonGroup * sortButtonGroup;
    QButtonGroup * showButtonGroup;
    bool bMultipleColumns;

    enum  ShowType {
        SHOW_ALL,
        SHOW_HIDDEN,
        SHOW_VISIBLE
    };


    enum  SortType {
        SORT_NONE,
        SORT_ASCENDING,
        SORT_DESCENDING
    };

    ShowType showType;
    SortType sortType;

};

//==============================================================================
#endif
//==============================================================================

