/***************************************************************************
                          objectdb.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 3 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef OBJECTDB_H
#define OBJECTDB_H

#include <Entities/entity.h>


#include <qobject.h>

#include <vector>
#include <algorithm>
#include <map>

/**ObjectDB is the object database. (Surprisingly).  It is maintains all the
  *entities used by the program.  It provides fast access to all the contents,
  *and provides methods for accessing, adding, deleting, and various other
  *operations for the entities.
  *
  *In order to facilitate operations, it actually maintains several separate
  *lists of entities.
  *
  *At some point, this will be replaced with a real scene graph.
  *
  *@author Jon Anderson
  */

class ObjectDB :public QObject{
Q_OBJECT
public:

	typedef map<int, vector<Selectable *> *, less<int> > SelectableMap;
	typedef SelectableMap::value_type SelectablePair;

	/**Construct an empty Object Database */
	ObjectDB();
	~ObjectDB();
	

public:
	/**add an Entity to the Database */
	void add(Selectable *e);
	/**Get an Entity from the Database without removing it. */
	Selectable * get(int id, int type=-1);
	
	/**Get the first instance of the entity of type id */
	Selectable * getFirst(int type);
	
	/**Remove an Entity from the Database. */
	Selectable * remove(int id, int type=-1);
	void remove(Selectable *e);
	
	/**Get a list of the selected ENtities */
	vector<Selectable *> *getSelected();
	/**draw all entities in the DB */
	void draw();
	
	/** Set the specified entity  to be selected */
	Selectable *setSelected(Selectable *e);
	Selectable *removeSelected(Selectable *e);
	Selectable *toggleSelected(Selectable *e);
	
	void setNoneSelected();
	
	vector<Selectable *> *getSelectables(int type=-1);

	static ObjectDB *getInstance();

	vector< Selectable * > * getList();		

private:
	SelectableMap db;
	
	vector<Selectable *> selected;
	vector<Selectable *> dblist;

		
	int size;
	
	static ObjectDB *objectdb;

};

#endif




