/***************************************************************************
                        view3D.h  -  description          
                            -------------------                     
   begin                : Thu Apr 8 1999                    
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : janderson@onelink.com            
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VIEW3D_H
#define VIEW3D_H

#include "glview.h"


/** View3D is a 3D openGL view.
 *  
 *@author Jonathan E. Anderson
 */



class View3D : public GLView
{
      Q_OBJECT
   public:
      View3D( QWidget *parent, const char *name = 0, QGLWidget *sharer = 0 );
      ~View3D();

      void initView();
      void display();
      void setCamera();
      void setProjection();

      void moveCamera( float x, float y );
      void rotateCamera( float x, float y );
      void zoomCamera( float x, float y );
      void panCamera( float x, float y );
      void truckCamera( float x, float y );

      bool updateCamera();
      void drawBackground();
      void drawGrid();

      void setWireframe3D( bool f );


      int getViewType() { return V3D;};

      Vector4 & unProjectPoint( int x, int y );
      void setPlane( Vector4 v ) { m_plane = v; };

   public slots:
      void slotPlaneXY() {setPlane( Vector4( 0, 0, 1, 0 ) );};

      void slotPlaneXZ() {setPlane( Vector4( 0, 1, 0, 0 ) );};

      void slotPlaneYZ() {setPlane( Vector4( 1, 0, 0, 0 ) );};


   private:
      float x_rotate;
      float y_rotate;

      float x_look;
      float y_look;

      Vector4 intersectPoint;

      Grid * m_grid;



};

#endif
































































