/***************************************************************************
                        glview.h  -  description          
                            -------------------                     
   begin                : Thu Apr 8 1999                    
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : janderson@onelink.com            
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef GLVIEW_H
#define GLVIEW_H

//QT includes
#include <qgl.h> 
//Standard includes
#include <iostream.h>
#include "GL/glut.h"
#include <qpainter.h>
#include <qpixmap.h>

#include <qbitmap.h>

#include <qpopupmenu.h>
#include <qprinter.h>
#include <qmainwindow.h>

#include <qcolordialog.h>
#include <qfiledialog.h>

#include <Math/matrix44.h>
#include <Math/vector4.h>
#include <Entities/entity.h>
#include <Entities/vertex.h>
#include <i3ddoc.h>
#include <i3dworkspace.h>

#include <Modifiers/icontrol.h>

#include "glmdiview.h"
#include <Entities/grid.h>

enum CameraMode{PAN, ORBIT, ZOOM, TRUCK, SLIDE, LOCK};


class GLView : public QGLWidget
{

      friend class GLMdiView;

      Q_OBJECT
   public:
      GLView( QWidget *parent, const char *name, QGLWidget *sharer );
      virtual ~GLView();

      virtual void paintGL();


      virtual void display() {};

      void select( int mode );
      void drawAxis();
      virtual void drawGrid();


      void draw2D();
      virtual int getViewType() { return -1;};

      QPixmap getPixmap( );

      void resizeGL( int x, int h );

      virtual void initView() {};

      virtual void setCamera() {};

      virtual void setProjection() {};

      virtual bool updateCamera();
      virtual IControl * currentControl() { return parentI3DWorkspace->getCurrentControl();};


      void setControl( IControl *c ) {control = c;};

      void setI3DWorkspace( I3DWorkspace *v ) {parentI3DWorkspace = v;};

      virtual void moveCamera( float x, float y ) {};

      virtual void rotateCamera( float x, float y ) {};

      virtual void zoomCamera( float x, float y ) {};


      void printString( void *font, char *string );

      Matrix44 *projMatrix;
      Matrix44 *modMatrix;
      GLint viewport[ 4 ];



      int width, height;

      void setBackground( QString *p );
      void setBackground( float r, float g, float b );
      void showBackground( bool flag );
      virtual void drawBackground();

      /**Project a screen point into world coordinates */
      virtual Vector4 &unProjectPoint( int x, int y );


      void setConnections( I3DWorkspace *parent );

      virtual Vector4 &transformPoint( Vector4 &p );

      void refreshOptions();
			QPopupMenu * getViewMenu() { return options; };
      virtual void setWireframe3D( bool f ) {};

      virtual void setWireframe2D( bool f ) {};

      void setWireframeMove( bool f );
      void setSmoothShaded( bool f );

      void setGridSpacing( int space ) {grid_unit = space;};

      void setGridSize( int size ) {grid_size = size;};

   protected slots:
      void toggleGrid();
      void toggleAxis();

      void slotNew3D();
			void slotNewXY();
			void slotNewXZ();
			void slotNewYZ();

      void saveImage();
      void saveImageTransparent();
      void printImage();
      void changeBackgroundImage();
      void changeBackgroundColor();
      void setBackgroundRepeat( int u, int v ) {u_repeat = u; v_repeat = v;};


   protected:
      Vector4 m_plane;

      void initializeGL();
      virtual void mouseMoveEvent( QMouseEvent *event );
      virtual void mousePressEvent( QMouseEvent *event );
      virtual void mouseReleaseEvent( QMouseEvent *event );

      void keyPressEvent( QKeyEvent *event );
      void keyReleaseEvent( QKeyEvent *event );


      int findOptions( QPopupMenu *menu, QString &name );

      IControl *control;
      Entity *camera;
      I3DWorkspace *parentI3DWorkspace;

      int mouse_pressed_x, mouse_pressed_y;
      int prev_mouse_move_x, prev_mouse_move_y;
      int mouse_release_x, mouse_release_y;
      int mouse_move_x, mouse_move_y;

      CameraMode cmode;

      float wpct, hpct;
      float bg, br, bb;
      float gg, gr, gb;

      int u_repeat, v_repeat;


      bool moving;
      bool dirty;

      bool selecting;

      QPopupMenu *options;

      float zoom;

      QPaintDevice *pdevice;
      QPainter *painter;

      Texture *background;

      bool draw_background;

      /**Document */
      I3DDoc *doc;

      bool twosided;

      QString *viewname;
      GLubyte *strError;
      Vector4 tempPoint;

      int separator_index;
      int context_index;
      bool menu_up;
      QPopupMenu *context_menu;

      bool showaxis;
      bool showgrid;

      //view configuration
      static float grid_size;
      static float grid_unit;
      static bool wireframe_3d;
      static bool wireframe_filled;
      static bool wireframe_move;
      static bool smooth_shaded;
      static bool smooth_textures;
      static bool wireframe;

};

#endif






























































































